// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Align, Application, AssistantPageType, Bin, Buildable, Container, ResizeMode, Widget, Window,
    WindowPosition, WindowType,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkAssistant")]
    pub struct Assistant(Object<ffi::GtkAssistant, ffi::GtkAssistantClass>) @extends Window, Bin, Container, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_assistant_get_type(),
    }
}

impl Assistant {
    pub const NONE: Option<&'static Assistant> = None;

    #[doc(alias = "gtk_assistant_new")]
    pub fn new() -> Assistant {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_assistant_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Assistant`] objects.
    ///
    /// This method returns an instance of [`AssistantBuilder`](crate::builders::AssistantBuilder) which can be used to create [`Assistant`] objects.
    pub fn builder() -> AssistantBuilder {
        AssistantBuilder::new()
    }
}

impl Default for Assistant {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Assistant`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct AssistantBuilder {
    builder: glib::object::ObjectBuilder<'static, Assistant>,
}

impl AssistantBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn use_header_bar(self, use_header_bar: i32) -> Self {
        Self {
            builder: self.builder.property("use-header-bar", use_header_bar),
        }
    }

    pub fn accept_focus(self, accept_focus: bool) -> Self {
        Self {
            builder: self.builder.property("accept-focus", accept_focus),
        }
    }

    pub fn application(self, application: &impl IsA<Application>) -> Self {
        Self {
            builder: self
                .builder
                .property("application", application.clone().upcast()),
        }
    }

    pub fn attached_to(self, attached_to: &impl IsA<Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("attached-to", attached_to.clone().upcast()),
        }
    }

    pub fn decorated(self, decorated: bool) -> Self {
        Self {
            builder: self.builder.property("decorated", decorated),
        }
    }

    pub fn default_height(self, default_height: i32) -> Self {
        Self {
            builder: self.builder.property("default-height", default_height),
        }
    }

    pub fn default_width(self, default_width: i32) -> Self {
        Self {
            builder: self.builder.property("default-width", default_width),
        }
    }

    pub fn deletable(self, deletable: bool) -> Self {
        Self {
            builder: self.builder.property("deletable", deletable),
        }
    }

    pub fn destroy_with_parent(self, destroy_with_parent: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("destroy-with-parent", destroy_with_parent),
        }
    }

    pub fn focus_on_map(self, focus_on_map: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-map", focus_on_map),
        }
    }

    pub fn focus_visible(self, focus_visible: bool) -> Self {
        Self {
            builder: self.builder.property("focus-visible", focus_visible),
        }
    }

    pub fn gravity(self, gravity: gdk::Gravity) -> Self {
        Self {
            builder: self.builder.property("gravity", gravity),
        }
    }

    pub fn hide_titlebar_when_maximized(self, hide_titlebar_when_maximized: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("hide-titlebar-when-maximized", hide_titlebar_when_maximized),
        }
    }

    pub fn icon(self, icon: &gdk_pixbuf::Pixbuf) -> Self {
        Self {
            builder: self.builder.property("icon", icon.clone()),
        }
    }

    pub fn icon_name(self, icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("icon-name", icon_name.into()),
        }
    }

    pub fn mnemonics_visible(self, mnemonics_visible: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("mnemonics-visible", mnemonics_visible),
        }
    }

    pub fn modal(self, modal: bool) -> Self {
        Self {
            builder: self.builder.property("modal", modal),
        }
    }

    pub fn resizable(self, resizable: bool) -> Self {
        Self {
            builder: self.builder.property("resizable", resizable),
        }
    }

    pub fn role(self, role: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("role", role.into()),
        }
    }

    pub fn screen(self, screen: &gdk::Screen) -> Self {
        Self {
            builder: self.builder.property("screen", screen.clone()),
        }
    }

    pub fn skip_pager_hint(self, skip_pager_hint: bool) -> Self {
        Self {
            builder: self.builder.property("skip-pager-hint", skip_pager_hint),
        }
    }

    pub fn skip_taskbar_hint(self, skip_taskbar_hint: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("skip-taskbar-hint", skip_taskbar_hint),
        }
    }

    pub fn startup_id(self, startup_id: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("startup-id", startup_id.into()),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    pub fn transient_for(self, transient_for: &impl IsA<Window>) -> Self {
        Self {
            builder: self
                .builder
                .property("transient-for", transient_for.clone().upcast()),
        }
    }

    pub fn type_(self, type_: WindowType) -> Self {
        Self {
            builder: self.builder.property("type", type_),
        }
    }

    pub fn type_hint(self, type_hint: gdk::WindowTypeHint) -> Self {
        Self {
            builder: self.builder.property("type-hint", type_hint),
        }
    }

    pub fn urgency_hint(self, urgency_hint: bool) -> Self {
        Self {
            builder: self.builder.property("urgency-hint", urgency_hint),
        }
    }

    pub fn window_position(self, window_position: WindowPosition) -> Self {
        Self {
            builder: self.builder.property("window-position", window_position),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Assistant`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Assistant {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Assistant>> Sealed for T {}
}

pub trait AssistantExt: IsA<Assistant> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_assistant_add_action_widget")]
    fn add_action_widget(&self, child: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_assistant_add_action_widget(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_assistant_append_page")]
    fn append_page(&self, page: &impl IsA<Widget>) -> i32 {
        unsafe {
            ffi::gtk_assistant_append_page(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            )
        }
    }

    #[doc(alias = "gtk_assistant_commit")]
    fn commit(&self) {
        unsafe {
            ffi::gtk_assistant_commit(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_assistant_get_current_page")]
    #[doc(alias = "get_current_page")]
    fn current_page(&self) -> i32 {
        unsafe { ffi::gtk_assistant_get_current_page(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_assistant_get_n_pages")]
    #[doc(alias = "get_n_pages")]
    fn n_pages(&self) -> i32 {
        unsafe { ffi::gtk_assistant_get_n_pages(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_assistant_get_nth_page")]
    #[doc(alias = "get_nth_page")]
    fn nth_page(&self, page_num: i32) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_assistant_get_nth_page(
                self.as_ref().to_glib_none().0,
                page_num,
            ))
        }
    }

    #[doc(alias = "gtk_assistant_get_page_complete")]
    #[doc(alias = "get_page_complete")]
    fn page_is_complete(&self, page: &impl IsA<Widget>) -> bool {
        unsafe {
            from_glib(ffi::gtk_assistant_get_page_complete(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_assistant_get_page_has_padding")]
    #[doc(alias = "get_page_has_padding")]
    fn page_has_padding(&self, page: &impl IsA<Widget>) -> bool {
        unsafe {
            from_glib(ffi::gtk_assistant_get_page_has_padding(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_assistant_get_page_title")]
    #[doc(alias = "get_page_title")]
    fn page_title(&self, page: &impl IsA<Widget>) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_assistant_get_page_title(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_assistant_get_page_type")]
    #[doc(alias = "get_page_type")]
    fn page_type(&self, page: &impl IsA<Widget>) -> AssistantPageType {
        unsafe {
            from_glib(ffi::gtk_assistant_get_page_type(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_assistant_insert_page")]
    fn insert_page(&self, page: &impl IsA<Widget>, position: i32) -> i32 {
        unsafe {
            ffi::gtk_assistant_insert_page(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
                position,
            )
        }
    }

    #[doc(alias = "gtk_assistant_next_page")]
    fn next_page(&self) {
        unsafe {
            ffi::gtk_assistant_next_page(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_assistant_prepend_page")]
    fn prepend_page(&self, page: &impl IsA<Widget>) -> i32 {
        unsafe {
            ffi::gtk_assistant_prepend_page(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            )
        }
    }

    #[doc(alias = "gtk_assistant_previous_page")]
    fn previous_page(&self) {
        unsafe {
            ffi::gtk_assistant_previous_page(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_assistant_remove_action_widget")]
    fn remove_action_widget(&self, child: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_assistant_remove_action_widget(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_assistant_remove_page")]
    fn remove_page(&self, page_num: i32) {
        unsafe {
            ffi::gtk_assistant_remove_page(self.as_ref().to_glib_none().0, page_num);
        }
    }

    #[doc(alias = "gtk_assistant_set_current_page")]
    fn set_current_page(&self, page_num: i32) {
        unsafe {
            ffi::gtk_assistant_set_current_page(self.as_ref().to_glib_none().0, page_num);
        }
    }

    #[doc(alias = "gtk_assistant_set_forward_page_func")]
    fn set_forward_page_func(&self, page_func: Option<Box_<dyn Fn(i32) -> i32 + 'static>>) {
        let page_func_data: Box_<Option<Box_<dyn Fn(i32) -> i32 + 'static>>> = Box_::new(page_func);
        unsafe extern "C" fn page_func_func(
            current_page: libc::c_int,
            data: glib::ffi::gpointer,
        ) -> libc::c_int {
            let callback: &Option<Box_<dyn Fn(i32) -> i32 + 'static>> = &*(data as *mut _);
            if let Some(ref callback) = *callback {
                callback(current_page)
            } else {
                panic!("cannot get closure...")
            }
        }
        let page_func = if page_func_data.is_some() {
            Some(page_func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<Option<Box_<dyn Fn(i32) -> i32 + 'static>>> =
                Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func as _);
        let super_callback0: Box_<Option<Box_<dyn Fn(i32) -> i32 + 'static>>> = page_func_data;
        unsafe {
            ffi::gtk_assistant_set_forward_page_func(
                self.as_ref().to_glib_none().0,
                page_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gtk_assistant_set_page_complete")]
    fn set_page_complete(&self, page: &impl IsA<Widget>, complete: bool) {
        unsafe {
            ffi::gtk_assistant_set_page_complete(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
                complete.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_assistant_set_page_has_padding")]
    fn set_page_has_padding(&self, page: &impl IsA<Widget>, has_padding: bool) {
        unsafe {
            ffi::gtk_assistant_set_page_has_padding(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
                has_padding.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_assistant_set_page_title")]
    fn set_page_title(&self, page: &impl IsA<Widget>, title: &str) {
        unsafe {
            ffi::gtk_assistant_set_page_title(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
                title.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_assistant_set_page_type")]
    fn set_page_type(&self, page: &impl IsA<Widget>, type_: AssistantPageType) {
        unsafe {
            ffi::gtk_assistant_set_page_type(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
                type_.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_assistant_update_buttons_state")]
    fn update_buttons_state(&self) {
        unsafe {
            ffi::gtk_assistant_update_buttons_state(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "use-header-bar")]
    fn use_header_bar(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "use-header-bar")
    }

    fn child_is_complete<T: IsA<crate::Widget>>(&self, item: &T) -> bool {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "complete",
        )
    }

    fn set_child_complete<T: IsA<crate::Widget>>(&self, item: &T, complete: bool) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "complete",
            &complete,
        )
    }

    #[doc(alias = "child.has-padding")]
    fn child_has_padding<T: IsA<crate::Widget>>(&self, item: &T) -> bool {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "has-padding",
        )
    }

    #[doc(alias = "child.has-padding")]
    fn set_child_has_padding<T: IsA<crate::Widget>>(&self, item: &T, has_padding: bool) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "has-padding",
            &has_padding,
        )
    }

    #[doc(alias = "child.page-type")]
    fn child_page_type<T: IsA<crate::Widget>>(&self, item: &T) -> AssistantPageType {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "page-type",
        )
    }

    #[doc(alias = "child.page-type")]
    fn set_child_page_type<T: IsA<crate::Widget>>(&self, item: &T, page_type: AssistantPageType) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "page-type",
            &page_type,
        )
    }

    fn child_title<T: IsA<crate::Widget>>(&self, item: &T) -> Option<glib::GString> {
        crate::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "title",
        )
    }

    fn set_child_title<T: IsA<crate::Widget>>(&self, item: &T, title: Option<&str>) {
        crate::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "title",
            &title,
        )
    }

    #[doc(alias = "apply")]
    fn connect_apply<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn apply_trampoline<P: IsA<Assistant>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAssistant,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Assistant::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"apply\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    apply_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "cancel")]
    fn connect_cancel<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn cancel_trampoline<P: IsA<Assistant>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAssistant,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Assistant::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cancel\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    cancel_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "close")]
    fn connect_close<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn close_trampoline<P: IsA<Assistant>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAssistant,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Assistant::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"close\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    close_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "escape")]
    fn connect_escape<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn escape_trampoline<P: IsA<Assistant>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAssistant,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Assistant::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"escape\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    escape_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_escape(&self) {
        self.emit_by_name::<()>("escape", &[]);
    }

    #[doc(alias = "prepare")]
    fn connect_prepare<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn prepare_trampoline<P: IsA<Assistant>, F: Fn(&P, &Widget) + 'static>(
            this: *mut ffi::GtkAssistant,
            page: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Assistant::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(page),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"prepare\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    prepare_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Assistant>> AssistantExt for O {}

impl fmt::Display for Assistant {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Assistant")
    }
}
