/*
 * rwconf.h	Definitions for the configuration stuff in conf.c.
 *		You cannot set any compile-time directives here.
 *
 * Version:	@(#)rwconf.h  1.10  14-Oct-1996  miquels@cistron.nl
 *
 */

#ifndef __rwconf_h
#define __rwconf_h

struct time_ent {
  int days;
  int start_time;
  int end_time;
};

/*
 *	Configuration, per line.
 */
struct line_cfg {
	char *hostname;
	char *radclient_config_file;
	unsigned int loc_host;
#ifdef HAVE_IPV6
	struct in6_addr loc_host6;
	bool use_v6;
#endif
	char *lockdir;
	char *rlogin;
	char *telnet;
	char *ssh;
	char *pppd;
	unsigned int syslog;
	int facility;
	char *filterdir;
	/* Networking options */
	int authtype;
#ifdef PORTSLAVE_TACACS
	struct sockaddr *tacauthhost1;
	struct sockaddr *tacauthhost2;
#endif
	char *utmpfrom;
	int protocol;
	int host;
	unsigned int rem_host;
	unsigned int netmask;
	int mtu, mru;
	char *autoppp;
	char *pppopt;
	char *tty;
	/* Other options */
	char *issue;
	char *prompt;
	char *term;
#ifdef FIDO
	bool fidonet;     /* Do we allow fidonet? */
	char *fidologin;  /* The login name for the sole fido user */
	char *fidopasswd; /* Fido password */
#endif
	/* Modem options */
	int flow;
	bool dcd;
	int speed;
	int socket_port;
	int parity;
	int stopbits;
	int datasize;
	int debug;
	int porttype;
	char *initchat;
#ifdef PORTSLAVE_CLIENT_IP_RULES
	char *valid_ip;
#endif
	char *fixedlogin;

	char *lockfile; /* Internal use only */
	bool emumodem;
	bool logpassword;
	bool locallogins;
	bool stripnames;
	bool radnullpass;
	bool sysutmp;
	bool syswtmp;
	bool do_acct;
#ifndef NO_CHAP
	bool allow_chap;
#endif
	char *login_time_str;
	struct time_ent *login_time;
	bool login_time_limited;
} lineconf;

/*
 *	Flow control definitions.
 */
#define FLOW_NONE	0
#define FLOW_HARD	1
#define FLOW_SOFT	2

/*
 *	Functions.
 */
void initcfg(void);
int readcfg(const char *config_file, const char *tty);
int writecfg(void);

#endif	/* __rwconf_h */
