/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security.peer;

import com.workingdogs.village.Column;
import com.workingdogs.village.Record;
import com.workingdogs.village.Schema;
import com.workingdogs.village.Value;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.om.Persistent;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.om.security.User;
import org.apache.turbine.om.security.peer.UserPeer;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.map.TableMap;
import org.apache.turbine.util.db.map.TurbineMapBuilder;
import org.apache.turbine.util.db.pool.DBConnection;
import org.apache.turbine.util.security.DataBackendException;

public class TurbineUserPeer
extends BasePeer
implements UserPeer {
    private static final TurbineMapBuilder mapBuilder = (TurbineMapBuilder)BasePeer.getMapBuilder();
    private static final String USER_ID_COLUMN = mapBuilder.getUserId();
    private static final String USERNAME_COLUMN = mapBuilder.getUsername();
    private static final String FIRST_NAME_COLUMN = mapBuilder.getFirstName();
    private static final String LAST_NAME_COLUMN = mapBuilder.getLastName();
    private static final String MODIFIED_COLUMN = mapBuilder.getModified();
    private static final String CREATED_COLUMN = mapBuilder.getCreated();
    private static final String LAST_LOGIN_COLUMN = mapBuilder.getLastLogin();
    private static final String EMAIL_COLUMN = mapBuilder.getEmail();
    private static final String CONFIRM_VALUE_COLUMN = mapBuilder.getConfirmValue();
    public static final String CONFIRM_DATA = "CONFIRMED";
    private static final String OBJECT_DATA_COLUMN = mapBuilder.getObjectData();
    private static final String TABLE_NAME = mapBuilder.getTableUser();
    public static final String USER_ID = mapBuilder.getUser_UserId();
    public static final String USERNAME = mapBuilder.getUser_Username();
    public static final String PASSWORD = mapBuilder.getUser_Password();
    public static final String FIRST_NAME = mapBuilder.getUser_FirstName();
    public static final String LAST_NAME = mapBuilder.getUser_LastName();
    public static final String MODIFIED = mapBuilder.getUser_Modified();
    public static final String CREATED = mapBuilder.getUser_Created();
    public static final String EMAIL = mapBuilder.getUser_Email();
    public static final String LAST_LOGIN = mapBuilder.getUser_LastLogin();
    public static final String CONFIRM_VALUE = mapBuilder.getUser_ConfirmValue();
    public static final String OBJECT_DATA = mapBuilder.getUser_ObjectData();
    private static final String SEQUENCE_NAME = mapBuilder.getSequenceUser();
    private static Schema schema = BasePeer.initTableSchema(TABLE_NAME);
    private static Column[] columns = BasePeer.initTableColumns(schema);
    public static String[] columnNames = BasePeer.initColumnNames(columns);
    public static String[] criteriaKeys = BasePeer.initCriteriaKeys(TABLE_NAME, columnNames);

    public static String getTableName() {
        return TABLE_NAME;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(TABLE_NAME);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public String getFullColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(TABLE_NAME);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public static Criteria buildCriteria(User user) {
        Hashtable permData = (Hashtable)user.getPermStorage().clone();
        Criteria criteria = new Criteria();
        if (!((Persistent)((Object)user)).isNew()) {
            criteria.add(USER_ID, ((Persistent)((Object)user)).getPrimaryKey());
        }
        int i = 1;
        while (i < columnNames.length) {
            if (permData.containsKey(columnNames[i])) {
                criteria.add(criteriaKeys[i], permData.remove(columnNames[i]));
            }
            ++i;
        }
        criteria.add(OBJECT_DATA, permData);
        return criteria;
    }

    public static void addSelectColumns(Criteria criteria) throws Exception {
        int i = 0;
        while (i < columnNames.length) {
            criteria.addSelectColumn(TABLE_NAME + "." + columnNames[i]);
            ++i;
        }
    }

    public static void populateObject(Record row, int offset, User obj) throws Exception {
        int idPosition = 1;
        int objectDataPosition = columnNames.length;
        int i = 0;
        while (i < columnNames.length) {
            if (columnNames[i].equals(USER_ID_COLUMN)) {
                idPosition = i + 1;
            }
            if (columnNames[i].equals(OBJECT_DATA_COLUMN)) {
                objectDataPosition = i + 1;
            }
            ++i;
        }
        ((Persistent)((Object)obj)).setPrimaryKey(new NumberKey(row.getValue(idPosition).asBigDecimal()));
        byte[] objectData = row.getValue(objectDataPosition).asBytes();
        Hashtable<String, Object> tempHash = (Hashtable<String, Object>)ObjectUtils.deserialize(objectData);
        if (tempHash == null) {
            tempHash = new Hashtable<String, Object>(10);
        }
        int j = 0;
        while (j < columnNames.length) {
            if (!columnNames[j].equalsIgnoreCase(USER_ID_COLUMN) && !columnNames[j].equalsIgnoreCase(OBJECT_DATA_COLUMN)) {
                Object obj2 = null;
                Value value = row.getValue(j + 1);
                if (value.isByte()) {
                    obj2 = new Byte(value.asByte());
                }
                if (value.isBigDecimal()) {
                    obj2 = value.asBigDecimal();
                }
                if (value.isBytes()) {
                    obj2 = value.asBytes();
                }
                if (value.isDate()) {
                    obj2 = value.asDate();
                }
                if (value.isShort()) {
                    obj2 = new Short(value.asShort());
                }
                if (value.isInt()) {
                    obj2 = new Integer(value.asInt());
                }
                if (value.isLong()) {
                    obj2 = new Long(value.asLong());
                }
                if (value.isDouble()) {
                    obj2 = new Double(value.asDouble());
                }
                if (value.isFloat()) {
                    obj2 = new Float(value.asFloat());
                }
                if (value.isBoolean()) {
                    obj2 = new Boolean(value.asBoolean());
                }
                if (value.isString()) {
                    obj2 = value.asString();
                }
                if (value.isTime()) {
                    obj2 = value.asTime();
                }
                if (value.isTimestamp()) {
                    obj2 = value.asTimestamp();
                }
                if (value.isUtilDate()) {
                    obj2 = value.asUtilDate();
                }
                if (obj2 != null) {
                    tempHash.put(columnNames[j], obj2);
                }
            }
            ++j;
        }
        obj.setPermStorage(tempHash);
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        return TurbineUserPeer.doSelect(criteria, null);
    }

    public static Vector doSelect(Criteria criteria, User current) throws Exception {
        TurbineUserPeer.addSelectColumns(criteria);
        if (criteria.getOrderByColumns() == null) {
            criteria.addAscendingOrderByColumn(LAST_NAME);
        }
        Vector rows = BasePeer.doSelect(criteria);
        Vector<User> results = new Vector<User>();
        int i = 0;
        while (i < rows.size()) {
            Record row = (Record)rows.elementAt(i);
            if (current == null) {
                results.addElement(TurbineUserPeer.row2Object(row, 1, null));
            } else {
                TurbineUserPeer.populateObject(row, 1, current);
                ((Persistent)((Object)current)).setNew(false);
            }
            ++i;
        }
        return results;
    }

    public static Vector doSelect(Criteria criteria, DBConnection dbConn) throws Exception {
        TurbineUserPeer.addSelectColumns(criteria);
        if (criteria.getOrderByColumns() == null) {
            criteria.addAscendingOrderByColumn(LAST_NAME);
        }
        Vector rows = BasePeer.doSelect(criteria, dbConn);
        Vector<User> results = new Vector<User>();
        int i = 0;
        while (i < rows.size()) {
            Record row = (Record)rows.elementAt(i);
            results.addElement(TurbineUserPeer.row2Object(row, 1, null));
            ++i;
        }
        return results;
    }

    public static User row2Object(Record row, int offset, Class cls) throws Exception {
        User obj = TurbineSecurity.getUserInstance();
        TurbineUserPeer.populateObject(row, offset, obj);
        ((Persistent)((Object)obj)).setNew(false);
        ((Persistent)((Object)obj)).setModified(false);
        return obj;
    }

    public static Class getOMClass() throws Exception {
        return TurbineSecurity.getUserClass();
    }

    public static void doUpdate(Criteria criteria) throws Exception {
        Criteria selectCriteria = new Criteria(2);
        selectCriteria.put(USER_ID, criteria.remove(USER_ID));
        BasePeer.doUpdate(selectCriteria, criteria);
    }

    public static boolean checkExists(User user) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(USER_ID);
        criteria.add(USERNAME, user.getUserName());
        Vector results = BasePeer.doSelect(criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple users named '" + user.getUserName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static Vector selectAllUsers() throws Exception {
        Criteria criteria = new Criteria();
        criteria.addAscendingOrderByColumn(LAST_NAME);
        criteria.addAscendingOrderByColumn(FIRST_NAME);
        criteria.setIgnoreCase(true);
        return TurbineUserPeer.doSelect(criteria);
    }

    public static Vector selectAllConfirmedUsers() throws Exception {
        Criteria criteria = new Criteria();
        criteria.add("CONFIRM_VALUE", CONFIRM_DATA);
        criteria.addAscendingOrderByColumn(LAST_NAME);
        criteria.addAscendingOrderByColumn(FIRST_NAME);
        criteria.setIgnoreCase(true);
        return TurbineUserPeer.doSelect(criteria);
    }

    protected static TableMap getTableMap() {
        return mapBuilder.getDatabaseMap().getTable(TABLE_NAME);
    }
}

