; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -disable-output -da-delinearize=false "-passes=print<da>"      \
; RUN: -aa-pipeline=basic-aa 2>&1 | FileCheck %s
; RUN: opt < %s -disable-output -da-delinearize=false -passes='print<da><normalized-results>'      \
; RUN: -aa-pipeline=basic-aa 2>&1 | FileCheck %s -check-prefix=NORMALIZE
; RUN: opt < %s -disable-output "-passes=print<da>" -aa-pipeline=basic-aa 2>&1 \
; RUN: | FileCheck %s -check-prefix=DELIN

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.6.0"


;;  for (long int i = 1; i <= 10; i++)
;;    for (long int j = 1; j <= 10; j++) {
;;      A[10*i + j] = 0;
;;      *B++ = A[10*i + j - 1];

define void @banerjee0(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee0'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - flow [<= <>]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee0'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - flow [<= <>]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee0'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - flow [<= <>]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc7
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc7 ]
  %i.03 = phi i64 [ 1, %entry ], [ %inc8, %for.inc7 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 1, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 10
  %add = add nsw i64 %mul, %j.02
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.03, 10
  %add5 = add nsw i64 %mul4, %j.02
  %sub = add nsw i64 %add5, -1
  %arrayidx6 = getelementptr inbounds i64, ptr %A, i64 %sub
  %0 = load i64, ptr %arrayidx6, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %0, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 11
  br i1 %exitcond, label %for.body3, label %for.inc7

for.inc7:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 10
  %inc8 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc8, 11
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end9

for.end9:                                         ; preds = %for.inc7
  ret void
}


;;  for (long int i = 1; i <= n; i++)
;;    for (long int j = 1; j <= m; j++) {
;;      A[10*i + j] = 0;
;;      *B++ = A[10*i + j - 1];

define void @banerjee1(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee1'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - output [* *]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %2 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - flow [* <>]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %2, ptr %B.addr.12, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %2 = load i64, ptr %arrayidx6, align 8 --> Dst: %2 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - input [* *]!
; CHECK-NEXT:  Src: %2 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %2, ptr %B.addr.12, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %2, ptr %B.addr.12, align 8 --> Dst: store i64 %2, ptr %B.addr.12, align 8
; CHECK-NEXT:    da analyze - output [* *]!
;
; NORMALIZE-LABEL: 'banerjee1'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - output [* *]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %2 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - flow [* <>]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %2, ptr %B.addr.12, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %2 = load i64, ptr %arrayidx6, align 8 --> Dst: %2 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - input [* *]!
; NORMALIZE-NEXT:  Src: %2 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %2, ptr %B.addr.12, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %2, ptr %B.addr.12, align 8 --> Dst: store i64 %2, ptr %B.addr.12, align 8
; NORMALIZE-NEXT:    da analyze - output [* *]!
;
; DELIN-LABEL: 'banerjee1'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - output [* *]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %2 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - flow [* <>]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %2, ptr %B.addr.12, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %2 = load i64, ptr %arrayidx6, align 8 --> Dst: %2 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - input [* *]!
; DELIN-NEXT:  Src: %2 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %2, ptr %B.addr.12, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %2, ptr %B.addr.12, align 8 --> Dst: store i64 %2, ptr %B.addr.12, align 8
; DELIN-NEXT:    da analyze - output [* *]!
;
entry:
  %cmp4 = icmp sgt i64 %n, 0
  br i1 %cmp4, label %for.cond1.preheader.preheader, label %for.end9

for.cond1.preheader.preheader:                    ; preds = %entry
  %0 = add i64 %n, 1
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %for.cond1.preheader.preheader, %for.inc7
  %B.addr.06 = phi ptr [ %B.addr.1.lcssa, %for.inc7 ], [ %B, %for.cond1.preheader.preheader ]
  %i.05 = phi i64 [ %inc8, %for.inc7 ], [ 1, %for.cond1.preheader.preheader ]
  %1 = add i64 %m, 1
  %cmp21 = icmp sgt i64 %m, 0
  br i1 %cmp21, label %for.body3.preheader, label %for.inc7

for.body3.preheader:                              ; preds = %for.cond1.preheader
  br label %for.body3

for.body3:                                        ; preds = %for.body3.preheader, %for.body3
  %j.03 = phi i64 [ %inc, %for.body3 ], [ 1, %for.body3.preheader ]
  %B.addr.12 = phi ptr [ %incdec.ptr, %for.body3 ], [ %B.addr.06, %for.body3.preheader ]
  %mul = mul nsw i64 %i.05, 10
  %add = add nsw i64 %mul, %j.03
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.05, 10
  %add5 = add nsw i64 %mul4, %j.03
  %sub = add nsw i64 %add5, -1
  %arrayidx6 = getelementptr inbounds i64, ptr %A, i64 %sub
  %2 = load i64, ptr %arrayidx6, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.12, i64 1
  store i64 %2, ptr %B.addr.12, align 8
  %inc = add nsw i64 %j.03, 1
  %exitcond = icmp eq i64 %inc, %1
  br i1 %exitcond, label %for.inc7.loopexit, label %for.body3

for.inc7.loopexit:                                ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.06, i64 %m
  br label %for.inc7

for.inc7:                                         ; preds = %for.inc7.loopexit, %for.cond1.preheader
  %B.addr.1.lcssa = phi ptr [ %B.addr.06, %for.cond1.preheader ], [ %scevgep, %for.inc7.loopexit ]
  %inc8 = add nsw i64 %i.05, 1
  %exitcond7 = icmp eq i64 %inc8, %0
  br i1 %exitcond7, label %for.end9.loopexit, label %for.cond1.preheader

for.end9.loopexit:                                ; preds = %for.inc7
  br label %for.end9

for.end9:                                         ; preds = %for.end9.loopexit, %entry
  ret void
}


;;  for (long int i = 0; i < 10; i++)
;;    for (long int j = 0; j < 10; j++) {
;;      A[10*i + j] = 0;
;;      *B++ = A[10*i + j + 100];

define void @banerjee2(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee2'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee2'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee2'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc8
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc8 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc9, %for.inc8 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 10
  %add = add nsw i64 %mul, %j.02
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.03, 10
  %add5 = add nsw i64 %mul4, %j.02
  %add6 = add nsw i64 %add5, 100
  %arrayidx7 = getelementptr inbounds i64, ptr %A, i64 %add6
  %0 = load i64, ptr %arrayidx7, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %0, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 10
  br i1 %exitcond, label %for.body3, label %for.inc8

for.inc8:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 10
  %inc9 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc9, 10
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end10

for.end10:                                        ; preds = %for.inc8
  ret void
}


;;  for (long int i = 0; i < 10; i++)
;;    for (long int j = 0; j < 10; j++) {
;;      A[10*i + j] = 0;
;;      *B++ = A[10*i + j + 99];

define void @banerjee3(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee3'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - flow [> >]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee3'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - normalized - anti [< <]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee3'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - flow [> >]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc8
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc8 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc9, %for.inc8 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 10
  %add = add nsw i64 %mul, %j.02
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.03, 10
  %add5 = add nsw i64 %mul4, %j.02
  %add6 = add nsw i64 %add5, 99
  %arrayidx7 = getelementptr inbounds i64, ptr %A, i64 %add6
  %0 = load i64, ptr %arrayidx7, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %0, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 10
  br i1 %exitcond, label %for.body3, label %for.inc8

for.inc8:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 10
  %inc9 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc9, 10
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end10

for.end10:                                        ; preds = %for.inc8
  ret void
}


;;  for (long int i = 0; i < 10; i++)
;;    for (long int j = 0; j < 10; j++) {
;;      A[10*i + j] = 0;
;;      *B++ = A[10*i + j - 100];

define void @banerjee4(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee4'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee4'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee4'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc7
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc7 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc8, %for.inc7 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 10
  %add = add nsw i64 %mul, %j.02
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.03, 10
  %add5 = add nsw i64 %mul4, %j.02
  %sub = add nsw i64 %add5, -100
  %arrayidx6 = getelementptr inbounds i64, ptr %A, i64 %sub
  %0 = load i64, ptr %arrayidx6, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %0, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 10
  br i1 %exitcond, label %for.body3, label %for.inc7

for.inc7:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 10
  %inc8 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc8, 10
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end9

for.end9:                                         ; preds = %for.inc7
  ret void
}


;;  for (long int i = 0; i < 10; i++)
;;    for (long int j = 0; j < 10; j++) {
;;      A[10*i + j] = 0;
;;      *B++ = A[10*i + j - 99];

define void @banerjee5(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee5'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - flow [< <]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee5'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - flow [< <]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee5'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - flow [< <]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc7
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc7 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc8, %for.inc7 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 10
  %add = add nsw i64 %mul, %j.02
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.03, 10
  %add5 = add nsw i64 %mul4, %j.02
  %sub = add nsw i64 %add5, -99
  %arrayidx6 = getelementptr inbounds i64, ptr %A, i64 %sub
  %0 = load i64, ptr %arrayidx6, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %0, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 10
  br i1 %exitcond, label %for.body3, label %for.inc7

for.inc7:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 10
  %inc8 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc8, 10
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end9

for.end9:                                         ; preds = %for.inc7
  ret void
}


;;  for (long int i = 0; i < 10; i++)
;;    for (long int j = 0; j < 10; j++) {
;;      A[10*i + j] = 0;
;;      *B++ = A[10*i + j + 9];

define void @banerjee6(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee6'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - flow [=> <>]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee6'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - normalized - anti [<= <>]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee6'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - flow [=> <>]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc8
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc8 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc9, %for.inc8 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 10
  %add = add nsw i64 %mul, %j.02
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.03, 10
  %add5 = add nsw i64 %mul4, %j.02
  %add6 = add nsw i64 %add5, 9
  %arrayidx7 = getelementptr inbounds i64, ptr %A, i64 %add6
  %0 = load i64, ptr %arrayidx7, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %0, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 10
  br i1 %exitcond, label %for.body3, label %for.inc8

for.inc8:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 10
  %inc9 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc9, 10
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end10

for.end10:                                        ; preds = %for.inc8
  ret void
}


;;  for (long int i = 0; i < 10; i++)
;;    for (long int j = 0; j < 10; j++) {
;;      A[10*i + j] = 0;
;;      *B++ = A[10*i + j + 10];

define void @banerjee7(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee7'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - flow [> <=]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee7'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - normalized - anti [< =>]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee7'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - flow [> <=]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc8
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc8 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc9, %for.inc8 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 10
  %add = add nsw i64 %mul, %j.02
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.03, 10
  %add5 = add nsw i64 %mul4, %j.02
  %add6 = add nsw i64 %add5, 10
  %arrayidx7 = getelementptr inbounds i64, ptr %A, i64 %add6
  %0 = load i64, ptr %arrayidx7, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %0, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 10
  br i1 %exitcond, label %for.body3, label %for.inc8

for.inc8:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 10
  %inc9 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc9, 10
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end10

for.end10:                                        ; preds = %for.inc8
  ret void
}


;;  for (long int i = 0; i < 10; i++)
;;    for (long int j = 0; j < 10; j++) {
;;      A[10*i + j] = 0;
;;      *B++ = A[10*i + j + 11];

define void @banerjee8(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee8'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - flow [> <>]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee8'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - normalized - anti [< <>]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee8'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - flow [> <>]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: %0 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc8
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc8 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc9, %for.inc8 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 10
  %add = add nsw i64 %mul, %j.02
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.03, 10
  %add5 = add nsw i64 %mul4, %j.02
  %add6 = add nsw i64 %add5, 11
  %arrayidx7 = getelementptr inbounds i64, ptr %A, i64 %add6
  %0 = load i64, ptr %arrayidx7, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %0, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 10
  br i1 %exitcond, label %for.body3, label %for.inc8

for.inc8:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 10
  %inc9 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc9, 10
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end10

for.end10:                                        ; preds = %for.inc8
  ret void
}


;;  for (long int i = 0; i < 20; i++)
;;    for (long int j = 0; j < 20; j++) {
;;      A[30*i + 500*j] = 0;
;;      *B++ = A[i - 500*j + 11];

define void @banerjee9(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee9'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - output [* *]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %1 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - flow [<= =|<]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %1 = load i64, ptr %arrayidx7, align 8 --> Dst: %1 = load i64, ptr %arrayidx7, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %1 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %1, ptr %B.addr.11, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee9'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - output [* *]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %1 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - flow [<= =|<]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %1 = load i64, ptr %arrayidx7, align 8 --> Dst: %1 = load i64, ptr %arrayidx7, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %1 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %1, ptr %B.addr.11, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee9'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - output [* *]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %1 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - flow [<= =|<]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %1 = load i64, ptr %arrayidx7, align 8 --> Dst: %1 = load i64, ptr %arrayidx7, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %1 = load i64, ptr %arrayidx7, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %1, ptr %B.addr.11, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc8
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc8 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc9, %for.inc8 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 30
  %mul4 = mul nsw i64 %j.02, 500
  %add = add nsw i64 %mul, %mul4
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %0 = mul i64 %j.02, -500
  %sub = add i64 %i.03, %0
  %add6 = add nsw i64 %sub, 11
  %arrayidx7 = getelementptr inbounds i64, ptr %A, i64 %add6
  %1 = load i64, ptr %arrayidx7, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %1, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 20
  br i1 %exitcond, label %for.body3, label %for.inc8

for.inc8:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 20
  %inc9 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc9, 20
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end10

for.end10:                                        ; preds = %for.inc8
  ret void
}


;;  for (long int i = 0; i < 20; i++)
;;    for (long int j = 0; j < 20; j++) {
;;      A[i + 500*j] = 0;
;;      *B++ = A[i - 500*j + 11];

define void @banerjee10(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee10'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %1 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - flow [<> =]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %1 = load i64, ptr %arrayidx6, align 8 --> Dst: %1 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %1 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %1, ptr %B.addr.11, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee10'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %1 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - flow [<> =]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %1 = load i64, ptr %arrayidx6, align 8 --> Dst: %1 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %1 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %1, ptr %B.addr.11, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee10'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %1 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - flow [<> =]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %1 = load i64, ptr %arrayidx6, align 8 --> Dst: %1 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %1 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %1, ptr %B.addr.11, align 8 --> Dst: store i64 %1, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc7
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc7 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc8, %for.inc7 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %j.02, 500
  %add = add nsw i64 %i.03, %mul
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %0 = mul i64 %j.02, -500
  %sub = add i64 %i.03, %0
  %add5 = add nsw i64 %sub, 11
  %arrayidx6 = getelementptr inbounds i64, ptr %A, i64 %add5
  %1 = load i64, ptr %arrayidx6, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %1, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 20
  br i1 %exitcond, label %for.body3, label %for.inc7

for.inc7:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 20
  %inc8 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc8, 20
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end9

for.end9:                                         ; preds = %for.inc7
  ret void
}


;;  for (long int i = 0; i < 20; i++)
;;    for (long int j = 0; j < 20; j++) {
;;      A[300*i + j] = 0;
;;      *B++ = A[250*i - j + 11];

define void @banerjee11(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee11'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - flow [<= <>]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee11'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - flow [<= <>]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee11'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - flow [<= <>]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc7
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc7 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc8, %for.inc7 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 300
  %add = add nsw i64 %mul, %j.02
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.03, 250
  %sub = sub nsw i64 %mul4, %j.02
  %add5 = add nsw i64 %sub, 11
  %arrayidx6 = getelementptr inbounds i64, ptr %A, i64 %add5
  %0 = load i64, ptr %arrayidx6, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %0, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 20
  br i1 %exitcond, label %for.body3, label %for.inc7

for.inc7:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 20
  %inc8 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc8, 20
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end9

for.end9:                                         ; preds = %for.inc7
  ret void
}


;;  for (long int i = 0; i < 20; i++)
;;    for (long int j = 0; j < 20; j++) {
;;      A[100*i + j] = 0;
;;      *B++ = A[100*i - j + 11];

define void @banerjee12(ptr %A, ptr %B, i64 %m, i64 %n) nounwind uwtable ssp {
; CHECK-LABEL: 'banerjee12'
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - flow [= <>]!
; CHECK-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; CHECK-NEXT:    da analyze - none!
; CHECK-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - confused!
; CHECK-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; CHECK-NEXT:    da analyze - none!
;
; NORMALIZE-LABEL: 'banerjee12'
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - flow [= <>]!
; NORMALIZE-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; NORMALIZE-NEXT:    da analyze - none!
; NORMALIZE-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - confused!
; NORMALIZE-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; NORMALIZE-NEXT:    da analyze - none!
;
; DELIN-LABEL: 'banerjee12'
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 0, ptr %arrayidx, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - flow [= <>]!
; DELIN-NEXT:  Src: store i64 0, ptr %arrayidx, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: %0 = load i64, ptr %arrayidx6, align 8
; DELIN-NEXT:    da analyze - none!
; DELIN-NEXT:  Src: %0 = load i64, ptr %arrayidx6, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - confused!
; DELIN-NEXT:  Src: store i64 %0, ptr %B.addr.11, align 8 --> Dst: store i64 %0, ptr %B.addr.11, align 8
; DELIN-NEXT:    da analyze - none!
;
entry:
  br label %for.cond1.preheader

for.cond1.preheader:                              ; preds = %entry, %for.inc7
  %B.addr.04 = phi ptr [ %B, %entry ], [ %scevgep, %for.inc7 ]
  %i.03 = phi i64 [ 0, %entry ], [ %inc8, %for.inc7 ]
  br label %for.body3

for.body3:                                        ; preds = %for.cond1.preheader, %for.body3
  %j.02 = phi i64 [ 0, %for.cond1.preheader ], [ %inc, %for.body3 ]
  %B.addr.11 = phi ptr [ %B.addr.04, %for.cond1.preheader ], [ %incdec.ptr, %for.body3 ]
  %mul = mul nsw i64 %i.03, 100
  %add = add nsw i64 %mul, %j.02
  %arrayidx = getelementptr inbounds i64, ptr %A, i64 %add
  store i64 0, ptr %arrayidx, align 8
  %mul4 = mul nsw i64 %i.03, 100
  %sub = sub nsw i64 %mul4, %j.02
  %add5 = add nsw i64 %sub, 11
  %arrayidx6 = getelementptr inbounds i64, ptr %A, i64 %add5
  %0 = load i64, ptr %arrayidx6, align 8
  %incdec.ptr = getelementptr inbounds i64, ptr %B.addr.11, i64 1
  store i64 %0, ptr %B.addr.11, align 8
  %inc = add nsw i64 %j.02, 1
  %exitcond = icmp ne i64 %inc, 20
  br i1 %exitcond, label %for.body3, label %for.inc7

for.inc7:                                         ; preds = %for.body3
  %scevgep = getelementptr i64, ptr %B.addr.04, i64 20
  %inc8 = add nsw i64 %i.03, 1
  %exitcond5 = icmp ne i64 %inc8, 20
  br i1 %exitcond5, label %for.cond1.preheader, label %for.end9

for.end9:                                         ; preds = %for.inc7
  ret void
}
