; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv32 -mattr=+v | FileCheck %s -check-prefixes=CHECK,RV32
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mattr=+v | FileCheck %s -check-prefixes=CHECK,RV64
; RUN: opt < %s -passes="print<cost-model>" -cost-kind=code-size 2>&1 -disable-output -mtriple=riscv32 -mattr=+v | FileCheck %s -check-prefixes=CHECK-SIZE,RV32-SIZE
; RUN: opt < %s -passes="print<cost-model>" -cost-kind=code-size 2>&1 -disable-output -mtriple=riscv64 -mattr=+v | FileCheck %s -check-prefixes=CHECK-SIZE,RV64-SIZE

define <64 x i32> @interleave_v32i32(<32 x i32> %x, <32 x i32> %y) vscale_range(2,2) {
; CHECK-LABEL: 'interleave_v32i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %a = shufflevector <32 x i32> %x, <32 x i32> %y, <64 x i32> <i32 0, i32 32, i32 1, i32 33, i32 2, i32 34, i32 3, i32 35, i32 4, i32 36, i32 5, i32 37, i32 6, i32 38, i32 7, i32 39, i32 8, i32 40, i32 9, i32 41, i32 10, i32 42, i32 11, i32 43, i32 12, i32 44, i32 13, i32 45, i32 14, i32 46, i32 15, i32 47, i32 16, i32 48, i32 17, i32 49, i32 18, i32 50, i32 19, i32 51, i32 20, i32 52, i32 21, i32 53, i32 22, i32 54, i32 23, i32 55, i32 24, i32 56, i32 25, i32 57, i32 26, i32 58, i32 27, i32 59, i32 28, i32 60, i32 29, i32 61, i32 30, i32 62, i32 31, i32 63>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret <64 x i32> %a
;
; CHECK-SIZE-LABEL: 'interleave_v32i32'
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %a = shufflevector <32 x i32> %x, <32 x i32> %y, <64 x i32> <i32 0, i32 32, i32 1, i32 33, i32 2, i32 34, i32 3, i32 35, i32 4, i32 36, i32 5, i32 37, i32 6, i32 38, i32 7, i32 39, i32 8, i32 40, i32 9, i32 41, i32 10, i32 42, i32 11, i32 43, i32 12, i32 44, i32 13, i32 45, i32 14, i32 46, i32 15, i32 47, i32 16, i32 48, i32 17, i32 49, i32 18, i32 50, i32 19, i32 51, i32 20, i32 52, i32 21, i32 53, i32 22, i32 54, i32 23, i32 55, i32 24, i32 56, i32 25, i32 57, i32 26, i32 58, i32 27, i32 59, i32 28, i32 60, i32 29, i32 61, i32 30, i32 62, i32 31, i32 63>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i32> %a
;
  %a = shufflevector <32 x i32> %x, <32 x i32> %y, <64 x i32> <i32 0, i32 32, i32 1, i32 33, i32 2, i32 34, i32 3, i32 35, i32 4, i32 36, i32 5, i32 37, i32 6, i32 38, i32 7, i32 39, i32 8, i32 40, i32 9, i32 41, i32 10, i32 42, i32 11, i32 43, i32 12, i32 44, i32 13, i32 45, i32 14, i32 46, i32 15, i32 47, i32 16, i32 48, i32 17, i32 49, i32 18, i32 50, i32 19, i32 51, i32 20, i32 52, i32 21, i32 53, i32 22, i32 54, i32 23, i32 55, i32 24, i32 56, i32 25, i32 57, i32 26, i32 58, i32 27, i32 59, i32 28, i32 60, i32 29, i32 61, i32 30, i32 62, i32 31, i32 63>
  ret <64 x i32> %a
}

define void @extract(<64 x i32> %v, ptr %out) vscale_range(2,2) vscale_range(2,2) {
; CHECK-LABEL: 'extract'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %shuffle.i5 = shufflevector <64 x i32> %v, <64 x i32> poison, <64 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: store <64 x i32> %shuffle.i5, ptr %out, align 4
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; CHECK-SIZE-LABEL: 'extract'
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %shuffle.i5 = shufflevector <64 x i32> %v, <64 x i32> poison, <64 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: store <64 x i32> %shuffle.i5, ptr %out, align 4
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %shuffle.i5 = shufflevector <64 x i32> %v, <64 x i32> poison, <64 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
  store <64 x i32> %shuffle.i5, ptr %out, align 4
  ret void
}

define void @shuffle() vscale_range(2,2) {
; CHECK-LABEL: 'shuffle'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v9 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v10 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v11 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v12 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v13 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v10b = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v14 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v15 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16 = shufflevector <2 x float> poison, <2 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v17 = shufflevector <4 x float> poison, <4 x float> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %v18 = shufflevector <2 x fp128> poison, <2 x fp128> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; CHECK-SIZE-LABEL: 'shuffle'
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 1, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v9 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v10 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v11 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 1, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v12 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v13 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v10b = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v14 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 1, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v15 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16 = shufflevector <2 x float> poison, <2 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v17 = shufflevector <4 x float> poison, <4 x float> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Invalid cost for instruction: %v18 = shufflevector <2 x fp128> poison, <2 x fp128> poison, <2 x i32> <i32 1, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v7 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 1, i32 0>
  %v8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>
  %v9 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
  %v10 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>

  %v11 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 1, i32 0>
  %v12 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>
  %v13 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
  %v10b = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>

  %v14 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 1, i32 0>
  %v15 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>

  %v16 = shufflevector <2 x float> poison, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  %v17 = shufflevector <4 x float> poison, <4 x float> poison, <4 x i32> <i32 1, i32 3, i32 2, i32 0>

  %v18 = shufflevector <2 x fp128> poison, <2 x fp128> poison, <2 x i32> <i32 1, i32 0>

  ret void
}

define void @concat() vscale_range(2,2) {
; CHECK-LABEL: 'concat'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %v4f16 = shufflevector <2 x half> poison, <2 x half> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %v8f16 = shufflevector <4 x half> poison, <4 x half> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %v16f16 = shufflevector <8 x half> poison, <8 x half> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32 = shufflevector <2 x float> poison, <2 x float> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32 = shufflevector <4 x float> poison, <4 x float> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64 = shufflevector <2 x double> poison, <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; CHECK-SIZE-LABEL: 'concat'
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-SIZE-NEXT:  Cost Model: Invalid cost for instruction: %v4f16 = shufflevector <2 x half> poison, <2 x half> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-SIZE-NEXT:  Cost Model: Invalid cost for instruction: %v8f16 = shufflevector <4 x half> poison, <4 x half> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Invalid cost for instruction: %v16f16 = shufflevector <8 x half> poison, <8 x half> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32 = shufflevector <2 x float> poison, <2 x float> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32 = shufflevector <4 x float> poison, <4 x float> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64 = shufflevector <2 x double> poison, <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v4i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %v8i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %v16i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>

  %v4i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %v8i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %v16i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>

  %v4i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %v8i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>

  %v4i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>

  %v4f16 = shufflevector <2 x half> poison, <2 x half> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %v8f16 = shufflevector <4 x half> poison, <4 x half> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %v16f16 = shufflevector <8 x half> poison, <8 x half> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>

  %v4f32 = shufflevector <2 x float> poison, <2 x float> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %v8f32 = shufflevector <4 x float> poison, <4 x float> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>

  %v4f64 = shufflevector <2 x double> poison, <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>

  ret void
}

define void @insert_subvec() vscale_range(2,2) {
; CHECK-LABEL: 'insert_subvec'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_2_0 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_2_1 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i8_2_0 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 8, i32 9, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_2_1 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_2_2 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_2_3 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 9>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_2_05 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 8, i32 9, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i8_4_0 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_4_1 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_4_2 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_4_3 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_4_05 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 18, i32 19, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i16_2_0 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_2_1 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_2_0 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 8, i32 9, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_2_1 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_2_2 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_2_3 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 9>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_2_05 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 9, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_4_0 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_4_1 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_4_2 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_4_3 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_4_05 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 18, i32 19, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i32_2_0 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_2_1 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_2_0 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 8, i32 9, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_2_1 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_2_2 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_2_3 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 9>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_2_05 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 8, i32 9, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_4_0 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_4_1 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_4_2 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_4_3 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16i32_4_05 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 18, i32 19, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; CHECK-SIZE-LABEL: 'insert_subvec'
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_2_0 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_2_1 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i8_2_0 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 8, i32 9, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_2_1 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_2_2 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_2_3 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 9>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_2_05 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 8, i32 9, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i8_4_0 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_4_1 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_4_2 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_4_3 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_4_05 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 18, i32 19, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i16_2_0 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_2_1 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_2_0 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 8, i32 9, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_2_1 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_2_2 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_2_3 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 9>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_2_05 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 9, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_4_0 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_4_1 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_4_2 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_4_3 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_4_05 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 18, i32 19, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i32_2_0 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_2_1 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_2_0 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 8, i32 9, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_2_1 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_2_2 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_2_3 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 9>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_2_05 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 8, i32 9, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_4_0 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_4_1 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_4_2 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_4_3 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16i32_4_05 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 18, i32 19, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v4i8_2_0 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  %v4i8_2_1 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
  %v8i8_2_0 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 8, i32 9, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %v8i8_2_1 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 6, i32 7>
  %v8i8_2_2 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 6, i32 7>
  %v8i8_2_3 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 9>
  %v8i8_2_05 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 8, i32 9, i32 3, i32 4, i32 5, i32 6, i32 7>
  %v16i8_4_0 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %v16i8_4_1 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %v16i8_4_2 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 12, i32 13, i32 14, i32 15>
  %v16i8_4_3 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19>
  %v16i8_4_05 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 18, i32 19, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>

  %v4i16_2_0 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  %v4i16_2_1 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
  %v8i16_2_0 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 8, i32 9, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %v8i16_2_1 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 6, i32 7>
  %v8i16_2_2 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 6, i32 7>
  %v8i16_2_3 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 9>
  %v8i16_2_05 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 9, i32 3, i32 4, i32 5, i32 6, i32 7>
  %v16i16_4_0 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %v16i16_4_1 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %v16i16_4_2 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 12, i32 13, i32 14, i32 15>
  %v16i16_4_3 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19>
  %v16i16_4_05 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 18, i32 19, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>

  %v4i32_2_0 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  %v4i32_2_1 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
  %v8i32_2_0 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 8, i32 9, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %v8i32_2_1 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 6, i32 7>
  %v8i32_2_2 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 6, i32 7>
  %v8i32_2_3 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 9>
  %v8i32_2_05 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 8, i32 9, i32 3, i32 4, i32 5, i32 6, i32 7>
  %v16i32_4_0 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %v16i32_4_1 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %v16i32_4_2 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 12, i32 13, i32 14, i32 15>
  %v16i32_4_3 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19>
  %v16i32_4_05 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 18, i32 19, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>

  ret void
}

define void @shuffle1() vscale_range(2,2) {
; RV32-LABEL: 'shuffle1'
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 0, i32 2>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 1, i32 3>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %zipv16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 0, i32 2>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 1, i32 3>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %zipv8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zip1v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zip2v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %zipv16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 0, i32 2>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 1, i32 3>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %zipv4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zip1v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zip2v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %zipv8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %zip1v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV32-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %zip2v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %zipv16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 0, i32 2>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 1, i32 3>
; RV32-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %zipv2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV32-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %zip1v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV32-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %zip2v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zipv4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %zip1v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV32-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %zip2v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %zipv8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 139 for instruction: %zip1v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV32-NEXT:  Cost Model: Found an estimated cost of 139 for instruction: %zip2v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %zipv16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64-LABEL: 'shuffle1'
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 0, i32 2>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 1, i32 3>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %zipv16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 0, i32 2>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 1, i32 3>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %zipv8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zip1v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zip2v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %zipv16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 0, i32 2>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 1, i32 3>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %zipv4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zip1v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zip2v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %zipv8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %zip1v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV64-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %zip2v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %zipv16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 0, i32 2>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 1, i32 3>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %zipv2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zip1v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %zip2v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %zipv4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %zip1v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV64-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %zip2v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %zipv8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 151 for instruction: %zip1v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV64-NEXT:  Cost Model: Found an estimated cost of 151 for instruction: %zip2v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %zipv16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32-SIZE-LABEL: 'shuffle1'
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 0, i32 2>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 1, i32 3>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 0, i32 2>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 1, i32 3>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 0, i32 2>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 1, i32 3>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 0, i32 2>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 1, i32 3>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %zipv16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; RV64-SIZE-LABEL: 'shuffle1'
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 0, i32 2>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 1, i32 3>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 0, i32 2>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 1, i32 3>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 0, i32 2>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 1, i32 3>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 0, i32 2>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 1, i32 3>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zipv8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip1v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %zip2v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %zipv16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %zip1v2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 0, i32 2>
  %zip2v2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <2 x i32> <i32 1, i32 3>
  %zipv2i8 = shufflevector <2 x i8> poison, <2 x i8> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  %zip1v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %zip2v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %zipv4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  %zip1v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
  %zip2v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  %zipv8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  %zip1v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
  %zip2v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  %zipv16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>

  %zip1v2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 0, i32 2>
  %zip2v2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <2 x i32> <i32 1, i32 3>
  %zipv2i16 = shufflevector <2 x i16> poison, <2 x i16> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  %zip1v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %zip2v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %zipv4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  %zip1v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
  %zip2v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  %zipv8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  %zip1v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
  %zip2v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  %zipv16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>

  %zip1v2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 0, i32 2>
  %zip2v2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <2 x i32> <i32 1, i32 3>
  %zipv2i32 = shufflevector <2 x i32> poison, <2 x i32> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  %zip1v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %zip2v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %zipv4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  %zip1v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
  %zip2v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  %zipv8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  %zip1v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
  %zip2v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  %zipv16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>

  %zip1v2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 0, i32 2>
  %zip2v2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 1, i32 3>
  %zipv2i64 = shufflevector <2 x i64> poison, <2 x i64> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  %zip1v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %zip2v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %zipv4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  %zip1v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
  %zip2v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  %zipv8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  %zip1v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
  %zip2v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  %zipv16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>

  ret void
}

define void @shuffle2() vscale_range(2,2) {
; RV32-LABEL: 'shuffle2'
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %uzpv16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %uzpv8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzp1v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzp2v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %uzpv16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV32-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %uzpv4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzp1v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzp2v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %uzpv8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %uzp1v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV32-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %uzp2v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %uzpv16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %uzp1v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV32-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %uzp2v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzpv4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %uzp1v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV32-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %uzp2v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %uzpv8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 139 for instruction: %uzp1v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV32-NEXT:  Cost Model: Found an estimated cost of 139 for instruction: %uzp2v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %uzpv16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64-LABEL: 'shuffle2'
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %uzpv16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %uzpv8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzp1v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzp2v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %uzpv16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV64-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %uzpv4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzp1v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzp2v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %uzpv8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %uzp1v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV64-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %uzp2v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %uzpv16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzp1v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV64-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %uzp2v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %uzpv4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %uzp1v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV64-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %uzp2v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %uzpv8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 151 for instruction: %uzp1v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV64-NEXT:  Cost Model: Found an estimated cost of 151 for instruction: %uzp2v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %uzpv16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32-SIZE-LABEL: 'shuffle2'
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %uzpv16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; RV64-SIZE-LABEL: 'shuffle2'
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %uzpv8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp1v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %uzp2v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %uzpv16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %uzp1v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %uzp2v4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %uzpv4i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  %uzp1v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %uzp2v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %uzpv8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %uzp1v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %uzp2v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %uzpv16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>

  %uzp1v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %uzp2v4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %uzpv4i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  %uzp1v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %uzp2v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %uzpv8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %uzp1v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %uzp2v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %uzpv16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>

  %uzp1v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %uzp2v4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %uzpv4i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  %uzp1v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %uzp2v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %uzpv8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %uzp1v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %uzp2v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %uzpv16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>

  %uzp1v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %uzp2v4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %uzpv4i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  %uzp1v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %uzp2v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %uzpv8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %uzp1v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %uzp2v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %uzpv16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>

  ret void
}


define void @multipart() vscale_range(2,2) {
; CHECK-LABEL: 'multipart'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v16a = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16b = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16c = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16d = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32a = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v32a4 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v32idrev = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 15, i32 14, i32 13, i32 12, i32 16, i32 17, i32 18, i32 19, i32 31, i32 30, i32 29, i32 28>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %v32many = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %v32many2 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 1, i32 4, i32 8, i32 12, i32 17, i32 20, i32 24, i32 28, i32 2, i32 6, i32 11, i32 14, i32 18, i32 22, i32 27, i32 30>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v323 = shufflevector <3 x i32> poison, <3 x i32> poison, <3 x i32> <i32 2, i32 3, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64a = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 1, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64b = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64ab = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 1, i32 0, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64d = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 1, i32 4, i32 4>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %f64a = shufflevector <2 x double> poison, <2 x double> poison, <2 x i32> <i32 1, i32 1>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %f64b = shufflevector <2 x double> poison, <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %f64ab = shufflevector <4 x double> poison, <4 x double> poison, <4 x i32> <i32 1, i32 1, i32 0, i32 0>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; CHECK-SIZE-LABEL: 'multipart'
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v16a = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16b = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16c = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16d = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32a = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v32a4 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v32idrev = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 15, i32 14, i32 13, i32 12, i32 16, i32 17, i32 18, i32 19, i32 31, i32 30, i32 29, i32 28>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v32many = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v32many2 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 1, i32 4, i32 8, i32 12, i32 17, i32 20, i32 24, i32 28, i32 2, i32 6, i32 11, i32 14, i32 18, i32 22, i32 27, i32 30>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v323 = shufflevector <3 x i32> poison, <3 x i32> poison, <3 x i32> <i32 2, i32 3, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64a = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 1, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64b = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> zeroinitializer
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64ab = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 1, i32 0, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64d = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 1, i32 4, i32 4>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %f64a = shufflevector <2 x double> poison, <2 x double> poison, <2 x i32> <i32 1, i32 1>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %f64b = shufflevector <2 x double> poison, <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %f64ab = shufflevector <4 x double> poison, <4 x double> poison, <4 x i32> <i32 1, i32 1, i32 0, i32 0>
; CHECK-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v16a = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
  %v16b = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %v16c = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %v16d = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>

  %v32a = shufflevector <4 x i32> poison, <4 x i32> poison, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %v32a4 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1>
  %v32idrev = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 15, i32 14, i32 13, i32 12, i32 16, i32 17, i32 18, i32 19, i32 31, i32 30, i32 29, i32 28>
  %v32many = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %v32many2 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 1, i32 4, i32 8, i32 12, i32 17, i32 20, i32 24, i32 28, i32 2, i32 6, i32 11, i32 14, i32 18, i32 22, i32 27, i32 30>
  %v323 = shufflevector <3 x i32> poison, <3 x i32> poison, <3 x i32> <i32 2, i32 3, i32 0>

  %v64a = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 1, i32 1>
  %v64b = shufflevector <2 x i64> poison, <2 x i64> poison, <2 x i32> <i32 0, i32 0>
  %v64ab = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 1, i32 0, i32 0>
  %v64d = shufflevector <4 x i64> poison, <4 x i64> poison, <4 x i32> <i32 1, i32 1, i32 4, i32 4>

  %f64a = shufflevector <2 x double> poison, <2 x double> poison, <2 x i32> <i32 1, i32 1>
  %f64b = shufflevector <2 x double> poison, <2 x double> poison, <2 x i32> <i32 0, i32 0>
  %f64ab = shufflevector <4 x double> poison, <4 x double> poison, <4 x i32> <i32 1, i32 1, i32 0, i32 0>

  ret void
}


define void @shuffle4(ptr %p) vscale_range(2,2) {
; RV32-LABEL: 'shuffle4'
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV32-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v64i8 = shufflevector <32 x i8> poison, <32 x i8> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV32-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v32i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV32-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v64i16 = shufflevector <32 x i16> poison, <32 x i16> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV32-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v16i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV32-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v32i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV32-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %v64i32 = shufflevector <32 x i32> poison, <32 x i32> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %v8i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV32-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %v16i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV32-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %v32i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV32-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %v64i64 = shufflevector <32 x i64> poison, <32 x i64> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV32-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64-LABEL: 'shuffle4'
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v64i8 = shufflevector <32 x i8> poison, <32 x i8> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v32i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV64-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v64i16 = shufflevector <32 x i16> poison, <32 x i16> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v16i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV64-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v32i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV64-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %v64i32 = shufflevector <32 x i32> poison, <32 x i32> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v8i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV64-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v16i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV64-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %v32i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV64-NEXT:  Cost Model: Found an estimated cost of 144 for instruction: %v64i64 = shufflevector <32 x i64> poison, <32 x i64> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32-SIZE-LABEL: 'shuffle4'
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64i8 = shufflevector <32 x i8> poison, <32 x i8> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64i16 = shufflevector <32 x i16> poison, <32 x i16> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %v64i32 = shufflevector <32 x i32> poison, <32 x i32> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %v32i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %v64i64 = shufflevector <32 x i64> poison, <32 x i64> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; RV64-SIZE-LABEL: 'shuffle4'
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64i8 = shufflevector <32 x i8> poison, <32 x i8> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64i16 = shufflevector <32 x i16> poison, <32 x i16> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %v64i32 = shufflevector <32 x i32> poison, <32 x i32> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %v32i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 144 for instruction: %v64i64 = shufflevector <32 x i64> poison, <32 x i64> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v8i8 = shufflevector <4 x i8> poison, <4 x i8> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  %v16i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  %v32i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  %v64i8 = shufflevector <32 x i8> poison, <32 x i8> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>

  %v8i16 = shufflevector <4 x i16> poison, <4 x i16> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  %v16i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  %v32i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  %v64i16 = shufflevector <32 x i16> poison, <32 x i16> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>

  %v8i32 = shufflevector <4 x i32> poison, <4 x i32> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  %v16i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  %v32i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  %v64i32 = shufflevector <32 x i32> poison, <32 x i32> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>

  %v8i64 = shufflevector <4 x i64> poison, <4 x i64> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  %v16i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  %v32i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  %v64i64 = shufflevector <32 x i64> poison, <32 x i64> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>

  ret void
}


define void @shuffle5(ptr %p) vscale_range(2,2) {
; RV32-LABEL: 'shuffle5'
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32i8 = shufflevector <32 x i8> poison, <32 x i8> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v64i8 = shufflevector <64 x i8> poison, <64 x i8> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV32-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v32i16 = shufflevector <32 x i16> poison, <32 x i16> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v64i16 = shufflevector <64 x i16> poison, <64 x i16> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV32-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v32i32 = shufflevector <32 x i32> poison, <32 x i32> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %v64i32 = shufflevector <64 x i32> poison, <64 x i32> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV32-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV32-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %v32i64 = shufflevector <32 x i64> poison, <32 x i64> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV32-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %v64i64 = shufflevector <64 x i64> poison, <64 x i64> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV32-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64-LABEL: 'shuffle5'
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32i8 = shufflevector <32 x i8> poison, <32 x i8> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v64i8 = shufflevector <64 x i8> poison, <64 x i8> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV64-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v32i16 = shufflevector <32 x i16> poison, <32 x i16> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v64i16 = shufflevector <64 x i16> poison, <64 x i16> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV64-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v32i32 = shufflevector <32 x i32> poison, <32 x i32> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %v64i32 = shufflevector <64 x i32> poison, <64 x i32> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV64-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-NEXT:  Cost Model: Found an estimated cost of 74 for instruction: %v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV64-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %v32i64 = shufflevector <32 x i64> poison, <32 x i64> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV64-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %v64i64 = shufflevector <64 x i64> poison, <64 x i64> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV64-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32-SIZE-LABEL: 'shuffle5'
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i8 = shufflevector <32 x i8> poison, <32 x i8> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64i8 = shufflevector <64 x i8> poison, <64 x i8> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i16 = shufflevector <32 x i16> poison, <32 x i16> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64i16 = shufflevector <64 x i16> poison, <64 x i16> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i32 = shufflevector <32 x i32> poison, <32 x i32> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %v64i32 = shufflevector <64 x i32> poison, <64 x i32> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %v32i64 = shufflevector <32 x i64> poison, <32 x i64> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %v64i64 = shufflevector <64 x i64> poison, <64 x i64> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV32-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; RV64-SIZE-LABEL: 'shuffle5'
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i8 = shufflevector <32 x i8> poison, <32 x i8> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64i8 = shufflevector <64 x i8> poison, <64 x i8> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i16 = shufflevector <32 x i16> poison, <32 x i16> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64i16 = shufflevector <64 x i16> poison, <64 x i16> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i32 = shufflevector <32 x i32> poison, <32 x i32> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %v64i32 = shufflevector <64 x i32> poison, <64 x i32> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %v32i64 = shufflevector <32 x i64> poison, <32 x i64> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %v64i64 = shufflevector <64 x i64> poison, <64 x i64> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
; RV64-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v8i8 = shufflevector <8 x i8> poison, <8 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  %v16i8 = shufflevector <16 x i8> poison, <16 x i8> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  %v32i8 = shufflevector <32 x i8> poison, <32 x i8> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  %v64i8 = shufflevector <64 x i8> poison, <64 x i8> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>

  %v8i16 = shufflevector <8 x i16> poison, <8 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  %v16i16 = shufflevector <16 x i16> poison, <16 x i16> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  %v32i16 = shufflevector <32 x i16> poison, <32 x i16> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  %v64i16 = shufflevector <64 x i16> poison, <64 x i16> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>

  %v8i32 = shufflevector <8 x i32> poison, <8 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  %v16i32 = shufflevector <16 x i32> poison, <16 x i32> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  %v32i32 = shufflevector <32 x i32> poison, <32 x i32> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  %v64i32 = shufflevector <64 x i32> poison, <64 x i32> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>

  %v8i64 = shufflevector <8 x i64> poison, <8 x i64> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  %v16i64 = shufflevector <16 x i64> poison, <16 x i64> poison, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  %v32i64 = shufflevector <32 x i64> poison, <32 x i64> poison, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  %v64i64 = shufflevector <64 x i64> poison, <64 x i64> poison, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>

  ret void
}
