// REQUIRES: zstd && (system-windows || system-linux)

// clang-offload-wrapper compression test: checks that the wrapper can compress the device images.
// Checks the '--offload-compress', '--offload-compression-level', and '--offload-compression-threshold'
// CLI options.

// --- Prepare test data by creating the debice binary image.
// RUN: echo -e -n 'device binary image1\n' > %t.bin
// RUN: echo -e -n '[Category1]\nint_prop1=1|10\n[Category2]\nint_prop2=1|20\n' > %t.props
// RUN: echo -e -n 'kernel1\nkernel2\n' > %t.sym
// RUN: echo -e -n 'Manifest file - arbitrary data generated by the toolchain\n' > %t.mnf
// RUN: echo '[Code|Properties|Symbols|Manifest]' > %t.img1
// RUN: echo %t.bin"|"%t.props"|"%t.sym"|"%t.mnf >> %t.img1

///////////////////////////////////////////////////////
// Compress the test image using clang-offload-wrapper.
///////////////////////////////////////////////////////

// RUN: clang-offload-wrapper -kind=sycl -target=TARGET -batch %t.img1 -o %t.wrapped.bc -v \
// RUN: --offload-compress --offload-compression-level=9 --offload-compression-threshold=0 \
// RUN: 2>&1 | FileCheck %s --check-prefix=CHECK-COMPRESS

// CHECK-COMPRESS: [Compression] Original image size:
// CHECK-COMPRESS: [Compression] Compressed image size:
// CHECK-COMPRESS: [Compression] Compression level used: 9

///////////////////////////////////////////////////////////
// Check that there is no compression when the threshold is set to a value higher than the image size
// or '--offload-compress' is not set.
///////////////////////////////////////////////////////////

// RUN: clang-offload-wrapper -kind=sycl -target=TARGET -batch %t.img1 -o %t.wrapped.bc -v \
// RUN: --offload-compress --offload-compression-level=3 --offload-compression-threshold=1000 \
// RUN: 2>&1 | FileCheck %s --check-prefix=CHECK-NO-COMPRESS

// RUN: clang-offload-wrapper -kind=sycl -target=TARGET -batch %t.img1 -o %t.wrapped.bc -v \
// RUN: --offload-compression-level=3 --offload-compression-threshold=0 \
// RUN: 2>&1 | FileCheck %s --check-prefix=CHECK-NO-COMPRESS

// CHECK-NO-COMPRESS-NOT: [Compression] Original image size:
