// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -x c++ -triple spir64-unknown-linux -disable-llvm-passes -fsycl-is-device -emit-llvm %s -o - | FileCheck %s

struct S {
  unsigned short x;
};

// CHECK-LABEL: define {{[^@]+}}@_Z3foobR1SS_(
// CHECK:  entry:
// CHECK-NEXT:    [[COND_ADDR:%.*]] = alloca i8, align 1
// CHECK-NEXT:    [[LHS_ADDR:%.*]] = alloca ptr addrspace(4), align 8
// CHECK-NEXT:    [[COND_ADDR_ASCAST:%.*]] = addrspacecast ptr [[COND_ADDR]] to ptr addrspace(4)
// CHECK-NEXT:    [[LHS_ADDR_ASCAST:%.*]] = addrspacecast ptr [[LHS_ADDR]] to ptr addrspace(4)
// CHECK-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[COND:%.*]] to i8
// CHECK-NEXT:    store i8 [[FROMBOOL]], ptr addrspace(4) [[COND_ADDR_ASCAST]], align 1
// CHECK-NEXT:    store ptr addrspace(4) [[LHS:%.*]], ptr addrspace(4) [[LHS_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[RHS_ASCAST:%.*]] = addrspacecast ptr [[RHS:%.*]] to ptr addrspace(4)
// CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr addrspace(4) [[COND_ADDR_ASCAST]], align 1
// CHECK-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP0]] to i1
// CHECK-NEXT:    br i1 [[TOBOOL]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK:       cond.true:
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr addrspace(4), ptr addrspace(4) [[LHS_ADDR_ASCAST]], align 8
// CHECK-NEXT:    br label [[COND_END:%.*]]
// CHECK:       cond.false:
// CHECK-NEXT:    br label [[COND_END]]
// CHECK:       cond.end:
// CHECK-NEXT:    [[COND_LVALUE:%.*]] = phi ptr addrspace(4) [ [[TMP1]], [[COND_TRUE]] ], [ [[RHS_ASCAST]], [[COND_FALSE]] ]
// CHECK-NEXT:    call void @llvm.memcpy.p0.p4.i64(ptr align 2 [[AGG_RESULT:%.*]], ptr addrspace(4) align 2 [[COND_LVALUE]], i64 2, i1 false)
// CHECK-NEXT:    ret void
//
S foo(bool cond, S &lhs, S rhs) {
  S val = cond ? lhs : rhs;
  return val;
}

template <typename name, typename Func>
__attribute__((sycl_kernel)) void kernel(const Func &kernelFunc) {
  kernelFunc();
}

int main() {
  kernel<class fake_kernel>([]() {
    S lhs, rhs;
    foo(true, lhs, rhs);
  });
  return 0;
}
