// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN:  %clang_cc1 %s -triple x86_64-pc-linux  \
// RUN:  -emit-llvm -O0 -cl-std=CL2.0 -ffake-address-space-map \
// RUN:  -target-cpu skx -o - | FileCheck %s

typedef int __v16si __attribute__((__vector_size__(64)));

// CHECK-LABEL: @load(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[__U_ADDR:%.*]] = alloca i16, align 2
// CHECK-NEXT:    [[__P_ADDR:%.*]] = alloca ptr addrspace(4), align 8
// CHECK-NEXT:    [[DD:%.*]] = alloca <16 x i32>, align 64
// CHECK-NEXT:    store i16 [[__U:%.*]], ptr [[__U_ADDR]], align 2
// CHECK-NEXT:    store ptr addrspace(4) [[__P:%.*]], ptr [[__P_ADDR]], align 8
// CHECK-NEXT:    store <16 x i32> zeroinitializer, ptr [[DD]], align 64
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr addrspace(4), ptr [[__P_ADDR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i32>, ptr [[DD]], align 64
// CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr [[__U_ADDR]], align 2
// CHECK-NEXT:    [[TMP3:%.*]] = addrspacecast ptr addrspace(4) [[TMP0]] to ptr
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast i16 [[TMP2]] to <16 x i1>
// CHECK-NEXT:    [[TMP5:%.*]] = call <16 x i32> @llvm.masked.load.v16i32.p0(ptr [[TMP3]], i32 1, <16 x i1> [[TMP4]], <16 x i32> [[TMP1]])
// CHECK-NEXT:    ret void
//
void load(unsigned short __U, void const *__P) {
  __v16si dd = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
  __builtin_ia32_loaddqusi512_mask(__P, dd, __U);
}

// CHECK-LABEL: @store(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[__U_ADDR:%.*]] = alloca i16, align 2
// CHECK-NEXT:    [[__P_ADDR:%.*]] = alloca ptr addrspace(4), align 8
// CHECK-NEXT:    [[AA:%.*]] = alloca <16 x i32>, align 64
// CHECK-NEXT:    store i16 [[__U:%.*]], ptr [[__U_ADDR]], align 2
// CHECK-NEXT:    store ptr addrspace(4) [[__P:%.*]], ptr [[__P_ADDR]], align 8
// CHECK-NEXT:    store <16 x i32> zeroinitializer, ptr [[AA]], align 64
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr addrspace(4), ptr [[__P_ADDR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i32>, ptr [[AA]], align 64
// CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr [[__U_ADDR]], align 2
// CHECK-NEXT:    [[TMP3:%.*]] = addrspacecast ptr addrspace(4) [[TMP0]] to ptr
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast i16 [[TMP2]] to <16 x i1>
// CHECK-NEXT:    call void @llvm.masked.store.v16i32.p0(<16 x i32> [[TMP1]], ptr [[TMP3]], i32 1, <16 x i1> [[TMP4]])
// CHECK-NEXT:    ret void
//
void store(unsigned short __U, void const *__P) {
  __v16si aa = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
  __builtin_ia32_storedqusi512_mask((int *)__P, aa, __U);
}

// CHECK-LABEL: @foo(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[PLOADSTORE_ADDR:%.*]] = alloca ptr addrspace(4), align 8
// CHECK-NEXT:    [[MASK_ADDR:%.*]] = alloca i16, align 2
// CHECK-NEXT:    store ptr addrspace(4) [[PLOADSTORE:%.*]], ptr [[PLOADSTORE_ADDR]], align 8
// CHECK-NEXT:    store i16 [[MASK:%.*]], ptr [[MASK_ADDR]], align 2
// CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[MASK_ADDR]], align 2
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr addrspace(4), ptr [[PLOADSTORE_ADDR]], align 8
// CHECK-NEXT:    call void @load(i16 noundef zeroext [[TMP0]], ptr addrspace(4) noundef [[TMP1]]) #[[ATTR4:[0-9]+]]
// CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr [[MASK_ADDR]], align 2
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr addrspace(4), ptr [[PLOADSTORE_ADDR]], align 8
// CHECK-NEXT:    call void @store(i16 noundef zeroext [[TMP2]], ptr addrspace(4) noundef [[TMP3]]) #[[ATTR4]]
// CHECK-NEXT:    ret void
//
void foo(void const *pLoadStore, unsigned short mask) {
  load(mask, pLoadStore);
  store(mask, pLoadStore);
}
