﻿# Versioning scheme for .NET Compiler Platform ("Roslyn") Analyzers

Following is the versioning scheme that is being used for analyzer packages:

1. The major and minor version numbers of the packages track the major and minor version numbers of Microsoft.CodeAnalysis package that the analyzer is dependent upon. For example, version 1.0.0, 1.0.1, ..., 1.0.X of the analyzer packages depend upon version 1.0.0 of Microsoft.CodeAnalysis package.

2. When we move the repo to a newer version of Microsoft.CodeAnalysis, say 1.X.0, then the version number of all the analyzer packages will be bumped to be >= 1.X.0.

**NOTE**: An exception was applied to the above versioning scheme when we moved the analyzer packages to version 1.1.0, while still depending on version 1.0.0 of Microsoft.CodeAnalysis. This was done as we had mistakenly published 1.1.0-beta1 pre-release packages for some analyzer packages on nuget.org.

## Current and Released Versions of Analyzer Packages

Current version of all analyzer packages that are built out of this repo are tracked by the `VersionPrefix` property defined in [Versions.Props](.//eng//Versions.props)

Released versions of analyzer packages, with the last GitHub Commit Tag and SHA are below:

### Microsoft.CodeAnalysis.NetAnalyzers

Sr. No. | Release         |
--------|-----------------|
1       | [5.0.0](https://github.com/dotnet/roslyn-analyzers/releases/tag/5.0.0)           |
2       | [5.0.1](https://github.com/dotnet/roslyn-analyzers/releases/tag/5.0.1)           |
3       | [5.0.3](https://github.com/dotnet/roslyn-analyzers/releases/tag/5.0.3)           |
4       | [6.0.0](https://github.com/dotnet/roslyn-analyzers/releases/tag/6.0.0)           |
5       | [7.0.0](https://github.com/dotnet/roslyn-analyzers/releases/tag/7.0.0)           |

### Other analyzers

Sr. No. |  Release Version | Commit Tag       | Commit SHA                                                                                            | Released Packages                                                                                               |
--------|------------------|------------------|-------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------|
1       |  1.1.0           | v1.1.0    | [d96fbd4](https://github.com/dotnet/roslyn-analyzers/commit/d96fbd4e4b6c1fc5b01e3dc5af80d2b15034cc8c)   | MicrosoftCodeAnalysisAnalyzers, FxCopAnalyzers, DesktopAnalyzers, SystemRuntimeAnalyzers, SystemRuntimeInteropServicesAnalyzers, SystemSecurityCryptographyHashingAlgorithmsAnalyzers, AnalyzerPowerPack
2       |  1.2.0-beta1 (pre-release)    | v1.2.0-beta1    | [5d7f034](https://github.com/dotnet/roslyn-analyzers/commit/5d7f034c6a230ac522adeb22f65a14286eeaea8e)   | Desktop.Analyzers, Microsoft.ApiDesignGuidelines.Analyzers, Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.Composition.Analyzers, Microsoft.Maintainability.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.QualityGuidelines.Analyzers, Roslyn.Diagnostics.Analyzers, System.Collections.Immutable.Analyzers, System.Resources.Analyzers, System.Runtime.Analyzers, System.Runtime.InteropServices.Analyzers, System.Security.Cryptography.Hashing.Algorithms.Analyzers, System.Threading.Tasks.Analyzers, Text.Analyzers, XmlDocumentationComments.Analyzers
3       | 1.2.0-beta2 (pre-release)     | v1.2.0-beta2    | [19d67c8](https://github.com/dotnet/roslyn-analyzers/commit/19d67c86a3f3f05e657fedac70510c880263f7f7)   | Desktop.Analyzers, Microsoft.ApiDesignGuidelines.Analyzers, Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.Composition.Analyzers, Microsoft.Maintainability.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.QualityGuidelines.Analyzers, Roslyn.Diagnostics.Analyzers, System.Collections.Immutable.Analyzers, System.Resources.Analyzers, System.Runtime.Analyzers, System.Runtime.InteropServices.Analyzers, System.Security.Cryptography.Hashing.Algorithms.Analyzers, System.Threading.Tasks.Analyzers, Text.Analyzers, XmlDocumentationComments.Analyzers
4       | 2.0.0-beta1 (pre-release)     | v2.0.0-beta1    | [9ee42b9](https://github.com/dotnet/roslyn-analyzers/commit/9ee42b940df780793208cc130ca74e0ea6a5d5dc)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
5       | 2.0.0-beta2 (pre-release)     | v2.0.0-beta2    | [95e0ccc](https://github.com/dotnet/roslyn-analyzers/commit/95e0ccc46470d5dbd1cc6913fc1b975443242fd8)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
6       | 2.3.0-beta1 (pre-release)     | v2.3.0-beta1    | [d4407b2](https://github.com/dotnet/roslyn-analyzers/commit/d4407b236f4381cfae71cbac26ffc9281e326af9)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
7       | 2.6.0-beta1 (pre-release)     | v2.6.0-beta1    | [6f3a651](https://github.com/dotnet/roslyn-analyzers/commit/6f3a65166a9e8c18efa122c5843ecf749a7f263a)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
8       | 2.6.0-beta2 (pre-release)     | v2.6.0-beta2    | [f43577b](https://github.com/dotnet/roslyn-analyzers/commit/f43577bc2e8d545e4dfc2484edde2710df7a48f9)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
9       | 2.6.0 (release)               | v2.6.0          | [32d8c24](https://github.com/dotnet/roslyn-analyzers/commit/32d8c24893858ae68fc829c9e26bdd499c74e404)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
10       | 2.6.1 (release)              | v2.6.1          | [9c7e47f](https://github.com/dotnet/roslyn-analyzers/commit/9c7e47fdc74bf0c765ea663917c43f02c82f9731)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
11       | 2.6.2-beta1 (pre-release)    | v2.6.2-beta1    | [01f77e7](https://github.com/dotnet/roslyn-analyzers/commit/01f77e7f4ead0a001e25fef08954bc7d45c6c897)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
12       | 2.6.2-beta2 (pre-release)    | v2.6.2-beta2    | [ed182a5](https://github.com/dotnet/roslyn-analyzers/commit/ed182a52b2201b659389d1642ffdb69e8beeddd6)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
13       | 2.6.2 (release)              | v2.6.2          | [851ba52](https://github.com/dotnet/roslyn-analyzers/commit/851ba52b52b56e7c37219e23d05052395e3301e3)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
14       | 2.6.3 (release)              | v2.6.3          | [759b72f](https://github.com/dotnet/roslyn-analyzers/commit/759b72ff4dc4647de12f7ece54d756f0613c3539)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers,  Roslyn.Diagnostics.Analyzers, Text.Analyzers
15       | 2.6.4 (release)              | v2.6.4          | [e0f9443](https://github.com/dotnet/roslyn-analyzers/commit/e0f9443f7ec8b86b55393dcc99d24cc9d5853c95)   | Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Text.Analyzers
16       | 2.9.0-beta1.final (pre-release)              | v2.9.0-beta1.final          | [321600d](https://github.com/dotnet/roslyn-analyzers/commit/321600d1fbb5aed8574b7703682dd5323a31191b)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.Net.RoslynDiagnostics, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Text.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
17       | 2.9.0              | v2.9.0          | [ea7ff1c](https://github.com/dotnet/roslyn-analyzers/commit/ea7ff1ca55f67624a80d03ae34b2470599248fe3)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
18       | 2.9.1              | v2.9.1          | [aa54bf0](https://github.com/dotnet/roslyn-analyzers/commit/aa54bf09db2efd50a9d62311bbff053daa7e9baf)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
19       | 2.9.2              | v2.9.2          | [dcad84f](https://github.com/dotnet/roslyn-analyzers/commit/dcad84faf700d501edd8cb3c79279abd328c1ad0)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
20       | 2.9.3              | v2.9.3          | [7f096af](https://github.com/dotnet/roslyn-analyzers/commit/7f096aff22c1fd35652d55a9405e13d421dfe512)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
21       | 2.9.4-beta1.final (pre-release)             | v2.9.4-beta1.final          | [3b22a6a](https://github.com/dotnet/roslyn-analyzers/commit/3b22a6a82d450350ab0cf27504adab8d1226b2a8)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers, Microsoft.CodeAnalysis.FlowAnalysis.Utilities
22       | 2.9.4             | v2.9.4          | [a1a198d](https://github.com/dotnet/roslyn-analyzers/commit/a1a198d1c5d2359e93dd4ab4b1c4f7421512724e)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers, Microsoft.CodeAnalysis.FlowAnalysis.Utilities
23       | 2.9.5-beta1.final (pre-release)             | v2.9.5-beta1.final          | [494de6f](https://github.com/dotnet/roslyn-analyzers/commit/494de6f80082746e41d69355535f8dc3bfef494a)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
24       | 2.9.5             | v2.9.5          | [6c05175](https://github.com/dotnet/roslyn-analyzers/commit/6c05175f91bf7cc463a1b71e1f6773d4afcaa7a1)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers, Microsoft.CodeAnalysis.FlowAnalysis.Utilities
25       | 2.9.6             | v2.9.6          | [b377a16](https://github.com/dotnet/roslyn-analyzers/commit/b377a1612025bc51a737b69305d1546db9808f18)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers, Microsoft.CodeAnalysis.FlowAnalysis.Utilities
26       | 2.9.7             | v2.9.7          | [89f1193](https://github.com/dotnet/roslyn-analyzers/commit/89f1193364ef535a508f63e89d7c0e701b52c45c)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
27       | 2.9.8             | v2.9.8          | [1d07ec7](https://github.com/dotnet/roslyn-analyzers/commit/1d07ec78d0094b99c4f9f21864bb811e44344b99)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
28       | 2.9.9             | v2.9.9          | [e5c68c9](https://github.com/dotnet/roslyn-analyzers/commit/e5c68c969626565d6bfe58bcd2b77e219f4a02d8)   | Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers
29       | 2.9.10             | v2.9.10          | [d512b50](https://github.com/dotnet/roslyn-analyzers/commit/d512b503e4e86fa36c46d1b76eb098d05c8397c1)   | Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers
30       | 2.9.11             | v2.9.11          | [8394e05](https://github.com/dotnet/roslyn-analyzers/commit/8394e05acf4d188c0049a563de34f2395bd6b6d5)   | Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers
31       | 2.9.12             | v2.9.12          | [9b1b3df](https://github.com/dotnet/roslyn-analyzers/commit/9b1b3dfb3e3b29a3f1bafa4e32f739e37aee0e56)   | Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers
32       | 3.0.0-beta2.final (pre-release)             | v3.0.0-beta2.final          | [6dc3658](https://github.com/dotnet/roslyn-analyzers/commit/6dc3658cb0b16fc57997979afce092245b087c1c)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.AnalyzerUtilities, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
33       | 3.0.0-beta3.final (pre-release)             | v3.0.0-beta3.final          | [f902405](https://github.com/dotnet/roslyn-analyzers/commit/f902405734ee5206912ea46537947576d02f954f)   | Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers
34       | 3.0.0             | v3.0.0          | [39d189a](https://github.com/dotnet/roslyn-analyzers/commit/39d189ab8b48b3811978edbafdc0aef190025f53)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.AnalyzerUtilities, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
35       | 3.3.0-beta1.final (pre-release)             | v3.3.0-beta1.final          | [d752929](https://github.com/dotnet/roslyn-analyzers/commit/d7529293a04f71e007f1a7b74cba6378979589f3)   | Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers
36       | 3.3.0-beta2.final (pre-release)             | v3.3.0-beta2.final          | [303d517](https://github.com/dotnet/roslyn-analyzers/commit/303d517d74aaaade61c2e46c9d8965c23758ee7d)   | Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
37       | 3.3.0             | v3.3.0          | [0a95f9e](https://github.com/dotnet/roslyn-analyzers/commit/0a95f9e9a53519ee3cd59b9cf96be6326ef9955b)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.AnalyzerUtilities, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.Metrics, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
38       | 3.3.1             | v3.3.1          | [49efc9e](https://github.com/dotnet/roslyn-analyzers/commit/49efc9eea7aaa303190beb5b3ea554604fb5ce9d)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.AnalyzerUtilities, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
39       | 3.3.2             | v3.3.2          | [4e0e1e8](https://github.com/dotnet/roslyn-analyzers/commit/4e0e1e855864587991a39e1e974dc53af094f4db)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.AnalyzerUtilities, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
40       | 3.3.3             | v3.3.3          | [2771ee3](https://github.com/dotnet/roslyn-analyzers/commit/2771ee33883320861d72cdd23bf09a8da7fa8e5e)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.AnalyzerUtilities, Microsoft.CodeAnalysis.FxCopAnalyzers, Microsoft.CodeAnalysis.VersionCheckAnalyzer, Microsoft.CodeQuality.Analyzers, Microsoft.NetCore.Analyzers, Microsoft.NetFramework.Analyzers, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers
41       | 3.3.4             | v3.3.4          | [22ea642](https://github.com/dotnet/roslyn-analyzers/commit/22ea6422f85b05ca0793cc3b76375487be407f5d)   | Microsoft.CodeAnalysis.Analyzers, Microsoft.CodeAnalysis.AnalyzerUtilities, Roslyn.Diagnostics.Analyzers, Microsoft.CodeAnalysis.PublicApiAnalyzers, Microsoft.CodeAnalysis.BannedApiAnalyzers, Microsoft.CodeAnalysis.Metrics, Text.Analyzers
