#!/usr/bin/env bats
# Test to refuse server with only deprecated TLS versions

setup_file() {
  CERT="$BATS_TMPDIR/cert.pem"
  KEY="$BATS_TMPDIR/key.pem"

  openssl req -x509 -newkey rsa:3072 -nodes \
    -keyout "$BATS_TMPDIR/key.pem" \
    -out "$BATS_TMPDIR/cert.pem" \
    -subj "/CN=localhost" \
    -days 1 > /dev/null 2>&1

  if [[ ! -s "$CERT" || ! -s "$KEY" ]]; then
    echo "# Failed to generate certificate or key" >&2
    exit 1
  fi

  # Start OpenSSL server in background: only support TLS 1.0 and 1.1
  openssl s_server \
    -accept 4433 \
    -cert "$BATS_TMPDIR/cert.pem" \
    -key "$BATS_TMPDIR/key.pem" \
    -no_tls1_2 -no_tls1_3 \
    -quiet > "$BATS_TMPDIR/server.log" 2>&1 &

  SERVER_PID=$!

  for i in {1..10}; do
    nc -z localhost 4433 && break
    sleep 0.5
  done

  if ! kill -0 "$SERVER_PID" 2>/dev/null; then
    echo "# Server failed to start" >&2
    cat "$BATS_TMPDIR/server.log" >&3
  fi
  echo "# Started OpenSSL server on PID ${SERVER_PID}" >&3

  export SERVER_PID
}

@test "LEGACY rejects deprecated TLS versions" {
    update-crypto-policies --set LEGACY > /dev/null
    run openssl s_client -connect localhost:4433 < /dev/null
    [ "$status" -ne 0 ]
}

@test "DEFAULT rejects deprecated TLS versions" {
    update-crypto-policies --set DEFAULT > /dev/null
    run openssl s_client -connect localhost:4433 < /dev/null
    [ "$status" -ne 0 ]
}

@test "FUTURE rejects deprecated TLS versions" {
    update-crypto-policies --set FUTURE > /dev/null
    run openssl s_client -connect localhost:4433 < /dev/null
    [ "$status" -ne 0 ]
}

teardown_file() {
  echo "# Killed OpenSSL server on PID ${SERVER_PID}" >&3
  # Clean up server process
  if [[ -n "$SERVER_PID" ]]; then
    kill "$SERVER_PID" 2>/dev/null || true
    wait "$SERVER_PID" 2>/dev/null || true
  fi
}
