/* xoreos-tools - Tools to help with xoreos development
 *
 * xoreos-tools is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos-tools is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos-tools. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Game-specific NWScript information for The Witcher.
 */

#ifndef NWSCRIPT_GAME_WITCHER_H
#define NWSCRIPT_GAME_WITCHER_H

#include "src/nwscript/game.h"

namespace NWScript {

namespace Witcher {

static const char * const kEngineTypeNames[] = {
	"Effect", "Event", "Location", "Talent", "", "Mod"
};

static const char * const kFunctionNames[] = {
	/*   0 */ "Random",
	/*   1 */ "PrintString",
	/*   2 */ "PrintFloat",
	/*   3 */ "FloatToString",
	/*   4 */ "PrintInteger",
	/*   5 */ "PrintObject",
	/*   6 */ "AssignCommand",
	/*   7 */ "DelayCommand",
	/*   8 */ "ExecuteScript",
	/*   9 */ "ClearAllActions",
	/*  10 */ "SetFacing",
	/*  11 */ "SetCalendar",
	/*  12 */ "SetTime",
	/*  13 */ "GetCalendarYear",
	/*  14 */ "GetCalendarMonth",
	/*  15 */ "GetCalendarDay",
	/*  16 */ "GetTimeHour",
	/*  17 */ "GetTimeMinute",
	/*  18 */ "GetTimeSecond",
	/*  19 */ "GetTimeMillisecond",
	/*  20 */ "ActionRandomWalk",
	/*  21 */ "ActionMoveToLocation",
	/*  22 */ "ActionMoveToObject",
	/*  23 */ "ActionMoveAwayFromObject",
	/*  24 */ "GetArea",
	/*  25 */ "GetEnteringObject",
	/*  26 */ "GetExitingObject",
	/*  27 */ "GetPosition",
	/*  28 */ "GetFacing",
	/*  29 */ "GetItemPossessor",
	/*  30 */ "GetItemPossessedBy",
	/*  31 */ "CreateItemOnObject",
	/*  32 */ "ActionEquipItem",
	/*  33 */ "ActionUnequipItem",
	/*  34 */ "ActionPickUpItem",
	/*  35 */ "ActionPutDownItem",
	/*  36 */ "GetLastAttacker",
	/*  37 */ "ActionAttack",
	/*  38 */ "GetNearestCreature",
	/*  39 */ "ActionSpeakString",
	/*  40 */ "ActionPlayAnimation",
	/*  41 */ "GetDistanceToObject",
	/*  42 */ "GetIsObjectValid",
	/*  43 */ "ActionOpenDoor",
	/*  44 */ "ActionCloseDoor",
	/*  45 */ "SetCameraFacing",
	/*  46 */ "PlaySound",
	/*  47 */ "GetSpellTargetObject",
	/*  48 */ "ActionCastSpellAtObject",
	/*  49 */ "GetCurrentVitalityPoints",
	/*  50 */ "GetMaxVitalityPoints",
	/*  51 */ "GetLocalInt",
	/*  52 */ "GetLocalFloat",
	/*  53 */ "GetLocalString",
	/*  54 */ "GetLocalObject",
	/*  55 */ "SetLocalInt",
	/*  56 */ "SetLocalFloat",
	/*  57 */ "SetLocalString",
	/*  58 */ "SetLocalObject",
	/*  59 */ "GetStringLength",
	/*  60 */ "GetStringUpperCase",
	/*  61 */ "GetStringLowerCase",
	/*  62 */ "GetStringRight",
	/*  63 */ "GetStringLeft",
	/*  64 */ "InsertString",
	/*  65 */ "GetSubString",
	/*  66 */ "FindSubString",
	/*  67 */ "fabs",
	/*  68 */ "cos",
	/*  69 */ "sin",
	/*  70 */ "tan",
	/*  71 */ "acos",
	/*  72 */ "asin",
	/*  73 */ "atan",
	/*  74 */ "log",
	/*  75 */ "pow",
	/*  76 */ "sqrt",
	/*  77 */ "abs",
	/*  78 */ "EffectHeal",
	/*  79 */ "EffectDamage",
	/*  80 */ "GetCurrentScriptSpellID",
	/*  81 */ "GetNumRunningEffectsApplied",
	/*  82 */ "EffectResurrection",
	/*  83 */ "EffectSummonCreature",
	/*  84 */ "AddAbility",
	/*  85 */ "GetFirstEffect",
	/*  86 */ "GetNextEffect",
	/*  87 */ "RemoveEffect",
	/*  88 */ "GetIsEffectValid",
	/*  89 */ "GetEffectDurationType",
	/*  90 */ "GetEffectSubType",
	/*  91 */ "GetEffectCreator",
	/*  92 */ "IntToString",
	/*  93 */ "GetFirstObjectInArea",
	/*  94 */ "GetNextObjectInArea",
	/*  95 */ "d2",
	/*  96 */ "d3",
	/*  97 */ "d4",
	/*  98 */ "d6",
	/*  99 */ "d8",
	/* 100 */ "d10",
	/* 101 */ "d12",
	/* 102 */ "d20",
	/* 103 */ "d100",
	/* 104 */ "VectorMagnitude",
	/* 105 */ "GetPerceptionRange",
	/* 106 */ "GetObjectType",
	/* 107 */ "GetRacialType",
	/* 108 */ "AddRunningEffect",
	/* 109 */ "TalentItem",
	/* 110 */ "SetDoorUsable",
	/* 111 */ "RemoveRunningEffect",
	/* 112 */ "MagicalEffect",
	/* 113 */ "SupernaturalEffect",
	/* 114 */ "ExtraordinaryEffect",
	/* 115 */ "RemoveAbility",
	/* 116 */ "HasAbility",
	/* 117 */ "GetCurrentAttribute",
	/* 118 */ "AddSequenceAttack",
	/* 119 */ "AddAttackSequence",
	/* 120 */ "RemoveAttackSequence",
	/* 121 */ "RoundsToSeconds",
	/* 122 */ "HoursToSeconds",
	/* 123 */ "TurnsToSeconds",
	/* 124 */ "ApplyForce",
	/* 125 */ "TestDirectLine",
	/* 126 */ "GetIsAggressive",
	/* 127 */ "SetAllowAggressiveAttitude",
	/* 128 */ "GetFirstObjectInShape",
	/* 129 */ "GetNextObjectInShape",
	/* 130 */ "GetLastActionResult",
	/* 131 */ "SignalEvent",
	/* 132 */ "EventUserDefined",
	/* 133 */ "EffectDeath",
	/* 134 */ "EffectKnockdown",
	/* 135 */ "ActionGiveItem",
	/* 136 */ "ActionTakeItem",
	/* 137 */ "VectorNormalize",
	/* 138 */ "ReplaceSequenceAttack",
	/* 139 */ "GetAbilityScore",
	/* 140 */ "GetIsDead",
	/* 141 */ "PrintVector",
	/* 142 */ "Vector",
	/* 143 */ "SetFacingPoint",
	/* 144 */ "AngleToVector",
	/* 145 */ "VectorToAngle",
	/* 146 */ "GetCurrentEndurancePoints",
	/* 147 */ "GetMaxEndurancePoints",
	/* 148 */ "EffectParalyze",
	/* 149 */ "FindSpellByTypeAndLevel",
	/* 150 */ "EffectDeaf",
	/* 151 */ "GetDistanceBetween",
	/* 152 */ "SetLocalLocation",
	/* 153 */ "GetLocalLocation",
	/* 154 */ "EffectSleep",
	/* 155 */ "GetItemInSlot",
	/* 156 */ "EffectCharmed",
	/* 157 */ "EffectConfused",
	/* 158 */ "EffectFrightened",
	/* 159 */ "EffectDominated",
	/* 160 */ "EffectDazed",
	/* 161 */ "EffectStunned",
	/* 162 */ "SetCommandable",
	/* 163 */ "GetCommandable",
	/* 164 */ "EffectRegenerate",
	/* 165 */ "EffectMovementSpeedIncrease",
	/* 166 */ "GetHitDice",
	/* 167 */ "ActionForceFollowObject",
	/* 168 */ "GetTag",
	/* 169 */ "AddKnownSpell",
	/* 170 */ "GetEffectType",
	/* 171 */ "EffectAreaOfEffect",
	/* 172 */ "GetFactionEqual",
	/* 173 */ "ChangeFaction",
	/* 174 */ "GetIsListening",
	/* 175 */ "SetListening",
	/* 176 */ "SetListenPattern",
	/* 177 */ "TestStringAgainstPattern",
	/* 178 */ "GetMatchedSubstring",
	/* 179 */ "GetMatchedSubstringsCount",
	/* 180 */ "EffectVisualEffect",
	/* 181 */ "GetFactionWeakestMember",
	/* 182 */ "GetFactionStrongestMember",
	/* 183 */ "GetFactionMostDamagedMember",
	/* 184 */ "GetFactionLeastDamagedMember",
	/* 185 */ "GetFactionGold",
	/* 186 */ "GetStoryPhaseByNPC",
	/* 187 */ "SetPerceptionRangeType",
	/* 188 */ "GetCurrentNonLethalDamagePoints",
	/* 189 */ "GetFactionAverageLevel",
	/* 190 */ "GetFactionAverageXP",
	/* 191 */ "HasProfile",
	/* 192 */ "GetFactionWorstAC",
	/* 193 */ "GetFactionBestAC",
	/* 194 */ "ActionSit",
	/* 195 */ "GetListenPatternNumber",
	/* 196 */ "ActionJumpToObject",
	/* 197 */ "GetWaypointByTag",
	/* 198 */ "GetTransitionTarget",
	/* 199 */ "EffectLinkEffects",
	/* 200 */ "GetObjectByTag",
	/* 201 */ "ItemIsUnarmedCombatWeapon",
	/* 202 */ "ActionWait",
	/* 203 */ "SetAreaTransitionBMP",
	/* 204 */ "ActionStartConversation",
	/* 205 */ "ActionPauseConversation",
	/* 206 */ "ActionResumeConversation",
	/* 207 */ "SetHostileToEnemiesOf",
	/* 208 */ "GetStoryNPCObject",
	/* 209 */ "GetStoryNPC",
	/* 210 */ "GetSittingCreature",
	/* 211 */ "GetGoingToBeAttackedBy",
	/* 212 */ "RemoveKnownSpell",
	/* 213 */ "GetLocation",
	/* 214 */ "ActionJumpToLocation",
	/* 215 */ "Location",
	/* 216 */ "ApplyEffectAtLocation",
	/* 217 */ "GetIsPC",
	/* 218 */ "FeetToMeters",
	/* 219 */ "YardsToMeters",
	/* 220 */ "ApplyEffectToObject",
	/* 221 */ "SpeakString",
	/* 222 */ "GetSpellTargetLocation",
	/* 223 */ "GetPositionFromLocation",
	/* 224 */ "GetAreaFromLocation",
	/* 225 */ "GetFacingFromLocation",
	/* 226 */ "GetNearestCreatureToLocation",
	/* 227 */ "GetNearestObject",
	/* 228 */ "GetNearestObjectToLocation",
	/* 229 */ "GetNearestObjectByTag",
	/* 230 */ "IntToFloat",
	/* 231 */ "FloatToInt",
	/* 232 */ "StringToInt",
	/* 233 */ "StringToFloat",
	/* 234 */ "ActionCastSpellAtLocation",
	/* 235 */ "GetStoryPhase",
	/* 236 */ "GetSpawnSetSpawnPhase",
	/* 237 */ "GetStoryNPCSpawnPhase",
	/* 238 */ "GetPCSpeaker",
	/* 239 */ "GetStringByStrRef",
	/* 240 */ "ActionSpeakStringByStrRef",
	/* 241 */ "DestroyObject",
	/* 242 */ "GetModule",
	/* 243 */ "CreateObject",
	/* 244 */ "EventSpellCastAt",
	/* 245 */ "GetLastSpellCaster",
	/* 246 */ "GetLastSpell",
	/* 247 */ "GetUserDefinedEventNumber",
	/* 248 */ "GetSpellId",
	/* 249 */ "RandomName",
	/* 250 */ "GetSpellIntensity",
	/* 251 */ "RemoveEffectByType",
	/* 252 */ "EffectSilence",
	/* 253 */ "GetName",
	/* 254 */ "GetLastSpeaker",
	/* 255 */ "BeginConversation",
	/* 256 */ "GetLastPerceived",
	/* 257 */ "GetLastPerceptionHeard",
	/* 258 */ "GetLastPerceptionInaudible",
	/* 259 */ "GetLastPerceptionSeen",
	/* 260 */ "GetLastClosedBy",
	/* 261 */ "GetLastPerceptionVanished",
	/* 262 */ "GetFirstInPersistentObject",
	/* 263 */ "GetNextInPersistentObject",
	/* 264 */ "GetAreaOfEffectCreator",
	/* 265 */ "DeleteLocalInt",
	/* 266 */ "DeleteLocalFloat",
	/* 267 */ "DeleteLocalString",
	/* 268 */ "DeleteLocalObject",
	/* 269 */ "DeleteLocalLocation",
	/* 270 */ "EffectHaste",
	/* 271 */ "EffectSlow",
	/* 272 */ "ObjectToString",
	/* 273 */ "FindKnownSpellByTypeAndLevel",
	/* 274 */ "SetCurrentScriptSpellID",
	/* 275 */ "PrintError",
	/* 276 */ "GetEncounterActive",
	/* 277 */ "SetEncounterActive",
	/* 278 */ "GetEncounterSpawnsMax",
	/* 279 */ "SetEncounterSpawnsMax",
	/* 280 */ "GetEncounterSpawnsCurrent",
	/* 281 */ "SetEncounterSpawnsCurrent",
	/* 282 */ "GetModuleItemAcquired",
	/* 283 */ "GetModuleItemAcquiredFrom",
	/* 284 */ "SetCustomToken",
	/* 285 */ "GetHasFeat",
	/* 286 */ "Mod",
	/* 287 */ "ActionUseFeat",
	/* 288 */ "ModAdd",
	/* 289 */ "GetObjectSeen",
	/* 290 */ "GetObjectHeard",
	/* 291 */ "GetLastPlayerDied",
	/* 292 */ "GetModuleItemLost",
	/* 293 */ "GetModuleItemLostBy",
	/* 294 */ "ActionDoCommand",
	/* 295 */ "EventConversation",
	/* 296 */ "SetEncounterDifficulty",
	/* 297 */ "GetEncounterDifficulty",
	/* 298 */ "GetDistanceBetweenLocations",
	/* 299 */ "EffectTemporaryEndurancePoints",
	/* 300 */ "PlayAnimation",
	/* 301 */ "TalentSpell",
	/* 302 */ "TalentFeat",
	/* 303 */ "ModToFloat",
	/* 304 */ "GetHasSpellEffect",
	/* 305 */ "GetEffectSpellId",
	/* 306 */ "GetCreatureHasTalent",
	/* 307 */ "GetCreatureTalentRandom",
	/* 308 */ "GetCreatureTalentBest",
	/* 309 */ "ActionUseTalentOnObject",
	/* 310 */ "ActionUseTalentAtLocation",
	/* 311 */ "GetGoldPieceValue",
	/* 312 */ "GetIsPlayableRacialType",
	/* 313 */ "JumpToLocation",
	/* 314 */ "EffectTemporaryVitalityPoints",
	/* 315 */ "SetCurrentVitalityPoints",
	/* 316 */ "GetAttackTarget",
	/* 317 */ "IsCurrentActionSitting",
	/* 318 */ "_TriggerOnWitness",
	/* 319 */ "GetMaster",
	/* 320 */ "GetIsInCombat",
	/* 321 */ "GetLastAssociateCommand",
	/* 322 */ "GiveGoldToCreature",
	/* 323 */ "SetIsDestroyable",
	/* 324 */ "SetLocked",
	/* 325 */ "GetLocked",
	/* 326 */ "GetClickingObject",
	/* 327 */ "SetAssociateListenPatterns",
	/* 328 */ "GetLastWeaponUsed",
	/* 329 */ "ActionInteractObject",
	/* 330 */ "GetLastUsedBy",
	/* 331 */ "GetLevel",
	/* 332 */ "GetIdentified",
	/* 333 */ "SetIdentified",
	/* 334 */ "SummonAnimalCompanion",
	/* 335 */ "SummonFamiliar",
	/* 336 */ "GetBlockingDoor",
	/* 337 */ "GetIsDoorActionPossible",
	/* 338 */ "DoDoorAction",
	/* 339 */ "GetFirstItemInInventory",
	/* 340 */ "GetNextItemInInventory",
	/* 341 */ "SetCurrentEndurancePoints",
	/* 342 */ "GetCurrentDrunkState",
	/* 343 */ "SetCurrentDrunkState",
	/* 344 */ "GetDamageDealtByMedium",
	/* 345 */ "GetTotalDamageDealt",
	/* 346 */ "GetLastDamager",
	/* 347 */ "GetLastDisarmed",
	/* 348 */ "GetLastDisturbed",
	/* 349 */ "GetLastLocked",
	/* 350 */ "GetLastUnlocked",
	/* 351 */ "BroadcastUserDefinedEvent",
	/* 352 */ "GetInventoryDisturbType",
	/* 353 */ "GetInventoryDisturbItem",
	/* 354 */ "GetHenchman",
	/* 355 */ "GetCurrentToxicity",
	/* 356 */ "VersusRacialTypeEffect",
	/* 357 */ "VersusTrapEffect",
	/* 358 */ "GetGender",
	/* 359 */ "GetIsTalentValid",
	/* 360 */ "ActionMoveAwayFromLocation",
	/* 361 */ "GetAttemptedAttackTarget",
	/* 362 */ "GetTypeFromTalent",
	/* 363 */ "GetIdFromTalent",
	/* 364 */ "GetAssociate",
	/* 365 */ "AddHenchman",
	/* 366 */ "RemoveHenchman",
	/* 367 */ "AddJournalEntry",
	/* 368 */ "HasJournalEntry",
	/* 369 */ "GetPCPublicCDKey",
	/* 370 */ "GetPCIPAddress",
	/* 371 */ "GetPCPlayerName",
	/* 372 */ "SetPCLike",
	/* 373 */ "SetPCDislike",
	/* 374 */ "SendMessageToPC",
	/* 375 */ "GetAttemptedSpellTarget",
	/* 376 */ "GetLastOpenedBy",
	/* 377 */ "GetHasSpell",
	/* 378 */ "OpenStore",
	/* 379 */ "EffectTurned",
	/* 380 */ "GetFirstFactionMember",
	/* 381 */ "GetNextFactionMember",
	/* 382 */ "ActionForceMoveToLocation",
	/* 383 */ "ActionForceMoveToObject",
	/* 384 */ "GetEnemyProfile",
	/* 385 */ "JumpToObject",
	/* 386 */ "SetMapPinEnabled",
	/* 387 */ "EffectHitPointChangeWhenDying",
	/* 388 */ "PopUpGUIPanel",
	/* 389 */ "GetIsUsingActionPoint",
	/* 390 */ "GetCurrentActionName",
	/* 391 */ "GetMonsterNPCObject",
	/* 392 */ "GetMonsterNPC",
	/* 393 */ "GiveXPToCreature",
	/* 394 */ "SetXP",
	/* 395 */ "GetXP",
	/* 396 */ "IntToHexString",
	/* 397 */ "GetBaseItemType",
	/* 398 */ "GetItemHasItemProperty",
	/* 399 */ "ActionEquipMostDamagingMelee",
	/* 400 */ "ActionEquipMostDamagingRanged",
	/* 401 */ "GetAnimation",
	/* 402 */ "ActionRest",
	/* 403 */ "ExploreAreaForPlayer",
	/* 404 */ "ActionEquipMostEffectiveArmor",
	/* 405 */ "GetIsDay",
	/* 406 */ "GetIsNight",
	/* 407 */ "GetIsDawn",
	/* 408 */ "GetIsDusk",
	/* 409 */ "GetIsEncounterCreature",
	/* 410 */ "GetLastPlayerDying",
	/* 411 */ "GetStartingLocation",
	/* 412 */ "ChangeToStandardFaction",
	/* 413 */ "SoundObjectPlay",
	/* 414 */ "SoundObjectStop",
	/* 415 */ "SoundObjectSetVolume",
	/* 416 */ "SoundObjectSetPosition",
	/* 417 */ "SpeakOneLinerConversation",
	/* 418 */ "GetGold",
	/* 419 */ "GetLastRespawnButtonPresser",
	/* 420 */ "GetIsDM",
	/* 421 */ "PlayVoiceChat",
	/* 422 */ "GetIsWeaponEffective",
	/* 423 */ "GetLastSpellHarmful",
	/* 424 */ "EventActivateItem",
	/* 425 */ "MusicBackgroundPlay",
	/* 426 */ "MusicBackgroundStop",
	/* 427 */ "MusicBackgroundSetDelay",
	/* 428 */ "MusicBackgroundChangeDay",
	/* 429 */ "MusicBackgroundChangeNight",
	/* 430 */ "MusicBattlePlay",
	/* 431 */ "MusicBattleStop",
	/* 432 */ "MusicBattleChange",
	/* 433 */ "AmbientSoundPlay",
	/* 434 */ "AmbientSoundStop",
	/* 435 */ "AmbientSoundChangeDay",
	/* 436 */ "AmbientSoundChangeNight",
	/* 437 */ "GetLastKiller",
	/* 438 */ "GetSpellCastItem",
	/* 439 */ "GetItemActivated",
	/* 440 */ "GetItemActivator",
	/* 441 */ "GetItemActivatedTargetLocation",
	/* 442 */ "GetItemActivatedTarget",
	/* 443 */ "GetIsOpen",
	/* 444 */ "TakeGoldFromCreature",
	/* 445 */ "IsInConversation",
	/* 446 */ "EnableSequenceJumps",
	/* 447 */ "SetupSpellTrigger",
	/* 448 */ "GetLastTriggerSpellEnergy",
	/* 449 */ "GetLastTriggerSpellID",
	/* 450 */ "GetCurrentGamePhase",
	/* 451 */ "EffectMovementSpeedDecrease",
	/* 452 */ "SetCurrentGamePhase",
	/* 453 */ "IsQuestCompleted",
	/* 454 */ "GetQuestCurrentPhaseIndex",
	/* 455 */ "GetPlotFlag",
	/* 456 */ "SetPlotFlag",
	/* 457 */ "EffectInvisibility",
	/* 458 */ "GetQuestPhaseIndex",
	/* 459 */ "EffectDarkness",
	/* 460 */ "CompareGamePhases",
	/* 461 */ "SetStoryNPCStoryPhase",
	/* 462 */ "SetCurrentToxicity",
	/* 463 */ "EffectPolymorph",
	/* 464 */ "SetItemModelPart",
	/* 465 */ "EffectTrueSeeing",
	/* 466 */ "EffectSeeInvisible",
	/* 467 */ "EffectTimeStop",
	/* 468 */ "EffectBlindness",
	/* 469 */ "_ClearPersonalAttitude",
	/* 470 */ "GetIsObjectVisible",
	/* 471 */ "CompareTags",
	/* 472 */ "ActionReady",
	/* 473 */ "EnableSpawnPhase",
	/* 474 */ "ActivatePortal",
	/* 475 */ "GetNumStackedItems",
	/* 476 */ "GetValueFromSettings_Float",
	/* 477 */ "SetConversationResponse",
	/* 478 */ "GetLastJoiningItem",
	/* 479 */ "GetCreatureSize",
	/* 480 */ "EffectDisappearAppear",
	/* 481 */ "EffectDisappear",
	/* 482 */ "EffectAppear",
	/* 483 */ "GetCurrentToxinCapacity",
	/* 484 */ "SetCurrentToxinCapacity",
	/* 485 */ "GetTimeFromLastHeartbeat",
	/* 486 */ "GetLastTrapDetected",
	/* 487 */ "GetConversationResponse",
	/* 488 */ "GetNearestTrapToObject",
	/* 489 */ "SetTag",
	/* 490 */ "SetName",
	/* 491 */ "HasSequenceForWeapon",
	/* 492 */ "PlayCutscene",
	/* 493 */ "SetAttackSequence",
	/* 494 */ "GetCurrentWeather",
	/* 495 */ "GetAge",
	/* 496 */ "GetMovementRate",
	/* 497 */ "GetAnimalCompanionCreatureType",
	/* 498 */ "GetFamiliarCreatureType",
	/* 499 */ "GetAnimalCompanionName",
	/* 500 */ "GetFamiliarName",
	/* 501 */ "ActionCastFakeSpellAtObject",
	/* 502 */ "ActionCastFakeSpellAtLocation",
	/* 503 */ "RemoveSummonedAssociate",
	/* 504 */ "GetPlaceableState",
	/* 505 */ "GetIsResting",
	/* 506 */ "GetLastPCRested",
	/* 507 */ "SetWeather",
	/* 508 */ "GetLastRestEventType",
	/* 509 */ "StartNewModule",
	/* 510 */ "HasOppositeProfileTo",
	/* 511 */ "GetWeaponRanged",
	/* 512 */ "DoSinglePlayerAutoSave",
	/* 513 */ "GetGameDifficulty",
	/* 514 */ "GetDialogActionParam",
	/* 515 */ "PlayVoiceSetVoiceOfTag",
	/* 516 */ "SoundObjectPlayWithFade",
	/* 517 */ "SoundObjectStopWithFade",
	/* 518 */ "IsSphereVisibleOnClient",
	/* 519 */ "GetLastGiftItem",
	/* 520 */ "OpenPlayerGoldPanel",
	/* 521 */ "SetPanelButtonFlash",
	/* 522 */ "GetCurrentAction",
	/* 523 */ "SetStandardFactionReputation",
	/* 524 */ "GetStandardFactionReputation",
	/* 525 */ "FloatingTextStrRefOnCreature",
	/* 526 */ "FloatingTextStringOnCreature",
	/* 527 */ "GetTrapDisarmable",
	/* 528 */ "GetTrapDetectable",
	/* 529 */ "GetTrapDetectedBy",
	/* 530 */ "GetTrapFlagged",
	/* 531 */ "GetTrapBaseType",
	/* 532 */ "GetTrapOneShot",
	/* 533 */ "GetTrapCreator",
	/* 534 */ "GetTrapKeyTag",
	/* 535 */ "GetTrapDisarmDC",
	/* 536 */ "GetTrapDetectDC",
	/* 537 */ "GetLockKeyRequired",
	/* 538 */ "GetLockKeyTag",
	/* 539 */ "GetLockLockable",
	/* 540 */ "GetLockUnlockDC",
	/* 541 */ "GetLockLockDC",
	/* 542 */ "GetPCLevellingUp",
	/* 543 */ "GetHasFeatEffect",
	/* 544 */ "SetPlaceableIllumination",
	/* 545 */ "GetPlaceableIllumination",
	/* 546 */ "GetIsPlaceableObjectActionPossible",
	/* 547 */ "DoPlaceableObjectAction",
	/* 548 */ "GetFirstPC",
	/* 549 */ "GetNextPC",
	/* 550 */ "SetTrapDetectedBy",
	/* 551 */ "GetIsTrapped",
	/* 552 */ "PreloadCreature",
	/* 553 */ "_SetProfile",
	/* 554 */ "PopUpDeathGUIPanel",
	/* 555 */ "SetTrapDisabled",
	/* 556 */ "GetLastHostileActor",
	/* 557 */ "ExportAllCharacters",
	/* 558 */ "MusicBackgroundGetDayTrack",
	/* 559 */ "MusicBackgroundGetNightTrack",
	/* 560 */ "WriteTimestampedLogEntry",
	/* 561 */ "GetModuleName",
	/* 562 */ "GetFactionLeader",
	/* 563 */ "SendMessageToAllDMs",
	/* 564 */ "EndGame",
	/* 565 */ "BootPC",
	/* 566 */ "RestartModule",
	/* 567 */ "AmbientSoundSetDayVolume",
	/* 568 */ "AmbientSoundSetNightVolume",
	/* 569 */ "MusicBackgroundGetBattleTrack",
	/* 570 */ "GetHasInventory",
	/* 571 */ "GetStrRefSoundDuration",
	/* 572 */ "GetAttitude",
	/* 573 */ "CreateVisualEffectAtLocation",
	/* 574 */ "MusicIncidentalPlay",
	/* 575 */ "MusicIncidentalStop",
	/* 576 */ "SetPerceptionUpdateInterval",
	/* 577 */ "GetAppearanceType",
	/* 578 */ "SpawnScriptDebugger",
	/* 579 */ "GetModuleItemAcquiredStackSize",
	/* 580 */ "BackupPersonalAttitudes",
	/* 581 */ "RestorePersonalAttitudes",
	/* 582 */ "GetResRef",
	/* 583 */ "EffectPetrify",
	/* 584 */ "CopyItem",
	/* 585 */ "EffectCutsceneParalyze",
	/* 586 */ "GetDroppableFlag",
	/* 587 */ "GetUseableFlag",
	/* 588 */ "GetStolenFlag",
	/* 589 */ "SetCampaignFloat",
	/* 590 */ "SetCampaignInt",
	/* 591 */ "SetCampaignVector",
	/* 592 */ "SetCampaignLocation",
	/* 593 */ "SetCampaignString",
	/* 594 */ "DestroyCampaignDatabase",
	/* 595 */ "GetCampaignFloat",
	/* 596 */ "GetCampaignInt",
	/* 597 */ "GetCampaignVector",
	/* 598 */ "GetCampaignLocation",
	/* 599 */ "GetCampaignString",
	/* 600 */ "CopyObject",
	/* 601 */ "DeleteCampaignVariable",
	/* 602 */ "StoreCampaignObject",
	/* 603 */ "RetrieveCampaignObject",
	/* 604 */ "EffectCutsceneDominated",
	/* 605 */ "GetItemStackSize",
	/* 606 */ "SetItemStackSize",
	/* 607 */ "GetItemCharges",
	/* 608 */ "SetItemCharges",
	/* 609 */ "AddItemProperty",
	/* 610 */ "RemoveItemProperty",
	/* 611 */ "GetIsItemPropertyValid",
	/* 612 */ "GetFirstItemProperty",
	/* 613 */ "GetNextItemProperty",
	/* 614 */ "GetItemPropertyType",
	/* 615 */ "GetItemPropertyDuration",
	/* 616 */ "GetLastBribeAmount",
	/* 617 */ "EnableStoryNPCActions",
	/* 618 */ "EffectPush",
	/* 619 */ "AddWeaponEffect",
	/* 620 */ "RemoveWeaponEffect",
	/* 621 */ "SetProtectionPoints",
	/* 622 */ "SetSpecialDistance",
	/* 623 */ "GetProtectionPoints",
	/* 624 */ "UnlockPlayerStoryBasedAbility",
	/* 625 */ "TerminateProtection",
	/* 626 */ "GetLastPerceptionEventType",
	/* 627 */ "GetLastPerceptionZone",
	/* 628 */ "GetIsItemOfType",
	/* 629 */ "GetIsAmmoForWeapon",
	/* 630 */ "ImmediateRest",
	/* 631 */ "DPrint",
	/* 632 */ "CreateVisualEffectAtCreature",
	/* 633 */ "GetIsAISystemEnabled",
	/* 634 */ "GetProfileName",
	/* 635 */ "GetNumPeacefulProfiles",
	/* 636 */ "SetPlaceableUsable",
	/* 637 */ "AddToCallstack",
	/* 638 */ "GetCallstackLine",
	/* 639 */ "GetCallstack",
	/* 640 */ "ChangePlaceableEffectPhase",
	/* 641 */ "_SetCallstackIdent",
	/* 642 */ "_AdjustCallstackIdent",
	/* 643 */ "HasSequence",
	/* 644 */ "GetCurrentSequenceId",
	/* 645 */ "SetCurrentSequenceId",
	/* 646 */ "GetIsWeaponRanged",
	/* 647 */ "NoOp",
	/* 648 */ "GetBattleMusicIdByCreature",
	/* 649 */ "GetSpecialDistance",
	/* 650 */ "CreateVisualEffectAtObject",
	/* 651 */ "DeleteVisualEffectFromObject",
	/* 652 */ "SetGiftMessages",
	/* 653 */ "HasTheSameAffiliations",
	/* 654 */ "IsAfraidOf",
	/* 655 */ "GetLastItemSold",
	/* 656 */ "CloseStoreAndInventory",
	/* 657 */ "GetNPCDialogByTags",
	/* 658 */ "GetDialogInterlocutorByTag",
	/* 659 */ "IsCutscenePlaying",
	/* 660 */ "SetPositionNearObject",
	/* 661 */ "StartMaterialEffect",
	/* 662 */ "StopMaterialEffect",
	/* 663 */ "BindEffectParamToObjectPosition",
	/* 664 */ "GetDialogFile",
	/* 665 */ "_UpdateIsInTrigger",
	/* 666 */ "HasJournalEntryConcerningObject",
	/* 667 */ "Meditate",
	/* 668 */ "GetCurrentWeatherIntensity",
	/* 669 */ "BackupAfraidOf",
	/* 670 */ "RestoreAfraidOf",
	/* 671 */ "SetAfraidOfAffiliations",
	/* 672 */ "GetProfileType",
	/* 673 */ "GetIsExcited",
	/* 674 */ "BindEffectParamToPartPosition",
	/* 675 */ "ForceUpdateMeleePositions",
	/* 676 */ "IsMeleePositionFree",
	/* 677 */ "CanPlotNPCRaiseFromDead",
	/* 678 */ "ProlongPlotNPCDeathEffect",
	/* 679 */ "AddTalents",
	/* 680 */ "CacheSequenceDistances",
	/* 681 */ "RevealWorldMapRegion",
	/* 682 */ "GetNearestAreaTransitionTarget",
	/* 683 */ "AlchemyLearnMixture",
	/* 684 */ "AlchemyLearnItem",
	/* 685 */ "AlchemyGetItemKnown",
	/* 686 */ "SetLockedAttackTarget",
	/* 687 */ "ScriptDecisionsTempOff",
	/* 688 */ "CanScriptDecideOfActions",
	/* 689 */ "IsTriggerEnabled",
	/* 690 */ "EnableTrigger",
	/* 691 */ "SpeakStringByStrRef",
	/* 692 */ "SetCutsceneMode",
	/* 693 */ "GetLastPCToCancelCutscene",
	/* 694 */ "GetDialogSoundLength",
	/* 695 */ "FadeFromBlack",
	/* 696 */ "FadeToBlack",
	/* 697 */ "StopFade",
	/* 698 */ "BlackScreen",
	/* 699 */ "GetBaseAttackBonus",
	/* 700 */ "SetImmortal",
	/* 701 */ "OpenPlayerInventory",
	/* 702 */ "StoreCameraFacing",
	/* 703 */ "RestoreCameraFacing",
	/* 704 */ "LevelUpHenchman",
	/* 705 */ "SetDroppableFlag",
	/* 706 */ "SetNeutralBumpable",
	/* 707 */ "GetModuleItemAcquiredBy",
	/* 708 */ "GetImmortal",
	/* 709 */ "_SetEmotionalSubstate",
	/* 710 */ "Get2DAString",
	/* 711 */ "GetMainProfile",
	/* 712 */ "GetAILevel",
	/* 713 */ "SetAILevel",
	/* 714 */ "GetIsPossessedFamiliar",
	/* 715 */ "UnpossessFamiliar",
	/* 716 */ "GetIsInside",
	/* 717 */ "SendMessageToPCByStrRef",
	/* 718 */ "IncrementRemainingFeatUses",
	/* 719 */ "ExportSingleCharacter",
	/* 720 */ "PlaySoundByStrRef",
	/* 721 */ "RunClientMacro",
	/* 722 */ "RunClientLua",
	/* 723 */ "EffectRunScript",
	/* 724 */ "SetEmotionalState",
	/* 725 */ "GetEffectScriptID",
	/* 726 */ "ForceEmotionalAnim",
	/* 727 */ "GetObjectById",
	/* 728 */ "TestDialogFlag",
	/* 729 */ "SetDialogFlagValue",
	/* 730 */ "GetDialogFlagValue",
	/* 731 */ "FindDialogFlagIndex",
	/* 732 */ "SetStartingStyleForWeaponType",
	/* 733 */ "GetBestSlotForWeapon",
	/* 734 */ "SetWaypointDesc",
	/* 735 */ "ActionJumpToModule",
	/* 736 */ "AddImpulse",
	/* 737 */ "_SetPersonalAttitude",
	/* 738 */ "GetPersonalAttitude",
	/* 739 */ "HasPersonalAttitude",
	/* 740 */ "_ClearPersonalAttitudeList",
	/* 741 */ "GetFirstNeighbourCreature",
	/* 742 */ "GetNextNeighbourCreature",
	/* 743 */ "SetSurroundingFlag",
	/* 744 */ "HasProfileByName",
	/* 745 */ "AddDialogActor",
	/* 746 */ "DespawnCreature",
	/* 747 */ "PreloadAreaModel",
	/* 748 */ "PostDialogCommand",
	/* 749 */ "GetCombatState",
	/* 750 */ "SetCombatState",
	/* 751 */ "GetCrowdActionParticipant",
	/* 752 */ "GetNPCDialog",
	/* 753 */ "ErrorExit",
	/* 754 */ "SetQueuedActionsInterruptable",
	/* 755 */ "_SetPauseState",
	/* 756 */ "See",
	/* 757 */ "_StackPopObject",
	/* 758 */ "FindNearestCreatures",
	/* 759 */ "_GetLastInternalEventId",
	/* 760 */ "_StackPopInteger",
	/* 761 */ "_StackPopFloat",
	/* 762 */ "HasEquipedMelee",
	/* 763 */ "HasEquipedRanged",
	/* 764 */ "GetIsFistfighter",
	/* 765 */ "SetMapPinActive",
	/* 766 */ "_FastSetInt",
	/* 767 */ "_FastGetInt",
	/* 768 */ "_FastSetObject",
	/* 769 */ "_FastGetObject",
	/* 770 */ "Assert",
	/* 771 */ "_FastSetFloat",
	/* 772 */ "_FastGetFloat",
	/* 773 */ "TriggerInternalEvent",
	/* 774 */ "GetNumGuardianTriggers",
	/* 775 */ "GetNumGuardianWaypoints",
	/* 776 */ "GetGuardianTrigger",
	/* 777 */ "GetGuardianWaypoint",
	/* 778 */ "SetIsInTrigger",
	/* 779 */ "GetIsInMyTriggers",
	/* 780 */ "SetPerceptionMultiplier",
	/* 781 */ "GetPerceptionMultiplier",
	/* 782 */ "SlotDlaTomka01",
	/* 783 */ "SlotDlaTomka02",
	/* 784 */ "SlotDlaTomka03",
	/* 785 */ "SlotDlaTomka04",
	/* 786 */ "HasAction",
	/* 787 */ "ForceMapOfAnotherArea",
	/* 788 */ "IsMapFullyLoaded",
	/* 789 */ "GetCreatureAppearance",
	/* 790 */ "SetCreatureAppearance",
	/* 791 */ "DontEnableNPCActionsAfterDialog",
	/* 792 */ "HasPhysics",
	/* 793 */ "WillBeOneLiner",
	/* 794 */ "SetCombatModeBaseDist",
	/* 795 */ "ActionTeleportAndTalk",
	/* 796 */ "PreDialogShot",
	/* 797 */ "EnterFistfightMode",
	/* 798 */ "LeaveFistfightMode",
	/* 799 */ "LoadAreaMap",
	/* 800 */ "SetDontEquipAnythingAfterDialog",
	/* 801 */ "EndFistfightKnockOutEffect",
	/* 802 */ "OpenPlayerBribePanel",
	/* 803 */ "GetBribeVariationValue",
	/* 804 */ "ResetXP",
	/* 805 */ "AddGreaseAbility",
	/* 806 */ "ClearGrease",
	/* 807 */ "Get2DARow",
	/* 808 */ "Get2DAInt",
	/* 809 */ "SlotDlaMichala5",
	/* 810 */ "SlotDlaMichala6",
	/* 811 */ "SlotDlaMichala7",
	/* 812 */ "SlotDlaMichala8",
	/* 813 */ "SlotDlaMichala9",
	/* 814 */ "Find5NearestCreatures",
	/* 815 */ "IsInInteractiveMode",
	/* 816 */ "SetMovementRate",
	/* 817 */ "EquipMelee",
	/* 818 */ "EquipRanged",
	/* 819 */ "CanImmobileAttackMelee",
	/* 820 */ "HasDialog",
	/* 821 */ "GetNumNearbyCreatures",
	/* 822 */ "_UpdatePassiveState",
	/* 823 */ "_SetIsPassiveAttacker",
	/* 824 */ "RandomFL",
	/* 825 */ "GetBestRainHideout",
	/* 826 */ "_DespawnBecouseOfRain",
	/* 827 */ "_IsDespawningBecouseOfRain",
	/* 828 */ "_GetLastExecutedScript",
	/* 829 */ "ResetQuestUpdateFlag",
	/* 830 */ "GetQuestUpdateFlag",
	/* 831 */ "IsActorInDialog",
	/* 832 */ "GetRandomLocationNearObject",
	/* 833 */ "CanPlayVoiceSetOfType",
	/* 834 */ "OpenPlayerBetPanel",
	/* 835 */ "IsAreaFullyLoadedOnClient",
	/* 836 */ "IsInInterior",
	/* 837 */ "_CanFindPath",
	/* 838 */ "_IsActionQueueEmpty",
	/* 839 */ "IsModuleSaveGame",
	/* 840 */ "GetRealMaxActiveAttackers",
	/* 841 */ "GetRealActiveAttackers",
	/* 842 */ "_UpdatePassiveAttackersList",
	/* 843 */ "HasVoiceOfTag",
	/* 844 */ "SetDialogOwner",
	/* 845 */ "ForceCharacterDevelopment",
	/* 846 */ "DisableCutsceneModeAfterDialog",
	/* 847 */ "EnableMusician"
};

static const VariableType kFunctionSignatures[][GameInfo::kMaxSignatureSize] = {
	/*   0 */ { kTypeInt, kTypeInt },
	/*   1 */ { kTypeVoid, kTypeString },
	/*   2 */ { kTypeVoid, kTypeFloat, kTypeInt, kTypeInt },
	/*   3 */ { kTypeString, kTypeFloat, kTypeInt, kTypeInt },
	/*   4 */ { kTypeVoid, kTypeInt },
	/*   5 */ { kTypeString, kTypeObject },
	/*   6 */ { kTypeVoid, kTypeObject, kTypeScriptState },
	/*   7 */ { kTypeVoid, kTypeFloat, kTypeScriptState },
	/*   8 */ { kTypeVoid, kTypeString, kTypeObject },
	/*   9 */ { kTypeVoid, kTypeInt, kTypeObject },
	/*  10 */ { kTypeVoid, kTypeFloat },
	/*  11 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/*  12 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  13 */ { kTypeInt },
	/*  14 */ { kTypeInt },
	/*  15 */ { kTypeInt },
	/*  16 */ { kTypeInt },
	/*  17 */ { kTypeInt },
	/*  18 */ { kTypeInt },
	/*  19 */ { kTypeInt },
	/*  20 */ { kTypeVoid },
	/*  21 */ { kTypeVoid, kTypeEngineType2, kTypeInt },
	/*  22 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  23 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  24 */ { kTypeObject, kTypeObject },
	/*  25 */ { kTypeObject },
	/*  26 */ { kTypeObject },
	/*  27 */ { kTypeVector, kTypeObject },
	/*  28 */ { kTypeFloat, kTypeObject },
	/*  29 */ { kTypeObject, kTypeObject },
	/*  30 */ { kTypeObject, kTypeObject, kTypeString },
	/*  31 */ { kTypeObject, kTypeString, kTypeObject, kTypeInt },
	/*  32 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  33 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  34 */ { kTypeVoid, kTypeObject },
	/*  35 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  36 */ { kTypeObject, kTypeObject },
	/*  37 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  38 */ { kTypeObject, kTypeInt, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  39 */ { kTypeVoid, kTypeString, kTypeInt },
	/*  40 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat },
	/*  41 */ { kTypeFloat, kTypeObject },
	/*  42 */ { kTypeInt, kTypeObject },
	/*  43 */ { kTypeVoid, kTypeObject },
	/*  44 */ { kTypeVoid, kTypeObject },
	/*  45 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeInt, kTypeInt },
	/*  46 */ { kTypeVoid, kTypeString, kTypeInt, kTypeFloat },
	/*  47 */ { kTypeObject },
	/*  48 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/*  49 */ { kTypeInt, kTypeObject },
	/*  50 */ { kTypeInt, kTypeObject },
	/*  51 */ { kTypeInt, kTypeObject, kTypeString },
	/*  52 */ { kTypeFloat, kTypeObject, kTypeString },
	/*  53 */ { kTypeString, kTypeObject, kTypeString },
	/*  54 */ { kTypeObject, kTypeObject, kTypeString },
	/*  55 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt },
	/*  56 */ { kTypeVoid, kTypeObject, kTypeString, kTypeFloat },
	/*  57 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString },
	/*  58 */ { kTypeVoid, kTypeObject, kTypeString, kTypeObject },
	/*  59 */ { kTypeInt, kTypeString },
	/*  60 */ { kTypeString, kTypeString },
	/*  61 */ { kTypeString, kTypeString },
	/*  62 */ { kTypeString, kTypeString, kTypeInt },
	/*  63 */ { kTypeString, kTypeString, kTypeInt },
	/*  64 */ { kTypeString, kTypeString, kTypeString, kTypeInt },
	/*  65 */ { kTypeString, kTypeString, kTypeInt, kTypeInt },
	/*  66 */ { kTypeInt, kTypeString, kTypeString },
	/*  67 */ { kTypeFloat, kTypeFloat },
	/*  68 */ { kTypeFloat, kTypeFloat },
	/*  69 */ { kTypeFloat, kTypeFloat },
	/*  70 */ { kTypeFloat, kTypeFloat },
	/*  71 */ { kTypeFloat, kTypeFloat },
	/*  72 */ { kTypeFloat, kTypeFloat },
	/*  73 */ { kTypeFloat, kTypeFloat },
	/*  74 */ { kTypeFloat, kTypeFloat },
	/*  75 */ { kTypeFloat, kTypeFloat, kTypeFloat },
	/*  76 */ { kTypeFloat, kTypeFloat },
	/*  77 */ { kTypeInt, kTypeInt },
	/*  78 */ { kTypeEngineType0, kTypeInt },
	/*  79 */ { kTypeEngineType0, kTypeFloat, kTypeFloat, kTypeFloat, kTypeString, kTypeInt, kTypeString },
	/*  80 */ { kTypeInt, kTypeObject },
	/*  81 */ { kTypeInt, kTypeObject, kTypeString, kTypeInt },
	/*  82 */ { kTypeEngineType0 },
	/*  83 */ { kTypeEngineType0, kTypeString, kTypeInt, kTypeFloat },
	/*  84 */ { kTypeInt, kTypeString, kTypeObject, kTypeInt, kTypeInt },
	/*  85 */ { kTypeEngineType0, kTypeObject },
	/*  86 */ { kTypeEngineType0, kTypeObject },
	/*  87 */ { kTypeVoid, kTypeObject, kTypeEngineType0 },
	/*  88 */ { kTypeInt, kTypeEngineType0 },
	/*  89 */ { kTypeInt, kTypeEngineType0 },
	/*  90 */ { kTypeInt, kTypeEngineType0 },
	/*  91 */ { kTypeObject, kTypeEngineType0 },
	/*  92 */ { kTypeString, kTypeInt },
	/*  93 */ { kTypeObject, kTypeObject },
	/*  94 */ { kTypeObject, kTypeObject },
	/*  95 */ { kTypeInt, kTypeInt },
	/*  96 */ { kTypeInt, kTypeInt },
	/*  97 */ { kTypeInt, kTypeInt },
	/*  98 */ { kTypeInt, kTypeInt },
	/*  99 */ { kTypeInt, kTypeInt },
	/* 100 */ { kTypeInt, kTypeInt },
	/* 101 */ { kTypeInt, kTypeInt },
	/* 102 */ { kTypeInt, kTypeInt },
	/* 103 */ { kTypeInt, kTypeInt },
	/* 104 */ { kTypeFloat, kTypeVector },
	/* 105 */ { kTypeFloat, kTypeInt, kTypeObject },
	/* 106 */ { kTypeInt, kTypeObject },
	/* 107 */ { kTypeInt, kTypeObject },
	/* 108 */ { kTypeInt, kTypeObject, kTypeString, kTypeInt, kTypeString, kTypeFloat, kTypeFloat, kTypeObject, kTypeString },
	/* 109 */ { kTypeEngineType3, kTypeObject },
	/* 110 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 111 */ { kTypeInt, kTypeObject, kTypeString, kTypeInt },
	/* 112 */ { kTypeEngineType0, kTypeEngineType0 },
	/* 113 */ { kTypeEngineType0, kTypeEngineType0 },
	/* 114 */ { kTypeEngineType0, kTypeEngineType0 },
	/* 115 */ { kTypeInt, kTypeString, kTypeObject },
	/* 116 */ { kTypeInt, kTypeString, kTypeObject },
	/* 117 */ { kTypeEngineType5, kTypeString, kTypeString, kTypeObject, kTypeObject },
	/* 118 */ { kTypeInt, kTypeString, kTypeInt, kTypeInt, kTypeString, kTypeObject },
	/* 119 */ { kTypeInt, kTypeString, kTypeString, kTypeString, kTypeObject },
	/* 120 */ { kTypeInt, kTypeString, kTypeObject },
	/* 121 */ { kTypeFloat, kTypeInt },
	/* 122 */ { kTypeFloat, kTypeInt },
	/* 123 */ { kTypeFloat, kTypeInt },
	/* 124 */ { kTypeVoid, kTypeObject, kTypeEngineType2, kTypeFloat, kTypeFloat, kTypeFloat },
	/* 125 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 126 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 127 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 128 */ { kTypeObject, kTypeInt, kTypeFloat, kTypeEngineType2, kTypeInt, kTypeInt, kTypeVector, kTypeFloat },
	/* 129 */ { kTypeObject, kTypeInt, kTypeFloat, kTypeEngineType2, kTypeInt, kTypeInt, kTypeVector, kTypeFloat },
	/* 130 */ { kTypeInt, kTypeObject },
	/* 131 */ { kTypeVoid, kTypeObject, kTypeEngineType1 },
	/* 132 */ { kTypeEngineType1, kTypeInt },
	/* 133 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 134 */ { kTypeEngineType0, kTypeObject },
	/* 135 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 136 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 137 */ { kTypeVector, kTypeVector },
	/* 138 */ { kTypeInt, kTypeString, kTypeString, kTypeString, kTypeObject },
	/* 139 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 140 */ { kTypeInt, kTypeObject },
	/* 141 */ { kTypeString, kTypeVector, kTypeInt },
	/* 142 */ { kTypeVector, kTypeFloat, kTypeFloat, kTypeFloat },
	/* 143 */ { kTypeVoid, kTypeVector },
	/* 144 */ { kTypeVector, kTypeFloat },
	/* 145 */ { kTypeFloat, kTypeVector },
	/* 146 */ { kTypeInt, kTypeObject },
	/* 147 */ { kTypeInt, kTypeObject },
	/* 148 */ { kTypeEngineType0 },
	/* 149 */ { kTypeInt, kTypeString, kTypeInt, kTypeInt },
	/* 150 */ { kTypeEngineType0 },
	/* 151 */ { kTypeFloat, kTypeObject, kTypeObject },
	/* 152 */ { kTypeVoid, kTypeObject, kTypeString, kTypeEngineType2 },
	/* 153 */ { kTypeEngineType2, kTypeObject, kTypeString },
	/* 154 */ { kTypeEngineType0 },
	/* 155 */ { kTypeObject, kTypeInt, kTypeObject },
	/* 156 */ { kTypeEngineType0 },
	/* 157 */ { kTypeEngineType0 },
	/* 158 */ { kTypeEngineType0 },
	/* 159 */ { kTypeEngineType0 },
	/* 160 */ { kTypeEngineType0 },
	/* 161 */ { kTypeEngineType0 },
	/* 162 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 163 */ { kTypeInt, kTypeObject },
	/* 164 */ { kTypeEngineType0, kTypeInt, kTypeFloat },
	/* 165 */ { kTypeEngineType0, kTypeInt },
	/* 166 */ { kTypeInt, kTypeObject },
	/* 167 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeInt },
	/* 168 */ { kTypeString, kTypeObject },
	/* 169 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 170 */ { kTypeInt, kTypeEngineType0 },
	/* 171 */ { kTypeEngineType0, kTypeInt, kTypeString, kTypeString, kTypeString },
	/* 172 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 173 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 174 */ { kTypeInt, kTypeObject },
	/* 175 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 176 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt },
	/* 177 */ { kTypeInt, kTypeString, kTypeString },
	/* 178 */ { kTypeString, kTypeInt },
	/* 179 */ { kTypeInt },
	/* 180 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 181 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 182 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 183 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 184 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 185 */ { kTypeInt, kTypeObject },
	/* 186 */ { kTypeString, kTypeString },
	/* 187 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 188 */ { kTypeInt, kTypeObject },
	/* 189 */ { kTypeInt, kTypeObject },
	/* 190 */ { kTypeInt, kTypeObject },
	/* 191 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 192 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 193 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 194 */ { kTypeVoid, kTypeObject },
	/* 195 */ { kTypeInt },
	/* 196 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 197 */ { kTypeObject, kTypeString },
	/* 198 */ { kTypeObject, kTypeObject },
	/* 199 */ { kTypeEngineType0, kTypeEngineType0, kTypeEngineType0 },
	/* 200 */ { kTypeObject, kTypeString, kTypeInt },
	/* 201 */ { kTypeInt, kTypeObject },
	/* 202 */ { kTypeVoid, kTypeFloat },
	/* 203 */ { kTypeVoid, kTypeInt, kTypeString },
	/* 204 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeInt, kTypeInt },
	/* 205 */ { kTypeVoid },
	/* 206 */ { kTypeVoid },
	/* 207 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 208 */ { kTypeObject, kTypeString },
	/* 209 */ { kTypeString, kTypeObject },
	/* 210 */ { kTypeObject, kTypeObject },
	/* 211 */ { kTypeObject, kTypeObject },
	/* 212 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 213 */ { kTypeEngineType2, kTypeObject },
	/* 214 */ { kTypeVoid, kTypeEngineType2 },
	/* 215 */ { kTypeEngineType2, kTypeObject, kTypeVector, kTypeFloat },
	/* 216 */ { kTypeVoid, kTypeInt, kTypeEngineType0, kTypeEngineType2, kTypeFloat },
	/* 217 */ { kTypeInt, kTypeObject },
	/* 218 */ { kTypeFloat, kTypeFloat },
	/* 219 */ { kTypeFloat, kTypeFloat },
	/* 220 */ { kTypeVoid, kTypeInt, kTypeEngineType0, kTypeObject, kTypeFloat, kTypeString, kTypeInt },
	/* 221 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 222 */ { kTypeEngineType2 },
	/* 223 */ { kTypeVector, kTypeEngineType2 },
	/* 224 */ { kTypeObject, kTypeEngineType2 },
	/* 225 */ { kTypeFloat, kTypeEngineType2 },
	/* 226 */ { kTypeObject, kTypeInt, kTypeInt, kTypeEngineType2, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 227 */ { kTypeObject, kTypeInt, kTypeObject, kTypeInt },
	/* 228 */ { kTypeObject, kTypeInt, kTypeEngineType2, kTypeInt },
	/* 229 */ { kTypeObject, kTypeString, kTypeObject, kTypeInt, kTypeInt },
	/* 230 */ { kTypeFloat, kTypeInt },
	/* 231 */ { kTypeInt, kTypeFloat },
	/* 232 */ { kTypeInt, kTypeString },
	/* 233 */ { kTypeFloat, kTypeString },
	/* 234 */ { kTypeVoid, kTypeInt, kTypeEngineType2, kTypeInt, kTypeInt, kTypeInt },
	/* 235 */ { kTypeString, kTypeObject },
	/* 236 */ { kTypeString, kTypeString },
	/* 237 */ { kTypeString, kTypeString },
	/* 238 */ { kTypeObject },
	/* 239 */ { kTypeString, kTypeInt, kTypeInt },
	/* 240 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 241 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 242 */ { kTypeObject },
	/* 243 */ { kTypeObject, kTypeInt, kTypeString, kTypeEngineType2, kTypeInt, kTypeString },
	/* 244 */ { kTypeEngineType1, kTypeObject, kTypeInt, kTypeInt },
	/* 245 */ { kTypeObject },
	/* 246 */ { kTypeInt },
	/* 247 */ { kTypeInt },
	/* 248 */ { kTypeInt },
	/* 249 */ { kTypeString },
	/* 250 */ { kTypeFloat, kTypeString, kTypeInt, kTypeInt, kTypeObject, kTypeObject },
	/* 251 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 252 */ { kTypeEngineType0 },
	/* 253 */ { kTypeString, kTypeObject },
	/* 254 */ { kTypeObject },
	/* 255 */ { kTypeInt, kTypeString, kTypeObject, kTypeObject },
	/* 256 */ { kTypeObject },
	/* 257 */ { kTypeInt },
	/* 258 */ { kTypeInt },
	/* 259 */ { kTypeInt },
	/* 260 */ { kTypeObject },
	/* 261 */ { kTypeInt },
	/* 262 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/* 263 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/* 264 */ { kTypeObject, kTypeObject },
	/* 265 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 266 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 267 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 268 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 269 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 270 */ { kTypeEngineType0 },
	/* 271 */ { kTypeEngineType0 },
	/* 272 */ { kTypeString, kTypeObject },
	/* 273 */ { kTypeInt, kTypeString, kTypeInt, kTypeInt, kTypeObject },
	/* 274 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 275 */ { kTypeVoid, kTypeString },
	/* 276 */ { kTypeInt, kTypeObject },
	/* 277 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 278 */ { kTypeInt, kTypeObject },
	/* 279 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 280 */ { kTypeInt, kTypeObject },
	/* 281 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 282 */ { kTypeObject },
	/* 283 */ { kTypeObject },
	/* 284 */ { kTypeVoid, kTypeInt, kTypeString },
	/* 285 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 286 */ { kTypeEngineType5, kTypeFloat, kTypeFloat },
	/* 287 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 288 */ { kTypeEngineType5, kTypeEngineType5, kTypeEngineType5 },
	/* 289 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 290 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 291 */ { kTypeObject },
	/* 292 */ { kTypeObject },
	/* 293 */ { kTypeObject },
	/* 294 */ { kTypeVoid, kTypeScriptState },
	/* 295 */ { kTypeEngineType1 },
	/* 296 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 297 */ { kTypeInt, kTypeObject },
	/* 298 */ { kTypeFloat, kTypeEngineType2, kTypeEngineType2 },
	/* 299 */ { kTypeEngineType0, kTypeInt },
	/* 300 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat },
	/* 301 */ { kTypeEngineType3, kTypeInt },
	/* 302 */ { kTypeEngineType3, kTypeInt },
	/* 303 */ { kTypeFloat, kTypeEngineType5 },
	/* 304 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 305 */ { kTypeInt, kTypeEngineType0 },
	/* 306 */ { kTypeInt, kTypeEngineType3, kTypeObject },
	/* 307 */ { kTypeEngineType3, kTypeInt, kTypeObject },
	/* 308 */ { kTypeEngineType3, kTypeInt, kTypeInt, kTypeObject },
	/* 309 */ { kTypeVoid, kTypeEngineType3, kTypeObject },
	/* 310 */ { kTypeVoid, kTypeEngineType3, kTypeEngineType2 },
	/* 311 */ { kTypeInt, kTypeObject },
	/* 312 */ { kTypeInt, kTypeObject },
	/* 313 */ { kTypeVoid, kTypeEngineType2 },
	/* 314 */ { kTypeEngineType0, kTypeInt },
	/* 315 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 316 */ { kTypeObject, kTypeObject },
	/* 317 */ { kTypeInt, kTypeObject },
	/* 318 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 319 */ { kTypeObject, kTypeObject },
	/* 320 */ { kTypeInt, kTypeObject },
	/* 321 */ { kTypeInt, kTypeObject },
	/* 322 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 323 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/* 324 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 325 */ { kTypeInt, kTypeObject },
	/* 326 */ { kTypeObject },
	/* 327 */ { kTypeVoid, kTypeObject },
	/* 328 */ { kTypeObject, kTypeObject },
	/* 329 */ { kTypeVoid, kTypeObject },
	/* 330 */ { kTypeObject },
	/* 331 */ { kTypeInt, kTypeObject },
	/* 332 */ { kTypeInt, kTypeObject },
	/* 333 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 334 */ { kTypeVoid, kTypeObject },
	/* 335 */ { kTypeVoid, kTypeObject },
	/* 336 */ { kTypeObject },
	/* 337 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 338 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 339 */ { kTypeObject, kTypeObject },
	/* 340 */ { kTypeObject, kTypeObject },
	/* 341 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 342 */ { kTypeInt, kTypeObject },
	/* 343 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 344 */ { kTypeInt, kTypeString },
	/* 345 */ { kTypeInt },
	/* 346 */ { kTypeObject },
	/* 347 */ { kTypeObject },
	/* 348 */ { kTypeObject },
	/* 349 */ { kTypeObject },
	/* 350 */ { kTypeObject },
	/* 351 */ { kTypeVoid, kTypeEngineType1, kTypeFloat },
	/* 352 */ { kTypeInt },
	/* 353 */ { kTypeObject },
	/* 354 */ { kTypeObject, kTypeObject },
	/* 355 */ { kTypeInt, kTypeObject },
	/* 356 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt },
	/* 357 */ { kTypeEngineType0, kTypeEngineType0 },
	/* 358 */ { kTypeInt, kTypeObject },
	/* 359 */ { kTypeInt, kTypeEngineType3 },
	/* 360 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeFloat },
	/* 361 */ { kTypeObject },
	/* 362 */ { kTypeInt, kTypeEngineType3 },
	/* 363 */ { kTypeInt, kTypeEngineType3 },
	/* 364 */ { kTypeObject, kTypeInt, kTypeObject },
	/* 365 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 366 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 367 */ { kTypeVoid, kTypeString, kTypeString },
	/* 368 */ { kTypeInt, kTypeString, kTypeString },
	/* 369 */ { kTypeString, kTypeObject },
	/* 370 */ { kTypeString, kTypeObject },
	/* 371 */ { kTypeString, kTypeObject },
	/* 372 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 373 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 374 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 375 */ { kTypeObject },
	/* 376 */ { kTypeObject },
	/* 377 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 378 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 379 */ { kTypeEngineType0 },
	/* 380 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 381 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 382 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeFloat },
	/* 383 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat, kTypeFloat },
	/* 384 */ { kTypeInt, kTypeInt },
	/* 385 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 386 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 387 */ { kTypeEngineType0, kTypeFloat },
	/* 388 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 389 */ { kTypeInt, kTypeObject },
	/* 390 */ { kTypeString, kTypeObject },
	/* 391 */ { kTypeObject, kTypeString },
	/* 392 */ { kTypeString, kTypeObject },
	/* 393 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 394 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 395 */ { kTypeInt, kTypeObject },
	/* 396 */ { kTypeString, kTypeInt },
	/* 397 */ { kTypeInt, kTypeObject },
	/* 398 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 399 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 400 */ { kTypeVoid, kTypeObject },
	/* 401 */ { kTypeInt, kTypeObject },
	/* 402 */ { kTypeVoid },
	/* 403 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 404 */ { kTypeVoid },
	/* 405 */ { kTypeInt },
	/* 406 */ { kTypeInt },
	/* 407 */ { kTypeInt },
	/* 408 */ { kTypeInt },
	/* 409 */ { kTypeInt, kTypeObject },
	/* 410 */ { kTypeObject },
	/* 411 */ { kTypeEngineType2 },
	/* 412 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 413 */ { kTypeVoid, kTypeObject },
	/* 414 */ { kTypeVoid, kTypeObject },
	/* 415 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 416 */ { kTypeVoid, kTypeObject, kTypeVector },
	/* 417 */ { kTypeVoid, kTypeString, kTypeObject },
	/* 418 */ { kTypeInt, kTypeObject },
	/* 419 */ { kTypeObject },
	/* 420 */ { kTypeInt, kTypeObject },
	/* 421 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 422 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 423 */ { kTypeInt },
	/* 424 */ { kTypeEngineType1, kTypeObject, kTypeEngineType2, kTypeObject },
	/* 425 */ { kTypeVoid, kTypeObject },
	/* 426 */ { kTypeVoid, kTypeObject },
	/* 427 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 428 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 429 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 430 */ { kTypeVoid, kTypeObject },
	/* 431 */ { kTypeVoid, kTypeObject },
	/* 432 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 433 */ { kTypeVoid, kTypeObject },
	/* 434 */ { kTypeVoid, kTypeObject },
	/* 435 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 436 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 437 */ { kTypeObject },
	/* 438 */ { kTypeObject },
	/* 439 */ { kTypeObject },
	/* 440 */ { kTypeObject },
	/* 441 */ { kTypeEngineType2 },
	/* 442 */ { kTypeObject },
	/* 443 */ { kTypeInt, kTypeObject },
	/* 444 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt },
	/* 445 */ { kTypeInt, kTypeObject },
	/* 446 */ { kTypeInt, kTypeString, kTypeInt, kTypeObject },
	/* 447 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeFloat, kTypeFloat, kTypeInt, kTypeString },
	/* 448 */ { kTypeFloat },
	/* 449 */ { kTypeInt },
	/* 450 */ { kTypeString },
	/* 451 */ { kTypeEngineType0, kTypeInt },
	/* 452 */ { kTypeVoid, kTypeString },
	/* 453 */ { kTypeInt, kTypeString },
	/* 454 */ { kTypeInt, kTypeString },
	/* 455 */ { kTypeInt, kTypeObject },
	/* 456 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 457 */ { kTypeEngineType0, kTypeInt },
	/* 458 */ { kTypeInt, kTypeString, kTypeString, kTypeString },
	/* 459 */ { kTypeEngineType0 },
	/* 460 */ { kTypeInt, kTypeString, kTypeString },
	/* 461 */ { kTypeVoid, kTypeString, kTypeString },
	/* 462 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 463 */ { kTypeEngineType0, kTypeInt },
	/* 464 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt, kTypeObject },
	/* 465 */ { kTypeEngineType0 },
	/* 466 */ { kTypeEngineType0 },
	/* 467 */ { kTypeEngineType0 },
	/* 468 */ { kTypeEngineType0 },
	/* 469 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 470 */ { kTypeInt, kTypeFloat, kTypeObject },
	/* 471 */ { kTypeInt, kTypeString, kTypeString, kTypeInt },
	/* 472 */ { kTypeVoid },
	/* 473 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 474 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeString, kTypeInt },
	/* 475 */ { kTypeInt, kTypeObject },
	/* 476 */ { kTypeFloat, kTypeString },
	/* 477 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeObject },
	/* 478 */ { kTypeObject, kTypeObject },
	/* 479 */ { kTypeInt, kTypeObject },
	/* 480 */ { kTypeEngineType0, kTypeEngineType2 },
	/* 481 */ { kTypeEngineType0 },
	/* 482 */ { kTypeEngineType0 },
	/* 483 */ { kTypeInt, kTypeObject },
	/* 484 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 485 */ { kTypeFloat, kTypeObject },
	/* 486 */ { kTypeObject, kTypeObject },
	/* 487 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 488 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 489 */ { kTypeVoid, kTypeString, kTypeObject },
	/* 490 */ { kTypeVoid, kTypeString, kTypeObject },
	/* 491 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 492 */ { kTypeVoid, kTypeString, kTypeString, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 493 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 494 */ { kTypeInt, kTypeObject },
	/* 495 */ { kTypeInt, kTypeObject },
	/* 496 */ { kTypeInt, kTypeObject },
	/* 497 */ { kTypeInt, kTypeObject },
	/* 498 */ { kTypeInt, kTypeObject },
	/* 499 */ { kTypeString, kTypeObject },
	/* 500 */ { kTypeString, kTypeObject },
	/* 501 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt },
	/* 502 */ { kTypeVoid, kTypeInt, kTypeEngineType2, kTypeInt },
	/* 503 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 504 */ { kTypeInt, kTypeObject },
	/* 505 */ { kTypeInt, kTypeObject },
	/* 506 */ { kTypeObject },
	/* 507 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 508 */ { kTypeInt },
	/* 509 */ { kTypeVoid, kTypeString },
	/* 510 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 511 */ { kTypeInt, kTypeObject },
	/* 512 */ { kTypeVoid },
	/* 513 */ { kTypeInt },
	/* 514 */ { kTypeString, kTypeInt, kTypeObject },
	/* 515 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 516 */ { kTypeVoid, kTypeObject },
	/* 517 */ { kTypeVoid, kTypeObject },
	/* 518 */ { kTypeInt, kTypeVector, kTypeFloat },
	/* 519 */ { kTypeObject, kTypeObject },
	/* 520 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 521 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 522 */ { kTypeInt, kTypeObject },
	/* 523 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeObject },
	/* 524 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 525 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt },
	/* 526 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt },
	/* 527 */ { kTypeInt, kTypeObject },
	/* 528 */ { kTypeInt, kTypeObject },
	/* 529 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 530 */ { kTypeInt, kTypeObject },
	/* 531 */ { kTypeInt, kTypeObject },
	/* 532 */ { kTypeInt, kTypeObject },
	/* 533 */ { kTypeObject, kTypeObject },
	/* 534 */ { kTypeString, kTypeObject },
	/* 535 */ { kTypeInt, kTypeObject },
	/* 536 */ { kTypeInt, kTypeObject },
	/* 537 */ { kTypeInt, kTypeObject },
	/* 538 */ { kTypeString, kTypeObject },
	/* 539 */ { kTypeInt, kTypeObject },
	/* 540 */ { kTypeInt, kTypeObject },
	/* 541 */ { kTypeInt, kTypeObject },
	/* 542 */ { kTypeObject },
	/* 543 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 544 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 545 */ { kTypeInt, kTypeObject },
	/* 546 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 547 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 548 */ { kTypeObject },
	/* 549 */ { kTypeObject },
	/* 550 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 551 */ { kTypeInt, kTypeObject },
	/* 552 */ { kTypeInt, kTypeString, kTypeObject },
	/* 553 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 554 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeString },
	/* 555 */ { kTypeVoid, kTypeObject },
	/* 556 */ { kTypeObject, kTypeObject },
	/* 557 */ { kTypeVoid },
	/* 558 */ { kTypeInt, kTypeObject },
	/* 559 */ { kTypeInt, kTypeObject },
	/* 560 */ { kTypeVoid, kTypeString },
	/* 561 */ { kTypeString },
	/* 562 */ { kTypeObject, kTypeObject },
	/* 563 */ { kTypeVoid, kTypeString },
	/* 564 */ { kTypeVoid, kTypeString },
	/* 565 */ { kTypeVoid, kTypeObject },
	/* 566 */ { kTypeVoid },
	/* 567 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 568 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 569 */ { kTypeInt, kTypeObject },
	/* 570 */ { kTypeInt, kTypeObject },
	/* 571 */ { kTypeFloat, kTypeInt },
	/* 572 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 573 */ { kTypeVoid, kTypeString, kTypeEngineType2 },
	/* 574 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 575 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 576 */ { kTypeVoid, kTypeInt },
	/* 577 */ { kTypeInt, kTypeObject },
	/* 578 */ { kTypeVoid },
	/* 579 */ { kTypeInt },
	/* 580 */ { kTypeVoid, kTypeObject },
	/* 581 */ { kTypeVoid, kTypeObject },
	/* 582 */ { kTypeString, kTypeObject },
	/* 583 */ { kTypeEngineType0 },
	/* 584 */ { kTypeObject, kTypeObject, kTypeObject },
	/* 585 */ { kTypeEngineType0 },
	/* 586 */ { kTypeInt, kTypeObject },
	/* 587 */ { kTypeInt, kTypeObject },
	/* 588 */ { kTypeInt, kTypeObject },
	/* 589 */ { kTypeVoid, kTypeString, kTypeString, kTypeFloat, kTypeObject },
	/* 590 */ { kTypeVoid, kTypeString, kTypeString, kTypeInt, kTypeObject },
	/* 591 */ { kTypeVoid, kTypeString, kTypeString, kTypeVector, kTypeObject },
	/* 592 */ { kTypeVoid, kTypeString, kTypeString, kTypeEngineType2, kTypeObject },
	/* 593 */ { kTypeVoid, kTypeString, kTypeString, kTypeString, kTypeObject },
	/* 594 */ { kTypeVoid, kTypeString },
	/* 595 */ { kTypeFloat, kTypeString, kTypeString, kTypeObject },
	/* 596 */ { kTypeInt, kTypeString, kTypeString, kTypeObject },
	/* 597 */ { kTypeVector, kTypeString, kTypeString, kTypeObject },
	/* 598 */ { kTypeEngineType2, kTypeString, kTypeString, kTypeObject },
	/* 599 */ { kTypeString, kTypeString, kTypeString, kTypeObject },
	/* 600 */ { kTypeObject, kTypeObject, kTypeEngineType2, kTypeObject, kTypeString },
	/* 601 */ { kTypeVoid, kTypeString, kTypeString, kTypeObject },
	/* 602 */ { kTypeInt, kTypeString, kTypeString, kTypeObject, kTypeObject },
	/* 603 */ { kTypeObject, kTypeString, kTypeString, kTypeEngineType2, kTypeObject, kTypeObject },
	/* 604 */ { kTypeEngineType0 },
	/* 605 */ { kTypeInt, kTypeObject },
	/* 606 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 607 */ { kTypeInt, kTypeObject },
	/* 608 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 609 */ { kTypeVoid },
	/* 610 */ { kTypeVoid },
	/* 611 */ { kTypeVoid },
	/* 612 */ { kTypeVoid },
	/* 613 */ { kTypeVoid },
	/* 614 */ { kTypeVoid },
	/* 615 */ { kTypeVoid },
	/* 616 */ { kTypeInt, kTypeObject },
	/* 617 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 618 */ { kTypeEngineType0, kTypeFloat },
	/* 619 */ { kTypeInt, kTypeString, kTypeInt, kTypeString, kTypeFloat, kTypeObject },
	/* 620 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 621 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeFloat, kTypeInt, kTypeString, kTypeInt },
	/* 622 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeObject },
	/* 623 */ { kTypeFloat, kTypeObject },
	/* 624 */ { kTypeVoid, kTypeString },
	/* 625 */ { kTypeVoid, kTypeObject },
	/* 626 */ { kTypeInt, kTypeObject },
	/* 627 */ { kTypeInt, kTypeObject },
	/* 628 */ { kTypeInt, kTypeString, kTypeObject },
	/* 629 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 630 */ { kTypeVoid, kTypeInt },
	/* 631 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 632 */ { kTypeVoid, kTypeString, kTypeString, kTypeObject, kTypeInt },
	/* 633 */ { kTypeInt, kTypeObject },
	/* 634 */ { kTypeString, kTypeInt },
	/* 635 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 636 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 637 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt },
	/* 638 */ { kTypeString, kTypeInt, kTypeObject },
	/* 639 */ { kTypeString, kTypeObject },
	/* 640 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 641 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 642 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 643 */ { kTypeInt, kTypeString, kTypeObject },
	/* 644 */ { kTypeString, kTypeObject },
	/* 645 */ { kTypeInt, kTypeString, kTypeObject },
	/* 646 */ { kTypeInt, kTypeObject },
	/* 647 */ { kTypeVoid },
	/* 648 */ { kTypeInt, kTypeObject },
	/* 649 */ { kTypeFloat, kTypeInt, kTypeObject },
	/* 650 */ { kTypeVoid, kTypeString, kTypeString, kTypeObject },
	/* 651 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt },
	/* 652 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt, kTypeObject },
	/* 653 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 654 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 655 */ { kTypeObject, kTypeObject },
	/* 656 */ { kTypeVoid, kTypeInt },
	/* 657 */ { kTypeString, kTypeString, kTypeString, kTypeString },
	/* 658 */ { kTypeString, kTypeString, kTypeString },
	/* 659 */ { kTypeInt },
	/* 660 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 661 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 662 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 663 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeObject, kTypeVector },
	/* 664 */ { kTypeString, kTypeObject },
	/* 665 */ { kTypeVoid, kTypeObject },
	/* 666 */ { kTypeInt, kTypeString, kTypeString },
	/* 667 */ { kTypeVoid, kTypeObject },
	/* 668 */ { kTypeInt, kTypeObject },
	/* 669 */ { kTypeVoid, kTypeObject },
	/* 670 */ { kTypeVoid, kTypeObject },
	/* 671 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 672 */ { kTypeInt, kTypeInt },
	/* 673 */ { kTypeInt, kTypeObject },
	/* 674 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeObject, kTypeString },
	/* 675 */ { kTypeVoid, kTypeObject },
	/* 676 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 677 */ { kTypeInt, kTypeObject },
	/* 678 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 679 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/* 680 */ { kTypeVoid, kTypeObject },
	/* 681 */ { kTypeVoid, kTypeInt },
	/* 682 */ { kTypeObject, kTypeObject },
	/* 683 */ { kTypeVoid, kTypeString },
	/* 684 */ { kTypeVoid, kTypeString },
	/* 685 */ { kTypeInt, kTypeObject },
	/* 686 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 687 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 688 */ { kTypeInt, kTypeObject },
	/* 689 */ { kTypeInt, kTypeObject },
	/* 690 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 691 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 692 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 693 */ { kTypeObject },
	/* 694 */ { kTypeFloat, kTypeInt },
	/* 695 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 696 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 697 */ { kTypeVoid, kTypeObject },
	/* 698 */ { kTypeVoid, kTypeObject },
	/* 699 */ { kTypeInt, kTypeObject },
	/* 700 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 701 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 702 */ { kTypeVoid },
	/* 703 */ { kTypeVoid },
	/* 704 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 705 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 706 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 707 */ { kTypeObject },
	/* 708 */ { kTypeInt, kTypeObject },
	/* 709 */ { kTypeVoid, kTypeString, kTypeInt, kTypeObject },
	/* 710 */ { kTypeString, kTypeString, kTypeString, kTypeInt },
	/* 711 */ { kTypeInt, kTypeObject },
	/* 712 */ { kTypeInt, kTypeObject },
	/* 713 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 714 */ { kTypeInt, kTypeObject },
	/* 715 */ { kTypeVoid, kTypeObject },
	/* 716 */ { kTypeVoid },
	/* 717 */ { kTypeVoid },
	/* 718 */ { kTypeVoid },
	/* 719 */ { kTypeVoid, kTypeObject },
	/* 720 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 721 */ { kTypeVoid, kTypeString },
	/* 722 */ { kTypeVoid, kTypeString },
	/* 723 */ { kTypeEngineType0, kTypeString, kTypeString, kTypeInt },
	/* 724 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 725 */ { kTypeInt, kTypeEngineType0 },
	/* 726 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt },
	/* 727 */ { kTypeObject, kTypeInt },
	/* 728 */ { kTypeInt, kTypeString, kTypeInt },
	/* 729 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 730 */ { kTypeInt, kTypeString },
	/* 731 */ { kTypeInt, kTypeString },
	/* 732 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 733 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 734 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 735 */ { kTypeVoid, kTypeObject, kTypeString, kTypeString, kTypeString },
	/* 736 */ { kTypeVoid, kTypeObject, kTypeVector },
	/* 737 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeObject },
	/* 738 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 739 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 740 */ { kTypeVoid, kTypeObject },
	/* 741 */ { kTypeObject, kTypeObject },
	/* 742 */ { kTypeObject, kTypeObject },
	/* 743 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 744 */ { kTypeInt, kTypeObject, kTypeString },
	/* 745 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 746 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 747 */ { kTypeInt, kTypeString },
	/* 748 */ { kTypeInt, kTypeScriptState, kTypeObject, kTypeInt },
	/* 749 */ { kTypeInt, kTypeObject },
	/* 750 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 751 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 752 */ { kTypeString, kTypeObject, kTypeString },
	/* 753 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 754 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 755 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/* 756 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 757 */ { kTypeObject },
	/* 758 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/* 759 */ { kTypeInt, kTypeObject },
	/* 760 */ { kTypeInt },
	/* 761 */ { kTypeFloat },
	/* 762 */ { kTypeInt, kTypeObject },
	/* 763 */ { kTypeInt, kTypeObject },
	/* 764 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 765 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 766 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 767 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 768 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeObject },
	/* 769 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 770 */ { kTypeVoid, kTypeString, kTypeInt, kTypeInt },
	/* 771 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/* 772 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 773 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeInt, kTypeObject, kTypeInt },
	/* 774 */ { kTypeInt, kTypeObject },
	/* 775 */ { kTypeInt, kTypeObject },
	/* 776 */ { kTypeObject, kTypeInt, kTypeObject, kTypeInt, kTypeObject },
	/* 777 */ { kTypeObject, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeObject },
	/* 778 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeObject },
	/* 779 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 780 */ { kTypeVoid, kTypeFloat, kTypeObject },
	/* 781 */ { kTypeFloat, kTypeObject },
	/* 782 */ { kTypeVoid },
	/* 783 */ { kTypeVoid },
	/* 784 */ { kTypeVoid },
	/* 785 */ { kTypeVoid },
	/* 786 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 787 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString },
	/* 788 */ { kTypeInt },
	/* 789 */ { kTypeInt, kTypeObject },
	/* 790 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 791 */ { kTypeVoid, kTypeObject },
	/* 792 */ { kTypeInt, kTypeObject },
	/* 793 */ { kTypeInt, kTypeObject, kTypeString },
	/* 794 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 795 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeString, kTypeString, kTypeString, kTypeObject, kTypeInt },
	/* 796 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 797 */ { kTypeVoid, kTypeObject },
	/* 798 */ { kTypeVoid, kTypeObject },
	/* 799 */ { kTypeVoid, kTypeString, kTypeString, kTypeString },
	/* 800 */ { kTypeVoid, kTypeObject },
	/* 801 */ { kTypeVoid, kTypeObject },
	/* 802 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 803 */ { kTypeInt, kTypeObject },
	/* 804 */ { kTypeVoid, kTypeObject },
	/* 805 */ { kTypeInt, kTypeString, kTypeObject, kTypeInt },
	/* 806 */ { kTypeVoid, kTypeObject },
	/* 807 */ { kTypeInt, kTypeString, kTypeString, kTypeInt },
	/* 808 */ { kTypeInt, kTypeString, kTypeString, kTypeInt },
	/* 809 */ { kTypeVoid },
	/* 810 */ { kTypeVoid },
	/* 811 */ { kTypeVoid },
	/* 812 */ { kTypeVoid },
	/* 813 */ { kTypeVoid },
	/* 814 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 815 */ { kTypeInt, kTypeObject },
	/* 816 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 817 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 818 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 819 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 820 */ { kTypeInt, kTypeObject },
	/* 821 */ { kTypeInt, kTypeFloat, kTypeInt, kTypeInt, kTypeObject },
	/* 822 */ { kTypeVoid, kTypeObject },
	/* 823 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 824 */ { kTypeFloat, kTypeFloat, kTypeFloat },
	/* 825 */ { kTypeObject, kTypeObject },
	/* 826 */ { kTypeVoid, kTypeObject },
	/* 827 */ { kTypeInt, kTypeObject },
	/* 828 */ { kTypeString },
	/* 829 */ { kTypeVoid },
	/* 830 */ { kTypeInt },
	/* 831 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 832 */ { kTypeEngineType2, kTypeFloat, kTypeObject, kTypeObject },
	/* 833 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 834 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 835 */ { kTypeInt, kTypeObject },
	/* 836 */ { kTypeInt, kTypeObject },
	/* 837 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 838 */ { kTypeInt, kTypeObject },
	/* 839 */ { kTypeInt },
	/* 840 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 841 */ { kTypeInt, kTypeObject },
	/* 842 */ { kTypeVoid, kTypeObject },
	/* 843 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 844 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 845 */ { kTypeVoid },
	/* 846 */ { kTypeVoid, kTypeInt },
	/* 847 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeObject, kTypeInt }
};

} // End of namespace Witcher

} // End of namespace NWScript

#endif // NWSCRIPT_GAME_WITCHER_H
