// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

#[cfg(feature = "v4_22")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
use crate::ReducedMotion;
use crate::{CssSection, StyleProvider, ffi};
#[cfg(feature = "v4_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
use crate::{InterfaceColorScheme, InterfaceContrast};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkCssProvider")]
    pub struct CssProvider(Object<ffi::GtkCssProvider, ffi::GtkCssProviderClass>) @implements StyleProvider;

    match fn {
        type_ => || ffi::gtk_css_provider_get_type(),
    }
}

impl CssProvider {
    #[doc(alias = "gtk_css_provider_new")]
    pub fn new() -> CssProvider {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_css_provider_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`CssProvider`] objects.
    ///
    /// This method returns an instance of [`CssProviderBuilder`](crate::builders::CssProviderBuilder) which can be used to create [`CssProvider`] objects.
    pub fn builder() -> CssProviderBuilder {
        CssProviderBuilder::new()
    }

    #[cfg(feature = "v4_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_12")))]
    #[doc(alias = "gtk_css_provider_load_from_bytes")]
    pub fn load_from_bytes(&self, data: &glib::Bytes) {
        unsafe {
            ffi::gtk_css_provider_load_from_bytes(self.to_glib_none().0, data.to_glib_none().0);
        }
    }

    #[cfg_attr(feature = "v4_12", deprecated = "Since 4.12")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_css_provider_load_from_data")]
    pub fn load_from_data(&self, data: &str) {
        let length = data.len() as _;
        unsafe {
            ffi::gtk_css_provider_load_from_data(
                self.to_glib_none().0,
                data.to_glib_none().0,
                length,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_load_from_file")]
    pub fn load_from_file(&self, file: &impl IsA<gio::File>) {
        unsafe {
            ffi::gtk_css_provider_load_from_file(
                self.to_glib_none().0,
                file.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_load_from_path")]
    pub fn load_from_path(&self, path: impl AsRef<std::path::Path>) {
        unsafe {
            ffi::gtk_css_provider_load_from_path(
                self.to_glib_none().0,
                path.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_load_from_resource")]
    pub fn load_from_resource(&self, resource_path: &str) {
        unsafe {
            ffi::gtk_css_provider_load_from_resource(
                self.to_glib_none().0,
                resource_path.to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v4_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_12")))]
    #[doc(alias = "gtk_css_provider_load_from_string")]
    pub fn load_from_string(&self, string: &str) {
        unsafe {
            ffi::gtk_css_provider_load_from_string(self.to_glib_none().0, string.to_glib_none().0);
        }
    }

    #[cfg_attr(feature = "v4_20", deprecated = "Since 4.20")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_css_provider_load_named")]
    pub fn load_named(&self, name: &str, variant: Option<&str>) {
        unsafe {
            ffi::gtk_css_provider_load_named(
                self.to_glib_none().0,
                name.to_glib_none().0,
                variant.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_to_string")]
    #[doc(alias = "to_string")]
    pub fn to_str(&self) -> glib::GString {
        unsafe { from_glib_full(ffi::gtk_css_provider_to_string(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "prefers-color-scheme")]
    pub fn prefers_color_scheme(&self) -> InterfaceColorScheme {
        ObjectExt::property(self, "prefers-color-scheme")
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "prefers-color-scheme")]
    pub fn set_prefers_color_scheme(&self, prefers_color_scheme: InterfaceColorScheme) {
        ObjectExt::set_property(self, "prefers-color-scheme", prefers_color_scheme)
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "prefers-contrast")]
    pub fn prefers_contrast(&self) -> InterfaceContrast {
        ObjectExt::property(self, "prefers-contrast")
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "prefers-contrast")]
    pub fn set_prefers_contrast(&self, prefers_contrast: InterfaceContrast) {
        ObjectExt::set_property(self, "prefers-contrast", prefers_contrast)
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "prefers-reduced-motion")]
    pub fn prefers_reduced_motion(&self) -> ReducedMotion {
        ObjectExt::property(self, "prefers-reduced-motion")
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "prefers-reduced-motion")]
    pub fn set_prefers_reduced_motion(&self, prefers_reduced_motion: ReducedMotion) {
        ObjectExt::set_property(self, "prefers-reduced-motion", prefers_reduced_motion)
    }

    #[doc(alias = "parsing-error")]
    pub fn connect_parsing_error<F: Fn(&Self, &CssSection, &glib::Error) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn parsing_error_trampoline<
            F: Fn(&CssProvider, &CssSection, &glib::Error) + 'static,
        >(
            this: *mut ffi::GtkCssProvider,
            section: *mut ffi::GtkCssSection,
            error: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    &from_glib_borrow(this),
                    &from_glib_borrow(section),
                    &from_glib_borrow(error),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"parsing-error".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    parsing_error_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "prefers-color-scheme")]
    pub fn connect_prefers_color_scheme_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_prefers_color_scheme_trampoline<
            F: Fn(&CssProvider) + 'static,
        >(
            this: *mut ffi::GtkCssProvider,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::prefers-color-scheme".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_prefers_color_scheme_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    #[doc(alias = "prefers-contrast")]
    pub fn connect_prefers_contrast_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_prefers_contrast_trampoline<F: Fn(&CssProvider) + 'static>(
            this: *mut ffi::GtkCssProvider,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::prefers-contrast".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_prefers_contrast_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    #[doc(alias = "prefers-reduced-motion")]
    pub fn connect_prefers_reduced_motion_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_prefers_reduced_motion_trampoline<
            F: Fn(&CssProvider) + 'static,
        >(
            this: *mut ffi::GtkCssProvider,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::prefers-reduced-motion".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_prefers_reduced_motion_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for CssProvider {
    fn default() -> Self {
        Self::new()
    }
}

impl std::fmt::Display for CssProvider {
    #[inline]
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        f.write_str(&self.to_str())
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`CssProvider`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CssProviderBuilder {
    builder: glib::object::ObjectBuilder<'static, CssProvider>,
}

impl CssProviderBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    pub fn prefers_color_scheme(self, prefers_color_scheme: InterfaceColorScheme) -> Self {
        Self {
            builder: self
                .builder
                .property("prefers-color-scheme", prefers_color_scheme),
        }
    }

    #[cfg(feature = "v4_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_20")))]
    pub fn prefers_contrast(self, prefers_contrast: InterfaceContrast) -> Self {
        Self {
            builder: self.builder.property("prefers-contrast", prefers_contrast),
        }
    }

    #[cfg(feature = "v4_22")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_22")))]
    pub fn prefers_reduced_motion(self, prefers_reduced_motion: ReducedMotion) -> Self {
        Self {
            builder: self
                .builder
                .property("prefers-reduced-motion", prefers_reduced_motion),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`CssProvider`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> CssProvider {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
