% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{site_data_dir}
\alias{site_data_dir}
\alias{site_config_dir}
\title{Path to shared data/config directories}
\usage{
site_data_dir(
  appname = NULL,
  appauthor = appname,
  version = NULL,
  multipath = FALSE,
  expand = TRUE,
  os = NULL
)

site_config_dir(
  appname = NULL,
  appauthor = appname,
  version = NULL,
  multipath = FALSE,
  expand = TRUE,
  os = NULL
)
}
\arguments{
\item{appname}{is the name of application. If NULL, just the system
directory is returned.}

\item{appauthor}{(only required and used on Windows) is the name of the
appauthor or distributing body for this application. Typically
it is the owning company name. This falls back to appname.}

\item{version}{is an optional version path element to append to the
path. You might want to use this if you want multiple versions
of your app to be able to run independently. If used, this
would typically be \code{"<major>.<minor>"}. Only applied when appname
is not NULL.}

\item{multipath}{is an optional parameter only applicable to *nix
which indicates that the entire list of data dirs should be returned
By default, the first directory is returned}

\item{expand}{If TRUE (the default) will expand the \code{R_LIBS} specifiers with their equivalents.
See \code{\link[=R_LIBS]{R_LIBS()}} for list of all possibly specifiers.}

\item{os}{Operating system whose conventions are used to construct the
requested directory. Possible values are "win", "mac", "unix". If \code{NULL}
(the default) then the current OS will be used.}
}
\description{
\code{site_data_dir} returns full path to the user-shared data dir for this application.
\code{site_config_dir} returns full path to the user-specific configuration directory for this application
which returns the same path as site data directory in Windows and Mac but a different one for Unix.
Typical user-shared data directories are:
}
\details{
\itemize{
\item Mac OS X:  \verb{/Library/Application Support/<AppName>}
\item Unix:      \verb{/usr/local/share:/usr/share/}
\item Win XP:    \verb{C:\\\\Documents and Settings\\\\All Users\\\\Application Data\\\\<AppAuthor>\\\\<AppName>}
\item Vista:     (Fail! \verb{C:\\\\ProgramData} is a hidden \emph{system} directory on Vista.)
\item Win 7:     \verb{C:\\\\ProgramData\\\\<AppAuthor>\\\\<AppName>}. Hidden, but writeable on Win 7.
}

Unix also specifies a separate location for user-shared configuration data in \env{$XDG_CONFIG_DIRS}.
\itemize{
\item Unix: \verb{/etc/xdg/<AppName>}, in \env{$XDG_CONFIG_HOME} if defined
}

For Unix, this returns the first default.  Set the \code{multipath=TRUE} to guarantee returning all directories.
}
\section{Warning}{

Do not use this on Windows. See the note above for why.
}

