# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.playwrighttesting import PlaywrightTestingMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-playwrighttesting
# USAGE
    python accounts_check_name_availability.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = PlaywrightTestingMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.accounts.check_name_availability(
        body={"name": "dummyName", "type": "Microsoft.AzurePlaywrightService/Accounts"},
    )
    print(response)


# x-ms-original-file: 2024-12-01/Accounts_CheckNameAvailability.json
if __name__ == "__main__":
    main()
