# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class BatchLoggingLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Log verbosity for batch inferencing.
    Increasing verbosity order for logging is : Warning, Info and Debug.
    The default value is Info.
    """

    INFO = "Info"
    WARNING = "Warning"
    DEBUG = "Debug"

class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class DatasetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    SIMPLE = "Simple"
    DATAFLOW = "Dataflow"

class InferenceDataInputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    DATASET_VERSION = "DatasetVersion"
    DATASET_ID = "DatasetId"
    DATA_URL = "DataUrl"

class InputDeliveryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the input data delivery mode.
    """

    READ_ONLY_MOUNT = "ReadOnlyMount"
    READ_WRITE_MOUNT = "ReadWriteMount"
    DOWNLOAD = "Download"
    DIRECT = "Direct"
    EVAL_MOUNT = "EvalMount"
    EVAL_DOWNLOAD = "EvalDownload"

class JobInputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the Job Input Type.
    """

    URI_FILE = "UriFile"
    URI_FOLDER = "UriFolder"
    ML_TABLE = "MLTable"
    LITERAL = "Literal"
    CUSTOM_MODEL = "CustomModel"
    ML_FLOW_MODEL = "MLFlowModel"
    TRITON_MODEL = "TritonModel"

class JobOutputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the Job Output Type.
    """

    URI_FILE = "UriFile"
    URI_FOLDER = "UriFolder"
    ML_TABLE = "MLTable"
    CUSTOM_MODEL = "CustomModel"
    ML_FLOW_MODEL = "MLFlowModel"
    TRITON_MODEL = "TritonModel"

class JobProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    IN_PROGRESS = "InProgress"

class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of a job.
    """

    NOT_STARTED = "NotStarted"
    STARTING = "Starting"
    PROVISIONING = "Provisioning"
    PREPARING = "Preparing"
    QUEUED = "Queued"
    RUNNING = "Running"
    FINALIZING = "Finalizing"
    CANCEL_REQUESTED = "CancelRequested"
    COMPLETED = "Completed"
    FAILED = "Failed"
    CANCELED = "Canceled"
    NOT_RESPONDING = "NotResponding"
    PAUSED = "Paused"
    UNKNOWN = "Unknown"

class OutputDeliveryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Output data delivery mode enums.
    """

    READ_WRITE_MOUNT = "ReadWriteMount"
    UPLOAD = "Upload"
