// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Generated by Fuzzlyn v2.2 on 2024-08-13 00:04:04
// Run on Arm64 MacOS
// Seed: 13207615092246842583-vectort,vector64,vector128,armadvsimd,armadvsimdarm64,armaes,armarmbase,armarmbasearm64,armcrc32,armcrc32arm64,armdp,armrdm,armrdmarm64,armsha1,armsha256
// Reduced from 226.8 KiB to 0.4 KiB in 00:02:12
// Debug: Outputs 1600094603
// Release: Outputs 1600094604
using System;
using System.Runtime.InteropServices;
using System.Runtime.Intrinsics.X86;
using Xunit;

public class Runtime_106338
{
    [Fact]
    [SkipOnMono("https://github.com/dotnet/runtime/issues/100368", TestPlatforms.Any)]
    public static void TestEntryPoint()
    {
        ulong vr10 = 16105307123914158031UL;
        float vr11 = 4294967295U | vr10;
        uint result = BitConverter.SingleToUInt32Bits(vr11);

        if ((RuntimeInformation.ProcessArchitecture == Architecture.Arm64) || ((RuntimeInformation.ProcessArchitecture == Architecture.X64) && Avx512F.IsSupported))
        {
            // Expected to cast ulong -> float directly
            Assert.Equal(1600094603U, result);
        }
        else
        {
            // Expected to cast ulong -> double -> float
            Assert.Equal(1600094604U, result);
        }
    }
}