#!/usr/bin/env bats
# Test to check if the bit-size used for openssl req is the one stated in the config.

. ./openssl/shared_config

get_config_size() {
    cat /etc/crypto-policies/back-ends/opensslcnf.config | grep -Po 'default_bits\s*=\s*\K\d+'
}

gen_and_outupt_key() {
    openssl req -new -nodes \
      -keyout "$BATS_TMPDIR/test.key" -out "$BATS_TMPDIR/request.csr" \
      -subj "/C=US/ST=CA/L=LA/O=MyOrg/CN=example.com"

    openssl rsa -in "$BATS_TMPDIR/test.key" -text -noout
}

@test "LEGACY req size is config req size" {
    update-crypto-policies --set LEGACY > /dev/null
    config_bits=$(get_config_size)
    echo "# ${config_bits} bits" >&3
    run gen_and_outupt_key
    # Omitting closing parenthesis since output may also
    # include the number of primes
    assert_output --partial "Private-Key: (${config_bits} bit"
}

@test "DEFAULT req size is config req size" {
    update-crypto-policies --set DEFAULT > /dev/null
    config_bits=$(get_config_size)
    echo "# ${config_bits} bits" >&3
    run gen_and_outupt_key
    # Omitting closing parenthesis since output may also
    # include the number of primes
    assert_output --partial "Private-Key: (${config_bits} bit"
}

@test "FUTURE req size is config req size" {
    update-crypto-policies --set FUTURE > /dev/null
    config_bits=$(get_config_size)
    run gen_and_outupt_key
    echo "# ${config_bits} bits" >&3
    # Omitting closing parenthesis since output may also
    # include the number of primes
    assert_output --partial "Private-Key: (${config_bits} bit"
}
