#!/usr/bin/env bats
# Test to check if the DEFAULT config settings match
# those shown by ssh and sshd.

setup_file() {
    update-crypto-policies --set DEFAULT
}

. ./openssh/shared

@test "DEFAULT policy: Client Ciphers match expected" {
    assert_client_ciphers
}
@test "DEFAULT policy: Client MACs match expected" {
    assert_client_macs
}
@test "DEFAULT policy: Client KEX match expected" {
    assert_client_kex
}
@test "DEFAULT policy: Client PubKey match expected" {
    assert_client_pubkey
}
@test "DEFAULT policy: Client GSSAPIKex match expected" {
    assert_client_gssapikex
}
@test "DEFAULT policy: Client HostBased match expected" {
    assert_client_hostbased
}
@test "DEFAULT policy: Client CASignature match expected" {
    assert_client_casignature
}
@test "DEFAULT policy: Client RSASize match expected" {
    assert_client_rsasize
}

@test "DEFAULT policy: Server Ciphers match expected" {
    assert_server_ciphers
}
@test "DEFAULT policy: Server MACs match expected" {
    assert_server_macs
}
@test "DEFAULT policy: Server KEX match expected" {
    assert_server_kex
}
@test "DEFAULT policy: Server PubKey match expected" {
    assert_server_pubkey
}
@test "DEFAULT policy: Server GSSAPIKex match expected" {
    assert_server_gssapikex
}
@test "DEFAULT policy: Server HostBased match expected" {
    assert_server_hostbased
}
@test "DEFAULT policy: Server CASignature match expected" {
    assert_server_casignature
}
@test "DEFAULT policy: Server RSASize match expected" {
    assert_server_rsasize
}

