/* SPDX-License-Identifier: GPL-2.0-only */

#include <memlayout.h>
#include <arch/header.ld>
#include <soc/memlayout.h>

SECTIONS
{
	AOPSRAM_START(0x0B000000)
	REGION(aop_code_ram, 0x0B000000, 0x80000, 4096)
	REGION(aop_data_ram, 0x0B0E0000, 0x20000, 4096)
	AOPSRAM_END(0x0B100000)

	SSRAM_START(0x14680000)
	OVERLAP_DECOMPRESSOR_VERSTAGE_ROMSTAGE(0x14680000, 112K)
	REGION(qcsdi, 0x1469E000, 55K, 4K)
	REGION(modem_id, 0x146ABD00, 4, 4)
	SSRAM_END(0x146AE000)

	BSRAM_START(0x14800000)
	REGION(pbl_timestamps, 0x14800000, 83K, 4K)
	WATCHDOG_TOMBSTONE(0x14814FFC, 4)
	BOOTBLOCK(0x14815000, 52K)
	TPM_LOG(0x14822000, 2K)
	PRERAM_CBFS_CACHE(0x14822800, 56K)
	PRERAM_CBMEM_CONSOLE(0x14830800, 32K)
	TIMESTAMP(0x14838800, 1K)
	TTB(0x14839000, 56K)
	STACK(0x14847000, 16K)
	VBOOT2_WORK(0x1484B000, 12K)
	DMA_COHERENT(0x1484E000, 8K)
	REGION(ddr_training, 0x14850000, 8K, 4K)
	REGION(qclib_serial_log, 0x14852000, 4K, 4K)
	REGION(ddr_information, 0x14853000, 1K, 1K)
	FMAP_CACHE(0x14853400, 2K)
	CBFS_MCACHE(0x14853C00, 8K)
	REGION(dcb, 0x1485b000, 16K, 4K)
	REGION(pmic, 0x1485f000, 48K, 4K)
	REGION(qclib, 0x1486b000, 596K, 4K)
	BSRAM_END(0x14900000)

	DRAM_START(0x80000000)
	/* Various hardware/software subsystems make use of this area */
	REGION(dram_aop,  0x80800000, 0x040000, 0x1000)
	REGION(dram_soc,  0x80900000, 0x200000, 0x1000)
	BL31(0x80B00000, 1M)
	REGION(dram_modem_wifi_only, 0x86000000, 32M, 4)
	REGION(dram_modem_extra, 0x88000000, 108M, 4)
	POSTRAM_CBFS_CACHE(0x9F800000, 16M)
	RAMSTAGE(0xA0800000, 16M)
}
