/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.VectorPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;

class VectorIterator<E>
extends VectorPointer<E>
implements Iterator<E> {
    private int blockIndex;
    private int lo;
    private final int endIndex;
    private int endLo;
    private boolean _hasNext;

    VectorIterator(int _startIndex, int _endIndex) {
        this.blockIndex = _startIndex & 0xFFFFFFE0;
        this.lo = _startIndex & 0x1F;
        this.endIndex = _endIndex;
        this.endLo = Math.min(this.endIndex - this.blockIndex, 32);
        this._hasNext = this.blockIndex + this.lo < this.endIndex;
    }

    @Override
    public boolean hasNext() {
        return this._hasNext;
    }

    @Override
    public E next() {
        if (!this._hasNext) {
            throw new NoSuchElementException("reached iterator end");
        }
        Object res = this.display0[this.lo];
        ++this.lo;
        if (this.lo == this.endLo) {
            if (this.blockIndex + this.lo < this.endIndex) {
                int newBlockIndex = this.blockIndex + 32;
                this.gotoNextBlockStart(newBlockIndex, this.blockIndex ^ newBlockIndex);
                this.blockIndex = newBlockIndex;
                this.endLo = Math.min(this.endIndex - this.blockIndex, 32);
                this.lo = 0;
            } else {
                this._hasNext = false;
            }
        }
        return (E)res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

