/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.core.component;

import java.util.Iterator;
import java.util.List;
import org.chefproject.core.NotificationAction;
import org.chefproject.core.User;
import org.chefproject.core.component.EmailNotification;
import org.chefproject.service.SecurityService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.SiteService;
import org.chefproject.util.StringUtil;
import org.w3c.dom.Element;

public class SiteEmailNotification
extends EmailNotification {
    protected String m_siteId = null;

    public SiteEmailNotification() {
    }

    public SiteEmailNotification(String from, String siteId, String subject, String message) {
        super(from, null, subject, message);
        this.m_siteId = siteId;
    }

    public void set(Element el) {
        super.set(el);
        this.m_siteId = StringUtil.trimToNull(el.getAttribute("site"));
    }

    public void set(NotificationAction other) {
        super.set(other);
        SiteEmailNotification eOther = (SiteEmailNotification)other;
        this.m_siteId = eOther.m_siteId;
    }

    public NotificationAction getClone() {
        SiteEmailNotification clone = new SiteEmailNotification();
        clone.set(this);
        return clone;
    }

    public void toXml(Element el) {
        super.toXml(el);
        if (this.m_siteId != null) {
            el.setAttribute("site", this.m_siteId);
        }
    }

    public String getTo() {
        List users = SecurityService.unlockUsers("site.visit", SiteService.siteReference(this.m_siteId));
        StringBuffer to = new StringBuffer();
        Iterator it = users.iterator();
        while (it.hasNext()) {
            User user = (User)it.next();
            to.append(user.getEmail());
            to.append(",");
        }
        return to.toString();
    }

    public String getHeaderTo() {
        return this.m_siteId + " <" + this.m_siteId + "@" + ServerConfigurationService.getServerName() + ">";
    }

    public String getReplyTo() {
        return this.getHeaderTo();
    }
}

