C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_x_m06.F 
C> The nwxcm_x_m06 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_x_m06 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_4} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_5} &=& \rho_\alpha^{{{5}\over{3}}}\\\\ 
C>   {\it t_6} &=& 9.115599744691192\,{\it t_5}\\\\ 
C>   {\it t_7} &=& {\it t_6}-2.0\,\tau_\alpha\\\\ 
C>   {\it t_8} &=& 2.0\,\tau_\alpha+{\it t_6}\\\\ 
C>   {\it t_9} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{12}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{13}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{17}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{18}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{19}} &=& {{2.0\,\tau_\alpha}\over{{\it t_5}}}
C>    -9.11559972\\\\ 
C>   {\it t_{20}} &=& 0.00186726\,{\it t_{19}}+0.00186726\,{\it t_2}
C>    \,\sigma_{\alpha\alpha}+1.0\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{22}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{23}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_{20}}^2}}\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{29}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{31}} &=& \rho_\beta^{{{5}\over{3}}}\\\\ 
C>   {\it t_{32}} &=& 9.115599744691192\,{\it t_{31}}\\\\ 
C>   {\it t_{33}} &=& {\it t_{32}}-2.0\,\tau_\beta\\\\ 
C>   {\it t_{34}} &=& 2.0\,\tau_\beta+{\it t_{32}}\\\\ 
C>   {\it t_{35}} &=& {{2.0\,\tau_\beta}\over{{\it t_{31}}}}
C>    -9.11559972\\\\ 
C>   {\it t_{36}} &=& 0.00186726\,{\it t_{35}}+0.00186726\,{
C>    \it t_{30}}\,\sigma_{\beta\beta}+1.0\\\\ 
C>   {\it t_{37}} &=& {{1}\over{{\it t_{36}}}}\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_{36}}^2}}\\\\ 
C>   {\it t_{39}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{41}} &=& \rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{42}} &=& 9.115599744691192\,{\it t_{41}}\\\\ 
C>   {\it t_{43}} &=& {\it t_{42}}-2.0\,\tau_s\\\\ 
C>   {\it t_{44}} &=& 2.0\,\tau_s+{\it t_{42}}\\\\ 
C>   {\it t_{45}} &=& {{2.0\,\tau_s}\over{{\it t_{41}}}}-9.11559972\\\\ 
C>   {\it t_{46}} &=& 0.00186726\,{\it t_{45}}+0.00186726\,{
C>    \it t_{40}}\,\sigma_{ss}+1.0\\\\ 
C>   {\it t_{47}} &=& {{1}\over{{\it t_{46}}}}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{{\it t_{46}}^2}}\\\\ 
C>   f &=& 1.0\,{\it t_{29}}\,{\it t_{37}}\,\left({\it t_{28}}\,{
C>    \it t_{35}}\,{\it t_{37}}+{\it t_{27}}\,{\it t_{30}}\,
C>    \sigma_{\beta\beta}\,{\it t_{37}}+{\it t_{26}}\,{\it t_{35}}^2
C>    \,{\it t_{38}}+{\it t_{25}}\,{\it t_{30}}\,\sigma_{\beta\beta}
C>    \,{\it t_{35}}\,{\it t_{38}}+{{{\it t_{23}}\,
C>    \sigma_{\beta\beta}^2\,{\it t_{38}}}
C>    \over{\rho_\beta^{{{16}\over{3}}}}}+{\it t_{22}}\right)
C>    -0.9305257363490997\,{\it t_{29}}\,
C>    \left({{0.003612186453650949\,{\it t_{30}}\,
C>    \sigma_{\beta\beta}}\over{0.00449276922095889\,{\it t_{30}}
C>    \,\sigma_{\beta\beta}+1.0}}+1.0\right)\,\left({{{\it t_{18}}
C>    \,{\it t_{33}}}\over{{\it t_{34}}}}+{{{\it t_{17}}\,{
C>    \it t_{33}}^2}\over{{\it t_{34}}^2}}+{{{\it t_{16}}\,{
C>    \it t_{33}}^3}\over{{\it t_{34}}^3}}+{{{\it t_{15}}\,{
C>    \it t_{33}}^4}\over{{\it t_{34}}^4}}+{{{\it t_{14}}\,{
C>    \it t_{33}}^5}\over{{\it t_{34}}^5}}+{{{\it t_{13}}\,{
C>    \it t_{33}}^6}\over{{\it t_{34}}^6}}+{{{\it t_{12}}\,{
C>    \it t_{33}}^7}\over{{\it t_{34}}^7}}+{{{\it t_{11}}\,{
C>    \it t_{33}}^8}\over{{\it t_{34}}^8}}+{{{\it t_{10}}\,{
C>    \it t_{33}}^9}\over{{\it t_{34}}^9}}+{{{\it t_9}\,{
C>    \it t_{33}}^{10}}\over{{\it t_{34}}^{10}}}+{{{\it t_4}\,{
C>    \it t_{33}}^{11}}\over{{\it t_{34}}^{11}}}+{\it t_3}\right)
C>    +1.0\,{\it t_1}\,{\it t_{21}}\,\left({\it t_{28}}\,{
C>    \it t_{19}}\,{\it t_{21}}+{\it t_{27}}\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{21}}+{\it t_{26}}\,{
C>    \it t_{19}}^2\,{\it t_{24}}+{\it t_{25}}\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{19}}\,{\it t_{24}}+{{{
C>    \it t_{23}}\,\sigma_{\alpha\alpha}^2\,{\it t_{24}}}
C>    \over{\rho_\alpha^{{{16}\over{3}}}}}+{\it t_{22}}\right)
C>    -0.9305257363490997\,{\it t_1}\,\left({{0.003612186453650949
C>    \,{\it t_2}\,\sigma_{\alpha\alpha}}\over{0.00449276922095889
C>    \,{\it t_2}\,\sigma_{\alpha\alpha}+1.0}}+1.0\right)\,
C>    \left({{{\it t_{18}}\,{\it t_7}}\over{{\it t_8}}}+{{{
C>    \it t_{17}}\,{\it t_7}^2}\over{{\it t_8}^2}}+{{{\it t_{16}}
C>    \,{\it t_7}^3}\over{{\it t_8}^3}}+{{{\it t_{15}}\,{
C>    \it t_7}^4}\over{{\it t_8}^4}}+{{{\it t_{14}}\,{
C>    \it t_7}^5}\over{{\it t_8}^5}}+{{{\it t_{13}}\,{
C>    \it t_7}^6}\over{{\it t_8}^6}}+{{{\it t_{12}}\,{
C>    \it t_7}^7}\over{{\it t_8}^7}}+{{{\it t_{11}}\,{
C>    \it t_7}^8}\over{{\it t_8}^8}}+{{{\it t_{10}}\,{
C>    \it t_7}^9}\over{{\it t_8}^9}}+{{{\it t_9}\,{
C>    \it t_7}^{10}}\over{{\it t_8}^{10}}}+{{{\it t_4}\,{
C>    \it t_7}^{11}}\over{{\it t_8}^{11}}}+{\it t_3}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,{\it t_{39}}\,{\it t_{47}}\,\left({\it t_{28}}\,{
C>    \it t_{45}}\,{\it t_{47}}+{\it t_{27}}\,{\it t_{40}}\,
C>    \sigma_{ss}\,{\it t_{47}}+{\it t_{26}}\,{\it t_{45}}^2\,{
C>    \it t_{48}}+{\it t_{25}}\,{\it t_{40}}\,\sigma_{ss}\,{
C>    \it t_{45}}\,{\it t_{48}}+{{{\it t_{23}}\,\sigma_{ss}^2\,{
C>    \it t_{48}}}\over{\rho_s^{{{16}\over{3}}}}}+{\it t_{22}}\right)
C>    -0.9305257363490997\,{\it t_{39}}\,
C>    \left({{0.003612186453650949\,{\it t_{40}}\,\sigma_{ss}}
C>    \over{0.00449276922095889\,{\it t_{40}}\,\sigma_{ss}+1.0}}
C>    +1.0\right)\,\left({{{\it t_{18}}\,{\it t_{43}}}\over{{
C>    \it t_{44}}}}+{{{\it t_{17}}\,{\it t_{43}}^2}\over{{
C>    \it t_{44}}^2}}+{{{\it t_{16}}\,{\it t_{43}}^3}\over{{
C>    \it t_{44}}^3}}+{{{\it t_{15}}\,{\it t_{43}}^4}\over{{
C>    \it t_{44}}^4}}+{{{\it t_{14}}\,{\it t_{43}}^5}\over{{
C>    \it t_{44}}^5}}+{{{\it t_{13}}\,{\it t_{43}}^6}\over{{
C>    \it t_{44}}^6}}+{{{\it t_{12}}\,{\it t_{43}}^7}\over{{
C>    \it t_{44}}^7}}+{{{\it t_{11}}\,{\it t_{43}}^8}\over{{
C>    \it t_{44}}^8}}+{{{\it t_{10}}\,{\it t_{43}}^9}\over{{
C>    \it t_{44}}^9}}+{{{\it t_9}\,{\it t_{43}}^{10}}\over{{
C>    \it t_{44}}^{10}}}+{{{\it t_4}\,{\it t_{43}}^{11}}\over{{
C>    \it t_{44}}^{11}}}+{\it t_3}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, DG Truhlar, J.Chem.Phys. 123, 194101 (2006)  , DOI: 
C> <a href="https://doi.org/10.1063/1.2370993 "> 
C> 10.1063/1.2370993 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_m06(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammaaa*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammaaa*t1*t3+1.0d+0
            t5 = rhoa**1.3333333333333333d+0
            t6 = param(18)
            t7 = rhoa**1.6666666666666669d+0
            t8 = 9.115599744691192d+0*t7
            t9 = t8-2.0d+0*taua
            t10 = t9**11
            t11 = 2.0d+0*taua+t8
            t12 = 1/t11**11
            t13 = param(17)
            t14 = t9**10
            t15 = 1/t11**10
            t16 = param(16)
            t17 = t9**9
            t18 = 1/t11**9
            t19 = param(15)
            t20 = t9**8
            t21 = 1/t11**8
            t22 = param(14)
            t23 = t9**7
            t24 = 1/t11**7
            t25 = param(13)
            t26 = t9**6
            t27 = 1/t11**6
            t28 = param(12)
            t29 = t9**5
            t30 = 1/t11**5
            t31 = param(11)
            t32 = t9**4
            t33 = 1/t11**4
            t34 = param(10)
            t35 = t9**3
            t36 = 1/t11**3
            t37 = param(9)
            t38 = t9**2
            t39 = 1/t11**2
            t40 = param(8)
            t41 = 1/t11
            t42 = t40*t41*t9+t10*t12*t6+t37*t38*t39+t34*t35*t36+t31*t32*
     1         t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19*t20*t21+t16*t
     2         17*t18+t13*t14*t15+param(7)
            t43 = 1/t7
            t44 = 2.0d+0*t43*taua-9.11559972d+0
            t45 = 1.86726d-3*t44+1.86726d-3*gammaaa*t1+1.0d+0
            t46 = 1/t45
            t47 = param(4)
            t48 = gammaaa**2
            t49 = 1/rhoa**5.333333333333333d+0
            t50 = 1/t45**2
            t51 = param(5)
            t52 = param(6)
            t53 = t44**2
            t54 = param(2)
            t55 = param(3)
            t56 = t44*t46*t55+gammaaa*t1*t46*t54+t50*t52*t53+gammaaa*t1*
     1         t44*t50*t51+t47*t48*t49*t50+param(1)
            t57 = rhoa**6.666666666666666d-1
            t58 = 1/t11**12
            t59 = rhoa**3.333333333333333d-1
            t60 = 1/t2**2
            t61 = 1/rhoa**6.333333333333333d+0
            t62 = 1/rhoa**3.6666666666666664d+0
            t63 = -6.2242d-3*t1*taua-4.9793599999999993d-3*gammaaa*t62
            t64 = 1/t45**3
            t65 = 1/rhoa**4.333333333333333d+0
            fnc(iq) = (2.0d+0*t46*t5*t56-1.8610514726981994d+0*t4*t42*t5
     1         )*wght+fnc(iq)
            Amat(iq,D1_RA) = (t46*(1.0d+0*t5*(-3.3333333333333337d+0*t1*
     1         t46*t55*taua-6.666666666666667d+0*t1*t44*t50*t52*taua-3.3
     2         333333333333337d+0*gammaaa*t49*t50*t51*taua-2*t52*t53*t63
     3         *t64-2*gammaaa*t1*t44*t51*t63*t64-2*t47*t48*t49*t63*t64-t
     4         44*t50*t55*t63-gammaaa*t1*t50*t54*t63-2.6666666666666666d
     5         +0*gammaaa*t46*t54*t62-2.6666666666666666d+0*gammaaa*t44*
     6         t50*t51*t62-5.333333333333333d+0*t47*t48*t50*t61)+1.33333
     7         33333333333d+0*t56*t59)-9.305257363490997d-1*t4*t5*(-1.51
     8         92666241151986d+1*t39*t40*t57*t9+3.038533248230397d+1*t37
     9         *t39*t57*t9-1.6711932865267184d+2*t10*t57*t58*t6+1.671193
     :         2865267184d+2*t12*t14*t57*t6+1.5192666241151986d+1*t40*t4
     ;         1*t57-3.038533248230397d+1*t36*t37*t38*t57+4.557799872345
     <         5965d+1*t34*t36*t38*t57-4.5577998723455965d+1*t33*t34*t35
     =         *t57+6.077066496460795d+1*t31*t33*t35*t57-6.0770664964607
     >         95d+1*t30*t31*t32*t57+7.596333120575993d+1*t28*t30*t32*t5
     ?         7-7.596333120575993d+1*t27*t28*t29*t57+9.115599744691193d
     @         +1*t25*t27*t29*t57-9.115599744691193d+1*t24*t25*t26*t57+1
     1         .0634866368806391d+2*t22*t24*t26*t57-1.0634866368806391d+
     2         2*t21*t22*t23*t57+1.2154132992921589d+2*t19*t21*t23*t57-1
     3         .2154132992921589d+2*t18*t19*t20*t57+1.3673399617036788d+
     4         2*t16*t18*t20*t57-1.3673399617036788d+2*t15*t16*t17*t57+1
     5         .5192666241151986d+2*t13*t15*t17*t57-1.5192666241151986d+
     6         2*t12*t13*t14*t57)-1.0d+0*t5*t50*t56*t63-9.30525736349099
     7         7d-1*t42*t5*(4.327658698487368d-5*t48*t60*t61-9.632497209
     8         735863d-3*gammaaa*t3*t62)-1.2407009817987995d+0*t4*t42*t5
     9         9)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (1.0d+0*t46*t5*(-3.73452d-3*t1*t52*t53*t64
     1         -3.73452d-3*gammaaa*t44*t49*t51*t64-3.73452d-3*t47*t48*t6
     2         4/rhoa**8-1.86726d-3*t1*t44*t50*t55-1.86726d-3*gammaaa*t4
     3         9*t50*t54+t1*t46*t54+t1*t44*t50*t51+2*gammaaa*t47*t49*t50
     4         )-9.305257363490997d-1*t42*t5*(3.6121864536509485d-3*t1*t
     5         3-1.6228720119327628d-5*gammaaa*t49*t60)-1.86726d-3*t50*t
     6         56/t5)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = (-9.305257363490997d-1*t4*t5*(-2.0d+0*t39*t
     1         40*t9-4.0d+0*t37*t39*t9-2.2d+1*t10*t58*t6-2.2d+1*t12*t14*
     2         t6-2.0d+0*t40*t41-4.0d+0*t36*t37*t38-6.0d+0*t34*t36*t38-6
     3         .0d+0*t33*t34*t35-8.0d+0*t31*t33*t35-8.0d+0*t30*t31*t32-1
     4         .0d+1*t28*t30*t32-1.0d+1*t27*t28*t29-1.2d+1*t25*t27*t29-1
     5         .2d+1*t24*t25*t26-1.4d+1*t22*t24*t26-1.4d+1*t21*t22*t23-1
     6         .6d+1*t19*t21*t23-1.6d+1*t18*t19*t20-1.8d+1*t16*t18*t20-1
     7         .8d+1*t15*t16*t17-2.0d+1*t13*t15*t17-2.0d+1*t12*t13*t14)+
     8         1.0d+0*t46*t5*(-7.46904d-3*gammaaa*t44*t51*t64*t65-3.7345
     9         2d-3*gammaaa*t50*t54*t65+2.0d+0*gammaaa*t50*t51*t65-7.469
     :         04d-3*t43*t52*t53*t64-7.46904d-3*t47*t48*t64/rhoa**7-3.73
     ;         452d-3*t43*t44*t50*t55+2.0d+0*t43*t46*t55+4.0d+0*t43*t44*
     <         t50*t52)-3.73452d-3*t50*t56/t59)*wght+Mmat(iq,D1_TA)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammaaa*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammaaa*t1*t3+1.0d+0
            t5 = rhoa**1.3333333333333333d+0
            t6 = param(7)
            t7 = param(18)
            t8 = rhoa**1.6666666666666669d+0
            t9 = 9.115599744691192d+0*t8
            t10 = t9-2.0d+0*taua
            t11 = t10**11
            t12 = 2.0d+0*taua+t9
            t13 = 1/t12**11
            t14 = param(17)
            t15 = t10**10
            t16 = 1/t12**10
            t17 = param(16)
            t18 = t10**9
            t19 = 1/t12**9
            t20 = param(15)
            t21 = t10**8
            t22 = 1/t12**8
            t23 = param(14)
            t24 = t10**7
            t25 = 1/t12**7
            t26 = param(13)
            t27 = t10**6
            t28 = 1/t12**6
            t29 = param(12)
            t30 = t10**5
            t31 = 1/t12**5
            t32 = param(11)
            t33 = t10**4
            t34 = 1/t12**4
            t35 = param(10)
            t36 = t10**3
            t37 = 1/t12**3
            t38 = param(9)
            t39 = t10**2
            t40 = 1/t12**2
            t41 = param(8)
            t42 = 1/t12
            t43 = t11*t13*t7+t6+t10*t41*t42+t38*t39*t40+t35*t36*t37+t32*
     1         t33*t34+t29*t30*t31+t26*t27*t28+t23*t24*t25+t20*t21*t22+t
     2         17*t18*t19+t14*t15*t16
            t44 = 1/t8
            t45 = 2.0d+0*t44*taua-9.11559972d+0
            t46 = 1.86726d-3*t45+1.86726d-3*gammaaa*t1+1.0d+0
            t47 = 1/t46
            t48 = param(1)
            t49 = param(4)
            t50 = gammaaa**2
            t51 = 1/rhoa**5.333333333333333d+0
            t52 = 1/t46**2
            t53 = param(5)
            t54 = param(6)
            t55 = t45**2
            t56 = param(2)
            t57 = param(3)
            t58 = t45*t47*t57+gammaaa*t1*t47*t56+t52*t54*t55+gammaaa*t1*
     1         t45*t52*t53+t49*t50*t51*t52+t48
            t59 = 1/rhob**2.6666666666666666d+0
            t60 = 4.49276922095889d-3*gammabb*t59+1.0d+0
            t61 = 1/t60
            t62 = 3.6121864536509485d-3*gammabb*t59*t61+1.0d+0
            t63 = rhob**1.3333333333333333d+0
            t64 = rhob**1.6666666666666669d+0
            t65 = 9.115599744691192d+0*t64
            t66 = t65-2.0d+0*taub
            t67 = t66**11
            t68 = 2.0d+0*taub+t65
            t69 = 1/t68**11
            t70 = t66**10
            t71 = 1/t68**10
            t72 = t66**9
            t73 = 1/t68**9
            t74 = t66**8
            t75 = 1/t68**8
            t76 = t66**7
            t77 = 1/t68**7
            t78 = t66**6
            t79 = 1/t68**6
            t80 = t66**5
            t81 = 1/t68**5
            t82 = t66**4
            t83 = 1/t68**4
            t84 = t66**3
            t85 = 1/t68**3
            t86 = t66**2
            t87 = 1/t68**2
            t88 = 1/t68
            t89 = t41*t66*t88+t38*t86*t87+t35*t84*t85+t32*t82*t83+t29*t8
     1         0*t81+t26*t78*t79+t23*t76*t77+t20*t74*t75+t17*t72*t73+t14
     2         *t70*t71+t67*t69*t7+t6
            t90 = 1/t64
            t91 = 2.0d+0*t90*taub-9.11559972d+0
            t92 = 1.86726d-3*t91+1.86726d-3*gammabb*t59+1.0d+0
            t93 = 1/t92
            t94 = gammabb**2
            t95 = 1/rhob**5.333333333333333d+0
            t96 = 1/t92**2
            t97 = t91**2
            t98 = t54*t96*t97+t49*t94*t95*t96+gammabb*t53*t59*t91*t96+t5
     1         7*t91*t93+gammabb*t56*t59*t93+t48
            t99 = rhoa**6.666666666666666d-1
            t100 = 1/t12**12
            t101 = rhoa**3.333333333333333d-1
            t102 = 1/t2**2
            t103 = 1/rhoa**6.333333333333333d+0
            t104 = 1/rhoa**3.6666666666666664d+0
            t105 = -6.2242d-3*t1*taua-4.9793599999999993d-3*gammaaa*t104
            t106 = 1/t46**3
            t107 = rhob**6.666666666666666d-1
            t108 = 1/t68**12
            t109 = rhob**3.333333333333333d-1
            t110 = 1/t60**2
            t111 = 1/rhob**6.333333333333333d+0
            t112 = 1/rhob**3.6666666666666664d+0
            t113 = -6.2242d-3*t59*taub-4.9793599999999993d-3*gammabb*t11
     1         2
            t114 = 1/t92**3
            t115 = 1/rhoa**4.333333333333333d+0
            t116 = 1/rhob**4.333333333333333d+0
            fnc(iq) = (1.0d+0*t63*t93*t98-9.305257363490997d-1*t62*t63*t
     1         89+1.0d+0*t47*t5*t58-9.305257363490997d-1*t4*t43*t5)*wght
     2         +fnc(iq)
            Amat(iq,D1_RA) = (t47*(1.0d+0*t5*(-3.3333333333333337d+0*t1*
     1         t47*t57*taua-6.666666666666667d+0*t1*t45*t52*t54*taua-3.3
     2         333333333333337d+0*gammaaa*t51*t52*t53*taua-t105*t45*t52*
     3         t57-gammaaa*t1*t105*t52*t56-2.6666666666666666d+0*gammaaa
     4         *t104*t47*t56-2*t105*t106*t54*t55-2.6666666666666666d+0*g
     5         ammaaa*t104*t45*t52*t53-2*gammaaa*t1*t105*t106*t45*t53-5.
     6         333333333333333d+0*t103*t49*t50*t52-2*t105*t106*t49*t50*t
     7         51)+1.3333333333333333d+0*t101*t58)-9.305257363490997d-1*
     8         t4*t5*(1.6711932865267184d+2*t13*t15*t7*t99-1.67119328652
     9         67184d+2*t100*t11*t7*t99+1.5192666241151986d+1*t41*t42*t9
     :         9-1.5192666241151986d+1*t10*t40*t41*t99+3.038533248230397
     ;         d+1*t10*t38*t40*t99-3.038533248230397d+1*t37*t38*t39*t99+
     <         4.5577998723455965d+1*t35*t37*t39*t99-4.5577998723455965d
     =         +1*t34*t35*t36*t99+6.077066496460795d+1*t32*t34*t36*t99-6
     >         .077066496460795d+1*t31*t32*t33*t99+7.596333120575993d+1*
     ?         t29*t31*t33*t99-7.596333120575993d+1*t28*t29*t30*t99+9.11
     @         5599744691193d+1*t26*t28*t30*t99-9.115599744691193d+1*t25
     1         *t26*t27*t99+1.0634866368806391d+2*t23*t25*t27*t99-1.0634
     2         866368806391d+2*t22*t23*t24*t99+1.2154132992921589d+2*t20
     3         *t22*t24*t99-1.2154132992921589d+2*t19*t20*t21*t99+1.3673
     4         399617036788d+2*t17*t19*t21*t99-1.3673399617036788d+2*t16
     5         *t17*t18*t99+1.5192666241151986d+2*t14*t16*t18*t99-1.5192
     6         666241151986d+2*t13*t14*t15*t99)-1.0d+0*t105*t5*t52*t58-9
     7         .305257363490997d-1*t43*t5*(4.327658698487368d-5*t102*t10
     8         3*t50-9.632497209735863d-3*gammaaa*t104*t3)-1.24070098179
     9         87995d+0*t101*t4*t43)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (t93*(1.0d+0*t63*(-3.3333333333333337d+0*ga
     1         mmabb*t53*t95*t96*taub-6.666666666666667d+0*t54*t59*t91*t
     2         96*taub-3.3333333333333337d+0*t57*t59*t93*taub-2*t113*t11
     3         4*t54*t97-5.333333333333333d+0*t111*t49*t94*t96-t113*t57*
     4         t91*t96-2.6666666666666666d+0*gammabb*t112*t53*t91*t96-ga
     5         mmabb*t113*t56*t59*t96-2*t113*t114*t49*t94*t95-2.66666666
     6         66666666d+0*gammabb*t112*t56*t93-2*gammabb*t113*t114*t53*
     7         t59*t91)+1.3333333333333333d+0*t109*t98)-1.0d+0*t113*t63*
     8         t96*t98-9.305257363490997d-1*t63*t89*(4.327658698487368d-
     9         5*t110*t111*t94-9.632497209735863d-3*gammabb*t112*t61)-1.
     :         2407009817987995d+0*t109*t62*t89-9.305257363490997d-1*t62
     ;         *t63*(1.5192666241151986d+1*t107*t41*t88-1.51926662411519
     <         86d+1*t107*t41*t66*t87+3.038533248230397d+1*t107*t38*t66*
     =         t87-3.038533248230397d+1*t107*t38*t85*t86+4.5577998723455
     >         965d+1*t107*t35*t85*t86-4.5577998723455965d+1*t107*t35*t8
     ?         3*t84+6.077066496460795d+1*t107*t32*t83*t84-6.07706649646
     @         0795d+1*t107*t32*t81*t82+7.596333120575993d+1*t107*t29*t8
     1         1*t82-7.596333120575993d+1*t107*t29*t79*t80+9.11559974469
     2         1193d+1*t107*t26*t79*t80-9.115599744691193d+1*t107*t26*t7
     3         7*t78+1.0634866368806391d+2*t107*t23*t77*t78-1.0634866368
     4         806391d+2*t107*t23*t75*t76+1.2154132992921589d+2*t107*t20
     5         *t75*t76-1.2154132992921589d+2*t107*t20*t73*t74+1.3673399
     6         617036788d+2*t107*t17*t73*t74-1.3673399617036788d+2*t107*
     7         t17*t71*t72+1.5192666241151986d+2*t107*t14*t71*t72+1.6711
     8         932865267184d+2*t107*t69*t7*t70-1.5192666241151986d+2*t10
     9         7*t14*t69*t70-1.6711932865267184d+2*t107*t108*t67*t7))*wg
     :         ht+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = (-1.86726d-3*t52*t58/t5+1.0d+0*t47*t5*(-1.
     1         86726d-3*t1*t45*t52*t57-1.86726d-3*gammaaa*t51*t52*t56+t1
     2         *t47*t56-3.73452d-3*t1*t106*t54*t55+t1*t45*t52*t53-3.7345
     3         2d-3*gammaaa*t106*t45*t51*t53+2*gammaaa*t49*t51*t52-3.734
     4         52d-3*t106*t49*t50/rhoa**8)-9.305257363490997d-1*t43*t5*(
     5         3.6121864536509485d-3*t1*t3-1.6228720119327628d-5*gammaaa
     6         *t102*t51))*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (-1.86726d-3*t96*t98/t63+1.0d+0*t63*t93*(-
     1         3.73452d-3*t114*t54*t59*t97-1.86726d-3*gammabb*t56*t95*t9
     2         6+2*gammabb*t49*t95*t96-1.86726d-3*t57*t59*t91*t96+t53*t5
     3         9*t91*t96-3.73452d-3*gammabb*t114*t53*t91*t95-3.73452d-3*
     4         t114*t49*t94/rhob**8+t56*t59*t93)-9.305257363490997d-1*t6
     5         3*t89*(3.6121864536509485d-3*t59*t61-1.6228720119327628d-
     6         5*gammabb*t110*t95))*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = (-9.305257363490997d-1*t4*t5*(-2.2d+1*t13*t
     1         15*t7-2.2d+1*t100*t11*t7-2.0d+0*t41*t42-2.0d+0*t10*t40*t4
     2         1-4.0d+0*t10*t38*t40-4.0d+0*t37*t38*t39-6.0d+0*t35*t37*t3
     3         9-6.0d+0*t34*t35*t36-8.0d+0*t32*t34*t36-8.0d+0*t31*t32*t3
     4         3-1.0d+1*t29*t31*t33-1.0d+1*t28*t29*t30-1.2d+1*t26*t28*t3
     5         0-1.2d+1*t25*t26*t27-1.4d+1*t23*t25*t27-1.4d+1*t22*t23*t2
     6         4-1.6d+1*t20*t22*t24-1.6d+1*t19*t20*t21-1.8d+1*t17*t19*t2
     7         1-1.8d+1*t16*t17*t18-2.0d+1*t14*t16*t18-2.0d+1*t13*t14*t1
     8         5)-3.73452d-3*t52*t58/t101+1.0d+0*t47*t5*(-3.73452d-3*t44
     9         *t45*t52*t57+2.0d+0*t44*t47*t57-3.73452d-3*gammaaa*t115*t
     :         52*t56-7.46904d-3*t106*t44*t54*t55+4.0d+0*t44*t45*t52*t54
     ;         +2.0d+0*gammaaa*t115*t52*t53-7.46904d-3*gammaaa*t106*t115
     <         *t45*t53-7.46904d-3*t106*t49*t50/rhoa**7))*wght+Mmat(iq,D
     =         1_TA)
            Mmat(iq,D1_TB) = (-3.73452d-3*t96*t98/t109+1.0d+0*t63*t93*(-
     1         7.46904d-3*t114*t54*t90*t97-3.73452d-3*t57*t90*t91*t96+4.
     2         0d+0*t54*t90*t91*t96-3.73452d-3*gammabb*t116*t56*t96+2.0d
     3         +0*gammabb*t116*t53*t96-7.46904d-3*t114*t49*t94/rhob**7+2
     4         .0d+0*t57*t90*t93-7.46904d-3*gammabb*t114*t116*t53*t91)-9
     5         .305257363490997d-1*t62*t63*(-2.0d+0*t41*t88-2.0d+0*t41*t
     6         66*t87-4.0d+0*t38*t66*t87-4.0d+0*t38*t85*t86-6.0d+0*t35*t
     7         85*t86-6.0d+0*t35*t83*t84-8.0d+0*t32*t83*t84-8.0d+0*t32*t
     8         81*t82-1.0d+1*t29*t81*t82-1.0d+1*t29*t79*t80-1.2d+1*t26*t
     9         79*t80-1.2d+1*t26*t77*t78-1.4d+1*t23*t77*t78-1.4d+1*t23*t
     :         75*t76-1.6d+1*t20*t75*t76-1.6d+1*t20*t73*t74-1.8d+1*t17*t
     ;         73*t74-1.8d+1*t17*t71*t72-2.0d+1*t14*t71*t72-2.2d+1*t69*t
     <         7*t70-2.0d+1*t14*t69*t70-2.2d+1*t108*t67*t7))*wght+Mmat(i
     =         q,D1_TB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammaaa*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammaaa*t1*t3+1.0d+0
            t5 = rhoa**1.3333333333333333d+0
            t6 = param(18)
            t7 = rhoa**1.6666666666666669d+0
            t8 = 9.115599744691192d+0*t7
            t9 = t8-2.0d+0*taua
            t10 = t9**11
            t11 = 2.0d+0*taua+t8
            t12 = 1/t11**11
            t13 = param(17)
            t14 = t9**10
            t15 = 1/t11**10
            t16 = param(16)
            t17 = t9**9
            t18 = 1/t11**9
            t19 = param(15)
            t20 = t9**8
            t21 = 1/t11**8
            t22 = param(14)
            t23 = t9**7
            t24 = 1/t11**7
            t25 = param(13)
            t26 = t9**6
            t27 = 1/t11**6
            t28 = param(12)
            t29 = t9**5
            t30 = 1/t11**5
            t31 = param(11)
            t32 = t9**4
            t33 = 1/t11**4
            t34 = param(10)
            t35 = t9**3
            t36 = 1/t11**3
            t37 = param(9)
            t38 = t9**2
            t39 = 1/t11**2
            t40 = param(8)
            t41 = 1/t11
            t42 = t40*t41*t9+t10*t12*t6+t37*t38*t39+t34*t35*t36+t31*t32*
     1         t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19*t20*t21+t16*t
     2         17*t18+t13*t14*t15+param(7)
            t43 = 1/t7
            t44 = 2.0d+0*t43*taua-9.11559972d+0
            t45 = 1.86726d-3*t44+1.86726d-3*gammaaa*t1+1.0d+0
            t46 = 1/t45
            t47 = param(4)
            t48 = gammaaa**2
            t49 = 1/rhoa**5.333333333333333d+0
            t50 = 1/t45**2
            t51 = param(5)
            t52 = param(6)
            t53 = t44**2
            t54 = param(2)
            t55 = param(3)
            t56 = t44*t46*t55+gammaaa*t1*t46*t54+t50*t52*t53+gammaaa*t1*
     1         t44*t50*t51+t47*t48*t49*t50+param(1)
            t57 = rhoa**6.666666666666666d-1
            t58 = 1/t11**12
            t59 = rhoa**3.333333333333333d-1
            t60 = 1/t2**2
            t61 = 1/rhoa**6.333333333333333d+0
            t62 = 1/rhoa**3.6666666666666664d+0
            t63 = -6.2242d-3*t1*taua-4.9793599999999993d-3*gammaaa*t62
            t64 = 1/t45**3
            t65 = 1/rhoa**4.333333333333333d+0
            fnc(iq) = (1.0d+0*t46*t5*t56-9.305257363490997d-1*t4*t42*t5)
     1         *wght+fnc(iq)
            Amat(iq,D1_RA) = (t46*(1.0d+0*t5*(-3.3333333333333337d+0*t1*
     1         t46*t55*taua-6.666666666666667d+0*t1*t44*t50*t52*taua-3.3
     2         333333333333337d+0*gammaaa*t49*t50*t51*taua-2*t52*t53*t63
     3         *t64-2*gammaaa*t1*t44*t51*t63*t64-2*t47*t48*t49*t63*t64-t
     4         44*t50*t55*t63-gammaaa*t1*t50*t54*t63-2.6666666666666666d
     5         +0*gammaaa*t46*t54*t62-2.6666666666666666d+0*gammaaa*t44*
     6         t50*t51*t62-5.333333333333333d+0*t47*t48*t50*t61)+1.33333
     7         33333333333d+0*t56*t59)-9.305257363490997d-1*t4*t5*(-1.51
     8         92666241151986d+1*t39*t40*t57*t9+3.038533248230397d+1*t37
     9         *t39*t57*t9-1.6711932865267184d+2*t10*t57*t58*t6+1.671193
     :         2865267184d+2*t12*t14*t57*t6+1.5192666241151986d+1*t40*t4
     ;         1*t57-3.038533248230397d+1*t36*t37*t38*t57+4.557799872345
     <         5965d+1*t34*t36*t38*t57-4.5577998723455965d+1*t33*t34*t35
     =         *t57+6.077066496460795d+1*t31*t33*t35*t57-6.0770664964607
     >         95d+1*t30*t31*t32*t57+7.596333120575993d+1*t28*t30*t32*t5
     ?         7-7.596333120575993d+1*t27*t28*t29*t57+9.115599744691193d
     @         +1*t25*t27*t29*t57-9.115599744691193d+1*t24*t25*t26*t57+1
     1         .0634866368806391d+2*t22*t24*t26*t57-1.0634866368806391d+
     2         2*t21*t22*t23*t57+1.2154132992921589d+2*t19*t21*t23*t57-1
     3         .2154132992921589d+2*t18*t19*t20*t57+1.3673399617036788d+
     4         2*t16*t18*t20*t57-1.3673399617036788d+2*t15*t16*t17*t57+1
     5         .5192666241151986d+2*t13*t15*t17*t57-1.5192666241151986d+
     6         2*t12*t13*t14*t57)-1.0d+0*t5*t50*t56*t63-9.30525736349099
     7         7d-1*t42*t5*(4.327658698487368d-5*t48*t60*t61-9.632497209
     8         735863d-3*gammaaa*t3*t62)-1.2407009817987995d+0*t4*t42*t5
     9         9)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (1.0d+0*t46*t5*(-3.73452d-3*t1*t52*t53*t64
     1         -3.73452d-3*gammaaa*t44*t49*t51*t64-3.73452d-3*t47*t48*t6
     2         4/rhoa**8-1.86726d-3*t1*t44*t50*t55-1.86726d-3*gammaaa*t4
     3         9*t50*t54+t1*t46*t54+t1*t44*t50*t51+2*gammaaa*t47*t49*t50
     4         )-9.305257363490997d-1*t42*t5*(3.6121864536509485d-3*t1*t
     5         3-1.6228720119327628d-5*gammaaa*t49*t60)-1.86726d-3*t50*t
     6         56/t5)*wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = (-9.305257363490997d-1*t4*t5*(-2.0d+0*t39*t
     1         40*t9-4.0d+0*t37*t39*t9-2.2d+1*t10*t58*t6-2.2d+1*t12*t14*
     2         t6-2.0d+0*t40*t41-4.0d+0*t36*t37*t38-6.0d+0*t34*t36*t38-6
     3         .0d+0*t33*t34*t35-8.0d+0*t31*t33*t35-8.0d+0*t30*t31*t32-1
     4         .0d+1*t28*t30*t32-1.0d+1*t27*t28*t29-1.2d+1*t25*t27*t29-1
     5         .2d+1*t24*t25*t26-1.4d+1*t22*t24*t26-1.4d+1*t21*t22*t23-1
     6         .6d+1*t19*t21*t23-1.6d+1*t18*t19*t20-1.8d+1*t16*t18*t20-1
     7         .8d+1*t15*t16*t17-2.0d+1*t13*t15*t17-2.0d+1*t12*t13*t14)+
     8         1.0d+0*t46*t5*(-7.46904d-3*gammaaa*t44*t51*t64*t65-3.7345
     9         2d-3*gammaaa*t50*t54*t65+2.0d+0*gammaaa*t50*t51*t65-7.469
     :         04d-3*t43*t52*t53*t64-7.46904d-3*t47*t48*t64/rhoa**7-3.73
     ;         452d-3*t43*t44*t50*t55+2.0d+0*t43*t46*t55+4.0d+0*t43*t44*
     <         t50*t52)-3.73452d-3*t50*t56/t59)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammabb*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammabb*t1*t3+1.0d+0
            t5 = rhob**1.3333333333333333d+0
            t6 = param(18)
            t7 = rhob**1.6666666666666669d+0
            t8 = 9.115599744691192d+0*t7
            t9 = t8-2.0d+0*taub
            t10 = t9**11
            t11 = 2.0d+0*taub+t8
            t12 = 1/t11**11
            t13 = param(17)
            t14 = t9**10
            t15 = 1/t11**10
            t16 = param(16)
            t17 = t9**9
            t18 = 1/t11**9
            t19 = param(15)
            t20 = t9**8
            t21 = 1/t11**8
            t22 = param(14)
            t23 = t9**7
            t24 = 1/t11**7
            t25 = param(13)
            t26 = t9**6
            t27 = 1/t11**6
            t28 = param(12)
            t29 = t9**5
            t30 = 1/t11**5
            t31 = param(11)
            t32 = t9**4
            t33 = 1/t11**4
            t34 = param(10)
            t35 = t9**3
            t36 = 1/t11**3
            t37 = param(9)
            t38 = t9**2
            t39 = 1/t11**2
            t40 = param(8)
            t41 = 1/t11
            t42 = t40*t41*t9+t10*t12*t6+t37*t38*t39+t34*t35*t36+t31*t32*
     1         t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19*t20*t21+t16*t
     2         17*t18+t13*t14*t15+param(7)
            t43 = 1/t7
            t44 = 2.0d+0*t43*taub-9.11559972d+0
            t45 = 1.86726d-3*t44+1.86726d-3*gammabb*t1+1.0d+0
            t46 = 1/t45
            t47 = param(4)
            t48 = gammabb**2
            t49 = 1/rhob**5.333333333333333d+0
            t50 = 1/t45**2
            t51 = param(5)
            t52 = param(6)
            t53 = t44**2
            t54 = param(2)
            t55 = param(3)
            t56 = t44*t46*t55+gammabb*t1*t46*t54+t50*t52*t53+gammabb*t1*
     1         t44*t50*t51+t47*t48*t49*t50+param(1)
            t57 = rhob**6.666666666666666d-1
            t58 = 1/t11**12
            t59 = rhob**3.333333333333333d-1
            t60 = 1/t2**2
            t61 = 1/rhob**6.333333333333333d+0
            t62 = 1/rhob**3.6666666666666664d+0
            t63 = -6.2242d-3*t1*taub-4.9793599999999993d-3*gammabb*t62
            t64 = 1/t45**3
            t65 = 1/rhob**4.333333333333333d+0
            fnc(iq) = (1.0d+0*t46*t5*t56-9.305257363490997d-1*t4*t42*t5)
     1         *wght+fnc(iq)
            Amat(iq,D1_RB) = (t46*(1.0d+0*t5*(-3.3333333333333337d+0*t1*
     1         t46*t55*taub-6.666666666666667d+0*t1*t44*t50*t52*taub-3.3
     2         333333333333337d+0*gammabb*t49*t50*t51*taub-2*t52*t53*t63
     3         *t64-2*gammabb*t1*t44*t51*t63*t64-2*t47*t48*t49*t63*t64-t
     4         44*t50*t55*t63-gammabb*t1*t50*t54*t63-2.6666666666666666d
     5         +0*gammabb*t46*t54*t62-2.6666666666666666d+0*gammabb*t44*
     6         t50*t51*t62-5.333333333333333d+0*t47*t48*t50*t61)+1.33333
     7         33333333333d+0*t56*t59)-9.305257363490997d-1*t4*t5*(-1.51
     8         92666241151986d+1*t39*t40*t57*t9+3.038533248230397d+1*t37
     9         *t39*t57*t9-1.6711932865267184d+2*t10*t57*t58*t6+1.671193
     :         2865267184d+2*t12*t14*t57*t6+1.5192666241151986d+1*t40*t4
     ;         1*t57-3.038533248230397d+1*t36*t37*t38*t57+4.557799872345
     <         5965d+1*t34*t36*t38*t57-4.5577998723455965d+1*t33*t34*t35
     =         *t57+6.077066496460795d+1*t31*t33*t35*t57-6.0770664964607
     >         95d+1*t30*t31*t32*t57+7.596333120575993d+1*t28*t30*t32*t5
     ?         7-7.596333120575993d+1*t27*t28*t29*t57+9.115599744691193d
     @         +1*t25*t27*t29*t57-9.115599744691193d+1*t24*t25*t26*t57+1
     1         .0634866368806391d+2*t22*t24*t26*t57-1.0634866368806391d+
     2         2*t21*t22*t23*t57+1.2154132992921589d+2*t19*t21*t23*t57-1
     3         .2154132992921589d+2*t18*t19*t20*t57+1.3673399617036788d+
     4         2*t16*t18*t20*t57-1.3673399617036788d+2*t15*t16*t17*t57+1
     5         .5192666241151986d+2*t13*t15*t17*t57-1.5192666241151986d+
     6         2*t12*t13*t14*t57)-1.0d+0*t5*t50*t56*t63-9.30525736349099
     7         7d-1*t42*t5*(4.327658698487368d-5*t48*t60*t61-9.632497209
     8         735863d-3*gammabb*t3*t62)-1.2407009817987995d+0*t4*t42*t5
     9         9)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = (1.0d+0*t46*t5*(-3.73452d-3*t1*t52*t53*t64
     1         -3.73452d-3*gammabb*t44*t49*t51*t64-3.73452d-3*t47*t48*t6
     2         4/rhob**8-1.86726d-3*t1*t44*t50*t55-1.86726d-3*gammabb*t4
     3         9*t50*t54+t1*t46*t54+t1*t44*t50*t51+2*gammabb*t47*t49*t50
     4         )-9.305257363490997d-1*t42*t5*(3.6121864536509485d-3*t1*t
     5         3-1.6228720119327628d-5*gammabb*t49*t60)-1.86726d-3*t50*t
     6         56/t5)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = (-9.305257363490997d-1*t4*t5*(-2.0d+0*t39*t
     1         40*t9-4.0d+0*t37*t39*t9-2.2d+1*t10*t58*t6-2.2d+1*t12*t14*
     2         t6-2.0d+0*t40*t41-4.0d+0*t36*t37*t38-6.0d+0*t34*t36*t38-6
     3         .0d+0*t33*t34*t35-8.0d+0*t31*t33*t35-8.0d+0*t30*t31*t32-1
     4         .0d+1*t28*t30*t32-1.0d+1*t27*t28*t29-1.2d+1*t25*t27*t29-1
     5         .2d+1*t24*t25*t26-1.4d+1*t22*t24*t26-1.4d+1*t21*t22*t23-1
     6         .6d+1*t19*t21*t23-1.6d+1*t18*t19*t20-1.8d+1*t16*t18*t20-1
     7         .8d+1*t15*t16*t17-2.0d+1*t13*t15*t17-2.0d+1*t12*t13*t14)+
     8         1.0d+0*t46*t5*(-7.46904d-3*gammabb*t44*t51*t64*t65-3.7345
     9         2d-3*gammabb*t50*t54*t65+2.0d+0*gammabb*t50*t51*t65-7.469
     :         04d-3*t43*t52*t53*t64-7.46904d-3*t47*t48*t64/rhob**7-3.73
     ;         452d-3*t43*t44*t50*t55+2.0d+0*t43*t46*t55+4.0d+0*t43*t44*
     <         t50*t52)-3.73452d-3*t50*t56/t59)*wght+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_m06 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_4} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_5} &=& \rho_\alpha^{{{5}\over{3}}}\\\\ 
C>   {\it t_6} &=& 9.115599744691192\,{\it t_5}\\\\ 
C>   {\it t_7} &=& {\it t_6}-2.0\,\tau_\alpha\\\\ 
C>   {\it t_8} &=& 2.0\,\tau_\alpha+{\it t_6}\\\\ 
C>   {\it t_9} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{12}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{13}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{17}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{18}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{19}} &=& {{2.0\,\tau_\alpha}\over{{\it t_5}}}
C>    -9.11559972\\\\ 
C>   {\it t_{20}} &=& 0.00186726\,{\it t_{19}}+0.00186726\,{\it t_2}
C>    \,\sigma_{\alpha\alpha}+1.0\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{22}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{23}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_{20}}^2}}\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{29}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{31}} &=& \rho_\beta^{{{5}\over{3}}}\\\\ 
C>   {\it t_{32}} &=& 9.115599744691192\,{\it t_{31}}\\\\ 
C>   {\it t_{33}} &=& {\it t_{32}}-2.0\,\tau_\beta\\\\ 
C>   {\it t_{34}} &=& 2.0\,\tau_\beta+{\it t_{32}}\\\\ 
C>   {\it t_{35}} &=& {{2.0\,\tau_\beta}\over{{\it t_{31}}}}
C>    -9.11559972\\\\ 
C>   {\it t_{36}} &=& 0.00186726\,{\it t_{35}}+0.00186726\,{
C>    \it t_{30}}\,\sigma_{\beta\beta}+1.0\\\\ 
C>   {\it t_{37}} &=& {{1}\over{{\it t_{36}}}}\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_{36}}^2}}\\\\ 
C>   {\it t_{39}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{41}} &=& \rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{42}} &=& 9.115599744691192\,{\it t_{41}}\\\\ 
C>   {\it t_{43}} &=& {\it t_{42}}-2.0\,\tau_s\\\\ 
C>   {\it t_{44}} &=& 2.0\,\tau_s+{\it t_{42}}\\\\ 
C>   {\it t_{45}} &=& {{2.0\,\tau_s}\over{{\it t_{41}}}}-9.11559972\\\\ 
C>   {\it t_{46}} &=& 0.00186726\,{\it t_{45}}+0.00186726\,{
C>    \it t_{40}}\,\sigma_{ss}+1.0\\\\ 
C>   {\it t_{47}} &=& {{1}\over{{\it t_{46}}}}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{{\it t_{46}}^2}}\\\\ 
C>   f &=& 1.0\,{\it t_{29}}\,{\it t_{37}}\,\left({\it t_{28}}\,{
C>    \it t_{35}}\,{\it t_{37}}+{\it t_{27}}\,{\it t_{30}}\,
C>    \sigma_{\beta\beta}\,{\it t_{37}}+{\it t_{26}}\,{\it t_{35}}^2
C>    \,{\it t_{38}}+{\it t_{25}}\,{\it t_{30}}\,\sigma_{\beta\beta}
C>    \,{\it t_{35}}\,{\it t_{38}}+{{{\it t_{23}}\,
C>    \sigma_{\beta\beta}^2\,{\it t_{38}}}
C>    \over{\rho_\beta^{{{16}\over{3}}}}}+{\it t_{22}}\right)
C>    -0.9305257363490997\,{\it t_{29}}\,
C>    \left({{0.003612186453650949\,{\it t_{30}}\,
C>    \sigma_{\beta\beta}}\over{0.00449276922095889\,{\it t_{30}}
C>    \,\sigma_{\beta\beta}+1.0}}+1.0\right)\,\left({{{\it t_{18}}
C>    \,{\it t_{33}}}\over{{\it t_{34}}}}+{{{\it t_{17}}\,{
C>    \it t_{33}}^2}\over{{\it t_{34}}^2}}+{{{\it t_{16}}\,{
C>    \it t_{33}}^3}\over{{\it t_{34}}^3}}+{{{\it t_{15}}\,{
C>    \it t_{33}}^4}\over{{\it t_{34}}^4}}+{{{\it t_{14}}\,{
C>    \it t_{33}}^5}\over{{\it t_{34}}^5}}+{{{\it t_{13}}\,{
C>    \it t_{33}}^6}\over{{\it t_{34}}^6}}+{{{\it t_{12}}\,{
C>    \it t_{33}}^7}\over{{\it t_{34}}^7}}+{{{\it t_{11}}\,{
C>    \it t_{33}}^8}\over{{\it t_{34}}^8}}+{{{\it t_{10}}\,{
C>    \it t_{33}}^9}\over{{\it t_{34}}^9}}+{{{\it t_9}\,{
C>    \it t_{33}}^{10}}\over{{\it t_{34}}^{10}}}+{{{\it t_4}\,{
C>    \it t_{33}}^{11}}\over{{\it t_{34}}^{11}}}+{\it t_3}\right)
C>    +1.0\,{\it t_1}\,{\it t_{21}}\,\left({\it t_{28}}\,{
C>    \it t_{19}}\,{\it t_{21}}+{\it t_{27}}\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{21}}+{\it t_{26}}\,{
C>    \it t_{19}}^2\,{\it t_{24}}+{\it t_{25}}\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{19}}\,{\it t_{24}}+{{{
C>    \it t_{23}}\,\sigma_{\alpha\alpha}^2\,{\it t_{24}}}
C>    \over{\rho_\alpha^{{{16}\over{3}}}}}+{\it t_{22}}\right)
C>    -0.9305257363490997\,{\it t_1}\,\left({{0.003612186453650949
C>    \,{\it t_2}\,\sigma_{\alpha\alpha}}\over{0.00449276922095889
C>    \,{\it t_2}\,\sigma_{\alpha\alpha}+1.0}}+1.0\right)\,
C>    \left({{{\it t_{18}}\,{\it t_7}}\over{{\it t_8}}}+{{{
C>    \it t_{17}}\,{\it t_7}^2}\over{{\it t_8}^2}}+{{{\it t_{16}}
C>    \,{\it t_7}^3}\over{{\it t_8}^3}}+{{{\it t_{15}}\,{
C>    \it t_7}^4}\over{{\it t_8}^4}}+{{{\it t_{14}}\,{
C>    \it t_7}^5}\over{{\it t_8}^5}}+{{{\it t_{13}}\,{
C>    \it t_7}^6}\over{{\it t_8}^6}}+{{{\it t_{12}}\,{
C>    \it t_7}^7}\over{{\it t_8}^7}}+{{{\it t_{11}}\,{
C>    \it t_7}^8}\over{{\it t_8}^8}}+{{{\it t_{10}}\,{
C>    \it t_7}^9}\over{{\it t_8}^9}}+{{{\it t_9}\,{
C>    \it t_7}^{10}}\over{{\it t_8}^{10}}}+{{{\it t_4}\,{
C>    \it t_7}^{11}}\over{{\it t_8}^{11}}}+{\it t_3}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,{\it t_{39}}\,{\it t_{47}}\,\left({\it t_{28}}\,{
C>    \it t_{45}}\,{\it t_{47}}+{\it t_{27}}\,{\it t_{40}}\,
C>    \sigma_{ss}\,{\it t_{47}}+{\it t_{26}}\,{\it t_{45}}^2\,{
C>    \it t_{48}}+{\it t_{25}}\,{\it t_{40}}\,\sigma_{ss}\,{
C>    \it t_{45}}\,{\it t_{48}}+{{{\it t_{23}}\,\sigma_{ss}^2\,{
C>    \it t_{48}}}\over{\rho_s^{{{16}\over{3}}}}}+{\it t_{22}}\right)
C>    -0.9305257363490997\,{\it t_{39}}\,
C>    \left({{0.003612186453650949\,{\it t_{40}}\,\sigma_{ss}}
C>    \over{0.00449276922095889\,{\it t_{40}}\,\sigma_{ss}+1.0}}
C>    +1.0\right)\,\left({{{\it t_{18}}\,{\it t_{43}}}\over{{
C>    \it t_{44}}}}+{{{\it t_{17}}\,{\it t_{43}}^2}\over{{
C>    \it t_{44}}^2}}+{{{\it t_{16}}\,{\it t_{43}}^3}\over{{
C>    \it t_{44}}^3}}+{{{\it t_{15}}\,{\it t_{43}}^4}\over{{
C>    \it t_{44}}^4}}+{{{\it t_{14}}\,{\it t_{43}}^5}\over{{
C>    \it t_{44}}^5}}+{{{\it t_{13}}\,{\it t_{43}}^6}\over{{
C>    \it t_{44}}^6}}+{{{\it t_{12}}\,{\it t_{43}}^7}\over{{
C>    \it t_{44}}^7}}+{{{\it t_{11}}\,{\it t_{43}}^8}\over{{
C>    \it t_{44}}^8}}+{{{\it t_{10}}\,{\it t_{43}}^9}\over{{
C>    \it t_{44}}^9}}+{{{\it t_9}\,{\it t_{43}}^{10}}\over{{
C>    \it t_{44}}^{10}}}+{{{\it t_4}\,{\it t_{43}}^{11}}\over{{
C>    \it t_{44}}^{11}}}+{\it t_3}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, DG Truhlar, J.Chem.Phys. 123, 194101 (2006)  , DOI: 
C> <a href="https://doi.org/10.1063/1.2370993 "> 
C> 10.1063/1.2370993 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_m06_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammaaa*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammaaa*t1*t3+1.0d+0
            t5 = rhoa**1.3333333333333333d+0
            t6 = param(18)
            t7 = rhoa**1.6666666666666669d+0
            t8 = 9.115599744691192d+0*t7
            t9 = t8-2.0d+0*taua
            t10 = t9**11
            t11 = 2.0d+0*taua+t8
            t12 = 1/t11**11
            t13 = param(17)
            t14 = t9**10
            t15 = 1/t11**10
            t16 = param(16)
            t17 = t9**9
            t18 = 1/t11**9
            t19 = param(15)
            t20 = t9**8
            t21 = 1/t11**8
            t22 = param(14)
            t23 = t9**7
            t24 = 1/t11**7
            t25 = param(13)
            t26 = t9**6
            t27 = 1/t11**6
            t28 = param(12)
            t29 = t9**5
            t30 = 1/t11**5
            t31 = param(11)
            t32 = t9**4
            t33 = 1/t11**4
            t34 = param(10)
            t35 = t9**3
            t36 = 1/t11**3
            t37 = param(9)
            t38 = t9**2
            t39 = 1/t11**2
            t40 = param(8)
            t41 = 1/t11
            t42 = t40*t41*t9+t10*t12*t6+t37*t38*t39+t34*t35*t36+t31*t32*
     1         t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19*t20*t21+t16*t
     2         17*t18+t13*t14*t15+param(7)
            t43 = 1/t7
            t44 = 2.0d+0*t43*taua-9.11559972d+0
            t45 = 1.86726d-3*t44+1.86726d-3*gammaaa*t1+1.0d+0
            t46 = 1/t45
            t47 = param(4)
            t48 = gammaaa**2
            t49 = 1/rhoa**5.333333333333333d+0
            t50 = 1/t45**2
            t51 = param(5)
            t52 = param(6)
            t53 = t44**2
            t54 = param(2)
            t55 = param(3)
            t56 = t44*t46*t55+gammaaa*t1*t46*t54+t50*t52*t53+gammaaa*t1*
     1         t44*t50*t51+t47*t48*t49*t50+param(1)
            t57 = rhoa**6.666666666666666d-1
            t58 = 1/t11**12
            t59 = -1.5192666241151986d+1*t39*t40*t57*t9+3.03853324823039
     1         7d+1*t37*t39*t57*t9-1.6711932865267184d+2*t10*t57*t58*t6+
     2         1.6711932865267184d+2*t12*t14*t57*t6+1.5192666241151986d+
     3         1*t40*t41*t57-3.038533248230397d+1*t36*t37*t38*t57+4.5577
     4         998723455965d+1*t34*t36*t38*t57-4.5577998723455965d+1*t33
     5         *t34*t35*t57+6.077066496460795d+1*t31*t33*t35*t57-6.07706
     6         6496460795d+1*t30*t31*t32*t57+7.596333120575993d+1*t28*t3
     7         0*t32*t57-7.596333120575993d+1*t27*t28*t29*t57+9.11559974
     8         4691193d+1*t25*t27*t29*t57-9.115599744691193d+1*t24*t25*t
     9         26*t57+1.0634866368806391d+2*t22*t24*t26*t57-1.0634866368
     :         806391d+2*t21*t22*t23*t57+1.2154132992921589d+2*t19*t21*t
     ;         23*t57-1.2154132992921589d+2*t18*t19*t20*t57+1.3673399617
     <         036788d+2*t16*t18*t20*t57-1.3673399617036788d+2*t15*t16*t
     =         17*t57+1.5192666241151986d+2*t13*t15*t17*t57-1.5192666241
     >         151986d+2*t12*t13*t14*t57
            t60 = rhoa**3.333333333333333d-1
            t61 = 1/t2**2
            t62 = 1/rhoa**6.333333333333333d+0
            t63 = 1/rhoa**3.6666666666666664d+0
            t64 = 4.327658698487368d-5*t48*t61*t62-9.632497209735863d-3*
     1         gammaaa*t3*t63
            t65 = -6.2242d-3*t1*taua-4.9793599999999993d-3*gammaaa*t63
            t66 = 1/t45**3
            t67 = -3.3333333333333337d+0*t1*t46*t55*taua-6.6666666666666
     1         67d+0*t1*t44*t50*t52*taua-3.3333333333333337d+0*gammaaa*t
     2         49*t50*t51*taua-2*t52*t53*t65*t66-2*gammaaa*t1*t44*t51*t6
     3         5*t66-2*t47*t48*t49*t65*t66-t44*t50*t55*t65-gammaaa*t1*t5
     4         0*t54*t65-2.6666666666666666d+0*gammaaa*t46*t54*t63-2.666
     5         6666666666666d+0*gammaaa*t44*t50*t51*t63-5.33333333333333
     6         3d+0*t47*t48*t50*t62
            t68 = 1.0d+0*t5*t67+1.3333333333333333d+0*t56*t60
            t69 = 3.6121864536509485d-3*t1*t3-1.6228720119327628d-5*gamm
     1         aaa*t49*t61
            t70 = 1/rhoa**8
            t71 = -3.73452d-3*t47*t48*t66*t70-3.73452d-3*t1*t52*t53*t66-
     1         3.73452d-3*gammaaa*t44*t49*t51*t66-1.86726d-3*t1*t44*t50*
     2         t55-1.86726d-3*gammaaa*t49*t50*t54+t1*t46*t54+t1*t44*t50*
     3         t51+2*gammaaa*t47*t49*t50
            t72 = 1/t5
            t73 = -2.0d+0*t39*t40*t9-4.0d+0*t37*t39*t9-2.2d+1*t10*t58*t6
     1         -2.2d+1*t12*t14*t6-2.0d+0*t40*t41-4.0d+0*t36*t37*t38-6.0d
     2         +0*t34*t36*t38-6.0d+0*t33*t34*t35-8.0d+0*t31*t33*t35-8.0d
     3         +0*t30*t31*t32-1.0d+1*t28*t30*t32-1.0d+1*t27*t28*t29-1.2d
     4         +1*t25*t27*t29-1.2d+1*t24*t25*t26-1.4d+1*t22*t24*t26-1.4d
     5         +1*t21*t22*t23-1.6d+1*t19*t21*t23-1.6d+1*t18*t19*t20-1.8d
     6         +1*t16*t18*t20-1.8d+1*t15*t16*t17-2.0d+1*t13*t15*t17-2.0d
     7         +1*t12*t13*t14
            t74 = 1/rhoa**7
            t75 = 1/rhoa**4.333333333333333d+0
            t76 = -7.46904d-3*gammaaa*t44*t51*t66*t75-3.73452d-3*gammaaa
     1         *t50*t54*t75+2.0d+0*gammaaa*t50*t51*t75-7.46904d-3*t47*t4
     2         8*t66*t74-7.46904d-3*t43*t52*t53*t66-3.73452d-3*t43*t44*t
     3         50*t55+2.0d+0*t43*t46*t55+4.0d+0*t43*t44*t50*t52
            t77 = 1/t60
            t78 = 1/t11**13
            t79 = 1/t57
            t80 = 1/t2**3
            t81 = 1/rhoa**7.333333333333333d+0
            t82 = 1/rhoa**4.666666666666667d+0
            t83 = t65**2
            t84 = 1/t45**4
            t85 = 1.6597866666666666d-2*t63*taua+1.8257653333333332d-2*g
     1         ammaaa*t82
            t86 = 1/rhoa**9
            t87 = 1/rhoa**6
            t88 = 1/rhoa**3.3333333333333337d+0
            fnc(iq) = (2.0d+0*t46*t5*t56-1.8610514726981994d+0*t4*t42*t5
     1         )*wght+fnc(iq)
            Amat(iq,D1_RA) = (t46*t68-1.0d+0*t5*t50*t56*t65-9.3052573634
     1         90997d-1*t42*t5*t64-1.2407009817987995d+0*t4*t42*t60-9.30
     2         5257363490997d-1*t4*t5*t59)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (-1.86726d-3*t50*t56*t72+1.0d+0*t46*t5*t71
     1         -9.305257363490997d-1*t42*t5*t69)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = (-3.73452d-3*t50*t56*t77+1.0d+0*t46*t5*t76-
     1         9.305257363490997d-1*t4*t5*t73)*wght+Mmat(iq,D1_TA)
            Amat2(iq,D2_RA_RA) = (t46*(1.0d+0*t5*(2.2222222222222224d+1*
     1         t49*t50*t52*taua**2+2.6666666666666666d+1*t1*t44*t52*t65*
     2         t66*taua+1.3333333333333333d+1*gammaaa*t49*t51*t65*t66*ta
     3         ua+6.666666666666667d+0*t1*t50*t55*t65*taua+8.88888888888
     4         889d+0*t46*t55*t63*taua+1.7777777777777778d+1*t44*t50*t52
     5         *t63*taua+2.6666666666666666d+1*gammaaa*t50*t51*t62*taua-
     6         2*t52*t53*t66*t85-2*gammaaa*t1*t44*t51*t66*t85-2*t47*t48*
     7         t49*t66*t85-t44*t50*t55*t85-gammaaa*t1*t50*t54*t85+6*t52*
     8         t53*t83*t84+6*gammaaa*t1*t44*t51*t83*t84+6*t47*t48*t49*t8
     9         3*t84+2*t44*t55*t66*t83+2*gammaaa*t1*t54*t66*t83+9.777777
     :         777777779d+0*gammaaa*t46*t54*t82+9.777777777777779d+0*gam
     ;         maaa*t44*t50*t51*t82+3.377777777777778d+1*t47*t48*t50*t81
     <         +1.0666666666666666d+1*gammaaa*t44*t51*t63*t65*t66+2.1333
     =         333333333332d+1*t47*t48*t62*t65*t66+5.333333333333333d+0*
     >         gammaaa*t50*t54*t63*t65)+4.444444444444444d-1*t56*t79+2.6
     ?         666666666666666d+0*t60*t67)-9.305257363490997d-1*t4*t5*(-
     @         1.0128444160767991d+1*t39*t40*t77*t9+2.0256888321535982d+
     1         1*t37*t39*t77*t9+4.6163421503007845d+2*t36*t40*t5*t9-1.84
     2         6536860120314d+3*t36*t37*t5*t9+1.3849026450902355d+3*t34*
     3         t36*t5*t9+3.046785819198518d+4*t10*t5*t6*t78-1.1141288576
     4         844789d+2*t10*t58*t6*t77+1.1141288576844789d+2*t12*t14*t6
     5         *t77+1.0128444160767991d+1*t40*t41*t77-2.0256888321535982
     6         d+1*t36*t37*t38*t77+3.038533248230397d+1*t34*t36*t38*t77-
     7         3.038533248230397d+1*t33*t34*t35*t77+4.0513776643071964d+
     8         1*t31*t33*t35*t77-4.0513776643071964d+1*t30*t31*t32*t77+5
     9         .064222080383994d+1*t28*t30*t32*t77-5.064222080383994d+1*
     :         t27*t28*t29*t77+6.077066496460795d+1*t25*t27*t29*t77-6.07
     ;         7066496460795d+1*t24*t25*t26*t77+7.089910912537593d+1*t22
     <         *t24*t26*t77-7.089910912537593d+1*t21*t22*t23*t77+8.10275
     =         5328614393d+1*t19*t21*t23*t77-8.102755328614393d+1*t18*t1
     >         9*t20*t77+9.115599744691191d+1*t16*t18*t20*t77-9.11559974
     ?         4691191d+1*t15*t16*t17*t77+1.012844416076799d+2*t13*t15*t
     @         17*t77-1.012844416076799d+2*t12*t13*t14*t77-5.58577400186
     1         3949d+4*t14*t5*t58*t6+2.5389881826654315d+4*t12*t17*t5*t6
     2         +2.5389881826654315d+4*t13*t14*t5*t58-4.6163421503007845d
     3         +2*t39*t40*t5+4.6163421503007845d+2*t37*t39*t5+1.38490264
     4         50902355d+3*t33*t37*t38*t5-4.1547079352707067d+3*t33*t34*
     5         t38*t5+2.769805290180471d+3*t31*t33*t38*t5+2.769805290180
     6         471d+3*t30*t34*t35*t5-7.386147440481255d+3*t30*t31*t35*t5
     7         +4.616342150300784d+3*t28*t30*t35*t5+4.616342150300784d+3
     8         *t27*t31*t32*t5-1.154085537575196d+4*t27*t28*t32*t5+6.924
     9         513225451178d+3*t25*t27*t32*t5+6.924513225451178d+3*t24*t
     :         28*t29*t5-1.661883174108283d+4*t24*t25*t29*t5+9.694318515
     ;         631648d+3*t22*t24*t29*t5+9.694318515631648d+3*t21*t25*t26
     <         *t5-2.2620076536473846d+4*t21*t22*t26*t5+1.29257580208421
     =         96d+4*t19*t21*t26*t5+1.2925758020842196d+4*t18*t22*t23*t5
     >         -2.954458976192502d+4*t18*t19*t23*t5+1.6618831741082823d+
     ?         4*t16*t18*t23*t5+1.6618831741082823d+4*t15*t19*t20*t5-3.7
     @         392371417436354d+4*t15*t16*t20*t5+2.0773539676353528d+4*t
     1         13*t15*t20*t5+2.0773539676353528d+4*t12*t16*t17*t5-4.6163
     2         42150300784d+4*t12*t13*t17*t5)+t50*(-1.0d+0*t5*t56*t85-t6
     3         5*t68-1.0d+0*t5*t65*t67-1.3333333333333333d+0*t56*t60*t65
     4         )+2.0d+0*t5*t56*t66*t83-9.305257363490997d-1*t42*t5*(3.53
     5         1915643569816d-2*gammaaa*t3*t82-3.8948928286386303d-4*t48
     6         *t61*t81+1.0369691626335495d-6*gammaaa**3*t80/rhoa**10)-4
     7         .1356699393293317d-1*t4*t42*t79-2.481401963597599d+0*t42*
     8         t60*t64-1.8610514726981994d+0*t5*t59*t64-2.48140196359759
     9         9d+0*t4*t59*t60)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = (t46*(1.0d+0*t5*(1.24484d-2*gammaaa*t5
     1         1*t66*t70*taua+2.48968d-2*t44*t49*t52*t66*taua+6.2242d-3*
     2         t49*t50*t55*taua-3.3333333333333337d+0*t49*t50*t51*taua+2
     3         .9876159999999996d-2*t47*t48*t66*t86+1.120356d-2*t47*t48*
     4         t65*t70*t84+1.120356d-2*t1*t52*t53*t65*t84+1.120356d-2*ga
     5         mmaaa*t44*t49*t51*t65*t84+3.73452d-3*t1*t44*t55*t65*t66+3
     6         .73452d-3*gammaaa*t49*t54*t65*t66-2*t1*t44*t51*t65*t66-4*
     7         gammaaa*t47*t49*t65*t66+9.958719999999999d-3*t52*t53*t63*
     8         t66+1.9917439999999997d-2*gammaaa*t44*t51*t62*t66-t1*t50*
     9         t54*t65+4.9793599999999993d-3*t44*t50*t55*t63-2.666666666
     :         6666666d+0*t46*t54*t63-2.6666666666666666d+0*t44*t50*t51*
     ;         t63+9.958719999999999d-3*gammaaa*t50*t54*t62-1.0666666666
     <         666666d+1*gammaaa*t47*t50*t62)+1.3333333333333333d+0*t60*
     =         t71)-9.305257363490997d-1*t42*t5*(-3.8886343598758105d-7*
     >         t48*t80*t86-9.632497209735863d-3*t3*t63+1.29829760954621d
     ?         -4*gammaaa*t61*t62)+3.73452d-3*t56*t65*t66*t72-1.0d+0*t5*
     @         t50*t65*t71-1.2407009817987995d+0*t42*t60*t69-9.305257363
     1         490997d-1*t5*t59*t69-1.86726d-3*t1*t50*t68+4.979359999999
     2         9993d-3*t50*t56/rhoa**2.3333333333333334d+0)*wght+Cmat2(i
     3         q,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = (1.0d+0*t46*t5*(2.0919959445599998d-5
     1         *gammaaa*t44*t51*t70*t84+2.0919959445599998d-5*t49*t52*t5
     2         3*t84+2.0919959445599998d-5*t47*t48*t84/rhoa**1.066666666
     3         6666666d+1+6.973319815199999d-6*gammaaa*t54*t66*t70-1.493
     4         8079999999998d-2*gammaaa*t47*t66*t70+6.973319815199999d-6
     5         *t44*t49*t55*t66-7.46904d-3*t44*t49*t51*t66-3.73452d-3*t4
     6         9*t50*t54+2*t47*t49*t50)-9.305257363490997d-1*t42*t5*(1.4
     7         582378849534292d-7*gammaaa*t70*t80-3.2457440238655255d-5*
     8         t49*t61)-3.73452d-3*t50*t71*t72+6.973319815199999d-6*t56*
     9         t66/rhoa**4)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Mmat2(iq,D2_RA_TA) = (t46*(1.0d+0*t5*(4.97936d-2*t44*t52*t66
     1         *t75*taua+1.24484d-2*t50*t55*t75*taua-1.3333333333333333d
     2         +1*t50*t52*t75*taua+2.48968d-2*gammaaa*t51*t66*t74*taua+2
     3         .240712d-2*gammaaa*t44*t51*t65*t75*t84+2.240712d-2*t47*t4
     4         8*t65*t74*t84+2.240712d-2*t43*t52*t53*t65*t84+7.46904d-3*
     5         gammaaa*t54*t65*t66*t75-4.0d+0*gammaaa*t51*t65*t66*t75+5.
     6         228328d-2*t47*t48*t66*t70+7.46904d-3*t43*t44*t55*t65*t66-
     7         8.0d+0*t43*t44*t52*t65*t66+1.24484d-2*t1*t52*t53*t66+3.23
     8         6584d-2*gammaaa*t44*t49*t51*t66-2.0d+0*t43*t50*t55*t65+6.
     9         2242d-3*t1*t44*t50*t55-3.3333333333333337d+0*t1*t46*t55+1
     :         .618292d-2*gammaaa*t49*t50*t54-6.666666666666667d+0*t1*t4
     ;         4*t50*t52-8.666666666666666d+0*gammaaa*t49*t50*t51)+1.333
     <         3333333333333d+0*t60*t76)-9.305257363490997d-1*t4*t5*(6.0
     =         77066496460795d+1*t36*t40*t57*t9-1.8231199489382385d+2*t3
     >         4*t36*t57*t9+4.0108638876641245d+3*t10*t57*t6*t78-3.34238
     ?         6573053437d+3*t12*t17*t57*t6+3.342386573053437d+3*t13*t14
     @         *t57*t58-6.077066496460795d+1*t37*t39*t57+1.8231199489382
     1         385d+2*t33*t37*t38*t57-3.646239897876477d+2*t31*t33*t38*t
     2         57+3.646239897876477d+2*t30*t34*t35*t57-6.077066496460795
     3         d+2*t28*t30*t35*t57+6.077066496460795d+2*t27*t31*t32*t57-
     4         9.115599744691192d+2*t25*t27*t32*t57+9.115599744691192d+2
     5         *t24*t28*t29*t57-1.276183964256767d+3*t22*t24*t29*t57+1.2
     6         76183964256767d+3*t21*t25*t26*t57-1.7015786190090226d+3*t
     7         19*t21*t26*t57+1.7015786190090226d+3*t18*t22*t23*t57-2.18
     8         7743938725886d+3*t16*t18*t23*t57+2.187743938725886d+3*t15
     9         *t19*t20*t57-2.734679923407357d+3*t13*t15*t20*t57+2.73467
     :         9923407357d+3*t12*t16*t17*t57)+7.46904d-3*t56*t65*t66*t77
     ;         -1.0d+0*t5*t50*t65*t76-9.305257363490997d-1*t5*t64*t73-1.
     <         2407009817987995d+0*t4*t60*t73+6.2242d-3*t50*t56*t72-3.73
     =         452d-3*t43*t50*t68)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = (1.0d+0*t46*t5*(4.1839918891199995d-5*
     1         t52*t53*t75*t84+4.1839918891199995d-5*gammaaa*t44*t51*t74
     2         *t84+4.1839918891199995d-5*t47*t48*t84/rhoa**9.6666666666
     3         66666d+0+1.3946639630399998d-5*t44*t55*t66*t75-1.49380799
     4         99999998d-2*t44*t52*t66*t75-7.46904d-3*t44*t51*t66*t75-3.
     5         73452d-3*t50*t55*t75-3.73452d-3*t50*t54*t75+2.0d+0*t50*t5
     6         1*t75+1.3946639630399998d-5*gammaaa*t54*t66*t74-7.46904d-
     7         3*gammaaa*t51*t66*t74-1.4938079999999998d-2*gammaaa*t47*t
     8         66*t74)-3.73452d-3*t50*t71*t77-1.86726d-3*t50*t72*t76-9.3
     9         05257363490997d-1*t5*t69*t73+1.3946639630399998d-5*t56*t6
     :         6/rhoa**3)*wght+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_TA_TA) = (-9.305257363490997d-1*t4*t5*(8.0d+0*t3
     1         6*t40*t9+3.2d+1*t36*t37*t9+2.4d+1*t34*t36*t9+5.28d+2*t10*
     2         t6*t78+9.68d+2*t14*t58*t6+4.4d+2*t12*t17*t6+4.4d+2*t13*t1
     3         4*t58+8.0d+0*t39*t40+8.0d+0*t37*t39+2.4d+1*t33*t37*t38+7.
     4         2d+1*t33*t34*t38+4.8d+1*t31*t33*t38+4.8d+1*t30*t34*t35+1.
     5         28d+2*t30*t31*t35+8.0d+1*t28*t30*t35+8.0d+1*t27*t31*t32+2
     6         .0d+2*t27*t28*t32+1.2d+2*t25*t27*t32+1.2d+2*t24*t28*t29+2
     7         .88d+2*t24*t25*t29+1.68d+2*t22*t24*t29+1.68d+2*t21*t25*t2
     8         6+3.92d+2*t21*t22*t26+2.24d+2*t19*t21*t26+2.24d+2*t18*t22
     9         *t23+5.12d+2*t18*t19*t23+2.88d+2*t16*t18*t23+2.88d+2*t15*
     :         t19*t20+6.48d+2*t15*t16*t20+3.6d+2*t13*t15*t20+3.6d+2*t12
     ;         *t16*t17+8.0d+2*t12*t13*t17)+1.0d+0*t46*t5*(8.36798377823
     <         9999d-5*t52*t53*t84*t88+2.7893279260799997d-5*t44*t55*t66
     =         *t88-5.975231999999999d-2*t44*t52*t66*t88-1.4938079999999
     >         998d-2*t50*t55*t88+8.0d+0*t50*t52*t88+8.367983778239999d-
     ?         5*gammaaa*t44*t51*t84*t87+2.7893279260799997d-5*gammaaa*t
     @         54*t66*t87-2.9876159999999996d-2*gammaaa*t51*t66*t87+8.36
     1         7983778239999d-5*t47*t48*t84/rhoa**8.666666666666666d+0)-
     2         7.46904d-3*t50*t76*t77+2.7893279260799997d-5*t56*t66/rhoa
     3         **2)*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammaaa*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammaaa*t1*t3+1.0d+0
            t5 = rhoa**1.3333333333333333d+0
            t6 = param(7)
            t7 = param(18)
            t8 = rhoa**1.6666666666666669d+0
            t9 = 9.115599744691192d+0*t8
            t10 = t9-2.0d+0*taua
            t11 = t10**11
            t12 = 2.0d+0*taua+t9
            t13 = 1/t12**11
            t14 = param(17)
            t15 = t10**10
            t16 = 1/t12**10
            t17 = param(16)
            t18 = t10**9
            t19 = 1/t12**9
            t20 = param(15)
            t21 = t10**8
            t22 = 1/t12**8
            t23 = param(14)
            t24 = t10**7
            t25 = 1/t12**7
            t26 = param(13)
            t27 = t10**6
            t28 = 1/t12**6
            t29 = param(12)
            t30 = t10**5
            t31 = 1/t12**5
            t32 = param(11)
            t33 = t10**4
            t34 = 1/t12**4
            t35 = param(10)
            t36 = t10**3
            t37 = 1/t12**3
            t38 = param(9)
            t39 = t10**2
            t40 = 1/t12**2
            t41 = param(8)
            t42 = 1/t12
            t43 = t11*t13*t7+t6+t10*t41*t42+t38*t39*t40+t35*t36*t37+t32*
     1         t33*t34+t29*t30*t31+t26*t27*t28+t23*t24*t25+t20*t21*t22+t
     2         17*t18*t19+t14*t15*t16
            t44 = 1/t8
            t45 = 2.0d+0*t44*taua-9.11559972d+0
            t46 = 1.86726d-3*t45+1.86726d-3*gammaaa*t1+1.0d+0
            t47 = 1/t46
            t48 = param(1)
            t49 = param(4)
            t50 = gammaaa**2
            t51 = 1/rhoa**5.333333333333333d+0
            t52 = 1/t46**2
            t53 = param(5)
            t54 = param(6)
            t55 = t45**2
            t56 = param(2)
            t57 = param(3)
            t58 = t45*t47*t57+gammaaa*t1*t47*t56+t52*t54*t55+gammaaa*t1*
     1         t45*t52*t53+t49*t50*t51*t52+t48
            t59 = 1/rhob**2.6666666666666666d+0
            t60 = 4.49276922095889d-3*gammabb*t59+1.0d+0
            t61 = 1/t60
            t62 = 3.6121864536509485d-3*gammabb*t59*t61+1.0d+0
            t63 = rhob**1.3333333333333333d+0
            t64 = rhob**1.6666666666666669d+0
            t65 = 9.115599744691192d+0*t64
            t66 = t65-2.0d+0*taub
            t67 = t66**11
            t68 = 2.0d+0*taub+t65
            t69 = 1/t68**11
            t70 = t66**10
            t71 = 1/t68**10
            t72 = t66**9
            t73 = 1/t68**9
            t74 = t66**8
            t75 = 1/t68**8
            t76 = t66**7
            t77 = 1/t68**7
            t78 = t66**6
            t79 = 1/t68**6
            t80 = t66**5
            t81 = 1/t68**5
            t82 = t66**4
            t83 = 1/t68**4
            t84 = t66**3
            t85 = 1/t68**3
            t86 = t66**2
            t87 = 1/t68**2
            t88 = 1/t68
            t89 = t41*t66*t88+t38*t86*t87+t35*t84*t85+t32*t82*t83+t29*t8
     1         0*t81+t26*t78*t79+t23*t76*t77+t20*t74*t75+t17*t72*t73+t14
     2         *t70*t71+t67*t69*t7+t6
            t90 = 1/t64
            t91 = 2.0d+0*t90*taub-9.11559972d+0
            t92 = 1.86726d-3*t91+1.86726d-3*gammabb*t59+1.0d+0
            t93 = 1/t92
            t94 = gammabb**2
            t95 = 1/rhob**5.333333333333333d+0
            t96 = 1/t92**2
            t97 = t91**2
            t98 = t54*t96*t97+t49*t94*t95*t96+gammabb*t53*t59*t91*t96+t5
     1         7*t91*t93+gammabb*t56*t59*t93+t48
            t99 = rhoa**6.666666666666666d-1
            t100 = 1/t12**12
            t101 = 1.6711932865267184d+2*t13*t15*t7*t99-1.67119328652671
     1         84d+2*t100*t11*t7*t99+1.5192666241151986d+1*t41*t42*t99-1
     2         .5192666241151986d+1*t10*t40*t41*t99+3.038533248230397d+1
     3         *t10*t38*t40*t99-3.038533248230397d+1*t37*t38*t39*t99+4.5
     4         577998723455965d+1*t35*t37*t39*t99-4.5577998723455965d+1*
     5         t34*t35*t36*t99+6.077066496460795d+1*t32*t34*t36*t99-6.07
     6         7066496460795d+1*t31*t32*t33*t99+7.596333120575993d+1*t29
     7         *t31*t33*t99-7.596333120575993d+1*t28*t29*t30*t99+9.11559
     8         9744691193d+1*t26*t28*t30*t99-9.115599744691193d+1*t25*t2
     9         6*t27*t99+1.0634866368806391d+2*t23*t25*t27*t99-1.0634866
     :         368806391d+2*t22*t23*t24*t99+1.2154132992921589d+2*t20*t2
     ;         2*t24*t99-1.2154132992921589d+2*t19*t20*t21*t99+1.3673399
     <         617036788d+2*t17*t19*t21*t99-1.3673399617036788d+2*t16*t1
     =         7*t18*t99+1.5192666241151986d+2*t14*t16*t18*t99-1.5192666
     >         241151986d+2*t13*t14*t15*t99
            t102 = rhoa**3.333333333333333d-1
            t103 = 1/t2**2
            t104 = 1/rhoa**6.333333333333333d+0
            t105 = 1/rhoa**3.6666666666666664d+0
            t106 = 4.327658698487368d-5*t103*t104*t50-9.632497209735863d
     1         -3*gammaaa*t105*t3
            t107 = -6.2242d-3*t1*taua-4.9793599999999993d-3*gammaaa*t105
            t108 = 1/t46**3
            t109 = -3.3333333333333337d+0*t1*t47*t57*taua-6.666666666666
     1         667d+0*t1*t45*t52*t54*taua-3.3333333333333337d+0*gammaaa*
     2         t51*t52*t53*taua-t107*t45*t52*t57-gammaaa*t1*t107*t52*t56
     3         -2.6666666666666666d+0*gammaaa*t105*t47*t56-2*t107*t108*t
     4         54*t55-2.6666666666666666d+0*gammaaa*t105*t45*t52*t53-2*g
     5         ammaaa*t1*t107*t108*t45*t53-5.333333333333333d+0*t104*t49
     6         *t50*t52-2*t107*t108*t49*t50*t51
            t110 = 1.3333333333333333d+0*t102*t58+1.0d+0*t109*t5
            t111 = rhob**6.666666666666666d-1
            t112 = 1/t68**12
            t113 = 1.5192666241151986d+1*t111*t41*t88-1.5192666241151986
     1         d+1*t111*t41*t66*t87+3.038533248230397d+1*t111*t38*t66*t8
     2         7-3.038533248230397d+1*t111*t38*t85*t86+4.557799872345596
     3         5d+1*t111*t35*t85*t86-4.5577998723455965d+1*t111*t35*t83*
     4         t84+6.077066496460795d+1*t111*t32*t83*t84-6.0770664964607
     5         95d+1*t111*t32*t81*t82+7.596333120575993d+1*t111*t29*t81*
     6         t82-7.596333120575993d+1*t111*t29*t79*t80+9.1155997446911
     7         93d+1*t111*t26*t79*t80-9.115599744691193d+1*t111*t26*t77*
     8         t78+1.0634866368806391d+2*t111*t23*t77*t78-1.063486636880
     9         6391d+2*t111*t23*t75*t76+1.2154132992921589d+2*t111*t20*t
     :         75*t76-1.2154132992921589d+2*t111*t20*t73*t74+1.367339961
     ;         7036788d+2*t111*t17*t73*t74-1.3673399617036788d+2*t111*t1
     <         7*t71*t72+1.5192666241151986d+2*t111*t14*t71*t72+1.671193
     =         2865267184d+2*t111*t69*t7*t70-1.5192666241151986d+2*t111*
     >         t14*t69*t70-1.6711932865267184d+2*t111*t112*t67*t7
            t114 = rhob**3.333333333333333d-1
            t115 = 1/t60**2
            t116 = 1/rhob**6.333333333333333d+0
            t117 = 1/rhob**3.6666666666666664d+0
            t118 = 4.327658698487368d-5*t115*t116*t94-9.632497209735863d
     1         -3*gammabb*t117*t61
            t119 = -6.2242d-3*t59*taub-4.9793599999999993d-3*gammabb*t11
     1         7
            t120 = 1/t92**3
            t121 = -3.3333333333333337d+0*gammabb*t53*t95*t96*taub-6.666
     1         666666666667d+0*t54*t59*t91*t96*taub-3.3333333333333337d+
     2         0*t57*t59*t93*taub-2*t119*t120*t54*t97-5.333333333333333d
     3         +0*t116*t49*t94*t96-t119*t57*t91*t96-2.6666666666666666d+
     4         0*gammabb*t117*t53*t91*t96-gammabb*t119*t56*t59*t96-2*t11
     5         9*t120*t49*t94*t95-2.6666666666666666d+0*gammabb*t117*t56
     6         *t93-2*gammabb*t119*t120*t53*t59*t91
            t122 = 1.3333333333333333d+0*t114*t98+1.0d+0*t121*t63
            t123 = 3.6121864536509485d-3*t1*t3-1.6228720119327628d-5*gam
     1         maaa*t103*t51
            t124 = 1/rhoa**8
            t125 = -1.86726d-3*t1*t45*t52*t57-1.86726d-3*gammaaa*t51*t52
     1         *t56+t1*t47*t56-3.73452d-3*t1*t108*t54*t55+t1*t45*t52*t53
     2         -3.73452d-3*gammaaa*t108*t45*t51*t53+2*gammaaa*t49*t51*t5
     3         2-3.73452d-3*t108*t124*t49*t50
            t126 = 1/t5
            t127 = 3.6121864536509485d-3*t59*t61-1.6228720119327628d-5*g
     1         ammabb*t115*t95
            t128 = 1/rhob**8
            t129 = -3.73452d-3*t120*t54*t59*t97-1.86726d-3*gammabb*t56*t
     1         95*t96+2*gammabb*t49*t95*t96-1.86726d-3*t57*t59*t91*t96+t
     2         53*t59*t91*t96-3.73452d-3*gammabb*t120*t53*t91*t95-3.7345
     3         2d-3*t120*t128*t49*t94+t56*t59*t93
            t130 = 1/t63
            t131 = -2.2d+1*t13*t15*t7-2.2d+1*t100*t11*t7-2.0d+0*t41*t42-
     1         2.0d+0*t10*t40*t41-4.0d+0*t10*t38*t40-4.0d+0*t37*t38*t39-
     2         6.0d+0*t35*t37*t39-6.0d+0*t34*t35*t36-8.0d+0*t32*t34*t36-
     3         8.0d+0*t31*t32*t33-1.0d+1*t29*t31*t33-1.0d+1*t28*t29*t30-
     4         1.2d+1*t26*t28*t30-1.2d+1*t25*t26*t27-1.4d+1*t23*t25*t27-
     5         1.4d+1*t22*t23*t24-1.6d+1*t20*t22*t24-1.6d+1*t19*t20*t21-
     6         1.8d+1*t17*t19*t21-1.8d+1*t16*t17*t18-2.0d+1*t14*t16*t18-
     7         2.0d+1*t13*t14*t15
            t132 = 1/rhoa**7
            t133 = 1/rhoa**4.333333333333333d+0
            t134 = -3.73452d-3*t44*t45*t52*t57+2.0d+0*t44*t47*t57-3.7345
     1         2d-3*gammaaa*t133*t52*t56-7.46904d-3*t108*t44*t54*t55+4.0
     2         d+0*t44*t45*t52*t54+2.0d+0*gammaaa*t133*t52*t53-7.46904d-
     3         3*gammaaa*t108*t133*t45*t53-7.46904d-3*t108*t132*t49*t50
            t135 = 1/t102
            t136 = -2.0d+0*t41*t88-2.0d+0*t41*t66*t87-4.0d+0*t38*t66*t87
     1         -4.0d+0*t38*t85*t86-6.0d+0*t35*t85*t86-6.0d+0*t35*t83*t84
     2         -8.0d+0*t32*t83*t84-8.0d+0*t32*t81*t82-1.0d+1*t29*t81*t82
     3         -1.0d+1*t29*t79*t80-1.2d+1*t26*t79*t80-1.2d+1*t26*t77*t78
     4         -1.4d+1*t23*t77*t78-1.4d+1*t23*t75*t76-1.6d+1*t20*t75*t76
     5         -1.6d+1*t20*t73*t74-1.8d+1*t17*t73*t74-1.8d+1*t17*t71*t72
     6         -2.0d+1*t14*t71*t72-2.2d+1*t69*t7*t70-2.0d+1*t14*t69*t70-
     7         2.2d+1*t112*t67*t7
            t137 = 1/rhob**7
            t138 = 1/rhob**4.333333333333333d+0
            t139 = -7.46904d-3*t120*t54*t90*t97-3.73452d-3*t57*t90*t91*t
     1         96+4.0d+0*t54*t90*t91*t96-3.73452d-3*gammabb*t138*t56*t96
     2         +2.0d+0*gammabb*t138*t53*t96-7.46904d-3*t120*t137*t49*t94
     3         +2.0d+0*t57*t90*t93-7.46904d-3*gammabb*t120*t138*t53*t91
            t140 = 1/t114
            t141 = 1/t12**13
            t142 = 1/t99
            t143 = 1/t2**3
            t144 = 1/rhoa**7.333333333333333d+0
            t145 = 1/rhoa**4.666666666666667d+0
            t146 = t107**2
            t147 = 1/t46**4
            t148 = 1.6597866666666666d-2*t105*taua+1.8257653333333332d-2
     1         *gammaaa*t145
            t149 = 1/t68**13
            t150 = 1/t111
            t151 = 1/t60**3
            t152 = 1/rhob**7.333333333333333d+0
            t153 = 1/rhob**4.666666666666667d+0
            t154 = t119**2
            t155 = 1/t92**4
            t156 = 1.6597866666666666d-2*t117*taub+1.8257653333333332d-2
     1         *gammabb*t153
            t157 = 1/rhoa**9
            t158 = 1/rhob**9
            t159 = 1/rhoa**6
            t160 = 1/rhoa**3.3333333333333337d+0
            t161 = 1/rhob**6
            t162 = 1/rhob**3.3333333333333337d+0
            fnc(iq) = (1.0d+0*t63*t93*t98-9.305257363490997d-1*t62*t63*t
     1         89+1.0d+0*t47*t5*t58-9.305257363490997d-1*t4*t43*t5)*wght
     2         +fnc(iq)
            Amat(iq,D1_RA) = (-1.0d+0*t107*t5*t52*t58-9.305257363490997d
     1         -1*t106*t43*t5-9.305257363490997d-1*t101*t4*t5+t110*t47-1
     2         .2407009817987995d+0*t102*t4*t43)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (-1.0d+0*t119*t63*t96*t98+t122*t93-9.305257
     1         363490997d-1*t118*t63*t89-1.2407009817987995d+0*t114*t62*
     2         t89-9.305257363490997d-1*t113*t62*t63)*wght+Amat(iq,D1_RB
     3         )
            Cmat(iq,D1_GAA) = (-1.86726d-3*t126*t52*t58+1.0d+0*t125*t47*
     1         t5-9.305257363490997d-1*t123*t43*t5)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (-1.86726d-3*t130*t96*t98+1.0d+0*t129*t63*
     1         t93-9.305257363490997d-1*t127*t63*t89)*wght+Cmat(iq,D1_GB
     2         B)
            Mmat(iq,D1_TA) = (-3.73452d-3*t135*t52*t58+1.0d+0*t134*t47*t
     1         5-9.305257363490997d-1*t131*t4*t5)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = (-3.73452d-3*t140*t96*t98+1.0d+0*t139*t63*t
     1         93-9.305257363490997d-1*t136*t62*t63)*wght+Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = (t47*(1.0d+0*t5*(2.2222222222222224d+1*
     1         t51*t52*t54*taua**2+6.666666666666667d+0*t1*t107*t52*t57*
     2         taua+8.88888888888889d+0*t105*t47*t57*taua+1.777777777777
     3         7778d+1*t105*t45*t52*t54*taua+2.6666666666666666d+1*t1*t1
     4         07*t108*t45*t54*taua+2.6666666666666666d+1*gammaaa*t104*t
     5         52*t53*taua+1.3333333333333333d+1*gammaaa*t107*t108*t51*t
     6         53*taua-t148*t45*t52*t57+2*t108*t146*t45*t57-gammaaa*t1*t
     7         148*t52*t56+5.333333333333333d+0*gammaaa*t105*t107*t52*t5
     8         6+9.777777777777779d+0*gammaaa*t145*t47*t56+2*gammaaa*t1*
     9         t108*t146*t56-2*t108*t148*t54*t55+6*t146*t147*t54*t55+9.7
     :         77777777777779d+0*gammaaa*t145*t45*t52*t53-2*gammaaa*t1*t
     ;         108*t148*t45*t53+6*gammaaa*t1*t146*t147*t45*t53+1.0666666
     <         666666666d+1*gammaaa*t105*t107*t108*t45*t53+3.37777777777
     =         7778d+1*t144*t49*t50*t52-2*t108*t148*t49*t50*t51+6*t146*t
     >         147*t49*t50*t51+2.1333333333333332d+1*t104*t107*t108*t49*
     ?         t50)+4.444444444444444d-1*t142*t58+2.6666666666666666d+0*
     @         t102*t109)-9.305257363490997d-1*t4*t5*(2.5389881826654315
     1         d+4*t13*t18*t5*t7-5.585774001863949d+4*t100*t15*t5*t7+3.0
     2         46785819198518d+4*t11*t141*t5*t7+1.1141288576844789d+2*t1
     3         3*t135*t15*t7-1.1141288576844789d+2*t100*t11*t135*t7-4.61
     4         63421503007845d+2*t40*t41*t5+4.6163421503007845d+2*t10*t3
     5         7*t41*t5+4.6163421503007845d+2*t38*t40*t5+1.3849026450902
     6         355d+3*t34*t38*t39*t5-4.1547079352707067d+3*t34*t35*t39*t
     7         5+2.769805290180471d+3*t32*t34*t39*t5-1.846536860120314d+
     8         3*t10*t37*t38*t5+1.3849026450902355d+3*t10*t35*t37*t5+2.7
     9         69805290180471d+3*t31*t35*t36*t5-7.386147440481255d+3*t31
     :         *t32*t36*t5+4.616342150300784d+3*t29*t31*t36*t5+4.6163421
     ;         50300784d+3*t28*t32*t33*t5-1.154085537575196d+4*t28*t29*t
     <         33*t5+6.924513225451178d+3*t26*t28*t33*t5+6.9245132254511
     =         78d+3*t25*t29*t30*t5-1.661883174108283d+4*t25*t26*t30*t5+
     >         9.694318515631648d+3*t23*t25*t30*t5+9.694318515631648d+3*
     ?         t22*t26*t27*t5-2.2620076536473846d+4*t22*t23*t27*t5+1.292
     @         5758020842196d+4*t20*t22*t27*t5+1.2925758020842196d+4*t19
     1         *t23*t24*t5-2.954458976192502d+4*t19*t20*t24*t5+1.6618831
     2         741082823d+4*t17*t19*t24*t5+1.6618831741082823d+4*t16*t20
     3         *t21*t5-3.7392371417436354d+4*t16*t17*t21*t5+2.0773539676
     4         353528d+4*t14*t16*t21*t5+2.0773539676353528d+4*t13*t17*t1
     5         8*t5-4.616342150300784d+4*t13*t14*t18*t5+2.53898818266543
     6         15d+4*t100*t14*t15*t5+1.0128444160767991d+1*t135*t41*t42-
     7         1.0128444160767991d+1*t10*t135*t40*t41+2.0256888321535982
     8         d+1*t10*t135*t38*t40-2.0256888321535982d+1*t135*t37*t38*t
     9         39+3.038533248230397d+1*t135*t35*t37*t39-3.03853324823039
     :         7d+1*t135*t34*t35*t36+4.0513776643071964d+1*t135*t32*t34*
     ;         t36-4.0513776643071964d+1*t135*t31*t32*t33+5.064222080383
     <         994d+1*t135*t29*t31*t33-5.064222080383994d+1*t135*t28*t29
     =         *t30+6.077066496460795d+1*t135*t26*t28*t30-6.077066496460
     >         795d+1*t135*t25*t26*t27+7.089910912537593d+1*t135*t23*t25
     ?         *t27-7.089910912537593d+1*t135*t22*t23*t24+8.102755328614
     @         393d+1*t135*t20*t22*t24-8.102755328614393d+1*t135*t19*t20
     1         *t21+9.115599744691191d+1*t135*t17*t19*t21-9.115599744691
     2         191d+1*t135*t16*t17*t18+1.012844416076799d+2*t135*t14*t16
     3         *t18-1.012844416076799d+2*t13*t135*t14*t15)+t52*(-1.0d+0*
     4         t148*t5*t58-1.3333333333333333d+0*t102*t107*t58-1.0d+0*t1
     5         07*t109*t5-t107*t110)+2.0d+0*t108*t146*t5*t58-9.305257363
     6         490997d-1*t43*t5*(-3.8948928286386303d-4*t103*t144*t50+3.
     7         531915643569816d-2*gammaaa*t145*t3+1.0369691626335495d-6*
     8         gammaaa**3*t143/rhoa**10)-1.8610514726981994d+0*t101*t106
     9         *t5-4.1356699393293317d-1*t142*t4*t43-2.481401963597599d+
     :         0*t102*t106*t43-2.481401963597599d+0*t101*t102*t4)*wght+A
     ;         mat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (t93*(1.0d+0*t63*(2.2222222222222224d+1
     1         *t54*t95*t96*taub**2+1.7777777777777778d+1*t117*t54*t91*t
     2         96*taub+6.666666666666667d+0*t119*t57*t59*t96*taub+2.6666
     3         666666666666d+1*gammabb*t116*t53*t96*taub+1.3333333333333
     4         333d+1*gammabb*t119*t120*t53*t95*taub+8.88888888888889d+0
     5         *t117*t57*t93*taub+2.6666666666666666d+1*t119*t120*t54*t5
     6         9*t91*taub-2*t120*t156*t54*t97+6*t154*t155*t54*t97+3.3777
     7         77777777778d+1*t152*t49*t94*t96-t156*t57*t91*t96+9.777777
     8         777777779d+0*gammabb*t153*t53*t91*t96-gammabb*t156*t56*t5
     9         9*t96+5.333333333333333d+0*gammabb*t117*t119*t56*t96-2*t1
     :         20*t156*t49*t94*t95+6*t154*t155*t49*t94*t95+2.13333333333
     ;         33332d+1*t116*t119*t120*t49*t94+9.777777777777779d+0*gamm
     <         abb*t153*t56*t93-2*gammabb*t120*t156*t53*t59*t91+6*gammab
     =         b*t154*t155*t53*t59*t91+2*t120*t154*t57*t91+1.06666666666
     >         66666d+1*gammabb*t117*t119*t120*t53*t91+2*gammabb*t120*t1
     ?         54*t56*t59)+4.444444444444444d-1*t150*t98+2.6666666666666
     @         666d+0*t114*t121)+t96*(-1.0d+0*t156*t63*t98-1.33333333333
     1         33333d+0*t114*t119*t98-1.0d+0*t119*t121*t63-t119*t122)+2.
     2         0d+0*t120*t154*t63*t98-9.305257363490997d-1*t63*t89*(-3.8
     3         948928286386303d-4*t115*t152*t94+3.531915643569816d-2*gam
     4         mabb*t153*t61+1.0369691626335495d-6*gammabb**3*t151/rhob*
     5         *10)-4.1356699393293317d-1*t150*t62*t89-2.481401963597599
     6         d+0*t114*t118*t89-9.305257363490997d-1*t62*t63*(1.0128444
     7         160767991d+1*t140*t41*t88-1.0128444160767991d+1*t140*t41*
     8         t66*t87+2.0256888321535982d+1*t140*t38*t66*t87-4.61634215
     9         03007845d+2*t41*t63*t87+4.6163421503007845d+2*t38*t63*t87
     :         -2.0256888321535982d+1*t140*t38*t85*t86+3.038533248230397
     ;         d+1*t140*t35*t85*t86+1.3849026450902355d+3*t38*t63*t83*t8
     <         6-4.1547079352707067d+3*t35*t63*t83*t86+2.769805290180471
     =         d+3*t32*t63*t83*t86+4.6163421503007845d+2*t41*t63*t66*t85
     >         -1.846536860120314d+3*t38*t63*t66*t85+1.3849026450902355d
     ?         +3*t35*t63*t66*t85-3.038533248230397d+1*t140*t35*t83*t84+
     @         4.0513776643071964d+1*t140*t32*t83*t84+2.769805290180471d
     1         +3*t35*t63*t81*t84-7.386147440481255d+3*t32*t63*t81*t84+4
     2         .616342150300784d+3*t29*t63*t81*t84-4.0513776643071964d+1
     3         *t140*t32*t81*t82+5.064222080383994d+1*t140*t29*t81*t82+4
     4         .616342150300784d+3*t32*t63*t79*t82-1.154085537575196d+4*
     5         t29*t63*t79*t82+6.924513225451178d+3*t26*t63*t79*t82-5.06
     6         4222080383994d+1*t140*t29*t79*t80+6.077066496460795d+1*t1
     7         40*t26*t79*t80+6.924513225451178d+3*t29*t63*t77*t80-1.661
     8         883174108283d+4*t26*t63*t77*t80+9.694318515631648d+3*t23*
     9         t63*t77*t80-6.077066496460795d+1*t140*t26*t77*t78+7.08991
     :         0912537593d+1*t140*t23*t77*t78+9.694318515631648d+3*t26*t
     ;         63*t75*t78-2.2620076536473846d+4*t23*t63*t75*t78+1.292575
     <         8020842196d+4*t20*t63*t75*t78-7.089910912537593d+1*t140*t
     =         23*t75*t76+8.102755328614393d+1*t140*t20*t75*t76+1.292575
     >         8020842196d+4*t23*t63*t73*t76-2.954458976192502d+4*t20*t6
     ?         3*t73*t76+1.6618831741082823d+4*t17*t63*t73*t76-8.1027553
     @         28614393d+1*t140*t20*t73*t74+9.115599744691191d+1*t140*t1
     1         7*t73*t74+1.6618831741082823d+4*t20*t63*t71*t74-3.7392371
     2         417436354d+4*t17*t63*t71*t74+2.0773539676353528d+4*t14*t6
     3         3*t71*t74-9.115599744691191d+1*t140*t17*t71*t72+1.0128444
     4         16076799d+2*t14*t140*t71*t72+2.5389881826654315d+4*t63*t6
     5         9*t7*t72+2.0773539676353528d+4*t17*t63*t69*t72-4.61634215
     6         0300784d+4*t14*t63*t69*t72+1.1141288576844789d+2*t140*t69
     7         *t7*t70-5.585774001863949d+4*t112*t63*t7*t70-1.0128444160
     8         76799d+2*t14*t140*t69*t70+2.5389881826654315d+4*t112*t14*
     9         t63*t70+3.046785819198518d+4*t149*t63*t67*t7-1.1141288576
     :         844789d+2*t112*t140*t67*t7)-1.8610514726981994d+0*t113*t1
     ;         18*t63-2.481401963597599d+0*t113*t114*t62)*wght+Amat2(iq,
     <         D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = (t47*(1.0d+0*t5*(6.2242d-3*t51*t52*t57
     1         *taua+2.48968d-2*t108*t45*t51*t54*taua-3.3333333333333337
     2         d+0*t51*t52*t53*taua+1.24484d-2*gammaaa*t108*t124*t53*tau
     3         a+4.9793599999999993d-3*t105*t45*t52*t57+3.73452d-3*t1*t1
     4         07*t108*t45*t57-t1*t107*t52*t56+9.958719999999999d-3*gamm
     5         aaa*t104*t52*t56+3.73452d-3*gammaaa*t107*t108*t51*t56-2.6
     6         666666666666666d+0*t105*t47*t56+1.120356d-2*t1*t107*t147*
     7         t54*t55+9.958719999999999d-3*t105*t108*t54*t55-2.66666666
     8         66666666d+0*t105*t45*t52*t53+1.120356d-2*gammaaa*t107*t14
     9         7*t45*t51*t53-2*t1*t107*t108*t45*t53+1.9917439999999997d-
     :         2*gammaaa*t104*t108*t45*t53-1.0666666666666666d+1*gammaaa
     ;         *t104*t49*t52-4*gammaaa*t107*t108*t49*t51+2.9876159999999
     <         996d-2*t108*t157*t49*t50+1.120356d-2*t107*t124*t147*t49*t
     =         50)+1.3333333333333333d+0*t102*t125)+4.9793599999999993d-
     >         3*t52*t58/rhoa**2.3333333333333334d+0+3.73452d-3*t107*t10
     ?         8*t126*t58-1.0d+0*t107*t125*t5*t52-1.86726d-3*t1*t110*t52
     @         -9.305257363490997d-1*t43*t5*(-3.8886343598758105d-7*t143
     1         *t157*t50-9.632497209735863d-3*t105*t3+1.29829760954621d-
     2         4*gammaaa*t103*t104)-9.305257363490997d-1*t101*t123*t5-1.
     3         2407009817987995d+0*t102*t123*t43)*wght+Cmat2(iq,D2_RA_GA
     4         A)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = (t93*(1.0d+0*t63*(6.2242d-3*t57*t95*t9
     1         6*taub-3.3333333333333337d+0*t53*t95*t96*taub+2.48968d-2*
     2         t120*t54*t91*t95*taub+1.24484d-2*gammabb*t120*t128*t53*ta
     3         ub+1.120356d-2*t119*t155*t54*t59*t97+9.958719999999999d-3
     4         *t117*t120*t54*t97+4.9793599999999993d-3*t117*t57*t91*t96
     5         -2.6666666666666666d+0*t117*t53*t91*t96-t119*t56*t59*t96+
     6         9.958719999999999d-3*gammabb*t116*t56*t96-1.0666666666666
     7         666d+1*gammabb*t116*t49*t96+1.120356d-2*gammabb*t119*t155
     8         *t53*t91*t95+3.73452d-3*gammabb*t119*t120*t56*t95-4*gamma
     9         bb*t119*t120*t49*t95+2.9876159999999996d-2*t120*t158*t49*
     :         t94+1.120356d-2*t119*t128*t155*t49*t94-2.6666666666666666
     ;         d+0*t117*t56*t93+3.73452d-3*t119*t120*t57*t59*t91-2*t119*
     <         t120*t53*t59*t91+1.9917439999999997d-2*gammabb*t116*t120*
     =         t53*t91)+1.3333333333333333d+0*t114*t129)+4.9793599999999
     >         993d-3*t96*t98/rhob**2.3333333333333334d+0+3.73452d-3*t11
     ?         9*t120*t130*t98-1.0d+0*t119*t129*t63*t96-1.86726d-3*t122*
     @         t59*t96-9.305257363490997d-1*t63*t89*(-3.8886343598758105
     1         d-7*t151*t158*t94-9.632497209735863d-3*t117*t61+1.2982976
     2         0954621d-4*gammabb*t115*t116)-1.2407009817987995d+0*t114*
     3         t127*t89-9.305257363490997d-1*t113*t127*t63)*wght+Cmat2(i
     4         q,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = (6.973319815199999d-6*t108*t58/rhoa**
     1         4+1.0d+0*t47*t5*(6.973319815199999d-6*t108*t45*t51*t57-3.
     2         73452d-3*t51*t52*t56+6.973319815199999d-6*gammaaa*t108*t1
     3         24*t56+2.0919959445599998d-5*t147*t51*t54*t55-7.46904d-3*
     4         t108*t45*t51*t53+2.0919959445599998d-5*gammaaa*t124*t147*
     5         t45*t53+2*t49*t51*t52+2.0919959445599998d-5*t147*t49*t50/
     6         rhoa**1.0666666666666666d+1-1.4938079999999998d-2*gammaaa
     7         *t108*t124*t49)-3.73452d-3*t125*t126*t52-9.30525736349099
     8         7d-1*t43*t5*(1.4582378849534292d-7*gammaaa*t124*t143-3.24
     9         57440238655255d-5*t103*t51))*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = (6.973319815199999d-6*t120*t98/rhob**
     1         4+1.0d+0*t63*t93*(2.0919959445599998d-5*t155*t54*t95*t97-
     2         3.73452d-3*t56*t95*t96+2*t49*t95*t96+6.973319815199999d-6
     3         *t120*t57*t91*t95-7.46904d-3*t120*t53*t91*t95+2.091995944
     4         5599998d-5*t155*t49*t94/rhob**1.0666666666666666d+1+2.091
     5         9959445599998d-5*gammabb*t128*t155*t53*t91+6.973319815199
     6         999d-6*gammabb*t120*t128*t56-1.4938079999999998d-2*gammab
     7         b*t120*t128*t49)-3.73452d-3*t129*t130*t96-9.3052573634909
     8         97d-1*t63*t89*(1.4582378849534292d-7*gammabb*t128*t151-3.
     9         2457440238655255d-5*t115*t95))*wght+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RA_TA) = (t47*(1.0d+0*t5*(1.24484d-2*t133*t52*t5
     1         7*taua-1.3333333333333333d+1*t133*t52*t54*taua+4.97936d-2
     2         *t108*t133*t45*t54*taua+2.48968d-2*gammaaa*t108*t132*t53*
     3         taua+6.2242d-3*t1*t45*t52*t57-2.0d+0*t107*t44*t52*t57-3.3
     4         333333333333337d+0*t1*t47*t57+7.46904d-3*t107*t108*t44*t4
     5         5*t57+1.618292d-2*gammaaa*t51*t52*t56+7.46904d-3*gammaaa*
     6         t107*t108*t133*t56+2.240712d-2*t107*t147*t44*t54*t55+1.24
     7         484d-2*t1*t108*t54*t55-6.666666666666667d+0*t1*t45*t52*t5
     8         4-8.0d+0*t107*t108*t44*t45*t54-8.666666666666666d+0*gamma
     9         aa*t51*t52*t53+3.236584d-2*gammaaa*t108*t45*t51*t53+2.240
     :         712d-2*gammaaa*t107*t133*t147*t45*t53-4.0d+0*gammaaa*t107
     ;         *t108*t133*t53+2.240712d-2*t107*t132*t147*t49*t50+5.22832
     <         8d-2*t108*t124*t49*t50)+1.3333333333333333d+0*t102*t134)-
     =         9.305257363490997d-1*t4*t5*(-3.342386573053437d+3*t13*t18
     >         *t7*t99+4.0108638876641245d+3*t11*t141*t7*t99+6.077066496
     ?         460795d+1*t10*t37*t41*t99-6.077066496460795d+1*t38*t40*t9
     @         9+1.8231199489382385d+2*t34*t38*t39*t99-3.646239897876477
     1         d+2*t32*t34*t39*t99-1.8231199489382385d+2*t10*t35*t37*t99
     2         +3.646239897876477d+2*t31*t35*t36*t99-6.077066496460795d+
     3         2*t29*t31*t36*t99+6.077066496460795d+2*t28*t32*t33*t99-9.
     4         115599744691192d+2*t26*t28*t33*t99+9.115599744691192d+2*t
     5         25*t29*t30*t99-1.276183964256767d+3*t23*t25*t30*t99+1.276
     6         183964256767d+3*t22*t26*t27*t99-1.7015786190090226d+3*t20
     7         *t22*t27*t99+1.7015786190090226d+3*t19*t23*t24*t99-2.1877
     8         43938725886d+3*t17*t19*t24*t99+2.187743938725886d+3*t16*t
     9         20*t21*t99-2.734679923407357d+3*t14*t16*t21*t99+2.7346799
     :         23407357d+3*t13*t17*t18*t99+3.342386573053437d+3*t100*t14
     ;         *t15*t99)+6.2242d-3*t126*t52*t58+7.46904d-3*t107*t108*t13
     <         5*t58-1.0d+0*t107*t134*t5*t52-3.73452d-3*t110*t44*t52-9.3
     =         05257363490997d-1*t106*t131*t5-1.2407009817987995d+0*t102
     >         *t131*t4)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = (t93*(1.0d+0*t63*(1.24484d-2*t138*t57*t
     1         96*taub-1.3333333333333333d+1*t138*t54*t96*taub+4.97936d-
     2         2*t120*t138*t54*t91*taub+2.48968d-2*gammabb*t120*t137*t53
     3         *taub+2.240712d-2*t119*t155*t54*t90*t97+1.24484d-2*t120*t
     4         54*t59*t97+1.618292d-2*gammabb*t56*t95*t96-8.666666666666
     5         666d+0*gammabb*t53*t95*t96+6.2242d-3*t57*t59*t91*t96-6.66
     6         6666666666667d+0*t54*t59*t91*t96-2.0d+0*t119*t57*t90*t96+
     7         3.236584d-2*gammabb*t120*t53*t91*t95+2.240712d-2*t119*t13
     8         7*t155*t49*t94+5.228328d-2*t120*t128*t49*t94-3.3333333333
     9         333337d+0*t57*t59*t93+7.46904d-3*t119*t120*t57*t90*t91-8.
     :         0d+0*t119*t120*t54*t90*t91+2.240712d-2*gammabb*t119*t138*
     ;         t155*t53*t91+7.46904d-3*gammabb*t119*t120*t138*t56-4.0d+0
     <         *gammabb*t119*t120*t138*t53)+1.3333333333333333d+0*t114*t
     =         139)+6.2242d-3*t130*t96*t98+7.46904d-3*t119*t120*t140*t98
     >         -3.73452d-3*t122*t90*t96-1.0d+0*t119*t139*t63*t96-9.30525
     ?         7363490997d-1*t62*t63*(-6.077066496460795d+1*t111*t38*t87
     @         +1.8231199489382385d+2*t111*t38*t83*t86-3.646239897876477
     1         d+2*t111*t32*t83*t86+6.077066496460795d+1*t111*t41*t66*t8
     2         5-1.8231199489382385d+2*t111*t35*t66*t85+3.64623989787647
     3         7d+2*t111*t35*t81*t84-6.077066496460795d+2*t111*t29*t81*t
     4         84+6.077066496460795d+2*t111*t32*t79*t82-9.11559974469119
     5         2d+2*t111*t26*t79*t82+9.115599744691192d+2*t111*t29*t77*t
     6         80-1.276183964256767d+3*t111*t23*t77*t80+1.27618396425676
     7         7d+3*t111*t26*t75*t78-1.7015786190090226d+3*t111*t20*t75*
     8         t78+1.7015786190090226d+3*t111*t23*t73*t76-2.187743938725
     9         886d+3*t111*t17*t73*t76+2.187743938725886d+3*t111*t20*t71
     :         *t74-2.734679923407357d+3*t111*t14*t71*t74-3.342386573053
     ;         437d+3*t111*t69*t7*t72+2.734679923407357d+3*t111*t17*t69*
     <         t72+3.342386573053437d+3*t111*t112*t14*t70+4.010863887664
     =         1245d+3*t111*t149*t67*t7)-9.305257363490997d-1*t118*t136*
     >         t63-1.2407009817987995d+0*t114*t136*t62)*wght+Mmat2(iq,D2
     ?         _RB_TB)
            Mmat2(iq,D2_GAA_TA) = (1.3946639630399998d-5*t108*t58/rhoa**
     1         3+1.0d+0*t47*t5*(-3.73452d-3*t133*t52*t57+1.3946639630399
     2         998d-5*t108*t133*t45*t57-3.73452d-3*t133*t52*t56+1.394663
     3         9630399998d-5*gammaaa*t108*t132*t56+4.1839918891199995d-5
     4         *t133*t147*t54*t55-1.4938079999999998d-2*t108*t133*t45*t5
     5         4+2.0d+0*t133*t52*t53+4.1839918891199995d-5*gammaaa*t132*
     6         t147*t45*t53-7.46904d-3*t108*t133*t45*t53-7.46904d-3*gamm
     7         aaa*t108*t132*t53+4.1839918891199995d-5*t147*t49*t50/rhoa
     8         **9.666666666666666d+0-1.4938079999999998d-2*gammaaa*t108
     9         *t132*t49)-3.73452d-3*t125*t135*t52-1.86726d-3*t126*t134*
     :         t52-9.305257363490997d-1*t123*t131*t5)*wght+Mmat2(iq,D2_G
     ;         AA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = (1.3946639630399998d-5*t120*t98/rhob**
     1         3+1.0d+0*t63*t93*(4.1839918891199995d-5*t138*t155*t54*t97
     2         -3.73452d-3*t138*t57*t96-3.73452d-3*t138*t56*t96+2.0d+0*t
     3         138*t53*t96+4.1839918891199995d-5*t155*t49*t94/rhob**9.66
     4         6666666666666d+0+1.3946639630399998d-5*t120*t138*t57*t91-
     5         1.4938079999999998d-2*t120*t138*t54*t91+4.183991889119999
     6         5d-5*gammabb*t137*t155*t53*t91-7.46904d-3*t120*t138*t53*t
     7         91+1.3946639630399998d-5*gammabb*t120*t137*t56-7.46904d-3
     8         *gammabb*t120*t137*t53-1.4938079999999998d-2*gammabb*t120
     9         *t137*t49)-3.73452d-3*t129*t140*t96-1.86726d-3*t130*t139*
     :         t96-9.305257363490997d-1*t127*t136*t63)*wght+Mmat2(iq,D2_
     ;         GBB_TB)
            Mmat2(iq,D2_TA_TA) = (-9.305257363490997d-1*t4*t5*(4.4d+2*t1
     1         3*t18*t7+9.68d+2*t100*t15*t7+5.28d+2*t11*t141*t7+8.0d+0*t
     2         40*t41+8.0d+0*t10*t37*t41+8.0d+0*t38*t40+2.4d+1*t34*t38*t
     3         39+7.2d+1*t34*t35*t39+4.8d+1*t32*t34*t39+3.2d+1*t10*t37*t
     4         38+2.4d+1*t10*t35*t37+4.8d+1*t31*t35*t36+1.28d+2*t31*t32*
     5         t36+8.0d+1*t29*t31*t36+8.0d+1*t28*t32*t33+2.0d+2*t28*t29*
     6         t33+1.2d+2*t26*t28*t33+1.2d+2*t25*t29*t30+2.88d+2*t25*t26
     7         *t30+1.68d+2*t23*t25*t30+1.68d+2*t22*t26*t27+3.92d+2*t22*
     8         t23*t27+2.24d+2*t20*t22*t27+2.24d+2*t19*t23*t24+5.12d+2*t
     9         19*t20*t24+2.88d+2*t17*t19*t24+2.88d+2*t16*t20*t21+6.48d+
     :         2*t16*t17*t21+3.6d+2*t14*t16*t21+3.6d+2*t13*t17*t18+8.0d+
     ;         2*t13*t14*t18+4.4d+2*t100*t14*t15)+2.7893279260799997d-5*
     <         t108*t58/rhoa**2+1.0d+0*t47*t5*(-1.4938079999999998d-2*t1
     =         60*t52*t57+2.7893279260799997d-5*t108*t160*t45*t57+2.7893
     >         279260799997d-5*gammaaa*t108*t159*t56+8.367983778239999d-
     ?         5*t147*t160*t54*t55+8.0d+0*t160*t52*t54-5.975231999999999
     @         d-2*t108*t160*t45*t54+8.367983778239999d-5*gammaaa*t147*t
     1         159*t45*t53-2.9876159999999996d-2*gammaaa*t108*t159*t53+8
     2         .367983778239999d-5*t147*t49*t50/rhoa**8.666666666666666d
     3         +0)-7.46904d-3*t134*t135*t52)*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = (2.7893279260799997d-5*t120*t98/rhob**2
     1         +1.0d+0*t63*t93*(8.367983778239999d-5*t155*t162*t54*t97-1
     2         .4938079999999998d-2*t162*t57*t96+8.0d+0*t162*t54*t96+8.3
     3         67983778239999d-5*t155*t49*t94/rhob**8.666666666666666d+0
     4         +2.7893279260799997d-5*t120*t162*t57*t91-5.97523199999999
     5         9d-2*t120*t162*t54*t91+8.367983778239999d-5*gammabb*t155*
     6         t161*t53*t91+2.7893279260799997d-5*gammabb*t120*t161*t56-
     7         2.9876159999999996d-2*gammabb*t120*t161*t53)-7.46904d-3*t
     8         139*t140*t96-9.305257363490997d-1*t62*t63*(8.0d+0*t41*t87
     9         +8.0d+0*t38*t87+2.4d+1*t38*t83*t86+7.2d+1*t35*t83*t86+4.8
     :         d+1*t32*t83*t86+8.0d+0*t41*t66*t85+3.2d+1*t38*t66*t85+2.4
     ;         d+1*t35*t66*t85+4.8d+1*t35*t81*t84+1.28d+2*t32*t81*t84+8.
     <         0d+1*t29*t81*t84+8.0d+1*t32*t79*t82+2.0d+2*t29*t79*t82+1.
     =         2d+2*t26*t79*t82+1.2d+2*t29*t77*t80+2.88d+2*t26*t77*t80+1
     >         .68d+2*t23*t77*t80+1.68d+2*t26*t75*t78+3.92d+2*t23*t75*t7
     ?         8+2.24d+2*t20*t75*t78+2.24d+2*t23*t73*t76+5.12d+2*t20*t73
     @         *t76+2.88d+2*t17*t73*t76+2.88d+2*t20*t71*t74+6.48d+2*t17*
     1         t71*t74+3.6d+2*t14*t71*t74+4.4d+2*t69*t7*t72+3.6d+2*t17*t
     2         69*t72+8.0d+2*t14*t69*t72+9.68d+2*t112*t7*t70+4.4d+2*t112
     3         *t14*t70+5.28d+2*t149*t67*t7))*wght+Mmat2(iq,D2_TB_TB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammaaa*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammaaa*t1*t3+1.0d+0
            t5 = rhoa**1.3333333333333333d+0
            t6 = param(18)
            t7 = rhoa**1.6666666666666669d+0
            t8 = 9.115599744691192d+0*t7
            t9 = t8-2.0d+0*taua
            t10 = t9**11
            t11 = 2.0d+0*taua+t8
            t12 = 1/t11**11
            t13 = param(17)
            t14 = t9**10
            t15 = 1/t11**10
            t16 = param(16)
            t17 = t9**9
            t18 = 1/t11**9
            t19 = param(15)
            t20 = t9**8
            t21 = 1/t11**8
            t22 = param(14)
            t23 = t9**7
            t24 = 1/t11**7
            t25 = param(13)
            t26 = t9**6
            t27 = 1/t11**6
            t28 = param(12)
            t29 = t9**5
            t30 = 1/t11**5
            t31 = param(11)
            t32 = t9**4
            t33 = 1/t11**4
            t34 = param(10)
            t35 = t9**3
            t36 = 1/t11**3
            t37 = param(9)
            t38 = t9**2
            t39 = 1/t11**2
            t40 = param(8)
            t41 = 1/t11
            t42 = t40*t41*t9+t10*t12*t6+t37*t38*t39+t34*t35*t36+t31*t32*
     1         t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19*t20*t21+t16*t
     2         17*t18+t13*t14*t15+param(7)
            t43 = 1/t7
            t44 = 2.0d+0*t43*taua-9.11559972d+0
            t45 = 1.86726d-3*t44+1.86726d-3*gammaaa*t1+1.0d+0
            t46 = 1/t45
            t47 = param(4)
            t48 = gammaaa**2
            t49 = 1/rhoa**5.333333333333333d+0
            t50 = 1/t45**2
            t51 = param(5)
            t52 = param(6)
            t53 = t44**2
            t54 = param(2)
            t55 = param(3)
            t56 = t44*t46*t55+gammaaa*t1*t46*t54+t50*t52*t53+gammaaa*t1*
     1         t44*t50*t51+t47*t48*t49*t50+param(1)
            t57 = rhoa**6.666666666666666d-1
            t58 = 1/t11**12
            t59 = -1.5192666241151986d+1*t39*t40*t57*t9+3.03853324823039
     1         7d+1*t37*t39*t57*t9-1.6711932865267184d+2*t10*t57*t58*t6+
     2         1.6711932865267184d+2*t12*t14*t57*t6+1.5192666241151986d+
     3         1*t40*t41*t57-3.038533248230397d+1*t36*t37*t38*t57+4.5577
     4         998723455965d+1*t34*t36*t38*t57-4.5577998723455965d+1*t33
     5         *t34*t35*t57+6.077066496460795d+1*t31*t33*t35*t57-6.07706
     6         6496460795d+1*t30*t31*t32*t57+7.596333120575993d+1*t28*t3
     7         0*t32*t57-7.596333120575993d+1*t27*t28*t29*t57+9.11559974
     8         4691193d+1*t25*t27*t29*t57-9.115599744691193d+1*t24*t25*t
     9         26*t57+1.0634866368806391d+2*t22*t24*t26*t57-1.0634866368
     :         806391d+2*t21*t22*t23*t57+1.2154132992921589d+2*t19*t21*t
     ;         23*t57-1.2154132992921589d+2*t18*t19*t20*t57+1.3673399617
     <         036788d+2*t16*t18*t20*t57-1.3673399617036788d+2*t15*t16*t
     =         17*t57+1.5192666241151986d+2*t13*t15*t17*t57-1.5192666241
     >         151986d+2*t12*t13*t14*t57
            t60 = rhoa**3.333333333333333d-1
            t61 = 1/t2**2
            t62 = 1/rhoa**6.333333333333333d+0
            t63 = 1/rhoa**3.6666666666666664d+0
            t64 = 4.327658698487368d-5*t48*t61*t62-9.632497209735863d-3*
     1         gammaaa*t3*t63
            t65 = -6.2242d-3*t1*taua-4.9793599999999993d-3*gammaaa*t63
            t66 = 1/t45**3
            t67 = -3.3333333333333337d+0*t1*t46*t55*taua-6.6666666666666
     1         67d+0*t1*t44*t50*t52*taua-3.3333333333333337d+0*gammaaa*t
     2         49*t50*t51*taua-2*t52*t53*t65*t66-2*gammaaa*t1*t44*t51*t6
     3         5*t66-2*t47*t48*t49*t65*t66-t44*t50*t55*t65-gammaaa*t1*t5
     4         0*t54*t65-2.6666666666666666d+0*gammaaa*t46*t54*t63-2.666
     5         6666666666666d+0*gammaaa*t44*t50*t51*t63-5.33333333333333
     6         3d+0*t47*t48*t50*t62
            t68 = 1.0d+0*t5*t67+1.3333333333333333d+0*t56*t60
            t69 = 3.6121864536509485d-3*t1*t3-1.6228720119327628d-5*gamm
     1         aaa*t49*t61
            t70 = 1/rhoa**8
            t71 = -3.73452d-3*t47*t48*t66*t70-3.73452d-3*t1*t52*t53*t66-
     1         3.73452d-3*gammaaa*t44*t49*t51*t66-1.86726d-3*t1*t44*t50*
     2         t55-1.86726d-3*gammaaa*t49*t50*t54+t1*t46*t54+t1*t44*t50*
     3         t51+2*gammaaa*t47*t49*t50
            t72 = 1/t5
            t73 = -2.0d+0*t39*t40*t9-4.0d+0*t37*t39*t9-2.2d+1*t10*t58*t6
     1         -2.2d+1*t12*t14*t6-2.0d+0*t40*t41-4.0d+0*t36*t37*t38-6.0d
     2         +0*t34*t36*t38-6.0d+0*t33*t34*t35-8.0d+0*t31*t33*t35-8.0d
     3         +0*t30*t31*t32-1.0d+1*t28*t30*t32-1.0d+1*t27*t28*t29-1.2d
     4         +1*t25*t27*t29-1.2d+1*t24*t25*t26-1.4d+1*t22*t24*t26-1.4d
     5         +1*t21*t22*t23-1.6d+1*t19*t21*t23-1.6d+1*t18*t19*t20-1.8d
     6         +1*t16*t18*t20-1.8d+1*t15*t16*t17-2.0d+1*t13*t15*t17-2.0d
     7         +1*t12*t13*t14
            t74 = 1/rhoa**7
            t75 = 1/rhoa**4.333333333333333d+0
            t76 = -7.46904d-3*gammaaa*t44*t51*t66*t75-3.73452d-3*gammaaa
     1         *t50*t54*t75+2.0d+0*gammaaa*t50*t51*t75-7.46904d-3*t47*t4
     2         8*t66*t74-7.46904d-3*t43*t52*t53*t66-3.73452d-3*t43*t44*t
     3         50*t55+2.0d+0*t43*t46*t55+4.0d+0*t43*t44*t50*t52
            t77 = 1/t60
            t78 = 1/t11**13
            t79 = 1/t57
            t80 = 1/t2**3
            t81 = 1/rhoa**7.333333333333333d+0
            t82 = 1/rhoa**4.666666666666667d+0
            t83 = t65**2
            t84 = 1/t45**4
            t85 = 1.6597866666666666d-2*t63*taua+1.8257653333333332d-2*g
     1         ammaaa*t82
            t86 = 1/rhoa**9
            t87 = 1/rhoa**6
            t88 = 1/rhoa**3.3333333333333337d+0
            fnc(iq) = (1.0d+0*t46*t5*t56-9.305257363490997d-1*t4*t42*t5)
     1         *wght+fnc(iq)
            Amat(iq,D1_RA) = (t46*t68-1.0d+0*t5*t50*t56*t65-9.3052573634
     1         90997d-1*t42*t5*t64-1.2407009817987995d+0*t4*t42*t60-9.30
     2         5257363490997d-1*t4*t5*t59)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (-1.86726d-3*t50*t56*t72+1.0d+0*t46*t5*t71
     1         -9.305257363490997d-1*t42*t5*t69)*wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = (-3.73452d-3*t50*t56*t77+1.0d+0*t46*t5*t76-
     1         9.305257363490997d-1*t4*t5*t73)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = (t46*(1.0d+0*t5*(2.2222222222222224d+1*
     1         t49*t50*t52*taua**2+2.6666666666666666d+1*t1*t44*t52*t65*
     2         t66*taua+1.3333333333333333d+1*gammaaa*t49*t51*t65*t66*ta
     3         ua+6.666666666666667d+0*t1*t50*t55*t65*taua+8.88888888888
     4         889d+0*t46*t55*t63*taua+1.7777777777777778d+1*t44*t50*t52
     5         *t63*taua+2.6666666666666666d+1*gammaaa*t50*t51*t62*taua-
     6         2*t52*t53*t66*t85-2*gammaaa*t1*t44*t51*t66*t85-2*t47*t48*
     7         t49*t66*t85-t44*t50*t55*t85-gammaaa*t1*t50*t54*t85+6*t52*
     8         t53*t83*t84+6*gammaaa*t1*t44*t51*t83*t84+6*t47*t48*t49*t8
     9         3*t84+2*t44*t55*t66*t83+2*gammaaa*t1*t54*t66*t83+9.777777
     :         777777779d+0*gammaaa*t46*t54*t82+9.777777777777779d+0*gam
     ;         maaa*t44*t50*t51*t82+3.377777777777778d+1*t47*t48*t50*t81
     <         +1.0666666666666666d+1*gammaaa*t44*t51*t63*t65*t66+2.1333
     =         333333333332d+1*t47*t48*t62*t65*t66+5.333333333333333d+0*
     >         gammaaa*t50*t54*t63*t65)+4.444444444444444d-1*t56*t79+2.6
     ?         666666666666666d+0*t60*t67)-9.305257363490997d-1*t4*t5*(-
     @         1.0128444160767991d+1*t39*t40*t77*t9+2.0256888321535982d+
     1         1*t37*t39*t77*t9+4.6163421503007845d+2*t36*t40*t5*t9-1.84
     2         6536860120314d+3*t36*t37*t5*t9+1.3849026450902355d+3*t34*
     3         t36*t5*t9+3.046785819198518d+4*t10*t5*t6*t78-1.1141288576
     4         844789d+2*t10*t58*t6*t77+1.1141288576844789d+2*t12*t14*t6
     5         *t77+1.0128444160767991d+1*t40*t41*t77-2.0256888321535982
     6         d+1*t36*t37*t38*t77+3.038533248230397d+1*t34*t36*t38*t77-
     7         3.038533248230397d+1*t33*t34*t35*t77+4.0513776643071964d+
     8         1*t31*t33*t35*t77-4.0513776643071964d+1*t30*t31*t32*t77+5
     9         .064222080383994d+1*t28*t30*t32*t77-5.064222080383994d+1*
     :         t27*t28*t29*t77+6.077066496460795d+1*t25*t27*t29*t77-6.07
     ;         7066496460795d+1*t24*t25*t26*t77+7.089910912537593d+1*t22
     <         *t24*t26*t77-7.089910912537593d+1*t21*t22*t23*t77+8.10275
     =         5328614393d+1*t19*t21*t23*t77-8.102755328614393d+1*t18*t1
     >         9*t20*t77+9.115599744691191d+1*t16*t18*t20*t77-9.11559974
     ?         4691191d+1*t15*t16*t17*t77+1.012844416076799d+2*t13*t15*t
     @         17*t77-1.012844416076799d+2*t12*t13*t14*t77-5.58577400186
     1         3949d+4*t14*t5*t58*t6+2.5389881826654315d+4*t12*t17*t5*t6
     2         +2.5389881826654315d+4*t13*t14*t5*t58-4.6163421503007845d
     3         +2*t39*t40*t5+4.6163421503007845d+2*t37*t39*t5+1.38490264
     4         50902355d+3*t33*t37*t38*t5-4.1547079352707067d+3*t33*t34*
     5         t38*t5+2.769805290180471d+3*t31*t33*t38*t5+2.769805290180
     6         471d+3*t30*t34*t35*t5-7.386147440481255d+3*t30*t31*t35*t5
     7         +4.616342150300784d+3*t28*t30*t35*t5+4.616342150300784d+3
     8         *t27*t31*t32*t5-1.154085537575196d+4*t27*t28*t32*t5+6.924
     9         513225451178d+3*t25*t27*t32*t5+6.924513225451178d+3*t24*t
     :         28*t29*t5-1.661883174108283d+4*t24*t25*t29*t5+9.694318515
     ;         631648d+3*t22*t24*t29*t5+9.694318515631648d+3*t21*t25*t26
     <         *t5-2.2620076536473846d+4*t21*t22*t26*t5+1.29257580208421
     =         96d+4*t19*t21*t26*t5+1.2925758020842196d+4*t18*t22*t23*t5
     >         -2.954458976192502d+4*t18*t19*t23*t5+1.6618831741082823d+
     ?         4*t16*t18*t23*t5+1.6618831741082823d+4*t15*t19*t20*t5-3.7
     @         392371417436354d+4*t15*t16*t20*t5+2.0773539676353528d+4*t
     1         13*t15*t20*t5+2.0773539676353528d+4*t12*t16*t17*t5-4.6163
     2         42150300784d+4*t12*t13*t17*t5)+t50*(-1.0d+0*t5*t56*t85-t6
     3         5*t68-1.0d+0*t5*t65*t67-1.3333333333333333d+0*t56*t60*t65
     4         )+2.0d+0*t5*t56*t66*t83-9.305257363490997d-1*t42*t5*(3.53
     5         1915643569816d-2*gammaaa*t3*t82-3.8948928286386303d-4*t48
     6         *t61*t81+1.0369691626335495d-6*gammaaa**3*t80/rhoa**10)-4
     7         .1356699393293317d-1*t4*t42*t79-2.481401963597599d+0*t42*
     8         t60*t64-1.8610514726981994d+0*t5*t59*t64-2.48140196359759
     9         9d+0*t4*t59*t60)*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = (t46*(1.0d+0*t5*(1.24484d-2*gammaaa*t5
     1         1*t66*t70*taua+2.48968d-2*t44*t49*t52*t66*taua+6.2242d-3*
     2         t49*t50*t55*taua-3.3333333333333337d+0*t49*t50*t51*taua+2
     3         .9876159999999996d-2*t47*t48*t66*t86+1.120356d-2*t47*t48*
     4         t65*t70*t84+1.120356d-2*t1*t52*t53*t65*t84+1.120356d-2*ga
     5         mmaaa*t44*t49*t51*t65*t84+3.73452d-3*t1*t44*t55*t65*t66+3
     6         .73452d-3*gammaaa*t49*t54*t65*t66-2*t1*t44*t51*t65*t66-4*
     7         gammaaa*t47*t49*t65*t66+9.958719999999999d-3*t52*t53*t63*
     8         t66+1.9917439999999997d-2*gammaaa*t44*t51*t62*t66-t1*t50*
     9         t54*t65+4.9793599999999993d-3*t44*t50*t55*t63-2.666666666
     :         6666666d+0*t46*t54*t63-2.6666666666666666d+0*t44*t50*t51*
     ;         t63+9.958719999999999d-3*gammaaa*t50*t54*t62-1.0666666666
     <         666666d+1*gammaaa*t47*t50*t62)+1.3333333333333333d+0*t60*
     =         t71)-9.305257363490997d-1*t42*t5*(-3.8886343598758105d-7*
     >         t48*t80*t86-9.632497209735863d-3*t3*t63+1.29829760954621d
     ?         -4*gammaaa*t61*t62)+3.73452d-3*t56*t65*t66*t72-1.0d+0*t5*
     @         t50*t65*t71-1.2407009817987995d+0*t42*t60*t69-9.305257363
     1         490997d-1*t5*t59*t69-1.86726d-3*t1*t50*t68+4.979359999999
     2         9993d-3*t50*t56/rhoa**2.3333333333333334d+0)*wght+Cmat2(i
     3         q,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = (1.0d+0*t46*t5*(2.0919959445599998d-5
     1         *gammaaa*t44*t51*t70*t84+2.0919959445599998d-5*t49*t52*t5
     2         3*t84+2.0919959445599998d-5*t47*t48*t84/rhoa**1.066666666
     3         6666666d+1+6.973319815199999d-6*gammaaa*t54*t66*t70-1.493
     4         8079999999998d-2*gammaaa*t47*t66*t70+6.973319815199999d-6
     5         *t44*t49*t55*t66-7.46904d-3*t44*t49*t51*t66-3.73452d-3*t4
     6         9*t50*t54+2*t47*t49*t50)-9.305257363490997d-1*t42*t5*(1.4
     7         582378849534292d-7*gammaaa*t70*t80-3.2457440238655255d-5*
     8         t49*t61)-3.73452d-3*t50*t71*t72+6.973319815199999d-6*t56*
     9         t66/rhoa**4)*wght+Cmat2(iq,D2_GAA_GAA)
            Mmat2(iq,D2_RA_TA) = (t46*(1.0d+0*t5*(4.97936d-2*t44*t52*t66
     1         *t75*taua+1.24484d-2*t50*t55*t75*taua-1.3333333333333333d
     2         +1*t50*t52*t75*taua+2.48968d-2*gammaaa*t51*t66*t74*taua+2
     3         .240712d-2*gammaaa*t44*t51*t65*t75*t84+2.240712d-2*t47*t4
     4         8*t65*t74*t84+2.240712d-2*t43*t52*t53*t65*t84+7.46904d-3*
     5         gammaaa*t54*t65*t66*t75-4.0d+0*gammaaa*t51*t65*t66*t75+5.
     6         228328d-2*t47*t48*t66*t70+7.46904d-3*t43*t44*t55*t65*t66-
     7         8.0d+0*t43*t44*t52*t65*t66+1.24484d-2*t1*t52*t53*t66+3.23
     8         6584d-2*gammaaa*t44*t49*t51*t66-2.0d+0*t43*t50*t55*t65+6.
     9         2242d-3*t1*t44*t50*t55-3.3333333333333337d+0*t1*t46*t55+1
     :         .618292d-2*gammaaa*t49*t50*t54-6.666666666666667d+0*t1*t4
     ;         4*t50*t52-8.666666666666666d+0*gammaaa*t49*t50*t51)+1.333
     <         3333333333333d+0*t60*t76)-9.305257363490997d-1*t4*t5*(6.0
     =         77066496460795d+1*t36*t40*t57*t9-1.8231199489382385d+2*t3
     >         4*t36*t57*t9+4.0108638876641245d+3*t10*t57*t6*t78-3.34238
     ?         6573053437d+3*t12*t17*t57*t6+3.342386573053437d+3*t13*t14
     @         *t57*t58-6.077066496460795d+1*t37*t39*t57+1.8231199489382
     1         385d+2*t33*t37*t38*t57-3.646239897876477d+2*t31*t33*t38*t
     2         57+3.646239897876477d+2*t30*t34*t35*t57-6.077066496460795
     3         d+2*t28*t30*t35*t57+6.077066496460795d+2*t27*t31*t32*t57-
     4         9.115599744691192d+2*t25*t27*t32*t57+9.115599744691192d+2
     5         *t24*t28*t29*t57-1.276183964256767d+3*t22*t24*t29*t57+1.2
     6         76183964256767d+3*t21*t25*t26*t57-1.7015786190090226d+3*t
     7         19*t21*t26*t57+1.7015786190090226d+3*t18*t22*t23*t57-2.18
     8         7743938725886d+3*t16*t18*t23*t57+2.187743938725886d+3*t15
     9         *t19*t20*t57-2.734679923407357d+3*t13*t15*t20*t57+2.73467
     :         9923407357d+3*t12*t16*t17*t57)+7.46904d-3*t56*t65*t66*t77
     ;         -1.0d+0*t5*t50*t65*t76-9.305257363490997d-1*t5*t64*t73-1.
     <         2407009817987995d+0*t4*t60*t73+6.2242d-3*t50*t56*t72-3.73
     =         452d-3*t43*t50*t68)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = (1.0d+0*t46*t5*(4.1839918891199995d-5*
     1         t52*t53*t75*t84+4.1839918891199995d-5*gammaaa*t44*t51*t74
     2         *t84+4.1839918891199995d-5*t47*t48*t84/rhoa**9.6666666666
     3         66666d+0+1.3946639630399998d-5*t44*t55*t66*t75-1.49380799
     4         99999998d-2*t44*t52*t66*t75-7.46904d-3*t44*t51*t66*t75-3.
     5         73452d-3*t50*t55*t75-3.73452d-3*t50*t54*t75+2.0d+0*t50*t5
     6         1*t75+1.3946639630399998d-5*gammaaa*t54*t66*t74-7.46904d-
     7         3*gammaaa*t51*t66*t74-1.4938079999999998d-2*gammaaa*t47*t
     8         66*t74)-3.73452d-3*t50*t71*t77-1.86726d-3*t50*t72*t76-9.3
     9         05257363490997d-1*t5*t69*t73+1.3946639630399998d-5*t56*t6
     :         6/rhoa**3)*wght+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_TA_TA) = (-9.305257363490997d-1*t4*t5*(8.0d+0*t3
     1         6*t40*t9+3.2d+1*t36*t37*t9+2.4d+1*t34*t36*t9+5.28d+2*t10*
     2         t6*t78+9.68d+2*t14*t58*t6+4.4d+2*t12*t17*t6+4.4d+2*t13*t1
     3         4*t58+8.0d+0*t39*t40+8.0d+0*t37*t39+2.4d+1*t33*t37*t38+7.
     4         2d+1*t33*t34*t38+4.8d+1*t31*t33*t38+4.8d+1*t30*t34*t35+1.
     5         28d+2*t30*t31*t35+8.0d+1*t28*t30*t35+8.0d+1*t27*t31*t32+2
     6         .0d+2*t27*t28*t32+1.2d+2*t25*t27*t32+1.2d+2*t24*t28*t29+2
     7         .88d+2*t24*t25*t29+1.68d+2*t22*t24*t29+1.68d+2*t21*t25*t2
     8         6+3.92d+2*t21*t22*t26+2.24d+2*t19*t21*t26+2.24d+2*t18*t22
     9         *t23+5.12d+2*t18*t19*t23+2.88d+2*t16*t18*t23+2.88d+2*t15*
     :         t19*t20+6.48d+2*t15*t16*t20+3.6d+2*t13*t15*t20+3.6d+2*t12
     ;         *t16*t17+8.0d+2*t12*t13*t17)+1.0d+0*t46*t5*(8.36798377823
     <         9999d-5*t52*t53*t84*t88+2.7893279260799997d-5*t44*t55*t66
     =         *t88-5.975231999999999d-2*t44*t52*t66*t88-1.4938079999999
     >         998d-2*t50*t55*t88+8.0d+0*t50*t52*t88+8.367983778239999d-
     ?         5*gammaaa*t44*t51*t84*t87+2.7893279260799997d-5*gammaaa*t
     @         54*t66*t87-2.9876159999999996d-2*gammaaa*t51*t66*t87+8.36
     1         7983778239999d-5*t47*t48*t84/rhoa**8.666666666666666d+0)-
     2         7.46904d-3*t50*t76*t77+2.7893279260799997d-5*t56*t66/rhoa
     3         **2)*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammabb*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammabb*t1*t3+1.0d+0
            t5 = rhob**1.3333333333333333d+0
            t6 = param(18)
            t7 = rhob**1.6666666666666669d+0
            t8 = 9.115599744691192d+0*t7
            t9 = t8-2.0d+0*taub
            t10 = t9**11
            t11 = 2.0d+0*taub+t8
            t12 = 1/t11**11
            t13 = param(17)
            t14 = t9**10
            t15 = 1/t11**10
            t16 = param(16)
            t17 = t9**9
            t18 = 1/t11**9
            t19 = param(15)
            t20 = t9**8
            t21 = 1/t11**8
            t22 = param(14)
            t23 = t9**7
            t24 = 1/t11**7
            t25 = param(13)
            t26 = t9**6
            t27 = 1/t11**6
            t28 = param(12)
            t29 = t9**5
            t30 = 1/t11**5
            t31 = param(11)
            t32 = t9**4
            t33 = 1/t11**4
            t34 = param(10)
            t35 = t9**3
            t36 = 1/t11**3
            t37 = param(9)
            t38 = t9**2
            t39 = 1/t11**2
            t40 = param(8)
            t41 = 1/t11
            t42 = t40*t41*t9+t10*t12*t6+t37*t38*t39+t34*t35*t36+t31*t32*
     1         t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19*t20*t21+t16*t
     2         17*t18+t13*t14*t15+param(7)
            t43 = 1/t7
            t44 = 2.0d+0*t43*taub-9.11559972d+0
            t45 = 1.86726d-3*t44+1.86726d-3*gammabb*t1+1.0d+0
            t46 = 1/t45
            t47 = param(4)
            t48 = gammabb**2
            t49 = 1/rhob**5.333333333333333d+0
            t50 = 1/t45**2
            t51 = param(5)
            t52 = param(6)
            t53 = t44**2
            t54 = param(2)
            t55 = param(3)
            t56 = t44*t46*t55+gammabb*t1*t46*t54+t50*t52*t53+gammabb*t1*
     1         t44*t50*t51+t47*t48*t49*t50+param(1)
            t57 = rhob**6.666666666666666d-1
            t58 = 1/t11**12
            t59 = -1.5192666241151986d+1*t39*t40*t57*t9+3.03853324823039
     1         7d+1*t37*t39*t57*t9-1.6711932865267184d+2*t10*t57*t58*t6+
     2         1.6711932865267184d+2*t12*t14*t57*t6+1.5192666241151986d+
     3         1*t40*t41*t57-3.038533248230397d+1*t36*t37*t38*t57+4.5577
     4         998723455965d+1*t34*t36*t38*t57-4.5577998723455965d+1*t33
     5         *t34*t35*t57+6.077066496460795d+1*t31*t33*t35*t57-6.07706
     6         6496460795d+1*t30*t31*t32*t57+7.596333120575993d+1*t28*t3
     7         0*t32*t57-7.596333120575993d+1*t27*t28*t29*t57+9.11559974
     8         4691193d+1*t25*t27*t29*t57-9.115599744691193d+1*t24*t25*t
     9         26*t57+1.0634866368806391d+2*t22*t24*t26*t57-1.0634866368
     :         806391d+2*t21*t22*t23*t57+1.2154132992921589d+2*t19*t21*t
     ;         23*t57-1.2154132992921589d+2*t18*t19*t20*t57+1.3673399617
     <         036788d+2*t16*t18*t20*t57-1.3673399617036788d+2*t15*t16*t
     =         17*t57+1.5192666241151986d+2*t13*t15*t17*t57-1.5192666241
     >         151986d+2*t12*t13*t14*t57
            t60 = rhob**3.333333333333333d-1
            t61 = 1/t2**2
            t62 = 1/rhob**6.333333333333333d+0
            t63 = 1/rhob**3.6666666666666664d+0
            t64 = 4.327658698487368d-5*t48*t61*t62-9.632497209735863d-3*
     1         gammabb*t3*t63
            t65 = -6.2242d-3*t1*taub-4.9793599999999993d-3*gammabb*t63
            t66 = 1/t45**3
            t67 = -3.3333333333333337d+0*t1*t46*t55*taub-6.6666666666666
     1         67d+0*t1*t44*t50*t52*taub-3.3333333333333337d+0*gammabb*t
     2         49*t50*t51*taub-2*t52*t53*t65*t66-2*gammabb*t1*t44*t51*t6
     3         5*t66-2*t47*t48*t49*t65*t66-t44*t50*t55*t65-gammabb*t1*t5
     4         0*t54*t65-2.6666666666666666d+0*gammabb*t46*t54*t63-2.666
     5         6666666666666d+0*gammabb*t44*t50*t51*t63-5.33333333333333
     6         3d+0*t47*t48*t50*t62
            t68 = 1.0d+0*t5*t67+1.3333333333333333d+0*t56*t60
            t69 = 3.6121864536509485d-3*t1*t3-1.6228720119327628d-5*gamm
     1         abb*t49*t61
            t70 = 1/rhob**8
            t71 = -3.73452d-3*t47*t48*t66*t70-3.73452d-3*t1*t52*t53*t66-
     1         3.73452d-3*gammabb*t44*t49*t51*t66-1.86726d-3*t1*t44*t50*
     2         t55-1.86726d-3*gammabb*t49*t50*t54+t1*t46*t54+t1*t44*t50*
     3         t51+2*gammabb*t47*t49*t50
            t72 = 1/t5
            t73 = -2.0d+0*t39*t40*t9-4.0d+0*t37*t39*t9-2.2d+1*t10*t58*t6
     1         -2.2d+1*t12*t14*t6-2.0d+0*t40*t41-4.0d+0*t36*t37*t38-6.0d
     2         +0*t34*t36*t38-6.0d+0*t33*t34*t35-8.0d+0*t31*t33*t35-8.0d
     3         +0*t30*t31*t32-1.0d+1*t28*t30*t32-1.0d+1*t27*t28*t29-1.2d
     4         +1*t25*t27*t29-1.2d+1*t24*t25*t26-1.4d+1*t22*t24*t26-1.4d
     5         +1*t21*t22*t23-1.6d+1*t19*t21*t23-1.6d+1*t18*t19*t20-1.8d
     6         +1*t16*t18*t20-1.8d+1*t15*t16*t17-2.0d+1*t13*t15*t17-2.0d
     7         +1*t12*t13*t14
            t74 = 1/rhob**7
            t75 = 1/rhob**4.333333333333333d+0
            t76 = -7.46904d-3*gammabb*t44*t51*t66*t75-3.73452d-3*gammabb
     1         *t50*t54*t75+2.0d+0*gammabb*t50*t51*t75-7.46904d-3*t47*t4
     2         8*t66*t74-7.46904d-3*t43*t52*t53*t66-3.73452d-3*t43*t44*t
     3         50*t55+2.0d+0*t43*t46*t55+4.0d+0*t43*t44*t50*t52
            t77 = 1/t60
            t78 = 1/t11**13
            t79 = 1/t57
            t80 = 1/t2**3
            t81 = 1/rhob**7.333333333333333d+0
            t82 = 1/rhob**4.666666666666667d+0
            t83 = t65**2
            t84 = 1/t45**4
            t85 = 1.6597866666666666d-2*t63*taub+1.8257653333333332d-2*g
     1         ammabb*t82
            t86 = 1/rhob**9
            t87 = 1/rhob**6
            t88 = 1/rhob**3.3333333333333337d+0
            fnc(iq) = (1.0d+0*t46*t5*t56-9.305257363490997d-1*t4*t42*t5)
     1         *wght+fnc(iq)
            Amat(iq,D1_RB) = (t46*t68-1.0d+0*t5*t50*t56*t65-9.3052573634
     1         90997d-1*t42*t5*t64-1.2407009817987995d+0*t4*t42*t60-9.30
     2         5257363490997d-1*t4*t5*t59)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = (-1.86726d-3*t50*t56*t72+1.0d+0*t46*t5*t71
     1         -9.305257363490997d-1*t42*t5*t69)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = (-3.73452d-3*t50*t56*t77+1.0d+0*t46*t5*t76-
     1         9.305257363490997d-1*t4*t5*t73)*wght+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            Amat2(iq,D2_RB_RB) = (t46*(1.0d+0*t5*(2.2222222222222224d+1*
     1         t49*t50*t52*taub**2+2.6666666666666666d+1*t1*t44*t52*t65*
     2         t66*taub+1.3333333333333333d+1*gammabb*t49*t51*t65*t66*ta
     3         ub+6.666666666666667d+0*t1*t50*t55*t65*taub+8.88888888888
     4         889d+0*t46*t55*t63*taub+1.7777777777777778d+1*t44*t50*t52
     5         *t63*taub+2.6666666666666666d+1*gammabb*t50*t51*t62*taub-
     6         2*t52*t53*t66*t85-2*gammabb*t1*t44*t51*t66*t85-2*t47*t48*
     7         t49*t66*t85-t44*t50*t55*t85-gammabb*t1*t50*t54*t85+6*t52*
     8         t53*t83*t84+6*gammabb*t1*t44*t51*t83*t84+6*t47*t48*t49*t8
     9         3*t84+2*t44*t55*t66*t83+2*gammabb*t1*t54*t66*t83+9.777777
     :         777777779d+0*gammabb*t46*t54*t82+9.777777777777779d+0*gam
     ;         mabb*t44*t50*t51*t82+3.377777777777778d+1*t47*t48*t50*t81
     <         +1.0666666666666666d+1*gammabb*t44*t51*t63*t65*t66+2.1333
     =         333333333332d+1*t47*t48*t62*t65*t66+5.333333333333333d+0*
     >         gammabb*t50*t54*t63*t65)+4.444444444444444d-1*t56*t79+2.6
     ?         666666666666666d+0*t60*t67)-9.305257363490997d-1*t4*t5*(-
     @         1.0128444160767991d+1*t39*t40*t77*t9+2.0256888321535982d+
     1         1*t37*t39*t77*t9+4.6163421503007845d+2*t36*t40*t5*t9-1.84
     2         6536860120314d+3*t36*t37*t5*t9+1.3849026450902355d+3*t34*
     3         t36*t5*t9+3.046785819198518d+4*t10*t5*t6*t78-1.1141288576
     4         844789d+2*t10*t58*t6*t77+1.1141288576844789d+2*t12*t14*t6
     5         *t77+1.0128444160767991d+1*t40*t41*t77-2.0256888321535982
     6         d+1*t36*t37*t38*t77+3.038533248230397d+1*t34*t36*t38*t77-
     7         3.038533248230397d+1*t33*t34*t35*t77+4.0513776643071964d+
     8         1*t31*t33*t35*t77-4.0513776643071964d+1*t30*t31*t32*t77+5
     9         .064222080383994d+1*t28*t30*t32*t77-5.064222080383994d+1*
     :         t27*t28*t29*t77+6.077066496460795d+1*t25*t27*t29*t77-6.07
     ;         7066496460795d+1*t24*t25*t26*t77+7.089910912537593d+1*t22
     <         *t24*t26*t77-7.089910912537593d+1*t21*t22*t23*t77+8.10275
     =         5328614393d+1*t19*t21*t23*t77-8.102755328614393d+1*t18*t1
     >         9*t20*t77+9.115599744691191d+1*t16*t18*t20*t77-9.11559974
     ?         4691191d+1*t15*t16*t17*t77+1.012844416076799d+2*t13*t15*t
     @         17*t77-1.012844416076799d+2*t12*t13*t14*t77-5.58577400186
     1         3949d+4*t14*t5*t58*t6+2.5389881826654315d+4*t12*t17*t5*t6
     2         +2.5389881826654315d+4*t13*t14*t5*t58-4.6163421503007845d
     3         +2*t39*t40*t5+4.6163421503007845d+2*t37*t39*t5+1.38490264
     4         50902355d+3*t33*t37*t38*t5-4.1547079352707067d+3*t33*t34*
     5         t38*t5+2.769805290180471d+3*t31*t33*t38*t5+2.769805290180
     6         471d+3*t30*t34*t35*t5-7.386147440481255d+3*t30*t31*t35*t5
     7         +4.616342150300784d+3*t28*t30*t35*t5+4.616342150300784d+3
     8         *t27*t31*t32*t5-1.154085537575196d+4*t27*t28*t32*t5+6.924
     9         513225451178d+3*t25*t27*t32*t5+6.924513225451178d+3*t24*t
     :         28*t29*t5-1.661883174108283d+4*t24*t25*t29*t5+9.694318515
     ;         631648d+3*t22*t24*t29*t5+9.694318515631648d+3*t21*t25*t26
     <         *t5-2.2620076536473846d+4*t21*t22*t26*t5+1.29257580208421
     =         96d+4*t19*t21*t26*t5+1.2925758020842196d+4*t18*t22*t23*t5
     >         -2.954458976192502d+4*t18*t19*t23*t5+1.6618831741082823d+
     ?         4*t16*t18*t23*t5+1.6618831741082823d+4*t15*t19*t20*t5-3.7
     @         392371417436354d+4*t15*t16*t20*t5+2.0773539676353528d+4*t
     1         13*t15*t20*t5+2.0773539676353528d+4*t12*t16*t17*t5-4.6163
     2         42150300784d+4*t12*t13*t17*t5)+t50*(-1.0d+0*t5*t56*t85-t6
     3         5*t68-1.0d+0*t5*t65*t67-1.3333333333333333d+0*t56*t60*t65
     4         )+2.0d+0*t5*t56*t66*t83-9.305257363490997d-1*t42*t5*(3.53
     5         1915643569816d-2*gammabb*t3*t82-3.8948928286386303d-4*t48
     6         *t61*t81+1.0369691626335495d-6*gammabb**3*t80/rhob**10)-4
     7         .1356699393293317d-1*t4*t42*t79-2.481401963597599d+0*t42*
     8         t60*t64-1.8610514726981994d+0*t5*t59*t64-2.48140196359759
     9         9d+0*t4*t59*t60)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = (t46*(1.0d+0*t5*(1.24484d-2*gammabb*t5
     1         1*t66*t70*taub+2.48968d-2*t44*t49*t52*t66*taub+6.2242d-3*
     2         t49*t50*t55*taub-3.3333333333333337d+0*t49*t50*t51*taub+2
     3         .9876159999999996d-2*t47*t48*t66*t86+1.120356d-2*t47*t48*
     4         t65*t70*t84+1.120356d-2*t1*t52*t53*t65*t84+1.120356d-2*ga
     5         mmabb*t44*t49*t51*t65*t84+3.73452d-3*t1*t44*t55*t65*t66+3
     6         .73452d-3*gammabb*t49*t54*t65*t66-2*t1*t44*t51*t65*t66-4*
     7         gammabb*t47*t49*t65*t66+9.958719999999999d-3*t52*t53*t63*
     8         t66+1.9917439999999997d-2*gammabb*t44*t51*t62*t66-t1*t50*
     9         t54*t65+4.9793599999999993d-3*t44*t50*t55*t63-2.666666666
     :         6666666d+0*t46*t54*t63-2.6666666666666666d+0*t44*t50*t51*
     ;         t63+9.958719999999999d-3*gammabb*t50*t54*t62-1.0666666666
     <         666666d+1*gammabb*t47*t50*t62)+1.3333333333333333d+0*t60*
     =         t71)-9.305257363490997d-1*t42*t5*(-3.8886343598758105d-7*
     >         t48*t80*t86-9.632497209735863d-3*t3*t63+1.29829760954621d
     ?         -4*gammabb*t61*t62)+3.73452d-3*t56*t65*t66*t72-1.0d+0*t5*
     @         t50*t65*t71-1.2407009817987995d+0*t42*t60*t69-9.305257363
     1         490997d-1*t5*t59*t69-1.86726d-3*t1*t50*t68+4.979359999999
     2         9993d-3*t50*t56/rhob**2.3333333333333334d+0)*wght+Cmat2(i
     3         q,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = (1.0d+0*t46*t5*(2.0919959445599998d-5
     1         *gammabb*t44*t51*t70*t84+2.0919959445599998d-5*t49*t52*t5
     2         3*t84+2.0919959445599998d-5*t47*t48*t84/rhob**1.066666666
     3         6666666d+1+6.973319815199999d-6*gammabb*t54*t66*t70-1.493
     4         8079999999998d-2*gammabb*t47*t66*t70+6.973319815199999d-6
     5         *t44*t49*t55*t66-7.46904d-3*t44*t49*t51*t66-3.73452d-3*t4
     6         9*t50*t54+2*t47*t49*t50)-9.305257363490997d-1*t42*t5*(1.4
     7         582378849534292d-7*gammabb*t70*t80-3.2457440238655255d-5*
     8         t49*t61)-3.73452d-3*t50*t71*t72+6.973319815199999d-6*t56*
     9         t66/rhob**4)*wght+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = (t46*(1.0d+0*t5*(4.97936d-2*t44*t52*t66
     1         *t75*taub+1.24484d-2*t50*t55*t75*taub-1.3333333333333333d
     2         +1*t50*t52*t75*taub+2.48968d-2*gammabb*t51*t66*t74*taub+2
     3         .240712d-2*gammabb*t44*t51*t65*t75*t84+2.240712d-2*t47*t4
     4         8*t65*t74*t84+2.240712d-2*t43*t52*t53*t65*t84+7.46904d-3*
     5         gammabb*t54*t65*t66*t75-4.0d+0*gammabb*t51*t65*t66*t75+5.
     6         228328d-2*t47*t48*t66*t70+7.46904d-3*t43*t44*t55*t65*t66-
     7         8.0d+0*t43*t44*t52*t65*t66+1.24484d-2*t1*t52*t53*t66+3.23
     8         6584d-2*gammabb*t44*t49*t51*t66-2.0d+0*t43*t50*t55*t65+6.
     9         2242d-3*t1*t44*t50*t55-3.3333333333333337d+0*t1*t46*t55+1
     :         .618292d-2*gammabb*t49*t50*t54-6.666666666666667d+0*t1*t4
     ;         4*t50*t52-8.666666666666666d+0*gammabb*t49*t50*t51)+1.333
     <         3333333333333d+0*t60*t76)-9.305257363490997d-1*t4*t5*(6.0
     =         77066496460795d+1*t36*t40*t57*t9-1.8231199489382385d+2*t3
     >         4*t36*t57*t9+4.0108638876641245d+3*t10*t57*t6*t78-3.34238
     ?         6573053437d+3*t12*t17*t57*t6+3.342386573053437d+3*t13*t14
     @         *t57*t58-6.077066496460795d+1*t37*t39*t57+1.8231199489382
     1         385d+2*t33*t37*t38*t57-3.646239897876477d+2*t31*t33*t38*t
     2         57+3.646239897876477d+2*t30*t34*t35*t57-6.077066496460795
     3         d+2*t28*t30*t35*t57+6.077066496460795d+2*t27*t31*t32*t57-
     4         9.115599744691192d+2*t25*t27*t32*t57+9.115599744691192d+2
     5         *t24*t28*t29*t57-1.276183964256767d+3*t22*t24*t29*t57+1.2
     6         76183964256767d+3*t21*t25*t26*t57-1.7015786190090226d+3*t
     7         19*t21*t26*t57+1.7015786190090226d+3*t18*t22*t23*t57-2.18
     8         7743938725886d+3*t16*t18*t23*t57+2.187743938725886d+3*t15
     9         *t19*t20*t57-2.734679923407357d+3*t13*t15*t20*t57+2.73467
     :         9923407357d+3*t12*t16*t17*t57)+7.46904d-3*t56*t65*t66*t77
     ;         -1.0d+0*t5*t50*t65*t76-9.305257363490997d-1*t5*t64*t73-1.
     <         2407009817987995d+0*t4*t60*t73+6.2242d-3*t50*t56*t72-3.73
     =         452d-3*t43*t50*t68)*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = (1.0d+0*t46*t5*(4.1839918891199995d-5*
     1         t52*t53*t75*t84+4.1839918891199995d-5*gammabb*t44*t51*t74
     2         *t84+4.1839918891199995d-5*t47*t48*t84/rhob**9.6666666666
     3         66666d+0+1.3946639630399998d-5*t44*t55*t66*t75-1.49380799
     4         99999998d-2*t44*t52*t66*t75-7.46904d-3*t44*t51*t66*t75-3.
     5         73452d-3*t50*t55*t75-3.73452d-3*t50*t54*t75+2.0d+0*t50*t5
     6         1*t75+1.3946639630399998d-5*gammabb*t54*t66*t74-7.46904d-
     7         3*gammabb*t51*t66*t74-1.4938079999999998d-2*gammabb*t47*t
     8         66*t74)-3.73452d-3*t50*t71*t77-1.86726d-3*t50*t72*t76-9.3
     9         05257363490997d-1*t5*t69*t73+1.3946639630399998d-5*t56*t6
     :         6/rhob**3)*wght+Mmat2(iq,D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = (-9.305257363490997d-1*t4*t5*(8.0d+0*t3
     1         6*t40*t9+3.2d+1*t36*t37*t9+2.4d+1*t34*t36*t9+5.28d+2*t10*
     2         t6*t78+9.68d+2*t14*t58*t6+4.4d+2*t12*t17*t6+4.4d+2*t13*t1
     3         4*t58+8.0d+0*t39*t40+8.0d+0*t37*t39+2.4d+1*t33*t37*t38+7.
     4         2d+1*t33*t34*t38+4.8d+1*t31*t33*t38+4.8d+1*t30*t34*t35+1.
     5         28d+2*t30*t31*t35+8.0d+1*t28*t30*t35+8.0d+1*t27*t31*t32+2
     6         .0d+2*t27*t28*t32+1.2d+2*t25*t27*t32+1.2d+2*t24*t28*t29+2
     7         .88d+2*t24*t25*t29+1.68d+2*t22*t24*t29+1.68d+2*t21*t25*t2
     8         6+3.92d+2*t21*t22*t26+2.24d+2*t19*t21*t26+2.24d+2*t18*t22
     9         *t23+5.12d+2*t18*t19*t23+2.88d+2*t16*t18*t23+2.88d+2*t15*
     :         t19*t20+6.48d+2*t15*t16*t20+3.6d+2*t13*t15*t20+3.6d+2*t12
     ;         *t16*t17+8.0d+2*t12*t13*t17)+1.0d+0*t46*t5*(8.36798377823
     <         9999d-5*t52*t53*t84*t88+2.7893279260799997d-5*t44*t55*t66
     =         *t88-5.975231999999999d-2*t44*t52*t66*t88-1.4938079999999
     >         998d-2*t50*t55*t88+8.0d+0*t50*t52*t88+8.367983778239999d-
     ?         5*gammabb*t44*t51*t84*t87+2.7893279260799997d-5*gammabb*t
     @         54*t66*t87-2.9876159999999996d-2*gammabb*t51*t66*t87+8.36
     1         7983778239999d-5*t47*t48*t84/rhob**8.666666666666666d+0)-
     2         7.46904d-3*t50*t76*t77+2.7893279260799997d-5*t56*t66/rhob
     3         **2)*wght+Mmat2(iq,D2_TB_TB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_m06 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_4} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_5} &=& \rho_\alpha^{{{5}\over{3}}}\\\\ 
C>   {\it t_6} &=& 9.115599744691192\,{\it t_5}\\\\ 
C>   {\it t_7} &=& {\it t_6}-2.0\,\tau_\alpha\\\\ 
C>   {\it t_8} &=& 2.0\,\tau_\alpha+{\it t_6}\\\\ 
C>   {\it t_9} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{10}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{12}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{13}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{17}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{18}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{19}} &=& {{2.0\,\tau_\alpha}\over{{\it t_5}}}
C>    -9.11559972\\\\ 
C>   {\it t_{20}} &=& 0.00186726\,{\it t_{19}}+0.00186726\,{\it t_2}
C>    \,\sigma_{\alpha\alpha}+1.0\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{22}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{23}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{24}} &=& {{1}\over{{\it t_{20}}^2}}\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{29}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{31}} &=& \rho_\beta^{{{5}\over{3}}}\\\\ 
C>   {\it t_{32}} &=& 9.115599744691192\,{\it t_{31}}\\\\ 
C>   {\it t_{33}} &=& {\it t_{32}}-2.0\,\tau_\beta\\\\ 
C>   {\it t_{34}} &=& 2.0\,\tau_\beta+{\it t_{32}}\\\\ 
C>   {\it t_{35}} &=& {{2.0\,\tau_\beta}\over{{\it t_{31}}}}
C>    -9.11559972\\\\ 
C>   {\it t_{36}} &=& 0.00186726\,{\it t_{35}}+0.00186726\,{
C>    \it t_{30}}\,\sigma_{\beta\beta}+1.0\\\\ 
C>   {\it t_{37}} &=& {{1}\over{{\it t_{36}}}}\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_{36}}^2}}\\\\ 
C>   {\it t_{39}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{41}} &=& \rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{42}} &=& 9.115599744691192\,{\it t_{41}}\\\\ 
C>   {\it t_{43}} &=& {\it t_{42}}-2.0\,\tau_s\\\\ 
C>   {\it t_{44}} &=& 2.0\,\tau_s+{\it t_{42}}\\\\ 
C>   {\it t_{45}} &=& {{2.0\,\tau_s}\over{{\it t_{41}}}}-9.11559972\\\\ 
C>   {\it t_{46}} &=& 0.00186726\,{\it t_{45}}+0.00186726\,{
C>    \it t_{40}}\,\sigma_{ss}+1.0\\\\ 
C>   {\it t_{47}} &=& {{1}\over{{\it t_{46}}}}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{{\it t_{46}}^2}}\\\\ 
C>   f &=& 1.0\,{\it t_{29}}\,{\it t_{37}}\,\left({\it t_{28}}\,{
C>    \it t_{35}}\,{\it t_{37}}+{\it t_{27}}\,{\it t_{30}}\,
C>    \sigma_{\beta\beta}\,{\it t_{37}}+{\it t_{26}}\,{\it t_{35}}^2
C>    \,{\it t_{38}}+{\it t_{25}}\,{\it t_{30}}\,\sigma_{\beta\beta}
C>    \,{\it t_{35}}\,{\it t_{38}}+{{{\it t_{23}}\,
C>    \sigma_{\beta\beta}^2\,{\it t_{38}}}
C>    \over{\rho_\beta^{{{16}\over{3}}}}}+{\it t_{22}}\right)
C>    -0.9305257363490997\,{\it t_{29}}\,
C>    \left({{0.003612186453650949\,{\it t_{30}}\,
C>    \sigma_{\beta\beta}}\over{0.00449276922095889\,{\it t_{30}}
C>    \,\sigma_{\beta\beta}+1.0}}+1.0\right)\,\left({{{\it t_{18}}
C>    \,{\it t_{33}}}\over{{\it t_{34}}}}+{{{\it t_{17}}\,{
C>    \it t_{33}}^2}\over{{\it t_{34}}^2}}+{{{\it t_{16}}\,{
C>    \it t_{33}}^3}\over{{\it t_{34}}^3}}+{{{\it t_{15}}\,{
C>    \it t_{33}}^4}\over{{\it t_{34}}^4}}+{{{\it t_{14}}\,{
C>    \it t_{33}}^5}\over{{\it t_{34}}^5}}+{{{\it t_{13}}\,{
C>    \it t_{33}}^6}\over{{\it t_{34}}^6}}+{{{\it t_{12}}\,{
C>    \it t_{33}}^7}\over{{\it t_{34}}^7}}+{{{\it t_{11}}\,{
C>    \it t_{33}}^8}\over{{\it t_{34}}^8}}+{{{\it t_{10}}\,{
C>    \it t_{33}}^9}\over{{\it t_{34}}^9}}+{{{\it t_9}\,{
C>    \it t_{33}}^{10}}\over{{\it t_{34}}^{10}}}+{{{\it t_4}\,{
C>    \it t_{33}}^{11}}\over{{\it t_{34}}^{11}}}+{\it t_3}\right)
C>    +1.0\,{\it t_1}\,{\it t_{21}}\,\left({\it t_{28}}\,{
C>    \it t_{19}}\,{\it t_{21}}+{\it t_{27}}\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{21}}+{\it t_{26}}\,{
C>    \it t_{19}}^2\,{\it t_{24}}+{\it t_{25}}\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{19}}\,{\it t_{24}}+{{{
C>    \it t_{23}}\,\sigma_{\alpha\alpha}^2\,{\it t_{24}}}
C>    \over{\rho_\alpha^{{{16}\over{3}}}}}+{\it t_{22}}\right)
C>    -0.9305257363490997\,{\it t_1}\,\left({{0.003612186453650949
C>    \,{\it t_2}\,\sigma_{\alpha\alpha}}\over{0.00449276922095889
C>    \,{\it t_2}\,\sigma_{\alpha\alpha}+1.0}}+1.0\right)\,
C>    \left({{{\it t_{18}}\,{\it t_7}}\over{{\it t_8}}}+{{{
C>    \it t_{17}}\,{\it t_7}^2}\over{{\it t_8}^2}}+{{{\it t_{16}}
C>    \,{\it t_7}^3}\over{{\it t_8}^3}}+{{{\it t_{15}}\,{
C>    \it t_7}^4}\over{{\it t_8}^4}}+{{{\it t_{14}}\,{
C>    \it t_7}^5}\over{{\it t_8}^5}}+{{{\it t_{13}}\,{
C>    \it t_7}^6}\over{{\it t_8}^6}}+{{{\it t_{12}}\,{
C>    \it t_7}^7}\over{{\it t_8}^7}}+{{{\it t_{11}}\,{
C>    \it t_7}^8}\over{{\it t_8}^8}}+{{{\it t_{10}}\,{
C>    \it t_7}^9}\over{{\it t_8}^9}}+{{{\it t_9}\,{
C>    \it t_7}^{10}}\over{{\it t_8}^{10}}}+{{{\it t_4}\,{
C>    \it t_7}^{11}}\over{{\it t_8}^{11}}}+{\it t_3}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,{\it t_{39}}\,{\it t_{47}}\,\left({\it t_{28}}\,{
C>    \it t_{45}}\,{\it t_{47}}+{\it t_{27}}\,{\it t_{40}}\,
C>    \sigma_{ss}\,{\it t_{47}}+{\it t_{26}}\,{\it t_{45}}^2\,{
C>    \it t_{48}}+{\it t_{25}}\,{\it t_{40}}\,\sigma_{ss}\,{
C>    \it t_{45}}\,{\it t_{48}}+{{{\it t_{23}}\,\sigma_{ss}^2\,{
C>    \it t_{48}}}\over{\rho_s^{{{16}\over{3}}}}}+{\it t_{22}}\right)
C>    -0.9305257363490997\,{\it t_{39}}\,
C>    \left({{0.003612186453650949\,{\it t_{40}}\,\sigma_{ss}}
C>    \over{0.00449276922095889\,{\it t_{40}}\,\sigma_{ss}+1.0}}
C>    +1.0\right)\,\left({{{\it t_{18}}\,{\it t_{43}}}\over{{
C>    \it t_{44}}}}+{{{\it t_{17}}\,{\it t_{43}}^2}\over{{
C>    \it t_{44}}^2}}+{{{\it t_{16}}\,{\it t_{43}}^3}\over{{
C>    \it t_{44}}^3}}+{{{\it t_{15}}\,{\it t_{43}}^4}\over{{
C>    \it t_{44}}^4}}+{{{\it t_{14}}\,{\it t_{43}}^5}\over{{
C>    \it t_{44}}^5}}+{{{\it t_{13}}\,{\it t_{43}}^6}\over{{
C>    \it t_{44}}^6}}+{{{\it t_{12}}\,{\it t_{43}}^7}\over{{
C>    \it t_{44}}^7}}+{{{\it t_{11}}\,{\it t_{43}}^8}\over{{
C>    \it t_{44}}^8}}+{{{\it t_{10}}\,{\it t_{43}}^9}\over{{
C>    \it t_{44}}^9}}+{{{\it t_9}\,{\it t_{43}}^{10}}\over{{
C>    \it t_{44}}^{10}}}+{{{\it t_4}\,{\it t_{43}}^{11}}\over{{
C>    \it t_{44}}^{11}}}+{\it t_3}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, DG Truhlar, J.Chem.Phys. 123, 194101 (2006)  , DOI: 
C> <a href="https://doi.org/10.1063/1.2370993 "> 
C> 10.1063/1.2370993 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_m06_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammaaa*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammaaa*t1*t3+1.0d+0
            t5 = rhoa**1.3333333333333333d+0
            t6 = param(18)
            t7 = rhoa**1.6666666666666669d+0
            t8 = 9.115599744691192d+0*t7
            t9 = t8-2.0d+0*taua
            t10 = t9**11
            t11 = 2.0d+0*taua+t8
            t12 = 1/t11**11
            t13 = param(17)
            t14 = t9**10
            t15 = 1/t11**10
            t16 = param(16)
            t17 = t9**9
            t18 = 1/t11**9
            t19 = param(15)
            t20 = t9**8
            t21 = 1/t11**8
            t22 = param(14)
            t23 = t9**7
            t24 = 1/t11**7
            t25 = param(13)
            t26 = t9**6
            t27 = 1/t11**6
            t28 = param(12)
            t29 = t9**5
            t30 = 1/t11**5
            t31 = param(11)
            t32 = t9**4
            t33 = 1/t11**4
            t34 = param(10)
            t35 = t9**3
            t36 = 1/t11**3
            t37 = param(9)
            t38 = t9**2
            t39 = 1/t11**2
            t40 = param(8)
            t41 = 1/t11
            t42 = t40*t41*t9+t10*t12*t6+t37*t38*t39+t34*t35*t36+t31*t32*
     1         t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19*t20*t21+t16*t
     2         17*t18+t13*t14*t15+param(7)
            t43 = 1/t7
            t44 = 2.0d+0*t43*taua-9.11559972d+0
            t45 = 1.86726d-3*t44+1.86726d-3*gammaaa*t1+1.0d+0
            t46 = 1/t45
            t47 = param(4)
            t48 = gammaaa**2
            t49 = 1/rhoa**5.333333333333333d+0
            t50 = 1/t45**2
            t51 = param(5)
            t52 = param(6)
            t53 = t44**2
            t54 = param(2)
            t55 = param(3)
            t56 = t44*t46*t55+gammaaa*t1*t46*t54+t50*t52*t53+gammaaa*t1*
     1         t44*t50*t51+t47*t48*t49*t50+param(1)
            t57 = rhoa**6.666666666666666d-1
            t58 = 1/t11**12
            t59 = -1.5192666241151986d+1*t39*t40*t57*t9+3.03853324823039
     1         7d+1*t37*t39*t57*t9-1.6711932865267184d+2*t10*t57*t58*t6+
     2         1.6711932865267184d+2*t12*t14*t57*t6+1.5192666241151986d+
     3         1*t40*t41*t57-3.038533248230397d+1*t36*t37*t38*t57+4.5577
     4         998723455965d+1*t34*t36*t38*t57-4.5577998723455965d+1*t33
     5         *t34*t35*t57+6.077066496460795d+1*t31*t33*t35*t57-6.07706
     6         6496460795d+1*t30*t31*t32*t57+7.596333120575993d+1*t28*t3
     7         0*t32*t57-7.596333120575993d+1*t27*t28*t29*t57+9.11559974
     8         4691193d+1*t25*t27*t29*t57-9.115599744691193d+1*t24*t25*t
     9         26*t57+1.0634866368806391d+2*t22*t24*t26*t57-1.0634866368
     :         806391d+2*t21*t22*t23*t57+1.2154132992921589d+2*t19*t21*t
     ;         23*t57-1.2154132992921589d+2*t18*t19*t20*t57+1.3673399617
     <         036788d+2*t16*t18*t20*t57-1.3673399617036788d+2*t15*t16*t
     =         17*t57+1.5192666241151986d+2*t13*t15*t17*t57-1.5192666241
     >         151986d+2*t12*t13*t14*t57
            t60 = rhoa**3.333333333333333d-1
            t61 = 1/t2**2
            t62 = 1/rhoa**6.333333333333333d+0
            t63 = 1/rhoa**3.6666666666666664d+0
            t64 = 4.327658698487368d-5*t48*t61*t62-9.632497209735863d-3*
     1         gammaaa*t3*t63
            t65 = -6.2242d-3*t1*taua-4.9793599999999993d-3*gammaaa*t63
            t66 = 1/t45**3
            t67 = -3.3333333333333337d+0*t1*t46*t55*taua-6.6666666666666
     1         67d+0*t1*t44*t50*t52*taua-3.3333333333333337d+0*gammaaa*t
     2         49*t50*t51*taua-2*t52*t53*t65*t66-2*gammaaa*t1*t44*t51*t6
     3         5*t66-2*t47*t48*t49*t65*t66-t44*t50*t55*t65-gammaaa*t1*t5
     4         0*t54*t65-2.6666666666666666d+0*gammaaa*t46*t54*t63-2.666
     5         6666666666666d+0*gammaaa*t44*t50*t51*t63-5.33333333333333
     6         3d+0*t47*t48*t50*t62
            t68 = 1.0d+0*t5*t67+1.3333333333333333d+0*t56*t60
            t69 = 3.6121864536509485d-3*t1*t3-1.6228720119327628d-5*gamm
     1         aaa*t49*t61
            t70 = 1/rhoa**8
            t71 = -3.73452d-3*t47*t48*t66*t70-3.73452d-3*t1*t52*t53*t66-
     1         3.73452d-3*gammaaa*t44*t49*t51*t66-1.86726d-3*t1*t44*t50*
     2         t55-1.86726d-3*gammaaa*t49*t50*t54+t1*t46*t54+t1*t44*t50*
     3         t51+2*gammaaa*t47*t49*t50
            t72 = 1/t5
            t73 = -2.0d+0*t39*t40*t9-4.0d+0*t37*t39*t9-2.2d+1*t10*t58*t6
     1         -2.2d+1*t12*t14*t6-2.0d+0*t40*t41-4.0d+0*t36*t37*t38-6.0d
     2         +0*t34*t36*t38-6.0d+0*t33*t34*t35-8.0d+0*t31*t33*t35-8.0d
     3         +0*t30*t31*t32-1.0d+1*t28*t30*t32-1.0d+1*t27*t28*t29-1.2d
     4         +1*t25*t27*t29-1.2d+1*t24*t25*t26-1.4d+1*t22*t24*t26-1.4d
     5         +1*t21*t22*t23-1.6d+1*t19*t21*t23-1.6d+1*t18*t19*t20-1.8d
     6         +1*t16*t18*t20-1.8d+1*t15*t16*t17-2.0d+1*t13*t15*t17-2.0d
     7         +1*t12*t13*t14
            t74 = 1/rhoa**7
            t75 = 1/rhoa**4.333333333333333d+0
            t76 = -7.46904d-3*gammaaa*t44*t51*t66*t75-3.73452d-3*gammaaa
     1         *t50*t54*t75+2.0d+0*gammaaa*t50*t51*t75-7.46904d-3*t47*t4
     2         8*t66*t74-7.46904d-3*t43*t52*t53*t66-3.73452d-3*t43*t44*t
     3         50*t55+2.0d+0*t43*t46*t55+4.0d+0*t43*t44*t50*t52
            t77 = 1/t60
            t78 = 1/t11**13
            t79 = -1.0128444160767991d+1*t39*t40*t77*t9+2.02568883215359
     1         82d+1*t37*t39*t77*t9+4.6163421503007845d+2*t36*t40*t5*t9-
     2         1.846536860120314d+3*t36*t37*t5*t9+1.3849026450902355d+3*
     3         t34*t36*t5*t9+3.046785819198518d+4*t10*t5*t6*t78-1.114128
     4         8576844789d+2*t10*t58*t6*t77+1.1141288576844789d+2*t12*t1
     5         4*t6*t77+1.0128444160767991d+1*t40*t41*t77-2.025688832153
     6         5982d+1*t36*t37*t38*t77+3.038533248230397d+1*t34*t36*t38*
     7         t77-3.038533248230397d+1*t33*t34*t35*t77+4.05137766430719
     8         64d+1*t31*t33*t35*t77-4.0513776643071964d+1*t30*t31*t32*t
     9         77+5.064222080383994d+1*t28*t30*t32*t77-5.064222080383994
     :         d+1*t27*t28*t29*t77+6.077066496460795d+1*t25*t27*t29*t77-
     ;         6.077066496460795d+1*t24*t25*t26*t77+7.089910912537593d+1
     <         *t22*t24*t26*t77-7.089910912537593d+1*t21*t22*t23*t77+8.1
     =         02755328614393d+1*t19*t21*t23*t77-8.102755328614393d+1*t1
     >         8*t19*t20*t77+9.115599744691191d+1*t16*t18*t20*t77-9.1155
     ?         99744691191d+1*t15*t16*t17*t77+1.012844416076799d+2*t13*t
     @         15*t17*t77-1.012844416076799d+2*t12*t13*t14*t77-5.5857740
     1         01863949d+4*t14*t5*t58*t6+2.5389881826654315d+4*t12*t17*t
     2         5*t6+2.5389881826654315d+4*t13*t14*t5*t58-4.6163421503007
     3         845d+2*t39*t40*t5+4.6163421503007845d+2*t37*t39*t5+1.3849
     4         026450902355d+3*t33*t37*t38*t5-4.1547079352707067d+3*t33*
     5         t34*t38*t5+2.769805290180471d+3*t31*t33*t38*t5+2.76980529
     6         0180471d+3*t30*t34*t35*t5-7.386147440481255d+3*t30*t31*t3
     7         5*t5+4.616342150300784d+3*t28*t30*t35*t5+4.61634215030078
     8         4d+3*t27*t31*t32*t5-1.154085537575196d+4*t27*t28*t32*t5+6
     9         .924513225451178d+3*t25*t27*t32*t5+6.924513225451178d+3*t
     :         24*t28*t29*t5-1.661883174108283d+4*t24*t25*t29*t5+9.69431
     ;         8515631648d+3*t22*t24*t29*t5+9.694318515631648d+3*t21*t25
     <         *t26*t5-2.2620076536473846d+4*t21*t22*t26*t5+1.2925758020
     =         842196d+4*t19*t21*t26*t5+1.2925758020842196d+4*t18*t22*t2
     >         3*t5-2.954458976192502d+4*t18*t19*t23*t5+1.66188317410828
     ?         23d+4*t16*t18*t23*t5+1.6618831741082823d+4*t15*t19*t20*t5
     @         -3.7392371417436354d+4*t15*t16*t20*t5+2.0773539676353528d
     1         +4*t13*t15*t20*t5+2.0773539676353528d+4*t12*t16*t17*t5-4.
     2         616342150300784d+4*t12*t13*t17*t5
            t80 = 1/t57
            t81 = gammaaa**3
            t82 = 1/t2**3
            t83 = 1/rhoa**10
            t84 = 1/rhoa**7.333333333333333d+0
            t85 = 1/rhoa**4.666666666666667d+0
            t86 = 3.531915643569816d-2*gammaaa*t3*t85-3.8948928286386303
     1         d-4*t48*t61*t84+1.0369691626335495d-6*t81*t82*t83
            t87 = t65**2
            t88 = 1/t45**4
            t89 = 1.6597866666666666d-2*t63*taua+1.8257653333333332d-2*g
     1         ammaaa*t85
            t90 = taua**2
            t91 = 2.6666666666666666d+1*t1*t44*t52*t65*t66*taua+1.333333
     1         3333333333d+1*gammaaa*t49*t51*t65*t66*taua+6.666666666666
     2         667d+0*t1*t50*t55*t65*taua+8.88888888888889d+0*t46*t55*t6
     3         3*taua+1.7777777777777778d+1*t44*t50*t52*t63*taua+2.66666
     4         66666666666d+1*gammaaa*t50*t51*t62*taua+2.222222222222222
     5         4d+1*t49*t50*t52*t90-2*t52*t53*t66*t89-2*gammaaa*t1*t44*t
     6         51*t66*t89-2*t47*t48*t49*t66*t89-t44*t50*t55*t89-gammaaa*
     7         t1*t50*t54*t89+6*t52*t53*t87*t88+6*gammaaa*t1*t44*t51*t87
     8         *t88+6*t47*t48*t49*t87*t88+2*t44*t55*t66*t87+2*gammaaa*t1
     9         *t54*t66*t87+9.777777777777779d+0*gammaaa*t46*t54*t85+9.7
     :         77777777777779d+0*gammaaa*t44*t50*t51*t85+3.3777777777777
     ;         78d+1*t47*t48*t50*t84+1.0666666666666666d+1*gammaaa*t44*t
     <         51*t63*t65*t66+2.1333333333333332d+1*t47*t48*t62*t65*t66+
     =         5.333333333333333d+0*gammaaa*t50*t54*t63*t65
            t92 = 1.0d+0*t5*t91+4.444444444444444d-1*t56*t80+2.666666666
     1         6666666d+0*t60*t67
            t93 = -1.0d+0*t5*t56*t89-t65*t68-1.0d+0*t5*t65*t67-1.3333333
     1         333333333d+0*t56*t60*t65
            t94 = 1/rhoa**9
            t95 = -3.8886343598758105d-7*t48*t82*t94-9.632497209735863d-
     1         3*t3*t63+1.29829760954621d-4*gammaaa*t61*t62
            t96 = 1/rhoa**2.3333333333333334d+0
            t97 = 1.24484d-2*gammaaa*t51*t66*t70*taua+2.48968d-2*t44*t49
     1         *t52*t66*taua+6.2242d-3*t49*t50*t55*taua-3.33333333333333
     2         37d+0*t49*t50*t51*taua+2.9876159999999996d-2*t47*t48*t66*
     3         t94+1.120356d-2*t47*t48*t65*t70*t88+1.120356d-2*t1*t52*t5
     4         3*t65*t88+1.120356d-2*gammaaa*t44*t49*t51*t65*t88+3.73452
     5         d-3*t1*t44*t55*t65*t66+3.73452d-3*gammaaa*t49*t54*t65*t66
     6         -2*t1*t44*t51*t65*t66-4*gammaaa*t47*t49*t65*t66+9.9587199
     7         99999999d-3*t52*t53*t63*t66+1.9917439999999997d-2*gammaaa
     8         *t44*t51*t62*t66-t1*t50*t54*t65+4.9793599999999993d-3*t44
     9         *t50*t55*t63-2.6666666666666666d+0*t46*t54*t63-2.66666666
     :         66666666d+0*t44*t50*t51*t63+9.958719999999999d-3*gammaaa*
     ;         t50*t54*t62-1.0666666666666666d+1*gammaaa*t47*t50*t62
            t98 = 1.0d+0*t5*t97+1.3333333333333333d+0*t60*t71
            t99 = 1.4582378849534292d-7*gammaaa*t70*t82-3.24574402386552
     1         55d-5*t49*t61
            t100 = 1/rhoa**1.0666666666666666d+1
            t101 = 2.0919959445599998d-5*gammaaa*t44*t51*t70*t88+2.09199
     1         59445599998d-5*t49*t52*t53*t88+2.0919959445599998d-5*t100
     2         *t47*t48*t88+6.973319815199999d-6*gammaaa*t54*t66*t70-1.4
     3         938079999999998d-2*gammaaa*t47*t66*t70+6.973319815199999d
     4         -6*t44*t49*t55*t66-7.46904d-3*t44*t49*t51*t66-3.73452d-3*
     5         t49*t50*t54+2*t47*t49*t50
            t102 = 1/rhoa**4
            t103 = 6.077066496460795d+1*t36*t40*t57*t9-1.823119948938238
     1         5d+2*t34*t36*t57*t9+4.0108638876641245d+3*t10*t57*t6*t78-
     2         3.342386573053437d+3*t12*t17*t57*t6+3.342386573053437d+3*
     3         t13*t14*t57*t58-6.077066496460795d+1*t37*t39*t57+1.823119
     4         9489382385d+2*t33*t37*t38*t57-3.646239897876477d+2*t31*t3
     5         3*t38*t57+3.646239897876477d+2*t30*t34*t35*t57-6.07706649
     6         6460795d+2*t28*t30*t35*t57+6.077066496460795d+2*t27*t31*t
     7         32*t57-9.115599744691192d+2*t25*t27*t32*t57+9.11559974469
     8         1192d+2*t24*t28*t29*t57-1.276183964256767d+3*t22*t24*t29*
     9         t57+1.276183964256767d+3*t21*t25*t26*t57-1.70157861900902
     :         26d+3*t19*t21*t26*t57+1.7015786190090226d+3*t18*t22*t23*t
     ;         57-2.187743938725886d+3*t16*t18*t23*t57+2.187743938725886
     <         d+3*t15*t19*t20*t57-2.734679923407357d+3*t13*t15*t20*t57+
     =         2.734679923407357d+3*t12*t16*t17*t57
            t104 = 4.97936d-2*t44*t52*t66*t75*taua+1.24484d-2*t50*t55*t7
     1         5*taua-1.3333333333333333d+1*t50*t52*t75*taua+2.48968d-2*
     2         gammaaa*t51*t66*t74*taua+2.240712d-2*gammaaa*t44*t51*t65*
     3         t75*t88+2.240712d-2*t47*t48*t65*t74*t88+2.240712d-2*t43*t
     4         52*t53*t65*t88+7.46904d-3*gammaaa*t54*t65*t66*t75-4.0d+0*
     5         gammaaa*t51*t65*t66*t75+5.228328d-2*t47*t48*t66*t70+7.469
     6         04d-3*t43*t44*t55*t65*t66-8.0d+0*t43*t44*t52*t65*t66+1.24
     7         484d-2*t1*t52*t53*t66+3.236584d-2*gammaaa*t44*t49*t51*t66
     8         -2.0d+0*t43*t50*t55*t65+6.2242d-3*t1*t44*t50*t55-3.333333
     9         3333333337d+0*t1*t46*t55+1.618292d-2*gammaaa*t49*t50*t54-
     :         6.666666666666667d+0*t1*t44*t50*t52-8.666666666666666d+0*
     ;         gammaaa*t49*t50*t51
            t105 = 1.3333333333333333d+0*t60*t76+1.0d+0*t104*t5
            t106 = 1/rhoa**9.666666666666666d+0
            t107 = 4.1839918891199995d-5*t52*t53*t75*t88+4.1839918891199
     1         995d-5*gammaaa*t44*t51*t74*t88+4.1839918891199995d-5*t106
     2         *t47*t48*t88+1.3946639630399998d-5*t44*t55*t66*t75-1.4938
     3         079999999998d-2*t44*t52*t66*t75-7.46904d-3*t44*t51*t66*t7
     4         5-3.73452d-3*t50*t55*t75-3.73452d-3*t50*t54*t75+2.0d+0*t5
     5         0*t51*t75+1.3946639630399998d-5*gammaaa*t54*t66*t74-7.469
     6         04d-3*gammaaa*t51*t66*t74-1.4938079999999998d-2*gammaaa*t
     7         47*t66*t74
            t108 = 1/rhoa**3
            t109 = 1/rhoa**6
            t110 = 1/rhoa**3.3333333333333337d+0
            t111 = 8.367983778239999d-5*t110*t52*t53*t88+8.3679837782399
     1         99d-5*gammaaa*t109*t44*t51*t88+8.367983778239999d-5*t47*t
     2         48*t88/rhoa**8.666666666666666d+0+2.7893279260799997d-5*t
     3         110*t44*t55*t66+2.7893279260799997d-5*gammaaa*t109*t54*t6
     4         6-5.975231999999999d-2*t110*t44*t52*t66-2.987615999999999
     5         6d-2*gammaaa*t109*t51*t66-1.4938079999999998d-2*t110*t50*
     6         t55+8.0d+0*t110*t50*t52
            t112 = rhoa**2
            t113 = 1/t112
            t114 = 1/t11**14
            t115 = 1/t2**4
            t116 = 1/rhoa**8.333333333333334d+0
            t117 = 1/rhoa**5.666666666666667d+0
            t118 = t65**3
            t119 = 1/t45**5
            t120 = -6.085884444444444d-2*t85*taua-8.520238222222222d-2*g
     1         ammaaa*t117
            t121 = 1/rhoa**1.1666666666666665d+1
            t122 = 1/rhoa**5
            t123 = 1/rhoa**7.666666666666667d+0
            fnc(iq) = (2.0d+0*t46*t5*t56-1.8610514726981994d+0*t4*t42*t5
     1         )*wght+fnc(iq)
            Amat(iq,D1_RA) = (t46*t68-1.0d+0*t5*t50*t56*t65-9.3052573634
     1         90997d-1*t42*t5*t64-1.2407009817987995d+0*t4*t42*t60-9.30
     2         5257363490997d-1*t4*t5*t59)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (-1.86726d-3*t50*t56*t72+1.0d+0*t46*t5*t71
     1         -9.305257363490997d-1*t42*t5*t69)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = (-3.73452d-3*t50*t56*t77+1.0d+0*t46*t5*t76-
     1         9.305257363490997d-1*t4*t5*t73)*wght+Mmat(iq,D1_TA)
            Amat2(iq,D2_RA_RA) = (t50*t93+t46*t92+2.0d+0*t5*t56*t66*t87-
     1         9.305257363490997d-1*t42*t5*t86-4.1356699393293317d-1*t4*
     2         t42*t80-9.305257363490997d-1*t4*t5*t79-2.481401963597599d
     3         +0*t42*t60*t64-1.8610514726981994d+0*t5*t59*t64-2.4814019
     4         63597599d+0*t4*t59*t60)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = (t46*t98+4.9793599999999993d-3*t50*t56
     1         *t96-9.305257363490997d-1*t42*t5*t95+3.73452d-3*t56*t65*t
     2         66*t72-1.0d+0*t5*t50*t65*t71-1.2407009817987995d+0*t42*t6
     3         0*t69-9.305257363490997d-1*t5*t59*t69-1.86726d-3*t1*t50*t
     4         68)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = (-9.305257363490997d-1*t42*t5*t99-3.7
     1         3452d-3*t50*t71*t72+6.973319815199999d-6*t102*t56*t66+1.0
     2         d+0*t101*t46*t5)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Mmat2(iq,D2_RA_TA) = (7.46904d-3*t56*t65*t66*t77-1.0d+0*t5*t
     1         50*t65*t76-9.305257363490997d-1*t5*t64*t73-1.240700981798
     2         7995d+0*t4*t60*t73+6.2242d-3*t50*t56*t72-3.73452d-3*t43*t
     3         50*t68-9.305257363490997d-1*t103*t4*t5+t105*t46)*wght+Mma
     4         t2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = (-3.73452d-3*t50*t71*t77-1.86726d-3*t5
     1         0*t72*t76-9.305257363490997d-1*t5*t69*t73+1.3946639630399
     2         998d-5*t108*t56*t66+1.0d+0*t107*t46*t5)*wght+Mmat2(iq,D2_
     3         GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_TA_TA) = (-9.305257363490997d-1*t4*t5*(8.0d+0*t3
     1         6*t40*t9+3.2d+1*t36*t37*t9+2.4d+1*t34*t36*t9+5.28d+2*t10*
     2         t6*t78+9.68d+2*t14*t58*t6+4.4d+2*t12*t17*t6+4.4d+2*t13*t1
     3         4*t58+8.0d+0*t39*t40+8.0d+0*t37*t39+2.4d+1*t33*t37*t38+7.
     4         2d+1*t33*t34*t38+4.8d+1*t31*t33*t38+4.8d+1*t30*t34*t35+1.
     5         28d+2*t30*t31*t35+8.0d+1*t28*t30*t35+8.0d+1*t27*t31*t32+2
     6         .0d+2*t27*t28*t32+1.2d+2*t25*t27*t32+1.2d+2*t24*t28*t29+2
     7         .88d+2*t24*t25*t29+1.68d+2*t22*t24*t29+1.68d+2*t21*t25*t2
     8         6+3.92d+2*t21*t22*t26+2.24d+2*t19*t21*t26+2.24d+2*t18*t22
     9         *t23+5.12d+2*t18*t19*t23+2.88d+2*t16*t18*t23+2.88d+2*t15*
     :         t19*t20+6.48d+2*t15*t16*t20+3.6d+2*t13*t15*t20+3.6d+2*t12
     ;         *t16*t17+8.0d+2*t12*t13*t17)-7.46904d-3*t50*t76*t77+2.789
     <         3279260799997d-5*t113*t56*t66+1.0d+0*t111*t46*t5)*wght+Mm
     =         at2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Amat3(iq,D3_RA_RA_RA) = (t46*(1.0d+0*t5*(4.0d+1*t1*t44*t52*t
     1         66*t89*taua+2.0d+1*gammaaa*t49*t51*t66*t89*taua+1.0d+1*t1
     2         *t50*t55*t89*taua-1.2d+2*t1*t44*t52*t87*t88*taua-6.0d+1*g
     3         ammaaa*t49*t51*t87*t88*taua-2.0d+1*t1*t55*t66*t87*taua-3.
     4         2592592592592595d+1*t46*t55*t85*taua-6.518518518518519d+1
     5         *t44*t50*t52*t85*taua-2.0148148148148146d+2*gammaaa*t50*t
     6         51*t84*taua-1.0666666666666667d+2*t44*t52*t63*t65*t66*tau
     7         a-1.6d+2*gammaaa*t51*t62*t65*t66*taua-2.6666666666666666d
     8         +1*t50*t55*t63*t65*taua-1.3333333333333333d+2*t49*t52*t65
     9         *t66*t90-1.777777777777778d+2*t50*t52*t62*t90+18*t52*t53*
     :         t65*t88*t89+18*gammaaa*t1*t44*t51*t65*t88*t89+18*t47*t48*
     ;         t49*t65*t88*t89+6*t44*t55*t65*t66*t89+6*gammaaa*t1*t54*t6
     <         5*t66*t89+16*gammaaa*t44*t51*t63*t66*t89+32*t47*t48*t62*t
     =         66*t89+8*gammaaa*t50*t54*t63*t89-48*gammaaa*t44*t51*t63*t
     >         87*t88-96*t47*t48*t62*t87*t88-6*t118*t44*t55*t88-6*gammaa
     ?         a*t1*t118*t54*t88-16*gammaaa*t54*t63*t66*t87-5.8666666666
     @         66667d+1*gammaaa*t44*t51*t65*t66*t85-2.9333333333333333d+
     1         1*gammaaa*t50*t54*t65*t85-2.0266666666666666d+2*t47*t48*t
     2         65*t66*t84-2*t120*t52*t53*t66-2*gammaaa*t1*t120*t44*t51*t
     3         66-2*t120*t47*t48*t49*t66-t120*t44*t50*t55-gammaaa*t1*t12
     4         0*t50*t54-4.5629629629629626d+1*gammaaa*t117*t46*t54-24*t
     5         118*t119*t52*t53-4.5629629629629626d+1*gammaaa*t117*t44*t
     6         50*t51-24*gammaaa*t1*t118*t119*t44*t51-2.477037037037037d
     7         +2*t116*t47*t48*t50-24*t118*t119*t47*t48*t49)+4.0d+0*t60*
     8         t91+1.3333333333333333d+0*t67*t80-2.962962962962963d-1*t4
     9         3*t56)+t66*(-2*t65*t93+4.0d+0*t5*t56*t65*t89+2.0d+0*t5*t6
     :         7*t87+2.6666666666666666d+0*t56*t60*t87)+t50*(-2*t65*t92-
     ;         1.0d+0*t5*t65*t91-t68*t89-2.0d+0*t5*t67*t89-2.66666666666
     <         66666d+0*t56*t60*t89-4.444444444444444d-1*t56*t65*t80-2.6
     =         666666666666666d+0*t60*t65*t67-1.0d+0*t120*t5*t56)-9.3052
     >         57363490997d-1*t4*t5*(3.37614805358933d+0*t39*t40*t72*t9-
     ?         6.75229610717866d+0*t37*t39*t72*t9+9.232684300601568d+2*t
     @         36*t40*t60*t9-3.693073720240627d+3*t36*t37*t60*t9+2.76980
     1         5290180471d+3*t34*t36*t60*t9-2.104036366334451d+4*t112*t3
     2         3*t40*t9+1.2624218198006704d+5*t112*t33*t37*t9-1.89363272
     3         97010064d+5*t112*t33*t34*t9+8.416145465337804d+4*t112*t31
     4         *t33*t9+6.093571638397036d+4*t10*t6*t60*t78+1.52753040195
     5         88112d+7*t112*t14*t6*t78-4.628880005935792d+6*t112*t13*t1
     6         4*t78+3.713762858948263d+1*t10*t58*t6*t72-3.7137628589482
     7         63d+1*t12*t14*t6*t72-3.37614805358933d+0*t40*t41*t72+6.75
     8         229610717866d+0*t36*t37*t38*t72-1.0128444160767991d+1*t34
     9         *t36*t38*t72+1.0128444160767991d+1*t33*t34*t35*t72-1.3504
     :         59221435732d+1*t31*t33*t35*t72+1.350459221435732d+1*t30*t
     ;         31*t32*t72-1.6880740267946648d+1*t28*t30*t32*t72+1.688074
     <         0267946648d+1*t27*t28*t29*t72-2.0256888321535982d+1*t25*t
     =         27*t29*t72+2.0256888321535982d+1*t24*t25*t26*t72-2.363303
     >         6375125308d+1*t22*t24*t26*t72+2.3633036375125308d+1*t21*t
     ?         22*t23*t72-2.700918442871464d+1*t19*t21*t23*t72+2.7009184
     @         42871464d+1*t18*t19*t20*t72-3.0385332482303967d+1*t16*t18
     1         *t20*t72+3.0385332482303967d+1*t15*t16*t17*t72-3.37614805
     2         35893296d+1*t13*t15*t17*t72+3.3761480535893296d+1*t12*t13
     3         *t14*t72-1.1171548003727898d+5*t14*t58*t6*t60+5.077976365
     4         330863d+4*t12*t17*t6*t60+5.077976365330862d+4*t13*t14*t58
     5         *t60-9.232684300601568d+2*t39*t40*t60+9.232684300601568d+
     6         2*t37*t39*t60+2.769805290180471d+3*t33*t37*t38*t60-8.3094
     7         15870541413d+3*t33*t34*t38*t60+5.539610580360942d+3*t31*t
     8         33*t38*t60+5.539610580360942d+3*t30*t34*t35*t60-1.4772294
     9         880962508d+4*t30*t31*t35*t60+9.232684300601568d+3*t28*t30
     :         *t35*t60+9.232684300601568d+3*t27*t31*t32*t60-2.308171075
     ;         150392d+4*t27*t28*t32*t60+1.3849026450902355d+4*t25*t27*t
     <         32*t60+1.3849026450902355d+4*t24*t28*t29*t60-3.3237663482
     =         16566d+4*t24*t25*t29*t60+1.9388637031263292d+4*t22*t24*t2
     >         9*t60+1.9388637031263292d+4*t21*t25*t26*t60-4.52401530729
     ?         47686d+4*t21*t22*t26*t60+2.585151604168439d+4*t19*t21*t26
     @         *t60+2.585151604168439d+4*t18*t22*t23*t60-5.9089179523850
     1         03d+4*t18*t19*t23*t60+3.3237663482165647d+4*t16*t18*t23*t
     2         60+3.3237663482165647d+4*t15*t19*t20*t60-7.47847428348727
     3         1d+4*t15*t16*t20*t60+4.154707935270705d+4*t13*t15*t20*t60
     4         +4.1547079352707056d+4*t12*t16*t17*t60-9.232684300601568d
     5         +4*t12*t13*t17*t60-1.2729420016323426d+7*t112*t17*t58*t6+
     6         3.4716600044518436d+6*t112*t12*t20*t6-6.01754400771653d+6
     7         *t10*t112*t114*t6-3.4716600044518436d+6*t112*t16*t17*t58+
     8         1.1572200014839477d+7*t112*t13*t17*t58+2.104036366334451d
     9         +4*t112*t36*t40-8.416145465337804d+4*t112*t30*t37*t38+3.7
     :         87265459402013d+5*t112*t30*t34*t38-5.049687279202681d+5*t
     ;         112*t30*t31*t38+2.1040363663344508d+5*t112*t28*t30*t38-4.
     <         208072732668902d+4*t112*t36*t37+2.104036366334451d+4*t112
     =         *t34*t36-2.104036366334451d+5*t112*t27*t34*t35+8.41614546
     >         5337803d+5*t112*t27*t31*t35-1.0520181831672254d+6*t112*t2
     ?         7*t28*t35+4.208072732668902d+5*t112*t25*t27*t35-4.2080727
     @         326689016d+5*t112*t24*t31*t32+1.578027274750838d+6*t112*t
     1         24*t28*t32-1.893632729701006d+6*t112*t24*t25*t32+7.364127
     2         282170578d+5*t112*t22*t24*t32-7.364127282170578d+5*t112*t
     3         21*t28*t29+2.6510858215814087d+6*t112*t21*t25*t29-3.09293
     4         34585116436d+6*t112*t21*t22*t29+1.1782603651472927d+6*t11
     5         2*t19*t21*t29-1.1782603651472927d+6*t112*t18*t25*t26+4.12
     6         3911278015524d+6*t112*t18*t22*t26-4.713041460589171d+6*t1
     7         12*t18*t19*t26+1.767390547720939d+6*t112*t16*t18*t26-1.76
     8         73905477209387d+6*t112*t15*t22*t23+6.059624735043219d+6*t
     9         112*t15*t19*t23-6.817077826923622d+6*t112*t15*t16*t23+2.5
     :         24843639601341d+6*t112*t13*t15*t23-2.524843639601341d+6*t
     ;         112*t12*t19*t20+8.521347283654526d+6*t112*t12*t16*t20-9.4
     <         68163648505028d+6*t112*t12*t13*t20)-6.0d+0*t118*t5*t56*t8
     =         8-3.7221029453963983d+0*t42*t60*t86-2.791577209047299d+0*
     >         t5*t59*t86-9.305257363490997d-1*t42*t5*(-1.97024140900374
     ?         43d-5*t81*t82/rhoa**11+3.279403591520427d-3*t116*t48*t61-
     @         1.648227300332581d-1*gammaaa*t117*t3+3.7270905095708196d-
     1         8*gammaaa**4*t115/rhoa**1.3666666666666666d+1)+(-1.240700
     2         9817987995d+0*t42*t64-1.2407009817987995d+0*t4*t59)*t80-2
     3         .791577209047299d+0*t5*t64*t79-3.7221029453963983d+0*t4*t
     4         60*t79-7.444205890792797d+0*t59*t60*t64+2.757113292886221
     5         d-1*t4*t42*t43)*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = (t46*(1.0d+0*t5*(-1.659786666666666
     1         6d-1*gammaaa*t51*t66*t94*taua-7.46904d-2*gammaaa*t51*t65*
     2         t70*t88*taua-1.493808d-1*t44*t49*t52*t65*t88*taua-2.48968
     3         d-2*t49*t55*t65*t66*taua+1.3333333333333333d+1*t49*t51*t6
     4         5*t66*taua-1.9917439999999997d-1*t44*t52*t62*t66*taua-4.9
     5         793599999999993d-2*t50*t55*t62*taua+2.6666666666666666d+1
     6         *t50*t51*t62*taua-1.7925696d-1*t47*t48*t65*t88*t94-8.2989
     7         33333333335d-2*t52*t66*t70*t90+1.120356d-2*t47*t48*t70*t8
     8         8*t89+1.120356d-2*t1*t52*t53*t88*t89+1.120356d-2*gammaaa*
     9         t44*t49*t51*t88*t89+3.73452d-3*t1*t44*t55*t66*t89+3.73452
     :         d-3*gammaaa*t49*t54*t66*t89-2*t1*t44*t51*t66*t89-4*gammaa
     ;         a*t47*t49*t66*t89-t1*t50*t54*t89-1.120356d-2*t1*t44*t55*t
     <         87*t88-1.120356d-2*gammaaa*t49*t54*t87*t88+6*t1*t44*t51*t
     =         87*t88+12*gammaaa*t47*t49*t87*t88-5.975231999999999d-2*t5
     >         2*t53*t63*t65*t88-1.1950464d-1*gammaaa*t44*t51*t62*t65*t8
     ?         8-4.481424d-2*t119*t47*t48*t70*t87+2*t1*t54*t66*t87-4.481
     @         424d-2*t1*t119*t52*t53*t87-4.481424d-2*gammaaa*t119*t44*t
     1         49*t51*t87-3.6515306666666664d-2*t52*t53*t66*t85-1.825765
     2         3333333332d-2*t44*t50*t55*t85+9.777777777777779d+0*t46*t5
     3         4*t85+9.777777777777779d+0*t44*t50*t51*t85-1.261437866666
     4         6665d-1*gammaaa*t44*t51*t66*t84-6.307189333333332d-2*gamm
     5         aaa*t50*t54*t84+6.755555555555556d+1*gammaaa*t47*t50*t84-
     6         2.6888544000000003d-1*t47*t48*t66*t83-1.9917439999999997d
     7         -2*t44*t55*t63*t65*t66+1.0666666666666666d+1*t44*t51*t63*
     8         t65*t66-3.9834879999999995d-2*gammaaa*t54*t62*t65*t66+4.2
     9         666666666666664d+1*gammaaa*t47*t62*t65*t66+5.333333333333
     :         333d+0*t50*t54*t63*t65)+2.6666666666666666d+0*t60*t97+4.4
     ;         44444444444444d-1*t71*t80)+t50*(-t65*t98-1.0d+0*t5*t65*t9
     <         7+4.9793599999999993d-3*t67*t96-1.0d+0*t5*t71*t89-1.33333
     =         33333333333d+0*t60*t65*t71+4.9793599999999993d-3*t63*t68-
     >         1.1618506666666667d-2*t110*t56)-1.9917439999999997d-2*t56
     ?         *t65*t66*t96-2.481401963597599d+0*t42*t60*t95-1.861051472
     @         6981994d+0*t5*t59*t95-3.73452d-3*t1*t66*t93-1.86726d-3*t1
     1         *t50*t92-1.120356d-2*t56*t72*t87*t88+2.0d+0*t5*t66*t71*t8
     2         7-9.305257363490997d-1*t42*t5*(3.531915643569816d-2*t3*t8
     3         5-9.376593846722628d-4*gammaaa*t61*t84+6.610678411788878d
     4         -6*t48*t82*t83-1.3976589410890572d-8*t115*t81/rhoa**1.266
     5         6666666666665d+1)-4.1356699393293317d-1*t42*t69*t80-9.305
     6         257363490997d-1*t5*t69*t79-2.481401963597599d+0*t59*t60*t
     7         69)*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = (t46*(1.0d+0*t5*(-1.39466396303999
     1         98d-4*t44*t52*t70*t88*taua-6.9733198152d-5*gammaaa*t100*t
     2         51*t88*taua-2.3244399384d-5*t55*t66*t70*taua+2.48968d-2*t
     3         51*t66*t70*taua-1.6735967556479997d-4*gammaaa*t44*t51*t88
     4         *t94-5.578655852159999d-5*gammaaa*t54*t66*t94+1.1950464d-
     5         1*gammaaa*t47*t66*t94-2.0919959445599998d-5*gammaaa*t54*t
     6         65*t70*t88+4.481424d-2*gammaaa*t47*t65*t70*t88-2.09199594
     7         45599998d-5*t44*t49*t55*t65*t88+2.240712d-2*t44*t49*t51*t
     8         65*t88-1.1157311704319998d-4*t52*t53*t62*t88-2.2314623408
     9         639997d-4*t121*t47*t48*t88-8.367983778239999d-5*gammaaa*t
     :         119*t44*t51*t65*t70+7.46904d-3*t49*t54*t65*t66-4*t47*t49*
     ;         t65*t66-3.7191039014399996d-5*t44*t55*t62*t66+3.983487999
     <         9999995d-2*t44*t51*t62*t66-8.367983778239999d-5*t119*t49*
     =         t52*t53*t65-8.367983778239999d-5*t100*t119*t47*t48*t65+1.
     >         9917439999999997d-2*t50*t54*t62-1.0666666666666666d+1*t47
     ?         *t50*t62)+1.3333333333333333d+0*t101*t60)-1.2407009817987
     @         995d+0*t42*t60*t99-9.305257363490997d-1*t5*t59*t99-3.7345
     1         2d-3*t1*t50*t98+9.958719999999999d-3*t50*t71*t96-9.305257
     2         363490997d-1*t42*t5*(-1.944317179937905d-6*gammaaa*t82*t9
     3         4+1.731063479394947d-4*t61*t62+5.241221029083964d-9*t115*
     4         t121*t48)-2.0919959445599998d-5*t102*t56*t65*t88+7.46904d
     5         -3*t65*t66*t71*t72+6.973319815199999d-6*t49*t66*t68-3.719
     6         1039014399996d-5*t122*t56*t66-1.0d+0*t101*t5*t50*t65)*wgh
     7         t+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = (1.0d+0*t46*t5*(-3.90630034743910
     1         45d-8*t44*t55*t70*t88+6.275987833679999d-5*t44*t51*t70*t8
     2         8-3.9063003474391045d-8*gammaaa*t100*t54*t88+1.2551975667
     3         36d-4*gammaaa*t100*t47*t88+2.0919959445599995d-5*t54*t66*
     4         t70-2.240712d-2*t47*t66*t70-1.562520138975642d-7*t119*t52
     5         *t53*t70-1.562520138975642d-7*gammaaa*t100*t119*t44*t51-1
     6         .562520138975642d-7*t119*t47*t48/rhoa**1.3333333333333333
     7         d+1)-3.9063003474391045d-8*t56*t88/rhoa**6.66666666666666
     8         7d+0-9.305257363490997d-1*t42*t5*(4.374713654860287d-7*t7
     9         0*t82-1.965457885906487d-9*gammaaa*t100*t115)-5.60178d-3*
     :         t101*t50*t72+2.0919959445599995d-5*t102*t66*t71)*wght+Cma
     ;         t3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Mmat3(iq,D3_RA_RA_TA) = (t46*(1.0d+0*t5*(-2.987616d-1*t44*t5
     1         2*t65*t75*t88*taua-1.493808d-1*gammaaa*t51*t65*t74*t88*ta
     2         ua-4.97936d-2*t55*t65*t66*t75*taua+5.333333333333333d+1*t
     3         52*t65*t66*t75*taua-2.8216373333333333d-1*gammaaa*t51*t66
     4         *t70*taua-2.9876159999999996d-1*t44*t49*t52*t66*taua-7.46
     5         9039999999999d-2*t49*t50*t55*taua+8.0d+1*t49*t50*t52*taua
     6         -4.1826624d-1*t47*t48*t66*t94-1.659786666666667d-1*t52*t6
     7         6*t74*t90+2.240712d-2*gammaaa*t44*t51*t75*t88*t89+2.24071
     8         2d-2*t47*t48*t74*t88*t89+2.240712d-2*t43*t52*t53*t88*t89+
     9         7.46904d-3*gammaaa*t54*t66*t75*t89-4.0d+0*gammaaa*t51*t66
     :         *t75*t89+7.46904d-3*t43*t44*t55*t66*t89-8.0d+0*t43*t44*t5
     ;         2*t66*t89-2.0d+0*t43*t50*t55*t89-2.240712d-2*gammaaa*t54*
     <         t75*t87*t88+1.2d+1*gammaaa*t51*t75*t87*t88-2.240712d-2*t4
     =         3*t44*t55*t87*t88+2.4d+1*t43*t44*t52*t87*t88-3.1369968d-1
     >         *t47*t48*t65*t70*t88-7.46904d-2*t1*t52*t53*t65*t88-1.9419
     ?         503999999999d-1*gammaaa*t44*t49*t51*t65*t88-8.962848d-2*g
     @         ammaaa*t119*t44*t51*t75*t87-8.962848d-2*t119*t47*t48*t74*
     1         t87+4.0d+0*t43*t55*t66*t87-8.962848d-2*t119*t43*t52*t53*t
     2         87-2.48968d-2*t1*t44*t55*t65*t66-6.473168d-2*gammaaa*t49*
     3         t54*t65*t66+2.6666666666666666d+1*t1*t44*t52*t65*t66+3.46
     4         6666666666666d+1*gammaaa*t49*t51*t65*t66-3.31957333333333
     5         3d-2*t52*t53*t63*t66-1.7261781333333331d-1*gammaaa*t44*t5
     6         1*t62*t66+6.666666666666667d+0*t1*t50*t55*t65-1.659786666
     7         6666666d-2*t44*t50*t55*t63+8.88888888888889d+0*t46*t55*t6
     8         3+1.7777777777777778d+1*t44*t50*t52*t63-8.630890666666666
     9         d-2*gammaaa*t50*t54*t62+4.622222222222223d+1*gammaaa*t50*
     :         t51*t62)+4.444444444444444d-1*t76*t80+2.6666666666666666d
     ;         +0*t104*t60)+t50*(-8.298933333333333d-3*t56*t96-1.0d+0*t5
     <         *t76*t89-1.3333333333333333d+0*t60*t65*t76+6.2242d-3*t67*
     =         t72+6.2242d-3*t1*t68-1.0d+0*t104*t5*t65-t105*t65)-7.46904
     >         d-3*t43*t66*t93-3.73452d-3*t43*t50*t92-9.305257363490997d
     ?         -1*t4*t5*(4.0513776643071964d+1*t36*t40*t77*t9-1.21541329
     @         92921589d+2*t34*t36*t77*t9-2.769805290180471d+3*t33*t40*t
     1         5*t9+5.539610580360942d+3*t33*t37*t5*t9+8.309415870541416
     2         d+3*t33*t34*t5*t9-1.1079221160721883d+4*t31*t33*t5*t9+2.6
     3         739092584427493d+3*t10*t6*t77*t78+6.702928802236738d+5*t1
     4         4*t5*t6*t78-6.093571638397035d+5*t13*t14*t5*t78-2.2282577
     5         15368958d+3*t12*t17*t6*t77+2.2282577153689576d+3*t13*t14*
     6         t58*t77-4.0513776643071964d+1*t37*t39*t77+1.2154132992921
     7         589d+2*t33*t37*t38*t77-2.4308265985843178d+2*t31*t33*t38*
     8         t77+2.4308265985843178d+2*t30*t34*t35*t77-4.0513776643071
     9         96d+2*t28*t30*t35*t77+4.0513776643071964d+2*t27*t31*t32*t
     :         77-6.077066496460795d+2*t25*t27*t32*t77+6.077066496460793
     ;         d+2*t24*t28*t29*t77-8.507893095045111d+2*t22*t24*t29*t77+
     <         8.507893095045113d+2*t21*t25*t26*t77-1.1343857460060149d+
     =         3*t19*t21*t26*t77+1.1343857460060149d+3*t18*t22*t23*t77-1
     >         .4584959591505905d+3*t16*t18*t23*t77+1.4584959591505908d+
     ?         3*t15*t19*t20*t77-1.8231199489382383d+3*t13*t15*t20*t77+1
     @         .8231199489382383d+3*t12*t16*t17*t77+5.585774001863949d+5
     1         *t17*t5*t58*t6-4.5701787287977763d+5*t12*t20*t5*t6-7.9216
     2         43129916147d+5*t10*t114*t5*t6-4.5701787287977763d+5*t16*t
     3         17*t5*t58+5.077976365330863d+5*t13*t17*t5*t58+9.232684300
     4         601569d+2*t36*t40*t5-1.1079221160721883d+4*t30*t37*t38*t5
     5         +1.6618831741082832d+4*t30*t34*t38*t5+2.2158442321443766d
     6         +4*t30*t31*t38*t5-2.7698052901804704d+4*t28*t30*t38*t5+1.
     7         846536860120314d+3*t36*t37*t5-2.769805290180471d+3*t34*t3
     8         6*t5-2.769805290180471d+4*t27*t34*t35*t5+3.69307372024062
     9         9d+4*t27*t31*t35*t5+4.616342150300784d+4*t27*t28*t35*t5-5
     :         .539610580360942d+4*t25*t27*t35*t5-5.539610580360941d+4*t
     ;         24*t31*t32*t5+6.924513225451174d+4*t24*t28*t32*t5+8.30941
     <         5870541416d+4*t24*t25*t32*t5-9.694318515631648d+4*t22*t24
     =         *t32*t5-9.694318515631648d+4*t21*t28*t29*t5+1.16331822187
     >         57979d+5*t21*t25*t29*t5+1.3572045921884307d+5*t21*t22*t29
     ?         *t5-1.5510909625010635d+5*t19*t21*t29*t5-1.55109096250106
     @         38d+5*t18*t25*t26*t5+1.809606122917908d+5*t18*t22*t26*t5+
     1         2.0681212833347515d+5*t18*t19*t26*t5-2.3266364437515952d+
     2         5*t16*t18*t26*t5-2.3266364437515955d+5*t15*t22*t23*t5+2.6
     3         59013078573252d+5*t15*t19*t23*t5+2.9913897133949086d+5*t1
     4         5*t16*t23*t5-3.3237663482165647d+5*t13*t15*t23*t5-3.32376
     5         6348216565d+5*t12*t19*t20*t5+3.7392371417436354d+5*t12*t1
     6         6*t20*t5+4.1547079352707056d+5*t12*t13*t20*t5)-2.240712d-
     7         2*t56*t77*t87*t88+2.0d+0*t5*t66*t76*t87-9.305257363490997
     8         d-1*t5*t73*t86-4.1356699393293317d-1*t4*t73*t80-2.4814019
     9         63597599d+0*t60*t64*t73-2.48968d-2*t56*t65*t66*t72-1.8610
     :         514726981994d+0*t103*t5*t64-2.481401963597599d+0*t103*t4*
     ;         t60)*wght+Mmat3(iq,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
            Mmat3(iq,D3_RA_GAA_TA) = (t46*(1.0d+0*t5*(-2.789327926079999
     1         7d-4*t44*t52*t74*t88*taua-1.3946639630399998d-4*gammaaa*t
     2         106*t51*t88*taua-4.6488798768d-5*t55*t66*t74*taua+4.97936
     3         d-2*t52*t66*t74*taua+2.48968d-2*t51*t66*t74*taua-4.183991
     4         8891199995d-5*t44*t55*t65*t75*t88+4.481424d-2*t44*t52*t65
     5         *t75*t88+2.240712d-2*t44*t51*t65*t75*t88-4.18399188911999
     6         95d-5*gammaaa*t54*t65*t74*t88+2.240712d-2*gammaaa*t51*t65
     7         *t74*t88+4.481424d-2*gammaaa*t47*t65*t74*t88-2.9287943223
     8         839996d-4*gammaaa*t44*t51*t70*t88-1.8130631519519996d-4*t
     9         49*t52*t53*t88-4.044525492816d-4*t100*t47*t48*t88+7.46904
     :         d-3*t55*t65*t66*t75+7.46904d-3*t54*t65*t66*t75-4.0d+0*t51
     ;         *t65*t66*t75-1.673596755648d-4*t119*t52*t53*t65*t75-1.673
     <         596755648d-4*gammaaa*t119*t44*t51*t65*t74-9.76264774128d-
     =         5*gammaaa*t54*t66*t70+5.228328d-2*gammaaa*t51*t66*t70+1.0
     >         456655999999999d-1*gammaaa*t47*t66*t70-6.043543839839999d
     ?         -5*t44*t49*t55*t66+6.473168d-2*t44*t49*t52*t66+3.236584d-
     @         2*t44*t49*t51*t66-1.673596755648d-4*t106*t119*t47*t48*t65
     1         +1.618292d-2*t49*t50*t55+1.618292d-2*t49*t50*t54-8.666666
     2         666666666d+0*t49*t50*t51)+1.3333333333333333d+0*t107*t60)
     3         -3.73452d-3*t43*t50*t98+4.9793599999999993d-3*t50*t76*t96
     4         -9.305257363490997d-1*t5*t73*t95-4.1839918891199995d-5*t1
     5         08*t56*t65*t88+7.46904d-3*t65*t66*t71*t77+3.73452d-3*t65*
     6         t66*t72*t76+1.3946639630399998d-5*t66*t68*t75-1.240700981
     7         7987995d+0*t60*t69*t73+6.2242d-3*t50*t71*t72-9.3052573634
     8         90997d-1*t103*t5*t69-6.043543839839999d-5*t102*t56*t66-1.
     9         0d+0*t107*t5*t50*t65-1.86726d-3*t1*t105*t50)*wght+Mmat3(i
     :         q,D3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
            Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
            Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
            Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = (-9.305257363490997d-1*t5*t73*t99+
     1         1.0d+0*t46*t5*(-7.812600694878209d-8*t44*t55*t74*t88+8.36
     2         7983778239999d-5*t44*t52*t74*t88+8.367983778239999d-5*t44
     3         *t51*t74*t88-7.812600694878209d-8*gammaaa*t106*t54*t88+4.
     4         1839918891199995d-5*gammaaa*t106*t51*t88+1.673596755648d-
     5         4*gammaaa*t106*t47*t88+1.3946639630399998d-5*t55*t66*t74+
     6         2.7893279260799997d-5*t54*t66*t74-1.4938079999999998d-2*t
     7         51*t66*t74-1.4938079999999998d-2*t47*t66*t74-3.1250402779
     8         51284d-7*t119*t52*t53*t74-3.125040277951284d-7*gammaaa*t1
     9         06*t119*t44*t51-3.125040277951284d-7*t119*t47*t48/rhoa**1
     :         .2333333333333334d+1)-7.812600694878209d-8*t117*t56*t88-3
     ;         .73452d-3*t101*t50*t77+6.973319815199999d-6*t102*t66*t76-
     <         3.73452d-3*t107*t50*t72+2.7893279260799997d-5*t108*t66*t7
     =         1)*wght+Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
            Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
            Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
            Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
            Mmat3(iq,D3_TA_TA_TA) = (-9.305257363490997d-1*t4*t5*(-4.8d+
     1         1*t33*t40*t9-2.88d+2*t33*t37*t9-4.32d+2*t33*t34*t9-1.92d+
     2         2*t31*t33*t9-3.4848d+4*t14*t6*t78-1.056d+4*t13*t14*t78-2.
     3         904d+4*t17*t58*t6-7.92d+3*t12*t20*t6-1.3728d+4*t10*t114*t
     4         6-7.92d+3*t16*t17*t58-2.64d+4*t13*t17*t58-4.8d+1*t36*t40-
     5         1.92d+2*t30*t37*t38-8.64d+2*t30*t34*t38-1.152d+3*t30*t31*
     6         t38-4.8d+2*t28*t30*t38-9.6d+1*t36*t37-4.8d+1*t34*t36-4.8d
     7         +2*t27*t34*t35-1.92d+3*t27*t31*t35-2.4d+3*t27*t28*t35-9.6
     8         d+2*t25*t27*t35-9.6d+2*t24*t31*t32-3.6d+3*t24*t28*t32-4.3
     9         2d+3*t24*t25*t32-1.68d+3*t22*t24*t32-1.68d+3*t21*t28*t29-
     :         6.048d+3*t21*t25*t29-7.056d+3*t21*t22*t29-2.688d+3*t19*t2
     ;         1*t29-2.688d+3*t18*t25*t26-9.408d+3*t18*t22*t26-1.0752d+4
     <         *t18*t19*t26-4.032d+3*t16*t18*t26-4.032d+3*t15*t22*t23-1.
     =         3824d+4*t15*t19*t23-1.5552d+4*t15*t16*t23-5.76d+3*t13*t15
     >         *t23-5.76d+3*t12*t19*t20-1.944d+4*t12*t16*t20-2.16d+4*t12
     ?         *t13*t20)+1.0d+0*t46*t5*(-3.1250402779512837d-7*t122*t44*
     @         t55*t88-3.1250402779512837d-7*gammaaa*t123*t54*t88+1.0041
     1         580533887999d-3*t122*t44*t52*t88+5.020790266944d-4*gammaa
     2         a*t123*t51*t88+1.6735967556479997d-4*t122*t55*t66-1.79256
     3         96d-1*t122*t52*t66-1.2500161111805136d-6*t119*t122*t52*t5
     4         3-1.2500161111805136d-6*gammaaa*t119*t123*t44*t51-1.25001
     5         61111805136d-6*t119*t47*t48/rhoa**1.0333333333333333d+1)-
     6         3.1250402779512837d-7*t56*t63*t88-1.120356d-2*t111*t50*t7
     7         7+8.367983778239998d-5*t113*t66*t76)*wght+Mmat3(iq,D3_TA_
     8         TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammaaa*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammaaa*t1*t3+1.0d+0
            t5 = rhoa**1.3333333333333333d+0
            t6 = param(7)
            t7 = param(18)
            t8 = rhoa**1.6666666666666669d+0
            t9 = 9.115599744691192d+0*t8
            t10 = t9-2.0d+0*taua
            t11 = t10**11
            t12 = 2.0d+0*taua+t9
            t13 = 1/t12**11
            t14 = param(17)
            t15 = t10**10
            t16 = 1/t12**10
            t17 = param(16)
            t18 = t10**9
            t19 = 1/t12**9
            t20 = param(15)
            t21 = t10**8
            t22 = 1/t12**8
            t23 = param(14)
            t24 = t10**7
            t25 = 1/t12**7
            t26 = param(13)
            t27 = t10**6
            t28 = 1/t12**6
            t29 = param(12)
            t30 = t10**5
            t31 = 1/t12**5
            t32 = param(11)
            t33 = t10**4
            t34 = 1/t12**4
            t35 = param(10)
            t36 = t10**3
            t37 = 1/t12**3
            t38 = param(9)
            t39 = t10**2
            t40 = 1/t12**2
            t41 = param(8)
            t42 = 1/t12
            t43 = t11*t13*t7+t6+t10*t41*t42+t38*t39*t40+t35*t36*t37+t32*
     1         t33*t34+t29*t30*t31+t26*t27*t28+t23*t24*t25+t20*t21*t22+t
     2         17*t18*t19+t14*t15*t16
            t44 = 1/t8
            t45 = 2.0d+0*t44*taua-9.11559972d+0
            t46 = 1.86726d-3*t45+1.86726d-3*gammaaa*t1+1.0d+0
            t47 = 1/t46
            t48 = param(1)
            t49 = param(4)
            t50 = gammaaa**2
            t51 = 1/rhoa**5.333333333333333d+0
            t52 = 1/t46**2
            t53 = param(5)
            t54 = param(6)
            t55 = t45**2
            t56 = param(2)
            t57 = param(3)
            t58 = t45*t47*t57+gammaaa*t1*t47*t56+t52*t54*t55+gammaaa*t1*
     1         t45*t52*t53+t49*t50*t51*t52+t48
            t59 = 1/rhob**2.6666666666666666d+0
            t60 = 4.49276922095889d-3*gammabb*t59+1.0d+0
            t61 = 1/t60
            t62 = 3.6121864536509485d-3*gammabb*t59*t61+1.0d+0
            t63 = rhob**1.3333333333333333d+0
            t64 = rhob**1.6666666666666669d+0
            t65 = 9.115599744691192d+0*t64
            t66 = t65-2.0d+0*taub
            t67 = t66**11
            t68 = 2.0d+0*taub+t65
            t69 = 1/t68**11
            t70 = t66**10
            t71 = 1/t68**10
            t72 = t66**9
            t73 = 1/t68**9
            t74 = t66**8
            t75 = 1/t68**8
            t76 = t66**7
            t77 = 1/t68**7
            t78 = t66**6
            t79 = 1/t68**6
            t80 = t66**5
            t81 = 1/t68**5
            t82 = t66**4
            t83 = 1/t68**4
            t84 = t66**3
            t85 = 1/t68**3
            t86 = t66**2
            t87 = 1/t68**2
            t88 = 1/t68
            t89 = t41*t66*t88+t38*t86*t87+t35*t84*t85+t32*t82*t83+t29*t8
     1         0*t81+t26*t78*t79+t23*t76*t77+t20*t74*t75+t17*t72*t73+t14
     2         *t70*t71+t67*t69*t7+t6
            t90 = 1/t64
            t91 = 2.0d+0*t90*taub-9.11559972d+0
            t92 = 1.86726d-3*t91+1.86726d-3*gammabb*t59+1.0d+0
            t93 = 1/t92
            t94 = gammabb**2
            t95 = 1/rhob**5.333333333333333d+0
            t96 = 1/t92**2
            t97 = t91**2
            t98 = t54*t96*t97+t49*t94*t95*t96+gammabb*t53*t59*t91*t96+t5
     1         7*t91*t93+gammabb*t56*t59*t93+t48
            t99 = rhoa**6.666666666666666d-1
            t100 = 1/t12**12
            t101 = 1.6711932865267184d+2*t13*t15*t7*t99-1.67119328652671
     1         84d+2*t100*t11*t7*t99+1.5192666241151986d+1*t41*t42*t99-1
     2         .5192666241151986d+1*t10*t40*t41*t99+3.038533248230397d+1
     3         *t10*t38*t40*t99-3.038533248230397d+1*t37*t38*t39*t99+4.5
     4         577998723455965d+1*t35*t37*t39*t99-4.5577998723455965d+1*
     5         t34*t35*t36*t99+6.077066496460795d+1*t32*t34*t36*t99-6.07
     6         7066496460795d+1*t31*t32*t33*t99+7.596333120575993d+1*t29
     7         *t31*t33*t99-7.596333120575993d+1*t28*t29*t30*t99+9.11559
     8         9744691193d+1*t26*t28*t30*t99-9.115599744691193d+1*t25*t2
     9         6*t27*t99+1.0634866368806391d+2*t23*t25*t27*t99-1.0634866
     :         368806391d+2*t22*t23*t24*t99+1.2154132992921589d+2*t20*t2
     ;         2*t24*t99-1.2154132992921589d+2*t19*t20*t21*t99+1.3673399
     <         617036788d+2*t17*t19*t21*t99-1.3673399617036788d+2*t16*t1
     =         7*t18*t99+1.5192666241151986d+2*t14*t16*t18*t99-1.5192666
     >         241151986d+2*t13*t14*t15*t99
            t102 = rhoa**3.333333333333333d-1
            t103 = 1/t2**2
            t104 = 1/rhoa**6.333333333333333d+0
            t105 = 1/rhoa**3.6666666666666664d+0
            t106 = 4.327658698487368d-5*t103*t104*t50-9.632497209735863d
     1         -3*gammaaa*t105*t3
            t107 = -6.2242d-3*t1*taua-4.9793599999999993d-3*gammaaa*t105
            t108 = 1/t46**3
            t109 = -3.3333333333333337d+0*t1*t47*t57*taua-6.666666666666
     1         667d+0*t1*t45*t52*t54*taua-3.3333333333333337d+0*gammaaa*
     2         t51*t52*t53*taua-t107*t45*t52*t57-gammaaa*t1*t107*t52*t56
     3         -2.6666666666666666d+0*gammaaa*t105*t47*t56-2*t107*t108*t
     4         54*t55-2.6666666666666666d+0*gammaaa*t105*t45*t52*t53-2*g
     5         ammaaa*t1*t107*t108*t45*t53-5.333333333333333d+0*t104*t49
     6         *t50*t52-2*t107*t108*t49*t50*t51
            t110 = 1.3333333333333333d+0*t102*t58+1.0d+0*t109*t5
            t111 = rhob**6.666666666666666d-1
            t112 = 1/t68**12
            t113 = 1.5192666241151986d+1*t111*t41*t88-1.5192666241151986
     1         d+1*t111*t41*t66*t87+3.038533248230397d+1*t111*t38*t66*t8
     2         7-3.038533248230397d+1*t111*t38*t85*t86+4.557799872345596
     3         5d+1*t111*t35*t85*t86-4.5577998723455965d+1*t111*t35*t83*
     4         t84+6.077066496460795d+1*t111*t32*t83*t84-6.0770664964607
     5         95d+1*t111*t32*t81*t82+7.596333120575993d+1*t111*t29*t81*
     6         t82-7.596333120575993d+1*t111*t29*t79*t80+9.1155997446911
     7         93d+1*t111*t26*t79*t80-9.115599744691193d+1*t111*t26*t77*
     8         t78+1.0634866368806391d+2*t111*t23*t77*t78-1.063486636880
     9         6391d+2*t111*t23*t75*t76+1.2154132992921589d+2*t111*t20*t
     :         75*t76-1.2154132992921589d+2*t111*t20*t73*t74+1.367339961
     ;         7036788d+2*t111*t17*t73*t74-1.3673399617036788d+2*t111*t1
     <         7*t71*t72+1.5192666241151986d+2*t111*t14*t71*t72+1.671193
     =         2865267184d+2*t111*t69*t7*t70-1.5192666241151986d+2*t111*
     >         t14*t69*t70-1.6711932865267184d+2*t111*t112*t67*t7
            t114 = rhob**3.333333333333333d-1
            t115 = 1/t60**2
            t116 = 1/rhob**6.333333333333333d+0
            t117 = 1/rhob**3.6666666666666664d+0
            t118 = 4.327658698487368d-5*t115*t116*t94-9.632497209735863d
     1         -3*gammabb*t117*t61
            t119 = -6.2242d-3*t59*taub-4.9793599999999993d-3*gammabb*t11
     1         7
            t120 = 1/t92**3
            t121 = -3.3333333333333337d+0*gammabb*t53*t95*t96*taub-6.666
     1         666666666667d+0*t54*t59*t91*t96*taub-3.3333333333333337d+
     2         0*t57*t59*t93*taub-2*t119*t120*t54*t97-5.333333333333333d
     3         +0*t116*t49*t94*t96-t119*t57*t91*t96-2.6666666666666666d+
     4         0*gammabb*t117*t53*t91*t96-gammabb*t119*t56*t59*t96-2*t11
     5         9*t120*t49*t94*t95-2.6666666666666666d+0*gammabb*t117*t56
     6         *t93-2*gammabb*t119*t120*t53*t59*t91
            t122 = 1.3333333333333333d+0*t114*t98+1.0d+0*t121*t63
            t123 = 3.6121864536509485d-3*t1*t3-1.6228720119327628d-5*gam
     1         maaa*t103*t51
            t124 = 1/rhoa**8
            t125 = -1.86726d-3*t1*t45*t52*t57-1.86726d-3*gammaaa*t51*t52
     1         *t56+t1*t47*t56-3.73452d-3*t1*t108*t54*t55+t1*t45*t52*t53
     2         -3.73452d-3*gammaaa*t108*t45*t51*t53+2*gammaaa*t49*t51*t5
     3         2-3.73452d-3*t108*t124*t49*t50
            t126 = 1/t5
            t127 = 3.6121864536509485d-3*t59*t61-1.6228720119327628d-5*g
     1         ammabb*t115*t95
            t128 = 1/rhob**8
            t129 = -3.73452d-3*t120*t54*t59*t97-1.86726d-3*gammabb*t56*t
     1         95*t96+2*gammabb*t49*t95*t96-1.86726d-3*t57*t59*t91*t96+t
     2         53*t59*t91*t96-3.73452d-3*gammabb*t120*t53*t91*t95-3.7345
     3         2d-3*t120*t128*t49*t94+t56*t59*t93
            t130 = 1/t63
            t131 = -2.2d+1*t13*t15*t7-2.2d+1*t100*t11*t7-2.0d+0*t41*t42-
     1         2.0d+0*t10*t40*t41-4.0d+0*t10*t38*t40-4.0d+0*t37*t38*t39-
     2         6.0d+0*t35*t37*t39-6.0d+0*t34*t35*t36-8.0d+0*t32*t34*t36-
     3         8.0d+0*t31*t32*t33-1.0d+1*t29*t31*t33-1.0d+1*t28*t29*t30-
     4         1.2d+1*t26*t28*t30-1.2d+1*t25*t26*t27-1.4d+1*t23*t25*t27-
     5         1.4d+1*t22*t23*t24-1.6d+1*t20*t22*t24-1.6d+1*t19*t20*t21-
     6         1.8d+1*t17*t19*t21-1.8d+1*t16*t17*t18-2.0d+1*t14*t16*t18-
     7         2.0d+1*t13*t14*t15
            t132 = 1/rhoa**7
            t133 = 1/rhoa**4.333333333333333d+0
            t134 = -3.73452d-3*t44*t45*t52*t57+2.0d+0*t44*t47*t57-3.7345
     1         2d-3*gammaaa*t133*t52*t56-7.46904d-3*t108*t44*t54*t55+4.0
     2         d+0*t44*t45*t52*t54+2.0d+0*gammaaa*t133*t52*t53-7.46904d-
     3         3*gammaaa*t108*t133*t45*t53-7.46904d-3*t108*t132*t49*t50
            t135 = 1/t102
            t136 = -2.0d+0*t41*t88-2.0d+0*t41*t66*t87-4.0d+0*t38*t66*t87
     1         -4.0d+0*t38*t85*t86-6.0d+0*t35*t85*t86-6.0d+0*t35*t83*t84
     2         -8.0d+0*t32*t83*t84-8.0d+0*t32*t81*t82-1.0d+1*t29*t81*t82
     3         -1.0d+1*t29*t79*t80-1.2d+1*t26*t79*t80-1.2d+1*t26*t77*t78
     4         -1.4d+1*t23*t77*t78-1.4d+1*t23*t75*t76-1.6d+1*t20*t75*t76
     5         -1.6d+1*t20*t73*t74-1.8d+1*t17*t73*t74-1.8d+1*t17*t71*t72
     6         -2.0d+1*t14*t71*t72-2.2d+1*t69*t7*t70-2.0d+1*t14*t69*t70-
     7         2.2d+1*t112*t67*t7
            t137 = 1/rhob**7
            t138 = 1/rhob**4.333333333333333d+0
            t139 = -7.46904d-3*t120*t54*t90*t97-3.73452d-3*t57*t90*t91*t
     1         96+4.0d+0*t54*t90*t91*t96-3.73452d-3*gammabb*t138*t56*t96
     2         +2.0d+0*gammabb*t138*t53*t96-7.46904d-3*t120*t137*t49*t94
     3         +2.0d+0*t57*t90*t93-7.46904d-3*gammabb*t120*t138*t53*t91
            t140 = 1/t114
            t141 = 1/t12**13
            t142 = 2.5389881826654315d+4*t13*t18*t5*t7-5.585774001863949
     1         d+4*t100*t15*t5*t7+3.046785819198518d+4*t11*t141*t5*t7+1.
     2         1141288576844789d+2*t13*t135*t15*t7-1.1141288576844789d+2
     3         *t100*t11*t135*t7-4.6163421503007845d+2*t40*t41*t5+4.6163
     4         421503007845d+2*t10*t37*t41*t5+4.6163421503007845d+2*t38*
     5         t40*t5+1.3849026450902355d+3*t34*t38*t39*t5-4.15470793527
     6         07067d+3*t34*t35*t39*t5+2.769805290180471d+3*t32*t34*t39*
     7         t5-1.846536860120314d+3*t10*t37*t38*t5+1.3849026450902355
     8         d+3*t10*t35*t37*t5+2.769805290180471d+3*t31*t35*t36*t5-7.
     9         386147440481255d+3*t31*t32*t36*t5+4.616342150300784d+3*t2
     :         9*t31*t36*t5+4.616342150300784d+3*t28*t32*t33*t5-1.154085
     ;         537575196d+4*t28*t29*t33*t5+6.924513225451178d+3*t26*t28*
     <         t33*t5+6.924513225451178d+3*t25*t29*t30*t5-1.661883174108
     =         283d+4*t25*t26*t30*t5+9.694318515631648d+3*t23*t25*t30*t5
     >         +9.694318515631648d+3*t22*t26*t27*t5-2.2620076536473846d+
     ?         4*t22*t23*t27*t5+1.2925758020842196d+4*t20*t22*t27*t5+1.2
     @         925758020842196d+4*t19*t23*t24*t5-2.954458976192502d+4*t1
     1         9*t20*t24*t5+1.6618831741082823d+4*t17*t19*t24*t5+1.66188
     2         31741082823d+4*t16*t20*t21*t5-3.7392371417436354d+4*t16*t
     3         17*t21*t5+2.0773539676353528d+4*t14*t16*t21*t5+2.07735396
     4         76353528d+4*t13*t17*t18*t5-4.616342150300784d+4*t13*t14*t
     5         18*t5+2.5389881826654315d+4*t100*t14*t15*t5+1.01284441607
     6         67991d+1*t135*t41*t42-1.0128444160767991d+1*t10*t135*t40*
     7         t41+2.0256888321535982d+1*t10*t135*t38*t40-2.025688832153
     8         5982d+1*t135*t37*t38*t39+3.038533248230397d+1*t135*t35*t3
     9         7*t39-3.038533248230397d+1*t135*t34*t35*t36+4.05137766430
     :         71964d+1*t135*t32*t34*t36-4.0513776643071964d+1*t135*t31*
     ;         t32*t33+5.064222080383994d+1*t135*t29*t31*t33-5.064222080
     <         383994d+1*t135*t28*t29*t30+6.077066496460795d+1*t135*t26*
     =         t28*t30-6.077066496460795d+1*t135*t25*t26*t27+7.089910912
     >         537593d+1*t135*t23*t25*t27-7.089910912537593d+1*t135*t22*
     ?         t23*t24+8.102755328614393d+1*t135*t20*t22*t24-8.102755328
     @         614393d+1*t135*t19*t20*t21+9.115599744691191d+1*t135*t17*
     1         t19*t21-9.115599744691191d+1*t135*t16*t17*t18+1.012844416
     2         076799d+2*t135*t14*t16*t18-1.012844416076799d+2*t13*t135*
     3         t14*t15
            t143 = 1/t99
            t144 = gammaaa**3
            t145 = 1/t2**3
            t146 = 1/rhoa**10
            t147 = 1/rhoa**7.333333333333333d+0
            t148 = 1/rhoa**4.666666666666667d+0
            t149 = -3.8948928286386303d-4*t103*t147*t50+3.53191564356981
     1         6d-2*gammaaa*t148*t3+1.0369691626335495d-6*t144*t145*t146
            t150 = t107**2
            t151 = 1/t46**4
            t152 = 1.6597866666666666d-2*t105*taua+1.8257653333333332d-2
     1         *gammaaa*t148
            t153 = taua**2
            t154 = 6.666666666666667d+0*t1*t107*t52*t57*taua+8.888888888
     1         88889d+0*t105*t47*t57*taua+1.7777777777777778d+1*t105*t45
     2         *t52*t54*taua+2.6666666666666666d+1*t1*t107*t108*t45*t54*
     3         taua+2.6666666666666666d+1*gammaaa*t104*t52*t53*taua+1.33
     4         33333333333333d+1*gammaaa*t107*t108*t51*t53*taua-t152*t45
     5         *t52*t57+2*t108*t150*t45*t57-gammaaa*t1*t152*t52*t56+5.33
     6         3333333333333d+0*gammaaa*t105*t107*t52*t56+9.777777777777
     7         779d+0*gammaaa*t148*t47*t56+2*gammaaa*t1*t108*t150*t56-2*
     8         t108*t152*t54*t55+6*t150*t151*t54*t55+2.2222222222222224d
     9         +1*t153*t51*t52*t54+9.777777777777779d+0*gammaaa*t148*t45
     :         *t52*t53-2*gammaaa*t1*t108*t152*t45*t53+6*gammaaa*t1*t150
     ;         *t151*t45*t53+1.0666666666666666d+1*gammaaa*t105*t107*t10
     <         8*t45*t53+3.377777777777778d+1*t147*t49*t50*t52-2*t108*t1
     =         52*t49*t50*t51+6*t150*t151*t49*t50*t51+2.1333333333333332
     >         d+1*t104*t107*t108*t49*t50
            t155 = 4.444444444444444d-1*t143*t58+1.0d+0*t154*t5+2.666666
     1         6666666666d+0*t102*t109
            t156 = -1.0d+0*t152*t5*t58-1.3333333333333333d+0*t102*t107*t
     1         58-1.0d+0*t107*t109*t5-t107*t110
            t157 = 1/t68**13
            t158 = 1.0128444160767991d+1*t140*t41*t88-1.0128444160767991
     1         d+1*t140*t41*t66*t87+2.0256888321535982d+1*t140*t38*t66*t
     2         87-4.6163421503007845d+2*t41*t63*t87+4.6163421503007845d+
     3         2*t38*t63*t87-2.0256888321535982d+1*t140*t38*t85*t86+3.03
     4         8533248230397d+1*t140*t35*t85*t86+1.3849026450902355d+3*t
     5         38*t63*t83*t86-4.1547079352707067d+3*t35*t63*t83*t86+2.76
     6         9805290180471d+3*t32*t63*t83*t86+4.6163421503007845d+2*t4
     7         1*t63*t66*t85-1.846536860120314d+3*t38*t63*t66*t85+1.3849
     8         026450902355d+3*t35*t63*t66*t85-3.038533248230397d+1*t140
     9         *t35*t83*t84+4.0513776643071964d+1*t140*t32*t83*t84+2.769
     :         805290180471d+3*t35*t63*t81*t84-7.386147440481255d+3*t32*
     ;         t63*t81*t84+4.616342150300784d+3*t29*t63*t81*t84-4.051377
     <         6643071964d+1*t140*t32*t81*t82+5.064222080383994d+1*t140*
     =         t29*t81*t82+4.616342150300784d+3*t32*t63*t79*t82-1.154085
     >         537575196d+4*t29*t63*t79*t82+6.924513225451178d+3*t26*t63
     ?         *t79*t82-5.064222080383994d+1*t140*t29*t79*t80+6.07706649
     @         6460795d+1*t140*t26*t79*t80+6.924513225451178d+3*t29*t63*
     1         t77*t80-1.661883174108283d+4*t26*t63*t77*t80+9.6943185156
     2         31648d+3*t23*t63*t77*t80-6.077066496460795d+1*t140*t26*t7
     3         7*t78+7.089910912537593d+1*t140*t23*t77*t78+9.69431851563
     4         1648d+3*t26*t63*t75*t78-2.2620076536473846d+4*t23*t63*t75
     5         *t78+1.2925758020842196d+4*t20*t63*t75*t78-7.089910912537
     6         593d+1*t140*t23*t75*t76+8.102755328614393d+1*t140*t20*t75
     7         *t76+1.2925758020842196d+4*t23*t63*t73*t76-2.954458976192
     8         502d+4*t20*t63*t73*t76+1.6618831741082823d+4*t17*t63*t73*
     9         t76-8.102755328614393d+1*t140*t20*t73*t74+9.1155997446911
     :         91d+1*t140*t17*t73*t74+1.6618831741082823d+4*t20*t63*t71*
     ;         t74-3.7392371417436354d+4*t17*t63*t71*t74+2.0773539676353
     <         528d+4*t14*t63*t71*t74-9.115599744691191d+1*t140*t17*t71*
     =         t72+1.012844416076799d+2*t14*t140*t71*t72+2.5389881826654
     >         315d+4*t63*t69*t7*t72+2.0773539676353528d+4*t17*t63*t69*t
     ?         72-4.616342150300784d+4*t14*t63*t69*t72+1.114128857684478
     @         9d+2*t140*t69*t7*t70-5.585774001863949d+4*t112*t63*t7*t70
     1         -1.012844416076799d+2*t14*t140*t69*t70+2.5389881826654315
     2         d+4*t112*t14*t63*t70+3.046785819198518d+4*t157*t63*t67*t7
     3         -1.1141288576844789d+2*t112*t140*t67*t7
            t159 = 1/t111
            t160 = gammabb**3
            t161 = 1/t60**3
            t162 = 1/rhob**10
            t163 = 1/rhob**7.333333333333333d+0
            t164 = 1/rhob**4.666666666666667d+0
            t165 = -3.8948928286386303d-4*t115*t163*t94+3.53191564356981
     1         6d-2*gammabb*t164*t61+1.0369691626335495d-6*t160*t161*t16
     2         2
            t166 = t119**2
            t167 = 1/t92**4
            t168 = 1.6597866666666666d-2*t117*taub+1.8257653333333332d-2
     1         *gammabb*t164
            t169 = taub**2
            t170 = 1.7777777777777778d+1*t117*t54*t91*t96*taub+6.6666666
     1         66666667d+0*t119*t57*t59*t96*taub+2.6666666666666666d+1*g
     2         ammabb*t116*t53*t96*taub+1.3333333333333333d+1*gammabb*t1
     3         19*t120*t53*t95*taub+8.88888888888889d+0*t117*t57*t93*tau
     4         b+2.6666666666666666d+1*t119*t120*t54*t59*t91*taub-2*t120
     5         *t168*t54*t97+6*t166*t167*t54*t97+2.2222222222222224d+1*t
     6         169*t54*t95*t96+3.377777777777778d+1*t163*t49*t94*t96-t16
     7         8*t57*t91*t96+9.777777777777779d+0*gammabb*t164*t53*t91*t
     8         96-gammabb*t168*t56*t59*t96+5.333333333333333d+0*gammabb*
     9         t117*t119*t56*t96-2*t120*t168*t49*t94*t95+6*t166*t167*t49
     :         *t94*t95+2.1333333333333332d+1*t116*t119*t120*t49*t94+9.7
     ;         77777777777779d+0*gammabb*t164*t56*t93-2*gammabb*t120*t16
     <         8*t53*t59*t91+6*gammabb*t166*t167*t53*t59*t91+2*t120*t166
     =         *t57*t91+1.0666666666666666d+1*gammabb*t117*t119*t120*t53
     >         *t91+2*gammabb*t120*t166*t56*t59
            t171 = 4.444444444444444d-1*t159*t98+1.0d+0*t170*t63+2.66666
     1         66666666666d+0*t114*t121
            t172 = -1.0d+0*t168*t63*t98-1.3333333333333333d+0*t114*t119*
     1         t98-1.0d+0*t119*t121*t63-t119*t122
            t173 = 1/rhoa**9
            t174 = -3.8886343598758105d-7*t145*t173*t50-9.63249720973586
     1         3d-3*t105*t3+1.29829760954621d-4*gammaaa*t103*t104
            t175 = 1/rhoa**2.3333333333333334d+0
            t176 = 6.2242d-3*t51*t52*t57*taua+2.48968d-2*t108*t45*t51*t5
     1         4*taua-3.3333333333333337d+0*t51*t52*t53*taua+1.24484d-2*
     2         gammaaa*t108*t124*t53*taua+4.9793599999999993d-3*t105*t45
     3         *t52*t57+3.73452d-3*t1*t107*t108*t45*t57-t1*t107*t52*t56+
     4         9.958719999999999d-3*gammaaa*t104*t52*t56+3.73452d-3*gamm
     5         aaa*t107*t108*t51*t56-2.6666666666666666d+0*t105*t47*t56+
     6         1.120356d-2*t1*t107*t151*t54*t55+9.958719999999999d-3*t10
     7         5*t108*t54*t55-2.6666666666666666d+0*t105*t45*t52*t53+1.1
     8         20356d-2*gammaaa*t107*t151*t45*t51*t53-2*t1*t107*t108*t45
     9         *t53+1.9917439999999997d-2*gammaaa*t104*t108*t45*t53-1.06
     :         66666666666666d+1*gammaaa*t104*t49*t52-4*gammaaa*t107*t10
     ;         8*t49*t51+2.9876159999999996d-2*t108*t173*t49*t50+1.12035
     <         6d-2*t107*t124*t151*t49*t50
            t177 = 1.0d+0*t176*t5+1.3333333333333333d+0*t102*t125
            t178 = 1/rhob**9
            t179 = -3.8886343598758105d-7*t161*t178*t94-9.63249720973586
     1         3d-3*t117*t61+1.29829760954621d-4*gammabb*t115*t116
            t180 = 1/rhob**2.3333333333333334d+0
            t181 = 6.2242d-3*t57*t95*t96*taub-3.3333333333333337d+0*t53*
     1         t95*t96*taub+2.48968d-2*t120*t54*t91*t95*taub+1.24484d-2*
     2         gammabb*t120*t128*t53*taub+1.120356d-2*t119*t167*t54*t59*
     3         t97+9.958719999999999d-3*t117*t120*t54*t97+4.979359999999
     4         9993d-3*t117*t57*t91*t96-2.6666666666666666d+0*t117*t53*t
     5         91*t96-t119*t56*t59*t96+9.958719999999999d-3*gammabb*t116
     6         *t56*t96-1.0666666666666666d+1*gammabb*t116*t49*t96+1.120
     7         356d-2*gammabb*t119*t167*t53*t91*t95+3.73452d-3*gammabb*t
     8         119*t120*t56*t95-4*gammabb*t119*t120*t49*t95+2.9876159999
     9         999996d-2*t120*t178*t49*t94+1.120356d-2*t119*t128*t167*t4
     :         9*t94-2.6666666666666666d+0*t117*t56*t93+3.73452d-3*t119*
     ;         t120*t57*t59*t91-2*t119*t120*t53*t59*t91+1.99174399999999
     <         97d-2*gammabb*t116*t120*t53*t91
            t182 = 1.0d+0*t181*t63+1.3333333333333333d+0*t114*t129
            t183 = 1.4582378849534292d-7*gammaaa*t124*t145-3.24574402386
     1         55255d-5*t103*t51
            t184 = 1/rhoa**1.0666666666666666d+1
            t185 = 6.973319815199999d-6*t108*t45*t51*t57-3.73452d-3*t51*
     1         t52*t56+6.973319815199999d-6*gammaaa*t108*t124*t56+2.0919
     2         959445599998d-5*t151*t51*t54*t55-7.46904d-3*t108*t45*t51*
     3         t53+2.0919959445599998d-5*gammaaa*t124*t151*t45*t53+2*t49
     4         *t51*t52+2.0919959445599998d-5*t151*t184*t49*t50-1.493807
     5         9999999998d-2*gammaaa*t108*t124*t49
            t186 = 1/rhoa**4
            t187 = 1.4582378849534292d-7*gammabb*t128*t161-3.24574402386
     1         55255d-5*t115*t95
            t188 = 1/rhob**1.0666666666666666d+1
            t189 = 2.0919959445599998d-5*t167*t54*t95*t97-3.73452d-3*t56
     1         *t95*t96+2*t49*t95*t96+6.973319815199999d-6*t120*t57*t91*
     2         t95-7.46904d-3*t120*t53*t91*t95+2.0919959445599998d-5*t16
     3         7*t188*t49*t94+2.0919959445599998d-5*gammabb*t128*t167*t5
     4         3*t91+6.973319815199999d-6*gammabb*t120*t128*t56-1.493807
     5         9999999998d-2*gammabb*t120*t128*t49
            t190 = 1/rhob**4
            t191 = -3.342386573053437d+3*t13*t18*t7*t99+4.01086388766412
     1         45d+3*t11*t141*t7*t99+6.077066496460795d+1*t10*t37*t41*t9
     2         9-6.077066496460795d+1*t38*t40*t99+1.8231199489382385d+2*
     3         t34*t38*t39*t99-3.646239897876477d+2*t32*t34*t39*t99-1.82
     4         31199489382385d+2*t10*t35*t37*t99+3.646239897876477d+2*t3
     5         1*t35*t36*t99-6.077066496460795d+2*t29*t31*t36*t99+6.0770
     6         66496460795d+2*t28*t32*t33*t99-9.115599744691192d+2*t26*t
     7         28*t33*t99+9.115599744691192d+2*t25*t29*t30*t99-1.2761839
     8         64256767d+3*t23*t25*t30*t99+1.276183964256767d+3*t22*t26*
     9         t27*t99-1.7015786190090226d+3*t20*t22*t27*t99+1.701578619
     :         0090226d+3*t19*t23*t24*t99-2.187743938725886d+3*t17*t19*t
     ;         24*t99+2.187743938725886d+3*t16*t20*t21*t99-2.73467992340
     <         7357d+3*t14*t16*t21*t99+2.734679923407357d+3*t13*t17*t18*
     =         t99+3.342386573053437d+3*t100*t14*t15*t99
            t192 = 1.24484d-2*t133*t52*t57*taua-1.3333333333333333d+1*t1
     1         33*t52*t54*taua+4.97936d-2*t108*t133*t45*t54*taua+2.48968
     2         d-2*gammaaa*t108*t132*t53*taua+6.2242d-3*t1*t45*t52*t57-2
     3         .0d+0*t107*t44*t52*t57-3.3333333333333337d+0*t1*t47*t57+7
     4         .46904d-3*t107*t108*t44*t45*t57+1.618292d-2*gammaaa*t51*t
     5         52*t56+7.46904d-3*gammaaa*t107*t108*t133*t56+2.240712d-2*
     6         t107*t151*t44*t54*t55+1.24484d-2*t1*t108*t54*t55-6.666666
     7         666666667d+0*t1*t45*t52*t54-8.0d+0*t107*t108*t44*t45*t54-
     8         8.666666666666666d+0*gammaaa*t51*t52*t53+3.236584d-2*gamm
     9         aaa*t108*t45*t51*t53+2.240712d-2*gammaaa*t107*t133*t151*t
     :         45*t53-4.0d+0*gammaaa*t107*t108*t133*t53+2.240712d-2*t107
     ;         *t132*t151*t49*t50+5.228328d-2*t108*t124*t49*t50
            t193 = 1.0d+0*t192*t5+1.3333333333333333d+0*t102*t134
            t194 = -6.077066496460795d+1*t111*t38*t87+1.8231199489382385
     1         d+2*t111*t38*t83*t86-3.646239897876477d+2*t111*t32*t83*t8
     2         6+6.077066496460795d+1*t111*t41*t66*t85-1.823119948938238
     3         5d+2*t111*t35*t66*t85+3.646239897876477d+2*t111*t35*t81*t
     4         84-6.077066496460795d+2*t111*t29*t81*t84+6.07706649646079
     5         5d+2*t111*t32*t79*t82-9.115599744691192d+2*t111*t26*t79*t
     6         82+9.115599744691192d+2*t111*t29*t77*t80-1.27618396425676
     7         7d+3*t111*t23*t77*t80+1.276183964256767d+3*t111*t26*t75*t
     8         78-1.7015786190090226d+3*t111*t20*t75*t78+1.7015786190090
     9         226d+3*t111*t23*t73*t76-2.187743938725886d+3*t111*t17*t73
     :         *t76+2.187743938725886d+3*t111*t20*t71*t74-2.734679923407
     ;         357d+3*t111*t14*t71*t74-3.342386573053437d+3*t111*t69*t7*
     <         t72+2.734679923407357d+3*t111*t17*t69*t72+3.3423865730534
     =         37d+3*t111*t112*t14*t70+4.0108638876641245d+3*t111*t157*t
     >         67*t7
            t195 = 1.24484d-2*t138*t57*t96*taub-1.3333333333333333d+1*t1
     1         38*t54*t96*taub+4.97936d-2*t120*t138*t54*t91*taub+2.48968
     2         d-2*gammabb*t120*t137*t53*taub+2.240712d-2*t119*t167*t54*
     3         t90*t97+1.24484d-2*t120*t54*t59*t97+1.618292d-2*gammabb*t
     4         56*t95*t96-8.666666666666666d+0*gammabb*t53*t95*t96+6.224
     5         2d-3*t57*t59*t91*t96-6.666666666666667d+0*t54*t59*t91*t96
     6         -2.0d+0*t119*t57*t90*t96+3.236584d-2*gammabb*t120*t53*t91
     7         *t95+2.240712d-2*t119*t137*t167*t49*t94+5.228328d-2*t120*
     8         t128*t49*t94-3.3333333333333337d+0*t57*t59*t93+7.46904d-3
     9         *t119*t120*t57*t90*t91-8.0d+0*t119*t120*t54*t90*t91+2.240
     :         712d-2*gammabb*t119*t138*t167*t53*t91+7.46904d-3*gammabb*
     ;         t119*t120*t138*t56-4.0d+0*gammabb*t119*t120*t138*t53
            t196 = 1.0d+0*t195*t63+1.3333333333333333d+0*t114*t139
            t197 = 1/rhoa**9.666666666666666d+0
            t198 = -3.73452d-3*t133*t52*t57+1.3946639630399998d-5*t108*t
     1         133*t45*t57-3.73452d-3*t133*t52*t56+1.3946639630399998d-5
     2         *gammaaa*t108*t132*t56+4.1839918891199995d-5*t133*t151*t5
     3         4*t55-1.4938079999999998d-2*t108*t133*t45*t54+2.0d+0*t133
     4         *t52*t53+4.1839918891199995d-5*gammaaa*t132*t151*t45*t53-
     5         7.46904d-3*t108*t133*t45*t53-7.46904d-3*gammaaa*t108*t132
     6         *t53+4.1839918891199995d-5*t151*t197*t49*t50-1.4938079999
     7         999998d-2*gammaaa*t108*t132*t49
            t199 = 1/rhoa**3
            t200 = 1/rhob**9.666666666666666d+0
            t201 = 4.1839918891199995d-5*t138*t167*t54*t97-3.73452d-3*t1
     1         38*t57*t96-3.73452d-3*t138*t56*t96+2.0d+0*t138*t53*t96+4.
     2         1839918891199995d-5*t167*t200*t49*t94+1.3946639630399998d
     3         -5*t120*t138*t57*t91-1.4938079999999998d-2*t120*t138*t54*
     4         t91+4.1839918891199995d-5*gammabb*t137*t167*t53*t91-7.469
     5         04d-3*t120*t138*t53*t91+1.3946639630399998d-5*gammabb*t12
     6         0*t137*t56-7.46904d-3*gammabb*t120*t137*t53-1.49380799999
     7         99998d-2*gammabb*t120*t137*t49
            t202 = 1/rhob**3
            t203 = 4.4d+2*t13*t18*t7+9.68d+2*t100*t15*t7+5.28d+2*t11*t14
     1         1*t7+8.0d+0*t40*t41+8.0d+0*t10*t37*t41+8.0d+0*t38*t40+2.4
     2         d+1*t34*t38*t39+7.2d+1*t34*t35*t39+4.8d+1*t32*t34*t39+3.2
     3         d+1*t10*t37*t38+2.4d+1*t10*t35*t37+4.8d+1*t31*t35*t36+1.2
     4         8d+2*t31*t32*t36+8.0d+1*t29*t31*t36+8.0d+1*t28*t32*t33+2.
     5         0d+2*t28*t29*t33+1.2d+2*t26*t28*t33+1.2d+2*t25*t29*t30+2.
     6         88d+2*t25*t26*t30+1.68d+2*t23*t25*t30+1.68d+2*t22*t26*t27
     7         +3.92d+2*t22*t23*t27+2.24d+2*t20*t22*t27+2.24d+2*t19*t23*
     8         t24+5.12d+2*t19*t20*t24+2.88d+2*t17*t19*t24+2.88d+2*t16*t
     9         20*t21+6.48d+2*t16*t17*t21+3.6d+2*t14*t16*t21+3.6d+2*t13*
     :         t17*t18+8.0d+2*t13*t14*t18+4.4d+2*t100*t14*t15
            t204 = 1/rhoa**8.666666666666666d+0
            t205 = 1/rhoa**6
            t206 = 1/rhoa**3.3333333333333337d+0
            t207 = -1.4938079999999998d-2*t206*t52*t57+2.789327926079999
     1         7d-5*t108*t206*t45*t57+2.7893279260799997d-5*gammaaa*t108
     2         *t205*t56+8.367983778239999d-5*t151*t206*t54*t55+8.0d+0*t
     3         206*t52*t54-5.975231999999999d-2*t108*t206*t45*t54+8.3679
     4         83778239999d-5*gammaaa*t151*t205*t45*t53-2.98761599999999
     5         96d-2*gammaaa*t108*t205*t53+8.367983778239999d-5*t151*t20
     6         4*t49*t50
            t208 = rhoa**2
            t209 = 1/t208
            t210 = 8.0d+0*t41*t87+8.0d+0*t38*t87+2.4d+1*t38*t83*t86+7.2d
     1         +1*t35*t83*t86+4.8d+1*t32*t83*t86+8.0d+0*t41*t66*t85+3.2d
     2         +1*t38*t66*t85+2.4d+1*t35*t66*t85+4.8d+1*t35*t81*t84+1.28
     3         d+2*t32*t81*t84+8.0d+1*t29*t81*t84+8.0d+1*t32*t79*t82+2.0
     4         d+2*t29*t79*t82+1.2d+2*t26*t79*t82+1.2d+2*t29*t77*t80+2.8
     5         8d+2*t26*t77*t80+1.68d+2*t23*t77*t80+1.68d+2*t26*t75*t78+
     6         3.92d+2*t23*t75*t78+2.24d+2*t20*t75*t78+2.24d+2*t23*t73*t
     7         76+5.12d+2*t20*t73*t76+2.88d+2*t17*t73*t76+2.88d+2*t20*t7
     8         1*t74+6.48d+2*t17*t71*t74+3.6d+2*t14*t71*t74+4.4d+2*t69*t
     9         7*t72+3.6d+2*t17*t69*t72+8.0d+2*t14*t69*t72+9.68d+2*t112*
     :         t7*t70+4.4d+2*t112*t14*t70+5.28d+2*t157*t67*t7
            t211 = 1/rhob**8.666666666666666d+0
            t212 = 1/rhob**6
            t213 = 1/rhob**3.3333333333333337d+0
            t214 = 8.367983778239999d-5*t167*t213*t54*t97-1.493807999999
     1         9998d-2*t213*t57*t96+8.0d+0*t213*t54*t96+8.36798377823999
     2         9d-5*t167*t211*t49*t94+2.7893279260799997d-5*t120*t213*t5
     3         7*t91-5.975231999999999d-2*t120*t213*t54*t91+8.3679837782
     4         39999d-5*gammabb*t167*t212*t53*t91+2.7893279260799997d-5*
     5         gammabb*t120*t212*t56-2.9876159999999996d-2*gammabb*t120*
     6         t212*t53
            t215 = rhob**2
            t216 = 1/t215
            t217 = 1/t12**14
            t218 = 1/t2**4
            t219 = 1/rhoa**8.333333333333334d+0
            t220 = 1/rhoa**5.666666666666667d+0
            t221 = t107**3
            t222 = 1/t46**5
            t223 = -6.085884444444444d-2*t148*taua-8.520238222222222d-2*
     1         gammaaa*t220
            t224 = 1/t68**14
            t225 = 1/t60**4
            t226 = 1/rhob**8.333333333333334d+0
            t227 = 1/rhob**5.666666666666667d+0
            t228 = t119**3
            t229 = 1/t92**5
            t230 = -6.085884444444444d-2*t164*taub-8.520238222222222d-2*
     1         gammabb*t227
            t231 = 1/rhoa**1.1666666666666665d+1
            t232 = 1/rhoa**5
            t233 = 1/rhob**1.1666666666666665d+1
            t234 = 1/rhob**5
            t235 = 1/rhoa**7.666666666666667d+0
            t236 = 1/rhob**7.666666666666667d+0
            fnc(iq) = (1.0d+0*t63*t93*t98-9.305257363490997d-1*t62*t63*t
     1         89+1.0d+0*t47*t5*t58-9.305257363490997d-1*t4*t43*t5)*wght
     2         +fnc(iq)
            Amat(iq,D1_RA) = (-1.0d+0*t107*t5*t52*t58-9.305257363490997d
     1         -1*t106*t43*t5-9.305257363490997d-1*t101*t4*t5+t110*t47-1
     2         .2407009817987995d+0*t102*t4*t43)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (-1.0d+0*t119*t63*t96*t98+t122*t93-9.305257
     1         363490997d-1*t118*t63*t89-1.2407009817987995d+0*t114*t62*
     2         t89-9.305257363490997d-1*t113*t62*t63)*wght+Amat(iq,D1_RB
     3         )
            Cmat(iq,D1_GAA) = (-1.86726d-3*t126*t52*t58+1.0d+0*t125*t47*
     1         t5-9.305257363490997d-1*t123*t43*t5)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (-1.86726d-3*t130*t96*t98+1.0d+0*t129*t63*
     1         t93-9.305257363490997d-1*t127*t63*t89)*wght+Cmat(iq,D1_GB
     2         B)
            Mmat(iq,D1_TA) = (-3.73452d-3*t135*t52*t58+1.0d+0*t134*t47*t
     1         5-9.305257363490997d-1*t131*t4*t5)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = (-3.73452d-3*t140*t96*t98+1.0d+0*t139*t63*t
     1         93-9.305257363490997d-1*t136*t62*t63)*wght+Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = (2.0d+0*t108*t150*t5*t58+t156*t52-9.305
     1         257363490997d-1*t149*t43*t5-9.305257363490997d-1*t142*t4*
     2         t5-1.8610514726981994d+0*t101*t106*t5+t155*t47-4.13566993
     3         93293317d-1*t143*t4*t43-2.481401963597599d+0*t102*t106*t4
     4         3-2.481401963597599d+0*t101*t102*t4)*wght+Amat2(iq,D2_RA_
     5         RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (2.0d+0*t120*t166*t63*t98+t172*t96+t171
     1         *t93-9.305257363490997d-1*t165*t63*t89-4.1356699393293317
     2         d-1*t159*t62*t89-2.481401963597599d+0*t114*t118*t89-9.305
     3         257363490997d-1*t158*t62*t63-1.8610514726981994d+0*t113*t
     4         118*t63-2.481401963597599d+0*t113*t114*t62)*wght+Amat2(iq
     5         ,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = (4.9793599999999993d-3*t175*t52*t58+3.
     1         73452d-3*t107*t108*t126*t58-1.0d+0*t107*t125*t5*t52-1.867
     2         26d-3*t1*t110*t52-9.305257363490997d-1*t174*t43*t5-9.3052
     3         57363490997d-1*t101*t123*t5+t177*t47-1.2407009817987995d+
     4         0*t102*t123*t43)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = (4.9793599999999993d-3*t180*t96*t98+3.
     1         73452d-3*t119*t120*t130*t98-1.0d+0*t119*t129*t63*t96-1.86
     2         726d-3*t122*t59*t96+t182*t93-9.305257363490997d-1*t179*t6
     3         3*t89-1.2407009817987995d+0*t114*t127*t89-9.3052573634909
     4         97d-1*t113*t127*t63)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = (6.973319815199999d-6*t108*t186*t58-3
     1         .73452d-3*t125*t126*t52+1.0d+0*t185*t47*t5-9.305257363490
     2         997d-1*t183*t43*t5)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = (6.973319815199999d-6*t120*t190*t98-3
     1         .73452d-3*t129*t130*t96+1.0d+0*t189*t63*t93-9.30525736349
     2         0997d-1*t187*t63*t89)*wght+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RA_TA) = (6.2242d-3*t126*t52*t58+7.46904d-3*t107
     1         *t108*t135*t58-1.0d+0*t107*t134*t5*t52-3.73452d-3*t110*t4
     2         4*t52-9.305257363490997d-1*t191*t4*t5-9.305257363490997d-
     3         1*t106*t131*t5+t193*t47-1.2407009817987995d+0*t102*t131*t
     4         4)*wght+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = (6.2242d-3*t130*t96*t98+7.46904d-3*t119
     1         *t120*t140*t98-3.73452d-3*t122*t90*t96-1.0d+0*t119*t139*t
     2         63*t96+t196*t93-9.305257363490997d-1*t194*t62*t63-9.30525
     3         7363490997d-1*t118*t136*t63-1.2407009817987995d+0*t114*t1
     4         36*t62)*wght+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GAA_TA) = (1.3946639630399998d-5*t108*t199*t58-3
     1         .73452d-3*t125*t135*t52-1.86726d-3*t126*t134*t52+1.0d+0*t
     2         198*t47*t5-9.305257363490997d-1*t123*t131*t5)*wght+Mmat2(
     3         iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = (1.3946639630399998d-5*t120*t202*t98-3
     1         .73452d-3*t129*t140*t96-1.86726d-3*t130*t139*t96+1.0d+0*t
     2         201*t63*t93-9.305257363490997d-1*t127*t136*t63)*wght+Mmat
     3         2(iq,D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = (2.7893279260799997d-5*t108*t209*t58-7.
     1         46904d-3*t134*t135*t52+1.0d+0*t207*t47*t5-9.3052573634909
     2         97d-1*t203*t4*t5)*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = (2.7893279260799997d-5*t120*t216*t98-7.
     1         46904d-3*t139*t140*t96+1.0d+0*t214*t63*t93-9.305257363490
     2         997d-1*t210*t62*t63)*wght+Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RA_RA_RA) = (t47*(1.0d+0*t5*(1.0d+1*t1*t152*t52*
     1         t57*taua-2.6666666666666666d+1*t105*t107*t52*t57*taua-3.2
     2         592592592592595d+1*t148*t47*t57*taua-2.0d+1*t1*t108*t150*
     3         t57*taua-6.518518518518519d+1*t148*t45*t52*t54*taua+4.0d+
     4         1*t1*t108*t152*t45*t54*taua-1.2d+2*t1*t150*t151*t45*t54*t
     5         aua-1.0666666666666667d+2*t105*t107*t108*t45*t54*taua-2.0
     6         148148148148146d+2*gammaaa*t147*t52*t53*taua+2.0d+1*gamma
     7         aa*t108*t152*t51*t53*taua-6.0d+1*gammaaa*t150*t151*t51*t5
     8         3*taua-1.6d+2*gammaaa*t104*t107*t108*t53*taua-t223*t45*t5
     9         2*t57-6*t151*t221*t45*t57+6*t107*t108*t152*t45*t57-gammaa
     :         a*t1*t223*t52*t56+8*gammaaa*t105*t152*t52*t56-2.933333333
     ;         3333333d+1*gammaaa*t107*t148*t52*t56-4.5629629629629626d+
     <         1*gammaaa*t220*t47*t56-6*gammaaa*t1*t151*t221*t56+6*gamma
     =         aa*t1*t107*t108*t152*t56-16*gammaaa*t105*t108*t150*t56-2*
     >         t108*t223*t54*t55-24*t221*t222*t54*t55+18*t107*t151*t152*
     ?         t54*t55-1.777777777777778d+2*t104*t153*t52*t54-1.33333333
     @         33333333d+2*t107*t108*t153*t51*t54-4.5629629629629626d+1*
     1         gammaaa*t220*t45*t52*t53-2*gammaaa*t1*t108*t223*t45*t53-2
     2         4*gammaaa*t1*t221*t222*t45*t53+18*gammaaa*t1*t107*t151*t1
     3         52*t45*t53+16*gammaaa*t105*t108*t152*t45*t53-48*gammaaa*t
     4         105*t150*t151*t45*t53-5.866666666666667d+1*gammaaa*t107*t
     5         108*t148*t45*t53-2.477037037037037d+2*t219*t49*t50*t52-2*
     6         t108*t223*t49*t50*t51-24*t221*t222*t49*t50*t51+18*t107*t1
     7         51*t152*t49*t50*t51+32*t104*t108*t152*t49*t50-96*t104*t15
     8         0*t151*t49*t50-2.0266666666666666d+2*t107*t108*t147*t49*t
     9         50)-2.962962962962963d-1*t44*t58+4.0d+0*t102*t154+1.33333
     :         33333333333d+0*t109*t143)-9.305257363490997d-1*t4*t5*(-6.
     ;         01754400771653d+6*t11*t208*t217*t7+3.4716600044518436d+6*
     <         t13*t208*t21*t7-1.2729420016323426d+7*t100*t18*t208*t7+1.
     =         5275304019588112d+7*t141*t15*t208*t7+5.077976365330863d+4
     >         *t102*t13*t18*t7-3.713762858948263d+1*t126*t13*t15*t7-1.1
     ?         171548003727898d+5*t100*t102*t15*t7+6.093571638397036d+4*
     @         t102*t11*t141*t7+3.713762858948263d+1*t100*t11*t126*t7-3.
     1         37614805358933d+0*t126*t41*t42+3.37614805358933d+0*t10*t1
     2         26*t40*t41-9.232684300601568d+2*t102*t40*t41+2.1040363663
     3         34451d+4*t208*t37*t41+9.232684300601568d+2*t10*t102*t37*t
     4         41-2.104036366334451d+4*t10*t208*t34*t41-6.75229610717866
     5         d+0*t10*t126*t38*t40+9.232684300601568d+2*t102*t38*t40+6.
     6         75229610717866d+0*t126*t37*t38*t39+2.769805290180471d+3*t
     7         102*t34*t38*t39-8.416145465337804d+4*t208*t31*t38*t39-1.0
     8         128444160767991d+1*t126*t35*t37*t39-8.309415870541413d+3*
     9         t102*t34*t35*t39+3.787265459402013d+5*t208*t31*t35*t39+5.
     :         539610580360942d+3*t102*t32*t34*t39-5.049687279202681d+5*
     ;         t208*t31*t32*t39+2.1040363663344508d+5*t208*t29*t31*t39-4
     <         .208072732668902d+4*t208*t37*t38-3.693073720240627d+3*t10
     =         *t102*t37*t38+1.2624218198006704d+5*t10*t208*t34*t38+2.10
     >         4036366334451d+4*t208*t35*t37+2.769805290180471d+3*t10*t1
     ?         02*t35*t37+1.0128444160767991d+1*t126*t34*t35*t36+5.53961
     @         0580360942d+3*t102*t31*t35*t36-2.104036366334451d+5*t208*
     1         t28*t35*t36-1.350459221435732d+1*t126*t32*t34*t36-1.47722
     2         94880962508d+4*t102*t31*t32*t36+8.416145465337803d+5*t208
     3         *t28*t32*t36+9.232684300601568d+3*t102*t29*t31*t36-1.0520
     4         181831672254d+6*t208*t28*t29*t36+4.208072732668902d+5*t20
     5         8*t26*t28*t36-1.8936327297010064d+5*t10*t208*t34*t35+8.41
     6         6145465337804d+4*t10*t208*t32*t34+1.350459221435732d+1*t1
     7         26*t31*t32*t33+9.232684300601568d+3*t102*t28*t32*t33-4.20
     8         80727326689016d+5*t208*t25*t32*t33-1.6880740267946648d+1*
     9         t126*t29*t31*t33-2.308171075150392d+4*t102*t28*t29*t33+1.
     :         578027274750838d+6*t208*t25*t29*t33+1.3849026450902355d+4
     ;         *t102*t26*t28*t33-1.893632729701006d+6*t208*t25*t26*t33+7
     <         .364127282170578d+5*t208*t23*t25*t33+1.6880740267946648d+
     =         1*t126*t28*t29*t30+1.3849026450902355d+4*t102*t25*t29*t30
     >         -7.364127282170578d+5*t208*t22*t29*t30-2.0256888321535982
     ?         d+1*t126*t26*t28*t30-3.323766348216566d+4*t102*t25*t26*t3
     @         0+2.6510858215814087d+6*t208*t22*t26*t30+1.93886370312632
     1         92d+4*t102*t23*t25*t30-3.0929334585116436d+6*t208*t22*t23
     2         *t30+1.1782603651472927d+6*t20*t208*t22*t30+2.02568883215
     3         35982d+1*t126*t25*t26*t27+1.9388637031263292d+4*t102*t22*
     4         t26*t27-1.1782603651472927d+6*t19*t208*t26*t27-2.36330363
     5         75125308d+1*t126*t23*t25*t27-4.5240153072947686d+4*t102*t
     6         22*t23*t27+4.123911278015524d+6*t19*t208*t23*t27+2.585151
     7         604168439d+4*t102*t20*t22*t27-4.713041460589171d+6*t19*t2
     8         0*t208*t27+1.767390547720939d+6*t17*t19*t208*t27+2.363303
     9         6375125308d+1*t126*t22*t23*t24-1.7673905477209387d+6*t16*
     :         t208*t23*t24+2.585151604168439d+4*t102*t19*t23*t24-2.7009
     ;         18442871464d+1*t126*t20*t22*t24+6.059624735043219d+6*t16*
     <         t20*t208*t24-6.817077826923622d+6*t16*t17*t208*t24+2.5248
     =         43639601341d+6*t14*t16*t208*t24-5.908917952385003d+4*t102
     >         *t19*t20*t24+3.3237663482165647d+4*t102*t17*t19*t24-2.524
     ?         843639601341d+6*t13*t20*t208*t21+8.521347283654526d+6*t13
     @         *t17*t208*t21-9.468163648505028d+6*t13*t14*t208*t21+2.700
     1         918442871464d+1*t126*t19*t20*t21+3.3237663482165647d+4*t1
     2         02*t16*t20*t21-3.0385332482303967d+1*t126*t17*t19*t21-7.4
     3         78474283487271d+4*t102*t16*t17*t21+4.154707935270705d+4*t
     4         102*t14*t16*t21-3.4716600044518436d+6*t100*t17*t18*t208+1
     5         .1572200014839477d+7*t100*t14*t18*t208-4.628880005935792d
     6         +6*t14*t141*t15*t208+3.0385332482303967d+1*t126*t16*t17*t
     7         18+4.1547079352707056d+4*t102*t13*t17*t18-3.3761480535893
     8         296d+1*t126*t14*t16*t18-9.232684300601568d+4*t102*t13*t14
     9         *t18+3.3761480535893296d+1*t126*t13*t14*t15+5.07797636533
     :         0862d+4*t100*t102*t14*t15)+t52*(-1.0d+0*t223*t5*t58-2.666
     ;         6666666666666d+0*t102*t152*t58-4.444444444444444d-1*t107*
     <         t143*t58-1.0d+0*t107*t154*t5-2.0d+0*t109*t152*t5-2*t107*t
     =         155-t110*t152-2.6666666666666666d+0*t102*t107*t109)+t108*
     >         (4.0d+0*t107*t152*t5*t58+2.6666666666666666d+0*t102*t150*
     ?         t58+2.0d+0*t109*t150*t5-2*t107*t156)-6.0d+0*t151*t221*t5*
     @         t58-9.305257363490997d-1*t43*t5*(3.279403591520427d-3*t10
     1         3*t219*t50-1.648227300332581d-1*gammaaa*t220*t3+3.7270905
     2         095708196d-8*gammaaa**4*t218/rhoa**1.3666666666666666d+1-
     3         1.9702414090037443d-5*t144*t145/rhoa**11)-2.7915772090472
     4         99d+0*t101*t149*t5-2.791577209047299d+0*t106*t142*t5+2.75
     5         7113292886221d-1*t4*t43*t44+t143*(-1.2407009817987995d+0*
     6         t106*t43-1.2407009817987995d+0*t101*t4)-3.722102945396398
     7         3d+0*t102*t149*t43-3.7221029453963983d+0*t102*t142*t4-7.4
     8         44205890792797d+0*t101*t102*t106)*wght+Amat3(iq,D3_RA_RA_
     9         RA)
            Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = (t93*(1.0d+0*t63*(-6.518518518518519
     1         d+1*t164*t54*t91*t96*taub+1.0d+1*t168*t57*t59*t96*taub-2.
     2         6666666666666666d+1*t117*t119*t57*t96*taub-2.014814814814
     3         8146d+2*gammabb*t163*t53*t96*taub+2.0d+1*gammabb*t120*t16
     4         8*t53*t95*taub-6.0d+1*gammabb*t166*t167*t53*t95*taub-3.25
     5         92592592592595d+1*t164*t57*t93*taub+4.0d+1*t120*t168*t54*
     6         t59*t91*taub-1.2d+2*t166*t167*t54*t59*t91*taub-1.06666666
     7         66666667d+2*t117*t119*t120*t54*t91*taub-2.0d+1*t120*t166*
     8         t57*t59*taub-1.6d+2*gammabb*t116*t119*t120*t53*taub-2*t12
     9         0*t230*t54*t97-24*t228*t229*t54*t97+18*t119*t167*t168*t54
     :         *t97-2.477037037037037d+2*t226*t49*t94*t96-t230*t57*t91*t
     ;         96-4.5629629629629626d+1*gammabb*t227*t53*t91*t96-gammabb
     <         *t230*t56*t59*t96+8*gammabb*t117*t168*t56*t96-2.933333333
     =         3333333d+1*gammabb*t119*t164*t56*t96-1.777777777777778d+2
     >         *t116*t169*t54*t96-2*t120*t230*t49*t94*t95-24*t228*t229*t
     ?         49*t94*t95+18*t119*t167*t168*t49*t94*t95-1.33333333333333
     @         33d+2*t119*t120*t169*t54*t95+32*t116*t120*t168*t49*t94-96
     1         *t116*t166*t167*t49*t94-2.0266666666666666d+2*t119*t120*t
     2         163*t49*t94-4.5629629629629626d+1*gammabb*t227*t56*t93-2*
     3         gammabb*t120*t230*t53*t59*t91-24*gammabb*t228*t229*t53*t5
     4         9*t91+18*gammabb*t119*t167*t168*t53*t59*t91-6*t167*t228*t
     5         57*t91+6*t119*t120*t168*t57*t91+16*gammabb*t117*t120*t168
     6         *t53*t91-48*gammabb*t117*t166*t167*t53*t91-5.866666666666
     7         667d+1*gammabb*t119*t120*t164*t53*t91-6*gammabb*t167*t228
     8         *t56*t59+6*gammabb*t119*t120*t168*t56*t59-16*gammabb*t117
     9         *t120*t166*t56)-2.962962962962963d-1*t90*t98+4.0d+0*t114*
     :         t170+1.3333333333333333d+0*t121*t159)+t96*(-1.0d+0*t230*t
     ;         63*t98-2.6666666666666666d+0*t114*t168*t98-4.444444444444
     <         444d-1*t119*t159*t98-1.0d+0*t119*t170*t63-2.0d+0*t121*t16
     =         8*t63-2*t119*t171-t122*t168-2.6666666666666666d+0*t114*t1
     >         19*t121)+t120*(4.0d+0*t119*t168*t63*t98+2.666666666666666
     ?         6d+0*t114*t166*t98+2.0d+0*t121*t166*t63-2*t119*t172)-6.0d
     @         +0*t167*t228*t63*t98-9.305257363490997d-1*t63*t89*(3.2794
     1         03591520427d-3*t115*t226*t94-1.648227300332581d-1*gammabb
     2         *t227*t61+3.7270905095708196d-8*gammabb**4*t225/rhob**1.3
     3         666666666666666d+1-1.9702414090037443d-5*t160*t161/rhob**
     4         11)+2.757113292886221d-1*t62*t89*t90+t159*(-1.24070098179
     5         87995d+0*t118*t89-1.2407009817987995d+0*t113*t62)-3.72210
     6         29453963983d+0*t114*t165*t89-9.305257363490997d-1*t62*t63
     7         *(-3.37614805358933d+0*t130*t41*t88+3.37614805358933d+0*t
     8         130*t41*t66*t87-6.75229610717866d+0*t130*t38*t66*t87-9.23
     9         2684300601568d+2*t114*t41*t87+9.232684300601568d+2*t114*t
     :         38*t87+6.75229610717866d+0*t130*t38*t85*t86-1.01284441607
     ;         67991d+1*t130*t35*t85*t86+2.769805290180471d+3*t114*t38*t
     <         83*t86-8.309415870541413d+3*t114*t35*t83*t86+5.5396105803
     =         60942d+3*t114*t32*t83*t86-8.416145465337804d+4*t215*t38*t
     >         81*t86+3.787265459402013d+5*t215*t35*t81*t86-5.0496872792
     ?         02681d+5*t215*t32*t81*t86+2.1040363663344508d+5*t215*t29*
     @         t81*t86+9.232684300601568d+2*t114*t41*t66*t85-3.693073720
     1         240627d+3*t114*t38*t66*t85+2.769805290180471d+3*t114*t35*
     2         t66*t85+2.104036366334451d+4*t215*t41*t85-4.2080727326689
     3         02d+4*t215*t38*t85+2.104036366334451d+4*t215*t35*t85+1.01
     4         28444160767991d+1*t130*t35*t83*t84-1.350459221435732d+1*t
     5         130*t32*t83*t84+5.539610580360942d+3*t114*t35*t81*t84-1.4
     6         772294880962508d+4*t114*t32*t81*t84+9.232684300601568d+3*
     7         t114*t29*t81*t84-2.104036366334451d+5*t215*t35*t79*t84+8.
     8         416145465337803d+5*t215*t32*t79*t84-1.0520181831672254d+6
     9         *t215*t29*t79*t84+4.208072732668902d+5*t215*t26*t79*t84-2
     :         .104036366334451d+4*t215*t41*t66*t83+1.2624218198006704d+
     ;         5*t215*t38*t66*t83-1.8936327297010064d+5*t215*t35*t66*t83
     <         +8.416145465337804d+4*t215*t32*t66*t83+1.350459221435732d
     =         +1*t130*t32*t81*t82-1.6880740267946648d+1*t130*t29*t81*t8
     >         2+9.232684300601568d+3*t114*t32*t79*t82-2.308171075150392
     ?         d+4*t114*t29*t79*t82+1.3849026450902355d+4*t114*t26*t79*t
     @         82-4.2080727326689016d+5*t215*t32*t77*t82+1.5780272747508
     1         38d+6*t215*t29*t77*t82-1.893632729701006d+6*t215*t26*t77*
     2         t82+7.364127282170578d+5*t215*t23*t77*t82+1.6880740267946
     3         648d+1*t130*t29*t79*t80-2.0256888321535982d+1*t130*t26*t7
     4         9*t80+1.3849026450902355d+4*t114*t29*t77*t80-3.3237663482
     5         16566d+4*t114*t26*t77*t80+1.9388637031263292d+4*t114*t23*
     6         t77*t80-7.364127282170578d+5*t215*t29*t75*t80+2.651085821
     7         5814087d+6*t215*t26*t75*t80-3.0929334585116436d+6*t215*t2
     8         3*t75*t80+1.1782603651472927d+6*t20*t215*t75*t80+2.025688
     9         8321535982d+1*t130*t26*t77*t78-2.3633036375125308d+1*t130
     :         *t23*t77*t78+1.9388637031263292d+4*t114*t26*t75*t78-4.524
     ;         0153072947686d+4*t114*t23*t75*t78+2.585151604168439d+4*t1
     <         14*t20*t75*t78-1.1782603651472927d+6*t215*t26*t73*t78+4.1
     =         23911278015524d+6*t215*t23*t73*t78-4.713041460589171d+6*t
     >         20*t215*t73*t78+1.767390547720939d+6*t17*t215*t73*t78+2.3
     ?         633036375125308d+1*t130*t23*t75*t76-2.700918442871464d+1*
     @         t130*t20*t75*t76+2.585151604168439d+4*t114*t23*t73*t76-5.
     1         908917952385003d+4*t114*t20*t73*t76+3.3237663482165647d+4
     2         *t114*t17*t73*t76-1.7673905477209387d+6*t215*t23*t71*t76+
     3         6.059624735043219d+6*t20*t215*t71*t76-6.817077826923622d+
     4         6*t17*t215*t71*t76+2.524843639601341d+6*t14*t215*t71*t76+
     5         2.700918442871464d+1*t130*t20*t73*t74-3.0385332482303967d
     6         +1*t130*t17*t73*t74+3.3237663482165647d+4*t114*t20*t71*t7
     7         4-7.478474283487271d+4*t114*t17*t71*t74+4.154707935270705
     8         d+4*t114*t14*t71*t74+3.4716600044518436d+6*t215*t69*t7*t7
     9         4-2.524843639601341d+6*t20*t215*t69*t74+8.521347283654526
     :         d+6*t17*t215*t69*t74-9.468163648505028d+6*t14*t215*t69*t7
     ;         4+3.0385332482303967d+1*t130*t17*t71*t72-3.37614805358932
     <         96d+1*t130*t14*t71*t72+5.077976365330863d+4*t114*t69*t7*t
     =         72-1.2729420016323426d+7*t112*t215*t7*t72+4.1547079352707
     >         056d+4*t114*t17*t69*t72-9.232684300601568d+4*t114*t14*t69
     ?         *t72-3.4716600044518436d+6*t112*t17*t215*t72+1.1572200014
     @         839477d+7*t112*t14*t215*t72-3.713762858948263d+1*t130*t69
     1         *t7*t70+1.5275304019588112d+7*t157*t215*t7*t70-1.11715480
     2         03727898d+5*t112*t114*t7*t70+3.3761480535893296d+1*t130*t
     3         14*t69*t70-4.628880005935792d+6*t14*t157*t215*t70+5.07797
     4         6365330862d+4*t112*t114*t14*t70-6.01754400771653d+6*t215*
     5         t224*t67*t7+6.093571638397036d+4*t114*t157*t67*t7+3.71376
     6         2858948263d+1*t112*t130*t67*t7)-2.791577209047299d+0*t113
     7         *t165*t63-2.791577209047299d+0*t118*t158*t63-3.7221029453
     8         963983d+0*t114*t158*t62-7.444205890792797d+0*t113*t114*t1
     9         18)*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = (t47*(1.0d+0*t5*(-4.979359999999999
     1         3d-2*t104*t52*t57*taua-2.48968d-2*t107*t108*t51*t57*taua-
     2         1.493808d-1*t107*t151*t45*t51*t54*taua-1.9917439999999997
     3         d-1*t104*t108*t45*t54*taua+2.6666666666666666d+1*t104*t52
     4         *t53*taua+1.3333333333333333d+1*t107*t108*t51*t53*taua-1.
     5         6597866666666666d-1*gammaaa*t108*t173*t53*taua-7.46904d-2
     6         *gammaaa*t107*t124*t151*t53*taua-1.8257653333333332d-2*t1
     7         48*t45*t52*t57+3.73452d-3*t1*t108*t152*t45*t57-1.120356d-
     8         2*t1*t150*t151*t45*t57-1.9917439999999997d-2*t105*t107*t1
     9         08*t45*t57-t1*t152*t52*t56-6.307189333333332d-2*gammaaa*t
     :         147*t52*t56+5.333333333333333d+0*t105*t107*t52*t56+3.7345
     ;         2d-3*gammaaa*t108*t152*t51*t56-1.120356d-2*gammaaa*t150*t
     <         151*t51*t56+9.777777777777779d+0*t148*t47*t56+2*t1*t108*t
     =         150*t56-3.9834879999999995d-2*gammaaa*t104*t107*t108*t56-
     >         4.481424d-2*t1*t150*t222*t54*t55+1.120356d-2*t1*t151*t152
     ?         *t54*t55-5.975231999999999d-2*t105*t107*t151*t54*t55-3.65
     @         15306666666664d-2*t108*t148*t54*t55-8.298933333333335d-2*
     1         t108*t124*t153*t54+9.777777777777779d+0*t148*t45*t52*t53-
     2         4.481424d-2*gammaaa*t150*t222*t45*t51*t53+1.120356d-2*gam
     3         maaa*t151*t152*t45*t51*t53-2*t1*t108*t152*t45*t53+6*t1*t1
     4         50*t151*t45*t53-1.1950464d-1*gammaaa*t104*t107*t151*t45*t
     5         53-1.2614378666666665d-1*gammaaa*t108*t147*t45*t53+1.0666
     6         666666666666d+1*t105*t107*t108*t45*t53+6.755555555555556d
     7         +1*gammaaa*t147*t49*t52-4*gammaaa*t108*t152*t49*t51+12*ga
     8         mmaaa*t150*t151*t49*t51-4.481424d-2*t124*t150*t222*t49*t5
     9         0-1.7925696d-1*t107*t151*t173*t49*t50+1.120356d-2*t124*t1
     :         51*t152*t49*t50-2.6888544000000003d-1*t108*t146*t49*t50+4
     ;         .2666666666666664d+1*gammaaa*t104*t107*t108*t49)+2.666666
     <         6666666666d+0*t102*t176+4.444444444444444d-1*t125*t143)+t
     =         52*(-1.1618506666666667d-2*t206*t58-1.0d+0*t107*t176*t5-1
     >         .0d+0*t125*t152*t5-t107*t177+4.9793599999999993d-3*t109*t
     ?         175-1.3333333333333333d+0*t102*t107*t125+4.97935999999999
     @         93d-3*t105*t110)-1.9917439999999997d-2*t107*t108*t175*t58
     1         -1.120356d-2*t126*t150*t151*t58-1.86726d-3*t1*t155*t52-9.
     2         305257363490997d-1*t43*t5*(6.610678411788878d-6*t145*t146
     3         *t50+3.531915643569816d-2*t148*t3-1.3976589410890572d-8*t
     4         144*t218/rhoa**1.2666666666666665d+1-9.376593846722628d-4
     5         *gammaaa*t103*t147)-1.8610514726981994d+0*t101*t174*t5+2.
     6         0d+0*t108*t125*t150*t5-9.305257363490997d-1*t123*t142*t5-
     7         2.481401963597599d+0*t102*t174*t43-4.1356699393293317d-1*
     8         t123*t143*t43-3.73452d-3*t1*t108*t156-2.481401963597599d+
     9         0*t101*t102*t123)*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = (t93*(1.0d+0*t63*(-4.97935999999999
     1         93d-2*t116*t57*t96*taub+2.6666666666666666d+1*t116*t53*t9
     2         6*taub-1.493808d-1*t119*t167*t54*t91*t95*taub-2.48968d-2*
     3         t119*t120*t57*t95*taub+1.3333333333333333d+1*t119*t120*t5
     4         3*t95*taub-1.9917439999999997d-1*t116*t120*t54*t91*taub-1
     5         .6597866666666666d-1*gammabb*t120*t178*t53*taub-7.46904d-
     6         2*gammabb*t119*t128*t167*t53*taub-4.481424d-2*t166*t229*t
     7         54*t59*t97+1.120356d-2*t167*t168*t54*t59*t97-5.9752319999
     8         99999d-2*t117*t119*t167*t54*t97-3.6515306666666664d-2*t12
     9         0*t164*t54*t97-1.8257653333333332d-2*t164*t57*t91*t96+9.7
     :         77777777777779d+0*t164*t53*t91*t96-t168*t56*t59*t96-6.307
     ;         189333333332d-2*gammabb*t163*t56*t96+5.333333333333333d+0
     <         *t117*t119*t56*t96+6.755555555555556d+1*gammabb*t163*t49*
     =         t96-4.481424d-2*gammabb*t166*t229*t53*t91*t95+1.120356d-2
     >         *gammabb*t167*t168*t53*t91*t95+3.73452d-3*gammabb*t120*t1
     ?         68*t56*t95-1.120356d-2*gammabb*t166*t167*t56*t95-4*gammab
     @         b*t120*t168*t49*t95+12*gammabb*t166*t167*t49*t95-4.481424
     1         d-2*t128*t166*t229*t49*t94-1.7925696d-1*t119*t167*t178*t4
     2         9*t94+1.120356d-2*t128*t167*t168*t49*t94-2.68885440000000
     3         03d-1*t120*t162*t49*t94+9.777777777777779d+0*t164*t56*t93
     4         +3.73452d-3*t120*t168*t57*t59*t91-1.120356d-2*t166*t167*t
     5         57*t59*t91-2*t120*t168*t53*t59*t91+6*t166*t167*t53*t59*t9
     6         1-1.9917439999999997d-2*t117*t119*t120*t57*t91-1.1950464d
     7         -1*gammabb*t116*t119*t167*t53*t91-1.2614378666666665d-1*g
     8         ammabb*t120*t163*t53*t91+1.0666666666666666d+1*t117*t119*
     9         t120*t53*t91+2*t120*t166*t56*t59-3.9834879999999995d-2*ga
     :         mmabb*t116*t119*t120*t56-8.298933333333335d-2*t120*t128*t
     ;         169*t54+4.2666666666666664d+1*gammabb*t116*t119*t120*t49)
     <         +2.6666666666666666d+0*t114*t181+4.444444444444444d-1*t12
     =         9*t159)+t96*(-1.1618506666666667d-2*t213*t98-1.0d+0*t119*
     >         t181*t63-1.0d+0*t129*t168*t63-t119*t182+4.979359999999999
     ?         3d-3*t121*t180-1.3333333333333333d+0*t114*t119*t129+4.979
     @         3599999999993d-3*t117*t122)-1.9917439999999997d-2*t119*t1
     1         20*t180*t98-1.120356d-2*t130*t166*t167*t98-1.86726d-3*t17
     2         1*t59*t96-9.305257363490997d-1*t63*t89*(6.610678411788878
     3         d-6*t161*t162*t94+3.531915643569816d-2*t164*t61-1.3976589
     4         410890572d-8*t160*t225/rhob**1.2666666666666665d+1-9.3765
     5         93846722628d-4*gammabb*t115*t163)-2.481401963597599d+0*t1
     6         14*t179*t89-4.1356699393293317d-1*t127*t159*t89-1.8610514
     7         726981994d+0*t113*t179*t63+2.0d+0*t120*t129*t166*t63-9.30
     8         5257363490997d-1*t127*t158*t63-3.73452d-3*t120*t172*t59-2
     9         .481401963597599d+0*t113*t114*t127)*wght+Cmat3(iq,D3_RB_R
     :         B_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = (t47*(1.0d+0*t5*(-2.3244399384d-5*
     1         t108*t124*t57*taua-1.3946639630399998d-4*t124*t151*t45*t5
     2         4*taua-6.9733198152d-5*gammaaa*t151*t184*t53*taua+2.48968
     3         d-2*t108*t124*t53*taua-2.0919959445599998d-5*t107*t151*t4
     4         5*t51*t57-3.7191039014399996d-5*t104*t108*t45*t57+1.99174
     5         39999999997d-2*t104*t52*t56+7.46904d-3*t107*t108*t51*t56-
     6         5.578655852159999d-5*gammaaa*t108*t173*t56-2.091995944559
     7         9998d-5*gammaaa*t107*t124*t151*t56-8.367983778239999d-5*t
     8         107*t222*t51*t54*t55-1.1157311704319998d-4*t104*t151*t54*
     9         t55+2.240712d-2*t107*t151*t45*t51*t53-8.367983778239999d-
     :         5*gammaaa*t107*t124*t222*t45*t53-1.6735967556479997d-4*ga
     ;         mmaaa*t151*t173*t45*t53+3.9834879999999995d-2*t104*t108*t
     <         45*t53-1.0666666666666666d+1*t104*t49*t52-4*t107*t108*t49
     =         *t51-2.2314623408639997d-4*t151*t231*t49*t50-8.3679837782
     >         39999d-5*t107*t184*t222*t49*t50+1.1950464d-1*gammaaa*t108
     ?         *t173*t49+4.481424d-2*gammaaa*t107*t124*t151*t49)+1.33333
     @         33333333333d+0*t102*t185)-3.7191039014399996d-5*t108*t232
     1         *t58-2.0919959445599998d-5*t107*t151*t186*t58-1.0d+0*t107
     2         *t185*t5*t52-3.73452d-3*t1*t177*t52+9.958719999999999d-3*
     3         t125*t175*t52+6.973319815199999d-6*t108*t110*t51-9.305257
     4         363490997d-1*t43*t5*(5.241221029083964d-9*t218*t231*t50-1
     5         .944317179937905d-6*gammaaa*t145*t173+1.731063479394947d-
     6         4*t103*t104)-9.305257363490997d-1*t101*t183*t5-1.24070098
     7         17987995d+0*t102*t183*t43+7.46904d-3*t107*t108*t125*t126)
     8         *wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = (t93*(1.0d+0*t63*(-1.3946639630399
     1         998d-4*t128*t167*t54*t91*taub-2.3244399384d-5*t120*t128*t
     2         57*taub-6.9733198152d-5*gammabb*t167*t188*t53*taub+2.4896
     3         8d-2*t120*t128*t53*taub-8.367983778239999d-5*t119*t229*t5
     4         4*t95*t97-1.1157311704319998d-4*t116*t167*t54*t97+1.99174
     5         39999999997d-2*t116*t56*t96-1.0666666666666666d+1*t116*t4
     6         9*t96-2.0919959445599998d-5*t119*t167*t57*t91*t95+2.24071
     7         2d-2*t119*t167*t53*t91*t95+7.46904d-3*t119*t120*t56*t95-4
     8         *t119*t120*t49*t95-2.2314623408639997d-4*t167*t233*t49*t9
     9         4-8.367983778239999d-5*t119*t188*t229*t49*t94-3.719103901
     :         4399996d-5*t116*t120*t57*t91-8.367983778239999d-5*gammabb
     ;         *t119*t128*t229*t53*t91-1.6735967556479997d-4*gammabb*t16
     <         7*t178*t53*t91+3.9834879999999995d-2*t116*t120*t53*t91-5.
     =         578655852159999d-5*gammabb*t120*t178*t56-2.09199594455999
     >         98d-5*gammabb*t119*t128*t167*t56+1.1950464d-1*gammabb*t12
     ?         0*t178*t49+4.481424d-2*gammabb*t119*t128*t167*t49)+1.3333
     @         333333333333d+0*t114*t189)-3.7191039014399996d-5*t120*t23
     1         4*t98-2.0919959445599998d-5*t119*t167*t190*t98-1.0d+0*t11
     2         9*t189*t63*t96-3.73452d-3*t182*t59*t96+9.958719999999999d
     3         -3*t129*t180*t96+6.973319815199999d-6*t120*t122*t95-9.305
     4         257363490997d-1*t63*t89*(5.241221029083964d-9*t225*t233*t
     5         94-1.944317179937905d-6*gammabb*t161*t178+1.7310634793949
     6         47d-4*t115*t116)-1.2407009817987995d+0*t114*t187*t89-9.30
     7         5257363490997d-1*t113*t187*t63+7.46904d-3*t119*t120*t129*
     8         t130)*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = (-3.9063003474391045d-8*t151*t58/
     1         rhoa**6.666666666666667d+0+1.0d+0*t47*t5*(-3.906300347439
     2         1045d-8*t124*t151*t45*t57-3.9063003474391045d-8*gammaaa*t
     3         151*t184*t56+2.0919959445599995d-5*t108*t124*t56-1.562520
     4         138975642d-7*t124*t222*t54*t55-1.562520138975642d-7*gamma
     5         aa*t184*t222*t45*t53+6.275987833679999d-5*t124*t151*t45*t
     6         53-1.562520138975642d-7*t222*t49*t50/rhoa**1.333333333333
     7         3333d+1+1.255197566736d-4*gammaaa*t151*t184*t49-2.240712d
     8         -2*t108*t124*t49)-5.60178d-3*t126*t185*t52-9.305257363490
     9         997d-1*(4.374713654860287d-7*t124*t145-1.965457885906487d
     :         -9*gammaaa*t184*t218)*t43*t5+2.0919959445599995d-5*t108*t
     ;         125*t186)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = (-3.9063003474391045d-8*t167*t98/
     1         rhob**6.666666666666667d+0+1.0d+0*t63*t93*(-1.56252013897
     2         5642d-7*t128*t229*t54*t97-1.562520138975642d-7*t229*t49*t
     3         94/rhob**1.3333333333333333d+1-3.9063003474391045d-8*t128
     4         *t167*t57*t91-1.562520138975642d-7*gammabb*t188*t229*t53*
     5         t91+6.275987833679999d-5*t128*t167*t53*t91-3.906300347439
     6         1045d-8*gammabb*t167*t188*t56+2.0919959445599995d-5*t120*
     7         t128*t56+1.255197566736d-4*gammabb*t167*t188*t49-2.240712
     8         d-2*t120*t128*t49)-5.60178d-3*t130*t189*t96-9.30525736349
     9         0997d-1*(4.374713654860287d-7*t128*t161-1.965457885906487
     :         d-9*gammabb*t188*t225)*t63*t89+2.0919959445599995d-5*t120
     ;         *t129*t190)*wght+Cmat3(iq,D3_GBB_GBB_GBB)
            Mmat3(iq,D3_RA_RA_TA) = (t47*(1.0d+0*t5*(-7.469039999999999d
     1         -2*t51*t52*t57*taua-4.97936d-2*t107*t108*t133*t57*taua+8.
     2         0d+1*t51*t52*t54*taua-2.9876159999999996d-1*t108*t45*t51*
     3         t54*taua-2.987616d-1*t107*t133*t151*t45*t54*taua+5.333333
     4         333333333d+1*t107*t108*t133*t54*taua-1.493808d-1*gammaaa*
     5         t107*t132*t151*t53*taua-2.8216373333333333d-1*gammaaa*t10
     6         8*t124*t53*taua-1.6597866666666666d-2*t105*t45*t52*t57-2.
     7         0d+0*t152*t44*t52*t57+6.666666666666667d+0*t1*t107*t52*t5
     8         7+8.88888888888889d+0*t105*t47*t57+7.46904d-3*t108*t152*t
     9         44*t45*t57-2.240712d-2*t150*t151*t44*t45*t57-2.48968d-2*t
     :         1*t107*t108*t45*t57+4.0d+0*t108*t150*t44*t57-8.6308906666
     ;         66666d-2*gammaaa*t104*t52*t56-6.473168d-2*gammaaa*t107*t1
     <         08*t51*t56+7.46904d-3*gammaaa*t108*t133*t152*t56-2.240712
     =         d-2*gammaaa*t133*t150*t151*t56-8.962848d-2*t150*t222*t44*
     >         t54*t55+2.240712d-2*t151*t152*t44*t54*t55-7.46904d-2*t1*t
     ?         107*t151*t54*t55-3.319573333333333d-2*t105*t108*t54*t55+1
     @         .7777777777777778d+1*t105*t45*t52*t54-8.0d+0*t108*t152*t4
     1         4*t45*t54+2.4d+1*t150*t151*t44*t45*t54+2.6666666666666666
     2         d+1*t1*t107*t108*t45*t54-1.659786666666667d-1*t108*t132*t
     3         153*t54+4.622222222222223d+1*gammaaa*t104*t52*t53-1.94195
     4         03999999999d-1*gammaaa*t107*t151*t45*t51*t53+3.4666666666
     5         66666d+1*gammaaa*t107*t108*t51*t53-8.962848d-2*gammaaa*t1
     6         33*t150*t222*t45*t53+2.240712d-2*gammaaa*t133*t151*t152*t
     7         45*t53-1.7261781333333331d-1*gammaaa*t104*t108*t45*t53-4.
     8         0d+0*gammaaa*t108*t133*t152*t53+1.2d+1*gammaaa*t133*t150*
     9         t151*t53-8.962848d-2*t132*t150*t222*t49*t50-4.1826624d-1*
     :         t108*t173*t49*t50+2.240712d-2*t132*t151*t152*t49*t50-3.13
     ;         69968d-1*t107*t124*t151*t49*t50)+2.6666666666666666d+0*t1
     <         02*t192+4.444444444444444d-1*t134*t143)-9.305257363490997
     =         d-1*t4*t5*(-7.921643129916147d+5*t11*t217*t5*t7-4.5701787
     >         287977763d+5*t13*t21*t5*t7+5.585774001863949d+5*t100*t18*
     ?         t5*t7+6.702928802236738d+5*t141*t15*t5*t7-2.2282577153689
     @         58d+3*t13*t135*t18*t7+2.6739092584427493d+3*t11*t135*t141
     1         *t7+9.232684300601569d+2*t37*t41*t5-2.769805290180471d+3*
     2         t10*t34*t41*t5-1.1079221160721883d+4*t31*t38*t39*t5+1.661
     3         8831741082832d+4*t31*t35*t39*t5+2.2158442321443766d+4*t31
     4         *t32*t39*t5-2.7698052901804704d+4*t29*t31*t39*t5+1.846536
     5         860120314d+3*t37*t38*t5+5.539610580360942d+3*t10*t34*t38*
     6         t5-2.769805290180471d+3*t35*t37*t5-2.769805290180471d+4*t
     7         28*t35*t36*t5+3.693073720240629d+4*t28*t32*t36*t5+4.61634
     8         2150300784d+4*t28*t29*t36*t5-5.539610580360942d+4*t26*t28
     9         *t36*t5+8.309415870541416d+3*t10*t34*t35*t5-1.10792211607
     :         21883d+4*t10*t32*t34*t5-5.539610580360941d+4*t25*t32*t33*
     ;         t5+6.924513225451174d+4*t25*t29*t33*t5+8.309415870541416d
     <         +4*t25*t26*t33*t5-9.694318515631648d+4*t23*t25*t33*t5-9.6
     =         94318515631648d+4*t22*t29*t30*t5+1.1633182218757979d+5*t2
     >         2*t26*t30*t5+1.3572045921884307d+5*t22*t23*t30*t5-1.55109
     ?         09625010635d+5*t20*t22*t30*t5-1.5510909625010638d+5*t19*t
     @         26*t27*t5+1.809606122917908d+5*t19*t23*t27*t5+2.068121283
     1         3347515d+5*t19*t20*t27*t5-2.3266364437515952d+5*t17*t19*t
     2         27*t5-2.3266364437515955d+5*t16*t23*t24*t5+2.659013078573
     3         252d+5*t16*t20*t24*t5+2.9913897133949086d+5*t16*t17*t24*t
     4         5-3.3237663482165647d+5*t14*t16*t24*t5-3.323766348216565d
     5         +5*t13*t20*t21*t5+3.7392371417436354d+5*t13*t17*t21*t5+4.
     6         1547079352707056d+5*t13*t14*t21*t5-4.5701787287977763d+5*
     7         t100*t17*t18*t5+5.077976365330863d+5*t100*t14*t18*t5-6.09
     8         3571638397035d+5*t14*t141*t15*t5+4.0513776643071964d+1*t1
     9         0*t135*t37*t41-4.0513776643071964d+1*t135*t38*t40+1.21541
     :         32992921589d+2*t135*t34*t38*t39-2.4308265985843178d+2*t13
     ;         5*t32*t34*t39-1.2154132992921589d+2*t10*t135*t35*t37+2.43
     <         08265985843178d+2*t135*t31*t35*t36-4.051377664307196d+2*t
     =         135*t29*t31*t36+4.0513776643071964d+2*t135*t28*t32*t33-6.
     >         077066496460795d+2*t135*t26*t28*t33+6.077066496460793d+2*
     ?         t135*t25*t29*t30-8.507893095045111d+2*t135*t23*t25*t30+8.
     @         507893095045113d+2*t135*t22*t26*t27-1.1343857460060149d+3
     1         *t135*t20*t22*t27+1.1343857460060149d+3*t135*t19*t23*t24-
     2         1.4584959591505905d+3*t135*t17*t19*t24+1.4584959591505908
     3         d+3*t135*t16*t20*t21-1.8231199489382383d+3*t135*t14*t16*t
     4         21+1.8231199489382383d+3*t13*t135*t17*t18+2.2282577153689
     5         576d+3*t100*t135*t14*t15)+t52*(-8.298933333333333d-3*t175
     6         *t58-1.0d+0*t107*t192*t5-1.0d+0*t134*t152*t5-t107*t193-1.
     7         3333333333333333d+0*t102*t107*t134+6.2242d-3*t109*t126+6.
     8         2242d-3*t1*t110)-2.240712d-2*t135*t150*t151*t58-2.48968d-
     9         2*t107*t108*t126*t58-3.73452d-3*t155*t44*t52-1.8610514726
     :         981994d+0*t106*t191*t5+2.0d+0*t108*t134*t150*t5-9.3052573
     ;         63490997d-1*t131*t149*t5-7.46904d-3*t108*t156*t44-2.48140
     <         1963597599d+0*t102*t191*t4-4.1356699393293317d-1*t131*t14
     =         3*t4-2.481401963597599d+0*t102*t106*t131)*wght+Mmat3(iq,D
     >         3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
            Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
            Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
            Mmat3(iq,D3_RB_RB_TB) = (t93*(1.0d+0*t63*(-7.469039999999999
     1         d-2*t57*t95*t96*taub+8.0d+1*t54*t95*t96*taub-2.9876159999
     2         999996d-1*t120*t54*t91*t95*taub-2.987616d-1*t119*t138*t16
     3         7*t54*t91*taub-4.97936d-2*t119*t120*t138*t57*taub+5.33333
     4         3333333333d+1*t119*t120*t138*t54*taub-1.493808d-1*gammabb
     5         *t119*t137*t167*t53*taub-2.8216373333333333d-1*gammabb*t1
     6         20*t128*t53*taub-8.962848d-2*t166*t229*t54*t90*t97+2.2407
     7         12d-2*t167*t168*t54*t90*t97-7.46904d-2*t119*t167*t54*t59*
     8         t97-3.319573333333333d-2*t117*t120*t54*t97-1.659786666666
     9         6666d-2*t117*t57*t91*t96+1.7777777777777778d+1*t117*t54*t
     :         91*t96-2.0d+0*t168*t57*t90*t96+6.666666666666667d+0*t119*
     ;         t57*t59*t96-8.630890666666666d-2*gammabb*t116*t56*t96+4.6
     <         22222222222223d+1*gammabb*t116*t53*t96-1.9419503999999999
     =         d-1*gammabb*t119*t167*t53*t91*t95-6.473168d-2*gammabb*t11
     >         9*t120*t56*t95+3.466666666666666d+1*gammabb*t119*t120*t53
     ?         *t95-8.962848d-2*t137*t166*t229*t49*t94-4.1826624d-1*t120
     @         *t178*t49*t94+2.240712d-2*t137*t167*t168*t49*t94-3.136996
     1         8d-1*t119*t128*t167*t49*t94+8.88888888888889d+0*t117*t57*
     2         t93+7.46904d-3*t120*t168*t57*t90*t91-2.240712d-2*t166*t16
     3         7*t57*t90*t91-8.0d+0*t120*t168*t54*t90*t91+2.4d+1*t166*t1
     4         67*t54*t90*t91-2.48968d-2*t119*t120*t57*t59*t91+2.6666666
     5         666666666d+1*t119*t120*t54*t59*t91-8.962848d-2*gammabb*t1
     6         38*t166*t229*t53*t91+2.240712d-2*gammabb*t138*t167*t168*t
     7         53*t91-1.7261781333333331d-1*gammabb*t116*t120*t53*t91+4.
     8         0d+0*t120*t166*t57*t90+7.46904d-3*gammabb*t120*t138*t168*
     9         t56-2.240712d-2*gammabb*t138*t166*t167*t56-1.659786666666
     :         667d-1*t120*t137*t169*t54-4.0d+0*gammabb*t120*t138*t168*t
     ;         53+1.2d+1*gammabb*t138*t166*t167*t53)+2.6666666666666666d
     <         +0*t114*t195+4.444444444444444d-1*t139*t159)+t96*(-8.2989
     =         33333333333d-3*t180*t98-1.0d+0*t119*t195*t63-1.0d+0*t139*
     >         t168*t63+6.2242d-3*t122*t59-t119*t196-1.3333333333333333d
     ?         +0*t114*t119*t139+6.2242d-3*t121*t130)-2.240712d-2*t140*t
     @         166*t167*t98-2.48968d-2*t119*t120*t130*t98-3.73452d-3*t17
     1         1*t90*t96-7.46904d-3*t120*t172*t90-9.305257363490997d-1*t
     2         62*t63*(-4.0513776643071964d+1*t140*t38*t87+1.21541329929
     3         21589d+2*t140*t38*t83*t86-2.4308265985843178d+2*t140*t32*
     4         t83*t86-1.1079221160721883d+4*t38*t63*t81*t86+1.661883174
     5         1082832d+4*t35*t63*t81*t86+2.2158442321443766d+4*t32*t63*
     6         t81*t86-2.7698052901804704d+4*t29*t63*t81*t86+4.051377664
     7         3071964d+1*t140*t41*t66*t85-1.2154132992921589d+2*t140*t3
     8         5*t66*t85+9.232684300601569d+2*t41*t63*t85+1.846536860120
     9         314d+3*t38*t63*t85-2.769805290180471d+3*t35*t63*t85+2.430
     :         8265985843178d+2*t140*t35*t81*t84-4.051377664307196d+2*t1
     ;         40*t29*t81*t84-2.769805290180471d+4*t35*t63*t79*t84+3.693
     <         073720240629d+4*t32*t63*t79*t84+4.616342150300784d+4*t29*
     =         t63*t79*t84-5.539610580360942d+4*t26*t63*t79*t84-2.769805
     >         290180471d+3*t41*t63*t66*t83+5.539610580360942d+3*t38*t63
     ?         *t66*t83+8.309415870541416d+3*t35*t63*t66*t83-1.107922116
     @         0721883d+4*t32*t63*t66*t83+4.0513776643071964d+2*t140*t32
     1         *t79*t82-6.077066496460795d+2*t140*t26*t79*t82-5.53961058
     2         0360941d+4*t32*t63*t77*t82+6.924513225451174d+4*t29*t63*t
     3         77*t82+8.309415870541416d+4*t26*t63*t77*t82-9.69431851563
     4         1648d+4*t23*t63*t77*t82+6.077066496460793d+2*t140*t29*t77
     5         *t80-8.507893095045111d+2*t140*t23*t77*t80-9.694318515631
     6         648d+4*t29*t63*t75*t80+1.1633182218757979d+5*t26*t63*t75*
     7         t80+1.3572045921884307d+5*t23*t63*t75*t80-1.5510909625010
     8         635d+5*t20*t63*t75*t80+8.507893095045113d+2*t140*t26*t75*
     9         t78-1.1343857460060149d+3*t140*t20*t75*t78-1.551090962501
     :         0638d+5*t26*t63*t73*t78+1.809606122917908d+5*t23*t63*t73*
     ;         t78+2.0681212833347515d+5*t20*t63*t73*t78-2.3266364437515
     <         952d+5*t17*t63*t73*t78+1.1343857460060149d+3*t140*t23*t73
     =         *t76-1.4584959591505905d+3*t140*t17*t73*t76-2.32663644375
     >         15955d+5*t23*t63*t71*t76+2.659013078573252d+5*t20*t63*t71
     ?         *t76+2.9913897133949086d+5*t17*t63*t71*t76-3.323766348216
     @         5647d+5*t14*t63*t71*t76+1.4584959591505908d+3*t140*t20*t7
     1         1*t74-1.8231199489382383d+3*t14*t140*t71*t74-4.5701787287
     2         977763d+5*t63*t69*t7*t74-3.323766348216565d+5*t20*t63*t69
     3         *t74+3.7392371417436354d+5*t17*t63*t69*t74+4.154707935270
     4         7056d+5*t14*t63*t69*t74-2.228257715368958d+3*t140*t69*t7*
     5         t72+5.585774001863949d+5*t112*t63*t7*t72+1.82311994893823
     6         83d+3*t140*t17*t69*t72-4.5701787287977763d+5*t112*t17*t63
     7         *t72+5.077976365330863d+5*t112*t14*t63*t72+6.702928802236
     8         738d+5*t157*t63*t7*t70-6.093571638397035d+5*t14*t157*t63*
     9         t70+2.2282577153689576d+3*t112*t14*t140*t70-7.92164312991
     :         6147d+5*t224*t63*t67*t7+2.6739092584427493d+3*t140*t157*t
     ;         67*t7)-1.8610514726981994d+0*t118*t194*t63+2.0d+0*t120*t1
     <         39*t166*t63-9.305257363490997d-1*t136*t165*t63-2.48140196
     =         3597599d+0*t114*t194*t62-4.1356699393293317d-1*t136*t159*
     >         t62-2.481401963597599d+0*t114*t118*t136)*wght+Mmat3(iq,D3
     ?         _RB_RB_TB)
            Mmat3(iq,D3_RA_GAA_TA) = (t47*(1.0d+0*t5*(-4.6488798768d-5*t
     1         108*t132*t57*taua-2.7893279260799997d-4*t132*t151*t45*t54
     2         *taua+4.97936d-2*t108*t132*t54*taua-1.3946639630399998d-4
     3         *gammaaa*t151*t197*t53*taua+2.48968d-2*t108*t132*t53*taua
     4         +1.618292d-2*t51*t52*t57-6.043543839839999d-5*t108*t45*t5
     5         1*t57-4.1839918891199995d-5*t107*t133*t151*t45*t57+7.4690
     6         4d-3*t107*t108*t133*t57+1.618292d-2*t51*t52*t56-4.1839918
     7         891199995d-5*gammaaa*t107*t132*t151*t56+7.46904d-3*t107*t
     8         108*t133*t56-9.76264774128d-5*gammaaa*t108*t124*t56-1.813
     9         0631519519996d-4*t151*t51*t54*t55-1.673596755648d-4*t107*
     :         t133*t222*t54*t55+6.473168d-2*t108*t45*t51*t54+4.481424d-
     ;         2*t107*t133*t151*t45*t54-8.666666666666666d+0*t51*t52*t53
     <         +3.236584d-2*t108*t45*t51*t53-1.673596755648d-4*gammaaa*t
     =         107*t132*t222*t45*t53+2.240712d-2*t107*t133*t151*t45*t53-
     >         2.9287943223839996d-4*gammaaa*t124*t151*t45*t53+2.240712d
     ?         -2*gammaaa*t107*t132*t151*t53-4.0d+0*t107*t108*t133*t53+5
     @         .228328d-2*gammaaa*t108*t124*t53-1.673596755648d-4*t107*t
     1         197*t222*t49*t50-4.044525492816d-4*t151*t184*t49*t50+4.48
     2         1424d-2*gammaaa*t107*t132*t151*t49+1.0456655999999999d-1*
     3         gammaaa*t108*t124*t49)+1.3333333333333333d+0*t102*t198)-4
     4         .1839918891199995d-5*t107*t151*t199*t58-6.043543839839999
     5         d-5*t108*t186*t58-1.0d+0*t107*t198*t5*t52-3.73452d-3*t177
     6         *t44*t52-1.86726d-3*t1*t193*t52+4.9793599999999993d-3*t13
     7         4*t175*t52+6.2242d-3*t125*t126*t52-9.305257363490997d-1*t
     8         123*t191*t5-9.305257363490997d-1*t131*t174*t5+7.46904d-3*
     9         t107*t108*t125*t135+3.73452d-3*t107*t108*t126*t134+1.3946
     :         639630399998d-5*t108*t110*t133-1.2407009817987995d+0*t102
     ;         *t123*t131)*wght+Mmat3(iq,D3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
            Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
            Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
            Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
            Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
            Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
            Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
            Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
            Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
            Mmat3(iq,D3_RB_GBB_TB) = (t93*(1.0d+0*t63*(-2.78932792607999
     1         97d-4*t137*t167*t54*t91*taub-4.6488798768d-5*t120*t137*t5
     2         7*taub+4.97936d-2*t120*t137*t54*taub-1.3946639630399998d-
     3         4*gammabb*t167*t200*t53*taub+2.48968d-2*t120*t137*t53*tau
     4         b-1.8130631519519996d-4*t167*t54*t95*t97-1.673596755648d-
     5         4*t119*t138*t229*t54*t97+1.618292d-2*t57*t95*t96+1.618292
     6         d-2*t56*t95*t96-8.666666666666666d+0*t53*t95*t96-6.043543
     7         839839999d-5*t120*t57*t91*t95+6.473168d-2*t120*t54*t91*t9
     8         5+3.236584d-2*t120*t53*t91*t95-1.673596755648d-4*t119*t20
     9         0*t229*t49*t94-4.044525492816d-4*t167*t188*t49*t94-4.1839
     :         918891199995d-5*t119*t138*t167*t57*t91+4.481424d-2*t119*t
     ;         138*t167*t54*t91-1.673596755648d-4*gammabb*t119*t137*t229
     <         *t53*t91+2.240712d-2*t119*t138*t167*t53*t91-2.92879432238
     =         39996d-4*gammabb*t128*t167*t53*t91+7.46904d-3*t119*t120*t
     >         138*t57-4.1839918891199995d-5*gammabb*t119*t137*t167*t56+
     ?         7.46904d-3*t119*t120*t138*t56-9.76264774128d-5*gammabb*t1
     @         20*t128*t56+2.240712d-2*gammabb*t119*t137*t167*t53-4.0d+0
     1         *t119*t120*t138*t53+5.228328d-2*gammabb*t120*t128*t53+4.4
     2         81424d-2*gammabb*t119*t137*t167*t49+1.0456655999999999d-1
     3         *gammabb*t120*t128*t49)+1.3333333333333333d+0*t114*t201)-
     4         4.1839918891199995d-5*t119*t167*t202*t98-6.04354383983999
     5         9d-5*t120*t190*t98-3.73452d-3*t182*t90*t96-1.0d+0*t119*t2
     6         01*t63*t96-1.86726d-3*t196*t59*t96+4.9793599999999993d-3*
     7         t139*t180*t96+6.2242d-3*t129*t130*t96-9.305257363490997d-
     8         1*t127*t194*t63-9.305257363490997d-1*t136*t179*t63+7.4690
     9         4d-3*t119*t120*t129*t140+3.73452d-3*t119*t120*t130*t139+1
     :         .3946639630399998d-5*t120*t122*t138-1.2407009817987995d+0
     ;         *t114*t127*t136)*wght+Mmat3(iq,D3_RB_GBB_TB)
            Mmat3(iq,D3_RA_TA_TA) = (-7.812600694878209d-8*t151*t220*t58
     1         +1.0d+0*t47*t5*(-7.812600694878209d-8*t132*t151*t45*t57+1
     2         .3946639630399998d-5*t108*t132*t57-7.812600694878209d-8*g
     3         ammaaa*t151*t197*t56+2.7893279260799997d-5*t108*t132*t56-
     4         3.125040277951284d-7*t132*t222*t54*t55+8.367983778239999d
     5         -5*t132*t151*t45*t54-3.125040277951284d-7*gammaaa*t197*t2
     6         22*t45*t53+8.367983778239999d-5*t132*t151*t45*t53+4.18399
     7         18891199995d-5*gammaaa*t151*t197*t53-1.4938079999999998d-
     8         2*t108*t132*t53-3.125040277951284d-7*t222*t49*t50/rhoa**1
     9         .2333333333333334d+1+1.673596755648d-4*gammaaa*t151*t197*
     :         t49-1.4938079999999998d-2*t108*t132*t49)-3.73452d-3*t126*
     ;         t198*t52-3.73452d-3*t135*t185*t52-9.305257363490997d-1*t1
     <         31*t183*t5+2.7893279260799997d-5*t108*t125*t199+6.9733198
     =         15199999d-6*t108*t134*t186)*wght+Mmat3(iq,D3_RA_TA_TA)
            Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
            Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
            Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
            Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
            Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
            Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
            Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
            Mmat3(iq,D3_GAA_GBB_TB) = (-7.812600694878209d-8*t167*t227*t
     1         98+1.0d+0*t63*t93*(-3.125040277951284d-7*t137*t229*t54*t9
     2         7-3.125040277951284d-7*t229*t49*t94/rhob**1.2333333333333
     3         334d+1-7.812600694878209d-8*t137*t167*t57*t91+8.367983778
     4         239999d-5*t137*t167*t54*t91-3.125040277951284d-7*gammabb*
     5         t200*t229*t53*t91+8.367983778239999d-5*t137*t167*t53*t91+
     6         1.3946639630399998d-5*t120*t137*t57-7.812600694878209d-8*
     7         gammabb*t167*t200*t56+2.7893279260799997d-5*t120*t137*t56
     8         +4.1839918891199995d-5*gammabb*t167*t200*t53-1.4938079999
     9         999998d-2*t120*t137*t53+1.673596755648d-4*gammabb*t167*t2
     :         00*t49-1.4938079999999998d-2*t120*t137*t49)-3.73452d-3*t1
     ;         30*t201*t96-3.73452d-3*t140*t189*t96-9.305257363490997d-1
     <         *t136*t187*t63+2.7893279260799997d-5*t120*t129*t202+6.973
     =         319815199999d-6*t120*t139*t190)*wght+Mmat3(iq,D3_GAA_GBB_
     >         TB)
            Mmat3(iq,D3_GAB_GAB_TA) = (-1.5625201389756418d-7*t148*t151*
     1         t58+1.0d+0*t47*t5*(-1.5625201389756418d-7*t151*t205*t45*t
     2         57+5.578655852159999d-5*t108*t205*t57+2.7893279260799997d
     3         -5*t108*t205*t56-1.5625201389756418d-7*gammaaa*t151*t204*
     4         t56-6.250080555902569d-7*t205*t222*t54*t55+3.347193511296
     5         d-4*t151*t205*t45*t54-2.9876159999999996d-2*t108*t205*t54
     6         -6.250080555902569d-7*gammaaa*t204*t222*t45*t53+8.3679837
     7         78239999d-5*t151*t205*t45*t53-2.9876159999999996d-2*t108*
     8         t205*t53+1.673596755648d-4*gammaaa*t151*t204*t53-6.250080
     9         555902569d-7*t222*t49*t50/rhoa**1.1333333333333334d+1+1.6
     :         73596755648d-4*gammaaa*t151*t204*t49)-1.86726d-3*t126*t20
     ;         7*t52-7.46904d-3*t135*t198*t52-9.305257363490997d-1*t123*
     <         t203*t5+2.7893279260799997d-5*t108*t125*t209+2.7893279260
     =         799997d-5*t108*t134*t199)*wght+Mmat3(iq,D3_GAB_GAB_TA)
            Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
            Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
            Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
            Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
            Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
            Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
            Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
            Mmat3(iq,D3_GAA_TB_TB) = (-1.5625201389756418d-7*t164*t167*t
     1         98+1.0d+0*t63*t93*(-6.250080555902569d-7*t212*t229*t54*t9
     2         7-6.250080555902569d-7*t229*t49*t94/rhob**1.1333333333333
     3         334d+1-1.5625201389756418d-7*t167*t212*t57*t91+3.34719351
     4         1296d-4*t167*t212*t54*t91-6.250080555902569d-7*gammabb*t2
     5         11*t229*t53*t91+8.367983778239999d-5*t167*t212*t53*t91+5.
     6         578655852159999d-5*t120*t212*t57+2.7893279260799997d-5*t1
     7         20*t212*t56-1.5625201389756418d-7*gammabb*t167*t211*t56-2
     8         .9876159999999996d-2*t120*t212*t54-2.9876159999999996d-2*
     9         t120*t212*t53+1.673596755648d-4*gammabb*t167*t211*t53+1.6
     :         73596755648d-4*gammabb*t167*t211*t49)-1.86726d-3*t130*t21
     ;         4*t96-7.46904d-3*t140*t201*t96-9.305257363490997d-1*t127*
     <         t210*t63+2.7893279260799997d-5*t120*t129*t216+2.789327926
     =         0799997d-5*t120*t139*t202)*wght+Mmat3(iq,D3_GAA_TB_TB)
            Mmat3(iq,D3_GAB_TA_TA) = (-9.305257363490997d-1*t4*t5*(-1.37
     1         28d+4*t11*t217*t7-7.92d+3*t13*t21*t7-2.904d+4*t100*t18*t7
     2         -3.4848d+4*t141*t15*t7-4.8d+1*t37*t41-4.8d+1*t10*t34*t41-
     3         1.92d+2*t31*t38*t39-8.64d+2*t31*t35*t39-1.152d+3*t31*t32*
     4         t39-4.8d+2*t29*t31*t39-9.6d+1*t37*t38-2.88d+2*t10*t34*t38
     5         -4.8d+1*t35*t37-4.8d+2*t28*t35*t36-1.92d+3*t28*t32*t36-2.
     6         4d+3*t28*t29*t36-9.6d+2*t26*t28*t36-4.32d+2*t10*t34*t35-1
     7         .92d+2*t10*t32*t34-9.6d+2*t25*t32*t33-3.6d+3*t25*t29*t33-
     8         4.32d+3*t25*t26*t33-1.68d+3*t23*t25*t33-1.68d+3*t22*t29*t
     9         30-6.048d+3*t22*t26*t30-7.056d+3*t22*t23*t30-2.688d+3*t20
     :         *t22*t30-2.688d+3*t19*t26*t27-9.408d+3*t19*t23*t27-1.0752
     ;         d+4*t19*t20*t27-4.032d+3*t17*t19*t27-4.032d+3*t16*t23*t24
     <         -1.3824d+4*t16*t20*t24-1.5552d+4*t16*t17*t24-5.76d+3*t14*
     =         t16*t24-5.76d+3*t13*t20*t21-1.944d+4*t13*t17*t21-2.16d+4*
     >         t13*t14*t21-7.92d+3*t100*t17*t18-2.64d+4*t100*t14*t18-1.0
     ?         56d+4*t14*t141*t15)-3.1250402779512837d-7*t105*t151*t58+1
     @         .0d+0*t47*t5*(-3.1250402779512837d-7*t151*t232*t45*t57+1.
     1         6735967556479997d-4*t108*t232*t57-3.1250402779512837d-7*g
     2         ammaaa*t151*t235*t56-1.2500161111805136d-6*t222*t232*t54*
     3         t55+1.0041580533887999d-3*t151*t232*t45*t54-1.7925696d-1*
     4         t108*t232*t54-1.2500161111805136d-6*gammaaa*t222*t235*t45
     5         *t53+5.020790266944d-4*gammaaa*t151*t235*t53-1.2500161111
     6         805136d-6*t222*t49*t50/rhoa**1.0333333333333333d+1)-1.120
     7         356d-2*t135*t207*t52+8.367983778239998d-5*t108*t134*t209)
     8         *wght+Mmat3(iq,D3_GAB_TA_TA)
            Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
            Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
            Mmat3(iq,D3_GBB_TA_TA) = (-3.1250402779512837d-7*t117*t167*t
     1         98+1.0d+0*t63*t93*(-1.2500161111805136d-6*t229*t234*t54*t
     2         97-1.2500161111805136d-6*t229*t49*t94/rhob**1.03333333333
     3         33333d+1-3.1250402779512837d-7*t167*t234*t57*t91+1.004158
     4         0533887999d-3*t167*t234*t54*t91-1.2500161111805136d-6*gam
     5         mabb*t229*t236*t53*t91+1.6735967556479997d-4*t120*t234*t5
     6         7-3.1250402779512837d-7*gammabb*t167*t236*t56-1.7925696d-
     7         1*t120*t234*t54+5.020790266944d-4*gammabb*t167*t236*t53)-
     8         1.120356d-2*t140*t214*t96-9.305257363490997d-1*t62*t63*(-
     9         1.92d+2*t38*t81*t86-8.64d+2*t35*t81*t86-1.152d+3*t32*t81*
     :         t86-4.8d+2*t29*t81*t86-4.8d+1*t41*t85-9.6d+1*t38*t85-4.8d
     ;         +1*t35*t85-4.8d+2*t35*t79*t84-1.92d+3*t32*t79*t84-2.4d+3*
     <         t29*t79*t84-9.6d+2*t26*t79*t84-4.8d+1*t41*t66*t83-2.88d+2
     =         *t38*t66*t83-4.32d+2*t35*t66*t83-1.92d+2*t32*t66*t83-9.6d
     >         +2*t32*t77*t82-3.6d+3*t29*t77*t82-4.32d+3*t26*t77*t82-1.6
     ?         8d+3*t23*t77*t82-1.68d+3*t29*t75*t80-6.048d+3*t26*t75*t80
     @         -7.056d+3*t23*t75*t80-2.688d+3*t20*t75*t80-2.688d+3*t26*t
     1         73*t78-9.408d+3*t23*t73*t78-1.0752d+4*t20*t73*t78-4.032d+
     2         3*t17*t73*t78-4.032d+3*t23*t71*t76-1.3824d+4*t20*t71*t76-
     3         1.5552d+4*t17*t71*t76-5.76d+3*t14*t71*t76-7.92d+3*t69*t7*
     4         t74-5.76d+3*t20*t69*t74-1.944d+4*t17*t69*t74-2.16d+4*t14*
     5         t69*t74-2.904d+4*t112*t7*t72-7.92d+3*t112*t17*t72-2.64d+4
     6         *t112*t14*t72-3.4848d+4*t157*t7*t70-1.056d+4*t14*t157*t70
     7         -1.3728d+4*t224*t67*t7)+8.367983778239998d-5*t120*t139*t2
     8         16)*wght+Mmat3(iq,D3_GBB_TA_TA)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammaaa*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammaaa*t1*t3+1.0d+0
            t5 = rhoa**1.3333333333333333d+0
            t6 = param(18)
            t7 = rhoa**1.6666666666666669d+0
            t8 = 9.115599744691192d+0*t7
            t9 = t8-2.0d+0*taua
            t10 = t9**11
            t11 = 2.0d+0*taua+t8
            t12 = 1/t11**11
            t13 = param(17)
            t14 = t9**10
            t15 = 1/t11**10
            t16 = param(16)
            t17 = t9**9
            t18 = 1/t11**9
            t19 = param(15)
            t20 = t9**8
            t21 = 1/t11**8
            t22 = param(14)
            t23 = t9**7
            t24 = 1/t11**7
            t25 = param(13)
            t26 = t9**6
            t27 = 1/t11**6
            t28 = param(12)
            t29 = t9**5
            t30 = 1/t11**5
            t31 = param(11)
            t32 = t9**4
            t33 = 1/t11**4
            t34 = param(10)
            t35 = t9**3
            t36 = 1/t11**3
            t37 = param(9)
            t38 = t9**2
            t39 = 1/t11**2
            t40 = param(8)
            t41 = 1/t11
            t42 = t40*t41*t9+t10*t12*t6+t37*t38*t39+t34*t35*t36+t31*t32*
     1         t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19*t20*t21+t16*t
     2         17*t18+t13*t14*t15+param(7)
            t43 = 1/t7
            t44 = 2.0d+0*t43*taua-9.11559972d+0
            t45 = 1.86726d-3*t44+1.86726d-3*gammaaa*t1+1.0d+0
            t46 = 1/t45
            t47 = param(4)
            t48 = gammaaa**2
            t49 = 1/rhoa**5.333333333333333d+0
            t50 = 1/t45**2
            t51 = param(5)
            t52 = param(6)
            t53 = t44**2
            t54 = param(2)
            t55 = param(3)
            t56 = t44*t46*t55+gammaaa*t1*t46*t54+t50*t52*t53+gammaaa*t1*
     1         t44*t50*t51+t47*t48*t49*t50+param(1)
            t57 = rhoa**6.666666666666666d-1
            t58 = 1/t11**12
            t59 = -1.5192666241151986d+1*t39*t40*t57*t9+3.03853324823039
     1         7d+1*t37*t39*t57*t9-1.6711932865267184d+2*t10*t57*t58*t6+
     2         1.6711932865267184d+2*t12*t14*t57*t6+1.5192666241151986d+
     3         1*t40*t41*t57-3.038533248230397d+1*t36*t37*t38*t57+4.5577
     4         998723455965d+1*t34*t36*t38*t57-4.5577998723455965d+1*t33
     5         *t34*t35*t57+6.077066496460795d+1*t31*t33*t35*t57-6.07706
     6         6496460795d+1*t30*t31*t32*t57+7.596333120575993d+1*t28*t3
     7         0*t32*t57-7.596333120575993d+1*t27*t28*t29*t57+9.11559974
     8         4691193d+1*t25*t27*t29*t57-9.115599744691193d+1*t24*t25*t
     9         26*t57+1.0634866368806391d+2*t22*t24*t26*t57-1.0634866368
     :         806391d+2*t21*t22*t23*t57+1.2154132992921589d+2*t19*t21*t
     ;         23*t57-1.2154132992921589d+2*t18*t19*t20*t57+1.3673399617
     <         036788d+2*t16*t18*t20*t57-1.3673399617036788d+2*t15*t16*t
     =         17*t57+1.5192666241151986d+2*t13*t15*t17*t57-1.5192666241
     >         151986d+2*t12*t13*t14*t57
            t60 = rhoa**3.333333333333333d-1
            t61 = 1/t2**2
            t62 = 1/rhoa**6.333333333333333d+0
            t63 = 1/rhoa**3.6666666666666664d+0
            t64 = 4.327658698487368d-5*t48*t61*t62-9.632497209735863d-3*
     1         gammaaa*t3*t63
            t65 = -6.2242d-3*t1*taua-4.9793599999999993d-3*gammaaa*t63
            t66 = 1/t45**3
            t67 = -3.3333333333333337d+0*t1*t46*t55*taua-6.6666666666666
     1         67d+0*t1*t44*t50*t52*taua-3.3333333333333337d+0*gammaaa*t
     2         49*t50*t51*taua-2*t52*t53*t65*t66-2*gammaaa*t1*t44*t51*t6
     3         5*t66-2*t47*t48*t49*t65*t66-t44*t50*t55*t65-gammaaa*t1*t5
     4         0*t54*t65-2.6666666666666666d+0*gammaaa*t46*t54*t63-2.666
     5         6666666666666d+0*gammaaa*t44*t50*t51*t63-5.33333333333333
     6         3d+0*t47*t48*t50*t62
            t68 = 1.0d+0*t5*t67+1.3333333333333333d+0*t56*t60
            t69 = 3.6121864536509485d-3*t1*t3-1.6228720119327628d-5*gamm
     1         aaa*t49*t61
            t70 = 1/rhoa**8
            t71 = -3.73452d-3*t47*t48*t66*t70-3.73452d-3*t1*t52*t53*t66-
     1         3.73452d-3*gammaaa*t44*t49*t51*t66-1.86726d-3*t1*t44*t50*
     2         t55-1.86726d-3*gammaaa*t49*t50*t54+t1*t46*t54+t1*t44*t50*
     3         t51+2*gammaaa*t47*t49*t50
            t72 = 1/t5
            t73 = -2.0d+0*t39*t40*t9-4.0d+0*t37*t39*t9-2.2d+1*t10*t58*t6
     1         -2.2d+1*t12*t14*t6-2.0d+0*t40*t41-4.0d+0*t36*t37*t38-6.0d
     2         +0*t34*t36*t38-6.0d+0*t33*t34*t35-8.0d+0*t31*t33*t35-8.0d
     3         +0*t30*t31*t32-1.0d+1*t28*t30*t32-1.0d+1*t27*t28*t29-1.2d
     4         +1*t25*t27*t29-1.2d+1*t24*t25*t26-1.4d+1*t22*t24*t26-1.4d
     5         +1*t21*t22*t23-1.6d+1*t19*t21*t23-1.6d+1*t18*t19*t20-1.8d
     6         +1*t16*t18*t20-1.8d+1*t15*t16*t17-2.0d+1*t13*t15*t17-2.0d
     7         +1*t12*t13*t14
            t74 = 1/rhoa**7
            t75 = 1/rhoa**4.333333333333333d+0
            t76 = -7.46904d-3*gammaaa*t44*t51*t66*t75-3.73452d-3*gammaaa
     1         *t50*t54*t75+2.0d+0*gammaaa*t50*t51*t75-7.46904d-3*t47*t4
     2         8*t66*t74-7.46904d-3*t43*t52*t53*t66-3.73452d-3*t43*t44*t
     3         50*t55+2.0d+0*t43*t46*t55+4.0d+0*t43*t44*t50*t52
            t77 = 1/t60
            t78 = 1/t11**13
            t79 = -1.0128444160767991d+1*t39*t40*t77*t9+2.02568883215359
     1         82d+1*t37*t39*t77*t9+4.6163421503007845d+2*t36*t40*t5*t9-
     2         1.846536860120314d+3*t36*t37*t5*t9+1.3849026450902355d+3*
     3         t34*t36*t5*t9+3.046785819198518d+4*t10*t5*t6*t78-1.114128
     4         8576844789d+2*t10*t58*t6*t77+1.1141288576844789d+2*t12*t1
     5         4*t6*t77+1.0128444160767991d+1*t40*t41*t77-2.025688832153
     6         5982d+1*t36*t37*t38*t77+3.038533248230397d+1*t34*t36*t38*
     7         t77-3.038533248230397d+1*t33*t34*t35*t77+4.05137766430719
     8         64d+1*t31*t33*t35*t77-4.0513776643071964d+1*t30*t31*t32*t
     9         77+5.064222080383994d+1*t28*t30*t32*t77-5.064222080383994
     :         d+1*t27*t28*t29*t77+6.077066496460795d+1*t25*t27*t29*t77-
     ;         6.077066496460795d+1*t24*t25*t26*t77+7.089910912537593d+1
     <         *t22*t24*t26*t77-7.089910912537593d+1*t21*t22*t23*t77+8.1
     =         02755328614393d+1*t19*t21*t23*t77-8.102755328614393d+1*t1
     >         8*t19*t20*t77+9.115599744691191d+1*t16*t18*t20*t77-9.1155
     ?         99744691191d+1*t15*t16*t17*t77+1.012844416076799d+2*t13*t
     @         15*t17*t77-1.012844416076799d+2*t12*t13*t14*t77-5.5857740
     1         01863949d+4*t14*t5*t58*t6+2.5389881826654315d+4*t12*t17*t
     2         5*t6+2.5389881826654315d+4*t13*t14*t5*t58-4.6163421503007
     3         845d+2*t39*t40*t5+4.6163421503007845d+2*t37*t39*t5+1.3849
     4         026450902355d+3*t33*t37*t38*t5-4.1547079352707067d+3*t33*
     5         t34*t38*t5+2.769805290180471d+3*t31*t33*t38*t5+2.76980529
     6         0180471d+3*t30*t34*t35*t5-7.386147440481255d+3*t30*t31*t3
     7         5*t5+4.616342150300784d+3*t28*t30*t35*t5+4.61634215030078
     8         4d+3*t27*t31*t32*t5-1.154085537575196d+4*t27*t28*t32*t5+6
     9         .924513225451178d+3*t25*t27*t32*t5+6.924513225451178d+3*t
     :         24*t28*t29*t5-1.661883174108283d+4*t24*t25*t29*t5+9.69431
     ;         8515631648d+3*t22*t24*t29*t5+9.694318515631648d+3*t21*t25
     <         *t26*t5-2.2620076536473846d+4*t21*t22*t26*t5+1.2925758020
     =         842196d+4*t19*t21*t26*t5+1.2925758020842196d+4*t18*t22*t2
     >         3*t5-2.954458976192502d+4*t18*t19*t23*t5+1.66188317410828
     ?         23d+4*t16*t18*t23*t5+1.6618831741082823d+4*t15*t19*t20*t5
     @         -3.7392371417436354d+4*t15*t16*t20*t5+2.0773539676353528d
     1         +4*t13*t15*t20*t5+2.0773539676353528d+4*t12*t16*t17*t5-4.
     2         616342150300784d+4*t12*t13*t17*t5
            t80 = 1/t57
            t81 = gammaaa**3
            t82 = 1/t2**3
            t83 = 1/rhoa**10
            t84 = 1/rhoa**7.333333333333333d+0
            t85 = 1/rhoa**4.666666666666667d+0
            t86 = 3.531915643569816d-2*gammaaa*t3*t85-3.8948928286386303
     1         d-4*t48*t61*t84+1.0369691626335495d-6*t81*t82*t83
            t87 = t65**2
            t88 = 1/t45**4
            t89 = 1.6597866666666666d-2*t63*taua+1.8257653333333332d-2*g
     1         ammaaa*t85
            t90 = taua**2
            t91 = 2.6666666666666666d+1*t1*t44*t52*t65*t66*taua+1.333333
     1         3333333333d+1*gammaaa*t49*t51*t65*t66*taua+6.666666666666
     2         667d+0*t1*t50*t55*t65*taua+8.88888888888889d+0*t46*t55*t6
     3         3*taua+1.7777777777777778d+1*t44*t50*t52*t63*taua+2.66666
     4         66666666666d+1*gammaaa*t50*t51*t62*taua+2.222222222222222
     5         4d+1*t49*t50*t52*t90-2*t52*t53*t66*t89-2*gammaaa*t1*t44*t
     6         51*t66*t89-2*t47*t48*t49*t66*t89-t44*t50*t55*t89-gammaaa*
     7         t1*t50*t54*t89+6*t52*t53*t87*t88+6*gammaaa*t1*t44*t51*t87
     8         *t88+6*t47*t48*t49*t87*t88+2*t44*t55*t66*t87+2*gammaaa*t1
     9         *t54*t66*t87+9.777777777777779d+0*gammaaa*t46*t54*t85+9.7
     :         77777777777779d+0*gammaaa*t44*t50*t51*t85+3.3777777777777
     ;         78d+1*t47*t48*t50*t84+1.0666666666666666d+1*gammaaa*t44*t
     <         51*t63*t65*t66+2.1333333333333332d+1*t47*t48*t62*t65*t66+
     =         5.333333333333333d+0*gammaaa*t50*t54*t63*t65
            t92 = 1.0d+0*t5*t91+4.444444444444444d-1*t56*t80+2.666666666
     1         6666666d+0*t60*t67
            t93 = -1.0d+0*t5*t56*t89-t65*t68-1.0d+0*t5*t65*t67-1.3333333
     1         333333333d+0*t56*t60*t65
            t94 = 1/rhoa**9
            t95 = -3.8886343598758105d-7*t48*t82*t94-9.632497209735863d-
     1         3*t3*t63+1.29829760954621d-4*gammaaa*t61*t62
            t96 = 1/rhoa**2.3333333333333334d+0
            t97 = 1.24484d-2*gammaaa*t51*t66*t70*taua+2.48968d-2*t44*t49
     1         *t52*t66*taua+6.2242d-3*t49*t50*t55*taua-3.33333333333333
     2         37d+0*t49*t50*t51*taua+2.9876159999999996d-2*t47*t48*t66*
     3         t94+1.120356d-2*t47*t48*t65*t70*t88+1.120356d-2*t1*t52*t5
     4         3*t65*t88+1.120356d-2*gammaaa*t44*t49*t51*t65*t88+3.73452
     5         d-3*t1*t44*t55*t65*t66+3.73452d-3*gammaaa*t49*t54*t65*t66
     6         -2*t1*t44*t51*t65*t66-4*gammaaa*t47*t49*t65*t66+9.9587199
     7         99999999d-3*t52*t53*t63*t66+1.9917439999999997d-2*gammaaa
     8         *t44*t51*t62*t66-t1*t50*t54*t65+4.9793599999999993d-3*t44
     9         *t50*t55*t63-2.6666666666666666d+0*t46*t54*t63-2.66666666
     :         66666666d+0*t44*t50*t51*t63+9.958719999999999d-3*gammaaa*
     ;         t50*t54*t62-1.0666666666666666d+1*gammaaa*t47*t50*t62
            t98 = 1.0d+0*t5*t97+1.3333333333333333d+0*t60*t71
            t99 = 1.4582378849534292d-7*gammaaa*t70*t82-3.24574402386552
     1         55d-5*t49*t61
            t100 = 1/rhoa**1.0666666666666666d+1
            t101 = 2.0919959445599998d-5*gammaaa*t44*t51*t70*t88+2.09199
     1         59445599998d-5*t49*t52*t53*t88+2.0919959445599998d-5*t100
     2         *t47*t48*t88+6.973319815199999d-6*gammaaa*t54*t66*t70-1.4
     3         938079999999998d-2*gammaaa*t47*t66*t70+6.973319815199999d
     4         -6*t44*t49*t55*t66-7.46904d-3*t44*t49*t51*t66-3.73452d-3*
     5         t49*t50*t54+2*t47*t49*t50
            t102 = 1/rhoa**4
            t103 = 6.077066496460795d+1*t36*t40*t57*t9-1.823119948938238
     1         5d+2*t34*t36*t57*t9+4.0108638876641245d+3*t10*t57*t6*t78-
     2         3.342386573053437d+3*t12*t17*t57*t6+3.342386573053437d+3*
     3         t13*t14*t57*t58-6.077066496460795d+1*t37*t39*t57+1.823119
     4         9489382385d+2*t33*t37*t38*t57-3.646239897876477d+2*t31*t3
     5         3*t38*t57+3.646239897876477d+2*t30*t34*t35*t57-6.07706649
     6         6460795d+2*t28*t30*t35*t57+6.077066496460795d+2*t27*t31*t
     7         32*t57-9.115599744691192d+2*t25*t27*t32*t57+9.11559974469
     8         1192d+2*t24*t28*t29*t57-1.276183964256767d+3*t22*t24*t29*
     9         t57+1.276183964256767d+3*t21*t25*t26*t57-1.70157861900902
     :         26d+3*t19*t21*t26*t57+1.7015786190090226d+3*t18*t22*t23*t
     ;         57-2.187743938725886d+3*t16*t18*t23*t57+2.187743938725886
     <         d+3*t15*t19*t20*t57-2.734679923407357d+3*t13*t15*t20*t57+
     =         2.734679923407357d+3*t12*t16*t17*t57
            t104 = 4.97936d-2*t44*t52*t66*t75*taua+1.24484d-2*t50*t55*t7
     1         5*taua-1.3333333333333333d+1*t50*t52*t75*taua+2.48968d-2*
     2         gammaaa*t51*t66*t74*taua+2.240712d-2*gammaaa*t44*t51*t65*
     3         t75*t88+2.240712d-2*t47*t48*t65*t74*t88+2.240712d-2*t43*t
     4         52*t53*t65*t88+7.46904d-3*gammaaa*t54*t65*t66*t75-4.0d+0*
     5         gammaaa*t51*t65*t66*t75+5.228328d-2*t47*t48*t66*t70+7.469
     6         04d-3*t43*t44*t55*t65*t66-8.0d+0*t43*t44*t52*t65*t66+1.24
     7         484d-2*t1*t52*t53*t66+3.236584d-2*gammaaa*t44*t49*t51*t66
     8         -2.0d+0*t43*t50*t55*t65+6.2242d-3*t1*t44*t50*t55-3.333333
     9         3333333337d+0*t1*t46*t55+1.618292d-2*gammaaa*t49*t50*t54-
     :         6.666666666666667d+0*t1*t44*t50*t52-8.666666666666666d+0*
     ;         gammaaa*t49*t50*t51
            t105 = 1.3333333333333333d+0*t60*t76+1.0d+0*t104*t5
            t106 = 1/rhoa**9.666666666666666d+0
            t107 = 4.1839918891199995d-5*t52*t53*t75*t88+4.1839918891199
     1         995d-5*gammaaa*t44*t51*t74*t88+4.1839918891199995d-5*t106
     2         *t47*t48*t88+1.3946639630399998d-5*t44*t55*t66*t75-1.4938
     3         079999999998d-2*t44*t52*t66*t75-7.46904d-3*t44*t51*t66*t7
     4         5-3.73452d-3*t50*t55*t75-3.73452d-3*t50*t54*t75+2.0d+0*t5
     5         0*t51*t75+1.3946639630399998d-5*gammaaa*t54*t66*t74-7.469
     6         04d-3*gammaaa*t51*t66*t74-1.4938079999999998d-2*gammaaa*t
     7         47*t66*t74
            t108 = 1/rhoa**3
            t109 = 8.0d+0*t36*t40*t9+3.2d+1*t36*t37*t9+2.4d+1*t34*t36*t9
     1         +5.28d+2*t10*t6*t78+9.68d+2*t14*t58*t6+4.4d+2*t12*t17*t6+
     2         4.4d+2*t13*t14*t58+8.0d+0*t39*t40+8.0d+0*t37*t39+2.4d+1*t
     3         33*t37*t38+7.2d+1*t33*t34*t38+4.8d+1*t31*t33*t38+4.8d+1*t
     4         30*t34*t35+1.28d+2*t30*t31*t35+8.0d+1*t28*t30*t35+8.0d+1*
     5         t27*t31*t32+2.0d+2*t27*t28*t32+1.2d+2*t25*t27*t32+1.2d+2*
     6         t24*t28*t29+2.88d+2*t24*t25*t29+1.68d+2*t22*t24*t29+1.68d
     7         +2*t21*t25*t26+3.92d+2*t21*t22*t26+2.24d+2*t19*t21*t26+2.
     8         24d+2*t18*t22*t23+5.12d+2*t18*t19*t23+2.88d+2*t16*t18*t23
     9         +2.88d+2*t15*t19*t20+6.48d+2*t15*t16*t20+3.6d+2*t13*t15*t
     :         20+3.6d+2*t12*t16*t17+8.0d+2*t12*t13*t17
            t110 = 1/rhoa**8.666666666666666d+0
            t111 = 1/rhoa**6
            t112 = 1/rhoa**3.3333333333333337d+0
            t113 = 8.367983778239999d-5*t112*t52*t53*t88+8.3679837782399
     1         99d-5*gammaaa*t111*t44*t51*t88+8.367983778239999d-5*t110*
     2         t47*t48*t88+2.7893279260799997d-5*t112*t44*t55*t66+2.7893
     3         279260799997d-5*gammaaa*t111*t54*t66-5.975231999999999d-2
     4         *t112*t44*t52*t66-2.9876159999999996d-2*gammaaa*t111*t51*
     5         t66-1.4938079999999998d-2*t112*t50*t55+8.0d+0*t112*t50*t5
     6         2
            t114 = rhoa**2
            t115 = 1/t114
            t116 = 1/t11**14
            t117 = 1/t2**4
            t118 = 1/rhoa**8.333333333333334d+0
            t119 = 1/rhoa**5.666666666666667d+0
            t120 = t65**3
            t121 = 1/t45**5
            t122 = -6.085884444444444d-2*t85*taua-8.520238222222222d-2*g
     1         ammaaa*t119
            t123 = 1/rhoa**1.1666666666666665d+1
            t124 = 1/rhoa**5
            t125 = 1/rhoa**7.666666666666667d+0
            fnc(iq) = (1.0d+0*t46*t5*t56-9.305257363490997d-1*t4*t42*t5)
     1         *wght+fnc(iq)
            Amat(iq,D1_RA) = (t46*t68-1.0d+0*t5*t50*t56*t65-9.3052573634
     1         90997d-1*t42*t5*t64-1.2407009817987995d+0*t4*t42*t60-9.30
     2         5257363490997d-1*t4*t5*t59)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (-1.86726d-3*t50*t56*t72+1.0d+0*t46*t5*t71
     1         -9.305257363490997d-1*t42*t5*t69)*wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = (-3.73452d-3*t50*t56*t77+1.0d+0*t46*t5*t76-
     1         9.305257363490997d-1*t4*t5*t73)*wght+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = (t50*t93+t46*t92+2.0d+0*t5*t56*t66*t87-
     1         9.305257363490997d-1*t42*t5*t86-4.1356699393293317d-1*t4*
     2         t42*t80-9.305257363490997d-1*t4*t5*t79-2.481401963597599d
     3         +0*t42*t60*t64-1.8610514726981994d+0*t5*t59*t64-2.4814019
     4         63597599d+0*t4*t59*t60)*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = (t46*t98+4.9793599999999993d-3*t50*t56
     1         *t96-9.305257363490997d-1*t42*t5*t95+3.73452d-3*t56*t65*t
     2         66*t72-1.0d+0*t5*t50*t65*t71-1.2407009817987995d+0*t42*t6
     3         0*t69-9.305257363490997d-1*t5*t59*t69-1.86726d-3*t1*t50*t
     4         68)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = (-9.305257363490997d-1*t42*t5*t99-3.7
     1         3452d-3*t50*t71*t72+6.973319815199999d-6*t102*t56*t66+1.0
     2         d+0*t101*t46*t5)*wght+Cmat2(iq,D2_GAA_GAA)
            Mmat2(iq,D2_RA_TA) = (7.46904d-3*t56*t65*t66*t77-1.0d+0*t5*t
     1         50*t65*t76-9.305257363490997d-1*t5*t64*t73-1.240700981798
     2         7995d+0*t4*t60*t73+6.2242d-3*t50*t56*t72-3.73452d-3*t43*t
     3         50*t68-9.305257363490997d-1*t103*t4*t5+t105*t46)*wght+Mma
     4         t2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = (-3.73452d-3*t50*t71*t77-1.86726d-3*t5
     1         0*t72*t76-9.305257363490997d-1*t5*t69*t73+1.3946639630399
     2         998d-5*t108*t56*t66+1.0d+0*t107*t46*t5)*wght+Mmat2(iq,D2_
     3         GAA_TA)
            Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_TA_TA) = (-7.46904d-3*t50*t76*t77+2.789327926079
     1         9997d-5*t115*t56*t66+1.0d+0*t113*t46*t5-9.305257363490997
     2         d-1*t109*t4*t5)*wght+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RA_RA_RA) = (t46*(1.0d+0*t5*(4.0d+1*t1*t44*t52*t
     1         66*t89*taua+2.0d+1*gammaaa*t49*t51*t66*t89*taua+1.0d+1*t1
     2         *t50*t55*t89*taua-1.2d+2*t1*t44*t52*t87*t88*taua-6.0d+1*g
     3         ammaaa*t49*t51*t87*t88*taua-2.0d+1*t1*t55*t66*t87*taua-3.
     4         2592592592592595d+1*t46*t55*t85*taua-6.518518518518519d+1
     5         *t44*t50*t52*t85*taua-2.0148148148148146d+2*gammaaa*t50*t
     6         51*t84*taua-1.0666666666666667d+2*t44*t52*t63*t65*t66*tau
     7         a-1.6d+2*gammaaa*t51*t62*t65*t66*taua-2.6666666666666666d
     8         +1*t50*t55*t63*t65*taua-1.3333333333333333d+2*t49*t52*t65
     9         *t66*t90-1.777777777777778d+2*t50*t52*t62*t90+18*t52*t53*
     :         t65*t88*t89+18*gammaaa*t1*t44*t51*t65*t88*t89+18*t47*t48*
     ;         t49*t65*t88*t89+6*t44*t55*t65*t66*t89+6*gammaaa*t1*t54*t6
     <         5*t66*t89+16*gammaaa*t44*t51*t63*t66*t89+32*t47*t48*t62*t
     =         66*t89+8*gammaaa*t50*t54*t63*t89-48*gammaaa*t44*t51*t63*t
     >         87*t88-96*t47*t48*t62*t87*t88-6*t120*t44*t55*t88-6*gammaa
     ?         a*t1*t120*t54*t88-16*gammaaa*t54*t63*t66*t87-5.8666666666
     @         66667d+1*gammaaa*t44*t51*t65*t66*t85-2.9333333333333333d+
     1         1*gammaaa*t50*t54*t65*t85-2.0266666666666666d+2*t47*t48*t
     2         65*t66*t84-2*t122*t52*t53*t66-2*gammaaa*t1*t122*t44*t51*t
     3         66-2*t122*t47*t48*t49*t66-t122*t44*t50*t55-gammaaa*t1*t12
     4         2*t50*t54-4.5629629629629626d+1*gammaaa*t119*t46*t54-24*t
     5         120*t121*t52*t53-4.5629629629629626d+1*gammaaa*t119*t44*t
     6         50*t51-24*gammaaa*t1*t120*t121*t44*t51-2.477037037037037d
     7         +2*t118*t47*t48*t50-24*t120*t121*t47*t48*t49)+4.0d+0*t60*
     8         t91+1.3333333333333333d+0*t67*t80-2.962962962962963d-1*t4
     9         3*t56)+t66*(-2*t65*t93+4.0d+0*t5*t56*t65*t89+2.0d+0*t5*t6
     :         7*t87+2.6666666666666666d+0*t56*t60*t87)+t50*(-2*t65*t92-
     ;         1.0d+0*t5*t65*t91-t68*t89-2.0d+0*t5*t67*t89-2.66666666666
     <         66666d+0*t56*t60*t89-4.444444444444444d-1*t56*t65*t80-2.6
     =         666666666666666d+0*t60*t65*t67-1.0d+0*t122*t5*t56)-9.3052
     >         57363490997d-1*t4*t5*(3.37614805358933d+0*t39*t40*t72*t9-
     ?         6.75229610717866d+0*t37*t39*t72*t9+9.232684300601568d+2*t
     @         36*t40*t60*t9-3.693073720240627d+3*t36*t37*t60*t9+2.76980
     1         5290180471d+3*t34*t36*t60*t9-2.104036366334451d+4*t114*t3
     2         3*t40*t9+1.2624218198006704d+5*t114*t33*t37*t9-1.89363272
     3         97010064d+5*t114*t33*t34*t9+8.416145465337804d+4*t114*t31
     4         *t33*t9+6.093571638397036d+4*t10*t6*t60*t78+1.52753040195
     5         88112d+7*t114*t14*t6*t78-4.628880005935792d+6*t114*t13*t1
     6         4*t78+3.713762858948263d+1*t10*t58*t6*t72-3.7137628589482
     7         63d+1*t12*t14*t6*t72-3.37614805358933d+0*t40*t41*t72+6.75
     8         229610717866d+0*t36*t37*t38*t72-1.0128444160767991d+1*t34
     9         *t36*t38*t72+1.0128444160767991d+1*t33*t34*t35*t72-1.3504
     :         59221435732d+1*t31*t33*t35*t72+1.350459221435732d+1*t30*t
     ;         31*t32*t72-1.6880740267946648d+1*t28*t30*t32*t72+1.688074
     <         0267946648d+1*t27*t28*t29*t72-2.0256888321535982d+1*t25*t
     =         27*t29*t72+2.0256888321535982d+1*t24*t25*t26*t72-2.363303
     >         6375125308d+1*t22*t24*t26*t72+2.3633036375125308d+1*t21*t
     ?         22*t23*t72-2.700918442871464d+1*t19*t21*t23*t72+2.7009184
     @         42871464d+1*t18*t19*t20*t72-3.0385332482303967d+1*t16*t18
     1         *t20*t72+3.0385332482303967d+1*t15*t16*t17*t72-3.37614805
     2         35893296d+1*t13*t15*t17*t72+3.3761480535893296d+1*t12*t13
     3         *t14*t72-1.1171548003727898d+5*t14*t58*t6*t60+5.077976365
     4         330863d+4*t12*t17*t6*t60+5.077976365330862d+4*t13*t14*t58
     5         *t60-9.232684300601568d+2*t39*t40*t60+9.232684300601568d+
     6         2*t37*t39*t60+2.769805290180471d+3*t33*t37*t38*t60-8.3094
     7         15870541413d+3*t33*t34*t38*t60+5.539610580360942d+3*t31*t
     8         33*t38*t60+5.539610580360942d+3*t30*t34*t35*t60-1.4772294
     9         880962508d+4*t30*t31*t35*t60+9.232684300601568d+3*t28*t30
     :         *t35*t60+9.232684300601568d+3*t27*t31*t32*t60-2.308171075
     ;         150392d+4*t27*t28*t32*t60+1.3849026450902355d+4*t25*t27*t
     <         32*t60+1.3849026450902355d+4*t24*t28*t29*t60-3.3237663482
     =         16566d+4*t24*t25*t29*t60+1.9388637031263292d+4*t22*t24*t2
     >         9*t60+1.9388637031263292d+4*t21*t25*t26*t60-4.52401530729
     ?         47686d+4*t21*t22*t26*t60+2.585151604168439d+4*t19*t21*t26
     @         *t60+2.585151604168439d+4*t18*t22*t23*t60-5.9089179523850
     1         03d+4*t18*t19*t23*t60+3.3237663482165647d+4*t16*t18*t23*t
     2         60+3.3237663482165647d+4*t15*t19*t20*t60-7.47847428348727
     3         1d+4*t15*t16*t20*t60+4.154707935270705d+4*t13*t15*t20*t60
     4         +4.1547079352707056d+4*t12*t16*t17*t60-9.232684300601568d
     5         +4*t12*t13*t17*t60-1.2729420016323426d+7*t114*t17*t58*t6+
     6         3.4716600044518436d+6*t114*t12*t20*t6-6.01754400771653d+6
     7         *t10*t114*t116*t6-3.4716600044518436d+6*t114*t16*t17*t58+
     8         1.1572200014839477d+7*t114*t13*t17*t58+2.104036366334451d
     9         +4*t114*t36*t40-8.416145465337804d+4*t114*t30*t37*t38+3.7
     :         87265459402013d+5*t114*t30*t34*t38-5.049687279202681d+5*t
     ;         114*t30*t31*t38+2.1040363663344508d+5*t114*t28*t30*t38-4.
     <         208072732668902d+4*t114*t36*t37+2.104036366334451d+4*t114
     =         *t34*t36-2.104036366334451d+5*t114*t27*t34*t35+8.41614546
     >         5337803d+5*t114*t27*t31*t35-1.0520181831672254d+6*t114*t2
     ?         7*t28*t35+4.208072732668902d+5*t114*t25*t27*t35-4.2080727
     @         326689016d+5*t114*t24*t31*t32+1.578027274750838d+6*t114*t
     1         24*t28*t32-1.893632729701006d+6*t114*t24*t25*t32+7.364127
     2         282170578d+5*t114*t22*t24*t32-7.364127282170578d+5*t114*t
     3         21*t28*t29+2.6510858215814087d+6*t114*t21*t25*t29-3.09293
     4         34585116436d+6*t114*t21*t22*t29+1.1782603651472927d+6*t11
     5         4*t19*t21*t29-1.1782603651472927d+6*t114*t18*t25*t26+4.12
     6         3911278015524d+6*t114*t18*t22*t26-4.713041460589171d+6*t1
     7         14*t18*t19*t26+1.767390547720939d+6*t114*t16*t18*t26-1.76
     8         73905477209387d+6*t114*t15*t22*t23+6.059624735043219d+6*t
     9         114*t15*t19*t23-6.817077826923622d+6*t114*t15*t16*t23+2.5
     :         24843639601341d+6*t114*t13*t15*t23-2.524843639601341d+6*t
     ;         114*t12*t19*t20+8.521347283654526d+6*t114*t12*t16*t20-9.4
     <         68163648505028d+6*t114*t12*t13*t20)-6.0d+0*t120*t5*t56*t8
     =         8-3.7221029453963983d+0*t42*t60*t86-2.791577209047299d+0*
     >         t5*t59*t86-9.305257363490997d-1*t42*t5*(-1.97024140900374
     ?         43d-5*t81*t82/rhoa**11+3.279403591520427d-3*t118*t48*t61-
     @         1.648227300332581d-1*gammaaa*t119*t3+3.7270905095708196d-
     1         8*gammaaa**4*t117/rhoa**1.3666666666666666d+1)+(-1.240700
     2         9817987995d+0*t42*t64-1.2407009817987995d+0*t4*t59)*t80-2
     3         .791577209047299d+0*t5*t64*t79-3.7221029453963983d+0*t4*t
     4         60*t79-7.444205890792797d+0*t59*t60*t64+2.757113292886221
     5         d-1*t4*t42*t43)*wght+Amat3(iq,D3_RA_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = (t46*(1.0d+0*t5*(-1.659786666666666
     1         6d-1*gammaaa*t51*t66*t94*taua-7.46904d-2*gammaaa*t51*t65*
     2         t70*t88*taua-1.493808d-1*t44*t49*t52*t65*t88*taua-2.48968
     3         d-2*t49*t55*t65*t66*taua+1.3333333333333333d+1*t49*t51*t6
     4         5*t66*taua-1.9917439999999997d-1*t44*t52*t62*t66*taua-4.9
     5         793599999999993d-2*t50*t55*t62*taua+2.6666666666666666d+1
     6         *t50*t51*t62*taua-1.7925696d-1*t47*t48*t65*t88*t94-8.2989
     7         33333333335d-2*t52*t66*t70*t90+1.120356d-2*t47*t48*t70*t8
     8         8*t89+1.120356d-2*t1*t52*t53*t88*t89+1.120356d-2*gammaaa*
     9         t44*t49*t51*t88*t89+3.73452d-3*t1*t44*t55*t66*t89+3.73452
     :         d-3*gammaaa*t49*t54*t66*t89-2*t1*t44*t51*t66*t89-4*gammaa
     ;         a*t47*t49*t66*t89-t1*t50*t54*t89-1.120356d-2*t1*t44*t55*t
     <         87*t88-1.120356d-2*gammaaa*t49*t54*t87*t88+6*t1*t44*t51*t
     =         87*t88+12*gammaaa*t47*t49*t87*t88-5.975231999999999d-2*t5
     >         2*t53*t63*t65*t88-1.1950464d-1*gammaaa*t44*t51*t62*t65*t8
     ?         8-4.481424d-2*t121*t47*t48*t70*t87+2*t1*t54*t66*t87-4.481
     @         424d-2*t1*t121*t52*t53*t87-4.481424d-2*gammaaa*t121*t44*t
     1         49*t51*t87-3.6515306666666664d-2*t52*t53*t66*t85-1.825765
     2         3333333332d-2*t44*t50*t55*t85+9.777777777777779d+0*t46*t5
     3         4*t85+9.777777777777779d+0*t44*t50*t51*t85-1.261437866666
     4         6665d-1*gammaaa*t44*t51*t66*t84-6.307189333333332d-2*gamm
     5         aaa*t50*t54*t84+6.755555555555556d+1*gammaaa*t47*t50*t84-
     6         2.6888544000000003d-1*t47*t48*t66*t83-1.9917439999999997d
     7         -2*t44*t55*t63*t65*t66+1.0666666666666666d+1*t44*t51*t63*
     8         t65*t66-3.9834879999999995d-2*gammaaa*t54*t62*t65*t66+4.2
     9         666666666666664d+1*gammaaa*t47*t62*t65*t66+5.333333333333
     :         333d+0*t50*t54*t63*t65)+2.6666666666666666d+0*t60*t97+4.4
     ;         44444444444444d-1*t71*t80)+t50*(-t65*t98-1.0d+0*t5*t65*t9
     <         7+4.9793599999999993d-3*t67*t96-1.0d+0*t5*t71*t89-1.33333
     =         33333333333d+0*t60*t65*t71+4.9793599999999993d-3*t63*t68-
     >         1.1618506666666667d-2*t112*t56)-1.9917439999999997d-2*t56
     ?         *t65*t66*t96-2.481401963597599d+0*t42*t60*t95-1.861051472
     @         6981994d+0*t5*t59*t95-3.73452d-3*t1*t66*t93-1.86726d-3*t1
     1         *t50*t92-1.120356d-2*t56*t72*t87*t88+2.0d+0*t5*t66*t71*t8
     2         7-9.305257363490997d-1*t42*t5*(3.531915643569816d-2*t3*t8
     3         5-9.376593846722628d-4*gammaaa*t61*t84+6.610678411788878d
     4         -6*t48*t82*t83-1.3976589410890572d-8*t117*t81/rhoa**1.266
     5         6666666666665d+1)-4.1356699393293317d-1*t42*t69*t80-9.305
     6         257363490997d-1*t5*t69*t79-2.481401963597599d+0*t59*t60*t
     7         69)*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = (t46*(1.0d+0*t5*(-1.39466396303999
     1         98d-4*t44*t52*t70*t88*taua-6.9733198152d-5*gammaaa*t100*t
     2         51*t88*taua-2.3244399384d-5*t55*t66*t70*taua+2.48968d-2*t
     3         51*t66*t70*taua-1.6735967556479997d-4*gammaaa*t44*t51*t88
     4         *t94-5.578655852159999d-5*gammaaa*t54*t66*t94+1.1950464d-
     5         1*gammaaa*t47*t66*t94-2.0919959445599998d-5*gammaaa*t54*t
     6         65*t70*t88+4.481424d-2*gammaaa*t47*t65*t70*t88-2.09199594
     7         45599998d-5*t44*t49*t55*t65*t88+2.240712d-2*t44*t49*t51*t
     8         65*t88-1.1157311704319998d-4*t52*t53*t62*t88-2.2314623408
     9         639997d-4*t123*t47*t48*t88-8.367983778239999d-5*gammaaa*t
     :         121*t44*t51*t65*t70+7.46904d-3*t49*t54*t65*t66-4*t47*t49*
     ;         t65*t66-3.7191039014399996d-5*t44*t55*t62*t66+3.983487999
     <         9999995d-2*t44*t51*t62*t66-8.367983778239999d-5*t121*t49*
     =         t52*t53*t65-8.367983778239999d-5*t100*t121*t47*t48*t65+1.
     >         9917439999999997d-2*t50*t54*t62-1.0666666666666666d+1*t47
     ?         *t50*t62)+1.3333333333333333d+0*t101*t60)-1.2407009817987
     @         995d+0*t42*t60*t99-9.305257363490997d-1*t5*t59*t99-3.7345
     1         2d-3*t1*t50*t98+9.958719999999999d-3*t50*t71*t96-9.305257
     2         363490997d-1*t42*t5*(-1.944317179937905d-6*gammaaa*t82*t9
     3         4+1.731063479394947d-4*t61*t62+5.241221029083964d-9*t117*
     4         t123*t48)-2.0919959445599998d-5*t102*t56*t65*t88+7.46904d
     5         -3*t65*t66*t71*t72+6.973319815199999d-6*t49*t66*t68-3.719
     6         1039014399996d-5*t124*t56*t66-1.0d+0*t101*t5*t50*t65)*wgh
     7         t+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = (1.0d+0*t46*t5*(-3.90630034743910
     1         45d-8*t44*t55*t70*t88+6.275987833679999d-5*t44*t51*t70*t8
     2         8-3.9063003474391045d-8*gammaaa*t100*t54*t88+1.2551975667
     3         36d-4*gammaaa*t100*t47*t88+2.0919959445599995d-5*t54*t66*
     4         t70-2.240712d-2*t47*t66*t70-1.562520138975642d-7*t121*t52
     5         *t53*t70-1.562520138975642d-7*gammaaa*t100*t121*t44*t51-1
     6         .562520138975642d-7*t121*t47*t48/rhoa**1.3333333333333333
     7         d+1)-3.9063003474391045d-8*t56*t88/rhoa**6.66666666666666
     8         7d+0-9.305257363490997d-1*t42*t5*(4.374713654860287d-7*t7
     9         0*t82-1.965457885906487d-9*gammaaa*t100*t117)-5.60178d-3*
     :         t101*t50*t72+2.0919959445599995d-5*t102*t66*t71)*wght+Cma
     ;         t3(iq,D3_GAA_GAA_GAA)
            Mmat3(iq,D3_RA_RA_TA) = (t46*(1.0d+0*t5*(-2.987616d-1*t44*t5
     1         2*t65*t75*t88*taua-1.493808d-1*gammaaa*t51*t65*t74*t88*ta
     2         ua-4.97936d-2*t55*t65*t66*t75*taua+5.333333333333333d+1*t
     3         52*t65*t66*t75*taua-2.8216373333333333d-1*gammaaa*t51*t66
     4         *t70*taua-2.9876159999999996d-1*t44*t49*t52*t66*taua-7.46
     5         9039999999999d-2*t49*t50*t55*taua+8.0d+1*t49*t50*t52*taua
     6         -4.1826624d-1*t47*t48*t66*t94-1.659786666666667d-1*t52*t6
     7         6*t74*t90+2.240712d-2*gammaaa*t44*t51*t75*t88*t89+2.24071
     8         2d-2*t47*t48*t74*t88*t89+2.240712d-2*t43*t52*t53*t88*t89+
     9         7.46904d-3*gammaaa*t54*t66*t75*t89-4.0d+0*gammaaa*t51*t66
     :         *t75*t89+7.46904d-3*t43*t44*t55*t66*t89-8.0d+0*t43*t44*t5
     ;         2*t66*t89-2.0d+0*t43*t50*t55*t89-2.240712d-2*gammaaa*t54*
     <         t75*t87*t88+1.2d+1*gammaaa*t51*t75*t87*t88-2.240712d-2*t4
     =         3*t44*t55*t87*t88+2.4d+1*t43*t44*t52*t87*t88-3.1369968d-1
     >         *t47*t48*t65*t70*t88-7.46904d-2*t1*t52*t53*t65*t88-1.9419
     ?         503999999999d-1*gammaaa*t44*t49*t51*t65*t88-8.962848d-2*g
     @         ammaaa*t121*t44*t51*t75*t87-8.962848d-2*t121*t47*t48*t74*
     1         t87+4.0d+0*t43*t55*t66*t87-8.962848d-2*t121*t43*t52*t53*t
     2         87-2.48968d-2*t1*t44*t55*t65*t66-6.473168d-2*gammaaa*t49*
     3         t54*t65*t66+2.6666666666666666d+1*t1*t44*t52*t65*t66+3.46
     4         6666666666666d+1*gammaaa*t49*t51*t65*t66-3.31957333333333
     5         3d-2*t52*t53*t63*t66-1.7261781333333331d-1*gammaaa*t44*t5
     6         1*t62*t66+6.666666666666667d+0*t1*t50*t55*t65-1.659786666
     7         6666666d-2*t44*t50*t55*t63+8.88888888888889d+0*t46*t55*t6
     8         3+1.7777777777777778d+1*t44*t50*t52*t63-8.630890666666666
     9         d-2*gammaaa*t50*t54*t62+4.622222222222223d+1*gammaaa*t50*
     :         t51*t62)+4.444444444444444d-1*t76*t80+2.6666666666666666d
     ;         +0*t104*t60)+t50*(-8.298933333333333d-3*t56*t96-1.0d+0*t5
     <         *t76*t89-1.3333333333333333d+0*t60*t65*t76+6.2242d-3*t67*
     =         t72+6.2242d-3*t1*t68-1.0d+0*t104*t5*t65-t105*t65)-7.46904
     >         d-3*t43*t66*t93-3.73452d-3*t43*t50*t92-9.305257363490997d
     ?         -1*t4*t5*(4.0513776643071964d+1*t36*t40*t77*t9-1.21541329
     @         92921589d+2*t34*t36*t77*t9-2.769805290180471d+3*t33*t40*t
     1         5*t9+5.539610580360942d+3*t33*t37*t5*t9+8.309415870541416
     2         d+3*t33*t34*t5*t9-1.1079221160721883d+4*t31*t33*t5*t9+2.6
     3         739092584427493d+3*t10*t6*t77*t78+6.702928802236738d+5*t1
     4         4*t5*t6*t78-6.093571638397035d+5*t13*t14*t5*t78-2.2282577
     5         15368958d+3*t12*t17*t6*t77+2.2282577153689576d+3*t13*t14*
     6         t58*t77-4.0513776643071964d+1*t37*t39*t77+1.2154132992921
     7         589d+2*t33*t37*t38*t77-2.4308265985843178d+2*t31*t33*t38*
     8         t77+2.4308265985843178d+2*t30*t34*t35*t77-4.0513776643071
     9         96d+2*t28*t30*t35*t77+4.0513776643071964d+2*t27*t31*t32*t
     :         77-6.077066496460795d+2*t25*t27*t32*t77+6.077066496460793
     ;         d+2*t24*t28*t29*t77-8.507893095045111d+2*t22*t24*t29*t77+
     <         8.507893095045113d+2*t21*t25*t26*t77-1.1343857460060149d+
     =         3*t19*t21*t26*t77+1.1343857460060149d+3*t18*t22*t23*t77-1
     >         .4584959591505905d+3*t16*t18*t23*t77+1.4584959591505908d+
     ?         3*t15*t19*t20*t77-1.8231199489382383d+3*t13*t15*t20*t77+1
     @         .8231199489382383d+3*t12*t16*t17*t77+5.585774001863949d+5
     1         *t17*t5*t58*t6-4.5701787287977763d+5*t12*t20*t5*t6-7.9216
     2         43129916147d+5*t10*t116*t5*t6-4.5701787287977763d+5*t16*t
     3         17*t5*t58+5.077976365330863d+5*t13*t17*t5*t58+9.232684300
     4         601569d+2*t36*t40*t5-1.1079221160721883d+4*t30*t37*t38*t5
     5         +1.6618831741082832d+4*t30*t34*t38*t5+2.2158442321443766d
     6         +4*t30*t31*t38*t5-2.7698052901804704d+4*t28*t30*t38*t5+1.
     7         846536860120314d+3*t36*t37*t5-2.769805290180471d+3*t34*t3
     8         6*t5-2.769805290180471d+4*t27*t34*t35*t5+3.69307372024062
     9         9d+4*t27*t31*t35*t5+4.616342150300784d+4*t27*t28*t35*t5-5
     :         .539610580360942d+4*t25*t27*t35*t5-5.539610580360941d+4*t
     ;         24*t31*t32*t5+6.924513225451174d+4*t24*t28*t32*t5+8.30941
     <         5870541416d+4*t24*t25*t32*t5-9.694318515631648d+4*t22*t24
     =         *t32*t5-9.694318515631648d+4*t21*t28*t29*t5+1.16331822187
     >         57979d+5*t21*t25*t29*t5+1.3572045921884307d+5*t21*t22*t29
     ?         *t5-1.5510909625010635d+5*t19*t21*t29*t5-1.55109096250106
     @         38d+5*t18*t25*t26*t5+1.809606122917908d+5*t18*t22*t26*t5+
     1         2.0681212833347515d+5*t18*t19*t26*t5-2.3266364437515952d+
     2         5*t16*t18*t26*t5-2.3266364437515955d+5*t15*t22*t23*t5+2.6
     3         59013078573252d+5*t15*t19*t23*t5+2.9913897133949086d+5*t1
     4         5*t16*t23*t5-3.3237663482165647d+5*t13*t15*t23*t5-3.32376
     5         6348216565d+5*t12*t19*t20*t5+3.7392371417436354d+5*t12*t1
     6         6*t20*t5+4.1547079352707056d+5*t12*t13*t20*t5)-2.240712d-
     7         2*t56*t77*t87*t88+2.0d+0*t5*t66*t76*t87-9.305257363490997
     8         d-1*t5*t73*t86-4.1356699393293317d-1*t4*t73*t80-2.4814019
     9         63597599d+0*t60*t64*t73-2.48968d-2*t56*t65*t66*t72-1.8610
     :         514726981994d+0*t103*t5*t64-2.481401963597599d+0*t103*t4*
     ;         t60)*wght+Mmat3(iq,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_GAA_TA) = (t46*(1.0d+0*t5*(-2.789327926079999
     1         7d-4*t44*t52*t74*t88*taua-1.3946639630399998d-4*gammaaa*t
     2         106*t51*t88*taua-4.6488798768d-5*t55*t66*t74*taua+4.97936
     3         d-2*t52*t66*t74*taua+2.48968d-2*t51*t66*t74*taua-4.183991
     4         8891199995d-5*t44*t55*t65*t75*t88+4.481424d-2*t44*t52*t65
     5         *t75*t88+2.240712d-2*t44*t51*t65*t75*t88-4.18399188911999
     6         95d-5*gammaaa*t54*t65*t74*t88+2.240712d-2*gammaaa*t51*t65
     7         *t74*t88+4.481424d-2*gammaaa*t47*t65*t74*t88-2.9287943223
     8         839996d-4*gammaaa*t44*t51*t70*t88-1.8130631519519996d-4*t
     9         49*t52*t53*t88-4.044525492816d-4*t100*t47*t48*t88+7.46904
     :         d-3*t55*t65*t66*t75+7.46904d-3*t54*t65*t66*t75-4.0d+0*t51
     ;         *t65*t66*t75-1.673596755648d-4*t121*t52*t53*t65*t75-1.673
     <         596755648d-4*gammaaa*t121*t44*t51*t65*t74-9.76264774128d-
     =         5*gammaaa*t54*t66*t70+5.228328d-2*gammaaa*t51*t66*t70+1.0
     >         456655999999999d-1*gammaaa*t47*t66*t70-6.043543839839999d
     ?         -5*t44*t49*t55*t66+6.473168d-2*t44*t49*t52*t66+3.236584d-
     @         2*t44*t49*t51*t66-1.673596755648d-4*t106*t121*t47*t48*t65
     1         +1.618292d-2*t49*t50*t55+1.618292d-2*t49*t50*t54-8.666666
     2         666666666d+0*t49*t50*t51)+1.3333333333333333d+0*t107*t60)
     3         -3.73452d-3*t43*t50*t98+4.9793599999999993d-3*t50*t76*t96
     4         -9.305257363490997d-1*t5*t73*t95-4.1839918891199995d-5*t1
     5         08*t56*t65*t88+7.46904d-3*t65*t66*t71*t77+3.73452d-3*t65*
     6         t66*t72*t76+1.3946639630399998d-5*t66*t68*t75-1.240700981
     7         7987995d+0*t60*t69*t73+6.2242d-3*t50*t71*t72-9.3052573634
     8         90997d-1*t103*t5*t69-6.043543839839999d-5*t102*t56*t66-1.
     9         0d+0*t107*t5*t50*t65-1.86726d-3*t1*t105*t50)*wght+Mmat3(i
     :         q,D3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = (-9.305257363490997d-1*t5*t73*t99+
     1         1.0d+0*t46*t5*(-7.812600694878209d-8*t44*t55*t74*t88+8.36
     2         7983778239999d-5*t44*t52*t74*t88+8.367983778239999d-5*t44
     3         *t51*t74*t88-7.812600694878209d-8*gammaaa*t106*t54*t88+4.
     4         1839918891199995d-5*gammaaa*t106*t51*t88+1.673596755648d-
     5         4*gammaaa*t106*t47*t88+1.3946639630399998d-5*t55*t66*t74+
     6         2.7893279260799997d-5*t54*t66*t74-1.4938079999999998d-2*t
     7         51*t66*t74-1.4938079999999998d-2*t47*t66*t74-3.1250402779
     8         51284d-7*t121*t52*t53*t74-3.125040277951284d-7*gammaaa*t1
     9         06*t121*t44*t51-3.125040277951284d-7*t121*t47*t48/rhoa**1
     :         .2333333333333334d+1)-7.812600694878209d-8*t119*t56*t88-3
     ;         .73452d-3*t101*t50*t77+6.973319815199999d-6*t102*t66*t76-
     <         3.73452d-3*t107*t50*t72+2.7893279260799997d-5*t108*t66*t7
     =         1)*wght+Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_RA_TA_TA) = (t46*(1.0d+0*t5*(-5.578655852159999d
     1         -4*t111*t44*t52*t88*taua-2.7893279260799997d-4*gammaaa*t1
     2         10*t51*t88*taua-9.2977597536d-5*t111*t55*t66*taua+1.99174
     3         4d-1*t111*t52*t66*taua-2.7893279260799997d-4*t52*t53*t75*
     4         t88-5.020790266944d-4*gammaaa*t44*t51*t74*t88-8.367983778
     5         239999d-5*t112*t44*t55*t65*t88-8.367983778239999d-5*gamma
     6         aa*t111*t54*t65*t88+1.7925696d-1*t112*t44*t52*t65*t88+8.9
     7         62848d-2*gammaaa*t111*t51*t65*t88-7.252252607808d-4*t106*
     8         t47*t48*t88-9.2977597536d-5*t44*t55*t66*t75+1.991744d-1*t
     9         44*t52*t66*t75+4.97936d-2*t50*t55*t75-2.6666666666666666d
     :         +1*t50*t52*t75-1.673596755648d-4*gammaaa*t54*t66*t74+1.79
     ;         25696000000002d-1*gammaaa*t51*t66*t74+2.9876159999999996d
     <         -2*t112*t55*t65*t66-1.6d+1*t112*t52*t65*t66-3.34719351129
     =         6d-4*t112*t121*t52*t53*t65-3.347193511296d-4*gammaaa*t111
     >         *t121*t44*t51*t65-3.347193511296d-4*t110*t121*t47*t48*t65
     ?         )+1.3333333333333333d+0*t113*t60)-9.305257363490997d-1*t4
     @         *t5*(-3.646239897876477d+2*t33*t40*t57*t9-7.2924797957529
     1         54d+2*t33*t37*t57*t9+1.0938719693629433d+3*t33*t34*t57*t9
     2         +1.4584959591505908d+3*t31*t33*t57*t9-8.823900552861074d+
     3         4*t14*t57*t6*t78-8.021727775328248d+4*t13*t14*t57*t78+7.3
     4         53250460717561d+4*t17*t57*t58*t6+6.016295831496187d+4*t12
     5         *t20*t57*t6-1.0428246107926724d+5*t10*t116*t57*t6-6.01629
     6         5831496187d+4*t16*t17*t57*t58-6.684773146106873d+4*t13*t1
     7         7*t57*t58-1.2154132992921589d+2*t36*t40*t57-1.45849595915
     8         05908d+3*t30*t37*t38*t57-2.1877439387258865d+3*t30*t34*t3
     9         8*t57+2.9169919183011817d+3*t30*t31*t38*t57+3.64623989787
     :         6477d+3*t28*t30*t38*t57+2.4308265985843178d+2*t36*t37*t57
     ;         +3.646239897876477d+2*t34*t36*t57-3.646239897876477d+3*t2
     <         7*t34*t35*t57-4.8616531971686355d+3*t27*t31*t35*t57+6.077
     =         066496460795d+3*t27*t28*t35*t57+7.292479795752954d+3*t25*
     >         t27*t35*t57-7.292479795752954d+3*t24*t31*t32*t57-9.115599
     ?         744691192d+3*t24*t28*t32*t57+1.0938719693629431d+4*t24*t2
     @         5*t32*t57+1.2761839642567668d+4*t22*t24*t32*t57-1.2761839
     1         642567668d+4*t21*t28*t29*t57-1.5314207571081204d+4*t21*t2
     2         5*t29*t57+1.786657549959474d+4*t21*t22*t29*t57+2.04189434
     3         28108272d+4*t19*t21*t29*t57-2.0418943428108272d+4*t18*t25
     4         *t26*t57-2.3822100666126317d+4*t18*t22*t26*t57+2.72252579
     5         0414436d+4*t18*t19*t26*t57+3.062841514216241d+4*t16*t18*t
     6         26*t57-3.062841514216241d+4*t15*t22*t23*t57-3.50039030196
     7         14174d+4*t15*t19*t23*t57+3.9379390897065947d+4*t15*t16*t2
     8         3*t57+4.375487877451772d+4*t13*t15*t23*t57-4.375487877451
     9         772d+4*t12*t19*t20*t57-4.9224238621332433d+4*t12*t16*t20*
     :         t57+5.469359846814714d+4*t12*t13*t20*t57)-8.3679837782399
     ;         99d-5*t115*t56*t65*t88+1.4938079999999998d-2*t65*t66*t76*
     <         t77+1.24484d-2*t50*t72*t76+2.7893279260799997d-5*t112*t66
     =         *t68-9.2977597536d-5*t108*t56*t66-1.0d+0*t113*t5*t50*t65-
     >         9.305257363490997d-1*t109*t5*t64-1.2407009817987995d+0*t1
     ?         09*t4*t60-7.46904d-3*t105*t43*t50)*wght+Mmat3(iq,D3_RA_TA
     @         _TA)
            Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
            Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
            Mmat3(iq,D3_GAA_TA_TA) = (1.0d+0*t46*t5*(-1.5625201389756418
     1         d-7*t111*t44*t55*t88-1.5625201389756418d-7*gammaaa*t110*t
     2         54*t88+3.347193511296d-4*t111*t44*t52*t88+8.3679837782399
     3         99d-5*t111*t44*t51*t88+1.673596755648d-4*gammaaa*t110*t51
     4         *t88+1.673596755648d-4*gammaaa*t110*t47*t88+5.57865585215
     5         9999d-5*t111*t55*t66+2.7893279260799997d-5*t111*t54*t66-2
     6         .9876159999999996d-2*t111*t52*t66-2.9876159999999996d-2*t
     7         111*t51*t66-6.250080555902569d-7*t111*t121*t52*t53-6.2500
     8         80555902569d-7*gammaaa*t110*t121*t44*t51-6.25008055590256
     9         9d-7*t121*t47*t48/rhoa**1.1333333333333334d+1)-1.56252013
     :         89756418d-7*t56*t85*t88-7.46904d-3*t107*t50*t77+2.7893279
     ;         260799997d-5*t108*t66*t76-1.86726d-3*t113*t50*t72+2.78932
     <         79260799997d-5*t115*t66*t71-9.305257363490997d-1*t109*t5*
     =         t69)*wght+Mmat3(iq,D3_GAA_TA_TA)
            Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
            Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
            Mmat3(iq,D3_TA_TA_TA) = (-9.305257363490997d-1*t4*t5*(-4.8d+
     1         1*t33*t40*t9-2.88d+2*t33*t37*t9-4.32d+2*t33*t34*t9-1.92d+
     2         2*t31*t33*t9-3.4848d+4*t14*t6*t78-1.056d+4*t13*t14*t78-2.
     3         904d+4*t17*t58*t6-7.92d+3*t12*t20*t6-1.3728d+4*t10*t116*t
     4         6-7.92d+3*t16*t17*t58-2.64d+4*t13*t17*t58-4.8d+1*t36*t40-
     5         1.92d+2*t30*t37*t38-8.64d+2*t30*t34*t38-1.152d+3*t30*t31*
     6         t38-4.8d+2*t28*t30*t38-9.6d+1*t36*t37-4.8d+1*t34*t36-4.8d
     7         +2*t27*t34*t35-1.92d+3*t27*t31*t35-2.4d+3*t27*t28*t35-9.6
     8         d+2*t25*t27*t35-9.6d+2*t24*t31*t32-3.6d+3*t24*t28*t32-4.3
     9         2d+3*t24*t25*t32-1.68d+3*t22*t24*t32-1.68d+3*t21*t28*t29-
     :         6.048d+3*t21*t25*t29-7.056d+3*t21*t22*t29-2.688d+3*t19*t2
     ;         1*t29-2.688d+3*t18*t25*t26-9.408d+3*t18*t22*t26-1.0752d+4
     <         *t18*t19*t26-4.032d+3*t16*t18*t26-4.032d+3*t15*t22*t23-1.
     =         3824d+4*t15*t19*t23-1.5552d+4*t15*t16*t23-5.76d+3*t13*t15
     >         *t23-5.76d+3*t12*t19*t20-1.944d+4*t12*t16*t20-2.16d+4*t12
     ?         *t13*t20)+1.0d+0*t46*t5*(-3.1250402779512837d-7*t124*t44*
     @         t55*t88-3.1250402779512837d-7*gammaaa*t125*t54*t88+1.0041
     1         580533887999d-3*t124*t44*t52*t88+5.020790266944d-4*gammaa
     2         a*t125*t51*t88+1.6735967556479997d-4*t124*t55*t66-1.79256
     3         96d-1*t124*t52*t66-1.2500161111805136d-6*t121*t124*t52*t5
     4         3-1.2500161111805136d-6*gammaaa*t121*t125*t44*t51-1.25001
     5         61111805136d-6*t121*t47*t48/rhoa**1.0333333333333333d+1)-
     6         3.1250402779512837d-7*t56*t63*t88-1.120356d-2*t113*t50*t7
     7         7+8.367983778239998d-5*t115*t66*t76)*wght+Mmat3(iq,D3_TA_
     8         TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
            Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**2.6666666666666666d+0
            t2 = 4.49276922095889d-3*gammabb*t1+1.0d+0
            t3 = 1/t2
            t4 = 3.6121864536509485d-3*gammabb*t1*t3+1.0d+0
            t5 = rhob**1.3333333333333333d+0
            t6 = param(18)
            t7 = rhob**1.6666666666666669d+0
            t8 = 9.115599744691192d+0*t7
            t9 = t8-2.0d+0*taub
            t10 = t9**11
            t11 = 2.0d+0*taub+t8
            t12 = 1/t11**11
            t13 = param(17)
            t14 = t9**10
            t15 = 1/t11**10
            t16 = param(16)
            t17 = t9**9
            t18 = 1/t11**9
            t19 = param(15)
            t20 = t9**8
            t21 = 1/t11**8
            t22 = param(14)
            t23 = t9**7
            t24 = 1/t11**7
            t25 = param(13)
            t26 = t9**6
            t27 = 1/t11**6
            t28 = param(12)
            t29 = t9**5
            t30 = 1/t11**5
            t31 = param(11)
            t32 = t9**4
            t33 = 1/t11**4
            t34 = param(10)
            t35 = t9**3
            t36 = 1/t11**3
            t37 = param(9)
            t38 = t9**2
            t39 = 1/t11**2
            t40 = param(8)
            t41 = 1/t11
            t42 = t40*t41*t9+t10*t12*t6+t37*t38*t39+t34*t35*t36+t31*t32*
     1         t33+t28*t29*t30+t25*t26*t27+t22*t23*t24+t19*t20*t21+t16*t
     2         17*t18+t13*t14*t15+param(7)
            t43 = 1/t7
            t44 = 2.0d+0*t43*taub-9.11559972d+0
            t45 = 1.86726d-3*t44+1.86726d-3*gammabb*t1+1.0d+0
            t46 = 1/t45
            t47 = param(4)
            t48 = gammabb**2
            t49 = 1/rhob**5.333333333333333d+0
            t50 = 1/t45**2
            t51 = param(5)
            t52 = param(6)
            t53 = t44**2
            t54 = param(2)
            t55 = param(3)
            t56 = t44*t46*t55+gammabb*t1*t46*t54+t50*t52*t53+gammabb*t1*
     1         t44*t50*t51+t47*t48*t49*t50+param(1)
            t57 = rhob**6.666666666666666d-1
            t58 = 1/t11**12
            t59 = -1.5192666241151986d+1*t39*t40*t57*t9+3.03853324823039
     1         7d+1*t37*t39*t57*t9-1.6711932865267184d+2*t10*t57*t58*t6+
     2         1.6711932865267184d+2*t12*t14*t57*t6+1.5192666241151986d+
     3         1*t40*t41*t57-3.038533248230397d+1*t36*t37*t38*t57+4.5577
     4         998723455965d+1*t34*t36*t38*t57-4.5577998723455965d+1*t33
     5         *t34*t35*t57+6.077066496460795d+1*t31*t33*t35*t57-6.07706
     6         6496460795d+1*t30*t31*t32*t57+7.596333120575993d+1*t28*t3
     7         0*t32*t57-7.596333120575993d+1*t27*t28*t29*t57+9.11559974
     8         4691193d+1*t25*t27*t29*t57-9.115599744691193d+1*t24*t25*t
     9         26*t57+1.0634866368806391d+2*t22*t24*t26*t57-1.0634866368
     :         806391d+2*t21*t22*t23*t57+1.2154132992921589d+2*t19*t21*t
     ;         23*t57-1.2154132992921589d+2*t18*t19*t20*t57+1.3673399617
     <         036788d+2*t16*t18*t20*t57-1.3673399617036788d+2*t15*t16*t
     =         17*t57+1.5192666241151986d+2*t13*t15*t17*t57-1.5192666241
     >         151986d+2*t12*t13*t14*t57
            t60 = rhob**3.333333333333333d-1
            t61 = 1/t2**2
            t62 = 1/rhob**6.333333333333333d+0
            t63 = 1/rhob**3.6666666666666664d+0
            t64 = 4.327658698487368d-5*t48*t61*t62-9.632497209735863d-3*
     1         gammabb*t3*t63
            t65 = -6.2242d-3*t1*taub-4.9793599999999993d-3*gammabb*t63
            t66 = 1/t45**3
            t67 = -3.3333333333333337d+0*t1*t46*t55*taub-6.6666666666666
     1         67d+0*t1*t44*t50*t52*taub-3.3333333333333337d+0*gammabb*t
     2         49*t50*t51*taub-2*t52*t53*t65*t66-2*gammabb*t1*t44*t51*t6
     3         5*t66-2*t47*t48*t49*t65*t66-t44*t50*t55*t65-gammabb*t1*t5
     4         0*t54*t65-2.6666666666666666d+0*gammabb*t46*t54*t63-2.666
     5         6666666666666d+0*gammabb*t44*t50*t51*t63-5.33333333333333
     6         3d+0*t47*t48*t50*t62
            t68 = 1.0d+0*t5*t67+1.3333333333333333d+0*t56*t60
            t69 = 3.6121864536509485d-3*t1*t3-1.6228720119327628d-5*gamm
     1         abb*t49*t61
            t70 = 1/rhob**8
            t71 = -3.73452d-3*t47*t48*t66*t70-3.73452d-3*t1*t52*t53*t66-
     1         3.73452d-3*gammabb*t44*t49*t51*t66-1.86726d-3*t1*t44*t50*
     2         t55-1.86726d-3*gammabb*t49*t50*t54+t1*t46*t54+t1*t44*t50*
     3         t51+2*gammabb*t47*t49*t50
            t72 = 1/t5
            t73 = -2.0d+0*t39*t40*t9-4.0d+0*t37*t39*t9-2.2d+1*t10*t58*t6
     1         -2.2d+1*t12*t14*t6-2.0d+0*t40*t41-4.0d+0*t36*t37*t38-6.0d
     2         +0*t34*t36*t38-6.0d+0*t33*t34*t35-8.0d+0*t31*t33*t35-8.0d
     3         +0*t30*t31*t32-1.0d+1*t28*t30*t32-1.0d+1*t27*t28*t29-1.2d
     4         +1*t25*t27*t29-1.2d+1*t24*t25*t26-1.4d+1*t22*t24*t26-1.4d
     5         +1*t21*t22*t23-1.6d+1*t19*t21*t23-1.6d+1*t18*t19*t20-1.8d
     6         +1*t16*t18*t20-1.8d+1*t15*t16*t17-2.0d+1*t13*t15*t17-2.0d
     7         +1*t12*t13*t14
            t74 = 1/rhob**7
            t75 = 1/rhob**4.333333333333333d+0
            t76 = -7.46904d-3*gammabb*t44*t51*t66*t75-3.73452d-3*gammabb
     1         *t50*t54*t75+2.0d+0*gammabb*t50*t51*t75-7.46904d-3*t47*t4
     2         8*t66*t74-7.46904d-3*t43*t52*t53*t66-3.73452d-3*t43*t44*t
     3         50*t55+2.0d+0*t43*t46*t55+4.0d+0*t43*t44*t50*t52
            t77 = 1/t60
            t78 = 1/t11**13
            t79 = -1.0128444160767991d+1*t39*t40*t77*t9+2.02568883215359
     1         82d+1*t37*t39*t77*t9+4.6163421503007845d+2*t36*t40*t5*t9-
     2         1.846536860120314d+3*t36*t37*t5*t9+1.3849026450902355d+3*
     3         t34*t36*t5*t9+3.046785819198518d+4*t10*t5*t6*t78-1.114128
     4         8576844789d+2*t10*t58*t6*t77+1.1141288576844789d+2*t12*t1
     5         4*t6*t77+1.0128444160767991d+1*t40*t41*t77-2.025688832153
     6         5982d+1*t36*t37*t38*t77+3.038533248230397d+1*t34*t36*t38*
     7         t77-3.038533248230397d+1*t33*t34*t35*t77+4.05137766430719
     8         64d+1*t31*t33*t35*t77-4.0513776643071964d+1*t30*t31*t32*t
     9         77+5.064222080383994d+1*t28*t30*t32*t77-5.064222080383994
     :         d+1*t27*t28*t29*t77+6.077066496460795d+1*t25*t27*t29*t77-
     ;         6.077066496460795d+1*t24*t25*t26*t77+7.089910912537593d+1
     <         *t22*t24*t26*t77-7.089910912537593d+1*t21*t22*t23*t77+8.1
     =         02755328614393d+1*t19*t21*t23*t77-8.102755328614393d+1*t1
     >         8*t19*t20*t77+9.115599744691191d+1*t16*t18*t20*t77-9.1155
     ?         99744691191d+1*t15*t16*t17*t77+1.012844416076799d+2*t13*t
     @         15*t17*t77-1.012844416076799d+2*t12*t13*t14*t77-5.5857740
     1         01863949d+4*t14*t5*t58*t6+2.5389881826654315d+4*t12*t17*t
     2         5*t6+2.5389881826654315d+4*t13*t14*t5*t58-4.6163421503007
     3         845d+2*t39*t40*t5+4.6163421503007845d+2*t37*t39*t5+1.3849
     4         026450902355d+3*t33*t37*t38*t5-4.1547079352707067d+3*t33*
     5         t34*t38*t5+2.769805290180471d+3*t31*t33*t38*t5+2.76980529
     6         0180471d+3*t30*t34*t35*t5-7.386147440481255d+3*t30*t31*t3
     7         5*t5+4.616342150300784d+3*t28*t30*t35*t5+4.61634215030078
     8         4d+3*t27*t31*t32*t5-1.154085537575196d+4*t27*t28*t32*t5+6
     9         .924513225451178d+3*t25*t27*t32*t5+6.924513225451178d+3*t
     :         24*t28*t29*t5-1.661883174108283d+4*t24*t25*t29*t5+9.69431
     ;         8515631648d+3*t22*t24*t29*t5+9.694318515631648d+3*t21*t25
     <         *t26*t5-2.2620076536473846d+4*t21*t22*t26*t5+1.2925758020
     =         842196d+4*t19*t21*t26*t5+1.2925758020842196d+4*t18*t22*t2
     >         3*t5-2.954458976192502d+4*t18*t19*t23*t5+1.66188317410828
     ?         23d+4*t16*t18*t23*t5+1.6618831741082823d+4*t15*t19*t20*t5
     @         -3.7392371417436354d+4*t15*t16*t20*t5+2.0773539676353528d
     1         +4*t13*t15*t20*t5+2.0773539676353528d+4*t12*t16*t17*t5-4.
     2         616342150300784d+4*t12*t13*t17*t5
            t80 = 1/t57
            t81 = gammabb**3
            t82 = 1/t2**3
            t83 = 1/rhob**10
            t84 = 1/rhob**7.333333333333333d+0
            t85 = 1/rhob**4.666666666666667d+0
            t86 = 3.531915643569816d-2*gammabb*t3*t85-3.8948928286386303
     1         d-4*t48*t61*t84+1.0369691626335495d-6*t81*t82*t83
            t87 = t65**2
            t88 = 1/t45**4
            t89 = 1.6597866666666666d-2*t63*taub+1.8257653333333332d-2*g
     1         ammabb*t85
            t90 = taub**2
            t91 = 2.6666666666666666d+1*t1*t44*t52*t65*t66*taub+1.333333
     1         3333333333d+1*gammabb*t49*t51*t65*t66*taub+6.666666666666
     2         667d+0*t1*t50*t55*t65*taub+8.88888888888889d+0*t46*t55*t6
     3         3*taub+1.7777777777777778d+1*t44*t50*t52*t63*taub+2.66666
     4         66666666666d+1*gammabb*t50*t51*t62*taub+2.222222222222222
     5         4d+1*t49*t50*t52*t90-2*t52*t53*t66*t89-2*gammabb*t1*t44*t
     6         51*t66*t89-2*t47*t48*t49*t66*t89-t44*t50*t55*t89-gammabb*
     7         t1*t50*t54*t89+6*t52*t53*t87*t88+6*gammabb*t1*t44*t51*t87
     8         *t88+6*t47*t48*t49*t87*t88+2*t44*t55*t66*t87+2*gammabb*t1
     9         *t54*t66*t87+9.777777777777779d+0*gammabb*t46*t54*t85+9.7
     :         77777777777779d+0*gammabb*t44*t50*t51*t85+3.3777777777777
     ;         78d+1*t47*t48*t50*t84+1.0666666666666666d+1*gammabb*t44*t
     <         51*t63*t65*t66+2.1333333333333332d+1*t47*t48*t62*t65*t66+
     =         5.333333333333333d+0*gammabb*t50*t54*t63*t65
            t92 = 1.0d+0*t5*t91+4.444444444444444d-1*t56*t80+2.666666666
     1         6666666d+0*t60*t67
            t93 = -1.0d+0*t5*t56*t89-t65*t68-1.0d+0*t5*t65*t67-1.3333333
     1         333333333d+0*t56*t60*t65
            t94 = 1/rhob**9
            t95 = -3.8886343598758105d-7*t48*t82*t94-9.632497209735863d-
     1         3*t3*t63+1.29829760954621d-4*gammabb*t61*t62
            t96 = 1/rhob**2.3333333333333334d+0
            t97 = 1.24484d-2*gammabb*t51*t66*t70*taub+2.48968d-2*t44*t49
     1         *t52*t66*taub+6.2242d-3*t49*t50*t55*taub-3.33333333333333
     2         37d+0*t49*t50*t51*taub+2.9876159999999996d-2*t47*t48*t66*
     3         t94+1.120356d-2*t47*t48*t65*t70*t88+1.120356d-2*t1*t52*t5
     4         3*t65*t88+1.120356d-2*gammabb*t44*t49*t51*t65*t88+3.73452
     5         d-3*t1*t44*t55*t65*t66+3.73452d-3*gammabb*t49*t54*t65*t66
     6         -2*t1*t44*t51*t65*t66-4*gammabb*t47*t49*t65*t66+9.9587199
     7         99999999d-3*t52*t53*t63*t66+1.9917439999999997d-2*gammabb
     8         *t44*t51*t62*t66-t1*t50*t54*t65+4.9793599999999993d-3*t44
     9         *t50*t55*t63-2.6666666666666666d+0*t46*t54*t63-2.66666666
     :         66666666d+0*t44*t50*t51*t63+9.958719999999999d-3*gammabb*
     ;         t50*t54*t62-1.0666666666666666d+1*gammabb*t47*t50*t62
            t98 = 1.0d+0*t5*t97+1.3333333333333333d+0*t60*t71
            t99 = 1.4582378849534292d-7*gammabb*t70*t82-3.24574402386552
     1         55d-5*t49*t61
            t100 = 1/rhob**1.0666666666666666d+1
            t101 = 2.0919959445599998d-5*gammabb*t44*t51*t70*t88+2.09199
     1         59445599998d-5*t49*t52*t53*t88+2.0919959445599998d-5*t100
     2         *t47*t48*t88+6.973319815199999d-6*gammabb*t54*t66*t70-1.4
     3         938079999999998d-2*gammabb*t47*t66*t70+6.973319815199999d
     4         -6*t44*t49*t55*t66-7.46904d-3*t44*t49*t51*t66-3.73452d-3*
     5         t49*t50*t54+2*t47*t49*t50
            t102 = 1/rhob**4
            t103 = 6.077066496460795d+1*t36*t40*t57*t9-1.823119948938238
     1         5d+2*t34*t36*t57*t9+4.0108638876641245d+3*t10*t57*t6*t78-
     2         3.342386573053437d+3*t12*t17*t57*t6+3.342386573053437d+3*
     3         t13*t14*t57*t58-6.077066496460795d+1*t37*t39*t57+1.823119
     4         9489382385d+2*t33*t37*t38*t57-3.646239897876477d+2*t31*t3
     5         3*t38*t57+3.646239897876477d+2*t30*t34*t35*t57-6.07706649
     6         6460795d+2*t28*t30*t35*t57+6.077066496460795d+2*t27*t31*t
     7         32*t57-9.115599744691192d+2*t25*t27*t32*t57+9.11559974469
     8         1192d+2*t24*t28*t29*t57-1.276183964256767d+3*t22*t24*t29*
     9         t57+1.276183964256767d+3*t21*t25*t26*t57-1.70157861900902
     :         26d+3*t19*t21*t26*t57+1.7015786190090226d+3*t18*t22*t23*t
     ;         57-2.187743938725886d+3*t16*t18*t23*t57+2.187743938725886
     <         d+3*t15*t19*t20*t57-2.734679923407357d+3*t13*t15*t20*t57+
     =         2.734679923407357d+3*t12*t16*t17*t57
            t104 = 4.97936d-2*t44*t52*t66*t75*taub+1.24484d-2*t50*t55*t7
     1         5*taub-1.3333333333333333d+1*t50*t52*t75*taub+2.48968d-2*
     2         gammabb*t51*t66*t74*taub+2.240712d-2*gammabb*t44*t51*t65*
     3         t75*t88+2.240712d-2*t47*t48*t65*t74*t88+2.240712d-2*t43*t
     4         52*t53*t65*t88+7.46904d-3*gammabb*t54*t65*t66*t75-4.0d+0*
     5         gammabb*t51*t65*t66*t75+5.228328d-2*t47*t48*t66*t70+7.469
     6         04d-3*t43*t44*t55*t65*t66-8.0d+0*t43*t44*t52*t65*t66+1.24
     7         484d-2*t1*t52*t53*t66+3.236584d-2*gammabb*t44*t49*t51*t66
     8         -2.0d+0*t43*t50*t55*t65+6.2242d-3*t1*t44*t50*t55-3.333333
     9         3333333337d+0*t1*t46*t55+1.618292d-2*gammabb*t49*t50*t54-
     :         6.666666666666667d+0*t1*t44*t50*t52-8.666666666666666d+0*
     ;         gammabb*t49*t50*t51
            t105 = 1.3333333333333333d+0*t60*t76+1.0d+0*t104*t5
            t106 = 1/rhob**9.666666666666666d+0
            t107 = 4.1839918891199995d-5*t52*t53*t75*t88+4.1839918891199
     1         995d-5*gammabb*t44*t51*t74*t88+4.1839918891199995d-5*t106
     2         *t47*t48*t88+1.3946639630399998d-5*t44*t55*t66*t75-1.4938
     3         079999999998d-2*t44*t52*t66*t75-7.46904d-3*t44*t51*t66*t7
     4         5-3.73452d-3*t50*t55*t75-3.73452d-3*t50*t54*t75+2.0d+0*t5
     5         0*t51*t75+1.3946639630399998d-5*gammabb*t54*t66*t74-7.469
     6         04d-3*gammabb*t51*t66*t74-1.4938079999999998d-2*gammabb*t
     7         47*t66*t74
            t108 = 1/rhob**3
            t109 = 8.0d+0*t36*t40*t9+3.2d+1*t36*t37*t9+2.4d+1*t34*t36*t9
     1         +5.28d+2*t10*t6*t78+9.68d+2*t14*t58*t6+4.4d+2*t12*t17*t6+
     2         4.4d+2*t13*t14*t58+8.0d+0*t39*t40+8.0d+0*t37*t39+2.4d+1*t
     3         33*t37*t38+7.2d+1*t33*t34*t38+4.8d+1*t31*t33*t38+4.8d+1*t
     4         30*t34*t35+1.28d+2*t30*t31*t35+8.0d+1*t28*t30*t35+8.0d+1*
     5         t27*t31*t32+2.0d+2*t27*t28*t32+1.2d+2*t25*t27*t32+1.2d+2*
     6         t24*t28*t29+2.88d+2*t24*t25*t29+1.68d+2*t22*t24*t29+1.68d
     7         +2*t21*t25*t26+3.92d+2*t21*t22*t26+2.24d+2*t19*t21*t26+2.
     8         24d+2*t18*t22*t23+5.12d+2*t18*t19*t23+2.88d+2*t16*t18*t23
     9         +2.88d+2*t15*t19*t20+6.48d+2*t15*t16*t20+3.6d+2*t13*t15*t
     :         20+3.6d+2*t12*t16*t17+8.0d+2*t12*t13*t17
            t110 = 1/rhob**8.666666666666666d+0
            t111 = 1/rhob**6
            t112 = 1/rhob**3.3333333333333337d+0
            t113 = 8.367983778239999d-5*t112*t52*t53*t88+8.3679837782399
     1         99d-5*gammabb*t111*t44*t51*t88+8.367983778239999d-5*t110*
     2         t47*t48*t88+2.7893279260799997d-5*t112*t44*t55*t66+2.7893
     3         279260799997d-5*gammabb*t111*t54*t66-5.975231999999999d-2
     4         *t112*t44*t52*t66-2.9876159999999996d-2*gammabb*t111*t51*
     5         t66-1.4938079999999998d-2*t112*t50*t55+8.0d+0*t112*t50*t5
     6         2
            t114 = rhob**2
            t115 = 1/t114
            t116 = 1/t11**14
            t117 = 1/t2**4
            t118 = 1/rhob**8.333333333333334d+0
            t119 = 1/rhob**5.666666666666667d+0
            t120 = t65**3
            t121 = 1/t45**5
            t122 = -6.085884444444444d-2*t85*taub-8.520238222222222d-2*g
     1         ammabb*t119
            t123 = 1/rhob**1.1666666666666665d+1
            t124 = 1/rhob**5
            t125 = 1/rhob**7.666666666666667d+0
            fnc(iq) = (1.0d+0*t46*t5*t56-9.305257363490997d-1*t4*t42*t5)
     1         *wght+fnc(iq)
            Amat(iq,D1_RB) = (t46*t68-1.0d+0*t5*t50*t56*t65-9.3052573634
     1         90997d-1*t42*t5*t64-1.2407009817987995d+0*t4*t42*t60-9.30
     2         5257363490997d-1*t4*t5*t59)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = (-1.86726d-3*t50*t56*t72+1.0d+0*t46*t5*t71
     1         -9.305257363490997d-1*t42*t5*t69)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = (-3.73452d-3*t50*t56*t77+1.0d+0*t46*t5*t76-
     1         9.305257363490997d-1*t4*t5*t73)*wght+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            Amat2(iq,D2_RB_RB) = (t50*t93+t46*t92+2.0d+0*t5*t56*t66*t87-
     1         9.305257363490997d-1*t42*t5*t86-4.1356699393293317d-1*t4*
     2         t42*t80-9.305257363490997d-1*t4*t5*t79-2.481401963597599d
     3         +0*t42*t60*t64-1.8610514726981994d+0*t5*t59*t64-2.4814019
     4         63597599d+0*t4*t59*t60)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = (t46*t98+4.9793599999999993d-3*t50*t56
     1         *t96-9.305257363490997d-1*t42*t5*t95+3.73452d-3*t56*t65*t
     2         66*t72-1.0d+0*t5*t50*t65*t71-1.2407009817987995d+0*t42*t6
     3         0*t69-9.305257363490997d-1*t5*t59*t69-1.86726d-3*t1*t50*t
     4         68)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = (-9.305257363490997d-1*t42*t5*t99-3.7
     1         3452d-3*t50*t71*t72+6.973319815199999d-6*t102*t56*t66+1.0
     2         d+0*t101*t46*t5)*wght+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = (7.46904d-3*t56*t65*t66*t77-1.0d+0*t5*t
     1         50*t65*t76-9.305257363490997d-1*t5*t64*t73-1.240700981798
     2         7995d+0*t4*t60*t73+6.2242d-3*t50*t56*t72-3.73452d-3*t43*t
     3         50*t68-9.305257363490997d-1*t103*t4*t5+t105*t46)*wght+Mma
     4         t2(iq,D2_RB_TB)
            Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = (-3.73452d-3*t50*t71*t77-1.86726d-3*t5
     1         0*t72*t76-9.305257363490997d-1*t5*t69*t73+1.3946639630399
     2         998d-5*t108*t56*t66+1.0d+0*t107*t46*t5)*wght+Mmat2(iq,D2_
     3         GBB_TB)
            Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = (-7.46904d-3*t50*t76*t77+2.789327926079
     1         9997d-5*t115*t56*t66+1.0d+0*t113*t46*t5-9.305257363490997
     2         d-1*t109*t4*t5)*wght+Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RB_RB_RB) = (t46*(1.0d+0*t5*(4.0d+1*t1*t44*t52*t
     1         66*t89*taub+2.0d+1*gammabb*t49*t51*t66*t89*taub+1.0d+1*t1
     2         *t50*t55*t89*taub-1.2d+2*t1*t44*t52*t87*t88*taub-6.0d+1*g
     3         ammabb*t49*t51*t87*t88*taub-2.0d+1*t1*t55*t66*t87*taub-3.
     4         2592592592592595d+1*t46*t55*t85*taub-6.518518518518519d+1
     5         *t44*t50*t52*t85*taub-2.0148148148148146d+2*gammabb*t50*t
     6         51*t84*taub-1.0666666666666667d+2*t44*t52*t63*t65*t66*tau
     7         b-1.6d+2*gammabb*t51*t62*t65*t66*taub-2.6666666666666666d
     8         +1*t50*t55*t63*t65*taub-1.3333333333333333d+2*t49*t52*t65
     9         *t66*t90-1.777777777777778d+2*t50*t52*t62*t90+18*t52*t53*
     :         t65*t88*t89+18*gammabb*t1*t44*t51*t65*t88*t89+18*t47*t48*
     ;         t49*t65*t88*t89+6*t44*t55*t65*t66*t89+6*gammabb*t1*t54*t6
     <         5*t66*t89+16*gammabb*t44*t51*t63*t66*t89+32*t47*t48*t62*t
     =         66*t89+8*gammabb*t50*t54*t63*t89-48*gammabb*t44*t51*t63*t
     >         87*t88-96*t47*t48*t62*t87*t88-6*t120*t44*t55*t88-6*gammab
     ?         b*t1*t120*t54*t88-16*gammabb*t54*t63*t66*t87-5.8666666666
     @         66667d+1*gammabb*t44*t51*t65*t66*t85-2.9333333333333333d+
     1         1*gammabb*t50*t54*t65*t85-2.0266666666666666d+2*t47*t48*t
     2         65*t66*t84-2*t122*t52*t53*t66-2*gammabb*t1*t122*t44*t51*t
     3         66-2*t122*t47*t48*t49*t66-t122*t44*t50*t55-gammabb*t1*t12
     4         2*t50*t54-4.5629629629629626d+1*gammabb*t119*t46*t54-24*t
     5         120*t121*t52*t53-4.5629629629629626d+1*gammabb*t119*t44*t
     6         50*t51-24*gammabb*t1*t120*t121*t44*t51-2.477037037037037d
     7         +2*t118*t47*t48*t50-24*t120*t121*t47*t48*t49)+4.0d+0*t60*
     8         t91+1.3333333333333333d+0*t67*t80-2.962962962962963d-1*t4
     9         3*t56)+t66*(-2*t65*t93+4.0d+0*t5*t56*t65*t89+2.0d+0*t5*t6
     :         7*t87+2.6666666666666666d+0*t56*t60*t87)+t50*(-2*t65*t92-
     ;         1.0d+0*t5*t65*t91-t68*t89-2.0d+0*t5*t67*t89-2.66666666666
     <         66666d+0*t56*t60*t89-4.444444444444444d-1*t56*t65*t80-2.6
     =         666666666666666d+0*t60*t65*t67-1.0d+0*t122*t5*t56)-9.3052
     >         57363490997d-1*t4*t5*(3.37614805358933d+0*t39*t40*t72*t9-
     ?         6.75229610717866d+0*t37*t39*t72*t9+9.232684300601568d+2*t
     @         36*t40*t60*t9-3.693073720240627d+3*t36*t37*t60*t9+2.76980
     1         5290180471d+3*t34*t36*t60*t9-2.104036366334451d+4*t114*t3
     2         3*t40*t9+1.2624218198006704d+5*t114*t33*t37*t9-1.89363272
     3         97010064d+5*t114*t33*t34*t9+8.416145465337804d+4*t114*t31
     4         *t33*t9+6.093571638397036d+4*t10*t6*t60*t78+1.52753040195
     5         88112d+7*t114*t14*t6*t78-4.628880005935792d+6*t114*t13*t1
     6         4*t78+3.713762858948263d+1*t10*t58*t6*t72-3.7137628589482
     7         63d+1*t12*t14*t6*t72-3.37614805358933d+0*t40*t41*t72+6.75
     8         229610717866d+0*t36*t37*t38*t72-1.0128444160767991d+1*t34
     9         *t36*t38*t72+1.0128444160767991d+1*t33*t34*t35*t72-1.3504
     :         59221435732d+1*t31*t33*t35*t72+1.350459221435732d+1*t30*t
     ;         31*t32*t72-1.6880740267946648d+1*t28*t30*t32*t72+1.688074
     <         0267946648d+1*t27*t28*t29*t72-2.0256888321535982d+1*t25*t
     =         27*t29*t72+2.0256888321535982d+1*t24*t25*t26*t72-2.363303
     >         6375125308d+1*t22*t24*t26*t72+2.3633036375125308d+1*t21*t
     ?         22*t23*t72-2.700918442871464d+1*t19*t21*t23*t72+2.7009184
     @         42871464d+1*t18*t19*t20*t72-3.0385332482303967d+1*t16*t18
     1         *t20*t72+3.0385332482303967d+1*t15*t16*t17*t72-3.37614805
     2         35893296d+1*t13*t15*t17*t72+3.3761480535893296d+1*t12*t13
     3         *t14*t72-1.1171548003727898d+5*t14*t58*t6*t60+5.077976365
     4         330863d+4*t12*t17*t6*t60+5.077976365330862d+4*t13*t14*t58
     5         *t60-9.232684300601568d+2*t39*t40*t60+9.232684300601568d+
     6         2*t37*t39*t60+2.769805290180471d+3*t33*t37*t38*t60-8.3094
     7         15870541413d+3*t33*t34*t38*t60+5.539610580360942d+3*t31*t
     8         33*t38*t60+5.539610580360942d+3*t30*t34*t35*t60-1.4772294
     9         880962508d+4*t30*t31*t35*t60+9.232684300601568d+3*t28*t30
     :         *t35*t60+9.232684300601568d+3*t27*t31*t32*t60-2.308171075
     ;         150392d+4*t27*t28*t32*t60+1.3849026450902355d+4*t25*t27*t
     <         32*t60+1.3849026450902355d+4*t24*t28*t29*t60-3.3237663482
     =         16566d+4*t24*t25*t29*t60+1.9388637031263292d+4*t22*t24*t2
     >         9*t60+1.9388637031263292d+4*t21*t25*t26*t60-4.52401530729
     ?         47686d+4*t21*t22*t26*t60+2.585151604168439d+4*t19*t21*t26
     @         *t60+2.585151604168439d+4*t18*t22*t23*t60-5.9089179523850
     1         03d+4*t18*t19*t23*t60+3.3237663482165647d+4*t16*t18*t23*t
     2         60+3.3237663482165647d+4*t15*t19*t20*t60-7.47847428348727
     3         1d+4*t15*t16*t20*t60+4.154707935270705d+4*t13*t15*t20*t60
     4         +4.1547079352707056d+4*t12*t16*t17*t60-9.232684300601568d
     5         +4*t12*t13*t17*t60-1.2729420016323426d+7*t114*t17*t58*t6+
     6         3.4716600044518436d+6*t114*t12*t20*t6-6.01754400771653d+6
     7         *t10*t114*t116*t6-3.4716600044518436d+6*t114*t16*t17*t58+
     8         1.1572200014839477d+7*t114*t13*t17*t58+2.104036366334451d
     9         +4*t114*t36*t40-8.416145465337804d+4*t114*t30*t37*t38+3.7
     :         87265459402013d+5*t114*t30*t34*t38-5.049687279202681d+5*t
     ;         114*t30*t31*t38+2.1040363663344508d+5*t114*t28*t30*t38-4.
     <         208072732668902d+4*t114*t36*t37+2.104036366334451d+4*t114
     =         *t34*t36-2.104036366334451d+5*t114*t27*t34*t35+8.41614546
     >         5337803d+5*t114*t27*t31*t35-1.0520181831672254d+6*t114*t2
     ?         7*t28*t35+4.208072732668902d+5*t114*t25*t27*t35-4.2080727
     @         326689016d+5*t114*t24*t31*t32+1.578027274750838d+6*t114*t
     1         24*t28*t32-1.893632729701006d+6*t114*t24*t25*t32+7.364127
     2         282170578d+5*t114*t22*t24*t32-7.364127282170578d+5*t114*t
     3         21*t28*t29+2.6510858215814087d+6*t114*t21*t25*t29-3.09293
     4         34585116436d+6*t114*t21*t22*t29+1.1782603651472927d+6*t11
     5         4*t19*t21*t29-1.1782603651472927d+6*t114*t18*t25*t26+4.12
     6         3911278015524d+6*t114*t18*t22*t26-4.713041460589171d+6*t1
     7         14*t18*t19*t26+1.767390547720939d+6*t114*t16*t18*t26-1.76
     8         73905477209387d+6*t114*t15*t22*t23+6.059624735043219d+6*t
     9         114*t15*t19*t23-6.817077826923622d+6*t114*t15*t16*t23+2.5
     :         24843639601341d+6*t114*t13*t15*t23-2.524843639601341d+6*t
     ;         114*t12*t19*t20+8.521347283654526d+6*t114*t12*t16*t20-9.4
     <         68163648505028d+6*t114*t12*t13*t20)-6.0d+0*t120*t5*t56*t8
     =         8-3.7221029453963983d+0*t42*t60*t86-2.791577209047299d+0*
     >         t5*t59*t86-9.305257363490997d-1*t42*t5*(-1.97024140900374
     ?         43d-5*t81*t82/rhob**11+3.279403591520427d-3*t118*t48*t61-
     @         1.648227300332581d-1*gammabb*t119*t3+3.7270905095708196d-
     1         8*gammabb**4*t117/rhob**1.3666666666666666d+1)+(-1.240700
     2         9817987995d+0*t42*t64-1.2407009817987995d+0*t4*t59)*t80-2
     3         .791577209047299d+0*t5*t64*t79-3.7221029453963983d+0*t4*t
     4         60*t79-7.444205890792797d+0*t59*t60*t64+2.757113292886221
     5         d-1*t4*t42*t43)*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = (t46*(1.0d+0*t5*(-1.659786666666666
     1         6d-1*gammabb*t51*t66*t94*taub-7.46904d-2*gammabb*t51*t65*
     2         t70*t88*taub-1.493808d-1*t44*t49*t52*t65*t88*taub-2.48968
     3         d-2*t49*t55*t65*t66*taub+1.3333333333333333d+1*t49*t51*t6
     4         5*t66*taub-1.9917439999999997d-1*t44*t52*t62*t66*taub-4.9
     5         793599999999993d-2*t50*t55*t62*taub+2.6666666666666666d+1
     6         *t50*t51*t62*taub-1.7925696d-1*t47*t48*t65*t88*t94-8.2989
     7         33333333335d-2*t52*t66*t70*t90+1.120356d-2*t47*t48*t70*t8
     8         8*t89+1.120356d-2*t1*t52*t53*t88*t89+1.120356d-2*gammabb*
     9         t44*t49*t51*t88*t89+3.73452d-3*t1*t44*t55*t66*t89+3.73452
     :         d-3*gammabb*t49*t54*t66*t89-2*t1*t44*t51*t66*t89-4*gammab
     ;         b*t47*t49*t66*t89-t1*t50*t54*t89-1.120356d-2*t1*t44*t55*t
     <         87*t88-1.120356d-2*gammabb*t49*t54*t87*t88+6*t1*t44*t51*t
     =         87*t88+12*gammabb*t47*t49*t87*t88-5.975231999999999d-2*t5
     >         2*t53*t63*t65*t88-1.1950464d-1*gammabb*t44*t51*t62*t65*t8
     ?         8-4.481424d-2*t121*t47*t48*t70*t87+2*t1*t54*t66*t87-4.481
     @         424d-2*t1*t121*t52*t53*t87-4.481424d-2*gammabb*t121*t44*t
     1         49*t51*t87-3.6515306666666664d-2*t52*t53*t66*t85-1.825765
     2         3333333332d-2*t44*t50*t55*t85+9.777777777777779d+0*t46*t5
     3         4*t85+9.777777777777779d+0*t44*t50*t51*t85-1.261437866666
     4         6665d-1*gammabb*t44*t51*t66*t84-6.307189333333332d-2*gamm
     5         abb*t50*t54*t84+6.755555555555556d+1*gammabb*t47*t50*t84-
     6         2.6888544000000003d-1*t47*t48*t66*t83-1.9917439999999997d
     7         -2*t44*t55*t63*t65*t66+1.0666666666666666d+1*t44*t51*t63*
     8         t65*t66-3.9834879999999995d-2*gammabb*t54*t62*t65*t66+4.2
     9         666666666666664d+1*gammabb*t47*t62*t65*t66+5.333333333333
     :         333d+0*t50*t54*t63*t65)+2.6666666666666666d+0*t60*t97+4.4
     ;         44444444444444d-1*t71*t80)+t50*(-t65*t98-1.0d+0*t5*t65*t9
     <         7+4.9793599999999993d-3*t67*t96-1.0d+0*t5*t71*t89-1.33333
     =         33333333333d+0*t60*t65*t71+4.9793599999999993d-3*t63*t68-
     >         1.1618506666666667d-2*t112*t56)-1.9917439999999997d-2*t56
     ?         *t65*t66*t96-2.481401963597599d+0*t42*t60*t95-1.861051472
     @         6981994d+0*t5*t59*t95-3.73452d-3*t1*t66*t93-1.86726d-3*t1
     1         *t50*t92-1.120356d-2*t56*t72*t87*t88+2.0d+0*t5*t66*t71*t8
     2         7-9.305257363490997d-1*t42*t5*(3.531915643569816d-2*t3*t8
     3         5-9.376593846722628d-4*gammabb*t61*t84+6.610678411788878d
     4         -6*t48*t82*t83-1.3976589410890572d-8*t117*t81/rhob**1.266
     5         6666666666665d+1)-4.1356699393293317d-1*t42*t69*t80-9.305
     6         257363490997d-1*t5*t69*t79-2.481401963597599d+0*t59*t60*t
     7         69)*wght+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = (t46*(1.0d+0*t5*(-1.39466396303999
     1         98d-4*t44*t52*t70*t88*taub-6.9733198152d-5*gammabb*t100*t
     2         51*t88*taub-2.3244399384d-5*t55*t66*t70*taub+2.48968d-2*t
     3         51*t66*t70*taub-1.6735967556479997d-4*gammabb*t44*t51*t88
     4         *t94-5.578655852159999d-5*gammabb*t54*t66*t94+1.1950464d-
     5         1*gammabb*t47*t66*t94-2.0919959445599998d-5*gammabb*t54*t
     6         65*t70*t88+4.481424d-2*gammabb*t47*t65*t70*t88-2.09199594
     7         45599998d-5*t44*t49*t55*t65*t88+2.240712d-2*t44*t49*t51*t
     8         65*t88-1.1157311704319998d-4*t52*t53*t62*t88-2.2314623408
     9         639997d-4*t123*t47*t48*t88-8.367983778239999d-5*gammabb*t
     :         121*t44*t51*t65*t70+7.46904d-3*t49*t54*t65*t66-4*t47*t49*
     ;         t65*t66-3.7191039014399996d-5*t44*t55*t62*t66+3.983487999
     <         9999995d-2*t44*t51*t62*t66-8.367983778239999d-5*t121*t49*
     =         t52*t53*t65-8.367983778239999d-5*t100*t121*t47*t48*t65+1.
     >         9917439999999997d-2*t50*t54*t62-1.0666666666666666d+1*t47
     ?         *t50*t62)+1.3333333333333333d+0*t101*t60)-1.2407009817987
     @         995d+0*t42*t60*t99-9.305257363490997d-1*t5*t59*t99-3.7345
     1         2d-3*t1*t50*t98+9.958719999999999d-3*t50*t71*t96-9.305257
     2         363490997d-1*t42*t5*(-1.944317179937905d-6*gammabb*t82*t9
     3         4+1.731063479394947d-4*t61*t62+5.241221029083964d-9*t117*
     4         t123*t48)-2.0919959445599998d-5*t102*t56*t65*t88+7.46904d
     5         -3*t65*t66*t71*t72+6.973319815199999d-6*t49*t66*t68-3.719
     6         1039014399996d-5*t124*t56*t66-1.0d+0*t101*t5*t50*t65)*wgh
     7         t+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = (1.0d+0*t46*t5*(-3.90630034743910
     1         45d-8*t44*t55*t70*t88+6.275987833679999d-5*t44*t51*t70*t8
     2         8-3.9063003474391045d-8*gammabb*t100*t54*t88+1.2551975667
     3         36d-4*gammabb*t100*t47*t88+2.0919959445599995d-5*t54*t66*
     4         t70-2.240712d-2*t47*t66*t70-1.562520138975642d-7*t121*t52
     5         *t53*t70-1.562520138975642d-7*gammabb*t100*t121*t44*t51-1
     6         .562520138975642d-7*t121*t47*t48/rhob**1.3333333333333333
     7         d+1)-3.9063003474391045d-8*t56*t88/rhob**6.66666666666666
     8         7d+0-9.305257363490997d-1*t42*t5*(4.374713654860287d-7*t7
     9         0*t82-1.965457885906487d-9*gammabb*t100*t117)-5.60178d-3*
     :         t101*t50*t72+2.0919959445599995d-5*t102*t66*t71)*wght+Cma
     ;         t3(iq,D3_GBB_GBB_GBB)
            Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
            Mmat3(iq,D3_RB_RB_TB) = (t46*(1.0d+0*t5*(-2.987616d-1*t44*t5
     1         2*t65*t75*t88*taub-1.493808d-1*gammabb*t51*t65*t74*t88*ta
     2         ub-4.97936d-2*t55*t65*t66*t75*taub+5.333333333333333d+1*t
     3         52*t65*t66*t75*taub-2.8216373333333333d-1*gammabb*t51*t66
     4         *t70*taub-2.9876159999999996d-1*t44*t49*t52*t66*taub-7.46
     5         9039999999999d-2*t49*t50*t55*taub+8.0d+1*t49*t50*t52*taub
     6         -4.1826624d-1*t47*t48*t66*t94-1.659786666666667d-1*t52*t6
     7         6*t74*t90+2.240712d-2*gammabb*t44*t51*t75*t88*t89+2.24071
     8         2d-2*t47*t48*t74*t88*t89+2.240712d-2*t43*t52*t53*t88*t89+
     9         7.46904d-3*gammabb*t54*t66*t75*t89-4.0d+0*gammabb*t51*t66
     :         *t75*t89+7.46904d-3*t43*t44*t55*t66*t89-8.0d+0*t43*t44*t5
     ;         2*t66*t89-2.0d+0*t43*t50*t55*t89-2.240712d-2*gammabb*t54*
     <         t75*t87*t88+1.2d+1*gammabb*t51*t75*t87*t88-2.240712d-2*t4
     =         3*t44*t55*t87*t88+2.4d+1*t43*t44*t52*t87*t88-3.1369968d-1
     >         *t47*t48*t65*t70*t88-7.46904d-2*t1*t52*t53*t65*t88-1.9419
     ?         503999999999d-1*gammabb*t44*t49*t51*t65*t88-8.962848d-2*g
     @         ammabb*t121*t44*t51*t75*t87-8.962848d-2*t121*t47*t48*t74*
     1         t87+4.0d+0*t43*t55*t66*t87-8.962848d-2*t121*t43*t52*t53*t
     2         87-2.48968d-2*t1*t44*t55*t65*t66-6.473168d-2*gammabb*t49*
     3         t54*t65*t66+2.6666666666666666d+1*t1*t44*t52*t65*t66+3.46
     4         6666666666666d+1*gammabb*t49*t51*t65*t66-3.31957333333333
     5         3d-2*t52*t53*t63*t66-1.7261781333333331d-1*gammabb*t44*t5
     6         1*t62*t66+6.666666666666667d+0*t1*t50*t55*t65-1.659786666
     7         6666666d-2*t44*t50*t55*t63+8.88888888888889d+0*t46*t55*t6
     8         3+1.7777777777777778d+1*t44*t50*t52*t63-8.630890666666666
     9         d-2*gammabb*t50*t54*t62+4.622222222222223d+1*gammabb*t50*
     :         t51*t62)+4.444444444444444d-1*t76*t80+2.6666666666666666d
     ;         +0*t104*t60)+t50*(-8.298933333333333d-3*t56*t96-1.0d+0*t5
     <         *t76*t89-1.3333333333333333d+0*t60*t65*t76+6.2242d-3*t67*
     =         t72+6.2242d-3*t1*t68-1.0d+0*t104*t5*t65-t105*t65)-7.46904
     >         d-3*t43*t66*t93-3.73452d-3*t43*t50*t92-9.305257363490997d
     ?         -1*t4*t5*(4.0513776643071964d+1*t36*t40*t77*t9-1.21541329
     @         92921589d+2*t34*t36*t77*t9-2.769805290180471d+3*t33*t40*t
     1         5*t9+5.539610580360942d+3*t33*t37*t5*t9+8.309415870541416
     2         d+3*t33*t34*t5*t9-1.1079221160721883d+4*t31*t33*t5*t9+2.6
     3         739092584427493d+3*t10*t6*t77*t78+6.702928802236738d+5*t1
     4         4*t5*t6*t78-6.093571638397035d+5*t13*t14*t5*t78-2.2282577
     5         15368958d+3*t12*t17*t6*t77+2.2282577153689576d+3*t13*t14*
     6         t58*t77-4.0513776643071964d+1*t37*t39*t77+1.2154132992921
     7         589d+2*t33*t37*t38*t77-2.4308265985843178d+2*t31*t33*t38*
     8         t77+2.4308265985843178d+2*t30*t34*t35*t77-4.0513776643071
     9         96d+2*t28*t30*t35*t77+4.0513776643071964d+2*t27*t31*t32*t
     :         77-6.077066496460795d+2*t25*t27*t32*t77+6.077066496460793
     ;         d+2*t24*t28*t29*t77-8.507893095045111d+2*t22*t24*t29*t77+
     <         8.507893095045113d+2*t21*t25*t26*t77-1.1343857460060149d+
     =         3*t19*t21*t26*t77+1.1343857460060149d+3*t18*t22*t23*t77-1
     >         .4584959591505905d+3*t16*t18*t23*t77+1.4584959591505908d+
     ?         3*t15*t19*t20*t77-1.8231199489382383d+3*t13*t15*t20*t77+1
     @         .8231199489382383d+3*t12*t16*t17*t77+5.585774001863949d+5
     1         *t17*t5*t58*t6-4.5701787287977763d+5*t12*t20*t5*t6-7.9216
     2         43129916147d+5*t10*t116*t5*t6-4.5701787287977763d+5*t16*t
     3         17*t5*t58+5.077976365330863d+5*t13*t17*t5*t58+9.232684300
     4         601569d+2*t36*t40*t5-1.1079221160721883d+4*t30*t37*t38*t5
     5         +1.6618831741082832d+4*t30*t34*t38*t5+2.2158442321443766d
     6         +4*t30*t31*t38*t5-2.7698052901804704d+4*t28*t30*t38*t5+1.
     7         846536860120314d+3*t36*t37*t5-2.769805290180471d+3*t34*t3
     8         6*t5-2.769805290180471d+4*t27*t34*t35*t5+3.69307372024062
     9         9d+4*t27*t31*t35*t5+4.616342150300784d+4*t27*t28*t35*t5-5
     :         .539610580360942d+4*t25*t27*t35*t5-5.539610580360941d+4*t
     ;         24*t31*t32*t5+6.924513225451174d+4*t24*t28*t32*t5+8.30941
     <         5870541416d+4*t24*t25*t32*t5-9.694318515631648d+4*t22*t24
     =         *t32*t5-9.694318515631648d+4*t21*t28*t29*t5+1.16331822187
     >         57979d+5*t21*t25*t29*t5+1.3572045921884307d+5*t21*t22*t29
     ?         *t5-1.5510909625010635d+5*t19*t21*t29*t5-1.55109096250106
     @         38d+5*t18*t25*t26*t5+1.809606122917908d+5*t18*t22*t26*t5+
     1         2.0681212833347515d+5*t18*t19*t26*t5-2.3266364437515952d+
     2         5*t16*t18*t26*t5-2.3266364437515955d+5*t15*t22*t23*t5+2.6
     3         59013078573252d+5*t15*t19*t23*t5+2.9913897133949086d+5*t1
     4         5*t16*t23*t5-3.3237663482165647d+5*t13*t15*t23*t5-3.32376
     5         6348216565d+5*t12*t19*t20*t5+3.7392371417436354d+5*t12*t1
     6         6*t20*t5+4.1547079352707056d+5*t12*t13*t20*t5)-2.240712d-
     7         2*t56*t77*t87*t88+2.0d+0*t5*t66*t76*t87-9.305257363490997
     8         d-1*t5*t73*t86-4.1356699393293317d-1*t4*t73*t80-2.4814019
     9         63597599d+0*t60*t64*t73-2.48968d-2*t56*t65*t66*t72-1.8610
     :         514726981994d+0*t103*t5*t64-2.481401963597599d+0*t103*t4*
     ;         t60)*wght+Mmat3(iq,D3_RB_RB_TB)
            Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
            Mmat3(iq,D3_RB_GBB_TB) = (t46*(1.0d+0*t5*(-2.789327926079999
     1         7d-4*t44*t52*t74*t88*taub-1.3946639630399998d-4*gammabb*t
     2         106*t51*t88*taub-4.6488798768d-5*t55*t66*t74*taub+4.97936
     3         d-2*t52*t66*t74*taub+2.48968d-2*t51*t66*t74*taub-4.183991
     4         8891199995d-5*t44*t55*t65*t75*t88+4.481424d-2*t44*t52*t65
     5         *t75*t88+2.240712d-2*t44*t51*t65*t75*t88-4.18399188911999
     6         95d-5*gammabb*t54*t65*t74*t88+2.240712d-2*gammabb*t51*t65
     7         *t74*t88+4.481424d-2*gammabb*t47*t65*t74*t88-2.9287943223
     8         839996d-4*gammabb*t44*t51*t70*t88-1.8130631519519996d-4*t
     9         49*t52*t53*t88-4.044525492816d-4*t100*t47*t48*t88+7.46904
     :         d-3*t55*t65*t66*t75+7.46904d-3*t54*t65*t66*t75-4.0d+0*t51
     ;         *t65*t66*t75-1.673596755648d-4*t121*t52*t53*t65*t75-1.673
     <         596755648d-4*gammabb*t121*t44*t51*t65*t74-9.76264774128d-
     =         5*gammabb*t54*t66*t70+5.228328d-2*gammabb*t51*t66*t70+1.0
     >         456655999999999d-1*gammabb*t47*t66*t70-6.043543839839999d
     ?         -5*t44*t49*t55*t66+6.473168d-2*t44*t49*t52*t66+3.236584d-
     @         2*t44*t49*t51*t66-1.673596755648d-4*t106*t121*t47*t48*t65
     1         +1.618292d-2*t49*t50*t55+1.618292d-2*t49*t50*t54-8.666666
     2         666666666d+0*t49*t50*t51)+1.3333333333333333d+0*t107*t60)
     3         -3.73452d-3*t43*t50*t98+4.9793599999999993d-3*t50*t76*t96
     4         -9.305257363490997d-1*t5*t73*t95-4.1839918891199995d-5*t1
     5         08*t56*t65*t88+7.46904d-3*t65*t66*t71*t77+3.73452d-3*t65*
     6         t66*t72*t76+1.3946639630399998d-5*t66*t68*t75-1.240700981
     7         7987995d+0*t60*t69*t73+6.2242d-3*t50*t71*t72-9.3052573634
     8         90997d-1*t103*t5*t69-6.043543839839999d-5*t102*t56*t66-1.
     9         0d+0*t107*t5*t50*t65-1.86726d-3*t1*t105*t50)*wght+Mmat3(i
     :         q,D3_RB_GBB_TB)
            Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
            Mmat3(iq,D3_GBB_GBB_TB) = (-9.305257363490997d-1*t5*t73*t99+
     1         1.0d+0*t46*t5*(-7.812600694878209d-8*t44*t55*t74*t88+8.36
     2         7983778239999d-5*t44*t52*t74*t88+8.367983778239999d-5*t44
     3         *t51*t74*t88-7.812600694878209d-8*gammabb*t106*t54*t88+4.
     4         1839918891199995d-5*gammabb*t106*t51*t88+1.673596755648d-
     5         4*gammabb*t106*t47*t88+1.3946639630399998d-5*t55*t66*t74+
     6         2.7893279260799997d-5*t54*t66*t74-1.4938079999999998d-2*t
     7         51*t66*t74-1.4938079999999998d-2*t47*t66*t74-3.1250402779
     8         51284d-7*t121*t52*t53*t74-3.125040277951284d-7*gammabb*t1
     9         06*t121*t44*t51-3.125040277951284d-7*t121*t47*t48/rhob**1
     :         .2333333333333334d+1)-7.812600694878209d-8*t119*t56*t88-3
     ;         .73452d-3*t101*t50*t77+6.973319815199999d-6*t102*t66*t76-
     <         3.73452d-3*t107*t50*t72+2.7893279260799997d-5*t108*t66*t7
     =         1)*wght+Mmat3(iq,D3_GBB_GBB_TB)
            Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
            Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
            Mmat3(iq,D3_RB_TB_TB) = (t46*(1.0d+0*t5*(-5.578655852159999d
     1         -4*t111*t44*t52*t88*taub-2.7893279260799997d-4*gammabb*t1
     2         10*t51*t88*taub-9.2977597536d-5*t111*t55*t66*taub+1.99174
     3         4d-1*t111*t52*t66*taub-2.7893279260799997d-4*t52*t53*t75*
     4         t88-5.020790266944d-4*gammabb*t44*t51*t74*t88-8.367983778
     5         239999d-5*t112*t44*t55*t65*t88-8.367983778239999d-5*gamma
     6         bb*t111*t54*t65*t88+1.7925696d-1*t112*t44*t52*t65*t88+8.9
     7         62848d-2*gammabb*t111*t51*t65*t88-7.252252607808d-4*t106*
     8         t47*t48*t88-9.2977597536d-5*t44*t55*t66*t75+1.991744d-1*t
     9         44*t52*t66*t75+4.97936d-2*t50*t55*t75-2.6666666666666666d
     :         +1*t50*t52*t75-1.673596755648d-4*gammabb*t54*t66*t74+1.79
     ;         25696000000002d-1*gammabb*t51*t66*t74+2.9876159999999996d
     <         -2*t112*t55*t65*t66-1.6d+1*t112*t52*t65*t66-3.34719351129
     =         6d-4*t112*t121*t52*t53*t65-3.347193511296d-4*gammabb*t111
     >         *t121*t44*t51*t65-3.347193511296d-4*t110*t121*t47*t48*t65
     ?         )+1.3333333333333333d+0*t113*t60)-9.305257363490997d-1*t4
     @         *t5*(-3.646239897876477d+2*t33*t40*t57*t9-7.2924797957529
     1         54d+2*t33*t37*t57*t9+1.0938719693629433d+3*t33*t34*t57*t9
     2         +1.4584959591505908d+3*t31*t33*t57*t9-8.823900552861074d+
     3         4*t14*t57*t6*t78-8.021727775328248d+4*t13*t14*t57*t78+7.3
     4         53250460717561d+4*t17*t57*t58*t6+6.016295831496187d+4*t12
     5         *t20*t57*t6-1.0428246107926724d+5*t10*t116*t57*t6-6.01629
     6         5831496187d+4*t16*t17*t57*t58-6.684773146106873d+4*t13*t1
     7         7*t57*t58-1.2154132992921589d+2*t36*t40*t57-1.45849595915
     8         05908d+3*t30*t37*t38*t57-2.1877439387258865d+3*t30*t34*t3
     9         8*t57+2.9169919183011817d+3*t30*t31*t38*t57+3.64623989787
     :         6477d+3*t28*t30*t38*t57+2.4308265985843178d+2*t36*t37*t57
     ;         +3.646239897876477d+2*t34*t36*t57-3.646239897876477d+3*t2
     <         7*t34*t35*t57-4.8616531971686355d+3*t27*t31*t35*t57+6.077
     =         066496460795d+3*t27*t28*t35*t57+7.292479795752954d+3*t25*
     >         t27*t35*t57-7.292479795752954d+3*t24*t31*t32*t57-9.115599
     ?         744691192d+3*t24*t28*t32*t57+1.0938719693629431d+4*t24*t2
     @         5*t32*t57+1.2761839642567668d+4*t22*t24*t32*t57-1.2761839
     1         642567668d+4*t21*t28*t29*t57-1.5314207571081204d+4*t21*t2
     2         5*t29*t57+1.786657549959474d+4*t21*t22*t29*t57+2.04189434
     3         28108272d+4*t19*t21*t29*t57-2.0418943428108272d+4*t18*t25
     4         *t26*t57-2.3822100666126317d+4*t18*t22*t26*t57+2.72252579
     5         0414436d+4*t18*t19*t26*t57+3.062841514216241d+4*t16*t18*t
     6         26*t57-3.062841514216241d+4*t15*t22*t23*t57-3.50039030196
     7         14174d+4*t15*t19*t23*t57+3.9379390897065947d+4*t15*t16*t2
     8         3*t57+4.375487877451772d+4*t13*t15*t23*t57-4.375487877451
     9         772d+4*t12*t19*t20*t57-4.9224238621332433d+4*t12*t16*t20*
     :         t57+5.469359846814714d+4*t12*t13*t20*t57)-8.3679837782399
     ;         99d-5*t115*t56*t65*t88+1.4938079999999998d-2*t65*t66*t76*
     <         t77+1.24484d-2*t50*t72*t76+2.7893279260799997d-5*t112*t66
     =         *t68-9.2977597536d-5*t108*t56*t66-1.0d+0*t113*t5*t50*t65-
     >         9.305257363490997d-1*t109*t5*t64-1.2407009817987995d+0*t1
     ?         09*t4*t60-7.46904d-3*t105*t43*t50)*wght+Mmat3(iq,D3_RB_TB
     @         _TB)
            Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
            Mmat3(iq,D3_GBB_TB_TB) = (1.0d+0*t46*t5*(-1.5625201389756418
     1         d-7*t111*t44*t55*t88-1.5625201389756418d-7*gammabb*t110*t
     2         54*t88+3.347193511296d-4*t111*t44*t52*t88+8.3679837782399
     3         99d-5*t111*t44*t51*t88+1.673596755648d-4*gammabb*t110*t51
     4         *t88+1.673596755648d-4*gammabb*t110*t47*t88+5.57865585215
     5         9999d-5*t111*t55*t66+2.7893279260799997d-5*t111*t54*t66-2
     6         .9876159999999996d-2*t111*t52*t66-2.9876159999999996d-2*t
     7         111*t51*t66-6.250080555902569d-7*t111*t121*t52*t53-6.2500
     8         80555902569d-7*gammabb*t110*t121*t44*t51-6.25008055590256
     9         9d-7*t121*t47*t48/rhob**1.1333333333333334d+1)-1.56252013
     :         89756418d-7*t56*t85*t88-7.46904d-3*t107*t50*t77+2.7893279
     ;         260799997d-5*t108*t66*t76-1.86726d-3*t113*t50*t72+2.78932
     <         79260799997d-5*t115*t66*t71-9.305257363490997d-1*t109*t5*
     =         t69)*wght+Mmat3(iq,D3_GBB_TB_TB)
            Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
            Mmat3(iq,D3_TB_TB_TB) = (-9.305257363490997d-1*t4*t5*(-4.8d+
     1         1*t33*t40*t9-2.88d+2*t33*t37*t9-4.32d+2*t33*t34*t9-1.92d+
     2         2*t31*t33*t9-3.4848d+4*t14*t6*t78-1.056d+4*t13*t14*t78-2.
     3         904d+4*t17*t58*t6-7.92d+3*t12*t20*t6-1.3728d+4*t10*t116*t
     4         6-7.92d+3*t16*t17*t58-2.64d+4*t13*t17*t58-4.8d+1*t36*t40-
     5         1.92d+2*t30*t37*t38-8.64d+2*t30*t34*t38-1.152d+3*t30*t31*
     6         t38-4.8d+2*t28*t30*t38-9.6d+1*t36*t37-4.8d+1*t34*t36-4.8d
     7         +2*t27*t34*t35-1.92d+3*t27*t31*t35-2.4d+3*t27*t28*t35-9.6
     8         d+2*t25*t27*t35-9.6d+2*t24*t31*t32-3.6d+3*t24*t28*t32-4.3
     9         2d+3*t24*t25*t32-1.68d+3*t22*t24*t32-1.68d+3*t21*t28*t29-
     :         6.048d+3*t21*t25*t29-7.056d+3*t21*t22*t29-2.688d+3*t19*t2
     ;         1*t29-2.688d+3*t18*t25*t26-9.408d+3*t18*t22*t26-1.0752d+4
     <         *t18*t19*t26-4.032d+3*t16*t18*t26-4.032d+3*t15*t22*t23-1.
     =         3824d+4*t15*t19*t23-1.5552d+4*t15*t16*t23-5.76d+3*t13*t15
     >         *t23-5.76d+3*t12*t19*t20-1.944d+4*t12*t16*t20-2.16d+4*t12
     ?         *t13*t20)+1.0d+0*t46*t5*(-3.1250402779512837d-7*t124*t44*
     @         t55*t88-3.1250402779512837d-7*gammabb*t125*t54*t88+1.0041
     1         580533887999d-3*t124*t44*t52*t88+5.020790266944d-4*gammab
     2         b*t125*t51*t88+1.6735967556479997d-4*t124*t55*t66-1.79256
     3         96d-1*t124*t52*t66-1.2500161111805136d-6*t121*t124*t52*t5
     4         3-1.2500161111805136d-6*gammabb*t121*t125*t44*t51-1.25001
     5         61111805136d-6*t121*t47*t48/rhob**1.0333333333333333d+1)-
     6         3.1250402779512837d-7*t56*t63*t88-1.120356d-2*t113*t50*t7
     7         7+8.367983778239998d-5*t115*t66*t76)*wght+Mmat3(iq,D3_TB_
     8         TB_TB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
