C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_m06.F 
C> The nwxcm_c_m06 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_m06 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {\it t_{11}}\,\left(-0.0598079686361971\,{
C>    \it t_{14}}\,{\it t_{15}}\,\left(0.1274696188700087\,{
C>    \it t_{12}}+1.0\right)\,{\it t_{17}}\,\log 
C>    \left({{32.16395899738507}\over{11.12037486309469\,{\it t_{21}}
C>    +3.844746237447211\,{\it t_{12}}+1.644733775567609\,{\it t_{20}}
C>    +0.2405871291288192\,{\it t_{19}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_{12}}
C>    +1.0\right)\,\left({\it t_{18}}+1.923661050931536\,{
C>    \it t_{17}}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{21}}+2.247591863577616\,{
C>    \it t_{12}}+0.4300972471276643\,{\it t_{20}}
C>    +0.1911512595127337\,{\it t_{19}}}}+1.0\right)-0.0621814
C>    \,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{21}}+2.225569421150687\,{
C>    \it t_{12}}+0.8004286349993635\,{\it t_{20}}
C>    +0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)-{
C>    \it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}\,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{26}} &=& {\it t_{25}}\,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{27}} &=& {\it t_{26}}+{\it t_{24}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{0.0031\,{\it t_{27}}+1.0}}\\\\ 
C>   {\it t_{29}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{30}} &=& {{1}\over{0.06\,{\it t_{23}}\,
C>    \sigma_{\alpha\alpha}+1.0}}\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{32}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{33}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{34}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\tau_\alpha}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_{37}} &=& {{2.0\,\tau_\alpha}
C>    \over{\rho_\alpha^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{38}} &=& 0.00515088\,\left({\it t_{37}}+{\it t_{24}}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{39}} &=& {{1}\over{{\it t_{38}}}}\\\\ 
C>   {\it t_{40}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{41}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{42}} &=& {{1}\over{{\it t_{38}}^2}}\\\\ 
C>   {\it t_{43}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{44}} &=& {\it t_{37}}-9.11559972\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{48}} &=& {{1}\over{0.06\,{\it t_{25}}\,
C>    \sigma_{\beta\beta}+1.0}}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{\tau_\beta}}\\\\ 
C>   {\it t_{50}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{51}} &=& {{2.0\,\tau_\beta}\over{\rho_\beta^{{{5}
C>    \over{3}}}}}\\\\ 
C>   {\it t_{52}} &=& 0.00515088\,\left({\it t_{51}}+{\it t_{26}}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{53}} &=& {{1}\over{{\it t_{52}}}}\\\\ 
C>   {\it t_{54}} &=& {{1}\over{{\it t_{52}}^2}}\\\\ 
C>   {\it t_{55}} &=& {\it t_{51}}-9.11559972\\\\ 
C>   {\it t_{56}} &=& 0.00304966\,\left({\it t_{51}}+{\it t_{37}}
C>    +{\it t_{26}}+{\it t_{24}}-18.23119944\right)+1.0\\\\ 
C>   {\it t_{57}} &=& {{1}\over{{\it t_{56}}}}\\\\ 
C>   {\it t_{58}} &=& {{1}\over{{\it t_{56}}^2}}\\\\ 
C>   {\it t_{59}} &=& {\it t_{51}}+{\it t_{37}}-18.23119944\\\\ 
C>   {\it t_{60}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{61}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{62}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{63}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{64}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{63}}+2.225569421150687\,{\it t_{62}}+0.8004286349993635
C>    \,{\it t_{61}}+0.1897004325747558\,{\it t_{60}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{62}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{63}}+3.844746237447211\,{\it t_{62}}+1.644733775567609
C>    \,{\it t_{61}}+0.2405871291288192\,{\it t_{60}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{62}}+1.0\right)\\\\ 
C>   {\it t_{65}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{66}} &=& {{1}\over{0.06\,{\it t_{65}}\,\sigma_{ss}
C>    +1.0}}\\\\ 
C>   {\it t_{67}} &=& {{1}\over{\tau_s}}\\\\ 
C>   {\it t_{68}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{69}} &=& {{2.0\,\tau_s}\over{\rho_s^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{70}} &=& 0.00515088\,\left({\it t_{69}}+{\it t_{65}}
C>    \,\sigma_{ss}-9.11559972\right)+1.0\\\\ 
C>   {\it t_{71}} &=& {{1}\over{{\it t_{70}}}}\\\\ 
C>   {\it t_{72}} &=& {{1}\over{{\it t_{70}}^2}}\\\\ 
C>   {\it t_{73}} &=& {\it t_{69}}-9.11559972\\\\ 
C>   f &=& 1.0\,{\it t_{22}}\,{\it t_{57}}\,\left({\it param}
C>    \left(3\right)\,{\it t_{59}}\,{\it t_{57}}+{\it param}
C>    \left(2\right)\,{\it t_{27}}\,{\it t_{57}}+{\it param}
C>    \left(6\right)\,{\it t_{59}}^2\,{\it t_{58}}+{\it param}
C>    \left(5\right)\,{\it t_{27}}\,{\it t_{59}}\,{\it t_{58}}+{
C>    \it param}\left(4\right)\,{\it t_{27}}^2\,{\it t_{58}}+{
C>    \it param}\left(1\right)\right)+1.0\,{\it t_{10}}\,\rho_\beta
C>    \,\left(1.0-0.125\,{\it t_{50}}\,\sigma_{\beta\beta}\,{
C>    \it t_{49}}\right)\,{\it t_{53}}\,\left({\it t_{47}}\,{
C>    \it t_{55}}\,{\it t_{53}}+{\it t_{46}}\,{\it t_{25}}\,
C>    \sigma_{\beta\beta}\,{\it t_{53}}+{\it t_{45}}\,{\it t_{55}}^2
C>    \,{\it t_{54}}+{\it t_{43}}\,{\it t_{25}}\,\sigma_{\beta\beta}
C>    \,{\it t_{55}}\,{\it t_{54}}+{{{\it t_{41}}\,
C>    \sigma_{\beta\beta}^2\,{\it t_{54}}}
C>    \over{\rho_\beta^{{{16}\over{3}}}}}+{\it t_{40}}\right)+0.5
C>    \,{\it t_{10}}\,\rho_\beta\,\left(0.06\,{\it t_{25}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,\left(0.06\,{\it t_{25}}
C>    \,\sigma_{\beta\beta}\,{\it t_{48}}\,\left(0.06\,{\it t_{25}}
C>    \,\sigma_{\beta\beta}\,{\it t_{48}}\,\left(0.06\,{\it t_{34}}
C>    \,{\it t_{25}}\,\sigma_{\beta\beta}\,{\it t_{48}}+{
C>    \it t_{33}}\right)+{\it t_{32}}\right)+{\it t_{31}}\right)+{
C>    \it t_{29}}\right)\,{\it t_{49}}\,\left(2.0\,\tau_\beta-0.25
C>    \,{\it t_{50}}\,\sigma_{\beta\beta}\right)+1.0\,{\it t_5}
C>    \,\rho_\alpha\,\left(1.0-0.125\,{\it t_{36}}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{35}}\right)\,{\it t_{39}}
C>    \,\left({\it t_{47}}\,{\it t_{44}}\,{\it t_{39}}+{\it t_{46}}
C>    \,{\it t_{23}}\,\sigma_{\alpha\alpha}\,{\it t_{39}}+{
C>    \it t_{45}}\,{\it t_{44}}^2\,{\it t_{42}}+{\it t_{43}}\,{
C>    \it t_{23}}\,\sigma_{\alpha\alpha}\,{\it t_{44}}\,{\it t_{42}}
C>    +{{{\it t_{41}}\,\sigma_{\alpha\alpha}^2\,{\it t_{42}}}
C>    \over{\rho_\alpha^{{{16}\over{3}}}}}+{\it t_{40}}\right)+0.5
C>    \,{\it t_5}\,\rho_\alpha\,\left(0.06\,{\it t_{23}}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{30}}\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{30}}\,\left(0.06\,{
C>    \it t_{23}}\,\sigma_{\alpha\alpha}\,{\it t_{30}}\,\left(0.06
C>    \,{\it t_{34}}\,{\it t_{23}}\,\sigma_{\alpha\alpha}\,{
C>    \it t_{30}}+{\it t_{33}}\right)+{\it t_{32}}\right)+{
C>    \it t_{31}}\right)+{\it t_{29}}\right)\,{\it t_{35}}\,
C>    \left(2.0\,\tau_\alpha-0.25\,{\it t_{36}}\,
C>    \sigma_{\alpha\alpha}\right)+1.0\,{\it t_{22}}\,\left(0.0031
C>    \,{\it t_{27}}\,{\it t_{28}}\,\left(0.0031\,{\it t_{27}}\,{
C>    \it t_{28}}\,\left(0.0031\,{\it t_{27}}\,{\it t_{28}}\,
C>    \left(0.0031\,{\it param}\left(17\right)\,{\it t_{27}}\,{
C>    \it t_{28}}+{\it param}\left(16\right)\right)+{
C>    \it param}\left(15\right)\right)+{\it param}
C>    \left(14\right)\right)+{\it param}\left(13\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,{\it t_{64}}\,\rho_s\,\left(1.0-0.125\,{\it t_{68}}
C>    \,\sigma_{ss}\,{\it t_{67}}\right)\,{\it t_{71}}\,\left({
C>    \it t_{47}}\,{\it t_{73}}\,{\it t_{71}}+{\it t_{46}}\,{
C>    \it t_{65}}\,\sigma_{ss}\,{\it t_{71}}+{\it t_{45}}\,{
C>    \it t_{73}}^2\,{\it t_{72}}+{\it t_{43}}\,{\it t_{65}}
C>    \,\sigma_{ss}\,{\it t_{73}}\,{\it t_{72}}+{{{\it t_{41}}
C>    \,\sigma_{ss}^2\,{\it t_{72}}}\over{\rho_s^{{{16}\over{3}}}}}
C>    +{\it t_{40}}\right)+0.5\,{\it t_{64}}\,\rho_s\,\left(0.06
C>    \,{\it t_{65}}\,\sigma_{ss}\,{\it t_{66}}\,\left(0.06\,{
C>    \it t_{65}}\,\sigma_{ss}\,{\it t_{66}}\,\left(0.06\,{
C>    \it t_{65}}\,\sigma_{ss}\,{\it t_{66}}\,\left(0.06\,{
C>    \it t_{34}}\,{\it t_{65}}\,\sigma_{ss}\,{\it t_{66}}+{
C>    \it t_{33}}\right)+{\it t_{32}}\right)+{\it t_{31}}\right)+{
C>    \it t_{29}}\right)\,{\it t_{67}}\,\left(2.0\,\tau_s-0.25\,{
C>    \it t_{68}}\,\sigma_{ss}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, DG Truhlar, J.Chem.Phys. 123, 194101 (2006)  , DOI: 
C> <a href="http://dx.doi.org/10.1063/1.2370993 "> 
C> 10.1063/1.2370993 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_m06(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.2d-3*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(17)
              t5 = 6.2d-3*gammaaa*t1*t3*t4+param(16)
              t6 = 6.2d-3*gammaaa*t1*t3*t5+param(15)
              t7 = 6.2d-3*gammaaa*t1*t3*t6+param(14)
              t8 = 6.2d-3*gammaaa*t1*t3*t7+param(13)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = -2*rhoa*t22
              t24 = t23-1.243628d-1*rhoa*(1.0522000558389212d-1*t12+1.0d
     1           +0)*log(1.6081979498692536d+1/(1.19503784087549d-1*t9+5
     2           .329846514438383d+0*t13+1.766435620181429d+0*t12+5.6598
     3           85156639418d-1*t11)+1.0d+0)
              t25 = 6.0d-2*gammaaa*t1+1.0d+0
              t26 = 1/t25
              t27 = param(22)
              t28 = 6.0d-2*gammaaa*t1*t26*t27+param(21)
              t29 = 6.0d-2*gammaaa*t1*t26*t28+param(20)
              t30 = 6.0d-2*gammaaa*t1*t26*t29+param(19)
              t31 = 6.0d-2*gammaaa*t1*t26*t30+param(18)
              t32 = 1/taua
              t33 = 1/rhoa
              t34 = 2.0d+0*taua-2.5d-1*gammaaa*t33
              t35 = 1.0d+0-1.25d-1*gammaaa*t32*t33
              t36 = 1/rhoa**1.6666666666666669d+0
              t37 = 2.0d+0*t36*taua
              t38 = 5.15088d-3*(t37+gammaaa*t1-9.11559972d+0)+1.0d+0
              t39 = 1/t38
              t40 = param(10)
              t41 = gammaaa**2
              t42 = 1/rhoa**5.333333333333333d+0
              t43 = 1/t38**2
              t44 = param(11)
              t45 = t37-9.11559972d+0
              t46 = param(12)
              t47 = t45**2
              t48 = param(8)
              t49 = param(9)
              t50 = t39*t45*t49+gammaaa*t1*t39*t48+t43*t46*t47+gammaaa*t
     1           1*t43*t44*t45+t40*t41*t42*t43+param(7)
              t51 = 4.0d+0*t36*taua
              t52 = 3.04966d-3*(t51+2*gammaaa*t1-1.823119944d+1)+1.0d+0
              t53 = 1/t52
              t54 = param(4)
              t55 = 1/t52**2
              t56 = param(5)
              t57 = t51-1.823119944d+1
              t58 = param(6)
              t59 = t57**2
              t60 = param(2)
              t61 = param(3)
              t62 = t53*t57*t61+2*gammaaa*t1*t53*t60+t55*t58*t59+2*gamma
     1           aa*t1*t55*t56*t57+4*t41*t42*t54*t55+param(1)
              t63 = 1.414213562373095d+0
              t64 = 7.937005259840998d-1
              t65 = 1.1950378408754898d-1*t9+2.2255694211506874d+0*t12*t
     1           64+8.004286349993635d-1*t11/t63+5.329846514438382d+0*t1
     2           3
              t66 = 1.6081979498692536d+1/t65+1.0d+0
              t67 = log(t66)
              t68 = 1.3256889990520176d-1*t12*t64+1.0d+0
              t69 = 1/t10**3
              t70 = 1/rhoa**1.3333333333333333d+0
              t71 = 1/rhoa**1.1666666666666667d+0
              t72 = 1.1102230246251565d-16*t21*(-9.970917392951799d-1*t7
     1           1-7.418564737168958d-1*t70-4.002143174996817d-1*t69-1.2
     2           64669550498372d-1*t36)/(t18**2*t19)+1.0d+0*t17*(-1.8533
     3           958105157808d+0*t71-1.2815820791490704d+0*t70-8.2236688
     4           77838045d-1*t69-1.6039141941921276d-1*t36)/(t14**2*t15)
     5           +3.0506411443514264d-19*t20*t70+1.3210398931339265d-3*t
     6           16*t70
              t73 = 3.968502629920499d-1
              t74 = 2*rhoa*(1.0d+0*t68*(-7.418564737168958d-1*t70*t73-4.
     1           4415387620319857d-1*t71-4.002143174996817d-1*t69/t63**3
     2           -3.9834594695849657d-2*t36)/(t65**2*t66)+2.747773264188
     3           437d-3*t67*t70*t73)-rhoa*t72-6.21814d-2*t67*t68+6.90352
     4           2198342671d-18*t20*t21+3.1090699999999993d-2*t16*t17
              t75 = 1/t2**2
              t76 = 1/rhoa**6.333333333333333d+0
              t77 = 1/rhoa**3.6666666666666664d+0
              t78 = t23-1.243628d-1*rhoa*t67*t68
              t79 = 1/t25**2
              t80 = -3.3333333333333337d+0*t1*taua-2.6666666666666666d+0
     1           *gammaaa*t77
              t81 = 1/t38**3
              t82 = 1/t52**3
              t83 = 1/rhoa**8
              t84 = 1/taua**2
              t85 = 1/rhoa**7
              t86 = 1/rhoa**4.333333333333333d+0
              fnc(iq) = (1.0d+0*t24*t8+1.0d+0*t24*t53*t62+2.0d+0*rhoa*t2
     1           2*t35*t39*t50+1.0d+0*rhoa*t22*t31*t32*t34)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t53*(1.0d+0*t78*(-3.3333333333333337d+0*
     1           t1*t53*t61*taua-6.666666666666667d+0*t1*t55*t57*t58*tau
     2           a-6.666666666666667d+0*gammaaa*t42*t55*t56*taua-6.09932
     3           d-3*t58*t59*t80*t82-1.219864d-2*gammaaa*t1*t56*t57*t80*
     4           t82-2.439728d-2*t41*t42*t54*t80*t82-3.04966d-3*t55*t57*
     5           t61*t80-6.09932d-3*gammaaa*t1*t55*t60*t80-2.66666666666
     6           66666d+0*gammaaa*t53*t60*t77-2.6666666666666666d+0*gamm
     7           aaa*t55*t56*t57*t77-1.0666666666666666d+1*t41*t54*t55*t
     8           76)+1.0d+0*t62*t74)+t39*(1.0d+0*rhoa*t22*t35*(-3.333333
     9           3333333337d+0*t1*t39*t49*taua-6.666666666666667d+0*t1*t
     :           43*t45*t46*taua-3.3333333333333337d+0*gammaaa*t42*t43*t
     ;           44*taua-1.030176d-2*t46*t47*t80*t81-1.030176d-2*gammaaa
     <           *t1*t44*t45*t80*t81-1.030176d-2*t40*t41*t42*t80*t81-5.1
     =           5088d-3*t43*t45*t49*t80-5.15088d-3*gammaaa*t1*t43*t48*t
     >           80-2.6666666666666666d+0*gammaaa*t39*t48*t77-2.66666666
     ?           66666666d+0*gammaaa*t43*t44*t45*t77-5.333333333333333d+
     @           0*t40*t41*t43*t76)+1.0d+0*rhoa*t35*t50*t72+1.0d+0*t22*t
     1           35*t50)-3.04966d-3*t55*t62*t78*t80-5.15088d-3*rhoa*t22*
     2           t35*t43*t50*t80+1.0d+0*t74*t8+t32*(5.0d-1*rhoa*t22*t34*
     3           (6.0d-2*gammaaa*t1*t26*(6.0d-2*gammaaa*t1*t26*(6.0d-2*g
     4           ammaaa*t1*t26*(9.599999999999997d-3*t27*t41*t76*t79-1.5
     5           999999999999998d-1*gammaaa*t26*t27*t77)+9.5999999999999
     6           97d-3*t28*t41*t76*t79-1.5999999999999998d-1*gammaaa*t26
     7           *t28*t77)+9.599999999999997d-3*t29*t41*t76*t79-1.599999
     8           9999999998d-1*gammaaa*t26*t29*t77)+9.599999999999997d-3
     9           *t30*t41*t76*t79-1.5999999999999998d-1*gammaaa*t26*t30*
     :           t77)+5.0d-1*rhoa*t31*t34*t72+5.0d-1*t22*t31*t34)+1.0d+0
     ;           *(6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*(6.2d-3*ga
     <           mmaaa*t1*t3*(5.125333333333332d-5*t4*t41*t75*t76-8.2666
     =           66666666665d-3*gammaaa*t3*t4*t77)-8.266666666666665d-3*
     >           gammaaa*t3*t5*t77+5.125333333333332d-5*t41*t5*t75*t76)-
     ?           8.266666666666665d-3*gammaaa*t3*t6*t77+5.12533333333333
     @           2d-5*t41*t6*t75*t76)-8.266666666666665d-3*gammaaa*t3*t7
     1           *t77+5.125333333333332d-5*t41*t7*t75*t76)*t78+1.25d-1*g
     2           ammaaa*t22*t32*t33*t39*t50+1.25d-1*gammaaa*t22*t31*t32*
     3           t33)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (1.0d+0*t53*t78*(-2.439728d-2*t41*t54*t8
     1           2*t83-6.09932d-3*t1*t58*t59*t82-1.219864d-2*gammaaa*t42
     2           *t56*t57*t82-3.04966d-3*t1*t55*t57*t61-6.09932d-3*gamma
     3           aa*t42*t55*t60+t1*t53*t60+t1*t55*t56*t57+4*gammaaa*t42*
     4           t54*t55)+1.0d+0*rhoa*t22*t35*t39*(-1.030176d-2*t40*t41*
     5           t81*t83-1.030176d-2*t1*t46*t47*t81-1.030176d-2*gammaaa*
     6           t42*t44*t45*t81-5.15088d-3*t1*t43*t45*t49-5.15088d-3*ga
     7           mmaaa*t42*t43*t48+t1*t39*t48+t1*t43*t44*t45+2*gammaaa*t
     8           40*t42*t43)+t32*(5.0d-1*rhoa*t22*t34*(6.0d-2*gammaaa*t1
     9           *t26*(6.0d-2*gammaaa*t1*t26*(6.0d-2*gammaaa*t1*t26*(6.0
     :           d-2*t1*t26*t27-3.6d-3*gammaaa*t27*t42*t79)-3.6d-3*gamma
     ;           aa*t28*t42*t79+6.0d-2*t1*t26*t28)-3.6d-3*gammaaa*t29*t4
     <           2*t79+6.0d-2*t1*t26*t29)-3.6d-3*gammaaa*t30*t42*t79+6.0
     =           d-2*t1*t26*t30)-1.25d-1*t22*t31)+1.0d+0*(6.2d-3*gammaaa
     >           *t1*t3*(6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*(3.1
     ?           d-3*t1*t3*t4-1.9219999999999998d-5*gammaaa*t4*t42*t75)-
     @           1.9219999999999998d-5*gammaaa*t42*t5*t75+3.1d-3*t1*t3*t
     1           5)-1.9219999999999998d-5*gammaaa*t42*t6*t75+3.1d-3*t1*t
     2           3*t6)-1.9219999999999998d-5*gammaaa*t42*t7*t75+3.1d-3*t
     3           1*t3*t7)*t78-3.04966d-3*t1*t55*t62*t78-5.15088d-3*t22*t
     4           35*t36*t43*t50-1.25d-1*t22*t32*t39*t50)*wght+Cmat(iq,D1
     5           _GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (-1.030176d-2*t22*t35*t43*t50*t9+1.0d+0*t
     1           53*t78*(-2.439728d-2*gammaaa*t56*t57*t82*t86-1.219864d-
     2           2*gammaaa*t55*t60*t86+4.0d+0*gammaaa*t55*t56*t86-4.8794
     3           56d-2*t41*t54*t82*t85-1.219864d-2*t36*t58*t59*t82-6.099
     4           32d-3*t36*t55*t57*t61+2.0d+0*t36*t53*t61+4.0d+0*t36*t55
     5           *t57*t58)+1.0d+0*rhoa*t22*t35*t39*(-2.060352d-2*gammaaa
     6           *t44*t45*t81*t86-1.030176d-2*gammaaa*t43*t48*t86+2.0d+0
     7           *gammaaa*t43*t44*t86-2.060352d-2*t40*t41*t81*t85-2.0603
     8           52d-2*t36*t46*t47*t81-1.030176d-2*t36*t43*t45*t49+2.0d+
     9           0*t36*t39*t49+4.0d+0*t36*t43*t45*t46)+1.25d-1*gammaaa*t
     :           22*t39*t50*t84-5.0d-1*rhoa*t22*t31*t34*t84-6.09932d-3*t
     ;           36*t55*t62*t78+1.0d+0*rhoa*t22*t31*t32)*wght+Mmat(iq,D1
     <           _TA)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = 1/rhoa**3.3333333333333337d+0
              t10 = param(9)
              t11 = param(8)
              t12 = param(11)
              t13 = 1.6d-99*t5*t8*t9+t4*t5*t7+4.0d-50*t1*t12*t5*t6+t10*t
     1           3*t6+4.0d-50*t1*t11*t3+param(7)
              t14 = 1/rhoa**6.666666666666666d-1
              t15 = rhoa**5.0d-1
              t16 = 1/t15
              t17 = 1/rhoa**3.333333333333333d-1
              t18 = 1/rhoa**1.6666666666666666d-1
              t19 = 1.1120374863094686d+1*t18+3.8447462374472113d+0*t17+
     1           1.644733775567609d+0*t16+2.4058712912881916d-1*t14
              t20 = 3.216395899738507d+1/t19+1.0d+0
              t21 = log(t20)
              t22 = 1.274696188700087d-1*t17+1.0d+0
              t23 = 5.982550435771079d+0*t18+2.2255694211506874d+0*t17+8
     1           .004286349993635d-1*t16+1.8970043257475583d-1*t14
              t24 = 1.6081979498692536d+1/t23+1.0d+0
              t25 = log(t24)
              t26 = 1.3256889990520176d-1*t17+1.0d+0
              t27 = -6.903522198342671d-18*t25*t26-3.1090699999999993d-2
     1           *t21*t22
              t28 = 2.4d-51*t1+1.0d+0
              t29 = 1/t28
              t30 = param(22)
              t31 = 2.4d-51*t1*t29*t30+param(21)
              t32 = 2.4d-51*t1*t29*t31+param(20)
              t33 = 2.4d-51*t1*t29*t32+param(19)
              t34 = 2.4d-51*t1*t29*t33+param(18)
              t35 = 3.04966d-3*(1.2d-49*t1-1.823119944d+1)+1.0d+0
              t36 = 1/t35
              t37 = param(6)
              t38 = 1/t35**2
              t39 = 4.0d-50*t1-1.823119944d+1
              t40 = t39**2
              t41 = param(4)
              t42 = param(3)
              t43 = param(2)
              t44 = param(5)
              t45 = 6.4d-99*t38*t41*t9+8.0d-50*t1*t38*t39*t44+8.0d-50*t1
     1           *t36*t43+t36*t39*t42+t37*t38*t40+param(1)
              t46 = -2*rhoa*t27
              t47 = t46-1.243628d-1*rhoa*(1.0522000558389212d-1*t17+1.0d
     1           +0)*log(1.6081979498692536d+1/(5.329846514438383d+0*t18
     2           +1.766435620181429d+0*t17+5.659885156639418d-1*t16+1.19
     3           503784087549d-1*t14)+1.0d+0)
              t48 = 2.4799999999999997d-52*t1+1.0d+0
              t49 = 1/t48
              t50 = param(17)
              t51 = 2.4799999999999997d-52*t1*t49*t50+param(16)
              t52 = 2.4799999999999997d-52*t1*t49*t51+param(15)
              t53 = 2.4799999999999997d-52*t1*t49*t52+param(14)
              t54 = 2.4799999999999997d-52*t1*t49*t53+param(13)
              t55 = 1/t15**3
              t56 = 1/rhoa**1.3333333333333333d+0
              t57 = 1/rhoa**1.1666666666666667d+0
              t58 = 1.1102230246251565d-16*t26*(-9.970917392951799d-1*t5
     1           7-7.418564737168958d-1*t56-4.002143174996817d-1*t55-1.2
     2           64669550498372d-1*t1)/(t23**2*t24)+1.0d+0*t22*(-1.85339
     3           58105157808d+0*t57-1.2815820791490704d+0*t56-8.22366887
     4           7838045d-1*t55-1.6039141941921276d-1*t1)/(t19**2*t20)+3
     5           .0506411443514264d-19*t25*t56+1.3210398931339265d-3*t21
     6           *t56
              t59 = 1/t28**2
              t60 = 1/rhoa**4.333333333333333d+0
              t61 = 1/rhoa**2.6666666666666666d+0
              t62 = 1.414213562373095d+0
              t63 = 7.937005259840998d-1
              t64 = 2.2255694211506874d+0*t17*t63+8.004286349993635d-1*t
     1           16/t62+5.329846514438382d+0*t18+1.1950378408754898d-1*t
     2           14
              t65 = 1.6081979498692536d+1/t64+1.0d+0
              t66 = log(t65)
              t67 = 1.3256889990520176d-1*t17*t63+1.0d+0
              t68 = 3.968502629920499d-1
              t69 = 2*rhoa*(1.0d+0*t67*(-7.418564737168958d-1*t56*t68-4.
     1           002143174996817d-1*t55/t62**3-4.4415387620319857d-1*t57
     2           -3.9834594695849657d-2*t1)/(t64**2*t65)+2.7477732641884
     3           37d-3*t56*t66*t68)-6.21814d-2*t66*t67-rhoa*t58+6.903522
     4           198342671d-18*t25*t26+3.1090699999999993d-2*t21*t22
              t70 = 1/t2**3
              t71 = 1/rhoa**6
              t72 = t46-1.243628d-1*rhoa*t66*t67
              t73 = 1/t48**2
              t74 = 1/t35**3
              fnc(iq) = (1.0d+0*t47*t54+1.0d+0*t36*t45*t47+1.0d+0*rhoa*t
     1           27*t34+1.0d+0*rhoa*t13*t27*t3)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t3*(5.0d-1*rhoa*t27*(1.6482816d-150*t70*
     1           t71*t8-5.333333333333334d-99*t5*t60*t8+1.030176d-51*t4*
     2           t61*t7*t70+4.1207039999999995d-101*t12*t6*t60*t70-6.666
     3           666666666666d-50*t4*t5*t6*t61-6.666666666666666d-50*t12
     4           *t5*t6*t61+5.15088d-52*t10*t5*t6*t61-6.666666666666666d
     5           -50*t11*t3*t61-3.333333333333333d-50*t10*t3*t61-1.33333
     6           33333333333d-99*t12*t5*t60+2.0603519999999997d-101*t11*
     7           t5*t60)+5.0d-1*rhoa*t13*t58+5.0d-1*t13*t27)+t36*(1.0d+0
     8           *t72*(3.9035648d-150*t41*t71*t74+6.09932d-52*t37*t40*t6
     9           1*t74+4.8794560000000003d-101*t39*t44*t60*t74-6.6666666
     :           66666666d-50*t38*t39*t44*t61-6.666666666666666d-50*t36*
     ;           t43*t61+3.04966d-52*t38*t39*t42*t61-3.333333333333333d-
     <           50*t36*t42*t61-6.666666666666666d-50*t37*t38*t39*t61-2.
     =           6666666666666666d-99*t38*t44*t60+2.4397280000000002d-10
     >           1*t38*t43*t60-1.0666666666666666d-98*t38*t41*t60)+1.0d+
     ?           0*t45*t69)+1.0d+0*t72*(2.4799999999999997d-52*t1*t49*(2
     @           .4799999999999997d-52*t1*t49*(2.4799999999999997d-52*t1
     1           *t49*(5.125333333333333d-104*t50*t60*t73-2.066666666666
     2           6667d-52*t49*t50*t61)+5.125333333333333d-104*t51*t60*t7
     3           3-2.0666666666666667d-52*t49*t51*t61)+5.125333333333333
     4           d-104*t52*t60*t73-2.0666666666666667d-52*t49*t52*t61)+5
     5           .125333333333333d-104*t53*t60*t73-2.0666666666666667d-5
     6           2*t49*t53*t61)+3.04966d-52*t38*t45*t61*t72+1.0d+0*t54*t
     7           69+5.0d-1*rhoa*t27*(2.4d-51*t1*t29*(2.4d-51*t1*t29*(2.4
     8           d-51*t1*t29*(9.6d-102*t30*t59*t60-4.0d-51*t29*t30*t61)-
     9           4.0d-51*t29*t31*t61+9.6d-102*t31*t59*t60)-4.0d-51*t29*t
     :           32*t61+9.6d-102*t32*t59*t60)-4.0d-51*t29*t33*t61+9.6d-1
     ;           02*t33*t59*t60)+5.0d-1*rhoa*t34*t58+2.57544d-52*t1*t13*
     <           t27*t5+5.0d-1*t27*t34)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = param(17)
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = gammaaa*t2
              t4 = 1/rhob**2.6666666666666666d+0
              t5 = gammabb*t4
              t6 = t5+t3
              t7 = 3.1d-3*t6+1.0d+0
              t8 = 1/t7
              t9 = 3.1d-3*t1*t6*t8+param(16)
              t10 = 3.1d-3*t6*t8*t9+param(15)
              t11 = 3.1d-3*t10*t6*t8+param(14)
              t12 = 3.1d-3*t11*t6*t8+param(13)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/rhob**6.666666666666666d-1
              t28 = rhob**5.0d-1
              t29 = 1/t28
              t30 = 1/rhob**3.333333333333333d-1
              t31 = 1/rhob**1.6666666666666666d-1
              t32 = 1.1120374863094686d+1*t31+3.8447462374472113d+0*t30+
     1           1.644733775567609d+0*t29+2.4058712912881916d-1*t27
              t33 = 3.216395899738507d+1/t32+1.0d+0
              t34 = log(t33)
              t35 = 1.274696188700087d-1*t30+1.0d+0
              t36 = 5.982550435771079d+0*t31+2.2255694211506874d+0*t30+8
     1           .004286349993635d-1*t29+1.8970043257475583d-1*t27
              t37 = 1.6081979498692536d+1/t36+1.0d+0
              t38 = log(t37)
              t39 = 1.3256889990520176d-1*t30+1.0d+0
              t40 = -6.903522198342671d-18*t38*t39-3.1090699999999993d-2
     1           *t34*t35
              t41 = rhob+rhoa
              t42 = 1/t41**3.333333333333333d-1
              t43 = 1.3256889990520176d-1*t42+1.0d+0
              t44 = rhoa-rhob
              t45 = t44**4
              t46 = 1/t41**4
              t47 = 1/t41
              t48 = 1.0d+0-t44*t47
              t49 = t44*t47+1.0d+0
              t50 = t49**1.3333333333333333d+0+t48**1.3333333333333333d+
     1           0-2.0d+0
              t51 = -1.923661050931536d+0*t45*t46*t50
              t52 = t51+1.0d+0
              t53 = 1/t41**6.666666666666666d-1
              t54 = t41**5.0d-1
              t55 = 1/t54
              t56 = 1/t41**1.6666666666666666d-1
              t57 = 5.982550435771079d+0*t56+8.004286349993635d-1*t55+1.
     1           8970043257475583d-1*t53+2.2255694211506874d+0*t42
              t58 = 1.6081979498692536d+1/t57+1.0d+0
              t59 = log(t58)
              t60 = -6.21814d-2*t43*t52*t59
              t61 = 6.901399211255825d-2*t42+1.0d+0
              t62 = t51+1.923661050931536d+0*t50
              t63 = 8.157414703487641d+0*t56+4.3009724712766434d-1*t55+1
     1           .9115125951273373d-1*t53+2.247591863577616d+0*t42
              t64 = 2.9608813203268075d+1/t63+1.0d+0
              t65 = log(t64)
              t66 = 1.9751631321680768d-2*t61*t62*t65
              t67 = 1.274696188700087d-1*t42+1.0d+0
              t68 = 1.1120374863094686d+1*t56+1.644733775567609d+0*t55+2
     1           .4058712912881916d-1*t53+3.8447462374472113d+0*t42
              t69 = 3.216395899738507d+1/t68+1.0d+0
              t70 = log(t69)
              t71 = -5.980796863619711d-2*t45*t46*t50*t67*t70
              t72 = t41*(t71+t66+t60)-rhob*t40-rhoa*t26
              t73 = param(18)
              t74 = 6.0d-2*gammaaa*t2+1.0d+0
              t75 = 1/t74
              t76 = param(19)
              t77 = param(20)
              t78 = param(21)
              t79 = param(22)
              t80 = 6.0d-2*gammaaa*t2*t75*t79+t78
              t81 = 6.0d-2*gammaaa*t2*t75*t80+t77
              t82 = 6.0d-2*gammaaa*t2*t75*t81+t76
              t83 = 6.0d-2*gammaaa*t2*t75*t82+t73
              t84 = 1/taua
              t85 = 1/rhoa
              t86 = 2.0d+0*taua-2.5d-1*gammaaa*t85
              t87 = 1.0d+0-1.25d-1*gammaaa*t84*t85
              t88 = 1/rhoa**1.6666666666666669d+0
              t89 = 2.0d+0*t88*taua
              t90 = 5.15088d-3*(t89+t3-9.11559972d+0)+1.0d+0
              t91 = 1/t90
              t92 = param(7)
              t93 = param(10)
              t94 = gammaaa**2
              t95 = 1/rhoa**5.333333333333333d+0
              t96 = 1/t90**2
              t97 = param(11)
              t98 = t89-9.11559972d+0
              t99 = param(12)
              t100 = t98**2
              t101 = param(8)
              t102 = param(9)
              t103 = t100*t96*t99+gammaaa*t2*t96*t97*t98+t102*t91*t98+t9
     1           3*t94*t95*t96+t92+gammaaa*t101*t2*t91
              t104 = 6.0d-2*gammabb*t4+1.0d+0
              t105 = 1/t104
              t106 = 6.0d-2*gammabb*t105*t4*t79+t78
              t107 = t77+6.0d-2*gammabb*t105*t106*t4
              t108 = t76+6.0d-2*gammabb*t105*t107*t4
              t109 = t73+6.0d-2*gammabb*t105*t108*t4
              t110 = 1/taub
              t111 = 1/rhob
              t112 = 2.0d+0*taub-2.5d-1*gammabb*t111
              t113 = 1.0d+0-1.25d-1*gammabb*t110*t111
              t114 = 1/rhob**1.6666666666666669d+0
              t115 = 2.0d+0*t114*taub
              t116 = 5.15088d-3*(t5+t115-9.11559972d+0)+1.0d+0
              t117 = 1/t116
              t118 = gammabb**2
              t119 = 1/rhob**5.333333333333333d+0
              t120 = 1/t116**2
              t121 = t115-9.11559972d+0
              t122 = t121**2
              t123 = t120*t122*t99+gammabb*t120*t121*t4*t97+t118*t119*t1
     1           20*t93+t92+gammabb*t101*t117*t4+t102*t117*t121
              t124 = 3.04966d-3*(t89+t5+t3+t115-1.823119944d+1)+1.0d+0
              t125 = 1/t124
              t126 = param(4)
              t127 = t6**2
              t128 = 1/t124**2
              t129 = param(5)
              t130 = t89+t115-1.823119944d+1
              t131 = param(6)
              t132 = t130**2
              t133 = param(2)
              t134 = param(3)
              t135 = t125*t133*t6+t128*t129*t130*t6+t125*t130*t134+t128*
     1           t131*t132+t126*t127*t128+param(1)
              t136 = 1/t14**3
              t137 = 1/rhoa**1.3333333333333333d+0
              t138 = 1/rhoa**1.1666666666666667d+0
              t139 = 1.1102230246251565d-16*t25*(-1.264669550498372d-1*t
     1           88-9.970917392951799d-1*t138-7.418564737168958d-1*t137-
     2           4.002143174996817d-1*t136)/(t22**2*t23)+1.0d+0*t21*(-1.
     3           6039141941921276d-1*t88-1.8533958105157808d+0*t138-1.28
     4           15820791490704d+0*t137-8.223668877838045d-1*t136)/(t18*
     5           *2*t19)+3.0506411443514264d-19*t137*t24+1.3210398931339
     6           265d-3*t137*t20
              t140 = 1/t41**1.6666666666666669d+0
              t141 = 1/t54**3
              t142 = 1/t41**1.3333333333333333d+0
              t143 = 1/t41**1.1666666666666667d+0
              t144 = 1.0d+0*(-9.970917392951799d-1*t143-7.41856473716895
     1           8d-1*t142-4.002143174996817d-1*t141-1.264669550498372d-
     2           1*t140)*t43*t52/(t57**2*t58)
              t145 = -5.848223622634647d-1*(-1.3595691172479402d+0*t143-
     1           7.491972878592053d-1*t142-2.1504862356383217d-1*t141-1.
     2           2743417300848914d-1*t140)*t61*t62/(t63**2*t64)
              t146 = 1.923661050931536d+0*(-1.8533958105157808d+0*t143-1
     1           .2815820791490704d+0*t142-8.223668877838045d-1*t141-1.6
     2           039141941921276d-1*t140)*t45*t46*t50*t67/(t68**2*t69)
              t147 = 1/t41**2
              t148 = t147*t44
              t149 = -t47
              t150 = t48**3.333333333333333d-1
              t151 = -t147*t44
              t152 = t49**3.333333333333333d-1
              t153 = 1.3333333333333333d+0*t152*(t47+t151)+1.33333333333
     1           33333d+0*(t149+t148)*t150
              t154 = -1.923661050931536d+0*t153*t45*t46
              t155 = 1/t41**5
              t156 = 7.694644203726144d+0*t155*t45*t50
              t157 = t44**3
              t158 = -7.694644203726144d+0*t157*t46*t50
              t159 = 2.747773264188437d-3*t142*t52*t59
              t160 = -4.5437964274821163d-4*t142*t62*t65
              t161 = 2.541232989148493d-3*t45*t50*t70/t41**5.33333333333
     1           3333d+0
              t162 = 2.3923187454478842d-1*t155*t45*t50*t67*t70
              t163 = t71+t41*(-2.3923187454478842d-1*t157*t46*t50*t67*t7
     1           0-5.980796863619711d-2*t153*t45*t46*t67*t70+1.975163132
     2           1680768d-2*(t158+t156+t154+1.923661050931536d+0*t153)*t
     3           61*t65-6.21814d-2*(t158+t156+t154)*t43*t59+t162+t161+t1
     4           60+t159+t146+t145+t144)+t66+t60+6.903522198342671d-18*t
     5           24*t25+3.1090699999999993d-2*t20*t21-rhoa*t139
              t164 = 1/rhoa**3.6666666666666664d+0
              t165 = 1/t7**2
              t166 = 1/t74**2
              t167 = 1/rhoa**6.333333333333333d+0
              t168 = -3.3333333333333337d+0*t2*taua-2.6666666666666666d+
     1           0*gammaaa*t164
              t169 = 1/t90**3
              t170 = 1/t124**3
              t171 = 1/t28**3
              t172 = 1/rhob**1.3333333333333333d+0
              t173 = 1/rhob**1.1666666666666667d+0
              t174 = 1.1102230246251565d-16*(-9.970917392951799d-1*t173-
     1           7.418564737168958d-1*t172-4.002143174996817d-1*t171-1.2
     2           64669550498372d-1*t114)*t39/(t36**2*t37)+3.050641144351
     3           4264d-19*t172*t38+1.0d+0*(-1.8533958105157808d+0*t173-1
     4           .2815820791490704d+0*t172-8.223668877838045d-1*t171-1.6
     5           039141941921276d-1*t114)*t35/(t32**2*t33)+1.32103989313
     6           39265d-3*t172*t34
              t175 = 1.3333333333333333d+0*t150*(t47+t148)+1.33333333333
     1           33333d+0*(t151+t149)*t152
              t176 = -1.923661050931536d+0*t175*t45*t46
              t177 = 7.694644203726144d+0*t157*t46*t50
              t178 = t71+t41*(2.3923187454478842d-1*t157*t46*t50*t67*t70
     1           -5.980796863619711d-2*t175*t45*t46*t67*t70+1.9751631321
     2           680768d-2*(t177+t176+1.923661050931536d+0*t175+t156)*t6
     3           1*t65-6.21814d-2*(t177+t176+t156)*t43*t59+t162+t161+t16
     4           0+t159+t146+t145+t144)+t66+t60+6.903522198342671d-18*t3
     5           8*t39+3.1090699999999993d-2*t34*t35-rhob*t174
              t179 = 1/rhob**3.6666666666666664d+0
              t180 = 1/t104**2
              t181 = 1/rhob**6.333333333333333d+0
              t182 = -3.3333333333333337d+0*t4*taub-2.6666666666666666d+
     1           0*gammabb*t179
              t183 = 1/t116**3
              t184 = 1/taua**2
              t185 = 1/rhoa**4.333333333333333d+0
              t186 = 1/taub**2
              t187 = 1/rhob**4.333333333333333d+0
              fnc(iq) = (1.0d+0*rhoa*t103*t26*t87*t91+5.0d-1*rhoa*t26*t8
     1           3*t84*t86+1.0d+0*t125*t135*t72+1.0d+0*t12*t72+1.0d+0*rh
     2           ob*t113*t117*t123*t40+5.0d-1*rhob*t109*t110*t112*t40)*w
     3           ght+fnc(iq)
              Amat(iq,D1_RA) = (t91*(1.0d+0*rhoa*t26*t87*(-6.66666666666
     1           6667d+0*t2*t96*t98*t99*taua-3.3333333333333337d+0*gamma
     2           aa*t95*t96*t97*taua-3.3333333333333337d+0*t102*t2*t91*t
     3           aua-1.030176d-2*t100*t168*t169*t99-2.6666666666666666d+
     4           0*gammaaa*t164*t96*t97*t98-1.030176d-2*gammaaa*t168*t16
     5           9*t2*t97*t98-5.15088d-3*t102*t168*t96*t98-5.33333333333
     6           3333d+0*t167*t93*t94*t96-5.15088d-3*gammaaa*t101*t168*t
     7           2*t96-1.030176d-2*t168*t169*t93*t94*t95-2.6666666666666
     8           666d+0*gammaaa*t101*t164*t91)+1.0d+0*t103*t26*t87+1.0d+
     9           0*rhoa*t103*t139*t87)+t125*(1.0d+0*t72*(-3.333333333333
     :           3337d+0*t128*t129*t2*t6*taua-3.3333333333333337d+0*t125
     ;           *t134*t2*taua-6.666666666666667d+0*t128*t130*t131*t2*ta
     <           ua-6.09932d-3*t129*t130*t168*t170*t6-3.04966d-3*t128*t1
     =           33*t168*t6-5.333333333333333d+0*gammaaa*t126*t128*t164*
     >           t6-6.09932d-3*t131*t132*t168*t170-6.09932d-3*t126*t127*
     ?           t168*t170-3.04966d-3*t128*t130*t134*t168-2.666666666666
     @           6666d+0*gammaaa*t125*t133*t164-2.6666666666666666d+0*ga
     1           mmaaa*t128*t129*t130*t164)+1.0d+0*t135*t163)-5.15088d-3
     2           *rhoa*t103*t168*t26*t87*t96+t84*(5.0d-1*rhoa*t26*t86*(6
     3           .0d-2*gammaaa*t2*t75*(6.0d-2*gammaaa*t2*t75*(6.0d-2*gam
     4           maaa*t2*t75*(9.599999999999997d-3*t166*t167*t79*t94-1.5
     5           999999999999998d-1*gammaaa*t164*t75*t79)+9.599999999999
     6           997d-3*t166*t167*t80*t94-1.5999999999999998d-1*gammaaa*
     7           t164*t75*t80)+9.599999999999997d-3*t166*t167*t81*t94-1.
     8           5999999999999998d-1*gammaaa*t164*t75*t81)+9.59999999999
     9           9997d-3*t166*t167*t82*t94-1.5999999999999998d-1*gammaaa
     :           *t164*t75*t82)+5.0d-1*t26*t83*t86+5.0d-1*rhoa*t139*t83*
     ;           t86)+1.25d-1*gammaaa*t103*t26*t84*t85*t91+1.0d+0*t72*(3
     <           .1d-3*t6*t8*(3.1d-3*t6*t8*(-8.266666666666665d-3*gammaa
     =           a*t164*t8*t9+2.562666666666666d-5*gammaaa*t164*t165*t6*
     >           t9+3.1d-3*t6*t8*(2.562666666666666d-5*gammaaa*t1*t164*t
     ?           165*t6-8.266666666666665d-3*gammaaa*t1*t164*t8))-8.2666
     @           66666666665d-3*gammaaa*t10*t164*t8+2.562666666666666d-5
     1           *gammaaa*t10*t164*t165*t6)-8.266666666666665d-3*gammaaa
     2           *t11*t164*t8+2.562666666666666d-5*gammaaa*t11*t164*t165
     3           *t6)+1.25d-1*gammaaa*t26*t83*t84*t85-3.04966d-3*t128*t1
     4           35*t168*t72+1.0d+0*t12*t163)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t117*(1.0d+0*rhob*t113*t40*(-6.666666666
     1           666667d+0*t120*t121*t4*t99*taub-3.3333333333333337d+0*g
     2           ammabb*t119*t120*t97*taub-3.3333333333333337d+0*t102*t1
     3           17*t4*taub-1.030176d-2*t122*t182*t183*t99-1.030176d-2*g
     4           ammabb*t121*t182*t183*t4*t97-2.6666666666666666d+0*gamm
     5           abb*t120*t121*t179*t97-1.030176d-2*t118*t119*t182*t183*
     6           t93-5.333333333333333d+0*t118*t120*t181*t93-5.15088d-3*
     7           gammabb*t101*t120*t182*t4-5.15088d-3*t102*t120*t121*t18
     8           2-2.6666666666666666d+0*gammabb*t101*t117*t179)+1.0d+0*
     9           t113*t123*t40+1.0d+0*rhob*t113*t123*t174)+t125*(1.0d+0*
     :           t72*(-3.3333333333333337d+0*t128*t129*t4*t6*taub-3.3333
     ;           333333333337d+0*t125*t134*t4*taub-6.666666666666667d+0*
     <           t128*t130*t131*t4*taub-6.09932d-3*t129*t130*t170*t182*t
     =           6-3.04966d-3*t128*t133*t182*t6-5.333333333333333d+0*gam
     >           mabb*t126*t128*t179*t6-6.09932d-3*t131*t132*t170*t182-6
     ?           .09932d-3*t126*t127*t170*t182-3.04966d-3*t128*t130*t134
     @           *t182-2.6666666666666666d+0*gammabb*t125*t133*t179-2.66
     1           66666666666666d+0*gammabb*t128*t129*t130*t179)+1.0d+0*t
     2           135*t178)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(-8.26
     3           6666666666665d-3*gammabb*t179*t8*t9+2.562666666666666d-
     4           5*gammabb*t165*t179*t6*t9+3.1d-3*t6*t8*(2.5626666666666
     5           66d-5*gammabb*t1*t165*t179*t6-8.266666666666665d-3*gamm
     6           abb*t1*t179*t8))-8.266666666666665d-3*gammabb*t10*t179*
     7           t8+2.562666666666666d-5*gammabb*t10*t165*t179*t6)-8.266
     8           666666666665d-3*gammabb*t11*t179*t8+2.562666666666666d-
     9           5*gammabb*t11*t165*t179*t6)+t110*(5.0d-1*rhob*t112*t40*
     :           (6.0d-2*gammabb*t105*t4*(6.0d-2*gammabb*t105*t4*(6.0d-2
     ;           *gammabb*t105*t4*(9.599999999999997d-3*t118*t180*t181*t
     <           79-1.5999999999999998d-1*gammabb*t105*t179*t79)+9.59999
     =           9999999997d-3*t106*t118*t180*t181-1.5999999999999998d-1
     >           *gammabb*t105*t106*t179)+9.599999999999997d-3*t107*t118
     ?           *t180*t181-1.5999999999999998d-1*gammabb*t105*t107*t179
     @           )+9.599999999999997d-3*t108*t118*t180*t181-1.5999999999
     1           999998d-1*gammabb*t105*t108*t179)+5.0d-1*t109*t112*t40+
     2           5.0d-1*rhob*t109*t112*t174)-3.04966d-3*t128*t135*t182*t
     3           72-5.15088d-3*rhob*t113*t120*t123*t182*t40+1.25d-1*gamm
     4           abb*t110*t111*t117*t123*t40+1.25d-1*gammabb*t109*t110*t
     5           111*t40+1.0d+0*t12*t178)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (1.0d+0*rhoa*t26*t87*t91*(-1.030176d-2*t
     1           100*t169*t2*t99+t2*t96*t97*t98-1.030176d-2*gammaaa*t169
     2           *t95*t97*t98-5.15088d-3*t102*t2*t96*t98+2*gammaaa*t93*t
     3           95*t96-5.15088d-3*gammaaa*t101*t95*t96-1.030176d-2*t169
     4           *t93*t94/rhoa**8+t101*t2*t91)-5.15088d-3*t103*t26*t87*t
     5           88*t96+t84*(5.0d-1*rhoa*t26*t86*(6.0d-2*gammaaa*t2*t75*
     6           (6.0d-2*gammaaa*t2*t75*(6.0d-2*gammaaa*t2*t75*(6.0d-2*t
     7           2*t75*t79-3.6d-3*gammaaa*t166*t79*t95)-3.6d-3*gammaaa*t
     8           166*t80*t95+6.0d-2*t2*t75*t80)-3.6d-3*gammaaa*t166*t81*
     9           t95+6.0d-2*t2*t75*t81)-3.6d-3*gammaaa*t166*t82*t95+6.0d
     :           -2*t2*t75*t82)-1.25d-1*t26*t83)-1.25d-1*t103*t26*t84*t9
     ;           1+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(3.1d-3*t2*t8*
     <           t9-9.61d-6*t165*t2*t6*t9+3.1d-3*t6*t8*(3.1d-3*t1*t2*t8-
     =           9.61d-6*t1*t165*t2*t6))+3.1d-3*t10*t2*t8-9.61d-6*t10*t1
     >           65*t2*t6)+3.1d-3*t11*t2*t8-9.61d-6*t11*t165*t2*t6)+1.0d
     ?           +0*t125*(-6.09932d-3*t129*t130*t170*t2*t6-3.04966d-3*t1
     @           28*t133*t2*t6+2*t126*t128*t2*t6-6.09932d-3*t131*t132*t1
     1           70*t2-6.09932d-3*t126*t127*t170*t2-3.04966d-3*t128*t130
     2           *t134*t2+t125*t133*t2+t128*t129*t130*t2)*t72-3.04966d-3
     3           *t128*t135*t2*t72)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (1.0d+0*rhob*t113*t117*t40*(-1.030176d-2
     1           *t122*t183*t4*t99+t120*t121*t4*t97-1.030176d-2*gammabb*
     2           t119*t121*t183*t97-1.030176d-2*t118*t183*t93/rhob**8+2*
     3           gammabb*t119*t120*t93-5.15088d-3*t102*t120*t121*t4+t101
     4           *t117*t4-5.15088d-3*gammabb*t101*t119*t120)+1.0d+0*t72*
     5           (3.1d-3*t6*t8*(3.1d-3*t6*t8*(3.1d-3*t4*t8*t9-9.61d-6*t1
     6           65*t4*t6*t9+3.1d-3*t6*t8*(3.1d-3*t1*t4*t8-9.61d-6*t1*t1
     7           65*t4*t6))+3.1d-3*t10*t4*t8-9.61d-6*t10*t165*t4*t6)+3.1
     8           d-3*t11*t4*t8-9.61d-6*t11*t165*t4*t6)+t110*(5.0d-1*rhob
     9           *t112*t40*(6.0d-2*gammabb*t105*t4*(6.0d-2*gammabb*t105*
     :           t4*(6.0d-2*gammabb*t105*t4*(6.0d-2*t105*t4*t79-3.6d-3*g
     ;           ammabb*t119*t180*t79)+6.0d-2*t105*t106*t4-3.6d-3*gammab
     <           b*t106*t119*t180)+6.0d-2*t105*t107*t4-3.6d-3*gammabb*t1
     =           07*t119*t180)+6.0d-2*t105*t108*t4-3.6d-3*gammabb*t108*t
     >           119*t180)-1.25d-1*t109*t40)+1.0d+0*t125*(-6.09932d-3*t1
     ?           29*t130*t170*t4*t6-3.04966d-3*t128*t133*t4*t6+2*t126*t1
     @           28*t4*t6-6.09932d-3*t131*t132*t170*t4-6.09932d-3*t126*t
     1           127*t170*t4-3.04966d-3*t128*t130*t134*t4+t125*t133*t4+t
     2           128*t129*t130*t4)*t72-3.04966d-3*t128*t135*t4*t72-5.150
     3           88d-3*t113*t114*t120*t123*t40-1.25d-1*t110*t117*t123*t4
     4           0)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t26*t87*t91*(4.0d+0*t88*t96*
     1           t98*t99-2.060352d-2*t100*t169*t88*t99-2.060352d-2*gamma
     2           aa*t169*t185*t97*t98-1.030176d-2*t102*t88*t96*t98+2.0d+
     3           0*gammaaa*t185*t96*t97-1.030176d-2*gammaaa*t101*t185*t9
     4           6-2.060352d-2*t169*t93*t94/rhoa**7+2.0d+0*t102*t88*t91)
     5           -1.030176d-2*t103*t13*t26*t87*t96+1.25d-1*gammaaa*t103*
     6           t184*t26*t91+1.0d+0*t125*t72*(-1.219864d-2*t129*t130*t1
     7           70*t6*t88-6.09932d-3*t128*t133*t6*t88+2.0d+0*t128*t129*
     8           t6*t88-1.219864d-2*t131*t132*t170*t88-1.219864d-2*t126*
     9           t127*t170*t88-6.09932d-3*t128*t130*t134*t88+2.0d+0*t125
     :           *t134*t88+4.0d+0*t128*t130*t131*t88)-6.09932d-3*t128*t1
     ;           35*t72*t88-5.0d-1*rhoa*t184*t26*t83*t86+1.0d+0*rhoa*t26
     <           *t83*t84)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t113*t117*t40*(-2.060352d-2*
     1           t114*t122*t183*t99+4.0d+0*t114*t120*t121*t99-2.060352d-
     2           2*gammabb*t121*t183*t187*t97+2.0d+0*gammabb*t120*t187*t
     3           97-2.060352d-2*t118*t183*t93/rhob**7-1.030176d-2*gammab
     4           b*t101*t120*t187-1.030176d-2*t102*t114*t120*t121+2.0d+0
     5           *t102*t114*t117)+1.0d+0*t125*(-1.219864d-2*t114*t129*t1
     6           30*t170*t6-6.09932d-3*t114*t128*t133*t6+2.0d+0*t114*t12
     7           8*t129*t6-1.219864d-2*t114*t131*t132*t170-1.219864d-2*t
     8           114*t126*t127*t170-6.09932d-3*t114*t128*t130*t134+2.0d+
     9           0*t114*t125*t134+4.0d+0*t114*t128*t130*t131)*t72-6.0993
     :           2d-3*t114*t128*t135*t72-1.030176d-2*t113*t120*t123*t27*
     ;           t40+1.25d-1*gammabb*t117*t123*t186*t40-5.0d-1*rhob*t109
     <           *t112*t186*t40+1.0d+0*rhob*t109*t110*t40)*wght+Mmat(iq,
     =           D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhob**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhob**6.666666666666666d-1
              t17 = rhob**5.0d-1
              t18 = 1/t17
              t19 = 1/rhob**3.333333333333333d-1
              t20 = 1/rhob**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = param(18)
              t31 = 2.4d-51*t1+1.0d+0
              t32 = 1/t31
              t33 = param(19)
              t34 = param(20)
              t35 = param(21)
              t36 = param(22)
              t37 = 2.4d-51*t1*t32*t36+t35
              t38 = 2.4d-51*t1*t32*t37+t34
              t39 = 2.4d-51*t1*t32*t38+t33
              t40 = 2.4d-51*t1*t32*t39+t30
              t41 = 1/rhoa**2.6666666666666666d+0
              t42 = gammaaa*t41
              t43 = t42+4.0d-50*t1
              t44 = 3.1d-3*t43+1.0d+0
              t45 = 1/t44
              t46 = param(17)
              t47 = 3.1d-3*t43*t45*t46+param(16)
              t48 = 3.1d-3*t43*t45*t47+param(15)
              t49 = 3.1d-3*t43*t45*t48+param(14)
              t50 = 3.1d-3*t43*t45*t49+param(13)
              t51 = 1/rhoa**6.666666666666666d-1
              t52 = rhoa**5.0d-1
              t53 = 1/t52
              t54 = 1/rhoa**3.333333333333333d-1
              t55 = 1/rhoa**1.6666666666666666d-1
              t56 = 1.1120374863094686d+1*t55+3.8447462374472113d+0*t54+
     1           1.644733775567609d+0*t53+2.4058712912881916d-1*t51
              t57 = 3.216395899738507d+1/t56+1.0d+0
              t58 = log(t57)
              t59 = 1.274696188700087d-1*t54+1.0d+0
              t60 = 5.982550435771079d+0*t55+2.2255694211506874d+0*t54+8
     1           .004286349993635d-1*t53+1.8970043257475583d-1*t51
              t61 = 1.6081979498692536d+1/t60+1.0d+0
              t62 = log(t61)
              t63 = 1.3256889990520176d-1*t54+1.0d+0
              t64 = -6.903522198342671d-18*t62*t63-3.1090699999999993d-2
     1           *t58*t59
              t65 = rhob+rhoa
              t66 = 1/t65**3.333333333333333d-1
              t67 = 1.3256889990520176d-1*t66+1.0d+0
              t68 = rhoa-rhob
              t69 = t68**4
              t70 = 1/t65**4
              t71 = 1/t65
              t72 = 1.0d+0-t68*t71
              t73 = t68*t71+1.0d+0
              t74 = t73**1.3333333333333333d+0+t72**1.3333333333333333d+
     1           0-2.0d+0
              t75 = -1.923661050931536d+0*t69*t70*t74
              t76 = t75+1.0d+0
              t77 = 1/t65**6.666666666666666d-1
              t78 = t65**5.0d-1
              t79 = 1/t78
              t80 = 1/t65**1.6666666666666666d-1
              t81 = 5.982550435771079d+0*t80+8.004286349993635d-1*t79+1.
     1           8970043257475583d-1*t77+2.2255694211506874d+0*t66
              t82 = 1.6081979498692536d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = -6.21814d-2*t67*t76*t83
              t85 = 6.901399211255825d-2*t66+1.0d+0
              t86 = t75+1.923661050931536d+0*t74
              t87 = 8.157414703487641d+0*t80+4.3009724712766434d-1*t79+1
     1           .9115125951273373d-1*t77+2.247591863577616d+0*t66
              t88 = 2.9608813203268075d+1/t87+1.0d+0
              t89 = log(t88)
              t90 = 1.9751631321680768d-2*t85*t86*t89
              t91 = 1.274696188700087d-1*t66+1.0d+0
              t92 = 1.1120374863094686d+1*t80+1.644733775567609d+0*t79+2
     1           .4058712912881916d-1*t77+3.8447462374472113d+0*t66
              t93 = 3.216395899738507d+1/t92+1.0d+0
              t94 = log(t93)
              t95 = -5.980796863619711d-2*t69*t70*t74*t91*t94
              t96 = t65*(t95+t90+t84)-rhoa*t64-rhob*t29
              t97 = 6.0d-2*gammaaa*t41+1.0d+0
              t98 = 1/t97
              t99 = 6.0d-2*gammaaa*t36*t41*t98+t35
              t100 = 6.0d-2*gammaaa*t41*t98*t99+t34
              t101 = 6.0d-2*gammaaa*t100*t41*t98+t33
              t102 = 6.0d-2*gammaaa*t101*t41*t98+t30
              t103 = 1/taua
              t104 = 1/rhoa
              t105 = 2.0d+0*taua-2.5d-1*gammaaa*t104
              t106 = 1.0d+0-1.25d-1*gammaaa*t103*t104
              t107 = 1/rhoa**1.6666666666666669d+0
              t108 = 2.0d+0*t107*taua
              t109 = 5.15088d-3*(t42+t108-9.11559972d+0)+1.0d+0
              t110 = 1/t109
              t111 = gammaaa**2
              t112 = 1/rhoa**5.333333333333333d+0
              t113 = 1/t109**2
              t114 = t108-9.11559972d+0
              t115 = t114**2
              t116 = t113*t115*t6+t5+gammaaa*t113*t114*t14*t41+gammaaa*t
     1           110*t13*t41+t110*t114*t12+t11*t111*t112*t113
              t117 = 3.04966d-3*(t42+t2+t108-1.823119944d+1)+1.0d+0
              t118 = 1/t117
              t119 = param(4)
              t120 = t43**2
              t121 = 1/t117**2
              t122 = param(5)
              t123 = t8+t108-1.823119944d+1
              t124 = param(6)
              t125 = t123**2
              t126 = param(2)
              t127 = param(3)
              t128 = t118*t126*t43+t121*t122*t123*t43+t118*t123*t127+t12
     1           1*t124*t125+t119*t120*t121+param(1)
              t129 = 1/t52**3
              t130 = 1/rhoa**1.3333333333333333d+0
              t131 = 1/rhoa**1.1666666666666667d+0
              t132 = 1.1102230246251565d-16*(-9.970917392951799d-1*t131-
     1           7.418564737168958d-1*t130-4.002143174996817d-1*t129-1.2
     2           64669550498372d-1*t107)*t63/(t60**2*t61)+3.050641144351
     3           4264d-19*t130*t62+1.0d+0*(-1.8533958105157808d+0*t131-1
     4           .2815820791490704d+0*t130-8.223668877838045d-1*t129-1.6
     5           039141941921276d-1*t107)*t59/(t56**2*t57)+1.32103989313
     6           39265d-3*t130*t58
              t133 = 1/t65**1.6666666666666669d+0
              t134 = 1/t78**3
              t135 = 1/t65**1.3333333333333333d+0
              t136 = 1/t65**1.1666666666666667d+0
              t137 = 1.0d+0*(-9.970917392951799d-1*t136-7.41856473716895
     1           8d-1*t135-4.002143174996817d-1*t134-1.264669550498372d-
     2           1*t133)*t67*t76/(t81**2*t82)
              t138 = -5.848223622634647d-1*(-1.3595691172479402d+0*t136-
     1           7.491972878592053d-1*t135-2.1504862356383217d-1*t134-1.
     2           2743417300848914d-1*t133)*t85*t86/(t87**2*t88)
              t139 = 1.923661050931536d+0*(-1.8533958105157808d+0*t136-1
     1           .2815820791490704d+0*t135-8.223668877838045d-1*t134-1.6
     2           039141941921276d-1*t133)*t69*t70*t74*t91/(t92**2*t93)
              t140 = 1/t65**2
              t141 = t140*t68
              t142 = -t71
              t143 = t72**3.333333333333333d-1
              t144 = -t140*t68
              t145 = t73**3.333333333333333d-1
              t146 = 1.3333333333333333d+0*t145*(t71+t144)+1.33333333333
     1           33333d+0*(t142+t141)*t143
              t147 = -1.923661050931536d+0*t146*t69*t70
              t148 = 1/t65**5
              t149 = 7.694644203726144d+0*t148*t69*t74
              t150 = t68**3
              t151 = -7.694644203726144d+0*t150*t70*t74
              t152 = 2.747773264188437d-3*t135*t76*t83
              t153 = -4.5437964274821163d-4*t135*t86*t89
              t154 = 2.541232989148493d-3*t69*t74*t94/t65**5.33333333333
     1           3333d+0
              t155 = 2.3923187454478842d-1*t148*t69*t74*t91*t94
              t156 = t95+t65*(-2.3923187454478842d-1*t150*t70*t74*t91*t9
     1           4-5.980796863619711d-2*t146*t69*t70*t91*t94+1.975163132
     2           1680768d-2*(t151+t149+t147+1.923661050931536d+0*t146)*t
     3           85*t89-6.21814d-2*(t151+t149+t147)*t67*t83+t155+t154+t1
     4           53+t152+t139+t138+t137)+t90+t84+6.903522198342671d-18*t
     5           62*t63+3.1090699999999993d-2*t58*t59-rhoa*t132
              t157 = 1/rhoa**3.6666666666666664d+0
              t158 = 1/t44**2
              t159 = 1/t97**2
              t160 = 1/rhoa**6.333333333333333d+0
              t161 = -3.3333333333333337d+0*t41*taua-2.6666666666666666d
     1           +0*gammaaa*t157
              t162 = 1/t109**3
              t163 = 1/t117**3
              t164 = 1/t17**3
              t165 = 1/rhob**1.3333333333333333d+0
              t166 = 1/rhob**1.1666666666666667d+0
              t167 = 1.1102230246251565d-16*(-9.970917392951799d-1*t166-
     1           7.418564737168958d-1*t165-4.002143174996817d-1*t164-1.2
     2           64669550498372d-1*t1)*t28/(t25**2*t26)+3.05064114435142
     3           64d-19*t165*t27+1.0d+0*(-1.8533958105157808d+0*t166-1.2
     4           815820791490704d+0*t165-8.223668877838045d-1*t164-1.603
     5           9141941921276d-1*t1)*t24/(t21**2*t22)+1.321039893133926
     6           5d-3*t165*t23
              t168 = 1/t31**2
              t169 = 1/rhob**4.333333333333333d+0
              t170 = 1/rhob**2.6666666666666666d+0
              t171 = 1/t3**3
              t172 = 1.3333333333333333d+0*t143*(t71+t141)+1.33333333333
     1           33333d+0*(t144+t142)*t145
              t173 = -1.923661050931536d+0*t172*t69*t70
              t174 = 7.694644203726144d+0*t150*t70*t74
              t175 = t95+t65*(2.3923187454478842d-1*t150*t70*t74*t91*t94
     1           -5.980796863619711d-2*t172*t69*t70*t91*t94+1.9751631321
     2           680768d-2*(t174+t173+1.923661050931536d+0*t172+t149)*t8
     3           5*t89-6.21814d-2*(t174+t173+t149)*t67*t83+t155+t154+t15
     4           3+t152+t139+t138+t137)+t90+t84+6.903522198342671d-18*t2
     5           7*t28+3.1090699999999993d-2*t23*t24-rhob*t167
              t176 = 1/taua**2
              t177 = 1/rhoa**4.333333333333333d+0
              fnc(iq) = (1.0d+0*t50*t96+1.0d+0*t118*t128*t96+1.0d+0*rhoa
     1           *t106*t110*t116*t64+5.0d-1*rhoa*t102*t103*t105*t64+5.0d
     2           -1*rhob*t29*t40+5.0d-1*rhob*t15*t29*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t110*(1.0d+0*rhoa*t106*t64*(-6.666666666
     1           666667d+0*t113*t114*t41*t6*taua-3.3333333333333337d+0*t
     2           110*t12*t41*taua-3.3333333333333337d+0*gammaaa*t112*t11
     3           3*t14*taua-1.030176d-2*t115*t161*t162*t6-1.030176d-2*ga
     4           mmaaa*t114*t14*t161*t162*t41-5.15088d-3*gammaaa*t113*t1
     5           3*t161*t41-1.030176d-2*t11*t111*t112*t161*t162-5.15088d
     6           -3*t113*t114*t12*t161-5.333333333333333d+0*t11*t111*t11
     7           3*t160-2.6666666666666666d+0*gammaaa*t113*t114*t14*t157
     8           -2.6666666666666666d+0*gammaaa*t110*t13*t157)+1.0d+0*t1
     9           06*t116*t64+1.0d+0*rhoa*t106*t116*t132)+t118*(1.0d+0*t9
     :           6*(-3.3333333333333337d+0*t121*t122*t41*t43*taua-3.3333
     ;           333333333337d+0*t118*t127*t41*taua-6.666666666666667d+0
     <           *t121*t123*t124*t41*taua-6.09932d-3*t122*t123*t161*t163
     =           *t43-3.04966d-3*t121*t126*t161*t43-5.333333333333333d+0
     >           *gammaaa*t119*t121*t157*t43-6.09932d-3*t124*t125*t161*t
     ?           163-6.09932d-3*t119*t120*t161*t163-3.04966d-3*t121*t123
     @           *t127*t161-2.6666666666666666d+0*gammaaa*t118*t126*t157
     1           -2.6666666666666666d+0*gammaaa*t121*t122*t123*t157)+1.0
     2           d+0*t128*t156)+t103*(5.0d-1*rhoa*t105*t64*(6.0d-2*gamma
     3           aa*t41*t98*(6.0d-2*gammaaa*t41*t98*(-1.5999999999999998
     4           d-1*gammaaa*t157*t98*t99+9.599999999999997d-3*t111*t159
     5           *t160*t99+6.0d-2*gammaaa*t41*t98*(9.599999999999997d-3*
     6           t111*t159*t160*t36-1.5999999999999998d-1*gammaaa*t157*t
     7           36*t98))-1.5999999999999998d-1*gammaaa*t100*t157*t98+9.
     8           599999999999997d-3*t100*t111*t159*t160)-1.5999999999999
     9           998d-1*gammaaa*t101*t157*t98+9.599999999999997d-3*t101*
     :           t111*t159*t160)+5.0d-1*t102*t105*t64+5.0d-1*rhoa*t102*t
     ;           105*t132)+1.0d+0*(-8.266666666666665d-3*gammaaa*t157*t4
     <           5*t49+2.562666666666666d-5*gammaaa*t157*t158*t43*t49+3.
     =           1d-3*t43*t45*(-8.266666666666665d-3*gammaaa*t157*t45*t4
     >           8+2.562666666666666d-5*gammaaa*t157*t158*t43*t48+3.1d-3
     ?           *t43*t45*(-8.266666666666665d-3*gammaaa*t157*t45*t47+2.
     @           562666666666666d-5*gammaaa*t157*t158*t43*t47+3.1d-3*t43
     1           *t45*(2.562666666666666d-5*gammaaa*t157*t158*t43*t46-8.
     2           266666666666665d-3*gammaaa*t157*t45*t46))))*t96-3.04966
     3           d-3*t121*t128*t161*t96-5.15088d-3*rhoa*t106*t113*t116*t
     4           161*t64+1.25d-1*gammaaa*t103*t104*t110*t116*t64+1.25d-1
     5           *gammaaa*t102*t103*t104*t64+1.0d+0*t156*t50)*wght+Amat(
     6           iq,D1_RA)
              Amat(iq,D1_RB) = (t118*(1.0d+0*(6.09932d-52*t122*t123*t163
     1           *t170*t43+3.04966d-52*t121*t126*t170*t43-3.333333333333
     2           333d-50*t121*t122*t170*t43-1.3333333333333333d-49*t119*
     3           t121*t170*t43+6.09932d-52*t124*t125*t163*t170+6.09932d-
     4           52*t119*t120*t163*t170+3.04966d-52*t121*t123*t127*t170-
     5           3.333333333333333d-50*t118*t127*t170-6.666666666666666d
     6           -50*t118*t126*t170-6.666666666666666d-50*t121*t123*t124
     7           *t170-6.666666666666666d-50*t121*t122*t123*t170)*t96+1.
     8           0d+0*t128*t175)+1.0d+0*(-2.0666666666666667d-52*t170*t4
     9           5*t49+6.406666666666666d-55*t158*t170*t43*t49+3.1d-3*t4
     :           3*t45*(-2.0666666666666667d-52*t170*t45*t48+6.406666666
     ;           666666d-55*t158*t170*t43*t48+3.1d-3*t43*t45*(-2.0666666
     <           666666667d-52*t170*t45*t47+6.406666666666666d-55*t158*t
     =           170*t43*t47+3.1d-3*t43*t45*(6.406666666666666d-55*t158*
     >           t170*t43*t46-2.0666666666666667d-52*t170*t45*t46))))*t9
     ?           6+3.04966d-52*t121*t128*t170*t96+t4*(5.0d-1*rhob*t29*(-
     @           6.666666666666666d-50*t170*t6*t7*t9-6.666666666666666d-
     1           50*t14*t170*t7*t9+5.15088d-52*t12*t170*t7*t9+4.12070399
     2           99999995d-101*t14*t169*t171*t9-1.3333333333333333d-99*t
     3           14*t169*t7+2.0603519999999997d-101*t13*t169*t7-5.333333
     4           333333334d-99*t11*t169*t7+1.030176d-51*t10*t170*t171*t6
     5           -6.666666666666666d-50*t13*t170*t4-3.333333333333333d-5
     6           0*t12*t170*t4+1.6482816d-150*t11*t171/rhob**6)+5.0d-1*t
     7           15*t29+5.0d-1*rhob*t15*t167)+2.57544d-52*t1*t15*t29*t7+
     8           1.0d+0*t175*t50+5.0d-1*t29*t40+5.0d-1*rhob*t167*t40+5.0
     9           d-1*rhob*t29*(-4.0d-51*t170*t32*t39+9.6d-102*t168*t169*
     :           t39+2.4d-51*t1*t32*(-4.0d-51*t170*t32*t38+9.6d-102*t168
     ;           *t169*t38+2.4d-51*t1*t32*(-4.0d-51*t170*t32*t37+9.6d-10
     <           2*t168*t169*t37+2.4d-51*t1*t32*(9.6d-102*t168*t169*t36-
     =           4.0d-51*t170*t32*t36)))))*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (t103*(5.0d-1*rhoa*t105*t64*(6.0d-2*gamm
     1           aaa*t41*t98*(6.0d-2*gammaaa*t41*t98*(6.0d-2*t41*t98*t99
     2           -3.6d-3*gammaaa*t112*t159*t99+6.0d-2*gammaaa*t41*t98*(6
     3           .0d-2*t36*t41*t98-3.6d-3*gammaaa*t112*t159*t36))+6.0d-2
     4           *t100*t41*t98-3.6d-3*gammaaa*t100*t112*t159)+6.0d-2*t10
     5           1*t41*t98-3.6d-3*gammaaa*t101*t112*t159)-1.25d-1*t102*t
     6           64)+1.0d+0*(3.1d-3*t41*t45*t49-9.61d-6*t158*t41*t43*t49
     7           +3.1d-3*t43*t45*(3.1d-3*t41*t45*t48-9.61d-6*t158*t41*t4
     8           3*t48+3.1d-3*t43*t45*(3.1d-3*t41*t45*t47-9.61d-6*t158*t
     9           41*t43*t47+3.1d-3*t43*t45*(3.1d-3*t41*t45*t46-9.61d-6*t
     :           158*t41*t43*t46))))*t96+1.0d+0*t118*(-6.09932d-3*t122*t
     ;           123*t163*t41*t43-3.04966d-3*t121*t126*t41*t43+2*t119*t1
     <           21*t41*t43-6.09932d-3*t124*t125*t163*t41-6.09932d-3*t11
     =           9*t120*t163*t41-3.04966d-3*t121*t123*t127*t41+t118*t126
     >           *t41+t121*t122*t123*t41)*t96-3.04966d-3*t121*t128*t41*t
     ?           96+1.0d+0*rhoa*t106*t110*(-1.030176d-2*t115*t162*t41*t6
     @           +t113*t114*t14*t41+t110*t13*t41-5.15088d-3*t113*t114*t1
     1           2*t41-1.030176d-2*gammaaa*t112*t114*t14*t162-1.030176d-
     2           2*t11*t111*t162/rhoa**8-5.15088d-3*gammaaa*t112*t113*t1
     3           3+2*gammaaa*t11*t112*t113)*t64-5.15088d-3*t106*t107*t11
     4           3*t116*t64-1.25d-1*t103*t110*t116*t64)*wght+Cmat(iq,D1_
     5           GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*t118*(-1.219864d-2*t107*t122*t123
     1           *t163*t43-6.09932d-3*t107*t121*t126*t43+2.0d+0*t107*t12
     2           1*t122*t43-1.219864d-2*t107*t124*t125*t163-1.219864d-2*
     3           t107*t119*t120*t163-6.09932d-3*t107*t121*t123*t127+2.0d
     4           +0*t107*t118*t127+4.0d+0*t107*t121*t123*t124)*t96-6.099
     5           32d-3*t107*t121*t128*t96+1.0d+0*rhoa*t106*t110*(-2.0603
     6           52d-2*t107*t115*t162*t6+4.0d+0*t107*t113*t114*t6-2.0603
     7           52d-2*gammaaa*t114*t14*t162*t177+2.0d+0*gammaaa*t113*t1
     8           4*t177-1.030176d-2*gammaaa*t113*t13*t177-2.060352d-2*t1
     9           1*t111*t162/rhoa**7-1.030176d-2*t107*t113*t114*t12+2.0d
     :           +0*t107*t110*t12)*t64-1.030176d-2*t106*t113*t116*t51*t6
     ;           4+1.25d-1*gammaaa*t110*t116*t176*t64-5.0d-1*rhoa*t102*t
     <           105*t176*t64+1.0d+0*rhoa*t102*t103*t64)*wght+Mmat(iq,D1
     =           _TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhoa**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhoa**6.666666666666666d-1
              t17 = rhoa**5.0d-1
              t18 = 1/t17
              t19 = 1/rhoa**3.333333333333333d-1
              t20 = 1/rhoa**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = param(18)
              t31 = 2.4d-51*t1+1.0d+0
              t32 = 1/t31
              t33 = param(19)
              t34 = param(20)
              t35 = param(21)
              t36 = param(22)
              t37 = 2.4d-51*t1*t32*t36+t35
              t38 = 2.4d-51*t1*t32*t37+t34
              t39 = 2.4d-51*t1*t32*t38+t33
              t40 = 2.4d-51*t1*t32*t39+t30
              t41 = param(17)
              t42 = 1/rhob**2.6666666666666666d+0
              t43 = gammabb*t42
              t44 = t43+4.0d-50*t1
              t45 = 3.1d-3*t44+1.0d+0
              t46 = 1/t45
              t47 = 3.1d-3*t41*t44*t46+param(16)
              t48 = 3.1d-3*t44*t46*t47+param(15)
              t49 = 3.1d-3*t44*t46*t48+param(14)
              t50 = 3.1d-3*t44*t46*t49+param(13)
              t51 = 1/rhob**6.666666666666666d-1
              t52 = rhob**5.0d-1
              t53 = 1/t52
              t54 = 1/rhob**3.333333333333333d-1
              t55 = 1/rhob**1.6666666666666666d-1
              t56 = 1.1120374863094686d+1*t55+3.8447462374472113d+0*t54+
     1           1.644733775567609d+0*t53+2.4058712912881916d-1*t51
              t57 = 3.216395899738507d+1/t56+1.0d+0
              t58 = log(t57)
              t59 = 1.274696188700087d-1*t54+1.0d+0
              t60 = 5.982550435771079d+0*t55+2.2255694211506874d+0*t54+8
     1           .004286349993635d-1*t53+1.8970043257475583d-1*t51
              t61 = 1.6081979498692536d+1/t60+1.0d+0
              t62 = log(t61)
              t63 = 1.3256889990520176d-1*t54+1.0d+0
              t64 = -6.903522198342671d-18*t62*t63-3.1090699999999993d-2
     1           *t58*t59
              t65 = rhob+rhoa
              t66 = 1/t65**3.333333333333333d-1
              t67 = 1.3256889990520176d-1*t66+1.0d+0
              t68 = rhoa-rhob
              t69 = t68**4
              t70 = 1/t65**4
              t71 = 1/t65
              t72 = 1.0d+0-t68*t71
              t73 = t68*t71+1.0d+0
              t74 = t73**1.3333333333333333d+0+t72**1.3333333333333333d+
     1           0-2.0d+0
              t75 = -1.923661050931536d+0*t69*t70*t74
              t76 = t75+1.0d+0
              t77 = 1/t65**6.666666666666666d-1
              t78 = t65**5.0d-1
              t79 = 1/t78
              t80 = 1/t65**1.6666666666666666d-1
              t81 = 5.982550435771079d+0*t80+8.004286349993635d-1*t79+1.
     1           8970043257475583d-1*t77+2.2255694211506874d+0*t66
              t82 = 1.6081979498692536d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = -6.21814d-2*t67*t76*t83
              t85 = 6.901399211255825d-2*t66+1.0d+0
              t86 = t75+1.923661050931536d+0*t74
              t87 = 8.157414703487641d+0*t80+4.3009724712766434d-1*t79+1
     1           .9115125951273373d-1*t77+2.247591863577616d+0*t66
              t88 = 2.9608813203268075d+1/t87+1.0d+0
              t89 = log(t88)
              t90 = 1.9751631321680768d-2*t85*t86*t89
              t91 = 1.274696188700087d-1*t66+1.0d+0
              t92 = 1.1120374863094686d+1*t80+1.644733775567609d+0*t79+2
     1           .4058712912881916d-1*t77+3.8447462374472113d+0*t66
              t93 = 3.216395899738507d+1/t92+1.0d+0
              t94 = log(t93)
              t95 = -5.980796863619711d-2*t69*t70*t74*t91*t94
              t96 = t65*(t95+t90+t84)-rhob*t64-rhoa*t29
              t97 = 6.0d-2*gammabb*t42+1.0d+0
              t98 = 1/t97
              t99 = 6.0d-2*gammabb*t36*t42*t98+t35
              t100 = 6.0d-2*gammabb*t42*t98*t99+t34
              t101 = 6.0d-2*gammabb*t100*t42*t98+t33
              t102 = 6.0d-2*gammabb*t101*t42*t98+t30
              t103 = 1/taub
              t104 = 1/rhob
              t105 = 2.0d+0*taub-2.5d-1*gammabb*t104
              t106 = 1.0d+0-1.25d-1*gammabb*t103*t104
              t107 = 1/rhob**1.6666666666666669d+0
              t108 = 2.0d+0*t107*taub
              t109 = 5.15088d-3*(t43+t108-9.11559972d+0)+1.0d+0
              t110 = 1/t109
              t111 = gammabb**2
              t112 = 1/rhob**5.333333333333333d+0
              t113 = 1/t109**2
              t114 = t108-9.11559972d+0
              t115 = t114**2
              t116 = t113*t115*t6+t5+gammabb*t113*t114*t14*t42+gammabb*t
     1           110*t13*t42+t110*t114*t12+t11*t111*t112*t113
              t117 = 3.04966d-3*(t43+t2+t108-1.823119944d+1)+1.0d+0
              t118 = 1/t117
              t119 = param(4)
              t120 = t44**2
              t121 = 1/t117**2
              t122 = param(5)
              t123 = t8+t108-1.823119944d+1
              t124 = param(6)
              t125 = t123**2
              t126 = param(2)
              t127 = param(3)
              t128 = t118*t126*t44+t121*t122*t123*t44+t118*t123*t127+t12
     1           1*t124*t125+t119*t120*t121+param(1)
              t129 = 1/t17**3
              t130 = 1/rhoa**1.3333333333333333d+0
              t131 = 1/rhoa**1.1666666666666667d+0
              t132 = 1.1102230246251565d-16*(-9.970917392951799d-1*t131-
     1           7.418564737168958d-1*t130-4.002143174996817d-1*t129-1.2
     2           64669550498372d-1*t1)*t28/(t25**2*t26)+3.05064114435142
     3           64d-19*t130*t27+1.0d+0*(-1.8533958105157808d+0*t131-1.2
     4           815820791490704d+0*t130-8.223668877838045d-1*t129-1.603
     5           9141941921276d-1*t1)*t24/(t21**2*t22)+1.321039893133926
     6           5d-3*t130*t23
              t133 = 1/t31**2
              t134 = 1/rhoa**4.333333333333333d+0
              t135 = 1/rhoa**2.6666666666666666d+0
              t136 = 1/t3**3
              t137 = 1/t65**1.6666666666666669d+0
              t138 = 1/t78**3
              t139 = 1/t65**1.3333333333333333d+0
              t140 = 1/t65**1.1666666666666667d+0
              t141 = 1.0d+0*(-9.970917392951799d-1*t140-7.41856473716895
     1           8d-1*t139-4.002143174996817d-1*t138-1.264669550498372d-
     2           1*t137)*t67*t76/(t81**2*t82)
              t142 = -5.848223622634647d-1*(-1.3595691172479402d+0*t140-
     1           7.491972878592053d-1*t139-2.1504862356383217d-1*t138-1.
     2           2743417300848914d-1*t137)*t85*t86/(t87**2*t88)
              t143 = 1.923661050931536d+0*(-1.8533958105157808d+0*t140-1
     1           .2815820791490704d+0*t139-8.223668877838045d-1*t138-1.6
     2           039141941921276d-1*t137)*t69*t70*t74*t91/(t92**2*t93)
              t144 = 1/t65**2
              t145 = t144*t68
              t146 = -t71
              t147 = t72**3.333333333333333d-1
              t148 = -t144*t68
              t149 = t73**3.333333333333333d-1
              t150 = 1.3333333333333333d+0*t149*(t71+t148)+1.33333333333
     1           33333d+0*(t146+t145)*t147
              t151 = -1.923661050931536d+0*t150*t69*t70
              t152 = 1/t65**5
              t153 = 7.694644203726144d+0*t152*t69*t74
              t154 = t68**3
              t155 = -7.694644203726144d+0*t154*t70*t74
              t156 = 2.747773264188437d-3*t139*t76*t83
              t157 = -4.5437964274821163d-4*t139*t86*t89
              t158 = 2.541232989148493d-3*t69*t74*t94/t65**5.33333333333
     1           3333d+0
              t159 = 2.3923187454478842d-1*t152*t69*t74*t91*t94
              t160 = t95+t65*(-2.3923187454478842d-1*t154*t70*t74*t91*t9
     1           4-5.980796863619711d-2*t150*t69*t70*t91*t94+1.975163132
     2           1680768d-2*(t155+t153+t151+1.923661050931536d+0*t150)*t
     3           85*t89-6.21814d-2*(t155+t153+t151)*t67*t83+t159+t158+t1
     4           57+t156+t143+t142+t141)+t90+t84+6.903522198342671d-18*t
     5           27*t28+3.1090699999999993d-2*t23*t24-rhoa*t132
              t161 = 1/t45**2
              t162 = 1/t117**3
              t163 = 1/t52**3
              t164 = 1/rhob**1.3333333333333333d+0
              t165 = 1/rhob**1.1666666666666667d+0
              t166 = 1.1102230246251565d-16*(-9.970917392951799d-1*t165-
     1           7.418564737168958d-1*t164-4.002143174996817d-1*t163-1.2
     2           64669550498372d-1*t107)*t63/(t60**2*t61)+3.050641144351
     3           4264d-19*t164*t62+1.0d+0*(-1.8533958105157808d+0*t165-1
     4           .2815820791490704d+0*t164-8.223668877838045d-1*t163-1.6
     5           039141941921276d-1*t107)*t59/(t56**2*t57)+1.32103989313
     6           39265d-3*t164*t58
              t167 = 1.3333333333333333d+0*t147*(t71+t145)+1.33333333333
     1           33333d+0*(t148+t146)*t149
              t168 = -1.923661050931536d+0*t167*t69*t70
              t169 = 7.694644203726144d+0*t154*t70*t74
              t170 = t95+t65*(2.3923187454478842d-1*t154*t70*t74*t91*t94
     1           -5.980796863619711d-2*t167*t69*t70*t91*t94+1.9751631321
     2           680768d-2*(t169+t168+1.923661050931536d+0*t167+t153)*t8
     3           5*t89-6.21814d-2*(t169+t168+t153)*t67*t83+t159+t158+t15
     4           7+t156+t143+t142+t141)+t90+t84+6.903522198342671d-18*t6
     5           2*t63+3.1090699999999993d-2*t58*t59-rhob*t166
              t171 = 1/rhob**3.6666666666666664d+0
              t172 = 1/t97**2
              t173 = 1/rhob**6.333333333333333d+0
              t174 = -3.3333333333333337d+0*t42*taub-2.6666666666666666d
     1           +0*gammabb*t171
              t175 = 1/t109**3
              t176 = 1/taub**2
              t177 = 1/rhob**4.333333333333333d+0
              fnc(iq) = (1.0d+0*t50*t96+1.0d+0*t118*t128*t96+1.0d+0*rhob
     1           *t106*t110*t116*t64+5.0d-1*rhob*t102*t103*t105*t64+5.0d
     2           -1*rhoa*t29*t40+5.0d-1*rhoa*t15*t29*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t118*(1.0d+0*(6.09932d-52*t122*t123*t135
     1           *t162*t44+3.04966d-52*t121*t126*t135*t44-3.333333333333
     2           333d-50*t121*t122*t135*t44-1.3333333333333333d-49*t119*
     3           t121*t135*t44+6.09932d-52*t124*t125*t135*t162+6.09932d-
     4           52*t119*t120*t135*t162+3.04966d-52*t121*t123*t127*t135-
     5           3.333333333333333d-50*t118*t127*t135-6.666666666666666d
     6           -50*t118*t126*t135-6.666666666666666d-50*t121*t123*t124
     7           *t135-6.666666666666666d-50*t121*t122*t123*t135)*t96+1.
     8           0d+0*t128*t160)+1.0d+0*(-2.0666666666666667d-52*t135*t4
     9           6*t49+6.406666666666666d-55*t135*t161*t44*t49+3.1d-3*t4
     :           4*t46*(-2.0666666666666667d-52*t135*t46*t48+6.406666666
     ;           666666d-55*t135*t161*t44*t48+3.1d-3*t44*t46*(-2.0666666
     <           666666667d-52*t135*t46*t47+6.406666666666666d-55*t135*t
     =           161*t44*t47+3.1d-3*t44*t46*(6.406666666666666d-55*t135*
     >           t161*t41*t44-2.0666666666666667d-52*t135*t41*t46))))*t9
     ?           6+3.04966d-52*t121*t128*t135*t96+t4*(5.0d-1*rhoa*t29*(-
     @           6.666666666666666d-50*t135*t6*t7*t9-6.666666666666666d-
     1           50*t135*t14*t7*t9+5.15088d-52*t12*t135*t7*t9+4.12070399
     2           99999995d-101*t134*t136*t14*t9-1.3333333333333333d-99*t
     3           134*t14*t7+2.0603519999999997d-101*t13*t134*t7-5.333333
     4           333333334d-99*t11*t134*t7+1.030176d-51*t10*t135*t136*t6
     5           -6.666666666666666d-50*t13*t135*t4-3.333333333333333d-5
     6           0*t12*t135*t4+1.6482816d-150*t11*t136/rhoa**6)+5.0d-1*t
     7           15*t29+5.0d-1*rhoa*t132*t15)+2.57544d-52*t1*t15*t29*t7+
     8           1.0d+0*t160*t50+5.0d-1*t29*t40+5.0d-1*rhoa*t132*t40+5.0
     9           d-1*rhoa*t29*(-4.0d-51*t135*t32*t39+9.6d-102*t133*t134*
     :           t39+2.4d-51*t1*t32*(-4.0d-51*t135*t32*t38+9.6d-102*t133
     ;           *t134*t38+2.4d-51*t1*t32*(-4.0d-51*t135*t32*t37+9.6d-10
     <           2*t133*t134*t37+2.4d-51*t1*t32*(9.6d-102*t133*t134*t36-
     =           4.0d-51*t135*t32*t36)))))*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t110*(1.0d+0*rhob*t106*t64*(-6.666666666
     1           666667d+0*t113*t114*t42*t6*taub-3.3333333333333337d+0*t
     2           110*t12*t42*taub-3.3333333333333337d+0*gammabb*t112*t11
     3           3*t14*taub-1.030176d-2*t115*t174*t175*t6-1.030176d-2*ga
     4           mmabb*t114*t14*t174*t175*t42-5.15088d-3*gammabb*t113*t1
     5           3*t174*t42-1.030176d-2*t11*t111*t112*t174*t175-5.15088d
     6           -3*t113*t114*t12*t174-5.333333333333333d+0*t11*t111*t11
     7           3*t173-2.6666666666666666d+0*gammabb*t113*t114*t14*t171
     8           -2.6666666666666666d+0*gammabb*t110*t13*t171)+1.0d+0*t1
     9           06*t116*t64+1.0d+0*rhob*t106*t116*t166)+t118*(1.0d+0*t9
     :           6*(-3.3333333333333337d+0*t121*t122*t42*t44*taub-3.3333
     ;           333333333337d+0*t118*t127*t42*taub-6.666666666666667d+0
     <           *t121*t123*t124*t42*taub-6.09932d-3*t122*t123*t162*t174
     =           *t44-3.04966d-3*t121*t126*t174*t44-5.333333333333333d+0
     >           *gammabb*t119*t121*t171*t44-6.09932d-3*t124*t125*t162*t
     ?           174-6.09932d-3*t119*t120*t162*t174-3.04966d-3*t121*t123
     @           *t127*t174-2.6666666666666666d+0*gammabb*t118*t126*t171
     1           -2.6666666666666666d+0*gammabb*t121*t122*t123*t171)+1.0
     2           d+0*t128*t170)+t103*(5.0d-1*rhob*t105*t64*(6.0d-2*gamma
     3           bb*t42*t98*(6.0d-2*gammabb*t42*t98*(-1.5999999999999998
     4           d-1*gammabb*t171*t98*t99+9.599999999999997d-3*t111*t172
     5           *t173*t99+6.0d-2*gammabb*t42*t98*(9.599999999999997d-3*
     6           t111*t172*t173*t36-1.5999999999999998d-1*gammabb*t171*t
     7           36*t98))-1.5999999999999998d-1*gammabb*t100*t171*t98+9.
     8           599999999999997d-3*t100*t111*t172*t173)-1.5999999999999
     9           998d-1*gammabb*t101*t171*t98+9.599999999999997d-3*t101*
     :           t111*t172*t173)+5.0d-1*t102*t105*t64+5.0d-1*rhob*t102*t
     ;           105*t166)+1.0d+0*(-8.266666666666665d-3*gammabb*t171*t4
     <           6*t49+2.562666666666666d-5*gammabb*t161*t171*t44*t49+3.
     =           1d-3*t44*t46*(-8.266666666666665d-3*gammabb*t171*t46*t4
     >           8+2.562666666666666d-5*gammabb*t161*t171*t44*t48+3.1d-3
     ?           *t44*t46*(-8.266666666666665d-3*gammabb*t171*t46*t47+2.
     @           562666666666666d-5*gammabb*t161*t171*t44*t47+3.1d-3*t44
     1           *t46*(2.562666666666666d-5*gammabb*t161*t171*t41*t44-8.
     2           266666666666665d-3*gammabb*t171*t41*t46))))*t96-3.04966
     3           d-3*t121*t128*t174*t96-5.15088d-3*rhob*t106*t113*t116*t
     4           174*t64+1.25d-1*gammabb*t103*t104*t110*t116*t64+1.25d-1
     5           *gammabb*t102*t103*t104*t64+1.0d+0*t170*t50)*wght+Amat(
     6           iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t103*(5.0d-1*rhob*t105*t64*(6.0d-2*gamm
     1           abb*t42*t98*(6.0d-2*gammabb*t42*t98*(6.0d-2*t42*t98*t99
     2           -3.6d-3*gammabb*t112*t172*t99+6.0d-2*gammabb*t42*t98*(6
     3           .0d-2*t36*t42*t98-3.6d-3*gammabb*t112*t172*t36))+6.0d-2
     4           *t100*t42*t98-3.6d-3*gammabb*t100*t112*t172)+6.0d-2*t10
     5           1*t42*t98-3.6d-3*gammabb*t101*t112*t172)-1.25d-1*t102*t
     6           64)+1.0d+0*(3.1d-3*t42*t46*t49-9.61d-6*t161*t42*t44*t49
     7           +3.1d-3*t44*t46*(3.1d-3*t42*t46*t48-9.61d-6*t161*t42*t4
     8           4*t48+3.1d-3*t44*t46*(3.1d-3*t42*t46*t47-9.61d-6*t161*t
     9           42*t44*t47+3.1d-3*t44*t46*(3.1d-3*t41*t42*t46-9.61d-6*t
     :           161*t41*t42*t44))))*t96+1.0d+0*t118*(-6.09932d-3*t122*t
     ;           123*t162*t42*t44-3.04966d-3*t121*t126*t42*t44+2*t119*t1
     <           21*t42*t44-6.09932d-3*t124*t125*t162*t42-6.09932d-3*t11
     =           9*t120*t162*t42-3.04966d-3*t121*t123*t127*t42+t118*t126
     >           *t42+t121*t122*t123*t42)*t96-3.04966d-3*t121*t128*t42*t
     ?           96+1.0d+0*rhob*t106*t110*(-1.030176d-2*t115*t175*t42*t6
     @           +t113*t114*t14*t42+t110*t13*t42-5.15088d-3*t113*t114*t1
     1           2*t42-1.030176d-2*gammabb*t112*t114*t14*t175-1.030176d-
     2           2*t11*t111*t175/rhob**8-5.15088d-3*gammabb*t112*t113*t1
     3           3+2*gammabb*t11*t112*t113)*t64-5.15088d-3*t106*t107*t11
     4           3*t116*t64-1.25d-1*t103*t110*t116*t64)*wght+Cmat(iq,D1_
     5           GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*t118*(-1.219864d-2*t107*t122*t123
     1           *t162*t44-6.09932d-3*t107*t121*t126*t44+2.0d+0*t107*t12
     2           1*t122*t44-1.219864d-2*t107*t124*t125*t162-1.219864d-2*
     3           t107*t119*t120*t162-6.09932d-3*t107*t121*t123*t127+2.0d
     4           +0*t107*t118*t127+4.0d+0*t107*t121*t123*t124)*t96-6.099
     5           32d-3*t107*t121*t128*t96+1.0d+0*rhob*t106*t110*(-2.0603
     6           52d-2*t107*t115*t175*t6+4.0d+0*t107*t113*t114*t6-2.0603
     7           52d-2*gammabb*t114*t14*t175*t177+2.0d+0*gammabb*t113*t1
     8           4*t177-1.030176d-2*gammabb*t113*t13*t177-2.060352d-2*t1
     9           1*t111*t175/rhob**7-1.030176d-2*t107*t113*t114*t12+2.0d
     :           +0*t107*t110*t12)*t64-1.030176d-2*t106*t113*t116*t51*t6
     ;           4+1.25d-1*gammabb*t110*t116*t176*t64-5.0d-1*rhob*t102*t
     <           105*t176*t64+1.0d+0*rhob*t102*t103*t64)*wght+Mmat(iq,D1
     =           _TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhoa**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhoa**6.666666666666666d-1
              t17 = rhoa**5.0d-1
              t18 = 1/t17
              t19 = 1/rhoa**3.333333333333333d-1
              t20 = 1/rhoa**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = param(18)
              t31 = 2.4d-51*t1+1.0d+0
              t32 = 1/t31
              t33 = param(19)
              t34 = param(20)
              t35 = param(21)
              t36 = param(22)
              t37 = 2.4d-51*t1*t32*t36+t35
              t38 = 2.4d-51*t1*t32*t37+t34
              t39 = 2.4d-51*t1*t32*t38+t33
              t40 = 2.4d-51*t1*t32*t39+t30
              t41 = 1/rhob**1.6666666666666669d+0
              t42 = 6.0d-50*t41
              t43 = 5.15088d-3*(t42-9.11559972d+0)+1.0d+0
              t44 = 1/t43
              t45 = 1/t43**2
              t46 = 2.0d-50*t41
              t47 = t46-9.11559972d+0
              t48 = t47**2
              t49 = t45*t48*t6+t5+4.0d-50*t14*t41*t45*t47+t12*t44*t47+1.
     1           6d-99*t11*t45/rhob**3.3333333333333337d+0+4.0d-50*t13*t
     2           41*t44
              t50 = 1/rhob**6.666666666666666d-1
              t51 = rhob**5.0d-1
              t52 = 1/t51
              t53 = 1/rhob**3.333333333333333d-1
              t54 = 1/rhob**1.6666666666666666d-1
              t55 = 1.1120374863094686d+1*t54+3.8447462374472113d+0*t53+
     1           1.644733775567609d+0*t52+2.4058712912881916d-1*t50
              t56 = 3.216395899738507d+1/t55+1.0d+0
              t57 = log(t56)
              t58 = 1.274696188700087d-1*t53+1.0d+0
              t59 = 5.982550435771079d+0*t54+2.2255694211506874d+0*t53+8
     1           .004286349993635d-1*t52+1.8970043257475583d-1*t50
              t60 = 1.6081979498692536d+1/t59+1.0d+0
              t61 = log(t60)
              t62 = 1.3256889990520176d-1*t53+1.0d+0
              t63 = -6.903522198342671d-18*t61*t62-3.1090699999999993d-2
     1           *t57*t58
              t64 = 2.4d-51*t41+1.0d+0
              t65 = 1/t64
              t66 = 2.4d-51*t36*t41*t65+t35
              t67 = 2.4d-51*t41*t65*t66+t34
              t68 = 2.4d-51*t41*t65*t67+t33
              t69 = 2.4d-51*t41*t65*t68+t30
              t70 = param(6)
              t71 = 3.04966d-3*(t42+t2-1.823119944d+1)+1.0d+0
              t72 = 1/t71**2
              t73 = t8+t46-1.823119944d+1
              t74 = t73**2
              t75 = param(4)
              t76 = 4.0d-50*t41+4.0d-50*t1
              t77 = t76**2
              t78 = param(3)
              t79 = 1/t71
              t80 = param(2)
              t81 = param(5)
              t82 = t72*t73*t76*t81+t76*t79*t80+t73*t78*t79+t72*t75*t77+
     1           t70*t72*t74+param(1)
              t83 = rhob+rhoa
              t84 = 1/t83**3.333333333333333d-1
              t85 = 1.3256889990520176d-1*t84+1.0d+0
              t86 = rhoa-rhob
              t87 = t86**4
              t88 = 1/t83**4
              t89 = 1/t83
              t90 = 1.0d+0-t86*t89
              t91 = t86*t89+1.0d+0
              t92 = t91**1.3333333333333333d+0+t90**1.3333333333333333d+
     1           0-2.0d+0
              t93 = -1.923661050931536d+0*t87*t88*t92
              t94 = t93+1.0d+0
              t95 = 1/t83**6.666666666666666d-1
              t96 = t83**5.0d-1
              t97 = 1/t96
              t98 = 1/t83**1.6666666666666666d-1
              t99 = 5.982550435771079d+0*t98+8.004286349993635d-1*t97+1.
     1           8970043257475583d-1*t95+2.2255694211506874d+0*t84
              t100 = 1.6081979498692536d+1/t99+1.0d+0
              t101 = log(t100)
              t102 = -6.21814d-2*t101*t85*t94
              t103 = 6.901399211255825d-2*t84+1.0d+0
              t104 = t93+1.923661050931536d+0*t92
              t105 = 8.157414703487641d+0*t98+4.3009724712766434d-1*t97+
     1           1.9115125951273373d-1*t95+2.247591863577616d+0*t84
              t106 = 2.9608813203268075d+1/t105+1.0d+0
              t107 = log(t106)
              t108 = 1.9751631321680768d-2*t103*t104*t107
              t109 = 1.274696188700087d-1*t84+1.0d+0
              t110 = 1.1120374863094686d+1*t98+1.644733775567609d+0*t97+
     1           2.4058712912881916d-1*t95+3.8447462374472113d+0*t84
              t111 = 3.216395899738507d+1/t110+1.0d+0
              t112 = log(t111)
              t113 = -5.980796863619711d-2*t109*t112*t87*t88*t92
              t114 = (t113+t108+t102)*t83-rhob*t63-rhoa*t29
              t115 = 3.1d-3*t76+1.0d+0
              t116 = 1/t115
              t117 = param(17)
              t118 = 3.1d-3*t116*t117*t76+param(16)
              t119 = 3.1d-3*t116*t118*t76+param(15)
              t120 = 3.1d-3*t116*t119*t76+param(14)
              t121 = 3.1d-3*t116*t120*t76+param(13)
              t122 = 1/t17**3
              t123 = 1/rhoa**1.3333333333333333d+0
              t124 = 1/rhoa**1.1666666666666667d+0
              t125 = 1.1102230246251565d-16*(-9.970917392951799d-1*t124-
     1           7.418564737168958d-1*t123-4.002143174996817d-1*t122-1.2
     2           64669550498372d-1*t1)*t28/(t25**2*t26)+3.05064114435142
     3           64d-19*t123*t27+1.0d+0*(-1.8533958105157808d+0*t124-1.2
     4           815820791490704d+0*t123-8.223668877838045d-1*t122-1.603
     5           9141941921276d-1*t1)*t24/(t21**2*t22)+1.321039893133926
     6           5d-3*t123*t23
              t126 = 1/t31**2
              t127 = 1/rhoa**4.333333333333333d+0
              t128 = 1/rhoa**2.6666666666666666d+0
              t129 = 1/t3**3
              t130 = 1/t83**1.6666666666666669d+0
              t131 = 1/t96**3
              t132 = 1/t83**1.3333333333333333d+0
              t133 = 1/t83**1.1666666666666667d+0
              t134 = 1.0d+0*(-9.970917392951799d-1*t133-7.41856473716895
     1           8d-1*t132-4.002143174996817d-1*t131-1.264669550498372d-
     2           1*t130)*t85*t94/(t100*t99**2)
              t135 = -5.848223622634647d-1*t103*t104*(-1.359569117247940
     1           2d+0*t133-7.491972878592053d-1*t132-2.1504862356383217d
     2           -1*t131-1.2743417300848914d-1*t130)/(t105**2*t106)
              t136 = 1.923661050931536d+0*t109*(-1.8533958105157808d+0*t
     1           133-1.2815820791490704d+0*t132-8.223668877838045d-1*t13
     2           1-1.6039141941921276d-1*t130)*t87*t88*t92/(t110**2*t111
     3           )
              t137 = 1/t83**2
              t138 = t137*t86
              t139 = -t89
              t140 = t90**3.333333333333333d-1
              t141 = -t137*t86
              t142 = t91**3.333333333333333d-1
              t143 = 1.3333333333333333d+0*t142*(t89+t141)+1.33333333333
     1           33333d+0*(t139+t138)*t140
              t144 = -1.923661050931536d+0*t143*t87*t88
              t145 = 1/t83**5
              t146 = 7.694644203726144d+0*t145*t87*t92
              t147 = t86**3
              t148 = -7.694644203726144d+0*t147*t88*t92
              t149 = 2.747773264188437d-3*t101*t132*t94
              t150 = -4.5437964274821163d-4*t104*t107*t132
              t151 = 2.541232989148493d-3*t112*t87*t92/t83**5.3333333333
     1           33333d+0
              t152 = 2.3923187454478842d-1*t109*t112*t145*t87*t92
              t153 = t83*(-2.3923187454478842d-1*t109*t112*t147*t88*t92-
     1           5.980796863619711d-2*t109*t112*t143*t87*t88-6.21814d-2*
     2           t101*(t148+t146+t144)*t85+t152+t151+t150+t149+1.9751631
     3           321680768d-2*t103*t107*(t148+t146+t144+1.92366105093153
     4           6d+0*t143)+t136+t135+t134)+6.903522198342671d-18*t27*t2
     5           8+3.1090699999999993d-2*t23*t24-rhoa*t125+t113+t108+t10
     6           2
              t154 = 1/t115**2
              t155 = 1/t71**3
              t156 = 1/t51**3
              t157 = 1/rhob**1.3333333333333333d+0
              t158 = 1/rhob**1.1666666666666667d+0
              t159 = 1.1102230246251565d-16*(-1.264669550498372d-1*t41-9
     1           .970917392951799d-1*t158-7.418564737168958d-1*t157-4.00
     2           2143174996817d-1*t156)*t62/(t59**2*t60)+3.0506411443514
     3           264d-19*t157*t61+1.0d+0*(-1.6039141941921276d-1*t41-1.8
     4           533958105157808d+0*t158-1.2815820791490704d+0*t157-8.22
     5           3668877838045d-1*t156)*t58/(t55**2*t56)+1.3210398931339
     6           265d-3*t157*t57
              t160 = 1/t64**2
              t161 = 1/rhob**4.333333333333333d+0
              t162 = 1/rhob**2.6666666666666666d+0
              t163 = 1/t43**3
              t164 = 1.3333333333333333d+0*t140*(t89+t138)+1.33333333333
     1           33333d+0*(t141+t139)*t142
              t165 = -1.923661050931536d+0*t164*t87*t88
              t166 = 7.694644203726144d+0*t147*t88*t92
              t167 = t83*(2.3923187454478842d-1*t109*t112*t147*t88*t92-5
     1           .980796863619711d-2*t109*t112*t164*t87*t88-6.21814d-2*t
     2           101*(t166+t165+t146)*t85+1.9751631321680768d-2*t103*t10
     3           7*(t166+t165+1.923661050931536d+0*t164+t146)+t152+t151+
     4           t150+t149+t136+t135+t134)+6.903522198342671d-18*t61*t62
     5           +3.1090699999999993d-2*t57*t58-rhob*t159+t113+t108+t102
              fnc(iq) = (1.0d+0*t114*t79*t82+5.0d-1*rhob*t63*t69+5.0d-1*
     1           rhob*t44*t49*t63+5.0d-1*rhoa*t29*t40+5.0d-1*rhoa*t15*t2
     2           9*t4+1.0d+0*t114*t121)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t4*(5.0d-1*rhoa*t29*(-6.666666666666666d
     1           -50*t128*t6*t7*t9-6.666666666666666d-50*t128*t14*t7*t9+
     2           5.15088d-52*t12*t128*t7*t9+4.1207039999999995d-101*t127
     3           *t129*t14*t9-1.3333333333333333d-99*t127*t14*t7+2.06035
     4           19999999997d-101*t127*t13*t7-5.333333333333334d-99*t11*
     5           t127*t7+1.030176d-51*t10*t128*t129*t6-6.666666666666666
     6           d-50*t128*t13*t4-3.333333333333333d-50*t12*t128*t4+1.64
     7           82816d-150*t11*t129/rhoa**6)+5.0d-1*t15*t29+5.0d-1*rhoa
     8           *t125*t15)+t79*(1.0d+0*t153*t82+1.0d+0*t114*(6.09932d-5
     9           2*t128*t155*t73*t76*t81-3.333333333333333d-50*t128*t72*
     :           t76*t81-6.666666666666666d-50*t128*t72*t73*t81-6.666666
     ;           666666666d-50*t128*t79*t80+3.04966d-52*t128*t72*t76*t80
     <           -3.333333333333333d-50*t128*t78*t79+3.04966d-52*t128*t7
     =           2*t73*t78+6.09932d-52*t128*t155*t75*t77-1.3333333333333
     >           333d-49*t128*t72*t75*t76+6.09932d-52*t128*t155*t70*t74-
     ?           6.666666666666666d-50*t128*t70*t72*t73))+3.04966d-52*t1
     @           14*t128*t72*t82+1.0d+0*t114*(3.1d-3*t116*t76*(3.1d-3*t1
     1           16*t76*(3.1d-3*t116*t76*(6.406666666666666d-55*t117*t12
     2           8*t154*t76-2.0666666666666667d-52*t116*t117*t128)+6.406
     3           666666666666d-55*t118*t128*t154*t76-2.0666666666666667d
     4           -52*t116*t118*t128)+6.406666666666666d-55*t119*t128*t15
     5           4*t76-2.0666666666666667d-52*t116*t119*t128)+6.40666666
     6           6666666d-55*t120*t128*t154*t76-2.0666666666666667d-52*t
     7           116*t120*t128)+2.57544d-52*t1*t15*t29*t7+5.0d-1*t29*t40
     8           +5.0d-1*rhoa*t125*t40+5.0d-1*rhoa*t29*(-4.0d-51*t128*t3
     9           2*t39+9.6d-102*t126*t127*t39+2.4d-51*t1*t32*(-4.0d-51*t
     :           128*t32*t38+9.6d-102*t126*t127*t38+2.4d-51*t1*t32*(-4.0
     ;           d-51*t128*t32*t37+9.6d-102*t126*t127*t37+2.4d-51*t1*t32
     <           *(9.6d-102*t126*t127*t36-4.0d-51*t128*t32*t36))))+1.0d+
     =           0*t121*t153)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t79*(1.0d+0*t167*t82+1.0d+0*t114*(6.0993
     1           2d-52*t155*t162*t73*t76*t81-3.333333333333333d-50*t162*
     2           t72*t76*t81-6.666666666666666d-50*t162*t72*t73*t81-6.66
     3           6666666666666d-50*t162*t79*t80+3.04966d-52*t162*t72*t76
     4           *t80-3.333333333333333d-50*t162*t78*t79+3.04966d-52*t16
     5           2*t72*t73*t78+6.09932d-52*t155*t162*t75*t77-1.333333333
     6           3333333d-49*t162*t72*t75*t76+6.09932d-52*t155*t162*t70*
     7           t74-6.666666666666666d-50*t162*t70*t72*t73))+3.04966d-5
     8           2*t114*t162*t72*t82+1.0d+0*t114*(3.1d-3*t116*t76*(3.1d-
     9           3*t116*t76*(3.1d-3*t116*t76*(6.406666666666666d-55*t117
     :           *t154*t162*t76-2.0666666666666667d-52*t116*t117*t162)+6
     ;           .406666666666666d-55*t118*t154*t162*t76-2.0666666666666
     <           667d-52*t116*t118*t162)+6.406666666666666d-55*t119*t154
     =           *t162*t76-2.0666666666666667d-52*t116*t119*t162)+6.4066
     >           66666666666d-55*t120*t154*t162*t76-2.0666666666666667d-
     ?           52*t116*t120*t162)+5.0d-1*t63*t69+5.0d-1*rhob*t159*t69+
     @           5.0d-1*rhob*t63*(-4.0d-51*t162*t65*t68+9.6d-102*t160*t1
     1           61*t68+2.4d-51*t41*t65*(-4.0d-51*t162*t65*t67+9.6d-102*
     2           t160*t161*t67+2.4d-51*t41*t65*(-4.0d-51*t162*t65*t66+9.
     3           6d-102*t160*t161*t66+2.4d-51*t41*t65*(9.6d-102*t160*t16
     4           1*t36-4.0d-51*t162*t36*t65))))+t44*(5.0d-1*rhob*(1.0301
     5           76d-51*t162*t163*t48*t6-6.666666666666666d-50*t162*t45*
     6           t47*t6-6.666666666666666d-50*t14*t162*t45*t47+5.15088d-
     7           52*t12*t162*t45*t47+4.1207039999999995d-101*t14*t161*t1
     8           63*t47-1.3333333333333333d-99*t14*t161*t45+2.0603519999
     9           999997d-101*t13*t161*t45-5.333333333333334d-99*t11*t161
     :           *t45-6.666666666666666d-50*t13*t162*t44-3.3333333333333
     ;           33d-50*t12*t162*t44+1.6482816d-150*t11*t163/rhob**6)*t6
     <           3+5.0d-1*t49*t63+5.0d-1*rhob*t159*t49)+2.57544d-52*t41*
     =           t45*t49*t63+1.0d+0*t121*t167)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(22)
              t5 = 6.0d-2*gammaaa*t1*t3*t4+param(21)
              t6 = 6.0d-2*gammaaa*t1*t3*t5+param(20)
              t7 = 6.0d-2*gammaaa*t1*t3*t6+param(19)
              t8 = 6.0d-2*gammaaa*t1*t3*t7+param(18)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taua
              t24 = 1/rhoa
              t25 = 2.0d+0*taua-2.5d-1*gammaaa*t24
              t26 = 1.0d+0-1.25d-1*gammaaa*t23*t24
              t27 = 1/rhoa**1.6666666666666669d+0
              t28 = 2.0d+0*t27*taua
              t29 = 5.15088d-3*(t28+gammaaa*t1-9.11559972d+0)+1.0d+0
              t30 = 1/t29
              t31 = param(10)
              t32 = gammaaa**2
              t33 = 1/rhoa**5.333333333333333d+0
              t34 = 1/t29**2
              t35 = param(11)
              t36 = t28-9.11559972d+0
              t37 = param(12)
              t38 = t36**2
              t39 = param(8)
              t40 = param(9)
              t41 = t30*t36*t40+gammaaa*t1*t30*t39+t34*t37*t38+gammaaa*t
     1           1*t34*t35*t36+t31*t32*t33*t34+param(7)
              t42 = 1/t10**3
              t43 = 1/rhoa**1.3333333333333333d+0
              t44 = 1/rhoa**1.1666666666666667d+0
              t45 = 1.1102230246251565d-16*t21*(-9.970917392951799d-1*t4
     1           4-7.418564737168958d-1*t43-4.002143174996817d-1*t42-1.2
     2           64669550498372d-1*t27)/(t18**2*t19)+1.0d+0*t17*(-1.8533
     3           958105157808d+0*t44-1.2815820791490704d+0*t43-8.2236688
     4           77838045d-1*t42-1.6039141941921276d-1*t27)/(t14**2*t15)
     5           +3.0506411443514264d-19*t20*t43+1.3210398931339265d-3*t
     6           16*t43
              t46 = 1/t2**2
              t47 = 1/rhoa**6.333333333333333d+0
              t48 = 1/rhoa**3.6666666666666664d+0
              t49 = -3.3333333333333337d+0*t1*taua-2.6666666666666666d+0
     1           *gammaaa*t48
              t50 = 1/t29**3
              t51 = 1/taua**2
              t52 = 1/rhoa**4.333333333333333d+0
              fnc(iq) = (5.0d-1*rhoa*t22*t23*t25*t8+1.0d+0*rhoa*t22*t26*
     1           t30*t41)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t30*(1.0d+0*rhoa*t22*t26*(-3.33333333333
     1           33337d+0*t1*t30*t40*taua-6.666666666666667d+0*t1*t34*t3
     2           6*t37*taua-3.3333333333333337d+0*gammaaa*t33*t34*t35*ta
     3           ua-1.030176d-2*t37*t38*t49*t50-1.030176d-2*gammaaa*t1*t
     4           35*t36*t49*t50-1.030176d-2*t31*t32*t33*t49*t50-5.15088d
     5           -3*t34*t36*t40*t49-5.15088d-3*gammaaa*t1*t34*t39*t49-2.
     6           6666666666666666d+0*gammaaa*t30*t39*t48-2.6666666666666
     7           666d+0*gammaaa*t34*t35*t36*t48-5.333333333333333d+0*t31
     8           *t32*t34*t47)+1.0d+0*rhoa*t26*t41*t45+1.0d+0*t22*t26*t4
     9           1)+t23*(5.0d-1*rhoa*t25*t45*t8+5.0d-1*t22*t25*t8+5.0d-1
     :           *rhoa*t22*t25*(-1.5999999999999998d-1*gammaaa*t3*t48*t7
     ;           +9.599999999999997d-3*t32*t46*t47*t7+6.0d-2*gammaaa*t1*
     <           t3*(-1.5999999999999998d-1*gammaaa*t3*t48*t6+9.59999999
     =           9999997d-3*t32*t46*t47*t6+6.0d-2*gammaaa*t1*t3*(-1.5999
     >           999999999998d-1*gammaaa*t3*t48*t5+9.599999999999997d-3*
     ?           t32*t46*t47*t5+6.0d-2*gammaaa*t1*t3*(9.599999999999997d
     @           -3*t32*t4*t46*t47-1.5999999999999998d-1*gammaaa*t3*t4*t
     1           48)))))+1.25d-1*gammaaa*t22*t23*t24*t8-5.15088d-3*rhoa*
     2           t22*t26*t34*t41*t49+1.25d-1*gammaaa*t22*t23*t24*t30*t41
     3           )*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (t23*(5.0d-1*rhoa*t22*t25*(-3.6d-3*gamma
     1           aa*t33*t46*t7+6.0d-2*t1*t3*t7+6.0d-2*gammaaa*t1*t3*(-3.
     2           6d-3*gammaaa*t33*t46*t6+6.0d-2*t1*t3*t6+6.0d-2*gammaaa*
     3           t1*t3*(-3.6d-3*gammaaa*t33*t46*t5+6.0d-2*t1*t3*t5+6.0d-
     4           2*gammaaa*t1*t3*(6.0d-2*t1*t3*t4-3.6d-3*gammaaa*t33*t4*
     5           t46))))-1.25d-1*t22*t8)+1.0d+0*rhoa*t22*t26*t30*(-1.030
     6           176d-2*t1*t37*t38*t50-1.030176d-2*gammaaa*t33*t35*t36*t
     7           50-1.030176d-2*t31*t32*t50/rhoa**8-5.15088d-3*t1*t34*t3
     8           6*t40-5.15088d-3*gammaaa*t33*t34*t39+t1*t30*t39+t1*t34*
     9           t35*t36+2*gammaaa*t31*t33*t34)-5.15088d-3*t22*t26*t27*t
     :           34*t41-1.25d-1*t22*t23*t30*t41)*wght+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = (-1.030176d-2*t22*t26*t34*t41*t9-5.0d-1*r
     1           hoa*t22*t25*t51*t8+1.0d+0*rhoa*t22*t23*t8+1.0d+0*rhoa*t
     2           22*t26*t30*(-2.060352d-2*gammaaa*t35*t36*t50*t52-1.0301
     3           76d-2*gammaaa*t34*t39*t52+2.0d+0*gammaaa*t34*t35*t52-2.
     4           060352d-2*t27*t37*t38*t50-2.060352d-2*t31*t32*t50/rhoa*
     5           *7-1.030176d-2*t27*t34*t36*t40+2.0d+0*t27*t30*t40+4.0d+
     6           0*t27*t34*t36*t37)+1.25d-1*gammaaa*t22*t30*t41*t51)*wgh
     7           t+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(22)
              t5 = 6.0d-2*gammaaa*t1*t3*t4+param(21)
              t6 = 6.0d-2*gammaaa*t1*t3*t5+param(20)
              t7 = 6.0d-2*gammaaa*t1*t3*t6+param(19)
              t8 = 6.0d-2*gammaaa*t1*t3*t7+param(18)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taua
              t24 = 1/rhoa
              t25 = 2.0d+0*taua-2.5d-1*gammaaa*t24
              t26 = 1.0d+0-1.25d-1*gammaaa*t23*t24
              t27 = 1/rhoa**1.6666666666666669d+0
              t28 = 2.0d+0*t27*taua
              t29 = 5.15088d-3*(t28+gammaaa*t1-9.11559972d+0)+1.0d+0
              t30 = 1/t29
              t31 = param(10)
              t32 = gammaaa**2
              t33 = 1/rhoa**5.333333333333333d+0
              t34 = 1/t29**2
              t35 = param(11)
              t36 = t28-9.11559972d+0
              t37 = param(12)
              t38 = t36**2
              t39 = param(8)
              t40 = param(9)
              t41 = t30*t36*t40+gammaaa*t1*t30*t39+t34*t37*t38+gammaaa*t
     1           1*t34*t35*t36+t31*t32*t33*t34+param(7)
              t42 = 1/t10**3
              t43 = 1/rhoa**1.3333333333333333d+0
              t44 = 1/rhoa**1.1666666666666667d+0
              t45 = 1.1102230246251565d-16*t21*(-9.970917392951799d-1*t4
     1           4-7.418564737168958d-1*t43-4.002143174996817d-1*t42-1.2
     2           64669550498372d-1*t27)/(t18**2*t19)+1.0d+0*t17*(-1.8533
     3           958105157808d+0*t44-1.2815820791490704d+0*t43-8.2236688
     4           77838045d-1*t42-1.6039141941921276d-1*t27)/(t14**2*t15)
     5           +3.0506411443514264d-19*t20*t43+1.3210398931339265d-3*t
     6           16*t43
              t46 = 1/t2**2
              t47 = 1/rhoa**6.333333333333333d+0
              t48 = 1/rhoa**3.6666666666666664d+0
              t49 = -3.3333333333333337d+0*t1*taua-2.6666666666666666d+0
     1           *gammaaa*t48
              t50 = 1/t29**3
              t51 = 1/taua**2
              t52 = 1/rhoa**4.333333333333333d+0
              fnc(iq) = (5.0d-1*rhoa*t22*t23*t25*t8+1.0d+0*rhoa*t22*t26*
     1           t30*t41)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t30*(1.0d+0*rhoa*t22*t26*(-3.33333333333
     1           33337d+0*t1*t30*t40*taua-6.666666666666667d+0*t1*t34*t3
     2           6*t37*taua-3.3333333333333337d+0*gammaaa*t33*t34*t35*ta
     3           ua-1.030176d-2*t37*t38*t49*t50-1.030176d-2*gammaaa*t1*t
     4           35*t36*t49*t50-1.030176d-2*t31*t32*t33*t49*t50-5.15088d
     5           -3*t34*t36*t40*t49-5.15088d-3*gammaaa*t1*t34*t39*t49-2.
     6           6666666666666666d+0*gammaaa*t30*t39*t48-2.6666666666666
     7           666d+0*gammaaa*t34*t35*t36*t48-5.333333333333333d+0*t31
     8           *t32*t34*t47)+1.0d+0*rhoa*t26*t41*t45+1.0d+0*t22*t26*t4
     9           1)+t23*(5.0d-1*rhoa*t25*t45*t8+5.0d-1*t22*t25*t8+5.0d-1
     :           *rhoa*t22*t25*(-1.5999999999999998d-1*gammaaa*t3*t48*t7
     ;           +9.599999999999997d-3*t32*t46*t47*t7+6.0d-2*gammaaa*t1*
     <           t3*(-1.5999999999999998d-1*gammaaa*t3*t48*t6+9.59999999
     =           9999997d-3*t32*t46*t47*t6+6.0d-2*gammaaa*t1*t3*(-1.5999
     >           999999999998d-1*gammaaa*t3*t48*t5+9.599999999999997d-3*
     ?           t32*t46*t47*t5+6.0d-2*gammaaa*t1*t3*(9.599999999999997d
     @           -3*t32*t4*t46*t47-1.5999999999999998d-1*gammaaa*t3*t4*t
     1           48)))))+1.25d-1*gammaaa*t22*t23*t24*t8-5.15088d-3*rhoa*
     2           t22*t26*t34*t41*t49+1.25d-1*gammaaa*t22*t23*t24*t30*t41
     3           )*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (t23*(5.0d-1*rhoa*t22*t25*(-3.6d-3*gamma
     1           aa*t33*t46*t7+6.0d-2*t1*t3*t7+6.0d-2*gammaaa*t1*t3*(-3.
     2           6d-3*gammaaa*t33*t46*t6+6.0d-2*t1*t3*t6+6.0d-2*gammaaa*
     3           t1*t3*(-3.6d-3*gammaaa*t33*t46*t5+6.0d-2*t1*t3*t5+6.0d-
     4           2*gammaaa*t1*t3*(6.0d-2*t1*t3*t4-3.6d-3*gammaaa*t33*t4*
     5           t46))))-1.25d-1*t22*t8)+1.0d+0*rhoa*t22*t26*t30*(-1.030
     6           176d-2*t1*t37*t38*t50-1.030176d-2*gammaaa*t33*t35*t36*t
     7           50-1.030176d-2*t31*t32*t50/rhoa**8-5.15088d-3*t1*t34*t3
     8           6*t40-5.15088d-3*gammaaa*t33*t34*t39+t1*t30*t39+t1*t34*
     9           t35*t36+2*gammaaa*t31*t33*t34)-5.15088d-3*t22*t26*t27*t
     :           34*t41-1.25d-1*t22*t23*t30*t41)*wght+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = (-1.030176d-2*t22*t26*t34*t41*t9-5.0d-1*r
     1           hoa*t22*t25*t51*t8+1.0d+0*rhoa*t22*t23*t8+1.0d+0*rhoa*t
     2           22*t26*t30*(-2.060352d-2*gammaaa*t35*t36*t50*t52-1.0301
     3           76d-2*gammaaa*t34*t39*t52+2.0d+0*gammaaa*t34*t35*t52-2.
     4           060352d-2*t27*t37*t38*t50-2.060352d-2*t31*t32*t50/rhoa*
     5           *7-1.030176d-2*t27*t34*t36*t40+2.0d+0*t27*t30*t40+4.0d+
     6           0*t27*t34*t36*t37)+1.25d-1*gammaaa*t22*t30*t41*t51)*wgh
     7           t+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhoa**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 2.4d-51*t1+1.0d+0
              t28 = 1/t27
              t29 = param(22)
              t30 = 2.4d-51*t1*t28*t29+param(21)
              t31 = 2.4d-51*t1*t28*t30+param(20)
              t32 = 2.4d-51*t1*t28*t31+param(19)
              t33 = 2.4d-51*t1*t28*t32+param(18)
              t34 = 1/t14**3
              t35 = 1/rhoa**1.3333333333333333d+0
              t36 = 1/rhoa**1.1666666666666667d+0
              t37 = 1.1102230246251565d-16*t25*(-9.970917392951799d-1*t3
     1           6-7.418564737168958d-1*t35-4.002143174996817d-1*t34-1.2
     2           64669550498372d-1*t1)/(t22**2*t23)+1.0d+0*t21*(-1.85339
     3           58105157808d+0*t36-1.2815820791490704d+0*t35-8.22366887
     4           7838045d-1*t34-1.6039141941921276d-1*t1)/(t18**2*t19)+3
     5           .0506411443514264d-19*t24*t35+1.3210398931339265d-3*t20
     6           *t35
              t38 = 1/t27**2
              t39 = 1/rhoa**4.333333333333333d+0
              t40 = 1/rhoa**2.6666666666666666d+0
              t41 = 1/t2**3
              fnc(iq) = (5.0d-1*rhoa*t26*t33+5.0d-1*rhoa*t12*t26*t3)*wgh
     1           t+fnc(iq)
              Amat(iq,D1_RA) = (t3*(5.0d-1*rhoa*t26*(5.15088d-52*t40*t5*
     1           t6*t9-3.333333333333333d-50*t3*t40*t9-5.333333333333334
     2           d-99*t39*t5*t8+1.6482816d-150*t41*t8/rhoa**6+1.030176d-
     3           51*t4*t40*t41*t7-6.666666666666666d-50*t4*t40*t5*t6-6.6
     4           66666666666666d-50*t11*t40*t5*t6+4.1207039999999995d-10
     5           1*t11*t39*t41*t6-1.3333333333333333d-99*t11*t39*t5+2.06
     6           03519999999997d-101*t10*t39*t5-6.666666666666666d-50*t1
     7           0*t3*t40)+5.0d-1*rhoa*t12*t37+5.0d-1*t12*t26)+2.57544d-
     8           52*t1*t12*t26*t5+5.0d-1*rhoa*t26*(2.4d-51*t1*t28*(2.4d-
     9           51*t1*t28*(2.4d-51*t1*t28*(9.6d-102*t29*t38*t39-4.0d-51
     :           *t28*t29*t40)-4.0d-51*t28*t30*t40+9.6d-102*t30*t38*t39)
     ;           -4.0d-51*t28*t31*t40+9.6d-102*t31*t38*t39)-4.0d-51*t28*
     <           t32*t40+9.6d-102*t32*t38*t39)+5.0d-1*rhoa*t33*t37+5.0d-
     =           1*t26*t33)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhoa**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 2.4d-51*t1+1.0d+0
              t28 = 1/t27
              t29 = param(22)
              t30 = 2.4d-51*t1*t28*t29+param(21)
              t31 = 2.4d-51*t1*t28*t30+param(20)
              t32 = 2.4d-51*t1*t28*t31+param(19)
              t33 = 2.4d-51*t1*t28*t32+param(18)
              t34 = 1/t14**3
              t35 = 1/rhoa**1.3333333333333333d+0
              t36 = 1/rhoa**1.1666666666666667d+0
              t37 = 1.1102230246251565d-16*t25*(-9.970917392951799d-1*t3
     1           6-7.418564737168958d-1*t35-4.002143174996817d-1*t34-1.2
     2           64669550498372d-1*t1)/(t22**2*t23)+1.0d+0*t21*(-1.85339
     3           58105157808d+0*t36-1.2815820791490704d+0*t35-8.22366887
     4           7838045d-1*t34-1.6039141941921276d-1*t1)/(t18**2*t19)+3
     5           .0506411443514264d-19*t24*t35+1.3210398931339265d-3*t20
     6           *t35
              t38 = 1/t27**2
              t39 = 1/rhoa**4.333333333333333d+0
              t40 = 1/rhoa**2.6666666666666666d+0
              t41 = 1/t2**3
              fnc(iq) = (5.0d-1*rhoa*t26*t33+5.0d-1*rhoa*t12*t26*t3)*wgh
     1           t+fnc(iq)
              Amat(iq,D1_RA) = (t3*(5.0d-1*rhoa*t26*(5.15088d-52*t40*t5*
     1           t6*t9-3.333333333333333d-50*t3*t40*t9-5.333333333333334
     2           d-99*t39*t5*t8+1.6482816d-150*t41*t8/rhoa**6+1.030176d-
     3           51*t4*t40*t41*t7-6.666666666666666d-50*t4*t40*t5*t6-6.6
     4           66666666666666d-50*t11*t40*t5*t6+4.1207039999999995d-10
     5           1*t11*t39*t41*t6-1.3333333333333333d-99*t11*t39*t5+2.06
     6           03519999999997d-101*t10*t39*t5-6.666666666666666d-50*t1
     7           0*t3*t40)+5.0d-1*rhoa*t12*t37+5.0d-1*t12*t26)+2.57544d-
     8           52*t1*t12*t26*t5+5.0d-1*rhoa*t26*(2.4d-51*t1*t28*(2.4d-
     9           51*t1*t28*(2.4d-51*t1*t28*(9.6d-102*t29*t38*t39-4.0d-51
     :           *t28*t29*t40)-4.0d-51*t28*t30*t40+9.6d-102*t30*t38*t39)
     ;           -4.0d-51*t28*t31*t40+9.6d-102*t31*t38*t39)-4.0d-51*t28*
     <           t32*t40+9.6d-102*t32*t38*t39)+5.0d-1*rhoa*t33*t37+5.0d-
     =           1*t26*t33)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = param(22)
              t5 = 6.0d-2*gammabb*t1*t3*t4+param(21)
              t6 = 6.0d-2*gammabb*t1*t3*t5+param(20)
              t7 = 6.0d-2*gammabb*t1*t3*t6+param(19)
              t8 = 6.0d-2*gammabb*t1*t3*t7+param(18)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taub
              t24 = 1/rhob
              t25 = 2.0d+0*taub-2.5d-1*gammabb*t24
              t26 = 1.0d+0-1.25d-1*gammabb*t23*t24
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 2.0d+0*t27*taub
              t29 = 5.15088d-3*(t28+gammabb*t1-9.11559972d+0)+1.0d+0
              t30 = 1/t29
              t31 = param(10)
              t32 = gammabb**2
              t33 = 1/rhob**5.333333333333333d+0
              t34 = 1/t29**2
              t35 = param(11)
              t36 = t28-9.11559972d+0
              t37 = param(12)
              t38 = t36**2
              t39 = param(8)
              t40 = param(9)
              t41 = t30*t36*t40+gammabb*t1*t30*t39+t34*t37*t38+gammabb*t
     1           1*t34*t35*t36+t31*t32*t33*t34+param(7)
              t42 = 1/t10**3
              t43 = 1/rhob**1.3333333333333333d+0
              t44 = 1/rhob**1.1666666666666667d+0
              t45 = 1.1102230246251565d-16*t21*(-9.970917392951799d-1*t4
     1           4-7.418564737168958d-1*t43-4.002143174996817d-1*t42-1.2
     2           64669550498372d-1*t27)/(t18**2*t19)+1.0d+0*t17*(-1.8533
     3           958105157808d+0*t44-1.2815820791490704d+0*t43-8.2236688
     4           77838045d-1*t42-1.6039141941921276d-1*t27)/(t14**2*t15)
     5           +3.0506411443514264d-19*t20*t43+1.3210398931339265d-3*t
     6           16*t43
              t46 = 1/t2**2
              t47 = 1/rhob**6.333333333333333d+0
              t48 = 1/rhob**3.6666666666666664d+0
              t49 = -3.3333333333333337d+0*t1*taub-2.6666666666666666d+0
     1           *gammabb*t48
              t50 = 1/t29**3
              t51 = 1/taub**2
              t52 = 1/rhob**4.333333333333333d+0
              fnc(iq) = (5.0d-1*rhob*t22*t23*t25*t8+1.0d+0*rhob*t22*t26*
     1           t30*t41)*wght+fnc(iq)
              Amat(iq,D1_RB) = (t30*(1.0d+0*rhob*t22*t26*(-3.33333333333
     1           33337d+0*t1*t30*t40*taub-6.666666666666667d+0*t1*t34*t3
     2           6*t37*taub-3.3333333333333337d+0*gammabb*t33*t34*t35*ta
     3           ub-1.030176d-2*t37*t38*t49*t50-1.030176d-2*gammabb*t1*t
     4           35*t36*t49*t50-1.030176d-2*t31*t32*t33*t49*t50-5.15088d
     5           -3*t34*t36*t40*t49-5.15088d-3*gammabb*t1*t34*t39*t49-2.
     6           6666666666666666d+0*gammabb*t30*t39*t48-2.6666666666666
     7           666d+0*gammabb*t34*t35*t36*t48-5.333333333333333d+0*t31
     8           *t32*t34*t47)+1.0d+0*rhob*t26*t41*t45+1.0d+0*t22*t26*t4
     9           1)+t23*(5.0d-1*rhob*t25*t45*t8+5.0d-1*t22*t25*t8+5.0d-1
     :           *rhob*t22*t25*(-1.5999999999999998d-1*gammabb*t3*t48*t7
     ;           +9.599999999999997d-3*t32*t46*t47*t7+6.0d-2*gammabb*t1*
     <           t3*(-1.5999999999999998d-1*gammabb*t3*t48*t6+9.59999999
     =           9999997d-3*t32*t46*t47*t6+6.0d-2*gammabb*t1*t3*(-1.5999
     >           999999999998d-1*gammabb*t3*t48*t5+9.599999999999997d-3*
     ?           t32*t46*t47*t5+6.0d-2*gammabb*t1*t3*(9.599999999999997d
     @           -3*t32*t4*t46*t47-1.5999999999999998d-1*gammabb*t3*t4*t
     1           48)))))+1.25d-1*gammabb*t22*t23*t24*t8-5.15088d-3*rhob*
     2           t22*t26*t34*t41*t49+1.25d-1*gammabb*t22*t23*t24*t30*t41
     3           )*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = (t23*(5.0d-1*rhob*t22*t25*(-3.6d-3*gamma
     1           bb*t33*t46*t7+6.0d-2*t1*t3*t7+6.0d-2*gammabb*t1*t3*(-3.
     2           6d-3*gammabb*t33*t46*t6+6.0d-2*t1*t3*t6+6.0d-2*gammabb*
     3           t1*t3*(-3.6d-3*gammabb*t33*t46*t5+6.0d-2*t1*t3*t5+6.0d-
     4           2*gammabb*t1*t3*(6.0d-2*t1*t3*t4-3.6d-3*gammabb*t33*t4*
     5           t46))))-1.25d-1*t22*t8)+1.0d+0*rhob*t22*t26*t30*(-1.030
     6           176d-2*t1*t37*t38*t50-1.030176d-2*gammabb*t33*t35*t36*t
     7           50-1.030176d-2*t31*t32*t50/rhob**8-5.15088d-3*t1*t34*t3
     8           6*t40-5.15088d-3*gammabb*t33*t34*t39+t1*t30*t39+t1*t34*
     9           t35*t36+2*gammabb*t31*t33*t34)-5.15088d-3*t22*t26*t27*t
     :           34*t41-1.25d-1*t22*t23*t30*t41)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = (-1.030176d-2*t22*t26*t34*t41*t9-5.0d-1*r
     1           hob*t22*t25*t51*t8+1.0d+0*rhob*t22*t23*t8+1.0d+0*rhob*t
     2           22*t26*t30*(-2.060352d-2*gammabb*t35*t36*t50*t52-1.0301
     3           76d-2*gammabb*t34*t39*t52+2.0d+0*gammabb*t34*t35*t52-2.
     4           060352d-2*t27*t37*t38*t50-2.060352d-2*t31*t32*t50/rhob*
     5           *7-1.030176d-2*t27*t34*t36*t40+2.0d+0*t27*t30*t40+4.0d+
     6           0*t27*t34*t36*t37)+1.25d-1*gammabb*t22*t30*t41*t51)*wgh
     7           t+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhob**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 2.4d-51*t1+1.0d+0
              t28 = 1/t27
              t29 = param(22)
              t30 = 2.4d-51*t1*t28*t29+param(21)
              t31 = 2.4d-51*t1*t28*t30+param(20)
              t32 = 2.4d-51*t1*t28*t31+param(19)
              t33 = 2.4d-51*t1*t28*t32+param(18)
              t34 = 1/t14**3
              t35 = 1/rhob**1.3333333333333333d+0
              t36 = 1/rhob**1.1666666666666667d+0
              t37 = 1.1102230246251565d-16*t25*(-9.970917392951799d-1*t3
     1           6-7.418564737168958d-1*t35-4.002143174996817d-1*t34-1.2
     2           64669550498372d-1*t1)/(t22**2*t23)+1.0d+0*t21*(-1.85339
     3           58105157808d+0*t36-1.2815820791490704d+0*t35-8.22366887
     4           7838045d-1*t34-1.6039141941921276d-1*t1)/(t18**2*t19)+3
     5           .0506411443514264d-19*t24*t35+1.3210398931339265d-3*t20
     6           *t35
              t38 = 1/t27**2
              t39 = 1/rhob**4.333333333333333d+0
              t40 = 1/rhob**2.6666666666666666d+0
              t41 = 1/t2**3
              fnc(iq) = (5.0d-1*rhob*t26*t33+5.0d-1*rhob*t12*t26*t3)*wgh
     1           t+fnc(iq)
              Amat(iq,D1_RB) = (t3*(5.0d-1*rhob*t26*(5.15088d-52*t40*t5*
     1           t6*t9-3.333333333333333d-50*t3*t40*t9-5.333333333333334
     2           d-99*t39*t5*t8+1.6482816d-150*t41*t8/rhob**6+1.030176d-
     3           51*t4*t40*t41*t7-6.666666666666666d-50*t4*t40*t5*t6-6.6
     4           66666666666666d-50*t11*t40*t5*t6+4.1207039999999995d-10
     5           1*t11*t39*t41*t6-1.3333333333333333d-99*t11*t39*t5+2.06
     6           03519999999997d-101*t10*t39*t5-6.666666666666666d-50*t1
     7           0*t3*t40)+5.0d-1*rhob*t12*t37+5.0d-1*t12*t26)+2.57544d-
     8           52*t1*t12*t26*t5+5.0d-1*rhob*t26*(2.4d-51*t1*t28*(2.4d-
     9           51*t1*t28*(2.4d-51*t1*t28*(9.6d-102*t29*t38*t39-4.0d-51
     :           *t28*t29*t40)-4.0d-51*t28*t30*t40+9.6d-102*t30*t38*t39)
     ;           -4.0d-51*t28*t31*t40+9.6d-102*t31*t38*t39)-4.0d-51*t28*
     <           t32*t40+9.6d-102*t32*t38*t39)+5.0d-1*rhob*t33*t37+5.0d-
     =           1*t26*t33)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = param(22)
              t5 = 6.0d-2*gammabb*t1*t3*t4+param(21)
              t6 = 6.0d-2*gammabb*t1*t3*t5+param(20)
              t7 = 6.0d-2*gammabb*t1*t3*t6+param(19)
              t8 = 6.0d-2*gammabb*t1*t3*t7+param(18)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taub
              t24 = 1/rhob
              t25 = 2.0d+0*taub-2.5d-1*gammabb*t24
              t26 = 1.0d+0-1.25d-1*gammabb*t23*t24
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 2.0d+0*t27*taub
              t29 = 5.15088d-3*(t28+gammabb*t1-9.11559972d+0)+1.0d+0
              t30 = 1/t29
              t31 = param(10)
              t32 = gammabb**2
              t33 = 1/rhob**5.333333333333333d+0
              t34 = 1/t29**2
              t35 = param(11)
              t36 = t28-9.11559972d+0
              t37 = param(12)
              t38 = t36**2
              t39 = param(8)
              t40 = param(9)
              t41 = t30*t36*t40+gammabb*t1*t30*t39+t34*t37*t38+gammabb*t
     1           1*t34*t35*t36+t31*t32*t33*t34+param(7)
              t42 = 1/t10**3
              t43 = 1/rhob**1.3333333333333333d+0
              t44 = 1/rhob**1.1666666666666667d+0
              t45 = 1.1102230246251565d-16*t21*(-9.970917392951799d-1*t4
     1           4-7.418564737168958d-1*t43-4.002143174996817d-1*t42-1.2
     2           64669550498372d-1*t27)/(t18**2*t19)+1.0d+0*t17*(-1.8533
     3           958105157808d+0*t44-1.2815820791490704d+0*t43-8.2236688
     4           77838045d-1*t42-1.6039141941921276d-1*t27)/(t14**2*t15)
     5           +3.0506411443514264d-19*t20*t43+1.3210398931339265d-3*t
     6           16*t43
              t46 = 1/t2**2
              t47 = 1/rhob**6.333333333333333d+0
              t48 = 1/rhob**3.6666666666666664d+0
              t49 = -3.3333333333333337d+0*t1*taub-2.6666666666666666d+0
     1           *gammabb*t48
              t50 = 1/t29**3
              t51 = 1/taub**2
              t52 = 1/rhob**4.333333333333333d+0
              fnc(iq) = (5.0d-1*rhob*t22*t23*t25*t8+1.0d+0*rhob*t22*t26*
     1           t30*t41)*wght+fnc(iq)
              Amat(iq,D1_RB) = (t30*(1.0d+0*rhob*t22*t26*(-3.33333333333
     1           33337d+0*t1*t30*t40*taub-6.666666666666667d+0*t1*t34*t3
     2           6*t37*taub-3.3333333333333337d+0*gammabb*t33*t34*t35*ta
     3           ub-1.030176d-2*t37*t38*t49*t50-1.030176d-2*gammabb*t1*t
     4           35*t36*t49*t50-1.030176d-2*t31*t32*t33*t49*t50-5.15088d
     5           -3*t34*t36*t40*t49-5.15088d-3*gammabb*t1*t34*t39*t49-2.
     6           6666666666666666d+0*gammabb*t30*t39*t48-2.6666666666666
     7           666d+0*gammabb*t34*t35*t36*t48-5.333333333333333d+0*t31
     8           *t32*t34*t47)+1.0d+0*rhob*t26*t41*t45+1.0d+0*t22*t26*t4
     9           1)+t23*(5.0d-1*rhob*t25*t45*t8+5.0d-1*t22*t25*t8+5.0d-1
     :           *rhob*t22*t25*(-1.5999999999999998d-1*gammabb*t3*t48*t7
     ;           +9.599999999999997d-3*t32*t46*t47*t7+6.0d-2*gammabb*t1*
     <           t3*(-1.5999999999999998d-1*gammabb*t3*t48*t6+9.59999999
     =           9999997d-3*t32*t46*t47*t6+6.0d-2*gammabb*t1*t3*(-1.5999
     >           999999999998d-1*gammabb*t3*t48*t5+9.599999999999997d-3*
     ?           t32*t46*t47*t5+6.0d-2*gammabb*t1*t3*(9.599999999999997d
     @           -3*t32*t4*t46*t47-1.5999999999999998d-1*gammabb*t3*t4*t
     1           48)))))+1.25d-1*gammabb*t22*t23*t24*t8-5.15088d-3*rhob*
     2           t22*t26*t34*t41*t49+1.25d-1*gammabb*t22*t23*t24*t30*t41
     3           )*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = (t23*(5.0d-1*rhob*t22*t25*(-3.6d-3*gamma
     1           bb*t33*t46*t7+6.0d-2*t1*t3*t7+6.0d-2*gammabb*t1*t3*(-3.
     2           6d-3*gammabb*t33*t46*t6+6.0d-2*t1*t3*t6+6.0d-2*gammabb*
     3           t1*t3*(-3.6d-3*gammabb*t33*t46*t5+6.0d-2*t1*t3*t5+6.0d-
     4           2*gammabb*t1*t3*(6.0d-2*t1*t3*t4-3.6d-3*gammabb*t33*t4*
     5           t46))))-1.25d-1*t22*t8)+1.0d+0*rhob*t22*t26*t30*(-1.030
     6           176d-2*t1*t37*t38*t50-1.030176d-2*gammabb*t33*t35*t36*t
     7           50-1.030176d-2*t31*t32*t50/rhob**8-5.15088d-3*t1*t34*t3
     8           6*t40-5.15088d-3*gammabb*t33*t34*t39+t1*t30*t39+t1*t34*
     9           t35*t36+2*gammabb*t31*t33*t34)-5.15088d-3*t22*t26*t27*t
     :           34*t41-1.25d-1*t22*t23*t30*t41)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = (-1.030176d-2*t22*t26*t34*t41*t9-5.0d-1*r
     1           hob*t22*t25*t51*t8+1.0d+0*rhob*t22*t23*t8+1.0d+0*rhob*t
     2           22*t26*t30*(-2.060352d-2*gammabb*t35*t36*t50*t52-1.0301
     3           76d-2*gammabb*t34*t39*t52+2.0d+0*gammabb*t34*t35*t52-2.
     4           060352d-2*t27*t37*t38*t50-2.060352d-2*t31*t32*t50/rhob*
     5           *7-1.030176d-2*t27*t34*t36*t40+2.0d+0*t27*t30*t40+4.0d+
     6           0*t27*t34*t36*t37)+1.25d-1*gammabb*t22*t30*t41*t51)*wgh
     7           t+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            else 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhob**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 2.4d-51*t1+1.0d+0
              t28 = 1/t27
              t29 = param(22)
              t30 = 2.4d-51*t1*t28*t29+param(21)
              t31 = 2.4d-51*t1*t28*t30+param(20)
              t32 = 2.4d-51*t1*t28*t31+param(19)
              t33 = 2.4d-51*t1*t28*t32+param(18)
              t34 = 1/t14**3
              t35 = 1/rhob**1.3333333333333333d+0
              t36 = 1/rhob**1.1666666666666667d+0
              t37 = 1.1102230246251565d-16*t25*(-9.970917392951799d-1*t3
     1           6-7.418564737168958d-1*t35-4.002143174996817d-1*t34-1.2
     2           64669550498372d-1*t1)/(t22**2*t23)+1.0d+0*t21*(-1.85339
     3           58105157808d+0*t36-1.2815820791490704d+0*t35-8.22366887
     4           7838045d-1*t34-1.6039141941921276d-1*t1)/(t18**2*t19)+3
     5           .0506411443514264d-19*t24*t35+1.3210398931339265d-3*t20
     6           *t35
              t38 = 1/t27**2
              t39 = 1/rhob**4.333333333333333d+0
              t40 = 1/rhob**2.6666666666666666d+0
              t41 = 1/t2**3
              fnc(iq) = (5.0d-1*rhob*t26*t33+5.0d-1*rhob*t12*t26*t3)*wgh
     1           t+fnc(iq)
              Amat(iq,D1_RB) = (t3*(5.0d-1*rhob*t26*(5.15088d-52*t40*t5*
     1           t6*t9-3.333333333333333d-50*t3*t40*t9-5.333333333333334
     2           d-99*t39*t5*t8+1.6482816d-150*t41*t8/rhob**6+1.030176d-
     3           51*t4*t40*t41*t7-6.666666666666666d-50*t4*t40*t5*t6-6.6
     4           66666666666666d-50*t11*t40*t5*t6+4.1207039999999995d-10
     5           1*t11*t39*t41*t6-1.3333333333333333d-99*t11*t39*t5+2.06
     6           03519999999997d-101*t10*t39*t5-6.666666666666666d-50*t1
     7           0*t3*t40)+5.0d-1*rhob*t12*t37+5.0d-1*t12*t26)+2.57544d-
     8           52*t1*t12*t26*t5+5.0d-1*rhob*t26*(2.4d-51*t1*t28*(2.4d-
     9           51*t1*t28*(2.4d-51*t1*t28*(9.6d-102*t29*t38*t39-4.0d-51
     :           *t28*t29*t40)-4.0d-51*t28*t30*t40+9.6d-102*t30*t38*t39)
     ;           -4.0d-51*t28*t31*t40+9.6d-102*t31*t38*t39)-4.0d-51*t28*
     <           t32*t40+9.6d-102*t32*t38*t39)+5.0d-1*rhob*t33*t37+5.0d-
     =           1*t26*t33)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_m06 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {\it t_{11}}\,\left(-0.0598079686361971\,{
C>    \it t_{14}}\,{\it t_{15}}\,\left(0.1274696188700087\,{
C>    \it t_{12}}+1.0\right)\,{\it t_{17}}\,\log 
C>    \left({{32.16395899738507}\over{11.12037486309469\,{\it t_{21}}
C>    +3.844746237447211\,{\it t_{12}}+1.644733775567609\,{\it t_{20}}
C>    +0.2405871291288192\,{\it t_{19}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_{12}}
C>    +1.0\right)\,\left({\it t_{18}}+1.923661050931536\,{
C>    \it t_{17}}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{21}}+2.247591863577616\,{
C>    \it t_{12}}+0.4300972471276643\,{\it t_{20}}
C>    +0.1911512595127337\,{\it t_{19}}}}+1.0\right)-0.0621814
C>    \,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{21}}+2.225569421150687\,{
C>    \it t_{12}}+0.8004286349993635\,{\it t_{20}}
C>    +0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)-{
C>    \it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}\,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{26}} &=& {\it t_{25}}\,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{27}} &=& {\it t_{26}}+{\it t_{24}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{0.0031\,{\it t_{27}}+1.0}}\\\\ 
C>   {\it t_{29}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{30}} &=& {{1}\over{0.06\,{\it t_{23}}\,
C>    \sigma_{\alpha\alpha}+1.0}}\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{32}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{33}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{34}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\tau_\alpha}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_{37}} &=& {{2.0\,\tau_\alpha}
C>    \over{\rho_\alpha^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{38}} &=& 0.00515088\,\left({\it t_{37}}+{\it t_{24}}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{39}} &=& {{1}\over{{\it t_{38}}}}\\\\ 
C>   {\it t_{40}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{41}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{42}} &=& {{1}\over{{\it t_{38}}^2}}\\\\ 
C>   {\it t_{43}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{44}} &=& {\it t_{37}}-9.11559972\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{48}} &=& {{1}\over{0.06\,{\it t_{25}}\,
C>    \sigma_{\beta\beta}+1.0}}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{\tau_\beta}}\\\\ 
C>   {\it t_{50}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{51}} &=& {{2.0\,\tau_\beta}\over{\rho_\beta^{{{5}
C>    \over{3}}}}}\\\\ 
C>   {\it t_{52}} &=& 0.00515088\,\left({\it t_{51}}+{\it t_{26}}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{53}} &=& {{1}\over{{\it t_{52}}}}\\\\ 
C>   {\it t_{54}} &=& {{1}\over{{\it t_{52}}^2}}\\\\ 
C>   {\it t_{55}} &=& {\it t_{51}}-9.11559972\\\\ 
C>   {\it t_{56}} &=& 0.00304966\,\left({\it t_{51}}+{\it t_{37}}
C>    +{\it t_{26}}+{\it t_{24}}-18.23119944\right)+1.0\\\\ 
C>   {\it t_{57}} &=& {{1}\over{{\it t_{56}}}}\\\\ 
C>   {\it t_{58}} &=& {{1}\over{{\it t_{56}}^2}}\\\\ 
C>   {\it t_{59}} &=& {\it t_{51}}+{\it t_{37}}-18.23119944\\\\ 
C>   {\it t_{60}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{61}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{62}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{63}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{64}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{63}}+2.225569421150687\,{\it t_{62}}+0.8004286349993635
C>    \,{\it t_{61}}+0.1897004325747558\,{\it t_{60}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{62}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{63}}+3.844746237447211\,{\it t_{62}}+1.644733775567609
C>    \,{\it t_{61}}+0.2405871291288192\,{\it t_{60}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{62}}+1.0\right)\\\\ 
C>   {\it t_{65}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{66}} &=& {{1}\over{0.06\,{\it t_{65}}\,\sigma_{ss}
C>    +1.0}}\\\\ 
C>   {\it t_{67}} &=& {{1}\over{\tau_s}}\\\\ 
C>   {\it t_{68}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{69}} &=& {{2.0\,\tau_s}\over{\rho_s^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{70}} &=& 0.00515088\,\left({\it t_{69}}+{\it t_{65}}
C>    \,\sigma_{ss}-9.11559972\right)+1.0\\\\ 
C>   {\it t_{71}} &=& {{1}\over{{\it t_{70}}}}\\\\ 
C>   {\it t_{72}} &=& {{1}\over{{\it t_{70}}^2}}\\\\ 
C>   {\it t_{73}} &=& {\it t_{69}}-9.11559972\\\\ 
C>   f &=& 1.0\,{\it t_{22}}\,{\it t_{57}}\,\left({\it param}
C>    \left(3\right)\,{\it t_{59}}\,{\it t_{57}}+{\it param}
C>    \left(2\right)\,{\it t_{27}}\,{\it t_{57}}+{\it param}
C>    \left(6\right)\,{\it t_{59}}^2\,{\it t_{58}}+{\it param}
C>    \left(5\right)\,{\it t_{27}}\,{\it t_{59}}\,{\it t_{58}}+{
C>    \it param}\left(4\right)\,{\it t_{27}}^2\,{\it t_{58}}+{
C>    \it param}\left(1\right)\right)+1.0\,{\it t_{10}}\,\rho_\beta
C>    \,\left(1.0-0.125\,{\it t_{50}}\,\sigma_{\beta\beta}\,{
C>    \it t_{49}}\right)\,{\it t_{53}}\,\left({\it t_{47}}\,{
C>    \it t_{55}}\,{\it t_{53}}+{\it t_{46}}\,{\it t_{25}}\,
C>    \sigma_{\beta\beta}\,{\it t_{53}}+{\it t_{45}}\,{\it t_{55}}^2
C>    \,{\it t_{54}}+{\it t_{43}}\,{\it t_{25}}\,\sigma_{\beta\beta}
C>    \,{\it t_{55}}\,{\it t_{54}}+{{{\it t_{41}}\,
C>    \sigma_{\beta\beta}^2\,{\it t_{54}}}
C>    \over{\rho_\beta^{{{16}\over{3}}}}}+{\it t_{40}}\right)+0.5
C>    \,{\it t_{10}}\,\rho_\beta\,\left(0.06\,{\it t_{25}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,\left(0.06\,{\it t_{25}}
C>    \,\sigma_{\beta\beta}\,{\it t_{48}}\,\left(0.06\,{\it t_{25}}
C>    \,\sigma_{\beta\beta}\,{\it t_{48}}\,\left(0.06\,{\it t_{34}}
C>    \,{\it t_{25}}\,\sigma_{\beta\beta}\,{\it t_{48}}+{
C>    \it t_{33}}\right)+{\it t_{32}}\right)+{\it t_{31}}\right)+{
C>    \it t_{29}}\right)\,{\it t_{49}}\,\left(2.0\,\tau_\beta-0.25
C>    \,{\it t_{50}}\,\sigma_{\beta\beta}\right)+1.0\,{\it t_5}
C>    \,\rho_\alpha\,\left(1.0-0.125\,{\it t_{36}}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{35}}\right)\,{\it t_{39}}
C>    \,\left({\it t_{47}}\,{\it t_{44}}\,{\it t_{39}}+{\it t_{46}}
C>    \,{\it t_{23}}\,\sigma_{\alpha\alpha}\,{\it t_{39}}+{
C>    \it t_{45}}\,{\it t_{44}}^2\,{\it t_{42}}+{\it t_{43}}\,{
C>    \it t_{23}}\,\sigma_{\alpha\alpha}\,{\it t_{44}}\,{\it t_{42}}
C>    +{{{\it t_{41}}\,\sigma_{\alpha\alpha}^2\,{\it t_{42}}}
C>    \over{\rho_\alpha^{{{16}\over{3}}}}}+{\it t_{40}}\right)+0.5
C>    \,{\it t_5}\,\rho_\alpha\,\left(0.06\,{\it t_{23}}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{30}}\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{30}}\,\left(0.06\,{
C>    \it t_{23}}\,\sigma_{\alpha\alpha}\,{\it t_{30}}\,\left(0.06
C>    \,{\it t_{34}}\,{\it t_{23}}\,\sigma_{\alpha\alpha}\,{
C>    \it t_{30}}+{\it t_{33}}\right)+{\it t_{32}}\right)+{
C>    \it t_{31}}\right)+{\it t_{29}}\right)\,{\it t_{35}}\,
C>    \left(2.0\,\tau_\alpha-0.25\,{\it t_{36}}\,
C>    \sigma_{\alpha\alpha}\right)+1.0\,{\it t_{22}}\,\left(0.0031
C>    \,{\it t_{27}}\,{\it t_{28}}\,\left(0.0031\,{\it t_{27}}\,{
C>    \it t_{28}}\,\left(0.0031\,{\it t_{27}}\,{\it t_{28}}\,
C>    \left(0.0031\,{\it param}\left(17\right)\,{\it t_{27}}\,{
C>    \it t_{28}}+{\it param}\left(16\right)\right)+{
C>    \it param}\left(15\right)\right)+{\it param}
C>    \left(14\right)\right)+{\it param}\left(13\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,{\it t_{64}}\,\rho_s\,\left(1.0-0.125\,{\it t_{68}}
C>    \,\sigma_{ss}\,{\it t_{67}}\right)\,{\it t_{71}}\,\left({
C>    \it t_{47}}\,{\it t_{73}}\,{\it t_{71}}+{\it t_{46}}\,{
C>    \it t_{65}}\,\sigma_{ss}\,{\it t_{71}}+{\it t_{45}}\,{
C>    \it t_{73}}^2\,{\it t_{72}}+{\it t_{43}}\,{\it t_{65}}
C>    \,\sigma_{ss}\,{\it t_{73}}\,{\it t_{72}}+{{{\it t_{41}}
C>    \,\sigma_{ss}^2\,{\it t_{72}}}\over{\rho_s^{{{16}\over{3}}}}}
C>    +{\it t_{40}}\right)+0.5\,{\it t_{64}}\,\rho_s\,\left(0.06
C>    \,{\it t_{65}}\,\sigma_{ss}\,{\it t_{66}}\,\left(0.06\,{
C>    \it t_{65}}\,\sigma_{ss}\,{\it t_{66}}\,\left(0.06\,{
C>    \it t_{65}}\,\sigma_{ss}\,{\it t_{66}}\,\left(0.06\,{
C>    \it t_{34}}\,{\it t_{65}}\,\sigma_{ss}\,{\it t_{66}}+{
C>    \it t_{33}}\right)+{\it t_{32}}\right)+{\it t_{31}}\right)+{
C>    \it t_{29}}\right)\,{\it t_{67}}\,\left(2.0\,\tau_s-0.25\,{
C>    \it t_{68}}\,\sigma_{ss}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, DG Truhlar, J.Chem.Phys. 123, 194101 (2006)  , DOI: 
C> <a href="http://dx.doi.org/10.1063/1.2370993 "> 
C> 10.1063/1.2370993 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_m06_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.2d-3*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(17)
              t5 = 6.2d-3*gammaaa*t1*t3*t4+param(16)
              t6 = 6.2d-3*gammaaa*t1*t3*t5+param(15)
              t7 = 6.2d-3*gammaaa*t1*t3*t6+param(14)
              t8 = 6.2d-3*gammaaa*t1*t3*t7+param(13)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = -2*rhoa*t22
              t24 = t23-1.243628d-1*rhoa*(1.0522000558389212d-1*t12+1.0d
     1           +0)*log(1.6081979498692536d+1/(1.19503784087549d-1*t9+5
     2           .329846514438383d+0*t13+1.766435620181429d+0*t12+5.6598
     3           85156639418d-1*t11)+1.0d+0)
              t25 = 6.0d-2*gammaaa*t1+1.0d+0
              t26 = 1/t25
              t27 = param(22)
              t28 = 6.0d-2*gammaaa*t1*t26*t27+param(21)
              t29 = 6.0d-2*gammaaa*t1*t26*t28+param(20)
              t30 = 6.0d-2*gammaaa*t1*t26*t29+param(19)
              t31 = 6.0d-2*gammaaa*t1*t26*t30+param(18)
              t32 = 1/taua
              t33 = 1/rhoa
              t34 = 2.0d+0*taua-2.5d-1*gammaaa*t33
              t35 = 1.0d+0-1.25d-1*gammaaa*t32*t33
              t36 = 1/rhoa**1.6666666666666669d+0
              t37 = 2.0d+0*t36*taua
              t38 = 5.15088d-3*(t37+gammaaa*t1-9.11559972d+0)+1.0d+0
              t39 = 1/t38
              t40 = param(10)
              t41 = gammaaa**2
              t42 = 1/rhoa**5.333333333333333d+0
              t43 = 1/t38**2
              t44 = param(11)
              t45 = t37-9.11559972d+0
              t46 = param(12)
              t47 = t45**2
              t48 = param(8)
              t49 = param(9)
              t50 = t39*t45*t49+gammaaa*t1*t39*t48+t43*t46*t47+gammaaa*t
     1           1*t43*t44*t45+t40*t41*t42*t43+param(7)
              t51 = 4.0d+0*t36*taua
              t52 = 3.04966d-3*(t51+2*gammaaa*t1-1.823119944d+1)+1.0d+0
              t53 = 1/t52
              t54 = param(4)
              t55 = 1/t52**2
              t56 = param(5)
              t57 = t51-1.823119944d+1
              t58 = param(6)
              t59 = t57**2
              t60 = param(2)
              t61 = param(3)
              t62 = t53*t57*t61+2*gammaaa*t1*t53*t60+t55*t58*t59+2*gamma
     1           aa*t1*t55*t56*t57+4*t41*t42*t54*t55+param(1)
              t63 = 6.299605249474366d-1
              t64 = 1.414213562373095d+0
              t65 = 1/t64
              t66 = 7.937005259840998d-1
              t67 = 8.908987181403393d-1
              t68 = 1.8970043257475583d-1*t63*t9+5.982550435771079d+0*t1
     1           3*t67+2.2255694211506874d+0*t12*t66+8.004286349993635d-
     2           1*t11*t65
              t69 = 1.6081979498692536d+1/t68+1.0d+0
              t70 = log(t69)
              t71 = 1.3256889990520176d-1*t12*t66+1.0d+0
              t72 = 1/t19
              t73 = 1/t10**3
              t74 = 1/rhoa**1.3333333333333333d+0
              t75 = 1/rhoa**1.1666666666666667d+0
              t76 = -9.970917392951799d-1*t75-7.418564737168958d-1*t74-4
     1           .002143174996817d-1*t73-1.264669550498372d-1*t36
              t77 = 1/t18**2
              t78 = 1/t15
              t79 = -1.8533958105157808d+0*t75-1.2815820791490704d+0*t74
     1           -8.223668877838045d-1*t73-1.6039141941921276d-1*t36
              t80 = 1/t14**2
              t81 = 1.0d+0*t17*t78*t79*t80+1.1102230246251565d-16*t21*t7
     1           2*t76*t77+3.0506411443514264d-19*t20*t74+1.321039893133
     2           9265d-3*t16*t74
              t82 = 1/t69
              t83 = 3.968502629920499d-1
              t84 = -7.418564737168958d-1*t74*t83-4.4415387620319857d-1*
     1           t75-4.002143174996817d-1*t73/t64**3-3.9834594695849657d
     2           -2*t36
              t85 = 1/t68**2
              t86 = 2*rhoa*(1.0d+0*t71*t82*t84*t85+2.747773264188437d-3*
     1           t70*t74*t83)-rhoa*t81-6.21814d-2*t70*t71+6.903522198342
     2           671d-18*t20*t21+3.1090699999999993d-2*t16*t17
              t87 = 1/t2**2
              t88 = 1/rhoa**6.333333333333333d+0
              t89 = 1/rhoa**3.6666666666666664d+0
              t90 = 5.125333333333332d-5*t4*t41*t87*t88-8.26666666666666
     1           5d-3*gammaaa*t3*t4*t89
              t91 = 6.2d-3*gammaaa*t1*t3*t90-8.266666666666665d-3*gammaa
     1           a*t3*t5*t89+5.125333333333332d-5*t41*t5*t87*t88
              t92 = 6.2d-3*gammaaa*t1*t3*t91-8.266666666666665d-3*gammaa
     1           a*t3*t6*t89+5.125333333333332d-5*t41*t6*t87*t88
              t93 = 6.2d-3*gammaaa*t1*t3*t92-8.266666666666665d-3*gammaa
     1           a*t3*t7*t89+5.125333333333332d-5*t41*t7*t87*t88
              t94 = t23-1.243628d-1*rhoa*t70*t71
              t95 = 1/t25**2
              t96 = 9.599999999999997d-3*t27*t41*t88*t95-1.5999999999999
     1           998d-1*gammaaa*t26*t27*t89
              t97 = 6.0d-2*gammaaa*t1*t26*t96+9.599999999999997d-3*t28*t
     1           41*t88*t95-1.5999999999999998d-1*gammaaa*t26*t28*t89
              t98 = 6.0d-2*gammaaa*t1*t26*t97+9.599999999999997d-3*t29*t
     1           41*t88*t95-1.5999999999999998d-1*gammaaa*t26*t29*t89
              t99 = 6.0d-2*gammaaa*t1*t26*t98+9.599999999999997d-3*t30*t
     1           41*t88*t95-1.5999999999999998d-1*gammaaa*t26*t30*t89
              t100 = -3.3333333333333337d+0*t1*taua-2.6666666666666666d+
     1           0*gammaaa*t89
              t101 = 1/t38**3
              t102 = -3.3333333333333337d+0*t1*t39*t49*taua-6.6666666666
     1           66667d+0*t1*t43*t45*t46*taua-3.3333333333333337d+0*gamm
     2           aaa*t42*t43*t44*taua-2.6666666666666666d+0*gammaaa*t39*
     3           t48*t89-2.6666666666666666d+0*gammaaa*t43*t44*t45*t89-5
     4           .333333333333333d+0*t40*t41*t43*t88-5.15088d-3*t100*t43
     5           *t45*t49-5.15088d-3*gammaaa*t1*t100*t43*t48-1.030176d-2
     6           *t100*t101*t46*t47-1.030176d-2*gammaaa*t1*t100*t101*t44
     7           *t45-1.030176d-2*t100*t101*t40*t41*t42
              t103 = 1.0d+0*rhoa*t35*t50*t81+1.0d+0*t22*t35*t50+1.0d+0*r
     1           hoa*t102*t22*t35
              t104 = 1/t52**3
              t105 = -3.3333333333333337d+0*t1*t53*t61*taua-6.6666666666
     1           66667d+0*t1*t55*t57*t58*taua-6.666666666666667d+0*gamma
     2           aa*t42*t55*t56*taua-2.6666666666666666d+0*gammaaa*t53*t
     3           60*t89-2.6666666666666666d+0*gammaaa*t55*t56*t57*t89-1.
     4           0666666666666666d+1*t41*t54*t55*t88-3.04966d-3*t100*t55
     5           *t57*t61-6.09932d-3*gammaaa*t1*t100*t55*t60-6.09932d-3*
     6           t100*t104*t58*t59-1.219864d-2*gammaaa*t1*t100*t104*t56*
     7           t57-2.439728d-2*t100*t104*t41*t42*t54
              t106 = 1.0d+0*t105*t94+1.0d+0*t62*t86
              t107 = 3.1d-3*t1*t3*t4-1.9219999999999998d-5*gammaaa*t4*t4
     1           2*t87
              t108 = -1.9219999999999998d-5*gammaaa*t42*t5*t87+3.1d-3*t1
     1           *t3*t5+6.2d-3*gammaaa*t1*t107*t3
              t109 = -1.9219999999999998d-5*gammaaa*t42*t6*t87+3.1d-3*t1
     1           *t3*t6+6.2d-3*gammaaa*t1*t108*t3
              t110 = -1.9219999999999998d-5*gammaaa*t42*t7*t87+3.1d-3*t1
     1           *t3*t7+6.2d-3*gammaaa*t1*t109*t3
              t111 = 6.0d-2*t1*t26*t27-3.6d-3*gammaaa*t27*t42*t95
              t112 = -3.6d-3*gammaaa*t28*t42*t95+6.0d-2*t1*t26*t28+6.0d-
     1           2*gammaaa*t1*t111*t26
              t113 = -3.6d-3*gammaaa*t29*t42*t95+6.0d-2*t1*t26*t29+6.0d-
     1           2*gammaaa*t1*t112*t26
              t114 = -3.6d-3*gammaaa*t30*t42*t95+6.0d-2*t1*t26*t30+6.0d-
     1           2*gammaaa*t1*t113*t26
              t115 = 1/rhoa**8
              t116 = -5.15088d-3*t1*t43*t45*t49-5.15088d-3*gammaaa*t42*t
     1           43*t48+t1*t39*t48-1.030176d-2*t1*t101*t46*t47+t1*t43*t4
     2           4*t45-1.030176d-2*gammaaa*t101*t42*t44*t45+2*gammaaa*t4
     3           0*t42*t43-1.030176d-2*t101*t115*t40*t41
              t117 = -3.04966d-3*t1*t55*t57*t61-6.09932d-3*gammaaa*t42*t
     1           55*t60+t1*t53*t60-6.09932d-3*t1*t104*t58*t59+t1*t55*t56
     2           *t57-1.219864d-2*gammaaa*t104*t42*t56*t57+4*gammaaa*t42
     3           *t54*t55-2.439728d-2*t104*t115*t41*t54
              t118 = taua**2
              t119 = 1/t118
              t120 = 1/rhoa**7
              t121 = 1/rhoa**4.333333333333333d+0
              t122 = -1.030176d-2*t36*t43*t45*t49+2.0d+0*t36*t39*t49-1.0
     1           30176d-2*gammaaa*t121*t43*t48-2.060352d-2*t101*t36*t46*
     2           t47+4.0d+0*t36*t43*t45*t46-2.060352d-2*gammaaa*t101*t12
     3           1*t44*t45+2.0d+0*gammaaa*t121*t43*t44-2.060352d-2*t101*
     4           t120*t40*t41
              t123 = -6.09932d-3*t36*t55*t57*t61+2.0d+0*t36*t53*t61-1.21
     1           9864d-2*gammaaa*t121*t55*t60-1.219864d-2*t104*t36*t58*t
     2           59+4.0d+0*t36*t55*t57*t58-2.439728d-2*gammaaa*t104*t121
     3           *t56*t57+4.0d+0*gammaaa*t121*t55*t56-4.879456d-2*t104*t
     4           120*t41*t54
              t124 = 2.0d+0*t86*t93
              t125 = 2.0d+0*t71*t82*t84*t85
              t126 = 5.495546528376875d-3*t70*t74*t83
              t127 = t76**2
              t128 = 1/t10**5
              t129 = 1/rhoa**2.3333333333333334d+0
              t130 = 1/rhoa**2.1666666666666665d+0
              t131 = t79**2
              t132 = -8.497974591333913d-2*t74*t78*t79*t80+1.0d+0*(2.162
     1           2951122684114d+0*t130+1.7087761055320938d+0*t129+1.2335
     2           503316757068d+0*t128+2.673190323653546d-1*t1)*t17*t78*t
     3           80-2.0d+0*t131*t17*t78/t14**3-9.812069668265515d-18*t72
     4           *t74*t76*t77+1.1102230246251565d-16*(1.1632736958443765
     5           d+0*t130+9.89141964955861d-1*t129+6.003214762495226d-1*
     6           t128+2.1077825841639536d-1*t1)*t21*t72*t77-2.2204460492
     7           50313d-16*t127*t21*t72/t18**3+1.7854583920998188d-15*t1
     8           27*t21/(t18**4*t19**2)-4.0675215258019015d-19*t129*t20+
     9           3.216395899738507d+1*t131*t17/(t14**4*t15**2)-1.7613865
     :           241785684d-3*t129*t16
              t133 = t84**2
              t134 = 1.6081979498692536d+1*t133*t71/(t68**4*t69**2)
              t135 = -2.0d+0*t133*t71*t82/t68**3
              t136 = 1.9842513149602492d-1
              t137 = 1.0d+0*(6.003214762495226d-1*t128/t64**5+9.89141964
     1           955861d-1*t129*t136+2.5908976111853255d-1*t130+3.319549
     2           557987472d-2*t1)*t71*t82*t85
              t138 = -3.663697685584583d-3*t129*t136*t70
              t139 = log(2.9608813203268075d+1/(1.9115125951273373d-1*t6
     1           3*t9+8.157414703487641d+0*t13*t67+2.247591863577616d+0*
     2           t12*t66+4.3009724712766434d-1*t11*t65)+1.0d+0)
              t140 = 6.901399211255825d-2*t12*t66+1.0d+0
              t141 = 1/rhoa**2
              t142 = -8.837926660346784d-2*t74*t82*t83*t84*t85
              t143 = -2.0d+0*t17*t78*t79*t80-2.220446049250313d-16*t21*t
     1           72*t76*t77-6.101282288702853d-19*t20*t74-2.642079786267
     2           853d-3*t16*t74+2*rhoa*(t142+8.443431970194815d-3*t139*t
     3           140*t141+t138+t137+t135+t134)-rhoa*t132+t126+t125
              t144 = gammaaa**3
              t145 = 1/t2**3
              t146 = 1/rhoa**10
              t147 = 8.473884444444441d-7*t144*t145*t146*t7
              t148 = 1/rhoa**7.333333333333333d+0
              t149 = 1.0250666666666663d-4*t41*t87*t88*t92
              t150 = 1/rhoa**4.666666666666667d+0
              t151 = -1.653333333333333d-2*gammaaa*t3*t89*t92
              t152 = 8.473884444444441d-7*t144*t145*t146*t6
              t153 = 1.0250666666666663d-4*t41*t87*t88*t91
              t154 = -1.653333333333333d-2*gammaaa*t3*t89*t91
              t155 = 8.473884444444441d-7*t144*t145*t146*t5
              t156 = 1.0250666666666663d-4*t41*t87*t88*t90
              t157 = -1.653333333333333d-2*gammaaa*t3*t89*t90
              t158 = 8.473884444444441d-7*t144*t145*t146*t4
              t159 = 1/t25**3
              t160 = t100**2
              t161 = 1/t38**4
              t162 = 8.88888888888889d+0*t89*taua+9.777777777777779d+0*g
     1           ammaaa*t150
              t163 = 1.86008522312d-5*t104*t160*t62*t94
              t164 = 1/t52**4
              t165 = 1.1160511338720001d-4*gammaaa*t1*t160*t164*t56*t57
              t166 = 2.2321022677440003d-4*t160*t164*t41*t42*t54
              t167 = 5.580255669360001d-5*t160*t164*t58*t59
              t168 = 1.3011882666666666d-1*t100*t104*t41*t54*t88
              t169 = 8.132426666666668d-2*gammaaa*t100*t104*t42*t56*taua
              t170 = 3.2529706666666663d-2*gammaaa*t100*t104*t56*t57*t89
              t171 = 8.132426666666668d-2*t1*t100*t104*t57*t58*taua
              t172 = 1.86008522312d-5*t104*t160*t57*t61
              t173 = 3.72017044624d-5*gammaaa*t1*t104*t160*t60
              t174 = 1.6264853333333332d-2*gammaaa*t100*t55*t60*t89
              t175 = 2.033106666666667d-2*t1*t100*t55*t61*taua
              t176 = 2.2222222222222224d+1*t118*t42*t55*t58
              t177 = 2.0d+0*t105*t86
              t178 = -3.04966d-3*t100*t105*t94
              t179 = -3.04966d-3*t100*t62*t86
              t180 = -3.04966d-3*t100*t106
              t181 = 2*rhoa*(t142-8.443431970194815d-3*t139*t140*t141+t1
     1           38+t137+t135+t134)+t126+t125
              t182 = 1.0d+0*t110*t86
              t183 = 1/rhoa**9
              t184 = -3.1777066666666653d-7*t145*t183*t41*t7
              t185 = 5.125333333333332d-5*t109*t41*t87*t88
              t186 = -1.9219999999999998d-5*gammaaa*t42*t87*t92
              t187 = -8.266666666666665d-3*gammaaa*t109*t3*t89
              t188 = -3.1777066666666653d-7*t145*t183*t41*t6
              t189 = 5.125333333333332d-5*t108*t41*t87*t88
              t190 = -1.9219999999999998d-5*gammaaa*t42*t87*t91
              t191 = -8.266666666666665d-3*gammaaa*t108*t3*t89
              t192 = -3.1777066666666653d-7*t145*t183*t41*t5
              t193 = 5.125333333333332d-5*t107*t41*t87*t88
              t194 = -1.9219999999999998d-5*gammaaa*t42*t87*t90
              t195 = -8.266666666666665d-3*gammaaa*t107*t3*t89
              t196 = -3.1777066666666653d-7*t145*t183*t4*t41
              t197 = 3.1d-3*t1*t3*t90
              t198 = 3.1d-3*t1*t3*t91
              t199 = 3.1d-3*t1*t3*t92
              t200 = 1.25d-1*t22*t31
              t201 = 1.25d-1*t22*t50+1.25d-1*gammaaa*t116*t22
              t202 = -3.04966d-3*t100*t117*t55*t94
              t203 = 1.86008522312d-5*t1*t100*t104*t62*t94
              t204 = 2.2321022677440003d-4*t100*t115*t164*t41*t54
              t205 = 1.1160511338720001d-4*gammaaa*t100*t164*t42*t56*t57
              t206 = 5.580255669360001d-5*t1*t100*t164*t58*t59
              t207 = 4.066213333333334d-2*gammaaa*t104*t115*t56*taua
              t208 = 3.72017044624d-5*gammaaa*t100*t104*t42*t60
              t209 = -2.439728d-2*gammaaa*t100*t104*t42*t54
              t210 = 4.066213333333334d-2*t104*t42*t57*t58*taua
              t211 = 1.86008522312d-5*t1*t100*t104*t57*t61
              t212 = -6.09932d-3*t1*t100*t104*t56*t57
              t213 = 1.0165533333333335d-2*t42*t55*t61*taua
              t214 = -3.3333333333333337d+0*t42*t55*t56*taua
              t215 = -3.04966d-3*t1*t100*t55*t60
              t216 = 1.0d+0*t117*t86
              t217 = -3.04966d-3*t1*t106*t55
              t218 = 1.0d+0*(6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*
     1           (6.2d-3*gammaaa*t1*t3*(1.1916399999999999d-7*gammaaa*t1
     2           15*t145*t4-1.9219999999999998d-5*t4*t42*t87)-1.92199999
     3           99999998d-5*t42*t5*t87-3.8439999999999996d-5*gammaaa*t1
     4           07*t42*t87+1.1916399999999999d-7*gammaaa*t115*t145*t5+6
     5           .2d-3*t1*t107*t3)-1.9219999999999998d-5*t42*t6*t87-3.84
     6           39999999999996d-5*gammaaa*t108*t42*t87+1.19163999999999
     7           99d-7*gammaaa*t115*t145*t6+6.2d-3*t1*t108*t3)-1.9219999
     8           999999998d-5*t42*t7*t87-3.8439999999999996d-5*gammaaa*t
     9           109*t42*t87+1.1916399999999999d-7*gammaaa*t115*t145*t7+
     :           6.2d-3*t1*t109*t3)*t94
              t219 = 1/rhoa**1.0666666666666666d+1
              t220 = 1.0d+0*t53*(1.86008522312d-5*t104*t42*t57*t61-6.099
     1           32d-3*t42*t55*t60+3.72017044624d-5*gammaaa*t104*t115*t6
     2           0+5.580255669360001d-5*t164*t42*t58*t59-1.219864d-2*t10
     3           4*t42*t56*t57+1.1160511338720001d-4*gammaaa*t115*t164*t
     4           56*t57+2*t42*t54*t55+2.2321022677440003d-4*t164*t219*t4
     5           1*t54-4.879456d-2*gammaaa*t104*t115*t54)*t94
              t221 = -6.09932d-3*t1*t117*t55*t94
              t222 = 1.86008522312d-5*t104*t42*t62*t94
              t223 = -3.04966d-3*t100*t123*t55*t94
              t224 = 3.72017044624d-5*t100*t104*t36*t62*t94
              t225 = 4.4642045354880006d-4*t100*t120*t164*t41*t54
              t226 = 2.2321022677440003d-4*gammaaa*t100*t121*t164*t56*t5
     1           7
              t227 = 1.1160511338720001d-4*t100*t164*t36*t58*t59
              t228 = 8.132426666666668d-2*gammaaa*t104*t120*t56*taua
              t229 = 7.44034089248d-5*gammaaa*t100*t104*t121*t60
              t230 = -2.439728d-2*gammaaa*t100*t104*t121*t56
              t231 = 8.132426666666668d-2*t104*t121*t57*t58*taua
              t232 = 3.72017044624d-5*t100*t104*t36*t57*t61
              t233 = -2.439728d-2*t100*t104*t36*t57*t58
              t234 = 2.033106666666667d-2*t121*t55*t61*taua
              t235 = -1.3333333333333333d+1*t121*t55*t58*taua
              t236 = -6.09932d-3*t100*t36*t55*t61
              t237 = 1.0d+0*t123*t86
              t238 = -6.09932d-3*t106*t36*t55
              t239 = 1/rhoa**9.666666666666666d+0
              t240 = 1/rhoa**3.3333333333333337d+0
              t241 = 1.0d+0*t53*(3.72017044624d-5*t104*t121*t57*t61-6.09
     1           932d-3*t121*t55*t61-6.09932d-3*t121*t55*t60+7.440340892
     2           48d-5*gammaaa*t104*t120*t60+1.1160511338720001d-4*t121*
     3           t164*t58*t59-2.439728d-2*t104*t121*t57*t58+2.2321022677
     4           440003d-4*gammaaa*t120*t164*t56*t57-1.219864d-2*t104*t1
     5           21*t56*t57+2.0d+0*t121*t55*t56-2.439728d-2*gammaaa*t104
     6           *t120*t56+4.4642045354880006d-4*t164*t239*t41*t54-4.879
     7           456d-2*gammaaa*t104*t120*t54)*t94
              t242 = -6.09932d-3*t117*t36*t55*t94
              t243 = -3.04966d-3*t1*t123*t55*t94
              t244 = 3.72017044624d-5*t104*t121*t62*t94
              t245 = 1/taua**3
              t246 = 1/rhoa**8.666666666666666d+0
              t247 = 1/rhoa**6
              t248 = 1.0d+0*t53*(7.44034089248d-5*t104*t240*t57*t61-2.43
     1           9728d-2*t240*t55*t61+1.488068178496d-4*gammaaa*t104*t24
     2           7*t60+2.2321022677440003d-4*t164*t240*t58*t59-9.758912d
     3           -2*t104*t240*t57*t58+8.0d+0*t240*t55*t58+4.464204535488
     4           0006d-4*gammaaa*t164*t247*t56*t57-9.758912d-2*gammaaa*t
     5           104*t247*t56+8.928409070976001d-4*t164*t246*t41*t54)*t9
     6           4
              t249 = -1.219864d-2*t123*t36*t55*t94
              t250 = 7.44034089248d-5*t104*t240*t62*t94
              fnc(iq) = (1.0d+0*t24*t8+1.0d+0*t24*t53*t62+2.0d+0*rhoa*t2
     1           2*t35*t39*t50+1.0d+0*rhoa*t22*t31*t32*t34)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t32*(5.0d-1*rhoa*t22*t34*t99+5.0d-1*rhoa
     1           *t31*t34*t81+5.0d-1*t22*t31*t34)+1.0d+0*t93*t94-3.04966
     2           d-3*t100*t55*t62*t94+1.0d+0*t8*t86+t106*t53-5.15088d-3*
     3           rhoa*t100*t22*t35*t43*t50+1.25d-1*gammaaa*t22*t32*t33*t
     4           39*t50+t103*t39+1.25d-1*gammaaa*t22*t31*t32*t33)*wght+A
     5           mat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (-3.04966d-3*t1*t55*t62*t94+1.0d+0*t117*
     1           t53*t94+1.0d+0*t110*t94-5.15088d-3*t22*t35*t36*t43*t50-
     2           1.25d-1*t22*t32*t39*t50+1.0d+0*rhoa*t116*t22*t35*t39+t3
     3           2*(5.0d-1*rhoa*t114*t22*t34-1.25d-1*t22*t31))*wght+Cmat
     4           (iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (-6.09932d-3*t36*t55*t62*t94+1.0d+0*t123*
     1           t53*t94-1.030176d-2*t22*t35*t43*t50*t9+1.25d-1*gammaaa*
     2           t119*t22*t39*t50+1.0d+0*rhoa*t122*t22*t35*t39-5.0d-1*rh
     3           oa*t119*t22*t31*t34+1.0d+0*rhoa*t22*t31*t32)*wght+Mmat(
     4           iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t53*(1.0d+0*t94*(8.88888888888889d+0
     1           *t53*t61*t89*taua+1.7777777777777778d+1*t55*t57*t58*t89
     2           *taua+3.5555555555555557d+1*gammaaa*t55*t56*t88*taua-3.
     3           04966d-3*t162*t55*t57*t61-6.09932d-3*gammaaa*t1*t162*t5
     4           5*t60+9.777777777777779d+0*gammaaa*t150*t53*t60-6.09932
     5           d-3*t104*t162*t58*t59+9.777777777777779d+0*gammaaa*t150
     6           *t55*t56*t57-1.219864d-2*gammaaa*t1*t104*t162*t56*t57+5
     7           .333333333333333d+1*t148*t41*t54*t55-2.439728d-2*t104*t
     8           162*t41*t42*t54+t176+t175+t174+t173+t172+t171+t170+t169
     9           +t168+t167+t166+t165)+1.0d+0*t143*t62+t177)+t39*(1.0d+0
     :           *rhoa*t22*t35*(8.88888888888889d+0*t39*t49*t89*taua+1.7
     ;           777777777777778d+1*t43*t45*t46*t89*taua+2.6666666666666
     <           666d+1*gammaaa*t43*t44*t88*taua+3.4339200000000003d-2*t
     =           1*t100*t43*t49*taua+1.373568d-1*t1*t100*t101*t45*t46*ta
     >           ua+6.867840000000001d-2*gammaaa*t100*t101*t42*t44*taua+
     ?           2.747136d-2*gammaaa*t100*t43*t48*t89+5.494272d-2*gammaa
     @           a*t100*t101*t44*t45*t89+1.0988544d-1*t100*t101*t40*t41*
     1           t88-5.15088d-3*t162*t43*t45*t49+5.30631295488d-5*t101*t
     2           160*t45*t49-5.15088d-3*gammaaa*t1*t162*t43*t48+9.777777
     3           777777779d+0*gammaaa*t150*t39*t48+5.30631295488d-5*gamm
     4           aaa*t1*t101*t160*t48-1.030176d-2*t101*t162*t46*t47+1.59
     5           1893886464d-4*t160*t161*t46*t47+2.2222222222222224d+1*t
     6           118*t42*t43*t46+9.777777777777779d+0*gammaaa*t150*t43*t
     7           44*t45-1.030176d-2*gammaaa*t1*t101*t162*t44*t45+1.59189
     8           3886464d-4*gammaaa*t1*t160*t161*t44*t45+3.3777777777777
     9           78d+1*t148*t40*t41*t43-1.030176d-2*t101*t162*t40*t41*t4
     :           2+1.591893886464d-4*t160*t161*t40*t41*t42)+2.0d+0*t35*t
     ;           50*t81+1.25d-1*gammaaa*t32*t33*t50*t81+2.0d+0*rhoa*t102
     <           *t35*t81+1.0d+0*rhoa*t132*t35*t50+1.25d-1*gammaaa*t141*
     =           t22*t32*t50+2.0d+0*t102*t22*t35+1.25d-1*gammaaa*t102*t2
     >           2*t32*t33)+t32*(1.0d+0*rhoa*t34*t81*t99+1.0d+0*t22*t34*
     ?           t99+1.25d-1*gammaaa*t22*t33*t99+5.0d-1*rhoa*t22*t34*(1.
     @           9199999999999995d-2*t41*t88*t95*t98-3.1999999999999995d
     1           -1*gammaaa*t26*t89*t98+6.0d-2*gammaaa*t1*t26*(1.9199999
     2           999999995d-2*t41*t88*t95*t97-3.1999999999999995d-1*gamm
     3           aaa*t26*t89*t97+6.0d-2*gammaaa*t1*t26*(1.91999999999999
     4           95d-2*t41*t88*t95*t96-3.1999999999999995d-1*gammaaa*t26
     5           *t89*t96+6.0d-2*gammaaa*t1*t26*(-8.639999999999998d-2*t
     6           148*t27*t41*t95+5.866666666666666d-1*gammaaa*t150*t26*t
     7           27+3.0719999999999986d-3*t144*t146*t159*t27)-8.63999999
     8           9999998d-2*t148*t28*t41*t95+5.866666666666666d-1*gammaa
     9           a*t150*t26*t28+3.0719999999999986d-3*t144*t146*t159*t28
     :           )-8.639999999999998d-2*t148*t29*t41*t95+5.8666666666666
     ;           66d-1*gammaaa*t150*t26*t29+3.0719999999999986d-3*t144*t
     <           146*t159*t29)-8.639999999999998d-2*t148*t30*t41*t95+5.8
     =           66666666666666d-1*gammaaa*t150*t26*t30+3.07199999999999
     >           86d-3*t144*t146*t159*t30)+1.0d+0*t31*t34*t81+1.25d-1*ga
     ?           mmaaa*t31*t33*t81+5.0d-1*rhoa*t132*t31*t34+1.25d-1*gamm
     @           aaa*t141*t22*t31)+t32*t33*(1.25d-1*gammaaa*t22*t99+1.25
     1           d-1*gammaaa*t31*t81)+t55*(-3.04966d-3*t162*t62*t94+t180
     2           +t179+t178)+1.0d+0*(6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaa
     3           a*t1*t3*(6.2d-3*gammaaa*t1*t3*(-3.2460444444444436d-4*t
     4           148*t4*t41*t87+3.0311111111111105d-2*gammaaa*t150*t3*t4
     5           +t158)-3.2460444444444436d-4*t148*t41*t5*t87+3.03111111
     6           11111105d-2*gammaaa*t150*t3*t5+t157+t156+t155)-3.246044
     7           4444444436d-4*t148*t41*t6*t87+3.0311111111111105d-2*gam
     8           maaa*t150*t3*t6+t154+t153+t152)-3.2460444444444436d-4*t
     9           148*t41*t7*t87+3.0311111111111105d-2*gammaaa*t150*t3*t7
     :           +t151+t149+t147)*t94+t43*(-5.15088d-3*rhoa*t100*t35*t50
     ;           *t81-5.15088d-3*rhoa*t162*t22*t35*t50-5.15088d-3*t100*t
     <           22*t35*t50-5.15088d-3*rhoa*t100*t102*t22*t35-5.15088d-3
     =           *t100*t103)+t32*t33*t39*(1.25d-1*gammaaa*t50*t81+1.25d-
     >           1*gammaaa*t102*t22)+1.0d+0*t143*t8-1.28772d-3*gammaaa*t
     ?           100*t22*t32*t33*t43*t50-1.25d-1*gammaaa*t141*t22*t32*t3
     @           9*t50+5.30631295488d-5*rhoa*t101*t160*t22*t35*t50-1.25d
     1           -1*gammaaa*t141*t22*t31*t32+t163+t124)*wght+Amat2(iq,D2
     2           _RA_RA)
              Amat2(iq,D2_RA_RB) = (t53*(1.0d+0*t94*(1.7777777777777778d
     1           +1*gammaaa*t55*t56*t88*taua+1.4222222222222222d+1*t148*
     2           t41*t54*t55+t176+t175+t174+t173+t172+t171+t170+t169+t16
     3           8+t167+t166+t165)+1.0d+0*t181*t62+t177)+1.0d+0*(6.2d-3*
     4           gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*
     5           t3*(t158-1.366755555555555d-4*t148*t4*t41*t87)-1.366755
     6           555555555d-4*t148*t41*t5*t87+t157+t156+t155)-1.36675555
     7           5555555d-4*t148*t41*t6*t87+t154+t153+t152)-1.3667555555
     8           55555d-4*t148*t41*t7*t87+t151+t149+t147)*t94+1.0d+0*t18
     9           1*t8+(t180+t179+t178)*t55+t163+t124)*wght+Amat2(iq,D2_R
     :           A_RB)
              Cmat2(iq,D2_RA_GAA) = (t39*(1.0d+0*rhoa*t22*t35*(1.7169600
     1           000000002d-2*t42*t43*t49*taua+6.867840000000001d-2*t101
     2           *t42*t45*t46*taua-3.3333333333333337d+0*t42*t43*t44*tau
     3           a+3.4339200000000003d-2*gammaaa*t101*t115*t44*taua+1.37
     4           3568d-2*t43*t45*t49*t89-2.6666666666666666d+0*t39*t48*t
     5           89+2.747136d-2*t101*t46*t47*t89-2.6666666666666666d+0*t
     6           43*t44*t45*t89+2.747136d-2*gammaaa*t43*t48*t88+5.494272
     7           d-2*gammaaa*t101*t44*t45*t88-1.0666666666666666d+1*gamm
     8           aaa*t40*t43*t88+5.30631295488d-5*t1*t100*t101*t45*t49-5
     9           .15088d-3*t1*t100*t43*t48+5.30631295488d-5*gammaaa*t100
     :           *t101*t42*t48+1.591893886464d-4*t1*t100*t161*t46*t47+1.
     ;           591893886464d-4*gammaaa*t100*t161*t42*t44*t45-1.030176d
     <           -2*t1*t100*t101*t44*t45-2.060352d-2*gammaaa*t100*t101*t
     =           40*t42+8.241408d-2*t101*t183*t40*t41+1.591893886464d-4*
     >           t100*t115*t161*t40*t41)-1.25d-1*t32*t50*t81+1.0d+0*rhoa
     ?           *t116*t35*t81-1.25d-1*t22*t32*t33*t50+1.0d+0*t116*t22*t
     @           35-1.25d-1*t102*t22*t32)+t32*(-1.25d-1*t22*t99+5.0d-1*r
     1           hoa*t22*t34*(-3.6d-3*gammaaa*t42*t95*t98+6.0d-2*t1*t26*
     2           t98+6.0d-2*gammaaa*t1*t26*(-3.6d-3*gammaaa*t42*t95*t97+
     3           6.0d-2*t1*t26*t97+6.0d-2*gammaaa*t1*t26*(-3.6d-3*gammaa
     4           a*t42*t95*t96+6.0d-2*t1*t26*t96+6.0d-2*gammaaa*t1*t26*(
     5           2.879999999999999d-2*gammaaa*t27*t88*t95-1.599999999999
     6           9998d-1*t26*t27*t89-1.1519999999999996d-3*t159*t183*t27
     7           *t41)+9.599999999999997d-3*t111*t41*t88*t95+2.879999999
     8           999999d-2*gammaaa*t28*t88*t95-1.5999999999999998d-1*t26
     9           *t28*t89-1.5999999999999998d-1*gammaaa*t111*t26*t89-1.1
     :           519999999999996d-3*t159*t183*t28*t41)+9.599999999999997
     ;           d-3*t112*t41*t88*t95+2.879999999999999d-2*gammaaa*t29*t
     <           88*t95-1.5999999999999998d-1*t26*t29*t89-1.599999999999
     =           9998d-1*gammaaa*t112*t26*t89-1.1519999999999996d-3*t159
     >           *t183*t29*t41)+9.599999999999997d-3*t113*t41*t88*t95+2.
     ?           879999999999999d-2*gammaaa*t30*t88*t95-1.59999999999999
     @           98d-1*t26*t30*t89-1.5999999999999998d-1*gammaaa*t113*t2
     1           6*t89-1.1519999999999996d-3*t159*t183*t30*t41)+5.0d-1*r
     2           hoa*t114*t34*t81-1.25d-1*t31*t81+5.0d-1*t114*t22*t34-1.
     3           25d-1*t22*t31*t33)+t53*(1.0d+0*(8.132426666666667d-3*t5
     4           5*t57*t61*t89-2.6666666666666666d+0*t53*t60*t89+1.62648
     5           53333333332d-2*t104*t58*t59*t89-2.6666666666666666d+0*t
     6           55*t56*t57*t89+2.439728d-2*gammaaa*t55*t60*t88+4.879456
     7           d-2*gammaaa*t104*t56*t57*t88-16*gammaaa*t54*t55*t88+1.3
     8           011882666666666d-1*t104*t183*t41*t54+t215+t214+t213+t21
     9           2+t211+t210+t209+t208+t207+t206+t205+t204)*t94+t216)+1.
     :           0d+0*(6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*(6.2d-
     ;           3*gammaaa*t1*t3*(-8.266666666666665d-3*t3*t4*t89+1.0250
     <           666666666663d-4*gammaaa*t4*t87*t88+t196)-8.266666666666
     =           665d-3*t3*t5*t89+1.0250666666666663d-4*gammaaa*t5*t87*t
     >           88+t197+t195+t194+t193+t192)-8.266666666666665d-3*t3*t6
     ?           *t89+1.0250666666666663d-4*gammaaa*t6*t87*t88+t198+t191
     @           +t190+t189+t188)-8.266666666666665d-3*t3*t7*t89+1.02506
     1           66666666663d-4*gammaaa*t7*t87*t88+t199+t187+t186+t185+t
     2           184)*t94+8.132426666666667d-3*t55*t62*t89*t94-6.4386d-4
     3           *gammaaa*t22*t32*t43*t50*t89+t1*t43*(1.373568d-2*t22*t3
     4           5*t50-5.15088d-3*t103)+6.4386d-4*t100*t22*t32*t43*t50+5
     5           .30631295488d-5*t100*t101*t22*t35*t36*t50-5.15088d-3*rh
     6           oa*t100*t116*t22*t35*t43+t201*t32*t33*t39+(1.25d-1*gamm
     7           aaa*t114*t22+t200)*t32*t33+t217+t203+t202+t182)*wght+Cm
     8           at2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (t53*(1.0d+0*(8.132426666666667d-3*g
     1           ammaaa*t55*t60*t88+1.6264853333333332d-2*gammaaa*t104*t
     2           56*t57*t88-5.333333333333333d+0*gammaaa*t54*t55*t88+6.5
     3           05941333333333d-2*t104*t183*t41*t54+t215+t214+t213+t212
     4           +t211+t210+t209+t208+t207+t206+t205+t204)*t94+t216)+1.0
     5           d+0*(6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*(6.2d-3
     6           *gammaaa*t1*t3*(5.125333333333332d-5*gammaaa*t4*t87*t88
     7           +t196)+5.125333333333332d-5*gammaaa*t5*t87*t88+t197+t19
     8           5+t194+t193+t192)+5.125333333333332d-5*gammaaa*t6*t87*t
     9           88+t198+t191+t190+t189+t188)+5.125333333333332d-5*gamma
     :           aa*t7*t87*t88+t199+t187+t186+t185+t184)*t94+t217+t203+t
     ;           202+t182)*wght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t32*(5.0d-1*rhoa*t22*t34*(6.0d-2*g
     1           ammaaa*t1*t26*(6.0d-2*gammaaa*t1*t26*(6.0d-2*gammaaa*t1
     2           *t26*(4.32d-4*gammaaa*t115*t159*t27-7.2d-3*t27*t42*t95)
     3           -7.2d-3*t28*t42*t95-7.2d-3*gammaaa*t111*t42*t95+4.32d-4
     4           *gammaaa*t115*t159*t28+1.2d-1*t1*t111*t26)-7.2d-3*t29*t
     5           42*t95-7.2d-3*gammaaa*t112*t42*t95+4.32d-4*gammaaa*t115
     6           *t159*t29+1.2d-1*t1*t112*t26)-7.2d-3*t30*t42*t95-7.2d-3
     7           *gammaaa*t113*t42*t95+4.32d-4*gammaaa*t115*t159*t30+1.2
     8           d-1*t1*t113*t26)-2.5d-1*t114*t22)+1.28772d-3*t1*t22*t32
     9           *t43*t50+5.30631295488d-5*t101*t121*t22*t35*t50+1.0d+0*
     :           rhoa*t22*t35*t39*(5.30631295488d-5*t101*t42*t45*t49-1.0
     ;           30176d-2*t42*t43*t48+5.30631295488d-5*gammaaa*t101*t115
     <           *t48+1.591893886464d-4*t161*t42*t46*t47-2.060352d-2*t10
     =           1*t42*t44*t45+1.591893886464d-4*gammaaa*t115*t161*t44*t
     >           45+2*t40*t42*t43+1.591893886464d-4*t161*t219*t40*t41-4.
     ?           120704d-2*gammaaa*t101*t115*t40)-1.030176d-2*t116*t22*t
     @           35*t36*t43-2.5d-1*t116*t22*t32*t39+t222+t221+t220+t218)
     1           *wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = (t222+t221+t220+t218)*wght+Cmat2(iq
     1           ,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = (t39*(1.0d+0*rhoa*t22*t35*(3.43392000
     1           00000003d-2*t121*t43*t49*taua+1.373568d-1*t101*t121*t45
     2           *t46*taua-1.3333333333333333d+1*t121*t43*t46*taua+6.867
     3           840000000001d-2*gammaaa*t101*t120*t44*taua+1.7169600000
     4           000002d-2*t1*t43*t45*t49+1.061262590976d-4*t100*t101*t3
     5           6*t45*t49-1.030176d-2*t100*t36*t43*t49-3.33333333333333
     6           37d+0*t1*t39*t49+4.464096d-2*gammaaa*t42*t43*t48+1.0612
     7           62590976d-4*gammaaa*t100*t101*t121*t48+3.183787772928d-
     8           4*t100*t161*t36*t46*t47+3.4339200000000003d-2*t1*t101*t
     9           46*t47-6.666666666666667d+0*t1*t43*t45*t46-4.120704d-2*
     :           t100*t101*t36*t45*t46+8.928192d-2*gammaaa*t101*t42*t44*
     ;           t45+3.183787772928d-4*gammaaa*t100*t121*t161*t44*t45-8.
     <           666666666666666d+0*gammaaa*t42*t43*t44-2.060352d-2*gamm
     =           aaa*t100*t101*t121*t44+3.183787772928d-4*t100*t120*t161
     >           *t40*t41+1.4422464000000002d-1*t101*t115*t40*t41)+1.25d
     ?           -1*gammaaa*t119*t50*t81+1.0d+0*rhoa*t122*t35*t81+1.25d-
     @           1*gammaaa*t119*t22*t33*t50+1.0d+0*t122*t22*t35+1.25d-1*
     1           gammaaa*t102*t119*t22)+t119*(-5.0d-1*rhoa*t22*t34*t99-5
     2           .0d-1*rhoa*t31*t34*t81-5.0d-1*t22*t31*t34)+t32*(1.0d+0*
     3           rhoa*t22*t99+1.0d+0*rhoa*t31*t81+1.0d+0*t22*t31)+t53*(1
     4           .0d+0*(1.0165533333333335d-2*t1*t55*t57*t61-3.333333333
     5           3333337d+0*t1*t53*t61+3.6595920000000004d-2*gammaaa*t42
     6           *t55*t60+2.033106666666667d-2*t1*t104*t58*t59-6.6666666
     7           66666667d+0*t1*t55*t57*t58+7.319184000000001d-2*gammaaa
     8           *t104*t42*t56*t57-1.2d+1*gammaaa*t42*t55*t56+2.11443093
     9           33333333d-1*t104*t115*t41*t54+t236+t235+t234+t233+t232+
     :           t231+t230+t229+t228+t227+t226+t225)*t94+t237)+1.0165533
     ;           333333335d-2*t1*t55*t62*t94+1.061262590976d-4*t100*t101
     <           *t22*t35*t50*t9+t36*t43*(1.7169600000000002d-2*t22*t35*
     =           t50-1.030176d-2*t103)-1.28772d-3*gammaaa*t1*t22*t32*t43
     >           *t50-6.4386d-4*gammaaa*t100*t119*t22*t43*t50-1.25d-1*ga
     ?           mmaaa*t119*t22*t33*t39*t50-5.15088d-3*rhoa*t100*t122*t2
     @           2*t35*t43+1.25d-1*gammaaa*t122*t22*t32*t33*t39-1.25d-1*
     1           gammaaa*t119*t22*t31*t33+t238+t224+t223)*wght+Mmat2(iq,
     2           D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = (t53*(1.0d+0*(1.6264853333333332d-2*g
     1           ammaaa*t42*t55*t60+3.2529706666666663d-2*gammaaa*t104*t
     2           42*t56*t57-5.333333333333333d+0*gammaaa*t42*t55*t56+1.3
     3           011882666666666d-1*t104*t115*t41*t54+t236+t235+t234+t23
     4           3+t232+t231+t230+t229+t228+t227+t226+t225)*t94+t237)+t2
     5           38+t224+t223)*wght+Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = (-1.030176d-2*t116*t22*t35*t43*t9+1.
     1           28772d-3*t22*t32*t36*t43*t50-6.4386d-4*gammaaa*t1*t119*
     2           t22*t43*t50+1.061262590976d-4*t101*t22*t240*t35*t50+1.0
     3           d+0*rhoa*t22*t35*t39*(1.061262590976d-4*t101*t121*t45*t
     4           49-1.030176d-2*t121*t43*t49-1.030176d-2*t121*t43*t48+1.
     5           061262590976d-4*gammaaa*t101*t120*t48+3.183787772928d-4
     6           *t121*t161*t46*t47-4.120704d-2*t101*t121*t45*t46+3.1837
     7           87772928d-4*gammaaa*t120*t161*t44*t45-2.060352d-2*t101*
     8           t121*t44*t45+2.0d+0*t121*t43*t44-2.060352d-2*gammaaa*t1
     9           01*t120*t44+3.183787772928d-4*t161*t239*t40*t41-4.12070
     :           4d-2*gammaaa*t101*t120*t40)-5.15088d-3*t122*t22*t35*t36
     ;           *t43-1.25d-1*t122*t22*t32*t39+t119*t201*t39+t119*(t200-
     <           5.0d-1*rhoa*t114*t22*t34)+1.0d+0*rhoa*t114*t22*t32+t244
     =           +t243+t242+t241)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = (t244+t243+t242+t241)*wght+Mmat2(iq,
     1           D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = (-2.060352d-2*t122*t22*t35*t43*t9-2.5
     1           7544d-3*gammaaa*t119*t22*t36*t43*t50-2.5d-1*gammaaa*t22
     2           *t245*t39*t50+2.122525181952d-4*t101*t129*t22*t35*t50+1
     3           .0d+0*rhoa*t22*t35*t39*(2.122525181952d-4*t101*t240*t45
     4           *t49-4.120704d-2*t240*t43*t49+2.122525181952d-4*gammaaa
     5           *t101*t247*t48+6.367575545856d-4*t161*t240*t46*t47-1.64
     6           82816d-1*t101*t240*t45*t46+8.0d+0*t240*t43*t46+6.367575
     7           545856d-4*gammaaa*t161*t247*t44*t45-8.241408d-2*gammaaa
     8           *t101*t247*t44+6.367575545856d-4*t161*t246*t40*t41)+2.5
     9           d-1*gammaaa*t119*t122*t22*t39+1.0d+0*rhoa*t22*t245*t31*
     :           t34-2.0d+0*rhoa*t119*t22*t31+t250+t249+t248)*wght+Mmat2
     ;           (iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = (t250+t249+t248)*wght+Mmat2(iq,D2_TA_
     1           TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = 1/rhoa**3.3333333333333337d+0
              t10 = param(9)
              t11 = param(8)
              t12 = param(11)
              t13 = 1.6d-99*t5*t8*t9+t4*t5*t7+4.0d-50*t1*t12*t5*t6+t10*t
     1           3*t6+4.0d-50*t1*t11*t3+param(7)
              t14 = 1/rhoa**6.666666666666666d-1
              t15 = rhoa**5.0d-1
              t16 = 1/t15
              t17 = 1/rhoa**3.333333333333333d-1
              t18 = 1/rhoa**1.6666666666666666d-1
              t19 = 1.1120374863094686d+1*t18+3.8447462374472113d+0*t17+
     1           1.644733775567609d+0*t16+2.4058712912881916d-1*t14
              t20 = 3.216395899738507d+1/t19+1.0d+0
              t21 = log(t20)
              t22 = 1.274696188700087d-1*t17+1.0d+0
              t23 = 5.982550435771079d+0*t18+2.2255694211506874d+0*t17+8
     1           .004286349993635d-1*t16+1.8970043257475583d-1*t14
              t24 = 1.6081979498692536d+1/t23+1.0d+0
              t25 = log(t24)
              t26 = 1.3256889990520176d-1*t17+1.0d+0
              t27 = -6.903522198342671d-18*t25*t26-3.1090699999999993d-2
     1           *t21*t22
              t28 = 2.4d-51*t1+1.0d+0
              t29 = 1/t28
              t30 = param(22)
              t31 = 2.4d-51*t1*t29*t30+param(21)
              t32 = 2.4d-51*t1*t29*t31+param(20)
              t33 = 2.4d-51*t1*t29*t32+param(19)
              t34 = 2.4d-51*t1*t29*t33+param(18)
              t35 = 3.04966d-3*(1.2d-49*t1-1.823119944d+1)+1.0d+0
              t36 = 1/t35
              t37 = param(6)
              t38 = 1/t35**2
              t39 = 4.0d-50*t1-1.823119944d+1
              t40 = t39**2
              t41 = param(4)
              t42 = param(3)
              t43 = param(2)
              t44 = param(5)
              t45 = 6.4d-99*t38*t41*t9+8.0d-50*t1*t38*t39*t44+8.0d-50*t1
     1           *t36*t43+t36*t39*t42+t37*t38*t40+param(1)
              t46 = -2*rhoa*t27
              t47 = t46-1.243628d-1*rhoa*(1.0522000558389212d-1*t17+1.0d
     1           +0)*log(1.6081979498692536d+1/(5.329846514438383d+0*t18
     2           +1.766435620181429d+0*t17+5.659885156639418d-1*t16+1.19
     3           503784087549d-1*t14)+1.0d+0)
              t48 = 2.4799999999999997d-52*t1+1.0d+0
              t49 = 1/t48
              t50 = param(17)
              t51 = 2.4799999999999997d-52*t1*t49*t50+param(16)
              t52 = 2.4799999999999997d-52*t1*t49*t51+param(15)
              t53 = 2.4799999999999997d-52*t1*t49*t52+param(14)
              t54 = 2.4799999999999997d-52*t1*t49*t53+param(13)
              t55 = 1/t24
              t56 = 1/t15**3
              t57 = 1/rhoa**1.3333333333333333d+0
              t58 = 1/rhoa**1.1666666666666667d+0
              t59 = -9.970917392951799d-1*t58-7.418564737168958d-1*t57-4
     1           .002143174996817d-1*t56-1.264669550498372d-1*t1
              t60 = 1/t23**2
              t61 = 1/t20
              t62 = -1.8533958105157808d+0*t58-1.2815820791490704d+0*t57
     1           -8.223668877838045d-1*t56-1.6039141941921276d-1*t1
              t63 = 1/t19**2
              t64 = 1.0d+0*t22*t61*t62*t63+1.1102230246251565d-16*t26*t5
     1           5*t59*t60+3.0506411443514264d-19*t25*t57+1.321039893133
     2           9265d-3*t21*t57
              t65 = 1/t28**2
              t66 = 1/rhoa**4.333333333333333d+0
              t67 = 1/rhoa**2.6666666666666666d+0
              t68 = 9.6d-102*t30*t65*t66-4.0d-51*t29*t30*t67
              t69 = 2.4d-51*t1*t29*t68-4.0d-51*t29*t31*t67+9.6d-102*t31*
     1           t65*t66
              t70 = 2.4d-51*t1*t29*t69-4.0d-51*t29*t32*t67+9.6d-102*t32*
     1           t65*t66
              t71 = 2.4d-51*t1*t29*t70-4.0d-51*t29*t33*t67+9.6d-102*t33*
     1           t65*t66
              t72 = 6.299605249474366d-1
              t73 = 1.414213562373095d+0
              t74 = 1/t73
              t75 = 7.937005259840998d-1
              t76 = 8.908987181403393d-1
              t77 = 5.982550435771079d+0*t18*t76+2.2255694211506874d+0*t
     1           17*t75+8.004286349993635d-1*t16*t74+1.8970043257475583d
     2           -1*t14*t72
              t78 = 1.6081979498692536d+1/t77+1.0d+0
              t79 = log(t78)
              t80 = 1.3256889990520176d-1*t17*t75+1.0d+0
              t81 = 1/t78
              t82 = 3.968502629920499d-1
              t83 = -7.418564737168958d-1*t57*t82-4.002143174996817d-1*t
     1           56/t73**3-4.4415387620319857d-1*t58-3.9834594695849657d
     2           -2*t1
              t84 = 1/t77**2
              t85 = 2*rhoa*(1.0d+0*t80*t81*t83*t84+2.747773264188437d-3*
     1           t57*t79*t82)-6.21814d-2*t79*t80-rhoa*t64+6.903522198342
     2           671d-18*t25*t26+3.1090699999999993d-2*t21*t22
              t86 = 1/t2**3
              t87 = 1/rhoa**6
              t88 = 1.6482816d-150*t8*t86*t87+1.030176d-51*t4*t67*t7*t86
     1           +4.1207039999999995d-101*t12*t6*t66*t86-5.3333333333333
     2           34d-99*t5*t66*t8-6.666666666666666d-50*t4*t5*t6*t67-6.6
     3           66666666666666d-50*t12*t5*t6*t67+5.15088d-52*t10*t5*t6*
     4           t67-6.666666666666666d-50*t11*t3*t67-3.333333333333333d
     5           -50*t10*t3*t67-1.3333333333333333d-99*t12*t5*t66+2.0603
     6           519999999997d-101*t11*t5*t66
              t89 = 5.0d-1*rhoa*t27*t88+5.0d-1*rhoa*t13*t64+5.0d-1*t13*t
     1           27
              t90 = t46-1.243628d-1*rhoa*t79*t80
              t91 = 1/t48**2
              t92 = 5.125333333333333d-104*t50*t66*t91-2.066666666666666
     1           7d-52*t49*t50*t67
              t93 = 2.4799999999999997d-52*t1*t49*t92+5.125333333333333d
     1           -104*t51*t66*t91-2.0666666666666667d-52*t49*t51*t67
              t94 = 2.4799999999999997d-52*t1*t49*t93+5.125333333333333d
     1           -104*t52*t66*t91-2.0666666666666667d-52*t49*t52*t67
              t95 = 2.4799999999999997d-52*t1*t49*t94+5.125333333333333d
     1           -104*t53*t66*t91-2.0666666666666667d-52*t49*t53*t67
              t96 = 1/t35**3
              t97 = 3.9035648d-150*t41*t87*t96+6.09932d-52*t37*t40*t67*t
     1           96+4.8794560000000003d-101*t39*t44*t66*t96-6.6666666666
     2           66666d-50*t38*t39*t44*t67-6.666666666666666d-50*t36*t43
     3           *t67+3.04966d-52*t38*t39*t42*t67-3.333333333333333d-50*
     4           t36*t42*t67-6.666666666666666d-50*t37*t38*t39*t67-2.666
     5           6666666666666d-99*t38*t44*t66+2.4397280000000002d-101*t
     6           38*t43*t66-1.0666666666666666d-98*t38*t41*t66
              t98 = 1.0d+0*t90*t97+1.0d+0*t45*t85
              t99 = t59**2
              t100 = 1/t15**5
              t101 = 1/rhoa**2.3333333333333334d+0
              t102 = 1/rhoa**2.1666666666666665d+0
              t103 = t62**2
              t104 = -2.220446049250313d-16*t26*t55*t99/t23**3+1.7854583
     1           920998188d-15*t26*t99/(t23**4*t24**2)+1.0d+0*t22*t61*t6
     2           3*(2.673190323653546d-1*t67+2.1622951122684114d+0*t102+
     3           1.7087761055320938d+0*t101+1.2335503316757068d+0*t100)+
     4           1.1102230246251565d-16*t26*t55*t60*(2.1077825841639536d
     5           -1*t67+1.1632736958443765d+0*t102+9.89141964955861d-1*t
     6           101+6.003214762495226d-1*t100)-8.497974591333913d-2*t57
     7           *t61*t62*t63-2.0d+0*t103*t22*t61/t19**3-9.8120696682655
     8           15d-18*t55*t57*t59*t60-4.0675215258019015d-19*t101*t25+
     9           3.216395899738507d+1*t103*t22/(t19**4*t20**2)-1.7613865
     :           241785684d-3*t101*t21
              t105 = 1/t28**3
              t106 = 1/rhoa**7
              t107 = 1/rhoa**5.333333333333333d+0
              t108 = 1/rhoa**3.6666666666666664d+0
              t109 = 2.0d+0*t85*t95
              t110 = 2.0d+0*t80*t81*t83*t84
              t111 = 5.495546528376875d-3*t57*t79*t82
              t112 = t83**2
              t113 = 1.6081979498692536d+1*t112*t80/(t77**4*t78**2)
              t114 = -2.0d+0*t112*t80*t81/t77**3
              t115 = 1.9842513149602492d-1
              t116 = 1.0d+0*(6.003214762495226d-1*t100/t73**5+3.31954955
     1           7987472d-2*t67+9.89141964955861d-1*t101*t115+2.59089761
     2           11853255d-1*t102)*t80*t81*t84
              t117 = -3.663697685584583d-3*t101*t115*t79
              t118 = log(2.9608813203268075d+1/(8.157414703487641d+0*t18
     1           *t76+2.247591863577616d+0*t17*t75+4.3009724712766434d-1
     2           *t16*t74+1.9115125951273373d-1*t14*t72)+1.0d+0)
              t119 = 6.901399211255825d-2*t17*t75+1.0d+0
              t120 = 1/rhoa**2
              t121 = -8.837926660346784d-2*t57*t81*t82*t83*t84
              t122 = -2.0d+0*t22*t61*t62*t63-2.220446049250313d-16*t26*t
     1           55*t59*t60-6.101282288702853d-19*t25*t57-2.642079786267
     2           853d-3*t21*t57+2*rhoa*(t121+8.443431970194815d-3*t118*t
     3           119*t120+t117+t116+t114+t113)+t111+t110-rhoa*t104
              t123 = 1/t2**4
              t124 = 1/rhoa**8.666666666666666d+0
              t125 = 1.86008522312d-103*t107*t45*t90*t96
              t126 = 1/t48**3
              t127 = 2.118471111111111d-155*t106*t126*t53
              t128 = 1.0250666666666666d-103*t66*t91*t94
              t129 = -4.1333333333333333d-52*t49*t67*t94
              t130 = 2.118471111111111d-155*t106*t126*t52
              t131 = 1.0250666666666666d-103*t66*t91*t93
              t132 = -4.1333333333333333d-52*t49*t67*t93
              t133 = 2.118471111111111d-155*t106*t126*t51
              t134 = 1.0250666666666666d-103*t66*t91*t92
              t135 = -4.1333333333333333d-52*t49*t67*t92
              t136 = 2.118471111111111d-155*t106*t126*t50
              t137 = 2.0d+0*t85*t97
              t138 = 1/t35**4
              t139 = 3.5713636283903993d-201*t124*t138*t41
              t140 = 1.488068178496d-152*t106*t43*t96
              t141 = -3.252970666666667d-150*t106*t44*t96
              t142 = 4.4642045354879994d-152*t106*t138*t39*t44
              t143 = -2.0331066666666667d-101*t107*t38*t42
              t144 = 2.222222222222222d-99*t107*t37*t38
              t145 = 5.580255669359999d-103*t107*t138*t37*t40
              t146 = 1.86008522312d-103*t107*t39*t42*t96
              t147 = -8.132426666666667d-101*t107*t37*t39*t96
              t148 = 3.04966d-52*t45*t85
              t149 = 3.04966d-52*t90*t97
              t150 = 2*rhoa*(t121-8.443431970194815d-3*t118*t119*t120+t1
     1           17+t116+t114+t113)+t111+t110
              fnc(iq) = (1.0d+0*t47*t54+1.0d+0*t36*t45*t47+1.0d+0*rhoa*t
     1           27*t34+1.0d+0*rhoa*t13*t27*t3)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t36*t98+1.0d+0*t90*t95+3.04966d-52*t38*t
     1           45*t67*t90+t3*t89+1.0d+0*t54*t85+5.0d-1*rhoa*t27*t71+5.
     2           0d-1*rhoa*t34*t64+2.57544d-52*t1*t13*t27*t5+5.0d-1*t27*
     3           t34)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t38*t67*(3.04966d-52*t98+t149+t148)+
     1           t36*(1.0d+0*t90*(-2.1144309333333333d-100*t107*t39*t44*
     2           t96-2.3421388800000004d-149*t106*t41*t96-1.626485333333
     3           3332d-51*t108*t37*t40*t96+1.7777777777777776d-49*t108*t
     4           38*t39*t44+1.1555555555555555d-98*t107*t38*t44-1.057215
     5           4666666667d-100*t107*t38*t43+1.7777777777777776d-49*t10
     6           8*t36*t43-8.132426666666666d-52*t108*t38*t39*t42+8.8888
     7           88888888888d-50*t108*t36*t42+3.733333333333333d-98*t107
     8           *t38*t41+1.7777777777777776d-49*t108*t37*t38*t39+t147+t
     9           146+t145+t144+t143+t142+t141+t140+t139)+1.0d+0*t122*t45
     :           +t137)+1.0d+0*t90*(2.4799999999999997d-52*t1*t49*(2.479
     ;           9999999999997d-52*t1*t49*(2.4799999999999997d-52*t1*t49
     <           *(-2.2209777777777773d-103*t107*t50*t91+5.5111111111111
     =           1d-52*t108*t49*t50+t136)-2.2209777777777773d-103*t107*t
     >           51*t91+5.51111111111111d-52*t108*t49*t51+t135+t134+t133
     ?           )-2.2209777777777773d-103*t107*t52*t91+5.51111111111111
     @           d-52*t108*t49*t52+t132+t131+t130)-2.2209777777777773d-1
     1           03*t107*t53*t91+5.51111111111111d-52*t108*t49*t53+t129+
     2           t128+t127)-8.132426666666666d-52*t108*t38*t45*t90+t5*t6
     3           7*(5.15088d-52*t89-4.2923999999999995d-52*t13*t27)+t3*(
     4           1.0d+0*rhoa*t64*t88+1.0d+0*t27*t88+5.0d-1*rhoa*t27*(-1.
     5           53839616d-149*t106*t8*t86-2.747136d-51*t108*t4*t7*t86-1
     6           .373568d-100*t107*t4*t6*t86-2.4724223999999997d-100*t10
     7           7*t12*t6*t86+5.306312954879999d-103*t10*t107*t6*t86-2.7
     8           471359999999995d-150*t106*t12*t86+2.1225251819519997d-1
     9           52*t106*t11*t86+2.3111111111111113d-98*t107*t5*t8+2.547
     :           0302183424d-201*t123*t124*t8+1.5918938864639998d-102*t1
     ;           07*t123*t4*t7+1.7777777777777776d-49*t108*t4*t5*t6+1.77
     <           77777777777776d-49*t108*t12*t5*t6-1.373568d-51*t10*t108
     =           *t5*t6+6.367575545855999d-152*t106*t12*t123*t6+2.222222
     >           222222222d-99*t107*t4*t5+8.0d-99*t107*t12*t5-1.23621119
     ?           99999999d-100*t107*t11*t5-3.43392d-101*t10*t107*t5+1.77
     @           77777777777776d-49*t108*t11*t3+8.888888888888888d-50*t1
     1           0*t108*t3)+1.0d+0*t13*t64+5.0d-1*rhoa*t104*t13)+t1*t5*(
     2           2.57544d-52*t27*t88+2.57544d-52*t13*t64)+2.653156477439
     3           9996d-103*t13*t27*t66*t86+1.0d+0*rhoa*t64*t71+1.0d+0*t2
     4           7*t71+5.0d-1*rhoa*t27*(-8.0d-51*t29*t67*t70+1.92d-101*t
     5           65*t66*t70+2.4d-51*t1*t29*(-8.0d-51*t29*t67*t69+1.92d-1
     6           01*t65*t66*t69+2.4d-51*t1*t29*(-8.0d-51*t29*t67*t68+1.9
     7           2d-101*t65*t66*t68+2.4d-51*t1*t29*(-5.76d-101*t107*t30*
     8           t65+1.0666666666666666d-50*t108*t29*t30+7.68d-152*t105*
     9           t106*t30)-5.76d-101*t107*t31*t65+1.0666666666666666d-50
     :           *t108*t29*t31+7.68d-152*t105*t106*t31)-5.76d-101*t107*t
     ;           32*t65+1.0666666666666666d-50*t108*t29*t32+7.68d-152*t1
     <           05*t106*t32)-5.76d-101*t107*t33*t65+1.0666666666666666d
     =           -50*t108*t29*t33+7.68d-152*t105*t106*t33)+1.0d+0*t34*t6
     >           4+1.0d+0*t122*t54+5.0d-1*rhoa*t104*t34+t125+t109)*wght+
     ?           Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (3.04966d-52*t38*t67*t98+t36*(1.0d+0*
     1           t90*(-8.132426666666667d-101*t107*t39*t44*t96-1.3011882
     2           666666666d-149*t106*t41*t96+4.444444444444444d-99*t107*
     3           t38*t44-4.0662133333333333d-101*t107*t38*t43+8.88888888
     4           8888888d-99*t107*t38*t41+t147+t146+t145+t144+t143+t142+
     5           t141+t140+t139)+1.0d+0*t150*t45+t137)+1.0d+0*t90*(2.479
     6           9999999999997d-52*t1*t49*(2.4799999999999997d-52*t1*t49
     7           *(2.4799999999999997d-52*t1*t49*(t136-8.542222222222222
     8           d-104*t107*t50*t91)-8.542222222222222d-104*t107*t51*t91
     9           +t135+t134+t133)-8.542222222222222d-104*t107*t52*t91+t1
     :           32+t131+t130)-8.542222222222222d-104*t107*t53*t91+t129+
     ;           t128+t127)+(t149+t148)*t38*t67+1.0d+0*t150*t54+t125+t10
     <           9)*wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = param(17)
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = gammaaa*t2
              t4 = 1/rhob**2.6666666666666666d+0
              t5 = gammabb*t4
              t6 = t5+t3
              t7 = 3.1d-3*t6+1.0d+0
              t8 = 1/t7
              t9 = 3.1d-3*t1*t6*t8+param(16)
              t10 = 3.1d-3*t6*t8*t9+param(15)
              t11 = 3.1d-3*t10*t6*t8+param(14)
              t12 = 3.1d-3*t11*t6*t8+param(13)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/rhob**6.666666666666666d-1
              t28 = rhob**5.0d-1
              t29 = 1/t28
              t30 = 1/rhob**3.333333333333333d-1
              t31 = 1/rhob**1.6666666666666666d-1
              t32 = 1.1120374863094686d+1*t31+3.8447462374472113d+0*t30+
     1           1.644733775567609d+0*t29+2.4058712912881916d-1*t27
              t33 = 3.216395899738507d+1/t32+1.0d+0
              t34 = log(t33)
              t35 = 1.274696188700087d-1*t30+1.0d+0
              t36 = 5.982550435771079d+0*t31+2.2255694211506874d+0*t30+8
     1           .004286349993635d-1*t29+1.8970043257475583d-1*t27
              t37 = 1.6081979498692536d+1/t36+1.0d+0
              t38 = log(t37)
              t39 = 1.3256889990520176d-1*t30+1.0d+0
              t40 = -6.903522198342671d-18*t38*t39-3.1090699999999993d-2
     1           *t34*t35
              t41 = rhob+rhoa
              t42 = 1/t41**3.333333333333333d-1
              t43 = 1.3256889990520176d-1*t42+1.0d+0
              t44 = rhoa-rhob
              t45 = t44**4
              t46 = 1/t41**4
              t47 = 1/t41
              t48 = 1.0d+0-t44*t47
              t49 = t44*t47+1.0d+0
              t50 = t49**1.3333333333333333d+0+t48**1.3333333333333333d+
     1           0-2.0d+0
              t51 = -1.923661050931536d+0*t45*t46*t50
              t52 = t51+1.0d+0
              t53 = 1/t41**6.666666666666666d-1
              t54 = t41**5.0d-1
              t55 = 1/t54
              t56 = 1/t41**1.6666666666666666d-1
              t57 = 5.982550435771079d+0*t56+8.004286349993635d-1*t55+1.
     1           8970043257475583d-1*t53+2.2255694211506874d+0*t42
              t58 = 1.6081979498692536d+1/t57+1.0d+0
              t59 = log(t58)
              t60 = -6.21814d-2*t43*t52*t59
              t61 = 6.901399211255825d-2*t42+1.0d+0
              t62 = t51+1.923661050931536d+0*t50
              t63 = 8.157414703487641d+0*t56+4.3009724712766434d-1*t55+1
     1           .9115125951273373d-1*t53+2.247591863577616d+0*t42
              t64 = 2.9608813203268075d+1/t63+1.0d+0
              t65 = log(t64)
              t66 = 1.9751631321680768d-2*t61*t62*t65
              t67 = 1.274696188700087d-1*t42+1.0d+0
              t68 = 1.1120374863094686d+1*t56+1.644733775567609d+0*t55+2
     1           .4058712912881916d-1*t53+3.8447462374472113d+0*t42
              t69 = 3.216395899738507d+1/t68+1.0d+0
              t70 = log(t69)
              t71 = -5.980796863619711d-2*t45*t46*t50*t67*t70
              t72 = t41*(t71+t66+t60)-rhob*t40-rhoa*t26
              t73 = param(18)
              t74 = 6.0d-2*gammaaa*t2+1.0d+0
              t75 = 1/t74
              t76 = param(19)
              t77 = param(20)
              t78 = param(21)
              t79 = param(22)
              t80 = 6.0d-2*gammaaa*t2*t75*t79+t78
              t81 = 6.0d-2*gammaaa*t2*t75*t80+t77
              t82 = 6.0d-2*gammaaa*t2*t75*t81+t76
              t83 = 6.0d-2*gammaaa*t2*t75*t82+t73
              t84 = 1/taua
              t85 = 1/rhoa
              t86 = 2.0d+0*taua-2.5d-1*gammaaa*t85
              t87 = 1.0d+0-1.25d-1*gammaaa*t84*t85
              t88 = 1/rhoa**1.6666666666666669d+0
              t89 = 2.0d+0*t88*taua
              t90 = 5.15088d-3*(t89+t3-9.11559972d+0)+1.0d+0
              t91 = 1/t90
              t92 = param(7)
              t93 = param(10)
              t94 = gammaaa**2
              t95 = 1/rhoa**5.333333333333333d+0
              t96 = 1/t90**2
              t97 = param(11)
              t98 = t89-9.11559972d+0
              t99 = param(12)
              t100 = t98**2
              t101 = param(8)
              t102 = param(9)
              t103 = t100*t96*t99+gammaaa*t2*t96*t97*t98+t102*t91*t98+t9
     1           3*t94*t95*t96+t92+gammaaa*t101*t2*t91
              t104 = 6.0d-2*gammabb*t4+1.0d+0
              t105 = 1/t104
              t106 = 6.0d-2*gammabb*t105*t4*t79+t78
              t107 = t77+6.0d-2*gammabb*t105*t106*t4
              t108 = t76+6.0d-2*gammabb*t105*t107*t4
              t109 = t73+6.0d-2*gammabb*t105*t108*t4
              t110 = 1/taub
              t111 = 1/rhob
              t112 = 2.0d+0*taub-2.5d-1*gammabb*t111
              t113 = 1.0d+0-1.25d-1*gammabb*t110*t111
              t114 = 1/rhob**1.6666666666666669d+0
              t115 = 2.0d+0*t114*taub
              t116 = 5.15088d-3*(t5+t115-9.11559972d+0)+1.0d+0
              t117 = 1/t116
              t118 = gammabb**2
              t119 = 1/rhob**5.333333333333333d+0
              t120 = 1/t116**2
              t121 = t115-9.11559972d+0
              t122 = t121**2
              t123 = t120*t122*t99+gammabb*t120*t121*t4*t97+t118*t119*t1
     1           20*t93+t92+gammabb*t101*t117*t4+t102*t117*t121
              t124 = 3.04966d-3*(t89+t5+t3+t115-1.823119944d+1)+1.0d+0
              t125 = 1/t124
              t126 = param(4)
              t127 = t6**2
              t128 = 1/t124**2
              t129 = param(5)
              t130 = t89+t115-1.823119944d+1
              t131 = param(6)
              t132 = t130**2
              t133 = param(2)
              t134 = param(3)
              t135 = t125*t133*t6+t128*t129*t130*t6+t125*t130*t134+t128*
     1           t131*t132+t126*t127*t128+param(1)
              t136 = 1/t23
              t137 = 1/t14**3
              t138 = 1/rhoa**1.3333333333333333d+0
              t139 = 1/rhoa**1.1666666666666667d+0
              t140 = -1.264669550498372d-1*t88-9.970917392951799d-1*t139
     1           -7.418564737168958d-1*t138-4.002143174996817d-1*t137
              t141 = 1/t22**2
              t142 = 1/t19
              t143 = -1.6039141941921276d-1*t88-1.8533958105157808d+0*t1
     1           39-1.2815820791490704d+0*t138-8.223668877838045d-1*t137
              t144 = 1/t18**2
              t145 = 1.1102230246251565d-16*t136*t140*t141*t25+3.0506411
     1           443514264d-19*t138*t24+1.0d+0*t142*t143*t144*t21+1.3210
     2           398931339265d-3*t138*t20
              t146 = 1/t41**1.6666666666666669d+0
              t147 = 1/t54**3
              t148 = 1/t41**1.3333333333333333d+0
              t149 = 1/t41**1.1666666666666667d+0
              t150 = -9.970917392951799d-1*t149-7.418564737168958d-1*t14
     1           8-4.002143174996817d-1*t147-1.264669550498372d-1*t146
              t151 = 1/t57**2
              t152 = 1/t58
              t153 = 1.0d+0*t150*t151*t152*t43*t52
              t154 = -1.3595691172479402d+0*t149-7.491972878592053d-1*t1
     1           48-2.1504862356383217d-1*t147-1.2743417300848914d-1*t14
     2           6
              t155 = 1/t63**2
              t156 = 1/t64
              t157 = -5.848223622634647d-1*t154*t155*t156*t61*t62
              t158 = -1.8533958105157808d+0*t149-1.2815820791490704d+0*t
     1           148-8.223668877838045d-1*t147-1.6039141941921276d-1*t14
     2           6
              t159 = 1/t68**2
              t160 = 1/t69
              t161 = 1.923661050931536d+0*t158*t159*t160*t45*t46*t50*t67
              t162 = 1/t41**2
              t163 = t162*t44
              t164 = -t47
              t165 = t164+t163
              t166 = t48**3.333333333333333d-1
              t167 = -t162*t44
              t168 = t47+t167
              t169 = t49**3.333333333333333d-1
              t170 = 1.3333333333333333d+0*t168*t169+1.3333333333333333d
     1           +0*t165*t166
              t171 = -1.923661050931536d+0*t170*t45*t46
              t172 = 1/t41**5
              t173 = 7.694644203726144d+0*t172*t45*t50
              t174 = t44**3
              t175 = -7.694644203726144d+0*t174*t46*t50
              t176 = t175+t173+t171
              t177 = -6.21814d-2*t176*t43*t59
              t178 = 2.747773264188437d-3*t148*t52*t59
              t179 = t175+t173+t171+1.923661050931536d+0*t170
              t180 = 1.9751631321680768d-2*t179*t61*t65
              t181 = -4.5437964274821163d-4*t148*t62*t65
              t182 = -5.980796863619711d-2*t170*t45*t46*t67*t70
              t183 = 1/t41**5.333333333333333d+0
              t184 = 2.541232989148493d-3*t183*t45*t50*t70
              t185 = 2.3923187454478842d-1*t172*t45*t50*t67*t70
              t186 = t71+t41*(-2.3923187454478842d-1*t174*t46*t50*t67*t7
     1           0+t185+t184+t182+t181+t180+t178+t177+t161+t157+t153)+t6
     2           6+t60+6.903522198342671d-18*t24*t25+3.1090699999999993d
     3           -2*t20*t21-rhoa*t145
              t187 = 1/rhoa**3.6666666666666664d+0
              t188 = 1/t7**2
              t189 = 2.562666666666666d-5*gammaaa*t1*t187*t188*t6-8.2666
     1           66666666665d-3*gammaaa*t1*t187*t8
              t190 = -8.266666666666665d-3*gammaaa*t187*t8*t9+2.56266666
     1           6666666d-5*gammaaa*t187*t188*t6*t9+3.1d-3*t189*t6*t8
              t191 = 3.1d-3*t190*t6*t8-8.266666666666665d-3*gammaaa*t10*
     1           t187*t8+2.562666666666666d-5*gammaaa*t10*t187*t188*t6
              t192 = 3.1d-3*t191*t6*t8-8.266666666666665d-3*gammaaa*t11*
     1           t187*t8+2.562666666666666d-5*gammaaa*t11*t187*t188*t6
              t193 = 1/t74**2
              t194 = 1/rhoa**6.333333333333333d+0
              t195 = 9.599999999999997d-3*t193*t194*t79*t94-1.5999999999
     1           999998d-1*gammaaa*t187*t75*t79
              t196 = 9.599999999999997d-3*t193*t194*t80*t94-1.5999999999
     1           999998d-1*gammaaa*t187*t75*t80+6.0d-2*gammaaa*t195*t2*t
     2           75
              t197 = 9.599999999999997d-3*t193*t194*t81*t94-1.5999999999
     1           999998d-1*gammaaa*t187*t75*t81+6.0d-2*gammaaa*t196*t2*t
     2           75
              t198 = 9.599999999999997d-3*t193*t194*t82*t94-1.5999999999
     1           999998d-1*gammaaa*t187*t75*t82+6.0d-2*gammaaa*t197*t2*t
     2           75
              t199 = -3.3333333333333337d+0*t2*taua-2.6666666666666666d+
     1           0*gammaaa*t187
              t200 = 1/t90**3
              t201 = -6.666666666666667d+0*t2*t96*t98*t99*taua-3.3333333
     1           333333337d+0*gammaaa*t95*t96*t97*taua-3.333333333333333
     2           7d+0*t102*t2*t91*taua-1.030176d-2*t100*t199*t200*t99-2.
     3           6666666666666666d+0*gammaaa*t187*t96*t97*t98-1.030176d-
     4           2*gammaaa*t199*t2*t200*t97*t98-5.15088d-3*t102*t199*t96
     5           *t98-5.333333333333333d+0*t194*t93*t94*t96-5.15088d-3*g
     6           ammaaa*t101*t199*t2*t96-1.030176d-2*t199*t200*t93*t94*t
     7           95-2.6666666666666666d+0*gammaaa*t101*t187*t91
              t202 = 1.0d+0*rhoa*t201*t26*t87+1.0d+0*t103*t26*t87+1.0d+0
     1           *rhoa*t103*t145*t87
              t203 = 1/t124**3
              t204 = -3.3333333333333337d+0*t128*t129*t2*t6*taua-3.33333
     1           33333333337d+0*t125*t134*t2*taua-6.666666666666667d+0*t
     2           128*t130*t131*t2*taua-6.09932d-3*t129*t130*t199*t203*t6
     3           -3.04966d-3*t128*t133*t199*t6-5.333333333333333d+0*gamm
     4           aaa*t126*t128*t187*t6-6.09932d-3*t131*t132*t199*t203-6.
     5           09932d-3*t126*t127*t199*t203-3.04966d-3*t128*t130*t134*
     6           t199-2.6666666666666666d+0*gammaaa*t125*t133*t187-2.666
     7           6666666666666d+0*gammaaa*t128*t129*t130*t187
              t205 = 1.0d+0*t204*t72+1.0d+0*t135*t186
              t206 = 1/t37
              t207 = 1/t28**3
              t208 = 1/rhob**1.3333333333333333d+0
              t209 = 1/rhob**1.1666666666666667d+0
              t210 = -9.970917392951799d-1*t209-7.418564737168958d-1*t20
     1           8-4.002143174996817d-1*t207-1.264669550498372d-1*t114
              t211 = 1/t36**2
              t212 = 1/t33
              t213 = -1.8533958105157808d+0*t209-1.2815820791490704d+0*t
     1           208-8.223668877838045d-1*t207-1.6039141941921276d-1*t11
     2           4
              t214 = 1/t32**2
              t215 = 1.1102230246251565d-16*t206*t210*t211*t39+3.0506411
     1           443514264d-19*t208*t38+1.0d+0*t212*t213*t214*t35+1.3210
     2           398931339265d-3*t208*t34
              t216 = t47+t163
              t217 = t167+t164
              t218 = 1.3333333333333333d+0*t169*t217+1.3333333333333333d
     1           +0*t166*t216
              t219 = -1.923661050931536d+0*t218*t45*t46
              t220 = 7.694644203726144d+0*t174*t46*t50
              t221 = t220+t219+t173
              t222 = -6.21814d-2*t221*t43*t59
              t223 = t220+t219+1.923661050931536d+0*t218+t173
              t224 = 1.9751631321680768d-2*t223*t61*t65
              t225 = -5.980796863619711d-2*t218*t45*t46*t67*t70
              t226 = t71+t41*(2.3923187454478842d-1*t174*t46*t50*t67*t70
     1           +t225+t224+t222+t185+t184+t181+t178+t161+t157+t153)+t66
     2           +t60+6.903522198342671d-18*t38*t39+3.1090699999999993d-
     3           2*t34*t35-rhob*t215
              t227 = 1/rhob**3.6666666666666664d+0
              t228 = 2.562666666666666d-5*gammabb*t1*t188*t227*t6-8.2666
     1           66666666665d-3*gammabb*t1*t227*t8
              t229 = -8.266666666666665d-3*gammabb*t227*t8*t9+2.56266666
     1           6666666d-5*gammabb*t188*t227*t6*t9+3.1d-3*t228*t6*t8
              t230 = 3.1d-3*t229*t6*t8-8.266666666666665d-3*gammabb*t10*
     1           t227*t8+2.562666666666666d-5*gammabb*t10*t188*t227*t6
              t231 = 3.1d-3*t230*t6*t8-8.266666666666665d-3*gammabb*t11*
     1           t227*t8+2.562666666666666d-5*gammabb*t11*t188*t227*t6
              t232 = 1/t104**2
              t233 = 1/rhob**6.333333333333333d+0
              t234 = 9.599999999999997d-3*t118*t232*t233*t79-1.599999999
     1           9999998d-1*gammabb*t105*t227*t79
              t235 = 6.0d-2*gammabb*t105*t234*t4+9.599999999999997d-3*t1
     1           06*t118*t232*t233-1.5999999999999998d-1*gammabb*t105*t1
     2           06*t227
              t236 = 6.0d-2*gammabb*t105*t235*t4+9.599999999999997d-3*t1
     1           07*t118*t232*t233-1.5999999999999998d-1*gammabb*t105*t1
     2           07*t227
              t237 = 6.0d-2*gammabb*t105*t236*t4+9.599999999999997d-3*t1
     1           08*t118*t232*t233-1.5999999999999998d-1*gammabb*t105*t1
     2           08*t227
              t238 = -3.3333333333333337d+0*t4*taub-2.6666666666666666d+
     1           0*gammabb*t227
              t239 = 1/t116**3
              t240 = -6.666666666666667d+0*t120*t121*t4*t99*taub-3.33333
     1           33333333337d+0*gammabb*t119*t120*t97*taub-3.33333333333
     2           33337d+0*t102*t117*t4*taub-1.030176d-2*t122*t238*t239*t
     3           99-1.030176d-2*gammabb*t121*t238*t239*t4*t97-2.66666666
     4           66666666d+0*gammabb*t120*t121*t227*t97-1.030176d-2*t118
     5           *t119*t238*t239*t93-5.333333333333333d+0*t118*t120*t233
     6           *t93-5.15088d-3*gammabb*t101*t120*t238*t4-5.15088d-3*t1
     7           02*t120*t121*t238-2.6666666666666666d+0*gammabb*t101*t1
     8           17*t227
              t241 = 1.0d+0*rhob*t113*t240*t40+1.0d+0*t113*t123*t40+1.0d
     1           +0*rhob*t113*t123*t215
              t242 = -3.3333333333333337d+0*t128*t129*t4*t6*taub-3.33333
     1           33333333337d+0*t125*t134*t4*taub-6.666666666666667d+0*t
     2           128*t130*t131*t4*taub-6.09932d-3*t129*t130*t203*t238*t6
     3           -3.04966d-3*t128*t133*t238*t6-5.333333333333333d+0*gamm
     4           abb*t126*t128*t227*t6-6.09932d-3*t131*t132*t203*t238-6.
     5           09932d-3*t126*t127*t203*t238-3.04966d-3*t128*t130*t134*
     6           t238-2.6666666666666666d+0*gammabb*t125*t133*t227-2.666
     7           6666666666666d+0*gammabb*t128*t129*t130*t227
              t243 = 1.0d+0*t242*t72+1.0d+0*t135*t226
              t244 = 3.1d-3*t1*t2*t8-9.61d-6*t1*t188*t2*t6
              t245 = 3.1d-3*t2*t8*t9-9.61d-6*t188*t2*t6*t9+3.1d-3*t244*t
     1           6*t8
              t246 = 3.1d-3*t245*t6*t8+3.1d-3*t10*t2*t8-9.61d-6*t10*t188
     1           *t2*t6
              t247 = 3.1d-3*t246*t6*t8+3.1d-3*t11*t2*t8-9.61d-6*t11*t188
     1           *t2*t6
              t248 = 6.0d-2*t2*t75*t79-3.6d-3*gammaaa*t193*t79*t95
              t249 = -3.6d-3*gammaaa*t193*t80*t95+6.0d-2*t2*t75*t80+6.0d
     1           -2*gammaaa*t2*t248*t75
              t250 = -3.6d-3*gammaaa*t193*t81*t95+6.0d-2*t2*t75*t81+6.0d
     1           -2*gammaaa*t2*t249*t75
              t251 = -3.6d-3*gammaaa*t193*t82*t95+6.0d-2*t2*t75*t82+6.0d
     1           -2*gammaaa*t2*t250*t75
              t252 = 1/rhoa**8
              t253 = -1.030176d-2*t100*t2*t200*t99+t2*t96*t97*t98-1.0301
     1           76d-2*gammaaa*t200*t95*t97*t98-5.15088d-3*t102*t2*t96*t
     2           98+2*gammaaa*t93*t95*t96-5.15088d-3*gammaaa*t101*t95*t9
     3           6-1.030176d-2*t200*t252*t93*t94+t101*t2*t91
              t254 = -6.09932d-3*t129*t130*t2*t203*t6-3.04966d-3*t128*t1
     1           33*t2*t6+2*t126*t128*t2*t6-6.09932d-3*t131*t132*t2*t203
     2           -6.09932d-3*t126*t127*t2*t203-3.04966d-3*t128*t130*t134
     3           *t2+t125*t133*t2+t128*t129*t130*t2
              t255 = 3.1d-3*t1*t4*t8-9.61d-6*t1*t188*t4*t6
              t256 = 3.1d-3*t4*t8*t9-9.61d-6*t188*t4*t6*t9+3.1d-3*t255*t
     1           6*t8
              t257 = 3.1d-3*t256*t6*t8+3.1d-3*t10*t4*t8-9.61d-6*t10*t188
     1           *t4*t6
              t258 = 3.1d-3*t257*t6*t8+3.1d-3*t11*t4*t8-9.61d-6*t11*t188
     1           *t4*t6
              t259 = 6.0d-2*t105*t4*t79-3.6d-3*gammabb*t119*t232*t79
              t260 = 6.0d-2*gammabb*t105*t259*t4+6.0d-2*t105*t106*t4-3.6
     1           d-3*gammabb*t106*t119*t232
              t261 = 6.0d-2*gammabb*t105*t260*t4+6.0d-2*t105*t107*t4-3.6
     1           d-3*gammabb*t107*t119*t232
              t262 = 6.0d-2*gammabb*t105*t261*t4+6.0d-2*t105*t108*t4-3.6
     1           d-3*gammabb*t108*t119*t232
              t263 = 1/rhob**8
              t264 = -1.030176d-2*t122*t239*t4*t99+t120*t121*t4*t97-1.03
     1           0176d-2*gammabb*t119*t121*t239*t97-1.030176d-2*t118*t23
     2           9*t263*t93+2*gammabb*t119*t120*t93-5.15088d-3*t102*t120
     3           *t121*t4+t101*t117*t4-5.15088d-3*gammabb*t101*t119*t120
              t265 = -6.09932d-3*t129*t130*t203*t4*t6-3.04966d-3*t128*t1
     1           33*t4*t6+2*t126*t128*t4*t6-6.09932d-3*t131*t132*t203*t4
     2           -6.09932d-3*t126*t127*t203*t4-3.04966d-3*t128*t130*t134
     3           *t4+t125*t133*t4+t128*t129*t130*t4
              t266 = taua**2
              t267 = 1/t266
              t268 = 1/rhoa**7
              t269 = 1/rhoa**4.333333333333333d+0
              t270 = 4.0d+0*t88*t96*t98*t99-2.060352d-2*t100*t200*t88*t9
     1           9-2.060352d-2*gammaaa*t200*t269*t97*t98-1.030176d-2*t10
     2           2*t88*t96*t98+2.0d+0*gammaaa*t269*t96*t97-1.030176d-2*g
     3           ammaaa*t101*t269*t96-2.060352d-2*t200*t268*t93*t94+2.0d
     4           +0*t102*t88*t91
              t271 = -1.219864d-2*t129*t130*t203*t6*t88-6.09932d-3*t128*
     1           t133*t6*t88+2.0d+0*t128*t129*t6*t88-1.219864d-2*t131*t1
     2           32*t203*t88-1.219864d-2*t126*t127*t203*t88-6.09932d-3*t
     3           128*t130*t134*t88+2.0d+0*t125*t134*t88+4.0d+0*t128*t130
     4           *t131*t88
              t272 = taub**2
              t273 = 1/t272
              t274 = 1/rhob**7
              t275 = 1/rhob**4.333333333333333d+0
              t276 = -2.060352d-2*t114*t122*t239*t99+4.0d+0*t114*t120*t1
     1           21*t99-2.060352d-2*gammabb*t121*t239*t275*t97+2.0d+0*ga
     2           mmabb*t120*t275*t97-2.060352d-2*t118*t239*t274*t93-1.03
     3           0176d-2*gammabb*t101*t120*t275-1.030176d-2*t102*t114*t1
     4           20*t121+2.0d+0*t102*t114*t117
              t277 = -1.219864d-2*t114*t129*t130*t203*t6-6.09932d-3*t114
     1           *t128*t133*t6+2.0d+0*t114*t128*t129*t6-1.219864d-2*t114
     2           *t131*t132*t203-1.219864d-2*t114*t126*t127*t203-6.09932
     3           d-3*t114*t128*t130*t134+2.0d+0*t114*t125*t134+4.0d+0*t1
     4           14*t128*t130*t131
              t278 = t140**2
              t279 = 1/t14**5
              t280 = 1/rhoa**2.3333333333333334d+0
              t281 = 1/rhoa**2.1666666666666665d+0
              t282 = t143**2
              t283 = 3.216395899738507d+1*t21*t282/(t18**4*t19**2)-2.0d+
     1           0*t142*t21*t282/t18**3+1.0d+0*t142*t144*t21*(2.16229511
     2           22684114d+0*t281+1.7087761055320938d+0*t280+1.233550331
     3           6757068d+0*t279+2.673190323653546d-1*t2)+1.110223024625
     4           1565d-16*t136*t141*t25*(1.1632736958443765d+0*t281+9.89
     5           141964955861d-1*t280+6.003214762495226d-1*t279+2.107782
     6           5841639536d-1*t2)-4.0675215258019015d-19*t24*t280-1.761
     7           3865241785684d-3*t20*t280+1.7854583920998188d-15*t25*t2
     8           78/(t22**4*t23**2)-2.220446049250313d-16*t136*t25*t278/
     9           t22**3-8.497974591333913d-2*t138*t142*t143*t144-9.81206
     :           9668265515d-18*t136*t138*t140*t141
              t284 = 2.0d+0*t150*t151*t152*t43*t52
              t285 = -1.1696447245269295d+0*t154*t155*t156*t61*t62
              t286 = 3.847322101863072d+0*t158*t159*t160*t45*t46*t50*t67
              t287 = 5.495546528376875d-3*t148*t52*t59
              t288 = -9.087592854964233d-4*t148*t62*t65
              t289 = 5.082465978296986d-3*t183*t45*t50*t70
              t290 = 4.7846374908957684d-1*t172*t45*t50*t67*t70
              t291 = t150**2
              t292 = 1.6081979498692536d+1*t291*t43*t52/(t57**4*t58**2)
              t293 = -2.0d+0*t152*t291*t43*t52/t57**3
              t294 = -8.837926660346784d-2*t148*t150*t151*t152*t52
              t295 = 1/t41**2.6666666666666666d+0
              t296 = 1/t54**5
              t297 = 1/t41**2.3333333333333334d+0
              t298 = 1/t41**2.1666666666666665d+0
              t299 = 1.0d+0*t151*t152*(1.1632736958443765d+0*t298+9.8914
     1           1964955861d-1*t297+6.003214762495226d-1*t296+2.10778258
     2           41639536d-1*t295)*t43*t52
              t300 = t154**2
              t301 = -1.73158960813529d+1*t300*t61*t62/(t63**4*t64**2)
              t302 = 1.1696447245269295d+0*t156*t300*t61*t62/t63**3
              t303 = 2.690728393099896d-2*t148*t154*t155*t156*t62
              t304 = -5.848223622634647d-1*t155*t156*(1.5861639701225969
     1           d+0*t298+9.98929717145607d-1*t297+3.2257293534574827d-1
     2           *t296+2.1239028834748191d-1*t295)*t61*t62
              t305 = t158**2
              t306 = 6.187255516702861d+1*t305*t45*t46*t50*t67/(t68**4*t
     1           69**2)
              t307 = -3.847322101863072d+0*t160*t305*t45*t46*t50*t67/t68
     1           **3
              t308 = -1.6347222733154887d-1*t158*t159*t160*t183*t45*t50
              t309 = 1.923661050931536d+0*t159*t160*(2.1622951122684114d
     1           +0*t298+1.7087761055320938d+0*t297+1.2335503316757068d+
     2           0*t296+2.673190323653546d-1*t295)*t45*t46*t50*t67
              t310 = -1.538928840745229d+1*t158*t159*t160*t172*t45*t50*t
     1           67
              t311 = 1/t48**6.666666666666666d-1
              t312 = 1/t41**3
              t313 = -2*t312*t44
              t314 = 2*t162
              t315 = 1/t49**6.666666666666666d-1
              t316 = 2*t312*t44
              t317 = -2*t162
              t318 = 1.3333333333333333d+0*t169*(t317+t316)+4.4444444444
     1           44444d-1*t168**2*t315+1.3333333333333333d+0*t166*(t314+
     2           t313)+4.444444444444444d-1*t165**2*t311
              t319 = -1.923661050931536d+0*t318*t45*t46
              t320 = 1.5389288407452287d+1*t170*t172*t45
              t321 = -1.5389288407452287d+1*t170*t174*t46
              t322 = 1/t41**6
              t323 = -3.8473221018630716d+1*t322*t45*t50
              t324 = 6.155715362980915d+1*t172*t174*t50
              t325 = t44**2
              t326 = -2.3083932611178434d+1*t325*t46*t50
              t327 = -3.663697685584583d-3*t297*t52*t59
              t328 = 6.058395236642822d-4*t297*t62*t65
              t329 = -2.3718174565385935d-2*t45*t50*t70/t41**6.333333333
     1           333333d+0
              t330 = -1.1961593727239421d+0*t322*t45*t50*t67*t70
              t331 = -7.176956236343652d-1*t325*t46*t50*t67*t70
              t332 = t41*(1.9138549963583074d+0*t172*t174*t50*t67*t70-5.
     1           980796863619711d-2*t318*t45*t46*t67*t70-4.7846374908957
     2           684d-1*t170*t174*t46*t67*t70+4.7846374908957684d-1*t170
     3           *t172*t45*t67*t70+2.0329863913187946d-2*t174*t183*t50*t
     4           70+5.082465978296986d-3*t170*t183*t45*t70+1.53892884074
     5           5229d+1*t158*t159*t160*t174*t46*t50*t67+3.8473221018630
     6           72d+0*t158*t159*t160*t170*t45*t46*t67+1.975163132168076
     7           8d-2*(t326+t324+t323+t321+t320+t319+1.923661050931536d+
     8           0*t318)*t61*t65-9.087592854964233d-4*t148*t179*t65-1.16
     9           96447245269295d+0*t154*t155*t156*t179*t61-6.21814d-2*(t
     :           326+t324+t323+t321+t320+t319)*t43*t59+5.495546528376875
     ;           d-3*t148*t176*t59+2.0d+0*t150*t151*t152*t176*t43+t331+t
     <           330+t329+t328+t327+t310+t309+t308+t307+t306+t304+t303+t
     =           302+t301+t299+t294+t293+t292)-4.7846374908957684d-1*t17
     >           4*t46*t50*t67*t70-1.1961593727239421d-1*t170*t45*t46*t6
     ?           7*t70+3.9503262643361536d-2*t179*t61*t65-1.243628d-1*t1
     @           76*t43*t59+t290+t289+t288+t287+t286+t285+t284-rhoa*t283
     1           -2.220446049250313d-16*t136*t140*t141*t25-6.10128228870
     2           2853d-19*t138*t24-2.0d+0*t142*t143*t144*t21-2.642079786
     3           267853d-3*t138*t20
              t333 = 1/rhoa**7.333333333333333d+0
              t334 = 1/t7**3
              t335 = 1/rhoa**4.666666666666667d+0
              t336 = 1/rhoa**2
              t337 = gammaaa**3
              t338 = 1/t74**3
              t339 = 1/rhoa**10
              t340 = t199**2
              t341 = 1/t90**4
              t342 = 8.88888888888889d+0*t187*taua+9.777777777777779d+0*
     1           gammaaa*t335
              t343 = 1/t124**4
              t344 = 2.6666666666666666d+0*t169*t312*t44-2.6666666666666
     1           666d+0*t166*t312*t44+4.444444444444444d-1*t168*t217*t31
     2           5+4.444444444444444d-1*t165*t216*t311
              t345 = -1.923661050931536d+0*t344*t45*t46
              t346 = 7.694644203726144d+0*t172*t218*t45
              t347 = -7.694644203726144d+0*t174*t218*t46
              t348 = 7.694644203726144d+0*t170*t172*t45
              t349 = 7.694644203726144d+0*t170*t174*t46
              t350 = 2.3083932611178434d+1*t325*t46*t50
              t351 = t41*(7.176956236343652d-1*t325*t46*t50*t67*t70-5.98
     1           0796863619711d-2*t344*t45*t46*t67*t70-2.392318745447884
     2           2d-1*t174*t218*t46*t67*t70+2.3923187454478842d-1*t170*t
     3           174*t46*t67*t70+2.3923187454478842d-1*t172*t218*t45*t67
     4           *t70+2.3923187454478842d-1*t170*t172*t45*t67*t70+2.5412
     5           32989148493d-3*t183*t218*t45*t70+2.541232989148493d-3*t
     6           170*t183*t45*t70+1.923661050931536d+0*t158*t159*t160*t2
     7           18*t45*t46*t67+1.923661050931536d+0*t158*t159*t160*t170
     8           *t45*t46*t67+1.9751631321680768d-2*(t350+t349+t348+t347
     9           +t346+t345+1.923661050931536d+0*t344+t323)*t61*t65-4.54
     :           37964274821163d-4*t148*t223*t65-4.5437964274821163d-4*t
     ;           148*t179*t65-5.848223622634647d-1*t154*t155*t156*t223*t
     <           61-5.848223622634647d-1*t154*t155*t156*t179*t61-6.21814
     =           d-2*(t350+t349+t348+t347+t346+t345+t323)*t43*t59+2.7477
     >           73264188437d-3*t148*t221*t59+2.747773264188437d-3*t148*
     ?           t176*t59+1.0d+0*t150*t151*t152*t221*t43+1.0d+0*t150*t15
     @           1*t152*t176*t43+t330+t329+t328+t327+t310+t309+t308+t307
     1           +t306+t304+t303+t302+t301+t299+t294+t293+t292)+t290+t28
     2           9+t288+t287+t286+t285+t284+t225+t224+t222+t182+t180+t17
     3           7
              t352 = t210**2
              t353 = 1/t28**5
              t354 = 1/rhob**2.3333333333333334d+0
              t355 = 1/rhob**2.1666666666666665d+0
              t356 = t213**2
              t357 = 1.0d+0*t212*t214*t35*(2.673190323653546d-1*t4+2.162
     1           2951122684114d+0*t355+1.7087761055320938d+0*t354+1.2335
     2           503316757068d+0*t353)+1.1102230246251565d-16*t206*t211*
     3           t39*(2.1077825841639536d-1*t4+1.1632736958443765d+0*t35
     4           5+9.89141964955861d-1*t354+6.003214762495226d-1*t353)+1
     5           .7854583920998188d-15*t352*t39/(t36**4*t37**2)-2.220446
     6           049250313d-16*t206*t352*t39/t36**3-4.0675215258019015d-
     7           19*t354*t38+3.216395899738507d+1*t35*t356/(t32**4*t33**
     8           2)-2.0d+0*t212*t35*t356/t32**3-1.7613865241785684d-3*t3
     9           4*t354-8.497974591333913d-2*t208*t212*t213*t214-9.81206
     :           9668265515d-18*t206*t208*t210*t211
              t358 = 1.3333333333333333d+0*t166*(t317+t313)+1.3333333333
     1           333333d+0*t169*(t316+t314)+4.444444444444444d-1*t217**2
     2           *t315+4.444444444444444d-1*t216**2*t311
              t359 = -1.923661050931536d+0*t358*t45*t46
              t360 = 1.5389288407452287d+1*t172*t218*t45
              t361 = 1.5389288407452287d+1*t174*t218*t46
              t362 = -6.155715362980915d+1*t172*t174*t50
              t363 = t41*(-1.9138549963583074d+0*t172*t174*t50*t67*t70-5
     1           .980796863619711d-2*t358*t45*t46*t67*t70+4.784637490895
     2           7684d-1*t174*t218*t46*t67*t70+4.7846374908957684d-1*t17
     3           2*t218*t45*t67*t70-2.0329863913187946d-2*t174*t183*t50*
     4           t70+5.082465978296986d-3*t183*t218*t45*t70-1.5389288407
     5           45229d+1*t158*t159*t160*t174*t46*t50*t67+3.847322101863
     6           072d+0*t158*t159*t160*t218*t45*t46*t67+1.97516313216807
     7           68d-2*(t362+t361+t360+t359+1.923661050931536d+0*t358+t3
     8           26+t323)*t61*t65-9.087592854964233d-4*t148*t223*t65-1.1
     9           696447245269295d+0*t154*t155*t156*t223*t61-6.21814d-2*(
     :           t362+t361+t360+t359+t326+t323)*t43*t59+5.49554652837687
     ;           5d-3*t148*t221*t59+2.0d+0*t150*t151*t152*t221*t43+t331+
     <           t330+t329+t328+t327+t310+t309+t308+t307+t306+t304+t303+
     =           t302+t301+t299+t294+t293+t292)+4.7846374908957684d-1*t1
     >           74*t46*t50*t67*t70-1.1961593727239421d-1*t218*t45*t46*t
     ?           67*t70+3.9503262643361536d-2*t223*t61*t65-1.243628d-1*t
     @           221*t43*t59-2.220446049250313d-16*t206*t210*t211*t39-6.
     1           101282288702853d-19*t208*t38-rhob*t357-2.0d+0*t212*t213
     2           *t214*t35-2.642079786267853d-3*t208*t34+t290+t289+t288+
     3           t287+t286+t285+t284
              t364 = 1/rhob**7.333333333333333d+0
              t365 = 1/rhob**4.666666666666667d+0
              t366 = 1/rhob**2
              t367 = gammabb**3
              t368 = 1/t104**3
              t369 = 1/rhob**10
              t370 = t238**2
              t371 = 1/t116**4
              t372 = 8.88888888888889d+0*t227*taub+9.777777777777779d+0*
     1           gammabb*t365
              t373 = 1.25d-1*t26*t83
              t374 = 1/rhoa**9
              t375 = 1.25d-1*gammaaa*t253*t26+1.25d-1*t103*t26
              t376 = 1.25d-1*t109*t40
              t377 = 1/rhob**9
              t378 = 1.25d-1*gammabb*t264*t40+1.25d-1*t123*t40
              t379 = 1/rhoa**3.3333333333333337d+0
              t380 = 1/rhob**3.3333333333333337d+0
              t381 = 1/taua**3
              t382 = 1/rhoa**6
              t383 = 1/taub**3
              t384 = 1/rhob**6
              fnc(iq) = (1.0d+0*rhoa*t103*t26*t87*t91+5.0d-1*rhoa*t26*t8
     1           3*t84*t86+1.0d+0*t125*t135*t72+1.0d+0*t12*t72+1.0d+0*rh
     2           ob*t113*t117*t123*t40+5.0d-1*rhob*t109*t110*t112*t40)*w
     3           ght+fnc(iq)
              Amat(iq,D1_RA) = (-5.15088d-3*rhoa*t103*t199*t26*t87*t96+1
     1           .25d-1*gammaaa*t103*t26*t84*t85*t91+t202*t91+t84*(5.0d-
     2           1*t26*t83*t86+5.0d-1*rhoa*t145*t83*t86+5.0d-1*rhoa*t198
     3           *t26*t86)+1.25d-1*gammaaa*t26*t83*t84*t85-3.04966d-3*t1
     4           28*t135*t199*t72+1.0d+0*t192*t72+t125*t205+1.0d+0*t12*t
     5           186)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-3.04966d-3*t128*t135*t238*t72+1.0d+0*t2
     1           31*t72+t110*(5.0d-1*rhob*t112*t237*t40+5.0d-1*t109*t112
     2           *t40+5.0d-1*rhob*t109*t112*t215)-5.15088d-3*rhob*t113*t
     3           120*t123*t238*t40+1.25d-1*gammabb*t110*t111*t117*t123*t
     4           40+1.25d-1*gammabb*t109*t110*t111*t40+t125*t243+t117*t2
     5           41+1.0d+0*t12*t226)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (-5.15088d-3*t103*t26*t87*t88*t96+1.0d+0
     1           *rhoa*t253*t26*t87*t91-1.25d-1*t103*t26*t84*t91+t84*(5.
     2           0d-1*rhoa*t251*t26*t86-1.25d-1*t26*t83)+1.0d+0*t125*t25
     3           4*t72+1.0d+0*t247*t72-3.04966d-3*t128*t135*t2*t72)*wght
     4           +Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (-3.04966d-3*t128*t135*t4*t72+1.0d+0*t12
     1           5*t265*t72+1.0d+0*t258*t72+t110*(5.0d-1*rhob*t112*t262*
     2           t40-1.25d-1*t109*t40)+1.0d+0*rhob*t113*t117*t264*t40-5.
     3           15088d-3*t113*t114*t120*t123*t40-1.25d-1*t110*t117*t123
     4           *t40)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (-1.030176d-2*t103*t13*t26*t87*t96+1.0d+0
     1           *rhoa*t26*t270*t87*t91+1.25d-1*gammaaa*t103*t26*t267*t9
     2           1-6.09932d-3*t128*t135*t72*t88-5.0d-1*rhoa*t26*t267*t83
     3           *t86+1.0d+0*rhoa*t26*t83*t84+1.0d+0*t125*t271*t72)*wght
     4           +Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*t125*t277*t72-6.09932d-3*t114*t12
     1           8*t135*t72+1.0d+0*rhob*t113*t117*t276*t40+1.25d-1*gamma
     2           bb*t117*t123*t273*t40-5.0d-1*rhob*t109*t112*t273*t40-1.
     3           030176d-2*t113*t120*t123*t27*t40+1.0d+0*rhob*t109*t110*
     4           t40)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t91*(1.0d+0*rhoa*t26*t87*(1.77777777
     1           77777778d+1*t187*t96*t98*t99*taua+1.373568d-1*t199*t2*t
     2           200*t98*t99*taua+2.6666666666666666d+1*gammaaa*t194*t96
     3           *t97*taua+6.867840000000001d-2*gammaaa*t199*t200*t95*t9
     4           7*taua+3.4339200000000003d-2*t102*t199*t2*t96*taua+8.88
     5           888888888889d+0*t102*t187*t91*taua+2.2222222222222224d+
     6           1*t266*t95*t96*t99-1.030176d-2*t100*t200*t342*t99+1.591
     7           893886464d-4*t100*t340*t341*t99+9.777777777777779d+0*ga
     8           mmaaa*t335*t96*t97*t98-1.030176d-2*gammaaa*t2*t200*t342
     9           *t97*t98+1.591893886464d-4*gammaaa*t2*t340*t341*t97*t98
     :           +5.494272d-2*gammaaa*t187*t199*t200*t97*t98-5.15088d-3*
     ;           t102*t342*t96*t98+5.30631295488d-5*t102*t200*t340*t98+3
     <           .377777777777778d+1*t333*t93*t94*t96-5.15088d-3*gammaaa
     =           *t101*t2*t342*t96+2.747136d-2*gammaaa*t101*t187*t199*t9
     >           6-1.030176d-2*t200*t342*t93*t94*t95+1.591893886464d-4*t
     ?           340*t341*t93*t94*t95+1.0988544d-1*t194*t199*t200*t93*t9
     @           4+9.777777777777779d+0*gammaaa*t101*t335*t91+5.30631295
     1           488d-5*gammaaa*t101*t2*t200*t340)+1.0d+0*rhoa*t103*t283
     2           *t87+2.0d+0*t201*t26*t87+2.0d+0*rhoa*t145*t201*t87+2.0d
     3           +0*t103*t145*t87+1.25d-1*gammaaa*t201*t26*t84*t85+1.25d
     4           -1*gammaaa*t103*t145*t84*t85+1.25d-1*gammaaa*t103*t26*t
     5           336*t84)+t125*(1.0d+0*t72*(4.066213333333334d-2*t129*t1
     6           99*t2*t203*t6*taua+8.88888888888889d+0*t128*t129*t187*t
     7           6*taua+8.132426666666668d-2*t130*t131*t199*t2*t203*taua
     8           +2.033106666666667d-2*t128*t134*t199*t2*taua+1.77777777
     9           77777778d+1*gammaaa*t128*t129*t194*taua+8.8888888888888
     :           9d+0*t125*t134*t187*taua+1.7777777777777778d+1*t128*t13
     ;           0*t131*t187*taua+2.2222222222222224d+1*t128*t131*t266*t
     <           95+1.4222222222222222d+1*t126*t128*t333*t94+5.580255669
     =           360001d-5*t129*t130*t340*t343*t6-6.09932d-3*t129*t130*t
     >           203*t342*t6-3.04966d-3*t128*t133*t342*t6+1.86008522312d
     ?           -5*t133*t203*t340*t6+1.9555555555555557d+1*gammaaa*t126
     @           *t128*t335*t6+6.505941333333333d-2*gammaaa*t126*t187*t1
     1           99*t203*t6+5.580255669360001d-5*t131*t132*t340*t343+5.5
     2           80255669360001d-5*t126*t127*t340*t343-6.09932d-3*t131*t
     3           132*t203*t342-6.09932d-3*t126*t127*t203*t342-3.04966d-3
     4           *t128*t130*t134*t342+1.86008522312d-5*t130*t134*t203*t3
     5           40+9.777777777777779d+0*gammaaa*t125*t133*t335+9.777777
     6           777777779d+0*gammaaa*t128*t129*t130*t335+3.252970666666
     7           6663d-2*gammaaa*t129*t130*t187*t199*t203+1.626485333333
     8           3332d-2*gammaaa*t128*t133*t187*t199)+1.0d+0*t135*t332+2
     9           .0d+0*t186*t204)+(-5.15088d-3*rhoa*t103*t26*t342*t87-5.
     :           15088d-3*rhoa*t199*t201*t26*t87-5.15088d-3*t103*t199*t2
     ;           6*t87-5.15088d-3*rhoa*t103*t145*t199*t87-5.15088d-3*t19
     <           9*t202)*t96-1.28772d-3*gammaaa*t103*t199*t26*t84*t85*t9
     =           6+t84*(5.0d-1*rhoa*t26*t86*(6.0d-2*gammaaa*t2*t75*(6.0d
     >           -2*gammaaa*t2*t75*(6.0d-2*gammaaa*t2*t75*(-8.6399999999
     ?           99998d-2*t193*t333*t79*t94+5.866666666666666d-1*gammaaa
     @           *t335*t75*t79+3.0719999999999986d-3*t337*t338*t339*t79)
     1           -8.639999999999998d-2*t193*t333*t80*t94+1.9199999999999
     2           995d-2*t193*t194*t195*t94+5.866666666666666d-1*gammaaa*
     3           t335*t75*t80+3.0719999999999986d-3*t337*t338*t339*t80-3
     4           .1999999999999995d-1*gammaaa*t187*t195*t75)-8.639999999
     5           999998d-2*t193*t333*t81*t94+1.9199999999999995d-2*t193*
     6           t194*t196*t94+5.866666666666666d-1*gammaaa*t335*t75*t81
     7           +3.0719999999999986d-3*t337*t338*t339*t81-3.19999999999
     8           99995d-1*gammaaa*t187*t196*t75)-8.639999999999998d-2*t1
     9           93*t333*t82*t94+1.9199999999999995d-2*t193*t194*t197*t9
     :           4+5.866666666666666d-1*gammaaa*t335*t75*t82+3.071999999
     ;           9999986d-3*t337*t338*t339*t82-3.1999999999999995d-1*gam
     <           maaa*t187*t197*t75)+5.0d-1*rhoa*t283*t83*t86+1.0d+0*t14
     =           5*t83*t86+1.0d+0*t198*t26*t86+1.0d+0*rhoa*t145*t198*t86
     >           +1.25d-1*gammaaa*t145*t83*t85+1.25d-1*gammaaa*t198*t26*
     ?           t85+1.25d-1*gammaaa*t26*t336*t83)+1.0d+0*t72*(3.1d-3*t6
     @           *t8*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(4.2369422222222203d-7*
     1           t1*t333*t334*t6*t94-1.366755555555555d-4*t1*t188*t333*t
     2           94+3.0311111111111105d-2*gammaaa*t1*t335*t8-9.396444444
     3           444442d-5*gammaaa*t1*t188*t335*t6)+4.2369422222222203d-
     4           7*t333*t334*t6*t9*t94-1.366755555555555d-4*t188*t333*t9
     5           *t94+3.0311111111111105d-2*gammaaa*t335*t8*t9-9.3964444
     6           44444442d-5*gammaaa*t188*t335*t6*t9-1.653333333333333d-
     7           2*gammaaa*t187*t189*t8+5.125333333333332d-5*gammaaa*t18
     8           7*t188*t189*t6)+4.2369422222222203d-7*t10*t333*t334*t6*
     9           t94-1.366755555555555d-4*t10*t188*t333*t94+3.0311111111
     :           111105d-2*gammaaa*t10*t335*t8-1.653333333333333d-2*gamm
     ;           aaa*t187*t190*t8-9.396444444444442d-5*gammaaa*t10*t188*
     <           t335*t6+5.125333333333332d-5*gammaaa*t187*t188*t190*t6)
     =           +4.2369422222222203d-7*t11*t333*t334*t6*t94-1.366755555
     >           555555d-4*t11*t188*t333*t94+3.0311111111111105d-2*gamma
     ?           aa*t11*t335*t8-1.653333333333333d-2*gammaaa*t187*t191*t
     @           8-9.396444444444442d-5*gammaaa*t11*t188*t335*t6+5.12533
     1           3333333332d-5*gammaaa*t187*t188*t191*t6)+(1.25d-1*gamma
     2           aa*t201*t26+1.25d-1*gammaaa*t103*t145)*t84*t85*t91-1.25
     3           d-1*gammaaa*t103*t26*t336*t84*t91+5.30631295488d-5*rhoa
     4           *t103*t200*t26*t340*t87+(1.25d-1*gammaaa*t145*t83+1.25d
     5           -1*gammaaa*t198*t26)*t84*t85-1.25d-1*gammaaa*t26*t336*t
     6           83*t84+t128*(-3.04966d-3*t135*t342*t72-3.04966d-3*t199*
     7           t204*t72-3.04966d-3*t199*t205-3.04966d-3*t135*t186*t199
     8           )+1.86008522312d-5*t135*t203*t340*t72+1.0d+0*t12*t332+2
     9           .0d+0*t186*t192)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t125*(1.0d+0*t72*(2.2222222222222224
     1           d+1*t128*t131*t2*t4*taua*taub+2.033106666666667d-2*t129
     2           *t199*t203*t4*t6*taub+4.066213333333334d-2*t130*t131*t1
     3           99*t203*t4*taub+1.0165533333333335d-2*t128*t134*t199*t4
     4           *taub+8.88888888888889d+0*gammaaa*t128*t129*t187*t4*tau
     5           b+2.033106666666667d-2*t129*t2*t203*t238*t6*taua+4.0662
     6           13333333334d-2*t130*t131*t2*t203*t238*taua+1.0165533333
     7           333335d-2*t128*t134*t2*t238*taua+8.88888888888889d+0*ga
     8           mmabb*t128*t129*t2*t227*taua+5.580255669360001d-5*t129*
     9           t130*t199*t238*t343*t6+1.86008522312d-5*t133*t199*t203*
     :           t238*t6+3.2529706666666663d-2*gammaaa*t126*t187*t203*t2
     ;           38*t6+3.2529706666666663d-2*gammabb*t126*t199*t203*t227
     <           *t6+5.580255669360001d-5*t131*t132*t199*t238*t343+5.580
     =           255669360001d-5*t126*t127*t199*t238*t343+1.86008522312d
     >           -5*t130*t134*t199*t203*t238+1.6264853333333332d-2*gamma
     ?           aa*t129*t130*t187*t203*t238+8.132426666666667d-3*gammaa
     @           a*t128*t133*t187*t238+1.6264853333333332d-2*gammabb*t12
     1           9*t130*t199*t203*t227+8.132426666666667d-3*gammabb*t128
     2           *t133*t199*t227+1.4222222222222222d+1*gammaaa*gammabb*t
     3           126*t128*t187*t227)+1.0d+0*t135*t351+1.0d+0*t186*t242+1
     4           .0d+0*t204*t226)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8
     5           *(4.2369422222222203d-7*gammaaa*gammabb*t187*t227*t334*
     6           t6*t9-1.366755555555555d-4*gammaaa*gammabb*t187*t188*t2
     7           27*t9+3.1d-3*t6*(4.2369422222222203d-7*gammaaa*gammabb*
     8           t1*t187*t227*t334*t6-1.366755555555555d-4*gammaaa*gamma
     9           bb*t1*t187*t188*t227)*t8-8.266666666666665d-3*gammaaa*t
     :           187*t228*t8-8.266666666666665d-3*gammabb*t189*t227*t8+2
     ;           .562666666666666d-5*gammaaa*t187*t188*t228*t6+2.5626666
     <           66666666d-5*gammabb*t188*t189*t227*t6)-8.26666666666666
     =           5d-3*gammaaa*t187*t229*t8-8.266666666666665d-3*gammabb*
     >           t190*t227*t8+4.2369422222222203d-7*gammaaa*gammabb*t10*
     ?           t187*t227*t334*t6+2.562666666666666d-5*gammaaa*t187*t18
     @           8*t229*t6+2.562666666666666d-5*gammabb*t188*t190*t227*t
     1           6-1.366755555555555d-4*gammaaa*gammabb*t10*t187*t188*t2
     2           27)-8.266666666666665d-3*gammaaa*t187*t230*t8-8.2666666
     3           66666665d-3*gammabb*t191*t227*t8+4.2369422222222203d-7*
     4           gammaaa*gammabb*t11*t187*t227*t334*t6+2.562666666666666
     5           d-5*gammaaa*t187*t188*t230*t6+2.562666666666666d-5*gamm
     6           abb*t188*t191*t227*t6-1.366755555555555d-4*gammaaa*gamm
     7           abb*t11*t187*t188*t227)+t128*(-3.04966d-3*t199*t242*t72
     8           -3.04966d-3*t205*t238-3.04966d-3*t135*t199*t226)+1.8600
     9           8522312d-5*t135*t199*t203*t238*t72+1.0d+0*t12*t351+1.0d
     :           +0*t186*t231+1.0d+0*t192*t226)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t117*(1.0d+0*rhob*t113*t40*(1.373568
     1           d-1*t121*t238*t239*t4*t99*taub+1.7777777777777778d+1*t1
     2           20*t121*t227*t99*taub+6.867840000000001d-2*gammabb*t119
     3           *t238*t239*t97*taub+2.6666666666666666d+1*gammabb*t120*
     4           t233*t97*taub+3.4339200000000003d-2*t102*t120*t238*t4*t
     5           aub+8.88888888888889d+0*t102*t117*t227*taub-1.030176d-2
     6           *t122*t239*t372*t99+1.591893886464d-4*t122*t370*t371*t9
     7           9+2.2222222222222224d+1*t119*t120*t272*t99-1.030176d-2*
     8           gammabb*t121*t239*t372*t4*t97+1.591893886464d-4*gammabb
     9           *t121*t370*t371*t4*t97+9.777777777777779d+0*gammabb*t12
     :           0*t121*t365*t97+5.494272d-2*gammabb*t121*t227*t238*t239
     ;           *t97-1.030176d-2*t118*t119*t239*t372*t93+1.591893886464
     <           d-4*t118*t119*t370*t371*t93+3.377777777777778d+1*t118*t
     =           120*t364*t93+1.0988544d-1*t118*t233*t238*t239*t93-5.150
     >           88d-3*gammabb*t101*t120*t372*t4+5.30631295488d-5*gammab
     ?           b*t101*t239*t370*t4-5.15088d-3*t102*t120*t121*t372+5.30
     @           631295488d-5*t102*t121*t239*t370+9.777777777777779d+0*g
     1           ammabb*t101*t117*t365+2.747136d-2*gammabb*t101*t120*t22
     2           7*t238)+1.25d-1*gammabb*t110*t123*t366*t40+2.0d+0*t113*
     3           t240*t40+1.25d-1*gammabb*t110*t111*t240*t40+1.0d+0*rhob
     4           *t113*t123*t357+2.0d+0*rhob*t113*t215*t240+2.0d+0*t113*
     5           t123*t215+1.25d-1*gammabb*t110*t111*t123*t215)+t125*(1.
     6           0d+0*t72*(4.066213333333334d-2*t129*t203*t238*t4*t6*tau
     7           b+8.88888888888889d+0*t128*t129*t227*t6*taub+8.13242666
     8           6666668d-2*t130*t131*t203*t238*t4*taub+2.03310666666666
     9           7d-2*t128*t134*t238*t4*taub+1.7777777777777778d+1*gamma
     :           bb*t128*t129*t233*taub+8.88888888888889d+0*t125*t134*t2
     ;           27*taub+1.7777777777777778d+1*t128*t130*t131*t227*taub-
     <           6.09932d-3*t129*t130*t203*t372*t6-3.04966d-3*t128*t133*
     =           t372*t6+5.580255669360001d-5*t129*t130*t343*t370*t6+1.8
     >           6008522312d-5*t133*t203*t370*t6+1.9555555555555557d+1*g
     ?           ammabb*t126*t128*t365*t6+6.505941333333333d-2*gammabb*t
     @           126*t203*t227*t238*t6-6.09932d-3*t131*t132*t203*t372-6.
     1           09932d-3*t126*t127*t203*t372-3.04966d-3*t128*t130*t134*
     2           t372+5.580255669360001d-5*t131*t132*t343*t370+5.5802556
     3           69360001d-5*t126*t127*t343*t370+1.86008522312d-5*t130*t
     4           134*t203*t370+9.777777777777779d+0*gammabb*t125*t133*t3
     5           65+9.777777777777779d+0*gammabb*t128*t129*t130*t365+1.4
     6           222222222222222d+1*t118*t126*t128*t364+2.22222222222222
     7           24d+1*t119*t128*t131*t272+3.2529706666666663d-2*gammabb
     8           *t129*t130*t203*t227*t238+1.6264853333333332d-2*gammabb
     9           *t128*t133*t227*t238)+1.0d+0*t135*t363+2.0d+0*t226*t242
     :           )+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(3.03111111111
     ;           11105d-2*gammabb*t365*t8*t9-9.396444444444442d-5*gammab
     <           b*t188*t365*t6*t9+4.2369422222222203d-7*t118*t334*t364*
     =           t6*t9-1.366755555555555d-4*t118*t188*t364*t9+3.1d-3*t6*
     >           t8*(3.0311111111111105d-2*gammabb*t1*t365*t8-9.39644444
     ?           4444442d-5*gammabb*t1*t188*t365*t6+4.2369422222222203d-
     @           7*t1*t118*t334*t364*t6-1.366755555555555d-4*t1*t118*t18
     1           8*t364)-1.653333333333333d-2*gammabb*t227*t228*t8+5.125
     2           333333333332d-5*gammabb*t188*t227*t228*t6)+3.0311111111
     3           111105d-2*gammabb*t10*t365*t8-1.653333333333333d-2*gamm
     4           abb*t227*t229*t8-9.396444444444442d-5*gammabb*t10*t188*
     5           t365*t6+4.2369422222222203d-7*t10*t118*t334*t364*t6+5.1
     6           25333333333332d-5*gammabb*t188*t227*t229*t6-1.366755555
     7           555555d-4*t10*t118*t188*t364)+3.0311111111111105d-2*gam
     8           mabb*t11*t365*t8-1.653333333333333d-2*gammabb*t227*t230
     9           *t8-9.396444444444442d-5*gammabb*t11*t188*t365*t6+4.236
     :           9422222222203d-7*t11*t118*t334*t364*t6+5.12533333333333
     ;           2d-5*gammabb*t188*t227*t230*t6-1.366755555555555d-4*t11
     <           *t118*t188*t364)+t110*(5.0d-1*rhob*t112*t40*(6.0d-2*gam
     =           mabb*t105*t4*(6.0d-2*gammabb*t105*t4*(6.0d-2*gammabb*t1
     >           05*t4*(3.0719999999999986d-3*t367*t368*t369*t79+5.86666
     ?           6666666666d-1*gammabb*t105*t365*t79-8.639999999999998d-
     @           2*t118*t232*t364*t79)+3.0719999999999986d-3*t106*t367*t
     1           368*t369+5.866666666666666d-1*gammabb*t105*t106*t365-8.
     2           639999999999998d-2*t106*t118*t232*t364+1.91999999999999
     3           95d-2*t118*t232*t233*t234-3.1999999999999995d-1*gammabb
     4           *t105*t227*t234)+3.0719999999999986d-3*t107*t367*t368*t
     5           369+5.866666666666666d-1*gammabb*t105*t107*t365-8.63999
     6           9999999998d-2*t107*t118*t232*t364+1.9199999999999995d-2
     7           *t118*t232*t233*t235-3.1999999999999995d-1*gammabb*t105
     8           *t227*t235)+3.0719999999999986d-3*t108*t367*t368*t369+5
     9           .866666666666666d-1*gammabb*t105*t108*t365-8.6399999999
     :           99998d-2*t108*t118*t232*t364+1.9199999999999995d-2*t118
     ;           *t232*t233*t236-3.1999999999999995d-1*gammabb*t105*t227
     <           *t236)+1.25d-1*gammabb*t109*t366*t40+1.0d+0*t112*t237*t
     =           40+1.25d-1*gammabb*t111*t237*t40+5.0d-1*rhob*t109*t112*
     >           t357+1.0d+0*rhob*t112*t215*t237+1.0d+0*t109*t112*t215+1
     ?           .25d-1*gammabb*t109*t111*t215)+t128*(-3.04966d-3*t135*t
     @           372*t72-3.04966d-3*t238*t242*t72-3.04966d-3*t238*t243-3
     1           .04966d-3*t135*t226*t238)+1.86008522312d-5*t135*t203*t3
     2           70*t72+t120*(-5.15088d-3*rhob*t113*t123*t372*t40-5.1508
     3           8d-3*rhob*t113*t238*t240*t40-5.15088d-3*t113*t123*t238*
     4           t40-5.15088d-3*t238*t241-5.15088d-3*rhob*t113*t123*t215
     5           *t238)+t110*t111*t117*(1.25d-1*gammabb*t240*t40+1.25d-1
     6           *gammabb*t123*t215)+t110*t111*(1.25d-1*gammabb*t237*t40
     7           +1.25d-1*gammabb*t109*t215)+5.30631295488d-5*rhob*t113*
     8           t123*t239*t370*t40-1.25d-1*gammabb*t110*t117*t123*t366*
     9           t40-1.25d-1*gammabb*t109*t110*t366*t40-1.28772d-3*gamma
     :           bb*t110*t111*t120*t123*t238*t40+1.0d+0*t12*t363+2.0d+0*
     ;           t226*t231)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t91*(1.0d+0*rhoa*t26*t87*(6.8678400
     1           00000001d-2*t200*t95*t98*t99*taua-3.3333333333333337d+0
     2           *t95*t96*t97*taua+3.4339200000000003d-2*gammaaa*t200*t2
     3           52*t97*taua+1.7169600000000002d-2*t102*t95*t96*taua+1.5
     4           91893886464d-4*t100*t199*t2*t341*t99+2.747136d-2*t100*t
     5           187*t200*t99-2.6666666666666666d+0*t187*t96*t97*t98+1.5
     6           91893886464d-4*gammaaa*t199*t341*t95*t97*t98-1.030176d-
     7           2*t199*t2*t200*t97*t98+5.494272d-2*gammaaa*t194*t200*t9
     8           7*t98+1.373568d-2*t102*t187*t96*t98+5.30631295488d-5*t1
     9           02*t199*t2*t200*t98-1.0666666666666666d+1*gammaaa*t194*
     :           t93*t96-5.15088d-3*t101*t199*t2*t96+2.747136d-2*gammaaa
     ;           *t101*t194*t96-2.060352d-2*gammaaa*t199*t200*t93*t95+5.
     <           30631295488d-5*gammaaa*t101*t199*t200*t95+8.241408d-2*t
     =           200*t374*t93*t94+1.591893886464d-4*t199*t252*t341*t93*t
     >           94-2.6666666666666666d+0*t101*t187*t91)+1.0d+0*t253*t26
     ?           *t87+1.0d+0*rhoa*t145*t253*t87-1.25d-1*t103*t26*t84*t85
     @           -1.25d-1*t201*t26*t84-1.25d-1*t103*t145*t84)+t125*(1.0d
     1           +0*t72*(2.033106666666667d-2*t129*t203*t6*t95*taua+4.06
     2           6213333333334d-2*t130*t131*t203*t95*taua+1.016553333333
     3           3335d-2*t128*t134*t95*taua-3.3333333333333337d+0*t128*t
     4           129*t95*taua+5.580255669360001d-5*t129*t130*t199*t2*t34
     5           3*t6+1.86008522312d-5*t133*t199*t2*t203*t6-1.219864d-2*
     6           t126*t199*t2*t203*t6+3.2529706666666663d-2*gammaaa*t126
     7           *t194*t203*t6+1.6264853333333332d-2*t129*t130*t187*t203
     8           *t6+8.132426666666667d-3*t128*t133*t187*t6-5.3333333333
     9           33333d+0*t126*t128*t187*t6+5.580255669360001d-5*t131*t1
     :           32*t199*t2*t343+5.580255669360001d-5*t126*t127*t199*t2*
     ;           t343+1.86008522312d-5*t130*t134*t199*t2*t203-6.09932d-3
     <           *t129*t130*t199*t2*t203+1.6264853333333332d-2*gammaaa*t
     =           129*t130*t194*t203+1.6264853333333332d-2*t131*t132*t187
     >           *t203+1.6264853333333332d-2*t126*t127*t187*t203-3.04966
     ?           d-3*t128*t133*t199*t2+8.132426666666667d-3*gammaaa*t128
     @           *t133*t194-5.333333333333333d+0*gammaaa*t126*t128*t194+
     1           8.132426666666667d-3*t128*t130*t134*t187-2.666666666666
     2           6666d+0*t125*t133*t187-2.6666666666666666d+0*t128*t129*
     3           t130*t187)+1.0d+0*t186*t254)+t2*(1.373568d-2*t103*t26*t
     4           87-5.15088d-3*t202)*t96-5.15088d-3*rhoa*t199*t253*t26*t
     5           87*t96+6.4386d-4*t103*t199*t26*t84*t96-6.4386d-4*gammaa
     6           a*t103*t187*t26*t84*t96+t84*(5.0d-1*rhoa*t26*t86*(6.0d-
     7           2*gammaaa*t2*t75*(6.0d-2*gammaaa*t2*t75*(-3.6d-3*gammaa
     8           a*t193*t195*t95+6.0d-2*gammaaa*t2*t75*(-1.1519999999999
     9           996d-3*t338*t374*t79*t94-1.5999999999999998d-1*t187*t75
     :           *t79+2.879999999999999d-2*gammaaa*t193*t194*t79)-1.1519
     ;           999999999996d-3*t338*t374*t80*t94+9.599999999999997d-3*
     <           t193*t194*t248*t94-1.5999999999999998d-1*t187*t75*t80+2
     =           .879999999999999d-2*gammaaa*t193*t194*t80-1.59999999999
     >           99998d-1*gammaaa*t187*t248*t75+6.0d-2*t195*t2*t75)-3.6d
     ?           -3*gammaaa*t193*t196*t95-1.1519999999999996d-3*t338*t37
     @           4*t81*t94+9.599999999999997d-3*t193*t194*t249*t94-1.599
     1           9999999999998d-1*t187*t75*t81+2.879999999999999d-2*gamm
     2           aaa*t193*t194*t81-1.5999999999999998d-1*gammaaa*t187*t2
     3           49*t75+6.0d-2*t196*t2*t75)-3.6d-3*gammaaa*t193*t197*t95
     4           -1.1519999999999996d-3*t338*t374*t82*t94+9.599999999999
     5           997d-3*t193*t194*t250*t94-1.5999999999999998d-1*t187*t7
     6           5*t82+2.879999999999999d-2*gammaaa*t193*t194*t82-1.5999
     7           999999999998d-1*gammaaa*t187*t250*t75+6.0d-2*t197*t2*t7
     8           5)+5.0d-1*t251*t26*t86+5.0d-1*rhoa*t145*t251*t86-1.25d-
     9           1*t26*t83*t85-1.25d-1*t145*t83-1.25d-1*t198*t26)+t375*t
     :           84*t85*t91+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(-8.2
     ;           66666666666665d-3*t187*t8*t9-1.5888533333333327d-7*gamm
     <           aaa*t194*t334*t6*t9+2.562666666666666d-5*t187*t188*t6*t
     =           9+5.125333333333332d-5*gammaaa*t188*t194*t9+3.1d-3*t6*t
     >           8*(-8.266666666666665d-3*t1*t187*t8-1.5888533333333327d
     ?           -7*gammaaa*t1*t194*t334*t6+2.562666666666666d-5*t1*t187
     @           *t188*t6+5.125333333333332d-5*gammaaa*t1*t188*t194)-8.2
     1           66666666666665d-3*gammaaa*t187*t244*t8+3.1d-3*t189*t2*t
     2           8+2.562666666666666d-5*gammaaa*t187*t188*t244*t6-9.61d-
     3           6*t188*t189*t2*t6)-8.266666666666665d-3*gammaaa*t187*t2
     4           45*t8+3.1d-3*t190*t2*t8-8.266666666666665d-3*t10*t187*t
     5           8-1.5888533333333327d-7*gammaaa*t10*t194*t334*t6+2.5626
     6           66666666666d-5*gammaaa*t187*t188*t245*t6-9.61d-6*t188*t
     7           190*t2*t6+2.562666666666666d-5*t10*t187*t188*t6+5.12533
     8           3333333332d-5*gammaaa*t10*t188*t194)-8.266666666666665d
     9           -3*gammaaa*t187*t246*t8+3.1d-3*t191*t2*t8-8.26666666666
     :           6665d-3*t11*t187*t8-1.5888533333333327d-7*gammaaa*t11*t
     ;           194*t334*t6+2.562666666666666d-5*gammaaa*t187*t188*t246
     <           *t6-9.61d-6*t188*t191*t2*t6+2.562666666666666d-5*t11*t1
     =           87*t188*t6+5.125333333333332d-5*gammaaa*t11*t188*t194)+
     >           5.30631295488d-5*t103*t199*t200*t26*t87*t88+(t373+1.25d
     ?           -1*gammaaa*t251*t26)*t84*t85-3.04966d-3*t128*t199*t254*
     @           t72+1.86008522312d-5*t135*t199*t2*t203*t72+8.1324266666
     1           66667d-3*t128*t135*t187*t72+1.0d+0*t186*t247-3.04966d-3
     2           *t128*t2*t205)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (t125*(1.0d+0*t72*(2.033106666666667
     1           d-2*t129*t2*t203*t4*t6*taua+4.066213333333334d-2*t130*t
     2           131*t2*t203*t4*taua+1.0165533333333335d-2*t128*t134*t2*
     3           t4*taua-3.3333333333333337d+0*t128*t129*t2*t4*taua+5.58
     4           0255669360001d-5*t129*t130*t199*t343*t4*t6+1.8600852231
     5           2d-5*t133*t199*t203*t4*t6-1.219864d-2*t126*t199*t203*t4
     6           *t6+3.2529706666666663d-2*gammaaa*t126*t187*t203*t4*t6+
     7           5.580255669360001d-5*t131*t132*t199*t343*t4+5.580255669
     8           360001d-5*t126*t127*t199*t343*t4+1.86008522312d-5*t130*
     9           t134*t199*t203*t4-6.09932d-3*t129*t130*t199*t203*t4+1.6
     :           264853333333332d-2*gammaaa*t129*t130*t187*t203*t4-3.049
     ;           66d-3*t128*t133*t199*t4+8.132426666666667d-3*gammaaa*t1
     <           28*t133*t187*t4-5.333333333333333d+0*gammaaa*t126*t128*
     =           t187*t4)+1.0d+0*t186*t265)+1.0d+0*t72*(3.1d-3*t6*t8*(3.
     >           1d-3*t6*t8*(-1.5888533333333327d-7*gammaaa*t187*t334*t4
     ?           *t6*t9+5.125333333333332d-5*gammaaa*t187*t188*t4*t9+3.1
     @           d-3*t6*(5.125333333333332d-5*gammaaa*t1*t187*t188*t4-1.
     1           5888533333333327d-7*gammaaa*t1*t187*t334*t4*t6)*t8+3.1d
     2           -3*t189*t4*t8-8.266666666666665d-3*gammaaa*t187*t255*t8
     3           -9.61d-6*t188*t189*t4*t6+2.562666666666666d-5*gammaaa*t
     4           187*t188*t255*t6)+3.1d-3*t190*t4*t8-8.266666666666665d-
     5           3*gammaaa*t187*t256*t8-1.5888533333333327d-7*gammaaa*t1
     6           0*t187*t334*t4*t6-9.61d-6*t188*t190*t4*t6+2.56266666666
     7           6666d-5*gammaaa*t187*t188*t256*t6+5.125333333333332d-5*
     8           gammaaa*t10*t187*t188*t4)+3.1d-3*t191*t4*t8-8.266666666
     9           666665d-3*gammaaa*t187*t257*t8-1.5888533333333327d-7*ga
     :           mmaaa*t11*t187*t334*t4*t6-9.61d-6*t188*t191*t4*t6+2.562
     ;           666666666666d-5*gammaaa*t187*t188*t257*t6+5.12533333333
     <           3332d-5*gammaaa*t11*t187*t188*t4)+1.86008522312d-5*t135
     =           *t199*t203*t4*t72-3.04966d-3*t128*t199*t265*t72-3.04966
     >           d-3*t128*t205*t4+1.0d+0*t186*t258)*wght+Cmat2(iq,D2_RA_
     ?           GBB)
              Cmat2(iq,D2_RB_GAA) = (t125*(1.0d+0*t72*(2.033106666666667
     1           d-2*t129*t2*t203*t4*t6*taub+4.066213333333334d-2*t130*t
     2           131*t2*t203*t4*taub+1.0165533333333335d-2*t128*t134*t2*
     3           t4*taub-3.3333333333333337d+0*t128*t129*t2*t4*taub+5.58
     4           0255669360001d-5*t129*t130*t2*t238*t343*t6+1.8600852231
     5           2d-5*t133*t2*t203*t238*t6-1.219864d-2*t126*t2*t203*t238
     6           *t6+3.2529706666666663d-2*gammabb*t126*t2*t203*t227*t6+
     7           5.580255669360001d-5*t131*t132*t2*t238*t343+5.580255669
     8           360001d-5*t126*t127*t2*t238*t343+1.86008522312d-5*t130*
     9           t134*t2*t203*t238-6.09932d-3*t129*t130*t2*t203*t238-3.0
     :           4966d-3*t128*t133*t2*t238+1.6264853333333332d-2*gammabb
     ;           *t129*t130*t2*t203*t227+8.132426666666667d-3*gammabb*t1
     <           28*t133*t2*t227-5.333333333333333d+0*gammabb*t126*t128*
     =           t2*t227)+1.0d+0*t226*t254)+1.0d+0*t72*(3.1d-3*t6*t8*(3.
     >           1d-3*t6*t8*(-1.5888533333333327d-7*gammabb*t2*t227*t334
     ?           *t6*t9+5.125333333333332d-5*gammabb*t188*t2*t227*t9+3.1
     @           d-3*t6*(5.125333333333332d-5*gammabb*t1*t188*t2*t227-1.
     1           5888533333333327d-7*gammabb*t1*t2*t227*t334*t6)*t8-8.26
     2           6666666666665d-3*gammabb*t227*t244*t8+3.1d-3*t2*t228*t8
     3           +2.562666666666666d-5*gammabb*t188*t227*t244*t6-9.61d-6
     4           *t188*t2*t228*t6)-8.266666666666665d-3*gammabb*t227*t24
     5           5*t8+3.1d-3*t2*t229*t8-1.5888533333333327d-7*gammabb*t1
     6           0*t2*t227*t334*t6+2.562666666666666d-5*gammabb*t188*t22
     7           7*t245*t6-9.61d-6*t188*t2*t229*t6+5.125333333333332d-5*
     8           gammabb*t10*t188*t2*t227)-8.266666666666665d-3*gammabb*
     9           t227*t246*t8+3.1d-3*t2*t230*t8-1.5888533333333327d-7*ga
     :           mmabb*t11*t2*t227*t334*t6+2.562666666666666d-5*gammabb*
     ;           t188*t227*t246*t6-9.61d-6*t188*t2*t230*t6+5.12533333333
     <           3332d-5*gammabb*t11*t188*t2*t227)-3.04966d-3*t128*t238*
     =           t254*t72+1.86008522312d-5*t135*t2*t203*t238*t72+1.0d+0*
     >           t226*t247-3.04966d-3*t128*t2*t243)*wght+Cmat2(iq,D2_RB_
     ?           GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t117*(1.0d+0*rhob*t113*t40*(6.86784
     1           0000000001d-2*t119*t121*t239*t99*taub+3.433920000000000
     2           3d-2*gammabb*t239*t263*t97*taub-3.3333333333333337d+0*t
     3           119*t120*t97*taub+1.7169600000000002d-2*t102*t119*t120*
     4           taub+1.591893886464d-4*t122*t238*t371*t4*t99+2.747136d-
     5           2*t122*t227*t239*t99-1.030176d-2*t121*t238*t239*t4*t97+
     6           1.591893886464d-4*gammabb*t119*t121*t238*t371*t97+5.494
     7           272d-2*gammabb*t121*t233*t239*t97-2.6666666666666666d+0
     8           *t120*t121*t227*t97+8.241408d-2*t118*t239*t377*t93+1.59
     9           1893886464d-4*t118*t238*t263*t371*t93-2.060352d-2*gamma
     :           bb*t119*t238*t239*t93-1.0666666666666666d+1*gammabb*t12
     ;           0*t233*t93+5.30631295488d-5*t102*t121*t238*t239*t4-5.15
     <           088d-3*t101*t120*t238*t4+5.30631295488d-5*gammabb*t101*
     =           t119*t238*t239+2.747136d-2*gammabb*t101*t120*t233+1.373
     >           568d-2*t102*t120*t121*t227-2.6666666666666666d+0*t101*t
     ?           117*t227)+1.0d+0*t113*t264*t40-1.25d-1*t110*t240*t40-1.
     @           25d-1*t110*t111*t123*t40+1.0d+0*rhob*t113*t215*t264-1.2
     1           5d-1*t110*t123*t215)+t125*(1.0d+0*t72*(2.03310666666666
     2           7d-2*t119*t129*t203*t6*taub+4.066213333333334d-2*t119*t
     3           130*t131*t203*taub+1.0165533333333335d-2*t119*t128*t134
     4           *taub-3.3333333333333337d+0*t119*t128*t129*taub+5.58025
     5           5669360001d-5*t129*t130*t238*t343*t4*t6+1.86008522312d-
     6           5*t133*t203*t238*t4*t6-1.219864d-2*t126*t203*t238*t4*t6
     7           +3.2529706666666663d-2*gammabb*t126*t203*t233*t6+1.6264
     8           853333333332d-2*t129*t130*t203*t227*t6+8.13242666666666
     9           7d-3*t128*t133*t227*t6-5.333333333333333d+0*t126*t128*t
     :           227*t6+5.580255669360001d-5*t131*t132*t238*t343*t4+5.58
     ;           0255669360001d-5*t126*t127*t238*t343*t4+1.86008522312d-
     <           5*t130*t134*t203*t238*t4-6.09932d-3*t129*t130*t203*t238
     =           *t4-3.04966d-3*t128*t133*t238*t4+1.6264853333333332d-2*
     >           gammabb*t129*t130*t203*t233+8.132426666666667d-3*gammab
     ?           b*t128*t133*t233-5.333333333333333d+0*gammabb*t126*t128
     @           *t233+1.6264853333333332d-2*t131*t132*t203*t227+1.62648
     1           53333333332d-2*t126*t127*t203*t227+8.132426666666667d-3
     2           *t128*t130*t134*t227-2.6666666666666666d+0*t125*t133*t2
     3           27-2.6666666666666666d+0*t128*t129*t130*t227)+1.0d+0*t2
     4           26*t265)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(-8.266
     5           666666666665d-3*t227*t8*t9-1.5888533333333327d-7*gammab
     6           b*t233*t334*t6*t9+2.562666666666666d-5*t188*t227*t6*t9+
     7           5.125333333333332d-5*gammabb*t188*t233*t9+3.1d-3*t6*t8*
     8           (-8.266666666666665d-3*t1*t227*t8-1.5888533333333327d-7
     9           *gammabb*t1*t233*t334*t6+2.562666666666666d-5*t1*t188*t
     :           227*t6+5.125333333333332d-5*gammabb*t1*t188*t233)+3.1d-
     ;           3*t228*t4*t8-8.266666666666665d-3*gammabb*t227*t255*t8-
     <           9.61d-6*t188*t228*t4*t6+2.562666666666666d-5*gammabb*t1
     =           88*t227*t255*t6)+3.1d-3*t229*t4*t8-8.266666666666665d-3
     >           *gammabb*t227*t256*t8-8.266666666666665d-3*t10*t227*t8-
     ?           9.61d-6*t188*t229*t4*t6-1.5888533333333327d-7*gammabb*t
     @           10*t233*t334*t6+2.562666666666666d-5*gammabb*t188*t227*
     1           t256*t6+2.562666666666666d-5*t10*t188*t227*t6+5.1253333
     2           33333332d-5*gammabb*t10*t188*t233)+3.1d-3*t230*t4*t8-8.
     3           266666666666665d-3*gammabb*t227*t257*t8-8.2666666666666
     4           65d-3*t11*t227*t8-9.61d-6*t188*t230*t4*t6-1.58885333333
     5           33327d-7*gammabb*t11*t233*t334*t6+2.562666666666666d-5*
     6           gammabb*t188*t227*t257*t6+2.562666666666666d-5*t11*t188
     7           *t227*t6+5.125333333333332d-5*gammabb*t11*t188*t233)+t1
     8           10*(5.0d-1*rhob*t112*t40*(6.0d-2*gammabb*t105*t4*(6.0d-
     9           2*gammabb*t105*t4*(6.0d-2*gammabb*t105*t4*(-1.151999999
     :           9999996d-3*t118*t368*t377*t79+2.879999999999999d-2*gamm
     ;           abb*t232*t233*t79-1.5999999999999998d-1*t105*t227*t79)+
     <           6.0d-2*t105*t234*t4-1.1519999999999996d-3*t106*t118*t36
     =           8*t377+9.599999999999997d-3*t118*t232*t233*t259-1.59999
     >           99999999998d-1*gammabb*t105*t227*t259-3.6d-3*gammabb*t1
     ?           19*t232*t234+2.879999999999999d-2*gammabb*t106*t232*t23
     @           3-1.5999999999999998d-1*t105*t106*t227)+6.0d-2*t105*t23
     1           5*t4-1.1519999999999996d-3*t107*t118*t368*t377+9.599999
     2           999999997d-3*t118*t232*t233*t260-1.5999999999999998d-1*
     3           gammabb*t105*t227*t260-3.6d-3*gammabb*t119*t232*t235+2.
     4           879999999999999d-2*gammabb*t107*t232*t233-1.59999999999
     5           99998d-1*t105*t107*t227)+6.0d-2*t105*t236*t4-1.15199999
     6           99999996d-3*t108*t118*t368*t377+9.599999999999997d-3*t1
     7           18*t232*t233*t261-1.5999999999999998d-1*gammabb*t105*t2
     8           27*t261-3.6d-3*gammabb*t119*t232*t236+2.879999999999999
     9           d-2*gammabb*t108*t232*t233-1.5999999999999998d-1*t105*t
     :           108*t227)+5.0d-1*t112*t262*t40-1.25d-1*t237*t40-1.25d-1
     ;           *t109*t111*t40+5.0d-1*rhob*t112*t215*t262-1.25d-1*t109*
     <           t215)+1.86008522312d-5*t135*t203*t238*t4*t72-3.04966d-3
     =           *t128*t238*t265*t72+8.132426666666667d-3*t128*t135*t227
     >           *t72+t110*t111*(1.25d-1*gammabb*t262*t40+t376)+t120*t4*
     ?           (1.373568d-2*t113*t123*t40-5.15088d-3*t241)-5.15088d-3*
     @           rhob*t113*t120*t238*t264*t40+5.30631295488d-5*t113*t114
     1           *t123*t238*t239*t40+6.4386d-4*t110*t120*t123*t238*t40-6
     2           .4386d-4*gammabb*t110*t120*t123*t227*t40-3.04966d-3*t12
     3           8*t243*t4+t110*t111*t117*t378+1.0d+0*t226*t258)*wght+Cm
     4           at2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (1.0d+0*rhoa*t26*t87*t91*(1.5918938
     1           86464d-4*t100*t341*t95*t99-2.060352d-2*t200*t95*t97*t98
     2           +1.591893886464d-4*gammaaa*t252*t341*t97*t98+5.30631295
     3           488d-5*t102*t200*t95*t98+2*t93*t95*t96-1.030176d-2*t101
     4           *t95*t96+1.591893886464d-4*t341*t93*t94/rhoa**1.0666666
     5           666666666d+1-4.120704d-2*gammaaa*t200*t252*t93+5.306312
     6           95488d-5*gammaaa*t101*t200*t252)-1.030176d-2*t253*t26*t
     7           87*t88*t96+1.28772d-3*t103*t2*t26*t84*t96+t84*(5.0d-1*r
     8           hoa*t26*t86*(6.0d-2*gammaaa*t2*t75*(6.0d-2*gammaaa*t2*t
     9           75*(6.0d-2*gammaaa*t2*t75*(4.32d-4*gammaaa*t252*t338*t7
     :           9-7.2d-3*t193*t79*t95)-7.2d-3*t193*t80*t95-7.2d-3*gamma
     ;           aa*t193*t248*t95+4.32d-4*gammaaa*t252*t338*t80+1.2d-1*t
     <           2*t248*t75)-7.2d-3*t193*t81*t95-7.2d-3*gammaaa*t193*t24
     =           9*t95+4.32d-4*gammaaa*t252*t338*t81+1.2d-1*t2*t249*t75)
     >           -7.2d-3*t193*t82*t95-7.2d-3*gammaaa*t193*t250*t95+4.32d
     ?           -4*gammaaa*t252*t338*t82+1.2d-1*t2*t250*t75)-2.5d-1*t25
     @           1*t26)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(3.1d-3*t
     1           6*t8*(5.9582d-8*t1*t334*t6*t95-1.9219999999999998d-5*t1
     2           *t188*t95)+5.9582d-8*t334*t6*t9*t95-1.9219999999999998d
     3           -5*t188*t9*t95+6.2d-3*t2*t244*t8-1.9219999999999998d-5*
     4           t188*t2*t244*t6)+5.9582d-8*t10*t334*t6*t95-1.9219999999
     5           999998d-5*t10*t188*t95+6.2d-3*t2*t245*t8-1.921999999999
     6           9998d-5*t188*t2*t245*t6)+5.9582d-8*t11*t334*t6*t95-1.92
     7           19999999999998d-5*t11*t188*t95+6.2d-3*t2*t246*t8-1.9219
     8           999999999998d-5*t188*t2*t246*t6)+1.0d+0*t125*t72*(5.580
     9           255669360001d-5*t129*t130*t343*t6*t95+1.86008522312d-5*
     :           t133*t203*t6*t95-2.439728d-2*t126*t203*t6*t95+5.5802556
     ;           69360001d-5*t131*t132*t343*t95+5.580255669360001d-5*t12
     <           6*t127*t343*t95+1.86008522312d-5*t130*t134*t203*t95-1.2
     =           19864d-2*t129*t130*t203*t95-6.09932d-3*t128*t133*t95+2*
     >           t126*t128*t95)+1.86008522312d-5*t135*t203*t72*t95-2.5d-
     ?           1*t253*t26*t84*t91+5.30631295488d-5*t103*t200*t26*t269*
     @           t87-6.09932d-3*t128*t2*t254*t72)*wght+Cmat2(iq,D2_GAA_G
     1           AA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = (1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t
     1           6*t8*(5.9582d-8*t2*t334*t4*t6*t9-1.9219999999999998d-5*
     2           t188*t2*t4*t9+3.1d-3*t6*(5.9582d-8*t1*t2*t334*t4*t6-1.9
     3           219999999999998d-5*t1*t188*t2*t4)*t8+3.1d-3*t244*t4*t8+
     4           3.1d-3*t2*t255*t8-9.61d-6*t188*t244*t4*t6-9.61d-6*t188*
     5           t2*t255*t6)+3.1d-3*t245*t4*t8+3.1d-3*t2*t256*t8+5.9582d
     6           -8*t10*t2*t334*t4*t6-9.61d-6*t188*t245*t4*t6-9.61d-6*t1
     7           88*t2*t256*t6-1.9219999999999998d-5*t10*t188*t2*t4)+3.1
     8           d-3*t246*t4*t8+3.1d-3*t2*t257*t8+5.9582d-8*t11*t2*t334*
     9           t4*t6-9.61d-6*t188*t246*t4*t6-9.61d-6*t188*t2*t257*t6-1
     :           .9219999999999998d-5*t11*t188*t2*t4)+1.0d+0*t125*(5.580
     ;           255669360001d-5*t129*t130*t2*t343*t4*t6+1.86008522312d-
     <           5*t133*t2*t203*t4*t6-2.439728d-2*t126*t2*t203*t4*t6+5.5
     =           80255669360001d-5*t131*t132*t2*t343*t4+5.58025566936000
     >           1d-5*t126*t127*t2*t343*t4+1.86008522312d-5*t130*t134*t2
     ?           *t203*t4-1.219864d-2*t129*t130*t2*t203*t4-6.09932d-3*t1
     @           28*t133*t2*t4+2*t126*t128*t2*t4)*t72-3.04966d-3*t128*t2
     1           54*t4*t72+1.86008522312d-5*t135*t2*t203*t4*t72-3.04966d
     2           -3*t128*t2*t265*t72)*wght+Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (1.0d+0*rhob*t113*t117*t40*(1.59189
     1           3886464d-4*t119*t122*t371*t99+1.591893886464d-4*gammabb
     2           *t121*t263*t371*t97-2.060352d-2*t119*t121*t239*t97+1.59
     3           1893886464d-4*t118*t371*t93/rhob**1.0666666666666666d+1
     4           -4.120704d-2*gammabb*t239*t263*t93+2*t119*t120*t93+5.30
     5           631295488d-5*gammabb*t101*t239*t263+5.30631295488d-5*t1
     6           02*t119*t121*t239-1.030176d-2*t101*t119*t120)+1.0d+0*t7
     7           2*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(5.9582d-8*t119*t334*t6*t
     8           9-1.9219999999999998d-5*t119*t188*t9+3.1d-3*t6*(5.9582d
     9           -8*t1*t119*t334*t6-1.9219999999999998d-5*t1*t119*t188)*
     :           t8+6.2d-3*t255*t4*t8-1.9219999999999998d-5*t188*t255*t4
     ;           *t6)+6.2d-3*t256*t4*t8-1.9219999999999998d-5*t188*t256*
     <           t4*t6+5.9582d-8*t10*t119*t334*t6-1.9219999999999998d-5*
     =           t10*t119*t188)+6.2d-3*t257*t4*t8-1.9219999999999998d-5*
     >           t188*t257*t4*t6+5.9582d-8*t11*t119*t334*t6-1.9219999999
     ?           999998d-5*t11*t119*t188)+t110*(5.0d-1*rhob*t112*t40*(6.
     @           0d-2*gammabb*t105*t4*(6.0d-2*gammabb*t105*t4*(6.0d-2*ga
     1           mmabb*t105*t4*(4.32d-4*gammabb*t263*t368*t79-7.2d-3*t11
     2           9*t232*t79)+1.2d-1*t105*t259*t4+4.32d-4*gammabb*t106*t2
     3           63*t368-7.2d-3*gammabb*t119*t232*t259-7.2d-3*t106*t119*
     4           t232)+1.2d-1*t105*t260*t4+4.32d-4*gammabb*t107*t263*t36
     5           8-7.2d-3*gammabb*t119*t232*t260-7.2d-3*t107*t119*t232)+
     6           1.2d-1*t105*t261*t4+4.32d-4*gammabb*t108*t263*t368-7.2d
     7           -3*gammabb*t119*t232*t261-7.2d-3*t108*t119*t232)-2.5d-1
     8           *t262*t40)+1.0d+0*t125*(5.580255669360001d-5*t119*t129*
     9           t130*t343*t6+1.86008522312d-5*t119*t133*t203*t6-2.43972
     :           8d-2*t119*t126*t203*t6+5.580255669360001d-5*t119*t131*t
     ;           132*t343+5.580255669360001d-5*t119*t126*t127*t343+1.860
     <           08522312d-5*t119*t130*t134*t203-1.219864d-2*t119*t129*t
     =           130*t203-6.09932d-3*t119*t128*t133+2*t119*t126*t128)*t7
     >           2-6.09932d-3*t128*t265*t4*t72+1.86008522312d-5*t119*t13
     ?           5*t203*t72+1.28772d-3*t110*t120*t123*t4*t40+5.306312954
     @           88d-5*t113*t123*t239*t275*t40-1.030176d-2*t113*t114*t12
     1           0*t264*t40-2.5d-1*t110*t117*t264*t40)*wght+Cmat2(iq,D2_
     2           GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t91*(1.0d+0*rhoa*t26*t87*(1.373568d-
     1           1*t200*t269*t98*t99*taua-1.3333333333333333d+1*t269*t96
     2           *t99*taua+6.867840000000001d-2*gammaaa*t200*t268*t97*ta
     3           ua+3.4339200000000003d-2*t102*t269*t96*taua-6.666666666
     4           666667d+0*t2*t96*t98*t99-4.120704d-2*t199*t200*t88*t98*
     5           t99+3.183787772928d-4*t100*t199*t341*t88*t99+3.43392000
     6           00000003d-2*t100*t2*t200*t99+8.928192d-2*gammaaa*t200*t
     7           95*t97*t98+3.183787772928d-4*gammaaa*t199*t269*t341*t97
     8           *t98+1.7169600000000002d-2*t102*t2*t96*t98+1.0612625909
     9           76d-4*t102*t199*t200*t88*t98-8.666666666666666d+0*gamma
     :           aa*t95*t96*t97-2.060352d-2*gammaaa*t199*t200*t269*t97+4
     ;           .464096d-2*gammaaa*t101*t95*t96-1.030176d-2*t102*t199*t
     <           88*t96+3.183787772928d-4*t199*t268*t341*t93*t94+1.44224
     =           64000000002d-1*t200*t252*t93*t94-3.3333333333333337d+0*
     >           t102*t2*t91+1.061262590976d-4*gammaaa*t101*t199*t200*t2
     ?           69)+1.0d+0*t26*t270*t87+1.0d+0*rhoa*t145*t270*t87+1.25d
     @           -1*gammaaa*t103*t26*t267*t85+1.25d-1*gammaaa*t201*t26*t
     1           267+1.25d-1*gammaaa*t103*t145*t267)+t125*(1.0d+0*t72*(4
     2           .066213333333334d-2*t129*t203*t269*t6*taua+8.1324266666
     3           66668d-2*t130*t131*t203*t269*taua+2.033106666666667d-2*
     4           t128*t134*t269*taua-1.3333333333333333d+1*t128*t131*t26
     5           9*taua+6.505941333333333d-2*gammaaa*t126*t203*t6*t95+3.
     6           2529706666666663d-2*gammaaa*t129*t130*t203*t95+1.626485
     7           3333333332d-2*gammaaa*t128*t133*t95-5.333333333333333d+
     8           0*gammaaa*t128*t129*t95+1.1160511338720001d-4*t129*t130
     9           *t199*t343*t6*t88+3.72017044624d-5*t133*t199*t203*t6*t8
     :           8-1.219864d-2*t129*t199*t203*t6*t88+1.1160511338720001d
     ;           -4*t131*t132*t199*t343*t88+1.1160511338720001d-4*t126*t
     <           127*t199*t343*t88+3.72017044624d-5*t130*t134*t199*t203*
     =           t88-2.439728d-2*t130*t131*t199*t203*t88-6.09932d-3*t128
     >           *t134*t199*t88+2.033106666666667d-2*t129*t130*t2*t203*t
     ?           6+1.0165533333333335d-2*t128*t133*t2*t6-3.3333333333333
     @           337d+0*t128*t129*t2*t6+2.033106666666667d-2*t131*t132*t
     1           2*t203+2.033106666666667d-2*t126*t127*t2*t203+1.0165533
     2           333333335d-2*t128*t130*t134*t2-3.3333333333333337d+0*t1
     3           25*t134*t2-6.666666666666667d+0*t128*t130*t131*t2)+1.0d
     4           +0*t186*t271)+(1.7169600000000002d-2*t103*t26*t87-1.030
     5           176d-2*t202)*t88*t96-5.15088d-3*rhoa*t199*t26*t270*t87*
     6           t96-1.28772d-3*gammaaa*t103*t2*t26*t84*t96-6.4386d-4*ga
     7           mmaaa*t103*t199*t26*t267*t96+1.25d-1*gammaaa*t26*t270*t
     8           84*t85*t91-1.25d-1*gammaaa*t103*t26*t267*t85*t91+3.7201
     9           7044624d-5*t135*t199*t203*t72*t88-6.09932d-3*t128*t205*
     :           t88+1.061262590976d-4*t103*t13*t199*t200*t26*t87+t267*(
     ;           -5.0d-1*t26*t83*t86-5.0d-1*rhoa*t145*t83*t86-5.0d-1*rho
     <           a*t198*t26*t86)-1.25d-1*gammaaa*t26*t267*t83*t85+(1.0d+
     =           0*t26*t83+1.0d+0*rhoa*t145*t83+1.0d+0*rhoa*t198*t26)*t8
     >           4-3.04966d-3*t128*t199*t271*t72+1.0165533333333335d-2*t
     ?           128*t135*t2*t72)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = (t125*(1.0d+0*t72*(4.066213333333334d
     1           -2*t114*t129*t2*t203*t6*taua+8.132426666666668d-2*t114*
     2           t130*t131*t2*t203*taua+2.033106666666667d-2*t114*t128*t
     3           134*t2*taua-1.3333333333333333d+1*t114*t128*t131*t2*tau
     4           a+1.1160511338720001d-4*t114*t129*t130*t199*t343*t6+3.7
     5           2017044624d-5*t114*t133*t199*t203*t6-1.219864d-2*t114*t
     6           129*t199*t203*t6+6.505941333333333d-2*gammaaa*t114*t126
     7           *t187*t203*t6+1.1160511338720001d-4*t114*t131*t132*t199
     8           *t343+1.1160511338720001d-4*t114*t126*t127*t199*t343+3.
     9           72017044624d-5*t114*t130*t134*t199*t203-2.439728d-2*t11
     :           4*t130*t131*t199*t203+3.2529706666666663d-2*gammaaa*t11
     ;           4*t129*t130*t187*t203-6.09932d-3*t114*t128*t134*t199+1.
     <           6264853333333332d-2*gammaaa*t114*t128*t133*t187-5.33333
     =           3333333333d+0*gammaaa*t114*t128*t129*t187)+1.0d+0*t186*
     >           t277)-3.04966d-3*t128*t199*t277*t72+3.72017044624d-5*t1
     ?           14*t135*t199*t203*t72-6.09932d-3*t114*t128*t205)*wght+M
     @           mat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = (t125*(1.0d+0*t72*(4.066213333333334d
     1           -2*t129*t203*t4*t6*t88*taub+8.132426666666668d-2*t130*t
     2           131*t203*t4*t88*taub+2.033106666666667d-2*t128*t134*t4*
     3           t88*taub-1.3333333333333333d+1*t128*t131*t4*t88*taub+1.
     4           1160511338720001d-4*t129*t130*t238*t343*t6*t88+3.720170
     5           44624d-5*t133*t203*t238*t6*t88-1.219864d-2*t129*t203*t2
     6           38*t6*t88+6.505941333333333d-2*gammabb*t126*t203*t227*t
     7           6*t88+1.1160511338720001d-4*t131*t132*t238*t343*t88+1.1
     8           160511338720001d-4*t126*t127*t238*t343*t88+3.7201704462
     9           4d-5*t130*t134*t203*t238*t88-2.439728d-2*t130*t131*t203
     :           *t238*t88-6.09932d-3*t128*t134*t238*t88+3.2529706666666
     ;           663d-2*gammabb*t129*t130*t203*t227*t88+1.62648533333333
     <           32d-2*gammabb*t128*t133*t227*t88-5.333333333333333d+0*g
     =           ammabb*t128*t129*t227*t88)+1.0d+0*t226*t271)+3.72017044
     >           624d-5*t135*t203*t238*t72*t88-6.09932d-3*t128*t243*t88-
     ?           3.04966d-3*t128*t238*t271*t72)*wght+Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t117*(1.0d+0*rhob*t113*t40*(1.373568
     1           d-1*t121*t239*t275*t99*taub-1.3333333333333333d+1*t120*
     2           t275*t99*taub+6.867840000000001d-2*gammabb*t239*t274*t9
     3           7*taub+3.4339200000000003d-2*t102*t120*t275*taub+3.4339
     4           200000000003d-2*t122*t239*t4*t99-6.666666666666667d+0*t
     5           120*t121*t4*t99+3.183787772928d-4*t114*t122*t238*t371*t
     6           99-4.120704d-2*t114*t121*t238*t239*t99+3.183787772928d-
     7           4*gammabb*t121*t238*t275*t371*t97-2.060352d-2*gammabb*t
     8           238*t239*t275*t97+8.928192d-2*gammabb*t119*t121*t239*t9
     9           7-8.666666666666666d+0*gammabb*t119*t120*t97+3.18378777
     :           2928d-4*t118*t238*t274*t371*t93+1.4422464000000002d-1*t
     ;           118*t239*t263*t93+1.7169600000000002d-2*t102*t120*t121*
     <           t4-3.3333333333333337d+0*t102*t117*t4+1.061262590976d-4
     =           *gammabb*t101*t238*t239*t275+1.061262590976d-4*t102*t11
     >           4*t121*t238*t239-1.030176d-2*t102*t114*t120*t238+4.4640
     ?           96d-2*gammabb*t101*t119*t120)+1.0d+0*t113*t276*t40+1.25
     @           d-1*gammabb*t240*t273*t40+1.25d-1*gammabb*t111*t123*t27
     1           3*t40+1.0d+0*rhob*t113*t215*t276+1.25d-1*gammabb*t123*t
     2           215*t273)+t125*(1.0d+0*t72*(4.066213333333334d-2*t129*t
     3           203*t275*t6*taub+8.132426666666668d-2*t130*t131*t203*t2
     4           75*taub+2.033106666666667d-2*t128*t134*t275*taub-1.3333
     5           333333333333d+1*t128*t131*t275*taub+2.033106666666667d-
     6           2*t129*t130*t203*t4*t6+1.0165533333333335d-2*t128*t133*
     7           t4*t6-3.3333333333333337d+0*t128*t129*t4*t6+1.116051133
     8           8720001d-4*t114*t129*t130*t238*t343*t6+3.72017044624d-5
     9           *t114*t133*t203*t238*t6-1.219864d-2*t114*t129*t203*t238
     :           *t6+6.505941333333333d-2*gammabb*t119*t126*t203*t6+2.03
     ;           3106666666667d-2*t131*t132*t203*t4+2.033106666666667d-2
     <           *t126*t127*t203*t4+1.0165533333333335d-2*t128*t130*t134
     =           *t4-3.3333333333333337d+0*t125*t134*t4-6.66666666666666
     >           7d+0*t128*t130*t131*t4+1.1160511338720001d-4*t114*t131*
     ?           t132*t238*t343+1.1160511338720001d-4*t114*t126*t127*t23
     @           8*t343+3.72017044624d-5*t114*t130*t134*t203*t238-2.4397
     1           28d-2*t114*t130*t131*t203*t238-6.09932d-3*t114*t128*t13
     2           4*t238+3.2529706666666663d-2*gammabb*t119*t129*t130*t20
     3           3+1.6264853333333332d-2*gammabb*t119*t128*t133-5.333333
     4           333333333d+0*gammabb*t119*t128*t129)+1.0d+0*t226*t277)+
     5           1.0165533333333335d-2*t128*t135*t4*t72-3.04966d-3*t128*
     6           t238*t277*t72+3.72017044624d-5*t114*t135*t203*t238*t72+
     7           t273*(-5.0d-1*rhob*t112*t237*t40-5.0d-1*t109*t112*t40-5
     8           .0d-1*rhob*t109*t112*t215)+t110*(1.0d+0*rhob*t237*t40+1
     9           .0d+0*t109*t40+1.0d+0*rhob*t109*t215)+t114*t120*(1.7169
     :           600000000002d-2*t113*t123*t40-1.030176d-2*t241)-1.28772
     ;           d-3*gammabb*t110*t120*t123*t4*t40-5.15088d-3*rhob*t113*
     <           t120*t238*t276*t40+1.25d-1*gammabb*t110*t111*t117*t276*
     =           t40-6.4386d-4*gammabb*t120*t123*t238*t273*t40-1.25d-1*g
     >           ammabb*t111*t117*t123*t273*t40-1.25d-1*gammabb*t109*t11
     ?           1*t273*t40+1.061262590976d-4*t113*t123*t238*t239*t27*t4
     @           0-6.09932d-3*t114*t128*t243)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (1.0d+0*rhoa*t26*t87*t91*(-4.120704d
     1           -2*t200*t269*t98*t99+3.183787772928d-4*t100*t269*t341*t
     2           99+3.183787772928d-4*gammaaa*t268*t341*t97*t98-2.060352
     3           d-2*t200*t269*t97*t98+1.061262590976d-4*t102*t200*t269*
     4           t98+2.0d+0*t269*t96*t97-2.060352d-2*gammaaa*t200*t268*t
     5           97-1.030176d-2*t102*t269*t96-1.030176d-2*t101*t269*t96+
     6           3.183787772928d-4*t341*t93*t94/rhoa**9.666666666666666d
     7           +0-4.120704d-2*gammaaa*t200*t268*t93+1.061262590976d-4*
     8           gammaaa*t101*t200*t268)-5.15088d-3*t26*t270*t87*t88*t96
     9           +1.28772d-3*t103*t26*t84*t88*t96-1.030176d-2*t13*t253*t
     :           26*t87*t96-6.4386d-4*gammaaa*t103*t2*t26*t267*t96-1.25d
     ;           -1*t26*t270*t84*t91+t267*t375*t91-6.09932d-3*t128*t254*
     <           t72*t88+1.061262590976d-4*t103*t200*t26*t379*t87+t267*(
     =           t373-5.0d-1*rhoa*t251*t26*t86)+1.0d+0*rhoa*t251*t26*t84
     >           +1.0d+0*t125*(1.1160511338720001d-4*t129*t130*t269*t343
     ?           *t6+3.72017044624d-5*t133*t203*t269*t6-1.219864d-2*t129
     @           *t203*t269*t6-2.439728d-2*t126*t203*t269*t6+1.116051133
     1           8720001d-4*t131*t132*t269*t343+1.1160511338720001d-4*t1
     2           26*t127*t269*t343+3.72017044624d-5*t130*t134*t203*t269-
     3           2.439728d-2*t130*t131*t203*t269-1.219864d-2*t129*t130*t
     4           203*t269-6.09932d-3*t128*t134*t269-6.09932d-3*t128*t133
     5           *t269+2.0d+0*t128*t129*t269)*t72-3.04966d-3*t128*t2*t27
     6           1*t72+3.72017044624d-5*t135*t203*t269*t72)*wght+Mmat2(i
     7           q,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = (1.0d+0*t125*(1.1160511338720001d-4*
     1           t114*t129*t130*t2*t343*t6+3.72017044624d-5*t114*t133*t2
     2           *t203*t6-1.219864d-2*t114*t129*t2*t203*t6-2.439728d-2*t
     3           114*t126*t2*t203*t6+1.1160511338720001d-4*t114*t131*t13
     4           2*t2*t343+1.1160511338720001d-4*t114*t126*t127*t2*t343+
     5           3.72017044624d-5*t114*t130*t134*t2*t203-2.439728d-2*t11
     6           4*t130*t131*t2*t203-1.219864d-2*t114*t129*t130*t2*t203-
     7           6.09932d-3*t114*t128*t134*t2-6.09932d-3*t114*t128*t133*
     8           t2+2.0d+0*t114*t128*t129*t2)*t72-3.04966d-3*t128*t2*t27
     9           7*t72-6.09932d-3*t114*t128*t254*t72+3.72017044624d-5*t1
     :           14*t135*t2*t203*t72)*wght+Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = (1.0d+0*t125*t72*(1.1160511338720001
     1           d-4*t129*t130*t343*t4*t6*t88+3.72017044624d-5*t133*t203
     2           *t4*t6*t88-1.219864d-2*t129*t203*t4*t6*t88-2.439728d-2*
     3           t126*t203*t4*t6*t88+1.1160511338720001d-4*t131*t132*t34
     4           3*t4*t88+1.1160511338720001d-4*t126*t127*t343*t4*t88+3.
     5           72017044624d-5*t130*t134*t203*t4*t88-2.439728d-2*t130*t
     6           131*t203*t4*t88-1.219864d-2*t129*t130*t203*t4*t88-6.099
     7           32d-3*t128*t134*t4*t88-6.09932d-3*t128*t133*t4*t88+2.0d
     8           +0*t128*t129*t4*t88)+3.72017044624d-5*t135*t203*t4*t72*
     9           t88-6.09932d-3*t128*t265*t72*t88-3.04966d-3*t128*t271*t
     :           4*t72)*wght+Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.0d+0*rhob*t113*t117*t40*(3.183787
     1           772928d-4*t122*t275*t371*t99-4.120704d-2*t121*t239*t275
     2           *t99+3.183787772928d-4*gammabb*t121*t274*t371*t97-2.060
     3           352d-2*t121*t239*t275*t97+2.0d+0*t120*t275*t97-2.060352
     4           d-2*gammabb*t239*t274*t97+3.183787772928d-4*t118*t371*t
     5           93/rhob**9.666666666666666d+0-4.120704d-2*gammabb*t239*
     6           t274*t93+1.061262590976d-4*t102*t121*t239*t275-1.030176
     7           d-2*t102*t120*t275-1.030176d-2*t101*t120*t275+1.0612625
     8           90976d-4*gammabb*t101*t239*t274)+1.0d+0*t125*(1.1160511
     9           338720001d-4*t129*t130*t275*t343*t6+3.72017044624d-5*t1
     :           33*t203*t275*t6-1.219864d-2*t129*t203*t275*t6-2.439728d
     ;           -2*t126*t203*t275*t6+1.1160511338720001d-4*t131*t132*t2
     <           75*t343+1.1160511338720001d-4*t126*t127*t275*t343+3.720
     =           17044624d-5*t130*t134*t203*t275-2.439728d-2*t130*t131*t
     >           203*t275-1.219864d-2*t129*t130*t203*t275-6.09932d-3*t12
     ?           8*t134*t275-6.09932d-3*t128*t133*t275+2.0d+0*t128*t129*
     @           t275)*t72-3.04966d-3*t128*t277*t4*t72+3.72017044624d-5*
     1           t135*t203*t275*t72-6.09932d-3*t114*t128*t265*t72+t273*(
     2           t376-5.0d-1*rhob*t112*t262*t40)-6.4386d-4*gammabb*t120*
     3           t123*t273*t4*t40+1.061262590976d-4*t113*t123*t239*t380*
     4           t40-5.15088d-3*t113*t114*t120*t276*t40-1.25d-1*t110*t11
     5           7*t276*t40-1.030176d-2*t113*t120*t264*t27*t40+1.0d+0*rh
     6           ob*t110*t262*t40+1.28772d-3*t110*t114*t120*t123*t40+t11
     7           7*t273*t378)*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t26*t87*t91*(-1.6482816d
     1           -1*t200*t379*t98*t99+8.0d+0*t379*t96*t99+6.367575545856
     2           d-4*t100*t341*t379*t99+6.367575545856d-4*gammaaa*t341*t
     3           382*t97*t98+2.122525181952d-4*t102*t200*t379*t98-8.2414
     4           08d-2*gammaaa*t200*t382*t97-4.120704d-2*t102*t379*t96+6
     5           .367575545856d-4*t341*t93*t94/rhoa**8.666666666666666d+
     6           0+2.122525181952d-4*gammaaa*t101*t200*t382)-2.57544d-3*
     7           gammaaa*t103*t26*t267*t88*t96-2.060352d-2*t13*t26*t270*
     8           t87*t96-2.5d-1*gammaaa*t103*t26*t381*t91+2.5d-1*gammaaa
     9           *t26*t267*t270*t91-1.219864d-2*t128*t271*t72*t88+2.1225
     :           25181952d-4*t103*t200*t26*t280*t87+1.0d+0*rhoa*t26*t381
     ;           *t83*t86-2.0d+0*rhoa*t26*t267*t83+1.0d+0*t125*(2.232102
     <           2677440003d-4*t129*t130*t343*t379*t6+7.44034089248d-5*t
     =           133*t203*t379*t6-4.879456d-2*t129*t203*t379*t6+2.232102
     >           2677440003d-4*t131*t132*t343*t379+2.2321022677440003d-4
     ?           *t126*t127*t343*t379+7.44034089248d-5*t130*t134*t203*t3
     @           79-9.758912d-2*t130*t131*t203*t379-2.439728d-2*t128*t13
     1           4*t379+8.0d+0*t128*t131*t379)*t72+7.44034089248d-5*t135
     2           *t203*t379*t72)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = (1.0d+0*t125*t72*(2.2321022677440003d
     1           -4*t114*t129*t130*t343*t6*t88+7.44034089248d-5*t114*t13
     2           3*t203*t6*t88-4.879456d-2*t114*t129*t203*t6*t88+2.23210
     3           22677440003d-4*t114*t131*t132*t343*t88+2.23210226774400
     4           03d-4*t114*t126*t127*t343*t88+7.44034089248d-5*t114*t13
     5           0*t134*t203*t88-9.758912d-2*t114*t130*t131*t203*t88-2.4
     6           39728d-2*t114*t128*t134*t88+8.0d+0*t114*t128*t131*t88)-
     7           6.09932d-3*t128*t277*t72*t88+7.44034089248d-5*t114*t135
     8           *t203*t72*t88-6.09932d-3*t114*t128*t271*t72)*wght+Mmat2
     9           (iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t113*t117*t40*(6.3675755
     1           45856d-4*t122*t371*t380*t99-1.6482816d-1*t121*t239*t380
     2           *t99+8.0d+0*t120*t380*t99+6.367575545856d-4*gammabb*t12
     3           1*t371*t384*t97-8.241408d-2*gammabb*t239*t384*t97+6.367
     4           575545856d-4*t118*t371*t93/rhob**8.666666666666666d+0+2
     5           .122525181952d-4*gammabb*t101*t239*t384+2.122525181952d
     6           -4*t102*t121*t239*t380-4.120704d-2*t102*t120*t380)+1.0d
     7           +0*t125*(2.2321022677440003d-4*t129*t130*t343*t380*t6+7
     8           .44034089248d-5*t133*t203*t380*t6-4.879456d-2*t129*t203
     9           *t380*t6+2.2321022677440003d-4*t131*t132*t343*t380+2.23
     :           21022677440003d-4*t126*t127*t343*t380+7.44034089248d-5*
     ;           t130*t134*t203*t380-9.758912d-2*t130*t131*t203*t380-2.4
     <           39728d-2*t128*t134*t380+8.0d+0*t128*t131*t380)*t72+7.44
     =           034089248d-5*t135*t203*t380*t72-1.219864d-2*t114*t128*t
     >           277*t72-2.5d-1*gammabb*t117*t123*t383*t40+1.0d+0*rhob*t
     ?           109*t112*t383*t40+2.122525181952d-4*t113*t123*t239*t354
     @           *t40+2.5d-1*gammabb*t117*t273*t276*t40-2.060352d-2*t113
     1           *t120*t27*t276*t40-2.57544d-3*gammabb*t114*t120*t123*t2
     2           73*t40-2.0d+0*rhob*t109*t273*t40)*wght+Mmat2(iq,D2_TB_T
     3           B)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhob**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhob**6.666666666666666d-1
              t17 = rhob**5.0d-1
              t18 = 1/t17
              t19 = 1/rhob**3.333333333333333d-1
              t20 = 1/rhob**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = param(18)
              t31 = 2.4d-51*t1+1.0d+0
              t32 = 1/t31
              t33 = param(19)
              t34 = param(20)
              t35 = param(21)
              t36 = param(22)
              t37 = 2.4d-51*t1*t32*t36+t35
              t38 = 2.4d-51*t1*t32*t37+t34
              t39 = 2.4d-51*t1*t32*t38+t33
              t40 = 2.4d-51*t1*t32*t39+t30
              t41 = 1/rhoa**2.6666666666666666d+0
              t42 = gammaaa*t41
              t43 = t42+4.0d-50*t1
              t44 = 3.1d-3*t43+1.0d+0
              t45 = 1/t44
              t46 = param(17)
              t47 = 3.1d-3*t43*t45*t46+param(16)
              t48 = 3.1d-3*t43*t45*t47+param(15)
              t49 = 3.1d-3*t43*t45*t48+param(14)
              t50 = 3.1d-3*t43*t45*t49+param(13)
              t51 = 1/rhoa**6.666666666666666d-1
              t52 = rhoa**5.0d-1
              t53 = 1/t52
              t54 = 1/rhoa**3.333333333333333d-1
              t55 = 1/rhoa**1.6666666666666666d-1
              t56 = 1.1120374863094686d+1*t55+3.8447462374472113d+0*t54+
     1           1.644733775567609d+0*t53+2.4058712912881916d-1*t51
              t57 = 3.216395899738507d+1/t56+1.0d+0
              t58 = log(t57)
              t59 = 1.274696188700087d-1*t54+1.0d+0
              t60 = 5.982550435771079d+0*t55+2.2255694211506874d+0*t54+8
     1           .004286349993635d-1*t53+1.8970043257475583d-1*t51
              t61 = 1.6081979498692536d+1/t60+1.0d+0
              t62 = log(t61)
              t63 = 1.3256889990520176d-1*t54+1.0d+0
              t64 = -6.903522198342671d-18*t62*t63-3.1090699999999993d-2
     1           *t58*t59
              t65 = rhob+rhoa
              t66 = 1/t65**3.333333333333333d-1
              t67 = 1.3256889990520176d-1*t66+1.0d+0
              t68 = rhoa-rhob
              t69 = t68**4
              t70 = 1/t65**4
              t71 = 1/t65
              t72 = 1.0d+0-t68*t71
              t73 = t68*t71+1.0d+0
              t74 = t73**1.3333333333333333d+0+t72**1.3333333333333333d+
     1           0-2.0d+0
              t75 = -1.923661050931536d+0*t69*t70*t74
              t76 = t75+1.0d+0
              t77 = 1/t65**6.666666666666666d-1
              t78 = t65**5.0d-1
              t79 = 1/t78
              t80 = 1/t65**1.6666666666666666d-1
              t81 = 5.982550435771079d+0*t80+8.004286349993635d-1*t79+1.
     1           8970043257475583d-1*t77+2.2255694211506874d+0*t66
              t82 = 1.6081979498692536d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = -6.21814d-2*t67*t76*t83
              t85 = 6.901399211255825d-2*t66+1.0d+0
              t86 = t75+1.923661050931536d+0*t74
              t87 = 8.157414703487641d+0*t80+4.3009724712766434d-1*t79+1
     1           .9115125951273373d-1*t77+2.247591863577616d+0*t66
              t88 = 2.9608813203268075d+1/t87+1.0d+0
              t89 = log(t88)
              t90 = 1.9751631321680768d-2*t85*t86*t89
              t91 = 1.274696188700087d-1*t66+1.0d+0
              t92 = 1.1120374863094686d+1*t80+1.644733775567609d+0*t79+2
     1           .4058712912881916d-1*t77+3.8447462374472113d+0*t66
              t93 = 3.216395899738507d+1/t92+1.0d+0
              t94 = log(t93)
              t95 = -5.980796863619711d-2*t69*t70*t74*t91*t94
              t96 = t65*(t95+t90+t84)-rhoa*t64-rhob*t29
              t97 = 6.0d-2*gammaaa*t41+1.0d+0
              t98 = 1/t97
              t99 = 6.0d-2*gammaaa*t36*t41*t98+t35
              t100 = 6.0d-2*gammaaa*t41*t98*t99+t34
              t101 = 6.0d-2*gammaaa*t100*t41*t98+t33
              t102 = 6.0d-2*gammaaa*t101*t41*t98+t30
              t103 = 1/taua
              t104 = 1/rhoa
              t105 = 2.0d+0*taua-2.5d-1*gammaaa*t104
              t106 = 1.0d+0-1.25d-1*gammaaa*t103*t104
              t107 = 1/rhoa**1.6666666666666669d+0
              t108 = 2.0d+0*t107*taua
              t109 = 5.15088d-3*(t42+t108-9.11559972d+0)+1.0d+0
              t110 = 1/t109
              t111 = gammaaa**2
              t112 = 1/rhoa**5.333333333333333d+0
              t113 = 1/t109**2
              t114 = t108-9.11559972d+0
              t115 = t114**2
              t116 = t113*t115*t6+t5+gammaaa*t113*t114*t14*t41+gammaaa*t
     1           110*t13*t41+t110*t114*t12+t11*t111*t112*t113
              t117 = 3.04966d-3*(t42+t2+t108-1.823119944d+1)+1.0d+0
              t118 = 1/t117
              t119 = param(4)
              t120 = t43**2
              t121 = 1/t117**2
              t122 = param(5)
              t123 = t8+t108-1.823119944d+1
              t124 = param(6)
              t125 = t123**2
              t126 = param(2)
              t127 = param(3)
              t128 = t118*t126*t43+t121*t122*t123*t43+t118*t123*t127+t12
     1           1*t124*t125+t119*t120*t121+param(1)
              t129 = 1/t61
              t130 = 1/t52**3
              t131 = 1/rhoa**1.3333333333333333d+0
              t132 = 1/rhoa**1.1666666666666667d+0
              t133 = -9.970917392951799d-1*t132-7.418564737168958d-1*t13
     1           1-4.002143174996817d-1*t130-1.264669550498372d-1*t107
              t134 = 1/t60**2
              t135 = 1/t57
              t136 = -1.8533958105157808d+0*t132-1.2815820791490704d+0*t
     1           131-8.223668877838045d-1*t130-1.6039141941921276d-1*t10
     2           7
              t137 = 1/t56**2
              t138 = 1.1102230246251565d-16*t129*t133*t134*t63+3.0506411
     1           443514264d-19*t131*t62+1.0d+0*t135*t136*t137*t59+1.3210
     2           398931339265d-3*t131*t58
              t139 = 1/t65**1.6666666666666669d+0
              t140 = 1/t78**3
              t141 = 1/t65**1.3333333333333333d+0
              t142 = 1/t65**1.1666666666666667d+0
              t143 = -9.970917392951799d-1*t142-7.418564737168958d-1*t14
     1           1-4.002143174996817d-1*t140-1.264669550498372d-1*t139
              t144 = 1/t81**2
              t145 = 1/t82
              t146 = 1.0d+0*t143*t144*t145*t67*t76
              t147 = -1.3595691172479402d+0*t142-7.491972878592053d-1*t1
     1           41-2.1504862356383217d-1*t140-1.2743417300848914d-1*t13
     2           9
              t148 = 1/t87**2
              t149 = 1/t88
              t150 = -5.848223622634647d-1*t147*t148*t149*t85*t86
              t151 = -1.8533958105157808d+0*t142-1.2815820791490704d+0*t
     1           141-8.223668877838045d-1*t140-1.6039141941921276d-1*t13
     2           9
              t152 = 1/t92**2
              t153 = 1/t93
              t154 = 1.923661050931536d+0*t151*t152*t153*t69*t70*t74*t91
              t155 = 1/t65**2
              t156 = t155*t68
              t157 = -t71
              t158 = t157+t156
              t159 = t72**3.333333333333333d-1
              t160 = -t155*t68
              t161 = t71+t160
              t162 = t73**3.333333333333333d-1
              t163 = 1.3333333333333333d+0*t161*t162+1.3333333333333333d
     1           +0*t158*t159
              t164 = -1.923661050931536d+0*t163*t69*t70
              t165 = 1/t65**5
              t166 = 7.694644203726144d+0*t165*t69*t74
              t167 = t68**3
              t168 = -7.694644203726144d+0*t167*t70*t74
              t169 = t168+t166+t164
              t170 = -6.21814d-2*t169*t67*t83
              t171 = 2.747773264188437d-3*t141*t76*t83
              t172 = t168+t166+t164+1.923661050931536d+0*t163
              t173 = 1.9751631321680768d-2*t172*t85*t89
              t174 = -4.5437964274821163d-4*t141*t86*t89
              t175 = -5.980796863619711d-2*t163*t69*t70*t91*t94
              t176 = 1/t65**5.333333333333333d+0
              t177 = 2.541232989148493d-3*t176*t69*t74*t94
              t178 = 2.3923187454478842d-1*t165*t69*t74*t91*t94
              t179 = t95+t65*(-2.3923187454478842d-1*t167*t70*t74*t91*t9
     1           4+t178+t177+t175+t174+t173+t171+t170+t154+t150+t146)+t9
     2           0+t84+6.903522198342671d-18*t62*t63+3.1090699999999993d
     3           -2*t58*t59-rhoa*t138
              t180 = 1/rhoa**3.6666666666666664d+0
              t181 = 1/t44**2
              t182 = 2.562666666666666d-5*gammaaa*t180*t181*t43*t46-8.26
     1           6666666666665d-3*gammaaa*t180*t45*t46
              t183 = -8.266666666666665d-3*gammaaa*t180*t45*t47+2.562666
     1           666666666d-5*gammaaa*t180*t181*t43*t47+3.1d-3*t182*t43*
     2           t45
              t184 = -8.266666666666665d-3*gammaaa*t180*t45*t48+2.562666
     1           666666666d-5*gammaaa*t180*t181*t43*t48+3.1d-3*t183*t43*
     2           t45
              t185 = -8.266666666666665d-3*gammaaa*t180*t45*t49+2.562666
     1           666666666d-5*gammaaa*t180*t181*t43*t49+3.1d-3*t184*t43*
     2           t45
              t186 = 1/t97**2
              t187 = 1/rhoa**6.333333333333333d+0
              t188 = 9.599999999999997d-3*t111*t186*t187*t36-1.599999999
     1           9999998d-1*gammaaa*t180*t36*t98
              t189 = -1.5999999999999998d-1*gammaaa*t180*t98*t99+9.59999
     1           9999999997d-3*t111*t186*t187*t99+6.0d-2*gammaaa*t188*t4
     2           1*t98
              t190 = 6.0d-2*gammaaa*t189*t41*t98-1.5999999999999998d-1*g
     1           ammaaa*t100*t180*t98+9.599999999999997d-3*t100*t111*t18
     2           6*t187
              t191 = 6.0d-2*gammaaa*t190*t41*t98-1.5999999999999998d-1*g
     1           ammaaa*t101*t180*t98+9.599999999999997d-3*t101*t111*t18
     2           6*t187
              t192 = -3.3333333333333337d+0*t41*taua-2.6666666666666666d
     1           +0*gammaaa*t180
              t193 = 1/t109**3
              t194 = -6.666666666666667d+0*t113*t114*t41*t6*taua-3.33333
     1           33333333337d+0*t110*t12*t41*taua-3.3333333333333337d+0*
     2           gammaaa*t112*t113*t14*taua-1.030176d-2*t115*t192*t193*t
     3           6-1.030176d-2*gammaaa*t114*t14*t192*t193*t41-5.15088d-3
     4           *gammaaa*t113*t13*t192*t41-1.030176d-2*t11*t111*t112*t1
     5           92*t193-5.15088d-3*t113*t114*t12*t192-5.333333333333333
     6           d+0*t11*t111*t113*t187-2.6666666666666666d+0*gammaaa*t1
     7           13*t114*t14*t180-2.6666666666666666d+0*gammaaa*t110*t13
     8           *t180
              t195 = 1.0d+0*rhoa*t106*t194*t64+1.0d+0*t106*t116*t64+1.0d
     1           +0*rhoa*t106*t116*t138
              t196 = 1/t117**3
              t197 = -3.3333333333333337d+0*t121*t122*t41*t43*taua-3.333
     1           3333333333337d+0*t118*t127*t41*taua-6.666666666666667d+
     2           0*t121*t123*t124*t41*taua-6.09932d-3*t122*t123*t192*t19
     3           6*t43-3.04966d-3*t121*t126*t192*t43-5.333333333333333d+
     4           0*gammaaa*t119*t121*t180*t43-6.09932d-3*t124*t125*t192*
     5           t196-6.09932d-3*t119*t120*t192*t196-3.04966d-3*t121*t12
     6           3*t127*t192-2.6666666666666666d+0*gammaaa*t118*t126*t18
     7           0-2.6666666666666666d+0*gammaaa*t121*t122*t123*t180
              t198 = 1.0d+0*t197*t96+1.0d+0*t128*t179
              t199 = 1/t26
              t200 = 1/t17**3
              t201 = 1/rhob**1.3333333333333333d+0
              t202 = 1/rhob**1.1666666666666667d+0
              t203 = -9.970917392951799d-1*t202-7.418564737168958d-1*t20
     1           1-4.002143174996817d-1*t200-1.264669550498372d-1*t1
              t204 = 1/t25**2
              t205 = 1/t22
              t206 = -1.8533958105157808d+0*t202-1.2815820791490704d+0*t
     1           201-8.223668877838045d-1*t200-1.6039141941921276d-1*t1
              t207 = 1/t21**2
              t208 = 1.1102230246251565d-16*t199*t203*t204*t28+3.0506411
     1           443514264d-19*t201*t27+1.0d+0*t205*t206*t207*t24+1.3210
     2           398931339265d-3*t201*t23
              t209 = 1/t31**2
              t210 = 1/rhob**4.333333333333333d+0
              t211 = 1/rhob**2.6666666666666666d+0
              t212 = 9.6d-102*t209*t210*t36-4.0d-51*t211*t32*t36
              t213 = -4.0d-51*t211*t32*t37+9.6d-102*t209*t210*t37+2.4d-5
     1           1*t1*t212*t32
              t214 = -4.0d-51*t211*t32*t38+9.6d-102*t209*t210*t38+2.4d-5
     1           1*t1*t213*t32
              t215 = -4.0d-51*t211*t32*t39+9.6d-102*t209*t210*t39+2.4d-5
     1           1*t1*t214*t32
              t216 = 1/t3**3
              t217 = -6.666666666666666d-50*t211*t6*t7*t9-6.666666666666
     1           666d-50*t14*t211*t7*t9+5.15088d-52*t12*t211*t7*t9+4.120
     2           7039999999995d-101*t14*t210*t216*t9-1.3333333333333333d
     3           -99*t14*t210*t7+2.0603519999999997d-101*t13*t210*t7-5.3
     4           33333333333334d-99*t11*t210*t7+1.030176d-51*t10*t211*t2
     5           16*t6-6.666666666666666d-50*t13*t211*t4-3.3333333333333
     6           33d-50*t12*t211*t4+1.6482816d-150*t11*t216/rhob**6
              t218 = 5.0d-1*rhob*t217*t29+5.0d-1*t15*t29+5.0d-1*rhob*t15
     1           *t208
              t219 = t71+t156
              t220 = t160+t157
              t221 = 1.3333333333333333d+0*t162*t220+1.3333333333333333d
     1           +0*t159*t219
              t222 = -1.923661050931536d+0*t221*t69*t70
              t223 = 7.694644203726144d+0*t167*t70*t74
              t224 = t223+t222+t166
              t225 = -6.21814d-2*t224*t67*t83
              t226 = t223+t222+1.923661050931536d+0*t221+t166
              t227 = 1.9751631321680768d-2*t226*t85*t89
              t228 = -5.980796863619711d-2*t221*t69*t70*t91*t94
              t229 = t95+t65*(2.3923187454478842d-1*t167*t70*t74*t91*t94
     1           +t228+t227+t225+t178+t177+t174+t171+t154+t150+t146)+t90
     2           +t84+6.903522198342671d-18*t27*t28+3.1090699999999993d-
     3           2*t23*t24-rhob*t208
              t230 = 6.406666666666666d-55*t181*t211*t43*t46-2.066666666
     1           6666667d-52*t211*t45*t46
              t231 = -2.0666666666666667d-52*t211*t45*t47+6.406666666666
     1           666d-55*t181*t211*t43*t47+3.1d-3*t230*t43*t45
              t232 = -2.0666666666666667d-52*t211*t45*t48+6.406666666666
     1           666d-55*t181*t211*t43*t48+3.1d-3*t231*t43*t45
              t233 = -2.0666666666666667d-52*t211*t45*t49+6.406666666666
     1           666d-55*t181*t211*t43*t49+3.1d-3*t232*t43*t45
              t234 = 6.09932d-52*t122*t123*t196*t211*t43+3.04966d-52*t12
     1           1*t126*t211*t43-3.333333333333333d-50*t121*t122*t211*t4
     2           3-1.3333333333333333d-49*t119*t121*t211*t43+6.09932d-52
     3           *t124*t125*t196*t211+6.09932d-52*t119*t120*t196*t211+3.
     4           04966d-52*t121*t123*t127*t211-3.333333333333333d-50*t11
     5           8*t127*t211-6.666666666666666d-50*t118*t126*t211-6.6666
     6           66666666666d-50*t121*t123*t124*t211-6.666666666666666d-
     7           50*t121*t122*t123*t211
              t235 = 1.0d+0*t234*t96+1.0d+0*t128*t229
              t236 = 3.1d-3*t41*t45*t46-9.61d-6*t181*t41*t43*t46
              t237 = 3.1d-3*t41*t45*t47-9.61d-6*t181*t41*t43*t47+3.1d-3*
     1           t236*t43*t45
              t238 = 3.1d-3*t41*t45*t48-9.61d-6*t181*t41*t43*t48+3.1d-3*
     1           t237*t43*t45
              t239 = 3.1d-3*t41*t45*t49-9.61d-6*t181*t41*t43*t49+3.1d-3*
     1           t238*t43*t45
              t240 = 6.0d-2*t36*t41*t98-3.6d-3*gammaaa*t112*t186*t36
              t241 = 6.0d-2*t41*t98*t99-3.6d-3*gammaaa*t112*t186*t99+6.0
     1           d-2*gammaaa*t240*t41*t98
              t242 = 6.0d-2*gammaaa*t241*t41*t98+6.0d-2*t100*t41*t98-3.6
     1           d-3*gammaaa*t100*t112*t186
              t243 = 6.0d-2*gammaaa*t242*t41*t98+6.0d-2*t101*t41*t98-3.6
     1           d-3*gammaaa*t101*t112*t186
              t244 = 1/rhoa**8
              t245 = -1.030176d-2*t115*t193*t41*t6+t113*t114*t14*t41+t11
     1           0*t13*t41-5.15088d-3*t113*t114*t12*t41-1.030176d-2*t11*
     2           t111*t193*t244-1.030176d-2*gammaaa*t112*t114*t14*t193-5
     3           .15088d-3*gammaaa*t112*t113*t13+2*gammaaa*t11*t112*t113
              t246 = -6.09932d-3*t122*t123*t196*t41*t43-3.04966d-3*t121*
     1           t126*t41*t43+2*t119*t121*t41*t43-6.09932d-3*t124*t125*t
     2           196*t41-6.09932d-3*t119*t120*t196*t41-3.04966d-3*t121*t
     3           123*t127*t41+t118*t126*t41+t121*t122*t123*t41
              t247 = taua**2
              t248 = 1/t247
              t249 = 1/rhoa**7
              t250 = 1/rhoa**4.333333333333333d+0
              t251 = -2.060352d-2*t107*t115*t193*t6+4.0d+0*t107*t113*t11
     1           4*t6-2.060352d-2*gammaaa*t114*t14*t193*t250+2.0d+0*gamm
     2           aaa*t113*t14*t250-1.030176d-2*gammaaa*t113*t13*t250-2.0
     3           60352d-2*t11*t111*t193*t249-1.030176d-2*t107*t113*t114*
     4           t12+2.0d+0*t107*t110*t12
              t252 = -1.219864d-2*t107*t122*t123*t196*t43-6.09932d-3*t10
     1           7*t121*t126*t43+2.0d+0*t107*t121*t122*t43-1.219864d-2*t
     2           107*t124*t125*t196-1.219864d-2*t107*t119*t120*t196-6.09
     3           932d-3*t107*t121*t123*t127+2.0d+0*t107*t118*t127+4.0d+0
     4           *t107*t121*t123*t124
              t253 = t133**2
              t254 = 1/t52**5
              t255 = 1/rhoa**2.3333333333333334d+0
              t256 = 1/rhoa**2.1666666666666665d+0
              t257 = t136**2
              t258 = 1.7854583920998188d-15*t253*t63/(t60**4*t61**2)-2.2
     1           20446049250313d-16*t129*t253*t63/t60**3+1.1102230246251
     2           565d-16*t129*t134*(2.1077825841639536d-1*t41+1.16327369
     3           58443765d+0*t256+9.89141964955861d-1*t255+6.00321476249
     4           5226d-1*t254)*t63-4.0675215258019015d-19*t255*t62+3.216
     5           395899738507d+1*t257*t59/(t56**4*t57**2)-2.0d+0*t135*t2
     6           57*t59/t56**3+1.0d+0*t135*t137*(2.673190323653546d-1*t4
     7           1+2.1622951122684114d+0*t256+1.7087761055320938d+0*t255
     8           +1.2335503316757068d+0*t254)*t59-1.7613865241785684d-3*
     9           t255*t58-8.497974591333913d-2*t131*t135*t136*t137-9.812
     :           069668265515d-18*t129*t131*t133*t134
              t259 = 2.0d+0*t143*t144*t145*t67*t76
              t260 = -1.1696447245269295d+0*t147*t148*t149*t85*t86
              t261 = 3.847322101863072d+0*t151*t152*t153*t69*t70*t74*t91
              t262 = 5.495546528376875d-3*t141*t76*t83
              t263 = -9.087592854964233d-4*t141*t86*t89
              t264 = 5.082465978296986d-3*t176*t69*t74*t94
              t265 = 4.7846374908957684d-1*t165*t69*t74*t91*t94
              t266 = t143**2
              t267 = 1.6081979498692536d+1*t266*t67*t76/(t81**4*t82**2)
              t268 = -2.0d+0*t145*t266*t67*t76/t81**3
              t269 = -8.837926660346784d-2*t141*t143*t144*t145*t76
              t270 = 1/t65**2.6666666666666666d+0
              t271 = 1/t78**5
              t272 = 1/t65**2.3333333333333334d+0
              t273 = 1/t65**2.1666666666666665d+0
              t274 = 1.0d+0*t144*t145*(1.1632736958443765d+0*t273+9.8914
     1           1964955861d-1*t272+6.003214762495226d-1*t271+2.10778258
     2           41639536d-1*t270)*t67*t76
              t275 = t147**2
              t276 = -1.73158960813529d+1*t275*t85*t86/(t87**4*t88**2)
              t277 = 1.1696447245269295d+0*t149*t275*t85*t86/t87**3
              t278 = 2.690728393099896d-2*t141*t147*t148*t149*t86
              t279 = -5.848223622634647d-1*t148*t149*(1.5861639701225969
     1           d+0*t273+9.98929717145607d-1*t272+3.2257293534574827d-1
     2           *t271+2.1239028834748191d-1*t270)*t85*t86
              t280 = t151**2
              t281 = 6.187255516702861d+1*t280*t69*t70*t74*t91/(t92**4*t
     1           93**2)
              t282 = -3.847322101863072d+0*t153*t280*t69*t70*t74*t91/t92
     1           **3
              t283 = -1.6347222733154887d-1*t151*t152*t153*t176*t69*t74
              t284 = 1.923661050931536d+0*t152*t153*(2.1622951122684114d
     1           +0*t273+1.7087761055320938d+0*t272+1.2335503316757068d+
     2           0*t271+2.673190323653546d-1*t270)*t69*t70*t74*t91
              t285 = -1.538928840745229d+1*t151*t152*t153*t165*t69*t74*t
     1           91
              t286 = 1/t72**6.666666666666666d-1
              t287 = 1/t65**3
              t288 = -2*t287*t68
              t289 = 2*t155
              t290 = 1/t73**6.666666666666666d-1
              t291 = 2*t287*t68
              t292 = -2*t155
              t293 = 1.3333333333333333d+0*t162*(t292+t291)+4.4444444444
     1           44444d-1*t161**2*t290+1.3333333333333333d+0*t159*(t289+
     2           t288)+4.444444444444444d-1*t158**2*t286
              t294 = -1.923661050931536d+0*t293*t69*t70
              t295 = 1.5389288407452287d+1*t163*t165*t69
              t296 = -1.5389288407452287d+1*t163*t167*t70
              t297 = 1/t65**6
              t298 = -3.8473221018630716d+1*t297*t69*t74
              t299 = 6.155715362980915d+1*t165*t167*t74
              t300 = t68**2
              t301 = -2.3083932611178434d+1*t300*t70*t74
              t302 = -3.663697685584583d-3*t272*t76*t83
              t303 = 6.058395236642822d-4*t272*t86*t89
              t304 = -2.3718174565385935d-2*t69*t74*t94/t65**6.333333333
     1           333333d+0
              t305 = -1.1961593727239421d+0*t297*t69*t74*t91*t94
              t306 = -7.176956236343652d-1*t300*t70*t74*t91*t94
              t307 = t65*(1.9138549963583074d+0*t165*t167*t74*t91*t94-5.
     1           980796863619711d-2*t293*t69*t70*t91*t94-4.7846374908957
     2           684d-1*t163*t167*t70*t91*t94+4.7846374908957684d-1*t163
     3           *t165*t69*t91*t94+2.0329863913187946d-2*t167*t176*t74*t
     4           94+5.082465978296986d-3*t163*t176*t69*t94+1.53892884074
     5           5229d+1*t151*t152*t153*t167*t70*t74*t91+3.8473221018630
     6           72d+0*t151*t152*t153*t163*t69*t70*t91+1.975163132168076
     7           8d-2*(t301+t299+t298+t296+t295+t294+1.923661050931536d+
     8           0*t293)*t85*t89-9.087592854964233d-4*t141*t172*t89-1.16
     9           96447245269295d+0*t147*t148*t149*t172*t85-6.21814d-2*(t
     :           301+t299+t298+t296+t295+t294)*t67*t83+5.495546528376875
     ;           d-3*t141*t169*t83+2.0d+0*t143*t144*t145*t169*t67+t306+t
     <           305+t304+t303+t302+t285+t284+t283+t282+t281+t279+t278+t
     =           277+t276+t274+t269+t268+t267)-4.7846374908957684d-1*t16
     >           7*t70*t74*t91*t94-1.1961593727239421d-1*t163*t69*t70*t9
     ?           1*t94+3.9503262643361536d-2*t172*t85*t89-1.243628d-1*t1
     @           69*t67*t83-2.220446049250313d-16*t129*t133*t134*t63-6.1
     1           01282288702853d-19*t131*t62-2.0d+0*t135*t136*t137*t59-2
     2           .642079786267853d-3*t131*t58+t265+t264+t263+t262+t261+t
     3           260+t259-rhoa*t258
              t308 = 1/rhoa**7.333333333333333d+0
              t309 = 1/rhoa**4.666666666666667d+0
              t310 = 1/t44**3
              t311 = 1/rhoa**2
              t312 = gammaaa**3
              t313 = 1/t97**3
              t314 = 1/rhoa**10
              t315 = t192**2
              t316 = 1/t109**4
              t317 = 8.88888888888889d+0*t180*taua+9.777777777777779d+0*
     1           gammaaa*t309
              t318 = 1/t117**4
              t319 = 2.6666666666666666d+0*t162*t287*t68-2.6666666666666
     1           666d+0*t159*t287*t68+4.444444444444444d-1*t161*t220*t29
     2           0+4.444444444444444d-1*t158*t219*t286
              t320 = -1.923661050931536d+0*t319*t69*t70
              t321 = 7.694644203726144d+0*t165*t221*t69
              t322 = -7.694644203726144d+0*t167*t221*t70
              t323 = 7.694644203726144d+0*t163*t165*t69
              t324 = 7.694644203726144d+0*t163*t167*t70
              t325 = 2.3083932611178434d+1*t300*t70*t74
              t326 = t65*(7.176956236343652d-1*t300*t70*t74*t91*t94-5.98
     1           0796863619711d-2*t319*t69*t70*t91*t94-2.392318745447884
     2           2d-1*t167*t221*t70*t91*t94+2.3923187454478842d-1*t163*t
     3           167*t70*t91*t94+2.3923187454478842d-1*t165*t221*t69*t91
     4           *t94+2.3923187454478842d-1*t163*t165*t69*t91*t94+2.5412
     5           32989148493d-3*t176*t221*t69*t94+2.541232989148493d-3*t
     6           163*t176*t69*t94+1.923661050931536d+0*t151*t152*t153*t2
     7           21*t69*t70*t91+1.923661050931536d+0*t151*t152*t153*t163
     8           *t69*t70*t91+1.9751631321680768d-2*(t325+t324+t323+t322
     9           +t321+t320+1.923661050931536d+0*t319+t298)*t85*t89-4.54
     :           37964274821163d-4*t141*t226*t89-4.5437964274821163d-4*t
     ;           141*t172*t89-5.848223622634647d-1*t147*t148*t149*t226*t
     <           85-5.848223622634647d-1*t147*t148*t149*t172*t85-6.21814
     =           d-2*(t325+t324+t323+t322+t321+t320+t298)*t67*t83+2.7477
     >           73264188437d-3*t141*t224*t83+2.747773264188437d-3*t141*
     ?           t169*t83+1.0d+0*t143*t144*t145*t224*t67+1.0d+0*t143*t14
     @           4*t145*t169*t67+t305+t304+t303+t302+t285+t284+t283+t282
     1           +t281+t279+t278+t277+t276+t274+t269+t268+t267)+t265+t26
     2           4+t263+t262+t261+t260+t259+t228+t227+t225+t175+t173+t17
     3           0
              t327 = t203**2
              t328 = 1/t17**5
              t329 = 1/rhob**2.3333333333333334d+0
              t330 = 1/rhob**2.1666666666666665d+0
              t331 = t206**2
              t332 = 3.216395899738507d+1*t24*t331/(t21**4*t22**2)-2.0d+
     1           0*t205*t24*t331/t21**3+1.0d+0*t205*t207*t24*(2.16229511
     2           22684114d+0*t330+1.7087761055320938d+0*t329+1.233550331
     3           6757068d+0*t328+2.673190323653546d-1*t211)+1.1102230246
     4           251565d-16*t199*t204*t28*(1.1632736958443765d+0*t330+9.
     5           89141964955861d-1*t329+6.003214762495226d-1*t328+2.1077
     6           825841639536d-1*t211)-4.0675215258019015d-19*t27*t329-1
     7           .7613865241785684d-3*t23*t329+1.7854583920998188d-15*t2
     8           8*t327/(t25**4*t26**2)-2.220446049250313d-16*t199*t28*t
     9           327/t25**3-8.497974591333913d-2*t201*t205*t206*t207-9.8
     :           12069668265515d-18*t199*t201*t203*t204
              t333 = 1/t31**3
              t334 = 1/rhob**7
              t335 = 1/rhob**5.333333333333333d+0
              t336 = 1/rhob**3.6666666666666664d+0
              t337 = 1/t3**4
              t338 = 1.3333333333333333d+0*t159*(t292+t288)+1.3333333333
     1           333333d+0*t162*(t291+t289)+4.444444444444444d-1*t220**2
     2           *t290+4.444444444444444d-1*t219**2*t286
              t339 = -1.923661050931536d+0*t338*t69*t70
              t340 = 1.5389288407452287d+1*t165*t221*t69
              t341 = 1.5389288407452287d+1*t167*t221*t70
              t342 = -6.155715362980915d+1*t165*t167*t74
              t343 = t65*(-1.9138549963583074d+0*t165*t167*t74*t91*t94-5
     1           .980796863619711d-2*t338*t69*t70*t91*t94+4.784637490895
     2           7684d-1*t167*t221*t70*t91*t94+4.7846374908957684d-1*t16
     3           5*t221*t69*t91*t94-2.0329863913187946d-2*t167*t176*t74*
     4           t94+5.082465978296986d-3*t176*t221*t69*t94-1.5389288407
     5           45229d+1*t151*t152*t153*t167*t70*t74*t91+3.847322101863
     6           072d+0*t151*t152*t153*t221*t69*t70*t91+1.97516313216807
     7           68d-2*(t342+t341+t340+t339+1.923661050931536d+0*t338+t3
     8           01+t298)*t85*t89-9.087592854964233d-4*t141*t226*t89-1.1
     9           696447245269295d+0*t147*t148*t149*t226*t85-6.21814d-2*(
     :           t342+t341+t340+t339+t301+t298)*t67*t83+5.49554652837687
     ;           5d-3*t141*t224*t83+2.0d+0*t143*t144*t145*t224*t67+t306+
     <           t305+t304+t303+t302+t285+t284+t283+t282+t281+t279+t278+
     =           t277+t276+t274+t269+t268+t267)+4.7846374908957684d-1*t1
     >           67*t70*t74*t91*t94-1.1961593727239421d-1*t221*t69*t70*t
     ?           91*t94+3.9503262643361536d-2*t226*t85*t89-1.243628d-1*t
     @           224*t67*t83-rhob*t332-2.220446049250313d-16*t199*t203*t
     1           204*t28-6.101282288702853d-19*t201*t27+t265+t264+t263+t
     2           262+t261+t260+t259-2.0d+0*t205*t206*t207*t24-2.64207978
     3           6267853d-3*t201*t23
              t344 = 1.25d-1*t102*t64
              t345 = 1/rhoa**9
              t346 = 1.25d-1*gammaaa*t245*t64+1.25d-1*t116*t64
              t347 = 1/rhoa**3.3333333333333337d+0
              t348 = 1/taua**3
              t349 = 1/rhoa**6
              fnc(iq) = (1.0d+0*t50*t96+1.0d+0*t118*t128*t96+1.0d+0*rhoa
     1           *t106*t110*t116*t64+5.0d-1*rhoa*t102*t103*t105*t64+5.0d
     2           -1*rhob*t29*t40+5.0d-1*rhob*t15*t29*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-3.04966d-3*t121*t128*t192*t96+1.0d+0*t1
     1           85*t96+t103*(5.0d-1*rhoa*t105*t191*t64+5.0d-1*t102*t105
     2           *t64+5.0d-1*rhoa*t102*t105*t138)-5.15088d-3*rhoa*t106*t
     3           113*t116*t192*t64+1.25d-1*gammaaa*t103*t104*t110*t116*t
     4           64+1.25d-1*gammaaa*t102*t103*t104*t64+1.0d+0*t179*t50+t
     5           118*t198+t110*t195)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t233*t96+3.04966d-52*t121*t128*t2
     1           11*t96+2.57544d-52*t1*t15*t29*t7+1.0d+0*t229*t50+5.0d-1
     2           *t29*t40+5.0d-1*rhob*t208*t40+t218*t4+5.0d-1*rhob*t215*
     3           t29+t118*t235)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (-3.04966d-3*t121*t128*t41*t96+1.0d+0*t1
     1           18*t246*t96+1.0d+0*t239*t96+t103*(5.0d-1*rhoa*t105*t243
     2           *t64-1.25d-1*t102*t64)+1.0d+0*rhoa*t106*t110*t245*t64-5
     3           .15088d-3*t106*t107*t113*t116*t64-1.25d-1*t103*t110*t11
     4           6*t64)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*t118*t252*t96-6.09932d-3*t107*t12
     1           1*t128*t96-1.030176d-2*t106*t113*t116*t51*t64+1.0d+0*rh
     2           oa*t106*t110*t251*t64+1.25d-1*gammaaa*t110*t116*t248*t6
     3           4-5.0d-1*rhoa*t102*t105*t248*t64+1.0d+0*rhoa*t102*t103*
     4           t64)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t110*(1.0d+0*rhoa*t106*t64*(1.373568
     1           d-1*t114*t192*t193*t41*t6*taua+1.7777777777777778d+1*t1
     2           13*t114*t180*t6*taua+3.4339200000000003d-2*t113*t12*t19
     3           2*t41*taua+6.867840000000001d-2*gammaaa*t112*t14*t192*t
     4           193*taua+2.6666666666666666d+1*gammaaa*t113*t14*t187*ta
     5           ua+8.88888888888889d+0*t110*t12*t180*taua-1.030176d-2*t
     6           115*t193*t317*t6+1.591893886464d-4*t115*t315*t316*t6+2.
     7           2222222222222224d+1*t112*t113*t247*t6-1.030176d-2*gamma
     8           aa*t114*t14*t193*t317*t41-5.15088d-3*gammaaa*t113*t13*t
     9           317*t41+1.591893886464d-4*gammaaa*t114*t14*t315*t316*t4
     :           1+5.30631295488d-5*gammaaa*t13*t193*t315*t41-1.030176d-
     ;           2*t11*t111*t112*t193*t317-5.15088d-3*t113*t114*t12*t317
     <           +1.591893886464d-4*t11*t111*t112*t315*t316+5.3063129548
     =           8d-5*t114*t12*t193*t315+9.777777777777779d+0*gammaaa*t1
     >           13*t114*t14*t309+9.777777777777779d+0*gammaaa*t110*t13*
     ?           t309+3.377777777777778d+1*t11*t111*t113*t308+1.0988544d
     @           -1*t11*t111*t187*t192*t193+5.494272d-2*gammaaa*t114*t14
     1           *t180*t192*t193+2.747136d-2*gammaaa*t113*t13*t180*t192)
     2           +1.25d-1*gammaaa*t103*t116*t311*t64+2.0d+0*t106*t194*t6
     3           4+1.25d-1*gammaaa*t103*t104*t194*t64+1.0d+0*rhoa*t106*t
     4           116*t258+2.0d+0*rhoa*t106*t138*t194+2.0d+0*t106*t116*t1
     5           38+1.25d-1*gammaaa*t103*t104*t116*t138)+t118*(1.0d+0*t9
     6           6*(4.066213333333334d-2*t122*t192*t196*t41*t43*taua+8.8
     7           8888888888889d+0*t121*t122*t180*t43*taua+8.132426666666
     8           668d-2*t123*t124*t192*t196*t41*taua+2.033106666666667d-
     9           2*t121*t127*t192*t41*taua+1.7777777777777778d+1*gammaaa
     :           *t121*t122*t187*taua+8.88888888888889d+0*t118*t127*t180
     ;           *taua+1.7777777777777778d+1*t121*t123*t124*t180*taua+5.
     <           580255669360001d-5*t122*t123*t315*t318*t43-6.09932d-3*t
     =           122*t123*t196*t317*t43-3.04966d-3*t121*t126*t317*t43+1.
     >           86008522312d-5*t126*t196*t315*t43+1.9555555555555557d+1
     ?           *gammaaa*t119*t121*t309*t43+6.505941333333333d-2*gammaa
     @           a*t119*t180*t192*t196*t43+5.580255669360001d-5*t124*t12
     1           5*t315*t318+5.580255669360001d-5*t119*t120*t315*t318-6.
     2           09932d-3*t124*t125*t196*t317-6.09932d-3*t119*t120*t196*
     3           t317-3.04966d-3*t121*t123*t127*t317+1.86008522312d-5*t1
     4           23*t127*t196*t315+9.777777777777779d+0*gammaaa*t118*t12
     5           6*t309+9.777777777777779d+0*gammaaa*t121*t122*t123*t309
     6           +1.4222222222222222d+1*t111*t119*t121*t308+2.2222222222
     7           222224d+1*t112*t121*t124*t247+3.2529706666666663d-2*gam
     8           maaa*t122*t123*t180*t192*t196+1.6264853333333332d-2*gam
     9           maaa*t121*t126*t180*t192)+1.0d+0*t128*t307+2.0d+0*t179*
     :           t197)+t103*(5.0d-1*rhoa*t105*t64*(6.0d-2*gammaaa*t41*t9
     ;           8*(6.0d-2*gammaaa*t41*t98*(5.866666666666666d-1*gammaaa
     <           *t309*t98*t99+3.0719999999999986d-3*t312*t313*t314*t99-
     =           8.639999999999998d-2*t111*t186*t308*t99+6.0d-2*gammaaa*
     >           t41*t98*(5.866666666666666d-1*gammaaa*t309*t36*t98+3.07
     ?           19999999999986d-3*t312*t313*t314*t36-8.639999999999998d
     @           -2*t111*t186*t308*t36)-3.1999999999999995d-1*gammaaa*t1
     1           80*t188*t98+1.9199999999999995d-2*t111*t186*t187*t188)+
     2           5.866666666666666d-1*gammaaa*t100*t309*t98-3.1999999999
     3           999995d-1*gammaaa*t180*t189*t98+3.0719999999999986d-3*t
     4           100*t312*t313*t314-8.639999999999998d-2*t100*t111*t186*
     5           t308+1.9199999999999995d-2*t111*t186*t187*t189)+5.86666
     6           6666666666d-1*gammaaa*t101*t309*t98-3.1999999999999995d
     7           -1*gammaaa*t180*t190*t98+3.0719999999999986d-3*t101*t31
     8           2*t313*t314-8.639999999999998d-2*t101*t111*t186*t308+1.
     9           9199999999999995d-2*t111*t186*t187*t190)+1.25d-1*gammaa
     :           a*t102*t311*t64+1.0d+0*t105*t191*t64+1.25d-1*gammaaa*t1
     ;           04*t191*t64+5.0d-1*rhoa*t102*t105*t258+1.0d+0*rhoa*t105
     <           *t138*t191+1.0d+0*t102*t105*t138+1.25d-1*gammaaa*t102*t
     =           104*t138)+t121*(-3.04966d-3*t128*t317*t96-3.04966d-3*t1
     >           92*t197*t96-3.04966d-3*t192*t198-3.04966d-3*t128*t179*t
     ?           192)+1.0d+0*(3.0311111111111105d-2*gammaaa*t309*t45*t49
     @           +4.2369422222222203d-7*t111*t308*t310*t43*t49-9.3964444
     1           44444442d-5*gammaaa*t181*t309*t43*t49-1.366755555555555
     2           d-4*t111*t181*t308*t49+3.1d-3*t43*t45*(3.03111111111111
     3           05d-2*gammaaa*t309*t45*t48+4.2369422222222203d-7*t111*t
     4           308*t310*t43*t48-9.396444444444442d-5*gammaaa*t181*t309
     5           *t43*t48-1.366755555555555d-4*t111*t181*t308*t48+3.1d-3
     6           *t43*t45*(3.0311111111111105d-2*gammaaa*t309*t45*t47+4.
     7           2369422222222203d-7*t111*t308*t310*t43*t47-9.3964444444
     8           44442d-5*gammaaa*t181*t309*t43*t47-1.366755555555555d-4
     9           *t111*t181*t308*t47+3.1d-3*t43*t45*(3.0311111111111105d
     :           -2*gammaaa*t309*t45*t46+4.2369422222222203d-7*t111*t308
     ;           *t310*t43*t46-9.396444444444442d-5*gammaaa*t181*t309*t4
     <           3*t46-1.366755555555555d-4*t111*t181*t308*t46)-1.653333
     =           333333333d-2*gammaaa*t180*t182*t45+5.125333333333332d-5
     >           *gammaaa*t180*t181*t182*t43)-1.653333333333333d-2*gamma
     ?           aa*t180*t183*t45+5.125333333333332d-5*gammaaa*t180*t181
     @           *t183*t43)-1.653333333333333d-2*gammaaa*t180*t184*t45+5
     1           .125333333333332d-5*gammaaa*t180*t181*t184*t43)*t96+1.8
     2           6008522312d-5*t128*t196*t315*t96+t113*(-5.15088d-3*rhoa
     3           *t106*t116*t317*t64-5.15088d-3*rhoa*t106*t192*t194*t64-
     4           5.15088d-3*t106*t116*t192*t64-5.15088d-3*t192*t195-5.15
     5           088d-3*rhoa*t106*t116*t138*t192)+t103*t104*t110*(1.25d-
     6           1*gammaaa*t194*t64+1.25d-1*gammaaa*t116*t138)+t103*t104
     7           *(1.25d-1*gammaaa*t191*t64+1.25d-1*gammaaa*t102*t138)+5
     8           .30631295488d-5*rhoa*t106*t116*t193*t315*t64-1.25d-1*ga
     9           mmaaa*t103*t110*t116*t311*t64-1.25d-1*gammaaa*t102*t103
     :           *t311*t64-1.28772d-3*gammaaa*t103*t104*t113*t116*t192*t
     ;           64+1.0d+0*t307*t50+2.0d+0*t179*t185)*wght+Amat2(iq,D2_R
     <           A_RA)
              Amat2(iq,D2_RA_RB) = (t118*(1.0d+0*t96*(-2.033106666666667
     1           d-51*t122*t196*t211*t41*t43*taua-4.066213333333334d-51*
     2           t123*t124*t196*t211*t41*taua-1.0165533333333335d-51*t12
     3           1*t127*t211*t41*taua+2.222222222222222d-49*t121*t124*t2
     4           11*t41*taua+2.222222222222222d-49*t121*t122*t211*t41*ta
     5           ua-5.58025566936d-54*t122*t123*t192*t211*t318*t43-1.860
     6           08522312d-54*t126*t192*t196*t211*t43+2.0331066666666667
     7           d-52*t122*t192*t196*t211*t43+8.132426666666667d-52*t119
     8           *t192*t196*t211*t43-3.2529706666666663d-51*gammaaa*t119
     9           *t180*t196*t211*t43-5.58025566936d-54*t124*t125*t192*t2
     :           11*t318-5.58025566936d-54*t119*t120*t192*t211*t318-1.86
     ;           008522312d-54*t123*t127*t192*t196*t211+4.06621333333333
     <           33d-52*t123*t124*t192*t196*t211+4.0662133333333333d-52*
     =           t122*t123*t192*t196*t211-1.6264853333333332d-51*gammaaa
     >           *t122*t123*t180*t196*t211+1.0165533333333333d-52*t121*t
     ?           127*t192*t211+2.0331066666666667d-52*t121*t126*t192*t21
     @           1-8.132426666666666d-52*gammaaa*t121*t126*t180*t211+8.8
     1           88888888888888d-50*gammaaa*t121*t122*t180*t211+3.555555
     2           555555555d-49*gammaaa*t119*t121*t180*t211)+1.0d+0*t128*
     3           t326+1.0d+0*t179*t234+1.0d+0*t197*t229)+t121*(-3.04966d
     4           -3*t192*t234*t96-3.04966d-3*t128*t192*t229)+1.0d+0*(1.0
     5           592355555555552d-56*gammaaa*t180*t211*t310*t43*t49-3.41
     6           6888888888888d-54*gammaaa*t180*t181*t211*t49+3.1d-3*t43
     7           *t45*(1.0592355555555552d-56*gammaaa*t180*t211*t310*t43
     8           *t48-3.416888888888888d-54*gammaaa*t180*t181*t211*t48+3
     9           .1d-3*t43*t45*(1.0592355555555552d-56*gammaaa*t180*t211
     :           *t310*t43*t47-3.416888888888888d-54*gammaaa*t180*t181*t
     ;           211*t47+3.1d-3*t43*t45*(1.0592355555555552d-56*gammaaa*
     <           t180*t211*t310*t43*t46-3.416888888888888d-54*gammaaa*t1
     =           80*t181*t211*t46)-8.266666666666665d-3*gammaaa*t180*t23
     >           0*t45-2.0666666666666667d-52*t182*t211*t45+2.5626666666
     ?           66666d-5*gammaaa*t180*t181*t230*t43+6.406666666666666d-
     @           55*t181*t182*t211*t43)-8.266666666666665d-3*gammaaa*t18
     1           0*t231*t45-2.0666666666666667d-52*t183*t211*t45+2.56266
     2           6666666666d-5*gammaaa*t180*t181*t231*t43+6.406666666666
     3           666d-55*t181*t183*t211*t43)-8.266666666666665d-3*gammaa
     4           a*t180*t232*t45-2.0666666666666667d-52*t184*t211*t45+2.
     5           562666666666666d-5*gammaaa*t180*t181*t232*t43+6.4066666
     6           66666666d-55*t181*t184*t211*t43)*t96-1.86008522312d-54*
     7           t128*t192*t196*t211*t96+1.0d+0*t326*t50+1.0d+0*t179*t23
     8           3+1.0d+0*t185*t229+3.04966d-52*t121*t198*t211)*wght+Ama
     9           t2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t118*(1.0d+0*(-1.6264853333333332d-5
     1           1*t122*t123*t196*t336*t43-8.132426666666666d-52*t121*t1
     2           26*t336*t43+8.888888888888888d-50*t121*t122*t336*t43+3.
     3           555555555555555d-49*t119*t121*t336*t43+5.58025566935999
     4           9d-103*t122*t123*t318*t335*t43+1.86008522312d-103*t126*
     5           t196*t335*t43-4.0662133333333333d-101*t122*t196*t335*t4
     6           3-1.6264853333333334d-100*t119*t196*t335*t43-1.62648533
     7           33333332d-51*t124*t125*t196*t336-1.6264853333333332d-51
     8           *t119*t120*t196*t336-8.132426666666666d-52*t121*t123*t1
     9           27*t336+8.888888888888888d-50*t118*t127*t336+1.77777777
     :           77777776d-49*t118*t126*t336+1.7777777777777776d-49*t121
     ;           *t123*t124*t336+1.7777777777777776d-49*t121*t122*t123*t
     <           336+5.580255669359999d-103*t124*t125*t318*t335+5.580255
     =           669359999d-103*t119*t120*t318*t335+1.86008522312d-103*t
     >           123*t127*t196*t335-8.132426666666667d-101*t123*t124*t19
     ?           6*t335-8.132426666666667d-101*t122*t123*t196*t335-2.033
     @           1066666666667d-101*t121*t127*t335-4.0662133333333333d-1
     1           01*t121*t126*t335+2.222222222222222d-99*t121*t124*t335+
     2           4.444444444444444d-99*t121*t122*t335+8.888888888888888d
     3           -99*t119*t121*t335)*t96+1.0d+0*t128*t343+2.0d+0*t229*t2
     4           34)+t121*t211*(3.04966d-52*t234*t96+3.04966d-52*t235+3.
     5           04966d-52*t128*t229)+1.0d+0*(5.51111111111111d-52*t336*
     6           t45*t49-1.708444444444444d-54*t181*t336*t43*t49+2.64808
     7           88888888887d-106*t310*t335*t43*t49-8.542222222222222d-1
     8           04*t181*t335*t49+3.1d-3*t43*t45*(5.51111111111111d-52*t
     9           336*t45*t48-1.708444444444444d-54*t181*t336*t43*t48+2.6
     :           480888888888887d-106*t310*t335*t43*t48-8.54222222222222
     ;           2d-104*t181*t335*t48+3.1d-3*t43*t45*(5.51111111111111d-
     <           52*t336*t45*t47-1.708444444444444d-54*t181*t336*t43*t47
     =           +2.6480888888888887d-106*t310*t335*t43*t47-8.5422222222
     >           22222d-104*t181*t335*t47+3.1d-3*t43*t45*(5.511111111111
     ?           11d-52*t336*t45*t46-1.708444444444444d-54*t181*t336*t43
     @           *t46+2.6480888888888887d-106*t310*t335*t43*t46-8.542222
     1           222222222d-104*t181*t335*t46)-4.1333333333333333d-52*t2
     2           11*t230*t45+1.2813333333333332d-54*t181*t211*t230*t43)-
     3           4.1333333333333333d-52*t211*t231*t45+1.2813333333333332
     4           d-54*t181*t211*t231*t43)-4.1333333333333333d-52*t211*t2
     5           32*t45+1.2813333333333332d-54*t181*t211*t232*t43)*t96-8
     6           .132426666666666d-52*t121*t128*t336*t96+1.86008522312d-
     7           103*t128*t196*t335*t96+t4*(5.0d-1*rhob*t29*(1.777777777
     8           7777776d-49*t336*t6*t7*t9+1.7777777777777776d-49*t14*t3
     9           36*t7*t9-1.373568d-51*t12*t336*t7*t9-1.373568d-100*t216
     :           *t335*t6*t9+6.367575545855999d-152*t14*t334*t337*t9-2.4
     ;           724223999999997d-100*t14*t216*t335*t9+5.306312954879999
     <           d-103*t12*t216*t335*t9+2.222222222222222d-99*t335*t6*t7
     =           +8.0d-99*t14*t335*t7-1.2362111999999999d-100*t13*t335*t
     >           7-3.43392d-101*t12*t335*t7+2.3111111111111113d-98*t11*t
     ?           335*t7+1.5918938864639998d-102*t10*t335*t337*t6-2.74713
     @           6d-51*t10*t216*t336*t6+1.7777777777777776d-49*t13*t336*
     1           t4+8.888888888888888d-50*t12*t336*t4+2.5470302183424d-2
     2           01*t11*t337/rhob**8.666666666666666d+0-2.74713599999999
     3           95d-150*t14*t216*t334+2.1225251819519997d-152*t13*t216*
     4           t334-1.53839616d-149*t11*t216*t334)+5.0d-1*rhob*t15*t33
     5           2+1.0d+0*t217*t29+1.0d+0*rhob*t208*t217+1.0d+0*t15*t208
     6           )+t1*(2.57544d-52*t217*t29+2.57544d-52*t15*t208)*t7+t21
     7           1*(5.15088d-52*t218-4.2923999999999995d-52*t15*t29)*t7+
     8           1.0d+0*t343*t50+5.0d-1*rhob*t332*t40+1.0d+0*t208*t40+5.
     9           0d-1*rhob*t29*(1.0666666666666666d-50*t32*t336*t39-5.76
     :           d-101*t209*t335*t39+7.68d-152*t333*t334*t39+2.4d-51*t1*
     ;           t32*(1.0666666666666666d-50*t32*t336*t38-5.76d-101*t209
     <           *t335*t38+7.68d-152*t333*t334*t38+2.4d-51*t1*t32*(1.066
     =           6666666666666d-50*t32*t336*t37-5.76d-101*t209*t335*t37+
     >           7.68d-152*t333*t334*t37+2.4d-51*t1*t32*(1.0666666666666
     ?           666d-50*t32*t336*t36-5.76d-101*t209*t335*t36+7.68d-152*
     @           t333*t334*t36)-8.0d-51*t211*t212*t32+1.92d-101*t209*t21
     1           0*t212)-8.0d-51*t211*t213*t32+1.92d-101*t209*t210*t213)
     2           -8.0d-51*t211*t214*t32+1.92d-101*t209*t210*t214)+2.6531
     3           564774399996d-103*t15*t210*t216*t29+1.0d+0*t215*t29+2.0
     4           d+0*t229*t233+1.0d+0*rhob*t208*t215)*wght+Amat2(iq,D2_R
     5           B_RB)
              Cmat2(iq,D2_RA_GAA) = (t110*(1.0d+0*rhoa*t106*t64*(6.86784
     1           0000000001d-2*t112*t114*t193*t6*taua+3.4339200000000003
     2           d-2*gammaaa*t14*t193*t244*taua-3.3333333333333337d+0*t1
     3           12*t113*t14*taua+1.7169600000000002d-2*t112*t113*t12*ta
     4           ua+1.591893886464d-4*t115*t192*t316*t41*t6+2.747136d-2*
     5           t115*t180*t193*t6-1.030176d-2*t114*t14*t192*t193*t41+5.
     6           30631295488d-5*t114*t12*t192*t193*t41-5.15088d-3*t113*t
     7           13*t192*t41+8.241408d-2*t11*t111*t193*t345+1.5918938864
     8           64d-4*t11*t111*t192*t244*t316+1.591893886464d-4*gammaaa
     9           *t112*t114*t14*t192*t316+5.30631295488d-5*gammaaa*t112*
     :           t13*t192*t193-2.060352d-2*gammaaa*t11*t112*t192*t193+5.
     ;           494272d-2*gammaaa*t114*t14*t187*t193+2.747136d-2*gammaa
     <           a*t113*t13*t187-1.0666666666666666d+1*gammaaa*t11*t113*
     =           t187-2.6666666666666666d+0*t113*t114*t14*t180-2.6666666
     >           666666666d+0*t110*t13*t180+1.373568d-2*t113*t114*t12*t1
     ?           80)+1.0d+0*t106*t245*t64-1.25d-1*t103*t194*t64-1.25d-1*
     @           t103*t104*t116*t64+1.0d+0*rhoa*t106*t138*t245-1.25d-1*t
     1           103*t116*t138)+t118*(1.0d+0*t96*(2.033106666666667d-2*t
     2           112*t122*t196*t43*taua+4.066213333333334d-2*t112*t123*t
     3           124*t196*taua+1.0165533333333335d-2*t112*t121*t127*taua
     4           -3.3333333333333337d+0*t112*t121*t122*taua+5.5802556693
     5           60001d-5*t122*t123*t192*t318*t41*t43+1.86008522312d-5*t
     6           126*t192*t196*t41*t43-1.219864d-2*t119*t192*t196*t41*t4
     7           3+3.2529706666666663d-2*gammaaa*t119*t187*t196*t43+1.62
     8           64853333333332d-2*t122*t123*t180*t196*t43+8.13242666666
     9           6667d-3*t121*t126*t180*t43-5.333333333333333d+0*t119*t1
     :           21*t180*t43+5.580255669360001d-5*t124*t125*t192*t318*t4
     ;           1+5.580255669360001d-5*t119*t120*t192*t318*t41+1.860085
     <           22312d-5*t123*t127*t192*t196*t41-6.09932d-3*t122*t123*t
     =           192*t196*t41-3.04966d-3*t121*t126*t192*t41+1.6264853333
     >           333332d-2*gammaaa*t122*t123*t187*t196+1.626485333333333
     ?           2d-2*t124*t125*t180*t196+1.6264853333333332d-2*t119*t12
     @           0*t180*t196+8.132426666666667d-3*gammaaa*t121*t126*t187
     1           -5.333333333333333d+0*gammaaa*t119*t121*t187+8.13242666
     2           6666667d-3*t121*t123*t127*t180-2.6666666666666666d+0*t1
     3           18*t126*t180-2.6666666666666666d+0*t121*t122*t123*t180)
     4           +1.0d+0*t179*t246)+t103*(5.0d-1*rhoa*t105*t64*(6.0d-2*g
     5           ammaaa*t41*t98*(6.0d-2*gammaaa*t41*t98*(-1.599999999999
     6           9998d-1*t180*t98*t99-1.1519999999999996d-3*t111*t313*t3
     7           45*t99+2.879999999999999d-2*gammaaa*t186*t187*t99+6.0d-
     8           2*gammaaa*t41*t98*(-1.5999999999999998d-1*t180*t36*t98-
     9           1.1519999999999996d-3*t111*t313*t345*t36+2.879999999999
     :           999d-2*gammaaa*t186*t187*t36)+6.0d-2*t188*t41*t98-1.599
     ;           9999999999998d-1*gammaaa*t180*t240*t98+9.59999999999999
     <           7d-3*t111*t186*t187*t240-3.6d-3*gammaaa*t112*t186*t188)
     =           +6.0d-2*t189*t41*t98-1.5999999999999998d-1*gammaaa*t180
     >           *t241*t98-1.5999999999999998d-1*t100*t180*t98-1.1519999
     ?           999999996d-3*t100*t111*t313*t345+9.599999999999997d-3*t
     @           111*t186*t187*t241-3.6d-3*gammaaa*t112*t186*t189+2.8799
     1           99999999999d-2*gammaaa*t100*t186*t187)+6.0d-2*t190*t41*
     2           t98-1.5999999999999998d-1*gammaaa*t180*t242*t98-1.59999
     3           99999999998d-1*t101*t180*t98-1.1519999999999996d-3*t101
     4           *t111*t313*t345+9.599999999999997d-3*t111*t186*t187*t24
     5           2-3.6d-3*gammaaa*t112*t186*t190+2.879999999999999d-2*ga
     6           mmaaa*t101*t186*t187)+5.0d-1*t105*t243*t64-1.25d-1*t191
     7           *t64-1.25d-1*t102*t104*t64+5.0d-1*rhoa*t105*t138*t243-1
     8           .25d-1*t102*t138)+1.0d+0*(-8.266666666666665d-3*t180*t4
     9           5*t49-1.5888533333333327d-7*gammaaa*t187*t310*t43*t49+2
     :           .562666666666666d-5*t180*t181*t43*t49+5.125333333333332
     ;           d-5*gammaaa*t181*t187*t49+3.1d-3*t43*t45*(-8.2666666666
     <           66665d-3*t180*t45*t48-1.5888533333333327d-7*gammaaa*t18
     =           7*t310*t43*t48+2.562666666666666d-5*t180*t181*t43*t48+5
     >           .125333333333332d-5*gammaaa*t181*t187*t48+3.1d-3*t43*t4
     ?           5*(-8.266666666666665d-3*t180*t45*t47-1.588853333333332
     @           7d-7*gammaaa*t187*t310*t43*t47+2.562666666666666d-5*t18
     1           0*t181*t43*t47+5.125333333333332d-5*gammaaa*t181*t187*t
     2           47+3.1d-3*t43*t45*(-8.266666666666665d-3*t180*t45*t46-1
     3           .5888533333333327d-7*gammaaa*t187*t310*t43*t46+2.562666
     4           666666666d-5*t180*t181*t43*t46+5.125333333333332d-5*gam
     5           maaa*t181*t187*t46)+3.1d-3*t182*t41*t45-8.2666666666666
     6           65d-3*gammaaa*t180*t236*t45-9.61d-6*t181*t182*t41*t43+2
     7           .562666666666666d-5*gammaaa*t180*t181*t236*t43)+3.1d-3*
     8           t183*t41*t45-8.266666666666665d-3*gammaaa*t180*t237*t45
     9           -9.61d-6*t181*t183*t41*t43+2.562666666666666d-5*gammaaa
     :           *t180*t181*t237*t43)+3.1d-3*t184*t41*t45-8.266666666666
     ;           665d-3*gammaaa*t180*t238*t45-9.61d-6*t181*t184*t41*t43+
     <           2.562666666666666d-5*gammaaa*t180*t181*t238*t43)*t96+1.
     =           86008522312d-5*t128*t192*t196*t41*t96-3.04966d-3*t121*t
     >           192*t246*t96+8.132426666666667d-3*t121*t128*t180*t96+t1
     ?           03*t104*(1.25d-1*gammaaa*t243*t64+t344)+t113*t41*(1.373
     @           568d-2*t106*t116*t64-5.15088d-3*t195)-5.15088d-3*rhoa*t
     1           106*t113*t192*t245*t64+5.30631295488d-5*t106*t107*t116*
     2           t192*t193*t64+6.4386d-4*t103*t113*t116*t192*t64-6.4386d
     3           -4*gammaaa*t103*t113*t116*t180*t64-3.04966d-3*t121*t198
     4           *t41+t103*t104*t110*t346+1.0d+0*t179*t239)*wght+Cmat2(i
     5           q,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (t118*(1.0d+0*(-5.580255669360001d-5
     1           4*t122*t123*t211*t318*t41*t43-1.86008522312d-54*t126*t1
     2           96*t211*t41*t43+2.0331066666666667d-52*t122*t196*t211*t
     3           41*t43+2.0331066666666667d-51*t119*t196*t211*t41*t43-5.
     4           580255669360001d-54*t124*t125*t211*t318*t41-5.580255669
     5           360001d-54*t119*t120*t211*t318*t41-1.86008522312d-54*t1
     6           23*t127*t196*t211*t41+4.0662133333333333d-52*t123*t124*
     7           t196*t211*t41+1.0165533333333333d-51*t122*t123*t196*t21
     8           1*t41+1.0165533333333333d-52*t121*t127*t211*t41+5.08276
     9           6666666666d-52*t121*t126*t211*t41-3.333333333333333d-50
     :           *t121*t122*t211*t41-1.3333333333333333d-49*t119*t121*t2
     ;           11*t41)*t96+1.0d+0*t229*t246)+1.0d+0*(-3.97213333333333
     <           3d-57*t211*t310*t41*t43*t49+1.2813333333333332d-54*t181
     =           *t211*t41*t49+3.1d-3*t43*t45*(-3.972133333333333d-57*t2
     >           11*t310*t41*t43*t48+1.2813333333333332d-54*t181*t211*t4
     ?           1*t48+3.1d-3*t43*t45*(-3.972133333333333d-57*t211*t310*
     @           t41*t43*t47+1.2813333333333332d-54*t181*t211*t41*t47+3.
     1           1d-3*t43*t45*(1.2813333333333332d-54*t181*t211*t41*t46-
     2           3.972133333333333d-57*t211*t310*t41*t43*t46)+3.1d-3*t23
     3           0*t41*t45-2.0666666666666667d-52*t211*t236*t45-9.61d-6*
     4           t181*t230*t41*t43+6.406666666666666d-55*t181*t211*t236*
     5           t43)+3.1d-3*t231*t41*t45-2.0666666666666667d-52*t211*t2
     6           37*t45-9.61d-6*t181*t231*t41*t43+6.406666666666666d-55*
     7           t181*t211*t237*t43)+3.1d-3*t232*t41*t45-2.0666666666666
     8           667d-52*t211*t238*t45-9.61d-6*t181*t232*t41*t43+6.40666
     9           6666666666d-55*t181*t211*t238*t43)*t96-1.86008522312d-5
     :           4*t128*t196*t211*t41*t96+3.04966d-52*t121*t211*t246*t96
     ;           -3.04966d-3*t121*t235*t41+1.0d+0*t229*t239)*wght+Cmat2(
     <           iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t103*(5.0d-1*rhoa*t105*t64*(6.0d-2
     1           *gammaaa*t41*t98*(6.0d-2*gammaaa*t41*t98*(4.32d-4*gamma
     2           aa*t244*t313*t99-7.2d-3*t112*t186*t99+6.0d-2*gammaaa*(4
     3           .32d-4*gammaaa*t244*t313*t36-7.2d-3*t112*t186*t36)*t41*
     4           t98+1.2d-1*t240*t41*t98-7.2d-3*gammaaa*t112*t186*t240)+
     5           1.2d-1*t241*t41*t98+4.32d-4*gammaaa*t100*t244*t313-7.2d
     6           -3*gammaaa*t112*t186*t241-7.2d-3*t100*t112*t186)+1.2d-1
     7           *t242*t41*t98+4.32d-4*gammaaa*t101*t244*t313-7.2d-3*gam
     8           maaa*t112*t186*t242-7.2d-3*t101*t112*t186)-2.5d-1*t243*
     9           t64)+1.0d+0*(5.9582d-8*t112*t310*t43*t49-1.921999999999
     :           9998d-5*t112*t181*t49+3.1d-3*t43*t45*(5.9582d-8*t112*t3
     ;           10*t43*t48-1.9219999999999998d-5*t112*t181*t48+3.1d-3*t
     <           43*t45*(5.9582d-8*t112*t310*t43*t47-1.9219999999999998d
     =           -5*t112*t181*t47+3.1d-3*t43*t45*(5.9582d-8*t112*t310*t4
     >           3*t46-1.9219999999999998d-5*t112*t181*t46)+6.2d-3*t236*
     ?           t41*t45-1.9219999999999998d-5*t181*t236*t41*t43)+6.2d-3
     @           *t237*t41*t45-1.9219999999999998d-5*t181*t237*t41*t43)+
     1           6.2d-3*t238*t41*t45-1.9219999999999998d-5*t181*t238*t41
     2           *t43)*t96+1.0d+0*t118*(5.580255669360001d-5*t112*t122*t
     3           123*t318*t43+1.86008522312d-5*t112*t126*t196*t43-2.4397
     4           28d-2*t112*t119*t196*t43+5.580255669360001d-5*t112*t124
     5           *t125*t318+5.580255669360001d-5*t112*t119*t120*t318+1.8
     6           6008522312d-5*t112*t123*t127*t196-1.219864d-2*t112*t122
     7           *t123*t196-6.09932d-3*t112*t121*t126+2*t112*t119*t121)*
     8           t96-6.09932d-3*t121*t246*t41*t96+1.86008522312d-5*t112*
     9           t128*t196*t96+1.0d+0*rhoa*t106*t110*(1.591893886464d-4*
     :           t112*t115*t316*t6+1.591893886464d-4*gammaaa*t114*t14*t2
     ;           44*t316+1.591893886464d-4*t11*t111*t316/rhoa**1.0666666
     <           666666666d+1+5.30631295488d-5*gammaaa*t13*t193*t244-4.1
     =           20704d-2*gammaaa*t11*t193*t244-2.060352d-2*t112*t114*t1
     >           4*t193+5.30631295488d-5*t112*t114*t12*t193-1.030176d-2*
     ?           t112*t113*t13+2*t11*t112*t113)*t64+1.28772d-3*t103*t113
     @           *t116*t41*t64+5.30631295488d-5*t106*t116*t193*t250*t64-
     1           1.030176d-2*t106*t107*t113*t245*t64-2.5d-1*t103*t110*t2
     2           45*t64)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t110*(1.0d+0*rhoa*t106*t64*(1.373568
     1           d-1*t114*t193*t250*t6*taua-1.3333333333333333d+1*t113*t
     2           250*t6*taua+3.4339200000000003d-2*t113*t12*t250*taua+6.
     3           867840000000001d-2*gammaaa*t14*t193*t249*taua+3.4339200
     4           000000003d-2*t115*t193*t41*t6-6.666666666666667d+0*t113
     5           *t114*t41*t6+3.183787772928d-4*t107*t115*t192*t316*t6-4
     6           .120704d-2*t107*t114*t192*t193*t6+1.7169600000000002d-2
     7           *t113*t114*t12*t41-3.3333333333333337d+0*t110*t12*t41+3
     8           .183787772928d-4*gammaaa*t114*t14*t192*t250*t316+3.1837
     9           87772928d-4*t11*t111*t192*t249*t316-2.060352d-2*gammaaa
     :           *t14*t192*t193*t250+1.061262590976d-4*gammaaa*t13*t192*
     ;           t193*t250+1.4422464000000002d-1*t11*t111*t193*t244+1.06
     <           1262590976d-4*t107*t114*t12*t192*t193+8.928192d-2*gamma
     =           aa*t112*t114*t14*t193-1.030176d-2*t107*t113*t12*t192-8.
     >           666666666666666d+0*gammaaa*t112*t113*t14+4.464096d-2*ga
     ?           mmaaa*t112*t113*t13)+1.0d+0*t106*t251*t64+1.25d-1*gamma
     @           aa*t194*t248*t64+1.25d-1*gammaaa*t104*t116*t248*t64+1.0
     1           d+0*rhoa*t106*t138*t251+1.25d-1*gammaaa*t116*t138*t248)
     2           +t118*(1.0d+0*t96*(4.066213333333334d-2*t122*t196*t250*
     3           t43*taua+8.132426666666668d-2*t123*t124*t196*t250*taua+
     4           2.033106666666667d-2*t121*t127*t250*taua-1.333333333333
     5           3333d+1*t121*t124*t250*taua+2.033106666666667d-2*t122*t
     6           123*t196*t41*t43+1.0165533333333335d-2*t121*t126*t41*t4
     7           3-3.3333333333333337d+0*t121*t122*t41*t43+1.11605113387
     8           20001d-4*t107*t122*t123*t192*t318*t43+3.72017044624d-5*
     9           t107*t126*t192*t196*t43-1.219864d-2*t107*t122*t192*t196
     :           *t43+6.505941333333333d-2*gammaaa*t112*t119*t196*t43+2.
     ;           033106666666667d-2*t124*t125*t196*t41+2.033106666666667
     <           d-2*t119*t120*t196*t41+1.0165533333333335d-2*t121*t123*
     =           t127*t41-3.3333333333333337d+0*t118*t127*t41-6.66666666
     >           6666667d+0*t121*t123*t124*t41+1.1160511338720001d-4*t10
     ?           7*t124*t125*t192*t318+1.1160511338720001d-4*t107*t119*t
     @           120*t192*t318+3.72017044624d-5*t107*t123*t127*t192*t196
     1           -2.439728d-2*t107*t123*t124*t192*t196+3.252970666666666
     2           3d-2*gammaaa*t112*t122*t123*t196-6.09932d-3*t107*t121*t
     3           127*t192+1.6264853333333332d-2*gammaaa*t112*t121*t126-5
     4           .333333333333333d+0*gammaaa*t112*t121*t122)+1.0d+0*t179
     5           *t252)+1.0165533333333335d-2*t121*t128*t41*t96-3.04966d
     6           -3*t121*t192*t252*t96+3.72017044624d-5*t107*t128*t192*t
     7           196*t96+t248*(-5.0d-1*rhoa*t105*t191*t64-5.0d-1*t102*t1
     8           05*t64-5.0d-1*rhoa*t102*t105*t138)+t103*(1.0d+0*rhoa*t1
     9           91*t64+1.0d+0*t102*t64+1.0d+0*rhoa*t102*t138)+t107*t113
     :           *(1.7169600000000002d-2*t106*t116*t64-1.030176d-2*t195)
     ;           +1.061262590976d-4*t106*t116*t192*t193*t51*t64-1.28772d
     <           -3*gammaaa*t103*t113*t116*t41*t64-5.15088d-3*rhoa*t106*
     =           t113*t192*t251*t64+1.25d-1*gammaaa*t103*t104*t110*t251*
     >           t64-6.4386d-4*gammaaa*t113*t116*t192*t248*t64-1.25d-1*g
     ?           ammaaa*t104*t110*t116*t248*t64-1.25d-1*gammaaa*t102*t10
     @           4*t248*t64-6.09932d-3*t107*t121*t198)*wght+Mmat2(iq,D2_
     1           RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = (t118*(1.0d+0*(-1.1160511338720003d-5
     1           3*t107*t122*t123*t211*t318*t43-3.72017044624d-54*t107*t
     2           126*t196*t211*t43+1.6264853333333334d-51*t107*t122*t196
     3           *t211*t43+1.6264853333333334d-51*t107*t119*t196*t211*t4
     4           3-1.1160511338720003d-53*t107*t124*t125*t211*t318-1.116
     5           0511338720003d-53*t107*t119*t120*t211*t318-3.7201704462
     6           4d-54*t107*t123*t127*t196*t211+3.252970666666667d-51*t1
     7           07*t123*t124*t196*t211+8.132426666666667d-52*t107*t122*
     8           t123*t196*t211+8.132426666666667d-52*t107*t121*t127*t21
     9           1+4.0662133333333333d-52*t107*t121*t126*t211-1.33333333
     :           33333333d-49*t107*t121*t124*t211-1.3333333333333333d-49
     ;           *t107*t121*t122*t211)*t96+1.0d+0*t229*t252)+3.04966d-52
     <           *t121*t211*t252*t96-3.72017044624d-54*t107*t128*t196*t2
     =           11*t96-6.09932d-3*t107*t121*t235)*wght+Mmat2(iq,D2_RB_T
     >           A)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (1.0d+0*t118*(1.1160511338720001d-4*
     1           t122*t123*t250*t318*t43+3.72017044624d-5*t126*t196*t250
     2           *t43-1.219864d-2*t122*t196*t250*t43-2.439728d-2*t119*t1
     3           96*t250*t43+1.1160511338720001d-4*t124*t125*t250*t318+1
     4           .1160511338720001d-4*t119*t120*t250*t318+3.72017044624d
     5           -5*t123*t127*t196*t250-2.439728d-2*t123*t124*t196*t250-
     6           1.219864d-2*t122*t123*t196*t250-6.09932d-3*t121*t127*t2
     7           50-6.09932d-3*t121*t126*t250+2.0d+0*t121*t122*t250)*t96
     8           -3.04966d-3*t121*t252*t41*t96+3.72017044624d-5*t128*t19
     9           6*t250*t96-6.09932d-3*t107*t121*t246*t96+t248*(t344-5.0
     :           d-1*rhoa*t105*t243*t64)+1.0d+0*rhoa*t106*t110*(3.183787
     ;           772928d-4*t115*t250*t316*t6-4.120704d-2*t114*t193*t250*
     <           t6+3.183787772928d-4*gammaaa*t114*t14*t249*t316+3.18378
     =           7772928d-4*t11*t111*t316/rhoa**9.666666666666666d+0-2.0
     >           60352d-2*t114*t14*t193*t250+1.061262590976d-4*t114*t12*
     ?           t193*t250+2.0d+0*t113*t14*t250-1.030176d-2*t113*t13*t25
     @           0-1.030176d-2*t113*t12*t250-2.060352d-2*gammaaa*t14*t19
     1           3*t249+1.061262590976d-4*gammaaa*t13*t193*t249-4.120704
     2           d-2*gammaaa*t11*t193*t249)*t64-1.030176d-2*t106*t113*t2
     3           45*t51*t64-6.4386d-4*gammaaa*t113*t116*t248*t41*t64+1.0
     4           61262590976d-4*t106*t116*t193*t347*t64-5.15088d-3*t106*
     5           t107*t113*t251*t64-1.25d-1*t103*t110*t251*t64+1.0d+0*rh
     6           oa*t103*t243*t64+1.28772d-3*t103*t107*t113*t116*t64+t11
     7           0*t248*t346)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*t118*(2.2321022677440003d-4*t
     1           122*t123*t318*t347*t43+7.44034089248d-5*t126*t196*t347*
     2           t43-4.879456d-2*t122*t196*t347*t43+2.2321022677440003d-
     3           4*t124*t125*t318*t347+2.2321022677440003d-4*t119*t120*t
     4           318*t347+7.44034089248d-5*t123*t127*t196*t347-9.758912d
     5           -2*t123*t124*t196*t347-2.439728d-2*t121*t127*t347+8.0d+
     6           0*t121*t124*t347)*t96+7.44034089248d-5*t128*t196*t347*t
     7           96-1.219864d-2*t107*t121*t252*t96+1.0d+0*rhoa*t106*t110
     8           *(6.367575545856d-4*t115*t316*t347*t6-1.6482816d-1*t114
     9           *t193*t347*t6+8.0d+0*t113*t347*t6+6.367575545856d-4*gam
     :           maaa*t114*t14*t316*t349-8.241408d-2*gammaaa*t14*t193*t3
     ;           49+2.122525181952d-4*gammaaa*t13*t193*t349+2.1225251819
     <           52d-4*t114*t12*t193*t347-4.120704d-2*t113*t12*t347+6.36
     =           7575545856d-4*t11*t111*t316/rhoa**8.666666666666666d+0)
     >           *t64-2.060352d-2*t106*t113*t251*t51*t64-2.5d-1*gammaaa*
     ?           t110*t116*t348*t64+1.0d+0*rhoa*t102*t105*t348*t64+2.122
     @           525181952d-4*t106*t116*t193*t255*t64+2.5d-1*gammaaa*t11
     1           0*t248*t251*t64-2.57544d-3*gammaaa*t107*t113*t116*t248*
     2           t64-2.0d+0*rhoa*t102*t248*t64)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhoa**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhoa**6.666666666666666d-1
              t17 = rhoa**5.0d-1
              t18 = 1/t17
              t19 = 1/rhoa**3.333333333333333d-1
              t20 = 1/rhoa**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = param(18)
              t31 = 2.4d-51*t1+1.0d+0
              t32 = 1/t31
              t33 = param(19)
              t34 = param(20)
              t35 = param(21)
              t36 = param(22)
              t37 = 2.4d-51*t1*t32*t36+t35
              t38 = 2.4d-51*t1*t32*t37+t34
              t39 = 2.4d-51*t1*t32*t38+t33
              t40 = 2.4d-51*t1*t32*t39+t30
              t41 = param(17)
              t42 = 1/rhob**2.6666666666666666d+0
              t43 = gammabb*t42
              t44 = t43+4.0d-50*t1
              t45 = 3.1d-3*t44+1.0d+0
              t46 = 1/t45
              t47 = 3.1d-3*t41*t44*t46+param(16)
              t48 = 3.1d-3*t44*t46*t47+param(15)
              t49 = 3.1d-3*t44*t46*t48+param(14)
              t50 = 3.1d-3*t44*t46*t49+param(13)
              t51 = 1/rhob**6.666666666666666d-1
              t52 = rhob**5.0d-1
              t53 = 1/t52
              t54 = 1/rhob**3.333333333333333d-1
              t55 = 1/rhob**1.6666666666666666d-1
              t56 = 1.1120374863094686d+1*t55+3.8447462374472113d+0*t54+
     1           1.644733775567609d+0*t53+2.4058712912881916d-1*t51
              t57 = 3.216395899738507d+1/t56+1.0d+0
              t58 = log(t57)
              t59 = 1.274696188700087d-1*t54+1.0d+0
              t60 = 5.982550435771079d+0*t55+2.2255694211506874d+0*t54+8
     1           .004286349993635d-1*t53+1.8970043257475583d-1*t51
              t61 = 1.6081979498692536d+1/t60+1.0d+0
              t62 = log(t61)
              t63 = 1.3256889990520176d-1*t54+1.0d+0
              t64 = -6.903522198342671d-18*t62*t63-3.1090699999999993d-2
     1           *t58*t59
              t65 = rhob+rhoa
              t66 = 1/t65**3.333333333333333d-1
              t67 = 1.3256889990520176d-1*t66+1.0d+0
              t68 = rhoa-rhob
              t69 = t68**4
              t70 = 1/t65**4
              t71 = 1/t65
              t72 = 1.0d+0-t68*t71
              t73 = t68*t71+1.0d+0
              t74 = t73**1.3333333333333333d+0+t72**1.3333333333333333d+
     1           0-2.0d+0
              t75 = -1.923661050931536d+0*t69*t70*t74
              t76 = t75+1.0d+0
              t77 = 1/t65**6.666666666666666d-1
              t78 = t65**5.0d-1
              t79 = 1/t78
              t80 = 1/t65**1.6666666666666666d-1
              t81 = 5.982550435771079d+0*t80+8.004286349993635d-1*t79+1.
     1           8970043257475583d-1*t77+2.2255694211506874d+0*t66
              t82 = 1.6081979498692536d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = -6.21814d-2*t67*t76*t83
              t85 = 6.901399211255825d-2*t66+1.0d+0
              t86 = t75+1.923661050931536d+0*t74
              t87 = 8.157414703487641d+0*t80+4.3009724712766434d-1*t79+1
     1           .9115125951273373d-1*t77+2.247591863577616d+0*t66
              t88 = 2.9608813203268075d+1/t87+1.0d+0
              t89 = log(t88)
              t90 = 1.9751631321680768d-2*t85*t86*t89
              t91 = 1.274696188700087d-1*t66+1.0d+0
              t92 = 1.1120374863094686d+1*t80+1.644733775567609d+0*t79+2
     1           .4058712912881916d-1*t77+3.8447462374472113d+0*t66
              t93 = 3.216395899738507d+1/t92+1.0d+0
              t94 = log(t93)
              t95 = -5.980796863619711d-2*t69*t70*t74*t91*t94
              t96 = t65*(t95+t90+t84)-rhob*t64-rhoa*t29
              t97 = 6.0d-2*gammabb*t42+1.0d+0
              t98 = 1/t97
              t99 = 6.0d-2*gammabb*t36*t42*t98+t35
              t100 = 6.0d-2*gammabb*t42*t98*t99+t34
              t101 = 6.0d-2*gammabb*t100*t42*t98+t33
              t102 = 6.0d-2*gammabb*t101*t42*t98+t30
              t103 = 1/taub
              t104 = 1/rhob
              t105 = 2.0d+0*taub-2.5d-1*gammabb*t104
              t106 = 1.0d+0-1.25d-1*gammabb*t103*t104
              t107 = 1/rhob**1.6666666666666669d+0
              t108 = 2.0d+0*t107*taub
              t109 = 5.15088d-3*(t43+t108-9.11559972d+0)+1.0d+0
              t110 = 1/t109
              t111 = gammabb**2
              t112 = 1/rhob**5.333333333333333d+0
              t113 = 1/t109**2
              t114 = t108-9.11559972d+0
              t115 = t114**2
              t116 = t113*t115*t6+t5+gammabb*t113*t114*t14*t42+gammabb*t
     1           110*t13*t42+t110*t114*t12+t11*t111*t112*t113
              t117 = 3.04966d-3*(t43+t2+t108-1.823119944d+1)+1.0d+0
              t118 = 1/t117
              t119 = param(4)
              t120 = t44**2
              t121 = 1/t117**2
              t122 = param(5)
              t123 = t8+t108-1.823119944d+1
              t124 = param(6)
              t125 = t123**2
              t126 = param(2)
              t127 = param(3)
              t128 = t118*t126*t44+t121*t122*t123*t44+t118*t123*t127+t12
     1           1*t124*t125+t119*t120*t121+param(1)
              t129 = 1/t26
              t130 = 1/t17**3
              t131 = 1/rhoa**1.3333333333333333d+0
              t132 = 1/rhoa**1.1666666666666667d+0
              t133 = -9.970917392951799d-1*t132-7.418564737168958d-1*t13
     1           1-4.002143174996817d-1*t130-1.264669550498372d-1*t1
              t134 = 1/t25**2
              t135 = 1/t22
              t136 = -1.8533958105157808d+0*t132-1.2815820791490704d+0*t
     1           131-8.223668877838045d-1*t130-1.6039141941921276d-1*t1
              t137 = 1/t21**2
              t138 = 1.1102230246251565d-16*t129*t133*t134*t28+3.0506411
     1           443514264d-19*t131*t27+1.0d+0*t135*t136*t137*t24+1.3210
     2           398931339265d-3*t131*t23
              t139 = 1/t31**2
              t140 = 1/rhoa**4.333333333333333d+0
              t141 = 1/rhoa**2.6666666666666666d+0
              t142 = 9.6d-102*t139*t140*t36-4.0d-51*t141*t32*t36
              t143 = -4.0d-51*t141*t32*t37+9.6d-102*t139*t140*t37+2.4d-5
     1           1*t1*t142*t32
              t144 = -4.0d-51*t141*t32*t38+9.6d-102*t139*t140*t38+2.4d-5
     1           1*t1*t143*t32
              t145 = -4.0d-51*t141*t32*t39+9.6d-102*t139*t140*t39+2.4d-5
     1           1*t1*t144*t32
              t146 = 1/t3**3
              t147 = -6.666666666666666d-50*t141*t6*t7*t9-6.666666666666
     1           666d-50*t14*t141*t7*t9+5.15088d-52*t12*t141*t7*t9+4.120
     2           7039999999995d-101*t14*t140*t146*t9-1.3333333333333333d
     3           -99*t14*t140*t7+2.0603519999999997d-101*t13*t140*t7-5.3
     4           33333333333334d-99*t11*t140*t7+1.030176d-51*t10*t141*t1
     5           46*t6-6.666666666666666d-50*t13*t141*t4-3.3333333333333
     6           33d-50*t12*t141*t4+1.6482816d-150*t11*t146/rhoa**6
              t148 = 5.0d-1*t15*t29+5.0d-1*rhoa*t147*t29+5.0d-1*rhoa*t13
     1           8*t15
              t149 = 1/t65**1.6666666666666669d+0
              t150 = 1/t78**3
              t151 = 1/t65**1.3333333333333333d+0
              t152 = 1/t65**1.1666666666666667d+0
              t153 = -9.970917392951799d-1*t152-7.418564737168958d-1*t15
     1           1-4.002143174996817d-1*t150-1.264669550498372d-1*t149
              t154 = 1/t81**2
              t155 = 1/t82
              t156 = 1.0d+0*t153*t154*t155*t67*t76
              t157 = -1.3595691172479402d+0*t152-7.491972878592053d-1*t1
     1           51-2.1504862356383217d-1*t150-1.2743417300848914d-1*t14
     2           9
              t158 = 1/t87**2
              t159 = 1/t88
              t160 = -5.848223622634647d-1*t157*t158*t159*t85*t86
              t161 = -1.8533958105157808d+0*t152-1.2815820791490704d+0*t
     1           151-8.223668877838045d-1*t150-1.6039141941921276d-1*t14
     2           9
              t162 = 1/t92**2
              t163 = 1/t93
              t164 = 1.923661050931536d+0*t161*t162*t163*t69*t70*t74*t91
              t165 = 1/t65**2
              t166 = t165*t68
              t167 = -t71
              t168 = t167+t166
              t169 = t72**3.333333333333333d-1
              t170 = -t165*t68
              t171 = t71+t170
              t172 = t73**3.333333333333333d-1
              t173 = 1.3333333333333333d+0*t171*t172+1.3333333333333333d
     1           +0*t168*t169
              t174 = -1.923661050931536d+0*t173*t69*t70
              t175 = 1/t65**5
              t176 = 7.694644203726144d+0*t175*t69*t74
              t177 = t68**3
              t178 = -7.694644203726144d+0*t177*t70*t74
              t179 = t178+t176+t174
              t180 = -6.21814d-2*t179*t67*t83
              t181 = 2.747773264188437d-3*t151*t76*t83
              t182 = t178+t176+t174+1.923661050931536d+0*t173
              t183 = 1.9751631321680768d-2*t182*t85*t89
              t184 = -4.5437964274821163d-4*t151*t86*t89
              t185 = -5.980796863619711d-2*t173*t69*t70*t91*t94
              t186 = 1/t65**5.333333333333333d+0
              t187 = 2.541232989148493d-3*t186*t69*t74*t94
              t188 = 2.3923187454478842d-1*t175*t69*t74*t91*t94
              t189 = t95+t65*(-2.3923187454478842d-1*t177*t70*t74*t91*t9
     1           4+t188+t187+t185+t184+t183+t181+t180+t164+t160+t156)+t9
     2           0+t84+6.903522198342671d-18*t27*t28+3.1090699999999993d
     3           -2*t23*t24-rhoa*t138
              t190 = 1/t45**2
              t191 = 6.406666666666666d-55*t141*t190*t41*t44-2.066666666
     1           6666667d-52*t141*t41*t46
              t192 = -2.0666666666666667d-52*t141*t46*t47+6.406666666666
     1           666d-55*t141*t190*t44*t47+3.1d-3*t191*t44*t46
              t193 = -2.0666666666666667d-52*t141*t46*t48+6.406666666666
     1           666d-55*t141*t190*t44*t48+3.1d-3*t192*t44*t46
              t194 = -2.0666666666666667d-52*t141*t46*t49+6.406666666666
     1           666d-55*t141*t190*t44*t49+3.1d-3*t193*t44*t46
              t195 = 1/t117**3
              t196 = 6.09932d-52*t122*t123*t141*t195*t44+3.04966d-52*t12
     1           1*t126*t141*t44-3.333333333333333d-50*t121*t122*t141*t4
     2           4-1.3333333333333333d-49*t119*t121*t141*t44+6.09932d-52
     3           *t124*t125*t141*t195+6.09932d-52*t119*t120*t141*t195+3.
     4           04966d-52*t121*t123*t127*t141-3.333333333333333d-50*t11
     5           8*t127*t141-6.666666666666666d-50*t118*t126*t141-6.6666
     6           66666666666d-50*t121*t123*t124*t141-6.666666666666666d-
     7           50*t121*t122*t123*t141
              t197 = 1.0d+0*t196*t96+1.0d+0*t128*t189
              t198 = 1/t61
              t199 = 1/t52**3
              t200 = 1/rhob**1.3333333333333333d+0
              t201 = 1/rhob**1.1666666666666667d+0
              t202 = -9.970917392951799d-1*t201-7.418564737168958d-1*t20
     1           0-4.002143174996817d-1*t199-1.264669550498372d-1*t107
              t203 = 1/t60**2
              t204 = 1/t57
              t205 = -1.8533958105157808d+0*t201-1.2815820791490704d+0*t
     1           200-8.223668877838045d-1*t199-1.6039141941921276d-1*t10
     2           7
              t206 = 1/t56**2
              t207 = 1.1102230246251565d-16*t198*t202*t203*t63+3.0506411
     1           443514264d-19*t200*t62+1.0d+0*t204*t205*t206*t59+1.3210
     2           398931339265d-3*t200*t58
              t208 = t71+t166
              t209 = t170+t167
              t210 = 1.3333333333333333d+0*t172*t209+1.3333333333333333d
     1           +0*t169*t208
              t211 = -1.923661050931536d+0*t210*t69*t70
              t212 = 7.694644203726144d+0*t177*t70*t74
              t213 = t212+t211+t176
              t214 = -6.21814d-2*t213*t67*t83
              t215 = t212+t211+1.923661050931536d+0*t210+t176
              t216 = 1.9751631321680768d-2*t215*t85*t89
              t217 = -5.980796863619711d-2*t210*t69*t70*t91*t94
              t218 = t95+t65*(2.3923187454478842d-1*t177*t70*t74*t91*t94
     1           +t217+t216+t214+t188+t187+t184+t181+t164+t160+t156)+t90
     2           +t84+6.903522198342671d-18*t62*t63+3.1090699999999993d-
     3           2*t58*t59-rhob*t207
              t219 = 1/rhob**3.6666666666666664d+0
              t220 = 2.562666666666666d-5*gammabb*t190*t219*t41*t44-8.26
     1           6666666666665d-3*gammabb*t219*t41*t46
              t221 = -8.266666666666665d-3*gammabb*t219*t46*t47+2.562666
     1           666666666d-5*gammabb*t190*t219*t44*t47+3.1d-3*t220*t44*
     2           t46
              t222 = -8.266666666666665d-3*gammabb*t219*t46*t48+2.562666
     1           666666666d-5*gammabb*t190*t219*t44*t48+3.1d-3*t221*t44*
     2           t46
              t223 = -8.266666666666665d-3*gammabb*t219*t46*t49+2.562666
     1           666666666d-5*gammabb*t190*t219*t44*t49+3.1d-3*t222*t44*
     2           t46
              t224 = 1/t97**2
              t225 = 1/rhob**6.333333333333333d+0
              t226 = 9.599999999999997d-3*t111*t224*t225*t36-1.599999999
     1           9999998d-1*gammabb*t219*t36*t98
              t227 = -1.5999999999999998d-1*gammabb*t219*t98*t99+9.59999
     1           9999999997d-3*t111*t224*t225*t99+6.0d-2*gammabb*t226*t4
     2           2*t98
              t228 = 6.0d-2*gammabb*t227*t42*t98-1.5999999999999998d-1*g
     1           ammabb*t100*t219*t98+9.599999999999997d-3*t100*t111*t22
     2           4*t225
              t229 = 6.0d-2*gammabb*t228*t42*t98-1.5999999999999998d-1*g
     1           ammabb*t101*t219*t98+9.599999999999997d-3*t101*t111*t22
     2           4*t225
              t230 = -3.3333333333333337d+0*t42*taub-2.6666666666666666d
     1           +0*gammabb*t219
              t231 = 1/t109**3
              t232 = -6.666666666666667d+0*t113*t114*t42*t6*taub-3.33333
     1           33333333337d+0*t110*t12*t42*taub-3.3333333333333337d+0*
     2           gammabb*t112*t113*t14*taub-1.030176d-2*t115*t230*t231*t
     3           6-1.030176d-2*gammabb*t114*t14*t230*t231*t42-5.15088d-3
     4           *gammabb*t113*t13*t230*t42-1.030176d-2*t11*t111*t112*t2
     5           30*t231-5.15088d-3*t113*t114*t12*t230-5.333333333333333
     6           d+0*t11*t111*t113*t225-2.6666666666666666d+0*gammabb*t1
     7           13*t114*t14*t219-2.6666666666666666d+0*gammabb*t110*t13
     8           *t219
              t233 = 1.0d+0*rhob*t106*t232*t64+1.0d+0*t106*t116*t64+1.0d
     1           +0*rhob*t106*t116*t207
              t234 = -3.3333333333333337d+0*t121*t122*t42*t44*taub-3.333
     1           3333333333337d+0*t118*t127*t42*taub-6.666666666666667d+
     2           0*t121*t123*t124*t42*taub-6.09932d-3*t122*t123*t195*t23
     3           0*t44-3.04966d-3*t121*t126*t230*t44-5.333333333333333d+
     4           0*gammabb*t119*t121*t219*t44-6.09932d-3*t124*t125*t195*
     5           t230-6.09932d-3*t119*t120*t195*t230-3.04966d-3*t121*t12
     6           3*t127*t230-2.6666666666666666d+0*gammabb*t118*t126*t21
     7           9-2.6666666666666666d+0*gammabb*t121*t122*t123*t219
              t235 = 1.0d+0*t234*t96+1.0d+0*t128*t218
              t236 = 3.1d-3*t41*t42*t46-9.61d-6*t190*t41*t42*t44
              t237 = 3.1d-3*t42*t46*t47-9.61d-6*t190*t42*t44*t47+3.1d-3*
     1           t236*t44*t46
              t238 = 3.1d-3*t42*t46*t48-9.61d-6*t190*t42*t44*t48+3.1d-3*
     1           t237*t44*t46
              t239 = 3.1d-3*t42*t46*t49-9.61d-6*t190*t42*t44*t49+3.1d-3*
     1           t238*t44*t46
              t240 = 6.0d-2*t36*t42*t98-3.6d-3*gammabb*t112*t224*t36
              t241 = 6.0d-2*t42*t98*t99-3.6d-3*gammabb*t112*t224*t99+6.0
     1           d-2*gammabb*t240*t42*t98
              t242 = 6.0d-2*gammabb*t241*t42*t98+6.0d-2*t100*t42*t98-3.6
     1           d-3*gammabb*t100*t112*t224
              t243 = 6.0d-2*gammabb*t242*t42*t98+6.0d-2*t101*t42*t98-3.6
     1           d-3*gammabb*t101*t112*t224
              t244 = 1/rhob**8
              t245 = -1.030176d-2*t115*t231*t42*t6+t113*t114*t14*t42+t11
     1           0*t13*t42-5.15088d-3*t113*t114*t12*t42-1.030176d-2*t11*
     2           t111*t231*t244-1.030176d-2*gammabb*t112*t114*t14*t231-5
     3           .15088d-3*gammabb*t112*t113*t13+2*gammabb*t11*t112*t113
              t246 = -6.09932d-3*t122*t123*t195*t42*t44-3.04966d-3*t121*
     1           t126*t42*t44+2*t119*t121*t42*t44-6.09932d-3*t124*t125*t
     2           195*t42-6.09932d-3*t119*t120*t195*t42-3.04966d-3*t121*t
     3           123*t127*t42+t118*t126*t42+t121*t122*t123*t42
              t247 = taub**2
              t248 = 1/t247
              t249 = 1/rhob**7
              t250 = 1/rhob**4.333333333333333d+0
              t251 = -2.060352d-2*t107*t115*t231*t6+4.0d+0*t107*t113*t11
     1           4*t6-2.060352d-2*gammabb*t114*t14*t231*t250+2.0d+0*gamm
     2           abb*t113*t14*t250-1.030176d-2*gammabb*t113*t13*t250-2.0
     3           60352d-2*t11*t111*t231*t249-1.030176d-2*t107*t113*t114*
     4           t12+2.0d+0*t107*t110*t12
              t252 = -1.219864d-2*t107*t122*t123*t195*t44-6.09932d-3*t10
     1           7*t121*t126*t44+2.0d+0*t107*t121*t122*t44-1.219864d-2*t
     2           107*t124*t125*t195-1.219864d-2*t107*t119*t120*t195-6.09
     3           932d-3*t107*t121*t123*t127+2.0d+0*t107*t118*t127+4.0d+0
     4           *t107*t121*t123*t124
              t253 = t133**2
              t254 = 1/t17**5
              t255 = 1/rhoa**2.3333333333333334d+0
              t256 = 1/rhoa**2.1666666666666665d+0
              t257 = t136**2
              t258 = 1.7854583920998188d-15*t253*t28/(t25**4*t26**2)+1.1
     1           102230246251565d-16*t129*t134*(1.1632736958443765d+0*t2
     2           56+9.89141964955861d-1*t255+6.003214762495226d-1*t254+2
     3           .1077825841639536d-1*t141)*t28-2.220446049250313d-16*t1
     4           29*t253*t28/t25**3-4.0675215258019015d-19*t255*t27+3.21
     5           6395899738507d+1*t24*t257/(t21**4*t22**2)-2.0d+0*t135*t
     6           24*t257/t21**3+1.0d+0*t135*t137*t24*(2.1622951122684114
     7           d+0*t256+1.7087761055320938d+0*t255+1.2335503316757068d
     8           +0*t254+2.673190323653546d-1*t141)-1.7613865241785684d-
     9           3*t23*t255-8.497974591333913d-2*t131*t135*t136*t137-9.8
     :           12069668265515d-18*t129*t131*t133*t134
              t259 = 1/t31**3
              t260 = 1/rhoa**7
              t261 = 1/rhoa**5.333333333333333d+0
              t262 = 1/rhoa**3.6666666666666664d+0
              t263 = 1/t3**4
              t264 = 2.0d+0*t153*t154*t155*t67*t76
              t265 = -1.1696447245269295d+0*t157*t158*t159*t85*t86
              t266 = 3.847322101863072d+0*t161*t162*t163*t69*t70*t74*t91
              t267 = 5.495546528376875d-3*t151*t76*t83
              t268 = -9.087592854964233d-4*t151*t86*t89
              t269 = 5.082465978296986d-3*t186*t69*t74*t94
              t270 = 4.7846374908957684d-1*t175*t69*t74*t91*t94
              t271 = t153**2
              t272 = 1.6081979498692536d+1*t271*t67*t76/(t81**4*t82**2)
              t273 = -2.0d+0*t155*t271*t67*t76/t81**3
              t274 = -8.837926660346784d-2*t151*t153*t154*t155*t76
              t275 = 1/t65**2.6666666666666666d+0
              t276 = 1/t78**5
              t277 = 1/t65**2.3333333333333334d+0
              t278 = 1/t65**2.1666666666666665d+0
              t279 = 1.0d+0*t154*t155*(1.1632736958443765d+0*t278+9.8914
     1           1964955861d-1*t277+6.003214762495226d-1*t276+2.10778258
     2           41639536d-1*t275)*t67*t76
              t280 = t157**2
              t281 = -1.73158960813529d+1*t280*t85*t86/(t87**4*t88**2)
              t282 = 1.1696447245269295d+0*t159*t280*t85*t86/t87**3
              t283 = 2.690728393099896d-2*t151*t157*t158*t159*t86
              t284 = -5.848223622634647d-1*t158*t159*(1.5861639701225969
     1           d+0*t278+9.98929717145607d-1*t277+3.2257293534574827d-1
     2           *t276+2.1239028834748191d-1*t275)*t85*t86
              t285 = t161**2
              t286 = 6.187255516702861d+1*t285*t69*t70*t74*t91/(t92**4*t
     1           93**2)
              t287 = -3.847322101863072d+0*t163*t285*t69*t70*t74*t91/t92
     1           **3
              t288 = -1.6347222733154887d-1*t161*t162*t163*t186*t69*t74
              t289 = 1.923661050931536d+0*t162*t163*(2.1622951122684114d
     1           +0*t278+1.7087761055320938d+0*t277+1.2335503316757068d+
     2           0*t276+2.673190323653546d-1*t275)*t69*t70*t74*t91
              t290 = -1.538928840745229d+1*t161*t162*t163*t175*t69*t74*t
     1           91
              t291 = 1/t72**6.666666666666666d-1
              t292 = 1/t65**3
              t293 = -2*t292*t68
              t294 = 2*t165
              t295 = 1/t73**6.666666666666666d-1
              t296 = 2*t292*t68
              t297 = -2*t165
              t298 = 1.3333333333333333d+0*t172*(t297+t296)+4.4444444444
     1           44444d-1*t171**2*t295+1.3333333333333333d+0*t169*(t294+
     2           t293)+4.444444444444444d-1*t168**2*t291
              t299 = -1.923661050931536d+0*t298*t69*t70
              t300 = 1.5389288407452287d+1*t173*t175*t69
              t301 = -1.5389288407452287d+1*t173*t177*t70
              t302 = 1/t65**6
              t303 = -3.8473221018630716d+1*t302*t69*t74
              t304 = 6.155715362980915d+1*t175*t177*t74
              t305 = t68**2
              t306 = -2.3083932611178434d+1*t305*t70*t74
              t307 = -3.663697685584583d-3*t277*t76*t83
              t308 = 6.058395236642822d-4*t277*t86*t89
              t309 = -2.3718174565385935d-2*t69*t74*t94/t65**6.333333333
     1           333333d+0
              t310 = -1.1961593727239421d+0*t302*t69*t74*t91*t94
              t311 = -7.176956236343652d-1*t305*t70*t74*t91*t94
              t312 = t65*(1.9138549963583074d+0*t175*t177*t74*t91*t94-5.
     1           980796863619711d-2*t298*t69*t70*t91*t94-4.7846374908957
     2           684d-1*t173*t177*t70*t91*t94+4.7846374908957684d-1*t173
     3           *t175*t69*t91*t94+2.0329863913187946d-2*t177*t186*t74*t
     4           94+5.082465978296986d-3*t173*t186*t69*t94+1.53892884074
     5           5229d+1*t161*t162*t163*t177*t70*t74*t91+3.8473221018630
     6           72d+0*t161*t162*t163*t173*t69*t70*t91+1.975163132168076
     7           8d-2*(t306+t304+t303+t301+t300+t299+1.923661050931536d+
     8           0*t298)*t85*t89-9.087592854964233d-4*t151*t182*t89-1.16
     9           96447245269295d+0*t157*t158*t159*t182*t85-6.21814d-2*(t
     :           306+t304+t303+t301+t300+t299)*t67*t83+5.495546528376875
     ;           d-3*t151*t179*t83+2.0d+0*t153*t154*t155*t179*t67+t311+t
     <           310+t309+t308+t307+t290+t289+t288+t287+t286+t284+t283+t
     =           282+t281+t279+t274+t273+t272)-4.7846374908957684d-1*t17
     >           7*t70*t74*t91*t94-1.1961593727239421d-1*t173*t69*t70*t9
     ?           1*t94+3.9503262643361536d-2*t182*t85*t89-1.243628d-1*t1
     @           79*t67*t83-2.220446049250313d-16*t129*t133*t134*t28+t27
     1           0-6.101282288702853d-19*t131*t27+t269+t268+t267+t266+t2
     2           65+t264-rhoa*t258-2.0d+0*t135*t136*t137*t24-2.642079786
     3           267853d-3*t131*t23
              t313 = 1/t45**3
              t314 = 1/t117**4
              t315 = 2.6666666666666666d+0*t172*t292*t68-2.6666666666666
     1           666d+0*t169*t292*t68+4.444444444444444d-1*t171*t209*t29
     2           5+4.444444444444444d-1*t168*t208*t291
              t316 = -1.923661050931536d+0*t315*t69*t70
              t317 = 7.694644203726144d+0*t175*t210*t69
              t318 = -7.694644203726144d+0*t177*t210*t70
              t319 = 7.694644203726144d+0*t173*t175*t69
              t320 = 7.694644203726144d+0*t173*t177*t70
              t321 = 2.3083932611178434d+1*t305*t70*t74
              t322 = t65*(7.176956236343652d-1*t305*t70*t74*t91*t94-5.98
     1           0796863619711d-2*t315*t69*t70*t91*t94-2.392318745447884
     2           2d-1*t177*t210*t70*t91*t94+2.3923187454478842d-1*t173*t
     3           177*t70*t91*t94+2.3923187454478842d-1*t175*t210*t69*t91
     4           *t94+2.3923187454478842d-1*t173*t175*t69*t91*t94+2.5412
     5           32989148493d-3*t186*t210*t69*t94+2.541232989148493d-3*t
     6           173*t186*t69*t94+1.923661050931536d+0*t161*t162*t163*t2
     7           10*t69*t70*t91+1.923661050931536d+0*t161*t162*t163*t173
     8           *t69*t70*t91+1.9751631321680768d-2*(t321+t320+t319+t318
     9           +t317+t316+1.923661050931536d+0*t315+t303)*t85*t89-4.54
     :           37964274821163d-4*t151*t215*t89-4.5437964274821163d-4*t
     ;           151*t182*t89-5.848223622634647d-1*t157*t158*t159*t215*t
     <           85-5.848223622634647d-1*t157*t158*t159*t182*t85-6.21814
     =           d-2*(t321+t320+t319+t318+t317+t316+t303)*t67*t83+2.7477
     >           73264188437d-3*t151*t213*t83+2.747773264188437d-3*t151*
     ?           t179*t83+1.0d+0*t153*t154*t155*t213*t67+1.0d+0*t153*t15
     @           4*t155*t179*t67+t310+t309+t308+t307+t290+t289+t288+t287
     1           +t286+t284+t283+t282+t281+t279+t274+t273+t272)+t270+t26
     2           9+t268+t267+t266+t265+t264+t217+t216+t214+t185+t183+t18
     3           0
              t323 = t202**2
              t324 = 1/t52**5
              t325 = 1/rhob**2.3333333333333334d+0
              t326 = 1/rhob**2.1666666666666665d+0
              t327 = t205**2
              t328 = 1.7854583920998188d-15*t323*t63/(t60**4*t61**2)-2.2
     1           20446049250313d-16*t198*t323*t63/t60**3+1.1102230246251
     2           565d-16*t198*t203*(2.1077825841639536d-1*t42+1.16327369
     3           58443765d+0*t326+9.89141964955861d-1*t325+6.00321476249
     4           5226d-1*t324)*t63-4.0675215258019015d-19*t325*t62+3.216
     5           395899738507d+1*t327*t59/(t56**4*t57**2)-2.0d+0*t204*t3
     6           27*t59/t56**3+1.0d+0*t204*t206*(2.673190323653546d-1*t4
     7           2+2.1622951122684114d+0*t326+1.7087761055320938d+0*t325
     8           +1.2335503316757068d+0*t324)*t59-1.7613865241785684d-3*
     9           t325*t58-8.497974591333913d-2*t200*t204*t205*t206-9.812
     :           069668265515d-18*t198*t200*t202*t203
              t329 = 1.3333333333333333d+0*t169*(t297+t293)+1.3333333333
     1           333333d+0*t172*(t296+t294)+4.444444444444444d-1*t209**2
     2           *t295+4.444444444444444d-1*t208**2*t291
              t330 = -1.923661050931536d+0*t329*t69*t70
              t331 = 1.5389288407452287d+1*t175*t210*t69
              t332 = 1.5389288407452287d+1*t177*t210*t70
              t333 = -6.155715362980915d+1*t175*t177*t74
              t334 = t65*(-1.9138549963583074d+0*t175*t177*t74*t91*t94-5
     1           .980796863619711d-2*t329*t69*t70*t91*t94+4.784637490895
     2           7684d-1*t177*t210*t70*t91*t94+4.7846374908957684d-1*t17
     3           5*t210*t69*t91*t94-2.0329863913187946d-2*t177*t186*t74*
     4           t94+5.082465978296986d-3*t186*t210*t69*t94-1.5389288407
     5           45229d+1*t161*t162*t163*t177*t70*t74*t91+3.847322101863
     6           072d+0*t161*t162*t163*t210*t69*t70*t91+1.97516313216807
     7           68d-2*(t333+t332+t331+t330+1.923661050931536d+0*t329+t3
     8           06+t303)*t85*t89-9.087592854964233d-4*t151*t215*t89-1.1
     9           696447245269295d+0*t157*t158*t159*t215*t85-6.21814d-2*(
     :           t333+t332+t331+t330+t306+t303)*t67*t83+5.49554652837687
     ;           5d-3*t151*t213*t83+2.0d+0*t153*t154*t155*t213*t67+t311+
     <           t310+t309+t308+t307+t290+t289+t288+t287+t286+t284+t283+
     =           t282+t281+t279+t274+t273+t272)+4.7846374908957684d-1*t1
     >           77*t70*t74*t91*t94-1.1961593727239421d-1*t210*t69*t70*t
     ?           91*t94+3.9503262643361536d-2*t215*t85*t89-1.243628d-1*t
     @           213*t67*t83-2.220446049250313d-16*t198*t202*t203*t63-6.
     1           101282288702853d-19*t200*t62-2.0d+0*t204*t205*t206*t59-
     2           2.642079786267853d-3*t200*t58-rhob*t328+t270+t269+t268+
     3           t267+t266+t265+t264
              t335 = 1/rhob**7.333333333333333d+0
              t336 = 1/rhob**4.666666666666667d+0
              t337 = 1/rhob**2
              t338 = gammabb**3
              t339 = 1/t97**3
              t340 = 1/rhob**10
              t341 = t230**2
              t342 = 1/t109**4
              t343 = 8.88888888888889d+0*t219*taub+9.777777777777779d+0*
     1           gammabb*t336
              t344 = 1.25d-1*t102*t64
              t345 = 1/rhob**9
              t346 = 1.25d-1*gammabb*t245*t64+1.25d-1*t116*t64
              t347 = 1/rhob**3.3333333333333337d+0
              t348 = 1/taub**3
              t349 = 1/rhob**6
              fnc(iq) = (1.0d+0*t50*t96+1.0d+0*t118*t128*t96+1.0d+0*rhob
     1           *t106*t110*t116*t64+5.0d-1*rhob*t102*t103*t105*t64+5.0d
     2           -1*rhoa*t29*t40+5.0d-1*rhoa*t15*t29*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t194*t96+3.04966d-52*t121*t128*t1
     1           41*t96+2.57544d-52*t1*t15*t29*t7+1.0d+0*t189*t50+5.0d-1
     2           *t29*t40+5.0d-1*rhoa*t138*t40+t148*t4+5.0d-1*rhoa*t145*
     3           t29+t118*t197)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-3.04966d-3*t121*t128*t230*t96+1.0d+0*t2
     1           23*t96+t103*(5.0d-1*rhob*t105*t229*t64+5.0d-1*t102*t105
     2           *t64+5.0d-1*rhob*t102*t105*t207)-5.15088d-3*rhob*t106*t
     3           113*t116*t230*t64+1.25d-1*gammabb*t103*t104*t110*t116*t
     4           64+1.25d-1*gammabb*t102*t103*t104*t64+1.0d+0*t218*t50+t
     5           118*t235+t110*t233)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (-3.04966d-3*t121*t128*t42*t96+1.0d+0*t1
     1           18*t246*t96+1.0d+0*t239*t96+t103*(5.0d-1*rhob*t105*t243
     2           *t64-1.25d-1*t102*t64)+1.0d+0*rhob*t106*t110*t245*t64-5
     3           .15088d-3*t106*t107*t113*t116*t64-1.25d-1*t103*t110*t11
     4           6*t64)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*t118*t252*t96-6.09932d-3*t107*t12
     1           1*t128*t96-1.030176d-2*t106*t113*t116*t51*t64+1.0d+0*rh
     2           ob*t106*t110*t251*t64+1.25d-1*gammabb*t110*t116*t248*t6
     3           4-5.0d-1*rhob*t102*t105*t248*t64+1.0d+0*rhob*t102*t103*
     4           t64)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t118*(1.0d+0*(5.580255669359999d-103
     1           *t122*t123*t261*t314*t44-1.6264853333333332d-51*t122*t1
     2           23*t195*t262*t44-8.132426666666666d-52*t121*t126*t262*t
     3           44+8.888888888888888d-50*t121*t122*t262*t44+3.555555555
     4           555555d-49*t119*t121*t262*t44+1.86008522312d-103*t126*t
     5           195*t261*t44-4.0662133333333333d-101*t122*t195*t261*t44
     6           -1.6264853333333334d-100*t119*t195*t261*t44+5.580255669
     7           359999d-103*t124*t125*t261*t314+5.580255669359999d-103*
     8           t119*t120*t261*t314-1.6264853333333332d-51*t124*t125*t1
     9           95*t262-1.6264853333333332d-51*t119*t120*t195*t262-8.13
     :           2426666666666d-52*t121*t123*t127*t262+8.888888888888888
     ;           d-50*t118*t127*t262+1.7777777777777776d-49*t118*t126*t2
     <           62+1.7777777777777776d-49*t121*t123*t124*t262+1.7777777
     =           777777776d-49*t121*t122*t123*t262+1.86008522312d-103*t1
     >           23*t127*t195*t261-8.132426666666667d-101*t123*t124*t195
     ?           *t261-8.132426666666667d-101*t122*t123*t195*t261-2.0331
     @           066666666667d-101*t121*t127*t261-4.0662133333333333d-10
     1           1*t121*t126*t261+2.222222222222222d-99*t121*t124*t261+4
     2           .444444444444444d-99*t121*t122*t261+8.888888888888888d-
     3           99*t119*t121*t261)*t96+1.0d+0*t128*t312+2.0d+0*t189*t19
     4           6)+t121*t141*(3.04966d-52*t196*t96+3.04966d-52*t197+3.0
     5           4966d-52*t128*t189)+1.0d+0*(5.51111111111111d-52*t262*t
     6           46*t49+2.6480888888888887d-106*t261*t313*t44*t49-1.7084
     7           44444444444d-54*t190*t262*t44*t49-8.542222222222222d-10
     8           4*t190*t261*t49+3.1d-3*t44*t46*(5.51111111111111d-52*t2
     9           62*t46*t48+2.6480888888888887d-106*t261*t313*t44*t48-1.
     :           708444444444444d-54*t190*t262*t44*t48-8.542222222222222
     ;           d-104*t190*t261*t48+3.1d-3*t44*t46*(5.51111111111111d-5
     <           2*t262*t46*t47+2.6480888888888887d-106*t261*t313*t44*t4
     =           7-1.708444444444444d-54*t190*t262*t44*t47-8.54222222222
     >           2222d-104*t190*t261*t47+3.1d-3*t44*t46*(5.5111111111111
     ?           1d-52*t262*t41*t46+2.6480888888888887d-106*t261*t313*t4
     @           1*t44-1.708444444444444d-54*t190*t262*t41*t44-8.5422222
     1           22222222d-104*t190*t261*t41)-4.1333333333333333d-52*t14
     2           1*t191*t46+1.2813333333333332d-54*t141*t190*t191*t44)-4
     3           .1333333333333333d-52*t141*t192*t46+1.2813333333333332d
     4           -54*t141*t190*t192*t44)-4.1333333333333333d-52*t141*t19
     5           3*t46+1.2813333333333332d-54*t141*t190*t193*t44)*t96-8.
     6           132426666666666d-52*t121*t128*t262*t96+1.86008522312d-1
     7           03*t128*t195*t261*t96+t4*(5.0d-1*rhoa*t29*(1.7777777777
     8           777776d-49*t262*t6*t7*t9+1.7777777777777776d-49*t14*t26
     9           2*t7*t9-1.373568d-51*t12*t262*t7*t9-1.373568d-100*t146*
     :           t261*t6*t9+6.367575545855999d-152*t14*t260*t263*t9-2.47
     ;           24223999999997d-100*t14*t146*t261*t9+5.306312954879999d
     <           -103*t12*t146*t261*t9+2.222222222222222d-99*t261*t6*t7+
     =           8.0d-99*t14*t261*t7-1.2362111999999999d-100*t13*t261*t7
     >           -3.43392d-101*t12*t261*t7+2.3111111111111113d-98*t11*t2
     ?           61*t7+1.5918938864639998d-102*t10*t261*t263*t6-2.747136
     @           d-51*t10*t146*t262*t6+1.7777777777777776d-49*t13*t262*t
     1           4+8.888888888888888d-50*t12*t262*t4+2.5470302183424d-20
     2           1*t11*t263/rhoa**8.666666666666666d+0-2.747135999999999
     3           5d-150*t14*t146*t260+2.1225251819519997d-152*t13*t146*t
     4           260-1.53839616d-149*t11*t146*t260)+1.0d+0*t147*t29+5.0d
     5           -1*rhoa*t15*t258+1.0d+0*t138*t15+1.0d+0*rhoa*t138*t147)
     6           +t141*(5.15088d-52*t148-4.2923999999999995d-52*t15*t29)
     7           *t7+t1*(2.57544d-52*t147*t29+2.57544d-52*t138*t15)*t7+1
     8           .0d+0*t312*t50+5.0d-1*rhoa*t258*t40+1.0d+0*t138*t40+5.0
     9           d-1*rhoa*t29*(1.0666666666666666d-50*t262*t32*t39-5.76d
     :           -101*t139*t261*t39+7.68d-152*t259*t260*t39+2.4d-51*t1*t
     ;           32*(1.0666666666666666d-50*t262*t32*t38-5.76d-101*t139*
     <           t261*t38+7.68d-152*t259*t260*t38+2.4d-51*t1*t32*(1.0666
     =           666666666666d-50*t262*t32*t37-5.76d-101*t139*t261*t37+7
     >           .68d-152*t259*t260*t37+2.4d-51*t1*t32*(1.06666666666666
     ?           66d-50*t262*t32*t36-5.76d-101*t139*t261*t36+7.68d-152*t
     @           259*t260*t36)-8.0d-51*t141*t142*t32+1.92d-101*t139*t140
     1           *t142)-8.0d-51*t141*t143*t32+1.92d-101*t139*t140*t143)-
     2           8.0d-51*t141*t144*t32+1.92d-101*t139*t140*t144)+2.65315
     3           64774399996d-103*t140*t146*t15*t29+1.0d+0*t145*t29+2.0d
     4           +0*t189*t194+1.0d+0*rhoa*t138*t145)*wght+Amat2(iq,D2_RA
     5           _RA)
              Amat2(iq,D2_RA_RB) = (t118*(1.0d+0*t96*(-2.033106666666667
     1           d-51*t122*t141*t195*t42*t44*taub-4.066213333333334d-51*
     2           t123*t124*t141*t195*t42*taub-1.0165533333333335d-51*t12
     3           1*t127*t141*t42*taub+2.222222222222222d-49*t121*t124*t1
     4           41*t42*taub+2.222222222222222d-49*t121*t122*t141*t42*ta
     5           ub-5.580255669360001d-54*t122*t123*t141*t230*t314*t44-1
     6           .86008522312d-54*t126*t141*t195*t230*t44+2.033106666666
     7           6667d-52*t122*t141*t195*t230*t44+8.132426666666667d-52*
     8           t119*t141*t195*t230*t44-3.2529706666666663d-51*gammabb*
     9           t119*t141*t195*t219*t44-5.580255669360001d-54*t124*t125
     :           *t141*t230*t314-5.580255669360001d-54*t119*t120*t141*t2
     ;           30*t314-1.86008522312d-54*t123*t127*t141*t195*t230+4.06
     <           62133333333333d-52*t123*t124*t141*t195*t230+4.066213333
     =           3333333d-52*t122*t123*t141*t195*t230+1.0165533333333333
     >           d-52*t121*t127*t141*t230+2.0331066666666667d-52*t121*t1
     ?           26*t141*t230-1.6264853333333332d-51*gammabb*t122*t123*t
     @           141*t195*t219-8.132426666666666d-52*gammabb*t121*t126*t
     1           141*t219+8.888888888888888d-50*gammabb*t121*t122*t141*t
     2           219+3.555555555555555d-49*gammabb*t119*t121*t141*t219)+
     3           1.0d+0*t128*t322+1.0d+0*t189*t234+1.0d+0*t196*t218)+t12
     4           1*t141*(3.04966d-52*t234*t96+3.04966d-52*t128*t218)+1.0
     5           d+0*(1.0592355555555552d-56*gammabb*t141*t219*t313*t44*
     6           t49-3.416888888888888d-54*gammabb*t141*t190*t219*t49+3.
     7           1d-3*t44*t46*(1.0592355555555552d-56*gammabb*t141*t219*
     8           t313*t44*t48-3.416888888888888d-54*gammabb*t141*t190*t2
     9           19*t48+3.1d-3*t44*t46*(1.0592355555555552d-56*gammabb*t
     :           141*t219*t313*t44*t47-3.416888888888888d-54*gammabb*t14
     ;           1*t190*t219*t47+3.1d-3*t44*(1.0592355555555552d-56*gamm
     <           abb*t141*t219*t313*t41*t44-3.416888888888888d-54*gammab
     =           b*t141*t190*t219*t41)*t46-2.0666666666666667d-52*t141*t
     >           220*t46-8.266666666666665d-3*gammabb*t191*t219*t46+6.40
     ?           6666666666666d-55*t141*t190*t220*t44+2.562666666666666d
     @           -5*gammabb*t190*t191*t219*t44)-2.0666666666666667d-52*t
     1           141*t221*t46-8.266666666666665d-3*gammabb*t192*t219*t46
     2           +6.406666666666666d-55*t141*t190*t221*t44+2.56266666666
     3           6666d-5*gammabb*t190*t192*t219*t44)-2.0666666666666667d
     4           -52*t141*t222*t46-8.266666666666665d-3*gammabb*t193*t21
     5           9*t46+6.406666666666666d-55*t141*t190*t222*t44+2.562666
     6           666666666d-5*gammabb*t190*t193*t219*t44)*t96-1.86008522
     7           312d-54*t128*t141*t195*t230*t96+1.0d+0*t322*t50-3.04966
     8           d-3*t121*t197*t230+1.0d+0*t189*t223+1.0d+0*t194*t218)*w
     9           ght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t110*(1.0d+0*rhob*t106*t64*(1.373568
     1           d-1*t114*t230*t231*t42*t6*taub+1.7777777777777778d+1*t1
     2           13*t114*t219*t6*taub+3.4339200000000003d-2*t113*t12*t23
     3           0*t42*taub+6.867840000000001d-2*gammabb*t112*t14*t230*t
     4           231*taub+2.6666666666666666d+1*gammabb*t113*t14*t225*ta
     5           ub+8.88888888888889d+0*t110*t12*t219*taub-1.030176d-2*t
     6           115*t231*t343*t6+1.591893886464d-4*t115*t341*t342*t6+2.
     7           2222222222222224d+1*t112*t113*t247*t6-1.030176d-2*gamma
     8           bb*t114*t14*t231*t343*t42-5.15088d-3*gammabb*t113*t13*t
     9           343*t42+1.591893886464d-4*gammabb*t114*t14*t341*t342*t4
     :           2+5.30631295488d-5*gammabb*t13*t231*t341*t42-1.030176d-
     ;           2*t11*t111*t112*t231*t343-5.15088d-3*t113*t114*t12*t343
     <           +1.591893886464d-4*t11*t111*t112*t341*t342+5.3063129548
     =           8d-5*t114*t12*t231*t341+9.777777777777779d+0*gammabb*t1
     >           13*t114*t14*t336+9.777777777777779d+0*gammabb*t110*t13*
     ?           t336+3.377777777777778d+1*t11*t111*t113*t335+1.0988544d
     @           -1*t11*t111*t225*t230*t231+5.494272d-2*gammabb*t114*t14
     1           *t219*t230*t231+2.747136d-2*gammabb*t113*t13*t219*t230)
     2           +1.25d-1*gammabb*t103*t116*t337*t64+2.0d+0*t106*t232*t6
     3           4+1.25d-1*gammabb*t103*t104*t232*t64+1.0d+0*rhob*t106*t
     4           116*t328+2.0d+0*rhob*t106*t207*t232+2.0d+0*t106*t116*t2
     5           07+1.25d-1*gammabb*t103*t104*t116*t207)+t118*(1.0d+0*t9
     6           6*(4.066213333333334d-2*t122*t195*t230*t42*t44*taub+8.8
     7           8888888888889d+0*t121*t122*t219*t44*taub+8.132426666666
     8           668d-2*t123*t124*t195*t230*t42*taub+2.033106666666667d-
     9           2*t121*t127*t230*t42*taub+1.7777777777777778d+1*gammabb
     :           *t121*t122*t225*taub+8.88888888888889d+0*t118*t127*t219
     ;           *taub+1.7777777777777778d+1*t121*t123*t124*t219*taub-6.
     <           09932d-3*t122*t123*t195*t343*t44-3.04966d-3*t121*t126*t
     =           343*t44+5.580255669360001d-5*t122*t123*t314*t341*t44+1.
     >           86008522312d-5*t126*t195*t341*t44+1.9555555555555557d+1
     ?           *gammabb*t119*t121*t336*t44+6.505941333333333d-2*gammab
     @           b*t119*t195*t219*t230*t44-6.09932d-3*t124*t125*t195*t34
     1           3-6.09932d-3*t119*t120*t195*t343-3.04966d-3*t121*t123*t
     2           127*t343+5.580255669360001d-5*t124*t125*t314*t341+5.580
     3           255669360001d-5*t119*t120*t314*t341+1.86008522312d-5*t1
     4           23*t127*t195*t341+9.777777777777779d+0*gammabb*t118*t12
     5           6*t336+9.777777777777779d+0*gammabb*t121*t122*t123*t336
     6           +1.4222222222222222d+1*t111*t119*t121*t335+2.2222222222
     7           222224d+1*t112*t121*t124*t247+3.2529706666666663d-2*gam
     8           mabb*t122*t123*t195*t219*t230+1.6264853333333332d-2*gam
     9           mabb*t121*t126*t219*t230)+1.0d+0*t128*t334+2.0d+0*t218*
     :           t234)+t103*(5.0d-1*rhob*t105*t64*(6.0d-2*gammabb*t42*t9
     ;           8*(6.0d-2*gammabb*t42*t98*(5.866666666666666d-1*gammabb
     <           *t336*t98*t99+3.0719999999999986d-3*t338*t339*t340*t99-
     =           8.639999999999998d-2*t111*t224*t335*t99+6.0d-2*gammabb*
     >           t42*t98*(5.866666666666666d-1*gammabb*t336*t36*t98+3.07
     ?           19999999999986d-3*t338*t339*t340*t36-8.639999999999998d
     @           -2*t111*t224*t335*t36)-3.1999999999999995d-1*gammabb*t2
     1           19*t226*t98+1.9199999999999995d-2*t111*t224*t225*t226)+
     2           5.866666666666666d-1*gammabb*t100*t336*t98-3.1999999999
     3           999995d-1*gammabb*t219*t227*t98+3.0719999999999986d-3*t
     4           100*t338*t339*t340-8.639999999999998d-2*t100*t111*t224*
     5           t335+1.9199999999999995d-2*t111*t224*t225*t227)+5.86666
     6           6666666666d-1*gammabb*t101*t336*t98-3.1999999999999995d
     7           -1*gammabb*t219*t228*t98+3.0719999999999986d-3*t101*t33
     8           8*t339*t340-8.639999999999998d-2*t101*t111*t224*t335+1.
     9           9199999999999995d-2*t111*t224*t225*t228)+1.25d-1*gammab
     :           b*t102*t337*t64+1.0d+0*t105*t229*t64+1.25d-1*gammabb*t1
     ;           04*t229*t64+5.0d-1*rhob*t102*t105*t328+1.0d+0*rhob*t105
     <           *t207*t229+1.0d+0*t102*t105*t207+1.25d-1*gammabb*t102*t
     =           104*t207)+t121*(-3.04966d-3*t128*t343*t96-3.04966d-3*t2
     >           30*t234*t96-3.04966d-3*t230*t235-3.04966d-3*t128*t218*t
     ?           230)+1.0d+0*(3.0311111111111105d-2*gammabb*t336*t46*t49
     @           -9.396444444444442d-5*gammabb*t190*t336*t44*t49+4.23694
     1           22222222203d-7*t111*t313*t335*t44*t49-1.366755555555555
     2           d-4*t111*t190*t335*t49+3.1d-3*t44*t46*(3.03111111111111
     3           05d-2*gammabb*t336*t46*t48-9.396444444444442d-5*gammabb
     4           *t190*t336*t44*t48+4.2369422222222203d-7*t111*t313*t335
     5           *t44*t48-1.366755555555555d-4*t111*t190*t335*t48+3.1d-3
     6           *t44*t46*(3.0311111111111105d-2*gammabb*t336*t46*t47-9.
     7           396444444444442d-5*gammabb*t190*t336*t44*t47+4.23694222
     8           22222203d-7*t111*t313*t335*t44*t47-1.366755555555555d-4
     9           *t111*t190*t335*t47+3.1d-3*t44*t46*(3.0311111111111105d
     :           -2*gammabb*t336*t41*t46-9.396444444444442d-5*gammabb*t1
     ;           90*t336*t41*t44+4.2369422222222203d-7*t111*t313*t335*t4
     <           1*t44-1.366755555555555d-4*t111*t190*t335*t41)-1.653333
     =           333333333d-2*gammabb*t219*t220*t46+5.125333333333332d-5
     >           *gammabb*t190*t219*t220*t44)-1.653333333333333d-2*gamma
     ?           bb*t219*t221*t46+5.125333333333332d-5*gammabb*t190*t219
     @           *t221*t44)-1.653333333333333d-2*gammabb*t219*t222*t46+5
     1           .125333333333332d-5*gammabb*t190*t219*t222*t44)*t96+1.8
     2           6008522312d-5*t128*t195*t341*t96+t113*(-5.15088d-3*rhob
     3           *t106*t116*t343*t64-5.15088d-3*rhob*t106*t230*t232*t64-
     4           5.15088d-3*t106*t116*t230*t64-5.15088d-3*t230*t233-5.15
     5           088d-3*rhob*t106*t116*t207*t230)+t103*t104*t110*(1.25d-
     6           1*gammabb*t232*t64+1.25d-1*gammabb*t116*t207)+t103*t104
     7           *(1.25d-1*gammabb*t229*t64+1.25d-1*gammabb*t102*t207)+5
     8           .30631295488d-5*rhob*t106*t116*t231*t341*t64-1.25d-1*ga
     9           mmabb*t103*t110*t116*t337*t64-1.25d-1*gammabb*t102*t103
     :           *t337*t64-1.28772d-3*gammabb*t103*t104*t113*t116*t230*t
     ;           64+1.0d+0*t334*t50+2.0d+0*t218*t223)*wght+Amat2(iq,D2_R
     <           B_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (t118*(1.0d+0*(-5.580255669360001d-5
     1           4*t122*t123*t141*t314*t42*t44-1.86008522312d-54*t126*t1
     2           41*t195*t42*t44+2.0331066666666667d-52*t122*t141*t195*t
     3           42*t44+2.0331066666666667d-51*t119*t141*t195*t42*t44-5.
     4           580255669360001d-54*t124*t125*t141*t314*t42-5.580255669
     5           360001d-54*t119*t120*t141*t314*t42-1.86008522312d-54*t1
     6           23*t127*t141*t195*t42+4.0662133333333333d-52*t123*t124*
     7           t141*t195*t42+1.0165533333333333d-51*t122*t123*t141*t19
     8           5*t42+1.0165533333333333d-52*t121*t127*t141*t42+5.08276
     9           6666666666d-52*t121*t126*t141*t42-3.333333333333333d-50
     :           *t121*t122*t141*t42-1.3333333333333333d-49*t119*t121*t1
     ;           41*t42)*t96+1.0d+0*t189*t246)+1.0d+0*(-3.97213333333333
     <           3d-57*t141*t313*t42*t44*t49+1.2813333333333332d-54*t141
     =           *t190*t42*t49+3.1d-3*t44*t46*(-3.972133333333333d-57*t1
     >           41*t313*t42*t44*t48+1.2813333333333332d-54*t141*t190*t4
     ?           2*t48+3.1d-3*t44*t46*(-3.972133333333333d-57*t141*t313*
     @           t42*t44*t47+1.2813333333333332d-54*t141*t190*t42*t47+3.
     1           1d-3*t44*(1.2813333333333332d-54*t141*t190*t41*t42-3.97
     2           2133333333333d-57*t141*t313*t41*t42*t44)*t46+3.1d-3*t19
     3           1*t42*t46-2.0666666666666667d-52*t141*t236*t46-9.61d-6*
     4           t190*t191*t42*t44+6.406666666666666d-55*t141*t190*t236*
     5           t44)+3.1d-3*t192*t42*t46-2.0666666666666667d-52*t141*t2
     6           37*t46-9.61d-6*t190*t192*t42*t44+6.406666666666666d-55*
     7           t141*t190*t237*t44)+3.1d-3*t193*t42*t46-2.0666666666666
     8           667d-52*t141*t238*t46-9.61d-6*t190*t193*t42*t44+6.40666
     9           6666666666d-55*t141*t190*t238*t44)*t96-1.86008522312d-5
     :           4*t128*t141*t195*t42*t96+3.04966d-52*t121*t141*t246*t96
     ;           -3.04966d-3*t121*t197*t42+1.0d+0*t189*t239)*wght+Cmat2(
     <           iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t110*(1.0d+0*rhob*t106*t64*(6.86784
     1           0000000001d-2*t112*t114*t231*t6*taub+3.4339200000000003
     2           d-2*gammabb*t14*t231*t244*taub-3.3333333333333337d+0*t1
     3           12*t113*t14*taub+1.7169600000000002d-2*t112*t113*t12*ta
     4           ub+1.591893886464d-4*t115*t230*t342*t42*t6+2.747136d-2*
     5           t115*t219*t231*t6-1.030176d-2*t114*t14*t230*t231*t42+5.
     6           30631295488d-5*t114*t12*t230*t231*t42-5.15088d-3*t113*t
     7           13*t230*t42+8.241408d-2*t11*t111*t231*t345+1.5918938864
     8           64d-4*t11*t111*t230*t244*t342+1.591893886464d-4*gammabb
     9           *t112*t114*t14*t230*t342+5.30631295488d-5*gammabb*t112*
     :           t13*t230*t231-2.060352d-2*gammabb*t11*t112*t230*t231+5.
     ;           494272d-2*gammabb*t114*t14*t225*t231+2.747136d-2*gammab
     <           b*t113*t13*t225-1.0666666666666666d+1*gammabb*t11*t113*
     =           t225-2.6666666666666666d+0*t113*t114*t14*t219-2.6666666
     >           666666666d+0*t110*t13*t219+1.373568d-2*t113*t114*t12*t2
     ?           19)+1.0d+0*t106*t245*t64-1.25d-1*t103*t232*t64-1.25d-1*
     @           t103*t104*t116*t64+1.0d+0*rhob*t106*t207*t245-1.25d-1*t
     1           103*t116*t207)+t118*(1.0d+0*t96*(2.033106666666667d-2*t
     2           112*t122*t195*t44*taub+4.066213333333334d-2*t112*t123*t
     3           124*t195*taub+1.0165533333333335d-2*t112*t121*t127*taub
     4           -3.3333333333333337d+0*t112*t121*t122*taub+5.5802556693
     5           60001d-5*t122*t123*t230*t314*t42*t44+1.86008522312d-5*t
     6           126*t195*t230*t42*t44-1.219864d-2*t119*t195*t230*t42*t4
     7           4+3.2529706666666663d-2*gammabb*t119*t195*t225*t44+1.62
     8           64853333333332d-2*t122*t123*t195*t219*t44+8.13242666666
     9           6667d-3*t121*t126*t219*t44-5.333333333333333d+0*t119*t1
     :           21*t219*t44+5.580255669360001d-5*t124*t125*t230*t314*t4
     ;           2+5.580255669360001d-5*t119*t120*t230*t314*t42+1.860085
     <           22312d-5*t123*t127*t195*t230*t42-6.09932d-3*t122*t123*t
     =           195*t230*t42-3.04966d-3*t121*t126*t230*t42+1.6264853333
     >           333332d-2*gammabb*t122*t123*t195*t225+8.132426666666667
     ?           d-3*gammabb*t121*t126*t225-5.333333333333333d+0*gammabb
     @           *t119*t121*t225+1.6264853333333332d-2*t124*t125*t195*t2
     1           19+1.6264853333333332d-2*t119*t120*t195*t219+8.13242666
     2           6666667d-3*t121*t123*t127*t219-2.6666666666666666d+0*t1
     3           18*t126*t219-2.6666666666666666d+0*t121*t122*t123*t219)
     4           +1.0d+0*t218*t246)+t103*(5.0d-1*rhob*t105*t64*(6.0d-2*g
     5           ammabb*t42*t98*(6.0d-2*gammabb*t42*t98*(-1.599999999999
     6           9998d-1*t219*t98*t99-1.1519999999999996d-3*t111*t339*t3
     7           45*t99+2.879999999999999d-2*gammabb*t224*t225*t99+6.0d-
     8           2*gammabb*t42*t98*(-1.5999999999999998d-1*t219*t36*t98-
     9           1.1519999999999996d-3*t111*t339*t345*t36+2.879999999999
     :           999d-2*gammabb*t224*t225*t36)+6.0d-2*t226*t42*t98-1.599
     ;           9999999999998d-1*gammabb*t219*t240*t98+9.59999999999999
     <           7d-3*t111*t224*t225*t240-3.6d-3*gammabb*t112*t224*t226)
     =           +6.0d-2*t227*t42*t98-1.5999999999999998d-1*gammabb*t219
     >           *t241*t98-1.5999999999999998d-1*t100*t219*t98-1.1519999
     ?           999999996d-3*t100*t111*t339*t345+9.599999999999997d-3*t
     @           111*t224*t225*t241-3.6d-3*gammabb*t112*t224*t227+2.8799
     1           99999999999d-2*gammabb*t100*t224*t225)+6.0d-2*t228*t42*
     2           t98-1.5999999999999998d-1*gammabb*t219*t242*t98-1.59999
     3           99999999998d-1*t101*t219*t98-1.1519999999999996d-3*t101
     4           *t111*t339*t345+9.599999999999997d-3*t111*t224*t225*t24
     5           2-3.6d-3*gammabb*t112*t224*t228+2.879999999999999d-2*ga
     6           mmabb*t101*t224*t225)+5.0d-1*t105*t243*t64-1.25d-1*t229
     7           *t64-1.25d-1*t102*t104*t64+5.0d-1*rhob*t105*t207*t243-1
     8           .25d-1*t102*t207)+1.0d+0*(-8.266666666666665d-3*t219*t4
     9           6*t49-1.5888533333333327d-7*gammabb*t225*t313*t44*t49+2
     :           .562666666666666d-5*t190*t219*t44*t49+5.125333333333332
     ;           d-5*gammabb*t190*t225*t49+3.1d-3*t44*t46*(-8.2666666666
     <           66665d-3*t219*t46*t48-1.5888533333333327d-7*gammabb*t22
     =           5*t313*t44*t48+2.562666666666666d-5*t190*t219*t44*t48+5
     >           .125333333333332d-5*gammabb*t190*t225*t48+3.1d-3*t44*t4
     ?           6*(-8.266666666666665d-3*t219*t46*t47-1.588853333333332
     @           7d-7*gammabb*t225*t313*t44*t47+2.562666666666666d-5*t19
     1           0*t219*t44*t47+5.125333333333332d-5*gammabb*t190*t225*t
     2           47+3.1d-3*t44*t46*(-8.266666666666665d-3*t219*t41*t46-1
     3           .5888533333333327d-7*gammabb*t225*t313*t41*t44+2.562666
     4           666666666d-5*t190*t219*t41*t44+5.125333333333332d-5*gam
     5           mabb*t190*t225*t41)+3.1d-3*t220*t42*t46-8.2666666666666
     6           65d-3*gammabb*t219*t236*t46-9.61d-6*t190*t220*t42*t44+2
     7           .562666666666666d-5*gammabb*t190*t219*t236*t44)+3.1d-3*
     8           t221*t42*t46-8.266666666666665d-3*gammabb*t219*t237*t46
     9           -9.61d-6*t190*t221*t42*t44+2.562666666666666d-5*gammabb
     :           *t190*t219*t237*t44)+3.1d-3*t222*t42*t46-8.266666666666
     ;           665d-3*gammabb*t219*t238*t46-9.61d-6*t190*t222*t42*t44+
     <           2.562666666666666d-5*gammabb*t190*t219*t238*t44)*t96+1.
     =           86008522312d-5*t128*t195*t230*t42*t96-3.04966d-3*t121*t
     >           230*t246*t96+8.132426666666667d-3*t121*t128*t219*t96+t1
     ?           03*t104*(1.25d-1*gammabb*t243*t64+t344)+t113*t42*(1.373
     @           568d-2*t106*t116*t64-5.15088d-3*t233)-5.15088d-3*rhob*t
     1           106*t113*t230*t245*t64+5.30631295488d-5*t106*t107*t116*
     2           t230*t231*t64+6.4386d-4*t103*t113*t116*t230*t64-6.4386d
     3           -4*gammabb*t103*t113*t116*t219*t64-3.04966d-3*t121*t235
     4           *t42+t103*t104*t110*t346+1.0d+0*t218*t239)*wght+Cmat2(i
     5           q,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (t103*(5.0d-1*rhob*t105*t64*(6.0d-2
     1           *gammabb*t42*t98*(6.0d-2*gammabb*t42*t98*(4.32d-4*gamma
     2           bb*t244*t339*t99-7.2d-3*t112*t224*t99+6.0d-2*gammabb*(4
     3           .32d-4*gammabb*t244*t339*t36-7.2d-3*t112*t224*t36)*t42*
     4           t98+1.2d-1*t240*t42*t98-7.2d-3*gammabb*t112*t224*t240)+
     5           1.2d-1*t241*t42*t98+4.32d-4*gammabb*t100*t244*t339-7.2d
     6           -3*gammabb*t112*t224*t241-7.2d-3*t100*t112*t224)+1.2d-1
     7           *t242*t42*t98+4.32d-4*gammabb*t101*t244*t339-7.2d-3*gam
     8           mabb*t112*t224*t242-7.2d-3*t101*t112*t224)-2.5d-1*t243*
     9           t64)+1.0d+0*(5.9582d-8*t112*t313*t44*t49-1.921999999999
     :           9998d-5*t112*t190*t49+3.1d-3*t44*t46*(5.9582d-8*t112*t3
     ;           13*t44*t48-1.9219999999999998d-5*t112*t190*t48+3.1d-3*t
     <           44*t46*(5.9582d-8*t112*t313*t44*t47-1.9219999999999998d
     =           -5*t112*t190*t47+3.1d-3*t44*(5.9582d-8*t112*t313*t41*t4
     >           4-1.9219999999999998d-5*t112*t190*t41)*t46+6.2d-3*t236*
     ?           t42*t46-1.9219999999999998d-5*t190*t236*t42*t44)+6.2d-3
     @           *t237*t42*t46-1.9219999999999998d-5*t190*t237*t42*t44)+
     1           6.2d-3*t238*t42*t46-1.9219999999999998d-5*t190*t238*t42
     2           *t44)*t96+1.0d+0*t118*(5.580255669360001d-5*t112*t122*t
     3           123*t314*t44+1.86008522312d-5*t112*t126*t195*t44-2.4397
     4           28d-2*t112*t119*t195*t44+5.580255669360001d-5*t112*t124
     5           *t125*t314+5.580255669360001d-5*t112*t119*t120*t314+1.8
     6           6008522312d-5*t112*t123*t127*t195-1.219864d-2*t112*t122
     7           *t123*t195-6.09932d-3*t112*t121*t126+2*t112*t119*t121)*
     8           t96-6.09932d-3*t121*t246*t42*t96+1.86008522312d-5*t112*
     9           t128*t195*t96+1.0d+0*rhob*t106*t110*(1.591893886464d-4*
     :           t112*t115*t342*t6+1.591893886464d-4*gammabb*t114*t14*t2
     ;           44*t342+1.591893886464d-4*t11*t111*t342/rhob**1.0666666
     <           666666666d+1+5.30631295488d-5*gammabb*t13*t231*t244-4.1
     =           20704d-2*gammabb*t11*t231*t244-2.060352d-2*t112*t114*t1
     >           4*t231+5.30631295488d-5*t112*t114*t12*t231-1.030176d-2*
     ?           t112*t113*t13+2*t11*t112*t113)*t64+1.28772d-3*t103*t113
     @           *t116*t42*t64+5.30631295488d-5*t106*t116*t231*t250*t64-
     1           1.030176d-2*t106*t107*t113*t245*t64-2.5d-1*t103*t110*t2
     2           45*t64)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = (t118*(1.0d+0*(-1.1160511338720003d-5
     1           3*t107*t122*t123*t141*t314*t44-3.72017044624d-54*t107*t
     2           126*t141*t195*t44+1.6264853333333334d-51*t107*t122*t141
     3           *t195*t44+1.6264853333333334d-51*t107*t119*t141*t195*t4
     4           4-1.1160511338720003d-53*t107*t124*t125*t141*t314-1.116
     5           0511338720003d-53*t107*t119*t120*t141*t314-3.7201704462
     6           4d-54*t107*t123*t127*t141*t195+3.252970666666667d-51*t1
     7           07*t123*t124*t141*t195+8.132426666666667d-52*t107*t122*
     8           t123*t141*t195+8.132426666666667d-52*t107*t121*t127*t14
     9           1+4.0662133333333333d-52*t107*t121*t126*t141-1.33333333
     :           33333333d-49*t107*t121*t124*t141-1.3333333333333333d-49
     ;           *t107*t121*t122*t141)*t96+1.0d+0*t189*t252)+3.04966d-52
     <           *t121*t141*t252*t96-3.72017044624d-54*t107*t128*t141*t1
     =           95*t96-6.09932d-3*t107*t121*t197)*wght+Mmat2(iq,D2_RA_T
     >           B)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t110*(1.0d+0*rhob*t106*t64*(1.373568
     1           d-1*t114*t231*t250*t6*taub-1.3333333333333333d+1*t113*t
     2           250*t6*taub+3.4339200000000003d-2*t113*t12*t250*taub+6.
     3           867840000000001d-2*gammabb*t14*t231*t249*taub+3.4339200
     4           000000003d-2*t115*t231*t42*t6-6.666666666666667d+0*t113
     5           *t114*t42*t6+3.183787772928d-4*t107*t115*t230*t342*t6-4
     6           .120704d-2*t107*t114*t230*t231*t6+1.7169600000000002d-2
     7           *t113*t114*t12*t42-3.3333333333333337d+0*t110*t12*t42+3
     8           .183787772928d-4*gammabb*t114*t14*t230*t250*t342+3.1837
     9           87772928d-4*t11*t111*t230*t249*t342-2.060352d-2*gammabb
     :           *t14*t230*t231*t250+1.061262590976d-4*gammabb*t13*t230*
     ;           t231*t250+1.4422464000000002d-1*t11*t111*t231*t244+1.06
     <           1262590976d-4*t107*t114*t12*t230*t231+8.928192d-2*gamma
     =           bb*t112*t114*t14*t231-1.030176d-2*t107*t113*t12*t230-8.
     >           666666666666666d+0*gammabb*t112*t113*t14+4.464096d-2*ga
     ?           mmabb*t112*t113*t13)+1.0d+0*t106*t251*t64+1.25d-1*gamma
     @           bb*t232*t248*t64+1.25d-1*gammabb*t104*t116*t248*t64+1.0
     1           d+0*rhob*t106*t207*t251+1.25d-1*gammabb*t116*t207*t248)
     2           +t118*(1.0d+0*t96*(4.066213333333334d-2*t122*t195*t250*
     3           t44*taub+8.132426666666668d-2*t123*t124*t195*t250*taub+
     4           2.033106666666667d-2*t121*t127*t250*taub-1.333333333333
     5           3333d+1*t121*t124*t250*taub+2.033106666666667d-2*t122*t
     6           123*t195*t42*t44+1.0165533333333335d-2*t121*t126*t42*t4
     7           4-3.3333333333333337d+0*t121*t122*t42*t44+1.11605113387
     8           20001d-4*t107*t122*t123*t230*t314*t44+3.72017044624d-5*
     9           t107*t126*t195*t230*t44-1.219864d-2*t107*t122*t195*t230
     :           *t44+6.505941333333333d-2*gammabb*t112*t119*t195*t44+2.
     ;           033106666666667d-2*t124*t125*t195*t42+2.033106666666667
     <           d-2*t119*t120*t195*t42+1.0165533333333335d-2*t121*t123*
     =           t127*t42-3.3333333333333337d+0*t118*t127*t42-6.66666666
     >           6666667d+0*t121*t123*t124*t42+1.1160511338720001d-4*t10
     ?           7*t124*t125*t230*t314+1.1160511338720001d-4*t107*t119*t
     @           120*t230*t314+3.72017044624d-5*t107*t123*t127*t195*t230
     1           -2.439728d-2*t107*t123*t124*t195*t230-6.09932d-3*t107*t
     2           121*t127*t230+3.2529706666666663d-2*gammabb*t112*t122*t
     3           123*t195+1.6264853333333332d-2*gammabb*t112*t121*t126-5
     4           .333333333333333d+0*gammabb*t112*t121*t122)+1.0d+0*t218
     5           *t252)+1.0165533333333335d-2*t121*t128*t42*t96-3.04966d
     6           -3*t121*t230*t252*t96+3.72017044624d-5*t107*t128*t195*t
     7           230*t96+t248*(-5.0d-1*rhob*t105*t229*t64-5.0d-1*t102*t1
     8           05*t64-5.0d-1*rhob*t102*t105*t207)+t103*(1.0d+0*rhob*t2
     9           29*t64+1.0d+0*t102*t64+1.0d+0*rhob*t102*t207)+t107*t113
     :           *(1.7169600000000002d-2*t106*t116*t64-1.030176d-2*t233)
     ;           +1.061262590976d-4*t106*t116*t230*t231*t51*t64-1.28772d
     <           -3*gammabb*t103*t113*t116*t42*t64-5.15088d-3*rhob*t106*
     =           t113*t230*t251*t64+1.25d-1*gammabb*t103*t104*t110*t251*
     >           t64-6.4386d-4*gammabb*t113*t116*t230*t248*t64-1.25d-1*g
     ?           ammabb*t104*t110*t116*t248*t64-1.25d-1*gammabb*t102*t10
     @           4*t248*t64-6.09932d-3*t107*t121*t235)*wght+Mmat2(iq,D2_
     1           RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.0d+0*t118*(1.1160511338720001d-4*
     1           t122*t123*t250*t314*t44+3.72017044624d-5*t126*t195*t250
     2           *t44-1.219864d-2*t122*t195*t250*t44-2.439728d-2*t119*t1
     3           95*t250*t44+1.1160511338720001d-4*t124*t125*t250*t314+1
     4           .1160511338720001d-4*t119*t120*t250*t314+3.72017044624d
     5           -5*t123*t127*t195*t250-2.439728d-2*t123*t124*t195*t250-
     6           1.219864d-2*t122*t123*t195*t250-6.09932d-3*t121*t127*t2
     7           50-6.09932d-3*t121*t126*t250+2.0d+0*t121*t122*t250)*t96
     8           -3.04966d-3*t121*t252*t42*t96+3.72017044624d-5*t128*t19
     9           5*t250*t96-6.09932d-3*t107*t121*t246*t96+t248*(t344-5.0
     :           d-1*rhob*t105*t243*t64)+1.0d+0*rhob*t106*t110*(3.183787
     ;           772928d-4*t115*t250*t342*t6-4.120704d-2*t114*t231*t250*
     <           t6+3.183787772928d-4*gammabb*t114*t14*t249*t342+3.18378
     =           7772928d-4*t11*t111*t342/rhob**9.666666666666666d+0-2.0
     >           60352d-2*t114*t14*t231*t250+1.061262590976d-4*t114*t12*
     ?           t231*t250+2.0d+0*t113*t14*t250-1.030176d-2*t113*t13*t25
     @           0-1.030176d-2*t113*t12*t250-2.060352d-2*gammabb*t14*t23
     1           1*t249+1.061262590976d-4*gammabb*t13*t231*t249-4.120704
     2           d-2*gammabb*t11*t231*t249)*t64-1.030176d-2*t106*t113*t2
     3           45*t51*t64-6.4386d-4*gammabb*t113*t116*t248*t42*t64+1.0
     4           61262590976d-4*t106*t116*t231*t347*t64-5.15088d-3*t106*
     5           t107*t113*t251*t64-1.25d-1*t103*t110*t251*t64+1.0d+0*rh
     6           ob*t103*t243*t64+1.28772d-3*t103*t107*t113*t116*t64+t11
     7           0*t248*t346)*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*t118*(2.2321022677440003d-4*t
     1           122*t123*t314*t347*t44+7.44034089248d-5*t126*t195*t347*
     2           t44-4.879456d-2*t122*t195*t347*t44+2.2321022677440003d-
     3           4*t124*t125*t314*t347+2.2321022677440003d-4*t119*t120*t
     4           314*t347+7.44034089248d-5*t123*t127*t195*t347-9.758912d
     5           -2*t123*t124*t195*t347-2.439728d-2*t121*t127*t347+8.0d+
     6           0*t121*t124*t347)*t96+7.44034089248d-5*t128*t195*t347*t
     7           96-1.219864d-2*t107*t121*t252*t96+1.0d+0*rhob*t106*t110
     8           *(6.367575545856d-4*t115*t342*t347*t6-1.6482816d-1*t114
     9           *t231*t347*t6+8.0d+0*t113*t347*t6+6.367575545856d-4*gam
     :           mabb*t114*t14*t342*t349-8.241408d-2*gammabb*t14*t231*t3
     ;           49+2.122525181952d-4*gammabb*t13*t231*t349+2.1225251819
     <           52d-4*t114*t12*t231*t347-4.120704d-2*t113*t12*t347+6.36
     =           7575545856d-4*t11*t111*t342/rhob**8.666666666666666d+0)
     >           *t64-2.060352d-2*t106*t113*t251*t51*t64-2.5d-1*gammabb*
     ?           t110*t116*t348*t64+1.0d+0*rhob*t102*t105*t348*t64+2.122
     @           525181952d-4*t106*t116*t231*t325*t64+2.5d-1*gammabb*t11
     1           0*t248*t251*t64-2.57544d-3*gammabb*t107*t113*t116*t248*
     2           t64-2.0d+0*rhob*t102*t248*t64)*wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhoa**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhoa**6.666666666666666d-1
              t17 = rhoa**5.0d-1
              t18 = 1/t17
              t19 = 1/rhoa**3.333333333333333d-1
              t20 = 1/rhoa**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = param(18)
              t31 = 2.4d-51*t1+1.0d+0
              t32 = 1/t31
              t33 = param(19)
              t34 = param(20)
              t35 = param(21)
              t36 = param(22)
              t37 = 2.4d-51*t1*t32*t36+t35
              t38 = 2.4d-51*t1*t32*t37+t34
              t39 = 2.4d-51*t1*t32*t38+t33
              t40 = 2.4d-51*t1*t32*t39+t30
              t41 = 1/rhob**1.6666666666666669d+0
              t42 = 6.0d-50*t41
              t43 = 5.15088d-3*(t42-9.11559972d+0)+1.0d+0
              t44 = 1/t43
              t45 = 1/t43**2
              t46 = 2.0d-50*t41
              t47 = t46-9.11559972d+0
              t48 = t47**2
              t49 = t45*t48*t6+t5+4.0d-50*t14*t41*t45*t47+t12*t44*t47+1.
     1           6d-99*t11*t45/rhob**3.3333333333333337d+0+4.0d-50*t13*t
     2           41*t44
              t50 = 1/rhob**6.666666666666666d-1
              t51 = rhob**5.0d-1
              t52 = 1/t51
              t53 = 1/rhob**3.333333333333333d-1
              t54 = 1/rhob**1.6666666666666666d-1
              t55 = 1.1120374863094686d+1*t54+3.8447462374472113d+0*t53+
     1           1.644733775567609d+0*t52+2.4058712912881916d-1*t50
              t56 = 3.216395899738507d+1/t55+1.0d+0
              t57 = log(t56)
              t58 = 1.274696188700087d-1*t53+1.0d+0
              t59 = 5.982550435771079d+0*t54+2.2255694211506874d+0*t53+8
     1           .004286349993635d-1*t52+1.8970043257475583d-1*t50
              t60 = 1.6081979498692536d+1/t59+1.0d+0
              t61 = log(t60)
              t62 = 1.3256889990520176d-1*t53+1.0d+0
              t63 = -6.903522198342671d-18*t61*t62-3.1090699999999993d-2
     1           *t57*t58
              t64 = 2.4d-51*t41+1.0d+0
              t65 = 1/t64
              t66 = 2.4d-51*t36*t41*t65+t35
              t67 = 2.4d-51*t41*t65*t66+t34
              t68 = 2.4d-51*t41*t65*t67+t33
              t69 = 2.4d-51*t41*t65*t68+t30
              t70 = param(6)
              t71 = 3.04966d-3*(t42+t2-1.823119944d+1)+1.0d+0
              t72 = 1/t71**2
              t73 = t8+t46-1.823119944d+1
              t74 = t73**2
              t75 = param(4)
              t76 = 4.0d-50*t41+4.0d-50*t1
              t77 = t76**2
              t78 = param(3)
              t79 = 1/t71
              t80 = param(2)
              t81 = param(5)
              t82 = t72*t73*t76*t81+t76*t79*t80+t73*t78*t79+t72*t75*t77+
     1           t70*t72*t74+param(1)
              t83 = rhob+rhoa
              t84 = 1/t83**3.333333333333333d-1
              t85 = 1.3256889990520176d-1*t84+1.0d+0
              t86 = rhoa-rhob
              t87 = t86**4
              t88 = 1/t83**4
              t89 = 1/t83
              t90 = 1.0d+0-t86*t89
              t91 = t86*t89+1.0d+0
              t92 = t91**1.3333333333333333d+0+t90**1.3333333333333333d+
     1           0-2.0d+0
              t93 = -1.923661050931536d+0*t87*t88*t92
              t94 = t93+1.0d+0
              t95 = 1/t83**6.666666666666666d-1
              t96 = t83**5.0d-1
              t97 = 1/t96
              t98 = 1/t83**1.6666666666666666d-1
              t99 = 5.982550435771079d+0*t98+8.004286349993635d-1*t97+1.
     1           8970043257475583d-1*t95+2.2255694211506874d+0*t84
              t100 = 1.6081979498692536d+1/t99+1.0d+0
              t101 = log(t100)
              t102 = -6.21814d-2*t101*t85*t94
              t103 = 6.901399211255825d-2*t84+1.0d+0
              t104 = t93+1.923661050931536d+0*t92
              t105 = 8.157414703487641d+0*t98+4.3009724712766434d-1*t97+
     1           1.9115125951273373d-1*t95+2.247591863577616d+0*t84
              t106 = 2.9608813203268075d+1/t105+1.0d+0
              t107 = log(t106)
              t108 = 1.9751631321680768d-2*t103*t104*t107
              t109 = 1.274696188700087d-1*t84+1.0d+0
              t110 = 1.1120374863094686d+1*t98+1.644733775567609d+0*t97+
     1           2.4058712912881916d-1*t95+3.8447462374472113d+0*t84
              t111 = 3.216395899738507d+1/t110+1.0d+0
              t112 = log(t111)
              t113 = -5.980796863619711d-2*t109*t112*t87*t88*t92
              t114 = (t113+t108+t102)*t83-rhob*t63-rhoa*t29
              t115 = 3.1d-3*t76+1.0d+0
              t116 = 1/t115
              t117 = param(17)
              t118 = 3.1d-3*t116*t117*t76+param(16)
              t119 = 3.1d-3*t116*t118*t76+param(15)
              t120 = 3.1d-3*t116*t119*t76+param(14)
              t121 = 3.1d-3*t116*t120*t76+param(13)
              t122 = 1/t26
              t123 = 1/t17**3
              t124 = 1/rhoa**1.3333333333333333d+0
              t125 = 1/rhoa**1.1666666666666667d+0
              t126 = -9.970917392951799d-1*t125-7.418564737168958d-1*t12
     1           4-4.002143174996817d-1*t123-1.264669550498372d-1*t1
              t127 = 1/t25**2
              t128 = 1/t22
              t129 = -1.8533958105157808d+0*t125-1.2815820791490704d+0*t
     1           124-8.223668877838045d-1*t123-1.6039141941921276d-1*t1
              t130 = 1/t21**2
              t131 = 1.1102230246251565d-16*t122*t126*t127*t28+3.0506411
     1           443514264d-19*t124*t27+1.0d+0*t128*t129*t130*t24+1.3210
     2           398931339265d-3*t124*t23
              t132 = 1/t31**2
              t133 = 1/rhoa**4.333333333333333d+0
              t134 = 1/rhoa**2.6666666666666666d+0
              t135 = 9.6d-102*t132*t133*t36-4.0d-51*t134*t32*t36
              t136 = -4.0d-51*t134*t32*t37+9.6d-102*t132*t133*t37+2.4d-5
     1           1*t1*t135*t32
              t137 = -4.0d-51*t134*t32*t38+9.6d-102*t132*t133*t38+2.4d-5
     1           1*t1*t136*t32
              t138 = -4.0d-51*t134*t32*t39+9.6d-102*t132*t133*t39+2.4d-5
     1           1*t1*t137*t32
              t139 = 1/t3**3
              t140 = -6.666666666666666d-50*t134*t6*t7*t9-6.666666666666
     1           666d-50*t134*t14*t7*t9+5.15088d-52*t12*t134*t7*t9+4.120
     2           7039999999995d-101*t133*t139*t14*t9-1.3333333333333333d
     3           -99*t133*t14*t7+2.0603519999999997d-101*t13*t133*t7-5.3
     4           33333333333334d-99*t11*t133*t7+1.030176d-51*t10*t134*t1
     5           39*t6-6.666666666666666d-50*t13*t134*t4-3.3333333333333
     6           33d-50*t12*t134*t4+1.6482816d-150*t11*t139/rhoa**6
              t141 = 5.0d-1*t15*t29+5.0d-1*rhoa*t140*t29+5.0d-1*rhoa*t13
     1           1*t15
              t142 = 1/t83**1.6666666666666669d+0
              t143 = 1/t96**3
              t144 = 1/t83**1.3333333333333333d+0
              t145 = 1/t83**1.1666666666666667d+0
              t146 = -9.970917392951799d-1*t145-7.418564737168958d-1*t14
     1           4-4.002143174996817d-1*t143-1.264669550498372d-1*t142
              t147 = 1/t99**2
              t148 = 1/t100
              t149 = 1.0d+0*t146*t147*t148*t85*t94
              t150 = -1.3595691172479402d+0*t145-7.491972878592053d-1*t1
     1           44-2.1504862356383217d-1*t143-1.2743417300848914d-1*t14
     2           2
              t151 = 1/t105**2
              t152 = 1/t106
              t153 = -5.848223622634647d-1*t103*t104*t150*t151*t152
              t154 = -1.8533958105157808d+0*t145-1.2815820791490704d+0*t
     1           144-8.223668877838045d-1*t143-1.6039141941921276d-1*t14
     2           2
              t155 = 1/t110**2
              t156 = 1/t111
              t157 = 1.923661050931536d+0*t109*t154*t155*t156*t87*t88*t9
     1           2
              t158 = 1/t83**2
              t159 = t158*t86
              t160 = -t89
              t161 = t160+t159
              t162 = t90**3.333333333333333d-1
              t163 = -t158*t86
              t164 = t89+t163
              t165 = t91**3.333333333333333d-1
              t166 = 1.3333333333333333d+0*t164*t165+1.3333333333333333d
     1           +0*t161*t162
              t167 = -1.923661050931536d+0*t166*t87*t88
              t168 = 1/t83**5
              t169 = 7.694644203726144d+0*t168*t87*t92
              t170 = t86**3
              t171 = -7.694644203726144d+0*t170*t88*t92
              t172 = t171+t169+t167
              t173 = -6.21814d-2*t101*t172*t85
              t174 = 2.747773264188437d-3*t101*t144*t94
              t175 = t171+t169+t167+1.923661050931536d+0*t166
              t176 = 1.9751631321680768d-2*t103*t107*t175
              t177 = -4.5437964274821163d-4*t104*t107*t144
              t178 = -5.980796863619711d-2*t109*t112*t166*t87*t88
              t179 = 1/t83**5.333333333333333d+0
              t180 = 2.541232989148493d-3*t112*t179*t87*t92
              t181 = 2.3923187454478842d-1*t109*t112*t168*t87*t92
              t182 = t83*(-2.3923187454478842d-1*t109*t112*t170*t88*t92+
     1           t181+t180+t178+t177+t176+t174+t173+t157+t153+t149)+6.90
     2           3522198342671d-18*t27*t28+3.1090699999999993d-2*t23*t24
     3           -rhoa*t131+t113+t108+t102
              t183 = 1/t115**2
              t184 = 6.406666666666666d-55*t117*t134*t183*t76-2.06666666
     1           66666667d-52*t116*t117*t134
              t185 = 3.1d-3*t116*t184*t76+6.406666666666666d-55*t118*t13
     1           4*t183*t76-2.0666666666666667d-52*t116*t118*t134
              t186 = 3.1d-3*t116*t185*t76+6.406666666666666d-55*t119*t13
     1           4*t183*t76-2.0666666666666667d-52*t116*t119*t134
              t187 = 3.1d-3*t116*t186*t76+6.406666666666666d-55*t120*t13
     1           4*t183*t76-2.0666666666666667d-52*t116*t120*t134
              t188 = 1/t71**3
              t189 = 6.09932d-52*t134*t188*t73*t76*t81-3.333333333333333
     1           d-50*t134*t72*t76*t81-6.666666666666666d-50*t134*t72*t7
     2           3*t81-6.666666666666666d-50*t134*t79*t80+3.04966d-52*t1
     3           34*t72*t76*t80-3.333333333333333d-50*t134*t78*t79+3.049
     4           66d-52*t134*t72*t73*t78+6.09932d-52*t134*t188*t75*t77-1
     5           .3333333333333333d-49*t134*t72*t75*t76+6.09932d-52*t134
     6           *t188*t70*t74-6.666666666666666d-50*t134*t70*t72*t73
              t190 = 1.0d+0*t182*t82+1.0d+0*t114*t189
              t191 = 1/t60
              t192 = 1/t51**3
              t193 = 1/rhob**1.3333333333333333d+0
              t194 = 1/rhob**1.1666666666666667d+0
              t195 = -1.264669550498372d-1*t41-9.970917392951799d-1*t194
     1           -7.418564737168958d-1*t193-4.002143174996817d-1*t192
              t196 = 1/t59**2
              t197 = 1/t56
              t198 = -1.6039141941921276d-1*t41-1.8533958105157808d+0*t1
     1           94-1.2815820791490704d+0*t193-8.223668877838045d-1*t192
              t199 = 1/t55**2
              t200 = 1.1102230246251565d-16*t191*t195*t196*t62+3.0506411
     1           443514264d-19*t193*t61+1.0d+0*t197*t198*t199*t58+1.3210
     2           398931339265d-3*t193*t57
              t201 = 1/t64**2
              t202 = 1/rhob**4.333333333333333d+0
              t203 = 1/rhob**2.6666666666666666d+0
              t204 = 9.6d-102*t201*t202*t36-4.0d-51*t203*t36*t65
              t205 = -4.0d-51*t203*t65*t66+9.6d-102*t201*t202*t66+2.4d-5
     1           1*t204*t41*t65
              t206 = -4.0d-51*t203*t65*t67+9.6d-102*t201*t202*t67+2.4d-5
     1           1*t205*t41*t65
              t207 = -4.0d-51*t203*t65*t68+9.6d-102*t201*t202*t68+2.4d-5
     1           1*t206*t41*t65
              t208 = 1/t43**3
              t209 = 1.030176d-51*t203*t208*t48*t6-6.666666666666666d-50
     1           *t203*t45*t47*t6-6.666666666666666d-50*t14*t203*t45*t47
     2           +5.15088d-52*t12*t203*t45*t47+4.1207039999999995d-101*t
     3           14*t202*t208*t47-1.3333333333333333d-99*t14*t202*t45+2.
     4           0603519999999997d-101*t13*t202*t45-5.333333333333334d-9
     5           9*t11*t202*t45-6.666666666666666d-50*t13*t203*t44-3.333
     6           333333333333d-50*t12*t203*t44+1.6482816d-150*t11*t208/r
     7           hob**6
              t210 = 5.0d-1*t49*t63+5.0d-1*rhob*t209*t63+5.0d-1*rhob*t20
     1           0*t49
              t211 = t89+t159
              t212 = t163+t160
              t213 = 1.3333333333333333d+0*t165*t212+1.3333333333333333d
     1           +0*t162*t211
              t214 = -1.923661050931536d+0*t213*t87*t88
              t215 = 7.694644203726144d+0*t170*t88*t92
              t216 = t215+t214+t169
              t217 = -6.21814d-2*t101*t216*t85
              t218 = t215+t214+1.923661050931536d+0*t213+t169
              t219 = 1.9751631321680768d-2*t103*t107*t218
              t220 = -5.980796863619711d-2*t109*t112*t213*t87*t88
              t221 = t83*(2.3923187454478842d-1*t109*t112*t170*t88*t92+t
     1           220+t219+t217+t181+t180+t177+t174+t157+t153+t149)+6.903
     2           522198342671d-18*t61*t62+3.1090699999999993d-2*t57*t58-
     3           rhob*t200+t113+t108+t102
              t222 = 6.406666666666666d-55*t117*t183*t203*t76-2.06666666
     1           66666667d-52*t116*t117*t203
              t223 = 3.1d-3*t116*t222*t76+6.406666666666666d-55*t118*t18
     1           3*t203*t76-2.0666666666666667d-52*t116*t118*t203
              t224 = 3.1d-3*t116*t223*t76+6.406666666666666d-55*t119*t18
     1           3*t203*t76-2.0666666666666667d-52*t116*t119*t203
              t225 = 3.1d-3*t116*t224*t76+6.406666666666666d-55*t120*t18
     1           3*t203*t76-2.0666666666666667d-52*t116*t120*t203
              t226 = 6.09932d-52*t188*t203*t73*t76*t81-3.333333333333333
     1           d-50*t203*t72*t76*t81-6.666666666666666d-50*t203*t72*t7
     2           3*t81-6.666666666666666d-50*t203*t79*t80+3.04966d-52*t2
     3           03*t72*t76*t80-3.333333333333333d-50*t203*t78*t79+3.049
     4           66d-52*t203*t72*t73*t78+6.09932d-52*t188*t203*t75*t77-1
     5           .3333333333333333d-49*t203*t72*t75*t76+6.09932d-52*t188
     6           *t203*t70*t74-6.666666666666666d-50*t203*t70*t72*t73
              t227 = 1.0d+0*t221*t82+1.0d+0*t114*t226
              t228 = t126**2
              t229 = 1/t17**5
              t230 = 1/rhoa**2.3333333333333334d+0
              t231 = 1/rhoa**2.1666666666666665d+0
              t232 = t129**2
              t233 = 1.7854583920998188d-15*t228*t28/(t25**4*t26**2)-2.2
     1           20446049250313d-16*t122*t228*t28/t25**3+1.1102230246251
     2           565d-16*t122*t127*(1.1632736958443765d+0*t231+9.8914196
     3           4955861d-1*t230+6.003214762495226d-1*t229+2.10778258416
     4           39536d-1*t134)*t28-4.0675215258019015d-19*t230*t27+3.21
     5           6395899738507d+1*t232*t24/(t21**4*t22**2)-2.0d+0*t128*t
     6           232*t24/t21**3+1.0d+0*t128*t130*(2.1622951122684114d+0*
     7           t231+1.7087761055320938d+0*t230+1.2335503316757068d+0*t
     8           229+2.673190323653546d-1*t134)*t24-1.7613865241785684d-
     9           3*t23*t230-8.497974591333913d-2*t124*t128*t129*t130-9.8
     :           12069668265515d-18*t122*t124*t126*t127
              t234 = 1/t31**3
              t235 = 1/rhoa**7
              t236 = 1/rhoa**5.333333333333333d+0
              t237 = 1/rhoa**3.6666666666666664d+0
              t238 = 1/t3**4
              t239 = 2.0d+0*t146*t147*t148*t85*t94
              t240 = -1.1696447245269295d+0*t103*t104*t150*t151*t152
              t241 = 3.847322101863072d+0*t109*t154*t155*t156*t87*t88*t9
     1           2
              t242 = 5.495546528376875d-3*t101*t144*t94
              t243 = -9.087592854964233d-4*t104*t107*t144
              t244 = 5.082465978296986d-3*t112*t179*t87*t92
              t245 = 4.7846374908957684d-1*t109*t112*t168*t87*t92
              t246 = t146**2
              t247 = 1.6081979498692536d+1*t246*t85*t94/(t100**2*t99**4)
              t248 = -2.0d+0*t148*t246*t85*t94/t99**3
              t249 = -8.837926660346784d-2*t144*t146*t147*t148*t94
              t250 = 1/t83**2.6666666666666666d+0
              t251 = 1/t96**5
              t252 = 1/t83**2.3333333333333334d+0
              t253 = 1/t83**2.1666666666666665d+0
              t254 = 1.0d+0*t147*t148*(1.1632736958443765d+0*t253+9.8914
     1           1964955861d-1*t252+6.003214762495226d-1*t251+2.10778258
     2           41639536d-1*t250)*t85*t94
              t255 = t150**2
              t256 = -1.73158960813529d+1*t103*t104*t255/(t105**4*t106**
     1           2)
              t257 = 1.1696447245269295d+0*t103*t104*t152*t255/t105**3
              t258 = 2.690728393099896d-2*t104*t144*t150*t151*t152
              t259 = -5.848223622634647d-1*t103*t104*t151*t152*(1.586163
     1           9701225969d+0*t253+9.98929717145607d-1*t252+3.225729353
     2           4574827d-1*t251+2.1239028834748191d-1*t250)
              t260 = t154**2
              t261 = 6.187255516702861d+1*t109*t260*t87*t88*t92/(t110**4
     1           *t111**2)
              t262 = -3.847322101863072d+0*t109*t156*t260*t87*t88*t92/t1
     1           10**3
              t263 = -1.6347222733154887d-1*t154*t155*t156*t179*t87*t92
              t264 = 1.923661050931536d+0*t109*t155*t156*(2.162295112268
     1           4114d+0*t253+1.7087761055320938d+0*t252+1.2335503316757
     2           068d+0*t251+2.673190323653546d-1*t250)*t87*t88*t92
              t265 = -1.538928840745229d+1*t109*t154*t155*t156*t168*t87*
     1           t92
              t266 = 1/t90**6.666666666666666d-1
              t267 = 1/t83**3
              t268 = -2*t267*t86
              t269 = 2*t158
              t270 = 1/t91**6.666666666666666d-1
              t271 = 2*t267*t86
              t272 = -2*t158
              t273 = 1.3333333333333333d+0*t165*(t272+t271)+4.4444444444
     1           44444d-1*t164**2*t270+1.3333333333333333d+0*t162*(t269+
     2           t268)+4.444444444444444d-1*t161**2*t266
              t274 = -1.923661050931536d+0*t273*t87*t88
              t275 = 1.5389288407452287d+1*t166*t168*t87
              t276 = -1.5389288407452287d+1*t166*t170*t88
              t277 = 1/t83**6
              t278 = -3.8473221018630716d+1*t277*t87*t92
              t279 = 6.155715362980915d+1*t168*t170*t92
              t280 = t86**2
              t281 = -2.3083932611178434d+1*t280*t88*t92
              t282 = -3.663697685584583d-3*t101*t252*t94
              t283 = 6.058395236642822d-4*t104*t107*t252
              t284 = -2.3718174565385935d-2*t112*t87*t92/t83**6.33333333
     1           3333333d+0
              t285 = -1.1961593727239421d+0*t109*t112*t277*t87*t92
              t286 = -7.176956236343652d-1*t109*t112*t280*t88*t92
              t287 = t83*(1.538928840745229d+1*t109*t154*t155*t156*t170*
     1           t88*t92+2.0329863913187946d-2*t112*t170*t179*t92+1.9138
     2           549963583074d+0*t109*t112*t168*t170*t92-5.9807968636197
     3           11d-2*t109*t112*t273*t87*t88+3.847322101863072d+0*t109*
     4           t154*t155*t156*t166*t87*t88-4.7846374908957684d-1*t109*
     5           t112*t166*t170*t88+5.082465978296986d-3*t112*t166*t179*
     6           t87+4.7846374908957684d-1*t109*t112*t166*t168*t87-6.218
     7           14d-2*t101*(t281+t279+t278+t276+t275+t274)*t85+2.0d+0*t
     8           146*t147*t148*t172*t85+t286+t285+t284+t283+t282+1.97516
     9           31321680768d-2*t103*t107*(t281+t279+t278+t276+t275+t274
     :           +1.923661050931536d+0*t273)+t265+t264+t263+t262+t261+t2
     ;           59+t258+t257+t256+t254+t249+t248+t247-1.169644724526929
     <           5d+0*t103*t150*t151*t152*t175-9.087592854964233d-4*t107
     =           *t144*t175+5.495546528376875d-3*t101*t144*t172)-4.78463
     >           74908957684d-1*t109*t112*t170*t88*t92-1.196159372723942
     ?           1d-1*t109*t112*t166*t87*t88-1.243628d-1*t101*t172*t85-2
     @           .220446049250313d-16*t122*t126*t127*t28-6.1012822887028
     1           53d-19*t124*t27+t245+t244+t243+t242+t241+t240-2.0d+0*t1
     2           28*t129*t130*t24+t239-rhoa*t233-2.642079786267853d-3*t1
     3           24*t23+3.9503262643361536d-2*t103*t107*t175
              t288 = 1/t115**3
              t289 = 1/t71**4
              t290 = 2.6666666666666666d+0*t165*t267*t86-2.6666666666666
     1           666d+0*t162*t267*t86+4.444444444444444d-1*t164*t212*t27
     2           0+4.444444444444444d-1*t161*t211*t266
              t291 = -1.923661050931536d+0*t290*t87*t88
              t292 = 7.694644203726144d+0*t168*t213*t87
              t293 = -7.694644203726144d+0*t170*t213*t88
              t294 = 7.694644203726144d+0*t166*t168*t87
              t295 = 7.694644203726144d+0*t166*t170*t88
              t296 = 2.3083932611178434d+1*t280*t88*t92
              t297 = t83*(7.176956236343652d-1*t109*t112*t280*t88*t92-5.
     1           980796863619711d-2*t109*t112*t290*t87*t88+1.92366105093
     2           1536d+0*t109*t154*t155*t156*t213*t87*t88+1.923661050931
     3           536d+0*t109*t154*t155*t156*t166*t87*t88-2.3923187454478
     4           842d-1*t109*t112*t170*t213*t88+2.3923187454478842d-1*t1
     5           09*t112*t166*t170*t88+2.541232989148493d-3*t112*t179*t2
     6           13*t87+2.3923187454478842d-1*t109*t112*t168*t213*t87+2.
     7           541232989148493d-3*t112*t166*t179*t87+2.392318745447884
     8           2d-1*t109*t112*t166*t168*t87-6.21814d-2*t101*(t296+t295
     9           +t294+t293+t292+t291+t278)*t85+1.0d+0*t146*t147*t148*t2
     :           16*t85+1.0d+0*t146*t147*t148*t172*t85+1.975163132168076
     ;           8d-2*t103*t107*(t296+t295+t294+t293+t292+t291+1.9236610
     <           50931536d+0*t290+t278)+t285+t284+t283+t282+t265+t264+t2
     =           63+t262+t261+t259+t258+t257+t256+t254+t249+t248+t247-5.
     >           848223622634647d-1*t103*t150*t151*t152*t218-4.543796427
     ?           4821163d-4*t107*t144*t218+2.747773264188437d-3*t101*t14
     @           4*t216-5.848223622634647d-1*t103*t150*t151*t152*t175-4.
     1           5437964274821163d-4*t107*t144*t175+2.747773264188437d-3
     2           *t101*t144*t172)+t245+t244+t243+t242+t241+t240+t239+t22
     3           0+t219+t217+t178+t176+t173
              t298 = 3.04966d-52*t221*t82
              t299 = 3.04966d-52*t114*t226
              t300 = t195**2
              t301 = 1/t51**5
              t302 = 1/rhob**2.3333333333333334d+0
              t303 = 1/rhob**2.1666666666666665d+0
              t304 = t198**2
              t305 = 1.7854583920998188d-15*t300*t62/(t59**4*t60**2)-2.2
     1           20446049250313d-16*t191*t300*t62/t59**3+1.1102230246251
     2           565d-16*t191*t196*(1.1632736958443765d+0*t303+9.8914196
     3           4955861d-1*t302+6.003214762495226d-1*t301+2.10778258416
     4           39536d-1*t203)*t62-4.0675215258019015d-19*t302*t61+3.21
     5           6395899738507d+1*t304*t58/(t55**4*t56**2)-2.0d+0*t197*t
     6           304*t58/t55**3+1.0d+0*t197*t199*(2.1622951122684114d+0*
     7           t303+1.7087761055320938d+0*t302+1.2335503316757068d+0*t
     8           301+2.673190323653546d-1*t203)*t58-1.7613865241785684d-
     9           3*t302*t57-8.497974591333913d-2*t193*t197*t198*t199-9.8
     :           12069668265515d-18*t191*t193*t195*t196
              t306 = 1/t64**3
              t307 = 1/rhob**7
              t308 = 1/rhob**5.333333333333333d+0
              t309 = 1/rhob**3.6666666666666664d+0
              t310 = 1/t43**4
              t311 = 1.3333333333333333d+0*t162*(t272+t268)+1.3333333333
     1           333333d+0*t165*(t271+t269)+4.444444444444444d-1*t212**2
     2           *t270+4.444444444444444d-1*t211**2*t266
              t312 = -1.923661050931536d+0*t311*t87*t88
              t313 = 1.5389288407452287d+1*t168*t213*t87
              t314 = 1.5389288407452287d+1*t170*t213*t88
              t315 = -6.155715362980915d+1*t168*t170*t92
              t316 = t83*(-1.538928840745229d+1*t109*t154*t155*t156*t170
     1           *t88*t92-2.0329863913187946d-2*t112*t170*t179*t92-1.913
     2           8549963583074d+0*t109*t112*t168*t170*t92-5.980796863619
     3           711d-2*t109*t112*t311*t87*t88+3.847322101863072d+0*t109
     4           *t154*t155*t156*t213*t87*t88+4.7846374908957684d-1*t109
     5           *t112*t170*t213*t88+5.082465978296986d-3*t112*t179*t213
     6           *t87+4.7846374908957684d-1*t109*t112*t168*t213*t87-6.21
     7           814d-2*t101*(t315+t314+t313+t312+t281+t278)*t85+2.0d+0*
     8           t146*t147*t148*t216*t85+1.9751631321680768d-2*t103*t107
     9           *(t315+t314+t313+t312+1.923661050931536d+0*t311+t281+t2
     :           78)+t286+t285+t284+t283+t282+t265+t264+t263+t262+t261+t
     ;           259+t258+t257+t256+t254+t249+t248+t247-1.16964472452692
     <           95d+0*t103*t150*t151*t152*t218-9.087592854964233d-4*t10
     =           7*t144*t218+5.495546528376875d-3*t101*t144*t216)+4.7846
     >           374908957684d-1*t109*t112*t170*t88*t92-1.19615937272394
     ?           21d-1*t109*t112*t213*t87*t88-1.243628d-1*t101*t216*t85-
     @           2.220446049250313d-16*t191*t195*t196*t62-6.101282288702
     1           853d-19*t193*t61-2.0d+0*t197*t198*t199*t58-2.6420797862
     2           67853d-3*t193*t57-rhob*t305+t245+t244+t243+t242+t241+t2
     3           40+t239+3.9503262643361536d-2*t103*t107*t218
              fnc(iq) = (1.0d+0*t114*t79*t82+5.0d-1*rhob*t63*t69+5.0d-1*
     1           rhob*t44*t49*t63+5.0d-1*rhoa*t29*t40+5.0d-1*rhoa*t15*t2
     2           9*t4+1.0d+0*t114*t121)*wght+fnc(iq)
              Amat(iq,D1_RA) = (3.04966d-52*t114*t134*t72*t82+t190*t79+2
     1           .57544d-52*t1*t15*t29*t7+5.0d-1*t29*t40+5.0d-1*rhoa*t13
     2           1*t40+t141*t4+5.0d-1*rhoa*t138*t29+1.0d+0*t114*t187+1.0
     3           d+0*t121*t182)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (3.04966d-52*t114*t203*t72*t82+t227*t79+5
     1           .0d-1*t63*t69+5.0d-1*rhob*t200*t69+2.57544d-52*t41*t45*
     2           t49*t63+5.0d-1*rhob*t207*t63+t210*t44+1.0d+0*t114*t225+
     3           1.0d+0*t121*t221)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t4*(5.0d-1*rhoa*t29*(1.7777777777777
     1           776d-49*t237*t6*t7*t9+1.7777777777777776d-49*t14*t237*t
     2           7*t9-1.373568d-51*t12*t237*t7*t9-1.373568d-100*t139*t23
     3           6*t6*t9+6.367575545855999d-152*t14*t235*t238*t9-2.47242
     4           23999999997d-100*t139*t14*t236*t9+5.306312954879999d-10
     5           3*t12*t139*t236*t9+2.222222222222222d-99*t236*t6*t7+8.0
     6           d-99*t14*t236*t7-1.2362111999999999d-100*t13*t236*t7-3.
     7           43392d-101*t12*t236*t7+2.3111111111111113d-98*t11*t236*
     8           t7+1.5918938864639998d-102*t10*t236*t238*t6-2.747136d-5
     9           1*t10*t139*t237*t6+1.7777777777777776d-49*t13*t237*t4+8
     :           .888888888888888d-50*t12*t237*t4+2.5470302183424d-201*t
     ;           11*t238/rhoa**8.666666666666666d+0-2.7471359999999995d-
     <           150*t139*t14*t235+2.1225251819519997d-152*t13*t139*t235
     =           -1.53839616d-149*t11*t139*t235)+1.0d+0*t140*t29+5.0d-1*
     >           rhoa*t15*t233+1.0d+0*t131*t15+1.0d+0*rhoa*t131*t140)+t7
     ?           9*(1.0d+0*t287*t82+1.0d+0*t114*(5.580255669359999d-103*
     @           t236*t289*t73*t76*t81-1.6264853333333332d-51*t188*t237*
     1           t73*t76*t81+8.888888888888888d-50*t237*t72*t76*t81-4.06
     2           62133333333333d-101*t188*t236*t76*t81+1.777777777777777
     3           6d-49*t237*t72*t73*t81-8.132426666666667d-101*t188*t236
     4           *t73*t81+4.444444444444444d-99*t236*t72*t81+1.777777777
     5           7777776d-49*t237*t79*t80-8.132426666666666d-52*t237*t72
     6           *t76*t80+1.86008522312d-103*t188*t236*t76*t80-4.0662133
     7           333333333d-101*t236*t72*t80+8.888888888888888d-50*t237*
     8           t78*t79-8.132426666666666d-52*t237*t72*t73*t78+1.860085
     9           22312d-103*t188*t236*t73*t78-2.0331066666666667d-101*t2
     :           36*t72*t78+5.580255669359999d-103*t236*t289*t75*t77-1.6
     ;           264853333333332d-51*t188*t237*t75*t77+3.555555555555555
     <           d-49*t237*t72*t75*t76-1.6264853333333334d-100*t188*t236
     =           *t75*t76+8.888888888888888d-99*t236*t72*t75+5.580255669
     >           359999d-103*t236*t289*t70*t74-1.6264853333333332d-51*t1
     ?           88*t237*t70*t74+1.7777777777777776d-49*t237*t70*t72*t73
     @           -8.132426666666667d-101*t188*t236*t70*t73+2.22222222222
     1           2222d-99*t236*t70*t72)+2.0d+0*t182*t189)+t134*t72*(3.04
     2           966d-52*t182*t82+3.04966d-52*t190+3.04966d-52*t114*t189
     3           )-8.132426666666666d-52*t114*t237*t72*t82+1.86008522312
     4           d-103*t114*t188*t236*t82+1.0d+0*t114*(3.1d-3*t116*t76*(
     5           3.1d-3*t116*t76*(3.1d-3*t116*t76*(2.6480888888888887d-1
     6           06*t117*t236*t288*t76-1.708444444444444d-54*t117*t183*t
     7           237*t76+5.51111111111111d-52*t116*t117*t237-8.542222222
     8           222222d-104*t117*t183*t236)+2.6480888888888887d-106*t11
     9           8*t236*t288*t76-1.708444444444444d-54*t118*t183*t237*t7
     :           6+1.2813333333333332d-54*t134*t183*t184*t76+5.511111111
     ;           11111d-52*t116*t118*t237-8.542222222222222d-104*t118*t1
     <           83*t236-4.1333333333333333d-52*t116*t134*t184)+2.648088
     =           8888888887d-106*t119*t236*t288*t76-1.708444444444444d-5
     >           4*t119*t183*t237*t76+1.2813333333333332d-54*t134*t183*t
     ?           185*t76+5.51111111111111d-52*t116*t119*t237-8.542222222
     @           222222d-104*t119*t183*t236-4.1333333333333333d-52*t116*
     1           t134*t185)+2.6480888888888887d-106*t120*t236*t288*t76-1
     2           .708444444444444d-54*t120*t183*t237*t76+1.2813333333333
     3           332d-54*t134*t183*t186*t76+5.51111111111111d-52*t116*t1
     4           20*t237-8.542222222222222d-104*t120*t183*t236-4.1333333
     5           333333333d-52*t116*t134*t186)+t134*(5.15088d-52*t141-4.
     6           2923999999999995d-52*t15*t29)*t7+t1*(2.57544d-52*t140*t
     7           29+2.57544d-52*t131*t15)*t7+5.0d-1*rhoa*t233*t40+1.0d+0
     8           *t131*t40+5.0d-1*rhoa*t29*(1.0666666666666666d-50*t237*
     9           t32*t39-5.76d-101*t132*t236*t39+7.68d-152*t234*t235*t39
     :           +2.4d-51*t1*t32*(1.0666666666666666d-50*t237*t32*t38-5.
     ;           76d-101*t132*t236*t38+7.68d-152*t234*t235*t38+2.4d-51*t
     <           1*t32*(1.0666666666666666d-50*t237*t32*t37-5.76d-101*t1
     =           32*t236*t37+7.68d-152*t234*t235*t37+2.4d-51*t1*t32*(1.0
     >           666666666666666d-50*t237*t32*t36-5.76d-101*t132*t236*t3
     ?           6+7.68d-152*t234*t235*t36)-8.0d-51*t134*t135*t32+1.92d-
     @           101*t132*t133*t135)-8.0d-51*t134*t136*t32+1.92d-101*t13
     1           2*t133*t136)-8.0d-51*t134*t137*t32+1.92d-101*t132*t133*
     2           t137)+2.6531564774399996d-103*t133*t139*t15*t29+1.0d+0*
     3           t138*t29+1.0d+0*t121*t287+2.0d+0*t182*t187+1.0d+0*rhoa*
     4           t131*t138)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t79*(1.0d+0*t297*t82+1.0d+0*t114*(5.
     1           580255669359999d-103*t134*t203*t289*t73*t76*t81-4.06621
     2           33333333333d-101*t134*t188*t203*t76*t81-8.1324266666666
     3           67d-101*t134*t188*t203*t73*t81+4.444444444444444d-99*t1
     4           34*t203*t72*t81+1.86008522312d-103*t134*t188*t203*t76*t
     5           80-4.0662133333333333d-101*t134*t203*t72*t80+1.86008522
     6           312d-103*t134*t188*t203*t73*t78-2.0331066666666667d-101
     7           *t134*t203*t72*t78+5.580255669359999d-103*t134*t203*t28
     8           9*t75*t77-1.6264853333333334d-100*t134*t188*t203*t75*t7
     9           6+8.888888888888888d-99*t134*t203*t72*t75+5.58025566935
     :           9999d-103*t134*t203*t289*t70*t74-8.132426666666667d-101
     ;           *t134*t188*t203*t70*t73+2.222222222222222d-99*t134*t203
     <           *t70*t72)+1.0d+0*t182*t226+1.0d+0*t189*t221)+1.86008522
     =           312d-103*t114*t134*t188*t203*t82+1.0d+0*t114*(3.1d-3*t1
     >           16*t76*(3.1d-3*t116*t76*(3.1d-3*t116*t76*(2.64808888888
     ?           88887d-106*t117*t134*t203*t288*t76-8.542222222222222d-1
     @           04*t117*t134*t183*t203)+2.6480888888888887d-106*t118*t1
     1           34*t203*t288*t76+6.406666666666666d-55*t134*t183*t222*t
     2           76+6.406666666666666d-55*t183*t184*t203*t76-2.066666666
     3           6666667d-52*t116*t134*t222-2.0666666666666667d-52*t116*
     4           t184*t203-8.542222222222222d-104*t118*t134*t183*t203)+2
     5           .6480888888888887d-106*t119*t134*t203*t288*t76+6.406666
     6           666666666d-55*t134*t183*t223*t76+6.406666666666666d-55*
     7           t183*t185*t203*t76-2.0666666666666667d-52*t116*t134*t22
     8           3-2.0666666666666667d-52*t116*t185*t203-8.5422222222222
     9           22d-104*t119*t134*t183*t203)+2.6480888888888887d-106*t1
     :           20*t134*t203*t288*t76+6.406666666666666d-55*t134*t183*t
     ;           224*t76+6.406666666666666d-55*t183*t186*t203*t76-2.0666
     <           666666666667d-52*t116*t134*t224-2.0666666666666667d-52*
     =           t116*t186*t203-8.542222222222222d-104*t120*t134*t183*t2
     >           03)+t134*(t299+t298)*t72+3.04966d-52*t190*t203*t72+1.0d
     ?           +0*t121*t297+1.0d+0*t182*t225+1.0d+0*t187*t221)*wght+Am
     @           at2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t79*(1.0d+0*t316*t82+1.0d+0*t114*(-1
     1           .6264853333333332d-51*t188*t309*t73*t76*t81+5.580255669
     2           359999d-103*t289*t308*t73*t76*t81+8.888888888888888d-50
     3           *t309*t72*t76*t81-4.0662133333333333d-101*t188*t308*t76
     4           *t81+1.7777777777777776d-49*t309*t72*t73*t81-8.13242666
     5           6666667d-101*t188*t308*t73*t81+4.444444444444444d-99*t3
     6           08*t72*t81+1.7777777777777776d-49*t309*t79*t80-8.132426
     7           666666666d-52*t309*t72*t76*t80+1.86008522312d-103*t188*
     8           t308*t76*t80-4.0662133333333333d-101*t308*t72*t80+8.888
     9           888888888888d-50*t309*t78*t79-8.132426666666666d-52*t30
     :           9*t72*t73*t78+1.86008522312d-103*t188*t308*t73*t78-2.03
     ;           31066666666667d-101*t308*t72*t78-1.6264853333333332d-51
     <           *t188*t309*t75*t77+5.580255669359999d-103*t289*t308*t75
     =           *t77+3.555555555555555d-49*t309*t72*t75*t76-1.626485333
     >           3333334d-100*t188*t308*t75*t76+8.888888888888888d-99*t3
     ?           08*t72*t75-1.6264853333333332d-51*t188*t309*t70*t74+5.5
     @           80255669359999d-103*t289*t308*t70*t74+1.777777777777777
     1           6d-49*t309*t70*t72*t73-8.132426666666667d-101*t188*t308
     2           *t70*t73+2.222222222222222d-99*t308*t70*t72)+2.0d+0*t22
     3           1*t226)-8.132426666666666d-52*t114*t309*t72*t82+1.86008
     4           522312d-103*t114*t188*t308*t82+1.0d+0*t114*(3.1d-3*t116
     5           *t76*(3.1d-3*t116*t76*(3.1d-3*t116*t76*(-1.708444444444
     6           444d-54*t117*t183*t309*t76+2.6480888888888887d-106*t117
     7           *t288*t308*t76+5.51111111111111d-52*t116*t117*t309-8.54
     8           2222222222222d-104*t117*t183*t308)-1.708444444444444d-5
     9           4*t118*t183*t309*t76+2.6480888888888887d-106*t118*t288*
     :           t308*t76+1.2813333333333332d-54*t183*t203*t222*t76+5.51
     ;           111111111111d-52*t116*t118*t309-8.542222222222222d-104*
     <           t118*t183*t308-4.1333333333333333d-52*t116*t203*t222)-1
     =           .708444444444444d-54*t119*t183*t309*t76+2.6480888888888
     >           887d-106*t119*t288*t308*t76+1.2813333333333332d-54*t183
     ?           *t203*t223*t76+5.51111111111111d-52*t116*t119*t309-8.54
     @           2222222222222d-104*t119*t183*t308-4.1333333333333333d-5
     1           2*t116*t203*t223)-1.708444444444444d-54*t120*t183*t309*
     2           t76+2.6480888888888887d-106*t120*t288*t308*t76+1.281333
     3           3333333332d-54*t183*t203*t224*t76+5.51111111111111d-52*
     4           t116*t120*t309-8.542222222222222d-104*t120*t183*t308-4.
     5           1333333333333333d-52*t116*t203*t224)+t203*(t299+t298+3.
     6           04966d-52*t227)*t72+5.0d-1*rhob*t305*t69+1.0d+0*t200*t6
     7           9+5.0d-1*rhob*t63*(1.0666666666666666d-50*t309*t65*t68-
     8           5.76d-101*t201*t308*t68+7.68d-152*t306*t307*t68+2.4d-51
     9           *t41*t65*(1.0666666666666666d-50*t309*t65*t67-5.76d-101
     :           *t201*t308*t67+7.68d-152*t306*t307*t67+2.4d-51*t41*t65*
     ;           (1.0666666666666666d-50*t309*t65*t66-5.76d-101*t201*t30
     <           8*t66+7.68d-152*t306*t307*t66+2.4d-51*t41*t65*(1.066666
     =           6666666666d-50*t309*t36*t65-5.76d-101*t201*t308*t36+7.6
     >           8d-152*t306*t307*t36)-8.0d-51*t203*t204*t65+1.92d-101*t
     ?           201*t202*t204)-8.0d-51*t203*t205*t65+1.92d-101*t201*t20
     @           2*t205)-8.0d-51*t203*t206*t65+1.92d-101*t201*t202*t206)
     1           +t44*(5.0d-1*rhob*(1.5918938864639998d-102*t308*t310*t4
     2           8*t6-2.747136d-51*t208*t309*t48*t6+1.7777777777777776d-
     3           49*t309*t45*t47*t6-1.373568d-100*t208*t308*t47*t6+2.222
     4           222222222222d-99*t308*t45*t6+1.7777777777777776d-49*t14
     5           *t309*t45*t47-1.373568d-51*t12*t309*t45*t47+6.367575545
     6           855999d-152*t14*t307*t310*t47-2.4724223999999997d-100*t
     7           14*t208*t308*t47+5.306312954879999d-103*t12*t208*t308*t
     8           47+8.0d-99*t14*t308*t45-1.2362111999999999d-100*t13*t30
     9           8*t45-3.43392d-101*t12*t308*t45+2.3111111111111113d-98*
     :           t11*t308*t45+1.7777777777777776d-49*t13*t309*t44+8.8888
     ;           88888888888d-50*t12*t309*t44+2.5470302183424d-201*t11*t
     <           310/rhob**8.666666666666666d+0-2.7471359999999995d-150*
     =           t14*t208*t307+2.1225251819519997d-152*t13*t208*t307-1.5
     >           3839616d-149*t11*t208*t307)*t63+1.0d+0*t209*t63+5.0d-1*
     ?           rhob*t305*t49+1.0d+0*t200*t49+1.0d+0*rhob*t200*t209)+t2
     @           03*t45*(5.15088d-52*t210-4.2923999999999995d-52*t49*t63
     1           )+t41*t45*(2.57544d-52*t209*t63+2.57544d-52*t200*t49)+2
     2           .6531564774399996d-103*t202*t208*t49*t63+1.0d+0*t207*t6
     3           3+1.0d+0*t121*t316+2.0d+0*t221*t225+1.0d+0*rhob*t200*t2
     4           07)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(22)
              t5 = 6.0d-2*gammaaa*t1*t3*t4+param(21)
              t6 = 6.0d-2*gammaaa*t1*t3*t5+param(20)
              t7 = 6.0d-2*gammaaa*t1*t3*t6+param(19)
              t8 = 6.0d-2*gammaaa*t1*t3*t7+param(18)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taua
              t24 = 1/rhoa
              t25 = 2.0d+0*taua-2.5d-1*gammaaa*t24
              t26 = 1.0d+0-1.25d-1*gammaaa*t23*t24
              t27 = 1/rhoa**1.6666666666666669d+0
              t28 = 2.0d+0*t27*taua
              t29 = 5.15088d-3*(t28+gammaaa*t1-9.11559972d+0)+1.0d+0
              t30 = 1/t29
              t31 = param(10)
              t32 = gammaaa**2
              t33 = 1/rhoa**5.333333333333333d+0
              t34 = 1/t29**2
              t35 = param(11)
              t36 = t28-9.11559972d+0
              t37 = param(12)
              t38 = t36**2
              t39 = param(8)
              t40 = param(9)
              t41 = t30*t36*t40+gammaaa*t1*t30*t39+t34*t37*t38+gammaaa*t
     1           1*t34*t35*t36+t31*t32*t33*t34+param(7)
              t42 = 1/t19
              t43 = 1/t10**3
              t44 = 1/rhoa**1.3333333333333333d+0
              t45 = 1/rhoa**1.1666666666666667d+0
              t46 = -9.970917392951799d-1*t45-7.418564737168958d-1*t44-4
     1           .002143174996817d-1*t43-1.264669550498372d-1*t27
              t47 = 1/t18**2
              t48 = 1/t15
              t49 = -1.8533958105157808d+0*t45-1.2815820791490704d+0*t44
     1           -8.223668877838045d-1*t43-1.6039141941921276d-1*t27
              t50 = 1/t14**2
              t51 = 1.0d+0*t17*t48*t49*t50+1.1102230246251565d-16*t21*t4
     1           2*t46*t47+3.0506411443514264d-19*t20*t44+1.321039893133
     2           9265d-3*t16*t44
              t52 = 1/t2**2
              t53 = 1/rhoa**6.333333333333333d+0
              t54 = 1/rhoa**3.6666666666666664d+0
              t55 = 9.599999999999997d-3*t32*t4*t52*t53-1.59999999999999
     1           98d-1*gammaaa*t3*t4*t54
              t56 = 6.0d-2*gammaaa*t1*t3*t55-1.5999999999999998d-1*gamma
     1           aa*t3*t5*t54+9.599999999999997d-3*t32*t5*t52*t53
              t57 = -1.5999999999999998d-1*gammaaa*t3*t54*t6+9.599999999
     1           999997d-3*t32*t52*t53*t6+6.0d-2*gammaaa*t1*t3*t56
              t58 = -1.5999999999999998d-1*gammaaa*t3*t54*t7+9.599999999
     1           999997d-3*t32*t52*t53*t7+6.0d-2*gammaaa*t1*t3*t57
              t59 = -3.3333333333333337d+0*t1*taua-2.6666666666666666d+0
     1           *gammaaa*t54
              t60 = 1/t29**3
              t61 = -3.3333333333333337d+0*t1*t30*t40*taua-6.66666666666
     1           6667d+0*t1*t34*t36*t37*taua-3.3333333333333337d+0*gamma
     2           aa*t33*t34*t35*taua-1.030176d-2*t37*t38*t59*t60-1.03017
     3           6d-2*gammaaa*t1*t35*t36*t59*t60-1.030176d-2*t31*t32*t33
     4           *t59*t60-5.15088d-3*t34*t36*t40*t59-5.15088d-3*gammaaa*
     5           t1*t34*t39*t59-2.6666666666666666d+0*gammaaa*t30*t39*t5
     6           4-2.6666666666666666d+0*gammaaa*t34*t35*t36*t54-5.33333
     7           3333333333d+0*t31*t32*t34*t53
              t62 = 1.0d+0*rhoa*t22*t26*t61+1.0d+0*rhoa*t26*t41*t51+1.0d
     1           +0*t22*t26*t41
              t63 = 6.0d-2*t1*t3*t4-3.6d-3*gammaaa*t33*t4*t52
              t64 = 6.0d-2*gammaaa*t1*t3*t63-3.6d-3*gammaaa*t33*t5*t52+6
     1           .0d-2*t1*t3*t5
              t65 = 6.0d-2*gammaaa*t1*t3*t64-3.6d-3*gammaaa*t33*t52*t6+6
     1           .0d-2*t1*t3*t6
              t66 = -3.6d-3*gammaaa*t33*t52*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmaaa*t1*t3*t65
              t67 = 1/rhoa**8
              t68 = -1.030176d-2*t31*t32*t60*t67-1.030176d-2*t1*t37*t38*
     1           t60-1.030176d-2*gammaaa*t33*t35*t36*t60-5.15088d-3*t1*t
     2           34*t36*t40-5.15088d-3*gammaaa*t33*t34*t39+t1*t30*t39+t1
     3           *t34*t35*t36+2*gammaaa*t31*t33*t34
              t69 = taua**2
              t70 = 1/t69
              t71 = 1/rhoa**7
              t72 = 1/rhoa**4.333333333333333d+0
              t73 = -2.060352d-2*gammaaa*t35*t36*t60*t72-1.030176d-2*gam
     1           maaa*t34*t39*t72+2.0d+0*gammaaa*t34*t35*t72-2.060352d-2
     2           *t31*t32*t60*t71-2.060352d-2*t27*t37*t38*t60-1.030176d-
     3           2*t27*t34*t36*t40+2.0d+0*t27*t30*t40+4.0d+0*t27*t34*t36
     4           *t37
              t74 = 1/rhoa**2
              t75 = t46**2
              t76 = 1/t10**5
              t77 = 1/rhoa**2.3333333333333334d+0
              t78 = 1/rhoa**2.1666666666666665d+0
              t79 = t49**2
              t80 = -2.0d+0*t17*t48*t79/t14**3+3.216395899738507d+1*t17*
     1           t79/(t14**4*t15**2)+1.0d+0*t17*t48*t50*(2.1622951122684
     2           114d+0*t78+1.7087761055320938d+0*t77+1.2335503316757068
     3           d+0*t76+2.673190323653546d-1*t1)+1.1102230246251565d-16
     4           *t21*t42*t47*(1.1632736958443765d+0*t78+9.8914196495586
     5           1d-1*t77+6.003214762495226d-1*t76+2.1077825841639536d-1
     6           *t1)-4.0675215258019015d-19*t20*t77-1.7613865241785684d
     7           -3*t16*t77-2.220446049250313d-16*t21*t42*t75/t18**3+1.7
     8           854583920998188d-15*t21*t75/(t18**4*t19**2)-8.497974591
     9           333913d-2*t44*t48*t49*t50-9.812069668265515d-18*t42*t44
     :           *t46*t47
              t81 = gammaaa**3
              t82 = 1/t2**3
              t83 = 1/rhoa**10
              t84 = 1/rhoa**7.333333333333333d+0
              t85 = 1/rhoa**4.666666666666667d+0
              t86 = t59**2
              t87 = 1/t29**4
              t88 = 8.88888888888889d+0*t54*taua+9.777777777777779d+0*ga
     1           mmaaa*t85
              t89 = 1.25d-1*t22*t8
              t90 = 1/rhoa**9
              t91 = 1.25d-1*gammaaa*t22*t68+1.25d-1*t22*t41
              t92 = 1/rhoa**3.3333333333333337d+0
              t93 = 1/taua**3
              t94 = 1/rhoa**6
              fnc(iq) = (5.0d-1*rhoa*t22*t23*t25*t8+1.0d+0*rhoa*t22*t26*
     1           t30*t41)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t23*(5.0d-1*rhoa*t25*t51*t8+5.0d-1*t22*t
     1           25*t8+5.0d-1*rhoa*t22*t25*t58)+1.25d-1*gammaaa*t22*t23*
     2           t24*t8+t30*t62-5.15088d-3*rhoa*t22*t26*t34*t41*t59+1.25
     3           d-1*gammaaa*t22*t23*t24*t30*t41)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (t23*(5.0d-1*rhoa*t22*t25*t66-1.25d-1*t2
     1           2*t8)+1.0d+0*rhoa*t22*t26*t30*t68-5.15088d-3*t22*t26*t2
     2           7*t34*t41-1.25d-1*t22*t23*t30*t41)*wght+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = (-1.030176d-2*t22*t26*t34*t41*t9-5.0d-1*r
     1           hoa*t22*t25*t70*t8+1.0d+0*rhoa*t22*t23*t8+1.0d+0*rhoa*t
     2           22*t26*t30*t73+1.25d-1*gammaaa*t22*t30*t41*t70)*wght+Mm
     3           at(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t30*(1.0d+0*rhoa*t22*t26*(1.373568d-
     1           1*t1*t36*t37*t59*t60*taua+6.867840000000001d-2*gammaaa*
     2           t33*t35*t59*t60*taua+3.4339200000000003d-2*t1*t34*t40*t
     3           59*taua+8.88888888888889d+0*t30*t40*t54*taua+1.77777777
     4           77777778d+1*t34*t36*t37*t54*taua+2.6666666666666666d+1*
     5           gammaaa*t34*t35*t53*taua-1.030176d-2*t37*t38*t60*t88-1.
     6           030176d-2*gammaaa*t1*t35*t36*t60*t88-1.030176d-2*t31*t3
     7           2*t33*t60*t88-5.15088d-3*t34*t36*t40*t88-5.15088d-3*gam
     8           maaa*t1*t34*t39*t88+1.591893886464d-4*t37*t38*t86*t87+1
     9           .591893886464d-4*gammaaa*t1*t35*t36*t86*t87+1.591893886
     :           464d-4*t31*t32*t33*t86*t87+5.30631295488d-5*t36*t40*t60
     ;           *t86+5.30631295488d-5*gammaaa*t1*t39*t60*t86+9.77777777
     <           7777779d+0*gammaaa*t30*t39*t85+9.777777777777779d+0*gam
     =           maaa*t34*t35*t36*t85+3.377777777777778d+1*t31*t32*t34*t
     >           84+2.2222222222222224d+1*t33*t34*t37*t69+5.494272d-2*ga
     ?           mmaaa*t35*t36*t54*t59*t60+1.0988544d-1*t31*t32*t53*t59*
     @           t60+2.747136d-2*gammaaa*t34*t39*t54*t59)+1.0d+0*rhoa*t2
     1           6*t41*t80+1.25d-1*gammaaa*t22*t23*t41*t74+2.0d+0*rhoa*t
     2           26*t51*t61+2.0d+0*t22*t26*t61+1.25d-1*gammaaa*t22*t23*t
     3           24*t61+2.0d+0*t26*t41*t51+1.25d-1*gammaaa*t23*t24*t41*t
     4           51)+t34*(-5.15088d-3*rhoa*t22*t26*t41*t88-5.15088d-3*t5
     5           9*t62-5.15088d-3*rhoa*t22*t26*t59*t61-5.15088d-3*rhoa*t
     6           26*t41*t51*t59-5.15088d-3*t22*t26*t41*t59)+5.3063129548
     7           8d-5*rhoa*t22*t26*t41*t60*t86+t23*(5.0d-1*rhoa*t22*t25*
     8           (6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gam
     9           maaa*t1*t3*(5.866666666666666d-1*gammaaa*t3*t4*t85-8.63
     :           9999999999998d-2*t32*t4*t52*t84+3.0719999999999986d-3*t
     ;           4*t81*t82*t83)+5.866666666666666d-1*gammaaa*t3*t5*t85-8
     <           .639999999999998d-2*t32*t5*t52*t84+3.0719999999999986d-
     =           3*t5*t81*t82*t83-3.1999999999999995d-1*gammaaa*t3*t54*t
     >           55+1.9199999999999995d-2*t32*t52*t53*t55)+5.86666666666
     ?           6666d-1*gammaaa*t3*t6*t85-8.639999999999998d-2*t32*t52*
     @           t6*t84+3.0719999999999986d-3*t6*t81*t82*t83-3.199999999
     1           9999995d-1*gammaaa*t3*t54*t56+1.9199999999999995d-2*t32
     2           *t52*t53*t56)+5.866666666666666d-1*gammaaa*t3*t7*t85-8.
     3           639999999999998d-2*t32*t52*t7*t84+3.0719999999999986d-3
     4           *t7*t81*t82*t83-3.1999999999999995d-1*gammaaa*t3*t54*t5
     5           7+1.9199999999999995d-2*t32*t52*t53*t57)+5.0d-1*rhoa*t2
     6           5*t8*t80+1.25d-1*gammaaa*t22*t74*t8+1.0d+0*t25*t51*t8+1
     7           .25d-1*gammaaa*t24*t51*t8+1.0d+0*rhoa*t25*t51*t58+1.0d+
     8           0*t22*t25*t58+1.25d-1*gammaaa*t22*t24*t58)+t23*t24*(1.2
     9           5d-1*gammaaa*t51*t8+1.25d-1*gammaaa*t22*t58)-1.25d-1*ga
     :           mmaaa*t22*t23*t74*t8-1.25d-1*gammaaa*t22*t23*t30*t41*t7
     ;           4+t23*t24*t30*(1.25d-1*gammaaa*t22*t61+1.25d-1*gammaaa*
     <           t41*t51)-1.28772d-3*gammaaa*t22*t23*t24*t34*t41*t59)*wg
     =           ht+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = (t30*(1.0d+0*rhoa*t22*t26*(3.4339200
     1           000000003d-2*gammaaa*t35*t60*t67*taua+6.867840000000001
     2           d-2*t33*t36*t37*t60*taua+1.7169600000000002d-2*t33*t34*
     3           t40*taua-3.3333333333333337d+0*t33*t34*t35*taua+8.24140
     4           8d-2*t31*t32*t60*t90+1.591893886464d-4*t31*t32*t59*t67*
     5           t87+1.591893886464d-4*t1*t37*t38*t59*t87+1.591893886464
     6           d-4*gammaaa*t33*t35*t36*t59*t87+5.30631295488d-5*t1*t36
     7           *t40*t59*t60+5.30631295488d-5*gammaaa*t33*t39*t59*t60-1
     8           .030176d-2*t1*t35*t36*t59*t60-2.060352d-2*gammaaa*t31*t
     9           33*t59*t60+2.747136d-2*t37*t38*t54*t60+5.494272d-2*gamm
     :           aaa*t35*t36*t53*t60-5.15088d-3*t1*t34*t39*t59+1.373568d
     ;           -2*t34*t36*t40*t54-2.6666666666666666d+0*t30*t39*t54-2.
     <           6666666666666666d+0*t34*t35*t36*t54+2.747136d-2*gammaaa
     =           *t34*t39*t53-1.0666666666666666d+1*gammaaa*t31*t34*t53)
     >           +1.0d+0*rhoa*t26*t51*t68+1.0d+0*t22*t26*t68-1.25d-1*t22
     ?           *t23*t61-1.25d-1*t23*t41*t51-1.25d-1*t22*t23*t24*t41)+t
     @           23*t24*t30*t91+t23*(5.0d-1*rhoa*t22*t25*(6.0d-2*gammaaa
     1           *t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(-1.
     2           1519999999999996d-3*t32*t4*t82*t90-1.5999999999999998d-
     3           1*t3*t4*t54+2.879999999999999d-2*gammaaa*t4*t52*t53)-1.
     4           1519999999999996d-3*t32*t5*t82*t90-1.5999999999999998d-
     5           1*gammaaa*t3*t54*t63+9.599999999999997d-3*t32*t52*t53*t
     6           63-3.6d-3*gammaaa*t33*t52*t55+6.0d-2*t1*t3*t55-1.599999
     7           9999999998d-1*t3*t5*t54+2.879999999999999d-2*gammaaa*t5
     8           *t52*t53)-1.1519999999999996d-3*t32*t6*t82*t90-1.599999
     9           9999999998d-1*gammaaa*t3*t54*t64+9.599999999999997d-3*t
     :           32*t52*t53*t64-1.5999999999999998d-1*t3*t54*t6+2.879999
     ;           999999999d-2*gammaaa*t52*t53*t6-3.6d-3*gammaaa*t33*t52*
     <           t56+6.0d-2*t1*t3*t56)-1.1519999999999996d-3*t32*t7*t82*
     =           t90-1.5999999999999998d-1*t3*t54*t7+2.879999999999999d-
     >           2*gammaaa*t52*t53*t7-1.5999999999999998d-1*gammaaa*t3*t
     ?           54*t65+9.599999999999997d-3*t32*t52*t53*t65-3.6d-3*gamm
     @           aaa*t33*t52*t57+6.0d-2*t1*t3*t57)-1.25d-1*t51*t8-1.25d-
     1           1*t22*t24*t8+5.0d-1*rhoa*t25*t51*t66+5.0d-1*t22*t25*t66
     2           -1.25d-1*t22*t58)+t23*t24*(t89+1.25d-1*gammaaa*t22*t66)
     3           -5.15088d-3*rhoa*t22*t26*t34*t59*t68+t1*t34*(1.373568d-
     4           2*t22*t26*t41-5.15088d-3*t62)+5.30631295488d-5*t22*t26*
     5           t27*t41*t59*t60+6.4386d-4*t22*t23*t34*t41*t59-6.4386d-4
     6           *gammaaa*t22*t23*t34*t41*t54)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = (1.0d+0*rhoa*t22*t26*t30*(1.5918938
     1           86464d-4*gammaaa*t35*t36*t67*t87+1.591893886464d-4*t33*
     2           t37*t38*t87+1.591893886464d-4*t31*t32*t87/rhoa**1.06666
     3           66666666666d+1+5.30631295488d-5*gammaaa*t39*t60*t67-4.1
     4           20704d-2*gammaaa*t31*t60*t67+5.30631295488d-5*t33*t36*t
     5           40*t60-2.060352d-2*t33*t35*t36*t60-1.030176d-2*t33*t34*
     6           t39+2*t31*t33*t34)+t23*(5.0d-1*rhoa*t22*t25*(6.0d-2*gam
     7           maaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*
     8           (4.32d-4*gammaaa*t4*t67*t82-7.2d-3*t33*t4*t52)+4.32d-4*
     9           gammaaa*t5*t67*t82-7.2d-3*gammaaa*t33*t52*t63+1.2d-1*t1
     :           *t3*t63-7.2d-3*t33*t5*t52)+4.32d-4*gammaaa*t6*t67*t82-7
     ;           .2d-3*gammaaa*t33*t52*t64+1.2d-1*t1*t3*t64-7.2d-3*t33*t
     <           52*t6)+4.32d-4*gammaaa*t67*t7*t82-7.2d-3*t33*t52*t7-7.2
     =           d-3*gammaaa*t33*t52*t65+1.2d-1*t1*t3*t65)-2.5d-1*t22*t6
     >           6)+5.30631295488d-5*t22*t26*t41*t60*t72-1.030176d-2*t22
     ?           *t26*t27*t34*t68-2.5d-1*t22*t23*t30*t68+1.28772d-3*t1*t
     @           22*t23*t34*t41)*wght+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = (t30*(1.0d+0*rhoa*t22*t26*(1.373568d-
     1           1*t36*t37*t60*t72*taua+3.4339200000000003d-2*t34*t40*t7
     2           2*taua-1.3333333333333333d+1*t34*t37*t72*taua+6.8678400
     3           00000001d-2*gammaaa*t35*t60*t71*taua+3.183787772928d-4*
     4           gammaaa*t35*t36*t59*t72*t87+3.183787772928d-4*t31*t32*t
     5           59*t71*t87+3.183787772928d-4*t27*t37*t38*t59*t87+1.0612
     6           62590976d-4*gammaaa*t39*t59*t60*t72-2.060352d-2*gammaaa
     7           *t35*t59*t60*t72+1.4422464000000002d-1*t31*t32*t60*t67+
     8           1.061262590976d-4*t27*t36*t40*t59*t60-4.120704d-2*t27*t
     9           36*t37*t59*t60+3.4339200000000003d-2*t1*t37*t38*t60+8.9
     :           28192d-2*gammaaa*t33*t35*t36*t60-1.030176d-2*t27*t34*t4
     ;           0*t59+1.7169600000000002d-2*t1*t34*t36*t40-3.3333333333
     <           333337d+0*t1*t30*t40+4.464096d-2*gammaaa*t33*t34*t39-6.
     =           666666666666667d+0*t1*t34*t36*t37-8.666666666666666d+0*
     >           gammaaa*t33*t34*t35)+1.0d+0*rhoa*t26*t51*t73+1.0d+0*t22
     ?           *t26*t73+1.25d-1*gammaaa*t22*t61*t70+1.25d-1*gammaaa*t4
     @           1*t51*t70+1.25d-1*gammaaa*t22*t24*t41*t70)+1.0612625909
     1           76d-4*t22*t26*t41*t59*t60*t9+t70*(-5.0d-1*rhoa*t25*t51*
     2           t8-5.0d-1*t22*t25*t8-5.0d-1*rhoa*t22*t25*t58)+t23*(1.0d
     3           +0*rhoa*t51*t8+1.0d+0*t22*t8+1.0d+0*rhoa*t22*t58)-1.25d
     4           -1*gammaaa*t22*t24*t70*t8-5.15088d-3*rhoa*t22*t26*t34*t
     5           59*t73+1.25d-1*gammaaa*t22*t23*t24*t30*t73-6.4386d-4*ga
     6           mmaaa*t22*t34*t41*t59*t70-1.25d-1*gammaaa*t22*t24*t30*t
     7           41*t70+t27*t34*(1.7169600000000002d-2*t22*t26*t41-1.030
     8           176d-2*t62)-1.28772d-3*gammaaa*t1*t22*t23*t34*t41)*wght
     9           +Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = (1.061262590976d-4*t22*t26*t41*t60*t
     1           92+t30*t70*t91-1.030176d-2*t22*t26*t34*t68*t9+t70*(t89-
     2           5.0d-1*rhoa*t22*t25*t66)+1.0d+0*rhoa*t22*t26*t30*(3.183
     3           787772928d-4*t37*t38*t72*t87+3.183787772928d-4*gammaaa*
     4           t35*t36*t71*t87+3.183787772928d-4*t31*t32*t87/rhoa**9.6
     5           66666666666666d+0+1.061262590976d-4*t36*t40*t60*t72-4.1
     6           20704d-2*t36*t37*t60*t72-2.060352d-2*t35*t36*t60*t72-1.
     7           030176d-2*t34*t40*t72-1.030176d-2*t34*t39*t72+2.0d+0*t3
     8           4*t35*t72+1.061262590976d-4*gammaaa*t39*t60*t71-2.06035
     9           2d-2*gammaaa*t35*t60*t71-4.120704d-2*gammaaa*t31*t60*t7
     :           1)-5.15088d-3*t22*t26*t27*t34*t73-1.25d-1*t22*t23*t30*t
     ;           73-6.4386d-4*gammaaa*t1*t22*t34*t41*t70+1.0d+0*rhoa*t22
     <           *t23*t66+1.28772d-3*t22*t23*t27*t34*t41)*wght+Mmat2(iq,
     =           D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t22*t26*t30*(6.367575545
     1           856d-4*gammaaa*t35*t36*t87*t94+2.122525181952d-4*gammaa
     2           a*t39*t60*t94-8.241408d-2*gammaaa*t35*t60*t94+6.3675755
     3           45856d-4*t37*t38*t87*t92+2.122525181952d-4*t36*t40*t60*
     4           t92-1.6482816d-1*t36*t37*t60*t92-4.120704d-2*t34*t40*t9
     5           2+8.0d+0*t34*t37*t92+6.367575545856d-4*t31*t32*t87/rhoa
     6           **8.666666666666666d+0)+1.0d+0*rhoa*t22*t25*t8*t93-2.5d
     7           -1*gammaaa*t22*t30*t41*t93-2.060352d-2*t22*t26*t34*t73*
     8           t9-2.0d+0*rhoa*t22*t70*t8+2.122525181952d-4*t22*t26*t41
     9           *t60*t77+2.5d-1*gammaaa*t22*t30*t70*t73-2.57544d-3*gamm
     :           aaa*t22*t27*t34*t41*t70)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(22)
              t5 = 6.0d-2*gammaaa*t1*t3*t4+param(21)
              t6 = 6.0d-2*gammaaa*t1*t3*t5+param(20)
              t7 = 6.0d-2*gammaaa*t1*t3*t6+param(19)
              t8 = 6.0d-2*gammaaa*t1*t3*t7+param(18)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taua
              t24 = 1/rhoa
              t25 = 2.0d+0*taua-2.5d-1*gammaaa*t24
              t26 = 1.0d+0-1.25d-1*gammaaa*t23*t24
              t27 = 1/rhoa**1.6666666666666669d+0
              t28 = 2.0d+0*t27*taua
              t29 = 5.15088d-3*(t28+gammaaa*t1-9.11559972d+0)+1.0d+0
              t30 = 1/t29
              t31 = param(10)
              t32 = gammaaa**2
              t33 = 1/rhoa**5.333333333333333d+0
              t34 = 1/t29**2
              t35 = param(11)
              t36 = t28-9.11559972d+0
              t37 = param(12)
              t38 = t36**2
              t39 = param(8)
              t40 = param(9)
              t41 = t30*t36*t40+gammaaa*t1*t30*t39+t34*t37*t38+gammaaa*t
     1           1*t34*t35*t36+t31*t32*t33*t34+param(7)
              t42 = 1/t19
              t43 = 1/t10**3
              t44 = 1/rhoa**1.3333333333333333d+0
              t45 = 1/rhoa**1.1666666666666667d+0
              t46 = -9.970917392951799d-1*t45-7.418564737168958d-1*t44-4
     1           .002143174996817d-1*t43-1.264669550498372d-1*t27
              t47 = 1/t18**2
              t48 = 1/t15
              t49 = -1.8533958105157808d+0*t45-1.2815820791490704d+0*t44
     1           -8.223668877838045d-1*t43-1.6039141941921276d-1*t27
              t50 = 1/t14**2
              t51 = 1.0d+0*t17*t48*t49*t50+1.1102230246251565d-16*t21*t4
     1           2*t46*t47+3.0506411443514264d-19*t20*t44+1.321039893133
     2           9265d-3*t16*t44
              t52 = 1/t2**2
              t53 = 1/rhoa**6.333333333333333d+0
              t54 = 1/rhoa**3.6666666666666664d+0
              t55 = 9.599999999999997d-3*t32*t4*t52*t53-1.59999999999999
     1           98d-1*gammaaa*t3*t4*t54
              t56 = 6.0d-2*gammaaa*t1*t3*t55-1.5999999999999998d-1*gamma
     1           aa*t3*t5*t54+9.599999999999997d-3*t32*t5*t52*t53
              t57 = -1.5999999999999998d-1*gammaaa*t3*t54*t6+9.599999999
     1           999997d-3*t32*t52*t53*t6+6.0d-2*gammaaa*t1*t3*t56
              t58 = -1.5999999999999998d-1*gammaaa*t3*t54*t7+9.599999999
     1           999997d-3*t32*t52*t53*t7+6.0d-2*gammaaa*t1*t3*t57
              t59 = -3.3333333333333337d+0*t1*taua-2.6666666666666666d+0
     1           *gammaaa*t54
              t60 = 1/t29**3
              t61 = -3.3333333333333337d+0*t1*t30*t40*taua-6.66666666666
     1           6667d+0*t1*t34*t36*t37*taua-3.3333333333333337d+0*gamma
     2           aa*t33*t34*t35*taua-1.030176d-2*t37*t38*t59*t60-1.03017
     3           6d-2*gammaaa*t1*t35*t36*t59*t60-1.030176d-2*t31*t32*t33
     4           *t59*t60-5.15088d-3*t34*t36*t40*t59-5.15088d-3*gammaaa*
     5           t1*t34*t39*t59-2.6666666666666666d+0*gammaaa*t30*t39*t5
     6           4-2.6666666666666666d+0*gammaaa*t34*t35*t36*t54-5.33333
     7           3333333333d+0*t31*t32*t34*t53
              t62 = 1.0d+0*rhoa*t22*t26*t61+1.0d+0*rhoa*t26*t41*t51+1.0d
     1           +0*t22*t26*t41
              t63 = 6.0d-2*t1*t3*t4-3.6d-3*gammaaa*t33*t4*t52
              t64 = 6.0d-2*gammaaa*t1*t3*t63-3.6d-3*gammaaa*t33*t5*t52+6
     1           .0d-2*t1*t3*t5
              t65 = 6.0d-2*gammaaa*t1*t3*t64-3.6d-3*gammaaa*t33*t52*t6+6
     1           .0d-2*t1*t3*t6
              t66 = -3.6d-3*gammaaa*t33*t52*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmaaa*t1*t3*t65
              t67 = 1/rhoa**8
              t68 = -1.030176d-2*t31*t32*t60*t67-1.030176d-2*t1*t37*t38*
     1           t60-1.030176d-2*gammaaa*t33*t35*t36*t60-5.15088d-3*t1*t
     2           34*t36*t40-5.15088d-3*gammaaa*t33*t34*t39+t1*t30*t39+t1
     3           *t34*t35*t36+2*gammaaa*t31*t33*t34
              t69 = taua**2
              t70 = 1/t69
              t71 = 1/rhoa**7
              t72 = 1/rhoa**4.333333333333333d+0
              t73 = -2.060352d-2*gammaaa*t35*t36*t60*t72-1.030176d-2*gam
     1           maaa*t34*t39*t72+2.0d+0*gammaaa*t34*t35*t72-2.060352d-2
     2           *t31*t32*t60*t71-2.060352d-2*t27*t37*t38*t60-1.030176d-
     3           2*t27*t34*t36*t40+2.0d+0*t27*t30*t40+4.0d+0*t27*t34*t36
     4           *t37
              t74 = 1/rhoa**2
              t75 = t46**2
              t76 = 1/t10**5
              t77 = 1/rhoa**2.3333333333333334d+0
              t78 = 1/rhoa**2.1666666666666665d+0
              t79 = t49**2
              t80 = -2.0d+0*t17*t48*t79/t14**3+3.216395899738507d+1*t17*
     1           t79/(t14**4*t15**2)+1.0d+0*t17*t48*t50*(2.1622951122684
     2           114d+0*t78+1.7087761055320938d+0*t77+1.2335503316757068
     3           d+0*t76+2.673190323653546d-1*t1)+1.1102230246251565d-16
     4           *t21*t42*t47*(1.1632736958443765d+0*t78+9.8914196495586
     5           1d-1*t77+6.003214762495226d-1*t76+2.1077825841639536d-1
     6           *t1)-4.0675215258019015d-19*t20*t77-1.7613865241785684d
     7           -3*t16*t77-2.220446049250313d-16*t21*t42*t75/t18**3+1.7
     8           854583920998188d-15*t21*t75/(t18**4*t19**2)-8.497974591
     9           333913d-2*t44*t48*t49*t50-9.812069668265515d-18*t42*t44
     :           *t46*t47
              t81 = gammaaa**3
              t82 = 1/t2**3
              t83 = 1/rhoa**10
              t84 = 1/rhoa**7.333333333333333d+0
              t85 = 1/rhoa**4.666666666666667d+0
              t86 = t59**2
              t87 = 1/t29**4
              t88 = 8.88888888888889d+0*t54*taua+9.777777777777779d+0*ga
     1           mmaaa*t85
              t89 = 1.25d-1*t22*t8
              t90 = 1/rhoa**9
              t91 = 1.25d-1*gammaaa*t22*t68+1.25d-1*t22*t41
              t92 = 1/rhoa**3.3333333333333337d+0
              t93 = 1/taua**3
              t94 = 1/rhoa**6
              fnc(iq) = (5.0d-1*rhoa*t22*t23*t25*t8+1.0d+0*rhoa*t22*t26*
     1           t30*t41)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t23*(5.0d-1*rhoa*t25*t51*t8+5.0d-1*t22*t
     1           25*t8+5.0d-1*rhoa*t22*t25*t58)+1.25d-1*gammaaa*t22*t23*
     2           t24*t8+t30*t62-5.15088d-3*rhoa*t22*t26*t34*t41*t59+1.25
     3           d-1*gammaaa*t22*t23*t24*t30*t41)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (t23*(5.0d-1*rhoa*t22*t25*t66-1.25d-1*t2
     1           2*t8)+1.0d+0*rhoa*t22*t26*t30*t68-5.15088d-3*t22*t26*t2
     2           7*t34*t41-1.25d-1*t22*t23*t30*t41)*wght+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = (-1.030176d-2*t22*t26*t34*t41*t9-5.0d-1*r
     1           hoa*t22*t25*t70*t8+1.0d+0*rhoa*t22*t23*t8+1.0d+0*rhoa*t
     2           22*t26*t30*t73+1.25d-1*gammaaa*t22*t30*t41*t70)*wght+Mm
     3           at(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t30*(1.0d+0*rhoa*t22*t26*(1.373568d-
     1           1*t1*t36*t37*t59*t60*taua+6.867840000000001d-2*gammaaa*
     2           t33*t35*t59*t60*taua+3.4339200000000003d-2*t1*t34*t40*t
     3           59*taua+8.88888888888889d+0*t30*t40*t54*taua+1.77777777
     4           77777778d+1*t34*t36*t37*t54*taua+2.6666666666666666d+1*
     5           gammaaa*t34*t35*t53*taua-1.030176d-2*t37*t38*t60*t88-1.
     6           030176d-2*gammaaa*t1*t35*t36*t60*t88-1.030176d-2*t31*t3
     7           2*t33*t60*t88-5.15088d-3*t34*t36*t40*t88-5.15088d-3*gam
     8           maaa*t1*t34*t39*t88+1.591893886464d-4*t37*t38*t86*t87+1
     9           .591893886464d-4*gammaaa*t1*t35*t36*t86*t87+1.591893886
     :           464d-4*t31*t32*t33*t86*t87+5.30631295488d-5*t36*t40*t60
     ;           *t86+5.30631295488d-5*gammaaa*t1*t39*t60*t86+9.77777777
     <           7777779d+0*gammaaa*t30*t39*t85+9.777777777777779d+0*gam
     =           maaa*t34*t35*t36*t85+3.377777777777778d+1*t31*t32*t34*t
     >           84+2.2222222222222224d+1*t33*t34*t37*t69+5.494272d-2*ga
     ?           mmaaa*t35*t36*t54*t59*t60+1.0988544d-1*t31*t32*t53*t59*
     @           t60+2.747136d-2*gammaaa*t34*t39*t54*t59)+1.0d+0*rhoa*t2
     1           6*t41*t80+1.25d-1*gammaaa*t22*t23*t41*t74+2.0d+0*rhoa*t
     2           26*t51*t61+2.0d+0*t22*t26*t61+1.25d-1*gammaaa*t22*t23*t
     3           24*t61+2.0d+0*t26*t41*t51+1.25d-1*gammaaa*t23*t24*t41*t
     4           51)+t34*(-5.15088d-3*rhoa*t22*t26*t41*t88-5.15088d-3*t5
     5           9*t62-5.15088d-3*rhoa*t22*t26*t59*t61-5.15088d-3*rhoa*t
     6           26*t41*t51*t59-5.15088d-3*t22*t26*t41*t59)+5.3063129548
     7           8d-5*rhoa*t22*t26*t41*t60*t86+t23*(5.0d-1*rhoa*t22*t25*
     8           (6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gam
     9           maaa*t1*t3*(5.866666666666666d-1*gammaaa*t3*t4*t85-8.63
     :           9999999999998d-2*t32*t4*t52*t84+3.0719999999999986d-3*t
     ;           4*t81*t82*t83)+5.866666666666666d-1*gammaaa*t3*t5*t85-8
     <           .639999999999998d-2*t32*t5*t52*t84+3.0719999999999986d-
     =           3*t5*t81*t82*t83-3.1999999999999995d-1*gammaaa*t3*t54*t
     >           55+1.9199999999999995d-2*t32*t52*t53*t55)+5.86666666666
     ?           6666d-1*gammaaa*t3*t6*t85-8.639999999999998d-2*t32*t52*
     @           t6*t84+3.0719999999999986d-3*t6*t81*t82*t83-3.199999999
     1           9999995d-1*gammaaa*t3*t54*t56+1.9199999999999995d-2*t32
     2           *t52*t53*t56)+5.866666666666666d-1*gammaaa*t3*t7*t85-8.
     3           639999999999998d-2*t32*t52*t7*t84+3.0719999999999986d-3
     4           *t7*t81*t82*t83-3.1999999999999995d-1*gammaaa*t3*t54*t5
     5           7+1.9199999999999995d-2*t32*t52*t53*t57)+5.0d-1*rhoa*t2
     6           5*t8*t80+1.25d-1*gammaaa*t22*t74*t8+1.0d+0*t25*t51*t8+1
     7           .25d-1*gammaaa*t24*t51*t8+1.0d+0*rhoa*t25*t51*t58+1.0d+
     8           0*t22*t25*t58+1.25d-1*gammaaa*t22*t24*t58)+t23*t24*(1.2
     9           5d-1*gammaaa*t51*t8+1.25d-1*gammaaa*t22*t58)-1.25d-1*ga
     :           mmaaa*t22*t23*t74*t8-1.25d-1*gammaaa*t22*t23*t30*t41*t7
     ;           4+t23*t24*t30*(1.25d-1*gammaaa*t22*t61+1.25d-1*gammaaa*
     <           t41*t51)-1.28772d-3*gammaaa*t22*t23*t24*t34*t41*t59)*wg
     =           ht+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = (t30*(1.0d+0*rhoa*t22*t26*(3.4339200
     1           000000003d-2*gammaaa*t35*t60*t67*taua+6.867840000000001
     2           d-2*t33*t36*t37*t60*taua+1.7169600000000002d-2*t33*t34*
     3           t40*taua-3.3333333333333337d+0*t33*t34*t35*taua+8.24140
     4           8d-2*t31*t32*t60*t90+1.591893886464d-4*t31*t32*t59*t67*
     5           t87+1.591893886464d-4*t1*t37*t38*t59*t87+1.591893886464
     6           d-4*gammaaa*t33*t35*t36*t59*t87+5.30631295488d-5*t1*t36
     7           *t40*t59*t60+5.30631295488d-5*gammaaa*t33*t39*t59*t60-1
     8           .030176d-2*t1*t35*t36*t59*t60-2.060352d-2*gammaaa*t31*t
     9           33*t59*t60+2.747136d-2*t37*t38*t54*t60+5.494272d-2*gamm
     :           aaa*t35*t36*t53*t60-5.15088d-3*t1*t34*t39*t59+1.373568d
     ;           -2*t34*t36*t40*t54-2.6666666666666666d+0*t30*t39*t54-2.
     <           6666666666666666d+0*t34*t35*t36*t54+2.747136d-2*gammaaa
     =           *t34*t39*t53-1.0666666666666666d+1*gammaaa*t31*t34*t53)
     >           +1.0d+0*rhoa*t26*t51*t68+1.0d+0*t22*t26*t68-1.25d-1*t22
     ?           *t23*t61-1.25d-1*t23*t41*t51-1.25d-1*t22*t23*t24*t41)+t
     @           23*t24*t30*t91+t23*(5.0d-1*rhoa*t22*t25*(6.0d-2*gammaaa
     1           *t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(-1.
     2           1519999999999996d-3*t32*t4*t82*t90-1.5999999999999998d-
     3           1*t3*t4*t54+2.879999999999999d-2*gammaaa*t4*t52*t53)-1.
     4           1519999999999996d-3*t32*t5*t82*t90-1.5999999999999998d-
     5           1*gammaaa*t3*t54*t63+9.599999999999997d-3*t32*t52*t53*t
     6           63-3.6d-3*gammaaa*t33*t52*t55+6.0d-2*t1*t3*t55-1.599999
     7           9999999998d-1*t3*t5*t54+2.879999999999999d-2*gammaaa*t5
     8           *t52*t53)-1.1519999999999996d-3*t32*t6*t82*t90-1.599999
     9           9999999998d-1*gammaaa*t3*t54*t64+9.599999999999997d-3*t
     :           32*t52*t53*t64-1.5999999999999998d-1*t3*t54*t6+2.879999
     ;           999999999d-2*gammaaa*t52*t53*t6-3.6d-3*gammaaa*t33*t52*
     <           t56+6.0d-2*t1*t3*t56)-1.1519999999999996d-3*t32*t7*t82*
     =           t90-1.5999999999999998d-1*t3*t54*t7+2.879999999999999d-
     >           2*gammaaa*t52*t53*t7-1.5999999999999998d-1*gammaaa*t3*t
     ?           54*t65+9.599999999999997d-3*t32*t52*t53*t65-3.6d-3*gamm
     @           aaa*t33*t52*t57+6.0d-2*t1*t3*t57)-1.25d-1*t51*t8-1.25d-
     1           1*t22*t24*t8+5.0d-1*rhoa*t25*t51*t66+5.0d-1*t22*t25*t66
     2           -1.25d-1*t22*t58)+t23*t24*(t89+1.25d-1*gammaaa*t22*t66)
     3           -5.15088d-3*rhoa*t22*t26*t34*t59*t68+t1*t34*(1.373568d-
     4           2*t22*t26*t41-5.15088d-3*t62)+5.30631295488d-5*t22*t26*
     5           t27*t41*t59*t60+6.4386d-4*t22*t23*t34*t41*t59-6.4386d-4
     6           *gammaaa*t22*t23*t34*t41*t54)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = (1.0d+0*rhoa*t22*t26*t30*(1.5918938
     1           86464d-4*gammaaa*t35*t36*t67*t87+1.591893886464d-4*t33*
     2           t37*t38*t87+1.591893886464d-4*t31*t32*t87/rhoa**1.06666
     3           66666666666d+1+5.30631295488d-5*gammaaa*t39*t60*t67-4.1
     4           20704d-2*gammaaa*t31*t60*t67+5.30631295488d-5*t33*t36*t
     5           40*t60-2.060352d-2*t33*t35*t36*t60-1.030176d-2*t33*t34*
     6           t39+2*t31*t33*t34)+t23*(5.0d-1*rhoa*t22*t25*(6.0d-2*gam
     7           maaa*t1*t3*(6.0d-2*gammaaa*t1*t3*(6.0d-2*gammaaa*t1*t3*
     8           (4.32d-4*gammaaa*t4*t67*t82-7.2d-3*t33*t4*t52)+4.32d-4*
     9           gammaaa*t5*t67*t82-7.2d-3*gammaaa*t33*t52*t63+1.2d-1*t1
     :           *t3*t63-7.2d-3*t33*t5*t52)+4.32d-4*gammaaa*t6*t67*t82-7
     ;           .2d-3*gammaaa*t33*t52*t64+1.2d-1*t1*t3*t64-7.2d-3*t33*t
     <           52*t6)+4.32d-4*gammaaa*t67*t7*t82-7.2d-3*t33*t52*t7-7.2
     =           d-3*gammaaa*t33*t52*t65+1.2d-1*t1*t3*t65)-2.5d-1*t22*t6
     >           6)+5.30631295488d-5*t22*t26*t41*t60*t72-1.030176d-2*t22
     ?           *t26*t27*t34*t68-2.5d-1*t22*t23*t30*t68+1.28772d-3*t1*t
     @           22*t23*t34*t41)*wght+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = (t30*(1.0d+0*rhoa*t22*t26*(1.373568d-
     1           1*t36*t37*t60*t72*taua+3.4339200000000003d-2*t34*t40*t7
     2           2*taua-1.3333333333333333d+1*t34*t37*t72*taua+6.8678400
     3           00000001d-2*gammaaa*t35*t60*t71*taua+3.183787772928d-4*
     4           gammaaa*t35*t36*t59*t72*t87+3.183787772928d-4*t31*t32*t
     5           59*t71*t87+3.183787772928d-4*t27*t37*t38*t59*t87+1.0612
     6           62590976d-4*gammaaa*t39*t59*t60*t72-2.060352d-2*gammaaa
     7           *t35*t59*t60*t72+1.4422464000000002d-1*t31*t32*t60*t67+
     8           1.061262590976d-4*t27*t36*t40*t59*t60-4.120704d-2*t27*t
     9           36*t37*t59*t60+3.4339200000000003d-2*t1*t37*t38*t60+8.9
     :           28192d-2*gammaaa*t33*t35*t36*t60-1.030176d-2*t27*t34*t4
     ;           0*t59+1.7169600000000002d-2*t1*t34*t36*t40-3.3333333333
     <           333337d+0*t1*t30*t40+4.464096d-2*gammaaa*t33*t34*t39-6.
     =           666666666666667d+0*t1*t34*t36*t37-8.666666666666666d+0*
     >           gammaaa*t33*t34*t35)+1.0d+0*rhoa*t26*t51*t73+1.0d+0*t22
     ?           *t26*t73+1.25d-1*gammaaa*t22*t61*t70+1.25d-1*gammaaa*t4
     @           1*t51*t70+1.25d-1*gammaaa*t22*t24*t41*t70)+1.0612625909
     1           76d-4*t22*t26*t41*t59*t60*t9+t70*(-5.0d-1*rhoa*t25*t51*
     2           t8-5.0d-1*t22*t25*t8-5.0d-1*rhoa*t22*t25*t58)+t23*(1.0d
     3           +0*rhoa*t51*t8+1.0d+0*t22*t8+1.0d+0*rhoa*t22*t58)-1.25d
     4           -1*gammaaa*t22*t24*t70*t8-5.15088d-3*rhoa*t22*t26*t34*t
     5           59*t73+1.25d-1*gammaaa*t22*t23*t24*t30*t73-6.4386d-4*ga
     6           mmaaa*t22*t34*t41*t59*t70-1.25d-1*gammaaa*t22*t24*t30*t
     7           41*t70+t27*t34*(1.7169600000000002d-2*t22*t26*t41-1.030
     8           176d-2*t62)-1.28772d-3*gammaaa*t1*t22*t23*t34*t41)*wght
     9           +Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = (1.061262590976d-4*t22*t26*t41*t60*t
     1           92+t30*t70*t91-1.030176d-2*t22*t26*t34*t68*t9+t70*(t89-
     2           5.0d-1*rhoa*t22*t25*t66)+1.0d+0*rhoa*t22*t26*t30*(3.183
     3           787772928d-4*t37*t38*t72*t87+3.183787772928d-4*gammaaa*
     4           t35*t36*t71*t87+3.183787772928d-4*t31*t32*t87/rhoa**9.6
     5           66666666666666d+0+1.061262590976d-4*t36*t40*t60*t72-4.1
     6           20704d-2*t36*t37*t60*t72-2.060352d-2*t35*t36*t60*t72-1.
     7           030176d-2*t34*t40*t72-1.030176d-2*t34*t39*t72+2.0d+0*t3
     8           4*t35*t72+1.061262590976d-4*gammaaa*t39*t60*t71-2.06035
     9           2d-2*gammaaa*t35*t60*t71-4.120704d-2*gammaaa*t31*t60*t7
     :           1)-5.15088d-3*t22*t26*t27*t34*t73-1.25d-1*t22*t23*t30*t
     ;           73-6.4386d-4*gammaaa*t1*t22*t34*t41*t70+1.0d+0*rhoa*t22
     <           *t23*t66+1.28772d-3*t22*t23*t27*t34*t41)*wght+Mmat2(iq,
     =           D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t22*t26*t30*(6.367575545
     1           856d-4*gammaaa*t35*t36*t87*t94+2.122525181952d-4*gammaa
     2           a*t39*t60*t94-8.241408d-2*gammaaa*t35*t60*t94+6.3675755
     3           45856d-4*t37*t38*t87*t92+2.122525181952d-4*t36*t40*t60*
     4           t92-1.6482816d-1*t36*t37*t60*t92-4.120704d-2*t34*t40*t9
     5           2+8.0d+0*t34*t37*t92+6.367575545856d-4*t31*t32*t87/rhoa
     6           **8.666666666666666d+0)+1.0d+0*rhoa*t22*t25*t8*t93-2.5d
     7           -1*gammaaa*t22*t30*t41*t93-2.060352d-2*t22*t26*t34*t73*
     8           t9-2.0d+0*rhoa*t22*t70*t8+2.122525181952d-4*t22*t26*t41
     9           *t60*t77+2.5d-1*gammaaa*t22*t30*t70*t73-2.57544d-3*gamm
     :           aaa*t22*t27*t34*t41*t70)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhoa**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 2.4d-51*t1+1.0d+0
              t28 = 1/t27
              t29 = param(22)
              t30 = 2.4d-51*t1*t28*t29+param(21)
              t31 = 2.4d-51*t1*t28*t30+param(20)
              t32 = 2.4d-51*t1*t28*t31+param(19)
              t33 = 2.4d-51*t1*t28*t32+param(18)
              t34 = 1/t23
              t35 = 1/t14**3
              t36 = 1/rhoa**1.3333333333333333d+0
              t37 = 1/rhoa**1.1666666666666667d+0
              t38 = -9.970917392951799d-1*t37-7.418564737168958d-1*t36-4
     1           .002143174996817d-1*t35-1.264669550498372d-1*t1
              t39 = 1/t22**2
              t40 = 1/t19
              t41 = -1.8533958105157808d+0*t37-1.2815820791490704d+0*t36
     1           -8.223668877838045d-1*t35-1.6039141941921276d-1*t1
              t42 = 1/t18**2
              t43 = 1.0d+0*t21*t40*t41*t42+1.1102230246251565d-16*t25*t3
     1           4*t38*t39+3.0506411443514264d-19*t24*t36+1.321039893133
     2           9265d-3*t20*t36
              t44 = 1/t27**2
              t45 = 1/rhoa**4.333333333333333d+0
              t46 = 1/rhoa**2.6666666666666666d+0
              t47 = 9.6d-102*t29*t44*t45-4.0d-51*t28*t29*t46
              t48 = 2.4d-51*t1*t28*t47-4.0d-51*t28*t30*t46+9.6d-102*t30*
     1           t44*t45
              t49 = 2.4d-51*t1*t28*t48-4.0d-51*t28*t31*t46+9.6d-102*t31*
     1           t44*t45
              t50 = 2.4d-51*t1*t28*t49-4.0d-51*t28*t32*t46+9.6d-102*t32*
     1           t44*t45
              t51 = 1/t2**3
              t52 = 5.15088d-52*t46*t5*t6*t9-3.333333333333333d-50*t3*t4
     1           6*t9+1.6482816d-150*t51*t8/rhoa**6-5.333333333333334d-9
     2           9*t45*t5*t8+1.030176d-51*t4*t46*t51*t7+4.12070399999999
     3           95d-101*t11*t45*t51*t6-6.666666666666666d-50*t4*t46*t5*
     4           t6-6.666666666666666d-50*t11*t46*t5*t6-1.33333333333333
     5           33d-99*t11*t45*t5+2.0603519999999997d-101*t10*t45*t5-6.
     6           666666666666666d-50*t10*t3*t46
              t53 = 5.0d-1*rhoa*t26*t52+5.0d-1*rhoa*t12*t43+5.0d-1*t12*t
     1           26
              t54 = t38**2
              t55 = 1/t14**5
              t56 = 1/rhoa**2.3333333333333334d+0
              t57 = 1/rhoa**2.1666666666666665d+0
              t58 = t41**2
              t59 = -2.0d+0*t21*t40*t58/t18**3+3.216395899738507d+1*t21*
     1           t58/(t18**4*t19**2)+1.0d+0*t21*t40*t42*(2.1622951122684
     2           114d+0*t57+1.7087761055320938d+0*t56+1.2335503316757068
     3           d+0*t55+2.673190323653546d-1*t46)+1.1102230246251565d-1
     4           6*t25*t34*t39*(1.1632736958443765d+0*t57+9.891419649558
     5           61d-1*t56+6.003214762495226d-1*t55+2.1077825841639536d-
     6           1*t46)-4.0675215258019015d-19*t24*t56-1.761386524178568
     7           4d-3*t20*t56-2.220446049250313d-16*t25*t34*t54/t22**3+1
     8           .7854583920998188d-15*t25*t54/(t22**4*t23**2)-8.4979745
     9           91333913d-2*t36*t40*t41*t42-9.812069668265515d-18*t34*t
     :           36*t38*t39
              t60 = 1/t27**3
              t61 = 1/rhoa**7
              t62 = 1/rhoa**5.333333333333333d+0
              t63 = 1/rhoa**3.6666666666666664d+0
              t64 = 1/t2**4
              fnc(iq) = (5.0d-1*rhoa*t26*t33+5.0d-1*rhoa*t12*t26*t3)*wgh
     1           t+fnc(iq)
              Amat(iq,D1_RA) = (t3*t53+5.0d-1*rhoa*t26*t50+2.57544d-52*t
     1           1*t12*t26*t5+5.0d-1*rhoa*t33*t43+5.0d-1*t26*t33)*wght+A
     2           mat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t3*(5.0d-1*rhoa*t26*(-1.373568d-51*t
     1           5*t6*t63*t9+8.888888888888888d-50*t3*t63*t9+5.306312954
     2           879999d-103*t51*t6*t62*t9-3.43392d-101*t5*t62*t9+2.5470
     3           302183424d-201*t64*t8/rhoa**8.666666666666666d+0+2.3111
     4           111111111113d-98*t5*t62*t8-1.53839616d-149*t51*t61*t8+1
     5           .5918938864639998d-102*t4*t62*t64*t7-2.747136d-51*t4*t5
     6           1*t63*t7+6.367575545855999d-152*t11*t6*t61*t64+1.777777
     7           7777777776d-49*t4*t5*t6*t63+1.7777777777777776d-49*t11*
     8           t5*t6*t63+1.7777777777777776d-49*t10*t3*t63-1.373568d-1
     9           00*t4*t51*t6*t62-2.4724223999999997d-100*t11*t51*t6*t62
     :           +2.222222222222222d-99*t4*t5*t62+8.0d-99*t11*t5*t62-1.2
     ;           362111999999999d-100*t10*t5*t62-2.7471359999999995d-150
     <           *t11*t51*t61+2.1225251819519997d-152*t10*t51*t61)+5.0d-
     =           1*rhoa*t12*t59+1.0d+0*rhoa*t43*t52+1.0d+0*t26*t52+1.0d+
     >           0*t12*t43)+5.0d-1*rhoa*t26*(2.4d-51*t1*t28*(2.4d-51*t1*
     ?           t28*(2.4d-51*t1*t28*(1.0666666666666666d-50*t28*t29*t63
     @           -5.76d-101*t29*t44*t62+7.68d-152*t29*t60*t61)+1.0666666
     1           666666666d-50*t28*t30*t63-5.76d-101*t30*t44*t62+7.68d-1
     2           52*t30*t60*t61-8.0d-51*t28*t46*t47+1.92d-101*t44*t45*t4
     3           7)+1.0666666666666666d-50*t28*t31*t63-5.76d-101*t31*t44
     4           *t62+7.68d-152*t31*t60*t61-8.0d-51*t28*t46*t48+1.92d-10
     5           1*t44*t45*t48)+1.0666666666666666d-50*t28*t32*t63-5.76d
     6           -101*t32*t44*t62+7.68d-152*t32*t60*t61-8.0d-51*t28*t46*
     7           t49+1.92d-101*t44*t45*t49)+5.0d-1*rhoa*t33*t59+t46*t5*(
     8           5.15088d-52*t53-4.2923999999999995d-52*t12*t26)+t1*t5*(
     9           2.57544d-52*t26*t52+2.57544d-52*t12*t43)+2.653156477439
     :           9996d-103*t12*t26*t45*t51+1.0d+0*rhoa*t43*t50+1.0d+0*t2
     ;           6*t50+1.0d+0*t33*t43)*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhoa**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 2.4d-51*t1+1.0d+0
              t28 = 1/t27
              t29 = param(22)
              t30 = 2.4d-51*t1*t28*t29+param(21)
              t31 = 2.4d-51*t1*t28*t30+param(20)
              t32 = 2.4d-51*t1*t28*t31+param(19)
              t33 = 2.4d-51*t1*t28*t32+param(18)
              t34 = 1/t23
              t35 = 1/t14**3
              t36 = 1/rhoa**1.3333333333333333d+0
              t37 = 1/rhoa**1.1666666666666667d+0
              t38 = -9.970917392951799d-1*t37-7.418564737168958d-1*t36-4
     1           .002143174996817d-1*t35-1.264669550498372d-1*t1
              t39 = 1/t22**2
              t40 = 1/t19
              t41 = -1.8533958105157808d+0*t37-1.2815820791490704d+0*t36
     1           -8.223668877838045d-1*t35-1.6039141941921276d-1*t1
              t42 = 1/t18**2
              t43 = 1.0d+0*t21*t40*t41*t42+1.1102230246251565d-16*t25*t3
     1           4*t38*t39+3.0506411443514264d-19*t24*t36+1.321039893133
     2           9265d-3*t20*t36
              t44 = 1/t27**2
              t45 = 1/rhoa**4.333333333333333d+0
              t46 = 1/rhoa**2.6666666666666666d+0
              t47 = 9.6d-102*t29*t44*t45-4.0d-51*t28*t29*t46
              t48 = 2.4d-51*t1*t28*t47-4.0d-51*t28*t30*t46+9.6d-102*t30*
     1           t44*t45
              t49 = 2.4d-51*t1*t28*t48-4.0d-51*t28*t31*t46+9.6d-102*t31*
     1           t44*t45
              t50 = 2.4d-51*t1*t28*t49-4.0d-51*t28*t32*t46+9.6d-102*t32*
     1           t44*t45
              t51 = 1/t2**3
              t52 = 5.15088d-52*t46*t5*t6*t9-3.333333333333333d-50*t3*t4
     1           6*t9+1.6482816d-150*t51*t8/rhoa**6-5.333333333333334d-9
     2           9*t45*t5*t8+1.030176d-51*t4*t46*t51*t7+4.12070399999999
     3           95d-101*t11*t45*t51*t6-6.666666666666666d-50*t4*t46*t5*
     4           t6-6.666666666666666d-50*t11*t46*t5*t6-1.33333333333333
     5           33d-99*t11*t45*t5+2.0603519999999997d-101*t10*t45*t5-6.
     6           666666666666666d-50*t10*t3*t46
              t53 = 5.0d-1*rhoa*t26*t52+5.0d-1*rhoa*t12*t43+5.0d-1*t12*t
     1           26
              t54 = t38**2
              t55 = 1/t14**5
              t56 = 1/rhoa**2.3333333333333334d+0
              t57 = 1/rhoa**2.1666666666666665d+0
              t58 = t41**2
              t59 = -2.0d+0*t21*t40*t58/t18**3+3.216395899738507d+1*t21*
     1           t58/(t18**4*t19**2)+1.0d+0*t21*t40*t42*(2.1622951122684
     2           114d+0*t57+1.7087761055320938d+0*t56+1.2335503316757068
     3           d+0*t55+2.673190323653546d-1*t46)+1.1102230246251565d-1
     4           6*t25*t34*t39*(1.1632736958443765d+0*t57+9.891419649558
     5           61d-1*t56+6.003214762495226d-1*t55+2.1077825841639536d-
     6           1*t46)-4.0675215258019015d-19*t24*t56-1.761386524178568
     7           4d-3*t20*t56-2.220446049250313d-16*t25*t34*t54/t22**3+1
     8           .7854583920998188d-15*t25*t54/(t22**4*t23**2)-8.4979745
     9           91333913d-2*t36*t40*t41*t42-9.812069668265515d-18*t34*t
     :           36*t38*t39
              t60 = 1/t27**3
              t61 = 1/rhoa**7
              t62 = 1/rhoa**5.333333333333333d+0
              t63 = 1/rhoa**3.6666666666666664d+0
              t64 = 1/t2**4
              fnc(iq) = (5.0d-1*rhoa*t26*t33+5.0d-1*rhoa*t12*t26*t3)*wgh
     1           t+fnc(iq)
              Amat(iq,D1_RA) = (t3*t53+5.0d-1*rhoa*t26*t50+2.57544d-52*t
     1           1*t12*t26*t5+5.0d-1*rhoa*t33*t43+5.0d-1*t26*t33)*wght+A
     2           mat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t3*(5.0d-1*rhoa*t26*(-1.373568d-51*t
     1           5*t6*t63*t9+8.888888888888888d-50*t3*t63*t9+5.306312954
     2           879999d-103*t51*t6*t62*t9-3.43392d-101*t5*t62*t9+2.5470
     3           302183424d-201*t64*t8/rhoa**8.666666666666666d+0+2.3111
     4           111111111113d-98*t5*t62*t8-1.53839616d-149*t51*t61*t8+1
     5           .5918938864639998d-102*t4*t62*t64*t7-2.747136d-51*t4*t5
     6           1*t63*t7+6.367575545855999d-152*t11*t6*t61*t64+1.777777
     7           7777777776d-49*t4*t5*t6*t63+1.7777777777777776d-49*t11*
     8           t5*t6*t63+1.7777777777777776d-49*t10*t3*t63-1.373568d-1
     9           00*t4*t51*t6*t62-2.4724223999999997d-100*t11*t51*t6*t62
     :           +2.222222222222222d-99*t4*t5*t62+8.0d-99*t11*t5*t62-1.2
     ;           362111999999999d-100*t10*t5*t62-2.7471359999999995d-150
     <           *t11*t51*t61+2.1225251819519997d-152*t10*t51*t61)+5.0d-
     =           1*rhoa*t12*t59+1.0d+0*rhoa*t43*t52+1.0d+0*t26*t52+1.0d+
     >           0*t12*t43)+5.0d-1*rhoa*t26*(2.4d-51*t1*t28*(2.4d-51*t1*
     ?           t28*(2.4d-51*t1*t28*(1.0666666666666666d-50*t28*t29*t63
     @           -5.76d-101*t29*t44*t62+7.68d-152*t29*t60*t61)+1.0666666
     1           666666666d-50*t28*t30*t63-5.76d-101*t30*t44*t62+7.68d-1
     2           52*t30*t60*t61-8.0d-51*t28*t46*t47+1.92d-101*t44*t45*t4
     3           7)+1.0666666666666666d-50*t28*t31*t63-5.76d-101*t31*t44
     4           *t62+7.68d-152*t31*t60*t61-8.0d-51*t28*t46*t48+1.92d-10
     5           1*t44*t45*t48)+1.0666666666666666d-50*t28*t32*t63-5.76d
     6           -101*t32*t44*t62+7.68d-152*t32*t60*t61-8.0d-51*t28*t46*
     7           t49+1.92d-101*t44*t45*t49)+5.0d-1*rhoa*t33*t59+t46*t5*(
     8           5.15088d-52*t53-4.2923999999999995d-52*t12*t26)+t1*t5*(
     9           2.57544d-52*t26*t52+2.57544d-52*t12*t43)+2.653156477439
     :           9996d-103*t12*t26*t45*t51+1.0d+0*rhoa*t43*t50+1.0d+0*t2
     ;           6*t50+1.0d+0*t33*t43)*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = param(22)
              t5 = 6.0d-2*gammabb*t1*t3*t4+param(21)
              t6 = 6.0d-2*gammabb*t1*t3*t5+param(20)
              t7 = 6.0d-2*gammabb*t1*t3*t6+param(19)
              t8 = 6.0d-2*gammabb*t1*t3*t7+param(18)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taub
              t24 = 1/rhob
              t25 = 2.0d+0*taub-2.5d-1*gammabb*t24
              t26 = 1.0d+0-1.25d-1*gammabb*t23*t24
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 2.0d+0*t27*taub
              t29 = 5.15088d-3*(t28+gammabb*t1-9.11559972d+0)+1.0d+0
              t30 = 1/t29
              t31 = param(10)
              t32 = gammabb**2
              t33 = 1/rhob**5.333333333333333d+0
              t34 = 1/t29**2
              t35 = param(11)
              t36 = t28-9.11559972d+0
              t37 = param(12)
              t38 = t36**2
              t39 = param(8)
              t40 = param(9)
              t41 = t30*t36*t40+gammabb*t1*t30*t39+t34*t37*t38+gammabb*t
     1           1*t34*t35*t36+t31*t32*t33*t34+param(7)
              t42 = 1/t19
              t43 = 1/t10**3
              t44 = 1/rhob**1.3333333333333333d+0
              t45 = 1/rhob**1.1666666666666667d+0
              t46 = -9.970917392951799d-1*t45-7.418564737168958d-1*t44-4
     1           .002143174996817d-1*t43-1.264669550498372d-1*t27
              t47 = 1/t18**2
              t48 = 1/t15
              t49 = -1.8533958105157808d+0*t45-1.2815820791490704d+0*t44
     1           -8.223668877838045d-1*t43-1.6039141941921276d-1*t27
              t50 = 1/t14**2
              t51 = 1.0d+0*t17*t48*t49*t50+1.1102230246251565d-16*t21*t4
     1           2*t46*t47+3.0506411443514264d-19*t20*t44+1.321039893133
     2           9265d-3*t16*t44
              t52 = 1/t2**2
              t53 = 1/rhob**6.333333333333333d+0
              t54 = 1/rhob**3.6666666666666664d+0
              t55 = 9.599999999999997d-3*t32*t4*t52*t53-1.59999999999999
     1           98d-1*gammabb*t3*t4*t54
              t56 = 6.0d-2*gammabb*t1*t3*t55-1.5999999999999998d-1*gamma
     1           bb*t3*t5*t54+9.599999999999997d-3*t32*t5*t52*t53
              t57 = -1.5999999999999998d-1*gammabb*t3*t54*t6+9.599999999
     1           999997d-3*t32*t52*t53*t6+6.0d-2*gammabb*t1*t3*t56
              t58 = -1.5999999999999998d-1*gammabb*t3*t54*t7+9.599999999
     1           999997d-3*t32*t52*t53*t7+6.0d-2*gammabb*t1*t3*t57
              t59 = -3.3333333333333337d+0*t1*taub-2.6666666666666666d+0
     1           *gammabb*t54
              t60 = 1/t29**3
              t61 = -3.3333333333333337d+0*t1*t30*t40*taub-6.66666666666
     1           6667d+0*t1*t34*t36*t37*taub-3.3333333333333337d+0*gamma
     2           bb*t33*t34*t35*taub-1.030176d-2*t37*t38*t59*t60-1.03017
     3           6d-2*gammabb*t1*t35*t36*t59*t60-1.030176d-2*t31*t32*t33
     4           *t59*t60-5.15088d-3*t34*t36*t40*t59-5.15088d-3*gammabb*
     5           t1*t34*t39*t59-2.6666666666666666d+0*gammabb*t30*t39*t5
     6           4-2.6666666666666666d+0*gammabb*t34*t35*t36*t54-5.33333
     7           3333333333d+0*t31*t32*t34*t53
              t62 = 1.0d+0*rhob*t22*t26*t61+1.0d+0*rhob*t26*t41*t51+1.0d
     1           +0*t22*t26*t41
              t63 = 6.0d-2*t1*t3*t4-3.6d-3*gammabb*t33*t4*t52
              t64 = 6.0d-2*gammabb*t1*t3*t63-3.6d-3*gammabb*t33*t5*t52+6
     1           .0d-2*t1*t3*t5
              t65 = 6.0d-2*gammabb*t1*t3*t64-3.6d-3*gammabb*t33*t52*t6+6
     1           .0d-2*t1*t3*t6
              t66 = -3.6d-3*gammabb*t33*t52*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmabb*t1*t3*t65
              t67 = 1/rhob**8
              t68 = -1.030176d-2*t31*t32*t60*t67-1.030176d-2*t1*t37*t38*
     1           t60-1.030176d-2*gammabb*t33*t35*t36*t60-5.15088d-3*t1*t
     2           34*t36*t40-5.15088d-3*gammabb*t33*t34*t39+t1*t30*t39+t1
     3           *t34*t35*t36+2*gammabb*t31*t33*t34
              t69 = taub**2
              t70 = 1/t69
              t71 = 1/rhob**7
              t72 = 1/rhob**4.333333333333333d+0
              t73 = -2.060352d-2*gammabb*t35*t36*t60*t72-1.030176d-2*gam
     1           mabb*t34*t39*t72+2.0d+0*gammabb*t34*t35*t72-2.060352d-2
     2           *t31*t32*t60*t71-2.060352d-2*t27*t37*t38*t60-1.030176d-
     3           2*t27*t34*t36*t40+2.0d+0*t27*t30*t40+4.0d+0*t27*t34*t36
     4           *t37
              t74 = 1/rhob**2
              t75 = t46**2
              t76 = 1/t10**5
              t77 = 1/rhob**2.3333333333333334d+0
              t78 = 1/rhob**2.1666666666666665d+0
              t79 = t49**2
              t80 = -2.0d+0*t17*t48*t79/t14**3+3.216395899738507d+1*t17*
     1           t79/(t14**4*t15**2)+1.0d+0*t17*t48*t50*(2.1622951122684
     2           114d+0*t78+1.7087761055320938d+0*t77+1.2335503316757068
     3           d+0*t76+2.673190323653546d-1*t1)+1.1102230246251565d-16
     4           *t21*t42*t47*(1.1632736958443765d+0*t78+9.8914196495586
     5           1d-1*t77+6.003214762495226d-1*t76+2.1077825841639536d-1
     6           *t1)-4.0675215258019015d-19*t20*t77-1.7613865241785684d
     7           -3*t16*t77-2.220446049250313d-16*t21*t42*t75/t18**3+1.7
     8           854583920998188d-15*t21*t75/(t18**4*t19**2)-8.497974591
     9           333913d-2*t44*t48*t49*t50-9.812069668265515d-18*t42*t44
     :           *t46*t47
              t81 = gammabb**3
              t82 = 1/t2**3
              t83 = 1/rhob**10
              t84 = 1/rhob**7.333333333333333d+0
              t85 = 1/rhob**4.666666666666667d+0
              t86 = t59**2
              t87 = 1/t29**4
              t88 = 8.88888888888889d+0*t54*taub+9.777777777777779d+0*ga
     1           mmabb*t85
              t89 = 1.25d-1*t22*t8
              t90 = 1/rhob**9
              t91 = 1.25d-1*gammabb*t22*t68+1.25d-1*t22*t41
              t92 = 1/rhob**3.3333333333333337d+0
              t93 = 1/taub**3
              t94 = 1/rhob**6
              fnc(iq) = (5.0d-1*rhob*t22*t23*t25*t8+1.0d+0*rhob*t22*t26*
     1           t30*t41)*wght+fnc(iq)
              Amat(iq,D1_RB) = (t23*(5.0d-1*rhob*t25*t51*t8+5.0d-1*t22*t
     1           25*t8+5.0d-1*rhob*t22*t25*t58)+1.25d-1*gammabb*t22*t23*
     2           t24*t8+t30*t62-5.15088d-3*rhob*t22*t26*t34*t41*t59+1.25
     3           d-1*gammabb*t22*t23*t24*t30*t41)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = (t23*(5.0d-1*rhob*t22*t25*t66-1.25d-1*t2
     1           2*t8)+1.0d+0*rhob*t22*t26*t30*t68-5.15088d-3*t22*t26*t2
     2           7*t34*t41-1.25d-1*t22*t23*t30*t41)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = (-1.030176d-2*t22*t26*t34*t41*t9-5.0d-1*r
     1           hob*t22*t25*t70*t8+1.0d+0*rhob*t22*t23*t8+1.0d+0*rhob*t
     2           22*t26*t30*t73+1.25d-1*gammabb*t22*t30*t41*t70)*wght+Mm
     3           at(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (t30*(1.0d+0*rhob*t22*t26*(1.373568d-
     1           1*t1*t36*t37*t59*t60*taub+6.867840000000001d-2*gammabb*
     2           t33*t35*t59*t60*taub+3.4339200000000003d-2*t1*t34*t40*t
     3           59*taub+8.88888888888889d+0*t30*t40*t54*taub+1.77777777
     4           77777778d+1*t34*t36*t37*t54*taub+2.6666666666666666d+1*
     5           gammabb*t34*t35*t53*taub-1.030176d-2*t37*t38*t60*t88-1.
     6           030176d-2*gammabb*t1*t35*t36*t60*t88-1.030176d-2*t31*t3
     7           2*t33*t60*t88-5.15088d-3*t34*t36*t40*t88-5.15088d-3*gam
     8           mabb*t1*t34*t39*t88+1.591893886464d-4*t37*t38*t86*t87+1
     9           .591893886464d-4*gammabb*t1*t35*t36*t86*t87+1.591893886
     :           464d-4*t31*t32*t33*t86*t87+5.30631295488d-5*t36*t40*t60
     ;           *t86+5.30631295488d-5*gammabb*t1*t39*t60*t86+9.77777777
     <           7777779d+0*gammabb*t30*t39*t85+9.777777777777779d+0*gam
     =           mabb*t34*t35*t36*t85+3.377777777777778d+1*t31*t32*t34*t
     >           84+2.2222222222222224d+1*t33*t34*t37*t69+5.494272d-2*ga
     ?           mmabb*t35*t36*t54*t59*t60+1.0988544d-1*t31*t32*t53*t59*
     @           t60+2.747136d-2*gammabb*t34*t39*t54*t59)+1.0d+0*rhob*t2
     1           6*t41*t80+1.25d-1*gammabb*t22*t23*t41*t74+2.0d+0*rhob*t
     2           26*t51*t61+2.0d+0*t22*t26*t61+1.25d-1*gammabb*t22*t23*t
     3           24*t61+2.0d+0*t26*t41*t51+1.25d-1*gammabb*t23*t24*t41*t
     4           51)+t34*(-5.15088d-3*rhob*t22*t26*t41*t88-5.15088d-3*t5
     5           9*t62-5.15088d-3*rhob*t22*t26*t59*t61-5.15088d-3*rhob*t
     6           26*t41*t51*t59-5.15088d-3*t22*t26*t41*t59)+5.3063129548
     7           8d-5*rhob*t22*t26*t41*t60*t86+t23*(5.0d-1*rhob*t22*t25*
     8           (6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gam
     9           mabb*t1*t3*(5.866666666666666d-1*gammabb*t3*t4*t85-8.63
     :           9999999999998d-2*t32*t4*t52*t84+3.0719999999999986d-3*t
     ;           4*t81*t82*t83)+5.866666666666666d-1*gammabb*t3*t5*t85-8
     <           .639999999999998d-2*t32*t5*t52*t84+3.0719999999999986d-
     =           3*t5*t81*t82*t83-3.1999999999999995d-1*gammabb*t3*t54*t
     >           55+1.9199999999999995d-2*t32*t52*t53*t55)+5.86666666666
     ?           6666d-1*gammabb*t3*t6*t85-8.639999999999998d-2*t32*t52*
     @           t6*t84+3.0719999999999986d-3*t6*t81*t82*t83-3.199999999
     1           9999995d-1*gammabb*t3*t54*t56+1.9199999999999995d-2*t32
     2           *t52*t53*t56)+5.866666666666666d-1*gammabb*t3*t7*t85-8.
     3           639999999999998d-2*t32*t52*t7*t84+3.0719999999999986d-3
     4           *t7*t81*t82*t83-3.1999999999999995d-1*gammabb*t3*t54*t5
     5           7+1.9199999999999995d-2*t32*t52*t53*t57)+5.0d-1*rhob*t2
     6           5*t8*t80+1.25d-1*gammabb*t22*t74*t8+1.0d+0*t25*t51*t8+1
     7           .25d-1*gammabb*t24*t51*t8+1.0d+0*rhob*t25*t51*t58+1.0d+
     8           0*t22*t25*t58+1.25d-1*gammabb*t22*t24*t58)+t23*t24*(1.2
     9           5d-1*gammabb*t51*t8+1.25d-1*gammabb*t22*t58)-1.25d-1*ga
     :           mmabb*t22*t23*t74*t8-1.25d-1*gammabb*t22*t23*t30*t41*t7
     ;           4+t23*t24*t30*(1.25d-1*gammabb*t22*t61+1.25d-1*gammabb*
     <           t41*t51)-1.28772d-3*gammabb*t22*t23*t24*t34*t41*t59)*wg
     =           ht+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = (t30*(1.0d+0*rhob*t22*t26*(3.4339200
     1           000000003d-2*gammabb*t35*t60*t67*taub+6.867840000000001
     2           d-2*t33*t36*t37*t60*taub+1.7169600000000002d-2*t33*t34*
     3           t40*taub-3.3333333333333337d+0*t33*t34*t35*taub+8.24140
     4           8d-2*t31*t32*t60*t90+1.591893886464d-4*t31*t32*t59*t67*
     5           t87+1.591893886464d-4*t1*t37*t38*t59*t87+1.591893886464
     6           d-4*gammabb*t33*t35*t36*t59*t87+5.30631295488d-5*t1*t36
     7           *t40*t59*t60+5.30631295488d-5*gammabb*t33*t39*t59*t60-1
     8           .030176d-2*t1*t35*t36*t59*t60-2.060352d-2*gammabb*t31*t
     9           33*t59*t60+2.747136d-2*t37*t38*t54*t60+5.494272d-2*gamm
     :           abb*t35*t36*t53*t60-5.15088d-3*t1*t34*t39*t59+1.373568d
     ;           -2*t34*t36*t40*t54-2.6666666666666666d+0*t30*t39*t54-2.
     <           6666666666666666d+0*t34*t35*t36*t54+2.747136d-2*gammabb
     =           *t34*t39*t53-1.0666666666666666d+1*gammabb*t31*t34*t53)
     >           +1.0d+0*rhob*t26*t51*t68+1.0d+0*t22*t26*t68-1.25d-1*t22
     ?           *t23*t61-1.25d-1*t23*t41*t51-1.25d-1*t22*t23*t24*t41)+t
     @           23*t24*t30*t91+t23*(5.0d-1*rhob*t22*t25*(6.0d-2*gammabb
     1           *t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(-1.
     2           1519999999999996d-3*t32*t4*t82*t90-1.5999999999999998d-
     3           1*t3*t4*t54+2.879999999999999d-2*gammabb*t4*t52*t53)-1.
     4           1519999999999996d-3*t32*t5*t82*t90-1.5999999999999998d-
     5           1*gammabb*t3*t54*t63+9.599999999999997d-3*t32*t52*t53*t
     6           63-3.6d-3*gammabb*t33*t52*t55+6.0d-2*t1*t3*t55-1.599999
     7           9999999998d-1*t3*t5*t54+2.879999999999999d-2*gammabb*t5
     8           *t52*t53)-1.1519999999999996d-3*t32*t6*t82*t90-1.599999
     9           9999999998d-1*gammabb*t3*t54*t64+9.599999999999997d-3*t
     :           32*t52*t53*t64-1.5999999999999998d-1*t3*t54*t6+2.879999
     ;           999999999d-2*gammabb*t52*t53*t6-3.6d-3*gammabb*t33*t52*
     <           t56+6.0d-2*t1*t3*t56)-1.1519999999999996d-3*t32*t7*t82*
     =           t90-1.5999999999999998d-1*t3*t54*t7+2.879999999999999d-
     >           2*gammabb*t52*t53*t7-1.5999999999999998d-1*gammabb*t3*t
     ?           54*t65+9.599999999999997d-3*t32*t52*t53*t65-3.6d-3*gamm
     @           abb*t33*t52*t57+6.0d-2*t1*t3*t57)-1.25d-1*t51*t8-1.25d-
     1           1*t22*t24*t8+5.0d-1*rhob*t25*t51*t66+5.0d-1*t22*t25*t66
     2           -1.25d-1*t22*t58)+t23*t24*(t89+1.25d-1*gammabb*t22*t66)
     3           -5.15088d-3*rhob*t22*t26*t34*t59*t68+t1*t34*(1.373568d-
     4           2*t22*t26*t41-5.15088d-3*t62)+5.30631295488d-5*t22*t26*
     5           t27*t41*t59*t60+6.4386d-4*t22*t23*t34*t41*t59-6.4386d-4
     6           *gammabb*t22*t23*t34*t41*t54)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (1.0d+0*rhob*t22*t26*t30*(1.5918938
     1           86464d-4*gammabb*t35*t36*t67*t87+1.591893886464d-4*t33*
     2           t37*t38*t87+1.591893886464d-4*t31*t32*t87/rhob**1.06666
     3           66666666666d+1+5.30631295488d-5*gammabb*t39*t60*t67-4.1
     4           20704d-2*gammabb*t31*t60*t67+5.30631295488d-5*t33*t36*t
     5           40*t60-2.060352d-2*t33*t35*t36*t60-1.030176d-2*t33*t34*
     6           t39+2*t31*t33*t34)+t23*(5.0d-1*rhob*t22*t25*(6.0d-2*gam
     7           mabb*t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*
     8           (4.32d-4*gammabb*t4*t67*t82-7.2d-3*t33*t4*t52)+4.32d-4*
     9           gammabb*t5*t67*t82-7.2d-3*gammabb*t33*t52*t63+1.2d-1*t1
     :           *t3*t63-7.2d-3*t33*t5*t52)+4.32d-4*gammabb*t6*t67*t82-7
     ;           .2d-3*gammabb*t33*t52*t64+1.2d-1*t1*t3*t64-7.2d-3*t33*t
     <           52*t6)+4.32d-4*gammabb*t67*t7*t82-7.2d-3*t33*t52*t7-7.2
     =           d-3*gammabb*t33*t52*t65+1.2d-1*t1*t3*t65)-2.5d-1*t22*t6
     >           6)+5.30631295488d-5*t22*t26*t41*t60*t72-1.030176d-2*t22
     ?           *t26*t27*t34*t68-2.5d-1*t22*t23*t30*t68+1.28772d-3*t1*t
     @           22*t23*t34*t41)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t30*(1.0d+0*rhob*t22*t26*(1.373568d-
     1           1*t36*t37*t60*t72*taub+3.4339200000000003d-2*t34*t40*t7
     2           2*taub-1.3333333333333333d+1*t34*t37*t72*taub+6.8678400
     3           00000001d-2*gammabb*t35*t60*t71*taub+3.183787772928d-4*
     4           gammabb*t35*t36*t59*t72*t87+3.183787772928d-4*t31*t32*t
     5           59*t71*t87+3.183787772928d-4*t27*t37*t38*t59*t87+1.0612
     6           62590976d-4*gammabb*t39*t59*t60*t72-2.060352d-2*gammabb
     7           *t35*t59*t60*t72+1.4422464000000002d-1*t31*t32*t60*t67+
     8           1.061262590976d-4*t27*t36*t40*t59*t60-4.120704d-2*t27*t
     9           36*t37*t59*t60+3.4339200000000003d-2*t1*t37*t38*t60+8.9
     :           28192d-2*gammabb*t33*t35*t36*t60-1.030176d-2*t27*t34*t4
     ;           0*t59+1.7169600000000002d-2*t1*t34*t36*t40-3.3333333333
     <           333337d+0*t1*t30*t40+4.464096d-2*gammabb*t33*t34*t39-6.
     =           666666666666667d+0*t1*t34*t36*t37-8.666666666666666d+0*
     >           gammabb*t33*t34*t35)+1.0d+0*rhob*t26*t51*t73+1.0d+0*t22
     ?           *t26*t73+1.25d-1*gammabb*t22*t61*t70+1.25d-1*gammabb*t4
     @           1*t51*t70+1.25d-1*gammabb*t22*t24*t41*t70)+1.0612625909
     1           76d-4*t22*t26*t41*t59*t60*t9+t70*(-5.0d-1*rhob*t25*t51*
     2           t8-5.0d-1*t22*t25*t8-5.0d-1*rhob*t22*t25*t58)+t23*(1.0d
     3           +0*rhob*t51*t8+1.0d+0*t22*t8+1.0d+0*rhob*t22*t58)-1.25d
     4           -1*gammabb*t22*t24*t70*t8-5.15088d-3*rhob*t22*t26*t34*t
     5           59*t73+1.25d-1*gammabb*t22*t23*t24*t30*t73-6.4386d-4*ga
     6           mmabb*t22*t34*t41*t59*t70-1.25d-1*gammabb*t22*t24*t30*t
     7           41*t70+t27*t34*(1.7169600000000002d-2*t22*t26*t41-1.030
     8           176d-2*t62)-1.28772d-3*gammabb*t1*t22*t23*t34*t41)*wght
     9           +Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.061262590976d-4*t22*t26*t41*t60*t
     1           92+t30*t70*t91-1.030176d-2*t22*t26*t34*t68*t9+t70*(t89-
     2           5.0d-1*rhob*t22*t25*t66)+1.0d+0*rhob*t22*t26*t30*(3.183
     3           787772928d-4*t37*t38*t72*t87+3.183787772928d-4*gammabb*
     4           t35*t36*t71*t87+3.183787772928d-4*t31*t32*t87/rhob**9.6
     5           66666666666666d+0+1.061262590976d-4*t36*t40*t60*t72-4.1
     6           20704d-2*t36*t37*t60*t72-2.060352d-2*t35*t36*t60*t72-1.
     7           030176d-2*t34*t40*t72-1.030176d-2*t34*t39*t72+2.0d+0*t3
     8           4*t35*t72+1.061262590976d-4*gammabb*t39*t60*t71-2.06035
     9           2d-2*gammabb*t35*t60*t71-4.120704d-2*gammabb*t31*t60*t7
     :           1)-5.15088d-3*t22*t26*t27*t34*t73-1.25d-1*t22*t23*t30*t
     ;           73-6.4386d-4*gammabb*t1*t22*t34*t41*t70+1.0d+0*rhob*t22
     <           *t23*t66+1.28772d-3*t22*t23*t27*t34*t41)*wght+Mmat2(iq,
     =           D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t22*t26*t30*(6.367575545
     1           856d-4*gammabb*t35*t36*t87*t94+2.122525181952d-4*gammab
     2           b*t39*t60*t94-8.241408d-2*gammabb*t35*t60*t94+6.3675755
     3           45856d-4*t37*t38*t87*t92+2.122525181952d-4*t36*t40*t60*
     4           t92-1.6482816d-1*t36*t37*t60*t92-4.120704d-2*t34*t40*t9
     5           2+8.0d+0*t34*t37*t92+6.367575545856d-4*t31*t32*t87/rhob
     6           **8.666666666666666d+0)+1.0d+0*rhob*t22*t25*t8*t93-2.5d
     7           -1*gammabb*t22*t30*t41*t93-2.060352d-2*t22*t26*t34*t73*
     8           t9-2.0d+0*rhob*t22*t70*t8+2.122525181952d-4*t22*t26*t41
     9           *t60*t77+2.5d-1*gammabb*t22*t30*t70*t73-2.57544d-3*gamm
     :           abb*t22*t27*t34*t41*t70)*wght+Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhob**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 2.4d-51*t1+1.0d+0
              t28 = 1/t27
              t29 = param(22)
              t30 = 2.4d-51*t1*t28*t29+param(21)
              t31 = 2.4d-51*t1*t28*t30+param(20)
              t32 = 2.4d-51*t1*t28*t31+param(19)
              t33 = 2.4d-51*t1*t28*t32+param(18)
              t34 = 1/t23
              t35 = 1/t14**3
              t36 = 1/rhob**1.3333333333333333d+0
              t37 = 1/rhob**1.1666666666666667d+0
              t38 = -9.970917392951799d-1*t37-7.418564737168958d-1*t36-4
     1           .002143174996817d-1*t35-1.264669550498372d-1*t1
              t39 = 1/t22**2
              t40 = 1/t19
              t41 = -1.8533958105157808d+0*t37-1.2815820791490704d+0*t36
     1           -8.223668877838045d-1*t35-1.6039141941921276d-1*t1
              t42 = 1/t18**2
              t43 = 1.0d+0*t21*t40*t41*t42+1.1102230246251565d-16*t25*t3
     1           4*t38*t39+3.0506411443514264d-19*t24*t36+1.321039893133
     2           9265d-3*t20*t36
              t44 = 1/t27**2
              t45 = 1/rhob**4.333333333333333d+0
              t46 = 1/rhob**2.6666666666666666d+0
              t47 = 9.6d-102*t29*t44*t45-4.0d-51*t28*t29*t46
              t48 = 2.4d-51*t1*t28*t47-4.0d-51*t28*t30*t46+9.6d-102*t30*
     1           t44*t45
              t49 = 2.4d-51*t1*t28*t48-4.0d-51*t28*t31*t46+9.6d-102*t31*
     1           t44*t45
              t50 = 2.4d-51*t1*t28*t49-4.0d-51*t28*t32*t46+9.6d-102*t32*
     1           t44*t45
              t51 = 1/t2**3
              t52 = 5.15088d-52*t46*t5*t6*t9-3.333333333333333d-50*t3*t4
     1           6*t9+1.6482816d-150*t51*t8/rhob**6-5.333333333333334d-9
     2           9*t45*t5*t8+1.030176d-51*t4*t46*t51*t7+4.12070399999999
     3           95d-101*t11*t45*t51*t6-6.666666666666666d-50*t4*t46*t5*
     4           t6-6.666666666666666d-50*t11*t46*t5*t6-1.33333333333333
     5           33d-99*t11*t45*t5+2.0603519999999997d-101*t10*t45*t5-6.
     6           666666666666666d-50*t10*t3*t46
              t53 = 5.0d-1*rhob*t26*t52+5.0d-1*rhob*t12*t43+5.0d-1*t12*t
     1           26
              t54 = t38**2
              t55 = 1/t14**5
              t56 = 1/rhob**2.3333333333333334d+0
              t57 = 1/rhob**2.1666666666666665d+0
              t58 = t41**2
              t59 = -2.0d+0*t21*t40*t58/t18**3+3.216395899738507d+1*t21*
     1           t58/(t18**4*t19**2)+1.0d+0*t21*t40*t42*(2.1622951122684
     2           114d+0*t57+1.7087761055320938d+0*t56+1.2335503316757068
     3           d+0*t55+2.673190323653546d-1*t46)+1.1102230246251565d-1
     4           6*t25*t34*t39*(1.1632736958443765d+0*t57+9.891419649558
     5           61d-1*t56+6.003214762495226d-1*t55+2.1077825841639536d-
     6           1*t46)-4.0675215258019015d-19*t24*t56-1.761386524178568
     7           4d-3*t20*t56-2.220446049250313d-16*t25*t34*t54/t22**3+1
     8           .7854583920998188d-15*t25*t54/(t22**4*t23**2)-8.4979745
     9           91333913d-2*t36*t40*t41*t42-9.812069668265515d-18*t34*t
     :           36*t38*t39
              t60 = 1/t27**3
              t61 = 1/rhob**7
              t62 = 1/rhob**5.333333333333333d+0
              t63 = 1/rhob**3.6666666666666664d+0
              t64 = 1/t2**4
              fnc(iq) = (5.0d-1*rhob*t26*t33+5.0d-1*rhob*t12*t26*t3)*wgh
     1           t+fnc(iq)
              Amat(iq,D1_RB) = (t3*t53+5.0d-1*rhob*t26*t50+2.57544d-52*t
     1           1*t12*t26*t5+5.0d-1*rhob*t33*t43+5.0d-1*t26*t33)*wght+A
     2           mat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (t3*(5.0d-1*rhob*t26*(-1.373568d-51*t
     1           5*t6*t63*t9+8.888888888888888d-50*t3*t63*t9+5.306312954
     2           879999d-103*t51*t6*t62*t9-3.43392d-101*t5*t62*t9+2.5470
     3           302183424d-201*t64*t8/rhob**8.666666666666666d+0+2.3111
     4           111111111113d-98*t5*t62*t8-1.53839616d-149*t51*t61*t8+1
     5           .5918938864639998d-102*t4*t62*t64*t7-2.747136d-51*t4*t5
     6           1*t63*t7+6.367575545855999d-152*t11*t6*t61*t64+1.777777
     7           7777777776d-49*t4*t5*t6*t63+1.7777777777777776d-49*t11*
     8           t5*t6*t63+1.7777777777777776d-49*t10*t3*t63-1.373568d-1
     9           00*t4*t51*t6*t62-2.4724223999999997d-100*t11*t51*t6*t62
     :           +2.222222222222222d-99*t4*t5*t62+8.0d-99*t11*t5*t62-1.2
     ;           362111999999999d-100*t10*t5*t62-2.7471359999999995d-150
     <           *t11*t51*t61+2.1225251819519997d-152*t10*t51*t61)+5.0d-
     =           1*rhob*t12*t59+1.0d+0*rhob*t43*t52+1.0d+0*t26*t52+1.0d+
     >           0*t12*t43)+5.0d-1*rhob*t26*(2.4d-51*t1*t28*(2.4d-51*t1*
     ?           t28*(2.4d-51*t1*t28*(1.0666666666666666d-50*t28*t29*t63
     @           -5.76d-101*t29*t44*t62+7.68d-152*t29*t60*t61)+1.0666666
     1           666666666d-50*t28*t30*t63-5.76d-101*t30*t44*t62+7.68d-1
     2           52*t30*t60*t61-8.0d-51*t28*t46*t47+1.92d-101*t44*t45*t4
     3           7)+1.0666666666666666d-50*t28*t31*t63-5.76d-101*t31*t44
     4           *t62+7.68d-152*t31*t60*t61-8.0d-51*t28*t46*t48+1.92d-10
     5           1*t44*t45*t48)+1.0666666666666666d-50*t28*t32*t63-5.76d
     6           -101*t32*t44*t62+7.68d-152*t32*t60*t61-8.0d-51*t28*t46*
     7           t49+1.92d-101*t44*t45*t49)+5.0d-1*rhob*t33*t59+t46*t5*(
     8           5.15088d-52*t53-4.2923999999999995d-52*t12*t26)+t1*t5*(
     9           2.57544d-52*t26*t52+2.57544d-52*t12*t43)+2.653156477439
     :           9996d-103*t12*t26*t45*t51+1.0d+0*rhob*t43*t50+1.0d+0*t2
     ;           6*t50+1.0d+0*t33*t43)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = param(22)
              t5 = 6.0d-2*gammabb*t1*t3*t4+param(21)
              t6 = 6.0d-2*gammabb*t1*t3*t5+param(20)
              t7 = 6.0d-2*gammabb*t1*t3*t6+param(19)
              t8 = 6.0d-2*gammabb*t1*t3*t7+param(18)
              t9 = 1/rhob**6.666666666666666d-1
              t10 = rhob**5.0d-1
              t11 = 1/t10
              t12 = 1/rhob**3.333333333333333d-1
              t13 = 1/rhob**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = 1/taub
              t24 = 1/rhob
              t25 = 2.0d+0*taub-2.5d-1*gammabb*t24
              t26 = 1.0d+0-1.25d-1*gammabb*t23*t24
              t27 = 1/rhob**1.6666666666666669d+0
              t28 = 2.0d+0*t27*taub
              t29 = 5.15088d-3*(t28+gammabb*t1-9.11559972d+0)+1.0d+0
              t30 = 1/t29
              t31 = param(10)
              t32 = gammabb**2
              t33 = 1/rhob**5.333333333333333d+0
              t34 = 1/t29**2
              t35 = param(11)
              t36 = t28-9.11559972d+0
              t37 = param(12)
              t38 = t36**2
              t39 = param(8)
              t40 = param(9)
              t41 = t30*t36*t40+gammabb*t1*t30*t39+t34*t37*t38+gammabb*t
     1           1*t34*t35*t36+t31*t32*t33*t34+param(7)
              t42 = 1/t19
              t43 = 1/t10**3
              t44 = 1/rhob**1.3333333333333333d+0
              t45 = 1/rhob**1.1666666666666667d+0
              t46 = -9.970917392951799d-1*t45-7.418564737168958d-1*t44-4
     1           .002143174996817d-1*t43-1.264669550498372d-1*t27
              t47 = 1/t18**2
              t48 = 1/t15
              t49 = -1.8533958105157808d+0*t45-1.2815820791490704d+0*t44
     1           -8.223668877838045d-1*t43-1.6039141941921276d-1*t27
              t50 = 1/t14**2
              t51 = 1.0d+0*t17*t48*t49*t50+1.1102230246251565d-16*t21*t4
     1           2*t46*t47+3.0506411443514264d-19*t20*t44+1.321039893133
     2           9265d-3*t16*t44
              t52 = 1/t2**2
              t53 = 1/rhob**6.333333333333333d+0
              t54 = 1/rhob**3.6666666666666664d+0
              t55 = 9.599999999999997d-3*t32*t4*t52*t53-1.59999999999999
     1           98d-1*gammabb*t3*t4*t54
              t56 = 6.0d-2*gammabb*t1*t3*t55-1.5999999999999998d-1*gamma
     1           bb*t3*t5*t54+9.599999999999997d-3*t32*t5*t52*t53
              t57 = -1.5999999999999998d-1*gammabb*t3*t54*t6+9.599999999
     1           999997d-3*t32*t52*t53*t6+6.0d-2*gammabb*t1*t3*t56
              t58 = -1.5999999999999998d-1*gammabb*t3*t54*t7+9.599999999
     1           999997d-3*t32*t52*t53*t7+6.0d-2*gammabb*t1*t3*t57
              t59 = -3.3333333333333337d+0*t1*taub-2.6666666666666666d+0
     1           *gammabb*t54
              t60 = 1/t29**3
              t61 = -3.3333333333333337d+0*t1*t30*t40*taub-6.66666666666
     1           6667d+0*t1*t34*t36*t37*taub-3.3333333333333337d+0*gamma
     2           bb*t33*t34*t35*taub-1.030176d-2*t37*t38*t59*t60-1.03017
     3           6d-2*gammabb*t1*t35*t36*t59*t60-1.030176d-2*t31*t32*t33
     4           *t59*t60-5.15088d-3*t34*t36*t40*t59-5.15088d-3*gammabb*
     5           t1*t34*t39*t59-2.6666666666666666d+0*gammabb*t30*t39*t5
     6           4-2.6666666666666666d+0*gammabb*t34*t35*t36*t54-5.33333
     7           3333333333d+0*t31*t32*t34*t53
              t62 = 1.0d+0*rhob*t22*t26*t61+1.0d+0*rhob*t26*t41*t51+1.0d
     1           +0*t22*t26*t41
              t63 = 6.0d-2*t1*t3*t4-3.6d-3*gammabb*t33*t4*t52
              t64 = 6.0d-2*gammabb*t1*t3*t63-3.6d-3*gammabb*t33*t5*t52+6
     1           .0d-2*t1*t3*t5
              t65 = 6.0d-2*gammabb*t1*t3*t64-3.6d-3*gammabb*t33*t52*t6+6
     1           .0d-2*t1*t3*t6
              t66 = -3.6d-3*gammabb*t33*t52*t7+6.0d-2*t1*t3*t7+6.0d-2*ga
     1           mmabb*t1*t3*t65
              t67 = 1/rhob**8
              t68 = -1.030176d-2*t31*t32*t60*t67-1.030176d-2*t1*t37*t38*
     1           t60-1.030176d-2*gammabb*t33*t35*t36*t60-5.15088d-3*t1*t
     2           34*t36*t40-5.15088d-3*gammabb*t33*t34*t39+t1*t30*t39+t1
     3           *t34*t35*t36+2*gammabb*t31*t33*t34
              t69 = taub**2
              t70 = 1/t69
              t71 = 1/rhob**7
              t72 = 1/rhob**4.333333333333333d+0
              t73 = -2.060352d-2*gammabb*t35*t36*t60*t72-1.030176d-2*gam
     1           mabb*t34*t39*t72+2.0d+0*gammabb*t34*t35*t72-2.060352d-2
     2           *t31*t32*t60*t71-2.060352d-2*t27*t37*t38*t60-1.030176d-
     3           2*t27*t34*t36*t40+2.0d+0*t27*t30*t40+4.0d+0*t27*t34*t36
     4           *t37
              t74 = 1/rhob**2
              t75 = t46**2
              t76 = 1/t10**5
              t77 = 1/rhob**2.3333333333333334d+0
              t78 = 1/rhob**2.1666666666666665d+0
              t79 = t49**2
              t80 = -2.0d+0*t17*t48*t79/t14**3+3.216395899738507d+1*t17*
     1           t79/(t14**4*t15**2)+1.0d+0*t17*t48*t50*(2.1622951122684
     2           114d+0*t78+1.7087761055320938d+0*t77+1.2335503316757068
     3           d+0*t76+2.673190323653546d-1*t1)+1.1102230246251565d-16
     4           *t21*t42*t47*(1.1632736958443765d+0*t78+9.8914196495586
     5           1d-1*t77+6.003214762495226d-1*t76+2.1077825841639536d-1
     6           *t1)-4.0675215258019015d-19*t20*t77-1.7613865241785684d
     7           -3*t16*t77-2.220446049250313d-16*t21*t42*t75/t18**3+1.7
     8           854583920998188d-15*t21*t75/(t18**4*t19**2)-8.497974591
     9           333913d-2*t44*t48*t49*t50-9.812069668265515d-18*t42*t44
     :           *t46*t47
              t81 = gammabb**3
              t82 = 1/t2**3
              t83 = 1/rhob**10
              t84 = 1/rhob**7.333333333333333d+0
              t85 = 1/rhob**4.666666666666667d+0
              t86 = t59**2
              t87 = 1/t29**4
              t88 = 8.88888888888889d+0*t54*taub+9.777777777777779d+0*ga
     1           mmabb*t85
              t89 = 1.25d-1*t22*t8
              t90 = 1/rhob**9
              t91 = 1.25d-1*gammabb*t22*t68+1.25d-1*t22*t41
              t92 = 1/rhob**3.3333333333333337d+0
              t93 = 1/taub**3
              t94 = 1/rhob**6
              fnc(iq) = (5.0d-1*rhob*t22*t23*t25*t8+1.0d+0*rhob*t22*t26*
     1           t30*t41)*wght+fnc(iq)
              Amat(iq,D1_RB) = (t23*(5.0d-1*rhob*t25*t51*t8+5.0d-1*t22*t
     1           25*t8+5.0d-1*rhob*t22*t25*t58)+1.25d-1*gammabb*t22*t23*
     2           t24*t8+t30*t62-5.15088d-3*rhob*t22*t26*t34*t41*t59+1.25
     3           d-1*gammabb*t22*t23*t24*t30*t41)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = (t23*(5.0d-1*rhob*t22*t25*t66-1.25d-1*t2
     1           2*t8)+1.0d+0*rhob*t22*t26*t30*t68-5.15088d-3*t22*t26*t2
     2           7*t34*t41-1.25d-1*t22*t23*t30*t41)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = (-1.030176d-2*t22*t26*t34*t41*t9-5.0d-1*r
     1           hob*t22*t25*t70*t8+1.0d+0*rhob*t22*t23*t8+1.0d+0*rhob*t
     2           22*t26*t30*t73+1.25d-1*gammabb*t22*t30*t41*t70)*wght+Mm
     3           at(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (t30*(1.0d+0*rhob*t22*t26*(1.373568d-
     1           1*t1*t36*t37*t59*t60*taub+6.867840000000001d-2*gammabb*
     2           t33*t35*t59*t60*taub+3.4339200000000003d-2*t1*t34*t40*t
     3           59*taub+8.88888888888889d+0*t30*t40*t54*taub+1.77777777
     4           77777778d+1*t34*t36*t37*t54*taub+2.6666666666666666d+1*
     5           gammabb*t34*t35*t53*taub-1.030176d-2*t37*t38*t60*t88-1.
     6           030176d-2*gammabb*t1*t35*t36*t60*t88-1.030176d-2*t31*t3
     7           2*t33*t60*t88-5.15088d-3*t34*t36*t40*t88-5.15088d-3*gam
     8           mabb*t1*t34*t39*t88+1.591893886464d-4*t37*t38*t86*t87+1
     9           .591893886464d-4*gammabb*t1*t35*t36*t86*t87+1.591893886
     :           464d-4*t31*t32*t33*t86*t87+5.30631295488d-5*t36*t40*t60
     ;           *t86+5.30631295488d-5*gammabb*t1*t39*t60*t86+9.77777777
     <           7777779d+0*gammabb*t30*t39*t85+9.777777777777779d+0*gam
     =           mabb*t34*t35*t36*t85+3.377777777777778d+1*t31*t32*t34*t
     >           84+2.2222222222222224d+1*t33*t34*t37*t69+5.494272d-2*ga
     ?           mmabb*t35*t36*t54*t59*t60+1.0988544d-1*t31*t32*t53*t59*
     @           t60+2.747136d-2*gammabb*t34*t39*t54*t59)+1.0d+0*rhob*t2
     1           6*t41*t80+1.25d-1*gammabb*t22*t23*t41*t74+2.0d+0*rhob*t
     2           26*t51*t61+2.0d+0*t22*t26*t61+1.25d-1*gammabb*t22*t23*t
     3           24*t61+2.0d+0*t26*t41*t51+1.25d-1*gammabb*t23*t24*t41*t
     4           51)+t34*(-5.15088d-3*rhob*t22*t26*t41*t88-5.15088d-3*t5
     5           9*t62-5.15088d-3*rhob*t22*t26*t59*t61-5.15088d-3*rhob*t
     6           26*t41*t51*t59-5.15088d-3*t22*t26*t41*t59)+5.3063129548
     7           8d-5*rhob*t22*t26*t41*t60*t86+t23*(5.0d-1*rhob*t22*t25*
     8           (6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gam
     9           mabb*t1*t3*(5.866666666666666d-1*gammabb*t3*t4*t85-8.63
     :           9999999999998d-2*t32*t4*t52*t84+3.0719999999999986d-3*t
     ;           4*t81*t82*t83)+5.866666666666666d-1*gammabb*t3*t5*t85-8
     <           .639999999999998d-2*t32*t5*t52*t84+3.0719999999999986d-
     =           3*t5*t81*t82*t83-3.1999999999999995d-1*gammabb*t3*t54*t
     >           55+1.9199999999999995d-2*t32*t52*t53*t55)+5.86666666666
     ?           6666d-1*gammabb*t3*t6*t85-8.639999999999998d-2*t32*t52*
     @           t6*t84+3.0719999999999986d-3*t6*t81*t82*t83-3.199999999
     1           9999995d-1*gammabb*t3*t54*t56+1.9199999999999995d-2*t32
     2           *t52*t53*t56)+5.866666666666666d-1*gammabb*t3*t7*t85-8.
     3           639999999999998d-2*t32*t52*t7*t84+3.0719999999999986d-3
     4           *t7*t81*t82*t83-3.1999999999999995d-1*gammabb*t3*t54*t5
     5           7+1.9199999999999995d-2*t32*t52*t53*t57)+5.0d-1*rhob*t2
     6           5*t8*t80+1.25d-1*gammabb*t22*t74*t8+1.0d+0*t25*t51*t8+1
     7           .25d-1*gammabb*t24*t51*t8+1.0d+0*rhob*t25*t51*t58+1.0d+
     8           0*t22*t25*t58+1.25d-1*gammabb*t22*t24*t58)+t23*t24*(1.2
     9           5d-1*gammabb*t51*t8+1.25d-1*gammabb*t22*t58)-1.25d-1*ga
     :           mmabb*t22*t23*t74*t8-1.25d-1*gammabb*t22*t23*t30*t41*t7
     ;           4+t23*t24*t30*(1.25d-1*gammabb*t22*t61+1.25d-1*gammabb*
     <           t41*t51)-1.28772d-3*gammabb*t22*t23*t24*t34*t41*t59)*wg
     =           ht+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = (t30*(1.0d+0*rhob*t22*t26*(3.4339200
     1           000000003d-2*gammabb*t35*t60*t67*taub+6.867840000000001
     2           d-2*t33*t36*t37*t60*taub+1.7169600000000002d-2*t33*t34*
     3           t40*taub-3.3333333333333337d+0*t33*t34*t35*taub+8.24140
     4           8d-2*t31*t32*t60*t90+1.591893886464d-4*t31*t32*t59*t67*
     5           t87+1.591893886464d-4*t1*t37*t38*t59*t87+1.591893886464
     6           d-4*gammabb*t33*t35*t36*t59*t87+5.30631295488d-5*t1*t36
     7           *t40*t59*t60+5.30631295488d-5*gammabb*t33*t39*t59*t60-1
     8           .030176d-2*t1*t35*t36*t59*t60-2.060352d-2*gammabb*t31*t
     9           33*t59*t60+2.747136d-2*t37*t38*t54*t60+5.494272d-2*gamm
     :           abb*t35*t36*t53*t60-5.15088d-3*t1*t34*t39*t59+1.373568d
     ;           -2*t34*t36*t40*t54-2.6666666666666666d+0*t30*t39*t54-2.
     <           6666666666666666d+0*t34*t35*t36*t54+2.747136d-2*gammabb
     =           *t34*t39*t53-1.0666666666666666d+1*gammabb*t31*t34*t53)
     >           +1.0d+0*rhob*t26*t51*t68+1.0d+0*t22*t26*t68-1.25d-1*t22
     ?           *t23*t61-1.25d-1*t23*t41*t51-1.25d-1*t22*t23*t24*t41)+t
     @           23*t24*t30*t91+t23*(5.0d-1*rhob*t22*t25*(6.0d-2*gammabb
     1           *t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*(-1.
     2           1519999999999996d-3*t32*t4*t82*t90-1.5999999999999998d-
     3           1*t3*t4*t54+2.879999999999999d-2*gammabb*t4*t52*t53)-1.
     4           1519999999999996d-3*t32*t5*t82*t90-1.5999999999999998d-
     5           1*gammabb*t3*t54*t63+9.599999999999997d-3*t32*t52*t53*t
     6           63-3.6d-3*gammabb*t33*t52*t55+6.0d-2*t1*t3*t55-1.599999
     7           9999999998d-1*t3*t5*t54+2.879999999999999d-2*gammabb*t5
     8           *t52*t53)-1.1519999999999996d-3*t32*t6*t82*t90-1.599999
     9           9999999998d-1*gammabb*t3*t54*t64+9.599999999999997d-3*t
     :           32*t52*t53*t64-1.5999999999999998d-1*t3*t54*t6+2.879999
     ;           999999999d-2*gammabb*t52*t53*t6-3.6d-3*gammabb*t33*t52*
     <           t56+6.0d-2*t1*t3*t56)-1.1519999999999996d-3*t32*t7*t82*
     =           t90-1.5999999999999998d-1*t3*t54*t7+2.879999999999999d-
     >           2*gammabb*t52*t53*t7-1.5999999999999998d-1*gammabb*t3*t
     ?           54*t65+9.599999999999997d-3*t32*t52*t53*t65-3.6d-3*gamm
     @           abb*t33*t52*t57+6.0d-2*t1*t3*t57)-1.25d-1*t51*t8-1.25d-
     1           1*t22*t24*t8+5.0d-1*rhob*t25*t51*t66+5.0d-1*t22*t25*t66
     2           -1.25d-1*t22*t58)+t23*t24*(t89+1.25d-1*gammabb*t22*t66)
     3           -5.15088d-3*rhob*t22*t26*t34*t59*t68+t1*t34*(1.373568d-
     4           2*t22*t26*t41-5.15088d-3*t62)+5.30631295488d-5*t22*t26*
     5           t27*t41*t59*t60+6.4386d-4*t22*t23*t34*t41*t59-6.4386d-4
     6           *gammabb*t22*t23*t34*t41*t54)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (1.0d+0*rhob*t22*t26*t30*(1.5918938
     1           86464d-4*gammabb*t35*t36*t67*t87+1.591893886464d-4*t33*
     2           t37*t38*t87+1.591893886464d-4*t31*t32*t87/rhob**1.06666
     3           66666666666d+1+5.30631295488d-5*gammabb*t39*t60*t67-4.1
     4           20704d-2*gammabb*t31*t60*t67+5.30631295488d-5*t33*t36*t
     5           40*t60-2.060352d-2*t33*t35*t36*t60-1.030176d-2*t33*t34*
     6           t39+2*t31*t33*t34)+t23*(5.0d-1*rhob*t22*t25*(6.0d-2*gam
     7           mabb*t1*t3*(6.0d-2*gammabb*t1*t3*(6.0d-2*gammabb*t1*t3*
     8           (4.32d-4*gammabb*t4*t67*t82-7.2d-3*t33*t4*t52)+4.32d-4*
     9           gammabb*t5*t67*t82-7.2d-3*gammabb*t33*t52*t63+1.2d-1*t1
     :           *t3*t63-7.2d-3*t33*t5*t52)+4.32d-4*gammabb*t6*t67*t82-7
     ;           .2d-3*gammabb*t33*t52*t64+1.2d-1*t1*t3*t64-7.2d-3*t33*t
     <           52*t6)+4.32d-4*gammabb*t67*t7*t82-7.2d-3*t33*t52*t7-7.2
     =           d-3*gammabb*t33*t52*t65+1.2d-1*t1*t3*t65)-2.5d-1*t22*t6
     >           6)+5.30631295488d-5*t22*t26*t41*t60*t72-1.030176d-2*t22
     ?           *t26*t27*t34*t68-2.5d-1*t22*t23*t30*t68+1.28772d-3*t1*t
     @           22*t23*t34*t41)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t30*(1.0d+0*rhob*t22*t26*(1.373568d-
     1           1*t36*t37*t60*t72*taub+3.4339200000000003d-2*t34*t40*t7
     2           2*taub-1.3333333333333333d+1*t34*t37*t72*taub+6.8678400
     3           00000001d-2*gammabb*t35*t60*t71*taub+3.183787772928d-4*
     4           gammabb*t35*t36*t59*t72*t87+3.183787772928d-4*t31*t32*t
     5           59*t71*t87+3.183787772928d-4*t27*t37*t38*t59*t87+1.0612
     6           62590976d-4*gammabb*t39*t59*t60*t72-2.060352d-2*gammabb
     7           *t35*t59*t60*t72+1.4422464000000002d-1*t31*t32*t60*t67+
     8           1.061262590976d-4*t27*t36*t40*t59*t60-4.120704d-2*t27*t
     9           36*t37*t59*t60+3.4339200000000003d-2*t1*t37*t38*t60+8.9
     :           28192d-2*gammabb*t33*t35*t36*t60-1.030176d-2*t27*t34*t4
     ;           0*t59+1.7169600000000002d-2*t1*t34*t36*t40-3.3333333333
     <           333337d+0*t1*t30*t40+4.464096d-2*gammabb*t33*t34*t39-6.
     =           666666666666667d+0*t1*t34*t36*t37-8.666666666666666d+0*
     >           gammabb*t33*t34*t35)+1.0d+0*rhob*t26*t51*t73+1.0d+0*t22
     ?           *t26*t73+1.25d-1*gammabb*t22*t61*t70+1.25d-1*gammabb*t4
     @           1*t51*t70+1.25d-1*gammabb*t22*t24*t41*t70)+1.0612625909
     1           76d-4*t22*t26*t41*t59*t60*t9+t70*(-5.0d-1*rhob*t25*t51*
     2           t8-5.0d-1*t22*t25*t8-5.0d-1*rhob*t22*t25*t58)+t23*(1.0d
     3           +0*rhob*t51*t8+1.0d+0*t22*t8+1.0d+0*rhob*t22*t58)-1.25d
     4           -1*gammabb*t22*t24*t70*t8-5.15088d-3*rhob*t22*t26*t34*t
     5           59*t73+1.25d-1*gammabb*t22*t23*t24*t30*t73-6.4386d-4*ga
     6           mmabb*t22*t34*t41*t59*t70-1.25d-1*gammabb*t22*t24*t30*t
     7           41*t70+t27*t34*(1.7169600000000002d-2*t22*t26*t41-1.030
     8           176d-2*t62)-1.28772d-3*gammabb*t1*t22*t23*t34*t41)*wght
     9           +Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.061262590976d-4*t22*t26*t41*t60*t
     1           92+t30*t70*t91-1.030176d-2*t22*t26*t34*t68*t9+t70*(t89-
     2           5.0d-1*rhob*t22*t25*t66)+1.0d+0*rhob*t22*t26*t30*(3.183
     3           787772928d-4*t37*t38*t72*t87+3.183787772928d-4*gammabb*
     4           t35*t36*t71*t87+3.183787772928d-4*t31*t32*t87/rhob**9.6
     5           66666666666666d+0+1.061262590976d-4*t36*t40*t60*t72-4.1
     6           20704d-2*t36*t37*t60*t72-2.060352d-2*t35*t36*t60*t72-1.
     7           030176d-2*t34*t40*t72-1.030176d-2*t34*t39*t72+2.0d+0*t3
     8           4*t35*t72+1.061262590976d-4*gammabb*t39*t60*t71-2.06035
     9           2d-2*gammabb*t35*t60*t71-4.120704d-2*gammabb*t31*t60*t7
     :           1)-5.15088d-3*t22*t26*t27*t34*t73-1.25d-1*t22*t23*t30*t
     ;           73-6.4386d-4*gammabb*t1*t22*t34*t41*t70+1.0d+0*rhob*t22
     <           *t23*t66+1.28772d-3*t22*t23*t27*t34*t41)*wght+Mmat2(iq,
     =           D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t22*t26*t30*(6.367575545
     1           856d-4*gammabb*t35*t36*t87*t94+2.122525181952d-4*gammab
     2           b*t39*t60*t94-8.241408d-2*gammabb*t35*t60*t94+6.3675755
     3           45856d-4*t37*t38*t87*t92+2.122525181952d-4*t36*t40*t60*
     4           t92-1.6482816d-1*t36*t37*t60*t92-4.120704d-2*t34*t40*t9
     5           2+8.0d+0*t34*t37*t92+6.367575545856d-4*t31*t32*t87/rhob
     6           **8.666666666666666d+0)+1.0d+0*rhob*t22*t25*t8*t93-2.5d
     7           -1*gammabb*t22*t30*t41*t93-2.060352d-2*t22*t26*t34*t73*
     8           t9-2.0d+0*rhob*t22*t70*t8+2.122525181952d-4*t22*t26*t41
     9           *t60*t77+2.5d-1*gammabb*t22*t30*t70*t73-2.57544d-3*gamm
     :           abb*t22*t27*t34*t41*t70)*wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhob**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 2.4d-51*t1+1.0d+0
              t28 = 1/t27
              t29 = param(22)
              t30 = 2.4d-51*t1*t28*t29+param(21)
              t31 = 2.4d-51*t1*t28*t30+param(20)
              t32 = 2.4d-51*t1*t28*t31+param(19)
              t33 = 2.4d-51*t1*t28*t32+param(18)
              t34 = 1/t23
              t35 = 1/t14**3
              t36 = 1/rhob**1.3333333333333333d+0
              t37 = 1/rhob**1.1666666666666667d+0
              t38 = -9.970917392951799d-1*t37-7.418564737168958d-1*t36-4
     1           .002143174996817d-1*t35-1.264669550498372d-1*t1
              t39 = 1/t22**2
              t40 = 1/t19
              t41 = -1.8533958105157808d+0*t37-1.2815820791490704d+0*t36
     1           -8.223668877838045d-1*t35-1.6039141941921276d-1*t1
              t42 = 1/t18**2
              t43 = 1.0d+0*t21*t40*t41*t42+1.1102230246251565d-16*t25*t3
     1           4*t38*t39+3.0506411443514264d-19*t24*t36+1.321039893133
     2           9265d-3*t20*t36
              t44 = 1/t27**2
              t45 = 1/rhob**4.333333333333333d+0
              t46 = 1/rhob**2.6666666666666666d+0
              t47 = 9.6d-102*t29*t44*t45-4.0d-51*t28*t29*t46
              t48 = 2.4d-51*t1*t28*t47-4.0d-51*t28*t30*t46+9.6d-102*t30*
     1           t44*t45
              t49 = 2.4d-51*t1*t28*t48-4.0d-51*t28*t31*t46+9.6d-102*t31*
     1           t44*t45
              t50 = 2.4d-51*t1*t28*t49-4.0d-51*t28*t32*t46+9.6d-102*t32*
     1           t44*t45
              t51 = 1/t2**3
              t52 = 5.15088d-52*t46*t5*t6*t9-3.333333333333333d-50*t3*t4
     1           6*t9+1.6482816d-150*t51*t8/rhob**6-5.333333333333334d-9
     2           9*t45*t5*t8+1.030176d-51*t4*t46*t51*t7+4.12070399999999
     3           95d-101*t11*t45*t51*t6-6.666666666666666d-50*t4*t46*t5*
     4           t6-6.666666666666666d-50*t11*t46*t5*t6-1.33333333333333
     5           33d-99*t11*t45*t5+2.0603519999999997d-101*t10*t45*t5-6.
     6           666666666666666d-50*t10*t3*t46
              t53 = 5.0d-1*rhob*t26*t52+5.0d-1*rhob*t12*t43+5.0d-1*t12*t
     1           26
              t54 = t38**2
              t55 = 1/t14**5
              t56 = 1/rhob**2.3333333333333334d+0
              t57 = 1/rhob**2.1666666666666665d+0
              t58 = t41**2
              t59 = -2.0d+0*t21*t40*t58/t18**3+3.216395899738507d+1*t21*
     1           t58/(t18**4*t19**2)+1.0d+0*t21*t40*t42*(2.1622951122684
     2           114d+0*t57+1.7087761055320938d+0*t56+1.2335503316757068
     3           d+0*t55+2.673190323653546d-1*t46)+1.1102230246251565d-1
     4           6*t25*t34*t39*(1.1632736958443765d+0*t57+9.891419649558
     5           61d-1*t56+6.003214762495226d-1*t55+2.1077825841639536d-
     6           1*t46)-4.0675215258019015d-19*t24*t56-1.761386524178568
     7           4d-3*t20*t56-2.220446049250313d-16*t25*t34*t54/t22**3+1
     8           .7854583920998188d-15*t25*t54/(t22**4*t23**2)-8.4979745
     9           91333913d-2*t36*t40*t41*t42-9.812069668265515d-18*t34*t
     :           36*t38*t39
              t60 = 1/t27**3
              t61 = 1/rhob**7
              t62 = 1/rhob**5.333333333333333d+0
              t63 = 1/rhob**3.6666666666666664d+0
              t64 = 1/t2**4
              fnc(iq) = (5.0d-1*rhob*t26*t33+5.0d-1*rhob*t12*t26*t3)*wgh
     1           t+fnc(iq)
              Amat(iq,D1_RB) = (t3*t53+5.0d-1*rhob*t26*t50+2.57544d-52*t
     1           1*t12*t26*t5+5.0d-1*rhob*t33*t43+5.0d-1*t26*t33)*wght+A
     2           mat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (t3*(5.0d-1*rhob*t26*(-1.373568d-51*t
     1           5*t6*t63*t9+8.888888888888888d-50*t3*t63*t9+5.306312954
     2           879999d-103*t51*t6*t62*t9-3.43392d-101*t5*t62*t9+2.5470
     3           302183424d-201*t64*t8/rhob**8.666666666666666d+0+2.3111
     4           111111111113d-98*t5*t62*t8-1.53839616d-149*t51*t61*t8+1
     5           .5918938864639998d-102*t4*t62*t64*t7-2.747136d-51*t4*t5
     6           1*t63*t7+6.367575545855999d-152*t11*t6*t61*t64+1.777777
     7           7777777776d-49*t4*t5*t6*t63+1.7777777777777776d-49*t11*
     8           t5*t6*t63+1.7777777777777776d-49*t10*t3*t63-1.373568d-1
     9           00*t4*t51*t6*t62-2.4724223999999997d-100*t11*t51*t6*t62
     :           +2.222222222222222d-99*t4*t5*t62+8.0d-99*t11*t5*t62-1.2
     ;           362111999999999d-100*t10*t5*t62-2.7471359999999995d-150
     <           *t11*t51*t61+2.1225251819519997d-152*t10*t51*t61)+5.0d-
     =           1*rhob*t12*t59+1.0d+0*rhob*t43*t52+1.0d+0*t26*t52+1.0d+
     >           0*t12*t43)+5.0d-1*rhob*t26*(2.4d-51*t1*t28*(2.4d-51*t1*
     ?           t28*(2.4d-51*t1*t28*(1.0666666666666666d-50*t28*t29*t63
     @           -5.76d-101*t29*t44*t62+7.68d-152*t29*t60*t61)+1.0666666
     1           666666666d-50*t28*t30*t63-5.76d-101*t30*t44*t62+7.68d-1
     2           52*t30*t60*t61-8.0d-51*t28*t46*t47+1.92d-101*t44*t45*t4
     3           7)+1.0666666666666666d-50*t28*t31*t63-5.76d-101*t31*t44
     4           *t62+7.68d-152*t31*t60*t61-8.0d-51*t28*t46*t48+1.92d-10
     5           1*t44*t45*t48)+1.0666666666666666d-50*t28*t32*t63-5.76d
     6           -101*t32*t44*t62+7.68d-152*t32*t60*t61-8.0d-51*t28*t46*
     7           t49+1.92d-101*t44*t45*t49)+5.0d-1*rhob*t33*t59+t46*t5*(
     8           5.15088d-52*t53-4.2923999999999995d-52*t12*t26)+t1*t5*(
     9           2.57544d-52*t26*t52+2.57544d-52*t12*t43)+2.653156477439
     :           9996d-103*t12*t26*t45*t51+1.0d+0*rhob*t43*t50+1.0d+0*t2
     ;           6*t50+1.0d+0*t33*t43)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_m06 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {\it t_{11}}\,\left(-0.0598079686361971\,{
C>    \it t_{14}}\,{\it t_{15}}\,\left(0.1274696188700087\,{
C>    \it t_{12}}+1.0\right)\,{\it t_{17}}\,\log 
C>    \left({{32.16395899738507}\over{11.12037486309469\,{\it t_{21}}
C>    +3.844746237447211\,{\it t_{12}}+1.644733775567609\,{\it t_{20}}
C>    +0.2405871291288192\,{\it t_{19}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_{12}}
C>    +1.0\right)\,\left({\it t_{18}}+1.923661050931536\,{
C>    \it t_{17}}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{21}}+2.247591863577616\,{
C>    \it t_{12}}+0.4300972471276643\,{\it t_{20}}
C>    +0.1911512595127337\,{\it t_{19}}}}+1.0\right)-0.0621814
C>    \,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{21}}+2.225569421150687\,{
C>    \it t_{12}}+0.8004286349993635\,{\it t_{20}}
C>    +0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)-{
C>    \it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}\,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{26}} &=& {\it t_{25}}\,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{27}} &=& {\it t_{26}}+{\it t_{24}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{0.0031\,{\it t_{27}}+1.0}}\\\\ 
C>   {\it t_{29}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{30}} &=& {{1}\over{0.06\,{\it t_{23}}\,
C>    \sigma_{\alpha\alpha}+1.0}}\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{32}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{33}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{34}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\tau_\alpha}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_{37}} &=& {{2.0\,\tau_\alpha}
C>    \over{\rho_\alpha^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{38}} &=& 0.00515088\,\left({\it t_{37}}+{\it t_{24}}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{39}} &=& {{1}\over{{\it t_{38}}}}\\\\ 
C>   {\it t_{40}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{41}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{42}} &=& {{1}\over{{\it t_{38}}^2}}\\\\ 
C>   {\it t_{43}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{44}} &=& {\it t_{37}}-9.11559972\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{48}} &=& {{1}\over{0.06\,{\it t_{25}}\,
C>    \sigma_{\beta\beta}+1.0}}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{\tau_\beta}}\\\\ 
C>   {\it t_{50}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{51}} &=& {{2.0\,\tau_\beta}\over{\rho_\beta^{{{5}
C>    \over{3}}}}}\\\\ 
C>   {\it t_{52}} &=& 0.00515088\,\left({\it t_{51}}+{\it t_{26}}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{53}} &=& {{1}\over{{\it t_{52}}}}\\\\ 
C>   {\it t_{54}} &=& {{1}\over{{\it t_{52}}^2}}\\\\ 
C>   {\it t_{55}} &=& {\it t_{51}}-9.11559972\\\\ 
C>   {\it t_{56}} &=& 0.00304966\,\left({\it t_{51}}+{\it t_{37}}
C>    +{\it t_{26}}+{\it t_{24}}-18.23119944\right)+1.0\\\\ 
C>   {\it t_{57}} &=& {{1}\over{{\it t_{56}}}}\\\\ 
C>   {\it t_{58}} &=& {{1}\over{{\it t_{56}}^2}}\\\\ 
C>   {\it t_{59}} &=& {\it t_{51}}+{\it t_{37}}-18.23119944\\\\ 
C>   {\it t_{60}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{61}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{62}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{63}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{64}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{63}}+2.225569421150687\,{\it t_{62}}+0.8004286349993635
C>    \,{\it t_{61}}+0.1897004325747558\,{\it t_{60}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{62}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{63}}+3.844746237447211\,{\it t_{62}}+1.644733775567609
C>    \,{\it t_{61}}+0.2405871291288192\,{\it t_{60}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{62}}+1.0\right)\\\\ 
C>   {\it t_{65}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{66}} &=& {{1}\over{0.06\,{\it t_{65}}\,\sigma_{ss}
C>    +1.0}}\\\\ 
C>   {\it t_{67}} &=& {{1}\over{\tau_s}}\\\\ 
C>   {\it t_{68}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{69}} &=& {{2.0\,\tau_s}\over{\rho_s^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{70}} &=& 0.00515088\,\left({\it t_{69}}+{\it t_{65}}
C>    \,\sigma_{ss}-9.11559972\right)+1.0\\\\ 
C>   {\it t_{71}} &=& {{1}\over{{\it t_{70}}}}\\\\ 
C>   {\it t_{72}} &=& {{1}\over{{\it t_{70}}^2}}\\\\ 
C>   {\it t_{73}} &=& {\it t_{69}}-9.11559972\\\\ 
C>   f &=& 1.0\,{\it t_{22}}\,{\it t_{57}}\,\left({\it param}
C>    \left(3\right)\,{\it t_{59}}\,{\it t_{57}}+{\it param}
C>    \left(2\right)\,{\it t_{27}}\,{\it t_{57}}+{\it param}
C>    \left(6\right)\,{\it t_{59}}^2\,{\it t_{58}}+{\it param}
C>    \left(5\right)\,{\it t_{27}}\,{\it t_{59}}\,{\it t_{58}}+{
C>    \it param}\left(4\right)\,{\it t_{27}}^2\,{\it t_{58}}+{
C>    \it param}\left(1\right)\right)+1.0\,{\it t_{10}}\,\rho_\beta
C>    \,\left(1.0-0.125\,{\it t_{50}}\,\sigma_{\beta\beta}\,{
C>    \it t_{49}}\right)\,{\it t_{53}}\,\left({\it t_{47}}\,{
C>    \it t_{55}}\,{\it t_{53}}+{\it t_{46}}\,{\it t_{25}}\,
C>    \sigma_{\beta\beta}\,{\it t_{53}}+{\it t_{45}}\,{\it t_{55}}^2
C>    \,{\it t_{54}}+{\it t_{43}}\,{\it t_{25}}\,\sigma_{\beta\beta}
C>    \,{\it t_{55}}\,{\it t_{54}}+{{{\it t_{41}}\,
C>    \sigma_{\beta\beta}^2\,{\it t_{54}}}
C>    \over{\rho_\beta^{{{16}\over{3}}}}}+{\it t_{40}}\right)+0.5
C>    \,{\it t_{10}}\,\rho_\beta\,\left(0.06\,{\it t_{25}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,\left(0.06\,{\it t_{25}}
C>    \,\sigma_{\beta\beta}\,{\it t_{48}}\,\left(0.06\,{\it t_{25}}
C>    \,\sigma_{\beta\beta}\,{\it t_{48}}\,\left(0.06\,{\it t_{34}}
C>    \,{\it t_{25}}\,\sigma_{\beta\beta}\,{\it t_{48}}+{
C>    \it t_{33}}\right)+{\it t_{32}}\right)+{\it t_{31}}\right)+{
C>    \it t_{29}}\right)\,{\it t_{49}}\,\left(2.0\,\tau_\beta-0.25
C>    \,{\it t_{50}}\,\sigma_{\beta\beta}\right)+1.0\,{\it t_5}
C>    \,\rho_\alpha\,\left(1.0-0.125\,{\it t_{36}}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{35}}\right)\,{\it t_{39}}
C>    \,\left({\it t_{47}}\,{\it t_{44}}\,{\it t_{39}}+{\it t_{46}}
C>    \,{\it t_{23}}\,\sigma_{\alpha\alpha}\,{\it t_{39}}+{
C>    \it t_{45}}\,{\it t_{44}}^2\,{\it t_{42}}+{\it t_{43}}\,{
C>    \it t_{23}}\,\sigma_{\alpha\alpha}\,{\it t_{44}}\,{\it t_{42}}
C>    +{{{\it t_{41}}\,\sigma_{\alpha\alpha}^2\,{\it t_{42}}}
C>    \over{\rho_\alpha^{{{16}\over{3}}}}}+{\it t_{40}}\right)+0.5
C>    \,{\it t_5}\,\rho_\alpha\,\left(0.06\,{\it t_{23}}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{30}}\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{30}}\,\left(0.06\,{
C>    \it t_{23}}\,\sigma_{\alpha\alpha}\,{\it t_{30}}\,\left(0.06
C>    \,{\it t_{34}}\,{\it t_{23}}\,\sigma_{\alpha\alpha}\,{
C>    \it t_{30}}+{\it t_{33}}\right)+{\it t_{32}}\right)+{
C>    \it t_{31}}\right)+{\it t_{29}}\right)\,{\it t_{35}}\,
C>    \left(2.0\,\tau_\alpha-0.25\,{\it t_{36}}\,
C>    \sigma_{\alpha\alpha}\right)+1.0\,{\it t_{22}}\,\left(0.0031
C>    \,{\it t_{27}}\,{\it t_{28}}\,\left(0.0031\,{\it t_{27}}\,{
C>    \it t_{28}}\,\left(0.0031\,{\it t_{27}}\,{\it t_{28}}\,
C>    \left(0.0031\,{\it param}\left(17\right)\,{\it t_{27}}\,{
C>    \it t_{28}}+{\it param}\left(16\right)\right)+{
C>    \it param}\left(15\right)\right)+{\it param}
C>    \left(14\right)\right)+{\it param}\left(13\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,{\it t_{64}}\,\rho_s\,\left(1.0-0.125\,{\it t_{68}}
C>    \,\sigma_{ss}\,{\it t_{67}}\right)\,{\it t_{71}}\,\left({
C>    \it t_{47}}\,{\it t_{73}}\,{\it t_{71}}+{\it t_{46}}\,{
C>    \it t_{65}}\,\sigma_{ss}\,{\it t_{71}}+{\it t_{45}}\,{
C>    \it t_{73}}^2\,{\it t_{72}}+{\it t_{43}}\,{\it t_{65}}
C>    \,\sigma_{ss}\,{\it t_{73}}\,{\it t_{72}}+{{{\it t_{41}}
C>    \,\sigma_{ss}^2\,{\it t_{72}}}\over{\rho_s^{{{16}\over{3}}}}}
C>    +{\it t_{40}}\right)+0.5\,{\it t_{64}}\,\rho_s\,\left(0.06
C>    \,{\it t_{65}}\,\sigma_{ss}\,{\it t_{66}}\,\left(0.06\,{
C>    \it t_{65}}\,\sigma_{ss}\,{\it t_{66}}\,\left(0.06\,{
C>    \it t_{65}}\,\sigma_{ss}\,{\it t_{66}}\,\left(0.06\,{
C>    \it t_{34}}\,{\it t_{65}}\,\sigma_{ss}\,{\it t_{66}}+{
C>    \it t_{33}}\right)+{\it t_{32}}\right)+{\it t_{31}}\right)+{
C>    \it t_{29}}\right)\,{\it t_{67}}\,\left(2.0\,\tau_s-0.25\,{
C>    \it t_{68}}\,\sigma_{ss}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] Y Zhao, DG Truhlar, J.Chem.Phys. 123, 194101 (2006)  , DOI: 
C> <a href="http://dx.doi.org/10.1063/1.2370993 "> 
C> 10.1063/1.2370993 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_m06_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.2d-3*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = param(17)
              t5 = 6.2d-3*gammaaa*t1*t3*t4+param(16)
              t6 = 6.2d-3*gammaaa*t1*t3*t5+param(15)
              t7 = 6.2d-3*gammaaa*t1*t3*t6+param(14)
              t8 = 6.2d-3*gammaaa*t1*t3*t7+param(13)
              t9 = 1/rhoa**6.666666666666666d-1
              t10 = rhoa**5.0d-1
              t11 = 1/t10
              t12 = 1/rhoa**3.333333333333333d-1
              t13 = 1/rhoa**1.6666666666666666d-1
              t14 = 2.4058712912881916d-1*t9+1.1120374863094686d+1*t13+3
     1           .8447462374472113d+0*t12+1.644733775567609d+0*t11
              t15 = 3.216395899738507d+1/t14+1.0d+0
              t16 = log(t15)
              t17 = 1.274696188700087d-1*t12+1.0d+0
              t18 = 1.8970043257475583d-1*t9+5.982550435771079d+0*t13+2.
     1           2255694211506874d+0*t12+8.004286349993635d-1*t11
              t19 = 1.6081979498692536d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.3256889990520176d-1*t12+1.0d+0
              t22 = -6.903522198342671d-18*t20*t21-3.1090699999999993d-2
     1           *t16*t17
              t23 = -2*rhoa*t22
              t24 = t23-1.243628d-1*rhoa*(1.0522000558389212d-1*t12+1.0d
     1           +0)*log(1.6081979498692536d+1/(1.19503784087549d-1*t9+5
     2           .329846514438383d+0*t13+1.766435620181429d+0*t12+5.6598
     3           85156639418d-1*t11)+1.0d+0)
              t25 = 6.0d-2*gammaaa*t1+1.0d+0
              t26 = 1/t25
              t27 = param(22)
              t28 = 6.0d-2*gammaaa*t1*t26*t27+param(21)
              t29 = 6.0d-2*gammaaa*t1*t26*t28+param(20)
              t30 = 6.0d-2*gammaaa*t1*t26*t29+param(19)
              t31 = 6.0d-2*gammaaa*t1*t26*t30+param(18)
              t32 = 1/taua
              t33 = 1/rhoa
              t34 = 2.0d+0*taua-2.5d-1*gammaaa*t33
              t35 = 1.0d+0-1.25d-1*gammaaa*t32*t33
              t36 = 1/rhoa**1.6666666666666669d+0
              t37 = 2.0d+0*t36*taua
              t38 = 5.15088d-3*(t37+gammaaa*t1-9.11559972d+0)+1.0d+0
              t39 = 1/t38
              t40 = param(10)
              t41 = gammaaa**2
              t42 = 1/rhoa**5.333333333333333d+0
              t43 = 1/t38**2
              t44 = param(11)
              t45 = t37-9.11559972d+0
              t46 = param(12)
              t47 = t45**2
              t48 = param(8)
              t49 = param(9)
              t50 = t39*t45*t49+gammaaa*t1*t39*t48+t43*t46*t47+gammaaa*t
     1           1*t43*t44*t45+t40*t41*t42*t43+param(7)
              t51 = 4.0d+0*t36*taua
              t52 = 3.04966d-3*(t51+2*gammaaa*t1-1.823119944d+1)+1.0d+0
              t53 = 1/t52
              t54 = param(4)
              t55 = 1/t52**2
              t56 = param(5)
              t57 = t51-1.823119944d+1
              t58 = param(6)
              t59 = t57**2
              t60 = param(2)
              t61 = param(3)
              t62 = t53*t57*t61+2*gammaaa*t1*t53*t60+t55*t58*t59+2*gamma
     1           aa*t1*t55*t56*t57+4*t41*t42*t54*t55+param(1)
              t63 = 6.299605249474366d-1
              t64 = 1.414213562373095d+0
              t65 = 1/t64
              t66 = 7.937005259840998d-1
              t67 = 8.908987181403393d-1
              t68 = 1.8970043257475583d-1*t63*t9+5.982550435771079d+0*t1
     1           3*t67+2.2255694211506874d+0*t12*t66+8.004286349993635d-
     2           1*t11*t65
              t69 = 1.6081979498692536d+1/t68+1.0d+0
              t70 = log(t69)
              t71 = 1.3256889990520176d-1*t12*t66+1.0d+0
              t72 = 1/t19
              t73 = 1/t10**3
              t74 = 1/rhoa**1.3333333333333333d+0
              t75 = 1/rhoa**1.1666666666666667d+0
              t76 = -9.970917392951799d-1*t75-7.418564737168958d-1*t74-4
     1           .002143174996817d-1*t73-1.264669550498372d-1*t36
              t77 = 1/t18**2
              t78 = 1/t15
              t79 = -1.8533958105157808d+0*t75-1.2815820791490704d+0*t74
     1           -8.223668877838045d-1*t73-1.6039141941921276d-1*t36
              t80 = 1/t14**2
              t81 = 1.0d+0*t17*t78*t79*t80+1.1102230246251565d-16*t21*t7
     1           2*t76*t77+3.0506411443514264d-19*t20*t74+1.321039893133
     2           9265d-3*t16*t74
              t82 = 1/t69
              t83 = 3.149802624737183d-1
              t84 = 1/t64**3
              t85 = 3.968502629920499d-1
              t86 = 4.4544935907016964d-1
              t87 = -9.970917392951799d-1*t75*t86-7.418564737168958d-1*t
     1           74*t85-4.002143174996817d-1*t73*t84-1.264669550498372d-
     2           1*t36*t83
              t88 = 1/t68**2
              t89 = 2*rhoa*(1.0d+0*t71*t82*t87*t88+2.747773264188437d-3*
     1           t70*t74*t85)-rhoa*t81-6.21814d-2*t70*t71+6.903522198342
     2           671d-18*t20*t21+3.1090699999999993d-2*t16*t17
              t90 = 1/t2**2
              t91 = 1/rhoa**6.333333333333333d+0
              t92 = 1/rhoa**3.6666666666666664d+0
              t93 = 5.125333333333332d-5*t4*t41*t90*t91-8.26666666666666
     1           5d-3*gammaaa*t3*t4*t92
              t94 = 6.2d-3*gammaaa*t1*t3*t93-8.266666666666665d-3*gammaa
     1           a*t3*t5*t92+5.125333333333332d-5*t41*t5*t90*t91
              t95 = 6.2d-3*gammaaa*t1*t3*t94-8.266666666666665d-3*gammaa
     1           a*t3*t6*t92+5.125333333333332d-5*t41*t6*t90*t91
              t96 = 6.2d-3*gammaaa*t1*t3*t95-8.266666666666665d-3*gammaa
     1           a*t3*t7*t92+5.125333333333332d-5*t41*t7*t90*t91
              t97 = t23-1.243628d-1*rhoa*t70*t71
              t98 = 1/t25**2
              t99 = 9.599999999999997d-3*t27*t41*t91*t98-1.5999999999999
     1           998d-1*gammaaa*t26*t27*t92
              t100 = 6.0d-2*gammaaa*t1*t26*t99+9.599999999999997d-3*t28*
     1           t41*t91*t98-1.5999999999999998d-1*gammaaa*t26*t28*t92
              t101 = 9.599999999999997d-3*t29*t41*t91*t98-1.599999999999
     1           9998d-1*gammaaa*t26*t29*t92+6.0d-2*gammaaa*t1*t100*t26
              t102 = 9.599999999999997d-3*t30*t41*t91*t98-1.599999999999
     1           9998d-1*gammaaa*t26*t30*t92+6.0d-2*gammaaa*t1*t101*t26
              t103 = -3.3333333333333337d+0*t1*taua-2.6666666666666666d+
     1           0*gammaaa*t92
              t104 = 1/t38**3
              t105 = -3.3333333333333337d+0*t1*t39*t49*taua-6.6666666666
     1           66667d+0*t1*t43*t45*t46*taua-3.3333333333333337d+0*gamm
     2           aaa*t42*t43*t44*taua-2.6666666666666666d+0*gammaaa*t39*
     3           t48*t92-2.6666666666666666d+0*gammaaa*t43*t44*t45*t92-5
     4           .333333333333333d+0*t40*t41*t43*t91-5.15088d-3*t103*t43
     5           *t45*t49-5.15088d-3*gammaaa*t1*t103*t43*t48-1.030176d-2
     6           *t103*t104*t46*t47-1.030176d-2*gammaaa*t1*t103*t104*t44
     7           *t45-1.030176d-2*t103*t104*t40*t41*t42
              t106 = 1.0d+0*rhoa*t35*t50*t81+1.0d+0*t22*t35*t50+1.0d+0*r
     1           hoa*t105*t22*t35
              t107 = 1/t52**3
              t108 = -3.3333333333333337d+0*t1*t53*t61*taua-6.6666666666
     1           66667d+0*t1*t55*t57*t58*taua-6.666666666666667d+0*gamma
     2           aa*t42*t55*t56*taua-2.6666666666666666d+0*gammaaa*t53*t
     3           60*t92-2.6666666666666666d+0*gammaaa*t55*t56*t57*t92-1.
     4           0666666666666666d+1*t41*t54*t55*t91-3.04966d-3*t103*t55
     5           *t57*t61-6.09932d-3*gammaaa*t1*t103*t55*t60-6.09932d-3*
     6           t103*t107*t58*t59-1.219864d-2*gammaaa*t1*t103*t107*t56*
     7           t57-2.439728d-2*t103*t107*t41*t42*t54
              t109 = 1.0d+0*t108*t97+1.0d+0*t62*t89
              t110 = 3.1d-3*t1*t3*t4-1.9219999999999998d-5*gammaaa*t4*t4
     1           2*t90
              t111 = -1.9219999999999998d-5*gammaaa*t42*t5*t90+3.1d-3*t1
     1           *t3*t5+6.2d-3*gammaaa*t1*t110*t3
              t112 = -1.9219999999999998d-5*gammaaa*t42*t6*t90+3.1d-3*t1
     1           *t3*t6+6.2d-3*gammaaa*t1*t111*t3
              t113 = -1.9219999999999998d-5*gammaaa*t42*t7*t90+3.1d-3*t1
     1           *t3*t7+6.2d-3*gammaaa*t1*t112*t3
              t114 = -1.25d-1*t22*t31
              t115 = 6.0d-2*t1*t26*t27-3.6d-3*gammaaa*t27*t42*t98
              t116 = -3.6d-3*gammaaa*t28*t42*t98+6.0d-2*t1*t26*t28+6.0d-
     1           2*gammaaa*t1*t115*t26
              t117 = -3.6d-3*gammaaa*t29*t42*t98+6.0d-2*t1*t26*t29+6.0d-
     1           2*gammaaa*t1*t116*t26
              t118 = -3.6d-3*gammaaa*t30*t42*t98+6.0d-2*t1*t26*t30+6.0d-
     1           2*gammaaa*t1*t117*t26
              t119 = 1/rhoa**8
              t120 = -5.15088d-3*t1*t43*t45*t49-5.15088d-3*gammaaa*t42*t
     1           43*t48+t1*t39*t48-1.030176d-2*t1*t104*t46*t47+t1*t43*t4
     2           4*t45-1.030176d-2*gammaaa*t104*t42*t44*t45+2*gammaaa*t4
     3           0*t42*t43-1.030176d-2*t104*t119*t40*t41
              t121 = -3.04966d-3*t1*t55*t57*t61-6.09932d-3*gammaaa*t42*t
     1           55*t60+t1*t53*t60-6.09932d-3*t1*t107*t58*t59+t1*t55*t56
     2           *t57-1.219864d-2*gammaaa*t107*t42*t56*t57+4*gammaaa*t42
     3           *t54*t55-2.439728d-2*t107*t119*t41*t54
              t122 = taua**2
              t123 = 1/t122
              t124 = 1/rhoa**7
              t125 = 1/rhoa**4.333333333333333d+0
              t126 = -1.030176d-2*t36*t43*t45*t49+2.0d+0*t36*t39*t49-1.0
     1           30176d-2*gammaaa*t125*t43*t48-2.060352d-2*t104*t36*t46*
     2           t47+4.0d+0*t36*t43*t45*t46-2.060352d-2*gammaaa*t104*t12
     3           5*t44*t45+2.0d+0*gammaaa*t125*t43*t44-2.060352d-2*t104*
     4           t124*t40*t41
              t127 = -6.09932d-3*t36*t55*t57*t61+2.0d+0*t36*t53*t61-1.21
     1           9864d-2*gammaaa*t125*t55*t60-1.219864d-2*t107*t36*t58*t
     2           59+4.0d+0*t36*t55*t57*t58-2.439728d-2*gammaaa*t107*t125
     3           *t56*t57+4.0d+0*gammaaa*t125*t55*t56-4.879456d-2*t107*t
     4           124*t41*t54
              t128 = 2.0d+0*t89*t96
              t129 = 2.0d+0*t71*t82*t87*t88
              t130 = 5.495546528376875d-3*t70*t74*t85
              t131 = 1/t19**2
              t132 = t76**2
              t133 = 1/t18**4
              t134 = 1/t18**3
              t135 = 1/t10**5
              t136 = 1/rhoa**2.3333333333333334d+0
              t137 = 1/rhoa**2.1666666666666665d+0
              t138 = 1.1632736958443765d+0*t137+9.89141964955861d-1*t136
     1           +6.003214762495226d-1*t135+2.1077825841639536d-1*t1
              t139 = 1/t15**2
              t140 = t79**2
              t141 = 1/t14**4
              t142 = 1/t14**3
              t143 = 2.1622951122684114d+0*t137+1.7087761055320938d+0*t1
     1           36+1.2335503316757068d+0*t135+2.673190323653546d-1*t1
              t144 = -8.497974591333913d-2*t74*t78*t79*t80+1.0d+0*t143*t
     1           17*t78*t80-2.0d+0*t140*t142*t17*t78-9.812069668265515d-
     2           18*t72*t74*t76*t77+1.1102230246251565d-16*t138*t21*t72*
     3           t77-2.220446049250313d-16*t132*t134*t21*t72+1.785458392
     4           0998188d-15*t131*t132*t133*t21-4.0675215258019015d-19*t
     5           136*t20+3.216395899738507d+1*t139*t140*t141*t17-1.76138
     6           65241785684d-3*t136*t16
              t145 = 1/t69**2
              t146 = t87**2
              t147 = 1/t68**4
              t148 = 1.6081979498692536d+1*t145*t146*t147*t71
              t149 = 1/t68**3
              t150 = -2.0d+0*t146*t149*t71*t82
              t151 = 1.9842513149602492d-1
              t152 = 6.003214762495226d-1*t135/t64**5+9.89141964955861d-
     1           1*t136*t151+2.5908976111853255d-1*t137+3.31954955798747
     2           2d-2*t1
              t153 = 1.0d+0*t152*t71*t82*t88
              t154 = -3.663697685584583d-3*t136*t151*t70
              t155 = 1.9115125951273373d-1*t63*t9+8.157414703487641d+0*t
     1           13*t67+2.247591863577616d+0*t12*t66+4.3009724712766434d
     2           -1*t11*t65
              t156 = 2.9608813203268075d+1/t155+1.0d+0
              t157 = log(t156)
              t158 = 6.901399211255825d-2*t12*t66+1.0d+0
              t159 = 1/rhoa**2
              t160 = -8.837926660346784d-2*t74*t82*t85*t87*t88
              t161 = -2.0d+0*t17*t78*t79*t80-2.220446049250313d-16*t21*t
     1           72*t76*t77-6.101282288702853d-19*t20*t74-2.642079786267
     2           853d-3*t16*t74+2*rhoa*(t160+8.443431970194815d-3*t157*t
     3           158*t159+t154+t153+t150+t148)-rhoa*t144+t130+t129
              t162 = gammaaa**3
              t163 = 1/t2**3
              t164 = 1/rhoa**10
              t165 = 8.473884444444441d-7*t162*t163*t164*t7
              t166 = 1/rhoa**7.333333333333333d+0
              t167 = 1.0250666666666663d-4*t41*t90*t91*t95
              t168 = 1/rhoa**4.666666666666667d+0
              t169 = -1.653333333333333d-2*gammaaa*t3*t92*t95
              t170 = 8.473884444444441d-7*t162*t163*t164*t6
              t171 = 1.0250666666666663d-4*t41*t90*t91*t94
              t172 = -1.653333333333333d-2*gammaaa*t3*t92*t94
              t173 = 8.473884444444441d-7*t162*t163*t164*t5
              t174 = 1.0250666666666663d-4*t41*t90*t91*t93
              t175 = -1.653333333333333d-2*gammaaa*t3*t92*t93
              t176 = 8.473884444444441d-7*t162*t163*t164*t4
              t177 = -3.2460444444444436d-4*t166*t4*t41*t90+3.0311111111
     1           111105d-2*gammaaa*t168*t3*t4+t176
              t178 = -3.2460444444444436d-4*t166*t41*t5*t90+3.0311111111
     1           111105d-2*gammaaa*t168*t3*t5+6.2d-3*gammaaa*t1*t177*t3+
     2           t175+t174+t173
              t179 = -3.2460444444444436d-4*t166*t41*t6*t90+3.0311111111
     1           111105d-2*gammaaa*t168*t3*t6+6.2d-3*gammaaa*t1*t178*t3+
     2           t172+t171+t170
              t180 = -3.2460444444444436d-4*t166*t41*t7*t90+3.0311111111
     1           111105d-2*gammaaa*t168*t3*t7+6.2d-3*gammaaa*t1*t179*t3+
     2           t169+t167+t165
              t181 = 1/t25**3
              t182 = -8.639999999999998d-2*t166*t27*t41*t98+5.8666666666
     1           66666d-1*gammaaa*t168*t26*t27+3.0719999999999986d-3*t16
     2           2*t164*t181*t27
              t183 = 1.9199999999999995d-2*t41*t91*t98*t99-3.19999999999
     1           99995d-1*gammaaa*t26*t92*t99-8.639999999999998d-2*t166*
     2           t28*t41*t98+5.866666666666666d-1*gammaaa*t168*t26*t28+3
     3           .0719999999999986d-3*t162*t164*t181*t28+6.0d-2*gammaaa*
     4           t1*t182*t26
              t184 = 1.9199999999999995d-2*t100*t41*t91*t98-8.6399999999
     1           99998d-2*t166*t29*t41*t98-3.1999999999999995d-1*gammaaa
     2           *t100*t26*t92+5.866666666666666d-1*gammaaa*t168*t26*t29
     3           +3.0719999999999986d-3*t162*t164*t181*t29+6.0d-2*gammaa
     4           a*t1*t183*t26
              t185 = 1.9199999999999995d-2*t101*t41*t91*t98-8.6399999999
     1           99998d-2*t166*t30*t41*t98-3.1999999999999995d-1*gammaaa
     2           *t101*t26*t92+5.866666666666666d-1*gammaaa*t168*t26*t30
     3           +3.0719999999999986d-3*t162*t164*t181*t30+6.0d-2*gammaa
     4           a*t1*t184*t26
              t186 = t103**2
              t187 = 1.25d-1*gammaaa*t50*t81+1.25d-1*gammaaa*t105*t22
              t188 = 1/t38**4
              t189 = 8.88888888888889d+0*t92*taua+9.777777777777779d+0*g
     1           ammaaa*t168
              t190 = 8.88888888888889d+0*t39*t49*t92*taua+1.777777777777
     1           7778d+1*t43*t45*t46*t92*taua+2.6666666666666666d+1*gamm
     2           aaa*t43*t44*t91*taua+3.4339200000000003d-2*t1*t103*t43*
     3           t49*taua+1.373568d-1*t1*t103*t104*t45*t46*taua+6.867840
     4           000000001d-2*gammaaa*t103*t104*t42*t44*taua+2.747136d-2
     5           *gammaaa*t103*t43*t48*t92+5.494272d-2*gammaaa*t103*t104
     6           *t44*t45*t92+1.0988544d-1*t103*t104*t40*t41*t91-5.15088
     7           d-3*t189*t43*t45*t49+5.30631295488d-5*t104*t186*t45*t49
     8           -5.15088d-3*gammaaa*t1*t189*t43*t48+9.777777777777779d+
     9           0*gammaaa*t168*t39*t48+5.30631295488d-5*gammaaa*t1*t104
     :           *t186*t48-1.030176d-2*t104*t189*t46*t47+1.591893886464d
     ;           -4*t186*t188*t46*t47+2.2222222222222224d+1*t122*t42*t43
     <           *t46+9.777777777777779d+0*gammaaa*t168*t43*t44*t45-1.03
     =           0176d-2*gammaaa*t1*t104*t189*t44*t45+1.591893886464d-4*
     >           gammaaa*t1*t186*t188*t44*t45+3.377777777777778d+1*t166*
     ?           t40*t41*t43-1.030176d-2*t104*t189*t40*t41*t42+1.5918938
     @           86464d-4*t186*t188*t40*t41*t42
              t191 = 2.0d+0*t35*t50*t81+1.25d-1*gammaaa*t32*t33*t50*t81+
     1           2.0d+0*rhoa*t105*t35*t81+1.0d+0*rhoa*t144*t35*t50+1.25d
     2           -1*gammaaa*t159*t22*t32*t50+1.0d+0*rhoa*t190*t22*t35+2.
     3           0d+0*t105*t22*t35+1.25d-1*gammaaa*t105*t22*t32*t33
              t192 = -5.15088d-3*rhoa*t103*t35*t50*t81-5.15088d-3*rhoa*t
     1           189*t22*t35*t50-5.15088d-3*t103*t22*t35*t50-5.15088d-3*
     2           rhoa*t103*t105*t22*t35-5.15088d-3*t103*t106
              t193 = 1.86008522312d-5*t107*t186*t62*t97
              t194 = 1/t52**4
              t195 = 1.1160511338720001d-4*gammaaa*t1*t186*t194*t56*t57
              t196 = 2.2321022677440003d-4*t186*t194*t41*t42*t54
              t197 = 5.580255669360001d-5*t186*t194*t58*t59
              t198 = 1.3011882666666666d-1*t103*t107*t41*t54*t91
              t199 = 8.132426666666668d-2*gammaaa*t103*t107*t42*t56*taua
              t200 = 3.2529706666666663d-2*gammaaa*t103*t107*t56*t57*t92
              t201 = 8.132426666666668d-2*t1*t103*t107*t57*t58*taua
              t202 = 1.86008522312d-5*t107*t186*t57*t61
              t203 = 3.72017044624d-5*gammaaa*t1*t107*t186*t60
              t204 = 1.6264853333333332d-2*gammaaa*t103*t55*t60*t92
              t205 = 2.033106666666667d-2*t1*t103*t55*t61*taua
              t206 = 2.2222222222222224d+1*t122*t42*t55*t58
              t207 = 8.88888888888889d+0*t53*t61*t92*taua+1.777777777777
     1           7778d+1*t55*t57*t58*t92*taua+3.5555555555555557d+1*gamm
     2           aaa*t55*t56*t91*taua-3.04966d-3*t189*t55*t57*t61-6.0993
     3           2d-3*gammaaa*t1*t189*t55*t60+9.777777777777779d+0*gamma
     4           aa*t168*t53*t60-6.09932d-3*t107*t189*t58*t59+9.77777777
     5           7777779d+0*gammaaa*t168*t55*t56*t57-1.219864d-2*gammaaa
     6           *t1*t107*t189*t56*t57+5.333333333333333d+1*t166*t41*t54
     7           *t55-2.439728d-2*t107*t189*t41*t42*t54+t206+t205+t204+t
     8           203+t202+t201+t200+t199+t198+t197+t196+t195
              t208 = 2.0d+0*t108*t89
              t209 = 1.0d+0*t207*t97+1.0d+0*t161*t62+t208
              t210 = -3.04966d-3*t103*t108*t97
              t211 = -3.04966d-3*t103*t62*t89
              t212 = -3.04966d-3*t103*t109
              t213 = -3.04966d-3*t189*t62*t97+t212+t211+t210
              t214 = -8.443431970194815d-3*t157*t158*t159
              t215 = 2*rhoa*(t214+t160+t154+t153+t150+t148)+t130+t129
              t216 = t176-1.366755555555555d-4*t166*t4*t41*t90
              t217 = -1.366755555555555d-4*t166*t41*t5*t90+6.2d-3*gammaa
     1           a*t1*t216*t3+t175+t174+t173
              t218 = -1.366755555555555d-4*t166*t41*t6*t90+6.2d-3*gammaa
     1           a*t1*t217*t3+t172+t171+t170
              t219 = -1.366755555555555d-4*t166*t41*t7*t90+6.2d-3*gammaa
     1           a*t1*t218*t3+t169+t167+t165
              t220 = 1.7777777777777778d+1*gammaaa*t55*t56*t91*taua+1.42
     1           22222222222222d+1*t166*t41*t54*t55+t206+t205+t204+t203+
     2           t202+t201+t200+t199+t198+t197+t196+t195
              t221 = 1.0d+0*t220*t97+1.0d+0*t215*t62+t208
              t222 = t212+t211+t210
              t223 = 1.0d+0*t113*t89
              t224 = 1/rhoa**9
              t225 = -3.1777066666666653d-7*t163*t224*t41*t7
              t226 = 5.125333333333332d-5*t112*t41*t90*t91
              t227 = -1.9219999999999998d-5*gammaaa*t42*t90*t95
              t228 = -8.266666666666665d-3*gammaaa*t112*t3*t92
              t229 = -3.1777066666666653d-7*t163*t224*t41*t6
              t230 = 5.125333333333332d-5*t111*t41*t90*t91
              t231 = -1.9219999999999998d-5*gammaaa*t42*t90*t94
              t232 = -8.266666666666665d-3*gammaaa*t111*t3*t92
              t233 = -3.1777066666666653d-7*t163*t224*t41*t5
              t234 = 5.125333333333332d-5*t110*t41*t90*t91
              t235 = -1.9219999999999998d-5*gammaaa*t42*t90*t93
              t236 = -8.266666666666665d-3*gammaaa*t110*t3*t92
              t237 = -3.1777066666666653d-7*t163*t224*t4*t41
              t238 = -8.266666666666665d-3*t3*t4*t92+1.0250666666666663d
     1           -4*gammaaa*t4*t90*t91+t237
              t239 = 3.1d-3*t1*t3*t93
              t240 = -8.266666666666665d-3*t3*t5*t92+1.0250666666666663d
     1           -4*gammaaa*t5*t90*t91+6.2d-3*gammaaa*t1*t238*t3+t239+t2
     2           36+t235+t234+t233
              t241 = 3.1d-3*t1*t3*t94
              t242 = -8.266666666666665d-3*t3*t6*t92+1.0250666666666663d
     1           -4*gammaaa*t6*t90*t91+6.2d-3*gammaaa*t1*t240*t3+t241+t2
     2           32+t231+t230+t229
              t243 = 3.1d-3*t1*t3*t95
              t244 = -8.266666666666665d-3*t3*t7*t92+1.0250666666666663d
     1           -4*gammaaa*t7*t90*t91+6.2d-3*gammaaa*t1*t242*t3+t243+t2
     2           28+t227+t226+t225
              t245 = 1.25d-1*t22*t31
              t246 = 2.879999999999999d-2*gammaaa*t27*t91*t98-1.59999999
     1           99999998d-1*t26*t27*t92-1.1519999999999996d-3*t181*t224
     2           *t27*t41
              t247 = -3.6d-3*gammaaa*t42*t98*t99+6.0d-2*t1*t26*t99+9.599
     1           999999999997d-3*t115*t41*t91*t98+2.879999999999999d-2*g
     2           ammaaa*t28*t91*t98-1.5999999999999998d-1*t26*t28*t92-1.
     3           5999999999999998d-1*gammaaa*t115*t26*t92-1.151999999999
     4           9996d-3*t181*t224*t28*t41+6.0d-2*gammaaa*t1*t246*t26
              t248 = 9.599999999999997d-3*t116*t41*t91*t98+2.87999999999
     1           9999d-2*gammaaa*t29*t91*t98-3.6d-3*gammaaa*t100*t42*t98
     2           -1.5999999999999998d-1*t26*t29*t92-1.5999999999999998d-
     3           1*gammaaa*t116*t26*t92-1.1519999999999996d-3*t181*t224*
     4           t29*t41+6.0d-2*gammaaa*t1*t247*t26+6.0d-2*t1*t100*t26
              t249 = 9.599999999999997d-3*t117*t41*t91*t98+2.87999999999
     1           9999d-2*gammaaa*t30*t91*t98-3.6d-3*gammaaa*t101*t42*t98
     2           -1.5999999999999998d-1*t26*t30*t92-1.5999999999999998d-
     3           1*gammaaa*t117*t26*t92-1.1519999999999996d-3*t181*t224*
     4           t30*t41+6.0d-2*gammaaa*t1*t248*t26+6.0d-2*t1*t101*t26
              t250 = 1.25d-1*t22*t50+1.25d-1*gammaaa*t120*t22
              t251 = 1.7169600000000002d-2*t42*t43*t49*taua+6.8678400000
     1           00001d-2*t104*t42*t45*t46*taua-3.3333333333333337d+0*t4
     2           2*t43*t44*taua+3.4339200000000003d-2*gammaaa*t104*t119*
     3           t44*taua+1.373568d-2*t43*t45*t49*t92-2.6666666666666666
     4           d+0*t39*t48*t92+2.747136d-2*t104*t46*t47*t92-2.66666666
     5           66666666d+0*t43*t44*t45*t92+2.747136d-2*gammaaa*t43*t48
     6           *t91+5.494272d-2*gammaaa*t104*t44*t45*t91-1.06666666666
     7           66666d+1*gammaaa*t40*t43*t91+5.30631295488d-5*t1*t103*t
     8           104*t45*t49-5.15088d-3*t1*t103*t43*t48+5.30631295488d-5
     9           *gammaaa*t103*t104*t42*t48+1.591893886464d-4*t1*t103*t1
     :           88*t46*t47+1.591893886464d-4*gammaaa*t103*t188*t42*t44*
     ;           t45-1.030176d-2*t1*t103*t104*t44*t45-2.060352d-2*gammaa
     <           a*t103*t104*t40*t42+8.241408d-2*t104*t224*t40*t41+1.591
     =           893886464d-4*t103*t119*t188*t40*t41
              t252 = -1.25d-1*t32*t50*t81+1.0d+0*rhoa*t120*t35*t81-1.25d
     1           -1*t22*t32*t33*t50+1.0d+0*rhoa*t22*t251*t35+1.0d+0*t120
     2           *t22*t35-1.25d-1*t105*t22*t32
              t253 = 1.373568d-2*t22*t35*t50-5.15088d-3*t106
              t254 = -3.04966d-3*t103*t121*t55*t97
              t255 = 1.86008522312d-5*t1*t103*t107*t62*t97
              t256 = 2.2321022677440003d-4*t103*t119*t194*t41*t54
              t257 = 1.1160511338720001d-4*gammaaa*t103*t194*t42*t56*t57
              t258 = 5.580255669360001d-5*t1*t103*t194*t58*t59
              t259 = 4.066213333333334d-2*gammaaa*t107*t119*t56*taua
              t260 = 3.72017044624d-5*gammaaa*t103*t107*t42*t60
              t261 = -2.439728d-2*gammaaa*t103*t107*t42*t54
              t262 = 4.066213333333334d-2*t107*t42*t57*t58*taua
              t263 = 1.86008522312d-5*t1*t103*t107*t57*t61
              t264 = -6.09932d-3*t1*t103*t107*t56*t57
              t265 = 1.0165533333333335d-2*t42*t55*t61*taua
              t266 = -3.3333333333333337d+0*t42*t55*t56*taua
              t267 = -3.04966d-3*t1*t103*t55*t60
              t268 = 8.132426666666667d-3*t55*t57*t61*t92-2.666666666666
     1           6666d+0*t53*t60*t92+1.6264853333333332d-2*t107*t58*t59*
     2           t92-2.6666666666666666d+0*t55*t56*t57*t92+2.439728d-2*g
     3           ammaaa*t55*t60*t91+4.879456d-2*gammaaa*t107*t56*t57*t91
     4           -16*gammaaa*t54*t55*t91+1.3011882666666666d-1*t107*t224
     5           *t41*t54+t267+t266+t265+t264+t263+t262+t261+t260+t259+t
     6           258+t257+t256
              t269 = 1.0d+0*t121*t89
              t270 = 1.0d+0*t268*t97+t269
              t271 = -3.04966d-3*t1*t109*t55
              t272 = 5.125333333333332d-5*gammaaa*t4*t90*t91+t237
              t273 = 5.125333333333332d-5*gammaaa*t5*t90*t91+6.2d-3*gamm
     1           aaa*t1*t272*t3+t239+t236+t235+t234+t233
              t274 = 5.125333333333332d-5*gammaaa*t6*t90*t91+6.2d-3*gamm
     1           aaa*t1*t273*t3+t241+t232+t231+t230+t229
              t275 = 5.125333333333332d-5*gammaaa*t7*t90*t91+6.2d-3*gamm
     1           aaa*t1*t274*t3+t243+t228+t227+t226+t225
              t276 = 8.132426666666667d-3*gammaaa*t55*t60*t91+1.62648533
     1           33333332d-2*gammaaa*t107*t56*t57*t91-5.333333333333333d
     2           +0*gammaaa*t54*t55*t91+6.505941333333333d-2*t107*t224*t
     3           41*t54+t267+t266+t265+t264+t263+t262+t261+t260+t259+t25
     4           8+t257+t256
              t277 = 1.0d+0*t276*t97+t269
              t278 = 1.1916399999999999d-7*gammaaa*t119*t163*t4-1.921999
     1           9999999998d-5*t4*t42*t90
              t279 = -1.9219999999999998d-5*t42*t5*t90-3.843999999999999
     1           6d-5*gammaaa*t110*t42*t90+1.1916399999999999d-7*gammaaa
     2           *t119*t163*t5+6.2d-3*gammaaa*t1*t278*t3+6.2d-3*t1*t110*
     3           t3
              t280 = -1.9219999999999998d-5*t42*t6*t90-3.843999999999999
     1           6d-5*gammaaa*t111*t42*t90+1.1916399999999999d-7*gammaaa
     2           *t119*t163*t6+6.2d-3*gammaaa*t1*t279*t3+6.2d-3*t1*t111*
     3           t3
              t281 = -1.9219999999999998d-5*t42*t7*t90-3.843999999999999
     1           6d-5*gammaaa*t112*t42*t90+1.1916399999999999d-7*gammaaa
     2           *t119*t163*t7+6.2d-3*gammaaa*t1*t280*t3+6.2d-3*t1*t112*
     3           t3
              t282 = 1.0d+0*t281*t97
              t283 = 4.32d-4*gammaaa*t119*t181*t27-7.2d-3*t27*t42*t98
              t284 = -7.2d-3*t28*t42*t98-7.2d-3*gammaaa*t115*t42*t98+6.0
     1           d-2*gammaaa*t1*t26*t283+4.32d-4*gammaaa*t119*t181*t28+1
     2           .2d-1*t1*t115*t26
              t285 = -7.2d-3*t29*t42*t98-7.2d-3*gammaaa*t116*t42*t98+4.3
     1           2d-4*gammaaa*t119*t181*t29+6.0d-2*gammaaa*t1*t26*t284+1
     2           .2d-1*t1*t116*t26
              t286 = -7.2d-3*t30*t42*t98-7.2d-3*gammaaa*t117*t42*t98+4.3
     1           2d-4*gammaaa*t119*t181*t30+6.0d-2*gammaaa*t1*t26*t285+1
     2           .2d-1*t1*t117*t26
              t287 = 1/rhoa**1.0666666666666666d+1
              t288 = 5.30631295488d-5*t104*t42*t45*t49-1.030176d-2*t42*t
     1           43*t48+5.30631295488d-5*gammaaa*t104*t119*t48+1.5918938
     2           86464d-4*t188*t42*t46*t47-2.060352d-2*t104*t42*t44*t45+
     3           1.591893886464d-4*gammaaa*t119*t188*t44*t45+2*t40*t42*t
     4           43+1.591893886464d-4*t188*t287*t40*t41-4.120704d-2*gamm
     5           aaa*t104*t119*t40
              t289 = 1.86008522312d-5*t107*t42*t57*t61-6.09932d-3*t42*t5
     1           5*t60+3.72017044624d-5*gammaaa*t107*t119*t60+5.58025566
     2           9360001d-5*t194*t42*t58*t59-1.219864d-2*t107*t42*t56*t5
     3           7+1.1160511338720001d-4*gammaaa*t119*t194*t56*t57+2*t42
     4           *t54*t55+2.2321022677440003d-4*t194*t287*t41*t54-4.8794
     5           56d-2*gammaaa*t107*t119*t54
              t290 = 1.0d+0*t289*t53*t97
              t291 = -6.09932d-3*t1*t121*t55*t97
              t292 = 1.86008522312d-5*t107*t42*t62*t97
              t293 = 3.4339200000000003d-2*t125*t43*t49*taua+1.373568d-1
     1           *t104*t125*t45*t46*taua-1.3333333333333333d+1*t125*t43*
     2           t46*taua+6.867840000000001d-2*gammaaa*t104*t124*t44*tau
     3           a+1.7169600000000002d-2*t1*t43*t45*t49+1.061262590976d-
     4           4*t103*t104*t36*t45*t49-1.030176d-2*t103*t36*t43*t49-3.
     5           3333333333333337d+0*t1*t39*t49+4.464096d-2*gammaaa*t42*
     6           t43*t48+1.061262590976d-4*gammaaa*t103*t104*t125*t48+3.
     7           183787772928d-4*t103*t188*t36*t46*t47+3.433920000000000
     8           3d-2*t1*t104*t46*t47-6.666666666666667d+0*t1*t43*t45*t4
     9           6-4.120704d-2*t103*t104*t36*t45*t46+8.928192d-2*gammaaa
     :           *t104*t42*t44*t45+3.183787772928d-4*gammaaa*t103*t125*t
     ;           188*t44*t45-8.666666666666666d+0*gammaaa*t42*t43*t44-2.
     <           060352d-2*gammaaa*t103*t104*t125*t44+3.183787772928d-4*
     =           t103*t124*t188*t40*t41+1.4422464000000002d-1*t104*t119*
     >           t40*t41
              t294 = 1.25d-1*gammaaa*t123*t50*t81+1.0d+0*rhoa*t126*t35*t
     1           81+1.25d-1*gammaaa*t123*t22*t33*t50+1.0d+0*rhoa*t22*t29
     2           3*t35+1.0d+0*t126*t22*t35+1.25d-1*gammaaa*t105*t123*t22
              t295 = -3.04966d-3*t103*t127*t55*t97
              t296 = 3.72017044624d-5*t103*t107*t36*t62*t97
              t297 = 4.4642045354880006d-4*t103*t124*t194*t41*t54
              t298 = 2.2321022677440003d-4*gammaaa*t103*t125*t194*t56*t5
     1           7
              t299 = 1.1160511338720001d-4*t103*t194*t36*t58*t59
              t300 = 8.132426666666668d-2*gammaaa*t107*t124*t56*taua
              t301 = 7.44034089248d-5*gammaaa*t103*t107*t125*t60
              t302 = -2.439728d-2*gammaaa*t103*t107*t125*t56
              t303 = 8.132426666666668d-2*t107*t125*t57*t58*taua
              t304 = 3.72017044624d-5*t103*t107*t36*t57*t61
              t305 = -2.439728d-2*t103*t107*t36*t57*t58
              t306 = 2.033106666666667d-2*t125*t55*t61*taua
              t307 = -1.3333333333333333d+1*t125*t55*t58*taua
              t308 = -6.09932d-3*t103*t36*t55*t61
              t309 = 1.0165533333333335d-2*t1*t55*t57*t61-3.333333333333
     1           3337d+0*t1*t53*t61+3.6595920000000004d-2*gammaaa*t42*t5
     2           5*t60+2.033106666666667d-2*t1*t107*t58*t59-6.6666666666
     3           66667d+0*t1*t55*t57*t58+7.319184000000001d-2*gammaaa*t1
     4           07*t42*t56*t57-1.2d+1*gammaaa*t42*t55*t56+2.11443093333
     5           33333d-1*t107*t119*t41*t54+t308+t307+t306+t305+t304+t30
     6           3+t302+t301+t300+t299+t298+t297
              t310 = 1.0d+0*t127*t89
              t311 = 1.0d+0*t309*t97+t310
              t312 = -6.09932d-3*t109*t36*t55
              t313 = 1.6264853333333332d-2*gammaaa*t42*t55*t60+3.2529706
     1           666666663d-2*gammaaa*t107*t42*t56*t57-5.333333333333333
     2           d+0*gammaaa*t42*t55*t56+1.3011882666666666d-1*t107*t119
     3           *t41*t54+t308+t307+t306+t305+t304+t303+t302+t301+t300+t
     4           299+t298+t297
              t314 = 1.0d+0*t313*t97+t310
              t315 = 1/rhoa**9.666666666666666d+0
              t316 = 1.061262590976d-4*t104*t125*t45*t49-1.030176d-2*t12
     1           5*t43*t49-1.030176d-2*t125*t43*t48+1.061262590976d-4*ga
     2           mmaaa*t104*t124*t48+3.183787772928d-4*t125*t188*t46*t47
     3           -4.120704d-2*t104*t125*t45*t46+3.183787772928d-4*gammaa
     4           a*t124*t188*t44*t45-2.060352d-2*t104*t125*t44*t45+2.0d+
     5           0*t125*t43*t44-2.060352d-2*gammaaa*t104*t124*t44+3.1837
     6           87772928d-4*t188*t315*t40*t41-4.120704d-2*gammaaa*t104*
     7           t124*t40
              t317 = 1/rhoa**3.3333333333333337d+0
              t318 = 3.72017044624d-5*t107*t125*t57*t61-6.09932d-3*t125*
     1           t55*t61-6.09932d-3*t125*t55*t60+7.44034089248d-5*gammaa
     2           a*t107*t124*t60+1.1160511338720001d-4*t125*t194*t58*t59
     3           -2.439728d-2*t107*t125*t57*t58+2.2321022677440003d-4*ga
     4           mmaaa*t124*t194*t56*t57-1.219864d-2*t107*t125*t56*t57+2
     5           .0d+0*t125*t55*t56-2.439728d-2*gammaaa*t107*t124*t56+4.
     6           4642045354880006d-4*t194*t315*t41*t54-4.879456d-2*gamma
     7           aa*t107*t124*t54
              t319 = 1.0d+0*t318*t53*t97
              t320 = -6.09932d-3*t121*t36*t55*t97
              t321 = -3.04966d-3*t1*t127*t55*t97
              t322 = 3.72017044624d-5*t107*t125*t62*t97
              t323 = 1/taua**3
              t324 = 1/rhoa**8.666666666666666d+0
              t325 = 1/rhoa**6
              t326 = 2.122525181952d-4*t104*t317*t45*t49-4.120704d-2*t31
     1           7*t43*t49+2.122525181952d-4*gammaaa*t104*t325*t48+6.367
     2           575545856d-4*t188*t317*t46*t47-1.6482816d-1*t104*t317*t
     3           45*t46+8.0d+0*t317*t43*t46+6.367575545856d-4*gammaaa*t1
     4           88*t325*t44*t45-8.241408d-2*gammaaa*t104*t325*t44+6.367
     5           575545856d-4*t188*t324*t40*t41
              t327 = 7.44034089248d-5*t107*t317*t57*t61-2.439728d-2*t317
     1           *t55*t61+1.488068178496d-4*gammaaa*t107*t325*t60+2.2321
     2           022677440003d-4*t194*t317*t58*t59-9.758912d-2*t107*t317
     3           *t57*t58+8.0d+0*t317*t55*t58+4.4642045354880006d-4*gamm
     4           aaa*t194*t325*t56*t57-9.758912d-2*gammaaa*t107*t325*t56
     5           +8.928409070976001d-4*t194*t324*t41*t54
              t328 = 1.0d+0*t327*t53*t97
              t329 = -1.219864d-2*t127*t36*t55*t97
              t330 = 7.44034089248d-5*t107*t317*t62*t97
              t331 = 4.824593849607761d+1*t145*t146*t147*t71
              t332 = -6.0d+0*t146*t149*t71*t82
              t333 = 3.0d+0*t152*t71*t82*t88
              t334 = -1.099109305675375d-2*t136*t151*t70
              t335 = -2.6513779981040353d-1*t74*t82*t85*t87*t88
              t336 = t76**3
              t337 = 1/t10**7
              t338 = 1/rhoa**3.1666666666666665d+0
              t339 = t79**3
              t340 = 1.1102230246251565d-16*t21*t72*t77*(-5.620753557770
     1           543d-1*t92-2.520426340996149d+0*t338-1.5008036906238065
     2           d+0*t337-2.3079979182303428d+0*t317)+1.0d+0*t17*t78*t80
     3           *(-7.128507529742789d-1*t92-4.684972743248224d+0*t338-3
     4           .083875829189267d+0*t337-3.9871442462415524d+0*t317)+1.
     5           6995949182667827d-1*t136*t78*t79*t80-1.274696188700087d
     6           -1*t143*t74*t78*t80-6.0d+0*t142*t143*t17*t78*t79+9.6491
     7           87699215522d+1*t139*t141*t143*t17*t79+2.549392377400174
     8           d-1*t140*t142*t74*t78+6.0d+0*t141*t17*t339*t78+1.962413
     9           933653103d-17*t136*t72*t76*t77-1.4718104502398274d-17*t
     :           138*t72*t74*t77-6.661338147750939d-16*t134*t138*t21*t72
     ;           *t76+5.356375176299456d-15*t131*t133*t138*t21*t76+2.943
     <           620900479655d-17*t132*t134*t72*t74-4.0999275947472624d+
     =           0*t139*t140*t141*t74-2.3669625486718335d-16*t131*t132*t
     >           133*t74+6.661338147750939d-16*t133*t21*t336*t72+2.06904
     ?           05167709364d+3*t17*t339/(t14**6*t15**3)-1.9298375398431
     @           045d+2*t139*t17*t339/t14**5+5.742741051503565d-14*t21*t
     1           336/(t18**6*t19**3)-1.0712750352598913d-14*t131*t21*t33
     2           6/t18**5+9.490883560204437d-19*t20*t317+4.1099018897499
     3           934d-3*t16*t317
              t341 = t87**3
              t342 = 5.172601291927341d+2*t341*t71/(t68**6*t69**3)
              t343 = -9.649187699215522d+1*t145*t341*t71/t68**5
              t344 = 6.0d+0*t147*t341*t71*t82
              t345 = 4.824593849607761d+1*t145*t147*t152*t71*t87
              t346 = -6.0d+0*t149*t152*t71*t82*t87
              t347 = 9.921256574801247d-2
              t348 = 1.0d+0*t71*t82*t88*(-4.4260660773166294d-2*t92-1.50
     1           08036906238065d+0*t337/t64**7-2.3079979182303428d+0*t31
     2           7*t347-2.8068057454507694d-1*t338)
              t349 = 8.548627933030694d-3*t317*t347*t70
              t350 = 1/rhoa**3
              t351 = 1.767585332069357d-1*t136*t151*t82*t87*t88
              t352 = 1/t156
              t353 = -1.3595691172479402d+0*t75*t86-7.491972878592053d-1
     1           *t74*t85-2.1504862356383217d-1*t73*t84-1.27434173008489
     2           14d-1*t36*t83
              t354 = 1/t155**2
              t355 = -2.1319703304396778d+0*t145*t146*t147*t74*t85
              t356 = 2.6513779981040353d-1*t146*t149*t74*t82*t85
              t357 = -1.3256889990520176d-1*t152*t74*t82*t85*t88
              t358 = 2*rhoa*(-5.82714947393947d-4*t157*t317*t85+t357+t35
     1           6+t355-7.5d-1*t158*t159*t352*t353*t354+t351-2.533029591
     2           058444d-2*t157*t158*t350+t349+t348+t346+t345+t344+t343+
     3           t342)+2.549392377400174d-1*t74*t78*t79*t80-3.0d+0*t143*
     4           t17*t78*t80+6.0d+0*t140*t142*t17*t78+2.943620900479655d
     5           -17*t72*t74*t76*t77-3.3306690738754696d-16*t138*t21*t72
     6           *t77+6.661338147750939d-16*t132*t134*t21*t72-rhoa*t340+
     7           t335+t334+t333+t332+t331-5.356375176299456d-15*t131*t13
     8           2*t133*t21+1.2202564577405706d-18*t136*t20-9.6491876992
     9           15522d+1*t139*t140*t141*t17+5.284159572535705d-3*t136*t
     :           16+2.5330295910584444d-2*t157*t158*t159
              t359 = gammaaa**4
              t360 = 1/t2**4
              t361 = 1/rhoa**1.3666666666666666d+1
              t362 = 2.101523342222221d-8*t359*t360*t361*t7
              t363 = 1/rhoa**11
              t364 = 2.542165333333332d-6*t162*t163*t164*t95
              t365 = 1/rhoa**8.333333333333334d+0
              t366 = 1/rhoa**5.666666666666667d+0
              t367 = 2.101523342222221d-8*t359*t360*t361*t6
              t368 = 2.542165333333332d-6*t162*t163*t164*t94
              t369 = 2.101523342222221d-8*t359*t360*t361*t5
              t370 = 2.542165333333332d-6*t162*t163*t164*t93
              t371 = 2.101523342222221d-8*t359*t360*t361*t4
              t372 = 1/t25**4
              t373 = t103**3
              t374 = 1/t38**5
              t375 = -3.2592592592592595d+1*t168*taua-4.5629629629629626
     1           d+1*gammaaa*t366
              t376 = -1.7017882504620419d-7*t194*t373*t62*t97
              t377 = 1/t52**5
              t378 = -1.3614306003696336d-6*gammaaa*t1*t373*t377*t56*t57
              t379 = -2.722861200739267d-6*t373*t377*t41*t42*t54
              t380 = -6.807153001848167d-7*t373*t377*t58*t59
              t381 = -4.464204535488d-4*gammaaa*t186*t194*t56*t57*t92
              t382 = -1.1160511338720001d-3*t1*t186*t194*t57*t58*taua
              t383 = -1.7017882504620419d-7*t194*t373*t57*t61
              t384 = -1.7856818141952002d-3*t186*t194*t41*t54*t91
              t385 = -1.1160511338720001d-3*gammaaa*t186*t194*t42*t56*ta
     1           ua
              t386 = -3.4035765009240837d-7*gammaaa*t1*t194*t373*t60
              t387 = -4.066213333333334d-1*t103*t107*t122*t42*t58
              t388 = -1.4880681784959998d-4*gammaaa*t107*t186*t60*t92
              t389 = -1.8600852231200002d-4*t1*t107*t186*t61*taua
              t390 = -6.09932d-3*t103*t108*t89
              t391 = 1.86008522312d-5*t108*t186*t97
              t392 = 1.86008522312d-5*t186*t62*t89
              t393 = -6.09932d-3*t103*t213
              t394 = 2*rhoa*(1.9423831579798237d-4*t157*t317*t85+t357+t3
     1           56+t355+2.5d-1*t158*t159*t352*t353*t354+t351+8.44343197
     2           0194815d-3*t157*t158*t350+t349+t348+t346+t345+t344+t343
     3           +t342)+t335+t334+t333+t332+t331+t214
              t395 = 1.0d+0*t113*t161
              t396 = 1/rhoa**1.2666666666666665d+1
              t397 = -7.880712533333329d-9*t162*t360*t396*t7
              t398 = 8.473884444444441d-7*t112*t162*t163*t164
              t399 = -6.355413333333331d-7*t163*t224*t41*t95
              t400 = -3.2460444444444436d-4*t112*t166*t41*t90
              t401 = -1.9219999999999998d-5*gammaaa*t179*t42*t90
              t402 = 3.0311111111111105d-2*gammaaa*t112*t168*t3
              t403 = -7.880712533333329d-9*t162*t360*t396*t6
              t404 = 8.473884444444441d-7*t111*t162*t163*t164
              t405 = -6.355413333333331d-7*t163*t224*t41*t94
              t406 = -3.2460444444444436d-4*t111*t166*t41*t90
              t407 = -1.9219999999999998d-5*gammaaa*t178*t42*t90
              t408 = 3.0311111111111105d-2*gammaaa*t111*t168*t3
              t409 = -7.880712533333329d-9*t162*t360*t396*t5
              t410 = 8.473884444444441d-7*t110*t162*t163*t164
              t411 = -6.355413333333331d-7*t163*t224*t41*t93
              t412 = -3.2460444444444436d-4*t110*t166*t41*t90
              t413 = -1.9219999999999998d-5*gammaaa*t177*t42*t90
              t414 = 3.0311111111111105d-2*gammaaa*t110*t168*t3
              t415 = -7.880712533333329d-9*t162*t360*t396*t4
              t416 = 3.1d-3*t1*t177*t3
              t417 = 3.1d-3*t1*t178*t3
              t418 = 3.1d-3*t1*t179*t3
              t419 = t114-1.25d-1*gammaaa*t118*t22
              t420 = 1.25d-1*t31*t81
              t421 = 1.25d-1*t102*t22
              t422 = -1.25d-1*t22*t50-1.25d-1*gammaaa*t120*t22
              t423 = 1.86008522312d-5*t107*t121*t186*t97
              t424 = -1.7017882504620419d-7*t1*t186*t194*t62*t97
              t425 = -1.3614306003696336d-6*gammaaa*t186*t377*t42*t56*t5
     1           7
              t426 = -2.722861200739267d-6*t119*t186*t377*t41*t54
              t427 = -6.807153001848167d-7*t1*t186*t377*t58*t59
              t428 = 2.2321022677440003d-4*t119*t189*t194*t41*t54
              t429 = -7.440340892480001d-4*gammaaa*t103*t119*t194*t56*ta
     1           ua
              t430 = 1.1160511338720001d-4*gammaaa*t189*t194*t42*t56*t57
              t431 = -7.440340892480001d-4*t103*t194*t42*t57*t58*taua
              t432 = -1.7017882504620419d-7*t1*t186*t194*t57*t61
              t433 = 5.580255669360001d-5*t1*t186*t194*t56*t57
              t434 = -3.4035765009240837d-7*gammaaa*t186*t194*t42*t60
              t435 = 2.2321022677440003d-4*gammaaa*t186*t194*t42*t54
              t436 = 5.580255669360001d-5*t1*t189*t194*t58*t59
              t437 = 3.72017044624d-5*gammaaa*t107*t189*t42*t60
              t438 = -2.439728d-2*gammaaa*t107*t189*t42*t54
              t439 = -1.2400568154133336d-4*t103*t107*t42*t61*taua
              t440 = 4.066213333333334d-2*t103*t107*t42*t56*taua
              t441 = 1.86008522312d-5*t1*t107*t189*t57*t61
              t442 = -6.09932d-3*t1*t107*t189*t56*t57
              t443 = -1.3554044444444446d-1*t107*t119*t122*t58
              t444 = 1.86008522312d-5*t1*t107*t186*t60
              t445 = -3.04966d-3*t1*t189*t55*t60
              t446 = 1.0d+0*t121*t161
              t447 = -3.04966d-3*t1*t209*t55
              t448 = -3.04966d-3*t121*t189*t97
              t449 = -3.04966d-3*t103*t121*t89
              t450 = 8.132426666666667d-3*t108*t92*t97
              t451 = 8.132426666666667d-3*t62*t89*t92
              t452 = -3.04966d-3*t103*t270
              t453 = -6.09932d-3*t1*t107*t213
              t454 = 8.88888888888889d+0*t55*t56*t91*taua
              t455 = -3.04966d-3*t103*t276*t97
              t456 = 1.0d+0*t281*t89
              t457 = 1/rhoa**1.1666666666666665d+1
              t458 = 2.9552671999999985d-9*t360*t41*t457*t7
              t459 = -6.355413333333331d-7*t112*t163*t224*t41
              t460 = 1.1916399999999999d-7*gammaaa*t119*t163*t95
              t461 = 5.125333333333332d-5*t280*t41*t90*t91
              t462 = -1.9219999999999998d-5*t42*t90*t95
              t463 = -8.266666666666665d-3*gammaaa*t280*t3*t92
              t464 = 2.9552671999999985d-9*t360*t41*t457*t6
              t465 = -6.355413333333331d-7*t111*t163*t224*t41
              t466 = 1.1916399999999999d-7*gammaaa*t119*t163*t94
              t467 = 5.125333333333332d-5*t279*t41*t90*t91
              t468 = -1.9219999999999998d-5*t42*t90*t94
              t469 = -8.266666666666665d-3*gammaaa*t279*t3*t92
              t470 = 2.9552671999999985d-9*t360*t41*t457*t5
              t471 = -6.355413333333331d-7*t110*t163*t224*t41
              t472 = 1.1916399999999999d-7*gammaaa*t119*t163*t93
              t473 = 5.125333333333332d-5*t278*t41*t90*t91
              t474 = -1.9219999999999998d-5*t42*t90*t93
              t475 = -8.266666666666665d-3*gammaaa*t278*t3*t92
              t476 = 2.9552671999999985d-9*t360*t4*t41*t457
              t477 = 2.5d-1*t118*t22
              t478 = 1.25d-1*gammaaa*t22*t288+2.5d-1*t120*t22
              t479 = -1.030176d-2*t252
              t480 = -3.04966d-3*t103*t289*t55*t97
              t481 = -2.722861200739267d-6*t103*t287*t377*t41*t54
              t482 = -1.3614306003696336d-6*gammaaa*t103*t119*t377*t56*t
     1           57
              t483 = -6.807153001848167d-7*t103*t377*t42*t58*t59
              t484 = -3.7201704462400004d-4*gammaaa*t194*t287*t56*taua
              t485 = -3.4035765009240837d-7*gammaaa*t103*t119*t194*t60
              t486 = 4.4642045354880006d-4*gammaaa*t103*t119*t194*t54
              t487 = -3.7201704462400004d-4*t119*t194*t57*t58*taua
              t488 = -1.7017882504620419d-7*t103*t194*t42*t57*t61
              t489 = 1.1160511338720001d-4*t103*t194*t42*t56*t57
              t490 = -6.200284077066668d-5*t107*t119*t61*taua
              t491 = 4.066213333333334d-2*t107*t119*t56*taua
              t492 = 3.72017044624d-5*t103*t107*t42*t60
              t493 = -1.219864d-2*t103*t107*t42*t54
              t494 = 1.0d+0*t289*t89
              t495 = 3.72017044624d-5*t1*t103*t107*t121*t97
              t496 = -1.7017882504620419d-7*t103*t194*t42*t62*t97
              t497 = 1.86008522312d-5*t107*t109*t42
              t498 = 1.0d+0*(6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*
     1           (-5.766d-5*gammaaa*t278*t42*t90-5.766d-5*t110*t42*t90-1
     2           .1082252d-9*gammaaa*t287*t360*t5+1.78746d-7*t119*t163*t
     3           5+6.2d-3*gammaaa*t1*t3*(1.78746d-7*t119*t163*t4-1.10822
     4           52d-9*gammaaa*t287*t360*t4)+9.299999999999999d-3*t1*t27
     5           8*t3+3.57492d-7*gammaaa*t110*t119*t163)-5.766d-5*gammaa
     6           a*t279*t42*t90-5.766d-5*t111*t42*t90-1.1082252d-9*gamma
     7           aa*t287*t360*t6+1.78746d-7*t119*t163*t6+9.2999999999999
     8           99d-3*t1*t279*t3+3.57492d-7*gammaaa*t111*t119*t163)-5.7
     9           66d-5*gammaaa*t280*t42*t90-5.766d-5*t112*t42*t90-1.1082
     :           252d-9*gammaaa*t287*t360*t7+1.78746d-7*t119*t163*t7+9.2
     ;           99999999999999d-3*t1*t280*t3+3.57492d-7*gammaaa*t112*t1
     <           19*t163)*t97
              t499 = 1/rhoa**1.3333333333333333d+1
              t500 = 1.0d+0*t53*(-1.7017882504620419d-7*t119*t194*t57*t6
     1           1-3.4035765009240837d-7*gammaaa*t194*t287*t60+5.5802556
     2           69359999d-5*t107*t119*t60-6.807153001848167d-7*t119*t37
     3           7*t58*t59-1.3614306003696336d-6*gammaaa*t287*t377*t56*t
     4           57+1.6740767008080004d-4*t119*t194*t56*t57-2.7228612007
     5           39267d-6*t377*t41*t499*t54+6.696306803232002d-4*gammaaa
     6           *t194*t287*t54-3.6595920000000004d-2*t107*t119*t54)*t97
              t501 = -9.148980000000001d-3*t1*t289*t55*t97
              t502 = 5.580255669359999d-5*t107*t121*t42*t97
              t503 = -1.7017882504620419d-7*t119*t194*t62*t97
              t504 = 1.86008522312d-5*t107*t127*t186*t97
              t505 = -3.4035765009240837d-7*t186*t194*t36*t62*t97
              t506 = -2.722861200739267d-6*gammaaa*t125*t186*t377*t56*t5
     1           7
              t507 = -5.445722401478534d-6*t124*t186*t377*t41*t54
              t508 = -1.3614306003696336d-6*t186*t36*t377*t58*t59
              t509 = 4.4642045354880006d-4*t124*t189*t194*t41*t54
              t510 = -1.4880681784960004d-3*gammaaa*t103*t124*t194*t56*t
     1           aua
              t511 = 2.2321022677440003d-4*gammaaa*t125*t189*t194*t56*t5
     1           7
              t512 = -1.4880681784960004d-3*t103*t125*t194*t57*t58*taua
              t513 = -3.4035765009240837d-7*t186*t194*t36*t57*t61
              t514 = 2.2321022677440003d-4*t186*t194*t36*t57*t58
              t515 = -6.807153001848167d-7*gammaaa*t125*t186*t194*t60
              t516 = 2.2321022677440003d-4*gammaaa*t125*t186*t194*t56
              t517 = 1.1160511338720001d-4*t189*t194*t36*t58*t59
              t518 = 7.44034089248d-5*gammaaa*t107*t125*t189*t60
              t519 = -2.439728d-2*gammaaa*t107*t125*t189*t56
              t520 = -2.4801136308266672d-4*t103*t107*t125*t61*taua
              t521 = 1.6264853333333334d-1*t103*t107*t125*t58*taua
              t522 = 3.72017044624d-5*t107*t189*t36*t57*t61
              t523 = -2.439728d-2*t107*t189*t36*t57*t58
              t524 = -2.710808888888889d-1*t107*t122*t124*t58
              t525 = 3.72017044624d-5*t107*t186*t36*t61
              t526 = -6.09932d-3*t189*t36*t55*t61
              t527 = 1.0d+0*t127*t161
              t528 = -6.09932d-3*t209*t36*t55
              t529 = -3.04966d-3*t127*t189*t97
              t530 = -3.04966d-3*t103*t127*t89
              t531 = 1.0165533333333335d-2*t1*t108*t97
              t532 = 1.0165533333333335d-2*t1*t62*t89
              t533 = -3.04966d-3*t103*t311
              t534 = -1.219864d-2*t107*t213*t36
              t535 = -3.04966d-3*t103*t313*t97
              t536 = -3.04966d-3*t103*t318*t55*t97
              t537 = -5.445722401478534d-6*t103*t315*t377*t41*t54
              t538 = -2.722861200739267d-6*gammaaa*t103*t124*t377*t56*t5
     1           7
              t539 = -1.3614306003696336d-6*t103*t125*t377*t58*t59
              t540 = -7.440340892480001d-4*gammaaa*t194*t315*t56*taua
              t541 = -6.807153001848167d-7*gammaaa*t103*t124*t194*t60
              t542 = 4.4642045354880006d-4*gammaaa*t103*t124*t194*t54
              t543 = 2.2321022677440003d-4*gammaaa*t103*t124*t194*t56
              t544 = -7.440340892480001d-4*t124*t194*t57*t58*taua
              t545 = -3.4035765009240837d-7*t103*t125*t194*t57*t61
              t546 = 1.1160511338720001d-4*t103*t125*t194*t56*t57
              t547 = 2.2321022677440003d-4*t103*t125*t194*t57*t58
              t548 = -1.2400568154133336d-4*t107*t124*t61*taua
              t549 = 4.066213333333334d-2*t107*t124*t56*taua
              t550 = 8.132426666666668d-2*t107*t124*t58*taua
              t551 = 3.72017044624d-5*t103*t107*t125*t60
              t552 = 3.72017044624d-5*t103*t107*t125*t61
              t553 = -1.219864d-2*t103*t107*t125*t56
              t554 = 1.0d+0*t318*t89
              t555 = 3.72017044624d-5*t103*t107*t121*t36*t97
              t556 = 1.86008522312d-5*t1*t103*t107*t127*t97
              t557 = 8.132426666666667d-3*t127*t55*t92*t97
              t558 = -3.4035765009240837d-7*t103*t125*t194*t62*t97
              t559 = -6.09932d-3*t270*t36*t55
              t560 = 3.72017044624d-5*t107*t109*t125
              t561 = -3.04966d-3*t1*t314*t55
              t562 = -6.09932d-3*t277*t36*t55
              t563 = 1/rhoa**1.2333333333333334d+1
              t564 = 1.0d+0*t53*(-3.4035765009240837d-7*t124*t194*t57*t6
     1           1+3.72017044624d-5*t107*t124*t61-6.807153001848167d-7*g
     2           ammaaa*t194*t315*t60+7.44034089248d-5*t107*t124*t60-1.3
     3           614306003696336d-6*t124*t377*t58*t59+2.2321022677440003
     4           d-4*t124*t194*t57*t58-2.722861200739267d-6*gammaaa*t315
     5           *t377*t56*t57+2.2321022677440003d-4*t124*t194*t56*t57-5
     6           .445722401478534d-6*t377*t41*t54*t563+2.232102267744000
     7           3d-4*gammaaa*t194*t315*t56-2.439728d-2*t107*t124*t56+8.
     8           928409070976001d-4*gammaaa*t194*t315*t54-2.439728d-2*t1
     9           07*t124*t54)*t97
              t565 = -6.09932d-3*t289*t36*t55*t97
              t566 = -6.09932d-3*t1*t318*t55*t97
              t567 = 7.44034089248d-5*t107*t121*t125*t97
              t568 = 1.86008522312d-5*t107*t127*t42*t97
              t569 = -3.4035765009240837d-7*t124*t194*t62*t97
              t570 = (t569+t568+t567+t566+t565+t564)*wght
              t571 = 1/taua**4
              t572 = 1/rhoa**1.0333333333333333d+1
              t573 = 1/rhoa**7.666666666666667d+0
              t574 = 1/rhoa**5
              t575 = 1.0d+0*t53*(-1.3614306003696336d-6*t194*t57*t574*t6
     1           1+4.4642045354879994d-4*t107*t574*t61-2.722861200739267
     2           d-6*gammaaa*t194*t573*t60-5.445722401478534d-6*t377*t57
     3           4*t58*t59+2.678522721292801d-3*t194*t57*t574*t58-2.9276
     4           736000000003d-1*t107*t574*t58-1.0891444802957069d-5*gam
     5           maaa*t377*t56*t57*t573+2.678522721292801d-3*gammaaa*t19
     6           4*t56*t573-2.1782889605914138d-5*t377*t41*t54*t572)*t97
              t576 = -1.8297960000000002d-2*t327*t36*t55*t97
              t577 = 2.2321022677439997d-4*t107*t127*t317*t97
              t578 = -1.3614306003696336d-6*t194*t574*t62*t97
              fnc(iq) = (1.0d+0*t24*t8+1.0d+0*t24*t53*t62+2.0d+0*rhoa*t2
     1           2*t35*t39*t50+1.0d+0*rhoa*t22*t31*t32*t34)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t96*t97-3.04966d-3*t103*t55*t62*t
     1           97+1.0d+0*t8*t89+t32*(5.0d-1*rhoa*t31*t34*t81+5.0d-1*t2
     2           2*t31*t34+5.0d-1*rhoa*t102*t22*t34)+t109*t53-5.15088d-3
     3           *rhoa*t103*t22*t35*t43*t50+1.25d-1*gammaaa*t22*t32*t33*
     4           t39*t50+t106*t39+1.25d-1*gammaaa*t22*t31*t32*t33)*wght+
     5           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (-3.04966d-3*t1*t55*t62*t97+1.0d+0*t121*
     1           t53*t97+1.0d+0*t113*t97-5.15088d-3*t22*t35*t36*t43*t50-
     2           1.25d-1*t22*t32*t39*t50+1.0d+0*rhoa*t120*t22*t35*t39+t3
     3           2*(5.0d-1*rhoa*t118*t22*t34+t114))*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (-6.09932d-3*t36*t55*t62*t97+1.0d+0*t127*
     1           t53*t97-1.030176d-2*t22*t35*t43*t50*t9+1.25d-1*gammaaa*
     2           t123*t22*t39*t50+1.0d+0*rhoa*t126*t22*t35*t39-5.0d-1*rh
     3           oa*t123*t22*t31*t34+1.0d+0*rhoa*t22*t31*t32)*wght+Mmat(
     4           iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t180*t97+t32*(1.0d+0*t31*t34*
     1           t81+1.0d+0*rhoa*t102*t34*t81+1.25d-1*gammaaa*t31*t33*t8
     2           1+5.0d-1*rhoa*t144*t31*t34+5.0d-1*rhoa*t185*t22*t34+1.0
     3           d+0*t102*t22*t34+1.25d-1*gammaaa*t102*t22*t33+1.25d-1*g
     4           ammaaa*t159*t22*t31)+t32*t33*(1.25d-1*gammaaa*t31*t81+1
     5           .25d-1*gammaaa*t102*t22)+1.0d+0*t161*t8+t213*t55+t209*t
     6           53-1.28772d-3*gammaaa*t103*t22*t32*t33*t43*t50-1.25d-1*
     7           gammaaa*t159*t22*t32*t39*t50+5.30631295488d-5*rhoa*t104
     8           *t186*t22*t35*t50+t192*t43+t187*t32*t33*t39+t191*t39-1.
     9           25d-1*gammaaa*t159*t22*t31*t32+t193+t128)*wght+Amat2(iq
     :           ,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t219*t97+1.0d+0*t215*t8+t222*
     1           t55+t221*t53+t193+t128)*wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = (8.132426666666667d-3*t55*t62*t92*t9
     1           7+1.0d+0*t244*t97-6.4386d-4*gammaaa*t22*t32*t43*t50*t92
     2           +t32*(5.0d-1*rhoa*t118*t34*t81-1.25d-1*t31*t81+5.0d-1*r
     3           hoa*t22*t249*t34+5.0d-1*t118*t22*t34-1.25d-1*t22*t31*t3
     4           3-1.25d-1*t102*t22)+t270*t53+6.4386d-4*t103*t22*t32*t43
     5           *t50+5.30631295488d-5*t103*t104*t22*t35*t36*t50-5.15088
     6           d-3*rhoa*t103*t120*t22*t35*t43+t1*t253*t43+t250*t32*t33
     7           *t39+t252*t39+(t245+1.25d-1*gammaaa*t118*t22)*t32*t33+t
     8           271+t255+t254+t223)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t275*t97+t277*t53+t271+t255+
     1           t254+t223)*wght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = (1.28772d-3*t1*t22*t32*t43*t50+5.30
     1           631295488d-5*t104*t125*t22*t35*t50-1.030176d-2*t120*t22
     2           *t35*t36*t43+1.0d+0*rhoa*t22*t288*t35*t39-2.5d-1*t120*t
     3           22*t32*t39+t32*(5.0d-1*rhoa*t22*t286*t34-2.5d-1*t118*t2
     4           2)+t292+t291+t290+t282)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = (t292+t291+t290+t282)*wght+Cmat2(iq
     1           ,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = (1.0165533333333335d-2*t1*t55*t62*t97
     1           +1.061262590976d-4*t103*t104*t22*t35*t50*t9+t123*(-5.0d
     2           -1*rhoa*t31*t34*t81-5.0d-1*t22*t31*t34-5.0d-1*rhoa*t102
     3           *t22*t34)+t32*(1.0d+0*rhoa*t31*t81+1.0d+0*t22*t31+1.0d+
     4           0*rhoa*t102*t22)+t311*t53+t36*t43*(1.7169600000000002d-
     5           2*t22*t35*t50-1.030176d-2*t106)-1.28772d-3*gammaaa*t1*t
     6           22*t32*t43*t50-6.4386d-4*gammaaa*t103*t123*t22*t43*t50-
     7           1.25d-1*gammaaa*t123*t22*t33*t39*t50-5.15088d-3*rhoa*t1
     8           03*t126*t22*t35*t43+1.25d-1*gammaaa*t126*t22*t32*t33*t3
     9           9+t294*t39-1.25d-1*gammaaa*t123*t22*t31*t33+t312+t296+t
     :           295)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = (t314*t53+t312+t296+t295)*wght+Mmat2(
     1           iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = (-1.030176d-2*t120*t22*t35*t43*t9+1.
     1           28772d-3*t22*t32*t36*t43*t50-6.4386d-4*gammaaa*t1*t123*
     2           t22*t43*t50+1.061262590976d-4*t104*t22*t317*t35*t50-5.1
     3           5088d-3*t126*t22*t35*t36*t43+1.0d+0*rhoa*t22*t316*t35*t
     4           39-1.25d-1*t126*t22*t32*t39+t123*t250*t39+t123*(t245-5.
     5           0d-1*rhoa*t118*t22*t34)+t322+t321+t320+1.0d+0*rhoa*t118
     6           *t22*t32+t319)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = (t322+t321+t320+t319)*wght+Mmat2(iq,
     1           D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = (-2.060352d-2*t126*t22*t35*t43*t9-2.5
     1           7544d-3*gammaaa*t123*t22*t36*t43*t50-2.5d-1*gammaaa*t22
     2           *t323*t39*t50+2.122525181952d-4*t104*t136*t22*t35*t50+1
     3           .0d+0*rhoa*t22*t326*t35*t39+2.5d-1*gammaaa*t123*t126*t2
     4           2*t39+1.0d+0*rhoa*t22*t31*t323*t34+t330+t329+t328-2.0d+
     5           0*rhoa*t123*t22*t31)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = (t330+t329+t328)*wght+Mmat2(iq,D2_TA_
     1           TB)
              Amat3(iq,D3_RA_RA_RA) = (t53*(1.0d+0*t97*(-8.1324266666666
     1           68d-2*t103*t55*t61*t92*taua-3.252970666666667d-1*t103*t
     2           107*t57*t58*t92*taua-6.505941333333334d-1*gammaaa*t103*
     3           t107*t56*t91*taua+3.04966d-2*t1*t189*t55*t61*taua-3.259
     4           2592592592595d+1*t168*t53*t61*taua-6.518518518518519d+1
     5           *t168*t55*t57*t58*taua+1.2198640000000001d-1*t1*t107*t1
     6           89*t57*t58*taua-2.340740740740741d+2*gammaaa*t166*t55*t
     7           56*taua+1.2198640000000001d-1*gammaaa*t107*t189*t42*t56
     8           *taua+2.439728d-2*gammaaa*t189*t55*t60*t92+4.879456d-2*
     9           gammaaa*t107*t189*t56*t57*t92-1.777777777777778d+2*t122
     :           *t55*t58*t91+1.9517824d-1*t107*t189*t41*t54*t91-3.04966
     ;           d-3*t375*t55*t57*t61+5.580255669359999d-5*t103*t107*t18
     <           9*t57*t61-6.09932d-3*gammaaa*t1*t375*t55*t60-8.94566933
     =           3333333d-2*gammaaa*t103*t168*t55*t60-4.5629629629629626
     >           d+1*gammaaa*t366*t53*t60+1.1160511338719999d-4*gammaaa*
     ?           t1*t103*t107*t189*t60-6.09932d-3*t107*t375*t58*t59+1.67
     @           40767008080004d-4*t103*t189*t194*t58*t59-4.562962962962
     1           9626d+1*gammaaa*t366*t55*t56*t57-1.219864d-2*gammaaa*t1
     2           *t107*t375*t56*t57+3.348153401616001d-4*gammaaa*t1*t103
     3           *t189*t194*t56*t57-1.7891338666666665d-1*gammaaa*t103*t
     4           107*t168*t56*t57-3.3896296296296297d+2*t365*t41*t54*t55
     5           -2.439728d-2*t107*t375*t41*t42*t54+6.696306803232002d-4
     6           *t103*t189*t194*t41*t42*t54-9.758912d-1*t103*t107*t166*
     7           t41*t54+t389+t388+t387+t386+t385+t384+t383+t382+t381+t3
     8           80+t379+t378)+3.0d+0*t207*t89+1.0d+0*t358*t62+3.0d+0*t1
     9           08*t161)+t39*(1.0d+0*rhoa*t22*t35*(-1.373568d-1*t103*t4
     :           3*t49*t92*taua-5.494272d-1*t103*t104*t45*t46*t92*taua-8
     ;           .241408d-1*gammaaa*t103*t104*t44*t91*taua+5.15088d-2*t1
     <           *t189*t43*t49*taua-3.2592592592592595d+1*t168*t39*t49*t
     =           aua-5.30631295488d-4*t1*t104*t186*t49*taua-6.5185185185
     >           18519d+1*t168*t43*t45*t46*taua+2.060352d-1*t1*t104*t189
     ?           *t45*t46*taua-3.183787772928d-3*t1*t186*t188*t45*t46*ta
     @           ua-2.0148148148148146d+2*gammaaa*t166*t43*t44*taua+1.03
     1           0176d-1*gammaaa*t104*t189*t42*t44*taua-1.591893886464d-
     2           3*gammaaa*t186*t188*t42*t44*taua+4.120704d-2*gammaaa*t1
     3           89*t43*t48*t92-4.245050363904d-4*gammaaa*t104*t186*t48*
     4           t92+8.241408d-2*gammaaa*t104*t189*t44*t45*t92-1.2735151
     5           091712002d-3*gammaaa*t186*t188*t44*t45*t92-1.7777777777
     6           77778d+2*t122*t43*t46*t91+1.6482816d-1*t104*t189*t40*t4
     7           1*t91-2.5470302183424004d-3*t186*t188*t40*t41*t91-5.150
     8           88d-3*t375*t43*t45*t49-8.199654381909689d-7*t188*t373*t
     9           45*t49+1.591893886464d-4*t103*t104*t189*t45*t49-5.15088
     :           d-3*gammaaa*t1*t375*t43*t48-1.5109248d-1*gammaaa*t103*t
     ;           168*t43*t48-4.5629629629629626d+1*gammaaa*t366*t39*t48-
     <           8.199654381909689d-7*gammaaa*t1*t188*t373*t48+1.5918938
     =           86464d-4*gammaaa*t1*t103*t104*t189*t48-1.030176d-2*t104
     >           *t375*t46*t47-3.2798617527638757d-6*t373*t374*t46*t47+4
     ?           .7756816593920004d-4*t103*t188*t189*t46*t47-6.867840000
     @           000001d-1*t103*t104*t122*t42*t46-4.5629629629629626d+1*
     1           gammaaa*t366*t43*t44*t45-1.030176d-2*gammaaa*t1*t104*t3
     2           75*t44*t45-3.2798617527638757d-6*gammaaa*t1*t373*t374*t
     3           44*t45+4.7756816593920004d-4*gammaaa*t1*t103*t188*t189*
     4           t44*t45-3.0218496d-1*gammaaa*t103*t104*t168*t44*t45-2.4
     5           77037037037037d+2*t365*t40*t41*t43-1.030176d-2*t104*t37
     6           5*t40*t41*t42-3.2798617527638757d-6*t373*t374*t40*t41*t
     7           42+4.7756816593920004d-4*t103*t188*t189*t40*t41*t42-1.0
     8           439116799999999d+0*t103*t104*t166*t40*t41)+2.5d-1*gamma
     9           aa*t159*t32*t50*t81+3.0d+0*rhoa*t190*t35*t81+6.0d+0*t10
     :           5*t35*t81+5.0d-1*gammaaa*t105*t32*t33*t81-2.5d-1*gammaa
     ;           a*t22*t32*t350*t50+1.0d+0*rhoa*t340*t35*t50+3.0d+0*t144
     <           *t35*t50+2.5d-1*gammaaa*t144*t32*t33*t50+3.0d+0*t190*t2
     =           2*t35+3.0d+0*rhoa*t105*t144*t35+2.5d-1*gammaaa*t190*t22
     >           *t32*t33+2.5d-1*gammaaa*t105*t159*t22*t32)+t32*(5.0d-1*
     ?           rhoa*t22*t34*(6.0d-2*gammaaa*t1*t26*(6.0d-2*gammaaa*t1*
     @           t26*(-2.5919999999999993d-1*t166*t41*t98*t99+1.76d+0*ga
     1           mmaaa*t168*t26*t99+9.215999999999996d-3*t162*t164*t181*
     2           t99+6.0d-2*gammaaa*t1*t26*(7.274666666666665d-1*t27*t36
     3           5*t41*t98+1.4745599999999992d-3*t27*t359*t361*t372-2.73
     4           7777777777778d+0*gammaaa*t26*t27*t366-5.836799999999998
     5           d-2*t162*t181*t27*t363)+2.879999999999999d-2*t182*t41*t
     6           91*t98+7.274666666666665d-1*t28*t365*t41*t98-4.79999999
     7           9999999d-1*gammaaa*t182*t26*t92+1.4745599999999992d-3*t
     8           28*t359*t361*t372-2.737777777777778d+0*gammaaa*t26*t28*
     9           t366-5.836799999999998d-2*t162*t181*t28*t363)+2.8799999
     :           99999999d-2*t183*t41*t91*t98+7.274666666666665d-1*t29*t
     ;           365*t41*t98-2.5919999999999993d-1*t100*t166*t41*t98-4.7
     <           99999999999999d-1*gammaaa*t183*t26*t92+1.47455999999999
     =           92d-3*t29*t359*t361*t372-2.737777777777778d+0*gammaaa*t
     >           26*t29*t366-5.836799999999998d-2*t162*t181*t29*t363+1.7
     ?           6d+0*gammaaa*t100*t168*t26+9.215999999999996d-3*t100*t1
     @           62*t164*t181)+2.879999999999999d-2*t184*t41*t91*t98+7.2
     1           74666666666665d-1*t30*t365*t41*t98-2.5919999999999993d-
     2           1*t101*t166*t41*t98-4.799999999999999d-1*gammaaa*t184*t
     3           26*t92+1.4745599999999992d-3*t30*t359*t361*t372-2.73777
     4           7777777778d+0*gammaaa*t26*t30*t366-5.836799999999998d-2
     5           *t162*t181*t30*t363+1.76d+0*gammaaa*t101*t168*t26+9.215
     6           999999999996d-3*t101*t162*t164*t181)+1.5d+0*rhoa*t185*t
     7           34*t81+3.0d+0*t102*t34*t81+5.0d-1*gammaaa*t102*t33*t81+
     8           2.5d-1*gammaaa*t159*t31*t81-2.5d-1*gammaaa*t22*t31*t350
     9           +5.0d-1*rhoa*t31*t34*t340+1.5d+0*t144*t31*t34+1.5d+0*t1
     :           85*t22*t34+1.5d+0*rhoa*t102*t144*t34+2.5d-1*gammaaa*t14
     ;           4*t31*t33+2.5d-1*gammaaa*t185*t22*t33+2.5d-1*gammaaa*t1
     <           02*t159*t22)+t55*(-3.04966d-3*t375*t62*t97-3.04966d-3*t
     =           103*t207*t97-6.09932d-3*t108*t189*t97-6.09932d-3*t189*t
     >           62*t89-3.04966d-3*t103*t161*t62+t390-6.09932d-3*t103*t2
     ?           09-3.04966d-3*t109*t189)+t107*(3.72017044624d-5*t103*t1
     @           89*t62*t97+t393+t392+t391)+1.0d+0*(-9.73813333333333d-4
     1           *t166*t41*t90*t95+9.093333333333331d-2*gammaaa*t168*t3*
     2           t95+6.2d-3*gammaaa*t1*t3*(-9.73813333333333d-4*t166*t41
     3           *t90*t94+9.093333333333331d-2*gammaaa*t168*t3*t94+6.2d-
     4           3*gammaaa*t1*t3*(-9.73813333333333d-4*t166*t41*t90*t93+
     5           9.093333333333331d-2*gammaaa*t168*t3*t93-2.479999999999
     6           9994d-2*gammaaa*t177*t3*t92+1.5375999999999995d-4*t177*
     7           t41*t90*t91+6.2d-3*gammaaa*t1*t3*(2.3804325925925923d-3
     8           *t365*t4*t41*t90-1.4145185185185183d-1*gammaaa*t3*t366*
     9           t4-1.271082666666666d-5*t162*t163*t363*t4+t371)+2.38043
     :           25925925923d-3*t365*t41*t5*t90-1.4145185185185183d-1*ga
     ;           mmaaa*t3*t366*t5-1.271082666666666d-5*t162*t163*t363*t5
     <           +t370+t369)-2.4799999999999994d-2*gammaaa*t178*t3*t92+1
     =           .5375999999999995d-4*t178*t41*t90*t91+2.380432592592592
     >           3d-3*t365*t41*t6*t90-1.4145185185185183d-1*gammaaa*t3*t
     ?           366*t6-1.271082666666666d-5*t162*t163*t363*t6+t368+t367
     @           )-2.4799999999999994d-2*gammaaa*t179*t3*t92+1.537599999
     1           9999995d-4*t179*t41*t90*t91+2.3804325925925923d-3*t365*
     2           t41*t7*t90-1.4145185185185183d-1*gammaaa*t3*t366*t7-1.2
     3           71082666666666d-5*t162*t163*t363*t7+t364+t362)*t97+3.0d
     4           +0*t161*t96+3.0d+0*t180*t89+t43*(-1.030176d-2*rhoa*t189
     5           *t35*t50*t81-1.030176d-2*t103*t35*t50*t81-6.4386d-4*gam
     6           maaa*t103*t32*t33*t50*t81-1.030176d-2*rhoa*t103*t105*t3
     7           5*t81-5.15088d-3*rhoa*t22*t35*t375*t50-1.030176d-2*t189
     8           *t22*t35*t50-5.15088d-3*rhoa*t103*t144*t35*t50-6.4386d-
     9           4*gammaaa*t189*t22*t32*t33*t50-6.4386d-4*gammaaa*t103*t
     :           159*t22*t32*t50-5.15088d-3*rhoa*t103*t190*t22*t35-1.030
     ;           176d-2*rhoa*t105*t189*t22*t35-1.030176d-2*t103*t105*t22
     <           *t35-6.4386d-4*gammaaa*t103*t105*t22*t32*t33-1.030176d-
     =           2*t103*t191-5.15088d-3*t106*t189)+t104*(5.30631295488d-
     >           5*rhoa*t186*t35*t50*t81+1.061262590976d-4*rhoa*t103*t18
     ?           9*t22*t35*t50+5.30631295488d-5*t186*t22*t35*t50+5.30631
     @           295488d-5*rhoa*t105*t186*t22*t35-1.030176d-2*t103*t192)
     1           +t32*t33*t43*(-1.28772d-3*gammaaa*t103*t50*t81-1.28772d
     2           -3*gammaaa*t189*t22*t50-1.28772d-3*gammaaa*t103*t105*t2
     3           2-5.15088d-3*t103*t187)+t159*t32*t39*(-2.5d-1*gammaaa*t
     4           50*t81-2.5d-1*gammaaa*t105*t22)+t159*t32*(-2.5d-1*gamma
     5           aa*t31*t81-2.5d-1*gammaaa*t102*t22)+t32*t33*t39*(2.5d-1
     6           *gammaaa*t105*t81+1.25d-1*gammaaa*t144*t50+1.25d-1*gamm
     7           aaa*t190*t22)+t32*t33*(2.5d-1*gammaaa*t102*t81+1.25d-1*
     8           gammaaa*t144*t31+1.25d-1*gammaaa*t185*t22)+1.0d+0*t358*
     9           t8+1.93158d-3*gammaaa*t103*t159*t22*t32*t43*t50+2.5d-1*
     :           gammaaa*t22*t32*t350*t39*t50-8.199654381909689d-7*rhoa*
     ;           t188*t22*t35*t373*t50+1.9898673580800003d-5*gammaaa*t10
     <           4*t186*t22*t32*t33*t50+t376+2.5d-1*gammaaa*t22*t31*t32*
     =           t350)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (t53*(1.0d+0*t97*(-2.7108088888888
     1           89d-2*t103*t55*t61*t92*taua-1.0843235555555557d-1*t103*
     2           t107*t57*t58*t92*taua-4.3372942222222227d-1*gammaaa*t10
     3           3*t107*t56*t91*taua+1.0165533333333335d-2*t1*t189*t55*t
     4           61*taua+4.066213333333334d-2*t1*t107*t189*t57*t58*taua-
     5           5.62962962962963d+1*gammaaa*t166*t55*t56*taua+4.0662133
     6           33333334d-2*gammaaa*t107*t189*t42*t56*taua+8.1324266666
     7           66667d-3*gammaaa*t189*t55*t60*t92+1.6264853333333332d-2
     8           *gammaaa*t107*t189*t56*t57*t92-5.925925925925927d+1*t12
     9           2*t55*t58*t91+6.505941333333333d-2*t107*t189*t41*t54*t9
     :           1+1.86008522312d-5*t103*t107*t189*t57*t61-2.98188977777
     ;           7778d-2*gammaaa*t103*t168*t55*t60+3.72017044624d-5*gamm
     <           aaa*t1*t103*t107*t189*t60+5.580255669360001d-5*t103*t18
     =           9*t194*t58*t59+1.1160511338720001d-4*gammaaa*t1*t103*t1
     >           89*t194*t56*t57-5.963779555555556d-2*gammaaa*t103*t107*
     ?           t168*t56*t57-5.214814814814814d+1*t365*t41*t54*t55+2.23
     @           21022677440003d-4*t103*t189*t194*t41*t42*t54-4.98788835
     1           55555553d-1*t103*t107*t166*t41*t54+t389+t388+t387+t386+
     2           t385+t384+t383+t382+t381+t380+t379+t378)+2.0d+0*t220*t8
     3           9+1.0d+0*t207*t89+1.0d+0*t394*t62+2.0d+0*t108*t215+1.0d
     4           +0*t108*t161)+t55*(-3.04966d-3*t103*t220*t97-3.04966d-3
     5           *t108*t189*t97-3.04966d-3*t189*t62*t89-3.04966d-3*t103*
     6           t215*t62+t390-3.04966d-3*t103*t221-3.04966d-3*t103*t209
     7           )+1.0d+0*(-5.979555555555554d-4*t166*t41*t90*t95+3.0311
     8           111111111105d-2*gammaaa*t168*t3*t95+6.2d-3*gammaaa*t1*t
     9           3*(-5.979555555555554d-4*t166*t41*t90*t94+3.03111111111
     :           11105d-2*gammaaa*t168*t3*t94+6.2d-3*gammaaa*t1*t3*(-5.9
     ;           79555555555554d-4*t166*t41*t90*t93+3.0311111111111105d-
     <           2*gammaaa*t168*t3*t93-1.653333333333333d-2*gammaaa*t216
     =           *t3*t92-8.266666666666665d-3*gammaaa*t177*t3*t92+1.0250
     >           666666666663d-4*t216*t41*t90*t91+5.125333333333332d-5*t
     ?           177*t41*t90*t91+6.2d-3*gammaaa*t1*t3*(5.011437037037035
     @           d-4*t365*t4*t41*t90-6.496644740740738d-6*t162*t163*t363
     1           *t4+t371)+5.011437037037035d-4*t365*t41*t5*t90-6.496644
     2           740740738d-6*t162*t163*t363*t5+t370+t369)-1.65333333333
     3           3333d-2*gammaaa*t217*t3*t92-8.266666666666665d-3*gammaa
     4           a*t178*t3*t92+1.0250666666666663d-4*t217*t41*t90*t91+5.
     5           125333333333332d-5*t178*t41*t90*t91+5.011437037037035d-
     6           4*t365*t41*t6*t90-6.496644740740738d-6*t162*t163*t363*t
     7           6+t368+t367)-1.653333333333333d-2*gammaaa*t218*t3*t92-8
     8           .266666666666665d-3*gammaaa*t179*t3*t92+1.0250666666666
     9           663d-4*t218*t41*t90*t91+5.125333333333332d-5*t179*t41*t
     :           90*t91+5.011437037037035d-4*t365*t41*t7*t90-6.496644740
     ;           740738d-6*t162*t163*t363*t7+t364+t362)*t97+2.0d+0*t215*
     <           t96+1.0d+0*t161*t96+2.0d+0*t219*t89+1.0d+0*t180*t89+1.0
     =           d+0*t394*t8+t107*(t393+t392+t391)+t376)*wght+Amat3(iq,D
     >           3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t53*(1.0d+0*t97*(-8.132426666666
     1           668d-2*t55*t61*t91*taua-3.252970666666667d-1*t107*t57*t
     2           58*t91*taua+2.6666666666666666d+1*t55*t56*t91*taua-4.33
     3           72942222222227d-1*gammaaa*t107*t224*t56*taua-9.92045452
     4           3306665d-5*t103*t107*t57*t61*t92+1.6264853333333332d-2*
     5           t103*t55*t60*t92-2.976136356992001d-4*t103*t194*t58*t59
     6           *t92+3.2529706666666663d-2*t103*t107*t56*t57*t92-2.9761
     7           363569919996d-4*gammaaa*t103*t107*t60*t91-8.92840907097
     8           6001d-4*gammaaa*t103*t194*t56*t57*t91+1.9517824d-1*gamm
     9           aaa*t103*t107*t54*t91-2.981889777777778d-2*t168*t55*t57
     :           *t61-1.3282963555555555d-1*gammaaa*t166*t55*t60+9.77777
     ;           7777777779d+0*t168*t53*t60-5.963779555555556d-2*t107*t1
     <           68*t58*t59+9.777777777777779d+0*t168*t55*t56*t57-2.6565
     =           92711111111d-1*gammaaa*t107*t166*t56*t57+8.711111111111
     >           112d+1*gammaaa*t166*t54*t55-2.3809090855936005d-3*t103*
     ?           t194*t224*t41*t54-9.108317866666666d-1*t107*t164*t41*t5
     @           4+t445+t444+t443+t442+t441+t440+t439+t438+t437+t436+t43
     1           5+t434+t433+t432+t431+t430+t429+t428+t427+t426+t425)+2.
     2           0d+0*t268*t89+t446)+t39*(1.0d+0*rhoa*t22*t35*(-1.373568
     3           d-1*t43*t49*t91*taua-5.494272d-1*t104*t45*t46*t91*taua+
     4           2.6666666666666666d+1*t43*t44*t91*taua-3.53754196992d-4
     5           *t103*t104*t42*t49*taua-2.122525181952d-3*t103*t188*t42
     6           *t45*t46*taua+6.867840000000001d-2*t103*t104*t42*t44*ta
     7           ua-4.57856d-1*gammaaa*t104*t224*t44*taua-1.061262590976
     8           d-3*gammaaa*t103*t119*t188*t44*taua-2.830033575936d-4*t
     9           103*t104*t45*t49*t92+2.747136d-2*t103*t43*t48*t92-8.490
     :           100727808d-4*t103*t188*t46*t47*t92+5.494272d-2*t103*t10
     ;           4*t44*t45*t92-5.660067151872d-4*gammaaa*t103*t104*t48*t
     <           91-1.6980201455616d-3*gammaaa*t103*t188*t44*t45*t91+2.1
     =           977088d-1*gammaaa*t103*t104*t40*t91-5.036416d-2*t168*t4
     >           3*t45*t49+5.30631295488d-5*t1*t104*t189*t45*t49-8.19965
     ?           4381909689d-7*t1*t186*t188*t45*t49-5.15088d-3*t1*t189*t
     @           43*t48-1.7398528000000002d-1*gammaaa*t166*t43*t48+5.306
     1           31295488d-5*gammaaa*t104*t189*t42*t48-8.199654381909689
     2           d-7*gammaaa*t186*t188*t42*t48+9.777777777777779d+0*t168
     3           *t39*t48+5.30631295488d-5*t1*t104*t186*t48-3.2798617527
     4           638757d-6*t1*t186*t374*t46*t47+1.591893886464d-4*t1*t18
     5           8*t189*t46*t47-1.0072832000000001d-1*t104*t168*t46*t47-
     6           2.2892800000000002d-1*t104*t119*t122*t46+9.777777777777
     7           779d+0*t168*t43*t44*t45-3.2798617527638757d-6*gammaaa*t
     8           186*t374*t42*t44*t45+1.591893886464d-4*gammaaa*t188*t18
     9           9*t42*t44*t45-1.030176d-2*t1*t104*t189*t44*t45+1.591893
     :           886464d-4*t1*t186*t188*t44*t45-3.4797056000000004d-1*ga
     ;           mmaaa*t104*t166*t44*t45+6.755555555555556d+1*gammaaa*t1
     <           66*t40*t43-2.060352d-2*gammaaa*t104*t189*t40*t42+3.1837
     =           87772928d-4*gammaaa*t186*t188*t40*t42-3.279861752763875
     >           7d-6*t119*t186*t374*t40*t41-2.5470302183424004d-3*t103*
     ?           t188*t224*t40*t41+1.591893886464d-4*t119*t188*t189*t40*
     @           t41-7.4172672d-1*t104*t164*t40*t41)-1.25d-1*t32*t33*t50
     1           *t81+2.0d+0*rhoa*t251*t35*t81+2.0d+0*t120*t35*t81+1.25d
     2           -1*gammaaa*t120*t32*t33*t81-2.5d-1*t105*t32*t81+1.25d-1
     3           *t159*t22*t32*t50-1.25d-1*t144*t32*t50+2.0d+0*t22*t251*
     4           t35+1.0d+0*rhoa*t120*t144*t35+1.25d-1*gammaaa*t22*t251*
     5           t32*t33-1.25d-1*t105*t22*t32*t33-1.25d-1*t190*t22*t32+1
     6           .25d-1*gammaaa*t120*t159*t22*t32)+t32*(5.0d-1*rhoa*t22*
     7           t34*(6.0d-2*gammaaa*t1*t26*(6.0d-2*gammaaa*t1*t26*(5.75
     8           9999999999998d-2*gammaaa*t91*t98*t99-3.1999999999999995
     9           d-1*t26*t92*t99-2.303999999999999d-3*t181*t224*t41*t99+
     :           6.0d-2*gammaaa*t1*t26*(-2.0799999999999996d-1*gammaaa*t
     ;           166*t27*t98+1.9583999999999993d-2*t164*t181*t27*t41-5.5
     <           29599999999998d-4*t162*t27*t372*t396+5.866666666666666d
     =           -1*t168*t26*t27)+1.9199999999999995d-2*t246*t41*t91*t98
     >           -3.6d-3*gammaaa*t182*t42*t98-8.639999999999998d-2*t115*
     ?           t166*t41*t98-2.0799999999999996d-1*gammaaa*t166*t28*t98
     @           -3.1999999999999995d-1*gammaaa*t246*t26*t92+1.958399999
     1           9999993d-2*t164*t181*t28*t41-5.529599999999998d-4*t162*
     2           t28*t372*t396+5.866666666666666d-1*t168*t26*t28+6.0d-2*
     3           t1*t182*t26+5.866666666666666d-1*gammaaa*t115*t168*t26+
     4           3.0719999999999986d-3*t115*t162*t164*t181)+1.9199999999
     5           999995d-2*t247*t41*t91*t98+5.759999999999998d-2*gammaaa
     6           *t100*t91*t98-3.6d-3*gammaaa*t183*t42*t98-8.63999999999
     7           9998d-2*t116*t166*t41*t98-2.0799999999999996d-1*gammaaa
     8           *t166*t29*t98-3.1999999999999995d-1*gammaaa*t247*t26*t9
     9           2-3.1999999999999995d-1*t100*t26*t92+1.9583999999999993
     :           d-2*t164*t181*t29*t41-2.303999999999999d-3*t100*t181*t2
     ;           24*t41-5.529599999999998d-4*t162*t29*t372*t396+5.866666
     <           666666666d-1*t168*t26*t29+6.0d-2*t1*t183*t26+5.86666666
     =           6666666d-1*gammaaa*t116*t168*t26+3.0719999999999986d-3*
     >           t116*t162*t164*t181)+1.9199999999999995d-2*t248*t41*t91
     ?           *t98+5.759999999999998d-2*gammaaa*t101*t91*t98-3.6d-3*g
     @           ammaaa*t184*t42*t98-8.639999999999998d-2*t117*t166*t41*
     1           t98-2.0799999999999996d-1*gammaaa*t166*t30*t98-3.199999
     2           9999999995d-1*gammaaa*t248*t26*t92-3.1999999999999995d-
     3           1*t101*t26*t92+1.9583999999999993d-2*t164*t181*t30*t41-
     4           2.303999999999999d-3*t101*t181*t224*t41-5.5295999999999
     5           98d-4*t162*t30*t372*t396+5.866666666666666d-1*t168*t26*
     6           t30+6.0d-2*t1*t184*t26+5.866666666666666d-1*gammaaa*t11
     7           7*t168*t26+3.0719999999999986d-3*t117*t162*t164*t181)+1
     8           .0d+0*rhoa*t249*t34*t81+1.0d+0*t118*t34*t81-1.25d-1*t31
     9           *t33*t81+1.25d-1*gammaaa*t118*t33*t81-2.5d-1*t102*t81+1
     :           .0d+0*t22*t249*t34+5.0d-1*rhoa*t118*t144*t34+1.25d-1*ga
     ;           mmaaa*t22*t249*t33-1.25d-1*t102*t22*t33+1.25d-1*t159*t2
     <           2*t31-1.25d-1*t144*t31-1.25d-1*t185*t22+1.25d-1*gammaaa
     =           *t118*t159*t22)+t55*(-2.981889777777778d-2*t168*t62*t97
     >           -3.04966d-3*t103*t268*t97+8.132426666666667d-3*t109*t92
     ?           +t452+t451+t450+t449+t448)+1.0d+0*(-1.653333333333333d-
     @           2*t3*t92*t95+2.0501333333333327d-4*gammaaa*t90*t91*t95+
     1           6.2d-3*gammaaa*t1*t3*(-1.653333333333333d-2*t3*t92*t94+
     2           2.0501333333333327d-4*gammaaa*t90*t91*t94+6.2d-3*gammaa
     3           a*t1*t3*(-1.653333333333333d-2*t3*t92*t93+2.05013333333
     4           33327d-4*gammaaa*t90*t91*t93-1.653333333333333d-2*gamma
     5           aa*t238*t3*t92+1.0250666666666663d-4*t238*t41*t90*t91+6
     6           .2d-3*gammaaa*t1*t3*(-6.492088888888888d-4*gammaaa*t166
     7           *t4*t90+t415+4.1310186666666654d-6*t163*t164*t4*t41+3.0
     8           311111111111105d-2*t168*t3*t4)-6.492088888888888d-4*gam
     9           maaa*t166*t5*t90+4.1310186666666654d-6*t163*t164*t41*t5
     :           +3.0311111111111105d-2*t168*t3*t5+t416+t414+t413+t412+t
     ;           411+t410+t409)-1.653333333333333d-2*gammaaa*t240*t3*t92
     <           +1.0250666666666663d-4*t240*t41*t90*t91-6.4920888888888
     =           88d-4*gammaaa*t166*t6*t90+4.1310186666666654d-6*t163*t1
     >           64*t41*t6+3.0311111111111105d-2*t168*t3*t6+t417+t408+t4
     ?           07+t406+t405+t404+t403)-1.653333333333333d-2*gammaaa*t2
     @           42*t3*t92+1.0250666666666663d-4*t242*t41*t90*t91-6.4920
     1           88888888888d-4*gammaaa*t166*t7*t90+4.1310186666666654d-
     2           6*t163*t164*t41*t7+3.0311111111111105d-2*t168*t3*t7+t41
     3           8+t402+t401+t400+t399+t398+t397)*t97-9.920454523306665d
     4           -5*t103*t107*t62*t92*t97+t43*(-3.662848000000001d-2*t22
     5           *t35*t50*t92+1.373568d-2*t106*t92+1.373568d-2*t1*t35*t5
     6           0*t81+6.4386d-4*t103*t32*t50*t81-5.15088d-3*rhoa*t103*t
     7           120*t35*t81+6.4386d-4*t103*t22*t32*t33*t50+6.4386d-4*t1
     8           89*t22*t32*t50-5.15088d-3*rhoa*t103*t22*t251*t35-5.1508
     9           8d-3*rhoa*t120*t189*t22*t35-5.15088d-3*t103*t120*t22*t3
     :           5+1.373568d-2*t1*t105*t22*t35+6.4386d-4*t103*t105*t22*t
     ;           32-5.15088d-3*t103*t252)+1.32657823872d-5*gammaaa*t103*
     <           t104*t22*t32*t50*t92-5.15088d-3*t187*t32*t43*t92+2.0d+0
     =           *t244*t89+t32*t33*t39*(1.25d-1*t50*t81+1.25d-1*gammaaa*
     >           t120*t81+1.25d-1*gammaaa*t22*t251+1.25d-1*t105*t22)+t32
     ?           *t33*(1.25d-1*gammaaa*t118*t81+t421+t420+1.25d-1*gammaa
     @           a*t22*t249)+t1*t104*(-2.830033575936d-4*t103*t22*t35*t5
     1           0-1.030176d-2*t192)+t32*t33*t43*(-1.28772d-3*t103*t22*t
     2           50-1.28772d-3*gammaaa*t103*t120*t22)+4.07778d-3*gammaaa
     3           *t168*t22*t32*t43*t50-8.199654381909689d-7*t186*t188*t2
     4           2*t35*t36*t50-6.6328911936d-6*t104*t186*t22*t32*t50+t45
     5           3+t447-5.15088d-3*t1*t191*t43+t424+t423+t159*t32*t39*t4
     6           22+t159*t32*t419+t395+5.30631295488d-5*rhoa*t104*t120*t
     7           186*t22*t35)*wght+Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = (t53*(1.0d+0*t97*(-2.710808888888
     1           889d-2*t55*t61*t91*taua-1.0843235555555557d-1*t107*t57*
     2           t58*t91*taua-2.1686471111111114d-1*gammaaa*t107*t224*t5
     3           6*taua-9.920454523306665d-5*gammaaa*t103*t107*t60*t91-2
     4           .976136356992d-4*gammaaa*t103*t194*t56*t57*t91+6.505941
     5           333333333d-2*gammaaa*t103*t107*t54*t91-2.98188977777777
     6           8d-2*gammaaa*t166*t55*t60-5.963779555555556d-2*gammaaa*
     7           t107*t166*t56*t57+1.9555555555555557d+1*gammaaa*t166*t5
     8           4*t55-1.1904545427968d-3*t103*t194*t224*t41*t54-3.25297
     9           0666666667d-1*t107*t164*t41*t54+t454+t445+t444+t443+t44
     :           2+t441+t440+t439+t438+t437+t436+t435+t434+t433+t432+t43
     ;           1+t430+t429+t428+t427+t426+t425)+2.0d+0*t276*t89+t446)+
     <           1.0d+0*(1.0250666666666663d-4*gammaaa*t90*t91*t95+6.2d-
     =           3*gammaaa*t1*t3*(1.0250666666666663d-4*gammaaa*t90*t91*
     >           t94+6.2d-3*gammaaa*t1*t3*(1.0250666666666663d-4*gammaaa
     ?           *t90*t91*t93-1.653333333333333d-2*gammaaa*t272*t3*t92+1
     @           .0250666666666663d-4*t272*t41*t90*t91+6.2d-3*gammaaa*t1
     1           *t3*(-1.8792888888888884d-4*gammaaa*t166*t4*t90+t415+2.
     2           436241777777777d-6*t163*t164*t4*t41)-1.8792888888888884
     3           d-4*gammaaa*t166*t5*t90+2.436241777777777d-6*t163*t164*
     4           t41*t5+t416+t414+t413+t412+t411+t410+t409)-1.6533333333
     5           33333d-2*gammaaa*t273*t3*t92+1.0250666666666663d-4*t273
     6           *t41*t90*t91-1.8792888888888884d-4*gammaaa*t166*t6*t90+
     7           2.436241777777777d-6*t163*t164*t41*t6+t417+t408+t407+t4
     8           06+t405+t404+t403)-1.653333333333333d-2*gammaaa*t274*t3
     9           *t92+1.0250666666666663d-4*t274*t41*t90*t91-1.879288888
     :           8888884d-4*gammaaa*t166*t7*t90+2.436241777777777d-6*t16
     ;           3*t164*t41*t7+t418+t402+t401+t400+t399+t398+t397)*t97+2
     <           .0d+0*t275*t89+(t455+t449+t448-3.04966d-3*t103*t277)*t5
     =           5+t453+t447+t424+t423+t395)*wght+Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = (t53*(1.0d+0*t97*(-2.710808888888
     1           8887d-2*t55*t61*t91*taua-1.0843235555555555d-1*t107*t57
     2           *t58*t91*taua-2.168647111111111d-1*gammaaa*t107*t224*t5
     3           6*taua-4.9602272616533327d-5*t103*t107*t57*t61*t92+8.13
     4           2426666666667d-3*t103*t55*t60*t92-1.4880681784960004d-4
     5           *t103*t194*t58*t59*t92+1.6264853333333332d-2*t103*t107*
     6           t56*t57*t92-1.984090904661333d-4*gammaaa*t103*t107*t60*
     7           t91-5.952272713984001d-4*gammaaa*t103*t194*t56*t57*t91+
     8           1.3011882666666666d-1*gammaaa*t103*t107*t54*t91-2.16864
     9           71111111108d-2*gammaaa*t166*t55*t60-4.3372942222222216d
     :           -2*gammaaa*t107*t166*t56*t57+1.4222222222222222d+1*gamm
     ;           aaa*t166*t54*t55-1.7856818141952002d-3*t103*t194*t224*t
     <           41*t54-2.602376533333333d-1*t107*t164*t41*t54+t454+t444
     =           +t443+t440+t439+t435+t434+t433+t432+t431+t429+t427+t426
     >           +t425)+1.0d+0*t276*t89+1.0d+0*t268*t89+1.0d+0*t121*t215
     ?           )+1.0d+0*(-8.266666666666665d-3*t3*t92*t95+1.5375999999
     @           999995d-4*gammaaa*t90*t91*t95+6.2d-3*gammaaa*t1*t3*(-8.
     1           266666666666665d-3*t3*t92*t94+1.5375999999999995d-4*gam
     2           maaa*t90*t91*t94+6.2d-3*gammaaa*t1*t3*(-8.2666666666666
     3           65d-3*t3*t92*t93+1.5375999999999995d-4*gammaaa*t90*t91*
     4           t93-8.266666666666665d-3*gammaaa*t272*t3*t92-8.26666666
     5           6666665d-3*gammaaa*t238*t3*t92+5.125333333333332d-5*t27
     6           2*t41*t90*t91+5.125333333333332d-5*t238*t41*t90*t91+6.2
     7           d-3*gammaaa*t1*t3*(-1.366755555555555d-4*gammaaa*t166*t
     8           4*t90+t415+2.1184711111111104d-6*t163*t164*t4*t41)-1.36
     9           6755555555555d-4*gammaaa*t166*t5*t90-1.9219999999999998
     :           d-5*gammaaa*t216*t42*t90-1.366755555555555d-4*t110*t166
     ;           *t41*t90+2.1184711111111104d-6*t163*t164*t41*t5+t411+t4
     <           10+t409+3.1d-3*t1*t216*t3)-8.266666666666665d-3*gammaaa
     =           *t273*t3*t92-8.266666666666665d-3*gammaaa*t240*t3*t92+5
     >           .125333333333332d-5*t273*t41*t90*t91+5.125333333333332d
     ?           -5*t240*t41*t90*t91-1.366755555555555d-4*gammaaa*t166*t
     @           6*t90-1.9219999999999998d-5*gammaaa*t217*t42*t90-1.3667
     1           55555555555d-4*t111*t166*t41*t90+2.1184711111111104d-6*
     2           t163*t164*t41*t6+t405+t404+t403+3.1d-3*t1*t217*t3)-8.26
     3           6666666666665d-3*gammaaa*t274*t3*t92-8.266666666666665d
     4           -3*gammaaa*t242*t3*t92+5.125333333333332d-5*t274*t41*t9
     5           0*t91+5.125333333333332d-5*t242*t41*t90*t91-1.366755555
     6           555555d-4*gammaaa*t166*t7*t90-1.9219999999999998d-5*gam
     7           maaa*t218*t42*t90-1.366755555555555d-4*t112*t166*t41*t9
     8           0+2.1184711111111104d-6*t163*t164*t41*t7+t399+t398+t397
     9           +3.1d-3*t1*t218*t3)*t97-4.9602272616533327d-5*t103*t107
     :           *t62*t92*t97+1.0d+0*t275*t89+1.0d+0*t244*t89+(t455+t452
     ;           +t451+t450+t449)*t55-3.04966d-3*t1*t221*t55+t424+t423-6
     <           .09932d-3*t1*t107*t222+1.0d+0*t113*t215)*wght+Cmat3(iq,
     =           D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t39*(1.0d+0*rhoa*t22*t35*(-1.76
     1           877098496d-4*t104*t119*t49*taua-1.061262590976d-3*t119*
     2           t188*t45*t46*taua-5.30631295488d-4*gammaaa*t188*t287*t4
     3           4*taua+6.867840000000001d-2*t104*t119*t44*taua-2.830033
     4           575936d-4*t104*t45*t49*t91+5.494272d-2*t43*t48*t91-8.49
     5           0100727808d-4*t188*t46*t47*t91+1.0988544d-1*t104*t44*t4
     6           5*t91-1.0666666666666666d+1*t40*t43*t91-8.1996543819096
     7           89d-7*t103*t188*t42*t45*t49+1.061262590976d-4*t103*t104
     8           *t42*t48-4.245050363904d-4*gammaaa*t104*t224*t48-8.1996
     9           54381909689d-7*gammaaa*t103*t119*t188*t48-3.27986175276
     :           38757d-6*t103*t374*t42*t46*t47-1.6980201455616d-3*t188*
     ;           t40*t41*t457+3.183787772928d-4*t103*t188*t42*t44*t45-3.
     <           2798617527638757d-6*gammaaa*t103*t119*t374*t44*t45-1.27
     =           35151091712002d-3*gammaaa*t188*t224*t44*t45-2.060352d-2
     >           *t103*t104*t40*t42-3.2798617527638757d-6*t103*t287*t374
     ?           *t40*t41+3.2965632d-1*gammaaa*t104*t224*t40+6.367575545
     @           856d-4*gammaaa*t103*t119*t188*t40)+1.0d+0*rhoa*t288*t35
     1           *t81-2.5d-1*t120*t32*t81+1.0d+0*t22*t288*t35-2.5d-1*t12
     2           0*t22*t32*t33-2.5d-1*t22*t251*t32)+t32*(5.0d-1*rhoa*t22
     3           *t34*(6.0d-2*gammaaa*t1*t26*(6.0d-2*gammaaa*t1*t26*(-7.
     4           2d-3*t42*t98*t99+4.32d-4*gammaaa*t119*t181*t99+6.0d-2*g
     5           ammaaa*t1*t26*(3.839999999999999d-2*t27*t91*t98+2.07359
     6           9999999999d-4*t27*t372*t41*t457-5.759999999999997d-3*ga
     7           mmaaa*t181*t224*t27)+9.599999999999997d-3*t283*t41*t91*
     8           t98+3.839999999999999d-2*t28*t91*t98+5.759999999999998d
     9           -2*gammaaa*t115*t91*t98-7.2d-3*gammaaa*t246*t42*t98-1.5
     :           999999999999998d-1*gammaaa*t26*t283*t92-3.1999999999999
     ;           995d-1*t115*t26*t92+2.073599999999999d-4*t28*t372*t41*t
     <           457-2.303999999999999d-3*t115*t181*t224*t41-5.759999999
     =           999997d-3*gammaaa*t181*t224*t28+1.2d-1*t1*t246*t26)+9.5
     >           99999999999997d-3*t284*t41*t91*t98+3.839999999999999d-2
     ?           *t29*t91*t98+5.759999999999998d-2*gammaaa*t116*t91*t98-
     @           7.2d-3*gammaaa*t247*t42*t98-7.2d-3*t100*t42*t98-1.59999
     1           99999999998d-1*gammaaa*t26*t284*t92-3.1999999999999995d
     2           -1*t116*t26*t92+2.073599999999999d-4*t29*t372*t41*t457-
     3           2.303999999999999d-3*t116*t181*t224*t41-5.7599999999999
     4           97d-3*gammaaa*t181*t224*t29+1.2d-1*t1*t247*t26+4.32d-4*
     5           gammaaa*t100*t119*t181)+9.599999999999997d-3*t285*t41*t
     6           91*t98+3.839999999999999d-2*t30*t91*t98+5.7599999999999
     7           98d-2*gammaaa*t117*t91*t98-7.2d-3*gammaaa*t248*t42*t98-
     8           7.2d-3*t101*t42*t98-1.5999999999999998d-1*gammaaa*t26*t
     9           285*t92-3.1999999999999995d-1*t117*t26*t92+2.0735999999
     :           99999d-4*t30*t372*t41*t457-2.303999999999999d-3*t117*t1
     ;           81*t224*t41-5.759999999999997d-3*gammaaa*t181*t224*t30+
     <           1.2d-1*t1*t248*t26+4.32d-4*gammaaa*t101*t119*t181)+5.0d
     =           -1*rhoa*t286*t34*t81-2.5d-1*t118*t81+5.0d-1*t22*t286*t3
     >           4-2.5d-1*t118*t22*t33-2.5d-1*t22*t249)+t53*(1.0d+0*(-9.
     ?           920454523306665d-5*t107*t57*t61*t91+3.2529706666666663d
     @           -2*t55*t60*t91-2.976136356992001d-4*t194*t58*t59*t91+6.
     1           505941333333333d-2*t107*t56*t57*t91-1.0666666666666666d
     2           +1*t54*t55*t91-2.4801136308266666d-4*gammaaa*t107*t224*
     3           t60-7.440340892480001d-4*gammaaa*t194*t224*t56*t57-1.78
     4           56818141952002d-3*t194*t41*t457*t54+3.2529706666666663d
     5           -1*gammaaa*t107*t224*t54+t493+t492+t491+t490+t489+t488+
     6           t487+t486+t485+t484+t483+t482+t481)*t97+t494)+1.0d+0*(6
     7           .2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t3*(-1.653333333
     8           333333d-2*t110*t3*t92+6.2d-3*gammaaa*t1*t3*(1.025066666
     9           6666663d-4*t4*t90*t91+t476-1.1121973333333329d-6*gammaa
     :           a*t163*t224*t4)+1.0250666666666663d-4*t5*t90*t91+2.0501
     ;           333333333327d-4*gammaaa*t110*t90*t91-3.8439999999999996
     <           d-5*gammaaa*t238*t42*t90-1.1121973333333329d-6*gammaaa*
     =           t163*t224*t5+t475+t474+t473+t472+t471+t470+6.2d-3*t1*t2
     >           38*t3)-1.653333333333333d-2*t111*t3*t92+1.0250666666666
     ?           663d-4*t6*t90*t91+2.0501333333333327d-4*gammaaa*t111*t9
     @           0*t91-3.8439999999999996d-5*gammaaa*t240*t42*t90-1.1121
     1           973333333329d-6*gammaaa*t163*t224*t6+t469+t468+t467+t46
     2           6+t465+t464+6.2d-3*t1*t240*t3)-1.653333333333333d-2*t11
     3           2*t3*t92+1.0250666666666663d-4*t7*t90*t91+2.05013333333
     4           33327d-4*gammaaa*t112*t90*t91-3.8439999999999996d-5*gam
     5           maaa*t242*t42*t90-1.1121973333333329d-6*gammaaa*t163*t2
     6           24*t7+t463+t462+t461+t460+t459+t458+6.2d-3*t1*t242*t3)*
     7           t97+1.6264853333333332d-2*t121*t55*t92*t97-9.9204545233
     8           06665d-5*t107*t62*t91*t97+t32*t43*(-2.3608200000000001d
     9           -3*t22*t50-5.15088d-3*t250-6.4386d-4*gammaaa*t120*t22)*
     :           t92+6.6328911936d-6*gammaaa*t104*t22*t32*t50*t91-6.0993
     ;           2d-3*t1*t270*t55+t104*t42*(-1.415016787968d-4*t22*t35*t
     <           50-1.030176d-2*t253)+t1*t43*(-1.7169600000000002d-3*t22
     =           *t32*t33*t50+t479+2.747136d-2*t120*t22*t35)-8.199654381
     >           909689d-7*t103*t125*t188*t22*t35*t50-1.32657823872d-5*t
     ?           1*t103*t104*t22*t32*t50+t497+t496+t495+t480+t32*t33*t39
     @           *t478+t32*t33*(t477+1.25d-1*gammaaa*t22*t286)+t456-5.15
     1           088d-3*rhoa*t103*t22*t288*t35*t43+1.28772d-3*t103*t120*
     2           t22*t32*t43+1.061262590976d-4*t103*t104*t120*t22*t35*t3
     3           6)*wght+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = (t53*(1.0d+0*(-4.960227261653332
     1           7d-5*t107*t57*t61*t91+1.6264853333333332d-2*t55*t60*t91
     2           -1.488068178496d-4*t194*t58*t59*t91+3.2529706666666663d
     3           -2*t107*t56*t57*t91-5.333333333333333d+0*t54*t55*t91-1.
     4           4880681784959998d-4*gammaaa*t107*t224*t60-4.46420453548
     5           79994d-4*gammaaa*t194*t224*t56*t57-1.1904545427968d-3*t
     6           194*t41*t457*t54+1.9517824d-1*gammaaa*t107*t224*t54+t49
     7           3+t492+t491+t490+t489+t488+t487+t486+t485+t484+t483+t48
     8           2+t481)*t97+t494)+1.0d+0*(6.2d-3*gammaaa*t1*t3*(6.2d-3*
     9           gammaaa*t1*t3*(-8.266666666666665d-3*t110*t3*t92+6.2d-3
     :           *gammaaa*t1*t3*(5.125333333333332d-5*t4*t90*t91+t476-7.
     ;           944266666666663d-7*gammaaa*t163*t224*t4)+5.125333333333
     <           332d-5*t5*t90*t91+1.5375999999999995d-4*gammaaa*t110*t9
     =           0*t91-1.9219999999999998d-5*gammaaa*t272*t42*t90-1.9219
     >           999999999998d-5*gammaaa*t238*t42*t90-7.944266666666663d
     ?           -7*gammaaa*t163*t224*t5+t475+t474+t473+t472+t471+t470+3
     @           .1d-3*t1*t272*t3+3.1d-3*t1*t238*t3)-8.266666666666665d-
     1           3*t111*t3*t92+5.125333333333332d-5*t6*t90*t91+1.5375999
     2           999999995d-4*gammaaa*t111*t90*t91-1.9219999999999998d-5
     3           *gammaaa*t273*t42*t90-1.9219999999999998d-5*gammaaa*t24
     4           0*t42*t90-7.944266666666663d-7*gammaaa*t163*t224*t6+t46
     5           9+t468+t467+t466+t465+t464+3.1d-3*t1*t273*t3+3.1d-3*t1*
     6           t240*t3)-8.266666666666665d-3*t112*t3*t92+5.12533333333
     7           3332d-5*t7*t90*t91+1.5375999999999995d-4*gammaaa*t112*t
     8           90*t91-1.9219999999999998d-5*gammaaa*t274*t42*t90-1.921
     9           9999999999998d-5*gammaaa*t242*t42*t90-7.944266666666663
     :           d-7*gammaaa*t163*t224*t7+t463+t462+t461+t460+t459+t458+
     ;           3.1d-3*t1*t274*t3+3.1d-3*t1*t242*t3)*t97+8.132426666666
     <           667d-3*t121*t55*t92*t97-4.9602272616533327d-5*t107*t62*
     =           t91*t97-3.04966d-3*t1*t277*t55-3.04966d-3*t1*t270*t55+t
     >           497+t496+t495+t480+t456)*wght+Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = (t53*(1.0d+0*(-4.960227261653332
     1           7d-5*gammaaa*t107*t224*t60-1.488068178496d-4*gammaaa*t1
     2           94*t224*t56*t57-5.952272713984d-4*t194*t41*t457*t54+6.5
     3           05941333333333d-2*gammaaa*t107*t224*t54+t493+t492+t491+
     4           t490+t489+t488+t487+t486+t485+t484+t483+t482+t481)*t97+
     5           t494)+1.0d+0*(6.2d-3*gammaaa*t1*t3*(6.2d-3*gammaaa*t1*t
     6           3*(1.0250666666666663d-4*gammaaa*t110*t90*t91-3.8439999
     7           999999996d-5*gammaaa*t272*t42*t90-4.766559999999998d-7*
     8           gammaaa*t163*t224*t5+6.2d-3*gammaaa*t1*t3*(t476-4.76655
     9           9999999998d-7*gammaaa*t163*t224*t4)+t475+t474+t473+t472
     :           +t471+t470+6.2d-3*t1*t272*t3)+1.0250666666666663d-4*gam
     ;           maaa*t111*t90*t91-3.8439999999999996d-5*gammaaa*t273*t4
     <           2*t90-4.766559999999998d-7*gammaaa*t163*t224*t6+t469+t4
     =           68+t467+t466+t465+t464+6.2d-3*t1*t273*t3)+1.02506666666
     >           66663d-4*gammaaa*t112*t90*t91-3.8439999999999996d-5*gam
     ?           maaa*t274*t42*t90-4.766559999999998d-7*gammaaa*t163*t22
     @           4*t7+t463+t462+t461+t460+t459+t458+6.2d-3*t1*t274*t3)*t
     1           97-6.09932d-3*t1*t277*t55+t497+t496+t495+t480+t456)*wgh
     2           t+Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = (t32*(5.0d-1*rhoa*t22*t34*(6.0d
     1           -2*gammaaa*t1*t26*(6.0d-2*gammaaa*t1*t26*(-1.0800000000
     2           000001d-2*gammaaa*t283*t42*t98-2.1600000000000003d-2*t1
     3           15*t42*t98+6.0d-2*gammaaa*t1*t26*(1.296d-3*t119*t181*t2
     4           7-7.776d-5*gammaaa*t27*t287*t372)-7.776d-5*gammaaa*t28*
     5           t287*t372+1.8d-1*t1*t26*t283+1.296d-3*t119*t181*t28+1.2
     6           96d-3*gammaaa*t115*t119*t181)-1.0800000000000001d-2*gam
     7           maaa*t284*t42*t98-2.1600000000000003d-2*t116*t42*t98-7.
     8           776d-5*gammaaa*t287*t29*t372+1.296d-3*t119*t181*t29+1.8
     9           d-1*t1*t26*t284+1.296d-3*gammaaa*t116*t119*t181)-1.0800
     :           000000000001d-2*gammaaa*t285*t42*t98-2.1600000000000003
     ;           d-2*t117*t42*t98-7.776d-5*gammaaa*t287*t30*t372+1.296d-
     <           3*t119*t181*t30+1.8d-1*t1*t26*t285+1.296d-3*gammaaa*t11
     =           7*t119*t181)-3.75d-1*t22*t286)+t503+t502+t501+t500-1.98
     >           98673580800003d-5*t104*t22*t32*t42*t50-8.19965438190968
     ?           9d-7*t124*t188*t22*t35*t50+1.0d+0*rhoa*t22*t35*t39*(-3.
     @           2798617527638757d-6*t374*t40*t41*t499-8.199654381909689
     1           d-7*t119*t188*t45*t49-8.199654381909689d-7*gammaaa*t188
     2           *t287*t48+1.591893886464d-4*t104*t119*t48-3.27986175276
     3           38757d-6*t119*t374*t46*t47-3.2798617527638757d-6*gammaa
     4           a*t287*t374*t44*t45+4.7756816593920004d-4*t119*t188*t44
     5           *t45+9.551363318784001d-4*gammaaa*t188*t287*t40-6.18105
     6           6d-2*t104*t119*t40)+t498-1.545264d-2*t22*t288*t35*t36*t
     7           43+3.86316d-3*t1*t120*t22*t32*t43-3.75d-1*t22*t288*t32*
     8           t39+1.591893886464d-4*t104*t120*t125*t22*t35)*wght+Cmat
     9           3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = (t503+t502+t501+t500+t498)*wght
     1           +Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = (t53*(1.0d+0*t97*(-1.2198640000000
     1           002d-1*t42*t55*t61*taua-4.879456000000001d-1*t107*t42*t
     2           57*t58*taua+8.0d+1*t42*t55*t58*taua-7.048103111111113d-
     3           1*gammaaa*t107*t119*t56*taua-2.710808888888889d-2*t55*t
     4           57*t61*t92+8.88888888888889d+0*t53*t61*t92-5.4216177777
     5           77779d-2*t107*t58*t59*t92+1.7777777777777778d+1*t55*t57
     6           *t58*t92-1.6807015111111112d-1*gammaaa*t55*t60*t91-3.36
     7           14030222222224d-1*gammaaa*t107*t56*t57*t91+5.5111111111
     8           11111d+1*gammaaa*t55*t56*t91-1.2400568154133333d-4*t1*t
     9           103*t107*t57*t61+2.033106666666667d-2*t1*t103*t55*t61-4
     :           .4642045354879994d-4*gammaaa*t103*t107*t42*t60-3.720170
     ;           4462400004d-4*t1*t103*t194*t58*t59+8.132426666666668d-2
     <           *t1*t103*t107*t57*t58-1.3392613606464002d-3*gammaaa*t10
     =           3*t194*t42*t56*t57+1.4638368000000002d-1*gammaaa*t103*t
     >           107*t42*t56-1.301188266666667d+0*t107*t224*t41*t54-3.86
     ?           89772640896003d-3*t103*t119*t194*t41*t54+t526+t525+t524
     @           +t523+t522+t521+t520+t519+t518+t517+t516+t515+t514+t513
     1           +t512+t511+t510+t509+t508+t507+t506)+2.0d+0*t309*t89+t5
     2           27)+t39*(1.0d+0*rhoa*t22*t35*(-2.0603520000000003d-1*t4
     3           2*t43*t49*taua-7.07508393984d-4*t103*t104*t125*t49*taua
     4           -8.241408000000001d-1*t104*t42*t45*t46*taua-4.245050363
     5           904d-3*t103*t125*t188*t45*t46*taua+8.0d+1*t42*t43*t46*t
     6           aua+2.747136d-1*t103*t104*t125*t46*taua-2.122525181952d
     7           -3*gammaaa*t103*t124*t188*t44*taua-7.783552d-1*gammaaa*
     8           t104*t119*t44*taua-4.5785600000000004d-2*t43*t45*t49*t9
     9           2+8.88888888888889d+0*t39*t49*t92-9.157120000000001d-2*
     :           t104*t46*t47*t92+1.7777777777777778d+1*t43*t45*t46*t92-
     ;           2.3808512d-1*gammaaa*t43*t48*t91-4.7617024d-1*gammaaa*t
     <           104*t44*t45*t91+4.622222222222223d+1*gammaaa*t43*t44*t9
     =           1+1.061262590976d-4*t104*t189*t36*t45*t49-1.63993087638
     >           19376d-6*t186*t188*t36*t45*t49-3.5375419699200006d-4*t1
     ?           *t103*t104*t45*t49-1.030176d-2*t189*t36*t43*t49+3.43392
     @           00000000003d-2*t1*t103*t43*t49+1.061262590976d-4*t104*t
     1           186*t36*t49-9.197609121792001d-4*gammaaa*t103*t104*t42*
     2           t48+1.061262590976d-4*gammaaa*t104*t125*t189*t48-1.6399
     3           308763819376d-6*gammaaa*t125*t186*t188*t48-6.5597235055
     4           27751d-6*t186*t36*t374*t46*t47+3.183787772928d-4*t188*t
     5           189*t36*t46*t47-1.0612625909760003d-3*t1*t103*t188*t46*
     6           t47-4.120704d-2*t104*t189*t36*t45*t46+6.367575545856d-4
     7           *t186*t188*t36*t45*t46+1.373568d-1*t1*t103*t104*t45*t46
     8           -4.5785600000000004d-1*t104*t122*t124*t46-2.75928273653
     9           76d-3*gammaaa*t103*t188*t42*t44*t45-6.559723505527751d-
     :           6*gammaaa*t125*t186*t374*t44*t45+3.183787772928d-4*gamm
     ;           aaa*t125*t188*t189*t44*t45+1.7856384d-1*gammaaa*t103*t1
     <           04*t42*t44-2.060352d-2*gammaaa*t104*t125*t189*t44+3.183
     =           787772928d-4*gammaaa*t125*t186*t188*t44-6.5597235055277
     >           51d-6*t124*t186*t374*t40*t41-1.1537971200000001d+0*t104
     ?           *t224*t40*t41+3.183787772928d-4*t124*t188*t189*t40*t41-
     @           4.4573028820992006d-3*t103*t119*t188*t40*t41)+1.25d-1*g
     1           ammaaa*t123*t33*t50*t81+2.0d+0*rhoa*t293*t35*t81+2.0d+0
     2           *t126*t35*t81+1.25d-1*gammaaa*t126*t32*t33*t81+2.5d-1*g
     3           ammaaa*t105*t123*t81-1.25d-1*gammaaa*t123*t159*t22*t50+
     4           1.25d-1*gammaaa*t123*t144*t50+2.0d+0*t22*t293*t35+1.0d+
     5           0*rhoa*t126*t144*t35+1.25d-1*gammaaa*t22*t293*t32*t33+1
     6           .25d-1*gammaaa*t105*t123*t22*t33+1.25d-1*gammaaa*t126*t
     7           159*t22*t32+1.25d-1*gammaaa*t123*t190*t22)+t55*(-2.7108
     8           08888888889d-2*t62*t92*t97-3.04966d-3*t103*t309*t97+t53
     9           3+t532+t531+t530+t529+1.0165533333333335d-2*t1*t109)-1.
     :           2400568154133333d-4*t1*t103*t107*t62*t97+5.58012d-3*gam
     ;           maaa*t22*t32*t43*t50*t92-1.6399308763819376d-6*t186*t18
     <           8*t22*t35*t50*t9+t43*(1.7169600000000002d-2*t35*t36*t50
     =           *t81-6.4386d-4*gammaaa*t103*t123*t50*t81-5.15088d-3*rho
     >           a*t103*t126*t35*t81-2.8616d-2*t1*t22*t35*t50-6.4386d-4*
     ?           gammaaa*t103*t123*t22*t33*t50-6.4386d-4*gammaaa*t123*t1
     @           89*t22*t50+1.7169600000000002d-2*t105*t22*t35*t36-5.150
     1           88d-3*rhoa*t103*t22*t293*t35-5.15088d-3*rhoa*t126*t189*
     2           t22*t35-5.15088d-3*t103*t126*t22*t35-5.15088d-3*t103*t2
     3           94-6.4386d-4*gammaaa*t103*t105*t123*t22+1.7169600000000
     4           002d-2*t1*t106)+t123*t33*t39*(-1.25d-1*gammaaa*t50*t81-
     5           1.25d-1*gammaaa*t105*t22)+t123*(-1.0d+0*t31*t34*t81-1.0
     6           d+0*rhoa*t102*t34*t81-1.25d-1*gammaaa*t31*t33*t81-5.0d-
     7           1*rhoa*t144*t31*t34-5.0d-1*rhoa*t185*t22*t34-1.0d+0*t10
     8           2*t22*t34-1.25d-1*gammaaa*t102*t22*t33-1.25d-1*gammaaa*
     9           t159*t22*t31)+t123*t33*(-1.25d-1*gammaaa*t31*t81-1.25d-
     :           1*gammaaa*t102*t22)+t32*(2.0d+0*t31*t81+2.0d+0*rhoa*t10
     ;           2*t81+1.0d+0*rhoa*t144*t31+1.0d+0*rhoa*t185*t22+2.0d+0*
     <           t102*t22)+t32*t33*t39*(1.25d-1*gammaaa*t126*t81+1.25d-1
     =           *gammaaa*t22*t293)+t534+t528+t505+t504+t104*t36*(-3.537
     >           5419699200006d-4*t103*t22*t35*t50-2.060352d-2*t192)+1.2
     ?           8772d-3*gammaaa*t103*t123*t22*t33*t43*t50+1.25d-1*gamma
     @           aa*t123*t159*t22*t39*t50+2.65315647744d-5*gammaaa*t1*t1
     1           03*t104*t22*t32*t50+6.6328911936d-6*gammaaa*t104*t123*t
     2           186*t22*t50-1.030176d-2*t191*t36*t43-1.28772d-3*gammaaa
     3           *t103*t126*t22*t32*t33*t43-1.030176d-2*t1*t187*t32*t43-
     4           1.25d-1*gammaaa*t126*t159*t22*t32*t39+5.30631295488d-5*
     5           rhoa*t104*t126*t186*t22*t35+1.25d-1*gammaaa*t123*t159*t
     6           22*t31)*wght+Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = (t53*(1.0d+0*t97*(-5.4216177777777
     1           79d-2*t42*t55*t61*taua-2.1686471111111114d-1*t107*t42*t
     2           57*t58*taua+3.5555555555555557d+1*t42*t55*t58*taua-4.33
     3           72942222222227d-1*gammaaa*t107*t119*t56*taua-5.96377955
     4           5555556d-2*gammaaa*t55*t60*t91-1.1927559111111112d-1*ga
     5           mmaaa*t107*t56*t57*t91+1.9555555555555557d+1*gammaaa*t5
     6           5*t56*t91-1.984090904661333d-4*gammaaa*t103*t107*t42*t6
     7           0-5.952272713984d-4*gammaaa*t103*t194*t42*t56*t57+6.505
     8           941333333333d-2*gammaaa*t103*t107*t42*t56-6.50594133333
     9           3334d-1*t107*t224*t41*t54-2.3809090855936d-3*t103*t119*
     :           t194*t41*t54+t526+t525+t524+t523+t522+t521+t520+t519+t5
     ;           18+t517+t516+t515+t514+t513+t512+t511+t510+t509+t508+t5
     <           07+t506)+2.0d+0*t313*t89+t527)+(t535+t530+t529-3.04966d
     =           -3*t103*t314)*t55+t534+t528+t505+t504)*wght+Mmat3(iq,D3
     >           _RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = (t53*(1.0d+0*t97*(-3.3885111111111
     1           116d-2*t42*t55*t61*taua-1.3554044444444446d-1*t107*t42*
     2           t57*t58*taua+2.2222222222222224d+1*t42*t55*t58*taua-3.5
     3           24051555555556d-1*gammaaa*t107*t119*t56*taua-2.71080888
     4           88888887d-2*gammaaa*t55*t60*t91-5.421617777777777d-2*ga
     5           mmaaa*t107*t56*t57*t91+8.88888888888889d+0*gammaaa*t55*
     6           t56*t91-6.200284077066667d-5*t1*t103*t107*t57*t61+1.016
     7           5533333333335d-2*t1*t103*t55*t61-3.2241477200746665d-4*
     8           gammaaa*t103*t107*t42*t60-1.8600852231200002d-4*t1*t103
     9           *t194*t58*t59+4.066213333333334d-2*t1*t103*t107*t57*t58
     :           -9.672443160224d-4*gammaaa*t103*t194*t42*t56*t57+1.0572
     ;           154666666667d-1*gammaaa*t103*t107*t42*t56-3.9035648d-1*
     <           t107*t224*t41*t54-3.1249431748416d-3*t103*t119*t194*t41
     =           *t54+t525+t524+t521+t520+t516+t515+t514+t513+t512+t510+
     >           t508+t507+t506)+1.0d+0*t313*t89+1.0d+0*t309*t89+1.0d+0*
     ?           t127*t215)-6.200284077066667d-5*t1*t103*t107*t62*t97+(t
     @           535+t533+t532+t531+t530)*t55-6.09932d-3*t221*t36*t55+t5
     1           05+t504-1.219864d-2*t107*t222*t36)*wght+Mmat3(iq,D3_RA_
     2           RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = (t39*(1.0d+0*rhoa*t22*t35*(-3.537
     1           54196992d-4*t104*t124*t49*taua-2.122525181952d-3*t124*t
     2           188*t45*t46*taua+1.373568d-1*t104*t124*t46*taua-1.06126
     3           2590976d-3*gammaaa*t188*t315*t44*taua+6.867840000000001
     4           d-2*t104*t124*t44*taua-4.5988045608960004d-4*t104*t42*t
     5           45*t49-1.6399308763819376d-6*t103*t125*t188*t45*t49+4.4
     6           64096d-2*t42*t43*t49+1.061262590976d-4*t103*t104*t125*t
     7           49+4.464096d-2*t42*t43*t48-1.6399308763819376d-6*gammaa
     8           a*t103*t124*t188*t48+1.061262590976d-4*t103*t104*t125*t
     9           48-7.428838136832d-4*gammaaa*t104*t119*t48-1.3796413682
     :           688d-3*t188*t42*t46*t47-6.559723505527751d-6*t103*t125*
     ;           t374*t46*t47+1.7856384d-1*t104*t42*t45*t46+6.3675755458
     <           56d-4*t103*t125*t188*t45*t46+8.928192d-2*t104*t42*t44*t
     =           45-6.559723505527751d-6*gammaaa*t103*t124*t374*t44*t45+
     >           3.183787772928d-4*t103*t125*t188*t44*t45-2.228651441049
     ?           6003d-3*gammaaa*t119*t188*t44*t45-8.666666666666666d+0*
     @           t42*t43*t44+3.183787772928d-4*gammaaa*t103*t124*t188*t4
     1           4-2.060352d-2*t103*t104*t125*t44+1.4422464000000002d-1*
     2           gammaaa*t104*t119*t44-6.559723505527751d-6*t103*t315*t3
     3           74*t40*t41-3.0776615138304003d-3*t188*t287*t40*t41+6.36
     4           7575545856d-4*gammaaa*t103*t124*t188*t40+2.884492800000
     5           0003d-1*gammaaa*t104*t119*t40)+1.25d-1*t123*t50*t81+1.0
     6           d+0*rhoa*t316*t35*t81-1.25d-1*t126*t32*t81+1.25d-1*gamm
     7           aaa*t120*t123*t81+1.25d-1*t123*t22*t33*t50+1.0d+0*t22*t
     8           316*t35-1.25d-1*t126*t22*t32*t33+1.25d-1*gammaaa*t120*t
     9           123*t22*t33-1.25d-1*t22*t293*t32+1.25d-1*gammaaa*t123*t
     :           22*t251+1.25d-1*t105*t123*t22)+t53*(1.0d+0*(-1.61207386
     ;           00373333d-4*t107*t42*t57*t61+2.6430386666666666d-2*t42*
     <           t55*t61+2.6430386666666666d-2*t42*t55*t60-4.21619317240
     =           53336d-4*gammaaa*t107*t119*t60-4.836221580112d-4*t194*t
     >           42*t58*t59+1.0572154666666667d-1*t107*t42*t57*t58+5.286
     ?           077333333333d-2*t107*t42*t56*t57-1.2648579517216d-3*gam
     @           maaa*t119*t194*t56*t57-8.666666666666666d+0*t42*t55*t56
     1           +1.3825125333333332d-1*gammaaa*t107*t119*t56+t553+t552+
     2           t551+t550+t549+t548+t547+t546+t545+t544+t543+t542+t541+
     3           t540-3.1249431748416d-3*t194*t287*t41*t54+2.76502506666
     4           66665d-1*gammaaa*t107*t119*t54+t539+t538+t537)*t97+t554
     5           )+t1*t55*(1.0165533333333335d-2*t121*t97-3.04966d-3*t31
     6           1)-1.6120738600373333d-4*t107*t42*t62*t97+6.4386d-4*gam
     7           maaa*t123*t22*t43*t50*t92-6.4386d-4*gammaaa*t126*t22*t3
     8           2*t43*t92+1.061262590976d-4*t103*t104*t120*t22*t35*t9+t
     9           123*(-5.0d-1*rhoa*t118*t34*t81+t421+t420-5.0d-1*rhoa*t2
     :           2*t249*t34-5.0d-1*t118*t22*t34+1.25d-1*t22*t31*t33)+t32
     ;           *(1.0d+0*rhoa*t118*t81+1.0d+0*rhoa*t22*t249+1.0d+0*t118
     <           *t22)+t560+t559+t558+t557+t556+t555+t536+t104*t125*(-1.
     =           7687709849600003d-4*t22*t35*t50-2.060352d-2*t253)+t1*t4
     >           3*(1.7169600000000002d-3*gammaaa*t123*t22*t33*t50+1.373
     ?           568d-2*t126*t22*t35-5.15088d-3*t294)+t123*t43*(-6.4386d
     @           -4*t103*t22*t50-6.4386d-4*gammaaa*t103*t120*t22)+t1*t32
     1           *t43*(-2.1462d-3*t22*t50-1.030176d-2*t250)+1.3265782387
     2           2d-5*gammaaa*t104*t22*t32*t42*t50-1.32657823872d-5*t103
     3           *t104*t22*t32*t36*t50-1.6399308763819376d-6*t103*t188*t
     4           22*t317*t35*t50+6.6328911936d-6*gammaaa*t1*t103*t104*t1
     5           23*t22*t50+t36*t43*(t479+1.7169600000000002d-2*t120*t22
     6           *t35)-5.15088d-3*rhoa*t103*t22*t316*t35*t43+6.4386d-4*t
     7           103*t126*t22*t32*t43+t123*t33*t39*t422+t123*t33*t419+(1
     8           .25d-1*gammaaa*t22*t316+1.25d-1*t126*t22)*t32*t33*t39+5
     9           .30631295488d-5*t103*t104*t126*t22*t35*t36)*wght+Mmat3(
     :           iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = (t53*(1.0d+0*(-9.920454523306665d
     1           -5*t107*t42*t57*t61+1.6264853333333332d-2*t42*t55*t61+1
     2           .6264853333333332d-2*t42*t55*t60-2.9761363569919996d-4*
     3           gammaaa*t107*t119*t60-2.976136356992d-4*t194*t42*t58*t5
     4           9+6.505941333333333d-2*t107*t42*t57*t58+3.2529706666666
     5           663d-2*t107*t42*t56*t57-8.928409070975999d-4*gammaaa*t1
     6           19*t194*t56*t57-5.333333333333333d+0*t42*t55*t56+9.7589
     7           12d-2*gammaaa*t107*t119*t56+t553+t552+t551+t550+t549+t5
     8           48+t547+t546+t545+t544+t543+t542+t541+t540-2.3809090855
     9           936d-3*t194*t287*t41*t54+1.9517824d-1*gammaaa*t107*t119
     :           *t54+t539+t538+t537)*t97+t554)-9.920454523306665d-5*t10
     ;           7*t42*t62*t97+t561+t560+t559+t558+t557+t556+t555+t536)*
     <           wght+Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = (t53*(1.0d+0*(-6.200284077066667d
     1           -5*t107*t42*t57*t61+1.0165533333333335d-2*t42*t55*t61+1
     2           .0165533333333335d-2*t42*t55*t60-2.2321022677439997d-4*
     3           gammaaa*t107*t119*t60-1.8600852231200002d-4*t194*t42*t5
     4           8*t59+4.066213333333334d-2*t107*t42*t57*t58+2.033106666
     5           666667d-2*t107*t42*t56*t57-6.696306803232001d-4*gammaaa
     6           *t119*t194*t56*t57-3.3333333333333337d+0*t42*t55*t56+7.
     7           319184000000001d-2*gammaaa*t107*t119*t56+t553+t552+t551
     8           +t550+t549+t548+t547+t546+t545+t544+t543+t542+t541+t540
     9           -1.9344886320448001d-3*t194*t287*t41*t54+1.463836800000
     :           0002d-1*gammaaa*t107*t119*t54+t539+t538+t537)*t97+t554)
     ;           -6.200284077066667d-5*t107*t42*t62*t97+1.01655333333333
     <           35d-2*t1*t121*t55*t97+t562+t560+t558+t556+t555-3.04966d
     =           -3*t1*t311*t55+t536)*wght+Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = (t53*(1.0d+0*(-9.920454523306665d
     1           -5*gammaaa*t107*t119*t60-2.976136356992d-4*gammaaa*t119
     2           *t194*t56*t57+3.2529706666666663d-2*gammaaa*t107*t119*t
     3           56+t553+t552+t551+t550+t549+t548+t547+t546+t545+t544+t5
     4           43+t542+t541+t540-1.1904545427968d-3*t194*t287*t41*t54+
     5           6.505941333333333d-2*gammaaa*t107*t119*t54+t539+t538+t5
     6           37)*t97+t554)+t562+t561+t560+t558+t556+t555+t536)*wght+
     7           Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = (-1.030176d-2*t22*t288*t35*t43*t
     1           9+t569+t568+t567+t566+t565+t564+1.0d+0*rhoa*t22*t35*t39
     2           *(-6.559723505527751d-6*t374*t40*t41*t563-1.63993087638
     3           19376d-6*t124*t188*t45*t49+1.061262590976d-4*t104*t124*
     4           t49-1.6399308763819376d-6*gammaaa*t188*t315*t48+2.12252
     5           5181952d-4*t104*t124*t48-6.559723505527751d-6*t124*t374
     6           *t46*t47+6.367575545856d-4*t124*t188*t45*t46-6.55972350
     7           5527751d-6*gammaaa*t315*t374*t44*t45+6.367575545856d-4*
     8           t124*t188*t44*t45+3.183787772928d-4*gammaaa*t188*t315*t
     9           44-4.120704d-2*t104*t124*t44+1.2735151091712002d-3*gamm
     :           aaa*t188*t315*t40-4.120704d-2*t104*t124*t40)+t1*t123*t4
     ;           3*(-1.28772d-3*t22*t50-1.28772d-3*gammaaa*t120*t22)+6.6
     <           328911936d-6*gammaaa*t104*t123*t22*t42*t50-1.6399308763
     =           819376d-6*t188*t22*t325*t35*t50-2.65315647744d-5*t104*t
     >           125*t22*t32*t50+t123*t39*t478+t123*(t477-5.0d-1*rhoa*t2
     ?           2*t286*t34)-1.030176d-2*t22*t316*t35*t36*t43+2.57544d-3
     @           *t120*t22*t32*t36*t43+1.28772d-3*t1*t126*t22*t32*t43-2.
     1           5d-1*t22*t316*t32*t39+2.122525181952d-4*t104*t120*t22*t
     2           317*t35+5.30631295488d-5*t104*t125*t126*t22*t35+1.0d+0*
     3           rhoa*t22*t286*t32)*wght+Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = t570+Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = t570+Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = (-3.090528d-2*t22*t326*t35*t43*t9+
     1           t578+t577+t576+t575+1.0d+0*rhoa*t22*t35*t39*(-6.5597235
     2           0552775d-6*t188*t45*t49*t574+1.2735151091712002d-3*t104
     3           *t49*t574-2.623889402211101d-5*t374*t46*t47*t574+7.6410
     4           90655027201d-3*t188*t45*t46*t574-4.9448448d-1*t104*t46*
     5           t574-6.55972350552775d-6*gammaaa*t188*t48*t573-2.623889
     6           402211101d-5*gammaaa*t374*t44*t45*t573+3.82054532751360
     7           03d-3*gammaaa*t188*t44*t573-2.623889402211101d-5*t374*t
     8           40*t41*t572)+7.5d-1*gammaaa*t22*t39*t50*t571-3.0d+0*rho
     9           a*t22*t31*t34*t571+7.72632d-3*gammaaa*t22*t323*t36*t43*
     :           t50-6.55972350552775d-6*t188*t22*t35*t50/rhoa**4+7.9594
     ;           69432320001d-5*gammaaa*t104*t123*t22*t317*t50-7.72632d-
     <           3*gammaaa*t123*t126*t22*t36*t43+3.75d-1*gammaaa*t123*t2
     =           2*t326*t39-7.5d-1*gammaaa*t126*t22*t323*t39+6.367575545
     >           856d-4*t104*t126*t136*t22*t35+6.0d+0*rhoa*t22*t31*t323)
     ?           *wght+Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = (t578+t577+t576+t575)*wght+Mmat3(i
     1           q,D3_TA_TA_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = 1/rhoa**3.3333333333333337d+0
              t10 = param(9)
              t11 = param(8)
              t12 = param(11)
              t13 = 1.6d-99*t5*t8*t9+t4*t5*t7+4.0d-50*t1*t12*t5*t6+t10*t
     1           3*t6+4.0d-50*t1*t11*t3+param(7)
              t14 = 1/rhoa**6.666666666666666d-1
              t15 = rhoa**5.0d-1
              t16 = 1/t15
              t17 = 1/rhoa**3.333333333333333d-1
              t18 = 1/rhoa**1.6666666666666666d-1
              t19 = 1.1120374863094686d+1*t18+3.8447462374472113d+0*t17+
     1           1.644733775567609d+0*t16+2.4058712912881916d-1*t14
              t20 = 3.216395899738507d+1/t19+1.0d+0
              t21 = log(t20)
              t22 = 1.274696188700087d-1*t17+1.0d+0
              t23 = 5.982550435771079d+0*t18+2.2255694211506874d+0*t17+8
     1           .004286349993635d-1*t16+1.8970043257475583d-1*t14
              t24 = 1.6081979498692536d+1/t23+1.0d+0
              t25 = log(t24)
              t26 = 1.3256889990520176d-1*t17+1.0d+0
              t27 = -6.903522198342671d-18*t25*t26-3.1090699999999993d-2
     1           *t21*t22
              t28 = 2.4d-51*t1+1.0d+0
              t29 = 1/t28
              t30 = param(22)
              t31 = 2.4d-51*t1*t29*t30+param(21)
              t32 = 2.4d-51*t1*t29*t31+param(20)
              t33 = 2.4d-51*t1*t29*t32+param(19)
              t34 = 2.4d-51*t1*t29*t33+param(18)
              t35 = 3.04966d-3*(1.2d-49*t1-1.823119944d+1)+1.0d+0
              t36 = 1/t35
              t37 = param(6)
              t38 = 1/t35**2
              t39 = 4.0d-50*t1-1.823119944d+1
              t40 = t39**2
              t41 = param(4)
              t42 = param(3)
              t43 = param(2)
              t44 = param(5)
              t45 = 6.4d-99*t38*t41*t9+8.0d-50*t1*t38*t39*t44+8.0d-50*t1
     1           *t36*t43+t36*t39*t42+t37*t38*t40+param(1)
              t46 = -2*rhoa*t27
              t47 = t46-1.243628d-1*rhoa*(1.0522000558389212d-1*t17+1.0d
     1           +0)*log(1.6081979498692536d+1/(5.329846514438383d+0*t18
     2           +1.766435620181429d+0*t17+5.659885156639418d-1*t16+1.19
     3           503784087549d-1*t14)+1.0d+0)
              t48 = 2.4799999999999997d-52*t1+1.0d+0
              t49 = 1/t48
              t50 = param(17)
              t51 = 2.4799999999999997d-52*t1*t49*t50+param(16)
              t52 = 2.4799999999999997d-52*t1*t49*t51+param(15)
              t53 = 2.4799999999999997d-52*t1*t49*t52+param(14)
              t54 = 2.4799999999999997d-52*t1*t49*t53+param(13)
              t55 = 1/t24
              t56 = 1/t15**3
              t57 = 1/rhoa**1.3333333333333333d+0
              t58 = 1/rhoa**1.1666666666666667d+0
              t59 = -9.970917392951799d-1*t58-7.418564737168958d-1*t57-4
     1           .002143174996817d-1*t56-1.264669550498372d-1*t1
              t60 = 1/t23**2
              t61 = 1/t20
              t62 = -1.8533958105157808d+0*t58-1.2815820791490704d+0*t57
     1           -8.223668877838045d-1*t56-1.6039141941921276d-1*t1
              t63 = 1/t19**2
              t64 = 1.0d+0*t22*t61*t62*t63+1.1102230246251565d-16*t26*t5
     1           5*t59*t60+3.0506411443514264d-19*t25*t57+1.321039893133
     2           9265d-3*t21*t57
              t65 = 1/t28**2
              t66 = 1/rhoa**4.333333333333333d+0
              t67 = 1/rhoa**2.6666666666666666d+0
              t68 = 9.6d-102*t30*t65*t66-4.0d-51*t29*t30*t67
              t69 = 2.4d-51*t1*t29*t68-4.0d-51*t29*t31*t67+9.6d-102*t31*
     1           t65*t66
              t70 = 2.4d-51*t1*t29*t69-4.0d-51*t29*t32*t67+9.6d-102*t32*
     1           t65*t66
              t71 = 2.4d-51*t1*t29*t70-4.0d-51*t29*t33*t67+9.6d-102*t33*
     1           t65*t66
              t72 = 6.299605249474366d-1
              t73 = 1.414213562373095d+0
              t74 = 1/t73
              t75 = 7.937005259840998d-1
              t76 = 8.908987181403393d-1
              t77 = 5.982550435771079d+0*t18*t76+2.2255694211506874d+0*t
     1           17*t75+8.004286349993635d-1*t16*t74+1.8970043257475583d
     2           -1*t14*t72
              t78 = 1.6081979498692536d+1/t77+1.0d+0
              t79 = log(t78)
              t80 = 1.3256889990520176d-1*t17*t75+1.0d+0
              t81 = 1/t78
              t82 = 3.149802624737183d-1
              t83 = 1/t73**3
              t84 = 3.968502629920499d-1
              t85 = 4.4544935907016964d-1
              t86 = -9.970917392951799d-1*t58*t85-7.418564737168958d-1*t
     1           57*t84-4.002143174996817d-1*t56*t83-1.264669550498372d-
     2           1*t1*t82
              t87 = 1/t77**2
              t88 = 2*rhoa*(1.0d+0*t80*t81*t86*t87+2.747773264188437d-3*
     1           t57*t79*t84)-6.21814d-2*t79*t80-rhoa*t64+6.903522198342
     2           671d-18*t25*t26+3.1090699999999993d-2*t21*t22
              t89 = 1/t2**3
              t90 = 1/rhoa**6
              t91 = 1.6482816d-150*t8*t89*t90+1.030176d-51*t4*t67*t7*t89
     1           +4.1207039999999995d-101*t12*t6*t66*t89-5.3333333333333
     2           34d-99*t5*t66*t8-6.666666666666666d-50*t4*t5*t6*t67-6.6
     3           66666666666666d-50*t12*t5*t6*t67+5.15088d-52*t10*t5*t6*
     4           t67-6.666666666666666d-50*t11*t3*t67-3.333333333333333d
     5           -50*t10*t3*t67-1.3333333333333333d-99*t12*t5*t66+2.0603
     6           519999999997d-101*t11*t5*t66
              t92 = 5.0d-1*rhoa*t27*t91+5.0d-1*rhoa*t13*t64+5.0d-1*t13*t
     1           27
              t93 = t46-1.243628d-1*rhoa*t79*t80
              t94 = 1/t48**2
              t95 = 5.125333333333333d-104*t50*t66*t94-2.066666666666666
     1           7d-52*t49*t50*t67
              t96 = 2.4799999999999997d-52*t1*t49*t95+5.125333333333333d
     1           -104*t51*t66*t94-2.0666666666666667d-52*t49*t51*t67
              t97 = 2.4799999999999997d-52*t1*t49*t96+5.125333333333333d
     1           -104*t52*t66*t94-2.0666666666666667d-52*t49*t52*t67
              t98 = 2.4799999999999997d-52*t1*t49*t97+5.125333333333333d
     1           -104*t53*t66*t94-2.0666666666666667d-52*t49*t53*t67
              t99 = 1/t35**3
              t100 = 3.9035648d-150*t41*t90*t99+6.09932d-52*t37*t40*t67*
     1           t99+4.8794560000000003d-101*t39*t44*t66*t99-6.666666666
     2           666666d-50*t38*t39*t44*t67-6.666666666666666d-50*t36*t4
     3           3*t67+3.04966d-52*t38*t39*t42*t67-3.333333333333333d-50
     4           *t36*t42*t67-6.666666666666666d-50*t37*t38*t39*t67-2.66
     5           66666666666666d-99*t38*t44*t66+2.4397280000000002d-101*
     6           t38*t43*t66-1.0666666666666666d-98*t38*t41*t66
              t101 = 1.0d+0*t100*t93+1.0d+0*t45*t88
              t102 = 2.57544d-52*t27*t91+2.57544d-52*t13*t64
              t103 = 1/t24**2
              t104 = t59**2
              t105 = 1/t23**4
              t106 = 1/t23**3
              t107 = 1/t15**5
              t108 = 1/rhoa**2.3333333333333334d+0
              t109 = 1/rhoa**2.1666666666666665d+0
              t110 = 2.1077825841639536d-1*t67+1.1632736958443765d+0*t10
     1           9+9.89141964955861d-1*t108+6.003214762495226d-1*t107
              t111 = 1/t20**2
              t112 = t62**2
              t113 = 1/t19**4
              t114 = 1/t19**3
              t115 = 2.673190323653546d-1*t67+2.1622951122684114d+0*t109
     1           +1.7087761055320938d+0*t108+1.2335503316757068d+0*t107
              t116 = -8.497974591333913d-2*t57*t61*t62*t63+1.0d+0*t115*t
     1           22*t61*t63-2.0d+0*t112*t114*t22*t61-9.812069668265515d-
     2           18*t55*t57*t59*t60+1.1102230246251565d-16*t110*t26*t55*
     3           t60-2.220446049250313d-16*t104*t106*t26*t55+1.785458392
     4           0998188d-15*t103*t104*t105*t26-4.0675215258019015d-19*t
     5           108*t25+3.216395899738507d+1*t111*t112*t113*t22-1.76138
     6           65241785684d-3*t108*t21
              t117 = 1/t28**3
              t118 = 1/rhoa**7
              t119 = 1/rhoa**5.333333333333333d+0
              t120 = 1/rhoa**3.6666666666666664d+0
              t121 = -5.76d-101*t119*t30*t65+1.0666666666666666d-50*t120
     1           *t29*t30+7.68d-152*t117*t118*t30
              t122 = -8.0d-51*t29*t67*t68+1.92d-101*t65*t66*t68-5.76d-10
     1           1*t119*t31*t65+1.0666666666666666d-50*t120*t29*t31+7.68
     2           d-152*t117*t118*t31+2.4d-51*t1*t121*t29
              t123 = -8.0d-51*t29*t67*t69+1.92d-101*t65*t66*t69-5.76d-10
     1           1*t119*t32*t65+1.0666666666666666d-50*t120*t29*t32+7.68
     2           d-152*t117*t118*t32+2.4d-51*t1*t122*t29
              t124 = -8.0d-51*t29*t67*t70+1.92d-101*t65*t66*t70-5.76d-10
     1           1*t119*t33*t65+1.0666666666666666d-50*t120*t29*t33+7.68
     2           d-152*t117*t118*t33+2.4d-51*t1*t123*t29
              t125 = 2.0d+0*t88*t98
              t126 = 2.0d+0*t80*t81*t86*t87
              t127 = 5.495546528376875d-3*t57*t79*t84
              t128 = 1/t78**2
              t129 = t86**2
              t130 = 1/t77**4
              t131 = 1.6081979498692536d+1*t128*t129*t130*t80
              t132 = 1/t77**3
              t133 = -2.0d+0*t129*t132*t80*t81
              t134 = 1.9842513149602492d-1
              t135 = 6.003214762495226d-1*t107/t73**5+3.319549557987472d
     1           -2*t67+9.89141964955861d-1*t108*t134+2.5908976111853255
     2           d-1*t109
              t136 = 1.0d+0*t135*t80*t81*t87
              t137 = -3.663697685584583d-3*t108*t134*t79
              t138 = 8.157414703487641d+0*t18*t76+2.247591863577616d+0*t
     1           17*t75+4.3009724712766434d-1*t16*t74+1.9115125951273373
     2           d-1*t14*t72
              t139 = 2.9608813203268075d+1/t138+1.0d+0
              t140 = log(t139)
              t141 = 6.901399211255825d-2*t17*t75+1.0d+0
              t142 = 1/rhoa**2
              t143 = -8.837926660346784d-2*t57*t81*t84*t86*t87
              t144 = -2.0d+0*t22*t61*t62*t63-2.220446049250313d-16*t26*t
     1           55*t59*t60-6.101282288702853d-19*t25*t57-2.642079786267
     2           853d-3*t21*t57+2*rhoa*(t143+8.443431970194815d-3*t140*t
     3           141*t142+t137+t136+t133+t131)+t127+t126-rhoa*t116
              t145 = 1/t2**4
              t146 = 1/rhoa**8.666666666666666d+0
              t147 = -1.53839616d-149*t118*t8*t89-2.747136d-51*t120*t4*t
     1           7*t89-1.373568d-100*t119*t4*t6*t89-2.4724223999999997d-
     2           100*t119*t12*t6*t89+5.306312954879999d-103*t10*t119*t6*
     3           t89-2.7471359999999995d-150*t118*t12*t89+2.122525181951
     4           9997d-152*t11*t118*t89+2.3111111111111113d-98*t119*t5*t
     5           8+2.5470302183424d-201*t145*t146*t8+1.5918938864639998d
     6           -102*t119*t145*t4*t7+1.7777777777777776d-49*t120*t4*t5*
     7           t6+1.7777777777777776d-49*t12*t120*t5*t6-1.373568d-51*t
     8           10*t120*t5*t6+6.367575545855999d-152*t118*t12*t145*t6+2
     9           .222222222222222d-99*t119*t4*t5+8.0d-99*t119*t12*t5-1.2
     :           362111999999999d-100*t11*t119*t5-3.43392d-101*t10*t119*
     ;           t5+1.7777777777777776d-49*t11*t120*t3+8.888888888888888
     <           d-50*t10*t120*t3
              t148 = 1.0d+0*rhoa*t64*t91+1.0d+0*t27*t91+1.0d+0*t13*t64+5
     1           .0d-1*rhoa*t147*t27+5.0d-1*rhoa*t116*t13
              t149 = 1.86008522312d-103*t119*t45*t93*t99
              t150 = 1/t48**3
              t151 = 2.118471111111111d-155*t118*t150*t53
              t152 = 1.0250666666666666d-103*t66*t94*t97
              t153 = -4.1333333333333333d-52*t49*t67*t97
              t154 = 2.118471111111111d-155*t118*t150*t52
              t155 = 1.0250666666666666d-103*t66*t94*t96
              t156 = -4.1333333333333333d-52*t49*t67*t96
              t157 = 2.118471111111111d-155*t118*t150*t51
              t158 = 1.0250666666666666d-103*t66*t94*t95
              t159 = -4.1333333333333333d-52*t49*t67*t95
              t160 = 2.118471111111111d-155*t118*t150*t50
              t161 = -2.2209777777777773d-103*t119*t50*t94+5.51111111111
     1           111d-52*t120*t49*t50+t160
              t162 = -2.2209777777777773d-103*t119*t51*t94+5.51111111111
     1           111d-52*t120*t49*t51+2.4799999999999997d-52*t1*t161*t49
     2           +t159+t158+t157
              t163 = -2.2209777777777773d-103*t119*t52*t94+5.51111111111
     1           111d-52*t120*t49*t52+2.4799999999999997d-52*t1*t162*t49
     2           +t156+t155+t154
              t164 = -2.2209777777777773d-103*t119*t53*t94+5.51111111111
     1           111d-52*t120*t49*t53+2.4799999999999997d-52*t1*t163*t49
     2           +t153+t152+t151
              t165 = 5.15088d-52*t92-4.2923999999999995d-52*t13*t27
              t166 = 2.0d+0*t100*t88
              t167 = 1/t35**4
              t168 = 3.5713636283903993d-201*t146*t167*t41
              t169 = 1.488068178496d-152*t118*t43*t99
              t170 = -3.252970666666667d-150*t118*t44*t99
              t171 = 4.4642045354879994d-152*t118*t167*t39*t44
              t172 = -2.0331066666666667d-101*t119*t38*t42
              t173 = 2.222222222222222d-99*t119*t37*t38
              t174 = 5.580255669359999d-103*t119*t167*t37*t40
              t175 = 1.86008522312d-103*t119*t39*t42*t99
              t176 = -8.132426666666667d-101*t119*t37*t39*t99
              t177 = -2.1144309333333333d-100*t119*t39*t44*t99-2.3421388
     1           800000004d-149*t118*t41*t99-1.6264853333333332d-51*t120
     2           *t37*t40*t99+1.7777777777777776d-49*t120*t38*t39*t44+1.
     3           1555555555555555d-98*t119*t38*t44-1.0572154666666667d-1
     4           00*t119*t38*t43+1.7777777777777776d-49*t120*t36*t43-8.1
     5           32426666666666d-52*t120*t38*t39*t42+8.888888888888888d-
     6           50*t120*t36*t42+3.733333333333333d-98*t119*t38*t41+1.77
     7           77777777777776d-49*t120*t37*t38*t39+t176+t175+t174+t173
     8           +t172+t171+t170+t169+t168
              t178 = 1.0d+0*t177*t93+1.0d+0*t144*t45+t166
              t179 = 3.04966d-52*t45*t88
              t180 = 3.04966d-52*t100*t93
              t181 = t180+t179+3.04966d-52*t101
              t182 = -8.443431970194815d-3*t140*t141*t142
              t183 = 2*rhoa*(t182+t143+t137+t136+t133+t131)+t127+t126
              t184 = t160-8.542222222222222d-104*t119*t50*t94
              t185 = -8.542222222222222d-104*t119*t51*t94+2.479999999999
     1           9997d-52*t1*t184*t49+t159+t158+t157
              t186 = -8.542222222222222d-104*t119*t52*t94+2.479999999999
     1           9997d-52*t1*t185*t49+t156+t155+t154
              t187 = -8.542222222222222d-104*t119*t53*t94+2.479999999999
     1           9997d-52*t1*t186*t49+t153+t152+t151
              t188 = -8.132426666666667d-101*t119*t39*t44*t99-1.30118826
     1           66666666d-149*t118*t41*t99+4.444444444444444d-99*t119*t
     2           38*t44-4.0662133333333333d-101*t119*t38*t43+8.888888888
     3           888888d-99*t119*t38*t41+t176+t175+t174+t173+t172+t171+t
     4           170+t169+t168
              t189 = 1.0d+0*t188*t93+1.0d+0*t183*t45+t166
              t190 = t59**3
              t191 = 1/t15**7
              t192 = 1/rhoa**3.1666666666666665d+0
              t193 = t62**3
              t194 = 9.490883560204437d-19*t25*t9+4.1099018897499934d-3*
     1           t21*t9+1.1102230246251565d-16*t26*t55*t60*(-2.307997918
     2           2303428d+0*t9-2.520426340996149d+0*t192-1.5008036906238
     3           065d+0*t191-5.620753557770543d-1*t120)+1.0d+0*t22*t61*t
     4           63*(-3.9871442462415524d+0*t9-4.684972743248224d+0*t192
     5           -3.083875829189267d+0*t191-7.128507529742789d-1*t120)+1
     6           .6995949182667827d-1*t108*t61*t62*t63-1.274696188700087
     7           d-1*t115*t57*t61*t63-6.0d+0*t114*t115*t22*t61*t62+9.649
     8           187699215522d+1*t111*t113*t115*t22*t62+2.54939237740017
     9           4d-1*t112*t114*t57*t61+6.0d+0*t113*t193*t22*t61+1.96241
     :           3933653103d-17*t108*t55*t59*t60-1.4718104502398274d-17*
     ;           t110*t55*t57*t60-6.661338147750939d-16*t106*t110*t26*t5
     <           5*t59+5.356375176299456d-15*t103*t105*t110*t26*t59+2.94
     =           3620900479655d-17*t104*t106*t55*t57-4.0999275947472624d
     >           +0*t111*t112*t113*t57-2.3669625486718335d-16*t103*t104*
     ?           t105*t57+6.661338147750939d-16*t105*t190*t26*t55+5.7427
     @           41051503565d-14*t190*t26/(t23**6*t24**3)-1.071275035259
     1           8913d-14*t103*t190*t26/t23**5+2.0690405167709364d+3*t19
     2           3*t22/(t19**6*t20**3)-1.9298375398431045d+2*t111*t193*t
     3           22/t19**5
              t195 = 1/t28**4
              t196 = 1/rhoa**9.666666666666666d+0
              t197 = 1/rhoa**8
              t198 = 1/rhoa**6.333333333333333d+0
              t199 = 1/rhoa**4.666666666666667d+0
              t200 = 4.824593849607761d+1*t128*t129*t130*t80
              t201 = -6.0d+0*t129*t132*t80*t81
              t202 = 3.0d+0*t135*t80*t81*t87
              t203 = -1.099109305675375d-2*t108*t134*t79
              t204 = -2.6513779981040353d-1*t57*t81*t84*t86*t87
              t205 = t86**3
              t206 = 5.172601291927341d+2*t205*t80/(t77**6*t78**3)
              t207 = -9.649187699215522d+1*t128*t205*t80/t77**5
              t208 = 6.0d+0*t130*t205*t80*t81
              t209 = 4.824593849607761d+1*t128*t130*t135*t80*t86
              t210 = -6.0d+0*t132*t135*t80*t81*t86
              t211 = 9.921256574801247d-2
              t212 = 1.0d+0*t80*t81*t87*(-2.3079979182303428d+0*t211*t9-
     1           1.5008036906238065d+0*t191/t73**7-2.8068057454507694d-1
     2           *t192-4.4260660773166294d-2*t120)
              t213 = 8.548627933030694d-3*t211*t79*t9
              t214 = 1/rhoa**3
              t215 = 1.767585332069357d-1*t108*t134*t81*t86*t87
              t216 = 1/t139
              t217 = -1.3595691172479402d+0*t58*t85-7.491972878592053d-1
     1           *t57*t84-2.1504862356383217d-1*t56*t83-1.27434173008489
     2           14d-1*t1*t82
              t218 = 1/t138**2
              t219 = -2.1319703304396778d+0*t128*t129*t130*t57*t84
              t220 = 2.6513779981040353d-1*t129*t132*t57*t81*t84
              t221 = -1.3256889990520176d-1*t135*t57*t81*t84*t87
              t222 = 2*rhoa*(-5.82714947393947d-4*t140*t84*t9+t221+t220+
     1           t219-7.5d-1*t141*t142*t216*t217*t218+t215-2.53302959105
     2           8444d-2*t140*t141*t214+t213+t212+t210+t209+t208+t207+t2
     3           06)+2.549392377400174d-1*t57*t61*t62*t63-3.0d+0*t115*t2
     4           2*t61*t63+6.0d+0*t112*t114*t22*t61+2.943620900479655d-1
     5           7*t55*t57*t59*t60-3.3306690738754696d-16*t110*t26*t55*t
     6           60+6.661338147750939d-16*t104*t106*t26*t55-5.3563751762
     7           99456d-15*t103*t104*t105*t26+1.2202564577405706d-18*t10
     8           8*t25-9.649187699215522d+1*t111*t112*t113*t22+5.2841595
     9           72535705d-3*t108*t21+t204+t203+t202+t201+t200-rhoa*t194
     :           +2.5330295910584444d-2*t140*t141*t142
              t223 = 1/t2**5
              t224 = 1/rhoa**1.1333333333333334d+1
              t225 = 1.7017882504620416d-154*t167*t197*t45*t93
              t226 = 1/t48**4
              t227 = 1.3134520888888887d-206*t196*t226*t53
              t228 = 6.355413333333333d-155*t118*t150*t97
              t229 = 1.3134520888888887d-206*t196*t226*t52
              t230 = 6.355413333333333d-155*t118*t150*t96
              t231 = 1.3134520888888887d-206*t196*t226*t51
              t232 = 6.355413333333333d-155*t118*t150*t95
              t233 = 1.3134520888888887d-206*t196*t226*t50
              t234 = 1/t35**5
              t235 = 4.3565779211828265d-252*t224*t234*t41
              t236 = 1.3614306003696333d-203*t167*t196*t43
              t237 = -4.4642045354879994d-201*t167*t196*t44
              t238 = 5.445722401478533d-203*t196*t234*t39*t44
              t239 = -1.8600852231199996d-152*t197*t42*t99
              t240 = 4.066213333333333d-150*t197*t37*t99
              t241 = 6.807153001848166d-154*t197*t234*t37*t40
              t242 = 1.7017882504620416d-154*t167*t197*t39*t42
              t243 = -1.1160511338719999d-151*t167*t197*t37*t39
              t244 = t120*t38*(-8.132426666666666d-52*t100*t93-8.1324266
     1           66666666d-52*t45*t88)
              t245 = 6.09932d-52*t100*t88
              t246 = 1.86008522312d-103*t45*t88
              t247 = 1.86008522312d-103*t100*t93
              t248 = 2*rhoa*(1.9423831579798237d-4*t140*t84*t9+t221+t220
     1           +t219+2.5d-1*t141*t142*t216*t217*t218+t215+8.4434319701
     2           94815d-3*t140*t141*t214+t213+t212+t210+t209+t208+t207+t
     3           206)+t204+t203+t202+t201+t200+t182
              fnc(iq) = (1.0d+0*t47*t54+1.0d+0*t36*t45*t47+1.0d+0*rhoa*t
     1           27*t34+1.0d+0*rhoa*t13*t27*t3)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t93*t98+3.04966d-52*t38*t45*t67*t
     1           93+t3*t92+1.0d+0*t54*t88+5.0d-1*rhoa*t27*t71+5.0d-1*rho
     2           a*t34*t64+2.57544d-52*t1*t13*t27*t5+t101*t36+5.0d-1*t27
     3           *t34)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (-8.132426666666666d-52*t120*t38*t45*
     1           t93+1.0d+0*t164*t93+2.6531564774399996d-103*t13*t27*t66
     2           *t89+1.0d+0*rhoa*t64*t71+1.0d+0*t27*t71+t165*t5*t67+t18
     3           1*t38*t67+1.0d+0*t34*t64+1.0d+0*t144*t54+t1*t102*t5+t17
     4           8*t36+5.0d-1*rhoa*t116*t34+t148*t3+5.0d-1*rhoa*t124*t27
     5           +t149+t125)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t187*t93+(t180+t179)*t38*t67+
     1           3.04966d-52*t101*t38*t67+1.0d+0*t183*t54+t189*t36+t149+
     2           t125)*wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Amat3(iq,D3_RA_RA_RA) = (t36*(1.0d+0*t93*(1.12769649777777
     1           76d-99*t198*t39*t44*t99+3.415619199999999d-149*t197*t44
     2           *t99-1.5624715874207998d-151*t197*t43*t99-1.48806817849
     3           59998d-102*t198*t39*t42*t99+1.585281038222222d-148*t197
     4           *t41*t99+5.963779555555554d-51*t199*t37*t40*t99+6.50594
     5           1333333333d-100*t198*t37*t39*t99-6.518518518518518d-49*
     6           t199*t38*t39*t44-4.6874147622623996d-151*t167*t197*t39*
     7           t44-6.162962962962963d-98*t198*t38*t44+5.63848248888888
     8           7d-100*t198*t38*t43-6.518518518518518d-49*t199*t36*t43+
     9           2.981889777777777d-51*t199*t38*t39*t42+1.62648533333333
     :           32d-100*t198*t38*t42-3.259259259259259d-49*t199*t36*t42
     ;           -1.754074074074074d-97*t198*t38*t41-4.6427727169075195d
     <           -200*t167*t196*t41-4.4642045354879994d-102*t167*t198*t3
     =           7*t40-6.518518518518518d-49*t199*t37*t38*t39-1.77777777
     >           77777776d-98*t198*t37*t38+t243+t242+t241+t240+t239+t238
     ?           +t237+t236+t235)+3.0d+0*t177*t88+1.0d+0*t222*t45+3.0d+0
     @           *t100*t144)-1.4880681784959998d-102*t198*t45*t93*t99+t1
     1           19*(t247+t246+6.09932d-52*t181)*t99+3.0d+0*t144*t98+1.0
     2           d+0*t93*(-6.662933333333332d-103*t119*t94*t97+1.6533333
     3           333333333d-51*t120*t49*t97+2.4799999999999997d-52*t1*t4
     4           9*(-6.662933333333332d-103*t119*t94*t96+1.6533333333333
     5           333d-51*t120*t49*t96+2.4799999999999997d-52*t1*t49*(-6.
     6           662933333333332d-103*t119*t94*t95+1.6533333333333333d-5
     7           1*t120*t49*t95+2.4799999999999997d-52*t1*t49*(1.1845214
     8           814814811d-102*t198*t50*t94-2.0207407407407404d-51*t199
     9           *t49*t50-2.2243946666666667d-154*t150*t197*t50+t233)+1.
     :           5375999999999998d-103*t161*t66*t94+1.1845214814814811d-
     ;           102*t198*t51*t94-6.2d-52*t161*t49*t67-2.020740740740740
     <           4d-51*t199*t49*t51-2.2243946666666667d-154*t150*t197*t5
     =           1+t232+t231)+1.5375999999999998d-103*t162*t66*t94+1.184
     >           5214814814811d-102*t198*t52*t94-6.2d-52*t162*t49*t67-2.
     ?           0207407407407404d-51*t199*t49*t52-2.2243946666666667d-1
     @           54*t150*t197*t52+t230+t229)+1.5375999999999998d-103*t16
     1           3*t66*t94+1.1845214814814811d-102*t198*t53*t94-6.2d-52*
     2           t163*t49*t67-2.0207407407407404d-51*t199*t49*t53-2.2243
     3           946666666667d-154*t150*t197*t53+t228+t227)+t38*t67*(3.0
     4           4966d-52*t177*t93+3.04966d-52*t144*t45+t245+6.09932d-52
     5           *t178)+2.981889777777777d-51*t199*t38*t45*t93+t3*(3.0d+
     6           0*t64*t91+1.5d+0*rhoa*t116*t91+5.0d-1*rhoa*t27*(1.31496
     7           2432d-148*t197*t8*t89+1.0072832d-50*t199*t4*t7*t89+1.09
     8           88544d-99*t198*t4*t6*t89+1.50176768d-99*t12*t198*t6*t89
     9           -4.2450503639039994d-102*t10*t198*t6*t89+6.86784d-150*t
     :           197*t4*t89+3.5712767999999995d-149*t12*t197*t89-2.75928
     ;           27365375994d-151*t11*t197*t89-5.30631295488d-152*t10*t1
     <           97*t89-1.2325925925925926d-97*t198*t5*t8+5.247778804422
     =           2d-252*t223*t224*t8-4.58465439301632d-200*t145*t196*t8+
     >           3.279861752763875d-153*t197*t223*t4*t7-1.27351510917119
     ?           96d-101*t145*t198*t4*t7-6.518518518518518d-49*t199*t4*t
     @           5*t6-6.518518518518518d-49*t12*t199*t5*t6+5.03641599999
     1           9999d-51*t10*t199*t5*t6-3.1837877729279995d-151*t145*t1
     2           97*t4*t6+1.31194470110555d-202*t12*t196*t223*t6-8.27784
     3           8209612798d-151*t12*t145*t197*t6+8.199654381909687d-154
     4           *t10*t145*t197*t6-1.7777777777777776d-98*t198*t4*t5-4.8
     5           592592592592593d-98*t12*t198*t5+7.508838399999999d-100*
     6           t11*t198*t5+2.7471359999999995d-100*t10*t198*t5-6.51851
     7           8518518518d-49*t11*t199*t3-3.259259259259259d-49*t10*t1
     8           99*t3-6.367575545855999d-201*t12*t145*t196+3.2798617527
     9           638746d-203*t11*t145*t196)+1.5d+0*rhoa*t147*t64+1.5d+0*
     :           t147*t27+5.0d-1*rhoa*t13*t194+1.5d+0*t116*t13)+t1*t5*(5
     ;           .15088d-52*t64*t91+2.57544d-52*t147*t27+2.57544d-52*t11
     <           6*t13)+t66*t89*(2.6531564774399996d-103*t27*t91+2.65315
     =           64774399996d-103*t13*t64+1.030176d-51*t102)+t5*t67*(-4.
     >           2923999999999995d-52*t27*t91-4.2923999999999995d-52*t13
     ?           *t64+1.030176d-51*t148)+t119*(1.030176d-51*t165-1.14970
     @           11402239997d-102*t13*t27)*t89+3.0d+0*t164*t88+3.0d+0*t6
     1           4*t71+1.5d+0*rhoa*t116*t71+5.0d-1*rhoa*t27*(-1.72799999
     2           99999998d-100*t119*t65*t70+3.2d-50*t120*t29*t70+2.30400
     3           00000000002d-151*t117*t118*t70+2.4d-51*t1*t29*(-1.72799
     4           99999999998d-100*t119*t65*t69+3.2d-50*t120*t29*t69+2.30
     5           40000000000002d-151*t117*t118*t69+2.4d-51*t1*t29*(-1.72
     6           79999999999998d-100*t119*t65*t68+3.2d-50*t120*t29*t68+2
     7           .3040000000000002d-151*t117*t118*t68-1.2d-50*t121*t29*t
     8           67+2.88d-101*t121*t65*t66+2.4d-51*t1*t29*(3.49866666666
     9           66666d-100*t198*t30*t65-3.911111111111111d-50*t199*t29*
     :           t30-9.984000000000001d-151*t117*t197*t30+9.216000000000
     ;           001d-202*t195*t196*t30)+3.4986666666666666d-100*t198*t3
     <           1*t65-3.911111111111111d-50*t199*t29*t31-9.984000000000
     =           001d-151*t117*t197*t31+9.216000000000001d-202*t195*t196
     >           *t31)-1.2d-50*t122*t29*t67+2.88d-101*t122*t65*t66+3.498
     ?           6666666666666d-100*t198*t32*t65-3.911111111111111d-50*t
     @           199*t29*t32-9.984000000000001d-151*t117*t197*t32+9.2160
     1           00000000001d-202*t195*t196*t32)-1.2d-50*t123*t29*t67+2.
     2           88d-101*t123*t65*t66+3.4986666666666666d-100*t198*t33*t
     3           65-3.911111111111111d-50*t199*t29*t33-9.984000000000001
     4           d-151*t117*t197*t33+9.216000000000001d-202*t195*t196*t3
     5           3)-1.6666666666666669d+0*t102*t5*t67+1.5d+0*rhoa*t124*t
     6           64+1.0d+0*t222*t54-2.6666666666666666d+0*t120*t165*t5-2
     7           .6666666666666666d+0*t120*t181*t38+5.0d-1*rhoa*t194*t34
     8           +1.5d+0*t116*t34+4.0998271909548434d-154*t118*t13*t145*
     9           t27+1.5d+0*t124*t27+t244+t225)*wght+Amat3(iq,D3_RA_RA_R
     :           A)
              Amat3(iq,D3_RA_RA_RB) = (t36*(1.0d+0*t93*(2.16864711111111
     1           1d-100*t198*t39*t44*t99+1.6807015111111112d-149*t197*t4
     2           4*t99-7.688352255562666d-152*t197*t43*t99-4.96022726165
     3           3333d-103*t198*t39*t42*t99+5.096320711111111d-149*t197*
     4           t41*t99+2.168647111111111d-100*t198*t37*t39*t99-2.30650
     5           56766687997d-151*t167*t197*t39*t44-1.1851851851851851d-
     6           98*t198*t38*t44+1.0843235555555555d-100*t198*t38*t43+5.
     7           421617777777777d-101*t198*t38*t42-2.3703703703703702d-9
     8           8*t198*t38*t41-2.7380454484326394d-200*t167*t196*t41-1.
     9           4880681784959998d-102*t167*t198*t37*t40-5.9259259259259
     :           26d-99*t198*t37*t38+t243+t242+t241+t240+t239+t238+t237+
     ;           t236+t235)+2.0d+0*t188*t88+1.0d+0*t177*t88+1.0d+0*t248*
     <           t45+2.0d+0*t100*t183+1.0d+0*t100*t144)-4.96022726165333
     =           3d-103*t198*t45*t93*t99+t119*(t247+t246)*t99+6.09932d-5
     >           2*t119*t181*t99+2.0d+0*t183*t98+1.0d+0*t144*t98+1.0d+0*
     ?           t93*(-3.929422222222222d-103*t119*t94*t97+5.51111111111
     @           111d-52*t120*t49*t97+2.4799999999999997d-52*t1*t49*(-3.
     1           929422222222222d-103*t119*t94*t96+5.51111111111111d-52*
     2           t120*t49*t96+2.4799999999999997d-52*t1*t49*(-3.92942222
     3           2222222d-103*t119*t94*t95+5.51111111111111d-52*t120*t49
     4           *t95+2.4799999999999997d-52*t1*t49*(2.2779259259259252d
     5           -103*t198*t50*t94-1.0945434074074073d-154*t150*t197*t50
     6           +t233)+1.0250666666666666d-103*t184*t66*t94+5.125333333
     7           333333d-104*t161*t66*t94+2.2779259259259252d-103*t198*t
     8           51*t94-4.1333333333333333d-52*t184*t49*t67-2.0666666666
     9           666667d-52*t161*t49*t67-1.0945434074074073d-154*t150*t1
     :           97*t51+t232+t231)+1.0250666666666666d-103*t185*t66*t94+
     ;           5.125333333333333d-104*t162*t66*t94+2.2779259259259252d
     <           -103*t198*t52*t94-4.1333333333333333d-52*t185*t49*t67-2
     =           .0666666666666667d-52*t162*t49*t67-1.0945434074074073d-
     >           154*t150*t197*t52+t230+t229)+1.0250666666666666d-103*t1
     ?           86*t66*t94+5.125333333333333d-104*t163*t66*t94+2.277925
     @           9259259252d-103*t198*t53*t94-4.1333333333333333d-52*t18
     1           6*t49*t67-2.0666666666666667d-52*t163*t49*t67-1.0945434
     2           074074073d-154*t150*t197*t53+t228+t227)+t38*t67*(3.0496
     3           6d-52*t188*t93+3.04966d-52*t183*t45+t245+3.04966d-52*t1
     4           89)+2.0d+0*t187*t88+1.0d+0*t164*t88+3.04966d-52*t178*t3
     5           8*t67+1.0d+0*t248*t54+t244+t225)*wght+Amat3(iq,D3_RA_RA
     6           _RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = param(17)
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = gammaaa*t2
              t4 = 1/rhob**2.6666666666666666d+0
              t5 = gammabb*t4
              t6 = t5+t3
              t7 = 3.1d-3*t6+1.0d+0
              t8 = 1/t7
              t9 = 3.1d-3*t1*t6*t8+param(16)
              t10 = 3.1d-3*t6*t8*t9+param(15)
              t11 = 3.1d-3*t10*t6*t8+param(14)
              t12 = 3.1d-3*t11*t6*t8+param(13)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/rhob**6.666666666666666d-1
              t28 = rhob**5.0d-1
              t29 = 1/t28
              t30 = 1/rhob**3.333333333333333d-1
              t31 = 1/rhob**1.6666666666666666d-1
              t32 = 1.1120374863094686d+1*t31+3.8447462374472113d+0*t30+
     1           1.644733775567609d+0*t29+2.4058712912881916d-1*t27
              t33 = 3.216395899738507d+1/t32+1.0d+0
              t34 = log(t33)
              t35 = 1.274696188700087d-1*t30+1.0d+0
              t36 = 5.982550435771079d+0*t31+2.2255694211506874d+0*t30+8
     1           .004286349993635d-1*t29+1.8970043257475583d-1*t27
              t37 = 1.6081979498692536d+1/t36+1.0d+0
              t38 = log(t37)
              t39 = 1.3256889990520176d-1*t30+1.0d+0
              t40 = -6.903522198342671d-18*t38*t39-3.1090699999999993d-2
     1           *t34*t35
              t41 = rhob+rhoa
              t42 = 1/t41**3.333333333333333d-1
              t43 = 1.3256889990520176d-1*t42+1.0d+0
              t44 = rhoa-rhob
              t45 = t44**4
              t46 = 1/t41**4
              t47 = 1/t41
              t48 = 1.0d+0-t44*t47
              t49 = t44*t47+1.0d+0
              t50 = t49**1.3333333333333333d+0+t48**1.3333333333333333d+
     1           0-2.0d+0
              t51 = -1.923661050931536d+0*t45*t46*t50
              t52 = t51+1.0d+0
              t53 = 1/t41**6.666666666666666d-1
              t54 = t41**5.0d-1
              t55 = 1/t54
              t56 = 1/t41**1.6666666666666666d-1
              t57 = 5.982550435771079d+0*t56+8.004286349993635d-1*t55+1.
     1           8970043257475583d-1*t53+2.2255694211506874d+0*t42
              t58 = 1.6081979498692536d+1/t57+1.0d+0
              t59 = log(t58)
              t60 = -6.21814d-2*t43*t52*t59
              t61 = 6.901399211255825d-2*t42+1.0d+0
              t62 = t51+1.923661050931536d+0*t50
              t63 = 8.157414703487641d+0*t56+4.3009724712766434d-1*t55+1
     1           .9115125951273373d-1*t53+2.247591863577616d+0*t42
              t64 = 2.9608813203268075d+1/t63+1.0d+0
              t65 = log(t64)
              t66 = 1.9751631321680768d-2*t61*t62*t65
              t67 = 1.274696188700087d-1*t42+1.0d+0
              t68 = 1.1120374863094686d+1*t56+1.644733775567609d+0*t55+2
     1           .4058712912881916d-1*t53+3.8447462374472113d+0*t42
              t69 = 3.216395899738507d+1/t68+1.0d+0
              t70 = log(t69)
              t71 = -5.980796863619711d-2*t45*t46*t50*t67*t70
              t72 = t41*(t71+t66+t60)-rhob*t40-rhoa*t26
              t73 = param(18)
              t74 = 6.0d-2*gammaaa*t2+1.0d+0
              t75 = 1/t74
              t76 = param(19)
              t77 = param(20)
              t78 = param(21)
              t79 = param(22)
              t80 = 6.0d-2*gammaaa*t2*t75*t79+t78
              t81 = 6.0d-2*gammaaa*t2*t75*t80+t77
              t82 = 6.0d-2*gammaaa*t2*t75*t81+t76
              t83 = 6.0d-2*gammaaa*t2*t75*t82+t73
              t84 = 1/taua
              t85 = 1/rhoa
              t86 = 2.0d+0*taua-2.5d-1*gammaaa*t85
              t87 = 1.0d+0-1.25d-1*gammaaa*t84*t85
              t88 = 1/rhoa**1.6666666666666669d+0
              t89 = 2.0d+0*t88*taua
              t90 = 5.15088d-3*(t89+t3-9.11559972d+0)+1.0d+0
              t91 = 1/t90
              t92 = param(7)
              t93 = param(10)
              t94 = gammaaa**2
              t95 = 1/rhoa**5.333333333333333d+0
              t96 = 1/t90**2
              t97 = param(11)
              t98 = t89-9.11559972d+0
              t99 = param(12)
              t100 = t98**2
              t101 = param(8)
              t102 = param(9)
              t103 = t100*t96*t99+gammaaa*t2*t96*t97*t98+t102*t91*t98+t9
     1           3*t94*t95*t96+t92+gammaaa*t101*t2*t91
              t104 = 6.0d-2*gammabb*t4+1.0d+0
              t105 = 1/t104
              t106 = 6.0d-2*gammabb*t105*t4*t79+t78
              t107 = t77+6.0d-2*gammabb*t105*t106*t4
              t108 = t76+6.0d-2*gammabb*t105*t107*t4
              t109 = t73+6.0d-2*gammabb*t105*t108*t4
              t110 = 1/taub
              t111 = 1/rhob
              t112 = 2.0d+0*taub-2.5d-1*gammabb*t111
              t113 = 1.0d+0-1.25d-1*gammabb*t110*t111
              t114 = 1/rhob**1.6666666666666669d+0
              t115 = 2.0d+0*t114*taub
              t116 = 5.15088d-3*(t5+t115-9.11559972d+0)+1.0d+0
              t117 = 1/t116
              t118 = gammabb**2
              t119 = 1/rhob**5.333333333333333d+0
              t120 = 1/t116**2
              t121 = t115-9.11559972d+0
              t122 = t121**2
              t123 = t120*t122*t99+gammabb*t120*t121*t4*t97+t118*t119*t1
     1           20*t93+t92+gammabb*t101*t117*t4+t102*t117*t121
              t124 = 3.04966d-3*(t89+t5+t3+t115-1.823119944d+1)+1.0d+0
              t125 = 1/t124
              t126 = param(4)
              t127 = t6**2
              t128 = 1/t124**2
              t129 = param(5)
              t130 = t89+t115-1.823119944d+1
              t131 = param(6)
              t132 = t130**2
              t133 = param(2)
              t134 = param(3)
              t135 = t125*t133*t6+t128*t129*t130*t6+t125*t130*t134+t128*
     1           t131*t132+t126*t127*t128+param(1)
              t136 = 1/t23
              t137 = 1/t14**3
              t138 = 1/rhoa**1.3333333333333333d+0
              t139 = 1/rhoa**1.1666666666666667d+0
              t140 = -1.264669550498372d-1*t88-9.970917392951799d-1*t139
     1           -7.418564737168958d-1*t138-4.002143174996817d-1*t137
              t141 = 1/t22**2
              t142 = 1/t19
              t143 = -1.6039141941921276d-1*t88-1.8533958105157808d+0*t1
     1           39-1.2815820791490704d+0*t138-8.223668877838045d-1*t137
              t144 = 1/t18**2
              t145 = 1.1102230246251565d-16*t136*t140*t141*t25+3.0506411
     1           443514264d-19*t138*t24+1.0d+0*t142*t143*t144*t21+1.3210
     2           398931339265d-3*t138*t20
              t146 = 1/t41**1.6666666666666669d+0
              t147 = 1/t54**3
              t148 = 1/t41**1.3333333333333333d+0
              t149 = 1/t41**1.1666666666666667d+0
              t150 = -9.970917392951799d-1*t149-7.418564737168958d-1*t14
     1           8-4.002143174996817d-1*t147-1.264669550498372d-1*t146
              t151 = 1/t57**2
              t152 = 1/t58
              t153 = 1.0d+0*t150*t151*t152*t43*t52
              t154 = -1.3595691172479402d+0*t149-7.491972878592053d-1*t1
     1           48-2.1504862356383217d-1*t147-1.2743417300848914d-1*t14
     2           6
              t155 = 1/t63**2
              t156 = 1/t64
              t157 = -5.848223622634647d-1*t154*t155*t156*t61*t62
              t158 = -1.8533958105157808d+0*t149-1.2815820791490704d+0*t
     1           148-8.223668877838045d-1*t147-1.6039141941921276d-1*t14
     2           6
              t159 = 1/t68**2
              t160 = 1/t69
              t161 = 1.923661050931536d+0*t158*t159*t160*t45*t46*t50*t67
              t162 = 1/t41**2
              t163 = t162*t44
              t164 = -t47
              t165 = t164+t163
              t166 = t48**3.333333333333333d-1
              t167 = -t162*t44
              t168 = t47+t167
              t169 = t49**3.333333333333333d-1
              t170 = 1.3333333333333333d+0*t168*t169+1.3333333333333333d
     1           +0*t165*t166
              t171 = -1.923661050931536d+0*t170*t45*t46
              t172 = 1/t41**5
              t173 = 7.694644203726144d+0*t172*t45*t50
              t174 = t44**3
              t175 = -7.694644203726144d+0*t174*t46*t50
              t176 = t175+t173+t171
              t177 = -6.21814d-2*t176*t43*t59
              t178 = 2.747773264188437d-3*t148*t52*t59
              t179 = t175+t173+t171+1.923661050931536d+0*t170
              t180 = 1.9751631321680768d-2*t179*t61*t65
              t181 = -4.5437964274821163d-4*t148*t62*t65
              t182 = -5.980796863619711d-2*t170*t45*t46*t67*t70
              t183 = 1/t41**5.333333333333333d+0
              t184 = 2.541232989148493d-3*t183*t45*t50*t70
              t185 = 2.3923187454478842d-1*t172*t45*t50*t67*t70
              t186 = t71+t41*(-2.3923187454478842d-1*t174*t46*t50*t67*t7
     1           0+t185+t184+t182+t181+t180+t178+t177+t161+t157+t153)+t6
     2           6+t60+6.903522198342671d-18*t24*t25+3.1090699999999993d
     3           -2*t20*t21-rhoa*t145
              t187 = 1/rhoa**3.6666666666666664d+0
              t188 = 1/t7**2
              t189 = 2.562666666666666d-5*gammaaa*t1*t187*t188*t6-8.2666
     1           66666666665d-3*gammaaa*t1*t187*t8
              t190 = -8.266666666666665d-3*gammaaa*t187*t8*t9+2.56266666
     1           6666666d-5*gammaaa*t187*t188*t6*t9+3.1d-3*t189*t6*t8
              t191 = 3.1d-3*t190*t6*t8-8.266666666666665d-3*gammaaa*t10*
     1           t187*t8+2.562666666666666d-5*gammaaa*t10*t187*t188*t6
              t192 = 3.1d-3*t191*t6*t8-8.266666666666665d-3*gammaaa*t11*
     1           t187*t8+2.562666666666666d-5*gammaaa*t11*t187*t188*t6
              t193 = 1/t74**2
              t194 = 1/rhoa**6.333333333333333d+0
              t195 = 9.599999999999997d-3*t193*t194*t79*t94-1.5999999999
     1           999998d-1*gammaaa*t187*t75*t79
              t196 = 9.599999999999997d-3*t193*t194*t80*t94-1.5999999999
     1           999998d-1*gammaaa*t187*t75*t80+6.0d-2*gammaaa*t195*t2*t
     2           75
              t197 = 9.599999999999997d-3*t193*t194*t81*t94-1.5999999999
     1           999998d-1*gammaaa*t187*t75*t81+6.0d-2*gammaaa*t196*t2*t
     2           75
              t198 = 9.599999999999997d-3*t193*t194*t82*t94-1.5999999999
     1           999998d-1*gammaaa*t187*t75*t82+6.0d-2*gammaaa*t197*t2*t
     2           75
              t199 = -3.3333333333333337d+0*t2*taua-2.6666666666666666d+
     1           0*gammaaa*t187
              t200 = 1/t90**3
              t201 = -6.666666666666667d+0*t2*t96*t98*t99*taua-3.3333333
     1           333333337d+0*gammaaa*t95*t96*t97*taua-3.333333333333333
     2           7d+0*t102*t2*t91*taua-1.030176d-2*t100*t199*t200*t99-2.
     3           6666666666666666d+0*gammaaa*t187*t96*t97*t98-1.030176d-
     4           2*gammaaa*t199*t2*t200*t97*t98-5.15088d-3*t102*t199*t96
     5           *t98-5.333333333333333d+0*t194*t93*t94*t96-5.15088d-3*g
     6           ammaaa*t101*t199*t2*t96-1.030176d-2*t199*t200*t93*t94*t
     7           95-2.6666666666666666d+0*gammaaa*t101*t187*t91
              t202 = 1.0d+0*rhoa*t201*t26*t87+1.0d+0*t103*t26*t87+1.0d+0
     1           *rhoa*t103*t145*t87
              t203 = 1/t124**3
              t204 = -3.3333333333333337d+0*t128*t129*t2*t6*taua-3.33333
     1           33333333337d+0*t125*t134*t2*taua-6.666666666666667d+0*t
     2           128*t130*t131*t2*taua-6.09932d-3*t129*t130*t199*t203*t6
     3           -3.04966d-3*t128*t133*t199*t6-5.333333333333333d+0*gamm
     4           aaa*t126*t128*t187*t6-6.09932d-3*t131*t132*t199*t203-6.
     5           09932d-3*t126*t127*t199*t203-3.04966d-3*t128*t130*t134*
     6           t199-2.6666666666666666d+0*gammaaa*t125*t133*t187-2.666
     7           6666666666666d+0*gammaaa*t128*t129*t130*t187
              t205 = 1.0d+0*t204*t72+1.0d+0*t135*t186
              t206 = 1/t37
              t207 = 1/t28**3
              t208 = 1/rhob**1.3333333333333333d+0
              t209 = 1/rhob**1.1666666666666667d+0
              t210 = -9.970917392951799d-1*t209-7.418564737168958d-1*t20
     1           8-4.002143174996817d-1*t207-1.264669550498372d-1*t114
              t211 = 1/t36**2
              t212 = 1/t33
              t213 = -1.8533958105157808d+0*t209-1.2815820791490704d+0*t
     1           208-8.223668877838045d-1*t207-1.6039141941921276d-1*t11
     2           4
              t214 = 1/t32**2
              t215 = 1.1102230246251565d-16*t206*t210*t211*t39+3.0506411
     1           443514264d-19*t208*t38+1.0d+0*t212*t213*t214*t35+1.3210
     2           398931339265d-3*t208*t34
              t216 = t47+t163
              t217 = t167+t164
              t218 = 1.3333333333333333d+0*t169*t217+1.3333333333333333d
     1           +0*t166*t216
              t219 = -1.923661050931536d+0*t218*t45*t46
              t220 = 7.694644203726144d+0*t174*t46*t50
              t221 = t220+t219+t173
              t222 = -6.21814d-2*t221*t43*t59
              t223 = t220+t219+1.923661050931536d+0*t218+t173
              t224 = 1.9751631321680768d-2*t223*t61*t65
              t225 = -5.980796863619711d-2*t218*t45*t46*t67*t70
              t226 = t71+t41*(2.3923187454478842d-1*t174*t46*t50*t67*t70
     1           +t225+t224+t222+t185+t184+t181+t178+t161+t157+t153)+t66
     2           +t60+6.903522198342671d-18*t38*t39+3.1090699999999993d-
     3           2*t34*t35-rhob*t215
              t227 = 1/rhob**3.6666666666666664d+0
              t228 = 2.562666666666666d-5*gammabb*t1*t188*t227*t6-8.2666
     1           66666666665d-3*gammabb*t1*t227*t8
              t229 = -8.266666666666665d-3*gammabb*t227*t8*t9+2.56266666
     1           6666666d-5*gammabb*t188*t227*t6*t9+3.1d-3*t228*t6*t8
              t230 = 3.1d-3*t229*t6*t8-8.266666666666665d-3*gammabb*t10*
     1           t227*t8+2.562666666666666d-5*gammabb*t10*t188*t227*t6
              t231 = 3.1d-3*t230*t6*t8-8.266666666666665d-3*gammabb*t11*
     1           t227*t8+2.562666666666666d-5*gammabb*t11*t188*t227*t6
              t232 = 1/t104**2
              t233 = 1/rhob**6.333333333333333d+0
              t234 = 9.599999999999997d-3*t118*t232*t233*t79-1.599999999
     1           9999998d-1*gammabb*t105*t227*t79
              t235 = 6.0d-2*gammabb*t105*t234*t4+9.599999999999997d-3*t1
     1           06*t118*t232*t233-1.5999999999999998d-1*gammabb*t105*t1
     2           06*t227
              t236 = 6.0d-2*gammabb*t105*t235*t4+9.599999999999997d-3*t1
     1           07*t118*t232*t233-1.5999999999999998d-1*gammabb*t105*t1
     2           07*t227
              t237 = 6.0d-2*gammabb*t105*t236*t4+9.599999999999997d-3*t1
     1           08*t118*t232*t233-1.5999999999999998d-1*gammabb*t105*t1
     2           08*t227
              t238 = -3.3333333333333337d+0*t4*taub-2.6666666666666666d+
     1           0*gammabb*t227
              t239 = 1/t116**3
              t240 = -6.666666666666667d+0*t120*t121*t4*t99*taub-3.33333
     1           33333333337d+0*gammabb*t119*t120*t97*taub-3.33333333333
     2           33337d+0*t102*t117*t4*taub-1.030176d-2*t122*t238*t239*t
     3           99-1.030176d-2*gammabb*t121*t238*t239*t4*t97-2.66666666
     4           66666666d+0*gammabb*t120*t121*t227*t97-1.030176d-2*t118
     5           *t119*t238*t239*t93-5.333333333333333d+0*t118*t120*t233
     6           *t93-5.15088d-3*gammabb*t101*t120*t238*t4-5.15088d-3*t1
     7           02*t120*t121*t238-2.6666666666666666d+0*gammabb*t101*t1
     8           17*t227
              t241 = 1.0d+0*rhob*t113*t240*t40+1.0d+0*t113*t123*t40+1.0d
     1           +0*rhob*t113*t123*t215
              t242 = -3.3333333333333337d+0*t128*t129*t4*t6*taub-3.33333
     1           33333333337d+0*t125*t134*t4*taub-6.666666666666667d+0*t
     2           128*t130*t131*t4*taub-6.09932d-3*t129*t130*t203*t238*t6
     3           -3.04966d-3*t128*t133*t238*t6-5.333333333333333d+0*gamm
     4           abb*t126*t128*t227*t6-6.09932d-3*t131*t132*t203*t238-6.
     5           09932d-3*t126*t127*t203*t238-3.04966d-3*t128*t130*t134*
     6           t238-2.6666666666666666d+0*gammabb*t125*t133*t227-2.666
     7           6666666666666d+0*gammabb*t128*t129*t130*t227
              t243 = 1.0d+0*t242*t72+1.0d+0*t135*t226
              t244 = 3.1d-3*t1*t2*t8-9.61d-6*t1*t188*t2*t6
              t245 = 3.1d-3*t2*t8*t9-9.61d-6*t188*t2*t6*t9+3.1d-3*t244*t
     1           6*t8
              t246 = 3.1d-3*t245*t6*t8+3.1d-3*t10*t2*t8-9.61d-6*t10*t188
     1           *t2*t6
              t247 = 3.1d-3*t246*t6*t8+3.1d-3*t11*t2*t8-9.61d-6*t11*t188
     1           *t2*t6
              t248 = -1.25d-1*t26*t83
              t249 = 6.0d-2*t2*t75*t79-3.6d-3*gammaaa*t193*t79*t95
              t250 = -3.6d-3*gammaaa*t193*t80*t95+6.0d-2*t2*t75*t80+6.0d
     1           -2*gammaaa*t2*t249*t75
              t251 = -3.6d-3*gammaaa*t193*t81*t95+6.0d-2*t2*t75*t81+6.0d
     1           -2*gammaaa*t2*t250*t75
              t252 = -3.6d-3*gammaaa*t193*t82*t95+6.0d-2*t2*t75*t82+6.0d
     1           -2*gammaaa*t2*t251*t75
              t253 = 1/rhoa**8
              t254 = -1.030176d-2*t100*t2*t200*t99+t2*t96*t97*t98-1.0301
     1           76d-2*gammaaa*t200*t95*t97*t98-5.15088d-3*t102*t2*t96*t
     2           98+2*gammaaa*t93*t95*t96-5.15088d-3*gammaaa*t101*t95*t9
     3           6-1.030176d-2*t200*t253*t93*t94+t101*t2*t91
              t255 = -6.09932d-3*t129*t130*t2*t203*t6-3.04966d-3*t128*t1
     1           33*t2*t6+2*t126*t128*t2*t6-6.09932d-3*t131*t132*t2*t203
     2           -6.09932d-3*t126*t127*t2*t203-3.04966d-3*t128*t130*t134
     3           *t2+t125*t133*t2+t128*t129*t130*t2
              t256 = 3.1d-3*t1*t4*t8-9.61d-6*t1*t188*t4*t6
              t257 = 3.1d-3*t4*t8*t9-9.61d-6*t188*t4*t6*t9+3.1d-3*t256*t
     1           6*t8
              t258 = 3.1d-3*t257*t6*t8+3.1d-3*t10*t4*t8-9.61d-6*t10*t188
     1           *t4*t6
              t259 = 3.1d-3*t258*t6*t8+3.1d-3*t11*t4*t8-9.61d-6*t11*t188
     1           *t4*t6
              t260 = -1.25d-1*t109*t40
              t261 = 6.0d-2*t105*t4*t79-3.6d-3*gammabb*t119*t232*t79
              t262 = 6.0d-2*gammabb*t105*t261*t4+6.0d-2*t105*t106*t4-3.6
     1           d-3*gammabb*t106*t119*t232
              t263 = 6.0d-2*gammabb*t105*t262*t4+6.0d-2*t105*t107*t4-3.6
     1           d-3*gammabb*t107*t119*t232
              t264 = 6.0d-2*gammabb*t105*t263*t4+6.0d-2*t105*t108*t4-3.6
     1           d-3*gammabb*t108*t119*t232
              t265 = 1/rhob**8
              t266 = -1.030176d-2*t122*t239*t4*t99+t120*t121*t4*t97-1.03
     1           0176d-2*gammabb*t119*t121*t239*t97-1.030176d-2*t118*t23
     2           9*t265*t93+2*gammabb*t119*t120*t93-5.15088d-3*t102*t120
     3           *t121*t4+t101*t117*t4-5.15088d-3*gammabb*t101*t119*t120
              t267 = -6.09932d-3*t129*t130*t203*t4*t6-3.04966d-3*t128*t1
     1           33*t4*t6+2*t126*t128*t4*t6-6.09932d-3*t131*t132*t203*t4
     2           -6.09932d-3*t126*t127*t203*t4-3.04966d-3*t128*t130*t134
     3           *t4+t125*t133*t4+t128*t129*t130*t4
              t268 = taua**2
              t269 = 1/t268
              t270 = 1/rhoa**7
              t271 = 1/rhoa**4.333333333333333d+0
              t272 = 4.0d+0*t88*t96*t98*t99-2.060352d-2*t100*t200*t88*t9
     1           9-2.060352d-2*gammaaa*t200*t271*t97*t98-1.030176d-2*t10
     2           2*t88*t96*t98+2.0d+0*gammaaa*t271*t96*t97-1.030176d-2*g
     3           ammaaa*t101*t271*t96-2.060352d-2*t200*t270*t93*t94+2.0d
     4           +0*t102*t88*t91
              t273 = -1.219864d-2*t129*t130*t203*t6*t88-6.09932d-3*t128*
     1           t133*t6*t88+2.0d+0*t128*t129*t6*t88-1.219864d-2*t131*t1
     2           32*t203*t88-1.219864d-2*t126*t127*t203*t88-6.09932d-3*t
     3           128*t130*t134*t88+2.0d+0*t125*t134*t88+4.0d+0*t128*t130
     4           *t131*t88
              t274 = taub**2
              t275 = 1/t274
              t276 = 1/rhob**7
              t277 = 1/rhob**4.333333333333333d+0
              t278 = -2.060352d-2*t114*t122*t239*t99+4.0d+0*t114*t120*t1
     1           21*t99-2.060352d-2*gammabb*t121*t239*t277*t97+2.0d+0*ga
     2           mmabb*t120*t277*t97-2.060352d-2*t118*t239*t276*t93-1.03
     3           0176d-2*gammabb*t101*t120*t277-1.030176d-2*t102*t114*t1
     4           20*t121+2.0d+0*t102*t114*t117
              t279 = -1.219864d-2*t114*t129*t130*t203*t6-6.09932d-3*t114
     1           *t128*t133*t6+2.0d+0*t114*t128*t129*t6-1.219864d-2*t114
     2           *t131*t132*t203-1.219864d-2*t114*t126*t127*t203-6.09932
     3           d-3*t114*t128*t130*t134+2.0d+0*t114*t125*t134+4.0d+0*t1
     4           14*t128*t130*t131
              t280 = 1/t23**2
              t281 = t140**2
              t282 = 1/t22**4
              t283 = 1/t22**3
              t284 = 1/t14**5
              t285 = 1/rhoa**2.3333333333333334d+0
              t286 = 1/rhoa**2.1666666666666665d+0
              t287 = 1.1632736958443765d+0*t286+9.89141964955861d-1*t285
     1           +6.003214762495226d-1*t284+2.1077825841639536d-1*t2
              t288 = 1/t19**2
              t289 = t143**2
              t290 = 1/t18**4
              t291 = 1/t18**3
              t292 = 2.1622951122684114d+0*t286+1.7087761055320938d+0*t2
     1           85+1.2335503316757068d+0*t284+2.673190323653546d-1*t2
              t293 = 1.0d+0*t142*t144*t21*t292-2.0d+0*t142*t21*t289*t291
     1           +3.216395899738507d+1*t21*t288*t289*t290+1.110223024625
     2           1565d-16*t136*t141*t25*t287-4.0675215258019015d-19*t24*
     3           t285-1.7613865241785684d-3*t20*t285-2.220446049250313d-
     4           16*t136*t25*t281*t283+1.7854583920998188d-15*t25*t280*t
     5           281*t282-8.497974591333913d-2*t138*t142*t143*t144-9.812
     6           069668265515d-18*t136*t138*t140*t141
              t294 = 2.0d+0*t150*t151*t152*t43*t52
              t295 = -1.1696447245269295d+0*t154*t155*t156*t61*t62
              t296 = 3.847322101863072d+0*t158*t159*t160*t45*t46*t50*t67
              t297 = 5.495546528376875d-3*t148*t52*t59
              t298 = -9.087592854964233d-4*t148*t62*t65
              t299 = 5.082465978296986d-3*t183*t45*t50*t70
              t300 = 4.7846374908957684d-1*t172*t45*t50*t67*t70
              t301 = t150**2
              t302 = 1/t57**4
              t303 = 1/t58**2
              t304 = 1.6081979498692536d+1*t301*t302*t303*t43*t52
              t305 = 2.0d+0*t150*t151*t152*t176*t43
              t306 = 1/t57**3
              t307 = -2.0d+0*t152*t301*t306*t43*t52
              t308 = -8.837926660346784d-2*t148*t150*t151*t152*t52
              t309 = 1/t41**2.6666666666666666d+0
              t310 = 1/t54**5
              t311 = 1/t41**2.3333333333333334d+0
              t312 = 1/t41**2.1666666666666665d+0
              t313 = 1.1632736958443765d+0*t312+9.89141964955861d-1*t311
     1           +6.003214762495226d-1*t310+2.1077825841639536d-1*t309
              t314 = 1.0d+0*t151*t152*t313*t43*t52
              t315 = t154**2
              t316 = 1/t63**4
              t317 = 1/t64**2
              t318 = -1.73158960813529d+1*t315*t316*t317*t61*t62
              t319 = -1.1696447245269295d+0*t154*t155*t156*t179*t61
              t320 = 1/t63**3
              t321 = 1.1696447245269295d+0*t156*t315*t320*t61*t62
              t322 = 2.690728393099896d-2*t148*t154*t155*t156*t62
              t323 = 1.5861639701225969d+0*t312+9.98929717145607d-1*t311
     1           +3.2257293534574827d-1*t310+2.1239028834748191d-1*t309
              t324 = -5.848223622634647d-1*t155*t156*t323*t61*t62
              t325 = t158**2
              t326 = 1/t68**4
              t327 = 1/t69**2
              t328 = 6.187255516702861d+1*t325*t326*t327*t45*t46*t50*t67
              t329 = 3.847322101863072d+0*t158*t159*t160*t170*t45*t46*t6
     1           7
              t330 = 1/t68**3
              t331 = -3.847322101863072d+0*t160*t325*t330*t45*t46*t50*t6
     1           7
              t332 = -1.6347222733154887d-1*t158*t159*t160*t183*t45*t50
              t333 = 2.1622951122684114d+0*t312+1.7087761055320938d+0*t3
     1           11+1.2335503316757068d+0*t310+2.673190323653546d-1*t309
              t334 = 1.923661050931536d+0*t159*t160*t333*t45*t46*t50*t67
              t335 = -1.538928840745229d+1*t158*t159*t160*t172*t45*t50*t
     1           67
              t336 = 1.538928840745229d+1*t158*t159*t160*t174*t46*t50*t6
     1           7
              t337 = t165**2
              t338 = 1/t48**6.666666666666666d-1
              t339 = 1/t41**3
              t340 = -2*t339*t44
              t341 = 2*t162
              t342 = t341+t340
              t343 = t168**2
              t344 = 1/t49**6.666666666666666d-1
              t345 = 2*t339*t44
              t346 = -2*t162
              t347 = t346+t345
              t348 = 1.3333333333333333d+0*t169*t347+4.444444444444444d-
     1           1*t343*t344+1.3333333333333333d+0*t166*t342+4.444444444
     2           444444d-1*t337*t338
              t349 = -1.923661050931536d+0*t348*t45*t46
              t350 = 1.5389288407452287d+1*t170*t172*t45
              t351 = -1.5389288407452287d+1*t170*t174*t46
              t352 = 1/t41**6
              t353 = -3.8473221018630716d+1*t352*t45*t50
              t354 = 6.155715362980915d+1*t172*t174*t50
              t355 = t44**2
              t356 = -2.3083932611178434d+1*t355*t46*t50
              t357 = t356+t354+t353+t351+t350+t349
              t358 = -6.21814d-2*t357*t43*t59
              t359 = 5.495546528376875d-3*t148*t176*t59
              t360 = -3.663697685584583d-3*t311*t52*t59
              t361 = t356+t354+t353+t351+t350+t349+1.923661050931536d+0*
     1           t348
              t362 = 1.9751631321680768d-2*t361*t61*t65
              t363 = -9.087592854964233d-4*t148*t179*t65
              t364 = 6.058395236642822d-4*t311*t62*t65
              t365 = -5.980796863619711d-2*t348*t45*t46*t67*t70
              t366 = 5.082465978296986d-3*t170*t183*t45*t70
              t367 = 4.7846374908957684d-1*t170*t172*t45*t67*t70
              t368 = 1/t41**6.333333333333333d+0
              t369 = -2.3718174565385935d-2*t368*t45*t50*t70
              t370 = 2.0329863913187946d-2*t174*t183*t50*t70
              t371 = -1.1961593727239421d+0*t352*t45*t50*t67*t70
              t372 = 1.9138549963583074d+0*t172*t174*t50*t67*t70
              t373 = -7.176956236343652d-1*t355*t46*t50*t67*t70
              t374 = t41*(-4.7846374908957684d-1*t170*t174*t46*t67*t70+t
     1           373+t372+t371+t370+t369+t367+t366+t365+t364+t363+t362+t
     2           360+t359+t358+t336+t335+t334+t332+t331+t329+t328+t324+t
     3           322+t321+t319+t318+t314+t308+t307+t305+t304)-4.78463749
     4           08957684d-1*t174*t46*t50*t67*t70-1.1961593727239421d-1*
     5           t170*t45*t46*t67*t70+3.9503262643361536d-2*t179*t61*t65
     6           -1.243628d-1*t176*t43*t59+t300+t299+t298+t297+t296+t295
     7           +t294-rhoa*t293-2.220446049250313d-16*t136*t140*t141*t2
     8           5-6.101282288702853d-19*t138*t24-2.0d+0*t142*t143*t144*
     9           t21-2.642079786267853d-3*t138*t20
              t375 = 1/rhoa**7.333333333333333d+0
              t376 = 1/t7**3
              t377 = 1/rhoa**4.666666666666667d+0
              t378 = 4.2369422222222203d-7*t1*t375*t376*t6*t94-1.3667555
     1           55555555d-4*t1*t188*t375*t94+3.0311111111111105d-2*gamm
     2           aaa*t1*t377*t8-9.396444444444442d-5*gammaaa*t1*t188*t37
     3           7*t6
              t379 = 4.2369422222222203d-7*t375*t376*t6*t9*t94-1.3667555
     1           55555555d-4*t188*t375*t9*t94+3.0311111111111105d-2*gamm
     2           aaa*t377*t8*t9-9.396444444444442d-5*gammaaa*t188*t377*t
     3           6*t9+3.1d-3*t378*t6*t8-1.653333333333333d-2*gammaaa*t18
     4           7*t189*t8+5.125333333333332d-5*gammaaa*t187*t188*t189*t
     5           6
              t380 = 4.2369422222222203d-7*t10*t375*t376*t6*t94-1.366755
     1           555555555d-4*t10*t188*t375*t94+3.1d-3*t379*t6*t8+3.0311
     2           111111111105d-2*gammaaa*t10*t377*t8-1.653333333333333d-
     3           2*gammaaa*t187*t190*t8-9.396444444444442d-5*gammaaa*t10
     4           *t188*t377*t6+5.125333333333332d-5*gammaaa*t187*t188*t1
     5           90*t6
              t381 = 4.2369422222222203d-7*t11*t375*t376*t6*t94-1.366755
     1           555555555d-4*t11*t188*t375*t94+3.1d-3*t380*t6*t8+3.0311
     2           111111111105d-2*gammaaa*t11*t377*t8-1.653333333333333d-
     3           2*gammaaa*t187*t191*t8-9.396444444444442d-5*gammaaa*t11
     4           *t188*t377*t6+5.125333333333332d-5*gammaaa*t187*t188*t1
     5           91*t6
              t382 = 1/rhoa**2
              t383 = gammaaa**3
              t384 = 1/t74**3
              t385 = 1/rhoa**10
              t386 = -8.639999999999998d-2*t193*t375*t79*t94+5.866666666
     1           666666d-1*gammaaa*t377*t75*t79+3.0719999999999986d-3*t3
     2           83*t384*t385*t79
              t387 = -8.639999999999998d-2*t193*t375*t80*t94+1.919999999
     1           9999995d-2*t193*t194*t195*t94+5.866666666666666d-1*gamm
     2           aaa*t377*t75*t80+3.0719999999999986d-3*t383*t384*t385*t
     3           80+6.0d-2*gammaaa*t2*t386*t75-3.1999999999999995d-1*gam
     4           maaa*t187*t195*t75
              t388 = -8.639999999999998d-2*t193*t375*t81*t94+1.919999999
     1           9999995d-2*t193*t194*t196*t94+5.866666666666666d-1*gamm
     2           aaa*t377*t75*t81+3.0719999999999986d-3*t383*t384*t385*t
     3           81+6.0d-2*gammaaa*t2*t387*t75-3.1999999999999995d-1*gam
     4           maaa*t187*t196*t75
              t389 = -8.639999999999998d-2*t193*t375*t82*t94+1.919999999
     1           9999995d-2*t193*t194*t197*t94+5.866666666666666d-1*gamm
     2           aaa*t377*t75*t82+3.0719999999999986d-3*t383*t384*t385*t
     3           82+6.0d-2*gammaaa*t2*t388*t75-3.1999999999999995d-1*gam
     4           maaa*t187*t197*t75
              t390 = t199**2
              t391 = 1.25d-1*gammaaa*t201*t26+1.25d-1*gammaaa*t103*t145
              t392 = 1/t90**4
              t393 = 8.88888888888889d+0*t187*taua+9.777777777777779d+0*
     1           gammaaa*t377
              t394 = 1.7777777777777778d+1*t187*t96*t98*t99*taua+1.37356
     1           8d-1*t199*t2*t200*t98*t99*taua+2.6666666666666666d+1*ga
     2           mmaaa*t194*t96*t97*taua+6.867840000000001d-2*gammaaa*t1
     3           99*t200*t95*t97*taua+3.4339200000000003d-2*t102*t199*t2
     4           *t96*taua+8.88888888888889d+0*t102*t187*t91*taua+2.2222
     5           222222222224d+1*t268*t95*t96*t99-1.030176d-2*t100*t200*
     6           t393*t99+1.591893886464d-4*t100*t390*t392*t99+9.7777777
     7           77777779d+0*gammaaa*t377*t96*t97*t98-1.030176d-2*gammaa
     8           a*t2*t200*t393*t97*t98+1.591893886464d-4*gammaaa*t2*t39
     9           0*t392*t97*t98+5.494272d-2*gammaaa*t187*t199*t200*t97*t
     :           98-5.15088d-3*t102*t393*t96*t98+5.30631295488d-5*t102*t
     ;           200*t390*t98+3.377777777777778d+1*t375*t93*t94*t96-5.15
     <           088d-3*gammaaa*t101*t2*t393*t96+2.747136d-2*gammaaa*t10
     =           1*t187*t199*t96-1.030176d-2*t200*t393*t93*t94*t95+1.591
     >           893886464d-4*t390*t392*t93*t94*t95+1.0988544d-1*t194*t1
     ?           99*t200*t93*t94+9.777777777777779d+0*gammaaa*t101*t377*
     @           t91+5.30631295488d-5*gammaaa*t101*t2*t200*t390
              t395 = 1.0d+0*rhoa*t26*t394*t87+1.0d+0*rhoa*t103*t293*t87+
     1           2.0d+0*t201*t26*t87+2.0d+0*rhoa*t145*t201*t87+2.0d+0*t1
     2           03*t145*t87+1.25d-1*gammaaa*t201*t26*t84*t85+1.25d-1*ga
     3           mmaaa*t103*t145*t84*t85+1.25d-1*gammaaa*t103*t26*t382*t
     4           84
              t396 = -5.15088d-3*rhoa*t103*t26*t393*t87-5.15088d-3*rhoa*
     1           t199*t201*t26*t87-5.15088d-3*t103*t199*t26*t87-5.15088d
     2           -3*rhoa*t103*t145*t199*t87-5.15088d-3*t199*t202
              t397 = 1/t124**4
              t398 = 4.066213333333334d-2*t129*t199*t2*t203*t6*taua+8.88
     1           888888888889d+0*t128*t129*t187*t6*taua+8.13242666666666
     2           8d-2*t130*t131*t199*t2*t203*taua+2.033106666666667d-2*t
     3           128*t134*t199*t2*taua+1.7777777777777778d+1*gammaaa*t12
     4           8*t129*t194*taua+8.88888888888889d+0*t125*t134*t187*tau
     5           a+1.7777777777777778d+1*t128*t130*t131*t187*taua+2.2222
     6           222222222224d+1*t128*t131*t268*t95+1.4222222222222222d+
     7           1*t126*t128*t375*t94+5.580255669360001d-5*t129*t130*t39
     8           0*t397*t6-6.09932d-3*t129*t130*t203*t393*t6-3.04966d-3*
     9           t128*t133*t393*t6+1.86008522312d-5*t133*t203*t390*t6+1.
     :           9555555555555557d+1*gammaaa*t126*t128*t377*t6+6.5059413
     ;           33333333d-2*gammaaa*t126*t187*t199*t203*t6+5.5802556693
     <           60001d-5*t131*t132*t390*t397+5.580255669360001d-5*t126*
     =           t127*t390*t397-6.09932d-3*t131*t132*t203*t393-6.09932d-
     >           3*t126*t127*t203*t393-3.04966d-3*t128*t130*t134*t393+1.
     ?           86008522312d-5*t130*t134*t203*t390+9.777777777777779d+0
     @           *gammaaa*t125*t133*t377+9.777777777777779d+0*gammaaa*t1
     1           28*t129*t130*t377+3.2529706666666663d-2*gammaaa*t129*t1
     2           30*t187*t199*t203+1.6264853333333332d-2*gammaaa*t128*t1
     3           33*t187*t199
              t399 = 1.0d+0*t398*t72+1.0d+0*t135*t374+2.0d+0*t186*t204
              t400 = -3.04966d-3*t135*t393*t72-3.04966d-3*t199*t204*t72-
     1           3.04966d-3*t199*t205-3.04966d-3*t135*t186*t199
              t401 = 2.6666666666666666d+0*t169*t339*t44-2.6666666666666
     1           666d+0*t166*t339*t44+4.444444444444444d-1*t168*t217*t34
     2           4+4.444444444444444d-1*t165*t216*t338
              t402 = -1.923661050931536d+0*t401*t45*t46
              t403 = 7.694644203726144d+0*t172*t218*t45
              t404 = -7.694644203726144d+0*t174*t218*t46
              t405 = 7.694644203726144d+0*t170*t172*t45
              t406 = 7.694644203726144d+0*t170*t174*t46
              t407 = 2.3083932611178434d+1*t355*t46*t50
              t408 = t407+t406+t405+t404+t403+t402+t353
              t409 = t407+t406+t405+t404+t403+t402+1.923661050931536d+0*
     1           t401+t353
              t410 = 7.176956236343652d-1*t355*t46*t50*t67*t70
              t411 = t41*(-5.980796863619711d-2*t401*t45*t46*t67*t70-2.3
     1           923187454478842d-1*t174*t218*t46*t67*t70+2.392318745447
     2           8842d-1*t170*t174*t46*t67*t70+2.3923187454478842d-1*t17
     3           2*t218*t45*t67*t70+2.3923187454478842d-1*t170*t172*t45*
     4           t67*t70+2.541232989148493d-3*t183*t218*t45*t70+2.541232
     5           989148493d-3*t170*t183*t45*t70+1.923661050931536d+0*t15
     6           8*t159*t160*t218*t45*t46*t67+1.923661050931536d+0*t158*
     7           t159*t160*t170*t45*t46*t67+1.9751631321680768d-2*t409*t
     8           61*t65-4.5437964274821163d-4*t148*t223*t65-4.5437964274
     9           821163d-4*t148*t179*t65-5.848223622634647d-1*t154*t155*
     :           t156*t223*t61-5.848223622634647d-1*t154*t155*t156*t179*
     ;           t61-6.21814d-2*t408*t43*t59+2.747773264188437d-3*t148*t
     <           221*t59+2.747773264188437d-3*t148*t176*t59+1.0d+0*t150*
     =           t151*t152*t221*t43+1.0d+0*t150*t151*t152*t176*t43+t410+
     >           t371+t369+t364+t360+t335+t334+t332+t331+t328+t324+t322+
     ?           t321+t318+t314+t308+t307+t304)+t300+t299+t298+t297+t296
     @           +t295+t294+t225+t224+t222+t182+t180+t177
              t412 = 4.2369422222222203d-7*gammaaa*gammabb*t1*t187*t227*
     1           t376*t6-1.366755555555555d-4*gammaaa*gammabb*t1*t187*t1
     2           88*t227
              t413 = 4.2369422222222203d-7*gammaaa*gammabb*t187*t227*t37
     1           6*t6*t9-1.366755555555555d-4*gammaaa*gammabb*t187*t188*
     2           t227*t9+3.1d-3*t412*t6*t8-8.266666666666665d-3*gammaaa*
     3           t187*t228*t8-8.266666666666665d-3*gammabb*t189*t227*t8+
     4           2.562666666666666d-5*gammaaa*t187*t188*t228*t6+2.562666
     5           666666666d-5*gammabb*t188*t189*t227*t6
              t414 = 3.1d-3*t413*t6*t8-8.266666666666665d-3*gammaaa*t187
     1           *t229*t8-8.266666666666665d-3*gammabb*t190*t227*t8+4.23
     2           69422222222203d-7*gammaaa*gammabb*t10*t187*t227*t376*t6
     3           +2.562666666666666d-5*gammaaa*t187*t188*t229*t6+2.56266
     4           6666666666d-5*gammabb*t188*t190*t227*t6-1.3667555555555
     5           55d-4*gammaaa*gammabb*t10*t187*t188*t227
              t415 = 3.1d-3*t414*t6*t8-8.266666666666665d-3*gammaaa*t187
     1           *t230*t8-8.266666666666665d-3*gammabb*t191*t227*t8+4.23
     2           69422222222203d-7*gammaaa*gammabb*t11*t187*t227*t376*t6
     3           +2.562666666666666d-5*gammaaa*t187*t188*t230*t6+2.56266
     4           6666666666d-5*gammabb*t188*t191*t227*t6-1.3667555555555
     5           55d-4*gammaaa*gammabb*t11*t187*t188*t227
              t416 = 2.2222222222222224d+1*t128*t131*t2*t4*taua*taub+2.0
     1           33106666666667d-2*t129*t199*t203*t4*t6*taub+4.066213333
     2           333334d-2*t130*t131*t199*t203*t4*taub+1.016553333333333
     3           5d-2*t128*t134*t199*t4*taub+8.88888888888889d+0*gammaaa
     4           *t128*t129*t187*t4*taub+2.033106666666667d-2*t129*t2*t2
     5           03*t238*t6*taua+4.066213333333334d-2*t130*t131*t2*t203*
     6           t238*taua+1.0165533333333335d-2*t128*t134*t2*t238*taua+
     7           8.88888888888889d+0*gammabb*t128*t129*t2*t227*taua+5.58
     8           0255669360001d-5*t129*t130*t199*t238*t397*t6+1.86008522
     9           312d-5*t133*t199*t203*t238*t6+3.2529706666666663d-2*gam
     :           maaa*t126*t187*t203*t238*t6+3.2529706666666663d-2*gamma
     ;           bb*t126*t199*t203*t227*t6+5.580255669360001d-5*t131*t13
     <           2*t199*t238*t397+5.580255669360001d-5*t126*t127*t199*t2
     =           38*t397+1.86008522312d-5*t130*t134*t199*t203*t238+1.626
     >           4853333333332d-2*gammaaa*t129*t130*t187*t203*t238+8.132
     ?           426666666667d-3*gammaaa*t128*t133*t187*t238+1.626485333
     @           3333332d-2*gammabb*t129*t130*t199*t203*t227+8.132426666
     1           666667d-3*gammabb*t128*t133*t199*t227+1.422222222222222
     2           2d+1*gammaaa*gammabb*t126*t128*t187*t227
              t417 = 1.0d+0*t416*t72+1.0d+0*t135*t411+1.0d+0*t186*t242+1
     1           .0d+0*t204*t226
              t418 = -3.04966d-3*t199*t242*t72-3.04966d-3*t205*t238-3.04
     1           966d-3*t135*t199*t226
              t419 = 1/t37**2
              t420 = t210**2
              t421 = 1/t36**4
              t422 = 1/t36**3
              t423 = 1/t28**5
              t424 = 1/rhob**2.3333333333333334d+0
              t425 = 1/rhob**2.1666666666666665d+0
              t426 = 1.1632736958443765d+0*t425+9.89141964955861d-1*t424
     1           +6.003214762495226d-1*t423+2.1077825841639536d-1*t4
              t427 = 1/t33**2
              t428 = t213**2
              t429 = 1/t32**4
              t430 = 1/t32**3
              t431 = 2.1622951122684114d+0*t425+1.7087761055320938d+0*t4
     1           24+1.2335503316757068d+0*t423+2.673190323653546d-1*t4
              t432 = 1.0d+0*t212*t214*t35*t431-2.0d+0*t212*t35*t428*t430
     1           +3.216395899738507d+1*t35*t427*t428*t429+1.110223024625
     2           1565d-16*t206*t211*t39*t426-4.0675215258019015d-19*t38*
     3           t424-1.7613865241785684d-3*t34*t424-2.220446049250313d-
     4           16*t206*t39*t420*t422+1.7854583920998188d-15*t39*t419*t
     5           420*t421-8.497974591333913d-2*t208*t212*t213*t214-9.812
     6           069668265515d-18*t206*t208*t210*t211
              t433 = 2.0d+0*t150*t151*t152*t221*t43
              t434 = -1.1696447245269295d+0*t154*t155*t156*t223*t61
              t435 = 3.847322101863072d+0*t158*t159*t160*t218*t45*t46*t6
     1           7
              t436 = -1.538928840745229d+1*t158*t159*t160*t174*t46*t50*t
     1           67
              t437 = t216**2
              t438 = t346+t340
              t439 = t217**2
              t440 = t345+t341
              t441 = 1.3333333333333333d+0*t169*t440+4.444444444444444d-
     1           1*t344*t439+1.3333333333333333d+0*t166*t438+4.444444444
     2           444444d-1*t338*t437
              t442 = -1.923661050931536d+0*t441*t45*t46
              t443 = 1.5389288407452287d+1*t172*t218*t45
              t444 = 1.5389288407452287d+1*t174*t218*t46
              t445 = -6.155715362980915d+1*t172*t174*t50
              t446 = t445+t444+t443+t442+t356+t353
              t447 = -6.21814d-2*t43*t446*t59
              t448 = 5.495546528376875d-3*t148*t221*t59
              t449 = t445+t444+t443+t442+1.923661050931536d+0*t441+t356+
     1           t353
              t450 = 1.9751631321680768d-2*t449*t61*t65
              t451 = -9.087592854964233d-4*t148*t223*t65
              t452 = -5.980796863619711d-2*t441*t45*t46*t67*t70
              t453 = 5.082465978296986d-3*t183*t218*t45*t70
              t454 = 4.7846374908957684d-1*t172*t218*t45*t67*t70
              t455 = -2.0329863913187946d-2*t174*t183*t50*t70
              t456 = -1.9138549963583074d+0*t172*t174*t50*t67*t70
              t457 = t41*(4.7846374908957684d-1*t174*t218*t46*t67*t70+t4
     1           56+t455+t454+t453+t452+t451+t450+t448+t447+t436+t435+t4
     2           34+t433+t373+t371+t369+t364+t360+t335+t334+t332+t331+t3
     3           28+t324+t322+t321+t318+t314+t308+t307+t304)+4.784637490
     4           8957684d-1*t174*t46*t50*t67*t70-1.1961593727239421d-1*t
     5           218*t45*t46*t67*t70+3.9503262643361536d-2*t223*t61*t65-
     6           1.243628d-1*t221*t43*t59-rhob*t432-2.220446049250313d-1
     7           6*t206*t210*t211*t39-6.101282288702853d-19*t208*t38-2.0
     8           d+0*t212*t213*t214*t35-2.642079786267853d-3*t208*t34+t3
     9           00+t299+t298+t297+t296+t295+t294
              t458 = 1/rhob**7.333333333333333d+0
              t459 = 1/rhob**4.666666666666667d+0
              t460 = 3.0311111111111105d-2*gammabb*t1*t459*t8-9.39644444
     1           4444442d-5*gammabb*t1*t188*t459*t6+4.2369422222222203d-
     2           7*t1*t118*t376*t458*t6-1.366755555555555d-4*t1*t118*t18
     3           8*t458
              t461 = 3.0311111111111105d-2*gammabb*t459*t8*t9-9.39644444
     1           4444442d-5*gammabb*t188*t459*t6*t9+4.2369422222222203d-
     2           7*t118*t376*t458*t6*t9-1.366755555555555d-4*t118*t188*t
     3           458*t9+3.1d-3*t460*t6*t8-1.653333333333333d-2*gammabb*t
     4           227*t228*t8+5.125333333333332d-5*gammabb*t188*t227*t228
     5           *t6
              t462 = 3.1d-3*t461*t6*t8+3.0311111111111105d-2*gammabb*t10
     1           *t459*t8-1.653333333333333d-2*gammabb*t227*t229*t8-9.39
     2           6444444444442d-5*gammabb*t10*t188*t459*t6+4.23694222222
     3           22203d-7*t10*t118*t376*t458*t6+5.125333333333332d-5*gam
     4           mabb*t188*t227*t229*t6-1.366755555555555d-4*t10*t118*t1
     5           88*t458
              t463 = 3.1d-3*t462*t6*t8+3.0311111111111105d-2*gammabb*t11
     1           *t459*t8-1.653333333333333d-2*gammabb*t227*t230*t8-9.39
     2           6444444444442d-5*gammabb*t11*t188*t459*t6+4.23694222222
     3           22203d-7*t11*t118*t376*t458*t6+5.125333333333332d-5*gam
     4           mabb*t188*t227*t230*t6-1.366755555555555d-4*t11*t118*t1
     5           88*t458
              t464 = 1/rhob**2
              t465 = gammabb**3
              t466 = 1/t104**3
              t467 = 1/rhob**10
              t468 = 3.0719999999999986d-3*t465*t466*t467*t79+5.86666666
     1           6666666d-1*gammabb*t105*t459*t79-8.639999999999998d-2*t
     2           118*t232*t458*t79
              t469 = 6.0d-2*gammabb*t105*t4*t468+3.0719999999999986d-3*t
     1           106*t465*t466*t467+5.866666666666666d-1*gammabb*t105*t1
     2           06*t459-8.639999999999998d-2*t106*t118*t232*t458+1.9199
     3           999999999995d-2*t118*t232*t233*t234-3.1999999999999995d
     4           -1*gammabb*t105*t227*t234
              t470 = 6.0d-2*gammabb*t105*t4*t469+3.0719999999999986d-3*t
     1           107*t465*t466*t467+5.866666666666666d-1*gammabb*t105*t1
     2           07*t459-8.639999999999998d-2*t107*t118*t232*t458+1.9199
     3           999999999995d-2*t118*t232*t233*t235-3.1999999999999995d
     4           -1*gammabb*t105*t227*t235
              t471 = 6.0d-2*gammabb*t105*t4*t470+3.0719999999999986d-3*t
     1           108*t465*t466*t467+5.866666666666666d-1*gammabb*t105*t1
     2           08*t459-8.639999999999998d-2*t108*t118*t232*t458+1.9199
     3           999999999995d-2*t118*t232*t233*t236-3.1999999999999995d
     4           -1*gammabb*t105*t227*t236
              t472 = t238**2
              t473 = 1.25d-1*gammabb*t240*t40+1.25d-1*gammabb*t123*t215
              t474 = 1/t116**4
              t475 = 8.88888888888889d+0*t227*taub+9.777777777777779d+0*
     1           gammabb*t459
              t476 = 1.373568d-1*t121*t238*t239*t4*t99*taub+1.7777777777
     1           777778d+1*t120*t121*t227*t99*taub+6.867840000000001d-2*
     2           gammabb*t119*t238*t239*t97*taub+2.6666666666666666d+1*g
     3           ammabb*t120*t233*t97*taub+3.4339200000000003d-2*t102*t1
     4           20*t238*t4*taub+8.88888888888889d+0*t102*t117*t227*taub
     5           -1.030176d-2*t122*t239*t475*t99+1.591893886464d-4*t122*
     6           t472*t474*t99+2.2222222222222224d+1*t119*t120*t274*t99-
     7           1.030176d-2*gammabb*t121*t239*t4*t475*t97+1.59189388646
     8           4d-4*gammabb*t121*t4*t472*t474*t97+9.777777777777779d+0
     9           *gammabb*t120*t121*t459*t97+5.494272d-2*gammabb*t121*t2
     :           27*t238*t239*t97-1.030176d-2*t118*t119*t239*t475*t93+1.
     ;           591893886464d-4*t118*t119*t472*t474*t93+3.3777777777777
     <           78d+1*t118*t120*t458*t93+1.0988544d-1*t118*t233*t238*t2
     =           39*t93-5.15088d-3*gammabb*t101*t120*t4*t475-5.15088d-3*
     >           t102*t120*t121*t475+5.30631295488d-5*gammabb*t101*t239*
     ?           t4*t472+5.30631295488d-5*t102*t121*t239*t472+9.77777777
     @           7777779d+0*gammabb*t101*t117*t459+2.747136d-2*gammabb*t
     1           101*t120*t227*t238
              t477 = 1.0d+0*rhob*t113*t40*t476+1.25d-1*gammabb*t110*t123
     1           *t40*t464+1.0d+0*rhob*t113*t123*t432+2.0d+0*t113*t240*t
     2           40+1.25d-1*gammabb*t110*t111*t240*t40+2.0d+0*rhob*t113*
     3           t215*t240+2.0d+0*t113*t123*t215+1.25d-1*gammabb*t110*t1
     4           11*t123*t215
              t478 = -5.15088d-3*rhob*t113*t123*t40*t475-5.15088d-3*rhob
     1           *t113*t238*t240*t40-5.15088d-3*t113*t123*t238*t40-5.150
     2           88d-3*t238*t241-5.15088d-3*rhob*t113*t123*t215*t238
              t479 = 4.066213333333334d-2*t129*t203*t238*t4*t6*taub+8.88
     1           888888888889d+0*t128*t129*t227*t6*taub+8.13242666666666
     2           8d-2*t130*t131*t203*t238*t4*taub+2.033106666666667d-2*t
     3           128*t134*t238*t4*taub+1.7777777777777778d+1*gammabb*t12
     4           8*t129*t233*taub+8.88888888888889d+0*t125*t134*t227*tau
     5           b+1.7777777777777778d+1*t128*t130*t131*t227*taub-6.0993
     6           2d-3*t129*t130*t203*t475*t6-3.04966d-3*t128*t133*t475*t
     7           6+5.580255669360001d-5*t129*t130*t397*t472*t6+1.8600852
     8           2312d-5*t133*t203*t472*t6+1.9555555555555557d+1*gammabb
     9           *t126*t128*t459*t6+6.505941333333333d-2*gammabb*t126*t2
     :           03*t227*t238*t6-6.09932d-3*t131*t132*t203*t475-6.09932d
     ;           -3*t126*t127*t203*t475-3.04966d-3*t128*t130*t134*t475+5
     <           .580255669360001d-5*t131*t132*t397*t472+5.5802556693600
     =           01d-5*t126*t127*t397*t472+1.86008522312d-5*t130*t134*t2
     >           03*t472+9.777777777777779d+0*gammabb*t125*t133*t459+9.7
     ?           77777777777779d+0*gammabb*t128*t129*t130*t459+1.4222222
     @           222222222d+1*t118*t126*t128*t458+2.2222222222222224d+1*
     1           t119*t128*t131*t274+3.2529706666666663d-2*gammabb*t129*
     2           t130*t203*t227*t238+1.6264853333333332d-2*gammabb*t128*
     3           t133*t227*t238
              t480 = 1.0d+0*t479*t72+1.0d+0*t135*t457+2.0d+0*t226*t242
              t481 = -3.04966d-3*t135*t475*t72-3.04966d-3*t238*t242*t72-
     1           3.04966d-3*t238*t243-3.04966d-3*t135*t226*t238
              t482 = -8.266666666666665d-3*t1*t187*t8-1.5888533333333327
     1           d-7*gammaaa*t1*t194*t376*t6+2.562666666666666d-5*t1*t18
     2           7*t188*t6+5.125333333333332d-5*gammaaa*t1*t188*t194
              t483 = -8.266666666666665d-3*t187*t8*t9-1.5888533333333327
     1           d-7*gammaaa*t194*t376*t6*t9+2.562666666666666d-5*t187*t
     2           188*t6*t9+5.125333333333332d-5*gammaaa*t188*t194*t9+3.1
     3           d-3*t482*t6*t8-8.266666666666665d-3*gammaaa*t187*t244*t
     4           8+3.1d-3*t189*t2*t8+2.562666666666666d-5*gammaaa*t187*t
     5           188*t244*t6-9.61d-6*t188*t189*t2*t6
              t484 = 3.1d-3*t483*t6*t8-8.266666666666665d-3*gammaaa*t187
     1           *t245*t8+3.1d-3*t190*t2*t8-8.266666666666665d-3*t10*t18
     2           7*t8-1.5888533333333327d-7*gammaaa*t10*t194*t376*t6+2.5
     3           62666666666666d-5*gammaaa*t187*t188*t245*t6-9.61d-6*t18
     4           8*t190*t2*t6+2.562666666666666d-5*t10*t187*t188*t6+5.12
     5           5333333333332d-5*gammaaa*t10*t188*t194
              t485 = 3.1d-3*t484*t6*t8-8.266666666666665d-3*gammaaa*t187
     1           *t246*t8+3.1d-3*t191*t2*t8-8.266666666666665d-3*t11*t18
     2           7*t8-1.5888533333333327d-7*gammaaa*t11*t194*t376*t6+2.5
     3           62666666666666d-5*gammaaa*t187*t188*t246*t6-9.61d-6*t18
     4           8*t191*t2*t6+2.562666666666666d-5*t11*t187*t188*t6+5.12
     5           5333333333332d-5*gammaaa*t11*t188*t194
              t486 = 1.25d-1*t26*t83
              t487 = 1/rhoa**9
              t488 = -1.1519999999999996d-3*t384*t487*t79*t94-1.59999999
     1           99999998d-1*t187*t75*t79+2.879999999999999d-2*gammaaa*t
     2           193*t194*t79
              t489 = -3.6d-3*gammaaa*t193*t195*t95-1.1519999999999996d-3
     1           *t384*t487*t80*t94+9.599999999999997d-3*t193*t194*t249*
     2           t94-1.5999999999999998d-1*t187*t75*t80+2.87999999999999
     3           9d-2*gammaaa*t193*t194*t80+6.0d-2*gammaaa*t2*t488*t75-1
     4           .5999999999999998d-1*gammaaa*t187*t249*t75+6.0d-2*t195*
     5           t2*t75
              t490 = -3.6d-3*gammaaa*t193*t196*t95-1.1519999999999996d-3
     1           *t384*t487*t81*t94+9.599999999999997d-3*t193*t194*t250*
     2           t94-1.5999999999999998d-1*t187*t75*t81+2.87999999999999
     3           9d-2*gammaaa*t193*t194*t81+6.0d-2*gammaaa*t2*t489*t75-1
     4           .5999999999999998d-1*gammaaa*t187*t250*t75+6.0d-2*t196*
     5           t2*t75
              t491 = -3.6d-3*gammaaa*t193*t197*t95-1.1519999999999996d-3
     1           *t384*t487*t82*t94+9.599999999999997d-3*t193*t194*t251*
     2           t94-1.5999999999999998d-1*t187*t75*t82+2.87999999999999
     3           9d-2*gammaaa*t193*t194*t82+6.0d-2*gammaaa*t2*t490*t75-1
     4           .5999999999999998d-1*gammaaa*t187*t251*t75+6.0d-2*t197*
     5           t2*t75
              t492 = 1.25d-1*gammaaa*t254*t26+1.25d-1*t103*t26
              t493 = 6.867840000000001d-2*t200*t95*t98*t99*taua-3.333333
     1           3333333337d+0*t95*t96*t97*taua+3.4339200000000003d-2*ga
     2           mmaaa*t200*t253*t97*taua+1.7169600000000002d-2*t102*t95
     3           *t96*taua+1.591893886464d-4*t100*t199*t2*t392*t99+2.747
     4           136d-2*t100*t187*t200*t99-2.6666666666666666d+0*t187*t9
     5           6*t97*t98+1.591893886464d-4*gammaaa*t199*t392*t95*t97*t
     6           98-1.030176d-2*t199*t2*t200*t97*t98+5.494272d-2*gammaaa
     7           *t194*t200*t97*t98+1.373568d-2*t102*t187*t96*t98+5.3063
     8           1295488d-5*t102*t199*t2*t200*t98-1.0666666666666666d+1*
     9           gammaaa*t194*t93*t96-5.15088d-3*t101*t199*t2*t96+2.7471
     :           36d-2*gammaaa*t101*t194*t96-2.060352d-2*gammaaa*t199*t2
     ;           00*t93*t95+5.30631295488d-5*gammaaa*t101*t199*t200*t95+
     <           8.241408d-2*t200*t487*t93*t94+1.591893886464d-4*t199*t2
     =           53*t392*t93*t94-2.6666666666666666d+0*t101*t187*t91
              t494 = 1.0d+0*rhoa*t26*t493*t87+1.0d+0*t254*t26*t87+1.0d+0
     1           *rhoa*t145*t254*t87-1.25d-1*t103*t26*t84*t85-1.25d-1*t2
     2           01*t26*t84-1.25d-1*t103*t145*t84
              t495 = 1.373568d-2*t103*t26*t87-5.15088d-3*t202
              t496 = 2.033106666666667d-2*t129*t203*t6*t95*taua+4.066213
     1           333333334d-2*t130*t131*t203*t95*taua+1.0165533333333335
     2           d-2*t128*t134*t95*taua-3.3333333333333337d+0*t128*t129*
     3           t95*taua+5.580255669360001d-5*t129*t130*t199*t2*t397*t6
     4           +1.86008522312d-5*t133*t199*t2*t203*t6-1.219864d-2*t126
     5           *t199*t2*t203*t6+3.2529706666666663d-2*gammaaa*t126*t19
     6           4*t203*t6+1.6264853333333332d-2*t129*t130*t187*t203*t6+
     7           8.132426666666667d-3*t128*t133*t187*t6-5.33333333333333
     8           3d+0*t126*t128*t187*t6+5.580255669360001d-5*t131*t132*t
     9           199*t2*t397+5.580255669360001d-5*t126*t127*t199*t2*t397
     :           +1.86008522312d-5*t130*t134*t199*t2*t203-6.09932d-3*t12
     ;           9*t130*t199*t2*t203+1.6264853333333332d-2*gammaaa*t129*
     <           t130*t194*t203+1.6264853333333332d-2*t131*t132*t187*t20
     =           3+1.6264853333333332d-2*t126*t127*t187*t203-3.04966d-3*
     >           t128*t133*t199*t2+8.132426666666667d-3*gammaaa*t128*t13
     ?           3*t194-5.333333333333333d+0*gammaaa*t126*t128*t194+8.13
     @           2426666666667d-3*t128*t130*t134*t187-2.6666666666666666
     1           d+0*t125*t133*t187-2.6666666666666666d+0*t128*t129*t130
     2           *t187
              t497 = 1.0d+0*t496*t72+1.0d+0*t186*t255
              t498 = 5.125333333333332d-5*gammaaa*t1*t187*t188*t4-1.5888
     1           533333333327d-7*gammaaa*t1*t187*t376*t4*t6
              t499 = -1.5888533333333327d-7*gammaaa*t187*t376*t4*t6*t9+5
     1           .125333333333332d-5*gammaaa*t187*t188*t4*t9+3.1d-3*t498
     2           *t6*t8+3.1d-3*t189*t4*t8-8.266666666666665d-3*gammaaa*t
     3           187*t256*t8-9.61d-6*t188*t189*t4*t6+2.562666666666666d-
     4           5*gammaaa*t187*t188*t256*t6
              t500 = 3.1d-3*t499*t6*t8+3.1d-3*t190*t4*t8-8.2666666666666
     1           65d-3*gammaaa*t187*t257*t8-1.5888533333333327d-7*gammaa
     2           a*t10*t187*t376*t4*t6-9.61d-6*t188*t190*t4*t6+2.5626666
     3           66666666d-5*gammaaa*t187*t188*t257*t6+5.125333333333332
     4           d-5*gammaaa*t10*t187*t188*t4
              t501 = 3.1d-3*t500*t6*t8+3.1d-3*t191*t4*t8-8.2666666666666
     1           65d-3*gammaaa*t187*t258*t8-1.5888533333333327d-7*gammaa
     2           a*t11*t187*t376*t4*t6-9.61d-6*t188*t191*t4*t6+2.5626666
     3           66666666d-5*gammaaa*t187*t188*t258*t6+5.125333333333332
     4           d-5*gammaaa*t11*t187*t188*t4
              t502 = 2.033106666666667d-2*t129*t2*t203*t4*t6*taua+4.0662
     1           13333333334d-2*t130*t131*t2*t203*t4*taua+1.016553333333
     2           3335d-2*t128*t134*t2*t4*taua-3.3333333333333337d+0*t128
     3           *t129*t2*t4*taua+5.580255669360001d-5*t129*t130*t199*t3
     4           97*t4*t6+1.86008522312d-5*t133*t199*t203*t4*t6-1.219864
     5           d-2*t126*t199*t203*t4*t6+3.2529706666666663d-2*gammaaa*
     6           t126*t187*t203*t4*t6+5.580255669360001d-5*t131*t132*t19
     7           9*t397*t4+5.580255669360001d-5*t126*t127*t199*t397*t4+1
     8           .86008522312d-5*t130*t134*t199*t203*t4-6.09932d-3*t129*
     9           t130*t199*t203*t4+1.6264853333333332d-2*gammaaa*t129*t1
     :           30*t187*t203*t4-3.04966d-3*t128*t133*t199*t4+8.13242666
     ;           6666667d-3*gammaaa*t128*t133*t187*t4-5.333333333333333d
     <           +0*gammaaa*t126*t128*t187*t4
              t503 = 1.0d+0*t502*t72+1.0d+0*t186*t267
              t504 = 5.125333333333332d-5*gammabb*t1*t188*t2*t227-1.5888
     1           533333333327d-7*gammabb*t1*t2*t227*t376*t6
              t505 = -1.5888533333333327d-7*gammabb*t2*t227*t376*t6*t9+5
     1           .125333333333332d-5*gammabb*t188*t2*t227*t9+3.1d-3*t504
     2           *t6*t8-8.266666666666665d-3*gammabb*t227*t244*t8+3.1d-3
     3           *t2*t228*t8+2.562666666666666d-5*gammabb*t188*t227*t244
     4           *t6-9.61d-6*t188*t2*t228*t6
              t506 = 3.1d-3*t505*t6*t8-8.266666666666665d-3*gammabb*t227
     1           *t245*t8+3.1d-3*t2*t229*t8-1.5888533333333327d-7*gammab
     2           b*t10*t2*t227*t376*t6+2.562666666666666d-5*gammabb*t188
     3           *t227*t245*t6-9.61d-6*t188*t2*t229*t6+5.125333333333332
     4           d-5*gammabb*t10*t188*t2*t227
              t507 = 3.1d-3*t506*t6*t8-8.266666666666665d-3*gammabb*t227
     1           *t246*t8+3.1d-3*t2*t230*t8-1.5888533333333327d-7*gammab
     2           b*t11*t2*t227*t376*t6+2.562666666666666d-5*gammabb*t188
     3           *t227*t246*t6-9.61d-6*t188*t2*t230*t6+5.125333333333332
     4           d-5*gammabb*t11*t188*t2*t227
              t508 = 2.033106666666667d-2*t129*t2*t203*t4*t6*taub+4.0662
     1           13333333334d-2*t130*t131*t2*t203*t4*taub+1.016553333333
     2           3335d-2*t128*t134*t2*t4*taub-3.3333333333333337d+0*t128
     3           *t129*t2*t4*taub+5.580255669360001d-5*t129*t130*t2*t238
     4           *t397*t6+1.86008522312d-5*t133*t2*t203*t238*t6-1.219864
     5           d-2*t126*t2*t203*t238*t6+3.2529706666666663d-2*gammabb*
     6           t126*t2*t203*t227*t6+5.580255669360001d-5*t131*t132*t2*
     7           t238*t397+5.580255669360001d-5*t126*t127*t2*t238*t397+1
     8           .86008522312d-5*t130*t134*t2*t203*t238-6.09932d-3*t129*
     9           t130*t2*t203*t238-3.04966d-3*t128*t133*t2*t238+1.626485
     :           3333333332d-2*gammabb*t129*t130*t2*t203*t227+8.13242666
     ;           6666667d-3*gammabb*t128*t133*t2*t227-5.333333333333333d
     <           +0*gammabb*t126*t128*t2*t227
              t509 = 1.0d+0*t508*t72+1.0d+0*t226*t255
              t510 = -8.266666666666665d-3*t1*t227*t8-1.5888533333333327
     1           d-7*gammabb*t1*t233*t376*t6+2.562666666666666d-5*t1*t18
     2           8*t227*t6+5.125333333333332d-5*gammabb*t1*t188*t233
              t511 = -8.266666666666665d-3*t227*t8*t9-1.5888533333333327
     1           d-7*gammabb*t233*t376*t6*t9+2.562666666666666d-5*t188*t
     2           227*t6*t9+5.125333333333332d-5*gammabb*t188*t233*t9+3.1
     3           d-3*t510*t6*t8+3.1d-3*t228*t4*t8-8.266666666666665d-3*g
     4           ammabb*t227*t256*t8-9.61d-6*t188*t228*t4*t6+2.562666666
     5           666666d-5*gammabb*t188*t227*t256*t6
              t512 = 3.1d-3*t511*t6*t8+3.1d-3*t229*t4*t8-8.2666666666666
     1           65d-3*gammabb*t227*t257*t8-8.266666666666665d-3*t10*t22
     2           7*t8-9.61d-6*t188*t229*t4*t6-1.5888533333333327d-7*gamm
     3           abb*t10*t233*t376*t6+2.562666666666666d-5*gammabb*t188*
     4           t227*t257*t6+2.562666666666666d-5*t10*t188*t227*t6+5.12
     5           5333333333332d-5*gammabb*t10*t188*t233
              t513 = 3.1d-3*t512*t6*t8+3.1d-3*t230*t4*t8-8.2666666666666
     1           65d-3*gammabb*t227*t258*t8-8.266666666666665d-3*t11*t22
     2           7*t8-9.61d-6*t188*t230*t4*t6-1.5888533333333327d-7*gamm
     3           abb*t11*t233*t376*t6+2.562666666666666d-5*gammabb*t188*
     4           t227*t258*t6+2.562666666666666d-5*t11*t188*t227*t6+5.12
     5           5333333333332d-5*gammabb*t11*t188*t233
              t514 = 1.25d-1*t109*t40
              t515 = 1/rhob**9
              t516 = -1.1519999999999996d-3*t118*t466*t515*t79+2.8799999
     1           99999999d-2*gammabb*t232*t233*t79-1.5999999999999998d-1
     2           *t105*t227*t79
              t517 = 6.0d-2*gammabb*t105*t4*t516-1.1519999999999996d-3*t
     1           106*t118*t466*t515+6.0d-2*t105*t234*t4+9.59999999999999
     2           7d-3*t118*t232*t233*t261-1.5999999999999998d-1*gammabb*
     3           t105*t227*t261-3.6d-3*gammabb*t119*t232*t234+2.87999999
     4           9999999d-2*gammabb*t106*t232*t233-1.5999999999999998d-1
     5           *t105*t106*t227
              t518 = 6.0d-2*gammabb*t105*t4*t517-1.1519999999999996d-3*t
     1           107*t118*t466*t515+6.0d-2*t105*t235*t4+9.59999999999999
     2           7d-3*t118*t232*t233*t262-1.5999999999999998d-1*gammabb*
     3           t105*t227*t262-3.6d-3*gammabb*t119*t232*t235+2.87999999
     4           9999999d-2*gammabb*t107*t232*t233-1.5999999999999998d-1
     5           *t105*t107*t227
              t519 = 6.0d-2*gammabb*t105*t4*t518-1.1519999999999996d-3*t
     1           108*t118*t466*t515+6.0d-2*t105*t236*t4+9.59999999999999
     2           7d-3*t118*t232*t233*t263-1.5999999999999998d-1*gammabb*
     3           t105*t227*t263-3.6d-3*gammabb*t119*t232*t236+2.87999999
     4           9999999d-2*gammabb*t108*t232*t233-1.5999999999999998d-1
     5           *t105*t108*t227
              t520 = 1.25d-1*gammabb*t266*t40+1.25d-1*t123*t40
              t521 = 6.867840000000001d-2*t119*t121*t239*t99*taub+3.4339
     1           200000000003d-2*gammabb*t239*t265*t97*taub-3.3333333333
     2           333337d+0*t119*t120*t97*taub+1.7169600000000002d-2*t102
     3           *t119*t120*taub+1.591893886464d-4*t122*t238*t4*t474*t99
     4           +2.747136d-2*t122*t227*t239*t99+1.591893886464d-4*gamma
     5           bb*t119*t121*t238*t474*t97-1.030176d-2*t121*t238*t239*t
     6           4*t97+5.494272d-2*gammabb*t121*t233*t239*t97-2.66666666
     7           66666666d+0*t120*t121*t227*t97+8.241408d-2*t118*t239*t5
     8           15*t93+1.591893886464d-4*t118*t238*t265*t474*t93-2.0603
     9           52d-2*gammabb*t119*t238*t239*t93-1.0666666666666666d+1*
     :           gammabb*t120*t233*t93+5.30631295488d-5*t102*t121*t238*t
     ;           239*t4-5.15088d-3*t101*t120*t238*t4+5.30631295488d-5*ga
     <           mmabb*t101*t119*t238*t239+2.747136d-2*gammabb*t101*t120
     =           *t233+1.373568d-2*t102*t120*t121*t227-2.666666666666666
     >           6d+0*t101*t117*t227
              t522 = 1.0d+0*rhob*t113*t40*t521+1.0d+0*t113*t266*t40-1.25
     1           d-1*t110*t240*t40-1.25d-1*t110*t111*t123*t40+1.0d+0*rho
     2           b*t113*t215*t266-1.25d-1*t110*t123*t215
              t523 = 1.373568d-2*t113*t123*t40-5.15088d-3*t241
              t524 = 2.033106666666667d-2*t119*t129*t203*t6*taub+4.06621
     1           3333333334d-2*t119*t130*t131*t203*taub+1.01655333333333
     2           35d-2*t119*t128*t134*taub-3.3333333333333337d+0*t119*t1
     3           28*t129*taub+5.580255669360001d-5*t129*t130*t238*t397*t
     4           4*t6+1.86008522312d-5*t133*t203*t238*t4*t6-1.219864d-2*
     5           t126*t203*t238*t4*t6+3.2529706666666663d-2*gammabb*t126
     6           *t203*t233*t6+1.6264853333333332d-2*t129*t130*t203*t227
     7           *t6+8.132426666666667d-3*t128*t133*t227*t6-5.3333333333
     8           33333d+0*t126*t128*t227*t6+5.580255669360001d-5*t131*t1
     9           32*t238*t397*t4+5.580255669360001d-5*t126*t127*t238*t39
     :           7*t4+1.86008522312d-5*t130*t134*t203*t238*t4-6.09932d-3
     ;           *t129*t130*t203*t238*t4-3.04966d-3*t128*t133*t238*t4+1.
     <           6264853333333332d-2*gammabb*t129*t130*t203*t233+8.13242
     =           6666666667d-3*gammabb*t128*t133*t233-5.333333333333333d
     >           +0*gammabb*t126*t128*t233+1.6264853333333332d-2*t131*t1
     ?           32*t203*t227+1.6264853333333332d-2*t126*t127*t203*t227+
     @           8.132426666666667d-3*t128*t130*t134*t227-2.666666666666
     1           6666d+0*t125*t133*t227-2.6666666666666666d+0*t128*t129*
     2           t130*t227
              t525 = 1.0d+0*t524*t72+1.0d+0*t226*t267
              t526 = 5.9582d-8*t1*t376*t6*t95-1.9219999999999998d-5*t1*t
     1           188*t95
              t527 = 5.9582d-8*t376*t6*t9*t95-1.9219999999999998d-5*t188
     1           *t9*t95+3.1d-3*t526*t6*t8+6.2d-3*t2*t244*t8-1.921999999
     2           9999998d-5*t188*t2*t244*t6
              t528 = 5.9582d-8*t10*t376*t6*t95-1.9219999999999998d-5*t10
     1           *t188*t95+3.1d-3*t527*t6*t8+6.2d-3*t2*t245*t8-1.9219999
     2           999999998d-5*t188*t2*t245*t6
              t529 = 5.9582d-8*t11*t376*t6*t95-1.9219999999999998d-5*t11
     1           *t188*t95+3.1d-3*t528*t6*t8+6.2d-3*t2*t246*t8-1.9219999
     2           999999998d-5*t188*t2*t246*t6
              t530 = 4.32d-4*gammaaa*t253*t384*t79-7.2d-3*t193*t79*t95
              t531 = -7.2d-3*t193*t80*t95-7.2d-3*gammaaa*t193*t249*t95+4
     1           .32d-4*gammaaa*t253*t384*t80+6.0d-2*gammaaa*t2*t530*t75
     2           +1.2d-1*t2*t249*t75
              t532 = -7.2d-3*t193*t81*t95-7.2d-3*gammaaa*t193*t250*t95+4
     1           .32d-4*gammaaa*t253*t384*t81+6.0d-2*gammaaa*t2*t531*t75
     2           +1.2d-1*t2*t250*t75
              t533 = -7.2d-3*t193*t82*t95-7.2d-3*gammaaa*t193*t251*t95+4
     1           .32d-4*gammaaa*t253*t384*t82+6.0d-2*gammaaa*t2*t532*t75
     2           +1.2d-1*t2*t251*t75
              t534 = 1/rhoa**1.0666666666666666d+1
              t535 = 1.591893886464d-4*t100*t392*t95*t99-2.060352d-2*t20
     1           0*t95*t97*t98+1.591893886464d-4*gammaaa*t253*t392*t97*t
     2           98+5.30631295488d-5*t102*t200*t95*t98+2*t93*t95*t96-1.0
     3           30176d-2*t101*t95*t96+1.591893886464d-4*t392*t534*t93*t
     4           94-4.120704d-2*gammaaa*t200*t253*t93+5.30631295488d-5*g
     5           ammaaa*t101*t200*t253
              t536 = 5.580255669360001d-5*t129*t130*t397*t6*t95+1.860085
     1           22312d-5*t133*t203*t6*t95-2.439728d-2*t126*t203*t6*t95+
     2           5.580255669360001d-5*t131*t132*t397*t95+5.5802556693600
     3           01d-5*t126*t127*t397*t95+1.86008522312d-5*t130*t134*t20
     4           3*t95-1.219864d-2*t129*t130*t203*t95-6.09932d-3*t128*t1
     5           33*t95+2*t126*t128*t95
              t537 = 5.9582d-8*t1*t2*t376*t4*t6-1.9219999999999998d-5*t1
     1           *t188*t2*t4
              t538 = 5.9582d-8*t2*t376*t4*t6*t9-1.9219999999999998d-5*t1
     1           88*t2*t4*t9+3.1d-3*t537*t6*t8+3.1d-3*t244*t4*t8+3.1d-3*
     2           t2*t256*t8-9.61d-6*t188*t244*t4*t6-9.61d-6*t188*t2*t256
     3           *t6
              t539 = 3.1d-3*t538*t6*t8+3.1d-3*t245*t4*t8+3.1d-3*t2*t257*
     1           t8+5.9582d-8*t10*t2*t376*t4*t6-9.61d-6*t188*t245*t4*t6-
     2           9.61d-6*t188*t2*t257*t6-1.9219999999999998d-5*t10*t188*
     3           t2*t4
              t540 = 3.1d-3*t539*t6*t8+3.1d-3*t246*t4*t8+3.1d-3*t2*t258*
     1           t8+5.9582d-8*t11*t2*t376*t4*t6-9.61d-6*t188*t246*t4*t6-
     2           9.61d-6*t188*t2*t258*t6-1.9219999999999998d-5*t11*t188*
     3           t2*t4
              t541 = 5.580255669360001d-5*t129*t130*t2*t397*t4*t6+1.8600
     1           8522312d-5*t133*t2*t203*t4*t6-2.439728d-2*t126*t2*t203*
     2           t4*t6+5.580255669360001d-5*t131*t132*t2*t397*t4+5.58025
     3           5669360001d-5*t126*t127*t2*t397*t4+1.86008522312d-5*t13
     4           0*t134*t2*t203*t4-1.219864d-2*t129*t130*t2*t203*t4-6.09
     5           932d-3*t128*t133*t2*t4+2*t126*t128*t2*t4
              t542 = 5.9582d-8*t1*t119*t376*t6-1.9219999999999998d-5*t1*
     1           t119*t188
              t543 = 5.9582d-8*t119*t376*t6*t9-1.9219999999999998d-5*t11
     1           9*t188*t9+3.1d-3*t542*t6*t8+6.2d-3*t256*t4*t8-1.9219999
     2           999999998d-5*t188*t256*t4*t6
              t544 = 3.1d-3*t543*t6*t8+6.2d-3*t257*t4*t8-1.9219999999999
     1           998d-5*t188*t257*t4*t6+5.9582d-8*t10*t119*t376*t6-1.921
     2           9999999999998d-5*t10*t119*t188
              t545 = 3.1d-3*t544*t6*t8+6.2d-3*t258*t4*t8-1.9219999999999
     1           998d-5*t188*t258*t4*t6+5.9582d-8*t11*t119*t376*t6-1.921
     2           9999999999998d-5*t11*t119*t188
              t546 = 4.32d-4*gammabb*t265*t466*t79-7.2d-3*t119*t232*t79
              t547 = 6.0d-2*gammabb*t105*t4*t546+4.32d-4*gammabb*t106*t2
     1           65*t466+1.2d-1*t105*t261*t4-7.2d-3*gammabb*t119*t232*t2
     2           61-7.2d-3*t106*t119*t232
              t548 = 6.0d-2*gammabb*t105*t4*t547+4.32d-4*gammabb*t107*t2
     1           65*t466+1.2d-1*t105*t262*t4-7.2d-3*gammabb*t119*t232*t2
     2           62-7.2d-3*t107*t119*t232
              t549 = 6.0d-2*gammabb*t105*t4*t548+4.32d-4*gammabb*t108*t2
     1           65*t466+1.2d-1*t105*t263*t4-7.2d-3*gammabb*t119*t232*t2
     2           63-7.2d-3*t108*t119*t232
              t550 = 1/rhob**1.0666666666666666d+1
              t551 = 1.591893886464d-4*t119*t122*t474*t99+1.591893886464
     1           d-4*gammabb*t121*t265*t474*t97-2.060352d-2*t119*t121*t2
     2           39*t97+1.591893886464d-4*t118*t474*t550*t93-4.120704d-2
     3           *gammabb*t239*t265*t93+2*t119*t120*t93+5.30631295488d-5
     4           *gammabb*t101*t239*t265+5.30631295488d-5*t102*t119*t121
     5           *t239-1.030176d-2*t101*t119*t120
              t552 = 5.580255669360001d-5*t119*t129*t130*t397*t6+1.86008
     1           522312d-5*t119*t133*t203*t6-2.439728d-2*t119*t126*t203*
     2           t6+5.580255669360001d-5*t119*t131*t132*t397+5.580255669
     3           360001d-5*t119*t126*t127*t397+1.86008522312d-5*t119*t13
     4           0*t134*t203-1.219864d-2*t119*t129*t130*t203-6.09932d-3*
     5           t119*t128*t133+2*t119*t126*t128
              t553 = 1.373568d-1*t200*t271*t98*t99*taua-1.33333333333333
     1           33d+1*t271*t96*t99*taua+6.867840000000001d-2*gammaaa*t2
     2           00*t270*t97*taua+3.4339200000000003d-2*t102*t271*t96*ta
     3           ua-6.666666666666667d+0*t2*t96*t98*t99-4.120704d-2*t199
     4           *t200*t88*t98*t99+3.183787772928d-4*t100*t199*t392*t88*
     5           t99+3.4339200000000003d-2*t100*t2*t200*t99+8.928192d-2*
     6           gammaaa*t200*t95*t97*t98+3.183787772928d-4*gammaaa*t199
     7           *t271*t392*t97*t98+1.7169600000000002d-2*t102*t2*t96*t9
     8           8+1.061262590976d-4*t102*t199*t200*t88*t98-8.6666666666
     9           66666d+0*gammaaa*t95*t96*t97-2.060352d-2*gammaaa*t199*t
     :           200*t271*t97+4.464096d-2*gammaaa*t101*t95*t96-1.030176d
     ;           -2*t102*t199*t88*t96+3.183787772928d-4*t199*t270*t392*t
     <           93*t94+1.4422464000000002d-1*t200*t253*t93*t94-3.333333
     =           3333333337d+0*t102*t2*t91+1.061262590976d-4*gammaaa*t10
     >           1*t199*t200*t271
              t554 = 1.0d+0*rhoa*t26*t553*t87+1.0d+0*t26*t272*t87+1.0d+0
     1           *rhoa*t145*t272*t87+1.25d-1*gammaaa*t103*t26*t269*t85+1
     2           .25d-1*gammaaa*t201*t26*t269+1.25d-1*gammaaa*t103*t145*
     3           t269
              t555 = 4.066213333333334d-2*t129*t203*t271*t6*taua+8.13242
     1           6666666668d-2*t130*t131*t203*t271*taua+2.03310666666666
     2           7d-2*t128*t134*t271*taua-1.3333333333333333d+1*t128*t13
     3           1*t271*taua+6.505941333333333d-2*gammaaa*t126*t203*t6*t
     4           95+3.2529706666666663d-2*gammaaa*t129*t130*t203*t95+1.6
     5           264853333333332d-2*gammaaa*t128*t133*t95-5.333333333333
     6           333d+0*gammaaa*t128*t129*t95+1.1160511338720001d-4*t129
     7           *t130*t199*t397*t6*t88+3.72017044624d-5*t133*t199*t203*
     8           t6*t88-1.219864d-2*t129*t199*t203*t6*t88+1.116051133872
     9           0001d-4*t131*t132*t199*t397*t88+1.1160511338720001d-4*t
     :           126*t127*t199*t397*t88+3.72017044624d-5*t130*t134*t199*
     ;           t203*t88-2.439728d-2*t130*t131*t199*t203*t88-6.09932d-3
     <           *t128*t134*t199*t88+2.033106666666667d-2*t129*t130*t2*t
     =           203*t6+1.0165533333333335d-2*t128*t133*t2*t6-3.33333333
     >           33333337d+0*t128*t129*t2*t6+2.033106666666667d-2*t131*t
     ?           132*t2*t203+2.033106666666667d-2*t126*t127*t2*t203+1.01
     @           65533333333335d-2*t128*t130*t134*t2-3.3333333333333337d
     1           +0*t125*t134*t2-6.666666666666667d+0*t128*t130*t131*t2
              t556 = 1.0d+0*t555*t72+1.0d+0*t186*t273
              t557 = 4.066213333333334d-2*t114*t129*t2*t203*t6*taua+8.13
     1           2426666666668d-2*t114*t130*t131*t2*t203*taua+2.03310666
     2           6666667d-2*t114*t128*t134*t2*taua-1.3333333333333333d+1
     3           *t114*t128*t131*t2*taua+1.1160511338720001d-4*t114*t129
     4           *t130*t199*t397*t6+3.72017044624d-5*t114*t133*t199*t203
     5           *t6-1.219864d-2*t114*t129*t199*t203*t6+6.50594133333333
     6           3d-2*gammaaa*t114*t126*t187*t203*t6+1.1160511338720001d
     7           -4*t114*t131*t132*t199*t397+1.1160511338720001d-4*t114*
     8           t126*t127*t199*t397+3.72017044624d-5*t114*t130*t134*t19
     9           9*t203-2.439728d-2*t114*t130*t131*t199*t203+3.252970666
     :           6666663d-2*gammaaa*t114*t129*t130*t187*t203-6.09932d-3*
     ;           t114*t128*t134*t199+1.6264853333333332d-2*gammaaa*t114*
     <           t128*t133*t187-5.333333333333333d+0*gammaaa*t114*t128*t
     =           129*t187
              t558 = 1.0d+0*t557*t72+1.0d+0*t186*t279
              t559 = 4.066213333333334d-2*t129*t203*t4*t6*t88*taub+8.132
     1           426666666668d-2*t130*t131*t203*t4*t88*taub+2.0331066666
     2           66667d-2*t128*t134*t4*t88*taub-1.3333333333333333d+1*t1
     3           28*t131*t4*t88*taub+1.1160511338720001d-4*t129*t130*t23
     4           8*t397*t6*t88+3.72017044624d-5*t133*t203*t238*t6*t88-1.
     5           219864d-2*t129*t203*t238*t6*t88+6.505941333333333d-2*ga
     6           mmabb*t126*t203*t227*t6*t88+1.1160511338720001d-4*t131*
     7           t132*t238*t397*t88+1.1160511338720001d-4*t126*t127*t238
     8           *t397*t88+3.72017044624d-5*t130*t134*t203*t238*t88-2.43
     9           9728d-2*t130*t131*t203*t238*t88-6.09932d-3*t128*t134*t2
     :           38*t88+3.2529706666666663d-2*gammabb*t129*t130*t203*t22
     ;           7*t88+1.6264853333333332d-2*gammabb*t128*t133*t227*t88-
     <           5.333333333333333d+0*gammabb*t128*t129*t227*t88
              t560 = 1.0d+0*t559*t72+1.0d+0*t226*t273
              t561 = 1.373568d-1*t121*t239*t277*t99*taub-1.3333333333333
     1           333d+1*t120*t277*t99*taub+6.867840000000001d-2*gammabb*
     2           t239*t276*t97*taub+3.4339200000000003d-2*t102*t120*t277
     3           *taub+3.183787772928d-4*t114*t122*t238*t474*t99+3.43392
     4           00000000003d-2*t122*t239*t4*t99-6.666666666666667d+0*t1
     5           20*t121*t4*t99-4.120704d-2*t114*t121*t238*t239*t99+3.18
     6           3787772928d-4*gammabb*t121*t238*t277*t474*t97-2.060352d
     7           -2*gammabb*t238*t239*t277*t97+8.928192d-2*gammabb*t119*
     8           t121*t239*t97-8.666666666666666d+0*gammabb*t119*t120*t9
     9           7+3.183787772928d-4*t118*t238*t276*t474*t93+1.442246400
     :           0000002d-1*t118*t239*t265*t93+1.7169600000000002d-2*t10
     ;           2*t120*t121*t4-3.3333333333333337d+0*t102*t117*t4+1.061
     <           262590976d-4*gammabb*t101*t238*t239*t277+1.061262590976
     =           d-4*t102*t114*t121*t238*t239-1.030176d-2*t102*t114*t120
     >           *t238+4.464096d-2*gammabb*t101*t119*t120
              t562 = 1.0d+0*rhob*t113*t40*t561+1.0d+0*t113*t278*t40+1.25
     1           d-1*gammabb*t240*t275*t40+1.25d-1*gammabb*t111*t123*t27
     2           5*t40+1.0d+0*rhob*t113*t215*t278+1.25d-1*gammabb*t123*t
     3           215*t275
              t563 = 4.066213333333334d-2*t129*t203*t277*t6*taub+8.13242
     1           6666666668d-2*t130*t131*t203*t277*taub+2.03310666666666
     2           7d-2*t128*t134*t277*taub-1.3333333333333333d+1*t128*t13
     3           1*t277*taub+2.033106666666667d-2*t129*t130*t203*t4*t6+1
     4           .0165533333333335d-2*t128*t133*t4*t6-3.3333333333333337
     5           d+0*t128*t129*t4*t6+1.1160511338720001d-4*t114*t129*t13
     6           0*t238*t397*t6+3.72017044624d-5*t114*t133*t203*t238*t6-
     7           1.219864d-2*t114*t129*t203*t238*t6+6.505941333333333d-2
     8           *gammabb*t119*t126*t203*t6+2.033106666666667d-2*t131*t1
     9           32*t203*t4+2.033106666666667d-2*t126*t127*t203*t4+1.016
     :           5533333333335d-2*t128*t130*t134*t4-3.3333333333333337d+
     ;           0*t125*t134*t4-6.666666666666667d+0*t128*t130*t131*t4+1
     <           .1160511338720001d-4*t114*t131*t132*t238*t397+1.1160511
     =           338720001d-4*t114*t126*t127*t238*t397+3.72017044624d-5*
     >           t114*t130*t134*t203*t238-2.439728d-2*t114*t130*t131*t20
     ?           3*t238-6.09932d-3*t114*t128*t134*t238+3.252970666666666
     @           3d-2*gammabb*t119*t129*t130*t203+1.6264853333333332d-2*
     1           gammabb*t119*t128*t133-5.333333333333333d+0*gammabb*t11
     2           9*t128*t129
              t564 = 1.0d+0*t563*t72+1.0d+0*t226*t279
              t565 = t486-5.0d-1*rhoa*t252*t26*t86
              t566 = 1/rhoa**9.666666666666666d+0
              t567 = -4.120704d-2*t200*t271*t98*t99+3.183787772928d-4*t1
     1           00*t271*t392*t99+3.183787772928d-4*gammaaa*t270*t392*t9
     2           7*t98-2.060352d-2*t200*t271*t97*t98+1.061262590976d-4*t
     3           102*t200*t271*t98+2.0d+0*t271*t96*t97-2.060352d-2*gamma
     4           aa*t200*t270*t97-1.030176d-2*t102*t271*t96-1.030176d-2*
     5           t101*t271*t96+3.183787772928d-4*t392*t566*t93*t94-4.120
     6           704d-2*gammaaa*t200*t270*t93+1.061262590976d-4*gammaaa*
     7           t101*t200*t270
              t568 = 1/rhoa**3.3333333333333337d+0
              t569 = 1.1160511338720001d-4*t129*t130*t271*t397*t6+3.7201
     1           7044624d-5*t133*t203*t271*t6-1.219864d-2*t129*t203*t271
     2           *t6-2.439728d-2*t126*t203*t271*t6+1.1160511338720001d-4
     3           *t131*t132*t271*t397+1.1160511338720001d-4*t126*t127*t2
     4           71*t397+3.72017044624d-5*t130*t134*t203*t271-2.439728d-
     5           2*t130*t131*t203*t271-1.219864d-2*t129*t130*t203*t271-6
     6           .09932d-3*t128*t134*t271-6.09932d-3*t128*t133*t271+2.0d
     7           +0*t128*t129*t271
              t570 = 1.1160511338720001d-4*t114*t129*t130*t2*t397*t6+3.7
     1           2017044624d-5*t114*t133*t2*t203*t6-1.219864d-2*t114*t12
     2           9*t2*t203*t6-2.439728d-2*t114*t126*t2*t203*t6+1.1160511
     3           338720001d-4*t114*t131*t132*t2*t397+1.1160511338720001d
     4           -4*t114*t126*t127*t2*t397+3.72017044624d-5*t114*t130*t1
     5           34*t2*t203-2.439728d-2*t114*t130*t131*t2*t203-1.219864d
     6           -2*t114*t129*t130*t2*t203-6.09932d-3*t114*t128*t134*t2-
     7           6.09932d-3*t114*t128*t133*t2+2.0d+0*t114*t128*t129*t2
              t571 = 1.1160511338720001d-4*t129*t130*t397*t4*t6*t88+3.72
     1           017044624d-5*t133*t203*t4*t6*t88-1.219864d-2*t129*t203*
     2           t4*t6*t88-2.439728d-2*t126*t203*t4*t6*t88+1.11605113387
     3           20001d-4*t131*t132*t397*t4*t88+1.1160511338720001d-4*t1
     4           26*t127*t397*t4*t88+3.72017044624d-5*t130*t134*t203*t4*
     5           t88-2.439728d-2*t130*t131*t203*t4*t88-1.219864d-2*t129*
     6           t130*t203*t4*t88-6.09932d-3*t128*t134*t4*t88-6.09932d-3
     7           *t128*t133*t4*t88+2.0d+0*t128*t129*t4*t88
              t572 = t514-5.0d-1*rhob*t112*t264*t40
              t573 = 1/rhob**9.666666666666666d+0
              t574 = 3.183787772928d-4*t122*t277*t474*t99-4.120704d-2*t1
     1           21*t239*t277*t99+3.183787772928d-4*gammabb*t121*t276*t4
     2           74*t97-2.060352d-2*t121*t239*t277*t97+2.0d+0*t120*t277*
     3           t97-2.060352d-2*gammabb*t239*t276*t97+3.183787772928d-4
     4           *t118*t474*t573*t93-4.120704d-2*gammabb*t239*t276*t93+1
     5           .061262590976d-4*t102*t121*t239*t277-1.030176d-2*t102*t
     6           120*t277-1.030176d-2*t101*t120*t277+1.061262590976d-4*g
     7           ammabb*t101*t239*t276
              t575 = 1/rhob**3.3333333333333337d+0
              t576 = 1.1160511338720001d-4*t129*t130*t277*t397*t6+3.7201
     1           7044624d-5*t133*t203*t277*t6-1.219864d-2*t129*t203*t277
     2           *t6-2.439728d-2*t126*t203*t277*t6+1.1160511338720001d-4
     3           *t131*t132*t277*t397+1.1160511338720001d-4*t126*t127*t2
     4           77*t397+3.72017044624d-5*t130*t134*t203*t277-2.439728d-
     5           2*t130*t131*t203*t277-1.219864d-2*t129*t130*t203*t277-6
     6           .09932d-3*t128*t134*t277-6.09932d-3*t128*t133*t277+2.0d
     7           +0*t128*t129*t277
              t577 = 1/taua**3
              t578 = 1/rhoa**8.666666666666666d+0
              t579 = 1/rhoa**6
              t580 = -1.6482816d-1*t200*t568*t98*t99+8.0d+0*t568*t96*t99
     1           +6.367575545856d-4*t100*t392*t568*t99+6.367575545856d-4
     2           *gammaaa*t392*t579*t97*t98+2.122525181952d-4*t102*t200*
     3           t568*t98-8.241408d-2*gammaaa*t200*t579*t97-4.120704d-2*
     4           t102*t568*t96+6.367575545856d-4*t392*t578*t93*t94+2.122
     5           525181952d-4*gammaaa*t101*t200*t579
              t581 = 2.2321022677440003d-4*t129*t130*t397*t568*t6+7.4403
     1           4089248d-5*t133*t203*t568*t6-4.879456d-2*t129*t203*t568
     2           *t6+2.2321022677440003d-4*t131*t132*t397*t568+2.2321022
     3           677440003d-4*t126*t127*t397*t568+7.44034089248d-5*t130*
     4           t134*t203*t568-9.758912d-2*t130*t131*t203*t568-2.439728
     5           d-2*t128*t134*t568+8.0d+0*t128*t131*t568
              t582 = 2.2321022677440003d-4*t114*t129*t130*t397*t6*t88+7.
     1           44034089248d-5*t114*t133*t203*t6*t88-4.879456d-2*t114*t
     2           129*t203*t6*t88+2.2321022677440003d-4*t114*t131*t132*t3
     3           97*t88+2.2321022677440003d-4*t114*t126*t127*t397*t88+7.
     4           44034089248d-5*t114*t130*t134*t203*t88-9.758912d-2*t114
     5           *t130*t131*t203*t88-2.439728d-2*t114*t128*t134*t88+8.0d
     6           +0*t114*t128*t131*t88
              t583 = 1/taub**3
              t584 = 1/rhob**8.666666666666666d+0
              t585 = 1/rhob**6
              t586 = 6.367575545856d-4*t122*t474*t575*t99-1.6482816d-1*t
     1           121*t239*t575*t99+8.0d+0*t120*t575*t99+6.367575545856d-
     2           4*gammabb*t121*t474*t585*t97-8.241408d-2*gammabb*t239*t
     3           585*t97+6.367575545856d-4*t118*t474*t584*t93+2.12252518
     4           1952d-4*gammabb*t101*t239*t585+2.122525181952d-4*t102*t
     5           121*t239*t575-4.120704d-2*t102*t120*t575
              t587 = 2.2321022677440003d-4*t129*t130*t397*t575*t6+7.4403
     1           4089248d-5*t133*t203*t575*t6-4.879456d-2*t129*t203*t575
     2           *t6+2.2321022677440003d-4*t131*t132*t397*t575+2.2321022
     3           677440003d-4*t126*t127*t397*t575+7.44034089248d-5*t130*
     4           t134*t203*t575-9.758912d-2*t130*t131*t203*t575-2.439728
     5           d-2*t128*t134*t575+8.0d+0*t128*t131*t575
              t588 = 1/rhoa**11
              t589 = 1/t7**4
              t590 = 1/rhoa**8.333333333333334d+0
              t591 = 1/rhoa**5.666666666666667d+0
              t592 = t140**3
              t593 = 1/t14**7
              t594 = 1/rhoa**3.1666666666666665d+0
              t595 = t143**3
              t596 = 6.0d+0*t142*t21*t290*t595-1.9298375398431045d+2*t21
     1           *t288*t595/t18**5+2.0690405167709364d+3*t21*t595/(t18**
     2           6*t19**3)+1.1102230246251565d-16*t136*t141*t25*(-2.5204
     3           26340996149d+0*t594-1.5008036906238065d+0*t593-2.307997
     4           9182303428d+0*t568-5.620753557770543d-1*t187)+1.0d+0*t1
     5           42*t144*t21*(-4.684972743248224d+0*t594-3.0838758291892
     6           67d+0*t593-3.9871442462415524d+0*t568-7.128507529742789
     7           d-1*t187)+6.661338147750939d-16*t136*t25*t282*t592-1.07
     8           12750352598913d-14*t25*t280*t592/t22**5+5.7427410515035
     9           65d-14*t25*t592/(t22**6*t23**3)+9.490883560204437d-19*t
     :           24*t568+4.1099018897499934d-3*t20*t568-6.0d+0*t142*t143
     ;           *t21*t291*t292+9.649187699215522d+1*t143*t21*t288*t290*
     <           t292-1.274696188700087d-1*t138*t142*t144*t292+2.5493923
     =           77400174d-1*t138*t142*t289*t291-4.0999275947472624d+0*t
     >           138*t288*t289*t290-6.661338147750939d-16*t136*t140*t25*
     ?           t283*t287+5.356375176299456d-15*t140*t25*t280*t282*t287
     @           -1.4718104502398274d-17*t136*t138*t141*t287+1.699594918
     1           2667827d-1*t142*t143*t144*t285+1.962413933653103d-17*t1
     2           36*t140*t141*t285+2.943620900479655d-17*t136*t138*t281*
     3           t283-2.3669625486718335d-16*t138*t280*t281*t282
              t597 = 4.824593849607761d+1*t301*t302*t303*t43*t52
              t598 = -6.0d+0*t152*t301*t306*t43*t52
              t599 = -2.6513779981040353d-1*t148*t150*t151*t152*t52
              t600 = 3.0d+0*t151*t152*t313*t43*t52
              t601 = -5.19476882440587d+1*t315*t316*t317*t61*t62
              t602 = 3.5089341735807883d+0*t156*t315*t320*t61*t62
              t603 = 8.072185179299687d-2*t148*t154*t155*t156*t62
              t604 = -1.7544670867903941d+0*t155*t156*t323*t61*t62
              t605 = 1.856176655010858d+2*t325*t326*t327*t45*t46*t50*t67
              t606 = -1.1541966305589217d+1*t160*t325*t330*t45*t46*t50*t
     1           67
              t607 = -4.904166819946466d-1*t158*t159*t160*t183*t45*t50
              t608 = 5.770983152794609d+0*t159*t160*t333*t45*t46*t50*t67
              t609 = -4.616786522235687d+1*t158*t159*t160*t172*t45*t50*t
     1           67
              t610 = -1.099109305675375d-2*t311*t52*t59
              t611 = 1.8175185709928465d-3*t311*t62*t65
              t612 = -7.11545236961578d-2*t368*t45*t50*t70
              t613 = -3.588478118171826d+0*t352*t45*t50*t67*t70
              t614 = -2.1530868709030954d+0*t355*t46*t50*t67*t70
              t615 = t150**3
              t616 = 5.172601291927341d+2*t43*t52*t615/(t57**6*t58**3)
              t617 = -9.649187699215522d+1*t303*t43*t52*t615/t57**5
              t618 = 4.824593849607761d+1*t150*t302*t303*t313*t43*t52
              t619 = -2.1319703304396778d+0*t148*t301*t302*t303*t52
              t620 = 6.0d+0*t152*t302*t43*t52*t615
              t621 = -6.0d+0*t150*t152*t306*t313*t43*t52
              t622 = 2.6513779981040353d-1*t148*t152*t301*t306*t52
              t623 = -1.3256889990520176d-1*t148*t151*t152*t313*t52
              t624 = 1.767585332069357d-1*t150*t151*t152*t311*t52
              t625 = 1/t41**3.6666666666666664d+0
              t626 = 1/t54**7
              t627 = 1/t41**3.3333333333333337d+0
              t628 = 1/t41**3.1666666666666665d+0
              t629 = 1.0d+0*t151*t152*t43*t52*(-2.520426340996149d+0*t62
     1           8-2.3079979182303428d+0*t627-1.5008036906238065d+0*t626
     2           -5.620753557770543d-1*t625)
              t630 = t154**3
              t631 = -1.0254062650399592d+3*t61*t62*t630/(t63**6*t64**3)
              t632 = 1.0389537648811739d+2*t317*t61*t62*t630/t63**5
              t633 = -5.19476882440587d+1*t154*t316*t317*t323*t61*t62
              t634 = 1.1950391155803675d+0*t148*t315*t316*t317*t62
              t635 = -3.5089341735807883d+0*t156*t316*t61*t62*t630
              t636 = 3.5089341735807883d+0*t154*t156*t320*t323*t61*t62
              t637 = -8.072185179299687d-2*t148*t156*t315*t320*t62
              t638 = 4.0360925896498434d-2*t148*t155*t156*t323*t62
              t639 = -5.381456786199791d-2*t154*t155*t156*t311*t62
              t640 = -5.848223622634647d-1*t155*t156*t61*t62*(-3.4366886
     1           01932293d+0*t628-2.3308360066730832d+0*t627-8.064323383
     2           643707d-1*t626-5.663741022599518d-1*t625)
              t641 = t158**3
              t642 = 3.9801326549115085d+3*t45*t46*t50*t641*t67/(t68**6*
     1           t69**3)
              t643 = -3.712353310021716d+2*t327*t45*t46*t50*t641*t67/t68
     1           **5
              t644 = 1.856176655010858d+2*t158*t326*t327*t333*t45*t46*t5
     1           0*t67
              t645 = -7.424706620043432d+2*t172*t325*t326*t327*t45*t50*t
     1           67
              t646 = -7.886871025654724d+0*t183*t325*t326*t327*t45*t50
              t647 = 1.1541966305589217d+1*t160*t326*t45*t46*t50*t641*t6
     1           7
              t648 = -1.1541966305589217d+1*t158*t160*t330*t333*t45*t46*
     1           t50*t67
              t649 = 4.616786522235687d+1*t160*t172*t325*t330*t45*t50*t6
     1           7
              t650 = 4.904166819946466d-1*t160*t183*t325*t330*t45*t50
              t651 = -2.452083409973233d-1*t159*t160*t183*t333*t45*t50
              t652 = 2.2886111826416838d+0*t158*t159*t160*t368*t45*t50
              t653 = 1.923661050931536d+0*t159*t160*t45*t46*t50*(-4.6849
     1           72743248224d+0*t628-3.9871442462415524d+0*t627-3.083875
     2           829189267d+0*t626-7.128507529742789d-1*t625)*t67
              t654 = -2.3083932611178434d+1*t159*t160*t172*t333*t45*t50*
     1           t67
              t655 = 1.1541966305589217d+2*t158*t159*t160*t352*t45*t50*t
     1           67
              t656 = 6.925179783353531d+1*t158*t159*t160*t355*t46*t50*t6
     1           7
              t657 = 8.548627933030694d-3*t52*t59*t627
              t658 = 1/t48**1.6666666666666669d+0
              t659 = 6*t44*t46
              t660 = -6*t339
              t661 = 1/t49**1.6666666666666669d+0
              t662 = -6*t44*t46
              t663 = 6*t339
              t664 = 1.3333333333333333d+0*t169*(t663+t662)-2.9629629629
     1           62963d-1*t168**3*t661+1.3333333333333333d+0*t166*(t660+
     2           t659)-2.962962962962963d-1*t165**3*t658+1.3333333333333
     3           333d+0*t168*t344*t347+1.3333333333333333d+0*t165*t338*t
     4           342
              t665 = -1.923661050931536d+0*t45*t46*t664
              t666 = 2.3083932611178434d+1*t172*t348*t45
              t667 = -2.3083932611178434d+1*t174*t348*t46
              t668 = -1.1541966305589216d+2*t170*t352*t45
              t669 = 1.8467146088942746d+2*t170*t172*t174
              t670 = -6.925179783353531d+1*t170*t355*t46
              t671 = 1/t41**7
              t672 = 2.3083932611178432d+2*t45*t50*t671
              t673 = -4.6167865222356863d+2*t174*t352*t50
              t674 = 2.770071913341412d+2*t172*t355*t50
              t675 = -4.616786522235687d+1*t44*t46*t50
              t676 = -1.4136255552166585d-3*t62*t627*t65
              t677 = 2.0103976536374746d-1*t45*t50*t70/t41**7.3333333333
     1           33333d+0
              t678 = 9.148438760934575d-2*t183*t355*t50*t70
              t679 = 7.176956236343652d+0*t45*t50*t67*t671*t70
              t680 = 8.612347483612381d+0*t172*t355*t50*t67*t70
              t681 = -1.4353912472687305d+0*t44*t46*t50*t67*t70
              t682 = t41*(-5.980796863619711d-2*t45*t46*t664*t67*t70-1.4
     1           353912472687305d+1*t174*t352*t50*t67*t70-2.153086870903
     2           0954d+0*t170*t355*t46*t67*t70-7.176956236343652d-1*t174
     3           *t348*t46*t67*t70-3.588478118171826d+0*t170*t352*t45*t6
     4           7*t70+7.176956236343652d-1*t172*t348*t45*t67*t70+5.7415
     5           64989074922d+0*t170*t172*t174*t67*t70-2.846180947846312
     6           4d-1*t174*t368*t50*t70-7.11545236961578d-2*t170*t368*t4
     7           5*t70+7.623698967445479d-3*t183*t348*t45*t70+6.09895917
     8           3956384d-2*t170*t174*t183*t70+t681+t680+t679+t678+t677+
     9           t676+1.9751631321680768d-2*t61*t65*(t675+t674+t673+t672
     :           +t670+t669+t668+t667+t666+t665+1.923661050931536d+0*t66
     ;           4)-6.21814d-2*t43*t59*(t675+t674+t673+t672+t670+t669+t6
     <           68+t667+t666+t665)+2.3083932611178434d+1*t159*t160*t174
     =           *t333*t46*t50*t67-4.616786522235687d+1*t160*t174*t325*t
     >           330*t46*t50*t67+7.424706620043432d+2*t174*t325*t326*t32
     ?           7*t46*t50*t67-1.8467146088942746d+2*t158*t159*t160*t172
     @           *t174*t50*t67+5.770983152794609d+0*t158*t159*t160*t348*
     1           t45*t46*t67+5.770983152794609d+0*t159*t160*t170*t333*t4
     2           5*t46*t67-1.1541966305589217d+1*t160*t170*t325*t330*t45
     3           *t46*t67+1.856176655010858d+2*t170*t325*t326*t327*t45*t
     4           46*t67+4.616786522235687d+1*t158*t159*t160*t170*t174*t4
     5           6*t67-4.616786522235687d+1*t158*t159*t160*t170*t172*t45
     6           *t67+t657+t656+t655+t654+t653+t652+t651+t650-1.36313892
     7           8244635d-3*t148*t361*t65+1.8175185709928465d-3*t179*t31
     8           1*t65+t649+t648+t647+t646+t645+t644+t643+t642+t640+t639
     9           +t638+t637+t636+t635+t634+t633+t632+t631+t629+t624+t623
     :           +t622+t621+t620+t619+t618+t617+t616-1.7544670867903941d
     ;           +0*t154*t155*t156*t361*t61-1.7544670867903941d+0*t155*t
     <           156*t179*t323*t61+3.5089341735807883d+0*t156*t179*t315*
     =           t320*t61-5.19476882440587d+1*t179*t315*t316*t317*t61+8.
     >           243319792565312d-3*t148*t357*t59-1.099109305675375d-2*t
     ?           176*t311*t59-1.9616667279785865d+0*t158*t159*t160*t174*
     @           t183*t50-4.904166819946466d-1*t158*t159*t160*t170*t183*
     1           t45+3.0d+0*t150*t151*t152*t357*t43+3.0d+0*t151*t152*t17
     2           6*t313*t43-6.0d+0*t152*t176*t301*t306*t43+4.82459384960
     3           7761d+1*t176*t301*t302*t303*t43+8.072185179299687d-2*t1
     4           48*t154*t155*t156*t179-2.6513779981040353d-1*t148*t150*
     5           t151*t152*t176)+5.741564989074922d+0*t172*t174*t50*t67*
     6           t70-1.794239059085913d-1*t348*t45*t46*t67*t70-1.4353912
     7           472687305d+0*t170*t174*t46*t67*t70+1.4353912472687305d+
     8           0*t170*t172*t45*t67*t70+6.098959173956384d-2*t174*t183*
     9           t50*t70+1.524739793489096d-2*t170*t183*t45*t70+4.616786
     :           522235687d+1*t158*t159*t160*t174*t46*t50*t67+1.15419663
     ;           05589217d+1*t158*t159*t160*t170*t45*t46*t67+5.925489396
     <           50423d-2*t361*t61*t65-2.72627785648927d-3*t148*t179*t65
     =           +t614+t613+t612+t611+t610-3.5089341735807883d+0*t154*t1
     >           55*t156*t179*t61+t609+t608+t607+t606+t605+t604+t603+t60
     ?           2+t601+t600+t599+t598+t597-rhoa*t596-1.865442d-1*t357*t
     @           43*t59+1.6486639585130625d-2*t148*t176*t59+6.0d+0*t150*
     1           t151*t152*t176*t43-3.0d+0*t142*t144*t21*t292+6.0d+0*t14
     2           2*t21*t289*t291-9.649187699215522d+1*t21*t288*t289*t290
     3           -3.3306690738754696d-16*t136*t141*t25*t287+1.2202564577
     4           405706d-18*t24*t285+5.284159572535705d-3*t20*t285+6.661
     5           338147750939d-16*t136*t25*t281*t283-5.356375176299456d-
     6           15*t25*t280*t281*t282+2.549392377400174d-1*t138*t142*t1
     7           43*t144+2.943620900479655d-17*t136*t138*t140*t141
              t683 = 1/rhoa**3
              t684 = gammaaa**4
              t685 = 1/t74**4
              t686 = 1/rhoa**1.3666666666666666d+1
              t687 = t199**3
              t688 = 1/t90**5
              t689 = -3.2592592592592595d+1*t377*taua-4.5629629629629626
     1           d+1*gammaaa*t591
              t690 = 1/t124**5
              t691 = -1.243628d-1*t408*t43*t59
              t692 = 3.9503262643361536d-2*t409*t61*t65
              t693 = -1.1961593727239421d-1*t401*t45*t46*t67*t70
              t694 = 2.0d+0*t150*t151*t152*t408*t43
              t695 = -1.1696447245269295d+0*t154*t155*t156*t409*t61
              t696 = 3.847322101863072d+0*t158*t159*t160*t401*t45*t46*t6
     1           7
              t697 = -2.3083932611178434d+1*t158*t159*t160*t355*t46*t50*
     1           t67
              t698 = 5.495546528376875d-3*t148*t408*t59
              t699 = 1.5389288407452287d+1*t172*t401*t45
              t700 = -1.5389288407452287d+1*t174*t401*t46
              t701 = 1.3333333333333333d+0*t169*(t662+2*t339)-2.96296296
     1           2962963d-1*t217*t343*t661+1.3333333333333333d+0*t166*(t
     2           659-2*t339)-2.962962962962963d-1*t216*t337*t658+1.77777
     3           77777777776d+0*t168*t339*t344*t44-1.7777777777777776d+0
     4           *t165*t338*t339*t44+4.444444444444444d-1*t217*t344*t347
     5           +4.444444444444444d-1*t216*t338*t342
              t702 = -1.923661050931536d+0*t45*t46*t701
              t703 = 7.694644203726144d+0*t172*t348*t45
              t704 = 7.694644203726144d+0*t174*t348*t46
              t705 = -3.8473221018630716d+1*t218*t352*t45
              t706 = 6.155715362980915d+1*t172*t174*t218
              t707 = -2.3083932611178434d+1*t218*t355*t46
              t708 = -7.694644203726143d+1*t170*t352*t45
              t709 = 4.616786522235687d+1*t170*t355*t46
              t710 = -1.5389288407452287d+2*t174*t352*t50
              t711 = -9.233573044471374d+1*t172*t355*t50
              t712 = 4.616786522235687d+1*t44*t46*t50
              t713 = -9.087592854964233d-4*t148*t409*t65
              t714 = 5.082465978296986d-3*t183*t401*t45*t70
              t715 = 4.7846374908957684d-1*t172*t401*t45*t67*t70
              t716 = -2.870782494537461d+0*t172*t355*t50*t67*t70
              t717 = 1.4353912472687305d+0*t44*t46*t50*t67*t70
              t718 = t41*(t717+t716+t715+t714+t713+1.9751631321680768d-2
     1           *t61*t65*(t712+t711+t710+t709+t708+t707+t706+t705+t704+
     2           t703+t702+1.923661050931536d+0*t701+t700+t699+t672)-6.2
     3           1814d-2*t43*t59*(t712+t711+t710+t709+t708+t707+t706+t70
     4           5+t704+t703+t702+t700+t699+t672)-5.980796863619711d-2*t
     5           45*t46*t67*t70*t701-4.7846374908957684d+0*t174*t352*t50
     6           *t67*t70-4.7846374908957684d-1*t174*t401*t46*t67*t70-7.
     7           176956236343652d-1*t218*t355*t46*t67*t70+1.435391247268
     8           7305d+0*t170*t355*t46*t67*t70+2.3923187454478842d-1*t17
     9           4*t348*t46*t67*t70-1.1961593727239421d+0*t218*t352*t45*
     :           t67*t70-2.3923187454478842d+0*t170*t352*t45*t67*t70+2.3
     ;           923187454478842d-1*t172*t348*t45*t67*t70+1.913854996358
     <           3074d+0*t172*t174*t218*t67*t70-9.487269826154375d-2*t17
     =           4*t368*t50*t70-3.049479586978192d-2*t183*t355*t50*t70-2
     >           .3718174565385935d-2*t218*t368*t45*t70-4.74363491307718
     ?           7d-2*t170*t368*t45*t70+2.541232989148493d-3*t183*t348*t
     @           45*t70+2.0329863913187946d-2*t174*t183*t218*t70+t698+t6
     1           97+t696+t695+t694+t679+t677+t676+7.694644203726144d+0*t
     2           159*t160*t174*t333*t46*t50*t67-1.538928840745229d+1*t16
     3           0*t174*t325*t330*t46*t50*t67+2.4749022066811444d+2*t174
     4           *t325*t326*t327*t46*t50*t67-6.155715362980916d+1*t158*t
     5           159*t160*t172*t174*t50*t67+1.923661050931536d+0*t158*t1
     6           59*t160*t348*t45*t46*t67+1.923661050931536d+0*t159*t160
     7           *t218*t333*t45*t46*t67+3.847322101863072d+0*t159*t160*t
     8           170*t333*t45*t46*t67-3.847322101863072d+0*t160*t218*t32
     9           5*t330*t45*t46*t67-7.694644203726144d+0*t160*t170*t325*
     :           t330*t45*t46*t67+6.187255516702861d+1*t218*t325*t326*t3
     ;           27*t45*t46*t67+1.2374511033405722d+2*t170*t325*t326*t32
     <           7*t45*t46*t67+1.538928840745229d+1*t158*t159*t160*t174*
     =           t218*t46*t67-1.538928840745229d+1*t158*t159*t160*t172*t
     >           218*t45*t67-3.077857681490458d+1*t158*t159*t160*t170*t1
     ?           72*t45*t67+t657+t655+t654+t653+t652+t651+t650-4.5437964
     @           274821163d-4*t148*t361*t65+6.058395236642822d-4*t223*t3
     1           11*t65+1.2116790473285642d-3*t179*t311*t65+t649+t648+t6
     2           47+t646+t645+t644+t643+t642+t640+t639+t638+t637+t636+t6
     3           35+t634+t633+t632+t631+t629+t624+t623+t622+t621+t620+t6
     4           19+t618+t617+t616-5.848223622634647d-1*t154*t155*t156*t
     5           361*t61-5.848223622634647d-1*t155*t156*t223*t323*t61-1.
     6           1696447245269295d+0*t155*t156*t179*t323*t61+1.169644724
     7           5269295d+0*t156*t223*t315*t320*t61+2.339289449053859d+0
     8           *t156*t179*t315*t320*t61-1.73158960813529d+1*t223*t315*
     9           t316*t317*t61-3.46317921627058d+1*t179*t315*t316*t317*t
     :           61+2.747773264188437d-3*t148*t357*t59-3.663697685584583
     ;           d-3*t221*t311*t59-7.327395371169166d-3*t176*t311*t59-6.
     <           538889093261956d-1*t158*t159*t160*t174*t183*t50-1.63472
     =           22733154887d-1*t158*t159*t160*t183*t218*t45-3.269444546
     >           6309774d-1*t158*t159*t160*t170*t183*t45+1.0d+0*t150*t15
     ?           1*t152*t357*t43+1.0d+0*t151*t152*t221*t313*t43+2.0d+0*t
     @           151*t152*t176*t313*t43-2.0d+0*t152*t221*t301*t306*t43-4
     1           .0d+0*t152*t176*t301*t306*t43+1.6081979498692536d+1*t22
     2           1*t301*t302*t303*t43+3.216395899738507d+1*t176*t301*t30
     3           2*t303*t43+2.690728393099896d-2*t148*t154*t155*t156*t22
     4           3-8.837926660346784d-2*t148*t150*t151*t152*t221+5.38145
     5           6786199792d-2*t148*t154*t155*t156*t179-1.76758533206935
     6           7d-1*t148*t150*t151*t152*t176)-4.7846374908957684d-1*t1
     7           74*t218*t46*t67*t70+9.569274981791537d-1*t170*t172*t45*
     8           t67*t70+1.0164931956593973d-2*t170*t183*t45*t70+t693+t6
     9           92+t691+7.694644203726144d+0*t158*t159*t160*t170*t45*t4
     :           6*t67-1.8175185709928465d-3*t148*t179*t65+t613+t612+t61
     ;           1+t610-2.339289449053859d+0*t154*t155*t156*t179*t61+t60
     <           9+t608+t607+t606+t605+t604+t603+t602+t601+t600+t599+t59
     =           8+t597+1.099109305675375d-2*t148*t176*t59+t454+t453+t45
     >           1+t448+t435+t434+t433+4.0d+0*t150*t151*t152*t176*t43+t4
     ?           10+t372+t370+t365+t362+t358+t336
              t719 = -2.962962962962963d-1*t168*t439*t661-2.962962962962
     1           963d-1*t165*t437*t658-8*t169*t44*t46+8*t166*t44*t46+4.4
     2           44444444444444d-1*t168*t344*t440+1.7777777777777776d+0*
     3           t217*t339*t344*t44-1.7777777777777776d+0*t216*t338*t339
     4           *t44+4.444444444444444d-1*t165*t338*t438-2.666666666666
     5           6666d+0*t169*t339+2.6666666666666666d+0*t166*t339
              t720 = -1.923661050931536d+0*t45*t46*t719
              t721 = 1.5389288407452287d+1*t174*t401*t46
              t722 = 7.694644203726144d+0*t172*t441*t45
              t723 = -7.694644203726144d+0*t174*t441*t46
              t724 = -7.694644203726143d+1*t218*t352*t45
              t725 = 4.616786522235687d+1*t218*t355*t46
              t726 = -3.8473221018630716d+1*t170*t352*t45
              t727 = -6.155715362980915d+1*t170*t172*t174
              t728 = -2.3083932611178434d+1*t170*t355*t46
              t729 = 1.5389288407452287d+2*t174*t352*t50
              t730 = t41*(1.9751631321680768d-2*t61*t65*(t729+t728+t727+
     1           t726+t725+t724+t723+t722+t721+t720+1.923661050931536d+0
     2           *t719+t711+t699+t675+t672)-6.21814d-2*t43*t59*(t729+t72
     3           8+t727+t726+t725+t724+t723+t722+t721+t720+t711+t699+t67
     4           5+t672)-5.980796863619711d-2*t45*t46*t67*t70*t719+t716+
     5           t715+t714+t713+4.7846374908957684d+0*t174*t352*t50*t67*
     6           t70-2.3923187454478842d-1*t174*t441*t46*t67*t70+4.78463
     7           74908957684d-1*t174*t401*t46*t67*t70+1.4353912472687305
     8           d+0*t218*t355*t46*t67*t70-7.176956236343652d-1*t170*t35
     9           5*t46*t67*t70+2.3923187454478842d-1*t172*t441*t45*t67*t
     :           70-2.3923187454478842d+0*t218*t352*t45*t67*t70-1.196159
     ;           3727239421d+0*t170*t352*t45*t67*t70-1.9138549963583074d
     <           +0*t170*t172*t174*t67*t70+9.487269826154374d-2*t174*t36
     =           8*t50*t70-3.0494795869781915d-2*t183*t355*t50*t70+2.541
     >           232989148493d-3*t183*t441*t45*t70-4.743634913077187d-2*
     ?           t218*t368*t45*t70-2.3718174565385935d-2*t170*t368*t45*t
     @           70-2.0329863913187946d-2*t170*t174*t183*t70+t698+t697+t
     1           696+t695+t694+t681+t679+t677+t676-7.694644203726144d+0*
     2           t159*t160*t174*t333*t46*t50*t67+1.538928840745229d+1*t1
     3           60*t174*t325*t330*t46*t50*t67-2.4749022066811444d+2*t17
     4           4*t325*t326*t327*t46*t50*t67+6.155715362980916d+1*t158*
     5           t159*t160*t172*t174*t50*t67+1.923661050931536d+0*t158*t
     6           159*t160*t441*t45*t46*t67+3.847322101863072d+0*t159*t16
     7           0*t218*t333*t45*t46*t67+1.923661050931536d+0*t159*t160*
     8           t170*t333*t45*t46*t67-7.694644203726144d+0*t160*t218*t3
     9           25*t330*t45*t46*t67-3.847322101863072d+0*t160*t170*t325
     :           *t330*t45*t46*t67+1.2374511033405722d+2*t218*t325*t326*
     ;           t327*t45*t46*t67+6.187255516702861d+1*t170*t325*t326*t3
     <           27*t45*t46*t67-1.538928840745229d+1*t158*t159*t160*t170
     =           *t174*t46*t67-3.077857681490458d+1*t158*t159*t160*t172*
     >           t218*t45*t67-1.538928840745229d+1*t158*t159*t160*t170*t
     ?           172*t45*t67+t657+t655+t654+t653+t652+t651+t650-4.543796
     @           4274821163d-4*t148*t449*t65+1.2116790473285642d-3*t223*
     1           t311*t65+6.058395236642822d-4*t179*t311*t65+t649+t648+t
     2           647+t646+t645+t644+t643+t642+t640+t639+t638+t637+t636+t
     3           635+t634+t633+t632+t631+t629+t624+t623+t622+t621+t620+t
     4           619+t618+t617+t616-5.848223622634647d-1*t154*t155*t156*
     5           t449*t61-1.1696447245269295d+0*t155*t156*t223*t323*t61-
     6           5.848223622634647d-1*t155*t156*t179*t323*t61+2.33928944
     7           9053859d+0*t156*t223*t315*t320*t61+1.1696447245269295d+
     8           0*t156*t179*t315*t320*t61-3.46317921627058d+1*t223*t315
     9           *t316*t317*t61-1.73158960813529d+1*t179*t315*t316*t317*
     :           t61+2.747773264188437d-3*t148*t446*t59-7.32739537116916
     ;           6d-3*t221*t311*t59-3.663697685584583d-3*t176*t311*t59+6
     <           .538889093261955d-1*t158*t159*t160*t174*t183*t50-3.2694
     =           445466309774d-1*t158*t159*t160*t183*t218*t45-1.63472227
     >           33154887d-1*t158*t159*t160*t170*t183*t45+1.0d+0*t150*t1
     ?           51*t152*t43*t446+2.0d+0*t151*t152*t221*t313*t43+1.0d+0*
     @           t151*t152*t176*t313*t43-4.0d+0*t152*t221*t301*t306*t43-
     1           2.0d+0*t152*t176*t301*t306*t43+3.216395899738507d+1*t22
     2           1*t301*t302*t303*t43+1.6081979498692536d+1*t176*t301*t3
     3           02*t303*t43+5.381456786199792d-2*t148*t154*t155*t156*t2
     4           23-1.767585332069357d-1*t148*t150*t151*t152*t221+2.6907
     5           28393099896d-2*t148*t154*t155*t156*t179-8.8379266603467
     6           84d-2*t148*t150*t151*t152*t176)+4.7846374908957684d-1*t
     7           170*t174*t46*t67*t70+9.569274981791537d-1*t172*t218*t45
     8           *t67*t70+1.0164931956593973d-2*t183*t218*t45*t70+t693+t
     9           692+t691+7.694644203726144d+0*t158*t159*t160*t218*t45*t
     :           46*t67-1.8175185709928465d-3*t148*t223*t65+t613+t612+t6
     ;           11+t610-2.339289449053859d+0*t154*t155*t156*t223*t61+t6
     <           09+t608+t607+t606+t605+t604+t603+t602+t601+t600+t599+t5
     =           98+t597+1.099109305675375d-2*t148*t221*t59+t456+t455+t4
     >           52+t450+t447+t436+4.0d+0*t150*t151*t152*t221*t43+t410+t
     ?           367+t366+t363+t359+t329+t319+t305
              t731 = 1/rhob**11
              t732 = 1/rhob**8.333333333333334d+0
              t733 = 1/rhob**5.666666666666667d+0
              t734 = t210**3
              t735 = 1/t28**7
              t736 = 1/rhob**3.1666666666666665d+0
              t737 = t213**3
              t738 = 6.0d+0*t212*t35*t429*t737-1.9298375398431045d+2*t35
     1           *t427*t737/t32**5+2.0690405167709364d+3*t35*t737/(t32**
     2           6*t33**3)+1.1102230246251565d-16*t206*t211*t39*(-2.5204
     3           26340996149d+0*t736-1.5008036906238065d+0*t735-2.307997
     4           9182303428d+0*t575-5.620753557770543d-1*t227)+1.0d+0*t2
     5           12*t214*t35*(-4.684972743248224d+0*t736-3.0838758291892
     6           67d+0*t735-3.9871442462415524d+0*t575-7.128507529742789
     7           d-1*t227)+6.661338147750939d-16*t206*t39*t421*t734-1.07
     8           12750352598913d-14*t39*t419*t734/t36**5+5.7427410515035
     9           65d-14*t39*t734/(t36**6*t37**3)+9.490883560204437d-19*t
     :           38*t575+4.1099018897499934d-3*t34*t575-6.0d+0*t212*t213
     ;           *t35*t430*t431+9.649187699215522d+1*t213*t35*t427*t429*
     <           t431-1.274696188700087d-1*t208*t212*t214*t431+2.5493923
     =           77400174d-1*t208*t212*t428*t430-4.0999275947472624d+0*t
     >           208*t427*t428*t429-6.661338147750939d-16*t206*t210*t39*
     ?           t422*t426+5.356375176299456d-15*t210*t39*t419*t421*t426
     @           -1.4718104502398274d-17*t206*t208*t211*t426+1.699594918
     1           2667827d-1*t212*t213*t214*t424+1.962413933653103d-17*t2
     2           06*t210*t211*t424+2.943620900479655d-17*t206*t208*t420*
     3           t422-2.3669625486718335d-16*t208*t419*t420*t421
              t739 = 1.3333333333333333d+0*t166*(t663+t659)+1.3333333333
     1           333333d+0*t169*(t662+t660)-2.962962962962963d-1*t217**3
     2           *t661-2.962962962962963d-1*t216**3*t658+1.3333333333333
     3           333d+0*t217*t344*t440+1.3333333333333333d+0*t216*t338*t
     4           438
              t740 = -1.923661050931536d+0*t45*t46*t739
              t741 = 2.3083932611178434d+1*t172*t441*t45
              t742 = 2.3083932611178434d+1*t174*t441*t46
              t743 = -1.1541966305589216d+2*t218*t352*t45
              t744 = -1.8467146088942746d+2*t172*t174*t218
              t745 = -6.925179783353531d+1*t218*t355*t46
              t746 = 4.6167865222356863d+2*t174*t352*t50
              t747 = t41*(1.9751631321680768d-2*t61*t65*(t746+t745+t744+
     1           t743+t742+t741+t740+1.923661050931536d+0*t739+t712+t674
     2           +t672)-6.21814d-2*t43*t59*(t746+t745+t744+t743+t742+t74
     3           1+t740+t712+t674+t672)-5.980796863619711d-2*t45*t46*t67
     4           *t70*t739+t717+1.4353912472687305d+1*t174*t352*t50*t67*
     5           t70+7.176956236343652d-1*t174*t441*t46*t67*t70-2.153086
     6           8709030954d+0*t218*t355*t46*t67*t70+7.176956236343652d-
     7           1*t172*t441*t45*t67*t70-3.588478118171826d+0*t218*t352*
     8           t45*t67*t70-5.741564989074922d+0*t172*t174*t218*t67*t70
     9           +2.8461809478463124d-1*t174*t368*t50*t70+7.623698967445
     :           479d-3*t183*t441*t45*t70-7.11545236961578d-2*t218*t368*
     ;           t45*t70-6.098959173956384d-2*t174*t183*t218*t70+t680+t6
     <           79+t678+t677+t676-2.3083932611178434d+1*t159*t160*t174*
     =           t333*t46*t50*t67+4.616786522235687d+1*t160*t174*t325*t3
     >           30*t46*t50*t67-7.424706620043432d+2*t174*t325*t326*t327
     ?           *t46*t50*t67+1.8467146088942746d+2*t158*t159*t160*t172*
     @           t174*t50*t67+5.770983152794609d+0*t158*t159*t160*t441*t
     1           45*t46*t67+5.770983152794609d+0*t159*t160*t218*t333*t45
     2           *t46*t67-1.1541966305589217d+1*t160*t218*t325*t330*t45*
     3           t46*t67+1.856176655010858d+2*t218*t325*t326*t327*t45*t4
     4           6*t67-4.616786522235687d+1*t158*t159*t160*t174*t218*t46
     5           *t67-4.616786522235687d+1*t158*t159*t160*t172*t218*t45*
     6           t67+t657+t656+t655+t654+t653+t652+t651+t650-1.363138928
     7           244635d-3*t148*t449*t65+1.8175185709928465d-3*t223*t311
     8           *t65+t649+t648+t647+t646+t645+t644+t643+t642+t640+t639+
     9           t638+t637+t636+t635+t634+t633+t632+t631+t629+t624+t623+
     :           t622+t621+t620+t619+t618+t617+t616-1.7544670867903941d+
     ;           0*t154*t155*t156*t449*t61-1.7544670867903941d+0*t155*t1
     <           56*t223*t323*t61+3.5089341735807883d+0*t156*t223*t315*t
     =           320*t61-5.19476882440587d+1*t223*t315*t316*t317*t61+8.2
     >           43319792565312d-3*t148*t446*t59-1.099109305675375d-2*t2
     ?           21*t311*t59+1.9616667279785865d+0*t158*t159*t160*t174*t
     @           183*t50-4.904166819946466d-1*t158*t159*t160*t183*t218*t
     1           45+3.0d+0*t150*t151*t152*t43*t446+3.0d+0*t151*t152*t221
     2           *t313*t43-6.0d+0*t152*t221*t301*t306*t43+4.824593849607
     3           761d+1*t221*t301*t302*t303*t43+8.072185179299687d-2*t14
     4           8*t154*t155*t156*t223-2.6513779981040353d-1*t148*t150*t
     5           151*t152*t221)-rhob*t738-5.741564989074922d+0*t172*t174
     6           *t50*t67*t70-1.794239059085913d-1*t441*t45*t46*t67*t70+
     7           1.4353912472687305d+0*t174*t218*t46*t67*t70+1.435391247
     8           2687305d+0*t172*t218*t45*t67*t70-6.098959173956384d-2*t
     9           174*t183*t50*t70+1.524739793489096d-2*t183*t218*t45*t70
     :           -4.616786522235687d+1*t158*t159*t160*t174*t46*t50*t67+1
     ;           .1541966305589217d+1*t158*t159*t160*t218*t45*t46*t67+5.
     <           92548939650423d-2*t449*t61*t65-2.72627785648927d-3*t148
     =           *t223*t65+t614+t613+t612+t611+t610-3.5089341735807883d+
     >           0*t154*t155*t156*t223*t61+t609+t608+t607+t606+t605+t604
     ?           +t603+t602+t601+t600+t599+t598+t597-1.865442d-1*t43*t44
     @           6*t59+1.6486639585130625d-2*t148*t221*t59-3.0d+0*t212*t
     1           214*t35*t431+6.0d+0*t212*t35*t428*t430+6.0d+0*t150*t151
     2           *t152*t221*t43-9.649187699215522d+1*t35*t427*t428*t429-
     3           3.3306690738754696d-16*t206*t211*t39*t426+1.22025645774
     4           05706d-18*t38*t424+5.284159572535705d-3*t34*t424+6.6613
     5           38147750939d-16*t206*t39*t420*t422-5.356375176299456d-1
     6           5*t39*t419*t420*t421+2.549392377400174d-1*t208*t212*t21
     7           3*t214+2.943620900479655d-17*t206*t208*t210*t211
              t748 = 1/rhob**3
              t749 = gammabb**4
              t750 = 1/t104**4
              t751 = 1/rhob**1.3666666666666666d+1
              t752 = t238**3
              t753 = 1/t116**5
              t754 = -3.2592592592592595d+1*t459*taub-4.5629629629629626
     1           d+1*gammabb*t733
              t755 = t248-1.25d-1*gammaaa*t252*t26
              t756 = 1.25d-1*t145*t83
              t757 = 1.25d-1*t198*t26
              t758 = 1/rhoa**1.2666666666666665d+1
              t759 = -1.25d-1*gammaaa*t254*t26-1.25d-1*t103*t26
              t760 = t260-1.25d-1*gammabb*t264*t40
              t761 = 1.25d-1*t109*t215
              t762 = 1.25d-1*t237*t40
              t763 = 1/rhob**1.2666666666666665d+1
              t764 = -1.25d-1*gammabb*t266*t40-1.25d-1*t123*t40
              t765 = 2.5d-1*t252*t26
              t766 = 1/rhoa**1.1666666666666665d+1
              t767 = 1.25d-1*gammaaa*t26*t535+2.5d-1*t254*t26
              t768 = -1.030176d-2*t494
              t769 = 2.5d-1*t264*t40
              t770 = 1/rhob**1.1666666666666665d+1
              t771 = 1.25d-1*gammabb*t40*t551+2.5d-1*t266*t40
              t772 = -1.030176d-2*t522
              t773 = -1.030176d-2*t492
              t774 = -1.8600852231200002d-4*t126*t127*t2*t397*t4
              t775 = -1.8600852231200002d-4*t129*t130*t2*t397*t4*t6
              t776 = -1.8600852231200002d-4*t131*t132*t2*t397*t4
              t777 = -6.200284077066667d-5*t133*t2*t203*t4*t6
              t778 = 4.066213333333334d-2*t126*t2*t203*t4*t6
              t779 = 2.033106666666667d-2*t129*t2*t203*t4*t6
              t780 = -6.200284077066667d-5*t130*t134*t2*t203*t4
              t781 = 2.033106666666667d-2*t129*t130*t2*t203*t4
              t782 = 4.066213333333334d-2*t130*t131*t2*t203*t4
              t783 = 1.0165533333333335d-2*t128*t133*t2*t4
              t784 = 1.0165533333333335d-2*t128*t134*t2*t4
              t785 = -3.3333333333333337d+0*t128*t129*t2*t4
              t786 = -6.200284077066667d-5*t135*t2*t203*t4*t72
              t787 = -1.030176d-2*t520
              t788 = -1.28772d-3*gammaaa*t254*t26
              t789 = -1.28772d-3*t103*t26
              t790 = -1.28772d-3*gammabb*t266*t40
              t791 = -1.28772d-3*t123*t40
              t792 = 1/rhoa**5
              t793 = 1/rhob**5
              t794 = 1/taua**4
              t795 = 1/rhoa**7.666666666666667d+0
              t796 = 1/taub**4
              t797 = 1/rhob**7.666666666666667d+0
              fnc(iq) = (1.0d+0*rhoa*t103*t26*t87*t91+5.0d-1*rhoa*t26*t8
     1           3*t84*t86+1.0d+0*t125*t135*t72+1.0d+0*t12*t72+1.0d+0*rh
     2           ob*t113*t117*t123*t40+5.0d-1*rhob*t109*t110*t112*t40)*w
     3           ght+fnc(iq)
              Amat(iq,D1_RA) = (-5.15088d-3*rhoa*t103*t199*t26*t87*t96+1
     1           .25d-1*gammaaa*t103*t26*t84*t85*t91+t202*t91+t84*(5.0d-
     2           1*t26*t83*t86+5.0d-1*rhoa*t145*t83*t86+5.0d-1*rhoa*t198
     3           *t26*t86)+1.25d-1*gammaaa*t26*t83*t84*t85-3.04966d-3*t1
     4           28*t135*t199*t72+1.0d+0*t192*t72+t125*t205+1.0d+0*t12*t
     5           186)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-3.04966d-3*t128*t135*t238*t72+1.0d+0*t2
     1           31*t72+t110*(5.0d-1*rhob*t112*t237*t40+5.0d-1*t109*t112
     2           *t40+5.0d-1*rhob*t109*t112*t215)-5.15088d-3*rhob*t113*t
     3           120*t123*t238*t40+1.25d-1*gammabb*t110*t111*t117*t123*t
     4           40+1.25d-1*gammabb*t109*t110*t111*t40+t125*t243+t117*t2
     5           41+1.0d+0*t12*t226)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (-5.15088d-3*t103*t26*t87*t88*t96+1.0d+0
     1           *rhoa*t254*t26*t87*t91-1.25d-1*t103*t26*t84*t91+t84*(5.
     2           0d-1*rhoa*t252*t26*t86+t248)+1.0d+0*t125*t255*t72+1.0d+
     3           0*t247*t72-3.04966d-3*t128*t135*t2*t72)*wght+Cmat(iq,D1
     4           _GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (-3.04966d-3*t128*t135*t4*t72+1.0d+0*t12
     1           5*t267*t72+1.0d+0*t259*t72+t110*(5.0d-1*rhob*t112*t264*
     2           t40+t260)+1.0d+0*rhob*t113*t117*t266*t40-5.15088d-3*t11
     3           3*t114*t120*t123*t40-1.25d-1*t110*t117*t123*t40)*wght+C
     4           mat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (-1.030176d-2*t103*t13*t26*t87*t96+1.0d+0
     1           *rhoa*t26*t272*t87*t91+1.25d-1*gammaaa*t103*t26*t269*t9
     2           1-6.09932d-3*t128*t135*t72*t88-5.0d-1*rhoa*t26*t269*t83
     3           *t86+1.0d+0*rhoa*t26*t83*t84+1.0d+0*t125*t273*t72)*wght
     4           +Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*t125*t279*t72-6.09932d-3*t114*t12
     1           8*t135*t72+1.0d+0*rhob*t113*t117*t278*t40+1.25d-1*gamma
     2           bb*t117*t123*t275*t40-5.0d-1*rhob*t109*t112*t275*t40-1.
     3           030176d-2*t113*t120*t123*t27*t40+1.0d+0*rhob*t109*t110*
     4           t40)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (-1.28772d-3*gammaaa*t103*t199*t26*t8
     1           4*t85*t96+t396*t96+t391*t84*t85*t91-1.25d-1*gammaaa*t10
     2           3*t26*t382*t84*t91+t395*t91+5.30631295488d-5*rhoa*t103*
     3           t200*t26*t390*t87+t84*(5.0d-1*rhoa*t293*t83*t86+1.0d+0*
     4           t145*t83*t86+5.0d-1*rhoa*t26*t389*t86+1.0d+0*t198*t26*t
     5           86+1.0d+0*rhoa*t145*t198*t86+1.25d-1*gammaaa*t145*t83*t
     6           85+1.25d-1*gammaaa*t198*t26*t85+1.25d-1*gammaaa*t26*t38
     7           2*t83)+(1.25d-1*gammaaa*t145*t83+1.25d-1*gammaaa*t198*t
     8           26)*t84*t85-1.25d-1*gammaaa*t26*t382*t83*t84+1.86008522
     9           312d-5*t135*t203*t390*t72+1.0d+0*t381*t72+t128*t400+t12
     :           5*t399+1.0d+0*t12*t374+2.0d+0*t186*t192)*wght+Amat2(iq,
     ;           D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t415*t72+1.86008522312d-5*t13
     1           5*t199*t203*t238*t72+t128*t418+t125*t417+1.0d+0*t12*t41
     2           1+1.0d+0*t186*t231+1.0d+0*t192*t226)*wght+Amat2(iq,D2_R
     3           A_RB)
              Amat2(iq,D2_RB_RB) = (1.86008522312d-5*t135*t203*t472*t72+
     1           1.0d+0*t463*t72+t128*t481+t125*t480+t120*t478+t117*t477
     2           +t110*t111*t117*t473+5.30631295488d-5*rhob*t113*t123*t2
     3           39*t40*t472+t110*(5.0d-1*rhob*t112*t40*t471+1.25d-1*gam
     4           mabb*t109*t40*t464+5.0d-1*rhob*t109*t112*t432+1.0d+0*t1
     5           12*t237*t40+1.25d-1*gammabb*t111*t237*t40+1.0d+0*rhob*t
     6           112*t215*t237+1.0d+0*t109*t112*t215+1.25d-1*gammabb*t10
     7           9*t111*t215)-1.25d-1*gammabb*t110*t117*t123*t40*t464-1.
     8           25d-1*gammabb*t109*t110*t40*t464+1.0d+0*t12*t457+t110*t
     9           111*(1.25d-1*gammabb*t237*t40+1.25d-1*gammabb*t109*t215
     :           )-1.28772d-3*gammabb*t110*t111*t120*t123*t238*t40+2.0d+
     ;           0*t226*t231)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (-5.15088d-3*rhoa*t199*t254*t26*t87*
     1           t96+6.4386d-4*t103*t199*t26*t84*t96-6.4386d-4*gammaaa*t
     2           103*t187*t26*t84*t96+t2*t495*t96+t492*t84*t85*t91+t494*
     3           t91+5.30631295488d-5*t103*t199*t200*t26*t87*t88+t84*(5.
     4           0d-1*rhoa*t26*t491*t86+5.0d-1*t252*t26*t86+5.0d-1*rhoa*
     5           t145*t252*t86-1.25d-1*t26*t83*t85-1.25d-1*t145*t83-1.25
     6           d-1*t198*t26)+(t486+1.25d-1*gammaaa*t252*t26)*t84*t85+1
     7           .0d+0*t485*t72-3.04966d-3*t128*t199*t255*t72+1.86008522
     8           312d-5*t135*t199*t2*t203*t72+8.132426666666667d-3*t128*
     9           t135*t187*t72+t125*t497+1.0d+0*t186*t247-3.04966d-3*t12
     :           8*t2*t205)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t501*t72+1.86008522312d-5*t1
     1           35*t199*t203*t4*t72-3.04966d-3*t128*t199*t267*t72+t125*
     2           t503-3.04966d-3*t128*t205*t4+1.0d+0*t186*t259)*wght+Cma
     3           t2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (1.0d+0*t507*t72-3.04966d-3*t128*t23
     1           8*t255*t72+1.86008522312d-5*t135*t2*t203*t238*t72+t125*
     2           t509+1.0d+0*t226*t247-3.04966d-3*t128*t2*t243)*wght+Cma
     3           t2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (1.0d+0*t513*t72+1.86008522312d-5*t1
     1           35*t203*t238*t4*t72-3.04966d-3*t128*t238*t267*t72+8.132
     2           426666666667d-3*t128*t135*t227*t72+t125*t525+t120*t4*t5
     3           23+t117*t522+t110*t111*t117*t520+t110*(5.0d-1*rhob*t112
     4           *t40*t519+5.0d-1*t112*t264*t40-1.25d-1*t237*t40-1.25d-1
     5           *t109*t111*t40+5.0d-1*rhob*t112*t215*t264-1.25d-1*t109*
     6           t215)+t110*t111*(t514+1.25d-1*gammabb*t264*t40)-5.15088
     7           d-3*rhob*t113*t120*t238*t266*t40+5.30631295488d-5*t113*
     8           t114*t123*t238*t239*t40+6.4386d-4*t110*t120*t123*t238*t
     9           40-6.4386d-4*gammabb*t110*t120*t123*t227*t40-3.04966d-3
     :           *t128*t243*t4+1.0d+0*t226*t259)*wght+Cmat2(iq,D2_RB_GBB
     ;           )
              Cmat2(iq,D2_GAA_GAA) = (-1.030176d-2*t254*t26*t87*t88*t96+
     1           1.28772d-3*t103*t2*t26*t84*t96+1.86008522312d-5*t135*t2
     2           03*t72*t95+1.0d+0*rhoa*t26*t535*t87*t91-2.5d-1*t254*t26
     3           *t84*t91+5.30631295488d-5*t103*t200*t26*t271*t87+t84*(5
     4           .0d-1*rhoa*t26*t533*t86-2.5d-1*t252*t26)+1.0d+0*t125*t5
     5           36*t72+1.0d+0*t529*t72-6.09932d-3*t128*t2*t255*t72)*wgh
     6           t+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = (1.0d+0*t125*t541*t72+1.0d+0*t540*t
     1           72-3.04966d-3*t128*t255*t4*t72+1.86008522312d-5*t135*t2
     2           *t203*t4*t72-3.04966d-3*t128*t2*t267*t72)*wght+Cmat2(iq
     3           ,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (1.0d+0*t125*t552*t72+1.0d+0*t545*t
     1           72-6.09932d-3*t128*t267*t4*t72+1.86008522312d-5*t119*t1
     2           35*t203*t72+1.0d+0*rhob*t113*t117*t40*t551+t110*(5.0d-1
     3           *rhob*t112*t40*t549-2.5d-1*t264*t40)+1.28772d-3*t110*t1
     4           20*t123*t4*t40+5.30631295488d-5*t113*t123*t239*t277*t40
     5           -1.030176d-2*t113*t114*t120*t266*t40-2.5d-1*t110*t117*t
     6           266*t40)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = ((1.7169600000000002d-2*t103*t26*t87-
     1           1.030176d-2*t202)*t88*t96-5.15088d-3*rhoa*t199*t26*t272
     2           *t87*t96-1.28772d-3*gammaaa*t103*t2*t26*t84*t96-6.4386d
     3           -4*gammaaa*t103*t199*t26*t269*t96+1.25d-1*gammaaa*t26*t
     4           272*t84*t85*t91-1.25d-1*gammaaa*t103*t26*t269*t85*t91+t
     5           554*t91+3.72017044624d-5*t135*t199*t203*t72*t88-6.09932
     6           d-3*t128*t205*t88+1.061262590976d-4*t103*t13*t199*t200*
     7           t26*t87+t269*(-5.0d-1*t26*t83*t86-5.0d-1*rhoa*t145*t83*
     8           t86-5.0d-1*rhoa*t198*t26*t86)-1.25d-1*gammaaa*t26*t269*
     9           t83*t85+(1.0d+0*t26*t83+1.0d+0*rhoa*t145*t83+1.0d+0*rho
     :           a*t198*t26)*t84-3.04966d-3*t128*t199*t273*t72+1.0165533
     ;           333333335d-2*t128*t135*t2*t72+t125*t556)*wght+Mmat2(iq,
     <           D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = (-3.04966d-3*t128*t199*t279*t72+3.720
     1           17044624d-5*t114*t135*t199*t203*t72+t125*t558-6.09932d-
     2           3*t114*t128*t205)*wght+Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = (3.72017044624d-5*t135*t203*t238*t72*
     1           t88-6.09932d-3*t128*t243*t88-3.04966d-3*t128*t238*t273*
     2           t72+t125*t560)*wght+Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (1.0165533333333335d-2*t128*t135*t4*t
     1           72-3.04966d-3*t128*t238*t279*t72+3.72017044624d-5*t114*
     2           t135*t203*t238*t72+t125*t564+t117*t562+t275*(-5.0d-1*rh
     3           ob*t112*t237*t40-5.0d-1*t109*t112*t40-5.0d-1*rhob*t109*
     4           t112*t215)+t110*(1.0d+0*rhob*t237*t40+1.0d+0*t109*t40+1
     5           .0d+0*rhob*t109*t215)+t114*t120*(1.7169600000000002d-2*
     6           t113*t123*t40-1.030176d-2*t241)-1.28772d-3*gammabb*t110
     7           *t120*t123*t4*t40-5.15088d-3*rhob*t113*t120*t238*t278*t
     8           40+1.25d-1*gammabb*t110*t111*t117*t278*t40-6.4386d-4*ga
     9           mmabb*t120*t123*t238*t275*t40-1.25d-1*gammabb*t111*t117
     :           *t123*t275*t40-1.25d-1*gammabb*t109*t111*t275*t40+1.061
     ;           262590976d-4*t113*t123*t238*t239*t27*t40-6.09932d-3*t11
     <           4*t128*t243)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (-5.15088d-3*t26*t272*t87*t88*t96+1.
     1           28772d-3*t103*t26*t84*t88*t96-1.030176d-2*t13*t254*t26*
     2           t87*t96-6.4386d-4*gammaaa*t103*t2*t26*t269*t96+1.0d+0*r
     3           hoa*t26*t567*t87*t91-1.25d-1*t26*t272*t84*t91+t269*t492
     4           *t91-6.09932d-3*t128*t255*t72*t88+1.061262590976d-4*t10
     5           3*t200*t26*t568*t87+1.0d+0*rhoa*t252*t26*t84+1.0d+0*t12
     6           5*t569*t72-3.04966d-3*t128*t2*t273*t72+3.72017044624d-5
     7           *t135*t203*t271*t72+t269*t565)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = (1.0d+0*t125*t570*t72-3.04966d-3*t12
     1           8*t2*t279*t72-6.09932d-3*t114*t128*t255*t72+3.720170446
     2           24d-5*t114*t135*t2*t203*t72)*wght+Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = (3.72017044624d-5*t135*t203*t4*t72*t
     1           88-6.09932d-3*t128*t267*t72*t88+1.0d+0*t125*t571*t72-3.
     2           04966d-3*t128*t273*t4*t72)*wght+Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.0d+0*t125*t576*t72-3.04966d-3*t12
     1           8*t279*t4*t72+3.72017044624d-5*t135*t203*t277*t72-6.099
     2           32d-3*t114*t128*t267*t72+1.061262590976d-4*t113*t123*t2
     3           39*t40*t575+1.0d+0*rhob*t113*t117*t40*t574+t275*t572+t1
     4           17*t275*t520-6.4386d-4*gammabb*t120*t123*t275*t4*t40-5.
     5           15088d-3*t113*t114*t120*t278*t40-1.25d-1*t110*t117*t278
     6           *t40-1.030176d-2*t113*t120*t266*t27*t40+1.0d+0*rhob*t11
     7           0*t264*t40+1.28772d-3*t110*t114*t120*t123*t40)*wght+Mma
     8           t2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (-2.57544d-3*gammaaa*t103*t26*t269*t8
     1           8*t96-2.060352d-2*t13*t26*t272*t87*t96+1.0d+0*rhoa*t26*
     2           t580*t87*t91-2.5d-1*gammaaa*t103*t26*t577*t91+2.5d-1*ga
     3           mmaaa*t26*t269*t272*t91-1.219864d-2*t128*t273*t72*t88+2
     4           .122525181952d-4*t103*t200*t26*t285*t87+1.0d+0*rhoa*t26
     5           *t577*t83*t86-2.0d+0*rhoa*t26*t269*t83+1.0d+0*t125*t581
     6           *t72+7.44034089248d-5*t135*t203*t568*t72)*wght+Mmat2(iq
     7           ,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = (-6.09932d-3*t128*t279*t72*t88+7.4403
     1           4089248d-5*t114*t135*t203*t72*t88+1.0d+0*t125*t582*t72-
     2           6.09932d-3*t114*t128*t273*t72)*wght+Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*t125*t587*t72+7.44034089248d-
     1           5*t135*t203*t575*t72-1.219864d-2*t114*t128*t279*t72+1.0
     2           d+0*rhob*t113*t117*t40*t586-2.5d-1*gammabb*t117*t123*t4
     3           0*t583+1.0d+0*rhob*t109*t112*t40*t583+2.122525181952d-4
     4           *t113*t123*t239*t40*t424+2.5d-1*gammabb*t117*t275*t278*
     5           t40-2.060352d-2*t113*t120*t27*t278*t40-2.57544d-3*gamma
     6           bb*t114*t120*t123*t275*t40-2.0d+0*rhob*t109*t275*t40)*w
     7           ght+Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t91*(1.0d+0*rhoa*t26*t87*(-6.5185
     1           18518518519d+1*t377*t96*t98*t99*taua+2.060352d-1*t2*t20
     2           0*t393*t98*t99*taua-3.183787772928d-3*t2*t390*t392*t98*
     3           t99*taua-5.494272d-1*t187*t199*t200*t98*t99*taua-2.0148
     4           148148148146d+2*gammaaa*t375*t96*t97*taua+1.030176d-1*g
     5           ammaaa*t200*t393*t95*t97*taua-1.591893886464d-3*gammaaa
     6           *t390*t392*t95*t97*taua-8.241408d-1*gammaaa*t194*t199*t
     7           200*t97*taua+5.15088d-2*t102*t2*t393*t96*taua-1.373568d
     8           -1*t102*t187*t199*t96*taua-3.2592592592592595d+1*t102*t
     9           377*t91*taua-5.30631295488d-4*t102*t2*t200*t390*taua-1.
     :           777777777777778d+2*t194*t268*t96*t99-6.867840000000001d
     ;           -1*t199*t200*t268*t95*t99-1.030176d-2*t100*t200*t689*t9
     <           9-3.2798617527638757d-6*t100*t687*t688*t99+4.7756816593
     =           920004d-4*t100*t199*t392*t393*t99-4.5629629629629626d+1
     >           *gammaaa*t591*t96*t97*t98-1.030176d-2*gammaaa*t2*t200*t
     ?           689*t97*t98-3.2798617527638757d-6*gammaaa*t2*t687*t688*
     @           t97*t98+4.7756816593920004d-4*gammaaa*t199*t2*t392*t393
     1           *t97*t98+8.241408d-2*gammaaa*t187*t200*t393*t97*t98-1.2
     2           735151091712002d-3*gammaaa*t187*t390*t392*t97*t98-3.021
     3           8496d-1*gammaaa*t199*t200*t377*t97*t98-5.15088d-3*t102*
     4           t689*t96*t98-8.199654381909689d-7*t102*t392*t687*t98+1.
     5           591893886464d-4*t102*t199*t200*t393*t98-2.4770370370370
     6           37d+2*t590*t93*t94*t96-5.15088d-3*gammaaa*t101*t2*t689*
     7           t96+4.120704d-2*gammaaa*t101*t187*t393*t96-1.5109248d-1
     8           *gammaaa*t101*t199*t377*t96-1.030176d-2*t200*t689*t93*t
     9           94*t95-3.2798617527638757d-6*t687*t688*t93*t94*t95+4.77
     :           56816593920004d-4*t199*t392*t393*t93*t94*t95+1.6482816d
     ;           -1*t194*t200*t393*t93*t94-2.5470302183424004d-3*t194*t3
     <           90*t392*t93*t94-1.0439116799999999d+0*t199*t200*t375*t9
     =           3*t94-4.5629629629629626d+1*gammaaa*t101*t591*t91-8.199
     >           654381909689d-7*gammaaa*t101*t2*t392*t687+1.59189388646
     ?           4d-4*gammaaa*t101*t199*t2*t200*t393-4.245050363904d-4*g
     @           ammaaa*t101*t187*t200*t390)+1.0d+0*rhoa*t103*t596*t87+3
     1           .0d+0*t26*t394*t87+3.0d+0*rhoa*t145*t394*t87+3.0d+0*rho
     2           a*t201*t293*t87+3.0d+0*t103*t293*t87+6.0d+0*t145*t201*t
     3           87+2.5d-1*gammaaa*t26*t394*t84*t85+2.5d-1*gammaaa*t103*
     4           t293*t84*t85+5.0d-1*gammaaa*t145*t201*t84*t85-2.5d-1*ga
     5           mmaaa*t103*t26*t683*t84+2.5d-1*gammaaa*t201*t26*t382*t8
     6           4+2.5d-1*gammaaa*t103*t145*t382*t84)+t125*(1.0d+0*t72*(
     7           -5.58025566936d-4*t129*t2*t390*t397*t6*taua+6.09932d-2*
     8           t129*t2*t203*t393*t6*taua-3.2592592592592595d+1*t128*t1
     9           29*t377*t6*taua-1.6264853333333334d-1*t129*t187*t199*t2
     :           03*t6*taua-1.1160511338720001d-3*t130*t131*t2*t390*t397
     ;           *taua+1.2198640000000001d-1*t130*t131*t2*t203*t393*taua
     <           +3.04966d-2*t128*t134*t2*t393*taua-1.8600852231200002d-
     =           4*t134*t2*t203*t390*taua-3.2592592592592595d+1*t125*t13
     >           4*t377*taua-6.518518518518519d+1*t128*t130*t131*t377*ta
     ?           ua-1.6888888888888892d+2*gammaaa*t128*t129*t375*taua-3.
     @           252970666666667d-1*gammaaa*t129*t194*t199*t203*taua-3.2
     1           52970666666667d-1*t130*t131*t187*t199*t203*taua-8.13242
     2           6666666668d-2*t128*t134*t187*t199*taua-4.06621333333333
     3           4d-1*t131*t199*t203*t268*t95-1.5644444444444447d+2*t126
     4           *t128*t590*t94-2.602376533333333d-1*t126*t199*t203*t375
     5           *t94-6.807153001848167d-7*t129*t130*t6*t687*t690-6.8071
     6           53001848167d-7*t131*t132*t687*t690-6.807153001848167d-7
     7           *t126*t127*t687*t690-6.09932d-3*t129*t130*t203*t6*t689-
     8           3.04966d-3*t128*t133*t6*t689-6.09932d-3*t131*t132*t203*
     9           t689-6.09932d-3*t126*t127*t203*t689-3.04966d-3*t128*t13
     :           0*t134*t689-1.7017882504620419d-7*t133*t397*t6*t687-1.7
     ;           017882504620419d-7*t130*t134*t397*t687-9.12592592592592
     <           5d+1*gammaaa*t126*t128*t591*t6+1.6740767008080004d-4*t1
     =           29*t130*t199*t393*t397*t6-8.928409070976d-4*gammaaa*t12
     >           6*t187*t390*t397*t6+5.580255669359999d-5*t133*t199*t203
     ?           *t393*t6+9.758912d-2*gammaaa*t126*t187*t203*t393*t6-3.5
     @           78267733333333d-1*gammaaa*t126*t199*t203*t377*t6-4.5629
     1           629629629626d+1*gammaaa*t125*t133*t591-4.56296296296296
     2           26d+1*gammaaa*t128*t129*t130*t591+1.6740767008080004d-4
     3           *t131*t132*t199*t393*t397+1.6740767008080004d-4*t126*t1
     4           27*t199*t393*t397-4.464204535488d-4*gammaaa*t129*t130*t
     5           187*t390*t397+5.580255669359999d-5*t130*t134*t199*t203*
     6           t393+4.879456d-2*gammaaa*t129*t130*t187*t203*t393+2.439
     7           728d-2*gammaaa*t128*t133*t187*t393-1.4880681784959998d-
     8           4*gammaaa*t133*t187*t203*t390-1.7891338666666665d-1*gam
     9           maaa*t129*t130*t199*t203*t377-8.945669333333333d-2*gamm
     :           aaa*t128*t133*t199*t377-1.777777777777778d+2*t128*t131*
     ;           t194*t268)+1.0d+0*t135*t682+3.0d+0*t186*t398+3.0d+0*t20
     <           4*t374)+(-5.15088d-3*rhoa*t103*t26*t689*t87-5.15088d-3*
     =           rhoa*t199*t26*t394*t87-1.030176d-2*rhoa*t201*t26*t393*t
     >           87-1.030176d-2*t103*t26*t393*t87-1.030176d-2*rhoa*t103*
     ?           t145*t393*t87-5.15088d-3*rhoa*t103*t199*t293*t87-1.0301
     @           76d-2*t199*t201*t26*t87-1.030176d-2*rhoa*t145*t199*t201
     1           *t87-1.030176d-2*t103*t145*t199*t87-6.4386d-4*gammaaa*t
     2           103*t26*t393*t84*t85-6.4386d-4*gammaaa*t199*t201*t26*t8
     3           4*t85-6.4386d-4*gammaaa*t103*t145*t199*t84*t85-6.4386d-
     4           4*gammaaa*t103*t199*t26*t382*t84-1.030176d-2*t199*t395-
     5           5.15088d-3*t202*t393)*t96+(-1.28772d-3*gammaaa*t103*t26
     6           *t393-5.15088d-3*t199*t391-1.28772d-3*gammaaa*t199*t201
     7           *t26-1.28772d-3*gammaaa*t103*t145*t199)*t84*t85*t96+1.9
     8           3158d-3*gammaaa*t103*t199*t26*t382*t84*t96+t84*(5.0d-1*
     9           rhoa*t26*t86*(6.0d-2*gammaaa*t2*t75*(6.0d-2*gammaaa*t2*
     :           t75*(6.0d-2*gammaaa*t2*t75*(7.274666666666665d-1*t193*t
     ;           590*t79*t94-2.737777777777778d+0*gammaaa*t591*t75*t79+1
     <           .4745599999999992d-3*t684*t685*t686*t79-5.8367999999999
     =           98d-2*t383*t384*t588*t79)+7.274666666666665d-1*t193*t59
     >           0*t80*t94+2.879999999999999d-2*t193*t194*t386*t94-2.591
     ?           9999999999993d-1*t193*t195*t375*t94-2.737777777777778d+
     @           0*gammaaa*t591*t75*t80+1.4745599999999992d-3*t684*t685*
     1           t686*t80-5.836799999999998d-2*t383*t384*t588*t80-4.7999
     2           99999999999d-1*gammaaa*t187*t386*t75+1.76d+0*gammaaa*t1
     3           95*t377*t75+9.215999999999996d-3*t195*t383*t384*t385)+7
     4           .274666666666665d-1*t193*t590*t81*t94+2.879999999999999
     5           d-2*t193*t194*t387*t94-2.5919999999999993d-1*t193*t196*
     6           t375*t94-2.737777777777778d+0*gammaaa*t591*t75*t81+1.47
     7           45599999999992d-3*t684*t685*t686*t81-5.836799999999998d
     8           -2*t383*t384*t588*t81-4.799999999999999d-1*gammaaa*t187
     9           *t387*t75+1.76d+0*gammaaa*t196*t377*t75+9.2159999999999
     :           96d-3*t196*t383*t384*t385)+7.274666666666665d-1*t193*t5
     ;           90*t82*t94+2.879999999999999d-2*t193*t194*t388*t94-2.59
     <           19999999999993d-1*t193*t197*t375*t94-2.737777777777778d
     =           +0*gammaaa*t591*t75*t82+1.4745599999999992d-3*t684*t685
     >           *t686*t82-5.836799999999998d-2*t383*t384*t588*t82-4.799
     ?           999999999999d-1*gammaaa*t187*t388*t75+1.76d+0*gammaaa*t
     @           197*t377*t75+9.215999999999996d-3*t197*t383*t384*t385)+
     1           5.0d-1*rhoa*t596*t83*t86+1.5d+0*t293*t83*t86+1.5d+0*t26
     2           *t389*t86+1.5d+0*rhoa*t145*t389*t86+1.5d+0*rhoa*t198*t2
     3           93*t86+3.0d+0*t145*t198*t86+2.5d-1*gammaaa*t293*t83*t85
     4           +2.5d-1*gammaaa*t26*t389*t85+5.0d-1*gammaaa*t145*t198*t
     5           85-2.5d-1*gammaaa*t26*t683*t83+2.5d-1*gammaaa*t145*t382
     6           *t83+2.5d-1*gammaaa*t198*t26*t382)+1.0d+0*t72*(3.1d-3*t
     7           6*t8*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(-4.6606364444444426d-
     8           6*t1*t376*t590*t6*t94+1.5034311111111107d-3*t1*t188*t59
     9           0*t94-1.4145185185185183d-1*gammaaa*t1*t591*t8+4.385007
     :           4074074064d-4*gammaaa*t1*t188*t591*t6+1.050761671111110
     ;           5d-8*t1*t383*t588*t589*t6-3.389553777777776d-6*t1*t376*
     <           t383*t588)-4.6606364444444426d-6*t376*t590*t6*t9*t94+1.
     =           5034311111111107d-3*t188*t590*t9*t94+1.271082666666666d
     >           -6*t189*t375*t376*t6*t94-4.100266666666665d-4*t188*t189
     ?           *t375*t94-1.4145185185185183d-1*gammaaa*t591*t8*t9+4.38
     @           50074074074064d-4*gammaaa*t188*t591*t6*t9+1.05076167111
     1           11105d-8*t383*t588*t589*t6*t9-3.389553777777776d-6*t376
     2           *t383*t588*t9-2.4799999999999994d-2*gammaaa*t187*t378*t
     3           8+9.093333333333331d-2*gammaaa*t189*t377*t8+7.687999999
     4           999998d-5*gammaaa*t187*t188*t378*t6-2.818933333333332d-
     5           4*gammaaa*t188*t189*t377*t6)-4.6606364444444426d-6*t10*
     6           t376*t590*t6*t94+1.271082666666666d-6*t190*t375*t376*t6
     7           *t94+1.5034311111111107d-3*t10*t188*t590*t94-4.10026666
     8           6666665d-4*t188*t190*t375*t94-1.4145185185185183d-1*gam
     9           maaa*t10*t591*t8-2.4799999999999994d-2*gammaaa*t187*t37
     :           9*t8+9.093333333333331d-2*gammaaa*t190*t377*t8+4.385007
     ;           4074074064d-4*gammaaa*t10*t188*t591*t6+1.05076167111111
     <           05d-8*t10*t383*t588*t589*t6+7.687999999999998d-5*gammaa
     =           a*t187*t188*t379*t6-2.818933333333332d-4*gammaaa*t188*t
     >           190*t377*t6-3.389553777777776d-6*t10*t376*t383*t588)-4.
     ?           6606364444444426d-6*t11*t376*t590*t6*t94+1.271082666666
     @           666d-6*t191*t375*t376*t6*t94+1.5034311111111107d-3*t11*
     1           t188*t590*t94-4.100266666666665d-4*t188*t191*t375*t94-1
     2           .4145185185185183d-1*gammaaa*t11*t591*t8-2.479999999999
     3           9994d-2*gammaaa*t187*t380*t8+9.093333333333331d-2*gamma
     4           aa*t191*t377*t8+4.3850074074074064d-4*gammaaa*t11*t188*
     5           t591*t6+1.0507616711111105d-8*t11*t383*t588*t589*t6+7.6
     6           87999999999998d-5*gammaaa*t187*t188*t380*t6-2.818933333
     7           333332d-4*gammaaa*t188*t191*t377*t6-3.389553777777776d-
     8           6*t11*t376*t383*t588)+(1.25d-1*gammaaa*t26*t394+1.25d-1
     9           *gammaaa*t103*t293+2.5d-1*gammaaa*t145*t201)*t84*t85*t9
     :           1+2.5d-1*gammaaa*t103*t26*t683*t84*t91+(-2.5d-1*gammaaa
     ;           *t201*t26-2.5d-1*gammaaa*t103*t145)*t382*t84*t91+t200*(
     <           1.061262590976d-4*rhoa*t103*t199*t26*t393*t87+5.3063129
     =           5488d-5*rhoa*t201*t26*t390*t87+5.30631295488d-5*t103*t2
     >           6*t390*t87+5.30631295488d-5*rhoa*t103*t145*t390*t87-1.0
     ?           30176d-2*t199*t396)-8.199654381909689d-7*rhoa*t103*t26*
     @           t392*t687*t87+(1.25d-1*gammaaa*t293*t83+1.25d-1*gammaaa
     1           *t26*t389+2.5d-1*gammaaa*t145*t198)*t84*t85+1.989867358
     2           0800003d-5*gammaaa*t103*t200*t26*t390*t84*t85+t382*(-2.
     3           5d-1*gammaaa*t145*t83-2.5d-1*gammaaa*t198*t26)*t84+2.5d
     4           -1*gammaaa*t26*t683*t83*t84+t128*(-3.04966d-3*t135*t689
     5           *t72-3.04966d-3*t199*t398*t72-6.09932d-3*t204*t393*t72-
     6           6.09932d-3*t199*t399-3.04966d-3*t205*t393-6.09932d-3*t1
     7           35*t186*t393-3.04966d-3*t135*t199*t374-6.09932d-3*t186*
     8           t199*t204)+t203*(3.72017044624d-5*t135*t199*t393*t72+1.
     9           86008522312d-5*t204*t390*t72-6.09932d-3*t199*t400+1.860
     :           08522312d-5*t135*t186*t390)-1.7017882504620419d-7*t135*
     ;           t397*t687*t72+1.0d+0*t12*t682+3.0d+0*t186*t381+3.0d+0*t
     <           192*t374)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (t125*(1.0d+0*t72*(-2.710808888888
     1           889d-1*t131*t199*t2*t203*t4*taua*taub-5.925925925925927
     2           d+1*t128*t131*t187*t4*taua*taub-1.8600852231200002d-4*t
     3           129*t390*t397*t4*t6*taub+2.033106666666667d-2*t129*t203
     4           *t393*t4*t6*taub-3.7201704462400004d-4*t130*t131*t390*t
     5           397*t4*taub+4.066213333333334d-2*t130*t131*t203*t393*t4
     6           *taub+1.0165533333333335d-2*t128*t134*t393*t4*taub-6.20
     7           0284077066667d-5*t134*t203*t390*t4*taub-3.2592592592592
     8           595d+1*gammaaa*t128*t129*t377*t4*taub-1.084323555555555
     9           5d-1*gammaaa*t129*t187*t199*t203*t4*taub-3.720170446240
     :           0004d-4*t129*t199*t2*t238*t397*t6*taua-5.42161777777777
     ;           9d-2*t129*t187*t203*t238*t6*taua-7.440340892480001d-4*t
     <           130*t131*t199*t2*t238*t397*taua-1.2400568154133336d-4*t
     =           134*t199*t2*t203*t238*taua-1.0843235555555557d-1*gammaa
     >           a*t129*t194*t203*t238*taua-1.0843235555555557d-1*t130*t
     ?           131*t187*t203*t238*taua-2.710808888888889d-2*t128*t134*
     @           t187*t238*taua-1.0843235555555555d-1*gammabb*t129*t199*
     1           t2*t203*t227*taua-2.3703703703703702d+1*gammabb*t128*t1
     2           29*t187*t227*taua-1.3554044444444446d-1*t131*t203*t238*
     3           t268*t95-8.674588444444443d-2*t126*t203*t238*t375*t94-6
     4           .807153001848167d-7*t129*t130*t238*t390*t6*t690-6.80715
     5           3001848167d-7*t131*t132*t238*t390*t690-6.80715300184816
     6           7d-7*t126*t127*t238*t390*t690+5.580255669360001d-5*t129
     7           *t130*t238*t393*t397*t6-1.7017882504620419d-7*t133*t238
     8           *t390*t397*t6-2.976136356992001d-4*gammabb*t126*t227*t3
     9           90*t397*t6-5.952272713984d-4*gammaaa*t126*t187*t199*t23
     :           8*t397*t6+1.86008522312d-5*t133*t203*t238*t393*t6+3.252
     ;           9706666666663d-2*gammabb*t126*t203*t227*t393*t6-1.19275
     <           59111111112d-1*gammaaa*t126*t203*t238*t377*t6+5.5802556
     =           69360001d-5*t131*t132*t238*t393*t397+5.580255669360001d
     >           -5*t126*t127*t238*t393*t397-1.7017882504620419d-7*t130*
     ?           t134*t238*t390*t397-1.4880681784960004d-4*gammabb*t129*
     @           t130*t227*t390*t397-2.976136356992d-4*gammaaa*t129*t130
     1           *t187*t199*t238*t397+1.86008522312d-5*t130*t134*t203*t2
     2           38*t393+1.6264853333333332d-2*gammabb*t129*t130*t203*t2
     3           27*t393+8.132426666666667d-3*gammabb*t128*t133*t227*t39
     4           3-4.9602272616533327d-5*gammabb*t133*t203*t227*t390-5.9
     5           63779555555556d-2*gammaaa*t129*t130*t203*t238*t377-2.98
     6           1889777777778d-2*gammaaa*t128*t133*t238*t377-5.21481481
     7           4814814d+1*gammaaa*gammabb*t126*t128*t227*t377-9.920454
     8           523306665d-5*gammaaa*t133*t187*t199*t203*t238-1.7349176
     9           888888887d-1*gammaaa*gammabb*t126*t187*t199*t203*t227)+
     :           1.0d+0*t135*t718+2.0d+0*t186*t416+2.0d+0*t204*t411+1.0d
     ;           +0*t226*t398+1.0d+0*t242*t374)+1.0d+0*t72*(3.1d-3*t6*t8
     <           *(3.1d-3*t6*t8*(3.1d-3*t6*t8*(1.0507616711111105d-8*gam
     =           mabb*t1*t227*t375*t589*t6*t94-3.389553777777776d-6*gamm
     >           abb*t1*t227*t375*t376*t94-1.5535454814814809d-6*gammaaa
     ?           *gammabb*t1*t227*t376*t377*t6+5.011437037037035d-4*gamm
     @           aaa*gammabb*t1*t188*t227*t377)+1.0507616711111105d-8*ga
     1           mmabb*t227*t375*t589*t6*t9*t94-3.389553777777776d-6*gam
     2           mabb*t227*t375*t376*t9*t94+4.2369422222222203d-7*t228*t
     3           375*t376*t6*t94-1.366755555555555d-4*t188*t228*t375*t94
     4           -1.5535454814814809d-6*gammaaa*gammabb*t227*t376*t377*t
     5           6*t9+5.011437037037035d-4*gammaaa*gammabb*t188*t227*t37
     6           7*t9-1.653333333333333d-2*gammaaa*t187*t412*t8-8.266666
     7           666666665d-3*gammabb*t227*t378*t8+3.0311111111111105d-2
     8           *gammaaa*t228*t377*t8+5.125333333333332d-5*gammaaa*t187
     9           *t188*t412*t6+2.562666666666666d-5*gammabb*t188*t227*t3
     :           78*t6-9.396444444444442d-5*gammaaa*t188*t228*t377*t6+8.
     ;           473884444444441d-7*gammaaa*gammabb*t187*t189*t227*t376*
     <           t6-2.73351111111111d-4*gammaaa*gammabb*t187*t188*t189*t
     =           227)+1.0507616711111105d-8*gammabb*t10*t227*t375*t589*t
     >           6*t94+4.2369422222222203d-7*t229*t375*t376*t6*t94-3.389
     ?           553777777776d-6*gammabb*t10*t227*t375*t376*t94-1.366755
     @           555555555d-4*t188*t229*t375*t94-1.653333333333333d-2*ga
     1           mmaaa*t187*t413*t8-8.266666666666665d-3*gammabb*t227*t3
     2           79*t8+3.0311111111111105d-2*gammaaa*t229*t377*t8+5.1253
     3           33333333332d-5*gammaaa*t187*t188*t413*t6+2.562666666666
     4           666d-5*gammabb*t188*t227*t379*t6-1.5535454814814809d-6*
     5           gammaaa*gammabb*t10*t227*t376*t377*t6-9.396444444444442
     6           d-5*gammaaa*t188*t229*t377*t6+8.473884444444441d-7*gamm
     7           aaa*gammabb*t187*t190*t227*t376*t6+5.011437037037035d-4
     8           *gammaaa*gammabb*t10*t188*t227*t377-2.73351111111111d-4
     9           *gammaaa*gammabb*t187*t188*t190*t227)+1.050761671111110
     :           5d-8*gammabb*t11*t227*t375*t589*t6*t94+4.23694222222222
     ;           03d-7*t230*t375*t376*t6*t94-3.389553777777776d-6*gammab
     <           b*t11*t227*t375*t376*t94-1.366755555555555d-4*t188*t230
     =           *t375*t94-1.653333333333333d-2*gammaaa*t187*t414*t8-8.2
     >           66666666666665d-3*gammabb*t227*t380*t8+3.03111111111111
     ?           05d-2*gammaaa*t230*t377*t8+5.125333333333332d-5*gammaaa
     @           *t187*t188*t414*t6+2.562666666666666d-5*gammabb*t188*t2
     1           27*t380*t6-1.5535454814814809d-6*gammaaa*gammabb*t11*t2
     2           27*t376*t377*t6-9.396444444444442d-5*gammaaa*t188*t230*
     3           t377*t6+8.473884444444441d-7*gammaaa*gammabb*t187*t191*
     4           t227*t376*t6+5.011437037037035d-4*gammaaa*gammabb*t11*t
     5           188*t227*t377-2.73351111111111d-4*gammaaa*gammabb*t187*
     6           t188*t191*t227)+t128*(-3.04966d-3*t199*t416*t72-3.04966
     7           d-3*t242*t393*t72-3.04966d-3*t199*t417-3.04966d-3*t135*
     8           t199*t411-3.04966d-3*t238*t399-3.04966d-3*t135*t226*t39
     9           3-3.04966d-3*t186*t199*t242-3.04966d-3*t199*t204*t226)+
     :           t203*(1.86008522312d-5*t242*t390*t72-6.09932d-3*t238*t4
     ;           00+1.86008522312d-5*t135*t226*t390)-1.7017882504620419d
     <           -7*t135*t238*t390*t397*t72+1.0d+0*t12*t718+2.0d+0*t186*
     =           t415+2.0d+0*t192*t411+1.0d+0*t226*t381+1.0d+0*t231*t374
     >           )*wght+Amat3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = (t125*(1.0d+0*t72*(-2.710808888888
     1           889d-1*t131*t2*t203*t238*t4*taua*taub-5.925925925925927
     2           d+1*t128*t131*t2*t227*taua*taub-3.7201704462400004d-4*t
     3           129*t199*t238*t397*t4*t6*taub-5.421617777777777d-2*t129
     4           *t199*t203*t227*t6*taub-7.440340892480001d-4*t130*t131*
     5           t199*t238*t397*t4*taub-1.2400568154133336d-4*t134*t199*
     6           t203*t238*t4*taub-1.0843235555555555d-1*gammaaa*t129*t1
     7           87*t203*t238*t4*taub-1.0843235555555555d-1*gammabb*t129
     8           *t199*t203*t233*taub-1.0843235555555555d-1*t130*t131*t1
     9           99*t203*t227*taub-2.7108088888888887d-2*t128*t134*t199*
     :           t227*taub-2.3703703703703702d+1*gammaaa*t128*t129*t187*
     ;           t227*taub+2.033106666666667d-2*t129*t2*t203*t475*t6*tau
     <           a-1.8600852231200002d-4*t129*t2*t397*t472*t6*taua+4.066
     =           213333333334d-2*t130*t131*t2*t203*t475*taua+1.016553333
     >           3333335d-2*t128*t134*t2*t475*taua-3.7201704462400004d-4
     ?           *t130*t131*t2*t397*t472*taua-6.200284077066668d-5*t134*
     @           t2*t203*t472*taua-3.2592592592592595d+1*gammabb*t128*t1
     1           29*t2*t459*taua-1.0843235555555555d-1*gammabb*t129*t2*t
     2           203*t227*t238*taua-6.807153001848167d-7*t129*t130*t199*
     3           t472*t6*t690-6.807153001848167d-7*t131*t132*t199*t472*t
     4           690-6.807153001848167d-7*t126*t127*t199*t472*t690+5.580
     5           255669360001d-5*t129*t130*t199*t397*t475*t6+1.860085223
     6           12d-5*t133*t199*t203*t475*t6+3.2529706666666663d-2*gamm
     7           aaa*t126*t187*t203*t475*t6-1.7017882504620419d-7*t133*t
     8           199*t397*t472*t6-2.976136356992d-4*gammaaa*t126*t187*t3
     9           97*t472*t6-1.1927559111111109d-1*gammabb*t126*t199*t203
     :           *t459*t6-5.952272713984001d-4*gammabb*t126*t199*t227*t2
     ;           38*t397*t6+5.580255669360001d-5*t131*t132*t199*t397*t47
     <           5+5.580255669360001d-5*t126*t127*t199*t397*t475+1.86008
     =           522312d-5*t130*t134*t199*t203*t475+1.6264853333333332d-
     >           2*gammaaa*t129*t130*t187*t203*t475+8.132426666666667d-3
     ?           *gammaaa*t128*t133*t187*t475-1.7017882504620419d-7*t130
     @           *t134*t199*t397*t472-1.488068178496d-4*gammaaa*t129*t13
     1           0*t187*t397*t472-4.9602272616533327d-5*gammaaa*t133*t18
     2           7*t203*t472-5.963779555555555d-2*gammabb*t129*t130*t199
     3           *t203*t459-2.9818897777777775d-2*gammabb*t128*t133*t199
     4           *t459-5.214814814814814d+1*gammaaa*gammabb*t126*t128*t1
     5           87*t459-8.674588444444443d-2*t118*t126*t199*t203*t458-2
     6           .976136356992001d-4*gammabb*t129*t130*t199*t227*t238*t3
     7           97-1.3554044444444446d-1*t119*t131*t199*t203*t274-9.920
     8           454523306665d-5*gammabb*t133*t199*t203*t227*t238-1.7349
     9           176888888887d-1*gammaaa*gammabb*t126*t187*t203*t227*t23
     :           8)+1.0d+0*t135*t730+1.0d+0*t186*t479+1.0d+0*t204*t457+2
     ;           .0d+0*t226*t416+2.0d+0*t242*t411)+1.0d+0*t72*(3.1d-3*t6
     <           *t8*(3.1d-3*t6*t8*(1.0507616711111105d-8*gammaaa*t118*t
     =           187*t458*t589*t6*t9-1.5535454814814809d-6*gammaaa*gamma
     >           bb*t187*t376*t459*t6*t9+5.011437037037035d-4*gammaaa*ga
     ?           mmabb*t187*t188*t459*t9-3.389553777777776d-6*gammaaa*t1
     @           18*t187*t376*t458*t9+3.1d-3*t6*(1.0507616711111105d-8*g
     1           ammaaa*t1*t118*t187*t458*t589*t6-1.5535454814814809d-6*
     2           gammaaa*gammabb*t1*t187*t376*t459*t6+5.011437037037035d
     3           -4*gammaaa*gammabb*t1*t187*t188*t459-3.389553777777776d
     4           -6*gammaaa*t1*t118*t187*t376*t458)*t8-8.266666666666665
     5           d-3*gammaaa*t187*t460*t8+3.0311111111111105d-2*gammabb*
     6           t189*t459*t8-1.653333333333333d-2*gammabb*t227*t412*t8+
     7           2.562666666666666d-5*gammaaa*t187*t188*t460*t6-9.396444
     8           444444442d-5*gammabb*t188*t189*t459*t6+4.23694222222222
     9           03d-7*t118*t189*t376*t458*t6+5.125333333333332d-5*gamma
     :           bb*t188*t227*t412*t6+8.473884444444441d-7*gammaaa*gamma
     ;           bb*t187*t227*t228*t376*t6-1.366755555555555d-4*t118*t18
     <           8*t189*t458-2.73351111111111d-4*gammaaa*gammabb*t187*t1
     =           88*t227*t228)-8.266666666666665d-3*gammaaa*t187*t461*t8
     >           +3.0311111111111105d-2*gammabb*t190*t459*t8-1.653333333
     ?           333333d-2*gammabb*t227*t413*t8+1.0507616711111105d-8*ga
     @           mmaaa*t10*t118*t187*t458*t589*t6+2.562666666666666d-5*g
     1           ammaaa*t187*t188*t461*t6-1.5535454814814809d-6*gammaaa*
     2           gammabb*t10*t187*t376*t459*t6-9.396444444444442d-5*gamm
     3           abb*t188*t190*t459*t6+4.2369422222222203d-7*t118*t190*t
     4           376*t458*t6+5.125333333333332d-5*gammabb*t188*t227*t413
     5           *t6+8.473884444444441d-7*gammaaa*gammabb*t187*t227*t229
     6           *t376*t6+5.011437037037035d-4*gammaaa*gammabb*t10*t187*
     7           t188*t459-3.389553777777776d-6*gammaaa*t10*t118*t187*t3
     8           76*t458-1.366755555555555d-4*t118*t188*t190*t458-2.7335
     9           1111111111d-4*gammaaa*gammabb*t187*t188*t227*t229)-8.26
     :           6666666666665d-3*gammaaa*t187*t462*t8+3.031111111111110
     ;           5d-2*gammabb*t191*t459*t8-1.653333333333333d-2*gammabb*
     <           t227*t414*t8+1.0507616711111105d-8*gammaaa*t11*t118*t18
     =           7*t458*t589*t6+2.562666666666666d-5*gammaaa*t187*t188*t
     >           462*t6-1.5535454814814809d-6*gammaaa*gammabb*t11*t187*t
     ?           376*t459*t6-9.396444444444442d-5*gammabb*t188*t191*t459
     @           *t6+4.2369422222222203d-7*t118*t191*t376*t458*t6+5.1253
     1           33333333332d-5*gammabb*t188*t227*t414*t6+8.473884444444
     2           441d-7*gammaaa*gammabb*t187*t227*t230*t376*t6+5.0114370
     3           37037035d-4*gammaaa*gammabb*t11*t187*t188*t459-3.389553
     4           777777776d-6*gammaaa*t11*t118*t187*t376*t458-1.36675555
     5           5555555d-4*t118*t188*t191*t458-2.73351111111111d-4*gamm
     6           aaa*gammabb*t187*t188*t227*t230)+1.0d+0*t12*t730+t128*(
     7           -3.04966d-3*t199*t479*t72-3.04966d-3*t205*t475-3.04966d
     8           -3*t135*t199*t457-6.09932d-3*t238*t417-6.09932d-3*t199*
     9           t226*t242)+t203*(1.86008522312d-5*t135*t199*t475*t72+1.
     :           86008522312d-5*t199*t238*t242*t72-6.09932d-3*t238*t418+
     ;           1.86008522312d-5*t135*t199*t226*t238)-1.701788250462041
     <           9d-7*t135*t199*t397*t472*t72+1.0d+0*t186*t463+1.0d+0*t1
     =           92*t457+2.0d+0*t226*t415+2.0d+0*t231*t411)*wght+Amat3(i
     >           q,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (t117*(1.0d+0*rhob*t113*t40*(2.060
     1           352d-1*t121*t239*t4*t475*t99*taub-3.183787772928d-3*t12
     2           1*t4*t472*t474*t99*taub-6.518518518518519d+1*t120*t121*
     3           t459*t99*taub-5.494272d-1*t121*t227*t238*t239*t99*taub+
     4           1.030176d-1*gammabb*t119*t239*t475*t97*taub-1.591893886
     5           464d-3*gammabb*t119*t472*t474*t97*taub-2.01481481481481
     6           46d+2*gammabb*t120*t458*t97*taub-8.241408d-1*gammabb*t2
     7           33*t238*t239*t97*taub+5.15088d-2*t102*t120*t4*t475*taub
     8           -5.30631295488d-4*t102*t239*t4*t472*taub-3.259259259259
     9           2595d+1*t102*t117*t459*taub-1.373568d-1*t102*t120*t227*
     :           t238*taub-1.030176d-2*t122*t239*t754*t99-3.279861752763
     ;           8757d-6*t122*t752*t753*t99+4.7756816593920004d-4*t122*t
     <           238*t474*t475*t99-6.867840000000001d-1*t119*t238*t239*t
     =           274*t99-1.777777777777778d+2*t120*t233*t274*t99-1.03017
     >           6d-2*gammabb*t121*t239*t4*t754*t97-3.2798617527638757d-
     ?           6*gammabb*t121*t4*t752*t753*t97-4.5629629629629626d+1*g
     @           ammabb*t120*t121*t733*t97+4.7756816593920004d-4*gammabb
     1           *t121*t238*t4*t474*t475*t97+8.241408d-2*gammabb*t121*t2
     2           27*t239*t475*t97-1.2735151091712002d-3*gammabb*t121*t22
     3           7*t472*t474*t97-3.0218496d-1*gammabb*t121*t238*t239*t45
     4           9*t97-1.030176d-2*t118*t119*t239*t754*t93-3.27986175276
     5           38757d-6*t118*t119*t752*t753*t93-2.477037037037037d+2*t
     6           118*t120*t732*t93+4.7756816593920004d-4*t118*t119*t238*
     7           t474*t475*t93+1.6482816d-1*t118*t233*t239*t475*t93-2.54
     8           70302183424004d-3*t118*t233*t472*t474*t93-1.04391167999
     9           99999d+0*t118*t238*t239*t458*t93-5.15088d-3*gammabb*t10
     :           1*t120*t4*t754-5.15088d-3*t102*t120*t121*t754-8.1996543
     ;           81909689d-7*gammabb*t101*t4*t474*t752-8.199654381909689
     <           d-7*t102*t121*t474*t752-4.5629629629629626d+1*gammabb*t
     =           101*t117*t733+1.591893886464d-4*gammabb*t101*t238*t239*
     >           t4*t475+1.591893886464d-4*t102*t121*t238*t239*t475+4.12
     ?           0704d-2*gammabb*t101*t120*t227*t475-4.245050363904d-4*g
     @           ammabb*t101*t227*t239*t472-1.5109248d-1*gammabb*t101*t1
     1           20*t238*t459)-2.5d-1*gammabb*t110*t123*t40*t748+1.0d+0*
     2           rhob*t113*t123*t738+3.0d+0*t113*t40*t476+2.5d-1*gammabb
     3           *t110*t111*t40*t476+3.0d+0*rhob*t113*t215*t476+2.5d-1*g
     4           ammabb*t110*t240*t40*t464+2.5d-1*gammabb*t110*t123*t215
     5           *t464+3.0d+0*rhob*t113*t240*t432+3.0d+0*t113*t123*t432+
     6           2.5d-1*gammabb*t110*t111*t123*t432+6.0d+0*t113*t215*t24
     7           0+5.0d-1*gammabb*t110*t111*t215*t240)+t125*(1.0d+0*t72*
     8           (6.09932d-2*t129*t203*t4*t475*t6*taub-5.58025566936d-4*
     9           t129*t397*t4*t472*t6*taub-3.2592592592592595d+1*t128*t1
     :           29*t459*t6*taub-1.6264853333333334d-1*t129*t203*t227*t2
     ;           38*t6*taub+1.2198640000000001d-1*t130*t131*t203*t4*t475
     <           *taub+3.04966d-2*t128*t134*t4*t475*taub-1.1160511338720
     =           001d-3*t130*t131*t397*t4*t472*taub-1.8600852231200002d-
     >           4*t134*t203*t4*t472*taub-3.2592592592592595d+1*t125*t13
     ?           4*t459*taub-6.518518518518519d+1*t128*t130*t131*t459*ta
     @           ub-1.6888888888888892d+2*gammabb*t128*t129*t458*taub-3.
     1           252970666666667d-1*gammabb*t129*t203*t233*t238*taub-3.2
     2           52970666666667d-1*t130*t131*t203*t227*t238*taub-8.13242
     3           6666666668d-2*t128*t134*t227*t238*taub-6.09932d-3*t129*
     4           t130*t203*t6*t754-3.04966d-3*t128*t133*t6*t754-6.09932d
     5           -3*t131*t132*t203*t754-6.09932d-3*t126*t127*t203*t754-3
     6           .04966d-3*t128*t130*t134*t754-6.807153001848167d-7*t129
     7           *t130*t6*t690*t752-6.807153001848167d-7*t131*t132*t690*
     8           t752-6.807153001848167d-7*t126*t127*t690*t752-1.7017882
     9           504620419d-7*t133*t397*t6*t752-1.7017882504620419d-7*t1
     :           30*t134*t397*t752-9.125925925925925d+1*gammabb*t126*t12
     ;           8*t6*t733-4.5629629629629626d+1*gammabb*t125*t133*t733-
     <           4.5629629629629626d+1*gammabb*t128*t129*t130*t733-1.564
     =           4444444444447d+2*t118*t126*t128*t732+1.6740767008080004
     >           d-4*t129*t130*t238*t397*t475*t6+5.580255669359999d-5*t1
     ?           33*t203*t238*t475*t6+9.758912d-2*gammabb*t126*t203*t227
     @           *t475*t6-8.928409070976d-4*gammabb*t126*t227*t397*t472*
     1           t6-3.578267733333333d-1*gammabb*t126*t203*t238*t459*t6+
     2           1.6740767008080004d-4*t131*t132*t238*t397*t475+1.674076
     3           7008080004d-4*t126*t127*t238*t397*t475+5.58025566935999
     4           9d-5*t130*t134*t203*t238*t475+4.879456d-2*gammabb*t129*
     5           t130*t203*t227*t475+2.439728d-2*gammabb*t128*t133*t227*
     6           t475-4.464204535488d-4*gammabb*t129*t130*t227*t397*t472
     7           -1.4880681784959998d-4*gammabb*t133*t203*t227*t472-1.78
     8           91338666666665d-1*gammabb*t129*t130*t203*t238*t459-8.94
     9           5669333333333d-2*gammabb*t128*t133*t238*t459-2.60237653
     :           3333333d-1*t118*t126*t203*t238*t458-4.066213333333334d-
     ;           1*t119*t131*t203*t238*t274-1.777777777777778d+2*t128*t1
     <           31*t233*t274)+1.0d+0*t135*t747+3.0d+0*t226*t479+3.0d+0*
     =           t242*t457)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(-1.4
     >           145185185185183d-1*gammabb*t733*t8*t9+4.385007407407406
     ?           4d-4*gammabb*t188*t6*t733*t9-4.6606364444444426d-6*t118
     @           *t376*t6*t732*t9+1.5034311111111107d-3*t118*t188*t732*t
     1           9+1.0507616711111105d-8*t465*t589*t6*t731*t9-3.38955377
     2           7777776d-6*t376*t465*t731*t9+3.1d-3*t6*t8*(-1.414518518
     3           5185183d-1*gammabb*t1*t733*t8+4.3850074074074064d-4*gam
     4           mabb*t1*t188*t6*t733-4.6606364444444426d-6*t1*t118*t376
     5           *t6*t732+1.5034311111111107d-3*t1*t118*t188*t732+1.0507
     6           616711111105d-8*t1*t465*t589*t6*t731-3.389553777777776d
     7           -6*t1*t376*t465*t731)-2.4799999999999994d-2*gammabb*t22
     8           7*t460*t8+9.093333333333331d-2*gammabb*t228*t459*t8+7.6
     9           87999999999998d-5*gammabb*t188*t227*t460*t6-2.818933333
     :           333332d-4*gammabb*t188*t228*t459*t6+1.271082666666666d-
     ;           6*t118*t228*t376*t458*t6-4.100266666666665d-4*t118*t188
     <           *t228*t458)-1.4145185185185183d-1*gammabb*t10*t733*t8-2
     =           .4799999999999994d-2*gammabb*t227*t461*t8+9.09333333333
     >           3331d-2*gammabb*t229*t459*t8+4.3850074074074064d-4*gamm
     ?           abb*t10*t188*t6*t733-4.6606364444444426d-6*t10*t118*t37
     @           6*t6*t732+1.5034311111111107d-3*t10*t118*t188*t732+1.05
     1           07616711111105d-8*t10*t465*t589*t6*t731-3.3895537777777
     2           76d-6*t10*t376*t465*t731+7.687999999999998d-5*gammabb*t
     3           188*t227*t461*t6-2.818933333333332d-4*gammabb*t188*t229
     4           *t459*t6+1.271082666666666d-6*t118*t229*t376*t458*t6-4.
     5           100266666666665d-4*t118*t188*t229*t458)-1.4145185185185
     6           183d-1*gammabb*t11*t733*t8-2.4799999999999994d-2*gammab
     7           b*t227*t462*t8+9.093333333333331d-2*gammabb*t230*t459*t
     8           8+4.3850074074074064d-4*gammabb*t11*t188*t6*t733-4.6606
     9           364444444426d-6*t11*t118*t376*t6*t732+1.503431111111110
     :           7d-3*t11*t118*t188*t732+1.0507616711111105d-8*t11*t465*
     ;           t589*t6*t731-3.389553777777776d-6*t11*t376*t465*t731+7.
     <           687999999999998d-5*gammabb*t188*t227*t462*t6-2.81893333
     =           3333332d-4*gammabb*t188*t230*t459*t6+1.271082666666666d
     >           -6*t118*t230*t376*t458*t6-4.100266666666665d-4*t118*t18
     ?           8*t230*t458)+t110*(5.0d-1*rhob*t112*t40*(6.0d-2*gammabb
     @           *t105*t4*(6.0d-2*gammabb*t105*t4*(6.0d-2*gammabb*t105*t
     1           4*(1.4745599999999992d-3*t749*t750*t751*t79-2.737777777
     2           777778d+0*gammabb*t105*t733*t79+7.274666666666665d-1*t1
     3           18*t232*t732*t79-5.836799999999998d-2*t465*t466*t731*t7
     4           9)+1.4745599999999992d-3*t106*t749*t750*t751-2.73777777
     5           7777778d+0*gammabb*t105*t106*t733+7.274666666666665d-1*
     6           t106*t118*t232*t732-5.836799999999998d-2*t106*t465*t466
     7           *t731+2.879999999999999d-2*t118*t232*t233*t468-4.799999
     8           999999999d-1*gammabb*t105*t227*t468+9.215999999999996d-
     9           3*t234*t465*t466*t467+1.76d+0*gammabb*t105*t234*t459-2.
     :           5919999999999993d-1*t118*t232*t234*t458)+1.474559999999
     ;           9992d-3*t107*t749*t750*t751-2.737777777777778d+0*gammab
     <           b*t105*t107*t733+7.274666666666665d-1*t107*t118*t232*t7
     =           32-5.836799999999998d-2*t107*t465*t466*t731+2.879999999
     >           999999d-2*t118*t232*t233*t469-4.799999999999999d-1*gamm
     ?           abb*t105*t227*t469+9.215999999999996d-3*t235*t465*t466*
     @           t467+1.76d+0*gammabb*t105*t235*t459-2.5919999999999993d
     1           -1*t118*t232*t235*t458)+1.4745599999999992d-3*t108*t749
     2           *t750*t751-2.737777777777778d+0*gammabb*t105*t108*t733+
     3           7.274666666666665d-1*t108*t118*t232*t732-5.836799999999
     4           998d-2*t108*t465*t466*t731+2.879999999999999d-2*t118*t2
     5           32*t233*t470-4.799999999999999d-1*gammabb*t105*t227*t47
     6           0+9.215999999999996d-3*t236*t465*t466*t467+1.76d+0*gamm
     7           abb*t105*t236*t459-2.5919999999999993d-1*t118*t232*t236
     8           *t458)-2.5d-1*gammabb*t109*t40*t748+5.0d-1*rhob*t109*t1
     9           12*t738+1.5d+0*t112*t40*t471+2.5d-1*gammabb*t111*t40*t4
     :           71+1.5d+0*rhob*t112*t215*t471+2.5d-1*gammabb*t237*t40*t
     ;           464+2.5d-1*gammabb*t109*t215*t464+1.5d+0*rhob*t112*t237
     <           *t432+1.5d+0*t109*t112*t432+2.5d-1*gammabb*t109*t111*t4
     =           32+3.0d+0*t112*t215*t237+5.0d-1*gammabb*t111*t215*t237)
     >           +t128*(-3.04966d-3*t135*t72*t754-3.04966d-3*t238*t479*t
     ?           72-6.09932d-3*t242*t475*t72-6.09932d-3*t238*t480-3.0496
     @           6d-3*t243*t475-6.09932d-3*t135*t226*t475-3.04966d-3*t13
     1           5*t238*t457-6.09932d-3*t226*t238*t242)+t120*(-5.15088d-
     2           3*rhob*t113*t123*t40*t754-1.030176d-2*t238*t477-5.15088
     3           d-3*rhob*t113*t238*t40*t476-1.030176d-2*rhob*t113*t240*
     4           t40*t475-1.030176d-2*t113*t123*t40*t475-6.4386d-4*gamma
     5           bb*t110*t111*t123*t40*t475-5.15088d-3*t241*t475-1.03017
     6           6d-2*rhob*t113*t123*t215*t475-6.4386d-4*gammabb*t110*t1
     7           23*t238*t40*t464-5.15088d-3*rhob*t113*t123*t238*t432-1.
     8           030176d-2*t113*t238*t240*t40-6.4386d-4*gammabb*t110*t11
     9           1*t238*t240*t40-1.030176d-2*rhob*t113*t215*t238*t240-1.
     :           030176d-2*t113*t123*t215*t238-6.4386d-4*gammabb*t110*t1
     ;           11*t123*t215*t238)-1.7017882504620419d-7*t135*t397*t72*
     <           t752-8.199654381909689d-7*rhob*t113*t123*t40*t474*t752+
     =           2.5d-1*gammabb*t110*t117*t123*t40*t748+2.5d-1*gammabb*t
     >           109*t110*t40*t748+1.0d+0*t12*t747+t203*(3.72017044624d-
     ?           5*t135*t238*t475*t72+1.86008522312d-5*t242*t472*t72-6.0
     @           9932d-3*t238*t481+1.86008522312d-5*t135*t226*t472)+t239
     1           *(-1.030176d-2*t238*t478+1.061262590976d-4*rhob*t113*t1
     2           23*t238*t40*t475+5.30631295488d-5*rhob*t113*t240*t40*t4
     3           72+5.30631295488d-5*t113*t123*t40*t472+5.30631295488d-5
     4           *rhob*t113*t123*t215*t472)+t110*t111*t117*(1.25d-1*gamm
     5           abb*t40*t476+1.25d-1*gammabb*t123*t432+2.5d-1*gammabb*t
     6           215*t240)+t110*t111*t120*(-1.28772d-3*gammabb*t123*t40*
     7           t475-5.15088d-3*t238*t473-1.28772d-3*gammabb*t238*t240*
     8           t40-1.28772d-3*gammabb*t123*t215*t238)+1.98986735808000
     9           03d-5*gammabb*t110*t111*t123*t239*t40*t472+t110*t111*(1
     :           .25d-1*gammabb*t40*t471+1.25d-1*gammabb*t109*t432+2.5d-
     ;           1*gammabb*t215*t237)+t110*t117*(-2.5d-1*gammabb*t240*t4
     <           0-2.5d-1*gammabb*t123*t215)*t464+t110*(-2.5d-1*gammabb*
     =           t237*t40-2.5d-1*gammabb*t109*t215)*t464+1.93158d-3*gamm
     >           abb*t110*t120*t123*t238*t40*t464+3.0d+0*t226*t463+3.0d+
     ?           0*t231*t457)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t91*(1.0d+0*rhoa*t26*t87*(-2.122
     1           525181952d-3*t199*t392*t95*t98*t99*taua-5.494272d-1*t19
     2           4*t200*t98*t99*taua+2.6666666666666666d+1*t194*t96*t97*
     3           taua+6.867840000000001d-2*t199*t200*t95*t97*taua-4.5785
     4           6d-1*gammaaa*t200*t487*t97*taua-1.061262590976d-3*gamma
     5           aa*t199*t253*t392*t97*taua-1.373568d-1*t102*t194*t96*ta
     6           ua-3.53754196992d-4*t102*t199*t200*t95*taua-3.279861752
     7           7638757d-6*t100*t2*t390*t688*t99+1.591893886464d-4*t100
     8           *t2*t392*t393*t99-8.490100727808d-4*t100*t187*t199*t392
     9           *t99-1.0072832000000001d-1*t100*t200*t377*t99-2.2892800
     :           000000002d-1*t200*t253*t268*t99+9.777777777777779d+0*t3
     ;           77*t96*t97*t98-3.2798617527638757d-6*gammaaa*t390*t688*
     <           t95*t97*t98+1.591893886464d-4*gammaaa*t392*t393*t95*t97
     =           *t98-1.030176d-2*t2*t200*t393*t97*t98+1.591893886464d-4
     >           *t2*t390*t392*t97*t98-1.6980201455616d-3*gammaaa*t194*t
     ?           199*t392*t97*t98-3.4797056000000004d-1*gammaaa*t200*t37
     @           5*t97*t98+5.494272d-2*t187*t199*t200*t97*t98-5.036416d-
     1           2*t102*t377*t96*t98+5.30631295488d-5*t102*t2*t200*t393*
     2           t98-8.199654381909689d-7*t102*t2*t390*t392*t98-2.830033
     3           575936d-4*t102*t187*t199*t200*t98+6.755555555555556d+1*
     4           gammaaa*t375*t93*t96-5.15088d-3*t101*t2*t393*t96-1.7398
     5           528000000002d-1*gammaaa*t101*t375*t96+2.747136d-2*t101*
     6           t187*t199*t96-2.060352d-2*gammaaa*t200*t393*t93*t95+3.1
     7           83787772928d-4*gammaaa*t390*t392*t93*t95+5.30631295488d
     8           -5*gammaaa*t101*t200*t393*t95-8.199654381909689d-7*gamm
     9           aaa*t101*t390*t392*t95-3.2798617527638757d-6*t253*t390*
     :           t688*t93*t94-2.5470302183424004d-3*t199*t392*t487*t93*t
     ;           94+1.591893886464d-4*t253*t392*t393*t93*t94-7.4172672d-
     <           1*t200*t385*t93*t94+2.1977088d-1*gammaaa*t194*t199*t200
     =           *t93+9.777777777777779d+0*t101*t377*t91+5.30631295488d-
     >           5*t101*t2*t200*t390-5.660067151872d-4*gammaaa*t101*t194
     ?           *t199*t200)+2.0d+0*t26*t493*t87+2.0d+0*rhoa*t145*t493*t
     @           87+1.0d+0*rhoa*t254*t293*t87+2.0d+0*t145*t254*t87+1.25d
     1           -1*gammaaa*t26*t493*t84*t85-1.25d-1*t201*t26*t84*t85+1.
     2           25d-1*gammaaa*t145*t254*t84*t85-1.25d-1*t103*t145*t84*t
     3           85-1.25d-1*t26*t394*t84+1.25d-1*gammaaa*t254*t26*t382*t
     4           84+1.25d-1*t103*t26*t382*t84-1.25d-1*t103*t293*t84-2.5d
     5           -1*t145*t201*t84)+t125*(1.0d+0*t72*(-3.7201704462400004
     6           d-4*t129*t199*t397*t6*t95*taua-7.440340892480001d-4*t13
     7           0*t131*t199*t397*t95*taua-1.2400568154133336d-4*t134*t1
     8           99*t203*t95*taua+4.066213333333334d-2*t129*t199*t203*t9
     9           5*taua-1.6264853333333334d-1*t129*t194*t203*t6*taua-1.0
     :           843235555555557d-1*gammaaa*t129*t203*t487*taua-3.252970
     ;           666666667d-1*t130*t131*t194*t203*taua-8.132426666666668
     <           d-2*t128*t134*t194*taua+2.6666666666666666d+1*t128*t129
     =           *t194*taua-8.674588444444443d-2*t126*t203*t385*t94-6.80
     >           7153001848167d-7*t129*t130*t2*t390*t6*t690-6.8071530018
     ?           48167d-7*t131*t132*t2*t390*t690-6.807153001848167d-7*t1
     @           26*t127*t2*t390*t690+5.580255669360001d-5*t129*t130*t2*
     1           t393*t397*t6-1.7017882504620419d-7*t133*t2*t390*t397*t6
     2           +1.1160511338720001d-4*t126*t2*t390*t397*t6-5.952272713
     3           984d-4*gammaaa*t126*t194*t199*t397*t6-2.976136356992001
     4           d-4*t129*t130*t187*t199*t397*t6+1.86008522312d-5*t133*t
     5           2*t203*t393*t6-1.219864d-2*t126*t2*t203*t393*t6-5.96377
     6           9555555556d-2*t129*t130*t203*t377*t6-2.981889777777778d
     7           -2*t128*t133*t377*t6+1.9555555555555557d+1*t126*t128*t3
     8           77*t6-2.9276736d-1*gammaaa*t126*t203*t375*t6-9.92045452
     9           3306665d-5*t133*t187*t199*t203*t6+6.505941333333333d-2*
     :           t126*t187*t199*t203*t6+5.580255669360001d-5*t131*t132*t
     ;           2*t393*t397+5.580255669360001d-5*t126*t127*t2*t393*t397
     <           -1.7017882504620419d-7*t130*t134*t2*t390*t397+5.5802556
     =           69360001d-5*t129*t130*t2*t390*t397-2.976136356992d-4*ga
     >           mmaaa*t129*t130*t194*t199*t397-2.976136356992001d-4*t13
     ?           1*t132*t187*t199*t397-2.976136356992001d-4*t126*t127*t1
     @           87*t199*t397+1.86008522312d-5*t130*t134*t2*t203*t393-6.
     1           09932d-3*t129*t130*t2*t203*t393-3.04966d-3*t128*t133*t2
     2           *t393+1.86008522312d-5*t133*t2*t203*t390-5.963779555555
     3           556d-2*t131*t132*t203*t377-5.963779555555556d-2*t126*t1
     4           27*t203*t377-2.981889777777778d-2*t128*t130*t134*t377+9
     5           .777777777777779d+0*t125*t133*t377+9.777777777777779d+0
     6           *t128*t129*t130*t377-1.4638368d-1*gammaaa*t129*t130*t20
     7           3*t375-7.319184d-2*gammaaa*t128*t133*t375+48*gammaaa*t1
     8           26*t128*t375-1.3554044444444446d-1*t131*t203*t253*t268-
     9           9.920454523306665d-5*gammaaa*t133*t194*t199*t203+6.5059
     :           41333333333d-2*gammaaa*t126*t194*t199*t203-9.9204545233
     ;           06665d-5*t130*t134*t187*t199*t203+3.2529706666666663d-2
     <           *t129*t130*t187*t199*t203+1.6264853333333332d-2*t128*t1
     =           33*t187*t199)+2.0d+0*t186*t496+1.0d+0*t255*t374)+(-5.15
     >           088d-3*rhoa*t199*t26*t493*t87-5.15088d-3*rhoa*t254*t26*
     ?           t393*t87-5.15088d-3*t199*t254*t26*t87+1.373568d-2*t2*t2
     @           01*t26*t87-3.662848000000001d-2*t103*t187*t26*t87-5.150
     1           88d-3*rhoa*t145*t199*t254*t87+1.373568d-2*t103*t145*t2*
     2           t87+6.4386d-4*t103*t199*t26*t84*t85+6.4386d-4*t103*t26*
     3           t393*t84+6.4386d-4*t199*t201*t26*t84+6.4386d-4*t103*t14
     4           5*t199*t84-5.15088d-3*t199*t494+1.373568d-2*t187*t202)*
     5           t96+(-1.28772d-3*gammaaa*t199*t254*t26-1.28772d-3*t103*
     6           t199*t26)*t84*t85*t96-5.15088d-3*t187*t391*t84*t96+4.07
     7           778d-3*gammaaa*t103*t26*t377*t84*t96-5.15088d-3*t2*t395
     8           *t96+t84*(5.0d-1*rhoa*t26*t86*(6.0d-2*gammaaa*t2*t75*(6
     9           .0d-2*gammaaa*t2*t75*(-3.6d-3*gammaaa*t193*t386*t95+6.0
     :           d-2*gammaaa*t2*t75*(1.9583999999999993d-2*t384*t385*t79
     ;           *t94-5.529599999999998d-4*t383*t685*t758*t79+5.86666666
     <           6666666d-1*t377*t75*t79-2.0799999999999996d-1*gammaaa*t
     =           193*t375*t79)+1.9583999999999993d-2*t384*t385*t80*t94+1
     >           .9199999999999995d-2*t193*t194*t488*t94-2.3039999999999
     ?           99d-3*t195*t384*t487*t94-8.639999999999998d-2*t193*t249
     @           *t375*t94-5.529599999999998d-4*t383*t685*t758*t80+5.866
     1           666666666666d-1*t377*t75*t80-2.0799999999999996d-1*gamm
     2           aaa*t193*t375*t80-3.1999999999999995d-1*gammaaa*t187*t4
     3           88*t75+6.0d-2*t2*t386*t75+5.866666666666666d-1*gammaaa*
     4           t249*t377*t75-3.1999999999999995d-1*t187*t195*t75+3.071
     5           9999999999986d-3*t249*t383*t384*t385+5.759999999999998d
     6           -2*gammaaa*t193*t194*t195)-3.6d-3*gammaaa*t193*t387*t95
     7           +1.9583999999999993d-2*t384*t385*t81*t94+1.919999999999
     8           9995d-2*t193*t194*t489*t94-2.303999999999999d-3*t196*t3
     9           84*t487*t94-8.639999999999998d-2*t193*t250*t375*t94-5.5
     :           29599999999998d-4*t383*t685*t758*t81+5.866666666666666d
     ;           -1*t377*t75*t81-2.0799999999999996d-1*gammaaa*t193*t375
     <           *t81-3.1999999999999995d-1*gammaaa*t187*t489*t75+6.0d-2
     =           *t2*t387*t75+5.866666666666666d-1*gammaaa*t250*t377*t75
     >           -3.1999999999999995d-1*t187*t196*t75+3.0719999999999986
     ?           d-3*t250*t383*t384*t385+5.759999999999998d-2*gammaaa*t1
     @           93*t194*t196)-3.6d-3*gammaaa*t193*t388*t95+1.9583999999
     1           999993d-2*t384*t385*t82*t94+1.9199999999999995d-2*t193*
     2           t194*t490*t94-2.303999999999999d-3*t197*t384*t487*t94-8
     3           .639999999999998d-2*t193*t251*t375*t94-5.52959999999999
     4           8d-4*t383*t685*t758*t82+5.866666666666666d-1*t377*t75*t
     5           82-2.0799999999999996d-1*gammaaa*t193*t375*t82-3.199999
     6           9999999995d-1*gammaaa*t187*t490*t75+6.0d-2*t2*t388*t75+
     7           5.866666666666666d-1*gammaaa*t251*t377*t75-3.1999999999
     8           999995d-1*t187*t197*t75+3.0719999999999986d-3*t251*t383
     9           *t384*t385+5.759999999999998d-2*gammaaa*t193*t194*t197)
     :           +1.0d+0*t26*t491*t86+1.0d+0*rhoa*t145*t491*t86+5.0d-1*r
     ;           hoa*t252*t293*t86+1.0d+0*t145*t252*t86-1.25d-1*t145*t83
     <           *t85+1.25d-1*gammaaa*t26*t491*t85-1.25d-1*t198*t26*t85+
     =           1.25d-1*gammaaa*t145*t252*t85+1.25d-1*t26*t382*t83-1.25
     >           d-1*t293*t83-1.25d-1*t26*t389+1.25d-1*gammaaa*t252*t26*
     ?           t382-2.5d-1*t145*t198)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3
     @           *t6*t8*(3.1d-3*t6*t8*(-3.9403562666666647d-9*t1*t385*t5
     1           89*t6*t94+1.271082666666666d-6*t1*t376*t385*t94+3.03111
     2           11111111105d-2*t1*t377*t8-9.396444444444442d-5*t1*t188*
     3           t377*t6+1.4299679999999995d-6*gammaaa*t1*t375*t376*t6-4
     4           .612799999999999d-4*gammaaa*t1*t188*t375)-3.94035626666
     5           66647d-9*t385*t589*t6*t9*t94+1.271082666666666d-6*t376*
     6           t385*t9*t94+4.2369422222222203d-7*t244*t375*t376*t6*t94
     7           -1.366755555555555d-4*t188*t244*t375*t94+3.031111111111
     8           1105d-2*t377*t8*t9-9.396444444444442d-5*t188*t377*t6*t9
     9           +1.4299679999999995d-6*gammaaa*t375*t376*t6*t9-4.612799
     :           999999999d-4*gammaaa*t188*t375*t9-1.653333333333333d-2*
     ;           gammaaa*t187*t482*t8+3.1d-3*t2*t378*t8+3.03111111111111
     <           05d-2*gammaaa*t244*t377*t8-1.653333333333333d-2*t187*t1
     =           89*t8+5.125333333333332d-5*gammaaa*t187*t188*t482*t6-9.
     >           61d-6*t188*t2*t378*t6-9.396444444444442d-5*gammaaa*t188
     ?           *t244*t377*t6-3.1777066666666653d-7*gammaaa*t189*t194*t
     @           376*t6+5.125333333333332d-5*t187*t188*t189*t6+1.0250666
     1           666666663d-4*gammaaa*t188*t189*t194)-3.9403562666666647
     2           d-9*t10*t385*t589*t6*t94+4.2369422222222203d-7*t245*t37
     3           5*t376*t6*t94+1.271082666666666d-6*t10*t376*t385*t94-1.
     4           366755555555555d-4*t188*t245*t375*t94-1.653333333333333
     5           d-2*gammaaa*t187*t483*t8+3.1d-3*t2*t379*t8+3.0311111111
     6           111105d-2*gammaaa*t245*t377*t8+3.0311111111111105d-2*t1
     7           0*t377*t8-1.653333333333333d-2*t187*t190*t8+5.125333333
     8           333332d-5*gammaaa*t187*t188*t483*t6-9.61d-6*t188*t2*t37
     9           9*t6-9.396444444444442d-5*gammaaa*t188*t245*t377*t6-9.3
     :           96444444444442d-5*t10*t188*t377*t6+1.4299679999999995d-
     ;           6*gammaaa*t10*t375*t376*t6-3.1777066666666653d-7*gammaa
     <           a*t190*t194*t376*t6+5.125333333333332d-5*t187*t188*t190
     =           *t6-4.612799999999999d-4*gammaaa*t10*t188*t375+1.025066
     >           6666666663d-4*gammaaa*t188*t190*t194)-3.940356266666664
     ?           7d-9*t11*t385*t589*t6*t94+4.2369422222222203d-7*t246*t3
     @           75*t376*t6*t94+1.271082666666666d-6*t11*t376*t385*t94-1
     1           .366755555555555d-4*t188*t246*t375*t94-1.65333333333333
     2           3d-2*gammaaa*t187*t484*t8+3.1d-3*t2*t380*t8+3.031111111
     3           1111105d-2*gammaaa*t246*t377*t8+3.0311111111111105d-2*t
     4           11*t377*t8-1.653333333333333d-2*t187*t191*t8+5.12533333
     5           3333332d-5*gammaaa*t187*t188*t484*t6-9.61d-6*t188*t2*t3
     6           80*t6-9.396444444444442d-5*gammaaa*t188*t246*t377*t6-9.
     7           396444444444442d-5*t11*t188*t377*t6+1.4299679999999995d
     8           -6*gammaaa*t11*t375*t376*t6-3.1777066666666653d-7*gamma
     9           aa*t191*t194*t376*t6+5.125333333333332d-5*t187*t188*t19
     :           1*t6-4.612799999999999d-4*gammaaa*t11*t188*t375+1.02506
     ;           66666666663d-4*gammaaa*t188*t191*t194)+(1.25d-1*gammaaa
     <           *t26*t493+1.25d-1*t201*t26+1.25d-1*gammaaa*t145*t254+1.
     =           25d-1*t103*t145)*t84*t85*t91+t382*t759*t84*t91-8.199654
     >           381909689d-7*t103*t26*t390*t392*t87*t88+t2*t200*(-2.830
     ?           033575936d-4*t103*t199*t26*t87-1.030176d-2*t396)+5.3063
     @           1295488d-5*rhoa*t200*t254*t26*t390*t87+(t757+t756+1.25d
     1           -1*gammaaa*t26*t491+1.25d-1*gammaaa*t145*t252)*t84*t85+
     2           t382*t755*t84-6.6328911936d-6*t103*t200*t26*t390*t84+1.
     3           32657823872d-5*gammaaa*t103*t187*t199*t200*t26*t84+t128
     4           *(-3.04966d-3*t199*t496*t72-3.04966d-3*t255*t393*t72-2.
     5           981889777777778d-2*t135*t377*t72+8.132426666666667d-3*t
     6           187*t204*t72-3.04966d-3*t199*t497-3.04966d-3*t186*t199*
     7           t255+8.132426666666667d-3*t187*t205+8.132426666666667d-
     8           3*t135*t186*t187)-1.7017882504620419d-7*t135*t2*t390*t3
     9           97*t72+1.86008522312d-5*t203*t255*t390*t72-9.9204545233
     :           06665d-5*t135*t187*t199*t203*t72+2.0d+0*t186*t485-6.099
     ;           32d-3*t2*t203*t400-3.04966d-3*t128*t2*t399+1.0d+0*t247*
     <           t374)*wght+Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = (t125*(1.0d+0*t72*(-3.72017044624
     1           00004d-4*t129*t199*t2*t397*t4*t6*taua-5.421617777777779
     2           d-2*t129*t187*t203*t4*t6*taua-7.440340892480001d-4*t130
     3           *t131*t199*t2*t397*t4*taua-1.2400568154133336d-4*t134*t
     4           199*t2*t203*t4*taua+4.066213333333334d-2*t129*t199*t2*t
     5           203*t4*taua-1.0843235555555557d-1*gammaaa*t129*t194*t20
     6           3*t4*taua-1.0843235555555557d-1*t130*t131*t187*t203*t4*
     7           taua-2.710808888888889d-2*t128*t134*t187*t4*taua+8.8888
     8           8888888889d+0*t128*t129*t187*t4*taua-1.3554044444444446
     9           d-1*t131*t203*t268*t4*t95-8.674588444444443d-2*t126*t20
     :           3*t375*t4*t94-6.807153001848167d-7*t129*t130*t390*t4*t6
     ;           *t690-6.807153001848167d-7*t131*t132*t390*t4*t690-6.807
     <           153001848167d-7*t126*t127*t390*t4*t690+5.58025566936000
     =           1d-5*t129*t130*t393*t397*t4*t6-1.7017882504620419d-7*t1
     >           33*t390*t397*t4*t6+1.1160511338720001d-4*t126*t390*t397
     ?           *t4*t6-5.952272713984d-4*gammaaa*t126*t187*t199*t397*t4
     @           *t6+1.86008522312d-5*t133*t203*t393*t4*t6-1.219864d-2*t
     1           126*t203*t393*t4*t6-1.1927559111111112d-1*gammaaa*t126*
     2           t203*t377*t4*t6+5.580255669360001d-5*t131*t132*t393*t39
     3           7*t4+5.580255669360001d-5*t126*t127*t393*t397*t4-1.7017
     4           882504620419d-7*t130*t134*t390*t397*t4+5.58025566936000
     5           1d-5*t129*t130*t390*t397*t4-2.976136356992d-4*gammaaa*t
     6           129*t130*t187*t199*t397*t4+1.86008522312d-5*t130*t134*t
     7           203*t393*t4-6.09932d-3*t129*t130*t203*t393*t4-3.04966d-
     8           3*t128*t133*t393*t4+1.86008522312d-5*t133*t203*t390*t4-
     9           5.963779555555556d-2*gammaaa*t129*t130*t203*t377*t4-2.9
     :           81889777777778d-2*gammaaa*t128*t133*t377*t4+1.955555555
     ;           5555557d+1*gammaaa*t126*t128*t377*t4-9.920454523306665d
     <           -5*gammaaa*t133*t187*t199*t203*t4+6.505941333333333d-2*
     =           gammaaa*t126*t187*t199*t203*t4)+2.0d+0*t186*t502+1.0d+0
     >           *t267*t374)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(3.1
     ?           d-3*t6*t8*(-3.9403562666666647d-9*t1*t375*t4*t589*t6*t9
     @           4+1.271082666666666d-6*t1*t375*t376*t4*t94+5.8257955555
     1           55554d-7*gammaaa*t1*t376*t377*t4*t6-1.8792888888888884d
     2           -4*gammaaa*t1*t188*t377*t4)-3.9403562666666647d-9*t375*
     3           t4*t589*t6*t9*t94+1.271082666666666d-6*t375*t376*t4*t9*
     4           t94+4.2369422222222203d-7*t256*t375*t376*t6*t94-1.36675
     5           5555555555d-4*t188*t256*t375*t94+5.825795555555554d-7*g
     6           ammaaa*t376*t377*t4*t6*t9-1.8792888888888884d-4*gammaaa
     7           *t188*t377*t4*t9-1.653333333333333d-2*gammaaa*t187*t498
     8           *t8+3.1d-3*t378*t4*t8+3.0311111111111105d-2*gammaaa*t25
     9           6*t377*t8+5.125333333333332d-5*gammaaa*t187*t188*t498*t
     :           6-9.61d-6*t188*t378*t4*t6-3.1777066666666653d-7*gammaaa
     ;           *t187*t189*t376*t4*t6-9.396444444444442d-5*gammaaa*t188
     <           *t256*t377*t6+1.0250666666666663d-4*gammaaa*t187*t188*t
     =           189*t4)-3.9403562666666647d-9*t10*t375*t4*t589*t6*t94+4
     >           .2369422222222203d-7*t257*t375*t376*t6*t94+1.2710826666
     ?           66666d-6*t10*t375*t376*t4*t94-1.366755555555555d-4*t188
     @           *t257*t375*t94-1.653333333333333d-2*gammaaa*t187*t499*t
     1           8+3.1d-3*t379*t4*t8+3.0311111111111105d-2*gammaaa*t257*
     2           t377*t8+5.125333333333332d-5*gammaaa*t187*t188*t499*t6-
     3           9.61d-6*t188*t379*t4*t6+5.825795555555554d-7*gammaaa*t1
     4           0*t376*t377*t4*t6-3.1777066666666653d-7*gammaaa*t187*t1
     5           90*t376*t4*t6-9.396444444444442d-5*gammaaa*t188*t257*t3
     6           77*t6-1.8792888888888884d-4*gammaaa*t10*t188*t377*t4+1.
     7           0250666666666663d-4*gammaaa*t187*t188*t190*t4)-3.940356
     8           2666666647d-9*t11*t375*t4*t589*t6*t94+4.236942222222220
     9           3d-7*t258*t375*t376*t6*t94+1.271082666666666d-6*t11*t37
     :           5*t376*t4*t94-1.366755555555555d-4*t188*t258*t375*t94-1
     ;           .653333333333333d-2*gammaaa*t187*t500*t8+3.1d-3*t380*t4
     <           *t8+3.0311111111111105d-2*gammaaa*t258*t377*t8+5.125333
     =           333333332d-5*gammaaa*t187*t188*t500*t6-9.61d-6*t188*t38
     >           0*t4*t6+5.825795555555554d-7*gammaaa*t11*t376*t377*t4*t
     ?           6-3.1777066666666653d-7*gammaaa*t187*t191*t376*t4*t6-9.
     @           396444444444442d-5*gammaaa*t188*t258*t377*t6-1.87928888
     1           88888884d-4*gammaaa*t11*t188*t377*t4+1.0250666666666663
     2           d-4*gammaaa*t187*t188*t191*t4)+t128*(-3.04966d-3*t199*t
     3           502*t72-3.04966d-3*t267*t393*t72-3.04966d-3*t199*t503-3
     4           .04966d-3*t186*t199*t267)-1.7017882504620419d-7*t135*t3
     5           90*t397*t4*t72+1.86008522312d-5*t203*t267*t390*t72+2.0d
     6           +0*t186*t501-6.09932d-3*t203*t4*t400-3.04966d-3*t128*t3
     7           99*t4+1.0d+0*t259*t374)*wght+Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = (t125*(1.0d+0*t72*(-1.35540444444
     1           44446d-1*t131*t203*t4*t95*taua*taub-1.8600852231200002d
     2           -4*t129*t199*t2*t397*t4*t6*taub-5.421617777777777d-2*t1
     3           29*t187*t203*t4*t6*taub-3.7201704462400004d-4*t130*t131
     4           *t199*t2*t397*t4*taub-6.200284077066668d-5*t134*t199*t2
     5           *t203*t4*taub+2.033106666666667d-2*t129*t199*t2*t203*t4
     6           *taub-5.421617777777779d-2*gammaaa*t129*t194*t203*t4*ta
     7           ub-1.0843235555555555d-1*t130*t131*t187*t203*t4*taub-2.
     8           7108088888888887d-2*t128*t134*t187*t4*taub+8.8888888888
     9           8889d+0*t128*t129*t187*t4*taub-1.8600852231200002d-4*t1
     :           29*t238*t397*t6*t95*taua-3.7201704462400004d-4*t130*t13
     ;           1*t238*t397*t95*taua-6.200284077066668d-5*t134*t203*t23
     <           8*t95*taua+2.033106666666667d-2*t129*t203*t238*t95*taua
     =           -5.421617777777779d-2*gammabb*t129*t203*t227*t95*taua-6
     >           .807153001848167d-7*t129*t130*t199*t2*t238*t6*t690-6.80
     ?           7153001848167d-7*t131*t132*t199*t2*t238*t690-6.80715300
     @           1848167d-7*t126*t127*t199*t2*t238*t690-1.70178825046204
     1           19d-7*t133*t199*t2*t238*t397*t6+1.1160511338720001d-4*t
     2           126*t199*t2*t238*t397*t6-2.976136356992d-4*gammaaa*t126
     3           *t194*t238*t397*t6-1.4880681784960004d-4*t129*t130*t187
     4           *t238*t397*t6-2.976136356992d-4*gammabb*t126*t199*t2*t2
     5           27*t397*t6-4.9602272616533327d-5*t133*t187*t203*t238*t6
     6           +3.2529706666666663d-2*t126*t187*t203*t238*t6-8.6745884
     7           44444443d-2*gammabb*t126*t187*t203*t227*t6-1.7017882504
     8           620419d-7*t130*t134*t199*t2*t238*t397+5.580255669360001
     9           d-5*t129*t130*t199*t2*t238*t397-1.488068178496d-4*gamma
     :           aa*t129*t130*t194*t238*t397-1.4880681784960004d-4*t131*
     ;           t132*t187*t238*t397-1.4880681784960004d-4*t126*t127*t18
     <           7*t238*t397-1.488068178496d-4*gammabb*t129*t130*t199*t2
     =           *t227*t397+1.86008522312d-5*t133*t199*t2*t203*t238-4.96
     >           02272616533327d-5*gammaaa*t133*t194*t203*t238+3.2529706
     ?           666666663d-2*gammaaa*t126*t194*t203*t238-4.960227261653
     @           3327d-5*t130*t134*t187*t203*t238+1.6264853333333332d-2*
     1           t129*t130*t187*t203*t238+8.132426666666667d-3*t128*t133
     2           *t187*t238-4.9602272616533327d-5*gammabb*t133*t199*t2*t
     3           203*t227+3.2529706666666663d-2*gammabb*t126*t199*t2*t20
     4           3*t227-8.674588444444443d-2*gammaaa*gammabb*t126*t194*t
     5           203*t227-4.3372942222222216d-2*gammabb*t129*t130*t187*t
     6           203*t227-2.1686471111111108d-2*gammabb*t128*t133*t187*t
     7           227+1.4222222222222222d+1*gammabb*t126*t128*t187*t227)+
     8           1.0d+0*t186*t508+1.0d+0*t226*t496+1.0d+0*t255*t411)+1.0
     9           d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(-3.940356266666664
     :           7d-9*gammaaa*gammabb*t194*t227*t589*t6*t9+4.23694222222
     ;           22203d-7*gammabb*t187*t227*t376*t6*t9+1.271082666666666
     <           d-6*gammaaa*gammabb*t194*t227*t376*t9-1.366755555555555
     =           d-4*gammabb*t187*t188*t227*t9+3.1d-3*t6*(-3.94035626666
     >           66647d-9*gammaaa*gammabb*t1*t194*t227*t589*t6+4.2369422
     ?           222222203d-7*gammabb*t1*t187*t227*t376*t6+1.27108266666
     @           6666d-6*gammaaa*gammabb*t1*t194*t227*t376-1.36675555555
     1           5555d-4*gammabb*t1*t187*t188*t227)*t8-8.266666666666665
     2           d-3*gammaaa*t187*t504*t8-8.266666666666665d-3*gammabb*t
     3           227*t482*t8+3.1d-3*t2*t412*t8-8.266666666666665d-3*t187
     4           *t228*t8+2.562666666666666d-5*gammaaa*t187*t188*t504*t6
     5           +2.562666666666666d-5*gammabb*t188*t227*t482*t6-9.61d-6
     6           *t188*t2*t412*t6+4.2369422222222203d-7*gammaaa*gammabb*
     7           t187*t227*t244*t376*t6-1.5888533333333327d-7*gammaaa*t1
     8           94*t228*t376*t6-1.5888533333333327d-7*gammabb*t189*t2*t
     9           227*t376*t6+2.562666666666666d-5*t187*t188*t228*t6-1.36
     :           6755555555555d-4*gammaaa*gammabb*t187*t188*t227*t244+5.
     ;           125333333333332d-5*gammaaa*t188*t194*t228+5.12533333333
     <           3332d-5*gammabb*t188*t189*t2*t227)-8.266666666666665d-3
     =           *gammaaa*t187*t505*t8-8.266666666666665d-3*gammabb*t227
     >           *t483*t8+3.1d-3*t2*t413*t8-8.266666666666665d-3*t187*t2
     ?           29*t8-3.9403562666666647d-9*gammaaa*gammabb*t10*t194*t2
     @           27*t589*t6+2.562666666666666d-5*gammaaa*t187*t188*t505*
     1           t6+2.562666666666666d-5*gammabb*t188*t227*t483*t6-9.61d
     2           -6*t188*t2*t413*t6+4.2369422222222203d-7*gammaaa*gammab
     3           b*t187*t227*t245*t376*t6-1.5888533333333327d-7*gammaaa*
     4           t194*t229*t376*t6-1.5888533333333327d-7*gammabb*t190*t2
     5           *t227*t376*t6+4.2369422222222203d-7*gammabb*t10*t187*t2
     6           27*t376*t6+2.562666666666666d-5*t187*t188*t229*t6+1.271
     7           082666666666d-6*gammaaa*gammabb*t10*t194*t227*t376-1.36
     8           6755555555555d-4*gammaaa*gammabb*t187*t188*t227*t245+5.
     9           125333333333332d-5*gammaaa*t188*t194*t229+5.12533333333
     :           3332d-5*gammabb*t188*t190*t2*t227-1.366755555555555d-4*
     ;           gammabb*t10*t187*t188*t227)-8.266666666666665d-3*gammaa
     <           a*t187*t506*t8-8.266666666666665d-3*gammabb*t227*t484*t
     =           8+3.1d-3*t2*t414*t8-8.266666666666665d-3*t187*t230*t8-3
     >           .9403562666666647d-9*gammaaa*gammabb*t11*t194*t227*t589
     ?           *t6+2.562666666666666d-5*gammaaa*t187*t188*t506*t6+2.56
     @           2666666666666d-5*gammabb*t188*t227*t484*t6-9.61d-6*t188
     1           *t2*t414*t6+4.2369422222222203d-7*gammaaa*gammabb*t187*
     2           t227*t246*t376*t6-1.5888533333333327d-7*gammaaa*t194*t2
     3           30*t376*t6-1.5888533333333327d-7*gammabb*t191*t2*t227*t
     4           376*t6+4.2369422222222203d-7*gammabb*t11*t187*t227*t376
     5           *t6+2.562666666666666d-5*t187*t188*t230*t6+1.2710826666
     6           66666d-6*gammaaa*gammabb*t11*t194*t227*t376-1.366755555
     7           555555d-4*gammaaa*gammabb*t187*t188*t227*t246+5.1253333
     8           33333332d-5*gammaaa*t188*t194*t230+5.125333333333332d-5
     9           *gammabb*t188*t191*t2*t227-1.366755555555555d-4*gammabb
     :           *t11*t187*t188*t227)+t128*(-3.04966d-3*t199*t508*t72+8.
     ;           132426666666667d-3*t187*t242*t72-3.04966d-3*t238*t497-3
     <           .04966d-3*t199*t226*t255+8.132426666666667d-3*t135*t187
     =           *t226)-1.7017882504620419d-7*t135*t199*t2*t238*t397*t72
     >           +1.86008522312d-5*t199*t203*t238*t255*t72-4.96022726165
     ?           33327d-5*t135*t187*t203*t238*t72+1.0d+0*t186*t507+1.0d+
     @           0*t226*t485-6.09932d-3*t2*t203*t418-3.04966d-3*t128*t2*
     1           t417+1.0d+0*t247*t411)*wght+Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = (t125*(1.0d+0*t72*(-1.35540444444
     1           44446d-1*t119*t131*t2*t203*taua*taub-1.8600852231200002
     2           d-4*t119*t129*t199*t397*t6*taub-3.7201704462400004d-4*t
     3           119*t130*t131*t199*t397*taub-6.200284077066668d-5*t119*
     4           t134*t199*t203*taub+2.033106666666667d-2*t119*t129*t199
     5           *t203*taub-5.421617777777779d-2*gammaaa*t119*t129*t187*
     6           t203*taub-1.8600852231200002d-4*t129*t2*t238*t397*t4*t6
     7           *taua-5.421617777777777d-2*t129*t2*t203*t227*t6*taua-3.
     8           7201704462400004d-4*t130*t131*t2*t238*t397*t4*taua-6.20
     9           0284077066668d-5*t134*t2*t203*t238*t4*taua+2.0331066666
     :           66667d-2*t129*t2*t203*t238*t4*taua-5.421617777777779d-2
     ;           *gammabb*t129*t2*t203*t233*taua-1.0843235555555555d-1*t
     <           130*t131*t2*t203*t227*taua-2.7108088888888887d-2*t128*t
     =           134*t2*t227*taua+8.88888888888889d+0*t128*t129*t2*t227*
     >           taua-6.807153001848167d-7*t129*t130*t199*t238*t4*t6*t69
     ?           0-6.807153001848167d-7*t131*t132*t199*t238*t4*t690-6.80
     @           7153001848167d-7*t126*t127*t199*t238*t4*t690-1.70178825
     1           04620419d-7*t133*t199*t238*t397*t4*t6+1.116051133872000
     2           1d-4*t126*t199*t238*t397*t4*t6-2.976136356992d-4*gammaa
     3           a*t126*t187*t238*t397*t4*t6-2.976136356992d-4*gammabb*t
     4           126*t199*t233*t397*t6-1.4880681784960004d-4*t129*t130*t
     5           199*t227*t397*t6-4.9602272616533327d-5*t133*t199*t203*t
     6           227*t6+3.2529706666666663d-2*t126*t199*t203*t227*t6-8.6
     7           74588444444443d-2*gammaaa*t126*t187*t203*t227*t6-1.7017
     8           882504620419d-7*t130*t134*t199*t238*t397*t4+5.580255669
     9           360001d-5*t129*t130*t199*t238*t397*t4-1.488068178496d-4
     :           *gammaaa*t129*t130*t187*t238*t397*t4+1.86008522312d-5*t
     ;           133*t199*t203*t238*t4-4.9602272616533327d-5*gammaaa*t13
     <           3*t187*t203*t238*t4+3.2529706666666663d-2*gammaaa*t126*
     =           t187*t203*t238*t4-1.488068178496d-4*gammabb*t129*t130*t
     >           199*t233*t397-1.4880681784960004d-4*t131*t132*t199*t227
     ?           *t397-1.4880681784960004d-4*t126*t127*t199*t227*t397-4.
     @           9602272616533327d-5*gammabb*t133*t199*t203*t233+3.25297
     1           06666666663d-2*gammabb*t126*t199*t203*t233-8.6745884444
     2           44443d-2*gammaaa*gammabb*t126*t187*t203*t233-4.96022726
     3           16533327d-5*t130*t134*t199*t203*t227+1.6264853333333332
     4           d-2*t129*t130*t199*t203*t227-4.3372942222222216d-2*gamm
     5           aaa*t129*t130*t187*t203*t227+8.132426666666667d-3*t128*
     6           t133*t199*t227-2.1686471111111108d-2*gammaaa*t128*t133*
     7           t187*t227+1.4222222222222222d+1*gammaaa*t126*t128*t187*
     8           t227)+1.0d+0*t186*t524+1.0d+0*t226*t502+1.0d+0*t267*t41
     9           1)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(-3.940356266
     :           6666647d-9*gammaaa*gammabb*t187*t233*t589*t6*t9+4.23694
     ;           22222222203d-7*gammaaa*t187*t227*t376*t6*t9+1.271082666
     <           666666d-6*gammaaa*gammabb*t187*t233*t376*t9-1.366755555
     =           555555d-4*gammaaa*t187*t188*t227*t9+3.1d-3*t6*(-3.94035
     >           62666666647d-9*gammaaa*gammabb*t1*t187*t233*t589*t6+4.2
     ?           369422222222203d-7*gammaaa*t1*t187*t227*t376*t6+1.27108
     @           2666666666d-6*gammaaa*gammabb*t1*t187*t233*t376-1.36675
     1           5555555555d-4*gammaaa*t1*t187*t188*t227)*t8-8.266666666
     2           666665d-3*gammaaa*t187*t510*t8-8.266666666666665d-3*gam
     3           mabb*t227*t498*t8+3.1d-3*t4*t412*t8-8.266666666666665d-
     4           3*t189*t227*t8+2.562666666666666d-5*gammaaa*t187*t188*t
     5           510*t6+2.562666666666666d-5*gammabb*t188*t227*t498*t6-9
     6           .61d-6*t188*t4*t412*t6-1.5888533333333327d-7*gammaaa*t1
     7           87*t228*t376*t4*t6+4.2369422222222203d-7*gammaaa*gammab
     8           b*t187*t227*t256*t376*t6-1.5888533333333327d-7*gammabb*
     9           t189*t233*t376*t6+2.562666666666666d-5*t188*t189*t227*t
     :           6+5.125333333333332d-5*gammaaa*t187*t188*t228*t4-1.3667
     ;           55555555555d-4*gammaaa*gammabb*t187*t188*t227*t256+5.12
     <           5333333333332d-5*gammabb*t188*t189*t233)-8.266666666666
     =           665d-3*gammaaa*t187*t511*t8-8.266666666666665d-3*gammab
     >           b*t227*t499*t8+3.1d-3*t4*t413*t8-8.266666666666665d-3*t
     ?           190*t227*t8-3.9403562666666647d-9*gammaaa*gammabb*t10*t
     @           187*t233*t589*t6+2.562666666666666d-5*gammaaa*t187*t188
     1           *t511*t6+2.562666666666666d-5*gammabb*t188*t227*t499*t6
     2           -9.61d-6*t188*t4*t413*t6-1.5888533333333327d-7*gammaaa*
     3           t187*t229*t376*t4*t6+4.2369422222222203d-7*gammaaa*gamm
     4           abb*t187*t227*t257*t376*t6-1.5888533333333327d-7*gammab
     5           b*t190*t233*t376*t6+4.2369422222222203d-7*gammaaa*t10*t
     6           187*t227*t376*t6+2.562666666666666d-5*t188*t190*t227*t6
     7           +5.125333333333332d-5*gammaaa*t187*t188*t229*t4+1.27108
     8           2666666666d-6*gammaaa*gammabb*t10*t187*t233*t376-1.3667
     9           55555555555d-4*gammaaa*gammabb*t187*t188*t227*t257+5.12
     :           5333333333332d-5*gammabb*t188*t190*t233-1.3667555555555
     ;           55d-4*gammaaa*t10*t187*t188*t227)-8.266666666666665d-3*
     <           gammaaa*t187*t512*t8-8.266666666666665d-3*gammabb*t227*
     =           t500*t8+3.1d-3*t4*t414*t8-8.266666666666665d-3*t191*t22
     >           7*t8-3.9403562666666647d-9*gammaaa*gammabb*t11*t187*t23
     ?           3*t589*t6+2.562666666666666d-5*gammaaa*t187*t188*t512*t
     @           6+2.562666666666666d-5*gammabb*t188*t227*t500*t6-9.61d-
     1           6*t188*t4*t414*t6-1.5888533333333327d-7*gammaaa*t187*t2
     2           30*t376*t4*t6+4.2369422222222203d-7*gammaaa*gammabb*t18
     3           7*t227*t258*t376*t6-1.5888533333333327d-7*gammabb*t191*
     4           t233*t376*t6+4.2369422222222203d-7*gammaaa*t11*t187*t22
     5           7*t376*t6+2.562666666666666d-5*t188*t191*t227*t6+5.1253
     6           33333333332d-5*gammaaa*t187*t188*t230*t4+1.271082666666
     7           666d-6*gammaaa*gammabb*t11*t187*t233*t376-1.36675555555
     8           5555d-4*gammaaa*gammabb*t187*t188*t227*t258+5.125333333
     9           333332d-5*gammabb*t188*t191*t233-1.366755555555555d-4*g
     :           ammaaa*t11*t187*t188*t227)+t128*(-3.04966d-3*t199*t524*
     ;           t72-3.04966d-3*t238*t503-3.04966d-3*t199*t226*t267+8.13
     <           2426666666667d-3*t205*t227)-1.7017882504620419d-7*t135*
     =           t199*t238*t397*t4*t72+1.86008522312d-5*t199*t203*t238*t
     >           267*t72-4.9602272616533327d-5*t135*t199*t203*t227*t72+1
     ?           .0d+0*t186*t513+1.0d+0*t226*t501-6.09932d-3*t203*t4*t41
     @           8-3.04966d-3*t128*t4*t417+1.0d+0*t259*t411)*wght+Cmat3(
     1           iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = (t125*(1.0d+0*t72*(-3.72017044624
     1           00004d-4*t129*t2*t238*t397*t4*t6*taub-5.421617777777779
     2           d-2*t129*t2*t203*t227*t6*taub-7.440340892480001d-4*t130
     3           *t131*t2*t238*t397*t4*taub-1.2400568154133336d-4*t134*t
     4           2*t203*t238*t4*taub+4.066213333333334d-2*t129*t2*t203*t
     5           238*t4*taub-1.0843235555555557d-1*gammabb*t129*t2*t203*
     6           t233*taub-1.0843235555555557d-1*t130*t131*t2*t203*t227*
     7           taub-2.710808888888889d-2*t128*t134*t2*t227*taub+8.8888
     8           8888888889d+0*t128*t129*t2*t227*taub-6.807153001848167d
     9           -7*t129*t130*t2*t472*t6*t690-6.807153001848167d-7*t131*
     :           t132*t2*t472*t690-6.807153001848167d-7*t126*t127*t2*t47
     ;           2*t690+5.580255669360001d-5*t129*t130*t2*t397*t475*t6+1
     <           .86008522312d-5*t133*t2*t203*t475*t6-1.219864d-2*t126*t
     =           2*t203*t475*t6-1.7017882504620419d-7*t133*t2*t397*t472*
     >           t6+1.1160511338720001d-4*t126*t2*t397*t472*t6-1.1927559
     ?           111111112d-1*gammabb*t126*t2*t203*t459*t6-5.95227271398
     @           4d-4*gammabb*t126*t2*t227*t238*t397*t6+5.58025566936000
     1           1d-5*t131*t132*t2*t397*t475+5.580255669360001d-5*t126*t
     2           127*t2*t397*t475+1.86008522312d-5*t130*t134*t2*t203*t47
     3           5-6.09932d-3*t129*t130*t2*t203*t475-3.04966d-3*t128*t13
     4           3*t2*t475-1.7017882504620419d-7*t130*t134*t2*t397*t472+
     5           5.580255669360001d-5*t129*t130*t2*t397*t472+1.860085223
     6           12d-5*t133*t2*t203*t472-5.963779555555556d-2*gammabb*t1
     7           29*t130*t2*t203*t459-2.981889777777778d-2*gammabb*t128*
     8           t133*t2*t459+1.9555555555555557d+1*gammabb*t126*t128*t2
     9           *t459-8.674588444444443d-2*t118*t126*t2*t203*t458-2.976
     :           136356992d-4*gammabb*t129*t130*t2*t227*t238*t397-1.3554
     ;           044444444446d-1*t119*t131*t2*t203*t274-9.92045452330666
     <           5d-5*gammabb*t133*t2*t203*t227*t238+6.505941333333333d-
     =           2*gammabb*t126*t2*t203*t227*t238)+2.0d+0*t226*t508+1.0d
     >           +0*t255*t457)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(-
     ?           3.9403562666666647d-9*t118*t2*t458*t589*t6*t9+5.8257955
     @           55555554d-7*gammabb*t2*t376*t459*t6*t9-1.87928888888888
     1           84d-4*gammabb*t188*t2*t459*t9+1.271082666666666d-6*t118
     2           *t2*t376*t458*t9+3.1d-3*t6*(-3.9403562666666647d-9*t1*t
     3           118*t2*t458*t589*t6+5.825795555555554d-7*gammabb*t1*t2*
     4           t376*t459*t6-1.8792888888888884d-4*gammabb*t1*t188*t2*t
     5           459+1.271082666666666d-6*t1*t118*t2*t376*t458)*t8-1.653
     6           333333333333d-2*gammabb*t227*t504*t8+3.1d-3*t2*t460*t8+
     7           3.0311111111111105d-2*gammabb*t244*t459*t8+5.1253333333
     8           33332d-5*gammabb*t188*t227*t504*t6-9.61d-6*t188*t2*t460
     9           *t6-9.396444444444442d-5*gammabb*t188*t244*t459*t6+4.23
     :           69422222222203d-7*t118*t244*t376*t458*t6-3.177706666666
     ;           6653d-7*gammabb*t2*t227*t228*t376*t6-1.366755555555555d
     <           -4*t118*t188*t244*t458+1.0250666666666663d-4*gammabb*t1
     =           88*t2*t227*t228)-1.653333333333333d-2*gammabb*t227*t505
     >           *t8+3.1d-3*t2*t461*t8+3.0311111111111105d-2*gammabb*t24
     ?           5*t459*t8-3.9403562666666647d-9*t10*t118*t2*t458*t589*t
     @           6+5.125333333333332d-5*gammabb*t188*t227*t505*t6-9.61d-
     1           6*t188*t2*t461*t6+5.825795555555554d-7*gammabb*t10*t2*t
     2           376*t459*t6-9.396444444444442d-5*gammabb*t188*t245*t459
     3           *t6+4.2369422222222203d-7*t118*t245*t376*t458*t6-3.1777
     4           066666666653d-7*gammabb*t2*t227*t229*t376*t6-1.87928888
     5           88888884d-4*gammabb*t10*t188*t2*t459+1.271082666666666d
     6           -6*t10*t118*t2*t376*t458-1.366755555555555d-4*t118*t188
     7           *t245*t458+1.0250666666666663d-4*gammabb*t188*t2*t227*t
     8           229)-1.653333333333333d-2*gammabb*t227*t506*t8+3.1d-3*t
     9           2*t462*t8+3.0311111111111105d-2*gammabb*t246*t459*t8-3.
     :           9403562666666647d-9*t11*t118*t2*t458*t589*t6+5.12533333
     ;           3333332d-5*gammabb*t188*t227*t506*t6-9.61d-6*t188*t2*t4
     <           62*t6+5.825795555555554d-7*gammabb*t11*t2*t376*t459*t6-
     =           9.396444444444442d-5*gammabb*t188*t246*t459*t6+4.236942
     >           2222222203d-7*t118*t246*t376*t458*t6-3.1777066666666653
     ?           d-7*gammabb*t2*t227*t230*t376*t6-1.8792888888888884d-4*
     @           gammabb*t11*t188*t2*t459+1.271082666666666d-6*t11*t118*
     1           t2*t376*t458-1.366755555555555d-4*t118*t188*t246*t458+1
     2           .0250666666666663d-4*gammabb*t188*t2*t227*t230)+t128*(-
     3           3.04966d-3*t238*t508*t72-3.04966d-3*t255*t475*t72-3.049
     4           66d-3*t238*t509-3.04966d-3*t226*t238*t255)-1.7017882504
     5           620419d-7*t135*t2*t397*t472*t72+1.86008522312d-5*t203*t
     6           255*t472*t72+2.0d+0*t226*t507-6.09932d-3*t2*t203*t481-3
     7           .04966d-3*t128*t2*t480+1.0d+0*t247*t457)*wght+Cmat3(iq,
     8           D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = (t117*(1.0d+0*rhob*t113*t40*(-2.1
     1           22525181952d-3*t119*t121*t238*t474*t99*taub-5.494272d-1
     2           *t121*t233*t239*t99*taub-4.57856d-1*gammabb*t239*t515*t
     3           97*taub-1.061262590976d-3*gammabb*t238*t265*t474*t97*ta
     4           ub+6.867840000000001d-2*t119*t238*t239*t97*taub+2.66666
     5           66666666666d+1*t120*t233*t97*taub-3.53754196992d-4*t102
     6           *t119*t238*t239*taub-1.373568d-1*t102*t120*t233*taub-3.
     7           2798617527638757d-6*t122*t4*t472*t753*t99+1.59189388646
     8           4d-4*t122*t4*t474*t475*t99-8.490100727808d-4*t122*t227*
     9           t238*t474*t99-1.0072832000000001d-1*t122*t239*t459*t99-
     :           2.2892800000000002d-1*t239*t265*t274*t99-3.279861752763
     ;           8757d-6*gammabb*t119*t121*t472*t753*t97+1.591893886464d
     <           -4*gammabb*t119*t121*t474*t475*t97-1.030176d-2*t121*t23
     =           9*t4*t475*t97+1.591893886464d-4*t121*t4*t472*t474*t97-1
     >           .6980201455616d-3*gammabb*t121*t233*t238*t474*t97+9.777
     ?           777777777779d+0*t120*t121*t459*t97-3.4797056000000004d-
     @           1*gammabb*t121*t239*t458*t97+5.494272d-2*t121*t227*t238
     1           *t239*t97-3.2798617527638757d-6*t118*t265*t472*t753*t93
     2           -2.5470302183424004d-3*t118*t238*t474*t515*t93+1.591893
     3           886464d-4*t118*t265*t474*t475*t93-2.060352d-2*gammabb*t
     4           119*t239*t475*t93+3.183787772928d-4*gammabb*t119*t472*t
     5           474*t93-7.4172672d-1*t118*t239*t467*t93+6.7555555555555
     6           56d+1*gammabb*t120*t458*t93+2.1977088d-1*gammabb*t233*t
     7           238*t239*t93+5.30631295488d-5*t102*t121*t239*t4*t475-5.
     8           15088d-3*t101*t120*t4*t475+5.30631295488d-5*gammabb*t10
     9           1*t119*t239*t475-8.199654381909689d-7*t102*t121*t4*t472
     :           *t474-8.199654381909689d-7*gammabb*t101*t119*t472*t474+
     ;           5.30631295488d-5*t101*t239*t4*t472-5.036416d-2*t102*t12
     <           0*t121*t459+9.777777777777779d+0*t101*t117*t459-1.73985
     =           28000000002d-1*gammabb*t101*t120*t458-5.660067151872d-4
     >           *gammabb*t101*t233*t238*t239-2.830033575936d-4*t102*t12
     ?           1*t227*t238*t239+2.747136d-2*t101*t120*t227*t238)+2.0d+
     @           0*t113*t40*t521+1.25d-1*gammabb*t110*t111*t40*t521+2.0d
     1           +0*rhob*t113*t215*t521-1.25d-1*t110*t40*t476+1.25d-1*ga
     2           mmabb*t110*t266*t40*t464+1.25d-1*t110*t123*t40*t464+1.0
     3           d+0*rhob*t113*t266*t432-1.25d-1*t110*t123*t432-1.25d-1*
     4           t110*t111*t240*t40+2.0d+0*t113*t215*t266+1.25d-1*gammab
     5           b*t110*t111*t215*t266-2.5d-1*t110*t215*t240-1.25d-1*t11
     6           0*t111*t123*t215)+t125*(1.0d+0*t72*(-3.7201704462400004
     7           d-4*t119*t129*t238*t397*t6*taub-1.6264853333333334d-1*t
     8           129*t203*t233*t6*taub-1.0843235555555557d-1*gammabb*t12
     9           9*t203*t515*taub-7.440340892480001d-4*t119*t130*t131*t2
     :           38*t397*taub-1.2400568154133336d-4*t119*t134*t203*t238*
     ;           taub+4.066213333333334d-2*t119*t129*t203*t238*taub-3.25
     <           2970666666667d-1*t130*t131*t203*t233*taub-8.13242666666
     =           6668d-2*t128*t134*t233*taub+2.6666666666666666d+1*t128*
     >           t129*t233*taub-6.807153001848167d-7*t129*t130*t4*t472*t
     ?           6*t690-6.807153001848167d-7*t131*t132*t4*t472*t690-6.80
     @           7153001848167d-7*t126*t127*t4*t472*t690+5.5802556693600
     1           01d-5*t129*t130*t397*t4*t475*t6+1.86008522312d-5*t133*t
     2           203*t4*t475*t6-1.219864d-2*t126*t203*t4*t475*t6-1.70178
     3           82504620419d-7*t133*t397*t4*t472*t6+1.1160511338720001d
     4           -4*t126*t397*t4*t472*t6-5.963779555555556d-2*t129*t130*
     5           t203*t459*t6-2.981889777777778d-2*t128*t133*t459*t6+1.9
     6           555555555555557d+1*t126*t128*t459*t6-2.9276736d-1*gamma
     7           bb*t126*t203*t458*t6-5.952272713984d-4*gammabb*t126*t23
     8           3*t238*t397*t6-2.976136356992001d-4*t129*t130*t227*t238
     9           *t397*t6-9.920454523306665d-5*t133*t203*t227*t238*t6+6.
     :           505941333333333d-2*t126*t203*t227*t238*t6+5.58025566936
     ;           0001d-5*t131*t132*t397*t4*t475+5.580255669360001d-5*t12
     <           6*t127*t397*t4*t475+1.86008522312d-5*t130*t134*t203*t4*
     =           t475-6.09932d-3*t129*t130*t203*t4*t475-3.04966d-3*t128*
     >           t133*t4*t475-1.7017882504620419d-7*t130*t134*t397*t4*t4
     ?           72+5.580255669360001d-5*t129*t130*t397*t4*t472+1.860085
     @           22312d-5*t133*t203*t4*t472-8.674588444444443d-2*t118*t1
     1           26*t203*t467-5.963779555555556d-2*t131*t132*t203*t459-5
     2           .963779555555556d-2*t126*t127*t203*t459-2.9818897777777
     3           78d-2*t128*t130*t134*t459+9.777777777777779d+0*t125*t13
     4           3*t459+9.777777777777779d+0*t128*t129*t130*t459-1.46383
     5           68d-1*gammabb*t129*t130*t203*t458-7.319184d-2*gammabb*t
     6           128*t133*t458+48*gammabb*t126*t128*t458-2.976136356992d
     7           -4*gammabb*t129*t130*t233*t238*t397-2.976136356992001d-
     8           4*t131*t132*t227*t238*t397-2.976136356992001d-4*t126*t1
     9           27*t227*t238*t397-1.3554044444444446d-1*t131*t203*t265*
     :           t274-9.920454523306665d-5*gammabb*t133*t203*t233*t238+6
     ;           .505941333333333d-2*gammabb*t126*t203*t233*t238-9.92045
     <           4523306665d-5*t130*t134*t203*t227*t238+3.25297066666666
     =           63d-2*t129*t130*t203*t227*t238+1.6264853333333332d-2*t1
     >           28*t133*t227*t238)+2.0d+0*t226*t524+1.0d+0*t267*t457)+1
     ?           .0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(3.03111111111111
     @           05d-2*t459*t8*t9-3.9403562666666647d-9*t118*t467*t589*t
     1           6*t9-9.396444444444442d-5*t188*t459*t6*t9+1.42996799999
     2           99995d-6*gammabb*t376*t458*t6*t9+1.271082666666666d-6*t
     3           118*t376*t467*t9-4.612799999999999d-4*gammabb*t188*t458
     4           *t9+3.1d-3*t6*t8*(3.0311111111111105d-2*t1*t459*t8-3.94
     5           03562666666647d-9*t1*t118*t467*t589*t6-9.39644444444444
     6           2d-5*t1*t188*t459*t6+1.4299679999999995d-6*gammabb*t1*t
     7           376*t458*t6+1.271082666666666d-6*t1*t118*t376*t467-4.61
     8           2799999999999d-4*gammabb*t1*t188*t458)-1.65333333333333
     9           3d-2*gammabb*t227*t510*t8+3.1d-3*t4*t460*t8+3.031111111
     :           1111105d-2*gammabb*t256*t459*t8-1.653333333333333d-2*t2
     ;           27*t228*t8+5.125333333333332d-5*gammabb*t188*t227*t510*
     <           t6-9.61d-6*t188*t4*t460*t6-9.396444444444442d-5*gammabb
     =           *t188*t256*t459*t6+4.2369422222222203d-7*t118*t256*t376
     >           *t458*t6-3.1777066666666653d-7*gammabb*t228*t233*t376*t
     ?           6+5.125333333333332d-5*t188*t227*t228*t6-1.366755555555
     @           555d-4*t118*t188*t256*t458+1.0250666666666663d-4*gammab
     1           b*t188*t228*t233)-1.653333333333333d-2*gammabb*t227*t51
     2           1*t8+3.1d-3*t4*t461*t8+3.0311111111111105d-2*gammabb*t2
     3           57*t459*t8+3.0311111111111105d-2*t10*t459*t8-1.65333333
     4           3333333d-2*t227*t229*t8-3.9403562666666647d-9*t10*t118*
     5           t467*t589*t6+5.125333333333332d-5*gammabb*t188*t227*t51
     6           1*t6-9.61d-6*t188*t4*t461*t6-9.396444444444442d-5*gamma
     7           bb*t188*t257*t459*t6-9.396444444444442d-5*t10*t188*t459
     8           *t6+4.2369422222222203d-7*t118*t257*t376*t458*t6+1.4299
     9           679999999995d-6*gammabb*t10*t376*t458*t6-3.177706666666
     :           6653d-7*gammabb*t229*t233*t376*t6+5.125333333333332d-5*
     ;           t188*t227*t229*t6+1.271082666666666d-6*t10*t118*t376*t4
     <           67-1.366755555555555d-4*t118*t188*t257*t458-4.612799999
     =           999999d-4*gammabb*t10*t188*t458+1.0250666666666663d-4*g
     >           ammabb*t188*t229*t233)-1.653333333333333d-2*gammabb*t22
     ?           7*t512*t8+3.1d-3*t4*t462*t8+3.0311111111111105d-2*gamma
     @           bb*t258*t459*t8+3.0311111111111105d-2*t11*t459*t8-1.653
     1           333333333333d-2*t227*t230*t8-3.9403562666666647d-9*t11*
     2           t118*t467*t589*t6+5.125333333333332d-5*gammabb*t188*t22
     3           7*t512*t6-9.61d-6*t188*t4*t462*t6-9.396444444444442d-5*
     4           gammabb*t188*t258*t459*t6-9.396444444444442d-5*t11*t188
     5           *t459*t6+4.2369422222222203d-7*t118*t258*t376*t458*t6+1
     6           .4299679999999995d-6*gammabb*t11*t376*t458*t6-3.1777066
     7           666666653d-7*gammabb*t230*t233*t376*t6+5.12533333333333
     8           2d-5*t188*t227*t230*t6+1.271082666666666d-6*t11*t118*t3
     9           76*t467-1.366755555555555d-4*t118*t188*t258*t458-4.6127
     :           99999999999d-4*gammabb*t11*t188*t458+1.0250666666666663
     ;           d-4*gammabb*t188*t230*t233)+t110*(5.0d-1*rhob*t112*t40*
     <           (6.0d-2*gammabb*t105*t4*(6.0d-2*gammabb*t105*t4*(6.0d-2
     =           *gammabb*t105*t4*(-5.529599999999998d-4*t465*t750*t763*
     >           t79+1.9583999999999993d-2*t118*t466*t467*t79+5.86666666
     ?           6666666d-1*t105*t459*t79-2.0799999999999996d-1*gammabb*
     @           t232*t458*t79)-5.529599999999998d-4*t106*t465*t750*t763
     1           +1.9199999999999995d-2*t118*t232*t233*t516-3.1999999999
     2           999995d-1*gammabb*t105*t227*t516-2.303999999999999d-3*t
     3           118*t234*t466*t515+6.0d-2*t105*t4*t468-3.6d-3*gammabb*t
     4           119*t232*t468+3.0719999999999986d-3*t261*t465*t466*t467
     5           +1.9583999999999993d-2*t106*t118*t466*t467+5.8666666666
     6           66666d-1*gammabb*t105*t261*t459+5.866666666666666d-1*t1
     7           05*t106*t459-8.639999999999998d-2*t118*t232*t261*t458-2
     8           .0799999999999996d-1*gammabb*t106*t232*t458+5.759999999
     9           999998d-2*gammabb*t232*t233*t234-3.1999999999999995d-1*
     :           t105*t227*t234)-5.529599999999998d-4*t107*t465*t750*t76
     ;           3+1.9199999999999995d-2*t118*t232*t233*t517-3.199999999
     <           9999995d-1*gammabb*t105*t227*t517-2.303999999999999d-3*
     =           t118*t235*t466*t515+6.0d-2*t105*t4*t469-3.6d-3*gammabb*
     >           t119*t232*t469+3.0719999999999986d-3*t262*t465*t466*t46
     ?           7+1.9583999999999993d-2*t107*t118*t466*t467+5.866666666
     @           666666d-1*gammabb*t105*t262*t459+5.866666666666666d-1*t
     1           105*t107*t459-8.639999999999998d-2*t118*t232*t262*t458-
     2           2.0799999999999996d-1*gammabb*t107*t232*t458+5.75999999
     3           9999998d-2*gammabb*t232*t233*t235-3.1999999999999995d-1
     4           *t105*t227*t235)-5.529599999999998d-4*t108*t465*t750*t7
     5           63+1.9199999999999995d-2*t118*t232*t233*t518-3.19999999
     6           99999995d-1*gammabb*t105*t227*t518-2.303999999999999d-3
     7           *t118*t236*t466*t515+6.0d-2*t105*t4*t470-3.6d-3*gammabb
     8           *t119*t232*t470+3.0719999999999986d-3*t263*t465*t466*t4
     9           67+1.9583999999999993d-2*t108*t118*t466*t467+5.86666666
     :           6666666d-1*gammabb*t105*t263*t459+5.866666666666666d-1*
     ;           t105*t108*t459-8.639999999999998d-2*t118*t232*t263*t458
     <           -2.0799999999999996d-1*gammabb*t108*t232*t458+5.7599999
     =           99999998d-2*gammabb*t232*t233*t236-3.1999999999999995d-
     >           1*t105*t227*t236)+1.0d+0*t112*t40*t519+1.25d-1*gammabb*
     ?           t111*t40*t519+1.0d+0*rhob*t112*t215*t519-1.25d-1*t40*t4
     @           71+1.25d-1*gammabb*t264*t40*t464+1.25d-1*t109*t40*t464+
     1           5.0d-1*rhob*t112*t264*t432-1.25d-1*t109*t432-1.25d-1*t1
     2           11*t237*t40+1.0d+0*t112*t215*t264+1.25d-1*gammabb*t111*
     3           t215*t264-2.5d-1*t215*t237-1.25d-1*t109*t111*t215)+t110
     4           *t117*t464*t764+t110*t111*(t762+t761+1.25d-1*gammabb*t4
     5           0*t519+1.25d-1*gammabb*t215*t264)+t110*t464*t760+t128*(
     6           -3.04966d-3*t238*t524*t72-3.04966d-3*t267*t475*t72-2.98
     7           1889777777778d-2*t135*t459*t72+8.132426666666667d-3*t22
     8           7*t242*t72-3.04966d-3*t238*t525-3.04966d-3*t226*t238*t2
     9           67+8.132426666666667d-3*t227*t243+8.132426666666667d-3*
     :           t135*t226*t227)-1.7017882504620419d-7*t135*t397*t4*t472
     ;           *t72+1.86008522312d-5*t203*t267*t472*t72-9.920454523306
     <           665d-5*t135*t203*t227*t238*t72+t120*(-5.15088d-3*t238*t
     =           522-5.15088d-3*rhob*t113*t238*t40*t521-5.15088d-3*rhob*
     >           t113*t266*t40*t475+6.4386d-4*t110*t123*t40*t475+1.37356
     ?           8d-2*t113*t240*t4*t40-5.15088d-3*t113*t238*t266*t40+6.4
     @           386d-4*t110*t238*t240*t40+6.4386d-4*t110*t111*t123*t238
     1           *t40-3.662848000000001d-2*t113*t123*t227*t40+1.373568d-
     2           2*t113*t123*t215*t4-5.15088d-3*rhob*t113*t215*t238*t266
     3           +1.373568d-2*t227*t241+6.4386d-4*t110*t123*t215*t238)+t
     4           110*t111*t117*(1.25d-1*gammabb*t40*t521+1.25d-1*t240*t4
     5           0+1.25d-1*gammabb*t215*t266+1.25d-1*t123*t215)+2.0d+0*t
     6           226*t513-6.09932d-3*t203*t4*t481-3.04966d-3*t128*t4*t48
     7           0+t239*t4*(-1.030176d-2*t478-2.830033575936d-4*t113*t12
     8           3*t238*t40)-5.15088d-3*t120*t4*t477-8.199654381909689d-
     9           7*t113*t114*t123*t40*t472*t474-5.15088d-3*t110*t120*t22
     :           7*t473+5.30631295488d-5*rhob*t113*t239*t266*t40*t472-6.
     ;           6328911936d-6*t110*t123*t239*t40*t472+4.07778d-3*gammab
     <           b*t110*t120*t123*t40*t459+1.0d+0*t259*t457+t110*t111*t1
     =           20*(-1.28772d-3*gammabb*t238*t266*t40-1.28772d-3*t123*t
     >           238*t40)+1.32657823872d-5*gammabb*t110*t123*t227*t238*t
     ?           239*t40)*wght+Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t91*(1.0d+0*rhoa*t26*t87*(-1.06
     1           1262590976d-3*t253*t392*t98*t99*taua-5.30631295488d-4*g
     2           ammaaa*t392*t534*t97*taua+6.867840000000001d-2*t200*t25
     3           3*t97*taua-1.76877098496d-4*t102*t200*t253*taua-3.27986
     4           17527638757d-6*t100*t199*t688*t95*t99-8.490100727808d-4
     5           *t100*t194*t392*t99+3.183787772928d-4*t199*t392*t95*t97
     6           *t98-3.2798617527638757d-6*gammaaa*t199*t253*t688*t97*t
     7           98-1.2735151091712002d-3*gammaaa*t392*t487*t97*t98+1.09
     8           88544d-1*t194*t200*t97*t98-8.199654381909689d-7*t102*t1
     9           99*t392*t95*t98-2.830033575936d-4*t102*t194*t200*t98-1.
     :           0666666666666666d+1*t194*t93*t96+5.494272d-2*t101*t194*
     ;           t96-2.060352d-2*t199*t200*t93*t95+1.061262590976d-4*t10
     <           1*t199*t200*t95-1.6980201455616d-3*t392*t766*t93*t94-3.
     =           2798617527638757d-6*t199*t534*t688*t93*t94+3.2965632d-1
     >           *gammaaa*t200*t487*t93+6.367575545856d-4*gammaaa*t199*t
     ?           253*t392*t93-4.245050363904d-4*gammaaa*t101*t200*t487-8
     @           .199654381909689d-7*gammaaa*t101*t199*t253*t392)+1.0d+0
     1           *t26*t535*t87+1.0d+0*rhoa*t145*t535*t87-2.5d-1*t254*t26
     2           *t84*t85-2.5d-1*t26*t493*t84-2.5d-1*t145*t254*t84)+t125
     3           *(1.0d+0*t72*(-1.8600852231200002d-4*t129*t253*t397*t6*
     4           taua-3.7201704462400004d-4*t130*t131*t253*t397*taua-6.2
     5           00284077066668d-5*t134*t203*t253*taua+4.066213333333334
     6           d-2*t129*t203*t253*taua-6.807153001848167d-7*t129*t130*
     7           t199*t6*t690*t95-6.807153001848167d-7*t131*t132*t199*t6
     8           90*t95-6.807153001848167d-7*t126*t127*t199*t690*t95-1.7
     9           017882504620419d-7*t133*t199*t397*t6*t95+2.232102267744
     :           0003d-4*t126*t199*t397*t6*t95-1.7017882504620419d-7*t13
     ;           0*t134*t199*t397*t95+1.1160511338720001d-4*t129*t130*t1
     <           99*t397*t95+3.72017044624d-5*t133*t199*t203*t95-1.21986
     =           4d-2*t126*t199*t203*t95-2.976136356992d-4*gammaaa*t126*
     >           t397*t487*t6-2.976136356992001d-4*t129*t130*t194*t397*t
     ?           6-9.920454523306665d-5*t133*t194*t203*t6+1.301188266666
     @           6666d-1*t126*t194*t203*t6-1.488068178496d-4*gammaaa*t12
     1           9*t130*t397*t487-4.9602272616533327d-5*gammaaa*t133*t20
     2           3*t487+6.505941333333333d-2*gammaaa*t126*t203*t487-2.97
     3           6136356992001d-4*t131*t132*t194*t397-2.976136356992001d
     4           -4*t126*t127*t194*t397-9.920454523306665d-5*t130*t134*t
     5           194*t203+6.505941333333333d-2*t129*t130*t194*t203+3.252
     6           9706666666663d-2*t128*t133*t194-1.0666666666666666d+1*t
     7           126*t128*t194)+1.0d+0*t186*t536)+t2*(2.747136d-2*t254*t
     8           26*t87-1.7169600000000002d-3*t103*t26*t84*t85+t768)*t96
     9           -5.15088d-3*rhoa*t199*t26*t535*t87*t96+t187*(-5.15088d-
     :           3*t492-6.4386d-4*gammaaa*t254*t26-2.3608200000000001d-3
     ;           *t103*t26)*t84*t96+1.28772d-3*t199*t254*t26*t84*t96+t84
     <           *(5.0d-1*rhoa*t26*t86*(6.0d-2*gammaaa*t2*t75*(6.0d-2*ga
     =           mmaaa*t2*t75*(-7.2d-3*gammaaa*t193*t488*t95-7.2d-3*t193
     >           *t195*t95+6.0d-2*gammaaa*t2*t75*(2.073599999999999d-4*t
     ?           685*t766*t79*t94-5.759999999999997d-3*gammaaa*t384*t487
     @           *t79+3.839999999999999d-2*t193*t194*t79)+2.073599999999
     1           999d-4*t685*t766*t80*t94+9.599999999999997d-3*t193*t194
     2           *t530*t94-2.303999999999999d-3*t249*t384*t487*t94-5.759
     3           999999999997d-3*gammaaa*t384*t487*t80+3.839999999999999
     4           d-2*t193*t194*t80-1.5999999999999998d-1*gammaaa*t187*t5
     5           30*t75+1.2d-1*t2*t488*t75-3.1999999999999995d-1*t187*t2
     6           49*t75+4.32d-4*gammaaa*t195*t253*t384+5.759999999999998
     7           d-2*gammaaa*t193*t194*t249)-7.2d-3*gammaaa*t193*t489*t9
     8           5-7.2d-3*t193*t196*t95+2.073599999999999d-4*t685*t766*t
     9           81*t94+9.599999999999997d-3*t193*t194*t531*t94-2.303999
     :           999999999d-3*t250*t384*t487*t94-5.759999999999997d-3*ga
     ;           mmaaa*t384*t487*t81+3.839999999999999d-2*t193*t194*t81-
     <           1.5999999999999998d-1*gammaaa*t187*t531*t75+1.2d-1*t2*t
     =           489*t75-3.1999999999999995d-1*t187*t250*t75+4.32d-4*gam
     >           maaa*t196*t253*t384+5.759999999999998d-2*gammaaa*t193*t
     ?           194*t250)-7.2d-3*gammaaa*t193*t490*t95-7.2d-3*t193*t197
     @           *t95+2.073599999999999d-4*t685*t766*t82*t94+9.599999999
     1           999997d-3*t193*t194*t532*t94-2.303999999999999d-3*t251*
     2           t384*t487*t94-5.759999999999997d-3*gammaaa*t384*t487*t8
     3           2+3.839999999999999d-2*t193*t194*t82-1.5999999999999998
     4           d-1*gammaaa*t187*t532*t75+1.2d-1*t2*t490*t75-3.19999999
     5           99999995d-1*t187*t251*t75+4.32d-4*gammaaa*t197*t253*t38
     6           4+5.759999999999998d-2*gammaaa*t193*t194*t251)+5.0d-1*t
     7           26*t533*t86+5.0d-1*rhoa*t145*t533*t86-2.5d-1*t252*t26*t
     8           85-2.5d-1*t26*t491-2.5d-1*t145*t252)+1.0d+0*t72*(3.1d-3
     9           *t6*t8*(3.1d-3*t6*t8*(5.9582d-8*t189*t376*t6*t95-1.9219
     :           999999999998d-5*t188*t189*t95+1.4776335999999993d-9*gam
     ;           maaa*t487*t589*t6*t9-3.1777066666666653d-7*t194*t376*t6
     <           *t9-4.766559999999998d-7*gammaaa*t376*t487*t9+1.0250666
     =           666666663d-4*t188*t194*t9+3.1d-3*t6*(1.4776335999999993
     >           d-9*gammaaa*t1*t487*t589*t6-3.1777066666666653d-7*t1*t1
     ?           94*t376*t6-4.766559999999998d-7*gammaaa*t1*t376*t487+1.
     @           0250666666666663d-4*t1*t188*t194)*t8-8.266666666666665d
     1           -3*gammaaa*t187*t526*t8+6.2d-3*t2*t482*t8-1.65333333333
     2           3333d-2*t187*t244*t8+2.562666666666666d-5*gammaaa*t187*
     3           t188*t526*t6-1.9219999999999998d-5*t188*t2*t482*t6-3.17
     4           77066666666653d-7*gammaaa*t194*t244*t376*t6+5.125333333
     5           333332d-5*t187*t188*t244*t6+1.0250666666666663d-4*gamma
     6           aa*t188*t194*t244)+5.9582d-8*t190*t376*t6*t95-1.9219999
     7           999999998d-5*t188*t190*t95-8.266666666666665d-3*gammaaa
     8           *t187*t527*t8+6.2d-3*t2*t483*t8-1.653333333333333d-2*t1
     9           87*t245*t8+1.4776335999999993d-9*gammaaa*t10*t487*t589*
     :           t6+2.562666666666666d-5*gammaaa*t187*t188*t527*t6-1.921
     ;           9999999999998d-5*t188*t2*t483*t6-3.1777066666666653d-7*
     <           gammaaa*t194*t245*t376*t6-3.1777066666666653d-7*t10*t19
     =           4*t376*t6+5.125333333333332d-5*t187*t188*t245*t6-4.7665
     >           59999999998d-7*gammaaa*t10*t376*t487+1.0250666666666663
     ?           d-4*gammaaa*t188*t194*t245+1.0250666666666663d-4*t10*t1
     @           88*t194)+5.9582d-8*t191*t376*t6*t95-1.9219999999999998d
     1           -5*t188*t191*t95-8.266666666666665d-3*gammaaa*t187*t528
     2           *t8+6.2d-3*t2*t484*t8-1.653333333333333d-2*t187*t246*t8
     3           +1.4776335999999993d-9*gammaaa*t11*t487*t589*t6+2.56266
     4           6666666666d-5*gammaaa*t187*t188*t528*t6-1.9219999999999
     5           998d-5*t188*t2*t484*t6-3.1777066666666653d-7*gammaaa*t1
     6           94*t246*t376*t6-3.1777066666666653d-7*t11*t194*t376*t6+
     7           5.125333333333332d-5*t187*t188*t246*t6-4.76655999999999
     8           8d-7*gammaaa*t11*t376*t487+1.0250666666666663d-4*gammaa
     9           a*t188*t194*t246+1.0250666666666663d-4*t11*t188*t194)+t
     :           200*(-1.415016787968d-4*t103*t26*t87-1.030176d-2*t495)*
     ;           t95-1.7017882504620419d-7*t135*t199*t397*t72*t95+1.8600
     <           8522312d-5*t203*t205*t95+t767*t84*t85*t91+1.06126259097
     =           6d-4*t199*t200*t254*t26*t87*t88-8.199654381909689d-7*t1
     >           03*t199*t26*t271*t392*t87+(t765+1.25d-1*gammaaa*t26*t53
     ?           3)*t84*t85-1.32657823872d-5*t103*t199*t2*t200*t26*t84+6
     @           .6328911936d-6*gammaaa*t103*t194*t200*t26*t84-3.04966d-
     1           3*t128*t199*t536*t72+3.72017044624d-5*t199*t2*t203*t255
     2           *t72+1.6264853333333332d-2*t128*t187*t255*t72-9.9204545
     3           23306665d-5*t135*t194*t203*t72+1.0d+0*t186*t529-6.09932
     4           d-3*t128*t2*t497)*wght+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = (t125*(1.0d+0*t72*(-1.8600852231
     1           200002d-4*t129*t397*t4*t6*t95*taua-3.7201704462400004d-
     2           4*t130*t131*t397*t4*t95*taua-6.200284077066668d-5*t134*
     3           t203*t4*t95*taua+4.066213333333334d-2*t129*t203*t4*t95*
     4           taua-6.807153001848167d-7*t129*t130*t199*t2*t4*t6*t690-
     5           6.807153001848167d-7*t131*t132*t199*t2*t4*t690-6.807153
     6           001848167d-7*t126*t127*t199*t2*t4*t690-1.70178825046204
     7           19d-7*t133*t199*t2*t397*t4*t6+2.2321022677440003d-4*t12
     8           6*t199*t2*t397*t4*t6-2.976136356992d-4*gammaaa*t126*t19
     9           4*t397*t4*t6-1.488068178496d-4*t129*t130*t187*t397*t4*t
     :           6-4.9602272616533327d-5*t133*t187*t203*t4*t6+6.50594133
     ;           3333333d-2*t126*t187*t203*t4*t6-1.7017882504620419d-7*t
     <           130*t134*t199*t2*t397*t4+1.1160511338720001d-4*t129*t13
     =           0*t199*t2*t397*t4-1.488068178496d-4*gammaaa*t129*t130*t
     >           194*t397*t4-1.488068178496d-4*t131*t132*t187*t397*t4-1.
     ?           488068178496d-4*t126*t127*t187*t397*t4+3.72017044624d-5
     @           *t133*t199*t2*t203*t4-1.219864d-2*t126*t199*t2*t203*t4-
     1           4.9602272616533327d-5*gammaaa*t133*t194*t203*t4+6.50594
     2           1333333333d-2*gammaaa*t126*t194*t203*t4-4.9602272616533
     3           327d-5*t130*t134*t187*t203*t4+3.2529706666666663d-2*t12
     4           9*t130*t187*t203*t4+1.6264853333333332d-2*t128*t133*t18
     5           7*t4-5.333333333333333d+0*t126*t128*t187*t4)+1.0d+0*t18
     6           6*t541)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(1.47763
     7           35999999993d-9*gammaaa*t194*t4*t589*t6*t9-1.58885333333
     8           33327d-7*t187*t376*t4*t6*t9-4.766559999999998d-7*gammaa
     9           a*t194*t376*t4*t9+5.125333333333332d-5*t187*t188*t4*t9+
     :           3.1d-3*t6*(1.4776335999999993d-9*gammaaa*t1*t194*t4*t58
     ;           9*t6-1.5888533333333327d-7*t1*t187*t376*t4*t6-4.7665599
     <           99999998d-7*gammaaa*t1*t194*t376*t4+5.125333333333332d-
     =           5*t1*t187*t188*t4)*t8-8.266666666666665d-3*gammaaa*t187
     >           *t537*t8+3.1d-3*t2*t498*t8+3.1d-3*t4*t482*t8-8.26666666
     ?           6666665d-3*t187*t256*t8+2.562666666666666d-5*gammaaa*t1
     @           87*t188*t537*t6-9.61d-6*t188*t2*t498*t6-9.61d-6*t188*t4
     1           *t482*t6-1.5888533333333327d-7*gammaaa*t187*t244*t376*t
     2           4*t6+5.9582d-8*t189*t2*t376*t4*t6-1.5888533333333327d-7
     3           *gammaaa*t194*t256*t376*t6+2.562666666666666d-5*t187*t1
     4           88*t256*t6+5.125333333333332d-5*gammaaa*t187*t188*t244*
     5           t4-1.9219999999999998d-5*t188*t189*t2*t4+5.125333333333
     6           332d-5*gammaaa*t188*t194*t256)-8.266666666666665d-3*gam
     7           maaa*t187*t538*t8+3.1d-3*t2*t499*t8+3.1d-3*t4*t483*t8-8
     8           .266666666666665d-3*t187*t257*t8+1.4776335999999993d-9*
     9           gammaaa*t10*t194*t4*t589*t6+2.562666666666666d-5*gammaa
     :           a*t187*t188*t538*t6-9.61d-6*t188*t2*t499*t6-9.61d-6*t18
     ;           8*t4*t483*t6-1.5888533333333327d-7*gammaaa*t187*t245*t3
     <           76*t4*t6+5.9582d-8*t190*t2*t376*t4*t6-1.588853333333332
     =           7d-7*t10*t187*t376*t4*t6-1.5888533333333327d-7*gammaaa*
     >           t194*t257*t376*t6+2.562666666666666d-5*t187*t188*t257*t
     ?           6-4.766559999999998d-7*gammaaa*t10*t194*t376*t4+5.12533
     @           3333333332d-5*gammaaa*t187*t188*t245*t4-1.9219999999999
     1           998d-5*t188*t190*t2*t4+5.125333333333332d-5*t10*t187*t1
     2           88*t4+5.125333333333332d-5*gammaaa*t188*t194*t257)-8.26
     3           6666666666665d-3*gammaaa*t187*t539*t8+3.1d-3*t2*t500*t8
     4           +3.1d-3*t4*t484*t8-8.266666666666665d-3*t187*t258*t8+1.
     5           4776335999999993d-9*gammaaa*t11*t194*t4*t589*t6+2.56266
     6           6666666666d-5*gammaaa*t187*t188*t539*t6-9.61d-6*t188*t2
     7           *t500*t6-9.61d-6*t188*t4*t484*t6-1.5888533333333327d-7*
     8           gammaaa*t187*t246*t376*t4*t6+5.9582d-8*t191*t2*t376*t4*
     9           t6-1.5888533333333327d-7*t11*t187*t376*t4*t6-1.58885333
     :           33333327d-7*gammaaa*t194*t258*t376*t6+2.562666666666666
     ;           d-5*t187*t188*t258*t6-4.766559999999998d-7*gammaaa*t11*
     <           t194*t376*t4+5.125333333333332d-5*gammaaa*t187*t188*t24
     =           6*t4-1.9219999999999998d-5*t188*t191*t2*t4+5.1253333333
     >           33332d-5*t11*t187*t188*t4+5.125333333333332d-5*gammaaa*
     ?           t188*t194*t258)-3.04966d-3*t128*t199*t541*t72-1.7017882
     @           504620419d-7*t135*t199*t2*t397*t4*t72+1.86008522312d-5*
     1           t199*t203*t255*t4*t72-4.9602272616533327d-5*t135*t187*t
     2           203*t4*t72+1.86008522312d-5*t199*t2*t203*t267*t72+8.132
     3           426666666667d-3*t128*t187*t267*t72+1.0d+0*t186*t540-3.0
     4           4966d-3*t128*t2*t503-3.04966d-3*t128*t4*t497+1.86008522
     5           312d-5*t2*t203*t205*t4)*wght+Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = (t125*(1.0d+0*t72*(-1.8600852231
     1           200002d-4*t119*t129*t2*t397*t6*taua-3.7201704462400004d
     2           -4*t119*t130*t131*t2*t397*taua-6.200284077066668d-5*t11
     3           9*t134*t2*t203*taua+4.066213333333334d-2*t119*t129*t2*t
     4           203*taua-6.807153001848167d-7*t119*t129*t130*t199*t6*t6
     5           90-6.807153001848167d-7*t119*t131*t132*t199*t690-6.8071
     6           53001848167d-7*t119*t126*t127*t199*t690-1.7017882504620
     7           419d-7*t119*t133*t199*t397*t6+2.2321022677440003d-4*t11
     8           9*t126*t199*t397*t6-2.976136356992d-4*gammaaa*t119*t126
     9           *t187*t397*t6-1.7017882504620419d-7*t119*t130*t134*t199
     :           *t397+1.1160511338720001d-4*t119*t129*t130*t199*t397-1.
     ;           488068178496d-4*gammaaa*t119*t129*t130*t187*t397+3.7201
     <           7044624d-5*t119*t133*t199*t203-1.219864d-2*t119*t126*t1
     =           99*t203-4.9602272616533327d-5*gammaaa*t119*t133*t187*t2
     >           03+6.505941333333333d-2*gammaaa*t119*t126*t187*t203)+1.
     ?           0d+0*t186*t552)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*
     @           (1.4776335999999993d-9*gammaaa*t119*t187*t589*t6*t9-4.7
     1           66559999999998d-7*gammaaa*t119*t187*t376*t9+3.1d-3*t6*(
     2           1.4776335999999993d-9*gammaaa*t1*t119*t187*t589*t6-4.76
     3           6559999999998d-7*gammaaa*t1*t119*t187*t376)*t8-8.266666
     4           666666665d-3*gammaaa*t187*t542*t8+6.2d-3*t4*t498*t8+2.5
     5           62666666666666d-5*gammaaa*t187*t188*t542*t6-1.921999999
     6           9999998d-5*t188*t4*t498*t6-3.1777066666666653d-7*gammaa
     7           a*t187*t256*t376*t4*t6+5.9582d-8*t119*t189*t376*t6+1.02
     8           50666666666663d-4*gammaaa*t187*t188*t256*t4-1.921999999
     9           9999998d-5*t119*t188*t189)-8.266666666666665d-3*gammaaa
     :           *t187*t543*t8+6.2d-3*t4*t499*t8+1.4776335999999993d-9*g
     ;           ammaaa*t10*t119*t187*t589*t6+2.562666666666666d-5*gamma
     <           aa*t187*t188*t543*t6-1.9219999999999998d-5*t188*t4*t499
     =           *t6-3.1777066666666653d-7*gammaaa*t187*t257*t376*t4*t6+
     >           5.9582d-8*t119*t190*t376*t6+1.0250666666666663d-4*gamma
     ?           aa*t187*t188*t257*t4-4.766559999999998d-7*gammaaa*t10*t
     @           119*t187*t376-1.9219999999999998d-5*t119*t188*t190)-8.2
     1           66666666666665d-3*gammaaa*t187*t544*t8+6.2d-3*t4*t500*t
     2           8+1.4776335999999993d-9*gammaaa*t11*t119*t187*t589*t6+2
     3           .562666666666666d-5*gammaaa*t187*t188*t544*t6-1.9219999
     4           999999998d-5*t188*t4*t500*t6-3.1777066666666653d-7*gamm
     5           aaa*t187*t258*t376*t4*t6+5.9582d-8*t119*t191*t376*t6+1.
     6           0250666666666663d-4*gammaaa*t187*t188*t258*t4-4.7665599
     7           99999998d-7*gammaaa*t11*t119*t187*t376-1.92199999999999
     8           98d-5*t119*t188*t191)-3.04966d-3*t128*t199*t552*t72+3.7
     9           2017044624d-5*t199*t203*t267*t4*t72-1.7017882504620419d
     :           -7*t119*t135*t199*t397*t72+1.0d+0*t186*t545-6.09932d-3*
     ;           t128*t4*t503+1.86008522312d-5*t119*t203*t205)*wght+Cmat
     <           3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = (t125*(1.0d+0*t72*(-1.8600852231
     1           200002d-4*t129*t397*t4*t6*t95*taub-3.7201704462400004d-
     2           4*t130*t131*t397*t4*t95*taub-6.200284077066668d-5*t134*
     3           t203*t4*t95*taub+4.066213333333334d-2*t129*t203*t4*t95*
     4           taub-6.807153001848167d-7*t129*t130*t238*t6*t690*t95-6.
     5           807153001848167d-7*t131*t132*t238*t690*t95-6.8071530018
     6           48167d-7*t126*t127*t238*t690*t95-1.7017882504620419d-7*
     7           t133*t238*t397*t6*t95+2.2321022677440003d-4*t126*t238*t
     8           397*t6*t95-2.976136356992d-4*gammabb*t126*t227*t397*t6*
     9           t95-1.7017882504620419d-7*t130*t134*t238*t397*t95+1.116
     :           0511338720001d-4*t129*t130*t238*t397*t95-1.488068178496
     ;           d-4*gammabb*t129*t130*t227*t397*t95+3.72017044624d-5*t1
     <           33*t203*t238*t95-1.219864d-2*t126*t203*t238*t95-4.96022
     =           72616533327d-5*gammabb*t133*t203*t227*t95+6.50594133333
     >           3333d-2*gammabb*t126*t203*t227*t95)+1.0d+0*t226*t536)+1
     ?           .0d+0*t72*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(3.1d-3*t6*t8*(1.
     @           4776335999999993d-9*gammabb*t1*t227*t589*t6*t95-4.76655
     1           9999999998d-7*gammabb*t1*t227*t376*t95)+1.4776335999999
     2           993d-9*gammabb*t227*t589*t6*t9*t95-4.766559999999998d-7
     3           *gammabb*t227*t376*t9*t95+5.9582d-8*t228*t376*t6*t95-1.
     4           9219999999999998d-5*t188*t228*t95-8.266666666666665d-3*
     5           gammabb*t227*t526*t8+6.2d-3*t2*t504*t8+2.56266666666666
     6           6d-5*gammabb*t188*t227*t526*t6-1.9219999999999998d-5*t1
     7           88*t2*t504*t6-3.1777066666666653d-7*gammabb*t2*t227*t24
     8           4*t376*t6+1.0250666666666663d-4*gammabb*t188*t2*t227*t2
     9           44)+1.4776335999999993d-9*gammabb*t10*t227*t589*t6*t95+
     :           5.9582d-8*t229*t376*t6*t95-4.766559999999998d-7*gammabb
     ;           *t10*t227*t376*t95-1.9219999999999998d-5*t188*t229*t95-
     <           8.266666666666665d-3*gammabb*t227*t527*t8+6.2d-3*t2*t50
     =           5*t8+2.562666666666666d-5*gammabb*t188*t227*t527*t6-1.9
     >           219999999999998d-5*t188*t2*t505*t6-3.1777066666666653d-
     ?           7*gammabb*t2*t227*t245*t376*t6+1.0250666666666663d-4*ga
     @           mmabb*t188*t2*t227*t245)+1.4776335999999993d-9*gammabb*
     1           t11*t227*t589*t6*t95+5.9582d-8*t230*t376*t6*t95-4.76655
     2           9999999998d-7*gammabb*t11*t227*t376*t95-1.9219999999999
     3           998d-5*t188*t230*t95-8.266666666666665d-3*gammabb*t227*
     4           t528*t8+6.2d-3*t2*t506*t8+2.562666666666666d-5*gammabb*
     5           t188*t227*t528*t6-1.9219999999999998d-5*t188*t2*t506*t6
     6           -3.1777066666666653d-7*gammabb*t2*t227*t246*t376*t6+1.0
     7           250666666666663d-4*gammabb*t188*t2*t227*t246)-1.7017882
     8           504620419d-7*t135*t238*t397*t72*t95+1.86008522312d-5*t2
     9           03*t243*t95-3.04966d-3*t128*t238*t536*t72+3.72017044624
     :           d-5*t2*t203*t238*t255*t72+1.0d+0*t226*t529-6.09932d-3*t
     ;           128*t2*t509)*wght+Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = (t125*(1.0d+0*t72*(-1.8600852231
     1           200002d-4*t119*t129*t2*t397*t6*taub-3.7201704462400004d
     2           -4*t119*t130*t131*t2*t397*taub-6.200284077066668d-5*t11
     3           9*t134*t2*t203*taub+4.066213333333334d-2*t119*t129*t2*t
     4           203*taub-6.807153001848167d-7*t129*t130*t2*t238*t4*t6*t
     5           690-6.807153001848167d-7*t131*t132*t2*t238*t4*t690-6.80
     6           7153001848167d-7*t126*t127*t2*t238*t4*t690-1.7017882504
     7           620419d-7*t133*t2*t238*t397*t4*t6+2.2321022677440003d-4
     8           *t126*t2*t238*t397*t4*t6-2.976136356992d-4*gammabb*t126
     9           *t2*t233*t397*t6-1.4880681784960004d-4*t129*t130*t2*t22
     :           7*t397*t6-4.9602272616533327d-5*t133*t2*t203*t227*t6+6.
     ;           505941333333333d-2*t126*t2*t203*t227*t6-1.7017882504620
     <           419d-7*t130*t134*t2*t238*t397*t4+1.1160511338720001d-4*
     =           t129*t130*t2*t238*t397*t4+3.72017044624d-5*t133*t2*t203
     >           *t238*t4-1.219864d-2*t126*t2*t203*t238*t4-1.48806817849
     ?           6d-4*gammabb*t129*t130*t2*t233*t397-1.4880681784960004d
     @           -4*t131*t132*t2*t227*t397-1.4880681784960004d-4*t126*t1
     1           27*t2*t227*t397-4.9602272616533327d-5*gammabb*t133*t2*t
     2           203*t233+6.505941333333333d-2*gammabb*t126*t2*t203*t233
     3           -4.9602272616533327d-5*t130*t134*t2*t203*t227+3.2529706
     4           666666663d-2*t129*t130*t2*t203*t227+1.6264853333333332d
     5           -2*t128*t133*t2*t227-5.333333333333333d+0*t126*t128*t2*
     6           t227)+1.0d+0*t226*t541)+1.0d+0*t72*(3.1d-3*t6*t8*(3.1d-
     7           3*t6*t8*(1.4776335999999993d-9*gammabb*t2*t233*t589*t6*
     8           t9-1.5888533333333327d-7*t2*t227*t376*t6*t9-4.766559999
     9           999998d-7*gammabb*t2*t233*t376*t9+5.125333333333332d-5*
     :           t188*t2*t227*t9+3.1d-3*t6*(1.4776335999999993d-9*gammab
     ;           b*t1*t2*t233*t589*t6-1.5888533333333327d-7*t1*t2*t227*t
     <           376*t6-4.766559999999998d-7*gammabb*t1*t2*t233*t376+5.1
     =           25333333333332d-5*t1*t188*t2*t227)*t8-8.266666666666665
     >           d-3*gammabb*t227*t537*t8+3.1d-3*t2*t510*t8+3.1d-3*t4*t5
     ?           04*t8-8.266666666666665d-3*t227*t244*t8+2.5626666666666
     @           66d-5*gammabb*t188*t227*t537*t6-9.61d-6*t188*t2*t510*t6
     1           -9.61d-6*t188*t4*t504*t6+5.9582d-8*t2*t228*t376*t4*t6-1
     2           .5888533333333327d-7*gammabb*t2*t227*t256*t376*t6-1.588
     3           8533333333327d-7*gammabb*t233*t244*t376*t6+2.5626666666
     4           66666d-5*t188*t227*t244*t6-1.9219999999999998d-5*t188*t
     5           2*t228*t4+5.125333333333332d-5*gammabb*t188*t2*t227*t25
     6           6+5.