import QtQml 2.12
import QtQuick 2.12
import QtQuick.Controls 2.3
import QtQuick.Layouts 1.2
import Style 1.0

ColumnLayout {
    id: unifiedSearchResultItemFetchMore

    property bool isFetchMoreInProgress: false

    property bool isWithinViewPort: false

    property int fontSize: Style.unifiedSearchResultTitleFontSize

    property string textColor: Style.ncSecondaryTextColor

    Accessible.role: Accessible.ListItem
    Accessible.name: unifiedSearchResultItemFetchMoreText.text
    Accessible.onPressAction: unifiedSearchResultMouseArea.clicked()

    Label {
        id: unifiedSearchResultItemFetchMoreText
        text: qsTr("Load more results")
        visible: !unifiedSearchResultItemFetchMore.isFetchMoreInProgress
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        Layout.fillWidth: true
        Layout.fillHeight: true
        font.pixelSize: unifiedSearchResultItemFetchMore.fontSize
        color: unifiedSearchResultItemFetchMore.textColor
    }

    BusyIndicator {
        id: unifiedSearchResultItemFetchMoreIconInProgress
        running: visible
        visible: unifiedSearchResultItemFetchMore.isFetchMoreInProgress && unifiedSearchResultItemFetchMore.isWithinViewPort
        Layout.alignment: Qt.AlignVCenter | Qt.AlignHCenter
        Layout.preferredWidth: parent.height * 0.70
        Layout.preferredHeight: parent.height * 0.70
    }
}
