import QtQuick 2.12
import Style 1.0
import QtQuick.Controls 2.12
import QtQuick.Layouts 1.12
import com.nextcloud.desktopclient 1.0

Item {
    id: root

    signal sendReply(string reply)

    function sendReplyMessage() {
        if (replyMessageTextField.text === "") {
            return;
        }

        root.sendReply(replyMessageTextField.text);
    }

    TextField {
        id: replyMessageTextField

        height: Style.talkReplyTextFieldPreferredHeight

        anchors.fill: parent

        visible: model.messageSent === ""

        color: Style.ncTextColor
        placeholderText: qsTr("Reply to …")

        onAccepted: root.sendReplyMessage()

        background: Rectangle {
            id: replyMessageTextFieldBorder
            radius: 24
            border.width: 1
            border.color: parent.activeFocus ? UserModel.currentUser.accentColor : Style.menuBorder
            color: Style.backgroundColor
        }

        Button {
            id: sendReplyMessageButton

            width: Style.talkReplyTextFieldPreferredWidth * 0.12
            height: parent.height

            opacity: 0.8
            flat: true
            enabled: replyMessageTextField.text !== ""
            onClicked: root.sendReplyMessage()
            background: null

            icon {
                source: "image://svgimage-custom-color/send.svg" + "/" + Style.menuBorder
                color: hovered || !sendReplyMessageButton.enabled? Style.menuBorder : UserModel.currentUser.accentColor
            }

            anchors {
                right: replyMessageTextField.right
                top: replyMessageTextField.top
            }

            ToolTip {
                visible: sendReplyMessageButton.hovered
                delay: Qt.styleHints.mousePressAndHoldInterval
                text:  qsTr("Send reply to chat message")
            }
        }
    }
}
