/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2023 Intel Corporation
 */

#ifndef __VLV_DPIO_PHY_REGS_H__
#define __VLV_DPIO_PHY_REGS_H__

#include "intel_display_reg_defs.h"

#define _VLV_CMN(dw) (0x8100 + (dw) * 4)
#define _CHV_CMN(cl, dw) (0x8100 - (cl) * 0x80 + (dw) * 4)
#define _VLV_PLL(ch, dw) (0x8000 + (ch) * 0x20 + (dw) * 4) /* dw 0-7,16-23 */
#define _CHV_PLL(ch, dw) (0x8000 + (ch) * 0x180 + (dw) * 4)
#define _VLV_REF(dw) (0x80a0 + ((dw) - 8) * 4) /* dw 8-15 */
#define _VLV_PCS(ch, spline, dw) (0x200 + (ch) * 0x2400 + (spline) * 0x200 + (dw) * 4)
#define _VLV_PCS_GRP(ch, dw) (0x8200 + (ch) * 0x200 + (dw) * 4)
#define _VLV_PCS_BCAST(dw) (0xc000 + (dw) * 4)
#define _VLV_TX(ch, lane, dw) (0x80 + (ch) * 0x2400 + (lane) * 0x200 + (dw) * 4)
#define _VLV_TX_GRP(ch, dw) (0x8280 + (ch) * 0x200 + (dw) * 4)
#define _VLV_TX_BCAST(dw) (0xc080 + (dw) * 4)

/*
 * Per pipe/PLL DPIO regs
 */
#define VLV_PLL_DW3(ch)			_VLV_PLL((ch), 3)
#define   DPIO_S1_DIV_MASK		REG_GENMASK(30, 28)
#define   DPIO_S1_DIV(s1)		REG_FIELD_PREP(DPIO_S1_DIV_MASK, (s1))
#define   DPIO_S1_DIV_DAC		0 /* 10, DAC 25-225M rate */
#define   DPIO_S1_DIV_HDMIDP		1 /* 5, DAC 225-400M rate */
#define   DPIO_S1_DIV_LVDS1		2 /* 14 */
#define   DPIO_S1_DIV_LVDS2		3 /* 7 */
#define   DPIO_K_DIV_MASK		REG_GENMASK(27, 24)
#define   DPIO_K_DIV(k)			REG_FIELD_PREP(DPIO_K_DIV_MASK, (k))
#define   DPIO_P1_DIV_MASK		REG_GENMASK(23, 21)
#define   DPIO_P1_DIV(p1)		REG_FIELD_PREP(DPIO_P1_DIV_MASK, (p1))
#define   DPIO_P2_DIV_MASK		REG_GENMASK(20, 16)
#define   DPIO_P2_DIV(p2)		REG_FIELD_PREP(DPIO_P2_DIV_MASK, (p2))
#define   DPIO_N_DIV_MASK		REG_GENMASK(15, 12)
#define   DPIO_N_DIV(n)			REG_FIELD_PREP(DPIO_N_DIV_MASK, (n))
#define   DPIO_ENABLE_CALIBRATION	REG_BIT(11)
#define   DPIO_M1_DIV_MASK		REG_GENMASK(10, 8)
#define   DPIO_M1_DIV(m1)		REG_FIELD_PREP(DPIO_M1_DIV_MASK, (m1))
#define   DPIO_M2_DIV_MASK		REG_GENMASK(7, 0)
#define   DPIO_M2_DIV(m2)		REG_FIELD_PREP(DPIO_M2_DIV_MASK, (m2))

#define VLV_PLL_DW5(ch)			_VLV_PLL((ch), 5)
#define   DPIO_REFSEL_OVERRIDE		REG_BIT(27)
#define   DPIO_PLL_MODESEL_MASK		REG_GENMASK(26, 24)
#define   DPIO_BIAS_CURRENT_CTL_MASK	REG_GENMASK(22, 20) /* always 0x7 */
#define   DPIO_PLL_REFCLK_SEL_MASK	REG_GENMASK(17, 16)
#define   DPIO_DRIVER_CTL_MASK		REG_GENMASK(15, 12) /* always set to 0x8 */
#define   DPIO_CLK_BIAS_CTL_MASK	REG_GENMASK(11, 8) /* always set to 0x5 */

#define VLV_PLL_DW7(ch)			_VLV_PLL((ch), 7)

#define VLV_PLL_DW16(ch)		_VLV_PLL((ch), 16)

#define VLV_PLL_DW17(ch)		_VLV_PLL((ch), 17)

#define VLV_PLL_DW18(ch)		_VLV_PLL((ch), 18)

#define VLV_PLL_DW19(ch)		_VLV_PLL((ch), 19)

#define VLV_REF_DW11			_VLV_REF(11)

#define VLV_CMN_DW0			_VLV_CMN(0)

/*
 * Per DDI channel DPIO regs
 */
#define VLV_PCS_DW0_GRP(ch)		_VLV_PCS_GRP((ch), 0)
#define VLV_PCS01_DW0(ch)		_VLV_PCS((ch), 0, 0)
#define VLV_PCS23_DW0(ch)		_VLV_PCS((ch), 1, 0)
#define   DPIO_PCS_TX_LANE2_RESET	REG_BIT(16)
#define   DPIO_PCS_TX_LANE1_RESET	REG_BIT(7)
#define   DPIO_LEFT_TXFIFO_RST_MASTER2	REG_BIT(4)
#define   DPIO_RIGHT_TXFIFO_RST_MASTER2	REG_BIT(3)

#define VLV_PCS_DW1_GRP(ch)		 _VLV_PCS_GRP((ch), 1)
#define VLV_PCS01_DW1(ch) _VLV_PCS((ch), 0, 1)
#define VLV_PCS23_DW1(ch) _VLV_PCS((ch), 1, 1)
#define   CHV_PCS_REQ_SOFTRESET_EN		REG_BIT(23)
#define   DPIO_PCS_CLK_CRI_RXEB_EIOS_EN		REG_BIT(22)
#define   DPIO_PCS_CLK_CRI_RXDIGFILTSG_EN	REG_BIT(21)
#define   DPIO_PCS_CLK_DATAWIDTH_MASK		REG_GENMASK(7, 6)
#define   DPIO_PCS_CLK_DATAWIDTH_8_10		REG_FIELD_PREP(DPIO_PCS_CLK_DATAWIDTH_MASK, 1)
#define   DPIO_PCS_CLK_DATAWIDTH_16_20		REG_FIELD_PREP(DPIO_PCS_CLK_DATAWIDTH_MASK, 2)
#define   DPIO_PCS_CLK_DATAWIDTH_32_40		REG_FIELD_PREP(DPIO_PCS_CLK_DATAWIDTH_MASK, 3)
#define   DPIO_PCS_CLK_SOFT_RESET		REG_BIT(5)

#define VLV_PCS_DW8_GRP(ch)		_VLV_PCS_GRP((ch), 8)
#define VLV_PCS01_DW8(ch)		_VLV_PCS((ch), 0, 8)
#define VLV_PCS23_DW8(ch)		_VLV_PCS((ch), 1, 8)
#define   DPIO_PCS_USEDCLKCHANNEL		REG_BIT(21)
#define   DPIO_PCS_USEDCLKCHANNEL_OVRRIDE	REG_BIT(20)

#define VLV_PCS_DW9_GRP(ch)		_VLV_PCS_GRP((ch), 9)
#define VLV_PCS01_DW9(ch)		_VLV_PCS((ch), 0, 9)
#define VLV_PCS23_DW9(ch)		_VLV_PCS((ch), 1, 9)
#define   DPIO_PCS_TX2MARGIN_MASK	REG_GENMASK(15, 13)
#define   DPIO_PCS_TX2MARGIN_000	REG_FIELD_PREP(DPIO_PCS_TX2MARGIN_MASK, 0)
#define   DPIO_PCS_TX2MARGIN_101	REG_FIELD_PREP(DPIO_PCS_TX2MARGIN_MASK, 1)
#define   DPIO_PCS_TX1MARGIN_MASK	REG_GENMASK(12, 10)
#define   DPIO_PCS_TX1MARGIN_000	REG_FIELD_PREP(DPIO_PCS_TX1MARGIN_MASK, 0)
#define   DPIO_PCS_TX1MARGIN_101	REG_FIELD_PREP(DPIO_PCS_TX1MARGIN_MASK, 1)

#define VLV_PCS_DW10_GRP(ch)		_VLV_PCS_GRP((ch), 10)
#define VLV_PCS01_DW10(ch)		_VLV_PCS((ch), 0, 10)
#define VLV_PCS23_DW10(ch)		_VLV_PCS((ch), 1, 10)
#define   DPIO_PCS_SWING_CALC_TX1_TX3	REG_BIT(31)
#define   DPIO_PCS_SWING_CALC_TX0_TX2	REG_BIT(30)
#define   DPIO_PCS_TX2DEEMP_MASK	REG_GENMASK(27, 24)
#define   DPIO_PCS_TX2DEEMP_9P5		REG_FIELD_PREP(DPIO_PCS_TX2DEEMP_MASK, 0)
#define   DPIO_PCS_TX2DEEMP_6P0		REG_FIELD_PREP(DPIO_PCS_TX2DEEMP_MASK, 2)
#define   DPIO_PCS_TX1DEEMP_MASK	REG_GENMASK(19, 16)
#define   DPIO_PCS_TX1DEEMP_9P5		REG_FIELD_PREP(DPIO_PCS_TX1DEEMP_MASK, 0)
#define   DPIO_PCS_TX1DEEMP_6P0		REG_FIELD_PREP(DPIO_PCS_TX1DEEMP_MASK, 2)

#define VLV_PCS_DW11_GRP(ch)		_VLV_PCS_GRP((ch), 11)
#define VLV_PCS01_DW11(ch)		_VLV_PCS((ch), 0, 11)
#define VLV_PCS23_DW11(ch)		_VLV_PCS((ch), 1, 11)
#define   DPIO_TX2_STAGGER_MASK_MASK	REG_GENMASK(28, 24)
#define   DPIO_TX2_STAGGER_MASK(x)	REG_FIELD_PREP(DPIO_TX2_STAGGER_MASK_MASK, (x))
#define   DPIO_LANEDESKEW_STRAP_OVRD	REG_BIT(3)
#define   DPIO_LEFT_TXFIFO_RST_MASTER	REG_BIT(1)
#define   DPIO_RIGHT_TXFIFO_RST_MASTER	REG_BIT(0)

#define VLV_PCS_DW12_GRP(ch)		_VLV_PCS_GRP((ch), 12)
#define VLV_PCS01_DW12(ch)		_VLV_PCS((ch), 0, 12)
#define VLV_PCS23_DW12(ch)		_VLV_PCS((ch), 1, 12)
#define   DPIO_TX2_STAGGER_MULT_MASK	REG_GENMASK(22, 20)
#define   DPIO_TX2_STAGGER_MULT(x)	REG_FIELD_PREP(DPIO_TX2_STAGGER_MULT_MASK, (x))
#define   DPIO_TX1_STAGGER_MULT_MASK	REG_GENMASK(20, 16)
#define   DPIO_TX1_STAGGER_MULT(x)	REG_FIELD_PREP(DPIO_TX1_STAGGER_MULT_MASK, (x))
#define   DPIO_TX1_STAGGER_MASK_MASK	REG_GENMASK(12, 8)
#define   DPIO_TX1_STAGGER_MASK(x)	REG_FIELD_PREP(DPIO_TX1_STAGGER_MASK_MASK, (x))
#define   DPIO_LANESTAGGER_STRAP_OVRD	REG_BIT(6)
#define   DPIO_LANESTAGGER_STRAP_MASK	REG_GENMASK(4, 0)
#define   DPIO_LANESTAGGER_STRAP(x)	REG_FIELD_PREP(DPIO_LANESTAGGER_STRAP_MASK, (x))

#define VLV_PCS_DW14_GRP(ch)		_VLV_PCS_GRP((ch), 14)
#define VLV_PCS01_DW14(ch)		_VLV_PCS((ch), 0, 14)
#define VLV_PCS23_DW14(ch)		_VLV_PCS((ch), 1, 14)

#define VLV_PCS_DW17_BCAST		_VLV_PCS_BCAST(17)
#define VLV_PCS_DW17_GRP(ch)		_VLV_PCS_GRP((ch), 17)
#define VLV_PCS01_DW17(ch)		_VLV_PCS((ch), 0, 17)
#define VLV_PCS23_DW17(ch)		_VLV_PCS((ch), 1, 17)

#define VLV_PCS_DW23_GRP(ch)		_VLV_PCS_GRP((ch), 23)
#define VLV_PCS01_DW23(ch)		_VLV_PCS((ch), 0, 23)
#define VLV_PCS23_DW23(ch)		_VLV_PCS((ch), 1, 23)

#define VLV_TX_DW2_GRP(ch)		_VLV_TX_GRP((ch), 2)
#define VLV_TX_DW2(ch, lane)		_VLV_TX((ch), (lane), 2)
#define   DPIO_SWING_MARGIN000_MASK	REG_GENMASK(23, 16)
#define   DPIO_SWING_MARGIN000(x)	REG_FIELD_PREP(DPIO_SWING_MARGIN000_MASK, (x))
#define   DPIO_UNIQ_TRANS_SCALE_MASK	REG_GENMASK(15, 8)
#define   DPIO_UNIQ_TRANS_SCALE(x)	REG_FIELD_PREP(DPIO_UNIQ_TRANS_SCALE_MASK, (x))

#define VLV_TX_DW3_GRP(ch)		_VLV_TX_GRP((ch), 3)
#define VLV_TX_DW3(ch, lane)		_VLV_TX((ch), (lane), 3)
/* The following bit for CHV phy */
#define   DPIO_TX_UNIQ_TRANS_SCALE_EN	REG_BIT(27)
#define   DPIO_SWING_MARGIN101_MASK	REG_GENMASK(23, 16)
#define   DPIO_SWING_MARGIN101(x)	REG_FIELD_PREP(DPIO_SWING_MARGIN101_MASK, (x))

#define VLV_TX_DW4_GRP(ch)		_VLV_TX_GRP((ch), 4)
#define VLV_TX_DW4(ch, lane)		_VLV_TX((ch), (lane), 4)
#define   DPIO_SWING_DEEMPH9P5_MASK	REG_GENMASK(31, 24)
#define   DPIO_SWING_DEEMPH9P5(x)	REG_FIELD_PREP(DPIO_SWING_DEEMPH9P5_MASK, (x))
#define   DPIO_SWING_DEEMPH6P0_MASK	REG_GENMASK(23, 16)
#define   DPIO_SWING_DEEMPH6P0_SHIFT	REG_FIELD_PREP(DPIO_SWING_DEEMPH6P0_MASK, (x))

#define VLV_TX_DW5_GRP(ch)		_VLV_TX_GRP((ch), 5)
#define VLV_TX_DW5(ch, lane)		_VLV_TX((ch), (lane), 5)
#define   DPIO_TX_OCALINIT_EN		REG_BIT(31)

#define VLV_TX_DW11_GRP(ch)		_VLV_TX_GRP((ch), 11)
#define VLV_TX_DW11(ch, lane)		_VLV_TX((ch), (lane), 11)

#define VLV_TX_DW14_GRP(ch)		_VLV_TX_GRP((ch), 14)
#define VLV_TX_DW14(ch, lane)		_VLV_TX((ch), (lane), 14)

/* CHV dpPhy registers */
#define CHV_PLL_DW0(ch)			_CHV_PLL((ch), 0)
#define   DPIO_CHV_M2_DIV_MASK		REG_GENMASK(7, 0)
#define   DPIO_CHV_M2_DIV(m2)		REG_FIELD_PREP(DPIO_CHV_M2_DIV_MASK, (m2))

#define CHV_PLL_DW1(ch)			_CHV_PLL((ch), 1)
#define   DPIO_CHV_N_DIV_MASK		REG_GENMASK(11, 8)
#define   DPIO_CHV_N_DIV(n)		REG_FIELD_PREP(DPIO_CHV_N_DIV_MASK, (n))
#define   DPIO_CHV_M1_DIV_MASK		REG_GENMASK(2, 0)
#define   DPIO_CHV_M1_DIV(m1)		REG_FIELD_PREP(DPIO_CHV_M1_DIV_MASK, (m1))
#define   DPIO_CHV_M1_DIV_BY_2		0

#define CHV_PLL_DW2(ch)			_CHV_PLL((ch), 2)
#define   DPIO_CHV_M2_FRAC_DIV_MASK	REG_GENMASK(21, 0)
#define   DPIO_CHV_M2_FRAC_DIV(m2_frac)	REG_FIELD_PREP(DPIO_CHV_M2_FRAC_DIV_MASK, (m2_frac))

#define CHV_PLL_DW3(ch)			_CHV_PLL((ch), 3)
#define   DPIO_CHV_FRAC_DIV_EN		REG_BIT(16)
#define   DPIO_CHV_SECOND_MOD		REG_BIT(8)
#define   DPIO_CHV_FEEDFWD_GAIN_MASK	REG_GENMASK(3, 0)
#define   DPIO_CHV_FEEDFWD_GAIN(x)	REG_FIELD_PREP(DPIO_CHV_FEEDFWD_GAIN_MASK, (x))

#define CHV_PLL_DW6(ch)			_CHV_PLL((ch), 6)
#define   DPIO_CHV_GAIN_CTRL_MASK	REG_GENMASK(18, 16)
#define   DPIO_CHV_GAIN_CTRL(x)		REG_FIELD_PREP(DPIO_CHV_GAIN_CTRL_MASK, (x))
#define   DPIO_CHV_INT_COEFF_MASK	REG_GENMASK(12, 8)
#define   DPIO_CHV_INT_COEFF(x)		REG_FIELD_PREP(DPIO_CHV_INT_COEFF_MASK, (x))
#define   DPIO_CHV_PROP_COEFF_MASK	REG_GENMASK(3, 0)
#define   DPIO_CHV_PROP_COEFF(x)	REG_FIELD_PREP(DPIO_CHV_PROP_COEFF_MASK, (x))

#define CHV_PLL_DW8(ch)			_CHV_PLL((ch), 8)
#define   DPIO_CHV_TDC_TARGET_CNT_MASK	REG_GENMASK(9, 0)
#define   DPIO_CHV_TDC_TARGET_CNT(x)	REG_FIELD_PREP(DPIO_CHV_TDC_TARGET_CNT_MASK, (x))

#define CHV_PLL_DW9(ch)			_CHV_PLL((ch), 9)
#define   DPIO_CHV_INT_LOCK_THRESHOLD_MASK		REG_GENMASK(3, 1)
#define   DPIO_CHV_INT_LOCK_THRESHOLD(x)		REG_FIELD_PREP(DPIO_CHV_INT_LOCK_THRESHOLD_MASK, (x))
#define   DPIO_CHV_INT_LOCK_THRESHOLD_SEL_COARSE	REG_BIT(0) /* 1: coarse & 0 : fine  */

#define CHV_CMN_DW0_CH0			_CHV_CMN(0, 0)
#define   DPIO_ALLDL_POWERDOWN_CH0	REG_BIT(19)
#define   DPIO_ANYDL_POWERDOWN_CH0	REG_BIT(18)
#define   DPIO_ALLDL_POWERDOWN		BIT(1)
#define   DPIO_ANYDL_POWERDOWN		BIT(0)

#define CHV_CMN_DW5_CH0			_CHV_CMN(0, 5)
#define   CHV_BUFRIGHTENA1_MASK		REG_GENMASK(21, 20)
#define   CHV_BUFRIGHTENA1_DISABLE	REG_FIELD_PREP(CHV_BUFRIGHTENA1_MASK, 0)
#define   CHV_BUFRIGHTENA1_NORMAL	REG_FIELD_PREP(CHV_BUFRIGHTENA1_MASK, 1)
#define   CHV_BUFRIGHTENA1_FORCE	REG_FIELD_PREP(CHV_BUFRIGHTENA1_MASK, 3)
#define   CHV_BUFLEFTENA1_MASK		REG_GENMASK(23, 22)
#define   CHV_BUFLEFTENA1_DISABLE	REG_FIELD_PREP(CHV_BUFLEFTENA1_MASK, 0)
#define   CHV_BUFLEFTENA1_NORMAL	REG_FIELD_PREP(CHV_BUFLEFTENA1_MASK, 1)
#define   CHV_BUFLEFTENA1_FORCE		REG_FIELD_PREP(CHV_BUFLEFTENA1_MASK, 3)

#define CHV_CMN_DW13_CH0		_CHV_CMN(0, 13)
#define CHV_CMN_DW0_CH1			_CHV_CMN(1, 0)
#define   DPIO_CHV_S1_DIV_MASK		REG_GENMASK(23, 21)
#define   DPIO_CHV_S1_DIV(s1)		REG_FIELD_PREP(DPIO_CHV_S1_DIV_MASK, (s1))
#define   DPIO_CHV_P1_DIV_MASK		REG_GENMASK(15, 13)
#define   DPIO_CHV_P1_DIV(p1)		REG_FIELD_PREP(DPIO_CHV_P1_DIV_MASK, (p1))
#define   DPIO_CHV_P2_DIV_MASK		REG_GENMASK(12, 8)
#define   DPIO_CHV_P2_DIV(p2)		REG_FIELD_PREP(DPIO_CHV_P2_DIV_MASK, (p2))
#define   DPIO_CHV_K_DIV_MASK		REG_GENMASK(7, 4)
#define   DPIO_CHV_K_DIV(k)		REG_FIELD_PREP(DPIO_CHV_K_DIV_MASK, (k))
#define   DPIO_PLL_FREQLOCK		REG_BIT(1)
#define   DPIO_PLL_LOCK			REG_BIT(0)
#define CHV_CMN_DW13(ch)		_PIPE(ch, CHV_CMN_DW13_CH0, CHV_CMN_DW0_CH1)

#define CHV_CMN_DW14_CH0		_CHV_CMN(0, 14)
#define CHV_CMN_DW1_CH1			_CHV_CMN(1, 1)
#define   DPIO_AFC_RECAL		REG_BIT(14)
#define   DPIO_DCLKP_EN			REG_BIT(13)
#define   CHV_BUFLEFTENA2_MASK		REG_GENMASK(18, 17) /* CL2 DW1 only */
#define   CHV_BUFLEFTENA2_DISABLE	REG_FIELD_PREP(CHV_BUFLEFTENA2_MASK, 0)
#define   CHV_BUFLEFTENA2_NORMAL	REG_FIELD_PREP(CHV_BUFLEFTENA2_MASK, 1)
#define   CHV_BUFLEFTENA2_FORCE		REG_FIELD_PREP(CHV_BUFLEFTENA2_MASK, 3)
#define   CHV_BUFRIGHTENA2_MASK		REG_GENMASK(20, 19) /* CL2 DW1 only */
#define   CHV_BUFRIGHTENA2_DISABLE	REG_FIELD_PREP(CHV_BUFRIGHTENA2_MASK, 0)
#define   CHV_BUFRIGHTENA2_NORMAL	REG_FIELD_PREP(CHV_BUFRIGHTENA2_MASK, 1)
#define   CHV_BUFRIGHTENA2_FORCE	REG_FIELD_PREP(CHV_BUFRIGHTENA2_MASK, 3)
#define CHV_CMN_DW14(ch)		_PIPE(ch, CHV_CMN_DW14_CH0, CHV_CMN_DW1_CH1)

#define CHV_CMN_DW19_CH0		_CHV_CMN(0, 19)
#define CHV_CMN_DW6_CH1			_CHV_CMN(1, 6)
#define   DPIO_ALLDL_POWERDOWN_CH1	REG_BIT(30) /* CL2 DW6 only */
#define   DPIO_ANYDL_POWERDOWN_CH1	REG_BIT(29) /* CL2 DW6 only */
#define   DPIO_DYNPWRDOWNEN_CH1		REG_BIT(28) /* CL2 DW6 only */
#define   CHV_CMN_USEDCLKCHANNEL	REG_BIT(13)
#define CHV_CMN_DW19(ch)		_PIPE(ch, CHV_CMN_DW19_CH0, CHV_CMN_DW6_CH1)

#define CHV_CMN_DW28			_CHV_CMN(0, 28)
#define   DPIO_CL1POWERDOWNEN			REG_BIT(23)
#define   DPIO_DYNPWRDOWNEN_CH0			REG_BIT(22)
#define   DPIO_SUS_CLK_CONFIG_MASK		REG_GENMASK(1, 0)
#define   DPIO_SUS_CLK_CONFIG_ON		REG_FIELD_PREP(DPIO_SUS_CLK_CONFIG_MASK, 0)
#define   DPIO_SUS_CLK_CONFIG_CLKREQ		REG_FIELD_PREP(DPIO_SUS_CLK_CONFIG_MASK, 1)
#define   DPIO_SUS_CLK_CONFIG_GATE		REG_FIELD_PREP(DPIO_SUS_CLK_CONFIG_MASK, 2)
#define   DPIO_SUS_CLK_CONFIG_GATE_CLKREQ	REG_FIELD_PREP(DPIO_SUS_CLK_CONFIG_MASK, 3)

#define CHV_CMN_DW30			_CHV_CMN(0, 30)
#define   DPIO_CL2_LDOFUSE_PWRENB	REG_BIT(6)
#define   DPIO_LRC_BYPASS		REG_BIT(3)

#define CHV_TX_DW0(ch, lane)		_VLV_TX((ch), (lane), 0)
#define CHV_TX_DW1(ch, lane)		_VLV_TX((ch), (lane), 1)
#define CHV_TX_DW2(ch, lane)		_VLV_TX((ch), (lane), 2)
#define CHV_TX_DW3(ch, lane)		_VLV_TX((ch), (lane), 3)
#define CHV_TX_DW4(ch, lane)		_VLV_TX((ch), (lane), 4)
#define CHV_TX_DW5(ch, lane)		_VLV_TX((ch), (lane), 5)
#define CHV_TX_DW6(ch, lane)		_VLV_TX((ch), (lane), 6)
#define CHV_TX_DW7(ch, lane)		_VLV_TX((ch), (lane), 7)
#define CHV_TX_DW8(ch, lane)		_VLV_TX((ch), (lane), 8)
#define CHV_TX_DW9(ch, lane)		_VLV_TX((ch), (lane), 9)
#define CHV_TX_DW10(ch, lane)		_VLV_TX((ch), (lane), 10)

#define CHV_TX_DW11(ch, lane)		_VLV_TX((ch), (lane), 11)
#define   DPIO_FRC_LATENCY_MASK		REG_GENMASK(10, 8)
#define   DPIO_FRC_LATENCY(x)		REG_FIELD_PREP(DPIO_FRC_LATENCY_MASK, (x))

#define CHV_TX_DW14(ch, lane)		_VLV_TX((ch), (lane), 14)
#define   DPIO_UPAR			REG_BIT(30)

#endif /* __VLV_DPIO_PHY_REGS_H__ */
