/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css2.font;

import java.util.Enumeration;
import java.util.Vector;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css2.font.Css2Style;
import org.w3c.css.properties.css2.font.FontProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;

public class FontFamily
extends FontProperty
implements CssOperator {
    Vector family_name = new Vector();

    public FontFamily() {
    }

    public FontFamily(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        boolean family = true;
        CssValue val = expression.getValue();
        this.setByUser();
        while (family) {
            val = expression.getValue();
            char op = expression.getOperator();
            if (op != ',' && op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            if (val instanceof CssString) {
                String name;
                if (op == ',') {
                    name = (String)val.get();
                    this.family_name.addElement(FontFamily.trimToOneSpace(name));
                    expression.next();
                    continue;
                }
                name = (String)val.get();
                this.family_name.addElement(FontFamily.trimToOneSpace(name));
                family = false;
                expression.next();
                continue;
            }
            if (val instanceof CssIdent) {
                if (op == ',') {
                    this.family_name.addElement(val.toString());
                    expression.next();
                    continue;
                }
                CssValue next = expression.getNextValue();
                if (next instanceof CssIdent) {
                    CssIdent New2 = new CssIdent(val.get() + " " + next.get());
                    expression.remove();
                    op = expression.getOperator();
                    expression.remove();
                    expression.insert(New2);
                    expression.setCurrentOperator(op);
                    continue;
                }
                this.family_name.addElement(val.toString());
                expression.next();
                family = false;
                continue;
            }
            throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
        }
    }

    public FontFamily(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Enumeration elements() {
        return this.family_name.elements();
    }

    public int size() {
        return this.family_name.size();
    }

    @Override
    public Object get() {
        if (this.family_name.size() == 0) {
            return null;
        }
        return this.family_name.firstElement();
    }

    @Override
    public String toString() {
        String r = "";
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            r = r + ", " + this.convertString(e.nextElement().toString());
        }
        if (r.length() < 3) {
            return null;
        }
        return r.substring(2);
    }

    String convertString(String value) {
        char clast;
        char cfirst = value.charAt(0);
        if (cfirst == (clast = value.charAt(value.length() - 1)) && (cfirst == '\'' || cfirst == '\"')) {
            return value;
        }
        if (value.indexOf(34) != -1) {
            return '\'' + value + '\'';
        }
        if (value.indexOf(39) != -1) {
            return '\"' + value + '\"';
        }
        return value;
    }

    @Override
    public String getPropertyName() {
        return "font-family";
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        Css2Style style0 = (Css2Style)style;
        if (style0.fontFamily != null) {
            style.addRedefinitionWarning(ac, this);
        }
        style0.fontFamily = this;
    }

    @Override
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css2Style)style).getFaceFontFamily();
        }
        return ((Css2Style)style).fontFamily;
    }

    @Override
    public boolean equals(CssProperty property) {
        return false;
    }

    private static String trimToOneSpace(String name) {
        int count = name.length();
        char[] dst = new char[count];
        char[] src = new char[count];
        int index = -1;
        name.getChars(0, count, src, 0);
        for (int i = 0; i < count; ++i) {
            if (i != 0 && Character.isWhitespace(src[i]) && (!Character.isWhitespace(src[i]) || Character.isWhitespace(dst[index]))) continue;
            dst[++index] = src[i];
        }
        return new String(dst, 0, index + 1);
    }
}

