/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class RelPaths {
    private static String[] dirs;

    private RelPaths() {
    }

    public static String[] findRelativePath(String string) {
        if (string.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[]{null, null};
        RelPaths.testWritePath(string, System.getProperty("netbeans.user"), "user", stringArray);
        int n = 0;
        for (String string2 : RelPaths.dirs()) {
            RelPaths.testWritePath(string, string2, "" + n, stringArray);
            ++n;
        }
        RelPaths.testWritePath(string, System.getProperty("netbeans.home"), "home", stringArray);
        if (stringArray[1] == null) {
            stringArray[0] = "abs";
            stringArray[1] = string;
        }
        return stringArray;
    }

    public static String readRelativePath(ByteBuffer byteBuffer) throws IOException {
        class IS
        extends InputStream {
            final /* synthetic */ ByteBuffer val$bb;

            IS(ByteBuffer byteBuffer) {
                this.val$bb = byteBuffer;
            }

            @Override
            public int read() throws IOException {
                return this.val$bb.position() < this.val$bb.limit() ? (int)this.val$bb.get() : -1;
            }
        }
        DataInputStream dataInputStream = new DataInputStream(new IS(byteBuffer));
        return RelPaths.readRelativePath(dataInputStream);
    }

    public static String cluster(int n) {
        return RelPaths.dirs()[n];
    }

    public static String readRelativePath(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        if (string.isEmpty()) {
            return string;
        }
        String string2 = dataInputStream.readUTF();
        if ("user".equals(string)) {
            return System.getProperty("netbeans.user").concat(string2);
        }
        if ("home".equals(string)) {
            return System.getProperty("netbeans.home").concat(string2);
        }
        if ("abs".equals(string)) {
            return string2;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException);
        }
        return RelPaths.dirs()[n].concat(string2);
    }

    private static boolean testWritePath(String string, String string2, String string3, String[] stringArray) {
        if (string2 == null || string2.isEmpty()) {
            return false;
        }
        if (string.startsWith(string2)) {
            String string4 = string.substring(string2.length());
            while (string4.startsWith("/")) {
                string4 = string4.substring(1);
            }
            if (stringArray[1] == null || stringArray[1].length() > string4.length()) {
                stringArray[0] = string3;
                stringArray[1] = string4;
            }
            return true;
        }
        return false;
    }

    private static synchronized String[] dirs() {
        if (dirs == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = System.getProperty("netbeans.dirs");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
            dirs = arrayList.toArray(new String[0]);
        }
        return dirs;
    }

    static synchronized void assignDirs(String ... stringArray) {
        dirs = stringArray;
    }
}

