/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.Modifiable;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.ModifiableVariableHolder;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicClientKeyExchangeAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.MessageActionResult;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendRaccoonCkeAction
extends MessageAction
implements SendingAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean withNullByte = true;
    private BigInteger initialSecret = new BigInteger("5000");

    public SendRaccoonCkeAction() {
    }

    public SendRaccoonCkeAction(boolean withNullByte, BigInteger intialSecret) {
        this.withNullByte = withNullByte;
        this.initialSecret = intialSecret;
    }

    public SendRaccoonCkeAction(String connectionAlias) {
        super(connectionAlias);
    }

    public BigInteger getInitialSecret() {
        return this.initialSecret;
    }

    public void setInitialSecret(BigInteger initialSecret) {
        this.initialSecret = initialSecret;
    }

    public boolean isWithNullByte() {
        return this.withNullByte;
    }

    public void setWithNullByte(boolean withNullByte) {
        this.withNullByte = withNullByte;
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.connectionAlias);
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        this.messages = new LinkedList();
        this.messages.add(this.generateRaccoonDhClientKeyExchangeMessage(state, this.withNullByte));
        String sending = this.getReadableString(this.messages);
        if (this.hasDefaultAlias()) {
            LOGGER.info("Sending Raccoon Cke message " + (this.withNullByte ? "(withNullByte)" : "(withoutNullByte)") + ": " + sending);
        } else {
            LOGGER.info("Sending Raccoon Cke message " + (this.withNullByte ? "(withNullByte)" : "(withoutNullByte)") + ": (" + this.connectionAlias + "): " + sending);
        }
        try {
            MessageActionResult result = this.sendMessageHelper.sendMessages(this.messages, this.records, tlsContext);
            this.messages = new ArrayList<ProtocolMessage>(result.getMessageList());
            this.records = new ArrayList<AbstractRecord>(result.getRecordList());
            this.setExecuted(true);
        }
        catch (IOException E) {
            tlsContext.setReceivedTransportHandlerException(true);
            LOGGER.debug((Object)E);
            this.setExecuted(false);
        }
    }

    private DHClientKeyExchangeMessage generateRaccoonDhClientKeyExchangeMessage(State state, boolean withNullByte) {
        DHClientKeyExchangeMessage cke = new DHClientKeyExchangeMessage(state.getConfig());
        Chooser chooser = state.getTlsContext().getChooser();
        byte[] clientPublicKey = this.getClientPublicKey(chooser.getServerDhGenerator(), chooser.getServerDhModulus(), chooser.getDhServerPublicKey(), this.initialSecret, withNullByte);
        cke.setPublicKey(Modifiable.explicit((byte[])clientPublicKey));
        return cke;
    }

    private byte[] getClientPublicKey(BigInteger g, BigInteger m, BigInteger serverPublicKey, BigInteger initialClientDhSecret, boolean withNullByte) {
        BigInteger clientPublicKey;
        byte[] cke;
        int length = ArrayConverter.bigIntegerToByteArray((BigInteger)m).length;
        byte[] pms = ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)serverPublicKey.modPow(initialClientDhSecret, m), (int)length);
        if ((withNullByte && pms[0] == 0 && pms[1] != 0 || !withNullByte && pms[0] != 0) && (cke = ArrayConverter.bigIntegerToByteArray((BigInteger)(clientPublicKey = g.modPow(initialClientDhSecret, m)))).length == length) {
            return cke;
        }
        initialClientDhSecret = initialClientDhSecret.add(new BigInteger("1"));
        return this.getClientPublicKey(g, m, serverPublicKey, initialClientDhSecret, withNullByte);
    }

    public String toString() {
        StringBuilder sb = this.isExecuted() ? new StringBuilder("Send Dynamic Client Key Exchange Action:\n") : new StringBuilder("Send Dynamic Client Key Exchange Action: (not executed)\n");
        sb.append("\tMessages:");
        if (this.messages != null) {
            for (ProtocolMessage message : this.messages) {
                sb.append(message.toCompactString());
                sb.append(", ");
            }
            sb.append("\n");
        } else {
            sb.append("null (no messages set)");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder(super.toCompactString());
        if (this.messages != null && !this.messages.isEmpty()) {
            sb.append(" (");
            for (ProtocolMessage message : this.messages) {
                sb.append(message.toCompactString());
                sb.append(",");
            }
            sb.deleteCharAt(sb.lastIndexOf(",")).append(")");
        } else {
            sb.append(" (no messages set)");
        }
        return sb.toString();
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void setRecords(List<AbstractRecord> records) {
        this.records = records;
    }

    @Override
    public void reset() {
        LinkedList<ModifiableVariableHolder> holders = new LinkedList<ModifiableVariableHolder>();
        if (this.messages != null) {
            for (ProtocolMessage message : this.messages) {
                holders.addAll(message.getAllModifiableVariableHolders());
            }
        }
        if (this.getRecords() != null) {
            for (AbstractRecord record : this.getRecords()) {
                holders.addAll(record.getAllModifiableVariableHolders());
            }
        }
        for (ModifiableVariableHolder holder : holders) {
            List<Field> fields = holder.getAllModifiableVariableFields();
            for (Field f : fields) {
                f.setAccessible(true);
                ModifiableVariable mv = null;
                try {
                    mv = (ModifiableVariable)f.get(holder);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    LOGGER.warn("Could not retrieve ModifiableVariables");
                    LOGGER.debug((Object)ex);
                }
                if (mv == null) continue;
                if (mv.getModification() != null || mv.isCreateRandomModification()) {
                    mv.setOriginalValue(null);
                    continue;
                }
                try {
                    f.set(holder, null);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    LOGGER.warn("Could not strip ModifiableVariable without Modification");
                }
            }
        }
        this.setExecuted(null);
    }

    @Override
    public List<ProtocolMessage> getSendMessages() {
        return this.messages;
    }

    @Override
    public List<AbstractRecord> getSendRecords() {
        return this.records;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SendDynamicClientKeyExchangeAction other = (SendDynamicClientKeyExchangeAction)obj;
        if (!Objects.equals(this.messages, other.messages)) {
            return false;
        }
        if (!Objects.equals(this.records, other.records)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 67 * hash + Objects.hashCode(this.messages);
        hash = 67 * hash + Objects.hashCode(this.records);
        return hash;
    }
}

