/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 * ivec3(-36, 32, -88)) => ivec3(-432, 384, -1056)
 * (12 * ivec3(36, 32, 88)) => ivec3(432, 384, 1056)
 * (12 * ivec3(59, 77, 68)) => ivec3(708, 924, 816)
 * (-6 * ivec3(-36, 32, -88)) => ivec3(216, -192, 528)
 * (-6 * ivec3(36, 32, 88)) => ivec3(-216, -192, -528)
 * (-6 * ivec3(59, 77, 68)) => ivec3(-354, -462, -408)
 * (76 * ivec3(-36, 32, -88)) => ivec3(-2736, 2432, -6688)
 * (76 * ivec3(36, 32, 88)) => ivec3(2736, 2432, 6688)
 * (76 * ivec3(59, 77, 68)) => ivec3(4484, 5852, 5168)
 * (-32 * ivec3(-36, 32, -88)) => ivec3(1152, -1024, 2816)
 * (-32 * ivec3(36, 32, 88)) => ivec3(-1152, -1024, -2816)
 * (-32 * ivec3(59, 77, 68)) => ivec3(-1888, -2464, -2176)
 * (0 * ivec3(-36, 32, -88)) => ivec3(0, 0, 0)
 * (0 * ivec3(36, 32, 88)) => ivec3(0, 0, 0)
 * (0 * ivec3(59, 77, 68)) => ivec3(0, 0, 0)
 */
#version 120

void main()
{
  float[all(equal((12 * ivec3(-36, 32, -88)), ivec3(-432, 384, -1056))) ? 1 : -1] array0;
  float[all(equal((12 * ivec3(36, 32, 88)), ivec3(432, 384, 1056))) ? 1 : -1] array1;
  float[all(equal((12 * ivec3(59, 77, 68)), ivec3(708, 924, 816))) ? 1 : -1] array2;
  float[all(equal((-6 * ivec3(-36, 32, -88)), ivec3(216, -192, 528))) ? 1 : -1] array3;
  float[all(equal((-6 * ivec3(36, 32, 88)), ivec3(-216, -192, -528))) ? 1 : -1] array4;
  float[all(equal((-6 * ivec3(59, 77, 68)), ivec3(-354, -462, -408))) ? 1 : -1] array5;
  float[all(equal((76 * ivec3(-36, 32, -88)), ivec3(-2736, 2432, -6688))) ? 1 : -1] array6;
  float[all(equal((76 * ivec3(36, 32, 88)), ivec3(2736, 2432, 6688))) ? 1 : -1] array7;
  float[all(equal((76 * ivec3(59, 77, 68)), ivec3(4484, 5852, 5168))) ? 1 : -1] array8;
  float[all(equal((-32 * ivec3(-36, 32, -88)), ivec3(1152, -1024, 2816))) ? 1 : -1] array9;
  float[all(equal((-32 * ivec3(36, 32, 88)), ivec3(-1152, -1024, -2816))) ? 1 : -1] array10;
  float[all(equal((-32 * ivec3(59, 77, 68)), ivec3(-1888, -2464, -2176))) ? 1 : -1] array11;
  float[all(equal((0 * ivec3(-36, 32, -88)), ivec3(0, 0, 0))) ? 1 : -1] array12;
  float[all(equal((0 * ivec3(36, 32, 88)), ivec3(0, 0, 0))) ? 1 : -1] array13;
  float[all(equal((0 * ivec3(59, 77, 68)), ivec3(0, 0, 0))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
