/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jta;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.TransactionException;

public final class JtaStatusHelper {
    private JtaStatusHelper() {
    }

    public static @UnknownKeyFor @NonNull @Initialized int getStatus(@UnknownKeyFor @NonNull @Initialized UserTransaction userTransaction) {
        try {
            int status = userTransaction.getStatus();
            if (status == 5) {
                throw new TransactionException("UserTransaction reported transaction status as unknown");
            }
            return status;
        }
        catch (SystemException se) {
            throw new TransactionException("Could not determine transaction status", se);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized int getStatus(@UnknownKeyFor @NonNull @Initialized TransactionManager transactionManager) {
        try {
            int status = transactionManager.getStatus();
            if (status == 5) {
                throw new TransactionException("TransactionManager reported transaction status as unknwon");
            }
            return status;
        }
        catch (SystemException se) {
            throw new TransactionException("Could not determine transaction status", se);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isActive(@UnknownKeyFor @NonNull @Initialized int status) {
        return status == 0;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isActive(@UnknownKeyFor @NonNull @Initialized UserTransaction userTransaction) {
        int status = JtaStatusHelper.getStatus(userTransaction);
        return JtaStatusHelper.isActive(status);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isActive(@UnknownKeyFor @NonNull @Initialized TransactionManager transactionManager) {
        return JtaStatusHelper.isActive(JtaStatusHelper.getStatus(transactionManager));
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isRollback(@UnknownKeyFor @NonNull @Initialized int status) {
        return status == 1 || status == 9 || status == 4;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isRollback(@UnknownKeyFor @NonNull @Initialized UserTransaction userTransaction) {
        return JtaStatusHelper.isRollback(JtaStatusHelper.getStatus(userTransaction));
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isRollback(@UnknownKeyFor @NonNull @Initialized TransactionManager transactionManager) {
        return JtaStatusHelper.isRollback(JtaStatusHelper.getStatus(transactionManager));
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isCommitted(@UnknownKeyFor @NonNull @Initialized int status) {
        return status == 3;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isCommitted(@UnknownKeyFor @NonNull @Initialized UserTransaction userTransaction) {
        return JtaStatusHelper.isCommitted(JtaStatusHelper.getStatus(userTransaction));
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isCommitted(@UnknownKeyFor @NonNull @Initialized TransactionManager transactionManager) {
        return JtaStatusHelper.isCommitted(JtaStatusHelper.getStatus(transactionManager));
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isMarkedForRollback(@UnknownKeyFor @NonNull @Initialized int status) {
        return status == 1;
    }
}

