/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.WorkLocationPlan;

public class ColonyPlan {
    private static final Logger logger = Logger.getLogger(ColonyPlan.class.getName());
    private static final Comparator<BuildPlan> buildPlanComparator = Comparator.comparingDouble(BuildPlan::getValue).reversed();
    private static final int LOW_PRODUCTION_THRESHOLD = 1;
    private static final int PRODUCTION_TURNOVER_TURNS = 5;
    private ProfileType profileType;
    private final AIMain aiMain;
    private final Colony colony;
    private final List<BuildPlan> buildPlans = new ArrayList<BuildPlan>();
    private final List<WorkLocationPlan> workPlans = new ArrayList<WorkLocationPlan>();
    private final List<GoodsType> produce = new ArrayList<GoodsType>();
    private final Set<GoodsType> libertyGoodsTypes = new HashSet<GoodsType>();
    private final Set<GoodsType> immigrationGoodsTypes = new HashSet<GoodsType>();
    private final Set<GoodsType> militaryGoodsTypes = new HashSet<GoodsType>();
    private final List<GoodsType> rawBuildingGoodsTypes = new ArrayList<GoodsType>();
    private final Set<GoodsType> buildingGoodsTypes = new HashSet<GoodsType>();
    private final Set<GoodsType> rawLuxuryGoodsTypes = new HashSet<GoodsType>();
    private final Set<GoodsType> otherRawGoodsTypes = new HashSet<GoodsType>();
    private static final double BREEDING_WEIGHT = 0.1;
    private static final double BUILDING_WEIGHT = 0.9;
    private static final double DEFENCE_WEIGHT = 0.1;
    private static final double EXPORT_WEIGHT = 0.6;
    private static final double FISH_WEIGHT = 0.25;
    private static final double FORTIFY_WEIGHT = 0.3;
    private static final double IMMIGRATION_WEIGHT = 0.05;
    private static final double LIBERTY_WEIGHT = 0.75;
    private static final double MILITARY_WEIGHT = 0.4;
    private static final double PRODUCTION_WEIGHT = 0.25;
    private static final double REPAIR_WEIGHT = 0.1;
    private static final double STORAGE_WEIGHT = 0.85;
    private static final double TEACH_WEIGHT = 0.2;
    private static final double TRANSPORT_WEIGHT = 0.15;

    public ColonyPlan(AIMain aiMain, Colony colony) {
        if (aiMain == null) {
            throw new RuntimeException("Null AIMain: " + this);
        }
        if (colony == null) {
            throw new RuntimeException("Null colony: " + this);
        }
        this.aiMain = aiMain;
        this.colony = colony;
        this.profileType = ProfileType.getProfileTypeFromSize(colony.getUnitCount());
    }

    private AIMain getAIMain() {
        return this.aiMain;
    }

    private Specification spec() {
        return this.aiMain.getGame().getSpecification();
    }

    public List<GoodsType> getPreferredProduction() {
        return new ArrayList<GoodsType>(this.produce);
    }

    public List<BuildableType> getBuildableTypes() {
        return CollectionUtils.transform(this.buildPlans, CollectionUtils.alwaysTrue(), bp -> bp.type);
    }

    public BuildableType getBestBuildableType() {
        BuildPlan bp = CollectionUtils.find(this.buildPlans, p -> this.colony.canBuild(p.type));
        return bp == null ? null : bp.type;
    }

    public String getBuildableReport() {
        LogBuilder lb = new LogBuilder(64);
        lb.add("Buildables:\n");
        for (BuildPlan b : this.buildPlans) {
            lb.add(b, "\n");
        }
        return lb.toString();
    }

    public List<WorkLocationPlan> getFoodPlans() {
        return CollectionUtils.transform(this.workPlans, wp -> wp.isFoodPlan() && !wp.getWorkLocation().canAutoProduce());
    }

    public List<WorkLocationPlan> getWorkPlans() {
        return CollectionUtils.transform(this.workPlans, wp -> !wp.isFoodPlan() && !wp.getWorkLocation().canAutoProduce());
    }

    public void refine(BuildableType build, LogBuilder lb) {
        List<GoodsType> required = CollectionUtils.transform(this.colony.getFullRequiredGoods(build), CollectionUtils.alwaysTrue(), AbstractGoods::getType);
        HashMap<GoodsType, ArrayList<WorkLocationPlan>> suppressed = new HashMap<GoodsType, ArrayList<WorkLocationPlan>>();
        ArrayList<WorkLocationPlan> plans = new ArrayList<WorkLocationPlan>(this.workPlans);
        int offset = 0;
        for (int i = 0; i < plans.size(); ++i) {
            List wls;
            WorkLocationPlan wlp = (WorkLocationPlan)plans.get(i);
            GoodsType g = wlp.getGoodsType();
            if (this.rawBuildingGoodsTypes.contains(g) && !required.contains(g.getOutputType()) || this.buildingGoodsTypes.contains(g) && !required.contains(g)) {
                this.workPlans.remove(i - offset);
                ++offset;
                wls = (ArrayList<WorkLocationPlan>)suppressed.get(g);
                if (wls == null) {
                    wls = new ArrayList<WorkLocationPlan>();
                }
                wls.add(0, wlp);
                suppressed.put(g, (ArrayList<WorkLocationPlan>)wls);
                this.produce.remove(g);
                lb.add(", suppress production of ", g);
                continue;
            }
            if (!g.isRefined() || !this.rawBuildingGoodsTypes.contains(g.getInputType()) && !this.buildingGoodsTypes.contains(g.getInputType())) continue;
            int n = 0;
            int idx = this.produce.indexOf(g);
            for (GoodsType type = g.getInputType(); type != null && (wls = (List)suppressed.get(type)) != null && this.colony.getGoodsCount(type) < 50; type = type.getInputType()) {
                n += wls.size();
                while (!wls.isEmpty()) {
                    this.workPlans.add(i - offset, (WorkLocationPlan)wls.remove(0));
                }
                this.produce.add(idx, type);
                lb.add(", restore production of ", type);
            }
            offset -= n;
        }
    }

    public void update() {
        this.profileType = ProfileType.getProfileTypeFromSize(this.colony.getUnitCount());
        Map<GoodsType, Map<WorkLocation, Integer>> production = this.createProductionMap();
        this.updateGoodsTypeLists(production);
        this.updateRawMaterials(production);
        this.updateBuildableTypes();
        this.updatePlans(production);
    }

    private Map<GoodsType, Map<WorkLocation, Integer>> createProductionMap() {
        HashMap<GoodsType, Map<WorkLocation, Integer>> production = new HashMap<GoodsType, Map<WorkLocation, Integer>>();
        for (WorkLocation wl : this.colony.getAvailableWorkLocationsList()) {
            for (GoodsType g : this.spec().getGoodsTypeList()) {
                int p = wl.getGenericPotential(g);
                if (p <= 0) continue;
                HashMap<WorkLocation, Integer> m = (HashMap<WorkLocation, Integer>)production.get(g);
                if (m == null) {
                    m = new HashMap<WorkLocation, Integer>();
                    production.put(g, m);
                }
                m.put(wl, p);
            }
        }
        return production;
    }

    private void updateGoodsTypeLists(Map<GoodsType, Map<WorkLocation, Integer>> production) {
        this.libertyGoodsTypes.clear();
        this.immigrationGoodsTypes.clear();
        this.militaryGoodsTypes.clear();
        this.rawBuildingGoodsTypes.clear();
        this.buildingGoodsTypes.clear();
        this.rawLuxuryGoodsTypes.clear();
        this.otherRawGoodsTypes.clear();
        for (GoodsType g : new ArrayList<GoodsType>(production.keySet())) {
            if (g.isFoodType()) continue;
            if (g.isLibertyType()) {
                this.libertyGoodsTypes.add(g);
                continue;
            }
            if (g.isImmigrationType()) {
                this.immigrationGoodsTypes.add(g);
                continue;
            }
            if (g.getMilitary()) {
                this.militaryGoodsTypes.add(g);
                continue;
            }
            if (g.isRawBuildingMaterial()) {
                if (!g.isRawMaterialForUnstorableBuildingMaterial()) continue;
                this.rawBuildingGoodsTypes.add(g);
                continue;
            }
            if (g.isBuildingMaterial() && g.getInputType().isRawBuildingMaterial()) {
                if (g.isStorable()) continue;
                this.buildingGoodsTypes.add(g);
                continue;
            }
            if (g.isNewWorldGoodsType()) {
                this.rawLuxuryGoodsTypes.add(g);
                continue;
            }
            if (g.isRefined() && g.getInputType().isNewWorldGoodsType()) continue;
            if (g.isFarmed()) {
                this.otherRawGoodsTypes.add(g);
                continue;
            }
            logger.warning("Ignoring goods type " + g + " at " + this.colony.getName());
            production.remove(g);
        }
    }

    private void updateRawMaterials(Map<GoodsType, Map<WorkLocation, Integer>> production) {
        Player player = this.colony.getOwner();
        Market market = player.getMarket();
        NationType nationType = player.getNationType();
        GoodsType primaryRawMaterial = null;
        GoodsType secondaryRawMaterial = null;
        int primaryValue = -1;
        int secondaryValue = -1;
        this.produce.clear();
        ArrayList<GoodsType> rawMaterials = new ArrayList<GoodsType>(this.rawLuxuryGoodsTypes);
        rawMaterials.addAll(this.otherRawGoodsTypes);
        for (GoodsType g : rawMaterials) {
            int value = CollectionUtils.sum(production.get(g).entrySet(), Map.Entry::getValue);
            if (value <= 1) {
                production.remove(g);
                continue;
            }
            if (market != null) {
                if (g.getOutputType() == null) {
                    value *= market.getSalePrice(g, 1);
                } else if (production.containsKey(g.getOutputType())) {
                    value *= (market.getSalePrice(g, 1) + market.getSalePrice(g.getOutputType(), 1)) / 2;
                }
            }
            if (nationType.hasModifier(g.getId())) {
                value = value * 12 / 10;
            }
            if (value > secondaryValue && secondaryRawMaterial != null) {
                production.remove(secondaryRawMaterial);
                production.remove(secondaryRawMaterial.getOutputType());
                if (!this.rawLuxuryGoodsTypes.remove(secondaryRawMaterial)) {
                    this.otherRawGoodsTypes.remove(secondaryRawMaterial);
                }
            }
            if (value > primaryValue) {
                secondaryRawMaterial = primaryRawMaterial;
                secondaryValue = primaryValue;
                primaryRawMaterial = g;
                primaryValue = value;
                continue;
            }
            if (value <= secondaryValue) continue;
            secondaryRawMaterial = g;
            secondaryValue = value;
        }
        if (primaryRawMaterial != null) {
            this.produce.add(primaryRawMaterial);
            if (primaryRawMaterial.getOutputType() != null) {
                this.produce.add(primaryRawMaterial.getOutputType());
            }
            if (secondaryRawMaterial != null) {
                this.produce.add(secondaryRawMaterial);
                if (secondaryRawMaterial.getOutputType() != null) {
                    this.produce.add(secondaryRawMaterial.getOutputType());
                }
            }
        }
    }

    private BuildPlan findBuildPlan(BuildableType type) {
        return CollectionUtils.find(this.buildPlans, bp -> bp.type == type);
    }

    private boolean prioritize(BuildableType type, double weight, double support) {
        BuildPlan bp = this.findBuildPlan(type);
        if (bp == null) {
            this.buildPlans.add(new BuildPlan(type, weight, support));
            return true;
        }
        if (bp.weight * bp.support < weight * support) {
            bp.weight = weight;
            bp.support = support;
            return true;
        }
        return false;
    }

    private boolean prioritizeProduction(BuildableType type, GoodsType goodsType) {
        Player player = this.colony.getOwner();
        NationType nationType = player.getNationType();
        String advantage = this.getAIMain().getAIPlayer(player).getAIAdvantage();
        boolean ret = false;
        double factor = 1.0;
        if (nationType.hasModifier(goodsType.getId())) {
            factor *= 1.2;
        }
        if (goodsType.getMilitary()) {
            if ("conquest".equals(advantage)) {
                factor = 1.2;
            }
            ret = this.prioritize(type, 0.4 * factor, 1.0);
        } else if (goodsType.isBuildingMaterial() && !goodsType.isStorable()) {
            ret = this.prioritize(type, 0.9 * factor, 1.0);
        } else if (goodsType.isLibertyType()) {
            if (player.isREF()) {
                return false;
            }
            ret = this.prioritize(type, 0.75, this.colony.getSonsOfLiberty() >= 100 ? 0.01 : 1.0);
        } else if (goodsType.isImmigrationType()) {
            if ("immigration".equals(advantage)) {
                factor = 1.2;
            }
            ret = this.prioritize(type, 0.05 * factor, 1.0);
        } else if (this.produce.contains(goodsType)) {
            if ("trade".equals(advantage)) {
                factor = 1.2;
            }
            double f = 0.1 * (double)this.colony.getTotalProductionOf(goodsType.getInputType());
            ret = this.prioritize(type, 0.25 * factor, f);
        }
        return ret;
    }

    private void updateBuildableTypes() {
        int maxLevel;
        EuropeanAIPlayer euaip = (EuropeanAIPlayer)this.getAIMain().getAIPlayer(this.colony.getOwner());
        String advantage = euaip.getAIAdvantage();
        this.buildPlans.clear();
        switch (this.profileType) {
            case OUTPOST: 
            case SMALL: {
                maxLevel = 1;
                break;
            }
            case MEDIUM: {
                maxLevel = 2;
                break;
            }
            case LARGE: {
                maxLevel = 3;
                break;
            }
            case CAPITAL: {
                maxLevel = 4;
                break;
            }
            default: {
                throw new IllegalStateException("Bogus profile type: " + this.profileType);
            }
        }
        Player player = this.colony.getOwner();
        for (BuildingType type : CollectionUtils.transform(this.spec().getBuildingTypeList(), bt -> this.colony.canBuild((BuildableType)bt))) {
            GoodsType output;
            double factor;
            boolean expectFail = false;
            if (type.hasModifier("model.modifier.defence")) {
                factor = 1.0;
                if ("conquest".equals(advantage)) {
                    factor = 1.1;
                }
                this.prioritize(type, 0.3 * factor, 1.0);
            }
            if (type.hasAbility("model.ability.export")) {
                factor = 1.0;
                if ("trade".equals(advantage)) {
                    factor = 1.1;
                }
                this.prioritize(type, 0.6 * factor, 1.0);
            }
            if (type.getLevel() > maxLevel) continue;
            if (type.hasAbility("model.ability.produceInWater")) {
                factor = 0.0;
                if (!this.colony.hasAbility("model.ability.produceInWater") && this.colony.getTile().isShore()) {
                    int landFood = 0;
                    int seaFood = 0;
                    for (Tile t : CollectionUtils.transform(this.colony.getTile().getSurroundingTiles(1, 1), t2 -> t2.getOwningSettlement() == this.colony || player.canClaimForSettlement((Tile)t2))) {
                        for (AbstractGoods ag2 : t.getSortedPotential()) {
                            if (!ag2.isFoodType()) continue;
                            if (t.isLand()) {
                                landFood += ag2.getAmount();
                                continue;
                            }
                            seaFood += ag2.getAmount();
                        }
                    }
                    factor = seaFood + landFood == 0 ? 0.0 : (double)seaFood / (double)(seaFood + landFood);
                }
                this.prioritize(type, 0.25, factor);
            }
            if (type.hasAbility("model.ability.build")) {
                factor = "building".equals(advantage) ? 1.1 : 1.0;
                double support = CollectionUtils.any(type.getAbilities("model.ability.build"), Feature::hasScope) ? 0.1 : 1.0;
                this.prioritize(type, 0.9 * factor, support);
            }
            if (type.hasAbility("model.ability.teach")) {
                this.prioritize(type, 0.2, 1.0);
            }
            if (type.hasAbility("model.ability.repairUnits")) {
                factor = 1.0;
                if ("naval".equals(advantage)) {
                    factor = 1.1;
                }
                this.prioritize(type, 0.1 * factor, 1.0);
            }
            if ((output = type.getProducedGoodsType()) != null) {
                if (!this.prioritizeProduction(type, output)) {
                    expectFail = true;
                }
            } else {
                for (GoodsType g : this.spec().getGoodsTypeList()) {
                    if (!type.hasModifier(g.getId()) || this.prioritizeProduction(type, g)) continue;
                    expectFail = true;
                }
                if (type.hasModifier("model.modifier.warehouseStorage")) {
                    double factor2 = 1.0;
                    if ("trade".equals(advantage)) {
                        factor2 = 1.1;
                    }
                    this.prioritize(type, 0.85 * factor2, 1.0);
                }
                if (type.hasModifier("model.modifier.breedingDivisor")) {
                    this.prioritize(type, 0.1, 1.0);
                }
            }
            if (expectFail || this.findBuildPlan(type) != null) continue;
            logger.warning("No building priority found for: " + type);
        }
        double wagonNeed = 0.0;
        if (!this.colony.isConnectedPort()) {
            int wagons = euaip.getNeededWagons(this.colony.getTile());
            wagonNeed = wagons <= 0 ? 0.0 : (wagons > 3 ? 1.0 : (double)wagons / 3.0);
        }
        for (UnitType unitType : CollectionUtils.transform(this.spec().getUnitTypeList(), ut -> this.colony.canBuild((BuildableType)ut))) {
            if (unitType.hasAbility("model.ability.navalUnit")) continue;
            if (unitType.isDefensive()) {
                if (!euaip.needsMoreArtillery()) continue;
                this.prioritize(unitType, 0.1, 1.0);
                continue;
            }
            if (!(wagonNeed > 0.0) || !unitType.hasAbility("model.ability.carryGoods")) continue;
            double factor = 1.0;
            if ("trade".equals(advantage)) {
                factor = 1.1;
            }
            this.prioritize(unitType, 0.15 * factor, wagonNeed);
        }
        for (BuildPlan bp : this.buildPlans) {
            int difficulty = CollectionUtils.sum(bp.type.getRequiredGoods(), ag -> ag.getAmount() > this.colony.getGoodsCount(ag.getType()), ag -> {
                GoodsType type = ag.getType();
                return (ag.getAmount() - this.colony.getGoodsCount(type)) * (this.produce.contains(type.getInputType()) ? 1 : 5);
            });
            bp.difficulty = Math.max(1.0, Math.sqrt(difficulty));
        }
        this.buildPlans.sort(buildPlanComparator);
    }

    private void updatePlans(Map<GoodsType, Map<WorkLocation, Integer>> production) {
        this.workPlans.clear();
        Predicate fullPred = e -> {
            GoodsType g = (GoodsType)e.getKey();
            return !g.isStorable() || g.limitIgnored() || this.colony.getGoodsCount(g) < this.colony.getWarehouseCapacity();
        };
        CollectionUtils.forEachMapEntry(production, fullPred, e -> {
            for (WorkLocation wl : CollectionUtils.transform(((Map)e.getValue()).keySet(), w -> w.canBeWorked() || w.canAutoProduce())) {
                this.workPlans.add(new WorkLocationPlan(this.getAIMain(), wl, (GoodsType)e.getKey()));
            }
        });
        this.updateProductionList(production);
        ArrayList<WorkLocationPlan> oldPlans = new ArrayList<WorkLocationPlan>(this.workPlans);
        this.workPlans.clear();
        this.workPlans.addAll(CollectionUtils.transform(oldPlans, w -> w.getWorkLocation().canBeWorked()));
        Comparator<WorkLocationPlan> comp = CollectionUtils.cachingIntComparator(wp -> {
            GoodsType gt = wp.getGoodsType();
            int i = this.produce.indexOf(gt);
            return i < 0 && !gt.isFoodType() ? 99999 : i;
        }).thenComparingInt(wp -> wp.getWorkLocation().getGenericPotential(wp.getGoodsType()) * -1).thenComparing(WorkLocationPlan::getGoodsType, GoodsType.goodsTypeComparator);
        this.workPlans.sort(comp);
    }

    private void updateProductionList(Map<GoodsType, Map<WorkLocation, Integer>> production) {
        Comparator<GoodsType> productionComparator = CollectionUtils.cachingIntComparator(gt -> CollectionUtils.sum(((Map)production.get(gt)).values(), Integer::intValue)).reversed();
        if (this.colony.getSonsOfLiberty() < 100) {
            this.produce.addAll(0, CollectionUtils.transform(this.libertyGoodsTypes, gt -> production.containsKey(gt), Function.identity(), productionComparator));
        }
        this.rawBuildingGoodsTypes.sort(productionComparator);
        ToIntFunction<GoodsType> indexer = gt -> this.rawBuildingGoodsTypes.indexOf(gt.getInputType());
        ArrayList<GoodsType> toAdd = new ArrayList<GoodsType>();
        toAdd.addAll(CollectionUtils.transform(this.buildingGoodsTypes, gt -> production.containsKey(gt) && (this.colony.getGoodsCount(gt.getInputType()) >= 50 || production.containsKey(gt.getInputType())), Function.identity(), Comparator.comparingInt(indexer).reversed()));
        for (int i = toAdd.size() - 1; i >= 0; --i) {
            GoodsType make = (GoodsType)toAdd.get(i);
            GoodsType raw = make.getInputType();
            if (production.containsKey(raw)) {
                if (this.colony.getGoodsCount(raw) >= 50) {
                    this.produce.add(raw);
                    this.produce.add(0, make);
                    continue;
                }
                this.produce.add(0, make);
                this.produce.add(0, raw);
                continue;
            }
            this.produce.add(0, make);
        }
        this.produce.addAll(CollectionUtils.transform(this.militaryGoodsTypes, gt -> production.containsKey(gt), Function.identity(), productionComparator));
        if (this.colony.getOwner().getEurope() != null) {
            this.produce.addAll(CollectionUtils.transform(this.immigrationGoodsTypes, gt -> production.containsKey(gt), Function.identity(), productionComparator));
        }
    }

    private WorkLocationPlan findPlan(GoodsType goodsType, List<WorkLocationPlan> plans) {
        return CollectionUtils.find(plans, wlp -> wlp.getGoodsType() == goodsType);
    }

    protected static Unit getBestWorker(WorkLocation wl, GoodsType goodsType, List<Unit> workers) {
        GoodsType outputType;
        if (workers == null || workers.isEmpty()) {
            return null;
        }
        Colony colony = wl.getColony();
        GoodsType goodsType2 = outputType = goodsType.isStoredAs() ? goodsType.getStoredAs() : goodsType;
        if (workers.size() == 1) {
            Unit u = workers.get(0);
            if (!wl.canAdd(u)) {
                return null;
            }
            Location oldLoc = u.getLocation();
            GoodsType oldWork = u.getWorkType();
            u.setLocation(wl);
            u.changeWorkType(goodsType);
            int production = wl.getProductionOf(u, goodsType);
            u.setLocation(oldLoc);
            u.changeWorkType(oldWork);
            return production > 0 ? u : null;
        }
        ArrayList<Unit> todo = new ArrayList<Unit>(workers);
        ArrayList<Unit> best = new ArrayList<Unit>();
        int bestValue = colony.getAdjustedNetProductionOf(outputType);
        Unit special = null;
        best.clear();
        for (Unit u : CollectionUtils.transform(todo, u2 -> wl.canAdd((Locatable)u2))) {
            Location oldLoc = u.getLocation();
            GoodsType oldWork = u.getWorkType();
            u.setLocation(wl);
            u.changeWorkType(goodsType);
            int value = colony.getAdjustedNetProductionOf(outputType);
            if (value > bestValue) {
                bestValue = value;
                best.clear();
                best.add(u);
                if (u.getType().getExpertProduction() == goodsType) {
                    special = u;
                }
            } else if (value == bestValue && !best.isEmpty()) {
                best.add(u);
                if (u.getType().getExpertProduction() == goodsType) {
                    special = u;
                }
            }
            u.setLocation(oldLoc);
            u.changeWorkType(oldWork);
        }
        switch (best.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Unit)best.get(0);
            }
        }
        todo.clear();
        todo.addAll(best);
        if (special != null) {
            return special;
        }
        Specification spec = colony.getSpecification();
        UnitType expert = spec.getExpertForProducing(goodsType);
        best.clear();
        bestValue = Integer.MIN_VALUE;
        for (Unit u : todo) {
            int score;
            boolean relevant = u.getWorkType() == goodsType;
            int n = score = relevant ? u.getExperience() : -u.getExperience();
            if (expert != null && u.getUnitChange("model.unitChange.experience", expert) != null) {
                score += 10000;
            } else if (expert != null && u.getUnitChange("model.unitChange.experience") != null) {
                score -= 10000;
            }
            if (score > bestValue) {
                best.clear();
                best.add(u);
                bestValue = score;
                continue;
            }
            if (score != bestValue) continue;
            best.add(u);
        }
        switch (best.size()) {
            case 0: {
                break;
            }
            case 1: {
                return (Unit)best.get(0);
            }
            default: {
                todo.clear();
                todo.addAll(best);
            }
        }
        int worstSkill = Integer.MAX_VALUE;
        special = null;
        for (Unit u : todo) {
            if (u.getType().getSkill() >= worstSkill) continue;
            special = u;
            worstSkill = u.getType().getSkill();
        }
        return special;
    }

    private static boolean fullEquipUnit(Specification spec, Unit unit, Role role, Colony colony) {
        return colony.equipForRole(unit, role, role.getMaximumCount());
    }

    public Colony assignWorkers(List<Unit> workers, boolean preferScout, LogBuilder lb) {
        Comparator<Unit> comparator;
        Colony col;
        block46: {
            Iterator<Unit> goodsType;
            GoodsType foodType = this.spec().getPrimaryFoodType();
            List<GoodsType> produce = this.getPreferredProduction();
            List<WorkLocationPlan> foodPlans = this.getFoodPlans();
            List<WorkLocationPlan> workPlans = this.getWorkPlans();
            col = this.colony.copyColony();
            Tile tile = col.getTile();
            ArrayList<Unit> otherWorkers = new ArrayList<Unit>(workers);
            workers.clear();
            for (Unit unit : otherWorkers) {
                workers.add(col.getCorresponding(unit));
            }
            for (Unit unit : workers) {
                unit.setLocation(tile);
                col.equipForRole(unit, this.spec().getDefaultRole(), 0);
            }
            Role[] outdoorRoles = new Role[]{this.spec().getRoleWithAbility("model.ability.improveTerrain", null), null, this.spec().getRoleWithAbility("model.ability.speakWithChief", null)};
            if (preferScout) {
                Role role = outdoorRoles[1];
                outdoorRoles[1] = outdoorRoles[2];
                outdoorRoles[2] = role;
            }
            block2: for (Role outdoorRole : outdoorRoles) {
                block3: for (Unit u3 : new ArrayList<Unit>(workers)) {
                    if (workers.size() <= 1) continue block2;
                    Role role = outdoorRole;
                    if (role == null) {
                        for (Role r : u3.getSortedMilitaryRoles()) {
                            if (u3.getType() != r.getExpertUnit() || !ColonyPlan.fullEquipUnit(this.spec(), u3, r, col)) continue;
                            workers.remove(u3);
                            lb.add(u3.getId(), "(", u3.getType().getSuffix(), ") -> ", r.getSuffix(), "\n");
                            continue block3;
                        }
                        continue;
                    }
                    if (u3.getType() != role.getExpertUnit() || !ColonyPlan.fullEquipUnit(this.spec(), u3, role, col)) continue;
                    workers.remove(u3);
                    lb.add(u3.getId(), "(", u3.getType().getSuffix(), ") -> ", role.getSuffix(), "\n");
                }
            }
            comparator = Comparator.comparingInt(Unit::getSkillLevel).thenComparingInt(u -> u.getType().getExpertProduction() == null ? 1 : 0).thenComparingInt(u -> produce.indexOf(u.getType().getExpertProduction())).reversed().thenComparingInt(Unit::getExperience);
            ArrayList<AbstractGoods> buildGoods = new ArrayList<AbstractGoods>();
            BuildableType build = col.getCurrentlyBuilding();
            if (build != null) {
                buildGoods.addAll(build.getRequiredGoodsList());
            }
            boolean done = false;
            block5: while (!done && !workers.isEmpty()) {
                GoodsType raw;
                List<WorkLocationPlan> wlps = null;
                WorkLocationPlan wlp = null;
                if (col.getAdjustedNetProductionOf(foodType) > 0) {
                    wlps = workPlans;
                    while (!produce.isEmpty() && (wlp = this.findPlan(produce.get(0), workPlans)) == null) {
                        produce.remove(0);
                    }
                }
                while (true) {
                    if (wlp == null) {
                        if (foodPlans.isEmpty()) {
                            lb.add("    Food plans exhausted\n");
                            done = true;
                            continue block5;
                        }
                        wlps = foodPlans;
                        wlp = wlps.get(0);
                    }
                    String err = null;
                    goodsType = wlp.getGoodsType();
                    WorkLocation wl = col.getCorresponding(wlp.getWorkLocation());
                    Object best = null;
                    lb.add("    ", LogBuilder.wide(2, col.getUnitCount()), ": ", LogBuilder.wide(-15, ((FreeColObject)((Object)goodsType)).getSuffix()), "@", LogBuilder.wide(25, this.locationDescription(wl)), " => ");
                    if (!wl.canBeWorked()) {
                        err = "can not be worked";
                    } else if (wl.isFull()) {
                        err = "full";
                    } else {
                        best = ColonyPlan.getBestWorker(wl, goodsType, workers);
                        if (best == null) {
                            err = "no worker found";
                        }
                    }
                    if (err != null) {
                        wlps.remove(wlp);
                        lb.add(err, "\n");
                        continue block5;
                    }
                    ((Unit)best).setLocation(wl);
                    if (col.getProductionBonus() < 0) {
                        ((Unit)best).setLocation(tile);
                        done = true;
                        lb.add("    broke production bonus\n");
                        continue block5;
                    }
                    if (col.getAdjustedNetProductionOf(foodType) < 0) {
                        int net = col.getAdjustedNetProductionOf(foodType);
                        int count = col.getGoodsCount(foodType);
                        if (count / -net < 5) {
                            ((Unit)best).setLocation(tile);
                            wlp = null;
                            if (((GoodsType)((Object)goodsType)).isFoodType()) {
                                lb.add("    starvation (", count, "/", net, ")\n");
                                done = true;
                                continue block5;
                            }
                            lb.add("    would starve (", count, "/", net, ")\n");
                            continue;
                        }
                    }
                    raw = ((GoodsType)((Object)goodsType)).getInputType();
                    int rawNeeded = CollectionUtils.sum(buildGoods, ag -> ag.getType() == raw, AbstractGoods::getAmount);
                    if (raw == null || col.getAdjustedNetProductionOf(raw) >= 0 || (col.getGoodsCount(raw) - rawNeeded) / -col.getAdjustedNetProductionOf(raw) >= 5) {
                        ((Unit)best).changeWorkType((GoodsType)((Object)goodsType));
                        workers.remove(best);
                        lb.add("    ", ((FreeColObject)best).getId(), "(", ((Unit)best).getType().getSuffix(), ")\n");
                        if (((GoodsType)((Object)goodsType)).isFoodType() || !produce.remove(goodsType)) continue block5;
                        produce.add((GoodsType)((Object)goodsType));
                        continue block5;
                    }
                    ((Unit)best).setLocation(tile);
                    WorkLocationPlan rawWlp = this.findPlan(raw, workPlans);
                    if (rawWlp == null) break;
                    if (produce.remove(raw)) {
                        produce.add(0, raw);
                    }
                    wlp = rawWlp;
                    lb.add("    retry with ", raw.getSuffix(), "\n");
                }
                wlps.remove(wlp);
                produce.remove(goodsType);
                lb.add("    needs more ", raw.getSuffix(), "\n");
            }
            for (Unit u4 : workers) {
                if (u4.getLocation() == tile) continue;
                u4.setLocation(tile);
            }
            if (col.getUnitCount() == 0) {
                if (this.getFoodPlans().isEmpty()) {
                    for (WorkLocation wl : col.getAvailableWorkLocationsList()) {
                        for (Unit u2 : new ArrayList<Unit>(workers)) {
                            for (GoodsType type : this.libertyGoodsTypes) {
                                if (!wl.canAdd(u2) || wl.getPotentialProduction(type, u2.getType()) <= 0) continue;
                                u2.setLocation(wl);
                                u2.changeWorkType(type);
                                workers.remove(u2);
                                break block46;
                            }
                        }
                    }
                } else {
                    for (WorkLocationPlan w : this.getFoodPlans()) {
                        goodsType = w.getGoodsType();
                        WorkLocation wl = col.getCorresponding(w.getWorkLocation());
                        for (Unit u6 : new ArrayList<Unit>(workers)) {
                            GoodsType oldWork = u6.getWorkType();
                            u6.setLocation(wl);
                            u6.changeWorkType((GoodsType)((Object)goodsType));
                            if (col.getAdjustedNetProductionOf(foodType) >= 0) {
                                lb.add("    Subsist with ", u6, "\n");
                                workers.remove(u6);
                                break block46;
                            }
                            u6.setLocation(tile);
                            u6.changeWorkType(oldWork);
                        }
                    }
                }
            }
        }
        ArrayList<Unit> experts = new ArrayList<Unit>();
        ArrayList<Unit> nonExperts = new ArrayList<Unit>();
        for (Unit u5 : col.getUnitList()) {
            if (u5.getType().getExpertProduction() != null) {
                if (u5.getType().getExpertProduction() == u5.getWorkType()) continue;
                experts.add(u5);
                continue;
            }
            nonExperts.add(u5);
        }
        boolean expert = false;
        Iterator expertIterator = experts.iterator();
        while (expertIterator.hasNext()) {
            Unit u1 = (Unit)expertIterator.next();
            Unit other = u1.trySwapExpert(experts);
            if (other != null) {
                lb.add("    Swapped ", u1.getId(), "(", u1.getType().getSuffix(), ") for ", other, "\n");
                expertIterator.remove();
                continue;
            }
            other = u1.trySwapExpert(nonExperts);
            if (other == null) continue;
            lb.add("    Swapped ", u1.getId(), "(", u1.getType().getSuffix(), ") for ", other, "\n");
            expertIterator.remove();
        }
        for (Unit u7 : new ArrayList<Unit>(workers)) {
            Unit other;
            GoodsType work = u7.getType().getExpertProduction();
            if (work == null || (other = u7.trySwapExpert(col.getUnitList())) == null) continue;
            lb.add("    Swapped ", u7.getId(), "(", u7.getType().getSuffix(), ") for ", other, "\n");
            workers.remove(u7);
            workers.add(other);
        }
        block17: for (Unit u8 : CollectionUtils.sort(workers, comparator)) {
            if (u8.getSkillLevel() > 0) continue;
            for (Role role : u8.getSortedMilitaryRoles()) {
                if (!ColonyPlan.fullEquipUnit(this.spec(), u8, role, col)) continue;
                lb.add("    ", u8.getId(), "(", u8.getType().getSuffix(), ") -> ", u8.getRoleSuffix(), "\n");
                workers.remove(u8);
                continue block17;
            }
        }
        for (Unit u9 : CollectionUtils.transform(col.getUnits(), u -> !u.hasDefaultRole())) {
            logger.warning("assignWorkers bogus role for " + u9);
            u9.changeRole(this.spec().getDefaultRole(), 0);
        }
        for (Unit u10 : workers) {
            lb.add("    ", u10.getId(), "(", u10.getType().getSuffix(), ") -> UNUSED\n");
        }
        if (col.getUnitCount() <= 0) {
            col = null;
        }
        return col;
    }

    private String locationDescription(Location loc) {
        String name = this.colony.getName() + "-";
        String desc = loc.toShortString();
        if (desc.startsWith(name)) {
            desc = desc.substring(name.length(), desc.length());
        }
        return desc;
    }

    public String toString() {
        WorkLocation wl;
        LogBuilder lb = new LogBuilder(256);
        lb.add(new Object[]{"ColonyPlan: ", this.colony, " ", this.colony.getTile(), "\nProfile: ", this.profileType, "\nPreferred production:"});
        FreeColObject.logFreeColObjects(this.getPreferredProduction(), lb);
        lb.add("\n");
        lb.add(this.getBuildableReport(), "Food Plans:\n");
        for (WorkLocationPlan wlp : this.getFoodPlans()) {
            wl = wlp.getWorkLocation();
            lb.add(this.locationDescription(wl), ": ", wl.getGenericPotential(wlp.getGoodsType()), " ", wlp.getGoodsType().getSuffix(), "\n");
        }
        lb.add("Work Plans:\n");
        for (WorkLocationPlan wlp : this.getWorkPlans()) {
            wl = wlp.getWorkLocation();
            lb.add(this.locationDescription(wl), ": ", wl.getGenericPotential(wlp.getGoodsType()), " ", wlp.getGoodsType().getSuffix(), "\n");
        }
        return lb.toString();
    }

    private static enum ProfileType {
        OUTPOST,
        SMALL,
        MEDIUM,
        LARGE,
        CAPITAL;


        public static ProfileType getProfileTypeFromSize(int size) {
            return size <= 1 ? OUTPOST : (size <= 2 ? SMALL : (size <= 4 ? MEDIUM : (size <= 8 ? LARGE : CAPITAL)));
        }
    }

    private static class BuildPlan {
        public final BuildableType type;
        public double weight;
        public double support;
        public double difficulty;

        public BuildPlan(BuildableType type, double weight, double support) {
            this.type = type;
            this.weight = weight;
            this.support = support;
            this.difficulty = 1.0;
        }

        public double getValue() {
            return this.weight * this.support / this.difficulty;
        }

        public String toString() {
            return String.format("%s (%1.3f * %1.3f / %1.3f = %1.3f)", this.type.getSuffix(), this.weight, this.support, this.difficulty, this.getValue());
        }
    }
}

