/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.metaserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.metaserver.ServerInfo;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.ConnectionVerificationMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.RegisterServerMessage;
import net.sf.freecol.common.networking.RemoveServerMessage;
import net.sf.freecol.common.networking.ServerListMessage;
import net.sf.freecol.common.networking.UpdateServerMessage;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;

public class MetaServerUtils {
    private static final long METASERVER_REPLY_TIMEOUT = 10000L;
    private static final Logger logger = Logger.getLogger(MetaServerUtils.class.getName());
    private static final int UPDATE_INTERVAL = 60000;
    private static final ServerInfo sentinel = new ServerInfo(null, null, -1, -1, -1, false, null, -1);
    private static Map<Timer, ServerInfo> updaters = Collections.synchronizedMap(new HashMap());

    private static Timer findTimer(ServerInfo si) {
        Map.Entry entry = CollectionUtils.find(updaters.entrySet(), CollectionUtils.matchKeyEquals(si.getName(), e -> ((ServerInfo)e.getValue()).getName()));
        return entry == null ? null : (Timer)entry.getKey();
    }

    private static boolean startTimer(ServerInfo si) {
        final Timer t = new Timer(true);
        updaters.put(t, si);
        t.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ServerInfo si = updaters.get(t);
                if (si == null) {
                    this.cancel();
                } else {
                    MetaServerUtils.updateServer(si);
                }
            }
        }, 60000L, 60000L);
        return true;
    }

    private static boolean updateTimer(ServerInfo si) {
        Timer t = MetaServerUtils.findTimer(si);
        if (t == null) {
            return false;
        }
        updaters.put(t, si);
        return true;
    }

    private static boolean stopTimer(ServerInfo si) {
        Timer t = MetaServerUtils.findTimer(si);
        if (t == null) {
            return false;
        }
        t.cancel();
        updaters.remove(t);
        return true;
    }

    private static Connection getMetaServerConnection(List<ServerInfo> lsi) {
        Consumer<List<ServerInfo>> consumer = l -> {};
        if (lsi != null) {
            lsi.clear();
            lsi.add(sentinel);
            consumer = l -> {
                lsi.clear();
                if (lsi != null) {
                    lsi.addAll((Collection<ServerInfo>)l);
                }
            };
        }
        String host = FreeCol.getMetaServerAddress();
        int port = FreeCol.getMetaServerPort();
        try {
            Connection c = new Connection(host, port, "MetaServer").setMessageHandler(new MetaInputHandler(consumer));
            c.startReceiving();
            return c;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Could not connect to meta-server: " + host + ":" + port, ioe);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean metaMessage(MetaMessageType type, ServerInfo si) {
        try (Connection mc = MetaServerUtils.getMetaServerConnection(null);){
            switch (type) {
                case REGISTER: {
                    MetaServerUtils.startTimer(si);
                    if (mc != null) {
                        ConnectionVerificationMessage reply = (ConnectionVerificationMessage)mc.askMessage(new RegisterServerMessage(si), 10000L);
                        boolean bl = reply.isConnectable();
                        return bl;
                    }
                }
                case REMOVE: {
                    MetaServerUtils.stopTimer(si);
                    if (mc != null) {
                        mc.sendMessage(new RemoveServerMessage(si));
                    }
                    boolean bl = true;
                    return bl;
                }
                case UPDATE: {
                    MetaServerUtils.updateTimer(si);
                    if (mc != null) {
                        mc.sendMessage(new UpdateServerMessage(si));
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            logger.log(Level.WARNING, "Wrong metaMessage type: " + type);
            return true;
        }
        catch (IOException | TimeoutException | XMLStreamException | FreeColException ex) {
            logger.log(Level.WARNING, "Meta message " + type + " failure.", ex);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ServerInfo> getServerList() {
        ArrayList<ServerInfo> lsi = new ArrayList<ServerInfo>();
        ArrayList<ServerInfo> ret = null;
        Connection mc = MetaServerUtils.getMetaServerConnection(lsi);
        if (mc == null) {
            logger.warning("Could not connect to metaserver.");
            return null;
        }
        try {
            mc.sendMessage(new ServerListMessage());
            int MAXTRIES = 5;
            int SLEEP_TIME = 1000;
            for (int n = 5; n > 0; --n) {
                if (lsi.size() != 1 || lsi.get(0) != sentinel) {
                    ret = new ArrayList<ServerInfo>(lsi);
                    break;
                }
                Utils.delay(1000L, "Delay interrupted");
            }
            if (ret == null) {
                logger.warning("No response from metaserver.");
            }
        }
        catch (IOException | XMLStreamException | FreeColException ex) {
            logger.log(Level.WARNING, "Get server list failure", ex);
        }
        finally {
            mc.close();
        }
        return ret;
    }

    public static boolean registerServer(ServerInfo si) {
        return MetaServerUtils.metaMessage(MetaMessageType.REGISTER, si);
    }

    public static boolean removeServer(ServerInfo si) {
        return MetaServerUtils.metaMessage(MetaMessageType.REMOVE, si);
    }

    public static boolean updateServer(ServerInfo si) {
        return MetaServerUtils.metaMessage(MetaMessageType.UPDATE, si);
    }

    private static enum MetaMessageType {
        REGISTER,
        REMOVE,
        SERVERLIST,
        UPDATE;

    }

    public static class MetaInputHandler
    implements MessageHandler {
        private static final Logger logger = Logger.getLogger(MetaInputHandler.class.getName());
        public final Consumer<List<ServerInfo>> consumer;

        public MetaInputHandler(Consumer<List<ServerInfo>> consumer) {
            this.consumer = consumer;
        }

        @Override
        public Message handle(Connection connection, Message message) throws FreeColException {
            String tag;
            if (message == null) {
                return null;
            }
            switch (tag = message.getType()) {
                case "disconnect": {
                    break;
                }
                case "serverList": {
                    ServerListMessage slm = (ServerListMessage)message;
                    this.consumer.accept(slm.getServers());
                    break;
                }
                default: {
                    logger.warning("MetaInputHandler does not handle: " + tag);
                }
            }
            return null;
        }

        @Override
        public Message read(Connection connection) throws FreeColException, XMLStreamException {
            return Message.read(null, connection.getFreeColXMLReader());
        }
    }
}

