/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.keys;

import java.io.FileInputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CreateKeyInfo {
    public static void main(String[] stringArray) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileInputStream = new FileInputStream("data/org/apache/xml/security/samples/input/keystore.jks");
        keyStore.load(fileInputStream, "xmlsecurity".toCharArray());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        KeyInfo keyInfo = new KeyInfo(document);
        document.appendChild(keyInfo.getElement());
        keyInfo.setId("myKI");
        keyInfo.addKeyName("A simple key");
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate("test");
        keyInfo.addKeyValue(x509Certificate.getPublicKey());
        X509Data x509Data = new X509Data(document);
        keyInfo.add(x509Data);
        x509Data.addCertificate(x509Certificate);
        x509Data.addSubjectName("Subject name");
        x509Data.addIssuerSerial("Subject nfsdfhs", 6786);
        keyInfo.add(new RSAKeyValue(document, new BigInteger("678"), new BigInteger("6870")));
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)System.out);
    }
}

