/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.querypen;

import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.query.Item;
import ca.sqlpower.swingui.querypen.CleanupPNode;
import ca.sqlpower.swingui.querypen.EditStyledTextListener;
import ca.sqlpower.swingui.querypen.EditablePStyledText;
import ca.sqlpower.swingui.querypen.EditablePStyledTextWithOptionBox;
import ca.sqlpower.swingui.querypen.JoinLine;
import ca.sqlpower.swingui.querypen.MouseState;
import ca.sqlpower.swingui.querypen.QueryPen;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolox.nodes.PStyledText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class UnmodifiableItemPNode
extends PNode
implements CleanupPNode {
    private static final Logger logger = Logger.getLogger(UnmodifiableItemPNode.class);
    private static final double WHERE_BUFFER = 5.0;
    private static final String WHERE_START_TEXT = "        ";
    private final Item item;
    private final EditablePStyledText columnText;
    private final EditablePStyledTextWithOptionBox whereText;
    private final JCheckBox isInSelectCheckBox;
    private boolean isJoined = false;
    private boolean isInJoiningState = false;
    private List<JoinLine> joinedLines;
    private final Collection<PropertyChangeListener> queryChangeListeners;
    private EditStyledTextListener editingTextListener = new EditStyledTextListener(){
        private boolean editing = false;

        @Override
        public void editingStopping() {
            String alias = UnmodifiableItemPNode.this.item.getAlias();
            if (this.editing) {
                JEditorPane nameEditor = UnmodifiableItemPNode.this.columnText.getEditorPane();
                alias = nameEditor.getText();
                if (nameEditor.getText() == null || nameEditor.getText().length() <= 0 || nameEditor.getText().equals(UnmodifiableItemPNode.this.item.getName())) {
                    alias = "";
                }
                logger.debug((Object)("editor has text " + nameEditor.getText() + " alias is " + alias));
            }
            if (UnmodifiableItemPNode.this.isJoined) {
                UnmodifiableItemPNode.this.highLightText();
            }
            UnmodifiableItemPNode.this.item.setAlias(alias);
            if (this.editing) {
                UnmodifiableItemPNode.this.setVisibleAliasText();
            }
            this.editing = false;
        }

        @Override
        public void editingStarting() {
            this.editing = true;
            if (UnmodifiableItemPNode.this.item.getAlias() != null && UnmodifiableItemPNode.this.item.getAlias().length() > 0) {
                UnmodifiableItemPNode.this.columnText.getEditorPane().setText(UnmodifiableItemPNode.this.item.getAlias());
                logger.debug((Object)("Setting editor text to " + UnmodifiableItemPNode.this.item.getAlias()));
            }
        }
    };
    private EditStyledTextListener whereTextListener = new EditStyledTextListener(){

        @Override
        public void editingStopping() {
            UnmodifiableItemPNode.this.item.setWhere(UnmodifiableItemPNode.this.getWhereText());
        }

        @Override
        public void editingStarting() {
        }
    };
    private PropertyChangeListener itemChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selected")) {
                UnmodifiableItemPNode.this.isInSelectCheckBox.setSelected(UnmodifiableItemPNode.this.item.isSelected());
            } else if (evt.getPropertyName().equals("alias")) {
                UnmodifiableItemPNode.this.setVisibleAliasText();
            } else if (evt.getPropertyName().equals("where") && !UnmodifiableItemPNode.this.item.getWhere().equals(UnmodifiableItemPNode.this.whereText.getEditorPane().getText().trim())) {
                UnmodifiableItemPNode.this.whereText.getEditorPane().setText(UnmodifiableItemPNode.this.item.getWhere());
                UnmodifiableItemPNode.this.fillWithSpaces();
                UnmodifiableItemPNode.this.whereText.syncWithDocument();
                UnmodifiableItemPNode.this.whereText.repaint();
            }
            for (PropertyChangeListener l : UnmodifiableItemPNode.this.queryChangeListeners) {
                l.propertyChange(evt);
            }
        }
    };
    private PSwing swingCheckBox;
    private final QueryPen queryPen;
    private final SPVariableHelper variablesHelper;

    private void fillWithSpaces() {
        if (this.whereText.getEditorPane().getText() == null || this.whereText.getEditorPane().getText().trim().equals("")) {
            this.whereText.getEditorPane().setText(WHERE_START_TEXT);
        } else if (this.whereText.getEditorPane().getText().length() < WHERE_START_TEXT.length()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < WHERE_START_TEXT.length() - this.whereText.getEditorPane().getText().length(); ++i) {
                sb.append(" ");
            }
            this.whereText.getEditorPane().setText(this.whereText.getEditorPane().getText() + sb.toString());
        }
    }

    public void highLightText() {
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        if (this.isJoined) {
            StyleConstants.setForeground(attributeSet, Color.blue);
        } else {
            StyleConstants.setForeground(attributeSet, Color.black);
        }
        DefaultStyledDocument doc = (DefaultStyledDocument)this.columnText.getDocument();
        doc.setCharacterAttributes(0, doc.getLength(), attributeSet, false);
        this.columnText.repaint();
        this.columnText.syncWithDocument();
    }

    public void JoinTo(JoinLine line) {
        this.joinedLines.add(line);
        this.setIsJoined(true);
        this.isInJoiningState = false;
    }

    public void setJoiningState(boolean state) {
        if (!state) {
            this.setPaint(new Color(0xFFFFFF, true));
            this.repaint();
        }
        this.isInJoiningState = state;
    }

    public List<JoinLine> getJoinedLines() {
        return this.joinedLines;
    }

    public void removeJoinedLine(JoinLine line) {
        this.joinedLines.remove(line);
        if (this.joinedLines.isEmpty()) {
            this.setIsJoined(false);
        }
    }

    public UnmodifiableItemPNode(QueryPen mouseStates, PCanvas canvas, Item i) {
        this(mouseStates, canvas, i, null);
    }

    public UnmodifiableItemPNode(QueryPen mouseStates, PCanvas canvas, Item i, SPVariableHelper newVariablesHelper) {
        this.item = i;
        this.variablesHelper = newVariablesHelper;
        this.item.addPropertyChangeListener(this.itemChangeListener);
        this.queryPen = mouseStates;
        this.queryChangeListeners = new ArrayList<PropertyChangeListener>();
        this.joinedLines = new ArrayList<JoinLine>();
        this.isInSelectCheckBox = new JCheckBox();
        this.isInSelectCheckBox.setOpaque(false);
        this.swingCheckBox = new PSwing((JComponent)this.isInSelectCheckBox);
        this.addChild((PNode)this.swingCheckBox);
        this.isInSelectCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UnmodifiableItemPNode.this.isInSelectCheckBox.isSelected()) {
                    UnmodifiableItemPNode.this.queryPen.getModel().selectItem(UnmodifiableItemPNode.this.item);
                } else {
                    UnmodifiableItemPNode.this.queryPen.getModel().unselectItem(UnmodifiableItemPNode.this.item);
                }
            }
        });
        this.columnText = new EditablePStyledText(this.item.getName(), this.queryPen, canvas);
        this.columnText.addEditStyledTextListener(this.editingTextListener);
        double textYTranslation = (this.swingCheckBox.getFullBounds().height - this.columnText.getFullBounds().height) / 2.0;
        this.columnText.translate(this.swingCheckBox.getFullBounds().width, textYTranslation);
        this.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mouseEntered(PInputEvent event) {
                if (UnmodifiableItemPNode.this.queryPen.getMouseState().equals((Object)MouseState.MouseStates.CREATE_JOIN)) {
                    UnmodifiableItemPNode.this.setPaint(Color.GRAY);
                    UnmodifiableItemPNode.this.repaint();
                }
            }

            public void mouseExited(PInputEvent event) {
                if (!UnmodifiableItemPNode.this.isInJoiningState) {
                    UnmodifiableItemPNode.this.setPaint(new Color(0xFFFFFF, true));
                    UnmodifiableItemPNode.this.repaint();
                }
            }
        });
        this.addChild((PNode)this.columnText);
        this.whereText = new EditablePStyledTextWithOptionBox(WHERE_START_TEXT, this.queryPen, canvas, WHERE_START_TEXT.length(), this.variablesHelper);
        this.whereText.addEditStyledTextListener(this.whereTextListener);
        this.whereText.translate(0.0, textYTranslation);
        this.addChild((PNode)this.whereText);
        logger.debug((Object)("Pnode " + this.item.getName() + " created."));
        this.setWidth(this.getFullBounds().getWidth());
        this.setHeight(this.getFullBounds().getHeight());
        this.isInSelectCheckBox.setSelected(this.item.isSelected());
        if (this.item.getWhere().trim().length() > 0) {
            this.whereText.getEditorPane().setText(this.item.getWhere());
            this.whereText.syncWithDocument();
        }
        this.setVisibleAliasText();
    }

    private void setVisibleAliasText() {
        JEditorPane nameEditor = this.columnText.getEditorPane();
        if (this.item.getAlias() == null || this.item.getAlias().trim().length() <= 0) {
            logger.debug((Object)("item name is " + this.item.getName()));
            nameEditor.setText(this.item.getName());
        } else {
            nameEditor.setText(this.item.getAlias() + " (" + this.item.getName() + ")");
        }
        this.columnText.syncWithDocument();
    }

    public void setIsJoined(boolean joined) {
        this.isJoined = joined;
        this.setPaint(new Color(0xFFFFFF, true));
        this.repaint();
        this.highLightText();
    }

    public Item getItem() {
        return this.item;
    }

    public PStyledText getItemText() {
        return this.columnText;
    }

    public PStyledText getWherePStyledText() {
        return this.whereText;
    }

    public String getWhereText() {
        String text = this.whereText.getEditorPane().getText();
        if (text.equals(WHERE_START_TEXT)) {
            return "";
        }
        return text;
    }

    public void setInSelected(boolean selected) {
        this.isInSelectCheckBox.setSelected(selected);
        if (selected) {
            this.queryPen.getModel().selectItem(this.item);
        } else {
            this.queryPen.getModel().unselectItem(this.item);
        }
    }

    public boolean isInSelect() {
        return this.isInSelectCheckBox.isSelected();
    }

    public void addQueryChangeListener(PropertyChangeListener l) {
        this.queryChangeListeners.add(l);
    }

    public void removeQueryChangeListener(PropertyChangeListener l) {
        this.queryChangeListeners.remove(l);
    }

    public double getDistanceForWhere() {
        return this.swingCheckBox.getFullBounds().width + this.columnText.getWidth() + 5.0;
    }

    public void positionWhere(double xpos) {
        logger.debug((Object)("Moving where text: xpos = " + xpos + ", text x position = " + this.whereText.getFullBounds().getX() + " x offset " + this.whereText.getXOffset()));
        this.whereText.translate(xpos - this.whereText.getXOffset(), 0.0);
        this.setWidth(this.getFullBounds().getWidth());
        this.setHeight(this.getFullBounds().getHeight());
    }

    @Override
    public void cleanup() {
        this.item.removePropertyChangeListener(this.itemChangeListener);
    }

    public Item getModel() {
        return this.item;
    }
}

