/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.ParametersWithContext;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.DigestUtils;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;

public class HashMLDSASigner
implements Signer {
    private static final byte[] EMPTY_CONTEXT = new byte[0];
    private MLDSAPublicKeyParameters pubKey;
    private MLDSAPrivateKeyParameters privKey;
    private SecureRandom random;
    private MLDSAEngine engine;
    private Digest digest;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        Object object;
        Object object2;
        byte[] byArray = EMPTY_CONTEXT;
        if (cipherParameters instanceof ParametersWithContext) {
            object2 = (ParametersWithContext)cipherParameters;
            byArray = ((ParametersWithContext)object2).getContext();
            cipherParameters = ((ParametersWithContext)object2).getParameters();
            if (byArray.length > 255) {
                throw new IllegalArgumentException("context too long");
            }
        }
        if (bl) {
            this.pubKey = null;
            if (cipherParameters instanceof ParametersWithRandom) {
                object = (ParametersWithRandom)cipherParameters;
                this.privKey = (MLDSAPrivateKeyParameters)((ParametersWithRandom)object).getParameters();
                this.random = ((ParametersWithRandom)object).getRandom();
            } else {
                this.privKey = (MLDSAPrivateKeyParameters)cipherParameters;
                this.random = null;
            }
            object2 = this.privKey.getParameters();
            this.engine = ((MLDSAParameters)object2).getEngine(this.random);
            this.engine.initSign(this.privKey.tr, true, byArray);
        } else {
            this.pubKey = (MLDSAPublicKeyParameters)cipherParameters;
            this.privKey = null;
            this.random = null;
            object2 = this.pubKey.getParameters();
            this.engine = ((MLDSAParameters)object2).getEngine(null);
            this.engine.initVerify(this.pubKey.rho, this.pubKey.t1, true, byArray);
        }
        this.digest = this.engine.shake256Digest;
        try {
            object = DigestUtils.getDigestOid(this.digest.getAlgorithmName()).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalStateException("oid encoding failed: " + iOException.getMessage());
        }
        this.digest.update((byte[])object, 0, ((Object)object).length);
    }

    @Override
    public void update(byte by) {
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        byte[] byArray = new byte[32];
        if (this.random != null) {
            this.random.nextBytes(byArray);
        }
        byte[] byArray2 = this.engine.generateMu(this.engine.shake256Digest);
        return this.engine.generateSignature(byArray2, this.engine.getShake256Digest(), this.privKey.rho, this.privKey.k, this.privKey.t0, this.privKey.s1, this.privKey.s2, byArray);
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        byte[] byArray2 = this.engine.generateMu(this.engine.shake256Digest);
        return this.engine.verifyInternalMuSignature(byArray2, byArray, byArray.length, this.engine.getShake256Digest(), this.pubKey.rho, this.pubKey.t1);
    }

    @Override
    public void reset() {
        this.digest.reset();
    }
}

