/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry.validator;

import java.util.List;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.util.ValidatorUtils;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.job.entry.validator.JobEntryValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerValidator
implements JobEntryValidator {
    public static final IntegerValidator INSTANCE = new IntegerValidator();
    private String VALIDATOR_NAME = "integer";

    @Override
    public boolean validate(CheckResultSourceInterface source, String propertyName, List<CheckResultInterface> remarks, ValidatorContext context) {
        Integer result = null;
        String value = null;
        value = ValidatorUtils.getValueAsString((Object)source, (String)propertyName);
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        result = GenericTypeValidator.formatInt((String)value);
        if (result == null) {
            JobEntryValidatorUtils.addFailureRemark(source, propertyName, this.VALIDATOR_NAME, remarks, JobEntryValidatorUtils.getLevelOnFail(context, this.VALIDATOR_NAME));
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return this.VALIDATOR_NAME;
    }
}

