/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.zaproxy.zap.utils.Enableable;

public class StructuralNodeModifier
extends Enableable
implements Cloneable {
    private static final String CONFIG_NAME = "name";
    private static final String CONFIG_TYPE = "type";
    private static final String CONFIG_PATTERN = "pattern";
    private Type type;
    private Pattern pattern;
    private String name;

    public StructuralNodeModifier(Type type, Pattern pattern, String name) {
        this.type = type;
        this.pattern = pattern;
        this.name = name;
    }

    public StructuralNodeModifier(String config) {
        JSONObject json = JSONObject.fromObject(config);
        this.name = json.getString(CONFIG_NAME);
        this.type = Type.valueOf(json.getString(CONFIG_TYPE));
        if (json.containsKey(CONFIG_TYPE)) {
            this.pattern = Pattern.compile(json.getString(CONFIG_PATTERN));
        }
    }

    public Type getType() {
        return this.type;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StructuralNodeModifier clone() {
        return new StructuralNodeModifier(this.type, Pattern.compile(this.pattern.toString()), this.name);
    }

    public String getConfig() {
        JSONObject json = new JSONObject();
        json.put(CONFIG_TYPE, this.getType().name());
        json.put(CONFIG_NAME, this.getName());
        if (this.getPattern() != null) {
            json.put(CONFIG_PATTERN, this.getPattern().pattern());
        }
        return json.toString();
    }

    public static enum Type {
        DataDrivenNode,
        StructuralParameter;

    }
}

