/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.item;

import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;

public interface IItemCollection
extends Iterable<IItemIterable> {
    public IItemCollection apply(IItemFilter var1);

    public <V, C extends IItemConsumer<C>> V getAggregate(IAggregator<V, C> var1);

    public boolean hasItems();

    @Deprecated
    public Set<IRange<IQuantity>> getUnfilteredTimeRanges();

    default public Stream<IItemIterable> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<IItemIterable> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    default public <T> Supplier<Stream<T>> values(IAttribute<T> attribute) {
        return () -> this.stream().flatMap(itemStream -> {
            IMemberAccessor accessor = attribute.getAccessor(itemStream.getType());
            if (accessor != null) {
                return itemStream.stream().map(accessor::getMember);
            }
            return Stream.empty();
        });
    }
}

