/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.BaseMatcher;
import org.eclipse.californium.core.network.EndpointReceiver;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.KeyMID;
import org.eclipse.californium.core.network.KeyToken;
import org.eclipse.californium.core.network.MessageExchangeStore;
import org.eclipse.californium.core.network.RemoveHandler;
import org.eclipse.californium.core.network.TokenGenerator;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UdpMatcher
extends BaseMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpMatcher.class);
    private final RemoveHandler exchangeRemoveHandler = new RemoveHandlerImpl();
    private final EndpointContextMatcher endpointContextMatcher;

    public UdpMatcher(NetworkConfig config, NotificationListener notificationListener, TokenGenerator tokenGenerator, ObservationStore observationStore, MessageExchangeStore exchangeStore, Executor executor, EndpointContextMatcher matchingStrategy) {
        super(config, notificationListener, tokenGenerator, observationStore, exchangeStore, executor);
        this.endpointContextMatcher = matchingStrategy;
    }

    @Override
    public void sendRequest(Exchange exchange) {
        Request request = exchange.getCurrentRequest();
        if (request.isObserve() && 0 == exchange.getFailedTransmissionCount()) {
            if (this.exchangeStore.assignMessageId(request) != -1) {
                this.registerObserve(request);
            } else {
                LOGGER.warn("message IDs exhausted, could not register outbound observe request for tracking");
                request.setSendError(new IllegalStateException("automatic message IDs exhausted"));
                return;
            }
        }
        try {
            if (this.exchangeStore.registerOutboundRequest(exchange)) {
                exchange.setRemoveHandler(this.exchangeRemoveHandler);
                LOGGER.debug("tracking open request [{}, {}]", (Object)exchange.getKeyMID(), (Object)exchange.getKeyToken());
            } else {
                LOGGER.warn("message IDs exhausted, could not register outbound request for tracking");
                request.setSendError(new IllegalStateException("automatic message IDs exhausted"));
            }
        }
        catch (IllegalArgumentException ex) {
            request.setSendError(ex);
        }
    }

    @Override
    public void sendResponse(Exchange exchange) {
        boolean ready = true;
        Response response = exchange.getCurrentResponse();
        response.ensureToken(exchange.getCurrentRequest().getToken());
        if (response.getType() == CoAP.Type.CON) {
            exchange.removeNotifications();
            this.exchangeStore.registerOutboundResponse(exchange);
            LOGGER.debug("tracking open response [{}]", (Object)exchange.getKeyMID());
            ready = false;
        } else if (response.getType() == CoAP.Type.NON) {
            if (response.isNotification()) {
                this.exchangeStore.registerOutboundResponse(exchange);
                ready = false;
            } else {
                this.exchangeStore.assignMessageId(response);
            }
        }
        if (ready) {
            exchange.setComplete();
        }
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        message.setToken(Token.EMPTY);
        if (message.getType() == CoAP.Type.RST && exchange != null) {
            exchange.executeComplete();
        }
    }

    @Override
    public void receiveRequest(final Request request, final EndpointReceiver receiver) {
        boolean duplicate;
        Exchange exchange;
        KeyMID idByMID = new KeyMID(request.getMID(), this.endpointContextMatcher.getEndpointIdentity(request.getSourceContext()));
        final Exchange previous = this.exchangeStore.findPrevious(idByMID, exchange = new Exchange(request, Exchange.Origin.REMOTE, this.executor));
        boolean bl = duplicate = previous != null;
        if (duplicate) {
            EndpointContext sourceContext = request.getSourceContext();
            Request previousRequest = previous.getCurrentRequest();
            EndpointContext previousSourceContext = previous.getOrigin() == Exchange.Origin.REMOTE ? previousRequest.getSourceContext() : previousRequest.getDestinationContext();
            duplicate = this.endpointContextMatcher.isToBeSent(previousSourceContext, sourceContext);
            if (!duplicate) {
                if (this.exchangeStore.replacePrevious(idByMID, previous, exchange)) {
                    LOGGER.debug("replaced request {} by new request {}!", (Object)previousRequest, (Object)request);
                } else {
                    LOGGER.warn("new request {} could not be registered! Deduplication disabled!", (Object)request);
                }
            } else if (previousRequest.isMulticast() || request.isMulticast()) {
                InetSocketAddress previousGroup;
                InetSocketAddress group = request.getDestinationContext() == null ? null : request.getDestinationContext().getPeerAddress();
                InetSocketAddress inetSocketAddress = previousGroup = previousRequest.getDestinationContext() == null ? null : previousRequest.getDestinationContext().getPeerAddress();
                if (!(group == previousGroup || group != null && group.equals(previousGroup))) {
                    LOGGER.warn("received request {} via different multicast groups ({} != {})!", new Object[]{request, StringUtil.toString((InetSocketAddress)group), StringUtil.toString((InetSocketAddress)previousGroup)});
                }
            }
        }
        if (duplicate) {
            LOGGER.trace("duplicate request: {}", (Object)request);
            request.setDuplicate(true);
            previous.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            receiver.receiveRequest(previous, request);
                        }
                        catch (RuntimeException ex) {
                            LOGGER.warn("error receiving request {} again!", (Object)request, (Object)ex);
                            if (request.isMulticast()) break block2;
                            receiver.reject(request);
                        }
                    }
                }
            });
        } else {
            exchange.setRemoveHandler(this.exchangeRemoveHandler);
            exchange.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            receiver.receiveRequest(exchange, request);
                        }
                        catch (RuntimeException ex) {
                            LOGGER.warn("error receiving request {}", (Object)request, (Object)ex);
                            if (request.isMulticast()) break block2;
                            receiver.reject(request);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void receiveResponse(final Response response, final EndpointReceiver receiver) {
        final Object peer = this.endpointContextMatcher.getEndpointIdentity(response.getSourceContext());
        final KeyToken idByToken = this.tokenGenerator.getKeyToken(response.getToken(), peer);
        LOGGER.trace("received response {} from {}", (Object)response, (Object)response.getSourceContext());
        Exchange tempExchange = this.exchangeStore.get(idByToken);
        if (tempExchange == null) {
            KeyMID idByMID;
            Exchange prev;
            if (response.getType() != CoAP.Type.ACK && (prev = this.exchangeStore.find(idByMID = new KeyMID(response.getMID(), peer))) != null) {
                prev.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (prev.getCurrentRequest().isMulticast()) {
                            LOGGER.debug("Ignore delayed response {} to multicast request {}", (Object)response, (Object)prev.getCurrentRequest().getDestinationContext().getPeerAddress());
                            UdpMatcher.this.cancel(response, receiver);
                            return;
                        }
                        try {
                            if (UdpMatcher.this.endpointContextMatcher.isResponseRelatedToRequest(prev.getEndpointContext(), response.getSourceContext())) {
                                LOGGER.trace("received response {} for already completed {}", (Object)response, (Object)prev);
                                response.setDuplicate(true);
                                Response prevResponse = prev.getCurrentResponse();
                                if (prevResponse != null) {
                                    response.setRejected(prevResponse.isRejected());
                                }
                                receiver.receiveResponse(prev, response);
                                return;
                            }
                            LOGGER.debug("ignoring potentially forged response {} for already completed {}", (Object)response, (Object)prev);
                        }
                        catch (RuntimeException ex) {
                            LOGGER.warn("error receiving response {} for {}", new Object[]{response, prev, ex});
                        }
                        UdpMatcher.this.reject(response, receiver);
                    }
                });
                return;
            }
            tempExchange = this.matchNotifyResponse(response);
            if (tempExchange == null) {
                if (response.getType() == CoAP.Type.ACK) {
                    LOGGER.trace("discarding by [{}] unmatchable piggy-backed response from [{}]: {}", new Object[]{idByToken, response.getSourceContext(), response});
                    this.cancel(response, receiver);
                } else {
                    LOGGER.trace("discarding by [{}] unmatchable response from [{}]: {}", new Object[]{idByToken, response.getSourceContext(), response});
                    this.reject(response, receiver);
                }
                return;
            }
        }
        final Exchange exchange = tempExchange;
        exchange.execute(new Runnable(){

            @Override
            public void run() {
                boolean checkResponseToken;
                boolean bl = checkResponseToken = !exchange.isNotification() || exchange.getRequest() != exchange.getCurrentRequest();
                if (checkResponseToken && UdpMatcher.this.exchangeStore.get(idByToken) != exchange) {
                    if (UdpMatcher.this.running) {
                        LOGGER.debug("ignoring response {}, exchange not longer matching!", (Object)response);
                    }
                    UdpMatcher.this.cancel(response, receiver);
                    return;
                }
                EndpointContext context = exchange.getEndpointContext();
                if (context == null) {
                    LOGGER.debug("ignoring response {}, request pending to sent!", (Object)response);
                    UdpMatcher.this.cancel(response, receiver);
                    return;
                }
                try {
                    if (UdpMatcher.this.endpointContextMatcher.isResponseRelatedToRequest(context, response.getSourceContext())) {
                        KeyMID idByMID;
                        Exchange prev;
                        CoAP.Type type = response.getType();
                        Request currentRequest = exchange.getCurrentRequest();
                        int requestMid = currentRequest.getMID();
                        if (currentRequest.isMulticast()) {
                            if (type != CoAP.Type.NON) {
                                LOGGER.debug("ignoring response of type {} for multicast request with token [{}], from {}", new Object[]{response.getType(), response.getTokenString(), response.getSourceContext().getPeerAddress()});
                                UdpMatcher.this.cancel(response, receiver);
                                return;
                            }
                        } else if (type == CoAP.Type.ACK && requestMid != response.getMID()) {
                            LOGGER.debug("ignoring ACK, possible MID reuse before lifetime end for token {}, expected MID {} but received {}", new Object[]{response.getTokenString(), requestMid, response.getMID()});
                            UdpMatcher.this.cancel(response, receiver);
                            return;
                        }
                        if (type != CoAP.Type.ACK && !exchange.isNotification() && response.isNotification() && currentRequest.isObserveCancel()) {
                            LOGGER.debug("ignoring notify for pending cancel {}!", (Object)response);
                            UdpMatcher.this.cancel(response, receiver);
                            return;
                        }
                        if ((type == CoAP.Type.CON || type == CoAP.Type.NON) && (prev = UdpMatcher.this.exchangeStore.findPrevious(idByMID = new KeyMID(response.getMID(), peer), exchange)) != null) {
                            LOGGER.trace("received duplicate response for open {}: {}", (Object)exchange, (Object)response);
                            response.setDuplicate(true);
                            Response prevResponse = prev.getCurrentResponse();
                            if (prevResponse != null) {
                                response.setRejected(prevResponse.isRejected());
                            }
                        }
                        receiver.receiveResponse(exchange, response);
                        return;
                    }
                    LOGGER.debug("ignoring potentially forged response for token {} with non-matching endpoint context", (Object)idByToken);
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("error receiving response {} for {}", new Object[]{response, exchange, ex});
                }
                UdpMatcher.this.reject(response, receiver);
            }
        });
    }

    @Override
    public void receiveEmptyMessage(final EmptyMessage message, final EndpointReceiver receiver) {
        final KeyMID idByMID = new KeyMID(message.getMID(), this.endpointContextMatcher.getEndpointIdentity(message.getSourceContext()));
        final Exchange exchange = this.exchangeStore.get(idByMID);
        if (exchange == null) {
            LOGGER.debug("ignoring {} message unmatchable by {}", (Object)message.getType(), (Object)idByMID);
            this.cancel(message, receiver);
            return;
        }
        exchange.execute(new Runnable(){

            @Override
            public void run() {
                if (exchange.getCurrentRequest().isMulticast()) {
                    LOGGER.debug("ignoring {} message for multicast request {}", (Object)message.getType(), (Object)idByMID);
                    UdpMatcher.this.cancel(message, receiver);
                    return;
                }
                if (UdpMatcher.this.exchangeStore.get(idByMID) != exchange) {
                    if (UdpMatcher.this.running) {
                        LOGGER.debug("ignoring {} message not longer matching by {}", (Object)message.getType(), (Object)idByMID);
                    }
                    UdpMatcher.this.cancel(message, receiver);
                    return;
                }
                try {
                    if (UdpMatcher.this.endpointContextMatcher.isResponseRelatedToRequest(exchange.getEndpointContext(), message.getSourceContext())) {
                        UdpMatcher.this.exchangeStore.remove(idByMID, exchange);
                        LOGGER.debug("received expected {} reply for {}", (Object)message.getType(), (Object)idByMID);
                        receiver.receiveEmptyMessage(exchange, message);
                        return;
                    }
                    LOGGER.debug("ignoring potentially forged {} reply for {} with non-matching endpoint context", (Object)message.getType(), (Object)idByMID);
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("error receiving {} message for {}", new Object[]{message.getType(), exchange, ex});
                }
                UdpMatcher.this.cancel(message, receiver);
            }
        });
    }

    private void reject(Response response, EndpointReceiver receiver) {
        if (response.getType() != CoAP.Type.ACK && response.hasMID()) {
            receiver.reject(response);
        }
        this.cancel(response, receiver);
    }

    private void cancel(Response response, EndpointReceiver receiver) {
        response.setCanceled(true);
        receiver.receiveResponse(null, response);
    }

    private void cancel(EmptyMessage message, EndpointReceiver receiver) {
        message.setCanceled(true);
        receiver.receiveEmptyMessage(null, message);
    }

    private class RemoveHandlerImpl
    implements RemoveHandler {
        private RemoveHandlerImpl() {
        }

        @Override
        public void remove(Exchange exchange, KeyToken keyToken, KeyMID keyMID) {
            if (keyToken != null) {
                UdpMatcher.this.exchangeStore.remove(keyToken, exchange);
            }
            if (keyMID != null) {
                UdpMatcher.this.exchangeStore.remove(keyMID, exchange);
            }
        }
    }
}

