/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferBackedInputStream
extends InputStream {
    protected final ByteBuffer _buffer;

    public ByteBufferBackedInputStream(ByteBuffer buf) {
        this._buffer = buf;
    }

    @Override
    public int available() {
        return this._buffer.remaining();
    }

    @Override
    public int read() throws IOException {
        return this._buffer.hasRemaining() ? this._buffer.get() & 0xFF : -1;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this._buffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this._buffer.remaining());
        this._buffer.get(bytes, off, len);
        return len;
    }
}

