/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SimpleArray_IntBuffer;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class ComplexArray_IntBuffer
extends AbstractArray {
    private final int[] dimv;
    private int totalSize;
    private IntBuffer data;
    private boolean directAllocation;
    private AbstractArray array;
    private int displacement;

    public ComplexArray_IntBuffer(int[] dimv) {
        this(dimv, false);
    }

    public ComplexArray_IntBuffer(int[] dimv, boolean directAllocation) {
        this.dimv = dimv;
        this.directAllocation = directAllocation;
        this.totalSize = ComplexArray_IntBuffer.computeTotalSize(dimv);
        if (directAllocation) {
            ByteBuffer b = ByteBuffer.allocateDirect(this.totalSize * 4);
            this.data = b.asIntBuffer();
        } else {
            this.data = IntBuffer.allocate(this.totalSize);
        }
    }

    public ComplexArray_IntBuffer(int[] dimv, LispObject initialContents) {
        this(dimv, initialContents, false);
    }

    public ComplexArray_IntBuffer(int[] dimv, LispObject initialContents, boolean directAllocation) {
        this.dimv = dimv;
        this.directAllocation = directAllocation;
        int rank = dimv.length;
        LispObject rest = initialContents;
        for (int i = 0; i < rank; ++i) {
            dimv[i] = rest.length();
            rest = rest.elt(0);
        }
        this.totalSize = ComplexArray_IntBuffer.computeTotalSize(dimv);
        if (directAllocation) {
            ByteBuffer b = ByteBuffer.allocateDirect(this.totalSize * 4);
            this.data = b.asIntBuffer();
        } else {
            this.data = IntBuffer.allocate(this.totalSize);
        }
        this.setInitialContents(0, dimv, initialContents, 0);
    }

    public ComplexArray_IntBuffer(int[] dimv, AbstractArray array, int displacement) {
        this(dimv, array, displacement, false);
    }

    public ComplexArray_IntBuffer(int[] dimv, AbstractArray array, int displacement, boolean directAllocation) {
        this.dimv = dimv;
        this.array = array;
        this.displacement = displacement;
        this.directAllocation = directAllocation;
        this.totalSize = ComplexArray_IntBuffer.computeTotalSize(dimv);
    }

    private int setInitialContents(int axis, int[] dims, LispObject contents, int index) {
        if (dims.length == 0) {
            try {
                this.data.put(index, (int)(contents.longValue() & 0xFFFFFFFFL));
            }
            catch (IndexOutOfBoundsException e) {
                Lisp.error(new LispError("Bad initial contents for array."));
                return -1;
            }
            ++index;
        } else {
            int i;
            int dim = dims[0];
            if (dim != contents.length()) {
                Lisp.error(new LispError("Bad initial contents for array."));
                return -1;
            }
            int[] newDims = new int[dims.length - 1];
            for (i = 1; i < dims.length; ++i) {
                newDims[i - 1] = dims[i];
            }
            if (contents.listp()) {
                i = contents.length();
                while (i-- > 0) {
                    LispObject content = contents.car();
                    index = this.setInitialContents(axis + 1, newDims, content, index);
                    contents = contents.cdr();
                }
            } else {
                AbstractVector v = Lisp.checkVector(contents);
                int length = v.length();
                for (int i2 = 0; i2 < length; ++i2) {
                    LispObject content = v.AREF(i2);
                    index = this.setInitialContents(axis + 1, newDims, content, index);
                }
            }
        }
        return index;
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.ARRAY, Lisp.UNSIGNED_BYTE_32, this.getDimensions());
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.ARRAY;
    }

    @Override
    public int getRank() {
        return this.dimv.length;
    }

    @Override
    public LispObject getDimensions() {
        LispObject result = Lisp.NIL;
        int i = this.dimv.length;
        while (i-- > 0) {
            result = new Cons(Fixnum.getInstance(this.dimv[i]), result);
        }
        return result;
    }

    @Override
    public int getDimension(int n) {
        try {
            return this.dimv[n];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Lisp.error(new TypeError("Bad array dimension " + n + "."));
            return -1;
        }
    }

    @Override
    public LispObject getElementType() {
        return Lisp.UNSIGNED_BYTE_32;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public LispObject arrayDisplacement() {
        Fixnum value2;
        LispObject value1;
        if (this.array != null) {
            value1 = this.array;
            value2 = Fixnum.getInstance(this.displacement);
        } else {
            value1 = Lisp.NIL;
            value2 = Fixnum.ZERO;
        }
        return LispThread.currentThread().setValues(value1, value2);
    }

    @Override
    public LispObject AREF(int index) {
        if (this.data != null) {
            try {
                return Lisp.number((long)this.data.get(index) & 0xFFFFFFFFL);
            }
            catch (IndexOutOfBoundsException e) {
                return Lisp.error(new TypeError("Bad row major index " + index + "."));
            }
        }
        return this.array.AREF(index + this.displacement);
    }

    @Override
    public void aset(int index, LispObject newValue) {
        if (this.data != null) {
            try {
                if (newValue.isLessThan(Fixnum.ZERO) || newValue.isGreaterThan(Lisp.UNSIGNED_BYTE_32_MAX_VALUE)) {
                    Lisp.type_error(newValue, Lisp.UNSIGNED_BYTE_32);
                }
                this.data.put(index, (int)(newValue.longValue() & 0xFFFFFFFFL));
            }
            catch (IndexOutOfBoundsException e) {
                Lisp.error(new TypeError("Bad row major index " + index + "."));
            }
        } else {
            this.array.aset(index + this.displacement, newValue);
        }
    }

    @Override
    public void fill(LispObject obj) {
        if (!(obj instanceof LispInteger)) {
            Lisp.type_error(obj, Symbol.INTEGER);
            return;
        }
        if (obj.isLessThan(Fixnum.ZERO) || obj.isGreaterThan(Lisp.UNSIGNED_BYTE_32_MAX_VALUE)) {
            Lisp.type_error(obj, Lisp.UNSIGNED_BYTE_32);
        }
        if (this.data != null) {
            int i = this.data.limit();
            while (i-- > 0) {
                this.data.put(i, (int)(obj.longValue() & 0xFFFFFFFFL));
            }
        } else {
            int i = this.totalSize;
            while (i-- > 0) {
                this.aset(i, obj);
            }
        }
    }

    @Override
    public String printObject() {
        return this.printObject(this.dimv);
    }

    @Override
    public AbstractArray adjustArray(int[] dims, LispObject initialElement, LispObject initialContents) {
        if (this.isAdjustable()) {
            if (initialContents != null) {
                this.setInitialContents(0, dims, initialContents, 0);
            } else {
                SimpleArray_IntBuffer tempArray = new SimpleArray_IntBuffer(dims);
                if (initialElement != null) {
                    tempArray.fill(initialElement);
                }
                SimpleArray_IntBuffer.copyArray(this, tempArray);
                this.data = tempArray.data;
                for (int i = 0; i < dims.length; ++i) {
                    this.dimv[i] = dims[i];
                }
            }
            return this;
        }
        if (initialContents != null) {
            return new ComplexArray_IntBuffer(dims, initialContents);
        }
        ComplexArray_IntBuffer newArray = new ComplexArray_IntBuffer(dims);
        if (initialElement != null) {
            newArray.fill(initialElement);
        }
        return newArray;
    }

    @Override
    public AbstractArray adjustArray(int[] dims, AbstractArray displacedTo, int displacement) {
        if (this.isAdjustable()) {
            for (int i = 0; i < dims.length; ++i) {
                this.dimv[i] = dims[i];
            }
            this.data = null;
            this.array = displacedTo;
            this.displacement = displacement;
            this.totalSize = ComplexArray_IntBuffer.computeTotalSize(dims);
            return this;
        }
        ComplexArray_IntBuffer a = new ComplexArray_IntBuffer(dims, displacedTo, displacement);
        return a;
    }
}

