# Example for the DelayedProgressPopup
#
# Start with:
#
#   y2start ./delayed_progress_2.rb qt
# or
#   y2start ./delayed_progress_2.rb ncurses
#

require "yast"
require "ui/delayed_progress_popup"

Yast::DelayedProgressPopup.run(delay: 2, heading: "Deep Think Mode") do |popup|
  # All those parameters are optional;
  # comment out or uncomment to experiment.
  # popup.heading = "Deep Think Mode"
  # popup.use_cancel_button = false

  puts("Nothing happens for #{popup.delay_seconds} seconds, then the popup opens.")

  10.times do |sec|
    puts "#{sec} sec"
    popup.progress(10 * sec, "Working #{sec}")
    if popup.open?
      # Checking for popup.open? is only needed here because otherwise there is
      # no window at all yet, so UI.WaitForEvent() throws an exception. Normal
      # applications have a main window at this point.

      event = Yast::UI.WaitForEvent(1000) # implicitly sleeps
      break if event["ID"] == :cancel
    else
      sleep(1)
    end
  end
end
