require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__LINUX_USB_RAW_GADGET_H)) {
    eval 'sub __LINUX_USB_RAW_GADGET_H () {1;}' unless defined(&__LINUX_USB_RAW_GADGET_H);
    require 'asm/ioctl.ph';
    require 'linux/types.ph';
    require 'linux/usb/ch9.ph';
    eval 'sub UDC_NAME_LENGTH_MAX () {128;}' unless defined(&UDC_NAME_LENGTH_MAX);
    eval("sub USB_RAW_EVENT_INVALID () { 0; }") unless defined(&USB_RAW_EVENT_INVALID);
    eval("sub USB_RAW_EVENT_CONNECT () { 1; }") unless defined(&USB_RAW_EVENT_CONNECT);
    eval("sub USB_RAW_EVENT_CONTROL () { 2; }") unless defined(&USB_RAW_EVENT_CONTROL);
    eval("sub USB_RAW_EVENT_SUSPEND () { 3; }") unless defined(&USB_RAW_EVENT_SUSPEND);
    eval("sub USB_RAW_EVENT_RESUME () { 4; }") unless defined(&USB_RAW_EVENT_RESUME);
    eval("sub USB_RAW_EVENT_RESET () { 5; }") unless defined(&USB_RAW_EVENT_RESET);
    eval("sub USB_RAW_EVENT_DISCONNECT () { 6; }") unless defined(&USB_RAW_EVENT_DISCONNECT);
    eval 'sub USB_RAW_IO_FLAGS_ZERO () {0x1;}' unless defined(&USB_RAW_IO_FLAGS_ZERO);
    eval 'sub USB_RAW_IO_FLAGS_MASK () {0x1;}' unless defined(&USB_RAW_IO_FLAGS_MASK);
    eval 'sub usb_raw_io_flags_valid {
        my($flags) = @_;
	    eval q({ ($flags & ~ &USB_RAW_IO_FLAGS_MASK) == 0; });
    }' unless defined(&usb_raw_io_flags_valid);
    eval 'sub usb_raw_io_flags_zero {
        my($flags) = @_;
	    eval q({ ($flags &  &USB_RAW_IO_FLAGS_ZERO); });
    }' unless defined(&usb_raw_io_flags_zero);
    eval 'sub USB_RAW_EPS_NUM_MAX () {30;}' unless defined(&USB_RAW_EPS_NUM_MAX);
    eval 'sub USB_RAW_EP_NAME_MAX () {16;}' unless defined(&USB_RAW_EP_NAME_MAX);
    eval 'sub USB_RAW_EP_ADDR_ANY () {0xff;}' unless defined(&USB_RAW_EP_ADDR_ANY);
    eval 'sub USB_RAW_IOCTL_INIT () { &_IOW(ord(\'U\'), 0, \'struct usb_raw_init\');}' unless defined(&USB_RAW_IOCTL_INIT);
    eval 'sub USB_RAW_IOCTL_RUN () { &_IO(ord(\'U\'), 1);}' unless defined(&USB_RAW_IOCTL_RUN);
    eval 'sub USB_RAW_IOCTL_EVENT_FETCH () { &_IOR(ord(\'U\'), 2, \'struct usb_raw_event\');}' unless defined(&USB_RAW_IOCTL_EVENT_FETCH);
    eval 'sub USB_RAW_IOCTL_EP0_WRITE () { &_IOW(ord(\'U\'), 3, \'struct usb_raw_ep_io\');}' unless defined(&USB_RAW_IOCTL_EP0_WRITE);
    eval 'sub USB_RAW_IOCTL_EP0_READ () { &_IOWR(ord(\'U\'), 4, \'struct usb_raw_ep_io\');}' unless defined(&USB_RAW_IOCTL_EP0_READ);
    eval 'sub USB_RAW_IOCTL_EP_ENABLE () { &_IOW(ord(\'U\'), 5, \'struct usb_endpoint_descriptor\');}' unless defined(&USB_RAW_IOCTL_EP_ENABLE);
    eval 'sub USB_RAW_IOCTL_EP_DISABLE () { &_IOW(ord(\'U\'), 6,  &__u32);}' unless defined(&USB_RAW_IOCTL_EP_DISABLE);
    eval 'sub USB_RAW_IOCTL_EP_WRITE () { &_IOW(ord(\'U\'), 7, \'struct usb_raw_ep_io\');}' unless defined(&USB_RAW_IOCTL_EP_WRITE);
    eval 'sub USB_RAW_IOCTL_EP_READ () { &_IOWR(ord(\'U\'), 8, \'struct usb_raw_ep_io\');}' unless defined(&USB_RAW_IOCTL_EP_READ);
    eval 'sub USB_RAW_IOCTL_CONFIGURE () { &_IO(ord(\'U\'), 9);}' unless defined(&USB_RAW_IOCTL_CONFIGURE);
    eval 'sub USB_RAW_IOCTL_VBUS_DRAW () { &_IOW(ord(\'U\'), 10,  &__u32);}' unless defined(&USB_RAW_IOCTL_VBUS_DRAW);
    eval 'sub USB_RAW_IOCTL_EPS_INFO () { &_IOR(ord(\'U\'), 11, \'struct usb_raw_eps_info\');}' unless defined(&USB_RAW_IOCTL_EPS_INFO);
    eval 'sub USB_RAW_IOCTL_EP0_STALL () { &_IO(ord(\'U\'), 12);}' unless defined(&USB_RAW_IOCTL_EP0_STALL);
    eval 'sub USB_RAW_IOCTL_EP_SET_HALT () { &_IOW(ord(\'U\'), 13,  &__u32);}' unless defined(&USB_RAW_IOCTL_EP_SET_HALT);
    eval 'sub USB_RAW_IOCTL_EP_CLEAR_HALT () { &_IOW(ord(\'U\'), 14,  &__u32);}' unless defined(&USB_RAW_IOCTL_EP_CLEAR_HALT);
    eval 'sub USB_RAW_IOCTL_EP_SET_WEDGE () { &_IOW(ord(\'U\'), 15,  &__u32);}' unless defined(&USB_RAW_IOCTL_EP_SET_WEDGE);
}
1;
