require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_FS_H)) {
    eval 'sub _LINUX_FS_H () {1;}' unless defined(&_LINUX_FS_H);
    require 'linux/limits.ph';
    require 'linux/ioctl.ph';
    require 'linux/types.ph';
    require 'linux/fscrypt.ph';
    require 'linux/mount.ph';
    undef(&NR_OPEN) if defined(&NR_OPEN);
    eval 'sub INR_OPEN_CUR () {1024;}' unless defined(&INR_OPEN_CUR);
    eval 'sub INR_OPEN_MAX () {4096;}' unless defined(&INR_OPEN_MAX);
    eval 'sub BLOCK_SIZE_BITS () {10;}' unless defined(&BLOCK_SIZE_BITS);
    eval 'sub BLOCK_SIZE () {(1<< &BLOCK_SIZE_BITS);}' unless defined(&BLOCK_SIZE);
    eval 'sub IO_INTEGRITY_CHK_GUARD () {(1 << 0);}' unless defined(&IO_INTEGRITY_CHK_GUARD);
    eval 'sub IO_INTEGRITY_CHK_REFTAG () {(1 << 1);}' unless defined(&IO_INTEGRITY_CHK_REFTAG);
    eval 'sub IO_INTEGRITY_CHK_APPTAG () {(1 << 2);}' unless defined(&IO_INTEGRITY_CHK_APPTAG);
    eval 'sub IO_INTEGRITY_VALID_FLAGS () {( &IO_INTEGRITY_CHK_GUARD |  &IO_INTEGRITY_CHK_REFTAG |  &IO_INTEGRITY_CHK_APPTAG);}' unless defined(&IO_INTEGRITY_VALID_FLAGS);
    eval 'sub SEEK_SET () {0;}' unless defined(&SEEK_SET);
    eval 'sub SEEK_CUR () {1;}' unless defined(&SEEK_CUR);
    eval 'sub SEEK_END () {2;}' unless defined(&SEEK_END);
    eval 'sub SEEK_DATA () {3;}' unless defined(&SEEK_DATA);
    eval 'sub SEEK_HOLE () {4;}' unless defined(&SEEK_HOLE);
    eval 'sub SEEK_MAX () { &SEEK_HOLE;}' unless defined(&SEEK_MAX);
    eval 'sub RENAME_NOREPLACE () {(1<< 0);}' unless defined(&RENAME_NOREPLACE);
    eval 'sub RENAME_EXCHANGE () {(1<< 1);}' unless defined(&RENAME_EXCHANGE);
    eval 'sub RENAME_WHITEOUT () {(1<< 2);}' unless defined(&RENAME_WHITEOUT);
    eval("sub PROCFS_ROOT_INO () { 1; }") unless defined(&PROCFS_ROOT_INO);
    eval 'sub LBMD_PI_CAP_INTEGRITY () {(1<< 0);}' unless defined(&LBMD_PI_CAP_INTEGRITY);
    eval 'sub LBMD_PI_CAP_REFTAG () {(1<< 1);}' unless defined(&LBMD_PI_CAP_REFTAG);
    eval 'sub LBMD_PI_CSUM_NONE () {0;}' unless defined(&LBMD_PI_CSUM_NONE);
    eval 'sub LBMD_PI_CSUM_IP () {1;}' unless defined(&LBMD_PI_CSUM_IP);
    eval 'sub LBMD_PI_CSUM_CRC16_T10DIF () {2;}' unless defined(&LBMD_PI_CSUM_CRC16_T10DIF);
    eval 'sub LBMD_PI_CSUM_CRC64_NVME () {4;}' unless defined(&LBMD_PI_CSUM_CRC64_NVME);
    eval 'sub LBMD_SIZE_VER0 () {16;}' unless defined(&LBMD_SIZE_VER0);
    eval 'sub FILE_DEDUPE_RANGE_SAME () {0;}' unless defined(&FILE_DEDUPE_RANGE_SAME);
    eval 'sub FILE_DEDUPE_RANGE_DIFFERS () {1;}' unless defined(&FILE_DEDUPE_RANGE_DIFFERS);
    eval 'sub NR_FILE () {8192;}' unless defined(&NR_FILE);
    eval 'sub FILE_ATTR_SIZE_VER0 () {24;}' unless defined(&FILE_ATTR_SIZE_VER0);
    eval 'sub FILE_ATTR_SIZE_LATEST () { &FILE_ATTR_SIZE_VER0;}' unless defined(&FILE_ATTR_SIZE_LATEST);
    eval 'sub FS_XFLAG_REALTIME () {0x1;}' unless defined(&FS_XFLAG_REALTIME);
    eval 'sub FS_XFLAG_PREALLOC () {0x2;}' unless defined(&FS_XFLAG_PREALLOC);
    eval 'sub FS_XFLAG_IMMUTABLE () {0x8;}' unless defined(&FS_XFLAG_IMMUTABLE);
    eval 'sub FS_XFLAG_APPEND () {0x10;}' unless defined(&FS_XFLAG_APPEND);
    eval 'sub FS_XFLAG_SYNC () {0x20;}' unless defined(&FS_XFLAG_SYNC);
    eval 'sub FS_XFLAG_NOATIME () {0x40;}' unless defined(&FS_XFLAG_NOATIME);
    eval 'sub FS_XFLAG_NODUMP () {0x80;}' unless defined(&FS_XFLAG_NODUMP);
    eval 'sub FS_XFLAG_RTINHERIT () {0x100;}' unless defined(&FS_XFLAG_RTINHERIT);
    eval 'sub FS_XFLAG_PROJINHERIT () {0x200;}' unless defined(&FS_XFLAG_PROJINHERIT);
    eval 'sub FS_XFLAG_NOSYMLINKS () {0x400;}' unless defined(&FS_XFLAG_NOSYMLINKS);
    eval 'sub FS_XFLAG_EXTSIZE () {0x800;}' unless defined(&FS_XFLAG_EXTSIZE);
    eval 'sub FS_XFLAG_EXTSZINHERIT () {0x1000;}' unless defined(&FS_XFLAG_EXTSZINHERIT);
    eval 'sub FS_XFLAG_NODEFRAG () {0x2000;}' unless defined(&FS_XFLAG_NODEFRAG);
    eval 'sub FS_XFLAG_FILESTREAM () {0x4000;}' unless defined(&FS_XFLAG_FILESTREAM);
    eval 'sub FS_XFLAG_DAX () {0x8000;}' unless defined(&FS_XFLAG_DAX);
    eval 'sub FS_XFLAG_COWEXTSIZE () {0x10000;}' unless defined(&FS_XFLAG_COWEXTSIZE);
    eval 'sub FS_XFLAG_HASATTR () {0x80000000;}' unless defined(&FS_XFLAG_HASATTR);
    eval 'sub BLKROSET () { &_IO(0x12,93);}' unless defined(&BLKROSET);
    eval 'sub BLKROGET () { &_IO(0x12,94);}' unless defined(&BLKROGET);
    eval 'sub BLKRRPART () { &_IO(0x12,95);}' unless defined(&BLKRRPART);
    eval 'sub BLKGETSIZE () { &_IO(0x12,96);}' unless defined(&BLKGETSIZE);
    eval 'sub BLKFLSBUF () { &_IO(0x12,97);}' unless defined(&BLKFLSBUF);
    eval 'sub BLKRASET () { &_IO(0x12,98);}' unless defined(&BLKRASET);
    eval 'sub BLKRAGET () { &_IO(0x12,99);}' unless defined(&BLKRAGET);
    eval 'sub BLKFRASET () { &_IO(0x12,100);}' unless defined(&BLKFRASET);
    eval 'sub BLKFRAGET () { &_IO(0x12,101);}' unless defined(&BLKFRAGET);
    eval 'sub BLKSECTSET () { &_IO(0x12,102);}' unless defined(&BLKSECTSET);
    eval 'sub BLKSECTGET () { &_IO(0x12,103);}' unless defined(&BLKSECTGET);
    eval 'sub BLKSSZGET () { &_IO(0x12,104);}' unless defined(&BLKSSZGET);
    if(0) {
	eval 'sub BLKPG () { &_IO(0x12,105);}' unless defined(&BLKPG);
	eval 'sub BLKELVGET () { &_IOR(0x12,106,\'size_t\');}' unless defined(&BLKELVGET);
	eval 'sub BLKELVSET () { &_IOW(0x12,107,\'size_t\');}' unless defined(&BLKELVSET);
    }
    eval 'sub BLKBSZGET () { &_IOR(0x12,112,\'size_t\');}' unless defined(&BLKBSZGET);
    eval 'sub BLKBSZSET () { &_IOW(0x12,113,\'size_t\');}' unless defined(&BLKBSZSET);
    eval 'sub BLKGETSIZE64 () { &_IOR(0x12,114,\'size_t\');}' unless defined(&BLKGETSIZE64);
    eval 'sub BLKTRACESETUP () { &_IOWR(0x12,115,\'struct blk_user_trace_setup\');}' unless defined(&BLKTRACESETUP);
    eval 'sub BLKTRACESTART () { &_IO(0x12,116);}' unless defined(&BLKTRACESTART);
    eval 'sub BLKTRACESTOP () { &_IO(0x12,117);}' unless defined(&BLKTRACESTOP);
    eval 'sub BLKTRACETEARDOWN () { &_IO(0x12,118);}' unless defined(&BLKTRACETEARDOWN);
    eval 'sub BLKDISCARD () { &_IO(0x12,119);}' unless defined(&BLKDISCARD);
    eval 'sub BLKIOMIN () { &_IO(0x12,120);}' unless defined(&BLKIOMIN);
    eval 'sub BLKIOOPT () { &_IO(0x12,121);}' unless defined(&BLKIOOPT);
    eval 'sub BLKALIGNOFF () { &_IO(0x12,122);}' unless defined(&BLKALIGNOFF);
    eval 'sub BLKPBSZGET () { &_IO(0x12,123);}' unless defined(&BLKPBSZGET);
    eval 'sub BLKDISCARDZEROES () { &_IO(0x12,124);}' unless defined(&BLKDISCARDZEROES);
    eval 'sub BLKSECDISCARD () { &_IO(0x12,125);}' unless defined(&BLKSECDISCARD);
    eval 'sub BLKROTATIONAL () { &_IO(0x12,126);}' unless defined(&BLKROTATIONAL);
    eval 'sub BLKZEROOUT () { &_IO(0x12,127);}' unless defined(&BLKZEROOUT);
    eval 'sub BLKGETDISKSEQ () { &_IOR(0x12,128, &__u64);}' unless defined(&BLKGETDISKSEQ);
    eval 'sub BMAP_IOCTL () {1;}' unless defined(&BMAP_IOCTL);
    eval 'sub FIBMAP () { &_IO(0x,1);}' unless defined(&FIBMAP);
    eval 'sub FIGETBSZ () { &_IO(0x,2);}' unless defined(&FIGETBSZ);
    eval 'sub FIFREEZE () { &_IOWR(ord(\'X\'), 119, \'int\');}' unless defined(&FIFREEZE);
    eval 'sub FITHAW () { &_IOWR(ord(\'X\'), 120, \'int\');}' unless defined(&FITHAW);
    eval 'sub FITRIM () { &_IOWR(ord(\'X\'), 121, \'struct fstrim_range\');}' unless defined(&FITRIM);
    eval 'sub FICLONE () { &_IOW(0x94, 9, \'int\');}' unless defined(&FICLONE);
    eval 'sub FICLONERANGE () { &_IOW(0x94, 13, \'struct file_clone_range\');}' unless defined(&FICLONERANGE);
    eval 'sub FIDEDUPERANGE () { &_IOWR(0x94, 54, \'struct file_dedupe_range\');}' unless defined(&FIDEDUPERANGE);
    eval 'sub FSLABEL_MAX () {256;}' unless defined(&FSLABEL_MAX);
    eval 'sub FS_IOC_GETFLAGS () { &_IOR(ord(\'f\'), 1, \'long\');}' unless defined(&FS_IOC_GETFLAGS);
    eval 'sub FS_IOC_SETFLAGS () { &_IOW(ord(\'f\'), 2, \'long\');}' unless defined(&FS_IOC_SETFLAGS);
    eval 'sub FS_IOC_GETVERSION () { &_IOR(ord(\'v\'), 1, \'long\');}' unless defined(&FS_IOC_GETVERSION);
    eval 'sub FS_IOC_SETVERSION () { &_IOW(ord(\'v\'), 2, \'long\');}' unless defined(&FS_IOC_SETVERSION);
    eval 'sub FS_IOC_FIEMAP () { &_IOWR(ord(\'f\'), 11, \'struct fiemap\');}' unless defined(&FS_IOC_FIEMAP);
    eval 'sub FS_IOC32_GETFLAGS () { &_IOR(ord(\'f\'), 1, \'int\');}' unless defined(&FS_IOC32_GETFLAGS);
    eval 'sub FS_IOC32_SETFLAGS () { &_IOW(ord(\'f\'), 2, \'int\');}' unless defined(&FS_IOC32_SETFLAGS);
    eval 'sub FS_IOC32_GETVERSION () { &_IOR(ord(\'v\'), 1, \'int\');}' unless defined(&FS_IOC32_GETVERSION);
    eval 'sub FS_IOC32_SETVERSION () { &_IOW(ord(\'v\'), 2, \'int\');}' unless defined(&FS_IOC32_SETVERSION);
    eval 'sub FS_IOC_FSGETXATTR () { &_IOR(ord(\'X\'), 31, \'struct fsxattr\');}' unless defined(&FS_IOC_FSGETXATTR);
    eval 'sub FS_IOC_FSSETXATTR () { &_IOW(ord(\'X\'), 32, \'struct fsxattr\');}' unless defined(&FS_IOC_FSSETXATTR);
    eval 'sub FS_IOC_GETFSLABEL () { &_IOR(0x94, 49, \'char\'[ &FSLABEL_MAX]);}' unless defined(&FS_IOC_GETFSLABEL);
    eval 'sub FS_IOC_SETFSLABEL () { &_IOW(0x94, 50, \'char\'[ &FSLABEL_MAX]);}' unless defined(&FS_IOC_SETFSLABEL);
    eval 'sub FS_IOC_GETFSUUID () { &_IOR(0x15, 0, \'struct fsuuid2\');}' unless defined(&FS_IOC_GETFSUUID);
    eval 'sub FS_IOC_GETFSSYSFSPATH () { &_IOR(0x15, 1, \'struct fs_sysfs_path\');}' unless defined(&FS_IOC_GETFSSYSFSPATH);
    eval 'sub FS_IOC_GETLBMD_CAP () { &_IOWR(0x15, 2, \'struct logical_block_metadata_cap\');}' unless defined(&FS_IOC_GETLBMD_CAP);
    eval 'sub FS_SECRM_FL () {0x1;}' unless defined(&FS_SECRM_FL);
    eval 'sub FS_UNRM_FL () {0x2;}' unless defined(&FS_UNRM_FL);
    eval 'sub FS_COMPR_FL () {0x4;}' unless defined(&FS_COMPR_FL);
    eval 'sub FS_SYNC_FL () {0x8;}' unless defined(&FS_SYNC_FL);
    eval 'sub FS_IMMUTABLE_FL () {0x10;}' unless defined(&FS_IMMUTABLE_FL);
    eval 'sub FS_APPEND_FL () {0x20;}' unless defined(&FS_APPEND_FL);
    eval 'sub FS_NODUMP_FL () {0x40;}' unless defined(&FS_NODUMP_FL);
    eval 'sub FS_NOATIME_FL () {0x80;}' unless defined(&FS_NOATIME_FL);
    eval 'sub FS_DIRTY_FL () {0x100;}' unless defined(&FS_DIRTY_FL);
    eval 'sub FS_COMPRBLK_FL () {0x200;}' unless defined(&FS_COMPRBLK_FL);
    eval 'sub FS_NOCOMP_FL () {0x400;}' unless defined(&FS_NOCOMP_FL);
    eval 'sub FS_ENCRYPT_FL () {0x800;}' unless defined(&FS_ENCRYPT_FL);
    eval 'sub FS_BTREE_FL () {0x1000;}' unless defined(&FS_BTREE_FL);
    eval 'sub FS_INDEX_FL () {0x1000;}' unless defined(&FS_INDEX_FL);
    eval 'sub FS_IMAGIC_FL () {0x2000;}' unless defined(&FS_IMAGIC_FL);
    eval 'sub FS_JOURNAL_DATA_FL () {0x4000;}' unless defined(&FS_JOURNAL_DATA_FL);
    eval 'sub FS_NOTAIL_FL () {0x8000;}' unless defined(&FS_NOTAIL_FL);
    eval 'sub FS_DIRSYNC_FL () {0x10000;}' unless defined(&FS_DIRSYNC_FL);
    eval 'sub FS_TOPDIR_FL () {0x20000;}' unless defined(&FS_TOPDIR_FL);
    eval 'sub FS_HUGE_FILE_FL () {0x40000;}' unless defined(&FS_HUGE_FILE_FL);
    eval 'sub FS_EXTENT_FL () {0x80000;}' unless defined(&FS_EXTENT_FL);
    eval 'sub FS_VERITY_FL () {0x100000;}' unless defined(&FS_VERITY_FL);
    eval 'sub FS_EA_INODE_FL () {0x200000;}' unless defined(&FS_EA_INODE_FL);
    eval 'sub FS_EOFBLOCKS_FL () {0x400000;}' unless defined(&FS_EOFBLOCKS_FL);
    eval 'sub FS_NOCOW_FL () {0x800000;}' unless defined(&FS_NOCOW_FL);
    eval 'sub FS_DAX_FL () {0x2000000;}' unless defined(&FS_DAX_FL);
    eval 'sub FS_INLINE_DATA_FL () {0x10000000;}' unless defined(&FS_INLINE_DATA_FL);
    eval 'sub FS_PROJINHERIT_FL () {0x20000000;}' unless defined(&FS_PROJINHERIT_FL);
    eval 'sub FS_CASEFOLD_FL () {0x40000000;}' unless defined(&FS_CASEFOLD_FL);
    eval 'sub FS_RESERVED_FL () {0x80000000;}' unless defined(&FS_RESERVED_FL);
    eval 'sub FS_FL_USER_VISIBLE () {0x3dfff;}' unless defined(&FS_FL_USER_VISIBLE);
    eval 'sub FS_FL_USER_MODIFIABLE () {0x380ff;}' unless defined(&FS_FL_USER_MODIFIABLE);
    eval 'sub SYNC_FILE_RANGE_WAIT_BEFORE () {1;}' unless defined(&SYNC_FILE_RANGE_WAIT_BEFORE);
    eval 'sub SYNC_FILE_RANGE_WRITE () {2;}' unless defined(&SYNC_FILE_RANGE_WRITE);
    eval 'sub SYNC_FILE_RANGE_WAIT_AFTER () {4;}' unless defined(&SYNC_FILE_RANGE_WAIT_AFTER);
    eval 'sub SYNC_FILE_RANGE_WRITE_AND_WAIT () {( &SYNC_FILE_RANGE_WRITE |  &SYNC_FILE_RANGE_WAIT_BEFORE |  &SYNC_FILE_RANGE_WAIT_AFTER);}' unless defined(&SYNC_FILE_RANGE_WRITE_AND_WAIT);
    eval 'sub RWF_HIPRI () {(( &__kernel_rwf_t)0x1);}' unless defined(&RWF_HIPRI);
    eval 'sub RWF_DSYNC () {(( &__kernel_rwf_t)0x2);}' unless defined(&RWF_DSYNC);
    eval 'sub RWF_SYNC () {(( &__kernel_rwf_t)0x4);}' unless defined(&RWF_SYNC);
    eval 'sub RWF_NOWAIT () {(( &__kernel_rwf_t)0x8);}' unless defined(&RWF_NOWAIT);
    eval 'sub RWF_APPEND () {(( &__kernel_rwf_t)0x10);}' unless defined(&RWF_APPEND);
    eval 'sub RWF_NOAPPEND () {(( &__kernel_rwf_t)0x20);}' unless defined(&RWF_NOAPPEND);
    eval 'sub RWF_ATOMIC () {(( &__kernel_rwf_t)0x40);}' unless defined(&RWF_ATOMIC);
    eval 'sub RWF_DONTCACHE () {(( &__kernel_rwf_t)0x80);}' unless defined(&RWF_DONTCACHE);
    eval 'sub RWF_SUPPORTED () {( &RWF_HIPRI |  &RWF_DSYNC |  &RWF_SYNC |  &RWF_NOWAIT |  &RWF_APPEND |  &RWF_NOAPPEND |  &RWF_ATOMIC |  &RWF_DONTCACHE);}' unless defined(&RWF_SUPPORTED);
    eval 'sub PROCFS_IOCTL_MAGIC () {ord(\'f\');}' unless defined(&PROCFS_IOCTL_MAGIC);
    eval 'sub PAGEMAP_SCAN () { &_IOWR( &PROCFS_IOCTL_MAGIC, 16, \'struct pm_scan_arg\');}' unless defined(&PAGEMAP_SCAN);
    eval 'sub PAGE_IS_WPALLOWED () {(1<< 0);}' unless defined(&PAGE_IS_WPALLOWED);
    eval 'sub PAGE_IS_WRITTEN () {(1<< 1);}' unless defined(&PAGE_IS_WRITTEN);
    eval 'sub PAGE_IS_FILE () {(1<< 2);}' unless defined(&PAGE_IS_FILE);
    eval 'sub PAGE_IS_PRESENT () {(1<< 3);}' unless defined(&PAGE_IS_PRESENT);
    eval 'sub PAGE_IS_SWAPPED () {(1<< 4);}' unless defined(&PAGE_IS_SWAPPED);
    eval 'sub PAGE_IS_PFNZERO () {(1<< 5);}' unless defined(&PAGE_IS_PFNZERO);
    eval 'sub PAGE_IS_HUGE () {(1<< 6);}' unless defined(&PAGE_IS_HUGE);
    eval 'sub PAGE_IS_SOFT_DIRTY () {(1<< 7);}' unless defined(&PAGE_IS_SOFT_DIRTY);
    eval 'sub PAGE_IS_GUARD () {(1<< 8);}' unless defined(&PAGE_IS_GUARD);
    eval 'sub PM_SCAN_WP_MATCHING () {(1<< 0);}' unless defined(&PM_SCAN_WP_MATCHING);
    eval 'sub PM_SCAN_CHECK_WPASYNC () {(1<< 1);}' unless defined(&PM_SCAN_CHECK_WPASYNC);
    eval 'sub PROCMAP_QUERY () { &_IOWR( &PROCFS_IOCTL_MAGIC, 17, \'struct procmap_query\');}' unless defined(&PROCMAP_QUERY);
    eval("sub PROCMAP_QUERY_VMA_READABLE () { 0x01; }") unless defined(&PROCMAP_QUERY_VMA_READABLE);
    eval("sub PROCMAP_QUERY_VMA_WRITABLE () { 0x02; }") unless defined(&PROCMAP_QUERY_VMA_WRITABLE);
    eval("sub PROCMAP_QUERY_VMA_EXECUTABLE () { 0x04; }") unless defined(&PROCMAP_QUERY_VMA_EXECUTABLE);
    eval("sub PROCMAP_QUERY_VMA_SHARED () { 0x08; }") unless defined(&PROCMAP_QUERY_VMA_SHARED);
    eval("sub PROCMAP_QUERY_COVERING_OR_NEXT_VMA () { 0x10; }") unless defined(&PROCMAP_QUERY_COVERING_OR_NEXT_VMA);
    eval("sub PROCMAP_QUERY_FILE_BACKED_VMA () { 0x20; }") unless defined(&PROCMAP_QUERY_FILE_BACKED_VMA);
}
1;
