/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.DefaultMutationGuard;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;

public class BuildOperationCrossProjectConfigurator
implements CrossProjectConfigurator {
    private final BuildOperationRunner buildOperationRunner;
    private final MutationGuard lazyGuard = new DefaultMutationGuard();
    private static final BuildOperationDescriptor.Builder ALLPROJECTS_DETAILS = BuildOperationCrossProjectConfigurator.computeConfigurationBlockBuildOperationDetails("allprojects");
    private static final BuildOperationDescriptor.Builder SUBPROJECTS_DETAILS = BuildOperationCrossProjectConfigurator.computeConfigurationBlockBuildOperationDetails("subprojects");
    private static final BuildOperationDescriptor.Builder ROOT_PROJECT_DETAILS = BuildOperationCrossProjectConfigurator.computeConfigurationBlockBuildOperationDetails("rootProject");

    public BuildOperationCrossProjectConfigurator(BuildOperationRunner buildOperationRunner) {
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public void project(ProjectInternal project, Action<? super Project> configureAction) {
        this.runProjectConfigureAction(project, configureAction);
    }

    @Override
    public void subprojects(Iterable<? extends ProjectInternal> projects, Action<? super Project> configureAction) {
        this.runBlockConfigureAction(SUBPROJECTS_DETAILS, projects, configureAction);
    }

    @Override
    public void allprojects(Iterable<? extends ProjectInternal> projects, Action<? super Project> configureAction) {
        this.runBlockConfigureAction(ALLPROJECTS_DETAILS, projects, configureAction);
    }

    @Override
    public void rootProject(ProjectInternal project, Action<? super Project> buildOperationRunner) {
        this.runBlockConfigureAction(ROOT_PROJECT_DETAILS, Collections.singleton(project), buildOperationRunner);
    }

    private void runBlockConfigureAction(BuildOperationDescriptor.Builder details, Iterable<? extends ProjectInternal> projects, Action<? super Project> configureAction) {
        this.buildOperationRunner.run((RunnableBuildOperation)new BlockConfigureBuildOperation(details, projects, configureAction));
    }

    private void runProjectConfigureAction(final ProjectInternal project, final Action<? super Project> configureAction) {
        project.getOwner().applyToMutableState(p -> this.buildOperationRunner.run((RunnableBuildOperation)new CrossConfigureProjectBuildOperation(project){

            public void run(BuildOperationContext context) {
                Actions.with((Object)project, BuildOperationCrossProjectConfigurator.this.lazyGuard.wrapEagerAction(configureAction));
            }
        }));
    }

    @Override
    public MutationGuard getLazyBehaviorGuard() {
        return this.lazyGuard;
    }

    private static BuildOperationDescriptor.Builder computeConfigurationBlockBuildOperationDetails(String configurationBlockName) {
        return BuildOperationDescriptor.displayName((String)("Execute '" + configurationBlockName + " {}' action")).name(configurationBlockName);
    }

    private class BlockConfigureBuildOperation
    implements RunnableBuildOperation {
        private final BuildOperationDescriptor.Builder details;
        private final Iterable<? extends ProjectInternal> projects;
        private final Action<? super Project> configureAction;

        private BlockConfigureBuildOperation(BuildOperationDescriptor.Builder details, Iterable<? extends ProjectInternal> projects, Action<? super Project> configureAction) {
            this.details = details;
            this.projects = projects;
            this.configureAction = configureAction;
        }

        public BuildOperationDescriptor.Builder description() {
            return this.details;
        }

        public void run(BuildOperationContext context) {
            for (ProjectInternal projectInternal : this.projects) {
                BuildOperationCrossProjectConfigurator.this.runProjectConfigureAction(projectInternal, (Action<? super Project>)this.configureAction);
            }
        }
    }

    private static abstract class CrossConfigureProjectBuildOperation
    implements RunnableBuildOperation {
        private final Project project;

        private CrossConfigureProjectBuildOperation(Project project) {
            this.project = project;
        }

        public BuildOperationDescriptor.Builder description() {
            String name = "Cross-configure project " + ((ProjectInternal)this.project).getIdentityPath();
            return BuildOperationDescriptor.displayName((String)name);
        }
    }
}

