# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.trust_management.principal_identities.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class WithCertificate(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.trust_management.principal_identities.with_certificate'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _WithCertificateStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               principal_identity_with_certificate,
               ):
        """
        Create a principal identity with a new, unused, certificate. The
        combination name and node_id needs to be unique across token-based and
        certificate-based principal identities.

        :type  principal_identity_with_certificate: :class:`com.vmware.nsx.model_client.PrincipalIdentityWithCertificate`
        :param principal_identity_with_certificate: (required)
        :rtype: :class:`com.vmware.nsx.model_client.PrincipalIdentity`
        :return: com.vmware.nsx.model.PrincipalIdentity
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'principal_identity_with_certificate': principal_identity_with_certificate,
                            })
class _WithCertificateStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'principal_identity_with_certificate': type.ReferenceType('com.vmware.nsx.model_client', 'PrincipalIdentityWithCertificate'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/trust-management/principal-identities/with-certificate',
            request_body_parameter='principal_identity_with_certificate',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'PrincipalIdentity'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.trust_management.principal_identities.with_certificate',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'WithCertificate': WithCertificate,
    }

