# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.notification_watchers.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Notifications(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.notification_watchers.notifications'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _NotificationsStub)
        self._VAPI_OPERATION_IDS = {}


    def addurifilters(self,
                      watcher_id,
                      notification,
                      ):
        """
        Add uri filters for the specified watcher ID.

        :type  watcher_id: :class:`str`
        :param watcher_id: (required)
        :type  notification: :class:`com.vmware.nsx.model_client.Notification`
        :param notification: (required)
        :rtype: :class:`com.vmware.nsx.model_client.NotificationsList`
        :return: com.vmware.nsx.model.NotificationsList
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('addurifilters',
                            {
                            'watcher_id': watcher_id,
                            'notification': notification,
                            })

    def deleteurifilters(self,
                         watcher_id,
                         notification,
                         ):
        """
        Delete uri filters for the specified watcher ID.

        :type  watcher_id: :class:`str`
        :param watcher_id: (required)
        :type  notification: :class:`com.vmware.nsx.model_client.Notification`
        :param notification: (required)
        :rtype: :class:`com.vmware.nsx.model_client.NotificationsList`
        :return: com.vmware.nsx.model.NotificationsList
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('deleteurifilters',
                            {
                            'watcher_id': watcher_id,
                            'notification': notification,
                            })

    def get(self,
            watcher_id,
            ):
        """
        Get notifications for the specified watcher ID.

        :type  watcher_id: :class:`str`
        :param watcher_id: (required)
        :rtype: :class:`com.vmware.nsx.model_client.NotificationsList`
        :return: com.vmware.nsx.model.NotificationsList
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'watcher_id': watcher_id,
                            })

    def update(self,
               watcher_id,
               notifications_list,
               ):
        """
        Update notifications for the specified watcher ID.

        :type  watcher_id: :class:`str`
        :param watcher_id: (required)
        :type  notifications_list: :class:`com.vmware.nsx.model_client.NotificationsList`
        :param notifications_list: (required)
        :rtype: :class:`com.vmware.nsx.model_client.NotificationsList`
        :return: com.vmware.nsx.model.NotificationsList
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'watcher_id': watcher_id,
                            'notifications_list': notifications_list,
                            })
class _NotificationsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for addurifilters operation
        addurifilters_input_type = type.StructType('operation-input', {
            'watcher_id': type.StringType(),
            'notification': type.ReferenceType('com.vmware.nsx.model_client', 'Notification'),
        })
        addurifilters_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        addurifilters_input_value_validator_list = [
        ]
        addurifilters_output_validator_list = [
        ]
        addurifilters_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/notification-watchers/{watcher-id}/notifications?action=add_uri_filters',
            request_body_parameter='notification',
            path_variables={
                'watcher_id': 'watcher-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for deleteurifilters operation
        deleteurifilters_input_type = type.StructType('operation-input', {
            'watcher_id': type.StringType(),
            'notification': type.ReferenceType('com.vmware.nsx.model_client', 'Notification'),
        })
        deleteurifilters_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        deleteurifilters_input_value_validator_list = [
        ]
        deleteurifilters_output_validator_list = [
        ]
        deleteurifilters_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/notification-watchers/{watcher-id}/notifications?action=delete_uri_filters',
            request_body_parameter='notification',
            path_variables={
                'watcher_id': 'watcher-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'watcher_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/notification-watchers/{watcher-id}/notifications',
            path_variables={
                'watcher_id': 'watcher-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'watcher_id': type.StringType(),
            'notifications_list': type.ReferenceType('com.vmware.nsx.model_client', 'NotificationsList'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/api/v1/notification-watchers/{watcher-id}/notifications',
            request_body_parameter='notifications_list',
            path_variables={
                'watcher_id': 'watcher-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'addurifilters': {
                'input_type': addurifilters_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NotificationsList'),
                'errors': addurifilters_error_dict,
                'input_value_validator_list': addurifilters_input_value_validator_list,
                'output_validator_list': addurifilters_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'deleteurifilters': {
                'input_type': deleteurifilters_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NotificationsList'),
                'errors': deleteurifilters_error_dict,
                'input_value_validator_list': deleteurifilters_input_value_validator_list,
                'output_validator_list': deleteurifilters_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NotificationsList'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NotificationsList'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'addurifilters': addurifilters_rest_metadata,
            'deleteurifilters': deleteurifilters_rest_metadata,
            'get': get_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.notification_watchers.notifications',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Notifications': Notifications,
    }

