/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class NotificationCategoryFactory {
    static final String ATTR_CATEGORY_NAME = "categoryName";
    static final String ATTR_BUNDLE_NAME = "localizingBundle";
    static final String ATTR_DISPLAY_NAME_KEY = "diplayNameKey";
    static final String ATTR_DESCRIPTION_KEY = "descriptionKey";
    private static final String CATEGORY_LIST_PATH = "Notification/Category";
    private static NotificationCategoryFactory theInstance;
    private Lookup.Result<NotificationDisplayer.Category> lookupRes;
    private Map<String, NotificationDisplayer.Category> name2category;
    private List<NotificationDisplayer.Category> categories;

    private NotificationCategoryFactory() {
    }

    static NotificationDisplayer.Category create(Map<String, String> map) {
        String string = map.get(ATTR_CATEGORY_NAME);
        String string2 = map.get(ATTR_BUNDLE_NAME);
        String string3 = map.get(ATTR_DISPLAY_NAME_KEY);
        String string4 = map.get(ATTR_DESCRIPTION_KEY);
        return NotificationCategoryFactory.create(string, string2, string3, string4);
    }

    static NotificationDisplayer.Category create(String string, String string2, String string3, String string4) {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)string2);
        String string5 = resourceBundle.getString(string3);
        String string6 = resourceBundle.getString(string4);
        return new NotificationDisplayer.Category(string, string5, string6);
    }

    public static NotificationCategoryFactory getInstance() {
        if (null == theInstance) {
            theInstance = new NotificationCategoryFactory();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NotificationDisplayer.Category getCategory(String string) {
        assert (null != string);
        NotificationCategoryFactory notificationCategoryFactory = this;
        synchronized (notificationCategoryFactory) {
            this.initCategories();
            return this.name2category.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<NotificationDisplayer.Category> getCategories() {
        NotificationCategoryFactory notificationCategoryFactory = this;
        synchronized (notificationCategoryFactory) {
            this.initCategories();
            return this.categories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCategories() {
        NotificationCategoryFactory notificationCategoryFactory = this;
        synchronized (notificationCategoryFactory) {
            if (null == this.name2category) {
                if (null == this.lookupRes) {
                    this.lookupRes = this.initLookup();
                    this.lookupRes.addLookupListener(new LookupListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resultChanged(LookupEvent lookupEvent) {
                            NotificationCategoryFactory notificationCategoryFactory = NotificationCategoryFactory.this;
                            synchronized (notificationCategoryFactory) {
                                NotificationCategoryFactory.this.name2category = null;
                                NotificationCategoryFactory.this.categories = null;
                            }
                        }
                    });
                }
                int n = 0;
                this.categories = new ArrayList<NotificationDisplayer.Category>(NotificationDisplayer.Category.getDefaultCategories());
                this.categories.addAll(this.lookupRes.allInstances());
                this.name2category = new HashMap<String, NotificationDisplayer.Category>(this.categories.size());
                for (NotificationDisplayer.Category category : this.categories) {
                    this.name2category.put(category.getName(), category);
                    category.setIndex(n++);
                }
            }
        }
    }

    private Lookup.Result<NotificationDisplayer.Category> initLookup() {
        Lookup lookup = Lookups.forPath((String)CATEGORY_LIST_PATH);
        Lookup.Template template = new Lookup.Template(NotificationDisplayer.Category.class);
        Lookup.Result result = lookup.lookup(template);
        return result;
    }
}

