/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.xy.synchronous;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.lib.charts.ChartComponent;
import org.graalvm.visualvm.lib.charts.ChartConfigurationListener;
import org.graalvm.visualvm.lib.charts.PaintersModel;
import org.graalvm.visualvm.lib.charts.Timeline;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYChartContext;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItemsModel;

public class SynchronousXYChart
extends ChartComponent {
    private static final int[] VISIBLE_NONE = new int[]{-1, -1};
    private final Timeline timeline;
    private int[] firstVisibleIndex;
    private int[] lastVisibleIndex;
    private Map<Rectangle, int[][]> indexesCache;
    private boolean visibleIndexesDirty;
    private boolean contentsWidthChanged;
    private int oldBoundsWidth;
    private int newBoundsWidth;
    private long oldOffsetX;
    private long newOffsetX;
    private double oldScaleX;
    private double newScaleX;

    private SynchronousXYChart() {
        throw new UnsupportedOperationException("new SynchronousXYChart() not supported");
    }

    public SynchronousXYChart(SynchronousXYItemsModel itemsModel, PaintersModel paintersModel) {
        this.timeline = itemsModel.getTimeline();
        this.indexesCache = new HashMap<Rectangle, int[][]>();
        this.firstVisibleIndex = VISIBLE_NONE;
        this.lastVisibleIndex = VISIBLE_NONE;
        this.visibleIndexesDirty = true;
        this.setItemsModel(itemsModel);
        this.setPaintersModel(paintersModel);
        this.addConfigurationListener(new VisibleBoundsListener());
    }

    @Override
    protected Context createChartContext() {
        return new Context(this);
    }

    private int[] findFirstVisibleL(int[] startIndex, int viewStart, int viewEnd) {
        if (startIndex == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        if (this.timeline.getTimestampsCount() == 0) {
            return VISIBLE_NONE;
        }
        int index = startIndex[0];
        if (index == -1) {
            index = startIndex[1];
        }
        double dataStart = this.getDataX(viewStart);
        while (index > 0 && (double)this.timeline.getTimestamp(index - 1) >= dataStart) {
            --index;
        }
        long timestamp = this.timeline.getTimestamp(index);
        if ((double)timestamp > this.getDataX(viewEnd)) {
            if (index == 0) {
                return VISIBLE_NONE;
            }
            return new int[]{-1, index - 1};
        }
        if ((double)timestamp >= dataStart) {
            return new int[]{index, -1};
        }
        return new int[]{-1, index};
    }

    private int[] findLastVisibleL(int[] startIndex, int viewStart, int viewEnd) {
        if (startIndex == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        if (this.timeline.getTimestampsCount() == 0) {
            return VISIBLE_NONE;
        }
        int index = startIndex[0];
        if (index == -1) {
            index = startIndex[1];
        }
        double dataEnd = this.getDataX(viewEnd);
        while (index > 0 && (double)this.timeline.getTimestamp(index - 1) > dataEnd) {
            --index;
        }
        long timestamp = this.timeline.getTimestamp(index);
        if ((double)timestamp > dataEnd) {
            if (index == 0 || (double)this.timeline.getTimestamp(index - 1) < this.getDataX(viewStart)) {
                return new int[]{-1, index};
            }
            return new int[]{index - 1, -1};
        }
        if ((double)timestamp >= this.getDataX(viewStart)) {
            return new int[]{index, -1};
        }
        return VISIBLE_NONE;
    }

    private int[] findFirstVisibleR(int[] startIndex, int viewStart, int viewEnd) {
        if (startIndex == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        int timestampsCount = this.timeline.getTimestampsCount();
        if (timestampsCount == 0) {
            return VISIBLE_NONE;
        }
        int index = startIndex[0];
        if (index == -1) {
            index = startIndex[1];
        }
        double dataStart = this.getDataX(viewStart);
        while (index < timestampsCount - 1 && (double)this.timeline.getTimestamp(index + 1) < dataStart) {
            ++index;
        }
        long timestamp = this.timeline.getTimestamp(index);
        if ((double)timestamp >= dataStart) {
            if ((double)timestamp > this.getDataX(viewEnd)) {
                return VISIBLE_NONE;
            }
            return new int[]{index, -1};
        }
        if (index == timestampsCount - 1 || (double)this.timeline.getTimestamp(index + 1) > this.getDataX(viewEnd)) {
            return new int[]{-1, index};
        }
        return new int[]{index + 1, -1};
    }

    private int[] findLastVisibleR(int[] startIndex, int viewStart, int viewEnd) {
        if (startIndex == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        int timestampsCount = this.timeline.getTimestampsCount();
        if (timestampsCount == 0) {
            return VISIBLE_NONE;
        }
        int index = startIndex[0];
        if (index == -1) {
            index = startIndex[1];
        }
        double dataEnd = this.getDataX(viewEnd);
        while (index < timestampsCount - 1 && (double)this.timeline.getTimestamp(index + 1) <= dataEnd) {
            ++index;
        }
        long timestamp = this.timeline.getTimestamp(index);
        if ((double)timestamp < this.getDataX(viewStart)) {
            if (index == timestampsCount - 1) {
                return VISIBLE_NONE;
            }
            return new int[]{-1, index + 1};
        }
        if ((double)timestamp > dataEnd) {
            return new int[]{-1, index};
        }
        return new int[]{index, -1};
    }

    private void recomputeVisibleBounds() {
        int timestampsCount = this.timeline.getTimestampsCount();
        if (timestampsCount == 0) {
            this.firstVisibleIndex = VISIBLE_NONE;
            this.lastVisibleIndex = VISIBLE_NONE;
        } else {
            this.firstVisibleIndex = new int[]{0, -1};
            this.lastVisibleIndex = new int[]{timestampsCount - 1, -1};
            if (!this.fitsWidth()) {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
            }
        }
    }

    @Override
    protected void reshaped(Rectangle oldBounds, Rectangle newBounds) {
        if (!this.fitsWidth() && oldBounds.width != newBounds.width) {
            this.visibleIndexesDirty = true;
            this.oldBoundsWidth = oldBounds.width;
            this.newBoundsWidth = newBounds.width;
        }
        super.reshaped(oldBounds, newBounds);
    }

    private void updateVisibleIndexes() {
        if (!this.visibleIndexesDirty) {
            return;
        }
        this.indexesCache.clear();
        if (this.fitsWidth()) {
            this.recomputeVisibleBounds();
        } else if (this.contentsWidthChanged) {
            this.recomputeVisibleBounds();
        } else if (this.firstVisibleIndex == VISIBLE_NONE) {
            this.recomputeVisibleBounds();
        } else if (this.oldBoundsWidth != this.newBoundsWidth) {
            if (this.oldBoundsWidth < this.newBoundsWidth) {
                this.firstVisibleIndex = this.findFirstVisibleL(this.firstVisibleIndex, 0, this.getWidth());
                if (this.currentlyFollowingDataWidth()) {
                    this.lastVisibleIndex[0] = this.timeline.getTimestampsCount() - 1;
                    this.lastVisibleIndex[1] = -1;
                } else {
                    this.lastVisibleIndex = this.findLastVisibleR(this.lastVisibleIndex, 0, this.getWidth());
                }
            } else {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                if (this.currentlyFollowingDataWidth()) {
                    this.lastVisibleIndex[0] = this.timeline.getTimestampsCount() - 1;
                    this.lastVisibleIndex[1] = -1;
                } else {
                    this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
                }
            }
        } else if (this.oldScaleX != this.newScaleX) {
            if (this.oldScaleX < this.newScaleX) {
                int[] firstVisibleI = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                if (firstVisibleI == VISIBLE_NONE) {
                    firstVisibleI = this.findFirstVisibleL(this.firstVisibleIndex, 0, this.getWidth());
                }
                this.firstVisibleIndex = firstVisibleI;
                int[] lastVisibleI = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
                if (lastVisibleI == VISIBLE_NONE) {
                    lastVisibleI = this.findLastVisibleR(this.lastVisibleIndex, 0, this.getWidth());
                }
                this.lastVisibleIndex = lastVisibleI;
            } else {
                this.firstVisibleIndex = this.findFirstVisibleL(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleR(this.lastVisibleIndex, 0, this.getWidth());
            }
        } else if (this.oldOffsetX != this.newOffsetX) {
            if (this.newOffsetX > this.oldOffsetX) {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleR(this.lastVisibleIndex, 0, this.getWidth());
            } else {
                this.firstVisibleIndex = this.findFirstVisibleL(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
            }
        }
        this.contentsWidthChanged = false;
        this.oldBoundsWidth = this.newBoundsWidth;
        this.oldScaleX = this.newScaleX;
        this.oldOffsetX = this.newOffsetX;
        this.visibleIndexesDirty = false;
    }

    private int[][] getVisibleBounds(Rectangle viewRect) {
        this.updateVisibleIndexes();
        if (this.fitsWidth() || viewRect.x == 0 && viewRect.width == this.getWidth()) {
            return new int[][]{this.firstVisibleIndex, this.lastVisibleIndex};
        }
        Rectangle rect = new Rectangle(viewRect.x, 0, viewRect.width, 0);
        Object bounds = this.indexesCache.get(rect);
        if (bounds == null) {
            int firstI = this.firstVisibleIndex[0];
            if (firstI == -1) {
                firstI = this.firstVisibleIndex[1];
            }
            int[] firstIndex = firstI == -1 ? VISIBLE_NONE : (this.getDataX(viewRect.x) > (double)this.timeline.getTimestamp(firstI) ? this.findFirstVisibleR(this.firstVisibleIndex, viewRect.x, viewRect.x + viewRect.width) : this.findFirstVisibleL(this.firstVisibleIndex, viewRect.x, viewRect.x + viewRect.width));
            int lastI = this.lastVisibleIndex[0];
            if (lastI == -1) {
                lastI = this.lastVisibleIndex[1];
            }
            int[] lastIndex = lastI == -1 ? VISIBLE_NONE : (this.getDataX(viewRect.x + viewRect.width) < (double)this.timeline.getTimestamp(lastI) ? this.findLastVisibleL(this.lastVisibleIndex, viewRect.x, viewRect.x + viewRect.width) : this.findLastVisibleR(this.lastVisibleIndex, viewRect.x, viewRect.x + viewRect.width));
            bounds = new int[][]{firstIndex, lastIndex};
            this.indexesCache.put(rect, (int[][])bounds);
        }
        return bounds;
    }

    public int getNearestTimestampIndex(int x, int y) {
        long distance;
        int timestampsCount = this.timeline.getTimestampsCount();
        if (timestampsCount == 0) {
            return -1;
        }
        if (timestampsCount == 1) {
            return 0;
        }
        long dataX = (long)this.getDataX(x);
        if (this.firstVisibleIndex == VISIBLE_NONE) {
            return -1;
        }
        int nearestIndex = this.firstVisibleIndex[0];
        if (nearestIndex == -1) {
            nearestIndex = this.firstVisibleIndex[1];
        }
        long itemDataX = this.timeline.getTimestamp(nearestIndex);
        long nearestDistance = Math.abs(dataX - itemDataX);
        int lastIndex = this.lastVisibleIndex[0];
        if (lastIndex == -1) {
            lastIndex = this.lastVisibleIndex[1];
        } else if (this.currentlyFollowingDataWidth()) {
            lastIndex = timestampsCount - 1;
        }
        while (nearestIndex + 1 <= lastIndex && (distance = Math.abs(dataX - (itemDataX = this.timeline.getTimestamp(nearestIndex + 1)))) < nearestDistance) {
            ++nearestIndex;
            nearestDistance = distance;
        }
        return nearestIndex;
    }

    protected static class Context
    extends ChartComponent.Context
    implements SynchronousXYChartContext {
        protected Context(SynchronousXYChart chart) {
            super(chart);
        }

        @Override
        protected SynchronousXYChart getChartComponent() {
            return (SynchronousXYChart)super.getChartComponent();
        }

        @Override
        public int[][] getVisibleBounds(Rectangle viewRect) {
            return this.getChartComponent().getVisibleBounds(viewRect);
        }

        @Override
        public int getNearestTimestampIndex(int x, int y) {
            return this.getChartComponent().getNearestTimestampIndex(x, y);
        }
    }

    private class VisibleBoundsListener
    extends ChartConfigurationListener.Adapter {
        private VisibleBoundsListener() {
        }

        @Override
        public void offsetChanged(long oldOffsetX, long oldOffsetY, long newOffsetX, long newOffsetY) {
            if (!SynchronousXYChart.this.fitsWidth() && oldOffsetX != newOffsetX) {
                SynchronousXYChart.this.visibleIndexesDirty = true;
                SynchronousXYChart.this.oldOffsetX = oldOffsetX;
                SynchronousXYChart.this.newOffsetX = newOffsetX;
            }
        }

        @Override
        public void dataBoundsChanged(long dataOffsetX, long dataOffsetY, long dataWidth, long dataHeight, long oldDataOffsetX, long oldDataOffsetY, long oldDataWidth, long oldDataHeight) {
            if (SynchronousXYChart.this.getContentsWidth() <= (long)SynchronousXYChart.this.getWidth()) {
                SynchronousXYChart.this.visibleIndexesDirty = true;
                SynchronousXYChart.this.contentsWidthChanged = true;
            }
        }

        @Override
        public void scaleChanged(double oldScaleX, double oldScaleY, double newScaleX, double newScaleY) {
            SynchronousXYChart.this.visibleIndexesDirty = true;
            if (!SynchronousXYChart.this.fitsWidth() && oldScaleX != newScaleX) {
                SynchronousXYChart.this.oldScaleX = oldScaleX;
                SynchronousXYChart.this.newScaleX = newScaleX;
            }
        }
    }
}

